/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute;

import org.eclipse.epsilon.commons.parse.AST;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.AbstractExecutor;
import org.eclipse.epsilon.eol.execute.context.IEolContext;

public class StringExecutor
extends AbstractExecutor {
    @Override
    public Object execute(AST ast, IEolContext context) throws EolRuntimeException {
        return this.unescape(ast.getText());
    }

    public String unescape(String str) {
        if (str == null) {
            return null;
        }
        int size = str.length();
        StringBuffer out = new StringBuffer();
        boolean slash = false;
        int i = 0;
        while (i < size) {
            char ch = str.charAt(i);
            if (slash) {
                slash = false;
                switch (ch) {
                    case '\\': {
                        out.append('\\');
                        break;
                    }
                    case '\'': {
                        out.append('\'');
                        break;
                    }
                    case '\"': {
                        out.append('\"');
                        break;
                    }
                    case 'r': {
                        out.append('\r');
                        break;
                    }
                    case 'f': {
                        out.append('\f');
                        break;
                    }
                    case 't': {
                        out.append('\t');
                        break;
                    }
                    case 'n': {
                        out.append('\n');
                        break;
                    }
                    case 'b': {
                        out.append('\b');
                        break;
                    }
                    default: {
                        out.append(ch);
                        break;
                    }
                }
            } else if (ch == '\\') {
                slash = true;
            } else {
                out.append(ch);
            }
            ++i;
        }
        if (slash) {
            out.append('\\');
        }
        return out.toString();
    }
}

