/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute;

import java.util.List;
import org.eclipse.epsilon.commons.parse.AST;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.AbstractExecutor;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.types.EolAnyType;
import org.eclipse.epsilon.eol.types.EolCollectionType;
import org.eclipse.epsilon.eol.types.EolPrimitiveType;
import org.eclipse.epsilon.eol.types.EolType;

public class VarStatementExecutor
extends AbstractExecutor {
    @Override
    public Object execute(AST ast, IEolContext context) throws EolRuntimeException {
        AST variableNameAst = ast.getFirstChild();
        AST variableTypeAst = variableNameAst.getNextSibling();
        AST parametersAst = null;
        if (variableTypeAst != null) {
            parametersAst = variableTypeAst.getNextSibling();
        }
        String variableName = variableNameAst.getText();
        Object newInstance = null;
        EolType variableType = null;
        variableType = variableTypeAst == null ? EolAnyType.Instance : (EolType)context.getExecutorFactory().executeAST(variableTypeAst, context);
        if (variableType instanceof EolPrimitiveType || variableType instanceof EolCollectionType) {
            newInstance = variableType.createInstance();
        } else if (ast.getText().equalsIgnoreCase("new")) {
            if (parametersAst != null) {
                List parameters = (List)context.getExecutorFactory().executeAST(parametersAst, context);
                newInstance = variableType.createInstance(parameters);
            } else {
                newInstance = variableType.createInstance();
            }
        }
        Variable variable = new Variable(variableName, newInstance, variableType);
        context.getFrameStack().put(variable);
        return variable;
    }
}

