/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.context;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.epsilon.commons.module.IModule;
import org.eclipse.epsilon.commons.parse.AST;
import org.eclipse.epsilon.commons.util.CollectionUtil;
import org.eclipse.epsilon.eol.execute.DeprecationInfo;
import org.eclipse.epsilon.eol.execute.ExecutorFactory;
import org.eclipse.epsilon.eol.execute.context.AsyncStatement;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.execute.introspection.IntrospectionManager;
import org.eclipse.epsilon.eol.execute.operations.OperationFactory;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributorRegistry;
import org.eclipse.epsilon.eol.execute.prettyprinting.PrettyPrinterManager;
import org.eclipse.epsilon.eol.models.ModelRepository;
import org.eclipse.epsilon.eol.types.EolClasspathNativeTypeDelegate;
import org.eclipse.epsilon.eol.types.IToolNativeTypeDelegate;
import org.eclipse.epsilon.eol.userinput.IUserInput;
import org.eclipse.epsilon.eol.userinput.JavaConsoleUserInput;

public class EolContext
implements IEolContext {
    protected IUserInput userInput = new JavaConsoleUserInput();
    protected FrameStack frameStack = new FrameStack();
    protected ModelRepository modelRepository = new ModelRepository();
    protected IntrospectionManager introspectionManager = new IntrospectionManager();
    protected ExecutorFactory executorFactory = new ExecutorFactory();
    protected OperationFactory operationFactory = new OperationFactory();
    protected PrettyPrinterManager prettyPrinterManager = new PrettyPrinterManager();
    protected PrintStream outputStream = System.out;
    protected PrintStream errorStream = System.err;
    protected IModule module = null;
    protected EolClasspathNativeTypeDelegate classpathNativeTypeDelegate = new EolClasspathNativeTypeDelegate();
    protected List<IToolNativeTypeDelegate> nativeTypeDelegates = new ArrayList<IToolNativeTypeDelegate>(CollectionUtil.asCollection((Object)this.classpathNativeTypeDelegate));
    protected boolean profilingEnabled = false;
    protected boolean assertionsEnabled = true;
    protected Map<Object, Map<String, Object>> extendedProperties = new IdentityHashMap<Object, Map<String, Object>>();
    protected List<AsyncStatement> asyncStatementsQueque = new ArrayList<AsyncStatement>();
    protected PrintStream warningStream = System.out;
    protected OperationContributorRegistry methodContributorRegistry = new OperationContributorRegistry();

    @Override
    public OperationContributorRegistry getOperationContributorRegistry() {
        return this.methodContributorRegistry;
    }

    @Override
    public PrintStream getWarningStream() {
        return this.warningStream;
    }

    @Override
    public void setWarningStream(PrintStream warningStream) {
        this.warningStream = warningStream;
    }

    @Override
    public boolean isAssertionsEnabled() {
        return this.assertionsEnabled;
    }

    @Override
    public void setAssertionsEnabled(boolean assertionsEnabled) {
        this.assertionsEnabled = assertionsEnabled;
    }

    @Override
    public PrettyPrinterManager getPrettyPrinterManager() {
        return this.prettyPrinterManager;
    }

    @Override
    public PrintStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void setOutputStream(PrintStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public OperationFactory getOperationFactory() {
        return this.operationFactory;
    }

    @Override
    public void setOperationFactory(OperationFactory operationFactory) {
        this.operationFactory = operationFactory;
    }

    @Override
    public ExecutorFactory getExecutorFactory() {
        return this.executorFactory;
    }

    @Override
    public void setExecutorFactory(ExecutorFactory executorFactory) {
        this.executorFactory = executorFactory;
    }

    @Override
    public ModelRepository getModelRepository() {
        return this.modelRepository;
    }

    @Override
    public void setModelRepository(ModelRepository modelRepository) {
        this.modelRepository = modelRepository;
    }

    @Override
    public FrameStack getFrameStack() {
        return this.frameStack;
    }

    @Override
    public void setFrameStack(FrameStack frameStack) {
        this.frameStack = frameStack;
    }

    @Override
    public IntrospectionManager getIntrospectionManager() {
        return this.introspectionManager;
    }

    @Override
    public void setIntrospectionManager(IntrospectionManager introspectionManager) {
        this.introspectionManager = introspectionManager;
    }

    @Override
    public PrintStream getErrorStream() {
        return this.errorStream;
    }

    @Override
    public void setErrorStream(PrintStream errorStream) {
        this.errorStream = errorStream;
    }

    @Override
    public void setModule(IModule module) {
        this.module = module;
    }

    @Override
    public IModule getModule() {
        return this.module;
    }

    @Override
    public void setUserInput(IUserInput userInput) {
        String userInputVarName = "UserInput";
        this.userInput = userInput;
        Variable var = this.frameStack.get(userInputVarName);
        if (var == null) {
            var = Variable.createReadOnlyVariable(userInputVarName, userInput);
            DeprecationInfo deprecationInfo = new DeprecationInfo();
            deprecationInfo.setMessage("Variable UserInput is deprecated. Use System.user instead.");
            var.setDeprecationInfo(deprecationInfo);
            this.frameStack.getGlobals().put(var);
        } else {
            var.setValueBruteForce(userInput);
        }
    }

    @Override
    public IUserInput getUserInput() {
        return this.userInput;
    }

    @Override
    public List<IToolNativeTypeDelegate> getNativeTypeDelegates() {
        return this.nativeTypeDelegates;
    }

    @Override
    public void setNativeTypeDelegates(List<IToolNativeTypeDelegate> nativeTypeDelegates) {
        this.nativeTypeDelegates = nativeTypeDelegates;
    }

    @Override
    public boolean isProfilingEnabled() {
        return this.profilingEnabled;
    }

    @Override
    public void setProfilingEnabled(boolean profilingEnabled) {
        this.profilingEnabled = profilingEnabled;
    }

    @Override
    public Map<Object, Map<String, Object>> getExtendedProperties() {
        return this.extendedProperties;
    }

    @Override
    public void setExtendedProperties(Map<Object, Map<String, Object>> extendedProperties) {
        this.extendedProperties = extendedProperties;
    }

    @Override
    public void dispose() {
        if (this.executorFactory.getExecutionController() != null) {
            this.executorFactory.getExecutionController().dispose();
        }
    }

    @Override
    public List<AsyncStatement> getAsyncStatementsQueque() {
        return this.asyncStatementsQueque;
    }

    public void enterProtectedFrame(AST ast, Variable ... variables) {
        this.getFrameStack().enter(FrameType.PROTECTED, ast);
        Variable[] variableArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableArray[n2];
            this.getFrameStack().put(variable);
            ++n2;
        }
    }

    public void leaveFrame(AST ast) {
        this.getFrameStack().leave(ast);
    }
}

