/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.context;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.epsilon.commons.parse.AST;
import org.eclipse.epsilon.commons.util.StringUtil;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.Variable;

public class Frame {
    private HashMap<String, Variable> storage = new HashMap();
    private FrameType type;
    private AST entryPoint;
    private String label;
    private AST currentStatement;

    public Frame(FrameType type, AST entryPoint) {
        this.type = type;
        this.entryPoint = entryPoint;
    }

    public Frame(FrameType type, AST entryPoint, String label) {
        this.type = type;
        this.entryPoint = entryPoint;
        this.label = label;
    }

    public void dispose() {
        for (Variable v : this.storage.values()) {
            v.dispose();
        }
        this.entryPoint = null;
    }

    public void clear() {
        this.storage.clear();
        this.currentStatement = null;
    }

    public Frame clone() {
        Frame clone = new Frame(this.type, this.entryPoint);
        clone.label = this.label;
        clone.currentStatement = this.currentStatement;
        for (Variable v : this.storage.values()) {
            clone.storage.put(v.name, v.clone());
        }
        return clone;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void put(String name, Object value) {
        this.put(Variable.createReadOnlyVariable(name, value));
    }

    public void put(Variable variable) {
        this.storage.put(variable.getName(), variable);
    }

    public void putAll(Map<String, Variable> variables) {
        this.storage.putAll(variables);
    }

    public Variable get(String key) {
        return this.storage.get(key);
    }

    public Map<String, Variable> getAll() {
        return this.storage;
    }

    public boolean contains(String key) {
        return this.storage.containsKey(key);
    }

    public FrameType getType() {
        return this.type;
    }

    public void setType(FrameType type) {
        this.type = type;
    }

    public AST getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(AST entryPoint) {
        this.entryPoint = entryPoint;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("------------" + this.type + "-------------\r\n");
        for (String key : this.storage.keySet()) {
            buffer.append(key + "     " + StringUtil.toString((Object)this.storage.get(key), (String)"null") + "\r\n");
        }
        return buffer.toString();
    }

    public void setCurrentStatement(AST ast) {
        this.currentStatement = ast;
    }

    public AST getCurrentStatement() {
        return this.currentStatement;
    }
}

