/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.epsilon.commons.parse.AST;
import org.eclipse.epsilon.eol.execute.context.Frame;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.Variable;

public class FrameStack {
    protected List<Frame> frames = new ArrayList<Frame>();
    protected Frame global = null;
    protected HashMap<String, Variable> builtInVariables = new HashMap();

    public FrameStack() {
        this.global = this.enter(FrameType.UNPROTECTED, null);
        this.builtInVariables.put("null", Variable.createReadOnlyVariable("null", null));
    }

    public void dispose() {
        for (Frame frame : this.frames) {
            frame.dispose();
        }
        this.global.dispose();
        this.frames.clear();
    }

    public Frame enter(FrameType type, AST entryPoint) {
        Frame frame = new Frame(type, entryPoint);
        this.frames.add(0, frame);
        return frame;
    }

    public void leave(AST entryPoint, boolean dispose) {
        if (this.frames.size() > 1) {
            Frame top = this.frames.get(0);
            while (top.getEntryPoint() != entryPoint) {
                this.frames.get(0).dispose();
                this.frames.remove(0);
                top = this.frames.get(0);
            }
            if (dispose) {
                this.frames.get(0).dispose();
            }
            this.frames.remove(0);
        }
    }

    public void leave(AST entryPoint) {
        this.leave(entryPoint, true);
    }

    public void put(Variable variable) {
        this.frames.get(0).put(variable);
    }

    public Variable get(String name) {
        if (this.builtInVariables.containsKey(name)) {
            return this.builtInVariables.get(name);
        }
        ListIterator<Frame> li = this.frames.listIterator();
        boolean protectedFrameFound = false;
        while (li.hasNext() && !protectedFrameFound) {
            Frame frame = li.next();
            if (frame.getType() == FrameType.PROTECTED) {
                protectedFrameFound = true;
            }
            if (!frame.contains(name)) continue;
            return frame.get(name);
        }
        return this.global.get(name);
    }

    public boolean isInLoop() {
        return this.getLoopDepth() > 0;
    }

    public int getLoopDepth() {
        int loopDepth = 0;
        ListIterator<Frame> li = this.frames.listIterator();
        boolean protectedFrameFound = false;
        while (li.hasNext() && !protectedFrameFound) {
            Frame frame = li.next();
            if (frame.getType() == FrameType.PROTECTED) {
                protectedFrameFound = true;
                continue;
            }
            if (!this.isLoopAst(frame.getEntryPoint())) continue;
            ++loopDepth;
        }
        return loopDepth;
    }

    protected boolean isLoopAst(AST ast) {
        return ast != null && (ast.getType() == 30 || ast.getType() == 33);
    }

    public boolean contains(String name) {
        return this.get(name) != null;
    }

    public Frame getGlobals() {
        return this.frames.get(this.frames.size() - 1);
    }

    public void printTrace() {
        for (Frame frame : this.frames) {
            if (frame.getType() != FrameType.PROTECTED) continue;
            System.out.println(String.valueOf(frame.getLabel()) + " (Line:" + frame.getEntryPoint().getLine() + " Column: " + frame.getEntryPoint().getColumn() + ")");
        }
        System.out.println("");
    }

    public List<Frame> getFrames() {
        return this.frames;
    }

    public int getDepth() {
        return this.frames.size();
    }

    public FrameStack clone() {
        FrameStack scope = new FrameStack();
        ArrayList<Frame> frames = new ArrayList<Frame>();
        assert (this.frames != null);
        for (Frame frame : this.frames) {
            if (frame == null) continue;
            frames.add(frame.clone());
        }
        scope.frames = frames;
        scope.global = this.global.clone();
        return scope;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("-----------SCOPE------------\r\n");
        for (Frame frame : this.frames) {
            buffer.append(frame.toString());
        }
        return buffer.toString();
    }

    public AST getCurrentStatement() {
        return this.frames.get(0).getCurrentStatement();
    }

    public void setCurrentStatement(AST ast) {
        this.frames.get(0).setCurrentStatement(ast);
    }
}

