/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.control;

import java.util.HashMap;
import org.eclipse.epsilon.commons.parse.AST;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.control.ExecutionController;

public class ExecutionProfiler
implements ExecutionController {
    protected HashMap profile = new HashMap();
    long previousTime = 0L;
    AST previousAst = null;

    @Override
    public void control(AST ast, IEolContext context) {
        long currentTime = 0L;
        if (this.previousAst != null) {
            Long timeSoFar = (Long)this.profile.get(this.previousAst);
            if (timeSoFar == null) {
                timeSoFar = new Long(0L);
            }
            currentTime = System.currentTimeMillis();
            timeSoFar = new Long(timeSoFar + currentTime - this.previousTime);
            this.profile.put(this.previousAst, timeSoFar);
        }
        this.previousTime = currentTime;
        this.previousAst = ast;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    public HashMap getProfile() {
        return this.profile;
    }

    @Override
    public void report(IEolContext context) {
        for (Object key : this.profile.keySet()) {
            context.getErrorStream().print(key);
            context.getErrorStream().print("-");
            context.getErrorStream().println(this.profile.get(key));
        }
    }

    @Override
    public void dispose() {
    }
}

