/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.introspection;

import java.util.ListIterator;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.introspection.ExtendedPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.ExtendedPropertySetter;
import org.eclipse.epsilon.eol.execute.introspection.IPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.IPropertySetter;
import org.eclipse.epsilon.eol.execute.introspection.java.JavaPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.java.JavaPropertySetter;
import org.eclipse.epsilon.eol.models.IModel;

public class IntrospectionManager {
    protected IPropertyGetter defaultPropertyGetter = new JavaPropertyGetter();
    protected IPropertySetter defaultPropertySetter = new JavaPropertySetter();

    public IPropertySetter getPropertySetterFor(Object object, String property, IEolContext context) {
        if (property.startsWith("~")) {
            ExtendedPropertySetter propertySetter = new ExtendedPropertySetter(context);
            propertySetter.setObject(object);
            propertySetter.setProperty(property.substring(1));
            propertySetter.setContext(context);
            return propertySetter;
        }
        ListIterator<IModel> li = context.getModelRepository().getModels().listIterator();
        while (li.hasNext()) {
            IModel model = li.next();
            if (!model.knowsAboutProperty(object, property)) continue;
            IPropertySetter ps = model.getPropertySetter();
            ps.setObject(object);
            ps.setProperty(property);
            ps.setContext(context);
            return ps;
        }
        this.defaultPropertySetter.setProperty(property);
        this.defaultPropertySetter.setObject(object);
        this.defaultPropertySetter.setContext(context);
        return this.defaultPropertySetter;
    }

    public IPropertyGetter getPropertyGetterFor(Object object, String property, IEolContext context) {
        if (property.startsWith("~")) {
            ExtendedPropertyGetter propertyGetter = new ExtendedPropertyGetter(context);
            propertyGetter.setContext(context);
            return propertyGetter;
        }
        for (IModel model : context.getModelRepository().getModels()) {
            if (!model.knowsAboutProperty(object, property)) continue;
            IPropertyGetter pg = model.getPropertyGetter();
            pg.setContext(context);
            return pg;
        }
        this.defaultPropertyGetter.setContext(context);
        return this.defaultPropertyGetter;
    }

    public IPropertyGetter getDefaultPropertyGetter() {
        return this.defaultPropertyGetter;
    }

    public void setDefaultPropertyGetter(IPropertyGetter defaultPropertyGetter) {
        this.defaultPropertyGetter = defaultPropertyGetter;
    }

    public IPropertySetter getDefaultPropertySetter() {
        return this.defaultPropertySetter;
    }

    public void setDefaultPropertySetter(IPropertySetter defaultPropertySetter) {
        this.defaultPropertySetter = defaultPropertySetter;
    }
}

