/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.contributors;

import org.eclipse.epsilon.eol.exceptions.EolAssertionException;
import org.eclipse.epsilon.eol.exceptions.EolInternalException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelNotFoundException;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;
import org.eclipse.epsilon.eol.models.IComparableModel;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.types.EolObjectComparator;

public class BasicEUnitOperationContributor
extends OperationContributor {
    @Override
    public boolean contributesTo(Object target) {
        return true;
    }

    public void assertTrue(boolean condition) throws EolAssertionException {
        this.assertTrue("Violated assertion", condition);
    }

    public void assertTrue(String message, boolean condition) throws EolAssertionException {
        this.compareBoolean(message, condition, true);
    }

    public void assertFalse(boolean condition) throws EolAssertionException {
        this.assertFalse("Violated assertion", condition);
    }

    public void assertFalse(String message, boolean condition) throws EolAssertionException {
        this.compareBoolean(message, condition, false);
    }

    public void assertEquals(Object expected, Object obtained) throws EolAssertionException {
        String sExpected = this.context.getPrettyPrinterManager().print(expected);
        String sObtained = this.context.getPrettyPrinterManager().print(obtained);
        String message = "Expected " + sExpected + ", but got " + sObtained + " instead";
        this.assertEquals(message, expected, obtained);
    }

    public void assertEquals(String message, Object expected, Object obtained) throws EolAssertionException {
        this.compareGeneric(message, expected, obtained, true);
    }

    public void assertEquals(Number expected, Number obtained, Number ulps) throws EolAssertionException {
        this.assertEquals(null, expected, obtained, ulps);
    }

    public void assertEquals(String message, Number expected, Number obtained, Number ulps) throws EolAssertionException {
        this.compareUlps(message, expected, obtained, ulps, true);
    }

    public void assertEqualModels(String expectedModelName, String obtainedModelName) throws EolModelNotFoundException, EolAssertionException, EolInternalException {
        this.assertEqualModels(null, expectedModelName, obtainedModelName);
    }

    public void assertEqualModels(String message, String expectedModelName, String obtainedModelName) throws EolModelNotFoundException, EolAssertionException, EolInternalException {
        this.compareModels(message, expectedModelName, obtainedModelName, true);
    }

    public void assertNotEquals(Object expected, Object obtained) throws EolAssertionException {
        this.assertNotEquals("Expected something different from " + expected + ", but got something equal to it", expected, obtained);
    }

    public void assertNotEquals(String message, Object expected, Object obtained) throws EolAssertionException {
        this.compareGeneric(message, expected, obtained, false);
    }

    public void assertNotEquals(Number expected, Number obtained, Number ulps) throws EolAssertionException {
        this.assertNotEquals(null, expected, obtained, ulps);
    }

    public void assertNotEquals(String message, Number expected, Number obtained, Number ulps) throws EolAssertionException {
        this.compareUlps(message, expected, obtained, ulps, false);
    }

    public void assertNotEqualModels(String expectedModelName, String obtainedModelName) throws EolModelNotFoundException, EolAssertionException, EolInternalException {
        this.assertNotEqualModels(null, expectedModelName, obtainedModelName);
    }

    public void assertNotEqualModels(String message, String expectedModelName, String obtainedModelName) throws EolModelNotFoundException, EolAssertionException, EolInternalException {
        this.compareModels(message, expectedModelName, obtainedModelName, false);
    }

    public void fail(String message) throws EolAssertionException {
        throw new EolAssertionException(message, this.context.getFrameStack().getCurrentStatement(), null, null, null);
    }

    private IComparableModel getComparableModel(String name) throws EolModelNotFoundException {
        IModel expectedModel = this.context.getModelRepository().getModelByName(name);
        if (!(expectedModel instanceof IComparableModel)) {
            throw new IllegalArgumentException(String.format("The model '%s' does not support comparison", name));
        }
        return (IComparableModel)expectedModel;
    }

    private void compareBoolean(String message, boolean condition, boolean expected) throws EolAssertionException {
        if (condition != expected) {
            throw new EolAssertionException(this.context.getPrettyPrinterManager().toString(message), this.context.getFrameStack().getCurrentStatement(), expected, condition, null);
        }
    }

    private void compareGeneric(String message, Object expected, Object obtained, boolean mustBeEqual) throws EolAssertionException {
        if (EolObjectComparator.equals(expected, obtained) != mustBeEqual) {
            throw new EolAssertionException(message, this.context.getFrameStack().getCurrentStatement(), expected, obtained, null);
        }
    }

    private void compareModels(String message, String expectedModelName, String actualModelName, boolean mustBeEqual) throws EolModelNotFoundException, EolAssertionException, EolInternalException {
        IComparableModel expectedCModel = this.getComparableModel(expectedModelName);
        IComparableModel actualCModel = this.getComparableModel(actualModelName);
        Object delta = null;
        boolean bExpectedEmpty = expectedCModel.allContents().isEmpty();
        boolean bActualEmpty = actualCModel.allContents().isEmpty();
        try {
            if (!bExpectedEmpty && !bActualEmpty) {
                delta = actualCModel.computeDifferencesWith(expectedCModel);
            } else if (bExpectedEmpty != bActualEmpty) {
                delta = "expected " + (bExpectedEmpty ? "is" : "is not") + " empty, actual " + (bActualEmpty ? "is" : "is not") + " empty";
            }
        }
        catch (Exception e) {
            throw new EolInternalException(e);
        }
        if (delta == null == mustBeEqual) {
            return;
        }
        if (message == null) {
            message = bExpectedEmpty ? "Expected " + actualModelName + (mustBeEqual ? " to be also" : " not to be") + " empty, but it is " + (bActualEmpty ? "empty" : "not") : "Expected " + actualModelName + " to be " + (mustBeEqual ? "equal" : "different") + " to " + expectedModelName + ", but it is " + (bActualEmpty ? "empty" : "not");
        }
        if (mustBeEqual) {
            throw new EolAssertionException(message.toString(), this.context.getFrameStack().getCurrentStatement(), expectedCModel, actualCModel, delta);
        }
        throw new EolAssertionException(message.toString(), this.context.getFrameStack().getCurrentStatement(), null, null, null);
    }

    private void compareUlps(String message, Number expected, Number obtained, Number ulps, boolean mustBeEqual) throws EolAssertionException {
        long intUlps = ulps.longValue();
        boolean bIsEqual = false;
        String upperBound = null;
        String lowerBound = null;
        if (expected instanceof Float) {
            float flExpected = expected.floatValue();
            float flActual = obtained.floatValue();
            float flMargin = (float)intUlps * Math.ulp(flExpected);
            bIsEqual = Math.abs(flActual - flExpected) <= flMargin;
            lowerBound = Float.toString(flExpected - flMargin);
            upperBound = Float.toString(flExpected + flMargin);
        } else {
            double dblExpected = expected.doubleValue();
            double dblActual = obtained.doubleValue();
            double dblMargin = (double)intUlps * Math.ulp(dblExpected);
            bIsEqual = Math.abs(dblActual - dblExpected) <= dblMargin;
            lowerBound = Double.toString(dblExpected - dblMargin);
            upperBound = Double.toString(dblExpected + dblMargin);
        }
        if (bIsEqual != mustBeEqual) {
            if (message == null) {
                message = "Expected " + expected + (mustBeEqual ? "not " : "") + "to be in [" + lowerBound + ", " + upperBound + "]";
            }
            throw new EolAssertionException(message, this.context.getFrameStack().getCurrentStatement(), expected, obtained, null);
        }
    }
}

