/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.contributors;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.epsilon.commons.util.CollectionUtil;
import org.eclipse.epsilon.commons.util.StringUtil;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;
import org.eclipse.epsilon.eol.types.EolBag;
import org.eclipse.epsilon.eol.types.EolCollectionType;
import org.eclipse.epsilon.eol.types.EolOrderedSet;
import org.eclipse.epsilon.eol.types.EolSequence;
import org.eclipse.epsilon.eol.types.EolSet;
import org.eclipse.epsilon.eol.types.NumberUtil;
import org.eclipse.epsilon.eol.types.ObjectUtil;

public class CollectionOperationContributor
extends OperationContributor {
    public CollectionOperationContributor() {
    }

    public CollectionOperationContributor(Collection target) {
        this.target = target;
    }

    protected Collection getCollection() {
        return (Collection)this.target;
    }

    protected boolean isList() {
        return this.target instanceof List;
    }

    protected List getList() {
        return (List)this.target;
    }

    protected boolean isSet() {
        return this.target instanceof Set;
    }

    protected Set getSet() {
        return (Set)this.target;
    }

    @Override
    public boolean contributesTo(Object target) {
        return target instanceof Collection;
    }

    public Object random() {
        int index = (int)Math.round(Math.random() * (double)this.getCollection().size() + 0.5);
        return this.nth(index - 1);
    }

    public Object at(int index) {
        if (this.isList()) {
            return this.getList().get(index);
        }
        Iterator it = this.getCollection().iterator();
        int i = 0;
        while (it.hasNext()) {
            Object next = it.next();
            if (i == index) {
                return next;
            }
            ++i;
        }
        return null;
    }

    public Object removeAt(int index) {
        if (this.target instanceof List) {
            return ((List)this.target).remove(index);
        }
        Object toRemove = new CollectionOperationContributor((Collection)this.target).at(index);
        ((Collection)this.target).remove(toRemove);
        return toRemove;
    }

    public List asSequence() {
        EolSequence copy = new EolSequence();
        this.copy(this.getCollection(), copy);
        return copy;
    }

    public EolSet asSet() {
        EolSet copy = new EolSet();
        this.copy(this.getCollection(), copy);
        return copy;
    }

    public EolBag asBag() {
        EolBag copy = new EolBag();
        this.copy(this.getCollection(), copy);
        return copy;
    }

    public EolOrderedSet asOrderedSet() {
        EolOrderedSet copy = new EolOrderedSet();
        this.copy(this.getCollection(), copy);
        return copy;
    }

    public Number sum() {
        Iterator it = this.getCollection().iterator();
        Number sum = 0;
        while (it.hasNext()) {
            Object next = it.next();
            if (!(next instanceof Number)) continue;
            sum = NumberUtil.add(sum, (Number)next);
        }
        return sum;
    }

    public Number product() {
        Iterator it = this.getCollection().iterator();
        if (this.isEmpty()) {
            return Float.valueOf(0.0f);
        }
        Number product = 1;
        while (it.hasNext()) {
            Object next = it.next();
            if (!(next instanceof Number)) continue;
            product = NumberUtil.multiply(product, (Number)next);
        }
        return product;
    }

    public boolean isEmpty() {
        return this.getCollection().size() == 0;
    }

    public boolean notEmpty() {
        return !this.isEmpty();
    }

    protected void copy(Collection source, Collection target) {
        Iterator it = source.iterator();
        while (it.hasNext()) {
            target.add(it.next());
        }
    }

    public Collection<Object> clone() {
        return EolCollectionType.clone(this.getCollection());
    }

    public boolean includes(Object o) {
        return this.getCollection().contains(o);
    }

    public boolean excludes(Object o) {
        return !this.includes(o);
    }

    public boolean includesAll(Collection col) {
        for (Object item : col) {
            if (this.includes(item)) continue;
            return false;
        }
        return true;
    }

    public boolean excludesAll(Collection col) {
        for (Object item : col) {
            if (!this.includes(item)) continue;
            return false;
        }
        return true;
    }

    public int count(Object o) {
        int count = 0;
        for (Object item : this.getCollection()) {
            if (!ObjectUtil.equals(item, o)) continue;
            ++count;
        }
        return count;
    }

    public Collection includingAll(Collection col) {
        Collection result = this.createCollection();
        result.addAll(this.getCollection());
        result.addAll(col);
        return result;
    }

    public Collection including(Object o) {
        Collection result = this.createCollection();
        result.addAll(this.getCollection());
        result.add(o);
        return result;
    }

    public Collection flatten() {
        return CollectionUtil.flatten((Collection)this.getCollection());
    }

    public Collection excluding(Object o) {
        Collection excluding = this.createCollection();
        excluding.addAll(this.getCollection());
        while (excluding.contains(o)) {
            excluding.remove(o);
        }
        return excluding;
    }

    public Collection excludingAll(Collection col) {
        Collection difference = this.createCollection();
        for (Object next : this.getCollection()) {
            if (col.contains(next)) continue;
            difference.add(next);
        }
        return difference;
    }

    public Object first() {
        return this.nth(0);
    }

    public Object second() {
        return this.nth(1);
    }

    public Object third() {
        return this.nth(2);
    }

    public Object fourth() {
        return this.nth(3);
    }

    public Object last() {
        return this.nth(this.getCollection().size() - 1);
    }

    public int indexOf(Object o) {
        if (this.isList()) {
            return this.getList().indexOf(o);
        }
        int counter = 0;
        for (Object item : this.getCollection()) {
            if (ObjectUtil.equals(item, o)) {
                return counter;
            }
            ++counter;
        }
        return -1;
    }

    private Object nth(int index) {
        if (this.isEmpty()) {
            return null;
        }
        return this.at(index);
    }

    public String concat() {
        return this.concat("");
    }

    public String concat(String delimiter) {
        return CollectionUtil.join((Collection)this.getCollection(), (String)delimiter, (CollectionUtil.ElementPrinter)new CollectionUtil.ElementPrinter(){

            public String print(Object element) {
                return StringUtil.toString((Object)element, (String)"");
            }
        });
    }

    public Number max() {
        return this.max(0);
    }

    public Number max(Number default_) {
        Number max = null;
        for (Object next : this.getCollection()) {
            if (!(next instanceof Number)) continue;
            Number nextNumber = (Number)next;
            if (max == null) {
                max = nextNumber;
                continue;
            }
            if (!NumberUtil.greaterThan(nextNumber, max)) continue;
            max = nextNumber;
        }
        if (max == null) {
            max = default_;
        }
        return max;
    }

    public Number min() {
        return this.min(0);
    }

    public Number min(Number default_) {
        Number min = null;
        for (Object next : this.getCollection()) {
            if (!(next instanceof Number)) continue;
            Number nextNumber = (Number)next;
            if (min == null) {
                min = nextNumber;
                continue;
            }
            if (!NumberUtil.lessThan(nextNumber, min)) continue;
            min = nextNumber;
        }
        if (min == null) {
            min = default_;
        }
        return min;
    }

    public Collection subset(int lower, int upper) {
        return null;
    }

    public Collection invert() {
        EolSequence sequence = new EolSequence();
        for (Object o : this.getCollection()) {
            sequence.add(0, o);
        }
        return sequence;
    }

    public Collection createCollection() {
        return EolCollectionType.createSameType(this.getCollection());
    }
}

