/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.contributors;

import java.io.FileOutputStream;
import java.util.List;
import org.eclipse.epsilon.commons.util.CollectionUtil;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;

public class StringOperationContributor
extends OperationContributor {
    @Override
    public boolean contributesTo(Object target) {
        return target instanceof String || target instanceof Character;
    }

    public Object toEnum() throws Exception {
        return this.context.getModelRepository().getEnumerationValue("" + this.target);
    }

    @Override
    public void setTarget(Object target) {
        if (target instanceof Character) {
            this.target = "" + target;
        } else {
            super.setTarget(target);
        }
    }

    public String firstToUpperCase() {
        String value = (String)this.target;
        return String.valueOf(value.substring(0, 1).toUpperCase()) + value.substring(1, value.length());
    }

    public String firstToLowerCase() {
        String value = (String)this.target;
        return String.valueOf(value.substring(0, 1).toLowerCase()) + value.substring(1, value.length());
    }

    public String ftuc() {
        return this.firstToUpperCase();
    }

    public String ftlc() {
        return this.firstToLowerCase();
    }

    public void store(String where) throws Exception {
        String value = (String)this.target;
        FileOutputStream fos = new FileOutputStream(where);
        fos.write(value.getBytes());
        fos.flush();
        fos.close();
    }

    public boolean isSubstringOf(String str) {
        String value = (String)this.target;
        return str == null ? false : str.indexOf(value) > -1;
    }

    public List toCharSequence() {
        String value = (String)this.target;
        List charSeq = CollectionUtil.createDefaultList();
        int i = 0;
        while (i < value.length()) {
            charSeq.add(String.valueOf(value.charAt(i)));
            ++i;
        }
        return charSeq;
    }

    public boolean isInteger() {
        String value = (String)this.target;
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isReal() {
        String value = (String)this.target;
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public float asReal() {
        String value = (String)this.target;
        return Float.parseFloat(value);
    }

    public double asDouble() {
        String value = (String)this.target;
        return Double.parseDouble(value);
    }

    public float asFloat() {
        String value = (String)this.target;
        return Float.parseFloat(value);
    }

    public int asInteger() {
        String value = (String)this.target;
        return Integer.parseInt(value);
    }

    public long asLong() {
        String value = (String)this.target;
        return Long.parseLong(value);
    }

    public boolean asBoolean() {
        String value = (String)this.target;
        return Boolean.parseBoolean(value);
    }

    public String asUnicode() {
        String value = (String)this.target;
        return "" + (char)Integer.parseInt(value, 16);
    }

    public String pad(int width, String padding, boolean right) {
        String result = (String)this.target;
        int pad = width - result.length();
        while (pad > 0) {
            result = right ? String.valueOf(result) + padding : String.valueOf(padding) + result;
            --pad;
        }
        return result;
    }
}

