/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.prettyprinting;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.epsilon.commons.util.StringUtil;
import org.eclipse.epsilon.eol.execute.prettyprinting.PrettyPrinter;
import org.eclipse.epsilon.eol.execute.prettyprinting.PrettyPrinterManager;
import org.eclipse.epsilon.eol.types.EolCollectionType;
import org.eclipse.epsilon.eol.types.EolMap;

public class DefaultPrettyPrinter
implements PrettyPrinter {
    PrettyPrinterManager manager = null;

    public DefaultPrettyPrinter(PrettyPrinterManager manager) {
        this.manager = manager;
    }

    @Override
    public boolean appliesTo(Object o) {
        return true;
    }

    @Override
    public String print(Object o) {
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            String result = String.valueOf(EolCollectionType.getTypeName(c)) + " {";
            Iterator li = c.iterator();
            PrettyPrinter prettyPrinter = null;
            while (li.hasNext()) {
                Object next = li.next();
                prettyPrinter = this.manager.getPrettyPrinterFor(next);
                result = String.valueOf(result) + prettyPrinter.print(next);
                if (!li.hasNext()) continue;
                result = String.valueOf(result) + ", ";
            }
            result = String.valueOf(result) + "}";
            return result;
        }
        if (o instanceof EolMap) {
            String simpleClassName = o.getClass().getSimpleName();
            String result = String.valueOf(simpleClassName.substring(3, simpleClassName.length())) + " {";
            Iterator li = ((EolMap)o).keySet().iterator();
            PrettyPrinter keyPrettyPrinter = null;
            PrettyPrinter valuePrettyPrinter = null;
            while (li.hasNext()) {
                Object key = li.next();
                Object value = ((EolMap)o).get(key);
                keyPrettyPrinter = this.manager.getPrettyPrinterFor(key);
                valuePrettyPrinter = this.manager.getPrettyPrinterFor(value);
                result = String.valueOf(result) + keyPrettyPrinter.print(key) + "->" + valuePrettyPrinter.print(value);
                if (!li.hasNext()) continue;
                result = String.valueOf(result) + ", ";
            }
            result = String.valueOf(result) + "}";
            return result;
        }
        return StringUtil.toString((Object)o);
    }
}

