/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;
import org.eclipse.epsilon.commons.util.StringProperties;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolEnumerationValueNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotInstantiableModelElementTypeException;
import org.eclipse.epsilon.eol.execute.introspection.AbstractPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.AbstractPropertySetter;
import org.eclipse.epsilon.eol.execute.introspection.IPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.IPropertySetter;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.Model;
import org.eclipse.epsilon.eol.models.ModelRepository;

public class ModelGroup
extends Model {
    protected ArrayList<IModel> models = new ArrayList();

    public ModelGroup(ModelRepository repository, String metaModel) throws EolModelNotFoundException {
        this.name = metaModel;
        for (IModel model : repository.getModels()) {
            if (!model.getAliases().contains(metaModel)) continue;
            this.models.add(model);
        }
        if (this.models.size() == 0) {
            throw new EolModelNotFoundException(metaModel);
        }
    }

    @Override
    public void load() throws EolModelLoadingException {
        for (IModel model : this.models) {
            model.load();
        }
    }

    public String getMetaModel() {
        return null;
    }

    @Override
    public Object getEnumerationValue(String enumeration, String label) throws EolEnumerationValueNotFoundException {
        return this.models.get(0).getEnumerationValue(enumeration, label);
    }

    public Collection getAllOfType(String metaClass) throws EolModelElementTypeNotFoundException {
        ArrayList allOfClass = new ArrayList();
        for (IModel model : this.models) {
            allOfClass.addAll(model.getAllOfType(metaClass));
        }
        return allOfClass;
    }

    public Collection getAllOfKind(String metaClass) throws EolModelElementTypeNotFoundException {
        ArrayList allOfType = new ArrayList();
        for (IModel model : this.models) {
            allOfType.addAll(model.getAllOfKind(metaClass));
        }
        return allOfType;
    }

    public Collection<Object> allContents() {
        ArrayList<Object> allContents = new ArrayList<Object>();
        for (IModel model : this.models) {
            allContents.addAll(model.allContents());
        }
        return allContents;
    }

    @Override
    public Object getTypeOf(Object instance) {
        for (IModel model : this.models) {
            if (!model.owns(instance)) continue;
            return model.getTypeOf(instance);
        }
        return null;
    }

    @Override
    public String getTypeNameOf(Object instance) {
        for (IModel model : this.models) {
            if (!model.isModelElement(instance)) continue;
            return model.getTypeNameOf(instance);
        }
        throw new IllegalArgumentException("No grouped model can contain: " + instance + " (" + instance.getClass().getCanonicalName() + ")");
    }

    @Override
    public Object createInstance(String metaClass) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        if (this.models.size() == 1) {
            return this.models.get(0).createInstance(metaClass);
        }
        throw new EolNotInstantiableModelElementTypeException(this.name, metaClass){

            @Override
            public String getReason() {
                return "Cannot create an instance of " + this.metaClass + " because model group " + ModelGroup.this.name + " has more than one models";
            }
        };
    }

    @Override
    public Object getElementById(String id) {
        ListIterator<IModel> li = this.models.listIterator();
        while (li.hasNext()) {
            IModel model = li.next();
            Object instance = model.getElementById(id);
            if (instance == null) continue;
            return instance;
        }
        return null;
    }

    @Override
    public String getElementId(Object instance) {
        ListIterator<IModel> li = this.models.listIterator();
        while (li.hasNext()) {
            IModel model = li.next();
            if (!model.owns(instance)) continue;
            return model.getElementId(instance);
        }
        return null;
    }

    @Override
    public void setElementId(Object instance, String newId) {
        ListIterator<IModel> li = this.models.listIterator();
        while (li.hasNext()) {
            IModel model = li.next();
            if (!model.owns(instance)) continue;
            model.setElementId(instance, newId);
        }
    }

    @Override
    public void deleteElement(Object instance) throws EolRuntimeException {
        ListIterator<IModel> li = this.models.listIterator();
        while (li.hasNext()) {
            IModel model = li.next();
            if (!model.owns(instance)) continue;
            model.deleteElement(instance);
        }
    }

    @Override
    public boolean owns(Object instance) {
        ListIterator<IModel> li = this.models.listIterator();
        while (li.hasNext()) {
            IModel model = li.next();
            if (!model.owns(instance)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean store(String fileName) {
        return false;
    }

    @Override
    public boolean store() {
        ListIterator<IModel> li = this.models.listIterator();
        while (li.hasNext()) {
            IModel model = li.next();
            model.store();
        }
        return true;
    }

    @Override
    public void dispose() {
        ListIterator<IModel> li = this.models.listIterator();
        while (li.hasNext()) {
            IModel model = li.next();
            model.dispose();
        }
    }

    @Override
    public boolean isInstantiable(String metaClass) {
        return this.models.get(0).isInstantiable(metaClass);
    }

    @Override
    public boolean hasType(String metaClass) {
        return this.models.get(0).hasType(metaClass);
    }

    @Override
    public void load(StringProperties properties, String basePath) throws EolModelLoadingException {
        this.load();
    }

    @Override
    public boolean isModelElement(Object instance) {
        ListIterator<IModel> li = this.models.listIterator();
        while (li.hasNext()) {
            IModel model = li.next();
            if (!model.isModelElement(instance)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IPropertyGetter getPropertyGetter() {
        return new DelegatingModelElementPropertyGetter();
    }

    @Override
    public IPropertySetter getPropertySetter() {
        return new DelegatingModelElementPropertySetter();
    }

    public class DelegatingModelElementPropertyGetter
    extends AbstractPropertyGetter {
        @Override
        public Object invoke(Object object, String property) throws EolRuntimeException {
            for (IModel model : ModelGroup.this.models) {
                if (!model.owns(object)) continue;
                return model.getPropertyGetter().invoke(object, property);
            }
            return null;
        }
    }

    public class DelegatingModelElementPropertySetter
    extends AbstractPropertySetter {
        IPropertySetter delegate = null;

        @Override
        public void setObject(Object object) {
            super.setObject(object);
            for (IModel model : ModelGroup.this.models) {
                if (!model.owns(object)) continue;
                this.delegate = model.getPropertySetter();
            }
        }

        @Override
        public void invoke(Object value) throws EolRuntimeException {
            this.delegate.invoke(value);
        }
    }
}

