/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.models.java;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.epsilon.commons.util.StringUtil;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolEnumerationValueNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotInstantiableModelElementTypeException;
import org.eclipse.epsilon.eol.models.Model;

public class JavaObjectModel
extends Model {
    protected Collection<Object> contents = new HashSet<Object>();
    protected List<String> importedPackages = new ArrayList<String>();

    public JavaObjectModel() {
    }

    JavaObjectModel(String ... importedPackages) {
        this.importedPackages = Arrays.asList(importedPackages);
    }

    public Collection<Object> allContents() {
        return this.contents;
    }

    public List<String> getImportedPackages() {
        return this.importedPackages;
    }

    @Override
    public Object createInstance(String type) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        Class clazz = this.classForName(type);
        try {
            Object instance = clazz.newInstance();
            this.contents.add(instance);
            return instance;
        }
        catch (Exception exception) {
            throw new EolNotInstantiableModelElementTypeException(this.name, type);
        }
    }

    public Class classForName(String type) throws EolModelElementTypeNotFoundException {
        Class clazz = null;
        clazz = this.getJavaClass(type);
        if (clazz == null) {
            for (String p : this.importedPackages) {
                clazz = this.getJavaClass(String.valueOf(p) + "." + type);
                if (clazz == null) continue;
                return clazz;
            }
        }
        throw new EolModelElementTypeNotFoundException(this.name, type);
    }

    protected Class getJavaClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void deleteElement(Object instance) throws EolRuntimeException {
        this.contents.remove(instance);
    }

    public Collection getAllOfKind(String type) throws EolModelElementTypeNotFoundException {
        Class clazz = this.classForName(type);
        ArrayList<Object> all = new ArrayList<Object>();
        for (Object o : this.contents) {
            try {
                o.getClass().asSubclass(clazz);
                all.add(o);
            }
            catch (Exception exception) {}
        }
        return all;
    }

    public Collection getAllOfType(String type) throws EolModelElementTypeNotFoundException {
        Class clazz = this.classForName(type);
        ArrayList<Object> all = new ArrayList<Object>();
        for (Object o : this.contents) {
            if (o.getClass() != clazz) continue;
            all.add(o);
        }
        return all;
    }

    @Override
    public Object getElementById(String id) {
        return null;
    }

    @Override
    public String getElementId(Object instance) {
        return String.valueOf(instance.hashCode());
    }

    @Override
    public void setElementId(Object instance, String newId) {
    }

    @Override
    public Object getEnumerationValue(String enumeration, String label) throws EolEnumerationValueNotFoundException {
        return null;
    }

    @Override
    public Object getTypeOf(Object instance) {
        return instance.getClass();
    }

    @Override
    public String getTypeNameOf(Object instance) {
        return instance.getClass().getCanonicalName();
    }

    @Override
    public boolean hasType(String type) {
        try {
            this.classForName(type);
            return true;
        }
        catch (EolModelElementTypeNotFoundException eolModelElementTypeNotFoundException) {
            return false;
        }
    }

    public Collection<String> getPropertiesOf(String type) throws EolModelElementTypeNotFoundException {
        Class clazz = this.classForName(type);
        if (clazz == null) {
            throw new EolModelElementTypeNotFoundException(this.name, type);
        }
        LinkedList<String> properties = new LinkedList<String>();
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().startsWith("set")) {
                properties.add(StringUtil.firstToLower((String)method.getName().substring(3)));
            } else if (method.getName().startsWith("is")) {
                properties.add(StringUtil.firstToLower((String)method.getName().substring(2)));
            } else if (method.getName().startsWith("get") && method.getReturnType().isAssignableFrom(Collection.class)) {
                properties.add(StringUtil.firstToLower((String)method.getName().substring(3)));
            }
            ++n2;
        }
        return properties;
    }

    @Override
    public boolean isInstantiable(String type) {
        return true;
    }

    @Override
    public boolean isModelElement(Object instance) {
        return true;
    }

    @Override
    public void load() throws EolModelLoadingException {
    }

    @Override
    public boolean owns(Object instance) {
        return this.contents.contains(instance);
    }

    @Override
    public boolean store(String location) {
        return false;
    }

    @Override
    public boolean store() {
        return false;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.contents.clear();
        this.importedPackages.clear();
    }
}

