/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.types;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import org.eclipse.epsilon.eol.exceptions.EolInternalException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.types.AbstractToolNativeTypeDelegate;

public class EolClasspathNativeTypeDelegate
extends AbstractToolNativeTypeDelegate {
    private ClassLoader fClassLoader;

    public EolClasspathNativeTypeDelegate() {
        this(EolClasspathNativeTypeDelegate.class.getClassLoader());
    }

    public EolClasspathNativeTypeDelegate(ClassLoader classLoader) {
        this.fClassLoader = classLoader;
    }

    @Override
    public boolean knowsAbout(String clazz) {
        try {
            this.fClassLoader.loadClass(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    @Override
    public Object createInstance(String clazz, List<Object> parameters) throws EolRuntimeException {
        try {
            Class<?> c = this.fClassLoader.loadClass(clazz);
            if (parameters.size() > 0) {
                Constructor<?> con = c.getConstructor(this.getTypes(parameters));
                return con.newInstance(parameters.toArray());
            }
            return c.newInstance();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new EolRuntimeException("Native type " + clazz + " does not define a suitable constructor for arguments " + parameters);
        }
        catch (Exception e) {
            throw new EolInternalException(e);
        }
    }

    public Class[] getTypes(Collection objects) {
        Class[] types = new Class[objects.size()];
        int i = 0;
        for (Object o : objects) {
            types[i] = o.getClass();
            ++i;
        }
        return types;
    }
}

