/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.types;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.epsilon.eol.exceptions.EolIllegalOperationParametersException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.types.CollectionAnnotator;
import org.eclipse.epsilon.eol.types.EolBag;
import org.eclipse.epsilon.eol.types.EolOrderedSet;
import org.eclipse.epsilon.eol.types.EolSequence;
import org.eclipse.epsilon.eol.types.EolSet;
import org.eclipse.epsilon.eol.types.EolType;

public class EolCollectionType
extends EolType {
    private String name;
    public static EolCollectionType Collection = new EolCollectionType("Collection");
    public static EolCollectionType Bag = new EolCollectionType("Bag");
    public static EolCollectionType Sequence = new EolCollectionType("Sequence");
    public static EolCollectionType Set = new EolCollectionType("Set");
    public static EolCollectionType OrderedSet = new EolCollectionType("OrderedSet");

    private EolCollectionType(String name) {
        this.name = name;
    }

    public EolCollectionType getTypeOf(Collection c) {
        CollectionAnnotator.AnnotatedCollectionType annotatedCollectionType = CollectionAnnotator.getInstance().getType(c);
        if (annotatedCollectionType != null) {
            if (annotatedCollectionType == CollectionAnnotator.AnnotatedCollectionType.Bag) {
                return Bag;
            }
            if (annotatedCollectionType == CollectionAnnotator.AnnotatedCollectionType.Sequence) {
                return Sequence;
            }
            if (annotatedCollectionType == CollectionAnnotator.AnnotatedCollectionType.Set) {
                return Set;
            }
            if (annotatedCollectionType == CollectionAnnotator.AnnotatedCollectionType.OrderedSet) {
                return OrderedSet;
            }
        }
        if (c instanceof EolSequence || c instanceof List && !(c instanceof Set)) {
            return Sequence;
        }
        if (c instanceof EolOrderedSet || c instanceof List && c instanceof Set) {
            return OrderedSet;
        }
        if (c instanceof EolSet || c instanceof Set && !(c instanceof List)) {
            return Set;
        }
        return Bag;
    }

    @Override
    public boolean isType(Object o) {
        if (!(o instanceof Collection)) {
            return false;
        }
        Collection c = (Collection)o;
        if (this == Collection) {
            return false;
        }
        return this.getTypeOf(c) == this;
    }

    @Override
    public boolean isKind(Object o) {
        if (!(o instanceof Collection)) {
            return false;
        }
        if (this == Collection) {
            return true;
        }
        if (this == Bag) {
            return Bag.isType(o) || Sequence.isType(o);
        }
        if (this == Sequence) {
            return Sequence.isType(o);
        }
        if (this == OrderedSet) {
            return OrderedSet.isType(o);
        }
        if (this == Set) {
            return Set.isType(o) || OrderedSet.isType(o);
        }
        return false;
    }

    @Override
    public Object createInstance() {
        block6: {
            try {
                if (this != Collection) break block6;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        if (this == Bag) {
            return new EolBag();
        }
        if (this == Sequence) {
            return new EolSequence();
        }
        if (this == OrderedSet) {
            return new EolOrderedSet();
        }
        return new EolSet();
    }

    @Override
    public Object createInstance(List<Object> parameters) throws EolRuntimeException {
        throw new EolIllegalOperationParametersException("createInstance");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static String getTypeName(Collection c) {
        if (Bag.isType(c)) {
            return Bag.getName();
        }
        if (Sequence.isType(c)) {
            return Sequence.getName();
        }
        if (OrderedSet.isType(c)) {
            return OrderedSet.getName();
        }
        if (Set.isType(c)) {
            return Set.getName();
        }
        return c.getClass().getSimpleName();
    }

    public static Collection createSameType(Collection c) {
        if (Bag.isType(c)) {
            return new EolBag();
        }
        if (Sequence.isType(c)) {
            return new EolSequence();
        }
        if (OrderedSet.isType(c)) {
            return new EolOrderedSet();
        }
        if (Set.isType(c)) {
            return new EolSet();
        }
        return null;
    }

    public static Collection clone(Collection c) {
        Collection clone = EolCollectionType.createSameType(c);
        clone.addAll(c);
        return clone;
    }

    public static Collection join(Collection c1, Collection c2) {
        Collection joined = EolCollectionType.createSameType(c1);
        joined.addAll(c1);
        joined.addAll(c2);
        return joined;
    }

    public static boolean isUnique(Collection c) {
        return Set.isType(c) || OrderedSet.isType(c);
    }

    public static boolean isOrdered(Collection c) {
        return Sequence.isType(c) || OrderedSet.isType(c);
    }
}

