/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.types;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.epsilon.commons.parse.AST;
import org.eclipse.epsilon.commons.util.CollectionUtil;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelNotFoundException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.ModelRepository;
import org.eclipse.epsilon.eol.types.EolType;

public class EolModelElementType
extends EolType {
    protected String modelName = "";
    protected String typeName = "";
    protected IModel model;

    public static EolModelElementType forName(String modelAndMetaClass, IEolContext context) throws EolModelElementTypeNotFoundException, EolModelNotFoundException {
        EolModelElementType type = null;
        type = new EolModelElementType(modelAndMetaClass, context);
        return type;
    }

    private EolModelElementType(String modelAndMetaClass, IEolContext context) throws EolModelNotFoundException, EolModelElementTypeNotFoundException {
        if (modelAndMetaClass.indexOf("!") > -1) {
            String[] parts = modelAndMetaClass.split("!");
            this.modelName = parts[0];
            this.typeName = parts[1];
        } else {
            this.modelName = "";
            this.typeName = modelAndMetaClass;
        }
        this.checkAmbiguityOfType(context);
        this.model = context.getModelRepository().getModelByName(this.modelName);
        if (this.model == null || !this.model.hasType(this.typeName)) {
            throw new EolModelElementTypeNotFoundException(this.modelName, this.typeName);
        }
    }

    private void checkAmbiguityOfType(IEolContext context) {
        ModelRepository.AmbiguityCheckResult result = context.getModelRepository().checkAmbiguity(this.typeName);
        if (this.modelName.isEmpty() && result.isAmbiguous) {
            this.issueAmbiguousTypeWarning(context, result);
        }
    }

    private void issueAmbiguousTypeWarning(IEolContext context, ModelRepository.AmbiguityCheckResult result) {
        String potentialTypes = CollectionUtil.join(result.namesOfOwningModels, (String)" ", (CollectionUtil.ElementPrinter)new CollectionUtil.ElementPrinter(){

            public String print(Object element) {
                return "'" + element + "!" + EolModelElementType.this.typeName + "'";
            }
        });
        context.getWarningStream().println("Warning: The type '" + this.typeName + "' " + "is ambiguous and could refer to any of the following: " + potentialTypes + ". " + "The type '" + result.nameOfSelectedModel + "!" + this.typeName + "' has been assumed. " + this.determineLocation(context.getFrameStack().getCurrentStatement()));
    }

    private String determineLocation(AST statement) {
        if (statement == null) {
            return "";
        }
        return "(" + statement.getFile() + "@" + statement.getLine() + ":" + statement.getColumn() + ")";
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String model) {
        this.modelName = model;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String type) {
        this.typeName = type;
    }

    public Collection<?> getAllOfKind() {
        try {
            return this.model.getAllOfKind(this.typeName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.EMPTY_LIST;
        }
    }

    public Collection<?> getAllOfType() {
        try {
            return this.model.getAllOfType(this.typeName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.EMPTY_LIST;
        }
    }

    public Collection<?> getAll() {
        return this.getAllOfKind();
    }

    public Collection<?> all() {
        return this.getAllOfKind();
    }

    public Collection<?> getAllInstances() {
        return this.getAllOfKind();
    }

    public Collection<?> allInstances() {
        return this.getAllOfKind();
    }

    public boolean isInstantiable() {
        return this.model.isInstantiable(this.typeName);
    }

    @Override
    public boolean isType(Object o) {
        try {
            return this.model.isOfType(o, this.typeName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public Object createInstance() throws EolRuntimeException {
        return this.model.createInstance(this.typeName);
    }

    @Override
    public Object createInstance(List<Object> parameters) throws EolRuntimeException {
        return this.model.createInstance(this.typeName, parameters);
    }

    @Override
    public boolean isKind(Object o) {
        try {
            return this.model.isOfKind(o, this.typeName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public String getName() {
        String name = "";
        if (this.modelName.length() > 0) {
            name = String.valueOf(this.modelName) + "!";
        }
        return String.valueOf(name) + this.typeName;
    }
}

