/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.types;

import java.util.Collections;
import java.util.List;
import org.eclipse.epsilon.commons.parse.AST;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.EolTypeNotFoundException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.types.EolAnyType;
import org.eclipse.epsilon.eol.types.IToolNativeTypeDelegate;

public class EolNativeType
extends EolAnyType {
    protected IEolContext context;
    protected String clazz;
    protected IToolNativeTypeDelegate delegate;

    public EolNativeType(AST classAst, IEolContext context) throws EolTypeNotFoundException {
        for (IToolNativeTypeDelegate delegate : context.getNativeTypeDelegates()) {
            if (!delegate.knowsAbout(classAst.getText())) continue;
            this.clazz = classAst.getText();
            this.delegate = delegate;
            this.context = context;
            return;
        }
        throw new EolTypeNotFoundException(classAst.getText(), classAst);
    }

    @Override
    public Object createInstance() throws EolRuntimeException {
        return this.delegate.createInstance(this.clazz, Collections.EMPTY_LIST, this.context);
    }

    @Override
    public Object createInstance(List<Object> parameters) throws EolRuntimeException {
        return this.delegate.createInstance(this.clazz, parameters, this.context);
    }

    public Class getJavaClass() {
        try {
            return ClassLoader.getSystemClassLoader().loadClass(this.clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    public String getName() {
        return "Native (" + this.clazz + ")";
    }

    @Override
    public boolean isKind(Object o) {
        if (o != null) {
            Class<?> cls = o.getClass();
            boolean found = false;
            while (cls != null && !found) {
                if (cls.getCanonicalName().equalsIgnoreCase(this.clazz)) {
                    return true;
                }
                cls = cls.getSuperclass();
            }
        }
        return false;
    }

    @Override
    public boolean isType(Object o) {
        if (o != null) {
            return o.getClass().getCanonicalName().equalsIgnoreCase(this.clazz);
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o instanceof EolNativeType) {
            return ((EolNativeType)o).clazz.equalsIgnoreCase(this.clazz);
        }
        return false;
    }
}

