/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.userinput;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.epsilon.eol.exceptions.EolUserException;
import org.eclipse.epsilon.eol.userinput.AbstractUserInput;

public abstract class ConsoleUserInput
extends AbstractUserInput {
    protected String initial = "_initial";

    @Override
    public void inform(String message) {
        this.getOutputStream().println(message);
    }

    public abstract InputStream getInputStream();

    public abstract PrintStream getOutputStream();

    public abstract PrintStream getErrorStream();

    @Override
    public boolean confirm(String question, boolean default_) throws EolUserException {
        String response = this.initial;
        while (!(response.equalsIgnoreCase("Y") || response.equalsIgnoreCase("N") || response.equalsIgnoreCase("C"))) {
            if (response != this.initial) {
                this.getErrorStream().println("Unrecognized choice : " + response);
                this.getErrorStream().flush();
            }
            this.getOutputStream().println(String.valueOf(question) + " (Y/N/C)");
            this.getOutputStream().flush();
            response = this.readString();
            if (response.equalsIgnoreCase("Y")) {
                return true;
            }
            if (response.equalsIgnoreCase("N")) {
                return false;
            }
            if (!response.equalsIgnoreCase("C")) continue;
            throw new EolUserException((Object)"Cancelled by the user");
        }
        return true;
    }

    @Override
    public Object chooseMany(String question, Collection choices, Collection default_) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object choose(String question, Collection choices, Object default_) {
        String response = this.initial;
        int index = -2;
        while (index <= 0 || index > choices.size()) {
            try {
                if (index != -2) {
                    this.getErrorStream().println("Please select a choice from 1 to " + choices.size());
                }
                Iterator it = choices.iterator();
                this.getOutputStream().println(question);
                int i = 1;
                while (it.hasNext()) {
                    this.getOutputStream().println(String.valueOf(i) + ") " + it.next());
                    ++i;
                }
                response = this.readString();
                index = Integer.parseInt(response);
                if (index <= 0 || index > choices.size()) continue;
                if (choices instanceof List) {
                    return ((List)choices).get(index - 1);
                }
                return new ArrayList(choices).get(index - 1);
            }
            catch (NumberFormatException numberFormatException) {
                this.getErrorStream().println("Not a valid number : " + response);
                index = -1;
            }
        }
        return null;
    }

    @Override
    public String prompt(String question, String deault_) {
        this.getOutputStream().println(question);
        return this.readString();
    }

    @Override
    public int promptInteger(String question, int default_) {
        boolean validResponse = false;
        int response = 0;
        String responseStr = "";
        while (!validResponse) {
            try {
                this.getOutputStream().println(question);
                responseStr = this.readString().trim();
                response = Integer.parseInt(responseStr);
                validResponse = true;
            }
            catch (NumberFormatException numberFormatException) {
                this.getErrorStream().println("Not a valid number : " + responseStr);
            }
        }
        return response;
    }

    @Override
    public float promptReal(String question, float default_) {
        boolean validResponse = false;
        float response = 0.0f;
        String responseStr = "";
        while (!validResponse) {
            try {
                this.getOutputStream().println(question);
                responseStr = this.readString().trim();
                response = Float.parseFloat(responseStr);
                validResponse = true;
            }
            catch (NumberFormatException numberFormatException) {
                this.getErrorStream().println("Not a valid number : " + responseStr);
            }
        }
        return response;
    }

    protected String readString() {
        byte[] response = new byte[100];
        try {
            this.getInputStream().read(response);
        }
        catch (IOException iOException) {
            return "";
        }
        return new String(response).trim();
    }
}

