/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.epsilon.commons.parse.AST;
import org.eclipse.epsilon.eol.exceptions.EolIllegalOperationException;
import org.eclipse.epsilon.eol.exceptions.EolInternalException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.prettyprinting.PrettyPrinterManager;
import org.eclipse.epsilon.eol.types.EolNativeType;

public class ReflectionUtil {
    public static boolean hasMethods(Object obj, String methodName) {
        if (obj == null) {
            return false;
        }
        Method[] methodArray = obj.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(methodName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Method getMethodFor(Object obj, String methodName, Object[] parameters) {
        return ReflectionUtil.getMethodFor(obj, methodName, parameters, true);
    }

    public static Method getMethodFor(Object obj, String methodName, Object[] parameters, boolean includeInheritedMethods) {
        if (obj == null) {
            return null;
        }
        Method[] methods = null;
        methods = includeInheritedMethods ? obj.getClass().getMethods() : obj.getClass().getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            boolean namesMatch = false;
            namesMatch = methods[i].getName().equalsIgnoreCase(methodName);
            if (namesMatch) {
                boolean parametersMatch;
                Method method = methods[i];
                Class<?>[] parameterTypes = method.getParameterTypes();
                boolean bl = parametersMatch = parameterTypes.length == parameters.length;
                if (parametersMatch) {
                    int j = 0;
                    while (j < parameterTypes.length && parametersMatch) {
                        Class<?> parameterType = parameterTypes[j];
                        Object parameter = parameters[j];
                        parametersMatch = parametersMatch && ReflectionUtil.isInstance(parameterType, parameter);
                        ++j;
                    }
                    if (parametersMatch) {
                        return method;
                    }
                }
            }
            ++i;
        }
        Class javaClass = null;
        if (obj instanceof EolNativeType) {
            javaClass = ((EolNativeType)obj).getJavaClass();
        }
        if (obj instanceof Class) {
            javaClass = (Class)obj;
        }
        if (javaClass != null) {
            methods = javaClass.getMethods();
            int i2 = 0;
            while (i2 < methods.length) {
                boolean namesMatch = false;
                namesMatch = methods[i2].getName().equalsIgnoreCase(methodName);
                if (namesMatch) {
                    boolean parametersMatch;
                    Method method = methods[i2];
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    boolean bl = parametersMatch = parameterTypes.length == parameters.length;
                    if (parametersMatch) {
                        int j = 0;
                        while (j < parameterTypes.length && parametersMatch) {
                            Class<?> parameterType = parameterTypes[j];
                            Object parameter = parameters[j];
                            parametersMatch = parametersMatch && ReflectionUtil.isInstance(parameterType, parameter);
                            ++j;
                        }
                        if (parametersMatch) {
                            return method;
                        }
                    }
                }
                ++i2;
            }
        }
        return null;
    }

    public static Method getMethodFor(Object obj, String methodName, int parametersCount) {
        Method[] methods = obj.getClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            boolean namesMatch = false;
            namesMatch = methods[i].getName().equalsIgnoreCase(methodName);
            if (namesMatch) {
                boolean parametersMatch;
                boolean bl = parametersMatch = methods[i].getParameterTypes().length == parametersCount;
                if (parametersMatch) {
                    return methods[i];
                }
            }
            ++i;
        }
        return null;
    }

    public static Object executeMethod(Object obj, String methodName, Object[] parameters, AST ast, PrettyPrinterManager prettyPrintManager) throws EolRuntimeException {
        Method method = ReflectionUtil.getMethodFor(obj, methodName, parameters);
        if (method != null) {
            try {
                return ReflectionUtil.executeMethod(method, obj, parameters);
            }
            catch (Throwable t) {
                throw new EolInternalException(t, ast);
            }
        }
        throw new EolIllegalOperationException(obj, methodName, ast, prettyPrintManager);
    }

    public static Object executeMethod(Object obj, Method method, Object[] parameters, AST ast) throws EolRuntimeException {
        try {
            return ReflectionUtil.executeMethod(method, obj, parameters);
        }
        catch (Throwable t) {
            throw new EolInternalException(t, ast);
        }
    }

    public static Object executeMethod(Object obj, String methodName, Object[] parameters) throws Throwable {
        Method method = ReflectionUtil.getMethodFor(obj, methodName, parameters);
        try {
            return method.invoke(obj, parameters);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public static Object executeMethod(Method method, Object obj, Object[] parameters) throws Throwable {
        try {
            return method.invoke(obj, parameters);
        }
        catch (InvocationTargetException iex) {
            throw iex.getCause();
        }
    }

    public static String methodToString(Method method) {
        String str = method.getName();
        str = String.valueOf(str) + "(";
        int i = 0;
        while (i < method.getParameterTypes().length) {
            Class<?> parameterType = method.getParameterTypes()[i];
            str = String.valueOf(str) + parameterType.getName();
            if (i < method.getParameterTypes().length - 1) {
                str = String.valueOf(str) + " ,";
            }
            ++i;
        }
        str = String.valueOf(str) + ")";
        return str;
    }

    public static Object getFieldValue(Object object, String fieldName) {
        if (object == null) {
            return null;
        }
        Field field = ReflectionUtil.getField(object.getClass(), fieldName);
        if (field == null) {
            return null;
        }
        field.setAccessible(true);
        try {
            return field.get(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Field getField(Class clazz, String fieldName) {
        Field[] fields = clazz.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getName().equals(fieldName)) {
                return fields[i];
            }
            ++i;
        }
        if (clazz.getSuperclass() != Object.class) {
            return ReflectionUtil.getField(clazz.getSuperclass(), fieldName);
        }
        return null;
    }

    public static boolean isInstance(Class clazz, Object instance) {
        if (instance == null) {
            return true;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class.isInstance(instance);
        }
        if (clazz == Float.TYPE) {
            return Float.class.isInstance(instance);
        }
        if (clazz == Double.TYPE) {
            return Double.class.isInstance(instance);
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class.isInstance(instance);
        }
        if (clazz == Long.TYPE) {
            return Long.class.isInstance(instance);
        }
        return clazz.isInstance(instance);
    }
}

