/*
 * Decompiled with CFR 0.152.
 */
package org.ros.model.ros.diagram.edit.parts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ScalablePolygonShape;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.FlowLayoutEditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;
import org.ros.model.ros.diagram.DefaultSizeNodeFigureWithFixedAnchors;
import org.ros.model.ros.diagram.edit.parts.ServiceClientEditPart;
import org.ros.model.ros.diagram.edit.parts.ServiceServerNameEditPart;
import org.ros.model.ros.diagram.edit.policies.ServiceServerItemSemanticEditPolicy;
import org.ros.model.ros.diagram.part.RosVisualIDRegistry;
import org.ros.model.ros.diagram.providers.RosElementTypes;

public class ServiceServerEditPart
extends AbstractBorderItemEditPart {
    public static final int VISUAL_ID = 3007;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    static final Color THIS_BACK = new Color(null, 150, 150, 0);

    public ServiceServerEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("PrimaryDrag Policy", this.getPrimaryDragEditPolicy());
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new ServiceServerItemSemanticEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        FlowLayoutEditPolicy lep = new FlowLayoutEditPolicy(){

            protected Command createAddCommand(EditPart child, EditPart after) {
                return null;
            }

            protected Command createMoveChildCommand(EditPart child, EditPart after) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new ServiceServerFigure();
        return this.primaryShape;
    }

    public ServiceServerFigure getPrimaryShape() {
        return (ServiceServerFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof ServiceServerNameEditPart) {
            ((ServiceServerNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getFigureServiceServerNameFigure());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        return childEditPart instanceof ServiceServerNameEditPart;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        return this.getContentPane();
    }

    protected NodeFigure createNodePlate() {
        HashMap<String, PrecisionPoint> anchorLocations = new HashMap<String, PrecisionPoint>();
        anchorLocations.put("EAST", new PrecisionPoint(1.0, 0.5));
        DefaultSizeNodeFigureWithFixedAnchors result = new DefaultSizeNodeFigureWithFixedAnchors(60, 20, anchorLocations);
        result.getBounds().setSize(result.getPreferredSize());
        return result;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(5);
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setBackgroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setBackgroundColor(color);
        }
    }

    protected void setLineWidth(int width) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineWidth(width);
        }
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineStyle(style);
        }
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(RosVisualIDRegistry.getType(5005));
    }

    public List<IElementType> getMARelTypesOnSource() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        types.add(RosElementTypes.Service_4002);
        return types;
    }

    public List<IElementType> getMARelTypesOnSourceAndTarget(IGraphicalEditPart targetEditPart) {
        LinkedList<IElementType> types = new LinkedList<IElementType>();
        if (targetEditPart instanceof ServiceClientEditPart) {
            types.add(RosElementTypes.Service_4002);
        }
        return types;
    }

    public List<IElementType> getMATypesForTarget(IElementType relationshipType) {
        LinkedList<IElementType> types = new LinkedList<IElementType>();
        if (relationshipType == RosElementTypes.Service_4002) {
            types.add(RosElementTypes.ServiceClient_3008);
        }
        return types;
    }

    public class ServiceServerFigure
    extends ScalablePolygonShape {
        public static final int BLUR_SHADOW_WIDTH = 5;
        private WrappingLabel fFigureServiceServerNameFigure;

        public void paintFigure(Graphics graphics) {
            this.drawBlurredShadow(graphics);
            super.paintFigure(graphics);
        }

        private void drawBlurredShadow(Graphics graphics) {
            graphics.pushState();
            int size = MapModeUtil.getMapMode((IFigure)this).DPtoLP(5);
            int step = MapModeUtil.getMapMode((IFigure)this).DPtoLP(-1);
            graphics.setForegroundColor(ColorConstants.gray);
            graphics.setLineWidth(MapModeUtil.getMapMode((IFigure)this).DPtoLP(2));
            graphics.translate(size, size);
            graphics.setClip(graphics.getClip(new Rectangle(this.getBounds())).expand(size, size));
            graphics.setAlpha(20);
            this.outlineShape(graphics);
            graphics.translate(step, step);
            graphics.setAlpha(30);
            this.outlineShape(graphics);
            graphics.translate(step, step);
            graphics.setAlpha(60);
            this.outlineShape(graphics);
            graphics.translate(step, step);
            graphics.setAlpha(100);
            this.outlineShape(graphics);
            graphics.translate(step, step);
            graphics.setAlpha(150);
            this.outlineShape(graphics);
            graphics.popState();
        }

        public ServiceServerFigure() {
            FlowLayout layoutThis = new FlowLayout();
            layoutThis.setStretchMinorAxis(false);
            layoutThis.setMinorAlignment(0);
            layoutThis.setMajorAlignment(0);
            layoutThis.setMajorSpacing(5);
            layoutThis.setMinorSpacing(5);
            layoutThis.setHorizontal(false);
            this.setLayoutManager((LayoutManager)layoutThis);
            this.addPoint(new Point(ServiceServerEditPart.this.getMapMode().DPtoLP(0), ServiceServerEditPart.this.getMapMode().DPtoLP(0)));
            this.addPoint(new Point(ServiceServerEditPart.this.getMapMode().DPtoLP(30), ServiceServerEditPart.this.getMapMode().DPtoLP(0)));
            this.addPoint(new Point(ServiceServerEditPart.this.getMapMode().DPtoLP(40), ServiceServerEditPart.this.getMapMode().DPtoLP(20)));
            this.addPoint(new Point(ServiceServerEditPart.this.getMapMode().DPtoLP(30), ServiceServerEditPart.this.getMapMode().DPtoLP(40)));
            this.addPoint(new Point(ServiceServerEditPart.this.getMapMode().DPtoLP(0), ServiceServerEditPart.this.getMapMode().DPtoLP(40)));
            this.setFill(true);
            this.setBackgroundColor(THIS_BACK);
            this.setPreferredSize(new Dimension(ServiceServerEditPart.this.getMapMode().DPtoLP(80), ServiceServerEditPart.this.getMapMode().DPtoLP(20)));
            this.setBorder((Border)new MarginBorder(ServiceServerEditPart.this.getMapMode().DPtoLP(2), ServiceServerEditPart.this.getMapMode().DPtoLP(2), ServiceServerEditPart.this.getMapMode().DPtoLP(2), ServiceServerEditPart.this.getMapMode().DPtoLP(2)));
            this.createContents();
        }

        private void createContents() {
            this.fFigureServiceServerNameFigure = new WrappingLabel();
            this.fFigureServiceServerNameFigure.setText("<...>");
            this.add((IFigure)this.fFigureServiceServerNameFigure);
        }

        public WrappingLabel getFigureServiceServerNameFigure() {
            return this.fFigureServiceServerNameFigure;
        }
    }
}

