/*
 * Decompiled with CFR 0.152.
 */
package org.bride.wizards;

import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;

public class ROSWizardResourceImportPage
extends WizardPage {
    private Text directoryPathField;
    private static String previouslyBrowsedDirectory = "";

    protected ROSWizardResourceImportPage(String name, IStructuredSelection selection) {
        super(name);
    }

    public String getCurrentPath() {
        return this.directoryPathField.getText();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        this.createProjectsRoot(workArea);
        Dialog.applyDialogFont((Control)workArea);
    }

    private void createProjectsRoot(Composite workArea) {
        Composite projectGroup = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        this.directoryPathField = new Text(projectGroup, 2048);
        GridData directoryPathData = new GridData(768);
        directoryPathData.widthHint = new PixelConverter((Control)this.directoryPathField).convertWidthInCharsToPixels(25);
        this.directoryPathField.setLayoutData((Object)directoryPathData);
        Button browseDirectoriesButton = new Button(projectGroup, 8);
        browseDirectoriesButton.setText(DataTransferMessages.DataTransfer_browse);
        browseDirectoriesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ROSWizardResourceImportPage.this.handleLocationDirectoryButtonPressed();
            }
        });
    }

    protected void handleLocationDirectoryButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.directoryPathField.getShell(), 0x10000000);
        dialog.setMessage(DataTransferMessages.WizardProjectsImportPage_SelectDialogTitle);
        String dirName = this.directoryPathField.getText().trim();
        if (dirName.length() == 0) {
            dirName = previouslyBrowsedDirectory;
        }
        if (dirName.length() == 0) {
            dialog.setFilterPath(IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(dirName);
            if (path.exists()) {
                dialog.setFilterPath(new Path(dirName).toOSString());
            }
        }
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            previouslyBrowsedDirectory = selectedDirectory;
            this.directoryPathField.setText(previouslyBrowsedDirectory);
        }
    }
}

