/*
 * Decompiled with CFR 0.152.
 */
package org.ros.model.ros_coordinator.diagram.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.structure.DiagramStructure;
import org.ros.model.ros.Package;
import org.ros.model.ros.RosPackage;
import org.ros.model.ros_coordinator.diagram.part.SmachDiagramEditorPlugin;
import org.ros.model.smach.SmachPackage;

public class SmachVisualIDRegistry {
    private static final String DEBUG_KEY = "org.ros.model.ros_coordinator.diagram/debug/visualID";
    public static final DiagramStructure TYPED_INSTANCE = new DiagramStructure(){

        public int getVisualID(View view) {
            return SmachVisualIDRegistry.getVisualID(view);
        }

        public String getModelID(View view) {
            return SmachVisualIDRegistry.getModelID(view);
        }

        public int getNodeVisualID(View containerView, EObject domainElement) {
            return SmachVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        }

        public boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
            return SmachVisualIDRegistry.checkNodeVisualID(containerView, domainElement, candidate);
        }

        public boolean isCompartmentVisualID(int visualID) {
            return SmachVisualIDRegistry.isCompartmentVisualID(visualID);
        }

        public boolean isSemanticLeafVisualID(int visualID) {
            return SmachVisualIDRegistry.isSemanticLeafVisualID(visualID);
        }
    };

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("RosCoordinator".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return SmachVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                SmachDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (RosPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass()) && SmachVisualIDRegistry.isDiagram((Package)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = SmachVisualIDRegistry.getModelID(containerView);
        if (!"RosCoordinator".equals(containerModelID)) {
            return -1;
        }
        if ("RosCoordinator".equals(containerModelID)) {
            containerVisualID = SmachVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (!SmachPackage.eINSTANCE.getSMACHStateMachine().isSuperTypeOf(domainElement.eClass())) break;
                return 2001;
            }
            case 7001: {
                if (SmachPackage.eINSTANCE.getActionState().isSuperTypeOf(domainElement.eClass())) {
                    return 3001;
                }
                if (SmachPackage.eINSTANCE.getServiceState().isSuperTypeOf(domainElement.eClass())) {
                    return 3002;
                }
                if (SmachPackage.eINSTANCE.getFinalState().isSuperTypeOf(domainElement.eClass())) {
                    return 3003;
                }
                if (!SmachPackage.eINSTANCE.getInitActionState().isSuperTypeOf(domainElement.eClass())) break;
                return 3004;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = SmachVisualIDRegistry.getModelID(containerView);
        if (!"RosCoordinator".equals(containerModelID)) {
            return false;
        }
        if ("RosCoordinator".equals(containerModelID)) {
            containerVisualID = SmachVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2001 != nodeVisualID) break;
                return true;
            }
            case 2001: {
                if (5003 == nodeVisualID) {
                    return true;
                }
                if (7001 != nodeVisualID) break;
                return true;
            }
            case 3001: {
                if (5001 != nodeVisualID) break;
                return true;
            }
            case 3002: {
                if (5002 != nodeVisualID) break;
                return true;
            }
            case 7001: {
                if (3001 == nodeVisualID) {
                    return true;
                }
                if (3002 == nodeVisualID) {
                    return true;
                }
                if (3003 == nodeVisualID) {
                    return true;
                }
                if (3004 != nodeVisualID) break;
                return true;
            }
            case 4001: {
                if (6001 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (SmachPackage.eINSTANCE.getSMACHTransition().isSuperTypeOf(domainElement.eClass())) {
            return 4001;
        }
        return -1;
    }

    private static boolean isDiagram(Package element) {
        return true;
    }

    public static boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
        if (candidate == -1) {
            return false;
        }
        int basic = SmachVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        return basic == candidate;
    }

    public static boolean isCompartmentVisualID(int visualID) {
        switch (visualID) {
            case 7001: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSemanticLeafVisualID(int visualID) {
        switch (visualID) {
            case 1000: {
                return false;
            }
            case 3001: 
            case 3002: 
            case 3003: 
            case 3004: {
                return true;
            }
        }
        return false;
    }
}

