/*
 * Decompiled with CFR 0.152.
 */
package org.ros.model.ros.diagram.part;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.update.DiagramUpdater;
import org.ros.model.ros.Action;
import org.ros.model.ros.ActionClient;
import org.ros.model.ros.ActionServer;
import org.ros.model.ros.Architecture;
import org.ros.model.ros.Node;
import org.ros.model.ros.Package;
import org.ros.model.ros.Parameter;
import org.ros.model.ros.Publisher;
import org.ros.model.ros.RosPackage;
import org.ros.model.ros.Service;
import org.ros.model.ros.ServiceClient;
import org.ros.model.ros.ServiceServer;
import org.ros.model.ros.Subscriber;
import org.ros.model.ros.Topic;
import org.ros.model.ros.diagram.part.RosLinkDescriptor;
import org.ros.model.ros.diagram.part.RosNodeDescriptor;
import org.ros.model.ros.diagram.part.RosVisualIDRegistry;
import org.ros.model.ros.diagram.providers.RosElementTypes;

public class RosDiagramUpdater {
    public static final DiagramUpdater TYPED_INSTANCE = new DiagramUpdater(){

        public List<RosNodeDescriptor> getSemanticChildren(View view) {
            return RosDiagramUpdater.getSemanticChildren(view);
        }

        public List<RosLinkDescriptor> getContainedLinks(View view) {
            return RosDiagramUpdater.getContainedLinks(view);
        }

        public List<RosLinkDescriptor> getIncomingLinks(View view) {
            return RosDiagramUpdater.getIncomingLinks(view);
        }

        public List<RosLinkDescriptor> getOutgoingLinks(View view) {
            return RosDiagramUpdater.getOutgoingLinks(view);
        }
    };

    public static List<RosNodeDescriptor> getSemanticChildren(View view) {
        switch (RosVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                return RosDiagramUpdater.getArchitecture_1000SemanticChildren(view);
            }
            case 3001: {
                return RosDiagramUpdater.getNode_3001SemanticChildren(view);
            }
            case 7001: {
                return RosDiagramUpdater.getPackagePackageContentCompartment_7001SemanticChildren(view);
            }
            case 7002: {
                return RosDiagramUpdater.getNodeParameters_7002SemanticChildren(view);
            }
        }
        return Collections.emptyList();
    }

    public static List<RosNodeDescriptor> getArchitecture_1000SemanticChildren(View view) {
        if (!view.isSetElement()) {
            return Collections.emptyList();
        }
        Architecture modelElement = (Architecture)view.getElement();
        LinkedList<RosNodeDescriptor> result = new LinkedList<RosNodeDescriptor>();
        for (Package childElement : modelElement.getPackages()) {
            int visualID = RosVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 2001) continue;
            result.add(new RosNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public static List<RosNodeDescriptor> getNode_3001SemanticChildren(View view) {
        int visualID;
        if (!view.isSetElement()) {
            return Collections.emptyList();
        }
        Node modelElement = (Node)view.getElement();
        LinkedList<RosNodeDescriptor> result = new LinkedList<RosNodeDescriptor>();
        for (Publisher childElement : modelElement.getPublisher()) {
            visualID = RosVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 3003) continue;
            result.add(new RosNodeDescriptor((EObject)childElement, visualID));
        }
        for (Publisher childElement : modelElement.getSubscriber()) {
            visualID = RosVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 3004) continue;
            result.add(new RosNodeDescriptor((EObject)childElement, visualID));
        }
        for (Publisher childElement : modelElement.getActionserver()) {
            visualID = RosVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 3005) continue;
            result.add(new RosNodeDescriptor((EObject)childElement, visualID));
        }
        for (Publisher childElement : modelElement.getActionclient()) {
            visualID = RosVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 3006) continue;
            result.add(new RosNodeDescriptor((EObject)childElement, visualID));
        }
        for (Publisher childElement : modelElement.getServiceServer()) {
            visualID = RosVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 3007) continue;
            result.add(new RosNodeDescriptor((EObject)childElement, visualID));
        }
        for (Publisher childElement : modelElement.getServiceClient()) {
            visualID = RosVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 3008) continue;
            result.add(new RosNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public static List<RosNodeDescriptor> getPackagePackageContentCompartment_7001SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Package modelElement = (Package)containerView.getElement();
        LinkedList<RosNodeDescriptor> result = new LinkedList<RosNodeDescriptor>();
        for (Node childElement : modelElement.getNode()) {
            int visualID = RosVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 3001) continue;
            result.add(new RosNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public static List<RosNodeDescriptor> getNodeParameters_7002SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Node modelElement = (Node)containerView.getElement();
        LinkedList<RosNodeDescriptor> result = new LinkedList<RosNodeDescriptor>();
        for (Parameter childElement : modelElement.getParameter()) {
            int visualID = RosVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 3002) continue;
            result.add(new RosNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public static List<RosLinkDescriptor> getContainedLinks(View view) {
        switch (RosVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                return RosDiagramUpdater.getArchitecture_1000ContainedLinks(view);
            }
            case 2001: {
                return RosDiagramUpdater.getPackage_2001ContainedLinks(view);
            }
            case 3001: {
                return RosDiagramUpdater.getNode_3001ContainedLinks(view);
            }
            case 3002: {
                return RosDiagramUpdater.getParameter_3002ContainedLinks(view);
            }
            case 3003: {
                return RosDiagramUpdater.getPublisher_3003ContainedLinks(view);
            }
            case 3004: {
                return RosDiagramUpdater.getSubscriber_3004ContainedLinks(view);
            }
            case 3005: {
                return RosDiagramUpdater.getActionServer_3005ContainedLinks(view);
            }
            case 3006: {
                return RosDiagramUpdater.getActionClient_3006ContainedLinks(view);
            }
            case 3007: {
                return RosDiagramUpdater.getServiceServer_3007ContainedLinks(view);
            }
            case 3008: {
                return RosDiagramUpdater.getServiceClient_3008ContainedLinks(view);
            }
            case 4001: {
                return RosDiagramUpdater.getTopic_4001ContainedLinks(view);
            }
            case 4002: {
                return RosDiagramUpdater.getService_4002ContainedLinks(view);
            }
            case 4003: {
                return RosDiagramUpdater.getAction_4003ContainedLinks(view);
            }
        }
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getIncomingLinks(View view) {
        switch (RosVisualIDRegistry.getVisualID(view)) {
            case 2001: {
                return RosDiagramUpdater.getPackage_2001IncomingLinks(view);
            }
            case 3001: {
                return RosDiagramUpdater.getNode_3001IncomingLinks(view);
            }
            case 3002: {
                return RosDiagramUpdater.getParameter_3002IncomingLinks(view);
            }
            case 3003: {
                return RosDiagramUpdater.getPublisher_3003IncomingLinks(view);
            }
            case 3004: {
                return RosDiagramUpdater.getSubscriber_3004IncomingLinks(view);
            }
            case 3005: {
                return RosDiagramUpdater.getActionServer_3005IncomingLinks(view);
            }
            case 3006: {
                return RosDiagramUpdater.getActionClient_3006IncomingLinks(view);
            }
            case 3007: {
                return RosDiagramUpdater.getServiceServer_3007IncomingLinks(view);
            }
            case 3008: {
                return RosDiagramUpdater.getServiceClient_3008IncomingLinks(view);
            }
            case 4001: {
                return RosDiagramUpdater.getTopic_4001IncomingLinks(view);
            }
            case 4002: {
                return RosDiagramUpdater.getService_4002IncomingLinks(view);
            }
            case 4003: {
                return RosDiagramUpdater.getAction_4003IncomingLinks(view);
            }
        }
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getOutgoingLinks(View view) {
        switch (RosVisualIDRegistry.getVisualID(view)) {
            case 2001: {
                return RosDiagramUpdater.getPackage_2001OutgoingLinks(view);
            }
            case 3001: {
                return RosDiagramUpdater.getNode_3001OutgoingLinks(view);
            }
            case 3002: {
                return RosDiagramUpdater.getParameter_3002OutgoingLinks(view);
            }
            case 3003: {
                return RosDiagramUpdater.getPublisher_3003OutgoingLinks(view);
            }
            case 3004: {
                return RosDiagramUpdater.getSubscriber_3004OutgoingLinks(view);
            }
            case 3005: {
                return RosDiagramUpdater.getActionServer_3005OutgoingLinks(view);
            }
            case 3006: {
                return RosDiagramUpdater.getActionClient_3006OutgoingLinks(view);
            }
            case 3007: {
                return RosDiagramUpdater.getServiceServer_3007OutgoingLinks(view);
            }
            case 3008: {
                return RosDiagramUpdater.getServiceClient_3008OutgoingLinks(view);
            }
            case 4001: {
                return RosDiagramUpdater.getTopic_4001OutgoingLinks(view);
            }
            case 4002: {
                return RosDiagramUpdater.getService_4002OutgoingLinks(view);
            }
            case 4003: {
                return RosDiagramUpdater.getAction_4003OutgoingLinks(view);
            }
        }
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getArchitecture_1000ContainedLinks(View view) {
        Architecture modelElement = (Architecture)view.getElement();
        LinkedList<RosLinkDescriptor> result = new LinkedList<RosLinkDescriptor>();
        result.addAll(RosDiagramUpdater.getContainedTypeModelFacetLinks_Topic_4001(modelElement));
        result.addAll(RosDiagramUpdater.getContainedTypeModelFacetLinks_Service_4002(modelElement));
        result.addAll(RosDiagramUpdater.getContainedTypeModelFacetLinks_Action_4003(modelElement));
        return result;
    }

    public static List<RosLinkDescriptor> getPackage_2001ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getNode_3001ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getParameter_3002ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getPublisher_3003ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getSubscriber_3004ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getActionServer_3005ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getActionClient_3006ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getServiceServer_3007ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getServiceClient_3008ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getTopic_4001ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getService_4002ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getAction_4003ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getPackage_2001IncomingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getNode_3001IncomingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getParameter_3002IncomingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getPublisher_3003IncomingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getSubscriber_3004IncomingLinks(View view) {
        Subscriber modelElement = (Subscriber)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<RosLinkDescriptor> result = new LinkedList<RosLinkDescriptor>();
        result.addAll(RosDiagramUpdater.getIncomingTypeModelFacetLinks_Topic_4001(modelElement, crossReferences));
        return result;
    }

    public static List<RosLinkDescriptor> getActionServer_3005IncomingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getActionClient_3006IncomingLinks(View view) {
        ActionClient modelElement = (ActionClient)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<RosLinkDescriptor> result = new LinkedList<RosLinkDescriptor>();
        result.addAll(RosDiagramUpdater.getIncomingTypeModelFacetLinks_Action_4003(modelElement, crossReferences));
        return result;
    }

    public static List<RosLinkDescriptor> getServiceServer_3007IncomingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getServiceClient_3008IncomingLinks(View view) {
        ServiceClient modelElement = (ServiceClient)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<RosLinkDescriptor> result = new LinkedList<RosLinkDescriptor>();
        result.addAll(RosDiagramUpdater.getIncomingTypeModelFacetLinks_Service_4002(modelElement, crossReferences));
        return result;
    }

    public static List<RosLinkDescriptor> getTopic_4001IncomingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getService_4002IncomingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getAction_4003IncomingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getPackage_2001OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getNode_3001OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getParameter_3002OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getPublisher_3003OutgoingLinks(View view) {
        Publisher modelElement = (Publisher)view.getElement();
        LinkedList<RosLinkDescriptor> result = new LinkedList<RosLinkDescriptor>();
        result.addAll(RosDiagramUpdater.getOutgoingTypeModelFacetLinks_Topic_4001(modelElement));
        return result;
    }

    public static List<RosLinkDescriptor> getSubscriber_3004OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getActionServer_3005OutgoingLinks(View view) {
        ActionServer modelElement = (ActionServer)view.getElement();
        LinkedList<RosLinkDescriptor> result = new LinkedList<RosLinkDescriptor>();
        result.addAll(RosDiagramUpdater.getOutgoingTypeModelFacetLinks_Action_4003(modelElement));
        return result;
    }

    public static List<RosLinkDescriptor> getActionClient_3006OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getServiceServer_3007OutgoingLinks(View view) {
        ServiceServer modelElement = (ServiceServer)view.getElement();
        LinkedList<RosLinkDescriptor> result = new LinkedList<RosLinkDescriptor>();
        result.addAll(RosDiagramUpdater.getOutgoingTypeModelFacetLinks_Service_4002(modelElement));
        return result;
    }

    public static List<RosLinkDescriptor> getServiceClient_3008OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getTopic_4001OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getService_4002OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<RosLinkDescriptor> getAction_4003OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    private static Collection<RosLinkDescriptor> getContainedTypeModelFacetLinks_Topic_4001(Architecture container) {
        LinkedList<RosLinkDescriptor> result = new LinkedList<RosLinkDescriptor>();
        for (EObject linkObject : container.getTopic()) {
            Topic link;
            if (!(linkObject instanceof Topic) || 4001 != RosVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Topic)linkObject))) continue;
            Subscriber dst = link.getSubscriber();
            Publisher src = link.getPublisher();
            result.add(new RosLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, RosElementTypes.Topic_4001, 4001));
        }
        return result;
    }

    private static Collection<RosLinkDescriptor> getContainedTypeModelFacetLinks_Service_4002(Architecture container) {
        LinkedList<RosLinkDescriptor> result = new LinkedList<RosLinkDescriptor>();
        for (EObject linkObject : container.getService()) {
            Object theSource;
            Object theTarget;
            Service link;
            if (!(linkObject instanceof Service) || 4002 != RosVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Service)linkObject))) continue;
            EList targets = link.getServiceclient();
            Object v0 = theTarget = targets.size() == 1 ? targets.get(0) : null;
            if (!(theTarget instanceof ServiceClient)) continue;
            ServiceClient dst = theTarget;
            EList sources = link.getServiceserver();
            Object v1 = theSource = sources.size() == 1 ? sources.get(0) : null;
            if (!(theSource instanceof ServiceServer)) continue;
            ServiceServer src = theSource;
            result.add(new RosLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, RosElementTypes.Service_4002, 4002));
        }
        return result;
    }

    private static Collection<RosLinkDescriptor> getContainedTypeModelFacetLinks_Action_4003(Architecture container) {
        LinkedList<RosLinkDescriptor> result = new LinkedList<RosLinkDescriptor>();
        for (EObject linkObject : container.getAction()) {
            Action link;
            if (!(linkObject instanceof Action) || 4003 != RosVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Action)linkObject))) continue;
            ActionClient dst = link.getActionclient();
            ActionServer src = link.getActionserver();
            result.add(new RosLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, RosElementTypes.Action_4003, 4003));
        }
        return result;
    }

    private static Collection<RosLinkDescriptor> getIncomingTypeModelFacetLinks_Topic_4001(Subscriber target, Map<EObject, Collection<EStructuralFeature.Setting>> crossReferences) {
        LinkedList<RosLinkDescriptor> result = new LinkedList<RosLinkDescriptor>();
        Collection<EStructuralFeature.Setting> settings = crossReferences.get(target);
        for (EStructuralFeature.Setting setting : settings) {
            Topic link;
            if (setting.getEStructuralFeature() != RosPackage.eINSTANCE.getTopic_Subscriber() || !(setting.getEObject() instanceof Topic) || 4001 != RosVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Topic)setting.getEObject()))) continue;
            Publisher src = link.getPublisher();
            result.add(new RosLinkDescriptor((EObject)src, (EObject)target, (EObject)link, RosElementTypes.Topic_4001, 4001));
        }
        return result;
    }

    private static Collection<RosLinkDescriptor> getIncomingTypeModelFacetLinks_Service_4002(ServiceClient target, Map<EObject, Collection<EStructuralFeature.Setting>> crossReferences) {
        LinkedList<RosLinkDescriptor> result = new LinkedList<RosLinkDescriptor>();
        Collection<EStructuralFeature.Setting> settings = crossReferences.get(target);
        for (EStructuralFeature.Setting setting : settings) {
            Object theSource;
            Service link;
            if (setting.getEStructuralFeature() != RosPackage.eINSTANCE.getService_Serviceclient() || !(setting.getEObject() instanceof Service) || 4002 != RosVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Service)setting.getEObject()))) continue;
            EList sources = link.getServiceserver();
            Object v0 = theSource = sources.size() == 1 ? sources.get(0) : null;
            if (!(theSource instanceof ServiceServer)) continue;
            ServiceServer src = theSource;
            result.add(new RosLinkDescriptor((EObject)src, (EObject)target, (EObject)link, RosElementTypes.Service_4002, 4002));
        }
        return result;
    }

    private static Collection<RosLinkDescriptor> getIncomingTypeModelFacetLinks_Action_4003(ActionClient target, Map<EObject, Collection<EStructuralFeature.Setting>> crossReferences) {
        LinkedList<RosLinkDescriptor> result = new LinkedList<RosLinkDescriptor>();
        Collection<EStructuralFeature.Setting> settings = crossReferences.get(target);
        for (EStructuralFeature.Setting setting : settings) {
            Action link;
            if (setting.getEStructuralFeature() != RosPackage.eINSTANCE.getAction_Actionclient() || !(setting.getEObject() instanceof Action) || 4003 != RosVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Action)setting.getEObject()))) continue;
            ActionServer src = link.getActionserver();
            result.add(new RosLinkDescriptor((EObject)src, (EObject)target, (EObject)link, RosElementTypes.Action_4003, 4003));
        }
        return result;
    }

    private static Collection<RosLinkDescriptor> getOutgoingTypeModelFacetLinks_Topic_4001(Publisher source) {
        Architecture container = null;
        Publisher element = source;
        while (element != null && container == null) {
            if (element instanceof Architecture) {
                container = (Architecture)element;
            }
            element = element.eContainer();
        }
        if (container == null) {
            return Collections.emptyList();
        }
        LinkedList<RosLinkDescriptor> result = new LinkedList<RosLinkDescriptor>();
        for (EObject linkObject : container.getTopic()) {
            Topic link;
            if (!(linkObject instanceof Topic) || 4001 != RosVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Topic)linkObject))) continue;
            Subscriber dst = link.getSubscriber();
            Publisher src = link.getPublisher();
            if (src != source) continue;
            result.add(new RosLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, RosElementTypes.Topic_4001, 4001));
        }
        return result;
    }

    private static Collection<RosLinkDescriptor> getOutgoingTypeModelFacetLinks_Service_4002(ServiceServer source) {
        Architecture container = null;
        ServiceServer element = source;
        while (element != null && container == null) {
            if (element instanceof Architecture) {
                container = (Architecture)element;
            }
            element = element.eContainer();
        }
        if (container == null) {
            return Collections.emptyList();
        }
        LinkedList<RosLinkDescriptor> result = new LinkedList<RosLinkDescriptor>();
        for (EObject linkObject : container.getService()) {
            ServiceServer src;
            Object theSource;
            Object theTarget;
            Service link;
            if (!(linkObject instanceof Service) || 4002 != RosVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Service)linkObject))) continue;
            EList targets = link.getServiceclient();
            Object v0 = theTarget = targets.size() == 1 ? targets.get(0) : null;
            if (!(theTarget instanceof ServiceClient)) continue;
            ServiceClient dst = theTarget;
            EList sources = link.getServiceserver();
            Object v1 = theSource = sources.size() == 1 ? sources.get(0) : null;
            if (!(theSource instanceof ServiceServer) || (src = (ServiceServer)theSource) != source) continue;
            result.add(new RosLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, RosElementTypes.Service_4002, 4002));
        }
        return result;
    }

    private static Collection<RosLinkDescriptor> getOutgoingTypeModelFacetLinks_Action_4003(ActionServer source) {
        Architecture container = null;
        ActionServer element = source;
        while (element != null && container == null) {
            if (element instanceof Architecture) {
                container = (Architecture)element;
            }
            element = element.eContainer();
        }
        if (container == null) {
            return Collections.emptyList();
        }
        LinkedList<RosLinkDescriptor> result = new LinkedList<RosLinkDescriptor>();
        for (EObject linkObject : container.getAction()) {
            Action link;
            if (!(linkObject instanceof Action) || 4003 != RosVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Action)linkObject))) continue;
            ActionClient dst = link.getActionclient();
            ActionServer src = link.getActionserver();
            if (src != source) continue;
            result.add(new RosLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, RosElementTypes.Action_4003, 4003));
        }
        return result;
    }
}

