/*
 * Decompiled with CFR 0.152.
 */
package org.ros.model.ros;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum StandardMessageType implements Enumerator
{
    BOOL(0, "Bool", "Bool"),
    STRING(1, "String", "String");

    public static final int BOOL_VALUE = 0;
    public static final int STRING_VALUE = 1;
    private static final StandardMessageType[] VALUES_ARRAY;
    public static final List<StandardMessageType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new StandardMessageType[]{BOOL, STRING};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static StandardMessageType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            StandardMessageType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static StandardMessageType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            StandardMessageType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static StandardMessageType get(int value) {
        switch (value) {
            case 0: {
                return BOOL;
            }
            case 1: {
                return STRING;
            }
        }
        return null;
    }

    private StandardMessageType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

