/*
 * Decompiled with CFR 0.152.
 */
package org.ros.model.ros.diagram.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.ros.model.ros.Architecture;
import org.ros.model.ros.Service;
import org.ros.model.ros.ServiceClient;
import org.ros.model.ros.ServiceServer;
import org.ros.model.ros.diagram.edit.policies.RosBaseItemSemanticEditPolicy;

public class ServiceReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public ServiceReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof Service)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof ServiceServer) || !(this.newEnd instanceof ServiceServer)) {
            return false;
        }
        if (this.getLink().getServiceclient().size() != 1) {
            return false;
        }
        ServiceClient target = (ServiceClient)this.getLink().getServiceclient().get(0);
        if (!(this.getLink().eContainer() instanceof Architecture)) {
            return false;
        }
        Architecture container = (Architecture)this.getLink().eContainer();
        return RosBaseItemSemanticEditPolicy.getLinkConstraints().canExistService_4002(container, this.getLink(), this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof ServiceClient) || !(this.newEnd instanceof ServiceClient)) {
            return false;
        }
        if (this.getLink().getServiceserver().size() != 1) {
            return false;
        }
        ServiceServer source = (ServiceServer)this.getLink().getServiceserver().get(0);
        if (!(this.getLink().eContainer() instanceof Architecture)) {
            return false;
        }
        Architecture container = (Architecture)this.getLink().eContainer();
        return RosBaseItemSemanticEditPolicy.getLinkConstraints().canExistService_4002(container, this.getLink(), source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getLink().getServiceserver().remove((Object)this.getOldSource());
        this.getLink().getServiceserver().add((Object)this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().getServiceclient().remove((Object)this.getOldTarget());
        this.getLink().getServiceclient().add((Object)this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected Service getLink() {
        return (Service)this.getElementToEdit();
    }

    protected ServiceServer getOldSource() {
        return (ServiceServer)this.oldEnd;
    }

    protected ServiceServer getNewSource() {
        return (ServiceServer)this.newEnd;
    }

    protected ServiceClient getOldTarget() {
        return (ServiceClient)this.oldEnd;
    }

    protected ServiceClient getNewTarget() {
        return (ServiceClient)this.newEnd;
    }
}

