/*
 * Decompiled with CFR 0.152.
 */
package org.ros.model.ros_coordinator.diagram.navigator;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.ros.model.ros.Package;
import org.ros.model.ros_coordinator.diagram.navigator.SmachNavigatorGroup;
import org.ros.model.ros_coordinator.diagram.navigator.SmachNavigatorItem;
import org.ros.model.ros_coordinator.diagram.part.SmachDiagramEditorPlugin;
import org.ros.model.ros_coordinator.diagram.part.SmachVisualIDRegistry;
import org.ros.model.ros_coordinator.diagram.providers.SmachElementTypes;
import org.ros.model.ros_coordinator.diagram.providers.SmachParserProvider;
import org.ros.model.smach.FinalState;
import org.ros.model.smach.InitActionState;

public class SmachNavigatorLabelProvider
extends LabelProvider
implements ICommonLabelProvider,
ITreePathLabelProvider {
    static {
        SmachDiagramEditorPlugin.getInstance().getImageRegistry().put("Navigator?UnknownElement", ImageDescriptor.getMissingImageDescriptor());
        SmachDiagramEditorPlugin.getInstance().getImageRegistry().put("Navigator?ImageNotFound", ImageDescriptor.getMissingImageDescriptor());
    }

    public void updateLabel(ViewerLabel label, TreePath elementPath) {
        Object element = elementPath.getLastSegment();
        if (element instanceof SmachNavigatorItem && !this.isOwnView(((SmachNavigatorItem)((Object)element)).getView())) {
            return;
        }
        label.setText(this.getText(element));
        label.setImage(this.getImage(element));
    }

    public Image getImage(Object element) {
        if (element instanceof SmachNavigatorGroup) {
            SmachNavigatorGroup group = (SmachNavigatorGroup)((Object)element);
            return SmachDiagramEditorPlugin.getInstance().getBundledImage(group.getIcon());
        }
        if (element instanceof SmachNavigatorItem) {
            SmachNavigatorItem navigatorItem = (SmachNavigatorItem)((Object)element);
            if (!this.isOwnView(navigatorItem.getView())) {
                return super.getImage(element);
            }
            return this.getImage(navigatorItem.getView());
        }
        return super.getImage(element);
    }

    public Image getImage(View view) {
        switch (SmachVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                return this.getImage("Navigator?Diagram?http://ros/1.0?Package", SmachElementTypes.Package_1000);
            }
            case 2001: {
                return this.getImage("Navigator?TopLevelNode?http://smach/1.0?SMACHStateMachine", SmachElementTypes.SMACHStateMachine_2001);
            }
            case 3001: {
                return this.getImage("Navigator?Node?http://smach/1.0?ActionState", SmachElementTypes.ActionState_3001);
            }
            case 3002: {
                return this.getImage("Navigator?Node?http://smach/1.0?ServiceState", SmachElementTypes.ServiceState_3002);
            }
            case 3003: {
                return this.getImage("Navigator?Node?http://smach/1.0?FinalState", SmachElementTypes.FinalState_3003);
            }
            case 3004: {
                return this.getImage("Navigator?Node?http://smach/1.0?InitActionState", SmachElementTypes.InitActionState_3004);
            }
            case 4001: {
                return this.getImage("Navigator?Link?http://smach/1.0?SMACHTransition", SmachElementTypes.SMACHTransition_4001);
            }
        }
        return this.getImage("Navigator?UnknownElement", null);
    }

    private Image getImage(String key, IElementType elementType) {
        ImageRegistry imageRegistry = SmachDiagramEditorPlugin.getInstance().getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null && elementType != null && SmachElementTypes.isKnownElementType(elementType)) {
            image = SmachElementTypes.getImage((IAdaptable)elementType);
            imageRegistry.put(key, image);
        }
        if (image == null) {
            image = imageRegistry.get("Navigator?ImageNotFound");
            imageRegistry.put(key, image);
        }
        return image;
    }

    public String getText(Object element) {
        if (element instanceof SmachNavigatorGroup) {
            SmachNavigatorGroup group = (SmachNavigatorGroup)((Object)element);
            return group.getGroupName();
        }
        if (element instanceof SmachNavigatorItem) {
            SmachNavigatorItem navigatorItem = (SmachNavigatorItem)((Object)element);
            if (!this.isOwnView(navigatorItem.getView())) {
                return null;
            }
            return this.getText(navigatorItem.getView());
        }
        return super.getText(element);
    }

    public String getText(View view) {
        if (view.getElement() != null && view.getElement().eIsProxy()) {
            return this.getUnresolvedDomainElementProxyText(view);
        }
        switch (SmachVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                return this.getPackage_1000Text(view);
            }
            case 2001: {
                return this.getSMACHStateMachine_2001Text(view);
            }
            case 3001: {
                return this.getActionState_3001Text(view);
            }
            case 3002: {
                return this.getServiceState_3002Text(view);
            }
            case 3003: {
                return this.getFinalState_3003Text(view);
            }
            case 3004: {
                return this.getInitActionState_3004Text(view);
            }
            case 4001: {
                return this.getSMACHTransition_4001Text(view);
            }
        }
        return this.getUnknownElementText(view);
    }

    private String getPackage_1000Text(View view) {
        Package domainModelElement = (Package)view.getElement();
        if (domainModelElement != null) {
            return domainModelElement.getName();
        }
        SmachDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 1000");
        return "";
    }

    private String getSMACHStateMachine_2001Text(View view) {
        IParser parser = SmachParserProvider.getParser(SmachElementTypes.SMACHStateMachine_2001, (EObject)(view.getElement() != null ? view.getElement() : view), SmachVisualIDRegistry.getType(5003));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        SmachDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5003");
        return "";
    }

    private String getActionState_3001Text(View view) {
        IParser parser = SmachParserProvider.getParser(SmachElementTypes.ActionState_3001, (EObject)(view.getElement() != null ? view.getElement() : view), SmachVisualIDRegistry.getType(5001));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        SmachDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5001");
        return "";
    }

    private String getServiceState_3002Text(View view) {
        IParser parser = SmachParserProvider.getParser(SmachElementTypes.ServiceState_3002, (EObject)(view.getElement() != null ? view.getElement() : view), SmachVisualIDRegistry.getType(5002));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        SmachDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5002");
        return "";
    }

    private String getFinalState_3003Text(View view) {
        FinalState domainModelElement = (FinalState)view.getElement();
        if (domainModelElement != null) {
            return domainModelElement.getGoal();
        }
        SmachDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 3003");
        return "";
    }

    private String getInitActionState_3004Text(View view) {
        InitActionState domainModelElement = (InitActionState)view.getElement();
        if (domainModelElement != null) {
            return domainModelElement.getGoal();
        }
        SmachDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 3004");
        return "";
    }

    private String getSMACHTransition_4001Text(View view) {
        IParser parser = SmachParserProvider.getParser(SmachElementTypes.SMACHTransition_4001, (EObject)(view.getElement() != null ? view.getElement() : view), SmachVisualIDRegistry.getType(6001));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        SmachDiagramEditorPlugin.getInstance().logError("Parser was not found for label 6001");
        return "";
    }

    private String getUnknownElementText(View view) {
        return "<UnknownElement Visual_ID = " + view.getType() + ">";
    }

    private String getUnresolvedDomainElementProxyText(View view) {
        return "<Unresolved domain element Visual_ID = " + view.getType() + ">";
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public String getDescription(Object anElement) {
        return null;
    }

    private boolean isOwnView(View view) {
        return "RosCoordinator".equals(SmachVisualIDRegistry.getModelID(view));
    }
}

