/*
 * Decompiled with CFR 0.152.
 */
package org.bride.wizards;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class ROSPackageWizard
extends Wizard
implements INewWizard {
    private static final String WIZARD_NAME = "New ROS Package";
    private WizardNewProjectCreationPage _pageOne;

    public ROSPackageWizard() {
        this.setWindowTitle(WIZARD_NAME);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public static void delete(File file) throws IOException {
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                file.delete();
                System.out.println("Directory is deleted : " + file.getAbsolutePath());
            } else {
                String[] files;
                String[] stringArray = files = file.list();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    String temp = stringArray[n2];
                    File fileDelete = new File(file, temp);
                    ROSPackageWizard.delete(fileDelete);
                    ++n2;
                }
                if (file.list().length == 0) {
                    file.delete();
                    System.out.println("Directory is deleted : " + file.getAbsolutePath());
                }
            }
        } else {
            file.delete();
            System.out.println("File is deleted : " + file.getAbsolutePath());
        }
    }

    public boolean performFinish() {
        String name = this._pageOne.getProjectName();
        URI location = null;
        location = this._pageOne.getLocationURI();
        Assert.isNotNull((Object)name);
        File directory = new File(location.getPath());
        System.out.println("Path: " + directory.getParent().toString());
        Runtime run = Runtime.getRuntime();
        try {
            Process pr = run.exec("catkin_create_pkg " + name, null, new File(directory.getParent()));
            pr.waitFor();
            BufferedReader buf = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            String line = "";
            while ((line = buf.readLine()) != null) {
                System.out.println(line);
            }
            System.out.println("Finished catkin_create_pkg");
            File bride_dir = new File(directory + "/bride");
            try {
                bride_dir.mkdir();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            File model_dir = new File(directory + "/model");
            try {
                model_dir.mkdir();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("Subfolder created");
            Process pr2 = run.exec(new String[]{"cmake", "-DCMAKE_ECLIPSE_MAKE_ARGUMENTS=-j8", "-G", "Eclipse CDT4 - Unix Makefiles", ".."}, null, bride_dir);
            pr2.waitFor();
            String line2 = "";
            BufferedReader buf2 = new BufferedReader(new InputStreamReader(pr2.getErrorStream()));
            while ((line2 = buf2.readLine()) != null) {
                System.out.println(line2);
            }
            pr2 = run.exec(new String[]{"cmake", "-DCMAKE_ECLIPSE_MAKE_ARGUMENTS=-j8", "-DCMAKE_MAKE_PROGRAM=catmake", "-G", "Eclipse CDT4 - Unix Makefiles", ".."}, null, bride_dir);
            pr2.waitFor();
            System.out.println("Finished eclipse file generation");
            File projectfile = new File(String.valueOf(bride_dir.getPath()) + "/.project");
            projectfile.renameTo(new File(String.valueOf(directory.getPath()) + "/.project"));
            File cprojectfile = new File(String.valueOf(bride_dir.getPath()) + "/.cproject");
            cprojectfile.renameTo(new File(String.valueOf(directory.getPath()) + "/.cproject"));
            ROSPackageWizard.delete(bride_dir);
            System.out.println("Files moved");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        IOverwriteQuery overwriteQuery = new IOverwriteQuery(){

            public String queryOverwrite(String file) {
                return "ALL";
            }
        };
        try {
            IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)new Path(String.valueOf(location.getPath()) + "/.project"));
            description.setName(description.getName().split("@")[0]);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(description.getName());
            System.out.println(project.getFullPath());
            String baseDir = location.getPath();
            ImportOperation importOperation = new ImportOperation(project.getFullPath(), (Object)new File(baseDir), (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, overwriteQuery);
            importOperation.setCreateContainerStructure(false);
            importOperation.setCreateLinks(true);
            importOperation.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }

    public void addPages() {
        super.addPages();
        this._pageOne = new WizardNewProjectCreationPage("From Scratch Project Wizard");
        this._pageOne.setTitle("From Scratch Project");
        this._pageOne.setDescription("Create something from scratch.");
        this.addPage((IWizardPage)this._pageOne);
    }
}

