/*
 * Decompiled with CFR 0.152.
 */
package org.ros.model.ros.diagram;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.ResourceWorkingSetFilter;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceNavigator;

public class WSFileDialog
extends Dialog {
    private TreeViewer viewer;
    private IResource rootElement;
    private boolean expand;
    private String[] extensions;
    private FilePatternFilter patternFilter = new FilePatternFilter();
    private ResourceWorkingSetFilter workingSetFilter = new ResourceWorkingSetFilter();
    private IWorkingSet workingSet;
    private int selectionStyle;
    private IResource[] result;
    private String title;

    public WSFileDialog(Shell parentShell, int selectionStyle, String title, IResource rootElement, boolean expand, String[] extensions, IWorkingSet workingSet) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.title = title;
        this.rootElement = rootElement;
        this.expand = expand;
        this.extensions = extensions;
        this.workingSet = workingSet;
        this.selectionStyle = selectionStyle;
    }

    public WSFileDialog(Shell parentShell, int selectionStyle, String title) {
        this(parentShell, selectionStyle, title, (IResource)ResourcesPlugin.getWorkspace().getRoot(), true, null, null);
    }

    public void setExtensions(String[] extensions) {
        this.extensions = extensions;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        this.getShell().setText(this.title);
        TreeViewer viewer = this.createViewer(comp);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.heightHint = 400;
        data.widthHint = 300;
        viewer.getControl().setLayoutData((Object)data);
        this.viewer = viewer;
        return comp;
    }

    protected TreeViewer createViewer(Composite parent) {
        new ResourceNavigator();
        TreeViewer viewer = new TreeViewer(parent, this.selectionStyle | 0x100 | 0x200 | 0x800);
        viewer.setUseHashlookup(true);
        this.initContentProvider(viewer);
        this.initLabelProvider(viewer);
        this.initFilters(viewer);
        viewer.setInput((Object)this.rootElement);
        if (this.expand) {
            viewer.expandToLevel(2);
        }
        return viewer;
    }

    protected void initFilters(TreeViewer viewer) {
        viewer.addFilter((ViewerFilter)this.patternFilter);
        if (this.workingSet != null) {
            this.workingSetFilter.setWorkingSet(this.workingSet);
            viewer.addFilter((ViewerFilter)this.workingSetFilter);
        }
    }

    protected void initContentProvider(TreeViewer viewer) {
        viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
    }

    protected void initLabelProvider(TreeViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), IDEWorkbenchPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator()));
    }

    protected void okPressed() {
        ISelection selection = this.viewer.getSelection();
        ArrayList<IResource> data = new ArrayList<IResource>();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            for (Object next : sel) {
                IResource resource = null;
                if (next instanceof IResource) {
                    resource = (IResource)next;
                } else if (next instanceof IAdaptable && resource == null) {
                    resource = (IResource)((IAdaptable)next).getAdapter(IResource.class);
                }
                if (resource == null) continue;
                data.add(resource);
            }
        }
        this.result = data.toArray(new IResource[0]);
        super.okPressed();
    }

    public IResource getSingleResult() {
        if (this.getReturnCode() == 0) {
            return this.getMultiResult()[0];
        }
        return null;
    }

    public IResource[] getMultiResult() {
        if (this.getReturnCode() == 0) {
            return this.result;
        }
        return null;
    }

    private class FilePatternFilter
    extends ViewerFilter {
        private FilePatternFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (WSFileDialog.this.extensions == null || WSFileDialog.this.extensions.length == 0) {
                return true;
            }
            IResource resource = null;
            if (element instanceof IResource) {
                resource = (IResource)element;
            } else if (element instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)element;
                resource = (IResource)adaptable.getAdapter(IResource.class);
            }
            if (resource != null && !resource.isDerived() && !resource.getName().equals("CVS")) {
                if (resource.getType() != 1) {
                    return true;
                }
                String extension = resource.getFileExtension();
                if (extension == null) {
                    return true;
                }
                int i = 0;
                while (i < WSFileDialog.this.extensions.length) {
                    if (extension.equalsIgnoreCase(WSFileDialog.this.extensions[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
    }
}

