/*
 * Decompiled with CFR 0.152.
 */
package org.ros.model.ros.diagram.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.ros.model.ros.Architecture;
import org.ros.model.ros.Publisher;
import org.ros.model.ros.Subscriber;
import org.ros.model.ros.Topic;
import org.ros.model.ros.diagram.edit.policies.RosBaseItemSemanticEditPolicy;

public class TopicReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public TopicReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof Topic)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof Publisher) || !(this.newEnd instanceof Publisher)) {
            return false;
        }
        Subscriber target = this.getLink().getSubscriber();
        if (!(this.getLink().eContainer() instanceof Architecture)) {
            return false;
        }
        Architecture container = (Architecture)this.getLink().eContainer();
        return RosBaseItemSemanticEditPolicy.getLinkConstraints().canExistTopic_4001(container, this.getLink(), this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof Subscriber) || !(this.newEnd instanceof Subscriber)) {
            return false;
        }
        Publisher source = this.getLink().getPublisher();
        if (!(this.getLink().eContainer() instanceof Architecture)) {
            return false;
        }
        Architecture container = (Architecture)this.getLink().eContainer();
        return RosBaseItemSemanticEditPolicy.getLinkConstraints().canExistTopic_4001(container, this.getLink(), source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getLink().setPublisher(this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().setSubscriber(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected Topic getLink() {
        return (Topic)this.getElementToEdit();
    }

    protected Publisher getOldSource() {
        return (Publisher)this.oldEnd;
    }

    protected Publisher getNewSource() {
        return (Publisher)this.newEnd;
    }

    protected Subscriber getOldTarget() {
        return (Subscriber)this.oldEnd;
    }

    protected Subscriber getNewTarget() {
        return (Subscriber)this.newEnd;
    }
}

