/*
 * Decompiled with CFR 0.152.
 */
package org.best_of_robotics.transform.ros.to.cplusplus;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.best_of_robotics.transform.service.parameter.IEglTransformParameter;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.egl.EglFileGeneratingTemplateFactory;
import org.eclipse.epsilon.egl.EglTemplateFactory;
import org.eclipse.epsilon.egl.EglTemplateFactoryModuleAdapter;
import org.eclipse.epsilon.egl.exceptions.EglRuntimeException;
import org.eclipse.epsilon.emc.emf.EmfModel;
import org.eclipse.epsilon.eol.dt.ExtensionPointToolNativeTypeDelegate;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class EGLTransformer {
    IEglTransformParameter parameter;
    int problem_;

    public EGLTransformer(IEglTransformParameter param) {
        this.parameter = param;
        this.problem_ = 0;
    }

    public void transform() {
        URL transformationEntry = null;
        try {
            transformationEntry = new URL(this.parameter.getEglTransformation());
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
            this.showError();
        }
        URL resolvedTransformationURL = null;
        URI transformURI = null;
        try {
            resolvedTransformationURL = FileLocator.resolve((URL)transformationEntry);
            transformURI = resolvedTransformationURL.toURI();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.showError();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            this.showError();
        }
        EglFileGeneratingTemplateFactory eglTemplateFactory = new EglFileGeneratingTemplateFactory();
        EglTemplateFactoryModuleAdapter eglModule = new EglTemplateFactoryModuleAdapter((EglTemplateFactory)eglTemplateFactory);
        try {
            eglTemplateFactory.setOutputRoot(this.parameter.getOutputRoot());
            eglModule.parse(transformURI);
        }
        catch (EglRuntimeException e2) {
            e2.printStackTrace();
            this.showError();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showError();
        }
        if (eglModule.getParseProblems().size() > 0) {
            System.err.println("Parse errors occured...");
            for (ParseProblem problem : eglModule.getParseProblems()) {
                System.err.println(problem.toString());
            }
        }
        eglModule.getContext().getNativeTypeDelegates().add(new ExtensionPointToolNativeTypeDelegate());
        EmfModel emfModel = new EmfModel();
        emfModel.setName(this.parameter.getSourceName());
        emfModel.setMetamodelUri(this.parameter.getSourceMetaModelURI());
        emfModel.setModelFile(this.parameter.getSourceModelFilePath());
        emfModel.setReadOnLoad(this.parameter.isSourceReadOnLoad());
        emfModel.setStoredOnDisposal(this.parameter.isSourceStoreOnDisposal());
        try {
            emfModel.load();
        }
        catch (EolModelLoadingException e) {
            e.printStackTrace();
            this.showError();
        }
        eglModule.getContext().getModelRepository().addModel((IModel)emfModel);
        try {
            eglModule.execute();
        }
        catch (EolRuntimeException e) {
            e.printStackTrace();
            this.showError();
        }
        eglModule.getContext().getModelRepository().dispose();
        if (this.problem_ == 0) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Codegeneration finished", (String)"The codegeneration was finished successfully. You might have to refresh you project to see the changes.");
        }
    }

    public void showError() {
        this.problem_ = 1;
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Code generation failed.", (String)"Something went wrong with the code generation. Please check the terminal for errors.");
    }
}

