/*
 * Decompiled with CFR 0.152.
 */
package org.ros.model.ros.diagram.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ui.PlatformUI;
import org.ros.model.ros.Architecture;
import org.ros.model.ros.Package;
import org.ros.model.ros.diagram.WSFileDialog;

public class PackageCreateCommand
extends EditElementCommand {
    public PackageCreateCommand(CreateElementRequest req) {
        super(req.getLabel(), null, (IEditCommandRequest)req);
    }

    protected EObject getElementToEdit() {
        EObject container = ((CreateElementRequest)this.getRequest()).getContainer();
        if (container instanceof View) {
            container = ((View)container).getElement();
        }
        return container;
    }

    public boolean canExecute() {
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        WSFileDialog dialog = new WSFileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 4, "Choose a filter to create new replayable", (IResource)ResourcesPlugin.getWorkspace().getRoot(), true, new String[]{"ros_package", "ros_coordinator"}, null);
        int result = dialog.open();
        if (result == 0) {
            IResource resource = dialog.getSingleResult();
            System.out.println(" ######## Selected File " + resource.getFullPath());
            ResourceSet resourceSet = this.getEditingDomain().getResourceSet();
            Resource res = resourceSet.getResource(URI.createURI((String)("platform:/resource/" + resource.getFullPath())), true);
            if (res.getContents().size() > 1) {
                int i = 0;
                while (i < res.getContents().size()) {
                    System.out.println("Contents:" + ((EObject)res.getContents().get(i)).toString());
                    ++i;
                }
            }
            Package newElement = (Package)res.getContents().get(0);
            Architecture owner = (Architecture)this.getElementToEdit();
            owner.getPackages().add((Object)newElement);
            System.out.println("Adding new Element to Architecture: " + newElement.toString());
            this.doConfigure(newElement, monitor, info);
            ((CreateElementRequest)this.getRequest()).setNewElement((EObject)newElement);
            return CommandResult.newOKCommandResult((Object)newElement);
        }
        return null;
    }

    protected void doConfigure(Package newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }
}

