/*
 * Decompiled with CFR 0.152.
 */
package org.bride.wizards;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.bride.wizards.ROSWizardNewProjectCreationPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;

public class ROSPackageWizard
extends Wizard
implements INewWizard {
    private static final String WIZARD_NAME = "New ROS Package";
    private ROSWizardNewProjectCreationPage _pageOne;

    public ROSPackageWizard() {
        this.setWindowTitle(WIZARD_NAME);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public static void delete(File file) throws IOException {
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                file.delete();
                System.out.println("Directory is deleted : " + file.getAbsolutePath());
            } else {
                String[] files;
                String[] stringArray = files = file.list();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    String temp = stringArray[n2];
                    File fileDelete = new File(file, temp);
                    ROSPackageWizard.delete(fileDelete);
                    ++n2;
                }
                if (file.list().length == 0) {
                    file.delete();
                    System.out.println("Directory is deleted : " + file.getAbsolutePath());
                }
            }
        } else {
            file.delete();
            System.out.println("File is deleted : " + file.getAbsolutePath());
        }
    }

    private boolean isDefaultLocation(IPath path) {
        if (path.segmentCount() < 2) {
            return false;
        }
        return path.removeLastSegments(2).toFile().equals(Platform.getLocation().toFile());
    }

    public boolean performFinish() {
        String name = this._pageOne.getProjectName();
        final URI location = this._pageOne.getLocationURI();
        Assert.isNotNull((Object)name);
        File directory = new File(location.getPath());
        System.out.println("Path: " + directory.getParent().toString());
        Runtime run = Runtime.getRuntime();
        try {
            Process pr = run.exec("rosrun bride catkin_create_eclipse_package.sh " + name, null, new File(directory.getParent()));
            pr.waitFor();
            BufferedReader buf = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            String line = "";
            while ((line = buf.readLine()) != null) {
                System.out.println(line);
            }
            System.out.println("Finished catkin_create_pkg");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        new IOverwriteQuery(){

            public String queryOverwrite(String file) {
                return "ALL";
            }
        };
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    Path path = new Path(String.valueOf(location.getPath()) + "/.project");
                    IProjectDescription description = null;
                    String projectName = "";
                    if (ROSPackageWizard.this.isDefaultLocation((IPath)path)) {
                        projectName = path.segment(path.segmentCount() - 2);
                        description = IDEWorkbenchPlugin.getPluginWorkspace().newProjectDescription(projectName);
                    } else {
                        description = IDEWorkbenchPlugin.getPluginWorkspace().loadProjectDescription((IPath)path);
                        projectName = description.getName().split("@")[0];
                    }
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    IProject project = workspace.getRoot().getProject(projectName);
                    description.setName(projectName);
                    monitor.beginTask(DataTransferMessages.WizardProjectsImportPage_CreateProjectsTask, 100);
                    project.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                    project.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 70));
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            String message = DataTransferMessages.WizardExternalProjectImportPage_errorMessage;
            Object status = t instanceof CoreException ? ((CoreException)t).getStatus() : new Status(4, "org.eclipse.ui.ide", 1, message, t);
            ErrorDialog.openError((Shell)this.getShell(), (String)message, null, (IStatus)status);
            return false;
        }
        return true;
    }

    public void addPages() {
        super.addPages();
        this._pageOne = new ROSWizardNewProjectCreationPage("ROS Package Creation Wizard");
        this._pageOne.setTitle("ROS Package Creation Wizard");
        this._pageOne.setDescription("Create a new ROS package as Eclipse project.");
        this.addPage((IWizardPage)this._pageOne);
    }
}

