/*
 * Decompiled with CFR 0.152.
 */
package org.ros.model.ros_coordinator.diagram.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.ros.model.ros_coordinator.diagram.edit.policies.SmachBaseItemSemanticEditPolicy;
import org.ros.model.smach.SMACHState;
import org.ros.model.smach.SMACHStateMachine;
import org.ros.model.smach.SMACHTransition;
import org.ros.model.smach.SmachFactory;

public class StateTransitionCreateCommand
extends EditElementCommand {
    private final EObject source;
    private final EObject target;
    private final SMACHStateMachine container;

    public StateTransitionCreateCommand(CreateRelationshipRequest request, EObject source, EObject target) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.source = source;
        this.target = target;
        this.container = StateTransitionCreateCommand.deduceContainer(source, target);
    }

    public boolean canExecute() {
        if (this.source == null && this.target == null) {
            return false;
        }
        if (this.source != null && !(this.source instanceof SMACHState)) {
            return false;
        }
        if (this.target != null && !(this.target instanceof SMACHState)) {
            return false;
        }
        if (this.getSource() == null) {
            return true;
        }
        if (this.getContainer() == null) {
            return false;
        }
        return SmachBaseItemSemanticEditPolicy.getLinkConstraints().canCreateSMACHTransition_4001(this.getContainer(), this.getSource(), this.getTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in create link command");
        }
        SMACHTransition newElement = SmachFactory.eINSTANCE.createSMACHTransition();
        this.getContainer().getTransitions().add((Object)newElement);
        newElement.setSource(this.getSource());
        newElement.setTarget(this.getTarget());
        this.doConfigure(newElement, monitor, info);
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)newElement);
        return CommandResult.newOKCommandResult((Object)newElement);
    }

    protected void doConfigure(SMACHTransition newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        configureRequest.setParameter("CreateRelationshipRequest.source", (Object)this.getSource());
        configureRequest.setParameter("CreateRelationshipRequest.target", (Object)this.getTarget());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }

    protected void setElementToEdit(EObject element) {
        throw new UnsupportedOperationException();
    }

    protected SMACHState getSource() {
        return (SMACHState)this.source;
    }

    protected SMACHState getTarget() {
        return (SMACHState)this.target;
    }

    public SMACHStateMachine getContainer() {
        return this.container;
    }

    private static SMACHStateMachine deduceContainer(EObject source, EObject target) {
        EObject element = source;
        while (element != null) {
            if (element instanceof SMACHStateMachine) {
                return (SMACHStateMachine)element;
            }
            element = element.eContainer();
        }
        return null;
    }
}

