/*
 * Decompiled with CFR 0.152.
 */
package org.ros.model.ros_coordinator.diagram.part;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.ros.model.ros_coordinator.diagram.part.Messages;
import org.ros.model.ros_coordinator.diagram.part.SmachCreationWizardPage;
import org.ros.model.ros_coordinator.diagram.part.SmachDiagramEditorPlugin;
import org.ros.model.ros_coordinator.diagram.part.SmachDiagramEditorUtil;

public class SmachCreationWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    protected IStructuredSelection selection;
    protected SmachCreationWizardPage diagramModelFilePage;
    protected SmachCreationWizardPage domainModelFilePage;
    protected Resource diagram;
    private boolean openNewlyCreatedDiagramEditor = true;

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public final Resource getDiagram() {
        return this.diagram;
    }

    public final boolean isOpenNewlyCreatedDiagramEditor() {
        return this.openNewlyCreatedDiagramEditor;
    }

    public void setOpenNewlyCreatedDiagramEditor(boolean openNewlyCreatedDiagramEditor) {
        this.openNewlyCreatedDiagramEditor = openNewlyCreatedDiagramEditor;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(Messages.SmachCreationWizardTitle);
        this.setDefaultPageImageDescriptor(SmachDiagramEditorPlugin.getBundledImageDescriptor("icons/wizban/NewRosWizard.gif"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.diagramModelFilePage = new SmachCreationWizardPage("DiagramModelFile", this.getSelection(), "ros_coordinator_diagram");
        this.diagramModelFilePage.setTitle(Messages.SmachCreationWizard_DiagramModelFilePageTitle);
        this.diagramModelFilePage.setDescription(Messages.SmachCreationWizard_DiagramModelFilePageDescription);
        this.addPage((IWizardPage)this.diagramModelFilePage);
        this.domainModelFilePage = new SmachCreationWizardPage("DomainModelFile", this.getSelection(), "ros_coordinator"){

            public void setVisible(boolean visible) {
                if (visible) {
                    String fileName = SmachCreationWizard.this.diagramModelFilePage.getFileName();
                    fileName = fileName.substring(0, fileName.length() - ".ros_coordinator_diagram".length());
                    this.setFileName(SmachDiagramEditorUtil.getUniqueFileName(this.getContainerFullPath(), fileName, "ros_coordinator"));
                }
                super.setVisible(visible);
            }
        };
        this.domainModelFilePage.setTitle(Messages.SmachCreationWizard_DomainModelFilePageTitle);
        this.domainModelFilePage.setDescription(Messages.SmachCreationWizard_DomainModelFilePageDescription);
        this.addPage((IWizardPage)this.domainModelFilePage);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                SmachCreationWizard.this.diagram = SmachDiagramEditorUtil.createDiagram(SmachCreationWizard.this.diagramModelFilePage.getURI(), SmachCreationWizard.this.domainModelFilePage.getURI(), monitor);
                if (SmachCreationWizard.this.isOpenNewlyCreatedDiagramEditor() && SmachCreationWizard.this.diagram != null) {
                    try {
                        SmachDiagramEditorUtil.openDiagram(SmachCreationWizard.this.diagram);
                    }
                    catch (PartInitException e) {
                        ErrorDialog.openError((Shell)SmachCreationWizard.this.getContainer().getShell(), (String)Messages.SmachCreationWizardOpenEditorError, null, (IStatus)e.getStatus());
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.SmachCreationWizardCreationError, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                SmachDiagramEditorPlugin.getInstance().logError("Error creating diagram", e.getTargetException());
            }
            return false;
        }
        return this.diagram != null;
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() != this.diagramModelFilePage;
    }
}

