/// autogenerated analytical inverse kinematics code from ikfast program part of OpenRAVE
/// \author Rosen Diankov
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///     http://www.apache.org/licenses/LICENSE-2.0
/// 
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// ikfast version 61 generated on 2012-11-23 19:10:48.288028
/// To compile with gcc:
///     gcc -lstdc++ ik.cpp
/// To compile without any main function as a shared object (might need -llapack):
///     gcc -fPIC -lstdc++ -DIKFAST_NO_MAIN -DIKFAST_CLIBRARY -shared -Wl,-soname,libik.so -o libik.so ik.cpp
#define IKFAST_HAS_LIBRARY
#include "ikfast.h" // found inside share/openrave-X.Y/python/ikfast.h
using namespace ikfast;

// check if the included ikfast version matches what this file was compiled with
#define IKFAST_COMPILE_ASSERT(x) extern int __dummy[(int)x]
IKFAST_COMPILE_ASSERT(IKFAST_VERSION==61);

#include <cmath>
#include <vector>
#include <limits>
#include <algorithm>
#include <complex>

#define IKFAST_STRINGIZE2(s) #s
#define IKFAST_STRINGIZE(s) IKFAST_STRINGIZE2(s)

#ifndef IKFAST_ASSERT
#include <stdexcept>
#include <sstream>
#include <iostream>

#ifdef _MSC_VER
#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __FUNCDNAME__
#endif
#endif

#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __func__
#endif

#define IKFAST_ASSERT(b) { if( !(b) ) { std::stringstream ss; ss << "ikfast exception: " << __FILE__ << ":" << __LINE__ << ": " <<__PRETTY_FUNCTION__ << ": Assertion '" << #b << "' failed"; throw std::runtime_error(ss.str()); } }

#endif

#if defined(_MSC_VER)
#define IKFAST_ALIGNED16(x) __declspec(align(16)) x
#else
#define IKFAST_ALIGNED16(x) x __attribute((aligned(16)))
#endif

#define IK2PI  ((IkReal)6.28318530717959)
#define IKPI  ((IkReal)3.14159265358979)
#define IKPI_2  ((IkReal)1.57079632679490)

#ifdef _MSC_VER
#ifndef isnan
#define isnan _isnan
#endif
#endif // _MSC_VER

// lapack routines
extern "C" {
  void dgetrf_ (const int* m, const int* n, double* a, const int* lda, int* ipiv, int* info);
  void zgetrf_ (const int* m, const int* n, std::complex<double>* a, const int* lda, int* ipiv, int* info);
  void dgetri_(const int* n, const double* a, const int* lda, int* ipiv, double* work, const int* lwork, int* info);
  void dgesv_ (const int* n, const int* nrhs, double* a, const int* lda, int* ipiv, double* b, const int* ldb, int* info);
  void dgetrs_(const char *trans, const int *n, const int *nrhs, double *a, const int *lda, int *ipiv, double *b, const int *ldb, int *info);
  void dgeev_(const char *jobvl, const char *jobvr, const int *n, double *a, const int *lda, double *wr, double *wi,double *vl, const int *ldvl, double *vr, const int *ldvr, double *work, const int *lwork, int *info);
}

using namespace std; // necessary to get std math routines

#ifdef IKFAST_NAMESPACE
namespace IKFAST_NAMESPACE {
#endif

inline float IKabs(float f) { return fabsf(f); }
inline double IKabs(double f) { return fabs(f); }

inline float IKsqr(float f) { return f*f; }
inline double IKsqr(double f) { return f*f; }

inline float IKlog(float f) { return logf(f); }
inline double IKlog(double f) { return log(f); }

// allows asin and acos to exceed 1
#ifndef IKFAST_SINCOS_THRESH
#define IKFAST_SINCOS_THRESH ((IkReal)0.000001)
#endif

// used to check input to atan2 for degenerate cases
#ifndef IKFAST_ATAN2_MAGTHRESH
#define IKFAST_ATAN2_MAGTHRESH ((IkReal)2e-6)
#endif

// minimum distance of separate solutions
#ifndef IKFAST_SOLUTION_THRESH
#define IKFAST_SOLUTION_THRESH ((IkReal)1e-6)
#endif

inline float IKasin(float f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return float(-IKPI_2);
else if( f >= 1 ) return float(IKPI_2);
return asinf(f);
}
inline double IKasin(double f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return -IKPI_2;
else if( f >= 1 ) return IKPI_2;
return asin(f);
}

// return positive value in [0,y)
inline float IKfmod(float x, float y)
{
    while(x < 0) {
        x += y;
    }
    return fmodf(x,y);
}

// return positive value in [0,y)
inline double IKfmod(double x, double y)
{
    while(x < 0) {
        x += y;
    }
    return fmod(x,y);
}

inline float IKacos(float f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return float(IKPI);
else if( f >= 1 ) return float(0);
return acosf(f);
}
inline double IKacos(double f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return IKPI;
else if( f >= 1 ) return 0;
return acos(f);
}
inline float IKsin(float f) { return sinf(f); }
inline double IKsin(double f) { return sin(f); }
inline float IKcos(float f) { return cosf(f); }
inline double IKcos(double f) { return cos(f); }
inline float IKtan(float f) { return tanf(f); }
inline double IKtan(double f) { return tan(f); }
inline float IKsqrt(float f) { if( f <= 0.0f ) return 0.0f; return sqrtf(f); }
inline double IKsqrt(double f) { if( f <= 0.0 ) return 0.0; return sqrt(f); }
inline float IKatan2(float fy, float fx) {
    if( isnan(fy) ) {
        IKFAST_ASSERT(!isnan(fx)); // if both are nan, probably wrong value will be returned
        return float(IKPI_2);
    }
    else if( isnan(fx) ) {
        return 0;
    }
    return atan2f(fy,fx);
}
inline double IKatan2(double fy, double fx) {
    if( isnan(fy) ) {
        IKFAST_ASSERT(!isnan(fx)); // if both are nan, probably wrong value will be returned
        return IKPI_2;
    }
    else if( isnan(fx) ) {
        return 0;
    }
    return atan2(fy,fx);
}

inline float IKsign(float f) {
    if( f > 0 ) {
        return float(1);
    }
    else if( f < 0 ) {
        return float(-1);
    }
    return 0;
}

inline double IKsign(double f) {
    if( f > 0 ) {
        return 1.0;
    }
    else if( f < 0 ) {
        return -1.0;
    }
    return 0;
}

/// solves the forward kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API void ComputeFk(const IkReal* j, IkReal* eetrans, IkReal* eerot) {
IkReal x0,x1,x2,x3,x4,x5,x6,x7,x8,x9,x10,x11,x12,x13,x14,x15,x16,x17,x18,x19,x20,x21,x22,x23,x24,x25,x26,x27,x28,x29,x30,x31,x32,x33,x34,x35,x36,x37,x38,x39,x40,x41,x42,x43,x44,x45,x46,x47,x48,x49,x50,x51,x52,x53,x54,x55,x56,x57,x58,x59,x60,x61,x62,x63,x64,x65;
x0=IKcos(j[1]);
x1=IKsin(j[1]);
x2=IKsin(j[3]);
x3=IKcos(j[2]);
x4=IKcos(j[3]);
x5=IKcos(j[4]);
x6=IKsin(j[2]);
x7=IKsin(j[4]);
x8=IKsin(j[6]);
x9=IKcos(j[6]);
x10=IKcos(j[5]);
x11=IKsin(j[5]);
x12=IKsin(j[0]);
x13=IKcos(j[0]);
x14=((IkReal(0.955072701792072))*(x13));
x15=((IkReal(0.296371615192129))*(x12));
x16=((IkReal(1.00000000000000))*(x7));
x17=((IkReal(1.00000000000000))*(x10));
x18=((IkReal(1.00000000000000))*(x5));
x19=((IkReal(0.390000000000000))*(x4));
x20=((IkReal(0.000500000000000000))*(x5));
x21=((IkReal(0.0570000000000000))*(x7));
x22=((IkReal(0.0570000000000000))*(x5));
x23=((IkReal(1.00000000000000))*(x11));
x24=((IkReal(0.390000000000000))*(x2));
x25=((IkReal(0.000500000000000000))*(x4));
x26=((x0)*(x3));
x27=((x2)*(x6));
x28=((x1)*(x6));
x29=((x0)*(x6));
x30=((x0)*(x2));
x31=((x1)*(x4));
x32=((x1)*(x2));
x33=((x4)*(x6));
x34=((x0)*(x4));
x35=((((IkReal(-1.00000000000000))*(x14)))+(x15));
x36=((((IkReal(-1.00000000000000))*(x15)))+(x14));
x37=((IkReal(1.00000000000000))*(x30));
x38=((IkReal(0.0570000000000000))*(x2)*(x3));
x39=((((IkReal(-0.955072701792072))*(x12)))+(((IkReal(-0.296371615192129))*(x13))));
x40=((x23)*(x27));
x41=((x16)*(x29));
x42=((x16)*(x28));
x43=((((IkReal(-1.00000000000000))*(x18)*(x3)))+(((x33)*(x7))));
x44=((((IkReal(-1.00000000000000))*(x31)))+(((x2)*(x26))));
x45=((x32)+(((x26)*(x4))));
x46=((((x3)*(x32)))+(x34));
x47=((((IkReal(-1.00000000000000))*(x37)))+(((x3)*(x31))));
x48=((((IkReal(-1.00000000000000))*(x18)*(x33)))+(((IkReal(-1.00000000000000))*(x16)*(x3))));
x49=((((x18)*(x33)))+(((x16)*(x3))));
x50=((x11)*(x44));
x51=((x11)*(x46));
x52=((x47)*(x5));
x53=((((IkReal(-1.00000000000000))*(x41)))+(((x45)*(x5))));
x54=((((IkReal(-1.00000000000000))*(x42)))+(x52));
x55=((((x7)*(((((IkReal(-1.00000000000000))*(x3)*(x31)))+(x37)))))+(((IkReal(-1.00000000000000))*(x18)*(x28))));
x56=((((IkReal(-1.00000000000000))*(x18)*(x29)))+(((x7)*(((((IkReal(-1.00000000000000))*(x32)))+(((IkReal(-1.00000000000000))*(x26)*(x4))))))));
x57=((((x11)*(x49)))+(((IkReal(-1.00000000000000))*(x17)*(x27))));
x58=((x10)*(x54));
x59=((((x11)*(((((IkReal(-1.00000000000000))*(x18)*(x45)))+(x41)))))+(((x10)*(x44))));
x60=((((x9)*(((((IkReal(-1.00000000000000))*(x40)))+(((x10)*(x48)))))))+(((x43)*(x8))));
x61=((((x8)*(((((IkReal(-1.00000000000000))*(x17)*(x48)))+(x40)))))+(((x43)*(x9))));
x62=((((x3)*(((IkReal(-0.00200000000000000))+(((IkReal(-1.00000000000000))*(x20)))))))+(((IkReal(-0.0570000000000000))*(x10)*(x27)))+(((x11)*(((((x21)*(x3)))+(((x22)*(x33)))))))+(((x6)*(((((IkReal(-1.00000000000000))*(x24)))+(((x25)*(x7))))))));
x63=((((x56)*(x8)))+(((x9)*(((((x10)*(x53)))+(x50))))));
x64=((((x56)*(x9)))+(((x8)*(((((IkReal(-1.00000000000000))*(x17)*(x53)))+(((IkReal(-1.00000000000000))*(x23)*(x44))))))));
x65=((((x7)*(((((IkReal(-1.00000000000000))*(x25)*(x26)))+(((IkReal(-0.000500000000000000))*(x32)))))))+(((x1)*(((IkReal(-0.400000000000000))+(((IkReal(-1.00000000000000))*(x19)))))))+(((IkReal(-0.00200000000000000))*(x29)))+(((x11)*(((((x21)*(x29)))+(((IkReal(-1.00000000000000))*(x22)*(x45)))))))+(((x10)*(((((IkReal(0.0570000000000000))*(x2)*(x26)))+(((IkReal(-0.0570000000000000))*(x31)))))))+(((x24)*(x26)))+(((IkReal(-1.00000000000000))*(x20)*(x29))));
eerot[0]=((((x39)*(x60)))+(((x35)*(x63))));
eerot[1]=((((x39)*(x61)))+(((x35)*(x64))));
eerot[2]=((((x39)*(x57)))+(((x35)*(x59))));
eetrans[0]=((((x39)*(x62)))+(((x35)*(x65)))+(((IkReal(-0.000592743230384259))*(x13)))+(((IkReal(-0.00191014540358414))*(x12))));
eerot[3]=((((x39)*(x63)))+(((x36)*(x60))));
eerot[4]=((((x39)*(x64)))+(((x36)*(x61))));
eerot[5]=((((x39)*(x59)))+(((x36)*(x57))));
eetrans[1]=((((x39)*(x65)))+(((x36)*(x62)))+(((IkReal(-0.000592743230384259))*(x12)))+(((IkReal(0.00191014540358414))*(x13))));
eerot[6]=((((x9)*(((x58)+(x51)))))+(((x55)*(x8))));
eerot[7]=((((x55)*(x9)))+(((x8)*(((((IkReal(-1.00000000000000))*(x17)*(x54)))+(((IkReal(-1.00000000000000))*(x23)*(x46))))))));
eerot[8]=((((x10)*(x46)))+(((x11)*(((((IkReal(-1.00000000000000))*(x18)*(x47)))+(x42))))));
IkReal x66=((x1)*(x3));
eetrans[2]=((IkReal(0.191500000000000))+(((x0)*(x19)))+(((IkReal(-0.00200000000000000))*(x28)))+(((x24)*(x66)))+(((IkReal(0.400000000000000))*(x0)))+(((x11)*(((((x21)*(x28)))+(((IkReal(-1.00000000000000))*(x22)*(x47)))))))+(((x7)*(((((IkReal(-1.00000000000000))*(x25)*(x66)))+(((IkReal(0.000500000000000000))*(x30)))))))+(((x10)*(((((IkReal(0.0570000000000000))*(x3)*(x32)))+(((IkReal(0.0570000000000000))*(x34)))))))+(((IkReal(-1.00000000000000))*(x20)*(x28))));
}

IKFAST_API int GetNumFreeParameters() { return 1; }
IKFAST_API int* GetFreeParameters() { static int freeparams[] = {0}; return freeparams; }
IKFAST_API int GetNumJoints() { return 7; }

IKFAST_API int GetIkRealSize() { return sizeof(IkReal); }

IKFAST_API int GetIkType() { return 0x67000001; }

class IKSolver {
public:
IkReal j1,cj1,sj1,htj1,j2,cj2,sj2,htj2,j3,cj3,sj3,htj3,j4,cj4,sj4,htj4,j5,cj5,sj5,htj5,j6,cj6,sj6,htj6,j0,cj0,sj0,htj0,new_r00,r00,rxp0_0,new_r01,r01,rxp0_1,new_r02,r02,rxp0_2,new_r10,r10,rxp1_0,new_r11,r11,rxp1_1,new_r12,r12,rxp1_2,new_r20,r20,rxp2_0,new_r21,r21,rxp2_1,new_r22,r22,rxp2_2,new_px,px,npx,new_py,py,npy,new_pz,pz,npz,pp;
unsigned char _ij1[2], _nj1,_ij2[2], _nj2,_ij3[2], _nj3,_ij4[2], _nj4,_ij5[2], _nj5,_ij6[2], _nj6,_ij0[2], _nj0;

bool ComputeIk(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions) {
j1=numeric_limits<IkReal>::quiet_NaN(); _ij1[0] = -1; _ij1[1] = -1; _nj1 = -1; j2=numeric_limits<IkReal>::quiet_NaN(); _ij2[0] = -1; _ij2[1] = -1; _nj2 = -1; j3=numeric_limits<IkReal>::quiet_NaN(); _ij3[0] = -1; _ij3[1] = -1; _nj3 = -1; j4=numeric_limits<IkReal>::quiet_NaN(); _ij4[0] = -1; _ij4[1] = -1; _nj4 = -1; j5=numeric_limits<IkReal>::quiet_NaN(); _ij5[0] = -1; _ij5[1] = -1; _nj5 = -1; j6=numeric_limits<IkReal>::quiet_NaN(); _ij6[0] = -1; _ij6[1] = -1; _nj6 = -1;  _ij0[0] = -1; _ij0[1] = -1; _nj0 = 0; 
for(int dummyiter = 0; dummyiter < 1; ++dummyiter) {
    solutions.Clear();
j0=pfree[0]; cj0=cos(pfree[0]); sj0=sin(pfree[0]);
r00 = eerot[0*3+0];
r01 = eerot[0*3+1];
r02 = eerot[0*3+2];
r10 = eerot[1*3+0];
r11 = eerot[1*3+1];
r12 = eerot[1*3+2];
r20 = eerot[2*3+0];
r21 = eerot[2*3+1];
r22 = eerot[2*3+2];
px = eetrans[0]; py = eetrans[1]; pz = eetrans[2];

IkReal x67=IKsin(j0);
IkReal x68=IKcos(j0);
new_r00=((((IkReal(0.296371615192129))*(r00)*(x67)))+(((IkReal(-0.955072701792072))*(r00)*(x68)))+(((IkReal(-0.296371615192129))*(r10)*(x68)))+(((IkReal(-0.955072701792072))*(r10)*(x67))));
IkReal x69=IKsin(j0);
IkReal x70=IKcos(j0);
new_r01=((((IkReal(0.296371615192129))*(r01)*(x69)))+(((IkReal(-0.955072701792072))*(r01)*(x70)))+(((IkReal(-0.955072701792072))*(r11)*(x69)))+(((IkReal(-0.296371615192129))*(r11)*(x70))));
IkReal x71=IKsin(j0);
IkReal x72=IKcos(j0);
new_r02=((((IkReal(-0.955072701792072))*(r12)*(x71)))+(((IkReal(0.296371615192129))*(r02)*(x71)))+(((IkReal(-0.955072701792072))*(r02)*(x72)))+(((IkReal(-0.296371615192129))*(r12)*(x72))));
IkReal x73=IKsin(j0);
IkReal x74=IKcos(j0);
new_px=((((IkReal(-0.0168931820659514))*(r02)*(x73)))+(((IkReal(0.0544391440021481))*(r02)*(x74)))+(((IkReal(0.296371615192129))*(px)*(x73)))+(((IkReal(0.0544391440021481))*(r12)*(x73)))+(((IkReal(0.0168931820659514))*(r12)*(x74)))+(((IkReal(-0.955072701792072))*(py)*(x73)))+(((IkReal(-0.955072701792072))*(px)*(x74)))+(((IkReal(-0.296371615192129))*(py)*(x74))));
new_r10=r20;
new_r11=r21;
new_r12=r22;
new_py=((IkReal(-0.191500000000000))+(pz)+(((IkReal(-0.0570000000000000))*(r22))));
IkReal x75=IKcos(j0);
IkReal x76=IKsin(j0);
new_r20=((((IkReal(-0.955072701792072))*(r00)*(x76)))+(((IkReal(-0.296371615192129))*(r00)*(x75)))+(((IkReal(-0.296371615192129))*(r10)*(x76)))+(((IkReal(0.955072701792072))*(r10)*(x75))));
IkReal x77=IKcos(j0);
IkReal x78=IKsin(j0);
new_r21=((((IkReal(-0.955072701792072))*(r01)*(x78)))+(((IkReal(0.955072701792072))*(r11)*(x77)))+(((IkReal(-0.296371615192129))*(r01)*(x77)))+(((IkReal(-0.296371615192129))*(r11)*(x78))));
IkReal x79=IKsin(j0);
IkReal x80=IKcos(j0);
new_r22=((((IkReal(0.955072701792072))*(r12)*(x80)))+(((IkReal(-0.296371615192129))*(r02)*(x80)))+(((IkReal(-0.955072701792072))*(r02)*(x79)))+(((IkReal(-0.296371615192129))*(r12)*(x79))));
IkReal x81=IKcos(j0);
IkReal x82=IKsin(j0);
new_pz=((IkReal(-0.00200000000000000))+(((IkReal(-0.0544391440021481))*(r12)*(x81)))+(((IkReal(0.0544391440021481))*(r02)*(x82)))+(((IkReal(0.955072701792072))*(py)*(x81)))+(((IkReal(-0.296371615192129))*(px)*(x81)))+(((IkReal(-0.955072701792072))*(px)*(x82)))+(((IkReal(0.0168931820659514))*(r02)*(x81)))+(((IkReal(0.0168931820659514))*(r12)*(x82)))+(((IkReal(-0.296371615192129))*(py)*(x82))));
r00 = new_r00; r01 = new_r01; r02 = new_r02; r10 = new_r10; r11 = new_r11; r12 = new_r12; r20 = new_r20; r21 = new_r21; r22 = new_r22; px = new_px; py = new_py; pz = new_pz;
pp=(((px)*(px))+((py)*(py))+((pz)*(pz)));
npx=((((px)*(r00)))+(((py)*(r10)))+(((pz)*(r20))));
npy=((((px)*(r01)))+(((py)*(r11)))+(((pz)*(r21))));
npz=((((px)*(r02)))+(((py)*(r12)))+(((pz)*(r22))));
rxp0_0=((((IkReal(-1.00000000000000))*(py)*(r20)))+(((pz)*(r10))));
rxp0_1=((((px)*(r20)))+(((IkReal(-1.00000000000000))*(pz)*(r00))));
rxp0_2=((((IkReal(-1.00000000000000))*(px)*(r10)))+(((py)*(r00))));
rxp1_0=((((IkReal(-1.00000000000000))*(py)*(r21)))+(((pz)*(r11))));
rxp1_1=((((px)*(r21)))+(((IkReal(-1.00000000000000))*(pz)*(r01))));
rxp1_2=((((IkReal(-1.00000000000000))*(px)*(r11)))+(((py)*(r01))));
rxp2_0=((((IkReal(-1.00000000000000))*(py)*(r22)))+(((pz)*(r12))));
rxp2_1=((((px)*(r22)))+(((IkReal(-1.00000000000000))*(pz)*(r02))));
rxp2_2=((((IkReal(-1.00000000000000))*(px)*(r12)))+(((py)*(r02))));
IkReal op[72], zeror[48];
int numroots;
IkReal x83=((IkReal(0.00100000000000000))*(npy));
IkReal x84=((IkReal(0.780000000000000))*(npz));
IkReal x85=((IkReal(0.00100000000000000))*(rxp0_0));
IkReal x86=((IkReal(0.780000000000000))*(px));
IkReal x87=((pp)*(r02));
IkReal x88=((IkReal(0.00789625000000000))*(r02));
IkReal x89=((IkReal(0.000400000000000000))*(r20));
IkReal x90=((IkReal(0.000390000000000000))*(r01));
IkReal x91=((IkReal(0.800000000000000))*(rxp2_2));
IkReal x92=((IkReal(0.00100000000000000))*(rxp0_1));
IkReal x93=((IkReal(0.780000000000000))*(py));
IkReal x94=((IkReal(0.00789625000000000))*(r12));
IkReal x95=((pp)*(r12));
IkReal x96=((IkReal(0.000390000000000000))*(r11));
IkReal x97=((IkReal(0.000780000000000000))*(r00));
IkReal x98=((IkReal(0.000800000000000000))*(r21));
IkReal x99=((IkReal(0.00200000000000000))*(rxp1_0));
IkReal x100=((IkReal(3.12000000000000))*(npy));
IkReal x101=((IkReal(1.56000000000000))*(npx));
IkReal x102=((IkReal(1.60000000000000))*(rxp0_2));
IkReal x103=((IkReal(0.00200000000000000))*(rxp2_0));
IkReal x104=((IkReal(0.000800000000000000))*(r22));
IkReal x105=((IkReal(0.0157925000000000))*(r00));
IkReal x106=((IkReal(0.00200000000000000))*(rxp2_1));
IkReal x107=((IkReal(0.0157925000000000))*(r10));
IkReal x108=((IkReal(0.0315850000000000))*(r01));
IkReal x109=((IkReal(3.20000000000000))*(rxp1_2));
IkReal x110=((IkReal(0.000780000000000000))*(r10));
IkReal x111=((IkReal(0.00200000000000000))*(rxp1_1));
IkReal x112=((IkReal(-0.00790375000000000))+(pp));
IkReal x113=((IkReal(8.00000000000000))*(npy));
IkReal x114=((IkReal(2.00000000000000))*(pp));
IkReal x115=((IkReal(4.00000000000000))*(npx));
IkReal x116=((IkReal(4.00000000000000))*(pp));
IkReal x117=((IkReal(2.00000000000000))*(npz));
IkReal x118=((IkReal(-0.00200000000000000))*(npx));
IkReal x119=((px)*(x117));
IkReal x120=((py)*(x117));
IkReal x121=((((IkReal(-1.00000000000000))*(x110)))+(x111));
IkReal x122=((IkReal(1.00000000000000))*(x87));
IkReal x123=((IkReal(-1.56000000000000))*(npx));
IkReal x124=((px)*(x115));
IkReal x125=((r00)*(x114));
IkReal x126=((py)*(x115));
IkReal x127=((r10)*(x114));
IkReal x128=((r01)*(x116));
IkReal x129=((px)*(x113));
IkReal x130=((IkReal(1.00000000000000))*(x95));
IkReal x131=((((IkReal(-1.00000000000000))*(x111)))+(((IkReal(-1.00000000000000))*(x110))));
IkReal x132=((x99)+(x97));
IkReal x133=((x89)+(x91));
IkReal x134=((x92)+(x96));
IkReal x135=((x89)+(x85));
IkReal x136=((x83)+(x84));
IkReal x137=((x86)+(x91));
IkReal x138=((x102)+(x103));
IkReal x139=((x88)+(x87));
IkReal x140=((x112)+(((IkReal(-1.00000000000000))*(x136))));
IkReal x141=((x112)+(x83)+(((IkReal(-1.00000000000000))*(x84))));
IkReal x142=((x112)+(x84)+(((IkReal(-1.00000000000000))*(x83))));
IkReal x143=((x119)+(x90));
IkReal x144=((x122)+(x88));
IkReal x145=((x124)+(x104));
IkReal x146=((x125)+(x105));
IkReal x147=((x127)+(x107));
IkReal x148=((x128)+(x108));
IkReal x149=((x130)+(x94));
IkReal x150=((x120)+(x93));
IkReal x151=((x136)+(x112));
IkReal x152=((x93)+(x95)+(x94));
IkReal x153=((((IkReal(-1.00000000000000))*(r11)*(x116)))+(((py)*(x113)))+(((IkReal(-0.0315850000000000))*(r11))));
IkReal x154=((x119)+(x86)+(x85));
IkReal x155=((((IkReal(-1.00000000000000))*(x126)))+(x147)+(x106));
IkReal x156=((((IkReal(-1.00000000000000))*(x147)))+(x126)+(x106));
IkReal x157=((((IkReal(-1.00000000000000))*(x120)))+(x152)+(((IkReal(-1.00000000000000))*(x134))));
IkReal x158=((((IkReal(-1.00000000000000))*(x120)))+(x152)+(x134));
IkReal x159=((((IkReal(-1.00000000000000))*(x149)))+(x150)+(x92)+(((IkReal(-1.00000000000000))*(x96))));
IkReal x160=((((IkReal(-1.00000000000000))*(x149)))+(x150)+(x96)+(((IkReal(-1.00000000000000))*(x92))));
op[0]=x140;
op[1]=IkReal(0);
op[2]=x118;
op[3]=IkReal(0);
op[4]=x141;
op[5]=IkReal(0);
op[6]=IkReal(0);
op[7]=x140;
op[8]=IkReal(0);
op[9]=x118;
op[10]=IkReal(0);
op[11]=x141;
op[12]=((((IkReal(-1.00000000000000))*(x143)))+(x139)+(((IkReal(-1.00000000000000))*(x133)))+(x86)+(((IkReal(-1.00000000000000))*(x85))));
op[13]=x157;
op[14]=((x99)+(x98)+(((IkReal(-1.00000000000000))*(x97))));
op[15]=x121;
op[16]=((((IkReal(-1.00000000000000))*(x119)))+(x135)+(x139)+(x86)+(x90)+(((IkReal(-1.00000000000000))*(x91))));
op[17]=x158;
op[18]=x157;
op[19]=((((IkReal(-1.00000000000000))*(x144)))+(x143)+(((IkReal(-1.00000000000000))*(x133)))+(x85)+(((IkReal(-1.00000000000000))*(x86))));
op[20]=x121;
op[21]=((x98)+(x97)+(((IkReal(-1.00000000000000))*(x99))));
op[22]=x158;
op[23]=((((IkReal(-1.00000000000000))*(x144)))+(x119)+(((IkReal(-1.00000000000000))*(x137)))+(x89)+(((IkReal(-1.00000000000000))*(x90)))+(((IkReal(-1.00000000000000))*(x85))));
op[24]=x123;
op[25]=IkReal(0);
op[26]=x100;
op[27]=IkReal(0);
op[28]=x101;
op[29]=IkReal(0);
op[30]=IkReal(0);
op[31]=x123;
op[32]=IkReal(0);
op[33]=x100;
op[34]=IkReal(0);
op[35]=x101;
op[36]=((((IkReal(-1.00000000000000))*(x102)))+(((IkReal(-1.00000000000000))*(x124)))+(x146)+(x104)+(x103));
op[37]=x155;
op[38]=((((IkReal(-1.00000000000000))*(x148)))+(x129)+(x109));
op[39]=x153;
op[40]=((((IkReal(-1.00000000000000))*(x146)))+(x145)+(x138));
op[41]=x156;
op[42]=x155;
op[43]=((((IkReal(-1.00000000000000))*(x146)))+(x145)+(((IkReal(-1.00000000000000))*(x138))));
op[44]=x153;
op[45]=((((IkReal(-1.00000000000000))*(x129)))+(x148)+(x109));
op[46]=x156;
op[47]=((((IkReal(-1.00000000000000))*(x103)))+(((IkReal(-1.00000000000000))*(x124)))+(x146)+(x104)+(x102));
op[48]=x142;
op[49]=IkReal(0);
op[50]=x118;
op[51]=IkReal(0);
op[52]=x151;
op[53]=IkReal(0);
op[54]=IkReal(0);
op[55]=x142;
op[56]=IkReal(0);
op[57]=x118;
op[58]=IkReal(0);
op[59]=x151;
op[60]=((((IkReal(-1.00000000000000))*(x144)))+(x154)+(x133)+(((IkReal(-1.00000000000000))*(x90))));
op[61]=x159;
op[62]=((((IkReal(-1.00000000000000))*(x132)))+(((IkReal(-1.00000000000000))*(x98))));
op[63]=x131;
op[64]=((((IkReal(-1.00000000000000))*(x144)))+(x143)+(x137)+(((IkReal(-1.00000000000000))*(x135))));
op[65]=x160;
op[66]=x159;
op[67]=((((IkReal(-1.00000000000000))*(x154)))+(x133)+(x139)+(x90));
op[68]=x131;
op[69]=((x132)+(((IkReal(-1.00000000000000))*(x98))));
op[70]=x160;
op[71]=((((IkReal(-1.00000000000000))*(x143)))+(x139)+(x85)+(x91)+(((IkReal(-1.00000000000000))*(x89)))+(((IkReal(-1.00000000000000))*(x86))));
solvedialyticpoly8qep(op,zeror,numroots);
IkReal j5array[16], cj5array[16], sj5array[16], j6array[16], cj6array[16], sj6array[16], j1array[16], cj1array[16], sj1array[16];
int numsolutions = 0;
for(int ij5 = 0; ij5 < numroots; ij5 += 3)
{
IkReal htj5 = zeror[ij5+0], htj6 = zeror[ij5+1], htj1 = zeror[ij5+2];
j5array[numsolutions]=((IkReal(2.00000000000000))*(atan(htj5)));
j6array[numsolutions]=((IkReal(2.00000000000000))*(atan(htj6)));
j1array[numsolutions]=((IkReal(2.00000000000000))*(atan(htj1)));
IkReal x161=(htj5)*(htj5);
IkReal x162=(htj6)*(htj6);
IkReal x163=(htj1)*(htj1);
cj5array[numsolutions]=((((IKabs(((IkReal(1.00000000000000))+(x161))) != 0)?((IkReal)1/(((IkReal(1.00000000000000))+(x161)))):(IkReal)1.0e30))*(((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x161))))));
cj6array[numsolutions]=((((IKabs(((IkReal(1.00000000000000))+(x162))) != 0)?((IkReal)1/(((IkReal(1.00000000000000))+(x162)))):(IkReal)1.0e30))*(((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x162))))));
cj1array[numsolutions]=((((IKabs(((IkReal(1.00000000000000))+(x163))) != 0)?((IkReal)1/(((IkReal(1.00000000000000))+(x163)))):(IkReal)1.0e30))*(((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x163))))));
sj5array[numsolutions]=((IkReal(2.00000000000000))*(htj5)*(((IKabs(((IkReal(1.00000000000000))+((htj5)*(htj5)))) != 0)?((IkReal)1/(((IkReal(1.00000000000000))+((htj5)*(htj5))))):(IkReal)1.0e30)));
sj6array[numsolutions]=((IkReal(2.00000000000000))*(htj6)*(((IKabs(((IkReal(1.00000000000000))+((htj6)*(htj6)))) != 0)?((IkReal)1/(((IkReal(1.00000000000000))+((htj6)*(htj6))))):(IkReal)1.0e30)));
sj1array[numsolutions]=((IkReal(2.00000000000000))*(htj1)*(((IKabs(((IkReal(1.00000000000000))+((htj1)*(htj1)))) != 0)?((IkReal)1/(((IkReal(1.00000000000000))+((htj1)*(htj1))))):(IkReal)1.0e30)));
if( j5array[numsolutions] > IKPI )
{
    j5array[numsolutions]-=IK2PI;
}
else if( j5array[numsolutions] < -IKPI )
{
    j5array[numsolutions]+=IK2PI;
}
if( j6array[numsolutions] > IKPI )
{
    j6array[numsolutions]-=IK2PI;
}
else if( j6array[numsolutions] < -IKPI )
{
    j6array[numsolutions]+=IK2PI;
}
if( j1array[numsolutions] > IKPI )
{
    j1array[numsolutions]-=IK2PI;
}
else if( j1array[numsolutions] < -IKPI )
{
    j1array[numsolutions]+=IK2PI;
}
numsolutions++;
}
bool j5valid[16]={true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true};
_nj5 = 16;
_nj6 = 1;
_nj1 = 1;
for(int ij5 = 0; ij5 < numsolutions; ++ij5)
    {
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
_ij6[0] = 0; _ij6[1] = -1;
_ij1[0] = 0; _ij1[1] = -1;
for(int iij5 = ij5+1; iij5 < numsolutions; ++iij5)
{
if( !j5valid[iij5] ) { continue; }
if( IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(cj6array[ij5]-cj6array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj6array[ij5]-sj6array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(cj1array[ij5]-cj1array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij5]-sj1array[iij5]) < IKFAST_SOLUTION_THRESH &&  1 )
{
    j5valid[iij5]=false; _ij5[1] = iij5; _ij6[1] = 0; _ij1[1] = 0;  break; 
}
}
    j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];

    j6 = j6array[ij5]; cj6 = cj6array[ij5]; sj6 = sj6array[ij5];

    j1 = j1array[ij5]; cj1 = cj1array[ij5]; sj1 = sj1array[ij5];

{
IkReal dummyeval[1];
dummyeval[0]=cj1;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=sj1;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[2];
IkReal x164=((IkReal(0.390000000000000))*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(3.14159265358979))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((IkReal(0.400000000000000))+(((IkReal(0.000500000000000000))*(cj6)*(r11)))+(((IkReal(-1.00000000000000))*(py)))+(((IkReal(0.000500000000000000))*(r10)*(sj6)))+(((cj6)*(r10)*(x164)))+(((IkReal(-1.00000000000000))*(r11)*(sj6)*(x164)))+(((IkReal(0.390000000000000))*(cj5)*(r12))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  )
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x165=((IkReal(0.250000000000000))*(cj6));
IkReal x166=((IkReal(195.000000000000))*(cj5));
IkReal x167=((IkReal(0.250000000000000))*(sj6));
IkReal x168=((IkReal(195.000000000000))*(sj5));
if( IKabs(((((r01)*(x165)))+(((r00)*(x167)))+(((IkReal(-1.00000000000000))*(r01)*(sj6)*(x168)))+(((IkReal(-500.000000000000))*(px)))+(((r02)*(x166)))+(((cj6)*(r00)*(x168))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((r22)*(x166)))+(((IkReal(-1.00000000000000))*(r21)*(sj6)*(x168)))+(((r20)*(x167)))+(((IkReal(-500.000000000000))*(pz)))+(((r21)*(x165)))+(((cj6)*(r20)*(x168))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((r01)*(x165)))+(((r00)*(x167)))+(((IkReal(-1.00000000000000))*(r01)*(sj6)*(x168)))+(((IkReal(-500.000000000000))*(px)))+(((r02)*(x166)))+(((cj6)*(r00)*(x168)))))+IKsqr(((((r22)*(x166)))+(((IkReal(-1.00000000000000))*(r21)*(sj6)*(x168)))+(((r20)*(x167)))+(((IkReal(-500.000000000000))*(pz)))+(((r21)*(x165)))+(((cj6)*(r20)*(x168)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((((r01)*(x165)))+(((r00)*(x167)))+(((IkReal(-1.00000000000000))*(r01)*(sj6)*(x168)))+(((IkReal(-500.000000000000))*(px)))+(((r02)*(x166)))+(((cj6)*(r00)*(x168)))), ((((r22)*(x166)))+(((IkReal(-1.00000000000000))*(r21)*(sj6)*(x168)))+(((r20)*(x167)))+(((IkReal(-500.000000000000))*(pz)))+(((r21)*(x165)))+(((cj6)*(r20)*(x168)))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[2];
IkReal x169=((IkReal(0.000500000000000000))*(cj6));
IkReal x170=((IkReal(0.390000000000000))*(sj5));
IkReal x171=((IkReal(0.390000000000000))*(cj5));
IkReal x172=((IkReal(0.000500000000000000))*(sj6));
evalcond[0]=((((r22)*(x171)))+(((IkReal(-1.00000000000000))*(r21)*(sj6)*(x170)))+(((IkReal(-0.00200000000000000))*(IKcos(j2))))+(((r20)*(x172)))+(((r21)*(x169)))+(((IkReal(-1.00000000000000))*(pz)))+(((cj6)*(r20)*(x170))));
evalcond[1]=((((r01)*(x169)))+(((r00)*(x172)))+(((IkReal(-1.00000000000000))*(r01)*(sj6)*(x170)))+(((IkReal(-0.00200000000000000))*(IKsin(j2))))+(((IkReal(-1.00000000000000))*(px)))+(((cj6)*(r00)*(x170)))+(((r02)*(x171))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst33;
IkReal x173=(cj6)*(cj6);
IkReal x174=(sj6)*(sj6);
IkReal x175=((r11)*(r20));
IkReal x176=((r12)*(sj5));
IkReal x177=((IkReal(1.00000000000000))*(r10));
IkReal x178=((r22)*(sj5));
IkReal x179=((cj5)*(x174));
IkReal x180=((cj5)*(x173));
gconst33=IKsign(((((r20)*(sj6)*(x176)))+(((IkReal(-1.00000000000000))*(r21)*(x177)*(x179)))+(((x175)*(x179)))+(((x175)*(x180)))+(((cj6)*(r21)*(x176)))+(((IkReal(-1.00000000000000))*(sj6)*(x177)*(x178)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x178)))+(((IkReal(-1.00000000000000))*(r21)*(x177)*(x180)))));
IkReal x181=(cj6)*(cj6);
IkReal x182=(sj6)*(sj6);
IkReal x183=((r11)*(r20));
IkReal x184=((r12)*(sj5));
IkReal x185=((IkReal(1.00000000000000))*(r10));
IkReal x186=((r22)*(sj5));
IkReal x187=((cj5)*(x182));
IkReal x188=((cj5)*(x181));
dummyeval[0]=((((IkReal(-1.00000000000000))*(sj6)*(x185)*(x186)))+(((r20)*(sj6)*(x184)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x186)))+(((cj6)*(r21)*(x184)))+(((IkReal(-1.00000000000000))*(r21)*(x185)*(x188)))+(((IkReal(-1.00000000000000))*(r21)*(x185)*(x187)))+(((x183)*(x187)))+(((x183)*(x188))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst34;
IkReal x189=(sj6)*(sj6);
IkReal x190=(cj6)*(cj6);
IkReal x191=((cj6)*(sj5));
IkReal x192=((r00)*(r11));
IkReal x193=((IkReal(1.00000000000000))*(r02));
IkReal x194=((sj5)*(sj6));
IkReal x195=((cj5)*(x189));
IkReal x196=((IkReal(1.00000000000000))*(r01)*(r10));
IkReal x197=((cj5)*(x190));
gconst34=IKsign(((((IkReal(-1.00000000000000))*(x196)*(x197)))+(((IkReal(-1.00000000000000))*(x195)*(x196)))+(((r00)*(r12)*(x194)))+(((r01)*(r12)*(x191)))+(((x192)*(x197)))+(((x192)*(x195)))+(((IkReal(-1.00000000000000))*(r10)*(x193)*(x194)))+(((IkReal(-1.00000000000000))*(r11)*(x191)*(x193)))));
IkReal x198=(sj6)*(sj6);
IkReal x199=(cj6)*(cj6);
IkReal x200=((cj6)*(sj5));
IkReal x201=((r00)*(r11));
IkReal x202=((IkReal(1.00000000000000))*(r02));
IkReal x203=((sj5)*(sj6));
IkReal x204=((cj5)*(x198));
IkReal x205=((IkReal(1.00000000000000))*(r01)*(r10));
IkReal x206=((cj5)*(x199));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x204)*(x205)))+(((IkReal(-1.00000000000000))*(r10)*(x202)*(x203)))+(((x201)*(x204)))+(((x201)*(x206)))+(((r01)*(r12)*(x200)))+(((IkReal(-1.00000000000000))*(r11)*(x200)*(x202)))+(((r00)*(r12)*(x203)))+(((IkReal(-1.00000000000000))*(x205)*(x206))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=cj2;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
IkReal x207=((IkReal(0.000500000000000000))*(cj6));
IkReal x208=((IkReal(0.000500000000000000))*(sj6));
IkReal x209=((sj5)*(sj6));
IkReal x210=((cj5)*(r02));
IkReal x211=((IkReal(0.390000000000000))*(cj5));
IkReal x212=((IkReal(0.390000000000000))*(cj6)*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((cj6)*(r00)*(sj5)))+(((IkReal(-1.00000000000000))*(r01)*(x209)))+(x210));
evalcond[2]=((((IkReal(-0.390000000000000))*(r21)*(x209)))+(((IkReal(-1.00000000000000))*(pz)))+(((r20)*(x208)))+(((r22)*(x211)))+(((r21)*(x207)))+(((r20)*(x212))));
evalcond[3]=((IkReal(-0.00200000000000000))+(((IkReal(-0.390000000000000))*(r01)*(x209)))+(((IkReal(0.390000000000000))*(x210)))+(((IkReal(-1.00000000000000))*(px)))+(((r01)*(x207)))+(((r00)*(x208)))+(((r00)*(x212))));
evalcond[4]=((IkReal(0.400000000000000))+(((r11)*(x207)))+(((r12)*(x211)))+(((IkReal(-1.00000000000000))*(py)))+(((r10)*(x208)))+(((r10)*(x212)))+(((IkReal(-0.390000000000000))*(r11)*(x209))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x213=((IkReal(1.00000000000000))*(sj5));
if( IKabs(((((IkReal(-1.00000000000000))*(cj6)*(r20)*(x213)))+(((r21)*(sj5)*(sj6)))+(((IkReal(-1.00000000000000))*(cj5)*(r22))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((cj5)*(r12)))+(((cj6)*(r10)*(sj5)))+(((IkReal(-1.00000000000000))*(r11)*(sj6)*(x213))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(cj6)*(r20)*(x213)))+(((r21)*(sj5)*(sj6)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))))+IKsqr(((((cj5)*(r12)))+(((cj6)*(r10)*(sj5)))+(((IkReal(-1.00000000000000))*(r11)*(sj6)*(x213)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(cj6)*(r20)*(x213)))+(((r21)*(sj5)*(sj6)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))), ((((cj5)*(r12)))+(((cj6)*(r10)*(sj5)))+(((IkReal(-1.00000000000000))*(r11)*(sj6)*(x213)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x214=((cj6)*(sj5));
IkReal x215=((IkReal(1.00000000000000))*(sj5)*(sj6));
evalcond[0]=((((cj5)*(r22)))+(IKsin(j3))+(((r20)*(x214)))+(((IkReal(-1.00000000000000))*(r21)*(x215))));
evalcond[1]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(r11)*(x215)))+(((IkReal(-1.00000000000000))*(IKcos(j3))))+(((r10)*(x214))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst39;
IkReal x216=(cj6)*(cj6);
IkReal x217=(sj6)*(sj6);
IkReal x218=((r01)*(r20));
IkReal x219=((r02)*(sj5));
IkReal x220=((cj5)*(x217));
IkReal x221=((IkReal(1.00000000000000))*(r22)*(sj5));
IkReal x222=((IkReal(1.00000000000000))*(r00)*(r21));
IkReal x223=((cj5)*(x216));
gconst39=IKsign(((((IkReal(-1.00000000000000))*(cj6)*(r01)*(x221)))+(((IkReal(-1.00000000000000))*(r00)*(sj6)*(x221)))+(((IkReal(-1.00000000000000))*(x222)*(x223)))+(((IkReal(-1.00000000000000))*(x220)*(x222)))+(((x218)*(x220)))+(((x218)*(x223)))+(((r20)*(sj6)*(x219)))+(((cj6)*(r21)*(x219)))));
IkReal x224=(cj6)*(cj6);
IkReal x225=(sj6)*(sj6);
IkReal x226=((r01)*(r20));
IkReal x227=((r02)*(sj5));
IkReal x228=((cj5)*(x225));
IkReal x229=((IkReal(1.00000000000000))*(r22)*(sj5));
IkReal x230=((IkReal(1.00000000000000))*(r00)*(r21));
IkReal x231=((cj5)*(x224));
dummyeval[0]=((((IkReal(-1.00000000000000))*(cj6)*(r01)*(x229)))+(((r20)*(sj6)*(x227)))+(((IkReal(-1.00000000000000))*(x230)*(x231)))+(((IkReal(-1.00000000000000))*(r00)*(sj6)*(x229)))+(((cj6)*(r21)*(x227)))+(((x226)*(x231)))+(((x226)*(x228)))+(((IkReal(-1.00000000000000))*(x228)*(x230))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst40;
IkReal x232=(cj6)*(cj6);
IkReal x233=(cj5)*(cj5);
IkReal x234=(r01)*(r01);
IkReal x235=(r00)*(r00);
IkReal x236=(sj6)*(sj6);
IkReal x237=((cj6)*(r00));
IkReal x238=((IkReal(2.00000000000000))*(r01)*(sj6));
IkReal x239=((cj5)*(r02)*(sj5));
gconst40=IKsign(((((IkReal(-2.00000000000000))*(x237)*(x239)))+(((x237)*(x238)))+(((x232)*(x234)))+((((r02)*(r02))*((sj5)*(sj5))))+(((x233)*(x234)*(x236)))+(((x235)*(x236)))+(((x238)*(x239)))+(((IkReal(-1.00000000000000))*(x233)*(x237)*(x238)))+(((x232)*(x233)*(x235)))));
IkReal x240=(cj6)*(cj6);
IkReal x241=(cj5)*(cj5);
IkReal x242=(r01)*(r01);
IkReal x243=(r00)*(r00);
IkReal x244=(sj6)*(sj6);
IkReal x245=((cj6)*(r00));
IkReal x246=((IkReal(2.00000000000000))*(r01)*(sj6));
IkReal x247=((cj5)*(r02)*(sj5));
dummyeval[0]=((((x240)*(x241)*(x243)))+(((x240)*(x242)))+((((r02)*(r02))*((sj5)*(sj5))))+(((x245)*(x246)))+(((x241)*(x242)*(x244)))+(((x246)*(x247)))+(((x243)*(x244)))+(((IkReal(-1.00000000000000))*(x241)*(x245)*(x246)))+(((IkReal(-2.00000000000000))*(x245)*(x247))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x248=((IkReal(1.00000000000000))*(r00));
if( IKabs(((gconst40)*(((((IkReal(-1.00000000000000))*(cj5)*(cj6)*(x248)))+(((cj5)*(r01)*(sj6)))+(((r02)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst40)*(((((IkReal(-1.00000000000000))*(sj6)*(x248)))+(((IkReal(-1.00000000000000))*(cj6)*(r01))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst40)*(((((IkReal(-1.00000000000000))*(cj5)*(cj6)*(x248)))+(((cj5)*(r01)*(sj6)))+(((r02)*(sj5)))))), ((gconst40)*(((((IkReal(-1.00000000000000))*(sj6)*(x248)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x249=IKsin(j4);
IkReal x250=IKcos(j4);
IkReal x251=((IkReal(1.00000000000000))*(r00));
IkReal x252=((cj5)*(r01));
IkReal x253=((cj5)*(r11));
IkReal x254=((IkReal(1.00000000000000))*(cj5));
IkReal x255=((cj5)*(r21));
IkReal x256=((sj5)*(x249));
IkReal x257=((cj6)*(x249));
IkReal x258=((sj6)*(x250));
IkReal x259=((sj6)*(x249));
IkReal x260=((sj5)*(x250));
IkReal x261=((cj6)*(x250));
evalcond[0]=((((IkReal(-1.00000000000000))*(r21)*(x261)))+(((IkReal(-1.00000000000000))*(r20)*(x254)*(x257)))+(((IkReal(-1.00000000000000))*(r20)*(x258)))+(((r22)*(x256)))+(((x255)*(x259))));
evalcond[1]=((((r21)*(x257)))+(((r20)*(x259)))+(((r22)*(x260)))+(((x255)*(x258)))+(((IkReal(-1.00000000000000))*(r20)*(x254)*(x261)))+(((IkReal(-1.00000000000000))*(cj3))));
evalcond[2]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(x251)*(x258)))+(((IkReal(-1.00000000000000))*(cj5)*(x251)*(x257)))+(((IkReal(-1.00000000000000))*(r01)*(x261)))+(((x252)*(x259)))+(((r02)*(x256))));
evalcond[3]=((((r12)*(x256)))+(((IkReal(-1.00000000000000))*(r10)*(x258)))+(((IkReal(-1.00000000000000))*(r11)*(x261)))+(((x253)*(x259)))+(((IkReal(-1.00000000000000))*(r10)*(x254)*(x257))));
evalcond[4]=((((r00)*(x259)))+(((r02)*(x260)))+(((r01)*(x257)))+(((x252)*(x258)))+(((IkReal(-1.00000000000000))*(cj5)*(x251)*(x261))));
evalcond[5]=((((IkReal(-1.00000000000000))*(sj3)))+(((r11)*(x257)))+(((r10)*(x259)))+(((IkReal(-1.00000000000000))*(r10)*(x254)*(x261)))+(((x253)*(x258)))+(((r12)*(x260))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x262=((cj3)*(sj6));
IkReal x263=((IkReal(1.00000000000000))*(r00));
IkReal x264=((cj3)*(cj6));
if( IKabs(((gconst39)*(((((IkReal(-1.00000000000000))*(cj5)*(x263)*(x264)))+(((cj5)*(r01)*(x262)))+(((cj3)*(r02)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst39)*(((((IkReal(-1.00000000000000))*(x262)*(x263)))+(((IkReal(-1.00000000000000))*(r01)*(x264))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst39)*(((((IkReal(-1.00000000000000))*(cj5)*(x263)*(x264)))+(((cj5)*(r01)*(x262)))+(((cj3)*(r02)*(sj5)))))), ((gconst39)*(((((IkReal(-1.00000000000000))*(x262)*(x263)))+(((IkReal(-1.00000000000000))*(r01)*(x264)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x265=IKsin(j4);
IkReal x266=IKcos(j4);
IkReal x267=((IkReal(1.00000000000000))*(r00));
IkReal x268=((cj5)*(r01));
IkReal x269=((cj5)*(r11));
IkReal x270=((IkReal(1.00000000000000))*(cj5));
IkReal x271=((cj5)*(r21));
IkReal x272=((sj5)*(x265));
IkReal x273=((cj6)*(x265));
IkReal x274=((sj6)*(x266));
IkReal x275=((sj6)*(x265));
IkReal x276=((sj5)*(x266));
IkReal x277=((cj6)*(x266));
evalcond[0]=((((x271)*(x275)))+(((IkReal(-1.00000000000000))*(r20)*(x270)*(x273)))+(((IkReal(-1.00000000000000))*(r20)*(x274)))+(((r22)*(x272)))+(((IkReal(-1.00000000000000))*(r21)*(x277))));
evalcond[1]=((((x271)*(x274)))+(((IkReal(-1.00000000000000))*(r20)*(x270)*(x277)))+(((r22)*(x276)))+(((r21)*(x273)))+(((r20)*(x275)))+(((IkReal(-1.00000000000000))*(cj3))));
evalcond[2]=((IkReal(-1.00000000000000))+(((r02)*(x272)))+(((IkReal(-1.00000000000000))*(cj5)*(x267)*(x273)))+(((IkReal(-1.00000000000000))*(r01)*(x277)))+(((IkReal(-1.00000000000000))*(x267)*(x274)))+(((x268)*(x275))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r10)*(x270)*(x273)))+(((IkReal(-1.00000000000000))*(r11)*(x277)))+(((r12)*(x272)))+(((IkReal(-1.00000000000000))*(r10)*(x274)))+(((x269)*(x275))));
evalcond[4]=((((r02)*(x276)))+(((IkReal(-1.00000000000000))*(cj5)*(x267)*(x277)))+(((r01)*(x273)))+(((r00)*(x275)))+(((x268)*(x274))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(x270)*(x277)))+(((IkReal(-1.00000000000000))*(sj3)))+(((r12)*(x276)))+(((r11)*(x273)))+(((x269)*(x274)))+(((r10)*(x275))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
IkReal x278=((IkReal(0.000500000000000000))*(cj6));
IkReal x279=((IkReal(0.000500000000000000))*(sj6));
IkReal x280=((sj5)*(sj6));
IkReal x281=((cj5)*(r02));
IkReal x282=((IkReal(0.390000000000000))*(cj5));
IkReal x283=((IkReal(0.390000000000000))*(cj6)*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((cj6)*(r00)*(sj5)))+(x281)+(((IkReal(-1.00000000000000))*(r01)*(x280))));
evalcond[2]=((((r22)*(x282)))+(((r21)*(x278)))+(((IkReal(-1.00000000000000))*(pz)))+(((IkReal(-0.390000000000000))*(r21)*(x280)))+(((r20)*(x279)))+(((r20)*(x283))));
evalcond[3]=((IkReal(0.00200000000000000))+(((r00)*(x283)))+(((IkReal(0.390000000000000))*(x281)))+(((IkReal(-1.00000000000000))*(px)))+(((r01)*(x278)))+(((r00)*(x279)))+(((IkReal(-0.390000000000000))*(r01)*(x280))));
evalcond[4]=((IkReal(0.400000000000000))+(((r10)*(x283)))+(((IkReal(-0.390000000000000))*(r11)*(x280)))+(((r12)*(x282)))+(((IkReal(-1.00000000000000))*(py)))+(((r11)*(x278)))+(((r10)*(x279))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x284=((cj6)*(sj5));
IkReal x285=((IkReal(1.00000000000000))*(sj5)*(sj6));
if( IKabs(((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(r21)*(x285)))+(((r20)*(x284))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((cj5)*(r12)))+(((r10)*(x284)))+(((IkReal(-1.00000000000000))*(r11)*(x285))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(r21)*(x285)))+(((r20)*(x284)))))+IKsqr(((((cj5)*(r12)))+(((r10)*(x284)))+(((IkReal(-1.00000000000000))*(r11)*(x285)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(r21)*(x285)))+(((r20)*(x284)))), ((((cj5)*(r12)))+(((r10)*(x284)))+(((IkReal(-1.00000000000000))*(r11)*(x285)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x286=((cj6)*(sj5));
IkReal x287=((IkReal(1.00000000000000))*(sj5)*(sj6));
evalcond[0]=((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(r21)*(x287)))+(((IkReal(-1.00000000000000))*(IKsin(j3))))+(((r20)*(x286))));
evalcond[1]=((((cj5)*(r12)))+(((r10)*(x286)))+(((IkReal(-1.00000000000000))*(r11)*(x287)))+(((IkReal(-1.00000000000000))*(IKcos(j3)))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst43;
IkReal x288=(sj6)*(sj6);
IkReal x289=(cj6)*(cj6);
IkReal x290=((IkReal(1.00000000000000))*(r20));
IkReal x291=((r00)*(r21));
IkReal x292=((r22)*(sj5));
IkReal x293=((r02)*(sj5));
IkReal x294=((cj5)*(x288));
IkReal x295=((cj5)*(x289));
gconst43=IKsign(((((x291)*(x294)))+(((x291)*(x295)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x293)))+(((IkReal(-1.00000000000000))*(sj6)*(x290)*(x293)))+(((IkReal(-1.00000000000000))*(r01)*(x290)*(x295)))+(((IkReal(-1.00000000000000))*(r01)*(x290)*(x294)))+(((cj6)*(r01)*(x292)))+(((r00)*(sj6)*(x292)))));
IkReal x296=(sj6)*(sj6);
IkReal x297=(cj6)*(cj6);
IkReal x298=((IkReal(1.00000000000000))*(r20));
IkReal x299=((r00)*(r21));
IkReal x300=((r22)*(sj5));
IkReal x301=((r02)*(sj5));
IkReal x302=((cj5)*(x296));
IkReal x303=((cj5)*(x297));
dummyeval[0]=((((IkReal(-1.00000000000000))*(r01)*(x298)*(x303)))+(((IkReal(-1.00000000000000))*(r01)*(x298)*(x302)))+(((r00)*(sj6)*(x300)))+(((x299)*(x302)))+(((x299)*(x303)))+(((cj6)*(r01)*(x300)))+(((IkReal(-1.00000000000000))*(sj6)*(x298)*(x301)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x301))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst44;
IkReal x304=(r20)*(r20);
IkReal x305=(cj5)*(cj5);
IkReal x306=(sj6)*(sj6);
IkReal x307=(cj6)*(cj6);
IkReal x308=(r21)*(r21);
IkReal x309=((cj6)*(r20));
IkReal x310=((IkReal(2.00000000000000))*(r21)*(sj6));
IkReal x311=((cj5)*(r22)*(sj5));
gconst44=IKsign(((((x310)*(x311)))+(((IkReal(-2.00000000000000))*(x309)*(x311)))+(((x309)*(x310)))+(((IkReal(-1.00000000000000))*(x305)*(x309)*(x310)))+(((x305)*(x306)*(x308)))+(((x304)*(x306)))+(((x304)*(x305)*(x307)))+(((x307)*(x308)))+((((r22)*(r22))*((sj5)*(sj5))))));
IkReal x312=(r20)*(r20);
IkReal x313=(cj5)*(cj5);
IkReal x314=(sj6)*(sj6);
IkReal x315=(cj6)*(cj6);
IkReal x316=(r21)*(r21);
IkReal x317=((cj6)*(r20));
IkReal x318=((IkReal(2.00000000000000))*(r21)*(sj6));
IkReal x319=((cj5)*(r22)*(sj5));
dummyeval[0]=((((x317)*(x318)))+(((x313)*(x314)*(x316)))+(((x312)*(x314)))+(((x315)*(x316)))+(((IkReal(-1.00000000000000))*(x313)*(x317)*(x318)))+(((x312)*(x313)*(x315)))+(((IkReal(-2.00000000000000))*(x317)*(x319)))+(((x318)*(x319)))+((((r22)*(r22))*((sj5)*(sj5)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x320=((cj3)*(cj6));
IkReal x321=((IkReal(1.00000000000000))*(r21));
IkReal x322=((cj3)*(sj6));
if( IKabs(((gconst44)*(((((IkReal(-1.00000000000000))*(x320)*(x321)))+(((IkReal(-1.00000000000000))*(r20)*(x322))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst44)*(((((IkReal(-1.00000000000000))*(cj3)*(r22)*(sj5)))+(((cj5)*(r20)*(x320)))+(((IkReal(-1.00000000000000))*(cj5)*(x321)*(x322))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst44)*(((((IkReal(-1.00000000000000))*(x320)*(x321)))+(((IkReal(-1.00000000000000))*(r20)*(x322)))))), ((gconst44)*(((((IkReal(-1.00000000000000))*(cj3)*(r22)*(sj5)))+(((cj5)*(r20)*(x320)))+(((IkReal(-1.00000000000000))*(cj5)*(x321)*(x322)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x323=IKsin(j4);
IkReal x324=IKcos(j4);
IkReal x325=((IkReal(1.00000000000000))*(r00));
IkReal x326=((cj5)*(r01));
IkReal x327=((cj5)*(r11));
IkReal x328=((IkReal(1.00000000000000))*(cj5));
IkReal x329=((cj5)*(r21));
IkReal x330=((sj5)*(x323));
IkReal x331=((cj6)*(x323));
IkReal x332=((sj6)*(x324));
IkReal x333=((sj6)*(x323));
IkReal x334=((sj5)*(x324));
IkReal x335=((cj6)*(x324));
evalcond[0]=((((r22)*(x330)))+(((IkReal(-1.00000000000000))*(r20)*(x332)))+(((IkReal(-1.00000000000000))*(r20)*(x328)*(x331)))+(((IkReal(-1.00000000000000))*(r21)*(x335)))+(((x329)*(x333))));
evalcond[1]=((((r22)*(x334)))+(cj3)+(((r21)*(x331)))+(((IkReal(-1.00000000000000))*(r20)*(x328)*(x335)))+(((r20)*(x333)))+(((x329)*(x332))));
evalcond[2]=((IkReal(1.00000000000000))+(((r02)*(x330)))+(((IkReal(-1.00000000000000))*(r01)*(x335)))+(((x326)*(x333)))+(((IkReal(-1.00000000000000))*(x325)*(x332)))+(((IkReal(-1.00000000000000))*(cj5)*(x325)*(x331))));
evalcond[3]=((((r12)*(x330)))+(((IkReal(-1.00000000000000))*(r11)*(x335)))+(((IkReal(-1.00000000000000))*(r10)*(x328)*(x331)))+(((x327)*(x333)))+(((IkReal(-1.00000000000000))*(r10)*(x332))));
evalcond[4]=((((r01)*(x331)))+(((r00)*(x333)))+(((r02)*(x334)))+(((x326)*(x332)))+(((IkReal(-1.00000000000000))*(cj5)*(x325)*(x335))));
evalcond[5]=((((r11)*(x331)))+(((IkReal(-1.00000000000000))*(sj3)))+(((r12)*(x334)))+(((IkReal(-1.00000000000000))*(r10)*(x328)*(x335)))+(((x327)*(x332)))+(((r10)*(x333))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x336=((cj3)*(sj6));
IkReal x337=((IkReal(1.00000000000000))*(r00));
IkReal x338=((cj3)*(cj6));
if( IKabs(((gconst43)*(((((cj5)*(r01)*(x336)))+(((cj3)*(r02)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(x337)*(x338))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst43)*(((((IkReal(-1.00000000000000))*(r01)*(x338)))+(((IkReal(-1.00000000000000))*(x336)*(x337))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst43)*(((((cj5)*(r01)*(x336)))+(((cj3)*(r02)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(x337)*(x338)))))), ((gconst43)*(((((IkReal(-1.00000000000000))*(r01)*(x338)))+(((IkReal(-1.00000000000000))*(x336)*(x337)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x339=IKsin(j4);
IkReal x340=IKcos(j4);
IkReal x341=((IkReal(1.00000000000000))*(r00));
IkReal x342=((cj5)*(r01));
IkReal x343=((cj5)*(r11));
IkReal x344=((IkReal(1.00000000000000))*(cj5));
IkReal x345=((cj5)*(r21));
IkReal x346=((sj5)*(x339));
IkReal x347=((cj6)*(x339));
IkReal x348=((sj6)*(x340));
IkReal x349=((sj6)*(x339));
IkReal x350=((sj5)*(x340));
IkReal x351=((cj6)*(x340));
evalcond[0]=((((IkReal(-1.00000000000000))*(r20)*(x344)*(x347)))+(((r22)*(x346)))+(((x345)*(x349)))+(((IkReal(-1.00000000000000))*(r21)*(x351)))+(((IkReal(-1.00000000000000))*(r20)*(x348))));
evalcond[1]=((((r21)*(x347)))+(cj3)+(((x345)*(x348)))+(((IkReal(-1.00000000000000))*(r20)*(x344)*(x351)))+(((r22)*(x350)))+(((r20)*(x349))));
evalcond[2]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(cj5)*(x341)*(x347)))+(((IkReal(-1.00000000000000))*(r01)*(x351)))+(((r02)*(x346)))+(((IkReal(-1.00000000000000))*(x341)*(x348)))+(((x342)*(x349))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r10)*(x344)*(x347)))+(((IkReal(-1.00000000000000))*(r10)*(x348)))+(((IkReal(-1.00000000000000))*(r11)*(x351)))+(((x343)*(x349)))+(((r12)*(x346))));
evalcond[4]=((((r01)*(x347)))+(((r00)*(x349)))+(((IkReal(-1.00000000000000))*(cj5)*(x341)*(x351)))+(((r02)*(x350)))+(((x342)*(x348))));
evalcond[5]=((((IkReal(-1.00000000000000))*(sj3)))+(((r12)*(x350)))+(((IkReal(-1.00000000000000))*(r10)*(x344)*(x351)))+(((r11)*(x347)))+(((x343)*(x348)))+(((r10)*(x349))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x352=((cj6)*(sj5));
IkReal x353=((IkReal(1.00000000000000))*(sj5)*(sj6));
if( IKabs(((((IKabs(cj2) != 0)?((IkReal)1/(cj2)):(IkReal)1.0e30))*(((((r00)*(x352)))+(((IkReal(-1.00000000000000))*(r01)*(x353)))+(((cj5)*(r02))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r11)*(x353)))+(((cj5)*(r12)))+(((r10)*(x352))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IKabs(cj2) != 0)?((IkReal)1/(cj2)):(IkReal)1.0e30))*(((((r00)*(x352)))+(((IkReal(-1.00000000000000))*(r01)*(x353)))+(((cj5)*(r02)))))))+IKsqr(((((IkReal(-1.00000000000000))*(r11)*(x353)))+(((cj5)*(r12)))+(((r10)*(x352)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IKabs(cj2) != 0)?((IkReal)1/(cj2)):(IkReal)1.0e30))*(((((r00)*(x352)))+(((IkReal(-1.00000000000000))*(r01)*(x353)))+(((cj5)*(r02)))))), ((((IkReal(-1.00000000000000))*(r11)*(x353)))+(((cj5)*(r12)))+(((r10)*(x352)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[3];
IkReal x354=IKsin(j3);
IkReal x355=((cj6)*(sj5));
IkReal x356=((IkReal(1.00000000000000))*(sj5)*(sj6));
evalcond[0]=((((cj5)*(r22)))+(((sj2)*(x354)))+(((IkReal(-1.00000000000000))*(r21)*(x356)))+(((r20)*(x355))));
evalcond[1]=((((IkReal(-1.00000000000000))*(cj2)*(x354)))+(((r00)*(x355)))+(((IkReal(-1.00000000000000))*(r01)*(x356)))+(((cj5)*(r02))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r11)*(x356)))+(((cj5)*(r12)))+(((r10)*(x355)))+(((IkReal(-1.00000000000000))*(IKcos(j3)))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst36;
IkReal x357=(cj5)*(cj5);
IkReal x358=(r11)*(r11);
IkReal x359=(sj6)*(sj6);
IkReal x360=(cj6)*(cj6);
IkReal x361=(r10)*(r10);
IkReal x362=((r11)*(sj6));
IkReal x363=((IkReal(1.00000000000000))*(x359));
IkReal x364=((IkReal(1.00000000000000))*(x360));
IkReal x365=((IkReal(2.00000000000000))*(cj6)*(r10));
IkReal x366=((cj5)*(r12)*(sj5));
gconst36=IKsign(((((IkReal(-1.00000000000000))*(x357)*(x358)*(x363)))+(((IkReal(-1.00000000000000))*(x362)*(x365)))+(((IkReal(-1.00000000000000))*(x361)*(x363)))+(((IkReal(-1.00000000000000))*((r12)*(r12))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x358)*(x364)))+(((IkReal(-2.00000000000000))*(x362)*(x366)))+(((x365)*(x366)))+(((IkReal(-1.00000000000000))*(x357)*(x361)*(x364)))+(((x357)*(x362)*(x365)))));
IkReal x367=(cj5)*(cj5);
IkReal x368=(r11)*(r11);
IkReal x369=(sj6)*(sj6);
IkReal x370=(cj6)*(cj6);
IkReal x371=(r10)*(r10);
IkReal x372=((r11)*(sj6));
IkReal x373=((IkReal(1.00000000000000))*(x369));
IkReal x374=((IkReal(1.00000000000000))*(x370));
IkReal x375=((IkReal(2.00000000000000))*(cj6)*(r10));
IkReal x376=((cj5)*(r12)*(sj5));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x368)*(x374)))+(((x375)*(x376)))+(((IkReal(-1.00000000000000))*(x372)*(x375)))+(((IkReal(-1.00000000000000))*((r12)*(r12))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x367)*(x371)*(x374)))+(((IkReal(-2.00000000000000))*(x372)*(x376)))+(((x367)*(x372)*(x375)))+(((IkReal(-1.00000000000000))*(x371)*(x373)))+(((IkReal(-1.00000000000000))*(x367)*(x368)*(x373))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst35;
IkReal x377=(sj6)*(sj6);
IkReal x378=(cj5)*(cj5);
IkReal x379=(cj6)*(cj6);
IkReal x380=((cj5)*(sj5));
IkReal x381=((cj6)*(r00));
IkReal x382=((r11)*(sj6));
IkReal x383=((r01)*(r11));
IkReal x384=((r01)*(sj6));
IkReal x385=((r00)*(r10));
IkReal x386=((IkReal(1.00000000000000))*(cj6)*(r10));
gconst35=IKsign(((((r02)*(x380)*(x382)))+(((x377)*(x385)))+(((IkReal(-1.00000000000000))*(x378)*(x384)*(x386)))+(((IkReal(-1.00000000000000))*(x378)*(x381)*(x382)))+(((cj6)*(r10)*(x384)))+(((x377)*(x378)*(x383)))+(((x378)*(x379)*(x385)))+(((r02)*(r12)*((sj5)*(sj5))))+(((x379)*(x383)))+(((r12)*(x380)*(x384)))+(((x381)*(x382)))+(((IkReal(-1.00000000000000))*(r02)*(x380)*(x386)))+(((IkReal(-1.00000000000000))*(r12)*(x380)*(x381)))));
IkReal x387=(sj6)*(sj6);
IkReal x388=(cj5)*(cj5);
IkReal x389=(cj6)*(cj6);
IkReal x390=((cj5)*(sj5));
IkReal x391=((cj6)*(r00));
IkReal x392=((r11)*(sj6));
IkReal x393=((r01)*(r11));
IkReal x394=((r01)*(sj6));
IkReal x395=((r00)*(r10));
IkReal x396=((IkReal(1.00000000000000))*(cj6)*(r10));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x388)*(x394)*(x396)))+(((IkReal(-1.00000000000000))*(r02)*(x390)*(x396)))+(((IkReal(-1.00000000000000))*(r12)*(x390)*(x391)))+(((x387)*(x388)*(x393)))+(((r02)*(r12)*((sj5)*(sj5))))+(((r02)*(x390)*(x392)))+(((x391)*(x392)))+(((cj6)*(r10)*(x394)))+(((x387)*(x395)))+(((r12)*(x390)*(x394)))+(((x389)*(x393)))+(((x388)*(x389)*(x395)))+(((IkReal(-1.00000000000000))*(x388)*(x391)*(x392))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x397=((IkReal(1.00000000000000))*(r11));
IkReal x398=((cj2)*(cj3)*(cj6));
IkReal x399=((cj2)*(cj3)*(sj6));
if( IKabs(((gconst35)*(((((IkReal(-1.00000000000000))*(x397)*(x398)))+(((IkReal(-1.00000000000000))*(r10)*(x399))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst35)*(((((IkReal(-1.00000000000000))*(cj2)*(cj3)*(r12)*(sj5)))+(((cj5)*(r10)*(x398)))+(((IkReal(-1.00000000000000))*(cj5)*(x397)*(x399))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst35)*(((((IkReal(-1.00000000000000))*(x397)*(x398)))+(((IkReal(-1.00000000000000))*(r10)*(x399)))))), ((gconst35)*(((((IkReal(-1.00000000000000))*(cj2)*(cj3)*(r12)*(sj5)))+(((cj5)*(r10)*(x398)))+(((IkReal(-1.00000000000000))*(cj5)*(x397)*(x399)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x400=IKsin(j4);
IkReal x401=IKcos(j4);
IkReal x402=((IkReal(1.00000000000000))*(r00));
IkReal x403=((cj5)*(r01));
IkReal x404=((cj5)*(r11));
IkReal x405=((IkReal(1.00000000000000))*(sj2));
IkReal x406=((IkReal(1.00000000000000))*(cj5));
IkReal x407=((cj5)*(r21));
IkReal x408=((sj5)*(x400));
IkReal x409=((cj6)*(x400));
IkReal x410=((sj6)*(x401));
IkReal x411=((sj6)*(x400));
IkReal x412=((sj5)*(x401));
IkReal x413=((cj6)*(x401));
evalcond[0]=((((x407)*(x411)))+(((r22)*(x408)))+(((IkReal(-1.00000000000000))*(r20)*(x410)))+(((IkReal(-1.00000000000000))*(r21)*(x413)))+(((IkReal(-1.00000000000000))*(r20)*(x406)*(x409)))+(((IkReal(-1.00000000000000))*(cj2))));
evalcond[1]=((((x407)*(x410)))+(((IkReal(-1.00000000000000))*(cj3)*(x405)))+(((r22)*(x412)))+(((r21)*(x409)))+(((r20)*(x411)))+(((IkReal(-1.00000000000000))*(r20)*(x406)*(x413))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r01)*(x413)))+(((IkReal(-1.00000000000000))*(cj5)*(x402)*(x409)))+(((IkReal(-1.00000000000000))*(x402)*(x410)))+(((x403)*(x411)))+(((IkReal(-1.00000000000000))*(x405)))+(((r02)*(x408))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r10)*(x410)))+(((x404)*(x411)))+(((r12)*(x408)))+(((IkReal(-1.00000000000000))*(r11)*(x413)))+(((IkReal(-1.00000000000000))*(r10)*(x406)*(x409))));
evalcond[4]=((((cj2)*(cj3)))+(((IkReal(-1.00000000000000))*(cj5)*(x402)*(x413)))+(((r01)*(x409)))+(((r00)*(x411)))+(((x403)*(x410)))+(((r02)*(x412))));
evalcond[5]=((((r11)*(x409)))+(((IkReal(-1.00000000000000))*(sj3)))+(((x404)*(x410)))+(((r12)*(x412)))+(((IkReal(-1.00000000000000))*(r10)*(x406)*(x413)))+(((r10)*(x411))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x414=((IkReal(1.00000000000000))*(sj3));
if( IKabs(((gconst36)*(((((IkReal(-1.00000000000000))*(cj6)*(r11)*(x414)))+(((IkReal(-1.00000000000000))*(r10)*(sj6)*(x414))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst36)*(((((IkReal(-1.00000000000000))*(r12)*(sj5)*(x414)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(sj6)*(x414)))+(((cj5)*(cj6)*(r10)*(sj3))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst36)*(((((IkReal(-1.00000000000000))*(cj6)*(r11)*(x414)))+(((IkReal(-1.00000000000000))*(r10)*(sj6)*(x414)))))), ((gconst36)*(((((IkReal(-1.00000000000000))*(r12)*(sj5)*(x414)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(sj6)*(x414)))+(((cj5)*(cj6)*(r10)*(sj3)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x415=IKsin(j4);
IkReal x416=IKcos(j4);
IkReal x417=((IkReal(1.00000000000000))*(r00));
IkReal x418=((cj5)*(r01));
IkReal x419=((cj5)*(r11));
IkReal x420=((IkReal(1.00000000000000))*(sj2));
IkReal x421=((IkReal(1.00000000000000))*(cj5));
IkReal x422=((cj5)*(r21));
IkReal x423=((sj5)*(x415));
IkReal x424=((cj6)*(x415));
IkReal x425=((sj6)*(x416));
IkReal x426=((sj6)*(x415));
IkReal x427=((sj5)*(x416));
IkReal x428=((cj6)*(x416));
evalcond[0]=((((IkReal(-1.00000000000000))*(r21)*(x428)))+(((IkReal(-1.00000000000000))*(r20)*(x425)))+(((r22)*(x423)))+(((IkReal(-1.00000000000000))*(r20)*(x421)*(x424)))+(((x422)*(x426)))+(((IkReal(-1.00000000000000))*(cj2))));
evalcond[1]=((((r20)*(x426)))+(((IkReal(-1.00000000000000))*(cj3)*(x420)))+(((r21)*(x424)))+(((r22)*(x427)))+(((IkReal(-1.00000000000000))*(r20)*(x421)*(x428)))+(((x422)*(x425))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x420)))+(((r02)*(x423)))+(((IkReal(-1.00000000000000))*(r01)*(x428)))+(((IkReal(-1.00000000000000))*(cj5)*(x417)*(x424)))+(((x418)*(x426)))+(((IkReal(-1.00000000000000))*(x417)*(x425))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r11)*(x428)))+(((x419)*(x426)))+(((IkReal(-1.00000000000000))*(r10)*(x421)*(x424)))+(((IkReal(-1.00000000000000))*(r10)*(x425)))+(((r12)*(x423))));
evalcond[4]=((((cj2)*(cj3)))+(((r02)*(x427)))+(((IkReal(-1.00000000000000))*(cj5)*(x417)*(x428)))+(((x418)*(x425)))+(((r00)*(x426)))+(((r01)*(x424))));
evalcond[5]=((((IkReal(-1.00000000000000))*(sj3)))+(((x419)*(x425)))+(((r10)*(x426)))+(((IkReal(-1.00000000000000))*(r10)*(x421)*(x428)))+(((r12)*(x427)))+(((r11)*(x424))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x429=((r10)*(sj2));
IkReal x430=((IkReal(1.00000000000000))*(sj6));
IkReal x431=((IkReal(1.00000000000000))*(sj2));
if( IKabs(((gconst34)*(((((IkReal(-1.00000000000000))*(x429)*(x430)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x431))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst34)*(((((IkReal(-1.00000000000000))*(r12)*(sj5)*(x431)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(sj2)*(x430)))+(((cj5)*(cj6)*(x429))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst34)*(((((IkReal(-1.00000000000000))*(x429)*(x430)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x431)))))), ((gconst34)*(((((IkReal(-1.00000000000000))*(r12)*(sj5)*(x431)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(sj2)*(x430)))+(((cj5)*(cj6)*(x429)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x432=IKsin(j4);
IkReal x433=IKcos(j4);
IkReal x434=((IkReal(1.00000000000000))*(cj6));
IkReal x435=((sj5)*(x432));
IkReal x436=((cj5)*(x432));
IkReal x437=((IkReal(1.00000000000000))*(sj6)*(x433));
evalcond[0]=((((r21)*(sj6)*(x436)))+(((IkReal(-1.00000000000000))*(r20)*(x434)*(x436)))+(((r22)*(x435)))+(((IkReal(-1.00000000000000))*(r20)*(x437)))+(((IkReal(-1.00000000000000))*(r21)*(x433)*(x434)))+(((IkReal(-1.00000000000000))*(cj2))));
evalcond[1]=((((IkReal(-1.00000000000000))*(sj2)))+(((IkReal(-1.00000000000000))*(r01)*(x433)*(x434)))+(((r02)*(x435)))+(((IkReal(-1.00000000000000))*(r00)*(x434)*(x436)))+(((r01)*(sj6)*(x436)))+(((IkReal(-1.00000000000000))*(r00)*(x437))));
evalcond[2]=((((r12)*(x435)))+(((IkReal(-1.00000000000000))*(r10)*(x437)))+(((IkReal(-1.00000000000000))*(r11)*(x433)*(x434)))+(((IkReal(-1.00000000000000))*(r10)*(x434)*(x436)))+(((r11)*(sj6)*(x436))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x438=((cj4)*(cj5));
IkReal x439=((r11)*(sj6));
IkReal x440=((cj6)*(r10));
if( IKabs(((((r10)*(sj4)*(sj6)))+(((cj6)*(r11)*(sj4)))+(((IkReal(-1.00000000000000))*(x438)*(x440)))+(((x438)*(x439)))+(((cj4)*(r12)*(sj5))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(sj5)*(x439)))+(((cj5)*(r12)))+(((sj5)*(x440))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((r10)*(sj4)*(sj6)))+(((cj6)*(r11)*(sj4)))+(((IkReal(-1.00000000000000))*(x438)*(x440)))+(((x438)*(x439)))+(((cj4)*(r12)*(sj5)))))+IKsqr(((((IkReal(-1.00000000000000))*(sj5)*(x439)))+(((cj5)*(r12)))+(((sj5)*(x440)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((r10)*(sj4)*(sj6)))+(((cj6)*(r11)*(sj4)))+(((IkReal(-1.00000000000000))*(x438)*(x440)))+(((x438)*(x439)))+(((cj4)*(r12)*(sj5)))), ((((IkReal(-1.00000000000000))*(sj5)*(x439)))+(((cj5)*(r12)))+(((sj5)*(x440)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x441=IKsin(j3);
IkReal x442=IKcos(j3);
IkReal x443=((r11)*(sj6));
IkReal x444=((IkReal(1.00000000000000))*(sj5));
IkReal x445=((cj6)*(sj4));
IkReal x446=((sj4)*(sj6));
IkReal x447=((cj4)*(sj5));
IkReal x448=((cj4)*(cj5));
IkReal x449=((r01)*(sj6));
IkReal x450=((r21)*(sj6));
IkReal x451=((cj6)*(sj5));
IkReal x452=((IkReal(1.00000000000000))*(x442));
IkReal x453=((IkReal(1.00000000000000))*(x441));
IkReal x454=((IkReal(1.00000000000000))*(cj6)*(x448));
evalcond[0]=((((cj5)*(r22)))+(((r20)*(x451)))+(((sj2)*(x441)))+(((IkReal(-1.00000000000000))*(x444)*(x450))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x444)*(x449)))+(((r00)*(x451)))+(((IkReal(-1.00000000000000))*(cj2)*(x453)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x443)*(x444)))+(((IkReal(-1.00000000000000))*(x452)))+(((r10)*(x451))));
evalcond[3]=((((r21)*(x445)))+(((IkReal(-1.00000000000000))*(sj2)*(x452)))+(((r22)*(x447)))+(((x448)*(x450)))+(((IkReal(-1.00000000000000))*(r20)*(x454)))+(((r20)*(x446))));
evalcond[4]=((((r02)*(x447)))+(((IkReal(-1.00000000000000))*(r00)*(x454)))+(((cj2)*(x442)))+(((r01)*(x445)))+(((r00)*(x446)))+(((x448)*(x449))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x453)))+(((IkReal(-1.00000000000000))*(r10)*(x454)))+(((x443)*(x448)))+(((r10)*(x446)))+(((r11)*(x445)))+(((r12)*(x447))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x455=((cj2)*(cj6));
IkReal x456=((IkReal(1.00000000000000))*(r11));
IkReal x457=((IkReal(1.00000000000000))*(cj2));
if( IKabs(((gconst33)*(((((IkReal(-1.00000000000000))*(x455)*(x456)))+(((IkReal(-1.00000000000000))*(r10)*(sj6)*(x457))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst33)*(((((cj5)*(r10)*(x455)))+(((IkReal(-1.00000000000000))*(cj2)*(cj5)*(sj6)*(x456)))+(((IkReal(-1.00000000000000))*(r12)*(sj5)*(x457))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst33)*(((((IkReal(-1.00000000000000))*(x455)*(x456)))+(((IkReal(-1.00000000000000))*(r10)*(sj6)*(x457)))))), ((gconst33)*(((((cj5)*(r10)*(x455)))+(((IkReal(-1.00000000000000))*(cj2)*(cj5)*(sj6)*(x456)))+(((IkReal(-1.00000000000000))*(r12)*(sj5)*(x457)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x458=IKsin(j4);
IkReal x459=IKcos(j4);
IkReal x460=((IkReal(1.00000000000000))*(cj6));
IkReal x461=((sj5)*(x458));
IkReal x462=((cj5)*(x458));
IkReal x463=((IkReal(1.00000000000000))*(sj6)*(x459));
evalcond[0]=((((r22)*(x461)))+(((r21)*(sj6)*(x462)))+(((IkReal(-1.00000000000000))*(r20)*(x460)*(x462)))+(((IkReal(-1.00000000000000))*(r20)*(x463)))+(((IkReal(-1.00000000000000))*(r21)*(x459)*(x460)))+(((IkReal(-1.00000000000000))*(cj2))));
evalcond[1]=((((IkReal(-1.00000000000000))*(sj2)))+(((IkReal(-1.00000000000000))*(r00)*(x463)))+(((r01)*(sj6)*(x462)))+(((IkReal(-1.00000000000000))*(r00)*(x460)*(x462)))+(((r02)*(x461)))+(((IkReal(-1.00000000000000))*(r01)*(x459)*(x460))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r11)*(x459)*(x460)))+(((r11)*(sj6)*(x462)))+(((r12)*(x461)))+(((IkReal(-1.00000000000000))*(r10)*(x463)))+(((IkReal(-1.00000000000000))*(r10)*(x460)*(x462))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x464=((cj4)*(cj5));
IkReal x465=((r11)*(sj6));
IkReal x466=((cj6)*(r10));
if( IKabs(((((r10)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(x464)*(x466)))+(((cj6)*(r11)*(sj4)))+(((x464)*(x465)))+(((cj4)*(r12)*(sj5))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(sj5)*(x465)))+(((sj5)*(x466))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((r10)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(x464)*(x466)))+(((cj6)*(r11)*(sj4)))+(((x464)*(x465)))+(((cj4)*(r12)*(sj5)))))+IKsqr(((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(sj5)*(x465)))+(((sj5)*(x466)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((r10)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(x464)*(x466)))+(((cj6)*(r11)*(sj4)))+(((x464)*(x465)))+(((cj4)*(r12)*(sj5)))), ((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(sj5)*(x465)))+(((sj5)*(x466)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x467=IKsin(j3);
IkReal x468=IKcos(j3);
IkReal x469=((r11)*(sj6));
IkReal x470=((IkReal(1.00000000000000))*(sj5));
IkReal x471=((cj6)*(sj4));
IkReal x472=((sj4)*(sj6));
IkReal x473=((cj4)*(sj5));
IkReal x474=((cj4)*(cj5));
IkReal x475=((r01)*(sj6));
IkReal x476=((r21)*(sj6));
IkReal x477=((cj6)*(sj5));
IkReal x478=((IkReal(1.00000000000000))*(x468));
IkReal x479=((IkReal(1.00000000000000))*(x467));
IkReal x480=((IkReal(1.00000000000000))*(cj6)*(x474));
evalcond[0]=((((cj5)*(r22)))+(((r20)*(x477)))+(((IkReal(-1.00000000000000))*(x470)*(x476)))+(((sj2)*(x467))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x470)*(x475)))+(((IkReal(-1.00000000000000))*(cj2)*(x479)))+(((r00)*(x477)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((r10)*(x477)))+(((IkReal(-1.00000000000000))*(x469)*(x470)))+(((IkReal(-1.00000000000000))*(x478))));
evalcond[3]=((((r21)*(x471)))+(((r20)*(x472)))+(((IkReal(-1.00000000000000))*(sj2)*(x478)))+(((x474)*(x476)))+(((r22)*(x473)))+(((IkReal(-1.00000000000000))*(r20)*(x480))));
evalcond[4]=((((cj2)*(x468)))+(((r02)*(x473)))+(((x474)*(x475)))+(((r00)*(x472)))+(((r01)*(x471)))+(((IkReal(-1.00000000000000))*(r00)*(x480))));
evalcond[5]=((((r10)*(x472)))+(((x469)*(x474)))+(((IkReal(-1.00000000000000))*(x479)))+(((r11)*(x471)))+(((r12)*(x473)))+(((IkReal(-1.00000000000000))*(r10)*(x480))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
}
}

}

}
}
}

} else
{
IkReal x481=((IkReal(0.390000000000000))*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.11022302462516e-16))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((IkReal(-0.400000000000000))+(((IkReal(-1.00000000000000))*(r11)*(sj6)*(x481)))+(((IkReal(0.000500000000000000))*(cj6)*(r11)))+(((IkReal(-1.00000000000000))*(py)))+(((IkReal(0.000500000000000000))*(r10)*(sj6)))+(((cj6)*(r10)*(x481)))+(((IkReal(0.390000000000000))*(cj5)*(r12))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  )
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x482=((IkReal(0.250000000000000))*(cj6));
IkReal x483=((IkReal(195.000000000000))*(cj5));
IkReal x484=((IkReal(0.250000000000000))*(sj6));
IkReal x485=((IkReal(195.000000000000))*(sj5));
if( IKabs(((((r01)*(sj6)*(x485)))+(((IkReal(500.000000000000))*(px)))+(((IkReal(-1.00000000000000))*(cj6)*(r00)*(x485)))+(((IkReal(-1.00000000000000))*(r01)*(x482)))+(((IkReal(-1.00000000000000))*(r02)*(x483)))+(((IkReal(-1.00000000000000))*(r00)*(x484))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((cj6)*(r20)*(x485)))+(((r20)*(x484)))+(((IkReal(-500.000000000000))*(pz)))+(((r22)*(x483)))+(((r21)*(x482)))+(((IkReal(-1.00000000000000))*(r21)*(sj6)*(x485))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((r01)*(sj6)*(x485)))+(((IkReal(500.000000000000))*(px)))+(((IkReal(-1.00000000000000))*(cj6)*(r00)*(x485)))+(((IkReal(-1.00000000000000))*(r01)*(x482)))+(((IkReal(-1.00000000000000))*(r02)*(x483)))+(((IkReal(-1.00000000000000))*(r00)*(x484)))))+IKsqr(((((cj6)*(r20)*(x485)))+(((r20)*(x484)))+(((IkReal(-500.000000000000))*(pz)))+(((r22)*(x483)))+(((r21)*(x482)))+(((IkReal(-1.00000000000000))*(r21)*(sj6)*(x485)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((((r01)*(sj6)*(x485)))+(((IkReal(500.000000000000))*(px)))+(((IkReal(-1.00000000000000))*(cj6)*(r00)*(x485)))+(((IkReal(-1.00000000000000))*(r01)*(x482)))+(((IkReal(-1.00000000000000))*(r02)*(x483)))+(((IkReal(-1.00000000000000))*(r00)*(x484)))), ((((cj6)*(r20)*(x485)))+(((r20)*(x484)))+(((IkReal(-500.000000000000))*(pz)))+(((r22)*(x483)))+(((r21)*(x482)))+(((IkReal(-1.00000000000000))*(r21)*(sj6)*(x485)))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[2];
IkReal x486=((IkReal(0.000500000000000000))*(cj6));
IkReal x487=((IkReal(0.390000000000000))*(sj5));
IkReal x488=((IkReal(0.390000000000000))*(cj5));
IkReal x489=((IkReal(0.000500000000000000))*(sj6));
evalcond[0]=((((cj6)*(r20)*(x487)))+(((r20)*(x489)))+(((IkReal(-0.00200000000000000))*(IKcos(j2))))+(((IkReal(-1.00000000000000))*(pz)))+(((r22)*(x488)))+(((r21)*(x486)))+(((IkReal(-1.00000000000000))*(r21)*(sj6)*(x487))));
evalcond[1]=((((r02)*(x488)))+(((IkReal(-1.00000000000000))*(px)))+(((IkReal(0.00200000000000000))*(IKsin(j2))))+(((r01)*(x486)))+(((r00)*(x489)))+(((IkReal(-1.00000000000000))*(r01)*(sj6)*(x487)))+(((cj6)*(r00)*(x487))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst45;
IkReal x490=(sj6)*(sj6);
IkReal x491=(cj6)*(cj6);
IkReal x492=((r01)*(r10));
IkReal x493=((IkReal(1.00000000000000))*(r00));
IkReal x494=((r02)*(sj5));
IkReal x495=((r12)*(sj5));
IkReal x496=((cj5)*(x490));
IkReal x497=((cj5)*(x491));
gconst45=IKsign(((((IkReal(-1.00000000000000))*(sj6)*(x493)*(x495)))+(((IkReal(-1.00000000000000))*(r11)*(x493)*(x497)))+(((IkReal(-1.00000000000000))*(r11)*(x493)*(x496)))+(((r10)*(sj6)*(x494)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x495)))+(((cj6)*(r11)*(x494)))+(((x492)*(x497)))+(((x492)*(x496)))));
IkReal x498=(sj6)*(sj6);
IkReal x499=(cj6)*(cj6);
IkReal x500=((r01)*(r10));
IkReal x501=((IkReal(1.00000000000000))*(r00));
IkReal x502=((r02)*(sj5));
IkReal x503=((r12)*(sj5));
IkReal x504=((cj5)*(x498));
IkReal x505=((cj5)*(x499));
dummyeval[0]=((((x500)*(x505)))+(((x500)*(x504)))+(((r10)*(sj6)*(x502)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x503)))+(((IkReal(-1.00000000000000))*(sj6)*(x501)*(x503)))+(((IkReal(-1.00000000000000))*(r11)*(x501)*(x505)))+(((IkReal(-1.00000000000000))*(r11)*(x501)*(x504)))+(((cj6)*(r11)*(x502))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst46;
IkReal x506=(cj6)*(cj6);
IkReal x507=(sj6)*(sj6);
IkReal x508=((r11)*(r20));
IkReal x509=((r12)*(sj5));
IkReal x510=((IkReal(1.00000000000000))*(r10));
IkReal x511=((r22)*(sj5));
IkReal x512=((cj5)*(x507));
IkReal x513=((cj5)*(x506));
gconst46=IKsign(((((IkReal(-1.00000000000000))*(sj6)*(x510)*(x511)))+(((cj6)*(r21)*(x509)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x511)))+(((IkReal(-1.00000000000000))*(r21)*(x510)*(x512)))+(((IkReal(-1.00000000000000))*(r21)*(x510)*(x513)))+(((x508)*(x512)))+(((x508)*(x513)))+(((r20)*(sj6)*(x509)))));
IkReal x514=(cj6)*(cj6);
IkReal x515=(sj6)*(sj6);
IkReal x516=((r11)*(r20));
IkReal x517=((r12)*(sj5));
IkReal x518=((IkReal(1.00000000000000))*(r10));
IkReal x519=((r22)*(sj5));
IkReal x520=((cj5)*(x515));
IkReal x521=((cj5)*(x514));
dummyeval[0]=((((IkReal(-1.00000000000000))*(r21)*(x518)*(x520)))+(((IkReal(-1.00000000000000))*(r21)*(x518)*(x521)))+(((x516)*(x520)))+(((x516)*(x521)))+(((r20)*(sj6)*(x517)))+(((IkReal(-1.00000000000000))*(sj6)*(x518)*(x519)))+(((cj6)*(r21)*(x517)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x519))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=sj2;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
IkReal x522=((IkReal(0.000500000000000000))*(cj6));
IkReal x523=((IkReal(0.390000000000000))*(sj5));
IkReal x524=((cj6)*(r20));
IkReal x525=((IkReal(0.000500000000000000))*(sj6));
IkReal x526=((cj5)*(r22));
IkReal x527=((r21)*(sj6));
IkReal x528=((IkReal(0.390000000000000))*(cj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(3.14159265358979))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(sj5)*(x527)))+(((sj5)*(x524)))+(x526));
evalcond[2]=((IkReal(-0.00200000000000000))+(((r21)*(x522)))+(((r20)*(x525)))+(((IkReal(-1.00000000000000))*(x523)*(x527)))+(((IkReal(-1.00000000000000))*(pz)))+(((IkReal(0.390000000000000))*(x526)))+(((x523)*(x524))));
evalcond[3]=((((r02)*(x528)))+(((cj6)*(r00)*(x523)))+(((IkReal(-1.00000000000000))*(r01)*(sj6)*(x523)))+(((IkReal(-1.00000000000000))*(px)))+(((r01)*(x522)))+(((r00)*(x525))));
evalcond[4]=((IkReal(-0.400000000000000))+(((IkReal(-1.00000000000000))*(r11)*(sj6)*(x523)))+(((r11)*(x522)))+(((r12)*(x528)))+(((IkReal(-1.00000000000000))*(py)))+(((r10)*(x525)))+(((cj6)*(r10)*(x523))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x529=((IkReal(1.00000000000000))*(cj5));
IkReal x530=((sj5)*(sj6));
IkReal x531=((IkReal(1.00000000000000))*(cj6)*(sj5));
if( IKabs(((((IkReal(-1.00000000000000))*(r00)*(x531)))+(((IkReal(-1.00000000000000))*(r02)*(x529)))+(((r01)*(x530))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((r11)*(x530)))+(((IkReal(-1.00000000000000))*(r10)*(x531)))+(((IkReal(-1.00000000000000))*(r12)*(x529))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(r00)*(x531)))+(((IkReal(-1.00000000000000))*(r02)*(x529)))+(((r01)*(x530)))))+IKsqr(((((r11)*(x530)))+(((IkReal(-1.00000000000000))*(r10)*(x531)))+(((IkReal(-1.00000000000000))*(r12)*(x529)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(r00)*(x531)))+(((IkReal(-1.00000000000000))*(r02)*(x529)))+(((r01)*(x530)))), ((((r11)*(x530)))+(((IkReal(-1.00000000000000))*(r10)*(x531)))+(((IkReal(-1.00000000000000))*(r12)*(x529)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x532=((cj6)*(sj5));
IkReal x533=((IkReal(1.00000000000000))*(sj5)*(sj6));
evalcond[0]=((((IkReal(-1.00000000000000))*(r01)*(x533)))+(IKsin(j3))+(((r00)*(x532)))+(((cj5)*(r02))));
evalcond[1]=((((cj5)*(r12)))+(IKcos(j3))+(((r10)*(x532)))+(((IkReal(-1.00000000000000))*(r11)*(x533))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst51;
IkReal x534=(cj6)*(cj6);
IkReal x535=(sj6)*(sj6);
IkReal x536=((r11)*(r20));
IkReal x537=((r12)*(sj5));
IkReal x538=((IkReal(1.00000000000000))*(r10));
IkReal x539=((r22)*(sj5));
IkReal x540=((cj5)*(x535));
IkReal x541=((cj5)*(x534));
gconst51=IKsign(((((IkReal(-1.00000000000000))*(sj6)*(x538)*(x539)))+(((r20)*(sj6)*(x537)))+(((IkReal(-1.00000000000000))*(r21)*(x538)*(x541)))+(((IkReal(-1.00000000000000))*(r21)*(x538)*(x540)))+(((x536)*(x541)))+(((x536)*(x540)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x539)))+(((cj6)*(r21)*(x537)))));
IkReal x542=(cj6)*(cj6);
IkReal x543=(sj6)*(sj6);
IkReal x544=((r11)*(r20));
IkReal x545=((r12)*(sj5));
IkReal x546=((IkReal(1.00000000000000))*(r10));
IkReal x547=((r22)*(sj5));
IkReal x548=((cj5)*(x543));
IkReal x549=((cj5)*(x542));
dummyeval[0]=((((x544)*(x549)))+(((x544)*(x548)))+(((IkReal(-1.00000000000000))*(r21)*(x546)*(x548)))+(((IkReal(-1.00000000000000))*(r21)*(x546)*(x549)))+(((r20)*(sj6)*(x545)))+(((IkReal(-1.00000000000000))*(sj6)*(x546)*(x547)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x547)))+(((cj6)*(r21)*(x545))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst52;
IkReal x550=(r20)*(r20);
IkReal x551=(cj5)*(cj5);
IkReal x552=(sj6)*(sj6);
IkReal x553=(cj6)*(cj6);
IkReal x554=(r21)*(r21);
IkReal x555=((cj6)*(r20));
IkReal x556=((IkReal(2.00000000000000))*(r21)*(sj6));
IkReal x557=((cj5)*(r22)*(sj5));
gconst52=IKsign(((((x551)*(x552)*(x554)))+(((x550)*(x551)*(x553)))+(((IkReal(-1.00000000000000))*(x551)*(x555)*(x556)))+(((x555)*(x556)))+(((x550)*(x552)))+(((x556)*(x557)))+(((x553)*(x554)))+(((IkReal(-2.00000000000000))*(x555)*(x557)))+((((r22)*(r22))*((sj5)*(sj5))))));
IkReal x558=(r20)*(r20);
IkReal x559=(cj5)*(cj5);
IkReal x560=(sj6)*(sj6);
IkReal x561=(cj6)*(cj6);
IkReal x562=(r21)*(r21);
IkReal x563=((cj6)*(r20));
IkReal x564=((IkReal(2.00000000000000))*(r21)*(sj6));
IkReal x565=((cj5)*(r22)*(sj5));
dummyeval[0]=((((x558)*(x560)))+(((IkReal(-1.00000000000000))*(x559)*(x563)*(x564)))+(((x564)*(x565)))+(((x559)*(x560)*(x562)))+(((x563)*(x564)))+(((x561)*(x562)))+(((IkReal(-2.00000000000000))*(x563)*(x565)))+(((x558)*(x559)*(x561)))+((((r22)*(r22))*((sj5)*(sj5)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x566=((IkReal(1.00000000000000))*(r20));
if( IKabs(((gconst52)*(((((IkReal(-1.00000000000000))*(cj5)*(cj6)*(x566)))+(((cj5)*(r21)*(sj6)))+(((r22)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst52)*(((((IkReal(-1.00000000000000))*(sj6)*(x566)))+(((IkReal(-1.00000000000000))*(cj6)*(r21))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst52)*(((((IkReal(-1.00000000000000))*(cj5)*(cj6)*(x566)))+(((cj5)*(r21)*(sj6)))+(((r22)*(sj5)))))), ((gconst52)*(((((IkReal(-1.00000000000000))*(sj6)*(x566)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x567=IKsin(j4);
IkReal x568=IKcos(j4);
IkReal x569=((IkReal(1.00000000000000))*(r00));
IkReal x570=((cj5)*(r01));
IkReal x571=((cj5)*(r11));
IkReal x572=((IkReal(1.00000000000000))*(cj5));
IkReal x573=((cj5)*(r21));
IkReal x574=((sj5)*(x567));
IkReal x575=((cj6)*(x567));
IkReal x576=((sj6)*(x568));
IkReal x577=((sj6)*(x567));
IkReal x578=((sj5)*(x568));
IkReal x579=((cj6)*(x568));
evalcond[0]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(r20)*(x576)))+(((x573)*(x577)))+(((IkReal(-1.00000000000000))*(r20)*(x572)*(x575)))+(((IkReal(-1.00000000000000))*(r21)*(x579)))+(((r22)*(x574))));
evalcond[1]=((((r20)*(x577)))+(((x573)*(x576)))+(((IkReal(-1.00000000000000))*(r20)*(x572)*(x579)))+(((r21)*(x575)))+(((r22)*(x578))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x569)*(x576)))+(((IkReal(-1.00000000000000))*(cj5)*(x569)*(x575)))+(((r02)*(x574)))+(((x570)*(x577)))+(((IkReal(-1.00000000000000))*(r01)*(x579))));
evalcond[3]=((((x571)*(x577)))+(((r12)*(x574)))+(((IkReal(-1.00000000000000))*(r11)*(x579)))+(((IkReal(-1.00000000000000))*(r10)*(x572)*(x575)))+(((IkReal(-1.00000000000000))*(r10)*(x576))));
evalcond[4]=((((r01)*(x575)))+(((r00)*(x577)))+(((IkReal(-1.00000000000000))*(cj5)*(x569)*(x579)))+(((r02)*(x578)))+(((IkReal(-1.00000000000000))*(cj3)))+(((x570)*(x576))));
evalcond[5]=((((x571)*(x576)))+(((r12)*(x578)))+(sj3)+(((IkReal(-1.00000000000000))*(r10)*(x572)*(x579)))+(((r10)*(x577)))+(((r11)*(x575))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x580=((IkReal(1.00000000000000))*(sj3));
if( IKabs(((gconst51)*(((((cj5)*(r21)*(sj3)*(sj6)))+(((r22)*(sj3)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(cj6)*(r20)*(x580))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst51)*(((((IkReal(-1.00000000000000))*(r20)*(sj6)*(x580)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x580))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst51)*(((((cj5)*(r21)*(sj3)*(sj6)))+(((r22)*(sj3)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(cj6)*(r20)*(x580)))))), ((gconst51)*(((((IkReal(-1.00000000000000))*(r20)*(sj6)*(x580)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x580)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x581=IKsin(j4);
IkReal x582=IKcos(j4);
IkReal x583=((IkReal(1.00000000000000))*(r00));
IkReal x584=((cj5)*(r01));
IkReal x585=((cj5)*(r11));
IkReal x586=((IkReal(1.00000000000000))*(cj5));
IkReal x587=((cj5)*(r21));
IkReal x588=((sj5)*(x581));
IkReal x589=((cj6)*(x581));
IkReal x590=((sj6)*(x582));
IkReal x591=((sj6)*(x581));
IkReal x592=((sj5)*(x582));
IkReal x593=((cj6)*(x582));
evalcond[0]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(r20)*(x590)))+(((IkReal(-1.00000000000000))*(r20)*(x586)*(x589)))+(((IkReal(-1.00000000000000))*(r21)*(x593)))+(((r22)*(x588)))+(((x587)*(x591))));
evalcond[1]=((((r22)*(x592)))+(((IkReal(-1.00000000000000))*(r20)*(x586)*(x593)))+(((r20)*(x591)))+(((r21)*(x589)))+(((x587)*(x590))));
evalcond[2]=((((r02)*(x588)))+(((IkReal(-1.00000000000000))*(r01)*(x593)))+(((IkReal(-1.00000000000000))*(cj5)*(x583)*(x589)))+(((IkReal(-1.00000000000000))*(x583)*(x590)))+(((x584)*(x591))));
evalcond[3]=((((x585)*(x591)))+(((IkReal(-1.00000000000000))*(r10)*(x590)))+(((r12)*(x588)))+(((IkReal(-1.00000000000000))*(r10)*(x586)*(x589)))+(((IkReal(-1.00000000000000))*(r11)*(x593))));
evalcond[4]=((((r00)*(x591)))+(((r02)*(x592)))+(((x584)*(x590)))+(((r01)*(x589)))+(((IkReal(-1.00000000000000))*(cj5)*(x583)*(x593)))+(((IkReal(-1.00000000000000))*(cj3))));
evalcond[5]=((((x585)*(x590)))+(sj3)+(((r11)*(x589)))+(((IkReal(-1.00000000000000))*(r10)*(x586)*(x593)))+(((r12)*(x592)))+(((r10)*(x591))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
IkReal x594=((IkReal(0.000500000000000000))*(cj6));
IkReal x595=((IkReal(0.390000000000000))*(sj5));
IkReal x596=((cj6)*(r20));
IkReal x597=((IkReal(0.000500000000000000))*(sj6));
IkReal x598=((cj5)*(r22));
IkReal x599=((r21)*(sj6));
IkReal x600=((IkReal(0.390000000000000))*(cj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.11022302462516e-16))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(sj5)*(x599)))+(x598)+(((sj5)*(x596))));
evalcond[2]=((IkReal(0.00200000000000000))+(((x595)*(x596)))+(((IkReal(-1.00000000000000))*(pz)))+(((r21)*(x594)))+(((IkReal(-1.00000000000000))*(x595)*(x599)))+(((r20)*(x597)))+(((IkReal(0.390000000000000))*(x598))));
evalcond[3]=((((r01)*(x594)))+(((cj6)*(r00)*(x595)))+(((r00)*(x597)))+(((IkReal(-1.00000000000000))*(px)))+(((IkReal(-1.00000000000000))*(r01)*(sj6)*(x595)))+(((r02)*(x600))));
evalcond[4]=((IkReal(-0.400000000000000))+(((cj6)*(r10)*(x595)))+(((r12)*(x600)))+(((IkReal(-1.00000000000000))*(r11)*(sj6)*(x595)))+(((IkReal(-1.00000000000000))*(py)))+(((r11)*(x594)))+(((r10)*(x597))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x601=((IkReal(1.00000000000000))*(sj5));
if( IKabs(((((cj6)*(r00)*(sj5)))+(((IkReal(-1.00000000000000))*(r01)*(sj6)*(x601)))+(((cj5)*(r02))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(cj5)*(r12)))+(((IkReal(-1.00000000000000))*(cj6)*(r10)*(x601)))+(((r11)*(sj5)*(sj6))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((cj6)*(r00)*(sj5)))+(((IkReal(-1.00000000000000))*(r01)*(sj6)*(x601)))+(((cj5)*(r02)))))+IKsqr(((((IkReal(-1.00000000000000))*(cj5)*(r12)))+(((IkReal(-1.00000000000000))*(cj6)*(r10)*(x601)))+(((r11)*(sj5)*(sj6)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((cj6)*(r00)*(sj5)))+(((IkReal(-1.00000000000000))*(r01)*(sj6)*(x601)))+(((cj5)*(r02)))), ((((IkReal(-1.00000000000000))*(cj5)*(r12)))+(((IkReal(-1.00000000000000))*(cj6)*(r10)*(x601)))+(((r11)*(sj5)*(sj6)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x602=((cj6)*(sj5));
IkReal x603=((IkReal(1.00000000000000))*(sj5)*(sj6));
evalcond[0]=((((r00)*(x602)))+(((IkReal(-1.00000000000000))*(r01)*(x603)))+(((IkReal(-1.00000000000000))*(IKsin(j3))))+(((cj5)*(r02))));
evalcond[1]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(r11)*(x603)))+(IKcos(j3))+(((r10)*(x602))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst55;
IkReal x604=(cj6)*(cj6);
IkReal x605=(sj6)*(sj6);
IkReal x606=((r01)*(r20));
IkReal x607=((r02)*(sj5));
IkReal x608=((cj5)*(x605));
IkReal x609=((IkReal(1.00000000000000))*(r22)*(sj5));
IkReal x610=((IkReal(1.00000000000000))*(r00)*(r21));
IkReal x611=((cj5)*(x604));
gconst55=IKsign(((((IkReal(-1.00000000000000))*(x610)*(x611)))+(((r20)*(sj6)*(x607)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x609)))+(((IkReal(-1.00000000000000))*(r00)*(sj6)*(x609)))+(((x606)*(x608)))+(((x606)*(x611)))+(((cj6)*(r21)*(x607)))+(((IkReal(-1.00000000000000))*(x608)*(x610)))));
IkReal x612=(cj6)*(cj6);
IkReal x613=(sj6)*(sj6);
IkReal x614=((r01)*(r20));
IkReal x615=((r02)*(sj5));
IkReal x616=((cj5)*(x613));
IkReal x617=((IkReal(1.00000000000000))*(r22)*(sj5));
IkReal x618=((IkReal(1.00000000000000))*(r00)*(r21));
IkReal x619=((cj5)*(x612));
dummyeval[0]=((((IkReal(-1.00000000000000))*(cj6)*(r01)*(x617)))+(((IkReal(-1.00000000000000))*(x618)*(x619)))+(((r20)*(sj6)*(x615)))+(((cj6)*(r21)*(x615)))+(((IkReal(-1.00000000000000))*(r00)*(sj6)*(x617)))+(((x614)*(x619)))+(((x614)*(x616)))+(((IkReal(-1.00000000000000))*(x616)*(x618))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst56;
IkReal x620=(cj6)*(cj6);
IkReal x621=(sj6)*(sj6);
IkReal x622=((r11)*(r20));
IkReal x623=((r12)*(sj5));
IkReal x624=((IkReal(1.00000000000000))*(r10));
IkReal x625=((r22)*(sj5));
IkReal x626=((cj5)*(x621));
IkReal x627=((cj5)*(x620));
gconst56=IKsign(((((cj6)*(r21)*(x623)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x625)))+(((IkReal(-1.00000000000000))*(r21)*(x624)*(x627)))+(((IkReal(-1.00000000000000))*(r21)*(x624)*(x626)))+(((r20)*(sj6)*(x623)))+(((IkReal(-1.00000000000000))*(sj6)*(x624)*(x625)))+(((x622)*(x627)))+(((x622)*(x626)))));
IkReal x628=(cj6)*(cj6);
IkReal x629=(sj6)*(sj6);
IkReal x630=((r11)*(r20));
IkReal x631=((r12)*(sj5));
IkReal x632=((IkReal(1.00000000000000))*(r10));
IkReal x633=((r22)*(sj5));
IkReal x634=((cj5)*(x629));
IkReal x635=((cj5)*(x628));
dummyeval[0]=((((cj6)*(r21)*(x631)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x633)))+(((IkReal(-1.00000000000000))*(sj6)*(x632)*(x633)))+(((IkReal(-1.00000000000000))*(r21)*(x632)*(x634)))+(((IkReal(-1.00000000000000))*(r21)*(x632)*(x635)))+(((r20)*(sj6)*(x631)))+(((x630)*(x635)))+(((x630)*(x634))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x636=((IkReal(1.00000000000000))*(sj3));
if( IKabs(((gconst56)*(((((cj5)*(r21)*(sj3)*(sj6)))+(((r22)*(sj3)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(cj6)*(r20)*(x636))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst56)*(((((IkReal(-1.00000000000000))*(cj6)*(r21)*(x636)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x636))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst56)*(((((cj5)*(r21)*(sj3)*(sj6)))+(((r22)*(sj3)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(cj6)*(r20)*(x636)))))), ((gconst56)*(((((IkReal(-1.00000000000000))*(cj6)*(r21)*(x636)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x636)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x637=IKsin(j4);
IkReal x638=IKcos(j4);
IkReal x639=((IkReal(1.00000000000000))*(r00));
IkReal x640=((cj5)*(r01));
IkReal x641=((cj5)*(r11));
IkReal x642=((IkReal(1.00000000000000))*(cj5));
IkReal x643=((cj5)*(r21));
IkReal x644=((sj5)*(x637));
IkReal x645=((cj6)*(x637));
IkReal x646=((sj6)*(x638));
IkReal x647=((sj6)*(x637));
IkReal x648=((sj5)*(x638));
IkReal x649=((cj6)*(x638));
evalcond[0]=((IkReal(1.00000000000000))+(((x643)*(x647)))+(((IkReal(-1.00000000000000))*(r20)*(x642)*(x645)))+(((IkReal(-1.00000000000000))*(r20)*(x646)))+(((r22)*(x644)))+(((IkReal(-1.00000000000000))*(r21)*(x649))));
evalcond[1]=((((r20)*(x647)))+(((x643)*(x646)))+(((IkReal(-1.00000000000000))*(r20)*(x642)*(x649)))+(((r21)*(x645)))+(((r22)*(x648))));
evalcond[2]=((((IkReal(-1.00000000000000))*(cj5)*(x639)*(x645)))+(((IkReal(-1.00000000000000))*(x639)*(x646)))+(((x640)*(x647)))+(((r02)*(x644)))+(((IkReal(-1.00000000000000))*(r01)*(x649))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r10)*(x646)))+(((x641)*(x647)))+(((r12)*(x644)))+(((IkReal(-1.00000000000000))*(r10)*(x642)*(x645)))+(((IkReal(-1.00000000000000))*(r11)*(x649))));
evalcond[4]=((cj3)+(((IkReal(-1.00000000000000))*(cj5)*(x639)*(x649)))+(((x640)*(x646)))+(((r02)*(x648)))+(((r01)*(x645)))+(((r00)*(x647))));
evalcond[5]=((sj3)+(((x641)*(x646)))+(((r10)*(x647)))+(((r12)*(x648)))+(((IkReal(-1.00000000000000))*(r10)*(x642)*(x649)))+(((r11)*(x645))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x650=((cj3)*(r21));
IkReal x651=((IkReal(1.00000000000000))*(cj6));
IkReal x652=((cj3)*(r20));
if( IKabs(((gconst55)*(((((cj3)*(r22)*(sj5)))+(((cj5)*(sj6)*(x650)))+(((IkReal(-1.00000000000000))*(cj5)*(x651)*(x652))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst55)*(((((IkReal(-1.00000000000000))*(sj6)*(x652)))+(((IkReal(-1.00000000000000))*(x650)*(x651))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst55)*(((((cj3)*(r22)*(sj5)))+(((cj5)*(sj6)*(x650)))+(((IkReal(-1.00000000000000))*(cj5)*(x651)*(x652)))))), ((gconst55)*(((((IkReal(-1.00000000000000))*(sj6)*(x652)))+(((IkReal(-1.00000000000000))*(x650)*(x651)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x653=IKsin(j4);
IkReal x654=IKcos(j4);
IkReal x655=((IkReal(1.00000000000000))*(r00));
IkReal x656=((cj5)*(r01));
IkReal x657=((cj5)*(r11));
IkReal x658=((IkReal(1.00000000000000))*(cj5));
IkReal x659=((cj5)*(r21));
IkReal x660=((sj5)*(x653));
IkReal x661=((cj6)*(x653));
IkReal x662=((sj6)*(x654));
IkReal x663=((sj6)*(x653));
IkReal x664=((sj5)*(x654));
IkReal x665=((cj6)*(x654));
evalcond[0]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(r21)*(x665)))+(((IkReal(-1.00000000000000))*(r20)*(x662)))+(((x659)*(x663)))+(((IkReal(-1.00000000000000))*(r20)*(x658)*(x661)))+(((r22)*(x660))));
evalcond[1]=((((r20)*(x663)))+(((r21)*(x661)))+(((x659)*(x662)))+(((IkReal(-1.00000000000000))*(r20)*(x658)*(x665)))+(((r22)*(x664))));
evalcond[2]=((((IkReal(-1.00000000000000))*(cj5)*(x655)*(x661)))+(((x656)*(x663)))+(((r02)*(x660)))+(((IkReal(-1.00000000000000))*(x655)*(x662)))+(((IkReal(-1.00000000000000))*(r01)*(x665))));
evalcond[3]=((((x657)*(x663)))+(((IkReal(-1.00000000000000))*(r10)*(x662)))+(((IkReal(-1.00000000000000))*(r11)*(x665)))+(((IkReal(-1.00000000000000))*(r10)*(x658)*(x661)))+(((r12)*(x660))));
evalcond[4]=((((r01)*(x661)))+(((r00)*(x663)))+(cj3)+(((IkReal(-1.00000000000000))*(cj5)*(x655)*(x665)))+(((x656)*(x662)))+(((r02)*(x664))));
evalcond[5]=((sj3)+(((x657)*(x662)))+(((r11)*(x661)))+(((IkReal(-1.00000000000000))*(r10)*(x658)*(x665)))+(((r12)*(x664)))+(((r10)*(x663))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x666=((IkReal(1.00000000000000))*(cj5));
IkReal x667=((sj5)*(sj6));
IkReal x668=((IkReal(1.00000000000000))*(cj6)*(sj5));
if( IKabs(((((IKabs(sj2) != 0)?((IkReal)1/(sj2)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(r20)*(x668)))+(((IkReal(-1.00000000000000))*(r22)*(x666)))+(((r21)*(x667))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r10)*(x668)))+(((r11)*(x667)))+(((IkReal(-1.00000000000000))*(r12)*(x666))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IKabs(sj2) != 0)?((IkReal)1/(sj2)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(r20)*(x668)))+(((IkReal(-1.00000000000000))*(r22)*(x666)))+(((r21)*(x667)))))))+IKsqr(((((IkReal(-1.00000000000000))*(r10)*(x668)))+(((r11)*(x667)))+(((IkReal(-1.00000000000000))*(r12)*(x666)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IKabs(sj2) != 0)?((IkReal)1/(sj2)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(r20)*(x668)))+(((IkReal(-1.00000000000000))*(r22)*(x666)))+(((r21)*(x667)))))), ((((IkReal(-1.00000000000000))*(r10)*(x668)))+(((r11)*(x667)))+(((IkReal(-1.00000000000000))*(r12)*(x666)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[3];
IkReal x669=IKsin(j3);
IkReal x670=((cj6)*(sj5));
IkReal x671=((IkReal(1.00000000000000))*(sj5)*(sj6));
evalcond[0]=((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(r21)*(x671)))+(((r20)*(x670)))+(((sj2)*(x669))));
evalcond[1]=((((cj2)*(x669)))+(((r00)*(x670)))+(((IkReal(-1.00000000000000))*(r01)*(x671)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((r10)*(x670)))+(IKcos(j3))+(((IkReal(-1.00000000000000))*(r11)*(x671))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst47;
IkReal x672=(r11)*(r11);
IkReal x673=(cj5)*(cj5);
IkReal x674=(cj6)*(cj6);
IkReal x675=(r10)*(r10);
IkReal x676=(sj6)*(sj6);
IkReal x677=((IkReal(2.00000000000000))*(cj5)*(r12)*(sj5));
IkReal x678=((IkReal(2.00000000000000))*(cj6)*(r10)*(r11)*(sj6));
gconst47=IKsign(((((x673)*(x674)*(x675)))+(((x672)*(x674)))+(((IkReal(-1.00000000000000))*(cj6)*(r10)*(x677)))+(((r11)*(sj6)*(x677)))+(((x672)*(x673)*(x676)))+((((r12)*(r12))*((sj5)*(sj5))))+(x678)+(((x675)*(x676)))+(((IkReal(-1.00000000000000))*(x673)*(x678)))));
IkReal x679=(r11)*(r11);
IkReal x680=(cj5)*(cj5);
IkReal x681=(cj6)*(cj6);
IkReal x682=(r10)*(r10);
IkReal x683=(sj6)*(sj6);
IkReal x684=x677;
IkReal x685=x678;
dummyeval[0]=((((IkReal(-1.00000000000000))*(x680)*(x685)))+(((IkReal(-1.00000000000000))*(cj6)*(r10)*(x684)))+(((x682)*(x683)))+(((x679)*(x681)))+((((r12)*(r12))*((sj5)*(sj5))))+(((r11)*(sj6)*(x684)))+(x685)+(((x679)*(x680)*(x683)))+(((x680)*(x681)*(x682))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst48;
IkReal x686=(cj5)*(cj5);
IkReal x687=(sj6)*(sj6);
IkReal x688=(cj6)*(cj6);
IkReal x689=((IkReal(1.00000000000000))*(r00));
IkReal x690=((IkReal(1.00000000000000))*(r12));
IkReal x691=((cj6)*(sj6));
IkReal x692=((IkReal(1.00000000000000))*(r01));
IkReal x693=((cj5)*(sj5));
IkReal x694=((r10)*(x686));
IkReal x695=((r11)*(x686));
gconst48=IKsign(((((IkReal(-1.00000000000000))*(r11)*(x689)*(x691)))+(((IkReal(-1.00000000000000))*(r01)*(sj6)*(x690)*(x693)))+(((IkReal(-1.00000000000000))*(r10)*(x691)*(x692)))+(((IkReal(-1.00000000000000))*(r10)*(x687)*(x689)))+(((cj6)*(r00)*(r12)*(x693)))+(((r01)*(x691)*(x694)))+(((IkReal(-1.00000000000000))*(r11)*(x688)*(x692)))+(((IkReal(-1.00000000000000))*(r02)*(x690)*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(r02)*(r11)*(sj6)*(x693)))+(((cj6)*(r02)*(r10)*(x693)))+(((IkReal(-1.00000000000000))*(x687)*(x692)*(x695)))+(((IkReal(-1.00000000000000))*(x688)*(x689)*(x694)))+(((r00)*(x691)*(x695)))));
IkReal x696=(cj5)*(cj5);
IkReal x697=(sj6)*(sj6);
IkReal x698=(cj6)*(cj6);
IkReal x699=((IkReal(1.00000000000000))*(r00));
IkReal x700=((IkReal(1.00000000000000))*(r12));
IkReal x701=((cj6)*(sj6));
IkReal x702=((IkReal(1.00000000000000))*(r01));
IkReal x703=((cj5)*(sj5));
IkReal x704=((r10)*(x696));
IkReal x705=((r11)*(x696));
dummyeval[0]=((((IkReal(-1.00000000000000))*(r10)*(x697)*(x699)))+(((IkReal(-1.00000000000000))*(r10)*(x701)*(x702)))+(((IkReal(-1.00000000000000))*(x697)*(x702)*(x705)))+(((cj6)*(r00)*(r12)*(x703)))+(((IkReal(-1.00000000000000))*(r11)*(x699)*(x701)))+(((IkReal(-1.00000000000000))*(r02)*(r11)*(sj6)*(x703)))+(((IkReal(-1.00000000000000))*(r01)*(sj6)*(x700)*(x703)))+(((cj6)*(r02)*(r10)*(x703)))+(((r01)*(x701)*(x704)))+(((IkReal(-1.00000000000000))*(r11)*(x698)*(x702)))+(((IkReal(-1.00000000000000))*(r02)*(x700)*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x698)*(x699)*(x704)))+(((r00)*(x701)*(x705))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x706=((r00)*(sj3));
IkReal x707=((cj5)*(cj6));
IkReal x708=((r01)*(sj3));
IkReal x709=((cj5)*(sj6));
IkReal x710=((r11)*(sj2));
IkReal x711=((IkReal(1.00000000000000))*(r10)*(sj2));
if( IKabs(((gconst48)*(((((IkReal(-1.00000000000000))*(x707)*(x711)))+(((r12)*(sj2)*(sj5)))+(((x709)*(x710)))+(((cj6)*(x708)))+(((sj6)*(x706))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst48)*(((((IkReal(-1.00000000000000))*(x706)*(x707)))+(((r02)*(sj3)*(sj5)))+(((IkReal(-1.00000000000000))*(cj6)*(x710)))+(((IkReal(-1.00000000000000))*(sj6)*(x711)))+(((x708)*(x709))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst48)*(((((IkReal(-1.00000000000000))*(x707)*(x711)))+(((r12)*(sj2)*(sj5)))+(((x709)*(x710)))+(((cj6)*(x708)))+(((sj6)*(x706)))))), ((gconst48)*(((((IkReal(-1.00000000000000))*(x706)*(x707)))+(((r02)*(sj3)*(sj5)))+(((IkReal(-1.00000000000000))*(cj6)*(x710)))+(((IkReal(-1.00000000000000))*(sj6)*(x711)))+(((x708)*(x709)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x712=IKsin(j4);
IkReal x713=IKcos(j4);
IkReal x714=((IkReal(1.00000000000000))*(r00));
IkReal x715=((cj5)*(r01));
IkReal x716=((cj5)*(r11));
IkReal x717=((IkReal(1.00000000000000))*(cj3));
IkReal x718=((IkReal(1.00000000000000))*(cj5));
IkReal x719=((cj5)*(r21));
IkReal x720=((sj5)*(x712));
IkReal x721=((cj6)*(x712));
IkReal x722=((sj6)*(x713));
IkReal x723=((sj6)*(x712));
IkReal x724=((sj5)*(x713));
IkReal x725=((cj6)*(x713));
evalcond[0]=((((IkReal(-1.00000000000000))*(r21)*(x725)))+(((IkReal(-1.00000000000000))*(r20)*(x722)))+(((x719)*(x723)))+(((IkReal(-1.00000000000000))*(r20)*(x718)*(x721)))+(((r22)*(x720)))+(((IkReal(-1.00000000000000))*(cj2))));
evalcond[1]=((((r20)*(x723)))+(((x719)*(x722)))+(((r21)*(x721)))+(((IkReal(-1.00000000000000))*(r20)*(x718)*(x725)))+(((r22)*(x724)))+(((IkReal(-1.00000000000000))*(sj2)*(x717))));
evalcond[2]=((sj2)+(((IkReal(-1.00000000000000))*(cj5)*(x714)*(x721)))+(((IkReal(-1.00000000000000))*(r01)*(x725)))+(((r02)*(x720)))+(((IkReal(-1.00000000000000))*(x714)*(x722)))+(((x715)*(x723))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r11)*(x725)))+(((IkReal(-1.00000000000000))*(r10)*(x718)*(x721)))+(((IkReal(-1.00000000000000))*(r10)*(x722)))+(((x716)*(x723)))+(((r12)*(x720))));
evalcond[4]=((((IkReal(-1.00000000000000))*(cj5)*(x714)*(x725)))+(((r01)*(x721)))+(((IkReal(-1.00000000000000))*(cj2)*(x717)))+(((r00)*(x723)))+(((r02)*(x724)))+(((x715)*(x722))));
evalcond[5]=((((r10)*(x723)))+(sj3)+(((IkReal(-1.00000000000000))*(r10)*(x718)*(x725)))+(((r11)*(x721)))+(((x716)*(x722)))+(((r12)*(x724))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x726=((IkReal(1.00000000000000))*(sj3));
if( IKabs(((gconst47)*(((((IkReal(-1.00000000000000))*(cj6)*(r11)*(x726)))+(((IkReal(-1.00000000000000))*(r10)*(sj6)*(x726))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst47)*(((((IkReal(-1.00000000000000))*(cj5)*(r11)*(sj6)*(x726)))+(((IkReal(-1.00000000000000))*(r12)*(sj5)*(x726)))+(((cj5)*(cj6)*(r10)*(sj3))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst47)*(((((IkReal(-1.00000000000000))*(cj6)*(r11)*(x726)))+(((IkReal(-1.00000000000000))*(r10)*(sj6)*(x726)))))), ((gconst47)*(((((IkReal(-1.00000000000000))*(cj5)*(r11)*(sj6)*(x726)))+(((IkReal(-1.00000000000000))*(r12)*(sj5)*(x726)))+(((cj5)*(cj6)*(r10)*(sj3)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x727=IKsin(j4);
IkReal x728=IKcos(j4);
IkReal x729=((IkReal(1.00000000000000))*(r00));
IkReal x730=((cj5)*(r01));
IkReal x731=((cj5)*(r11));
IkReal x732=((IkReal(1.00000000000000))*(cj3));
IkReal x733=((IkReal(1.00000000000000))*(cj5));
IkReal x734=((cj5)*(r21));
IkReal x735=((sj5)*(x727));
IkReal x736=((cj6)*(x727));
IkReal x737=((sj6)*(x728));
IkReal x738=((sj6)*(x727));
IkReal x739=((sj5)*(x728));
IkReal x740=((cj6)*(x728));
evalcond[0]=((((IkReal(-1.00000000000000))*(r21)*(x740)))+(((IkReal(-1.00000000000000))*(r20)*(x733)*(x736)))+(((IkReal(-1.00000000000000))*(r20)*(x737)))+(((x734)*(x738)))+(((r22)*(x735)))+(((IkReal(-1.00000000000000))*(cj2))));
evalcond[1]=((((x734)*(x737)))+(((r20)*(x738)))+(((IkReal(-1.00000000000000))*(sj2)*(x732)))+(((r22)*(x739)))+(((r21)*(x736)))+(((IkReal(-1.00000000000000))*(r20)*(x733)*(x740))));
evalcond[2]=((sj2)+(((IkReal(-1.00000000000000))*(cj5)*(x729)*(x736)))+(((IkReal(-1.00000000000000))*(r01)*(x740)))+(((r02)*(x735)))+(((IkReal(-1.00000000000000))*(x729)*(x737)))+(((x730)*(x738))));
evalcond[3]=((((r12)*(x735)))+(((IkReal(-1.00000000000000))*(r10)*(x733)*(x736)))+(((x731)*(x738)))+(((IkReal(-1.00000000000000))*(r10)*(x737)))+(((IkReal(-1.00000000000000))*(r11)*(x740))));
evalcond[4]=((((IkReal(-1.00000000000000))*(cj2)*(x732)))+(((r00)*(x738)))+(((r01)*(x736)))+(((r02)*(x739)))+(((x730)*(x737)))+(((IkReal(-1.00000000000000))*(cj5)*(x729)*(x740))));
evalcond[5]=((((r12)*(x739)))+(((r10)*(x738)))+(((x731)*(x737)))+(sj3)+(((IkReal(-1.00000000000000))*(r10)*(x733)*(x740)))+(((r11)*(x736))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x741=((cj2)*(cj6));
IkReal x742=((IkReal(1.00000000000000))*(r11));
IkReal x743=((IkReal(1.00000000000000))*(cj2));
if( IKabs(((gconst46)*(((((IkReal(-1.00000000000000))*(x741)*(x742)))+(((IkReal(-1.00000000000000))*(r10)*(sj6)*(x743))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst46)*(((((cj5)*(r10)*(x741)))+(((IkReal(-1.00000000000000))*(r12)*(sj5)*(x743)))+(((IkReal(-1.00000000000000))*(cj2)*(cj5)*(sj6)*(x742))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst46)*(((((IkReal(-1.00000000000000))*(x741)*(x742)))+(((IkReal(-1.00000000000000))*(r10)*(sj6)*(x743)))))), ((gconst46)*(((((cj5)*(r10)*(x741)))+(((IkReal(-1.00000000000000))*(r12)*(sj5)*(x743)))+(((IkReal(-1.00000000000000))*(cj2)*(cj5)*(sj6)*(x742)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x744=IKsin(j4);
IkReal x745=IKcos(j4);
IkReal x746=((IkReal(1.00000000000000))*(cj6));
IkReal x747=((sj5)*(x744));
IkReal x748=((cj5)*(x744));
IkReal x749=((IkReal(1.00000000000000))*(sj6)*(x745));
evalcond[0]=((((IkReal(-1.00000000000000))*(r20)*(x749)))+(((r22)*(x747)))+(((r21)*(sj6)*(x748)))+(((IkReal(-1.00000000000000))*(r20)*(x746)*(x748)))+(((IkReal(-1.00000000000000))*(r21)*(x745)*(x746)))+(((IkReal(-1.00000000000000))*(cj2))));
evalcond[1]=((((r02)*(x747)))+(sj2)+(((IkReal(-1.00000000000000))*(r01)*(x745)*(x746)))+(((IkReal(-1.00000000000000))*(r00)*(x746)*(x748)))+(((IkReal(-1.00000000000000))*(r00)*(x749)))+(((r01)*(sj6)*(x748))));
evalcond[2]=((((r11)*(sj6)*(x748)))+(((IkReal(-1.00000000000000))*(r11)*(x745)*(x746)))+(((IkReal(-1.00000000000000))*(r10)*(x749)))+(((IkReal(-1.00000000000000))*(r10)*(x746)*(x748)))+(((r12)*(x747))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x750=((r11)*(sj6));
IkReal x751=((IkReal(1.00000000000000))*(r12));
IkReal x752=((IkReal(1.00000000000000))*(sj4));
IkReal x753=((cj6)*(r10));
IkReal x754=((cj4)*(cj5));
if( IKabs(((((IkReal(-1.00000000000000))*(r10)*(sj6)*(x752)))+(((IkReal(-1.00000000000000))*(x750)*(x754)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x752)))+(((IkReal(-1.00000000000000))*(cj4)*(sj5)*(x751)))+(((x753)*(x754))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(cj5)*(x751)))+(((sj5)*(x750)))+(((IkReal(-1.00000000000000))*(sj5)*(x753))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(r10)*(sj6)*(x752)))+(((IkReal(-1.00000000000000))*(x750)*(x754)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x752)))+(((IkReal(-1.00000000000000))*(cj4)*(sj5)*(x751)))+(((x753)*(x754)))))+IKsqr(((((IkReal(-1.00000000000000))*(cj5)*(x751)))+(((sj5)*(x750)))+(((IkReal(-1.00000000000000))*(sj5)*(x753)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(r10)*(sj6)*(x752)))+(((IkReal(-1.00000000000000))*(x750)*(x754)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x752)))+(((IkReal(-1.00000000000000))*(cj4)*(sj5)*(x751)))+(((x753)*(x754)))), ((((IkReal(-1.00000000000000))*(cj5)*(x751)))+(((sj5)*(x750)))+(((IkReal(-1.00000000000000))*(sj5)*(x753)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x755=IKsin(j3);
IkReal x756=IKcos(j3);
IkReal x757=((r11)*(sj6));
IkReal x758=((IkReal(1.00000000000000))*(sj5));
IkReal x759=((sj4)*(sj6));
IkReal x760=((cj4)*(sj5));
IkReal x761=((cj6)*(sj4));
IkReal x762=((cj4)*(cj5));
IkReal x763=((r01)*(sj6));
IkReal x764=((r21)*(sj6));
IkReal x765=((cj6)*(sj5));
IkReal x766=((IkReal(1.00000000000000))*(x756));
IkReal x767=((IkReal(1.00000000000000))*(cj6)*(x762));
evalcond[0]=((((IkReal(-1.00000000000000))*(x758)*(x764)))+(((cj5)*(r22)))+(((r20)*(x765)))+(((sj2)*(x755))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x758)*(x763)))+(((cj2)*(x755)))+(((r00)*(x765)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((r10)*(x765)))+(x756)+(((IkReal(-1.00000000000000))*(x757)*(x758))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r20)*(x767)))+(((r21)*(x761)))+(((x762)*(x764)))+(((r22)*(x760)))+(((r20)*(x759)))+(((IkReal(-1.00000000000000))*(sj2)*(x766))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r00)*(x767)))+(((IkReal(-1.00000000000000))*(cj2)*(x766)))+(((x762)*(x763)))+(((r00)*(x759)))+(((r02)*(x760)))+(((r01)*(x761))));
evalcond[5]=((((x757)*(x762)))+(((r10)*(x759)))+(((IkReal(-1.00000000000000))*(r10)*(x767)))+(((r12)*(x760)))+(x755)+(((r11)*(x761))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x768=((r10)*(sj2));
IkReal x769=((IkReal(1.00000000000000))*(sj6));
IkReal x770=((IkReal(1.00000000000000))*(sj2));
if( IKabs(((gconst45)*(((((IkReal(-1.00000000000000))*(x768)*(x769)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x770))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst45)*(((((IkReal(-1.00000000000000))*(cj5)*(r11)*(sj2)*(x769)))+(((cj5)*(cj6)*(x768)))+(((IkReal(-1.00000000000000))*(r12)*(sj5)*(x770))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst45)*(((((IkReal(-1.00000000000000))*(x768)*(x769)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x770)))))), ((gconst45)*(((((IkReal(-1.00000000000000))*(cj5)*(r11)*(sj2)*(x769)))+(((cj5)*(cj6)*(x768)))+(((IkReal(-1.00000000000000))*(r12)*(sj5)*(x770)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x771=IKsin(j4);
IkReal x772=IKcos(j4);
IkReal x773=((IkReal(1.00000000000000))*(cj6));
IkReal x774=((sj5)*(x771));
IkReal x775=((cj5)*(x771));
IkReal x776=((IkReal(1.00000000000000))*(sj6)*(x772));
evalcond[0]=((((IkReal(-1.00000000000000))*(r20)*(x773)*(x775)))+(((IkReal(-1.00000000000000))*(r20)*(x776)))+(((r22)*(x774)))+(((r21)*(sj6)*(x775)))+(((IkReal(-1.00000000000000))*(r21)*(x772)*(x773)))+(((IkReal(-1.00000000000000))*(cj2))));
evalcond[1]=((sj2)+(((IkReal(-1.00000000000000))*(r00)*(x776)))+(((IkReal(-1.00000000000000))*(r00)*(x773)*(x775)))+(((IkReal(-1.00000000000000))*(r01)*(x772)*(x773)))+(((r01)*(sj6)*(x775)))+(((r02)*(x774))));
evalcond[2]=((((r11)*(sj6)*(x775)))+(((IkReal(-1.00000000000000))*(r11)*(x772)*(x773)))+(((IkReal(-1.00000000000000))*(r10)*(x776)))+(((r12)*(x774)))+(((IkReal(-1.00000000000000))*(r10)*(x773)*(x775))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x777=((r11)*(sj6));
IkReal x778=((IkReal(1.00000000000000))*(r12));
IkReal x779=((IkReal(1.00000000000000))*(sj4));
IkReal x780=((cj6)*(r10));
IkReal x781=((cj4)*(cj5));
if( IKabs(((((IkReal(-1.00000000000000))*(r10)*(sj6)*(x779)))+(((IkReal(-1.00000000000000))*(cj4)*(sj5)*(x778)))+(((IkReal(-1.00000000000000))*(x777)*(x781)))+(((x780)*(x781)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x779))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(cj5)*(x778)))+(((IkReal(-1.00000000000000))*(sj5)*(x780)))+(((sj5)*(x777))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(r10)*(sj6)*(x779)))+(((IkReal(-1.00000000000000))*(cj4)*(sj5)*(x778)))+(((IkReal(-1.00000000000000))*(x777)*(x781)))+(((x780)*(x781)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x779)))))+IKsqr(((((IkReal(-1.00000000000000))*(cj5)*(x778)))+(((IkReal(-1.00000000000000))*(sj5)*(x780)))+(((sj5)*(x777)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(r10)*(sj6)*(x779)))+(((IkReal(-1.00000000000000))*(cj4)*(sj5)*(x778)))+(((IkReal(-1.00000000000000))*(x777)*(x781)))+(((x780)*(x781)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x779)))), ((((IkReal(-1.00000000000000))*(cj5)*(x778)))+(((IkReal(-1.00000000000000))*(sj5)*(x780)))+(((sj5)*(x777)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x782=IKsin(j3);
IkReal x783=IKcos(j3);
IkReal x784=((r11)*(sj6));
IkReal x785=((IkReal(1.00000000000000))*(sj5));
IkReal x786=((sj4)*(sj6));
IkReal x787=((cj4)*(sj5));
IkReal x788=((cj6)*(sj4));
IkReal x789=((cj4)*(cj5));
IkReal x790=((r01)*(sj6));
IkReal x791=((r21)*(sj6));
IkReal x792=((cj6)*(sj5));
IkReal x793=((IkReal(1.00000000000000))*(x783));
IkReal x794=((IkReal(1.00000000000000))*(cj6)*(x789));
evalcond[0]=((((sj2)*(x782)))+(((cj5)*(r22)))+(((r20)*(x792)))+(((IkReal(-1.00000000000000))*(x785)*(x791))));
evalcond[1]=((((r00)*(x792)))+(((IkReal(-1.00000000000000))*(x785)*(x790)))+(((cj2)*(x782)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((r10)*(x792)))+(((IkReal(-1.00000000000000))*(x784)*(x785)))+(x783));
evalcond[3]=((((r20)*(x786)))+(((IkReal(-1.00000000000000))*(r20)*(x794)))+(((r21)*(x788)))+(((r22)*(x787)))+(((IkReal(-1.00000000000000))*(sj2)*(x793)))+(((x789)*(x791))));
evalcond[4]=((((r00)*(x786)))+(((r01)*(x788)))+(((IkReal(-1.00000000000000))*(r00)*(x794)))+(((IkReal(-1.00000000000000))*(cj2)*(x793)))+(((r02)*(x787)))+(((x789)*(x790))));
evalcond[5]=((((r10)*(x786)))+(((x784)*(x789)))+(((IkReal(-1.00000000000000))*(r10)*(x794)))+(((r11)*(x788)))+(x782)+(((r12)*(x787))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
}
}

}

}
}
}

} else
{
IkReal x795=((IkReal(0.390000000000000))*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((IkReal(-0.400000000000000))+(((cj6)*(r00)*(x795)))+(((IkReal(0.000500000000000000))*(cj6)*(r01)))+(((IkReal(0.000500000000000000))*(r00)*(sj6)))+(((IkReal(-1.00000000000000))*(px)))+(((IkReal(-1.00000000000000))*(r01)*(sj6)*(x795)))+(((IkReal(0.390000000000000))*(cj5)*(r02))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  )
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x796=((IkReal(195.000000000000))*(sj5));
IkReal x797=((IkReal(195.000000000000))*(cj5));
IkReal x798=((IkReal(0.250000000000000))*(sj6));
IkReal x799=((IkReal(0.250000000000000))*(cj6));
if( IKabs(((((r10)*(x798)))+(((IkReal(-500.000000000000))*(py)))+(((IkReal(-1.00000000000000))*(r11)*(sj6)*(x796)))+(((r11)*(x799)))+(((cj6)*(r10)*(x796)))+(((r12)*(x797))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((r20)*(x798)))+(((cj6)*(r20)*(x796)))+(((IkReal(-500.000000000000))*(pz)))+(((r21)*(x799)))+(((r22)*(x797)))+(((IkReal(-1.00000000000000))*(r21)*(sj6)*(x796))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((r10)*(x798)))+(((IkReal(-500.000000000000))*(py)))+(((IkReal(-1.00000000000000))*(r11)*(sj6)*(x796)))+(((r11)*(x799)))+(((cj6)*(r10)*(x796)))+(((r12)*(x797)))))+IKsqr(((((r20)*(x798)))+(((cj6)*(r20)*(x796)))+(((IkReal(-500.000000000000))*(pz)))+(((r21)*(x799)))+(((r22)*(x797)))+(((IkReal(-1.00000000000000))*(r21)*(sj6)*(x796)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((((r10)*(x798)))+(((IkReal(-500.000000000000))*(py)))+(((IkReal(-1.00000000000000))*(r11)*(sj6)*(x796)))+(((r11)*(x799)))+(((cj6)*(r10)*(x796)))+(((r12)*(x797)))), ((((r20)*(x798)))+(((cj6)*(r20)*(x796)))+(((IkReal(-500.000000000000))*(pz)))+(((r21)*(x799)))+(((r22)*(x797)))+(((IkReal(-1.00000000000000))*(r21)*(sj6)*(x796)))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[2];
IkReal x800=((IkReal(0.000500000000000000))*(cj6));
IkReal x801=((IkReal(0.000500000000000000))*(sj6));
IkReal x802=((IkReal(0.390000000000000))*(cj5));
IkReal x803=((IkReal(0.390000000000000))*(sj5)*(sj6));
IkReal x804=((IkReal(0.390000000000000))*(cj6)*(sj5));
evalcond[0]=((((r21)*(x800)))+(((IkReal(-0.00200000000000000))*(IKcos(j2))))+(((r22)*(x802)))+(((IkReal(-1.00000000000000))*(r21)*(x803)))+(((IkReal(-1.00000000000000))*(pz)))+(((r20)*(x804)))+(((r20)*(x801))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r11)*(x803)))+(((r12)*(x802)))+(((IkReal(-0.00200000000000000))*(IKsin(j2))))+(((IkReal(-1.00000000000000))*(py)))+(((r11)*(x800)))+(((r10)*(x804)))+(((r10)*(x801))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst57;
IkReal x805=(cj6)*(cj6);
IkReal x806=(sj6)*(sj6);
IkReal x807=((r01)*(r20));
IkReal x808=((r02)*(sj5));
IkReal x809=((cj5)*(x806));
IkReal x810=((IkReal(1.00000000000000))*(r22)*(sj5));
IkReal x811=((IkReal(1.00000000000000))*(r00)*(r21));
IkReal x812=((cj5)*(x805));
gconst57=IKsign(((((cj6)*(r21)*(x808)))+(((IkReal(-1.00000000000000))*(x809)*(x811)))+(((IkReal(-1.00000000000000))*(x811)*(x812)))+(((r20)*(sj6)*(x808)))+(((IkReal(-1.00000000000000))*(r00)*(sj6)*(x810)))+(((x807)*(x812)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x810)))+(((x807)*(x809)))));
IkReal x813=(cj6)*(cj6);
IkReal x814=(sj6)*(sj6);
IkReal x815=((r01)*(r20));
IkReal x816=((r02)*(sj5));
IkReal x817=((cj5)*(x814));
IkReal x818=((IkReal(1.00000000000000))*(r22)*(sj5));
IkReal x819=((IkReal(1.00000000000000))*(r00)*(r21));
IkReal x820=((cj5)*(x813));
dummyeval[0]=((((x815)*(x817)))+(((x815)*(x820)))+(((IkReal(-1.00000000000000))*(x819)*(x820)))+(((IkReal(-1.00000000000000))*(x817)*(x819)))+(((IkReal(-1.00000000000000))*(r00)*(sj6)*(x818)))+(((cj6)*(r21)*(x816)))+(((r20)*(sj6)*(x816)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x818))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst58;
IkReal x821=(sj6)*(sj6);
IkReal x822=(cj6)*(cj6);
IkReal x823=((r01)*(r10));
IkReal x824=((IkReal(1.00000000000000))*(r00));
IkReal x825=((r02)*(sj5));
IkReal x826=((r12)*(sj5));
IkReal x827=((cj5)*(x821));
IkReal x828=((cj5)*(x822));
gconst58=IKsign(((((IkReal(-1.00000000000000))*(cj6)*(r01)*(x826)))+(((IkReal(-1.00000000000000))*(r11)*(x824)*(x827)))+(((IkReal(-1.00000000000000))*(r11)*(x824)*(x828)))+(((IkReal(-1.00000000000000))*(sj6)*(x824)*(x826)))+(((x823)*(x828)))+(((x823)*(x827)))+(((cj6)*(r11)*(x825)))+(((r10)*(sj6)*(x825)))));
IkReal x829=(sj6)*(sj6);
IkReal x830=(cj6)*(cj6);
IkReal x831=((r01)*(r10));
IkReal x832=((IkReal(1.00000000000000))*(r00));
IkReal x833=((r02)*(sj5));
IkReal x834=((r12)*(sj5));
IkReal x835=((cj5)*(x829));
IkReal x836=((cj5)*(x830));
dummyeval[0]=((((x831)*(x835)))+(((x831)*(x836)))+(((r10)*(sj6)*(x833)))+(((IkReal(-1.00000000000000))*(sj6)*(x832)*(x834)))+(((IkReal(-1.00000000000000))*(r11)*(x832)*(x836)))+(((IkReal(-1.00000000000000))*(r11)*(x832)*(x835)))+(((cj6)*(r11)*(x833)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x834))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=cj2;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
IkReal x837=((IkReal(0.000500000000000000))*(cj6));
IkReal x838=((IkReal(0.000500000000000000))*(sj6));
IkReal x839=((sj5)*(sj6));
IkReal x840=((cj5)*(r12));
IkReal x841=((IkReal(0.390000000000000))*(cj5));
IkReal x842=((IkReal(0.390000000000000))*(cj6)*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((cj6)*(r10)*(sj5)))+(((IkReal(-1.00000000000000))*(r11)*(x839)))+(x840));
evalcond[2]=((((r22)*(x841)))+(((IkReal(-0.390000000000000))*(r21)*(x839)))+(((r20)*(x842)))+(((r20)*(x838)))+(((IkReal(-1.00000000000000))*(pz)))+(((r21)*(x837))));
evalcond[3]=((IkReal(-0.400000000000000))+(((r02)*(x841)))+(((IkReal(-0.390000000000000))*(r01)*(x839)))+(((r00)*(x838)))+(((r00)*(x842)))+(((IkReal(-1.00000000000000))*(px)))+(((r01)*(x837))));
evalcond[4]=((IkReal(-0.00200000000000000))+(((IkReal(0.390000000000000))*(x840)))+(((r10)*(x838)))+(((IkReal(-1.00000000000000))*(py)))+(((r10)*(x842)))+(((r11)*(x837)))+(((IkReal(-0.390000000000000))*(r11)*(x839))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x843=((sj5)*(sj6));
IkReal x844=((IkReal(1.00000000000000))*(cj5));
IkReal x845=((IkReal(1.00000000000000))*(cj6)*(sj5));
if( IKabs(((((IkReal(-1.00000000000000))*(r20)*(x845)))+(((r21)*(x843)))+(((IkReal(-1.00000000000000))*(r22)*(x844))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r02)*(x844)))+(((r01)*(x843)))+(((IkReal(-1.00000000000000))*(r00)*(x845))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(r20)*(x845)))+(((r21)*(x843)))+(((IkReal(-1.00000000000000))*(r22)*(x844)))))+IKsqr(((((IkReal(-1.00000000000000))*(r02)*(x844)))+(((r01)*(x843)))+(((IkReal(-1.00000000000000))*(r00)*(x845)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(r20)*(x845)))+(((r21)*(x843)))+(((IkReal(-1.00000000000000))*(r22)*(x844)))), ((((IkReal(-1.00000000000000))*(r02)*(x844)))+(((r01)*(x843)))+(((IkReal(-1.00000000000000))*(r00)*(x845)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x846=((cj6)*(sj5));
IkReal x847=((IkReal(1.00000000000000))*(sj5)*(sj6));
evalcond[0]=((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(r21)*(x847)))+(((r20)*(x846)))+(IKsin(j3)));
evalcond[1]=((((r00)*(x846)))+(IKcos(j3))+(((IkReal(-1.00000000000000))*(r01)*(x847)))+(((cj5)*(r02))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst63;
IkReal x848=(sj6)*(sj6);
IkReal x849=(cj6)*(cj6);
IkReal x850=((r01)*(r10));
IkReal x851=((IkReal(1.00000000000000))*(r00));
IkReal x852=((r02)*(sj5));
IkReal x853=((r12)*(sj5));
IkReal x854=((cj5)*(x848));
IkReal x855=((cj5)*(x849));
gconst63=IKsign(((((x850)*(x855)))+(((x850)*(x854)))+(((IkReal(-1.00000000000000))*(sj6)*(x851)*(x853)))+(((cj6)*(r11)*(x852)))+(((IkReal(-1.00000000000000))*(r11)*(x851)*(x855)))+(((IkReal(-1.00000000000000))*(r11)*(x851)*(x854)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x853)))+(((r10)*(sj6)*(x852)))));
IkReal x856=(sj6)*(sj6);
IkReal x857=(cj6)*(cj6);
IkReal x858=((r01)*(r10));
IkReal x859=((IkReal(1.00000000000000))*(r00));
IkReal x860=((r02)*(sj5));
IkReal x861=((r12)*(sj5));
IkReal x862=((cj5)*(x856));
IkReal x863=((cj5)*(x857));
dummyeval[0]=((((cj6)*(r11)*(x860)))+(((IkReal(-1.00000000000000))*(r11)*(x859)*(x863)))+(((IkReal(-1.00000000000000))*(r11)*(x859)*(x862)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x861)))+(((x858)*(x863)))+(((x858)*(x862)))+(((r10)*(sj6)*(x860)))+(((IkReal(-1.00000000000000))*(sj6)*(x859)*(x861))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst64;
IkReal x864=(cj5)*(cj5);
IkReal x865=(sj6)*(sj6);
IkReal x866=(cj6)*(cj6);
IkReal x867=((r00)*(r20));
IkReal x868=((cj5)*(sj5));
IkReal x869=((r01)*(r21));
IkReal x870=((r21)*(sj6));
IkReal x871=((sj6)*(x868));
IkReal x872=((IkReal(1.00000000000000))*(cj6)*(r00));
IkReal x873=((cj6)*(r01)*(r20)*(sj6));
gconst64=IKsign(((((r02)*(x868)*(x870)))+(((IkReal(-1.00000000000000))*(cj6)*(r02)*(r20)*(x868)))+(((IkReal(-1.00000000000000))*(x864)*(x870)*(x872)))+(((x864)*(x866)*(x867)))+(((x866)*(x869)))+(((x864)*(x865)*(x869)))+(((r02)*(r22)*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x864)*(x873)))+(((cj6)*(r00)*(x870)))+(x873)+(((IkReal(-1.00000000000000))*(r22)*(x868)*(x872)))+(((x865)*(x867)))+(((r01)*(r22)*(x871)))));
IkReal x874=(cj5)*(cj5);
IkReal x875=(sj6)*(sj6);
IkReal x876=(cj6)*(cj6);
IkReal x877=((r00)*(r20));
IkReal x878=((cj5)*(sj5));
IkReal x879=((r01)*(r21));
IkReal x880=((r21)*(sj6));
IkReal x881=((sj6)*(x878));
IkReal x882=((IkReal(1.00000000000000))*(cj6)*(r00));
IkReal x883=x873;
dummyeval[0]=((((IkReal(-1.00000000000000))*(cj6)*(r02)*(r20)*(x878)))+(((x876)*(x879)))+(((x874)*(x876)*(x877)))+(((cj6)*(r00)*(x880)))+(((r02)*(x878)*(x880)))+(((x874)*(x875)*(x879)))+(((IkReal(-1.00000000000000))*(r22)*(x878)*(x882)))+(((r02)*(r22)*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x874)*(x883)))+(((x875)*(x877)))+(x883)+(((r01)*(r22)*(x881)))+(((IkReal(-1.00000000000000))*(x874)*(x880)*(x882))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x884=((IkReal(1.00000000000000))*(sj3));
if( IKabs(((gconst64)*(((((IkReal(-1.00000000000000))*(r20)*(sj6)*(x884)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x884))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst64)*(((((IkReal(-1.00000000000000))*(r22)*(sj5)*(x884)))+(((cj5)*(cj6)*(r20)*(sj3)))+(((IkReal(-1.00000000000000))*(cj5)*(r21)*(sj6)*(x884))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst64)*(((((IkReal(-1.00000000000000))*(r20)*(sj6)*(x884)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x884)))))), ((gconst64)*(((((IkReal(-1.00000000000000))*(r22)*(sj5)*(x884)))+(((cj5)*(cj6)*(r20)*(sj3)))+(((IkReal(-1.00000000000000))*(cj5)*(r21)*(sj6)*(x884)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x885=IKsin(j4);
IkReal x886=IKcos(j4);
IkReal x887=((IkReal(1.00000000000000))*(r00));
IkReal x888=((cj5)*(r01));
IkReal x889=((cj5)*(r11));
IkReal x890=((IkReal(1.00000000000000))*(cj5));
IkReal x891=((cj5)*(r21));
IkReal x892=((sj5)*(x885));
IkReal x893=((cj6)*(x885));
IkReal x894=((sj6)*(x886));
IkReal x895=((sj6)*(x885));
IkReal x896=((sj5)*(x886));
IkReal x897=((cj6)*(x886));
evalcond[0]=((((IkReal(-1.00000000000000))*(r20)*(x894)))+(((IkReal(-1.00000000000000))*(r21)*(x897)))+(((x891)*(x895)))+(((r22)*(x892)))+(((IkReal(-1.00000000000000))*(r20)*(x890)*(x893))));
evalcond[1]=((((r20)*(x895)))+(((r21)*(x893)))+(((x891)*(x894)))+(((r22)*(x896)))+(((IkReal(-1.00000000000000))*(r20)*(x890)*(x897)))+(((IkReal(-1.00000000000000))*(cj3))));
evalcond[2]=((((r02)*(x892)))+(((IkReal(-1.00000000000000))*(cj5)*(x887)*(x893)))+(((IkReal(-1.00000000000000))*(r01)*(x897)))+(((x888)*(x895)))+(((IkReal(-1.00000000000000))*(x887)*(x894))));
evalcond[3]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(r11)*(x897)))+(((IkReal(-1.00000000000000))*(r10)*(x890)*(x893)))+(((IkReal(-1.00000000000000))*(r10)*(x894)))+(((x889)*(x895)))+(((r12)*(x892))));
evalcond[4]=((((r02)*(x896)))+(sj3)+(((r01)*(x893)))+(((r00)*(x895)))+(((IkReal(-1.00000000000000))*(cj5)*(x887)*(x897)))+(((x888)*(x894))));
evalcond[5]=((((r11)*(x893)))+(((r10)*(x895)))+(((IkReal(-1.00000000000000))*(r10)*(x890)*(x897)))+(((x889)*(x894)))+(((r12)*(x896))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x898=((sj3)*(sj6));
IkReal x899=((IkReal(1.00000000000000))*(r10));
IkReal x900=((cj6)*(sj3));
if( IKabs(((gconst63)*(((((r12)*(sj3)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(x899)*(x900)))+(((cj5)*(r11)*(x898))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst63)*(((((IkReal(-1.00000000000000))*(x898)*(x899)))+(((IkReal(-1.00000000000000))*(r11)*(x900))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst63)*(((((r12)*(sj3)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(x899)*(x900)))+(((cj5)*(r11)*(x898)))))), ((gconst63)*(((((IkReal(-1.00000000000000))*(x898)*(x899)))+(((IkReal(-1.00000000000000))*(r11)*(x900)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x901=IKsin(j4);
IkReal x902=IKcos(j4);
IkReal x903=((IkReal(1.00000000000000))*(r00));
IkReal x904=((cj5)*(r01));
IkReal x905=((cj5)*(r11));
IkReal x906=((IkReal(1.00000000000000))*(cj5));
IkReal x907=((cj5)*(r21));
IkReal x908=((sj5)*(x901));
IkReal x909=((cj6)*(x901));
IkReal x910=((sj6)*(x902));
IkReal x911=((sj6)*(x901));
IkReal x912=((sj5)*(x902));
IkReal x913=((cj6)*(x902));
evalcond[0]=((((IkReal(-1.00000000000000))*(r20)*(x906)*(x909)))+(((IkReal(-1.00000000000000))*(r20)*(x910)))+(((r22)*(x908)))+(((x907)*(x911)))+(((IkReal(-1.00000000000000))*(r21)*(x913))));
evalcond[1]=((((r21)*(x909)))+(((r20)*(x911)))+(((x907)*(x910)))+(((r22)*(x912)))+(((IkReal(-1.00000000000000))*(r20)*(x906)*(x913)))+(((IkReal(-1.00000000000000))*(cj3))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r01)*(x913)))+(((IkReal(-1.00000000000000))*(cj5)*(x903)*(x909)))+(((r02)*(x908)))+(((x904)*(x911)))+(((IkReal(-1.00000000000000))*(x903)*(x910))));
evalcond[3]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(r10)*(x906)*(x909)))+(((IkReal(-1.00000000000000))*(r11)*(x913)))+(((IkReal(-1.00000000000000))*(r10)*(x910)))+(((r12)*(x908)))+(((x905)*(x911))));
evalcond[4]=((sj3)+(((r01)*(x909)))+(((IkReal(-1.00000000000000))*(cj5)*(x903)*(x913)))+(((r02)*(x912)))+(((x904)*(x910)))+(((r00)*(x911))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(x906)*(x913)))+(((r11)*(x909)))+(((r12)*(x912)))+(((r10)*(x911)))+(((x905)*(x910))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
IkReal x914=((IkReal(0.000500000000000000))*(cj6));
IkReal x915=((IkReal(0.000500000000000000))*(sj6));
IkReal x916=((sj5)*(sj6));
IkReal x917=((cj5)*(r12));
IkReal x918=((IkReal(0.390000000000000))*(cj5));
IkReal x919=((IkReal(0.390000000000000))*(cj6)*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((cj6)*(r10)*(sj5)))+(((IkReal(-1.00000000000000))*(r11)*(x916)))+(x917));
evalcond[2]=((((r20)*(x919)))+(((r20)*(x915)))+(((IkReal(-1.00000000000000))*(pz)))+(((r22)*(x918)))+(((r21)*(x914)))+(((IkReal(-0.390000000000000))*(r21)*(x916))));
evalcond[3]=((IkReal(-0.400000000000000))+(((IkReal(-0.390000000000000))*(r01)*(x916)))+(((r02)*(x918)))+(((IkReal(-1.00000000000000))*(px)))+(((r01)*(x914)))+(((r00)*(x915)))+(((r00)*(x919))));
evalcond[4]=((IkReal(0.00200000000000000))+(((r10)*(x915)))+(((r10)*(x919)))+(((r11)*(x914)))+(((IkReal(-1.00000000000000))*(py)))+(((IkReal(0.390000000000000))*(x917)))+(((IkReal(-0.390000000000000))*(r11)*(x916))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x920=((cj6)*(sj5));
IkReal x921=((sj5)*(sj6));
if( IKabs(((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(r21)*(x921)))+(((r20)*(x920))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((r01)*(x921)))+(((IkReal(-1.00000000000000))*(r00)*(x920)))+(((IkReal(-1.00000000000000))*(cj5)*(r02))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(r21)*(x921)))+(((r20)*(x920)))))+IKsqr(((((r01)*(x921)))+(((IkReal(-1.00000000000000))*(r00)*(x920)))+(((IkReal(-1.00000000000000))*(cj5)*(r02)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(r21)*(x921)))+(((r20)*(x920)))), ((((r01)*(x921)))+(((IkReal(-1.00000000000000))*(r00)*(x920)))+(((IkReal(-1.00000000000000))*(cj5)*(r02)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x922=((cj6)*(sj5));
IkReal x923=((IkReal(1.00000000000000))*(sj5)*(sj6));
evalcond[0]=((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(r21)*(x923)))+(((IkReal(-1.00000000000000))*(IKsin(j3))))+(((r20)*(x922))));
evalcond[1]=((IKcos(j3))+(((IkReal(-1.00000000000000))*(r01)*(x923)))+(((r00)*(x922)))+(((cj5)*(r02))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst67;
IkReal x924=(sj6)*(sj6);
IkReal x925=(cj6)*(cj6);
IkReal x926=((cj6)*(sj5));
IkReal x927=((r10)*(r21));
IkReal x928=((IkReal(1.00000000000000))*(r12));
IkReal x929=((sj5)*(sj6));
IkReal x930=((cj5)*(x925));
IkReal x931=((IkReal(1.00000000000000))*(r11)*(r20));
IkReal x932=((cj5)*(x924));
gconst67=IKsign(((((r11)*(r22)*(x926)))+(((IkReal(-1.00000000000000))*(x930)*(x931)))+(((r10)*(r22)*(x929)))+(((IkReal(-1.00000000000000))*(x931)*(x932)))+(((x927)*(x932)))+(((x927)*(x930)))+(((IkReal(-1.00000000000000))*(r21)*(x926)*(x928)))+(((IkReal(-1.00000000000000))*(r20)*(x928)*(x929)))));
IkReal x933=(sj6)*(sj6);
IkReal x934=(cj6)*(cj6);
IkReal x935=((cj6)*(sj5));
IkReal x936=((r10)*(r21));
IkReal x937=((IkReal(1.00000000000000))*(r12));
IkReal x938=((sj5)*(sj6));
IkReal x939=((cj5)*(x934));
IkReal x940=((IkReal(1.00000000000000))*(r11)*(r20));
IkReal x941=((cj5)*(x933));
dummyeval[0]=((((x936)*(x939)))+(((r11)*(r22)*(x935)))+(((r10)*(r22)*(x938)))+(((x936)*(x941)))+(((IkReal(-1.00000000000000))*(x939)*(x940)))+(((IkReal(-1.00000000000000))*(r20)*(x937)*(x938)))+(((IkReal(-1.00000000000000))*(r21)*(x935)*(x937)))+(((IkReal(-1.00000000000000))*(x940)*(x941))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst68;
IkReal x942=(sj6)*(sj6);
IkReal x943=(cj6)*(cj6);
IkReal x944=((r01)*(r10));
IkReal x945=((IkReal(1.00000000000000))*(r00));
IkReal x946=((r02)*(sj5));
IkReal x947=((r12)*(sj5));
IkReal x948=((cj5)*(x942));
IkReal x949=((cj5)*(x943));
gconst68=IKsign(((((IkReal(-1.00000000000000))*(cj6)*(r01)*(x947)))+(((IkReal(-1.00000000000000))*(r11)*(x945)*(x948)))+(((IkReal(-1.00000000000000))*(r11)*(x945)*(x949)))+(((r10)*(sj6)*(x946)))+(((IkReal(-1.00000000000000))*(sj6)*(x945)*(x947)))+(((cj6)*(r11)*(x946)))+(((x944)*(x949)))+(((x944)*(x948)))));
IkReal x950=(sj6)*(sj6);
IkReal x951=(cj6)*(cj6);
IkReal x952=((r01)*(r10));
IkReal x953=((IkReal(1.00000000000000))*(r00));
IkReal x954=((r02)*(sj5));
IkReal x955=((r12)*(sj5));
IkReal x956=((cj5)*(x950));
IkReal x957=((cj5)*(x951));
dummyeval[0]=((((IkReal(-1.00000000000000))*(r11)*(x953)*(x956)))+(((IkReal(-1.00000000000000))*(r11)*(x953)*(x957)))+(((x952)*(x957)))+(((x952)*(x956)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x955)))+(((IkReal(-1.00000000000000))*(sj6)*(x953)*(x955)))+(((r10)*(sj6)*(x954)))+(((cj6)*(r11)*(x954))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x958=((sj3)*(sj6));
IkReal x959=((IkReal(1.00000000000000))*(r10));
IkReal x960=((cj6)*(sj3));
if( IKabs(((gconst68)*(((((r12)*(sj3)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(x959)*(x960)))+(((cj5)*(r11)*(x958))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst68)*(((((IkReal(-1.00000000000000))*(r11)*(x960)))+(((IkReal(-1.00000000000000))*(x958)*(x959))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst68)*(((((r12)*(sj3)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(x959)*(x960)))+(((cj5)*(r11)*(x958)))))), ((gconst68)*(((((IkReal(-1.00000000000000))*(r11)*(x960)))+(((IkReal(-1.00000000000000))*(x958)*(x959)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x961=IKsin(j4);
IkReal x962=IKcos(j4);
IkReal x963=((IkReal(1.00000000000000))*(r00));
IkReal x964=((cj5)*(r01));
IkReal x965=((cj5)*(r11));
IkReal x966=((IkReal(1.00000000000000))*(cj5));
IkReal x967=((cj5)*(r21));
IkReal x968=((sj5)*(x961));
IkReal x969=((cj6)*(x961));
IkReal x970=((sj6)*(x962));
IkReal x971=((sj6)*(x961));
IkReal x972=((sj5)*(x962));
IkReal x973=((cj6)*(x962));
evalcond[0]=((((IkReal(-1.00000000000000))*(r20)*(x970)))+(((x967)*(x971)))+(((IkReal(-1.00000000000000))*(r21)*(x973)))+(((r22)*(x968)))+(((IkReal(-1.00000000000000))*(r20)*(x966)*(x969))));
evalcond[1]=((cj3)+(((r22)*(x972)))+(((IkReal(-1.00000000000000))*(r20)*(x966)*(x973)))+(((r21)*(x969)))+(((r20)*(x971)))+(((x967)*(x970))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x963)*(x970)))+(((IkReal(-1.00000000000000))*(cj5)*(x963)*(x969)))+(((r02)*(x968)))+(((x964)*(x971)))+(((IkReal(-1.00000000000000))*(r01)*(x973))));
evalcond[3]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(r10)*(x966)*(x969)))+(((x965)*(x971)))+(((IkReal(-1.00000000000000))*(r11)*(x973)))+(((r12)*(x968)))+(((IkReal(-1.00000000000000))*(r10)*(x970))));
evalcond[4]=((sj3)+(((r00)*(x971)))+(((r01)*(x969)))+(((IkReal(-1.00000000000000))*(cj5)*(x963)*(x973)))+(((x964)*(x970)))+(((r02)*(x972))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(x966)*(x973)))+(((x965)*(x970)))+(((r11)*(x969)))+(((r12)*(x972)))+(((r10)*(x971))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x974=((cj3)*(sj6));
IkReal x975=((IkReal(1.00000000000000))*(r10));
IkReal x976=((cj3)*(cj6));
if( IKabs(((gconst67)*(((((IkReal(-1.00000000000000))*(cj5)*(x975)*(x976)))+(((cj3)*(r12)*(sj5)))+(((cj5)*(r11)*(x974))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst67)*(((((IkReal(-1.00000000000000))*(x974)*(x975)))+(((IkReal(-1.00000000000000))*(r11)*(x976))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst67)*(((((IkReal(-1.00000000000000))*(cj5)*(x975)*(x976)))+(((cj3)*(r12)*(sj5)))+(((cj5)*(r11)*(x974)))))), ((gconst67)*(((((IkReal(-1.00000000000000))*(x974)*(x975)))+(((IkReal(-1.00000000000000))*(r11)*(x976)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x977=IKsin(j4);
IkReal x978=IKcos(j4);
IkReal x979=((IkReal(1.00000000000000))*(r00));
IkReal x980=((cj5)*(r01));
IkReal x981=((cj5)*(r11));
IkReal x982=((IkReal(1.00000000000000))*(cj5));
IkReal x983=((cj5)*(r21));
IkReal x984=((sj5)*(x977));
IkReal x985=((cj6)*(x977));
IkReal x986=((sj6)*(x978));
IkReal x987=((sj6)*(x977));
IkReal x988=((sj5)*(x978));
IkReal x989=((cj6)*(x978));
evalcond[0]=((((x983)*(x987)))+(((IkReal(-1.00000000000000))*(r20)*(x982)*(x985)))+(((r22)*(x984)))+(((IkReal(-1.00000000000000))*(r20)*(x986)))+(((IkReal(-1.00000000000000))*(r21)*(x989))));
evalcond[1]=((((x983)*(x986)))+(((IkReal(-1.00000000000000))*(r20)*(x982)*(x989)))+(((r22)*(x988)))+(cj3)+(((r21)*(x985)))+(((r20)*(x987))));
evalcond[2]=((((IkReal(-1.00000000000000))*(cj5)*(x979)*(x985)))+(((IkReal(-1.00000000000000))*(x979)*(x986)))+(((x980)*(x987)))+(((IkReal(-1.00000000000000))*(r01)*(x989)))+(((r02)*(x984))));
evalcond[3]=((IkReal(1.00000000000000))+(((x981)*(x987)))+(((IkReal(-1.00000000000000))*(r10)*(x982)*(x985)))+(((IkReal(-1.00000000000000))*(r11)*(x989)))+(((r12)*(x984)))+(((IkReal(-1.00000000000000))*(r10)*(x986))));
evalcond[4]=((sj3)+(((r00)*(x987)))+(((r01)*(x985)))+(((IkReal(-1.00000000000000))*(cj5)*(x979)*(x989)))+(((x980)*(x986)))+(((r02)*(x988))));
evalcond[5]=((((x981)*(x986)))+(((IkReal(-1.00000000000000))*(r10)*(x982)*(x989)))+(((r12)*(x988)))+(((r11)*(x985)))+(((r10)*(x987))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x990=((IkReal(1.00000000000000))*(sj5));
if( IKabs(((((IKabs(cj2) != 0)?((IkReal)1/(cj2)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(r11)*(sj6)*(x990)))+(((cj5)*(r12)))+(((cj6)*(r10)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((r01)*(sj5)*(sj6)))+(((IkReal(-1.00000000000000))*(cj6)*(r00)*(x990)))+(((IkReal(-1.00000000000000))*(cj5)*(r02))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IKabs(cj2) != 0)?((IkReal)1/(cj2)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(r11)*(sj6)*(x990)))+(((cj5)*(r12)))+(((cj6)*(r10)*(sj5)))))))+IKsqr(((((r01)*(sj5)*(sj6)))+(((IkReal(-1.00000000000000))*(cj6)*(r00)*(x990)))+(((IkReal(-1.00000000000000))*(cj5)*(r02)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IKabs(cj2) != 0)?((IkReal)1/(cj2)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(r11)*(sj6)*(x990)))+(((cj5)*(r12)))+(((cj6)*(r10)*(sj5)))))), ((((r01)*(sj5)*(sj6)))+(((IkReal(-1.00000000000000))*(cj6)*(r00)*(x990)))+(((IkReal(-1.00000000000000))*(cj5)*(r02)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[3];
IkReal x991=IKsin(j3);
IkReal x992=((cj6)*(sj5));
IkReal x993=((IkReal(1.00000000000000))*(sj5)*(sj6));
evalcond[0]=((((cj5)*(r22)))+(((r20)*(x992)))+(((sj2)*(x991)))+(((IkReal(-1.00000000000000))*(r21)*(x993))));
evalcond[1]=((((r00)*(x992)))+(IKcos(j3))+(((IkReal(-1.00000000000000))*(r01)*(x993)))+(((cj5)*(r02))));
evalcond[2]=((((IkReal(-1.00000000000000))*(cj2)*(x991)))+(((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(r11)*(x993)))+(((r10)*(x992))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst59;
IkReal x994=(cj6)*(cj6);
IkReal x995=(cj5)*(cj5);
IkReal x996=(r01)*(r01);
IkReal x997=(r00)*(r00);
IkReal x998=(sj6)*(sj6);
IkReal x999=((cj6)*(r00));
IkReal x1000=((IkReal(2.00000000000000))*(r01)*(sj6));
IkReal x1001=((cj5)*(r02)*(sj5));
gconst59=IKsign(((((x1000)*(x999)))+(((x994)*(x996)))+(((x1000)*(x1001)))+((((r02)*(r02))*((sj5)*(sj5))))+(((x997)*(x998)))+(((x995)*(x996)*(x998)))+(((x994)*(x995)*(x997)))+(((IkReal(-1.00000000000000))*(x1000)*(x995)*(x999)))+(((IkReal(-2.00000000000000))*(x1001)*(x999)))));
IkReal x1002=(cj6)*(cj6);
IkReal x1003=(cj5)*(cj5);
IkReal x1004=(r01)*(r01);
IkReal x1005=(r00)*(r00);
IkReal x1006=(sj6)*(sj6);
IkReal x1007=((cj6)*(r00));
IkReal x1008=((IkReal(2.00000000000000))*(r01)*(sj6));
IkReal x1009=((cj5)*(r02)*(sj5));
dummyeval[0]=((((x1008)*(x1009)))+((((r02)*(r02))*((sj5)*(sj5))))+(((x1003)*(x1004)*(x1006)))+(((IkReal(-2.00000000000000))*(x1007)*(x1009)))+(((x1005)*(x1006)))+(((x1007)*(x1008)))+(((x1002)*(x1004)))+(((IkReal(-1.00000000000000))*(x1003)*(x1007)*(x1008)))+(((x1002)*(x1003)*(x1005))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst60;
IkReal x1010=(sj6)*(sj6);
IkReal x1011=(cj6)*(cj6);
IkReal x1012=((r01)*(r10));
IkReal x1013=((IkReal(1.00000000000000))*(r00));
IkReal x1014=((r02)*(sj5));
IkReal x1015=((r12)*(sj5));
IkReal x1016=((cj5)*(x1010));
IkReal x1017=((cj5)*(x1011));
gconst60=IKsign(((((IkReal(-1.00000000000000))*(sj6)*(x1013)*(x1015)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x1015)))+(((IkReal(-1.00000000000000))*(r11)*(x1013)*(x1017)))+(((IkReal(-1.00000000000000))*(r11)*(x1013)*(x1016)))+(((r10)*(sj6)*(x1014)))+(((x1012)*(x1016)))+(((x1012)*(x1017)))+(((cj6)*(r11)*(x1014)))));
IkReal x1018=(sj6)*(sj6);
IkReal x1019=(cj6)*(cj6);
IkReal x1020=((r01)*(r10));
IkReal x1021=((IkReal(1.00000000000000))*(r00));
IkReal x1022=((r02)*(sj5));
IkReal x1023=((r12)*(sj5));
IkReal x1024=((cj5)*(x1018));
IkReal x1025=((cj5)*(x1019));
dummyeval[0]=((((IkReal(-1.00000000000000))*(r11)*(x1021)*(x1024)))+(((IkReal(-1.00000000000000))*(r11)*(x1021)*(x1025)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x1023)))+(((IkReal(-1.00000000000000))*(sj6)*(x1021)*(x1023)))+(((r10)*(sj6)*(x1022)))+(((cj6)*(r11)*(x1022)))+(((x1020)*(x1025)))+(((x1020)*(x1024))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1026=((cj2)*(cj3));
IkReal x1027=((sj3)*(sj6));
IkReal x1028=((IkReal(1.00000000000000))*(r10));
IkReal x1029=((cj5)*(cj6));
if( IKabs(((gconst60)*(((((r12)*(sj3)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(sj6)*(x1026)))+(((IkReal(-1.00000000000000))*(r02)*(sj5)*(x1026)))+(((IkReal(-1.00000000000000))*(sj3)*(x1028)*(x1029)))+(((cj5)*(r11)*(x1027)))+(((r00)*(x1026)*(x1029))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst60)*(((((r00)*(sj6)*(x1026)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(sj3)))+(((cj6)*(r01)*(x1026)))+(((IkReal(-1.00000000000000))*(x1027)*(x1028))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst60)*(((((r12)*(sj3)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(sj6)*(x1026)))+(((IkReal(-1.00000000000000))*(r02)*(sj5)*(x1026)))+(((IkReal(-1.00000000000000))*(sj3)*(x1028)*(x1029)))+(((cj5)*(r11)*(x1027)))+(((r00)*(x1026)*(x1029)))))), ((gconst60)*(((((r00)*(sj6)*(x1026)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(sj3)))+(((cj6)*(r01)*(x1026)))+(((IkReal(-1.00000000000000))*(x1027)*(x1028)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1030=IKsin(j4);
IkReal x1031=IKcos(j4);
IkReal x1032=((IkReal(1.00000000000000))*(r00));
IkReal x1033=((cj5)*(r01));
IkReal x1034=((cj5)*(r11));
IkReal x1035=((IkReal(1.00000000000000))*(sj2));
IkReal x1036=((IkReal(1.00000000000000))*(cj5));
IkReal x1037=((cj5)*(r21));
IkReal x1038=((sj5)*(x1030));
IkReal x1039=((cj6)*(x1030));
IkReal x1040=((sj6)*(x1031));
IkReal x1041=((sj6)*(x1030));
IkReal x1042=((sj5)*(x1031));
IkReal x1043=((cj6)*(x1031));
evalcond[0]=((((r22)*(x1038)))+(((x1037)*(x1041)))+(((IkReal(-1.00000000000000))*(r20)*(x1036)*(x1039)))+(((IkReal(-1.00000000000000))*(r21)*(x1043)))+(((IkReal(-1.00000000000000))*(cj2)))+(((IkReal(-1.00000000000000))*(r20)*(x1040))));
evalcond[1]=((((x1037)*(x1040)))+(((r20)*(x1041)))+(((r21)*(x1039)))+(((IkReal(-1.00000000000000))*(r20)*(x1036)*(x1043)))+(((IkReal(-1.00000000000000))*(cj3)*(x1035)))+(((r22)*(x1042))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x1032)*(x1040)))+(((IkReal(-1.00000000000000))*(r01)*(x1043)))+(((r02)*(x1038)))+(((IkReal(-1.00000000000000))*(cj5)*(x1032)*(x1039)))+(((x1033)*(x1041))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x1035)))+(((x1034)*(x1041)))+(((IkReal(-1.00000000000000))*(r11)*(x1043)))+(((IkReal(-1.00000000000000))*(r10)*(x1040)))+(((r12)*(x1038)))+(((IkReal(-1.00000000000000))*(r10)*(x1036)*(x1039))));
evalcond[4]=((((r02)*(x1042)))+(sj3)+(((IkReal(-1.00000000000000))*(cj5)*(x1032)*(x1043)))+(((r00)*(x1041)))+(((r01)*(x1039)))+(((x1033)*(x1040))));
evalcond[5]=((((x1034)*(x1040)))+(((cj2)*(cj3)))+(((IkReal(-1.00000000000000))*(r10)*(x1036)*(x1043)))+(((r10)*(x1041)))+(((r11)*(x1039)))+(((r12)*(x1042))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1044=((cj5)*(sj3));
IkReal x1045=((IkReal(1.00000000000000))*(sj3));
if( IKabs(((gconst59)*(((((IkReal(-1.00000000000000))*(r00)*(sj6)*(x1045)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x1045))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst59)*(((((IkReal(-1.00000000000000))*(r02)*(sj5)*(x1045)))+(((IkReal(-1.00000000000000))*(r01)*(sj6)*(x1044)))+(((cj6)*(r00)*(x1044))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst59)*(((((IkReal(-1.00000000000000))*(r00)*(sj6)*(x1045)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x1045)))))), ((gconst59)*(((((IkReal(-1.00000000000000))*(r02)*(sj5)*(x1045)))+(((IkReal(-1.00000000000000))*(r01)*(sj6)*(x1044)))+(((cj6)*(r00)*(x1044)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1046=IKsin(j4);
IkReal x1047=IKcos(j4);
IkReal x1048=((IkReal(1.00000000000000))*(r00));
IkReal x1049=((cj5)*(r01));
IkReal x1050=((cj5)*(r11));
IkReal x1051=((IkReal(1.00000000000000))*(sj2));
IkReal x1052=((IkReal(1.00000000000000))*(cj5));
IkReal x1053=((cj5)*(r21));
IkReal x1054=((sj5)*(x1046));
IkReal x1055=((cj6)*(x1046));
IkReal x1056=((sj6)*(x1047));
IkReal x1057=((sj6)*(x1046));
IkReal x1058=((sj5)*(x1047));
IkReal x1059=((cj6)*(x1047));
evalcond[0]=((((IkReal(-1.00000000000000))*(r20)*(x1052)*(x1055)))+(((x1053)*(x1057)))+(((IkReal(-1.00000000000000))*(r21)*(x1059)))+(((r22)*(x1054)))+(((IkReal(-1.00000000000000))*(r20)*(x1056)))+(((IkReal(-1.00000000000000))*(cj2))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r20)*(x1052)*(x1059)))+(((x1053)*(x1056)))+(((r20)*(x1057)))+(((r21)*(x1055)))+(((r22)*(x1058)))+(((IkReal(-1.00000000000000))*(cj3)*(x1051))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r01)*(x1059)))+(((r02)*(x1054)))+(((x1049)*(x1057)))+(((IkReal(-1.00000000000000))*(x1048)*(x1056)))+(((IkReal(-1.00000000000000))*(cj5)*(x1048)*(x1055))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r10)*(x1052)*(x1055)))+(((IkReal(-1.00000000000000))*(x1051)))+(((r12)*(x1054)))+(((IkReal(-1.00000000000000))*(r11)*(x1059)))+(((IkReal(-1.00000000000000))*(r10)*(x1056)))+(((x1050)*(x1057))));
evalcond[4]=((((r02)*(x1058)))+(sj3)+(((r00)*(x1057)))+(((r01)*(x1055)))+(((x1049)*(x1056)))+(((IkReal(-1.00000000000000))*(cj5)*(x1048)*(x1059))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(x1052)*(x1059)))+(((r12)*(x1058)))+(((r11)*(x1055)))+(((cj2)*(cj3)))+(((x1050)*(x1056)))+(((r10)*(x1057))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1060=((IkReal(1.00000000000000))*(sj2));
if( IKabs(((gconst58)*(((((IkReal(-1.00000000000000))*(cj6)*(r01)*(x1060)))+(((IkReal(-1.00000000000000))*(r00)*(sj6)*(x1060))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst58)*(((((IkReal(-1.00000000000000))*(cj5)*(r01)*(sj6)*(x1060)))+(((cj5)*(cj6)*(r00)*(sj2)))+(((IkReal(-1.00000000000000))*(r02)*(sj5)*(x1060))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst58)*(((((IkReal(-1.00000000000000))*(cj6)*(r01)*(x1060)))+(((IkReal(-1.00000000000000))*(r00)*(sj6)*(x1060)))))), ((gconst58)*(((((IkReal(-1.00000000000000))*(cj5)*(r01)*(sj6)*(x1060)))+(((cj5)*(cj6)*(r00)*(sj2)))+(((IkReal(-1.00000000000000))*(r02)*(sj5)*(x1060)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x1061=IKsin(j4);
IkReal x1062=IKcos(j4);
IkReal x1063=((IkReal(1.00000000000000))*(cj6));
IkReal x1064=((sj5)*(x1061));
IkReal x1065=((cj5)*(x1061));
IkReal x1066=((IkReal(1.00000000000000))*(sj6)*(x1062));
evalcond[0]=((((r21)*(sj6)*(x1065)))+(((IkReal(-1.00000000000000))*(r20)*(x1066)))+(((IkReal(-1.00000000000000))*(r21)*(x1062)*(x1063)))+(((IkReal(-1.00000000000000))*(r20)*(x1063)*(x1065)))+(((r22)*(x1064)))+(((IkReal(-1.00000000000000))*(cj2))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r00)*(x1066)))+(((IkReal(-1.00000000000000))*(r00)*(x1063)*(x1065)))+(((r01)*(sj6)*(x1065)))+(((IkReal(-1.00000000000000))*(r01)*(x1062)*(x1063)))+(((r02)*(x1064))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r10)*(x1063)*(x1065)))+(((r12)*(x1064)))+(((IkReal(-1.00000000000000))*(sj2)))+(((IkReal(-1.00000000000000))*(r10)*(x1066)))+(((IkReal(-1.00000000000000))*(r11)*(x1062)*(x1063)))+(((r11)*(sj6)*(x1065))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x1067=((IkReal(1.00000000000000))*(cj6));
IkReal x1068=((IkReal(1.00000000000000))*(cj5));
IkReal x1069=((r01)*(sj6));
if( IKabs(((((IkReal(-1.00000000000000))*(r01)*(sj4)*(x1067)))+(((IkReal(-1.00000000000000))*(cj4)*(x1068)*(x1069)))+(((IkReal(-1.00000000000000))*(cj4)*(r02)*(sj5)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(sj6)))+(((cj4)*(cj5)*(cj6)*(r00))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r02)*(x1068)))+(((sj5)*(x1069)))+(((IkReal(-1.00000000000000))*(r00)*(sj5)*(x1067))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(r01)*(sj4)*(x1067)))+(((IkReal(-1.00000000000000))*(cj4)*(x1068)*(x1069)))+(((IkReal(-1.00000000000000))*(cj4)*(r02)*(sj5)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(sj6)))+(((cj4)*(cj5)*(cj6)*(r00)))))+IKsqr(((((IkReal(-1.00000000000000))*(r02)*(x1068)))+(((sj5)*(x1069)))+(((IkReal(-1.00000000000000))*(r00)*(sj5)*(x1067)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(r01)*(sj4)*(x1067)))+(((IkReal(-1.00000000000000))*(cj4)*(x1068)*(x1069)))+(((IkReal(-1.00000000000000))*(cj4)*(r02)*(sj5)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(sj6)))+(((cj4)*(cj5)*(cj6)*(r00)))), ((((IkReal(-1.00000000000000))*(r02)*(x1068)))+(((sj5)*(x1069)))+(((IkReal(-1.00000000000000))*(r00)*(sj5)*(x1067)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x1070=IKsin(j3);
IkReal x1071=IKcos(j3);
IkReal x1072=((r11)*(sj6));
IkReal x1073=((IkReal(1.00000000000000))*(sj5));
IkReal x1074=((sj4)*(sj6));
IkReal x1075=((cj4)*(sj5));
IkReal x1076=((cj6)*(sj4));
IkReal x1077=((cj4)*(cj5));
IkReal x1078=((r01)*(sj6));
IkReal x1079=((r21)*(sj6));
IkReal x1080=((cj6)*(sj5));
IkReal x1081=((IkReal(1.00000000000000))*(cj6)*(x1077));
evalcond[0]=((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(x1073)*(x1079)))+(((sj2)*(x1070)))+(((r20)*(x1080))));
evalcond[1]=((x1071)+(((IkReal(-1.00000000000000))*(x1073)*(x1078)))+(((r00)*(x1080)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(cj2)*(x1070)))+(((r10)*(x1080)))+(((IkReal(-1.00000000000000))*(x1072)*(x1073))));
evalcond[3]=((((x1077)*(x1079)))+(((IkReal(-1.00000000000000))*(sj2)*(x1071)))+(((r20)*(x1074)))+(((r22)*(x1075)))+(((r21)*(x1076)))+(((IkReal(-1.00000000000000))*(r20)*(x1081))));
evalcond[4]=((((x1077)*(x1078)))+(x1070)+(((IkReal(-1.00000000000000))*(r00)*(x1081)))+(((r00)*(x1074)))+(((r01)*(x1076)))+(((r02)*(x1075))));
evalcond[5]=((((r12)*(x1075)))+(((IkReal(-1.00000000000000))*(r10)*(x1081)))+(((cj2)*(x1071)))+(((r10)*(x1074)))+(((x1072)*(x1077)))+(((r11)*(x1076))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1082=((IkReal(1.00000000000000))*(cj2));
IkReal x1083=((sj6)*(x1082));
if( IKabs(((gconst57)*(((((IkReal(-1.00000000000000))*(cj6)*(r01)*(x1082)))+(((IkReal(-1.00000000000000))*(r00)*(x1083))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst57)*(((((cj2)*(cj5)*(cj6)*(r00)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(x1083)))+(((IkReal(-1.00000000000000))*(r02)*(sj5)*(x1082))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst57)*(((((IkReal(-1.00000000000000))*(cj6)*(r01)*(x1082)))+(((IkReal(-1.00000000000000))*(r00)*(x1083)))))), ((gconst57)*(((((cj2)*(cj5)*(cj6)*(r00)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(x1083)))+(((IkReal(-1.00000000000000))*(r02)*(sj5)*(x1082)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x1084=IKsin(j4);
IkReal x1085=IKcos(j4);
IkReal x1086=((IkReal(1.00000000000000))*(cj6));
IkReal x1087=((sj5)*(x1084));
IkReal x1088=((cj5)*(x1084));
IkReal x1089=((IkReal(1.00000000000000))*(sj6)*(x1085));
evalcond[0]=((((IkReal(-1.00000000000000))*(r21)*(x1085)*(x1086)))+(((r21)*(sj6)*(x1088)))+(((IkReal(-1.00000000000000))*(r20)*(x1086)*(x1088)))+(((r22)*(x1087)))+(((IkReal(-1.00000000000000))*(cj2)))+(((IkReal(-1.00000000000000))*(r20)*(x1089))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r00)*(x1086)*(x1088)))+(((IkReal(-1.00000000000000))*(r00)*(x1089)))+(((IkReal(-1.00000000000000))*(r01)*(x1085)*(x1086)))+(((r02)*(x1087)))+(((r01)*(sj6)*(x1088))));
evalcond[2]=((((IkReal(-1.00000000000000))*(sj2)))+(((r11)*(sj6)*(x1088)))+(((IkReal(-1.00000000000000))*(r10)*(x1086)*(x1088)))+(((IkReal(-1.00000000000000))*(r10)*(x1089)))+(((r12)*(x1087)))+(((IkReal(-1.00000000000000))*(r11)*(x1085)*(x1086))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x1090=((IkReal(1.00000000000000))*(cj6));
IkReal x1091=((IkReal(1.00000000000000))*(cj5));
IkReal x1092=((r01)*(sj6));
if( IKabs(((((IkReal(-1.00000000000000))*(r01)*(sj4)*(x1090)))+(((IkReal(-1.00000000000000))*(cj4)*(r02)*(sj5)))+(((IkReal(-1.00000000000000))*(cj4)*(x1091)*(x1092)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(sj6)))+(((cj4)*(cj5)*(cj6)*(r00))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r02)*(x1091)))+(((IkReal(-1.00000000000000))*(r00)*(sj5)*(x1090)))+(((sj5)*(x1092))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(r01)*(sj4)*(x1090)))+(((IkReal(-1.00000000000000))*(cj4)*(r02)*(sj5)))+(((IkReal(-1.00000000000000))*(cj4)*(x1091)*(x1092)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(sj6)))+(((cj4)*(cj5)*(cj6)*(r00)))))+IKsqr(((((IkReal(-1.00000000000000))*(r02)*(x1091)))+(((IkReal(-1.00000000000000))*(r00)*(sj5)*(x1090)))+(((sj5)*(x1092)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(r01)*(sj4)*(x1090)))+(((IkReal(-1.00000000000000))*(cj4)*(r02)*(sj5)))+(((IkReal(-1.00000000000000))*(cj4)*(x1091)*(x1092)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(sj6)))+(((cj4)*(cj5)*(cj6)*(r00)))), ((((IkReal(-1.00000000000000))*(r02)*(x1091)))+(((IkReal(-1.00000000000000))*(r00)*(sj5)*(x1090)))+(((sj5)*(x1092)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x1093=IKsin(j3);
IkReal x1094=IKcos(j3);
IkReal x1095=((r11)*(sj6));
IkReal x1096=((IkReal(1.00000000000000))*(sj5));
IkReal x1097=((sj4)*(sj6));
IkReal x1098=((cj4)*(sj5));
IkReal x1099=((cj6)*(sj4));
IkReal x1100=((cj4)*(cj5));
IkReal x1101=((r01)*(sj6));
IkReal x1102=((r21)*(sj6));
IkReal x1103=((cj6)*(sj5));
IkReal x1104=((IkReal(1.00000000000000))*(cj6)*(x1100));
evalcond[0]=((((cj5)*(r22)))+(((r20)*(x1103)))+(((sj2)*(x1093)))+(((IkReal(-1.00000000000000))*(x1096)*(x1102))));
evalcond[1]=((x1094)+(((r00)*(x1103)))+(((IkReal(-1.00000000000000))*(x1096)*(x1101)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(cj2)*(x1093)))+(((IkReal(-1.00000000000000))*(x1095)*(x1096)))+(((r10)*(x1103))));
evalcond[3]=((((r21)*(x1099)))+(((r22)*(x1098)))+(((IkReal(-1.00000000000000))*(r20)*(x1104)))+(((IkReal(-1.00000000000000))*(sj2)*(x1094)))+(((x1100)*(x1102)))+(((r20)*(x1097))));
evalcond[4]=((x1093)+(((r01)*(x1099)))+(((IkReal(-1.00000000000000))*(r00)*(x1104)))+(((r00)*(x1097)))+(((r02)*(x1098)))+(((x1100)*(x1101))));
evalcond[5]=((((r10)*(x1097)))+(((r11)*(x1099)))+(((r12)*(x1098)))+(((cj2)*(x1094)))+(((IkReal(-1.00000000000000))*(r10)*(x1104)))+(((x1095)*(x1100))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
}
}

}

}
}
}

} else
{
IkReal x1105=((IkReal(0.390000000000000))*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((IkReal(0.400000000000000))+(((cj6)*(r00)*(x1105)))+(((IkReal(-1.00000000000000))*(r01)*(sj6)*(x1105)))+(((IkReal(0.000500000000000000))*(cj6)*(r01)))+(((IkReal(0.000500000000000000))*(r00)*(sj6)))+(((IkReal(-1.00000000000000))*(px)))+(((IkReal(0.390000000000000))*(cj5)*(r02))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  )
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x1106=((IkReal(195.000000000000))*(cj5));
IkReal x1107=((IkReal(0.250000000000000))*(cj6));
IkReal x1108=((IkReal(0.250000000000000))*(sj6));
IkReal x1109=((IkReal(195.000000000000))*(cj6)*(sj5));
IkReal x1110=((IkReal(195.000000000000))*(sj5)*(sj6));
if( IKabs(((((IkReal(-1.00000000000000))*(r11)*(x1107)))+(((IkReal(-1.00000000000000))*(r12)*(x1106)))+(((IkReal(500.000000000000))*(py)))+(((r11)*(x1110)))+(((IkReal(-1.00000000000000))*(r10)*(x1109)))+(((IkReal(-1.00000000000000))*(r10)*(x1108))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((r20)*(x1109)))+(((r20)*(x1108)))+(((IkReal(-500.000000000000))*(pz)))+(((IkReal(-1.00000000000000))*(r21)*(x1110)))+(((r22)*(x1106)))+(((r21)*(x1107))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(r11)*(x1107)))+(((IkReal(-1.00000000000000))*(r12)*(x1106)))+(((IkReal(500.000000000000))*(py)))+(((r11)*(x1110)))+(((IkReal(-1.00000000000000))*(r10)*(x1109)))+(((IkReal(-1.00000000000000))*(r10)*(x1108)))))+IKsqr(((((r20)*(x1109)))+(((r20)*(x1108)))+(((IkReal(-500.000000000000))*(pz)))+(((IkReal(-1.00000000000000))*(r21)*(x1110)))+(((r22)*(x1106)))+(((r21)*(x1107)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((((IkReal(-1.00000000000000))*(r11)*(x1107)))+(((IkReal(-1.00000000000000))*(r12)*(x1106)))+(((IkReal(500.000000000000))*(py)))+(((r11)*(x1110)))+(((IkReal(-1.00000000000000))*(r10)*(x1109)))+(((IkReal(-1.00000000000000))*(r10)*(x1108)))), ((((r20)*(x1109)))+(((r20)*(x1108)))+(((IkReal(-500.000000000000))*(pz)))+(((IkReal(-1.00000000000000))*(r21)*(x1110)))+(((r22)*(x1106)))+(((r21)*(x1107)))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[2];
IkReal x1111=((IkReal(0.000500000000000000))*(cj6));
IkReal x1112=((IkReal(0.000500000000000000))*(sj6));
IkReal x1113=((IkReal(0.390000000000000))*(cj5));
IkReal x1114=((IkReal(0.390000000000000))*(sj5)*(sj6));
IkReal x1115=((IkReal(0.390000000000000))*(cj6)*(sj5));
evalcond[0]=((((r20)*(x1115)))+(((r20)*(x1112)))+(((IkReal(-0.00200000000000000))*(IKcos(j2))))+(((IkReal(-1.00000000000000))*(r21)*(x1114)))+(((IkReal(-1.00000000000000))*(pz)))+(((r22)*(x1113)))+(((r21)*(x1111))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r11)*(x1114)))+(((IkReal(-1.00000000000000))*(py)))+(((IkReal(0.00200000000000000))*(IKsin(j2))))+(((r12)*(x1113)))+(((r11)*(x1111)))+(((r10)*(x1115)))+(((r10)*(x1112))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst69;
IkReal x1116=(sj6)*(sj6);
IkReal x1117=(cj6)*(cj6);
IkReal x1118=((cj6)*(sj5));
IkReal x1119=((r00)*(r11));
IkReal x1120=((IkReal(1.00000000000000))*(r02));
IkReal x1121=((sj5)*(sj6));
IkReal x1122=((cj5)*(x1116));
IkReal x1123=((IkReal(1.00000000000000))*(r01)*(r10));
IkReal x1124=((cj5)*(x1117));
gconst69=IKsign(((((r01)*(r12)*(x1118)))+(((IkReal(-1.00000000000000))*(r11)*(x1118)*(x1120)))+(((IkReal(-1.00000000000000))*(x1122)*(x1123)))+(((r00)*(r12)*(x1121)))+(((x1119)*(x1122)))+(((x1119)*(x1124)))+(((IkReal(-1.00000000000000))*(x1123)*(x1124)))+(((IkReal(-1.00000000000000))*(r10)*(x1120)*(x1121)))));
IkReal x1125=(sj6)*(sj6);
IkReal x1126=(cj6)*(cj6);
IkReal x1127=((cj6)*(sj5));
IkReal x1128=((r00)*(r11));
IkReal x1129=((IkReal(1.00000000000000))*(r02));
IkReal x1130=((sj5)*(sj6));
IkReal x1131=((cj5)*(x1125));
IkReal x1132=((IkReal(1.00000000000000))*(r01)*(r10));
IkReal x1133=((cj5)*(x1126));
dummyeval[0]=((((r00)*(r12)*(x1130)))+(((IkReal(-1.00000000000000))*(x1131)*(x1132)))+(((IkReal(-1.00000000000000))*(r10)*(x1129)*(x1130)))+(((IkReal(-1.00000000000000))*(r11)*(x1127)*(x1129)))+(((IkReal(-1.00000000000000))*(x1132)*(x1133)))+(((x1128)*(x1133)))+(((x1128)*(x1131)))+(((r01)*(r12)*(x1127))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst70;
IkReal x1134=(cj6)*(cj6);
IkReal x1135=(sj6)*(sj6);
IkReal x1136=((r01)*(r20));
IkReal x1137=((r02)*(sj5));
IkReal x1138=((cj5)*(x1135));
IkReal x1139=((IkReal(1.00000000000000))*(r22)*(sj5));
IkReal x1140=((IkReal(1.00000000000000))*(r00)*(r21));
IkReal x1141=((cj5)*(x1134));
gconst70=IKsign(((((IkReal(-1.00000000000000))*(x1140)*(x1141)))+(((r20)*(sj6)*(x1137)))+(((IkReal(-1.00000000000000))*(r00)*(sj6)*(x1139)))+(((x1136)*(x1138)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x1139)))+(((cj6)*(r21)*(x1137)))+(((x1136)*(x1141)))+(((IkReal(-1.00000000000000))*(x1138)*(x1140)))));
IkReal x1142=(cj6)*(cj6);
IkReal x1143=(sj6)*(sj6);
IkReal x1144=((r01)*(r20));
IkReal x1145=((r02)*(sj5));
IkReal x1146=((cj5)*(x1143));
IkReal x1147=((IkReal(1.00000000000000))*(r22)*(sj5));
IkReal x1148=((IkReal(1.00000000000000))*(r00)*(r21));
IkReal x1149=((cj5)*(x1142));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x1146)*(x1148)))+(((IkReal(-1.00000000000000))*(r00)*(sj6)*(x1147)))+(((IkReal(-1.00000000000000))*(x1148)*(x1149)))+(((x1144)*(x1149)))+(((x1144)*(x1146)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x1147)))+(((cj6)*(r21)*(x1145)))+(((r20)*(sj6)*(x1145))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=sj2;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
IkReal x1150=((IkReal(0.000500000000000000))*(cj6));
IkReal x1151=((IkReal(0.390000000000000))*(sj5));
IkReal x1152=((cj6)*(r20));
IkReal x1153=((IkReal(0.000500000000000000))*(sj6));
IkReal x1154=((cj5)*(r22));
IkReal x1155=((r21)*(sj6));
IkReal x1156=((IkReal(0.390000000000000))*(cj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(3.14159265358979))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((x1154)+(((IkReal(-1.00000000000000))*(sj5)*(x1155)))+(((sj5)*(x1152))));
evalcond[2]=((IkReal(-0.00200000000000000))+(((r20)*(x1153)))+(((IkReal(-1.00000000000000))*(pz)))+(((IkReal(0.390000000000000))*(x1154)))+(((x1151)*(x1152)))+(((r21)*(x1150)))+(((IkReal(-1.00000000000000))*(x1151)*(x1155))));
evalcond[3]=((IkReal(0.400000000000000))+(((r00)*(x1153)))+(((r02)*(x1156)))+(((IkReal(-1.00000000000000))*(r01)*(sj6)*(x1151)))+(((cj6)*(r00)*(x1151)))+(((IkReal(-1.00000000000000))*(px)))+(((r01)*(x1150))));
evalcond[4]=((((r11)*(x1150)))+(((r12)*(x1156)))+(((cj6)*(r10)*(x1151)))+(((IkReal(-1.00000000000000))*(py)))+(((IkReal(-1.00000000000000))*(r11)*(sj6)*(x1151)))+(((r10)*(x1153))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x1157=((IkReal(1.00000000000000))*(sj5));
if( IKabs(((((IkReal(-1.00000000000000))*(cj5)*(r12)))+(((IkReal(-1.00000000000000))*(cj6)*(r10)*(x1157)))+(((r11)*(sj5)*(sj6))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((cj6)*(r00)*(sj5)))+(((IkReal(-1.00000000000000))*(r01)*(sj6)*(x1157)))+(((cj5)*(r02))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(cj5)*(r12)))+(((IkReal(-1.00000000000000))*(cj6)*(r10)*(x1157)))+(((r11)*(sj5)*(sj6)))))+IKsqr(((((cj6)*(r00)*(sj5)))+(((IkReal(-1.00000000000000))*(r01)*(sj6)*(x1157)))+(((cj5)*(r02)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(cj5)*(r12)))+(((IkReal(-1.00000000000000))*(cj6)*(r10)*(x1157)))+(((r11)*(sj5)*(sj6)))), ((((cj6)*(r00)*(sj5)))+(((IkReal(-1.00000000000000))*(r01)*(sj6)*(x1157)))+(((cj5)*(r02)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x1158=((cj6)*(sj5));
IkReal x1159=((IkReal(1.00000000000000))*(sj5)*(sj6));
evalcond[0]=((((r00)*(x1158)))+(((IkReal(-1.00000000000000))*(r01)*(x1159)))+(((IkReal(-1.00000000000000))*(IKcos(j3))))+(((cj5)*(r02))));
evalcond[1]=((((cj5)*(r12)))+(IKsin(j3))+(((IkReal(-1.00000000000000))*(r11)*(x1159)))+(((r10)*(x1158))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst76;
IkReal x1160=(sj6)*(sj6);
IkReal x1161=(cj6)*(cj6);
IkReal x1162=((IkReal(1.00000000000000))*(r20));
IkReal x1163=((r00)*(r21));
IkReal x1164=((r22)*(sj5));
IkReal x1165=((r02)*(sj5));
IkReal x1166=((cj5)*(x1160));
IkReal x1167=((cj5)*(x1161));
gconst76=IKsign(((((IkReal(-1.00000000000000))*(r01)*(x1162)*(x1167)))+(((IkReal(-1.00000000000000))*(r01)*(x1162)*(x1166)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x1165)))+(((x1163)*(x1167)))+(((x1163)*(x1166)))+(((cj6)*(r01)*(x1164)))+(((r00)*(sj6)*(x1164)))+(((IkReal(-1.00000000000000))*(sj6)*(x1162)*(x1165)))));
IkReal x1168=(sj6)*(sj6);
IkReal x1169=(cj6)*(cj6);
IkReal x1170=((IkReal(1.00000000000000))*(r20));
IkReal x1171=((r00)*(r21));
IkReal x1172=((r22)*(sj5));
IkReal x1173=((r02)*(sj5));
IkReal x1174=((cj5)*(x1168));
IkReal x1175=((cj5)*(x1169));
dummyeval[0]=((((IkReal(-1.00000000000000))*(r01)*(x1170)*(x1175)))+(((IkReal(-1.00000000000000))*(r01)*(x1170)*(x1174)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x1173)))+(((cj6)*(r01)*(x1172)))+(((r00)*(sj6)*(x1172)))+(((IkReal(-1.00000000000000))*(sj6)*(x1170)*(x1173)))+(((x1171)*(x1175)))+(((x1171)*(x1174))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst75;
IkReal x1176=(r20)*(r20);
IkReal x1177=(cj5)*(cj5);
IkReal x1178=(sj6)*(sj6);
IkReal x1179=(cj6)*(cj6);
IkReal x1180=(r21)*(r21);
IkReal x1181=((cj6)*(r20));
IkReal x1182=((IkReal(2.00000000000000))*(r21)*(sj6));
IkReal x1183=((cj5)*(r22)*(sj5));
gconst75=IKsign(((((IkReal(-1.00000000000000))*(x1177)*(x1181)*(x1182)))+(((x1177)*(x1178)*(x1180)))+(((x1182)*(x1183)))+(((x1179)*(x1180)))+(((x1176)*(x1178)))+(((x1181)*(x1182)))+(((IkReal(-2.00000000000000))*(x1181)*(x1183)))+(((x1176)*(x1177)*(x1179)))+((((r22)*(r22))*((sj5)*(sj5))))));
IkReal x1184=(r20)*(r20);
IkReal x1185=(cj5)*(cj5);
IkReal x1186=(sj6)*(sj6);
IkReal x1187=(cj6)*(cj6);
IkReal x1188=(r21)*(r21);
IkReal x1189=((cj6)*(r20));
IkReal x1190=((IkReal(2.00000000000000))*(r21)*(sj6));
IkReal x1191=((cj5)*(r22)*(sj5));
dummyeval[0]=((((x1184)*(x1185)*(x1187)))+(((x1187)*(x1188)))+(((x1184)*(x1186)))+(((IkReal(-1.00000000000000))*(x1185)*(x1189)*(x1190)))+(((IkReal(-2.00000000000000))*(x1189)*(x1191)))+(((x1189)*(x1190)))+(((x1185)*(x1186)*(x1188)))+(((x1190)*(x1191)))+((((r22)*(r22))*((sj5)*(sj5)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1192=((IkReal(1.00000000000000))*(r20));
if( IKabs(((gconst75)*(((((IkReal(-1.00000000000000))*(cj5)*(cj6)*(x1192)))+(((cj5)*(r21)*(sj6)))+(((r22)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst75)*(((((IkReal(-1.00000000000000))*(sj6)*(x1192)))+(((IkReal(-1.00000000000000))*(cj6)*(r21))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst75)*(((((IkReal(-1.00000000000000))*(cj5)*(cj6)*(x1192)))+(((cj5)*(r21)*(sj6)))+(((r22)*(sj5)))))), ((gconst75)*(((((IkReal(-1.00000000000000))*(sj6)*(x1192)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1193=IKsin(j4);
IkReal x1194=IKcos(j4);
IkReal x1195=((IkReal(1.00000000000000))*(r00));
IkReal x1196=((cj5)*(r01));
IkReal x1197=((cj5)*(r11));
IkReal x1198=((IkReal(1.00000000000000))*(cj5));
IkReal x1199=((cj5)*(r21));
IkReal x1200=((sj5)*(x1193));
IkReal x1201=((cj6)*(x1193));
IkReal x1202=((sj6)*(x1194));
IkReal x1203=((sj6)*(x1193));
IkReal x1204=((sj5)*(x1194));
IkReal x1205=((cj6)*(x1194));
evalcond[0]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(r21)*(x1205)))+(((x1199)*(x1203)))+(((IkReal(-1.00000000000000))*(r20)*(x1198)*(x1201)))+(((IkReal(-1.00000000000000))*(r20)*(x1202)))+(((r22)*(x1200))));
evalcond[1]=((((x1199)*(x1202)))+(((r21)*(x1201)))+(((r20)*(x1203)))+(((IkReal(-1.00000000000000))*(r20)*(x1198)*(x1205)))+(((r22)*(x1204))));
evalcond[2]=((((IkReal(-1.00000000000000))*(cj5)*(x1195)*(x1201)))+(((r02)*(x1200)))+(((IkReal(-1.00000000000000))*(x1195)*(x1202)))+(((x1196)*(x1203)))+(((IkReal(-1.00000000000000))*(r01)*(x1205))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r10)*(x1202)))+(((r12)*(x1200)))+(((IkReal(-1.00000000000000))*(r10)*(x1198)*(x1201)))+(((x1197)*(x1203)))+(((IkReal(-1.00000000000000))*(r11)*(x1205))));
evalcond[4]=((((IkReal(-1.00000000000000))*(cj5)*(x1195)*(x1205)))+(((IkReal(-1.00000000000000))*(sj3)))+(((r01)*(x1201)))+(((r00)*(x1203)))+(((r02)*(x1204)))+(((x1196)*(x1202))));
evalcond[5]=((((r10)*(x1203)))+(((r11)*(x1201)))+(((r12)*(x1204)))+(((IkReal(-1.00000000000000))*(r10)*(x1198)*(x1205)))+(((x1197)*(x1202)))+(((IkReal(-1.00000000000000))*(cj3))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1206=((IkReal(1.00000000000000))*(sj3));
if( IKabs(((gconst76)*(((((IkReal(-1.00000000000000))*(cj5)*(cj6)*(r20)*(x1206)))+(((cj5)*(r21)*(sj3)*(sj6)))+(((r22)*(sj3)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst76)*(((((IkReal(-1.00000000000000))*(cj6)*(r21)*(x1206)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x1206))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst76)*(((((IkReal(-1.00000000000000))*(cj5)*(cj6)*(r20)*(x1206)))+(((cj5)*(r21)*(sj3)*(sj6)))+(((r22)*(sj3)*(sj5)))))), ((gconst76)*(((((IkReal(-1.00000000000000))*(cj6)*(r21)*(x1206)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x1206)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1207=IKsin(j4);
IkReal x1208=IKcos(j4);
IkReal x1209=((IkReal(1.00000000000000))*(r00));
IkReal x1210=((cj5)*(r01));
IkReal x1211=((cj5)*(r11));
IkReal x1212=((IkReal(1.00000000000000))*(cj5));
IkReal x1213=((cj5)*(r21));
IkReal x1214=((sj5)*(x1207));
IkReal x1215=((cj6)*(x1207));
IkReal x1216=((sj6)*(x1208));
IkReal x1217=((sj6)*(x1207));
IkReal x1218=((sj5)*(x1208));
IkReal x1219=((cj6)*(x1208));
evalcond[0]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(r20)*(x1216)))+(((IkReal(-1.00000000000000))*(r20)*(x1212)*(x1215)))+(((r22)*(x1214)))+(((x1213)*(x1217)))+(((IkReal(-1.00000000000000))*(r21)*(x1219))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r20)*(x1212)*(x1219)))+(((r22)*(x1218)))+(((x1213)*(x1216)))+(((r20)*(x1217)))+(((r21)*(x1215))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x1209)*(x1216)))+(((x1210)*(x1217)))+(((r02)*(x1214)))+(((IkReal(-1.00000000000000))*(cj5)*(x1209)*(x1215)))+(((IkReal(-1.00000000000000))*(r01)*(x1219))));
evalcond[3]=((((r12)*(x1214)))+(((IkReal(-1.00000000000000))*(r10)*(x1212)*(x1215)))+(((IkReal(-1.00000000000000))*(r11)*(x1219)))+(((x1211)*(x1217)))+(((IkReal(-1.00000000000000))*(r10)*(x1216))));
evalcond[4]=((((IkReal(-1.00000000000000))*(sj3)))+(((x1210)*(x1216)))+(((r02)*(x1218)))+(((r00)*(x1217)))+(((r01)*(x1215)))+(((IkReal(-1.00000000000000))*(cj5)*(x1209)*(x1219))));
evalcond[5]=((((r12)*(x1218)))+(((r11)*(x1215)))+(((IkReal(-1.00000000000000))*(r10)*(x1212)*(x1219)))+(((r10)*(x1217)))+(((x1211)*(x1216)))+(((IkReal(-1.00000000000000))*(cj3))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
IkReal x1220=((IkReal(0.000500000000000000))*(cj6));
IkReal x1221=((IkReal(0.390000000000000))*(sj5));
IkReal x1222=((cj6)*(r20));
IkReal x1223=((IkReal(0.000500000000000000))*(sj6));
IkReal x1224=((cj5)*(r22));
IkReal x1225=((r21)*(sj6));
IkReal x1226=((IkReal(0.390000000000000))*(cj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.11022302462516e-16))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((x1224)+(((sj5)*(x1222)))+(((IkReal(-1.00000000000000))*(sj5)*(x1225))));
evalcond[2]=((IkReal(0.00200000000000000))+(((r20)*(x1223)))+(((IkReal(-1.00000000000000))*(x1221)*(x1225)))+(((IkReal(-1.00000000000000))*(pz)))+(((x1221)*(x1222)))+(((IkReal(0.390000000000000))*(x1224)))+(((r21)*(x1220))));
evalcond[3]=((IkReal(0.400000000000000))+(((r01)*(x1220)))+(((r00)*(x1223)))+(((cj6)*(r00)*(x1221)))+(((r02)*(x1226)))+(((IkReal(-1.00000000000000))*(px)))+(((IkReal(-1.00000000000000))*(r01)*(sj6)*(x1221))));
evalcond[4]=((((IkReal(-1.00000000000000))*(py)))+(((r10)*(x1223)))+(((cj6)*(r10)*(x1221)))+(((r11)*(x1220)))+(((r12)*(x1226)))+(((IkReal(-1.00000000000000))*(r11)*(sj6)*(x1221))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x1227=((cj6)*(sj5));
IkReal x1228=((IkReal(1.00000000000000))*(sj5)*(sj6));
if( IKabs(((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(r11)*(x1228)))+(((r10)*(x1227))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r01)*(x1228)))+(((r00)*(x1227)))+(((cj5)*(r02))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(r11)*(x1228)))+(((r10)*(x1227)))))+IKsqr(((((IkReal(-1.00000000000000))*(r01)*(x1228)))+(((r00)*(x1227)))+(((cj5)*(r02)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(r11)*(x1228)))+(((r10)*(x1227)))), ((((IkReal(-1.00000000000000))*(r01)*(x1228)))+(((r00)*(x1227)))+(((cj5)*(r02)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x1229=((cj6)*(sj5));
IkReal x1230=((IkReal(1.00000000000000))*(sj5)*(sj6));
evalcond[0]=((((IkReal(-1.00000000000000))*(r01)*(x1230)))+(((r00)*(x1229)))+(((IkReal(-1.00000000000000))*(IKcos(j3))))+(((cj5)*(r02))));
evalcond[1]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(r11)*(x1230)))+(((IkReal(-1.00000000000000))*(IKsin(j3))))+(((r10)*(x1229))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst79;
IkReal x1231=(cj6)*(cj6);
IkReal x1232=(sj6)*(sj6);
IkReal x1233=((r11)*(r20));
IkReal x1234=((r12)*(sj5));
IkReal x1235=((IkReal(1.00000000000000))*(r10));
IkReal x1236=((r22)*(sj5));
IkReal x1237=((cj5)*(x1232));
IkReal x1238=((cj5)*(x1231));
gconst79=IKsign(((((IkReal(-1.00000000000000))*(sj6)*(x1235)*(x1236)))+(((cj6)*(r21)*(x1234)))+(((r20)*(sj6)*(x1234)))+(((x1233)*(x1237)))+(((x1233)*(x1238)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x1236)))+(((IkReal(-1.00000000000000))*(r21)*(x1235)*(x1237)))+(((IkReal(-1.00000000000000))*(r21)*(x1235)*(x1238)))));
IkReal x1239=(cj6)*(cj6);
IkReal x1240=(sj6)*(sj6);
IkReal x1241=((r11)*(r20));
IkReal x1242=((r12)*(sj5));
IkReal x1243=((IkReal(1.00000000000000))*(r10));
IkReal x1244=((r22)*(sj5));
IkReal x1245=((cj5)*(x1240));
IkReal x1246=((cj5)*(x1239));
dummyeval[0]=((((IkReal(-1.00000000000000))*(r21)*(x1243)*(x1246)))+(((IkReal(-1.00000000000000))*(r21)*(x1243)*(x1245)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x1244)))+(((cj6)*(r21)*(x1242)))+(((r20)*(sj6)*(x1242)))+(((x1241)*(x1246)))+(((x1241)*(x1245)))+(((IkReal(-1.00000000000000))*(sj6)*(x1243)*(x1244))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst80;
IkReal x1247=(cj5)*(cj5);
IkReal x1248=(r21)*(r21);
IkReal x1249=(sj6)*(sj6);
IkReal x1250=(cj6)*(cj6);
IkReal x1251=(r20)*(r20);
IkReal x1252=((cj6)*(r20));
IkReal x1253=((IkReal(1.00000000000000))*(x1250));
IkReal x1254=((IkReal(2.00000000000000))*(r21)*(sj6));
IkReal x1255=((cj5)*(r22)*(sj5));
IkReal x1256=((IkReal(1.00000000000000))*(x1249));
gconst80=IKsign(((((x1247)*(x1252)*(x1254)))+(((IkReal(-1.00000000000000))*(x1247)*(x1251)*(x1253)))+(((IkReal(-1.00000000000000))*(x1248)*(x1253)))+(((IkReal(-1.00000000000000))*(x1252)*(x1254)))+(((IkReal(-1.00000000000000))*(x1254)*(x1255)))+(((IkReal(-1.00000000000000))*(x1251)*(x1256)))+(((IkReal(2.00000000000000))*(x1252)*(x1255)))+(((IkReal(-1.00000000000000))*(x1247)*(x1248)*(x1256)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))));
IkReal x1257=(cj5)*(cj5);
IkReal x1258=(r21)*(r21);
IkReal x1259=(sj6)*(sj6);
IkReal x1260=(cj6)*(cj6);
IkReal x1261=(r20)*(r20);
IkReal x1262=((cj6)*(r20));
IkReal x1263=((IkReal(1.00000000000000))*(x1260));
IkReal x1264=((IkReal(2.00000000000000))*(r21)*(sj6));
IkReal x1265=((cj5)*(r22)*(sj5));
IkReal x1266=((IkReal(1.00000000000000))*(x1259));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x1258)*(x1263)))+(((IkReal(-1.00000000000000))*(x1264)*(x1265)))+(((IkReal(-1.00000000000000))*(x1257)*(x1258)*(x1266)))+(((IkReal(-1.00000000000000))*(x1261)*(x1266)))+(((IkReal(2.00000000000000))*(x1262)*(x1265)))+(((IkReal(-1.00000000000000))*(x1262)*(x1264)))+(((x1257)*(x1262)*(x1264)))+(((IkReal(-1.00000000000000))*(x1257)*(x1261)*(x1263)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1267=((IkReal(1.00000000000000))*(r20));
if( IKabs(((gconst80)*(((((cj5)*(r21)*(sj6)))+(((r22)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(cj6)*(x1267))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst80)*(((((IkReal(-1.00000000000000))*(cj6)*(r21)))+(((IkReal(-1.00000000000000))*(sj6)*(x1267))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst80)*(((((cj5)*(r21)*(sj6)))+(((r22)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(cj6)*(x1267)))))), ((gconst80)*(((((IkReal(-1.00000000000000))*(cj6)*(r21)))+(((IkReal(-1.00000000000000))*(sj6)*(x1267)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1268=IKsin(j4);
IkReal x1269=IKcos(j4);
IkReal x1270=((IkReal(1.00000000000000))*(r00));
IkReal x1271=((cj5)*(r01));
IkReal x1272=((cj5)*(r11));
IkReal x1273=((IkReal(1.00000000000000))*(cj5));
IkReal x1274=((cj5)*(r21));
IkReal x1275=((sj5)*(x1268));
IkReal x1276=((cj6)*(x1268));
IkReal x1277=((sj6)*(x1269));
IkReal x1278=((sj6)*(x1268));
IkReal x1279=((sj5)*(x1269));
IkReal x1280=((cj6)*(x1269));
evalcond[0]=((IkReal(1.00000000000000))+(((r22)*(x1275)))+(((x1274)*(x1278)))+(((IkReal(-1.00000000000000))*(r20)*(x1273)*(x1276)))+(((IkReal(-1.00000000000000))*(r21)*(x1280)))+(((IkReal(-1.00000000000000))*(r20)*(x1277))));
evalcond[1]=((((r21)*(x1276)))+(((IkReal(-1.00000000000000))*(r20)*(x1273)*(x1280)))+(((r22)*(x1279)))+(((x1274)*(x1277)))+(((r20)*(x1278))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r01)*(x1280)))+(((IkReal(-1.00000000000000))*(x1270)*(x1277)))+(((IkReal(-1.00000000000000))*(cj5)*(x1270)*(x1276)))+(((r02)*(x1275)))+(((x1271)*(x1278))));
evalcond[3]=((((r12)*(x1275)))+(((x1272)*(x1278)))+(((IkReal(-1.00000000000000))*(r11)*(x1280)))+(((IkReal(-1.00000000000000))*(r10)*(x1273)*(x1276)))+(((IkReal(-1.00000000000000))*(r10)*(x1277))));
evalcond[4]=((((IkReal(-1.00000000000000))*(sj3)))+(((IkReal(-1.00000000000000))*(cj5)*(x1270)*(x1280)))+(((r02)*(x1279)))+(((x1271)*(x1277)))+(((r00)*(x1278)))+(((r01)*(x1276))));
evalcond[5]=((((r12)*(x1279)))+(((r10)*(x1278)))+(cj3)+(((r11)*(x1276)))+(((x1272)*(x1277)))+(((IkReal(-1.00000000000000))*(r10)*(x1273)*(x1280))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1281=((cj3)*(sj6));
IkReal x1282=((IkReal(1.00000000000000))*(cj3)*(cj6));
if( IKabs(((gconst79)*(((((cj3)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r20)*(x1282)))+(((cj5)*(r21)*(x1281))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst79)*(((((IkReal(-1.00000000000000))*(r20)*(x1281)))+(((IkReal(-1.00000000000000))*(r21)*(x1282))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst79)*(((((cj3)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r20)*(x1282)))+(((cj5)*(r21)*(x1281)))))), ((gconst79)*(((((IkReal(-1.00000000000000))*(r20)*(x1281)))+(((IkReal(-1.00000000000000))*(r21)*(x1282)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1283=IKsin(j4);
IkReal x1284=IKcos(j4);
IkReal x1285=((IkReal(1.00000000000000))*(r00));
IkReal x1286=((cj5)*(r01));
IkReal x1287=((cj5)*(r11));
IkReal x1288=((IkReal(1.00000000000000))*(cj5));
IkReal x1289=((cj5)*(r21));
IkReal x1290=((sj5)*(x1283));
IkReal x1291=((cj6)*(x1283));
IkReal x1292=((sj6)*(x1284));
IkReal x1293=((sj6)*(x1283));
IkReal x1294=((sj5)*(x1284));
IkReal x1295=((cj6)*(x1284));
evalcond[0]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(r21)*(x1295)))+(((IkReal(-1.00000000000000))*(r20)*(x1288)*(x1291)))+(((IkReal(-1.00000000000000))*(r20)*(x1292)))+(((r22)*(x1290)))+(((x1289)*(x1293))));
evalcond[1]=((((r20)*(x1293)))+(((r21)*(x1291)))+(((IkReal(-1.00000000000000))*(r20)*(x1288)*(x1295)))+(((r22)*(x1294)))+(((x1289)*(x1292))));
evalcond[2]=((((x1286)*(x1293)))+(((IkReal(-1.00000000000000))*(r01)*(x1295)))+(((r02)*(x1290)))+(((IkReal(-1.00000000000000))*(cj5)*(x1285)*(x1291)))+(((IkReal(-1.00000000000000))*(x1285)*(x1292))));
evalcond[3]=((((x1287)*(x1293)))+(((r12)*(x1290)))+(((IkReal(-1.00000000000000))*(r10)*(x1292)))+(((IkReal(-1.00000000000000))*(r11)*(x1295)))+(((IkReal(-1.00000000000000))*(r10)*(x1288)*(x1291))));
evalcond[4]=((((IkReal(-1.00000000000000))*(sj3)))+(((x1286)*(x1292)))+(((r02)*(x1294)))+(((IkReal(-1.00000000000000))*(cj5)*(x1285)*(x1295)))+(((r01)*(x1291)))+(((r00)*(x1293))));
evalcond[5]=((cj3)+(((x1287)*(x1292)))+(((r12)*(x1294)))+(((r11)*(x1291)))+(((r10)*(x1293)))+(((IkReal(-1.00000000000000))*(r10)*(x1288)*(x1295))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x1296=((IkReal(1.00000000000000))*(sj5));
if( IKabs(((((IKabs(sj2) != 0)?((IkReal)1/(sj2)):(IkReal)1.0e30))*(((((r21)*(sj5)*(sj6)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(x1296))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r01)*(sj6)*(x1296)))+(((cj6)*(r00)*(sj5)))+(((cj5)*(r02))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IKabs(sj2) != 0)?((IkReal)1/(sj2)):(IkReal)1.0e30))*(((((r21)*(sj5)*(sj6)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(x1296)))))))+IKsqr(((((IkReal(-1.00000000000000))*(r01)*(sj6)*(x1296)))+(((cj6)*(r00)*(sj5)))+(((cj5)*(r02)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IKabs(sj2) != 0)?((IkReal)1/(sj2)):(IkReal)1.0e30))*(((((r21)*(sj5)*(sj6)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(x1296)))))), ((((IkReal(-1.00000000000000))*(r01)*(sj6)*(x1296)))+(((cj6)*(r00)*(sj5)))+(((cj5)*(r02)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[3];
IkReal x1297=IKsin(j3);
IkReal x1298=((cj6)*(sj5));
IkReal x1299=((IkReal(1.00000000000000))*(sj5)*(sj6));
evalcond[0]=((((r20)*(x1298)))+(((cj5)*(r22)))+(((sj2)*(x1297)))+(((IkReal(-1.00000000000000))*(r21)*(x1299))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r01)*(x1299)))+(((IkReal(-1.00000000000000))*(IKcos(j3))))+(((r00)*(x1298)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((cj2)*(x1297)))+(((IkReal(-1.00000000000000))*(r11)*(x1299)))+(((r10)*(x1298))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst71;
IkReal x1300=(sj6)*(sj6);
IkReal x1301=(cj6)*(cj6);
IkReal x1302=((cj6)*(sj5));
IkReal x1303=((r00)*(r11));
IkReal x1304=((IkReal(1.00000000000000))*(r02));
IkReal x1305=((sj5)*(sj6));
IkReal x1306=((cj5)*(x1300));
IkReal x1307=((IkReal(1.00000000000000))*(r01)*(r10));
IkReal x1308=((cj5)*(x1301));
gconst71=IKsign(((((IkReal(-1.00000000000000))*(x1307)*(x1308)))+(((IkReal(-1.00000000000000))*(r10)*(x1304)*(x1305)))+(((IkReal(-1.00000000000000))*(x1306)*(x1307)))+(((IkReal(-1.00000000000000))*(r11)*(x1302)*(x1304)))+(((r01)*(r12)*(x1302)))+(((x1303)*(x1308)))+(((x1303)*(x1306)))+(((r00)*(r12)*(x1305)))));
IkReal x1309=(sj6)*(sj6);
IkReal x1310=(cj6)*(cj6);
IkReal x1311=((cj6)*(sj5));
IkReal x1312=((r00)*(r11));
IkReal x1313=((IkReal(1.00000000000000))*(r02));
IkReal x1314=((sj5)*(sj6));
IkReal x1315=((cj5)*(x1309));
IkReal x1316=((IkReal(1.00000000000000))*(r01)*(r10));
IkReal x1317=((cj5)*(x1310));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x1315)*(x1316)))+(((r01)*(r12)*(x1311)))+(((IkReal(-1.00000000000000))*(r10)*(x1313)*(x1314)))+(((IkReal(-1.00000000000000))*(r11)*(x1311)*(x1313)))+(((r00)*(r12)*(x1314)))+(((IkReal(-1.00000000000000))*(x1316)*(x1317)))+(((x1312)*(x1315)))+(((x1312)*(x1317))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst72;
IkReal x1318=(cj5)*(cj5);
IkReal x1319=(sj6)*(sj6);
IkReal x1320=(r01)*(r01);
IkReal x1321=(cj6)*(cj6);
IkReal x1322=(r00)*(r00);
IkReal x1323=((cj6)*(r00));
IkReal x1324=((IkReal(2.00000000000000))*(r01)*(sj6));
IkReal x1325=((cj5)*(r02)*(sj5));
IkReal x1326=((IkReal(1.00000000000000))*(x1319));
IkReal x1327=((IkReal(1.00000000000000))*(x1321));
gconst72=IKsign(((((IkReal(-1.00000000000000))*(x1323)*(x1324)))+(((IkReal(-1.00000000000000))*(x1324)*(x1325)))+(((IkReal(-1.00000000000000))*(x1318)*(x1322)*(x1327)))+(((x1318)*(x1323)*(x1324)))+(((IkReal(-1.00000000000000))*(x1322)*(x1326)))+(((IkReal(-1.00000000000000))*(x1318)*(x1320)*(x1326)))+(((IkReal(2.00000000000000))*(x1323)*(x1325)))+(((IkReal(-1.00000000000000))*((r02)*(r02))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x1320)*(x1327)))));
IkReal x1328=(cj5)*(cj5);
IkReal x1329=(sj6)*(sj6);
IkReal x1330=(r01)*(r01);
IkReal x1331=(cj6)*(cj6);
IkReal x1332=(r00)*(r00);
IkReal x1333=((cj6)*(r00));
IkReal x1334=((IkReal(2.00000000000000))*(r01)*(sj6));
IkReal x1335=((cj5)*(r02)*(sj5));
IkReal x1336=((IkReal(1.00000000000000))*(x1329));
IkReal x1337=((IkReal(1.00000000000000))*(x1331));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x1334)*(x1335)))+(((IkReal(2.00000000000000))*(x1333)*(x1335)))+(((IkReal(-1.00000000000000))*(x1330)*(x1337)))+(((IkReal(-1.00000000000000))*(x1333)*(x1334)))+(((IkReal(-1.00000000000000))*(x1332)*(x1336)))+(((x1328)*(x1333)*(x1334)))+(((IkReal(-1.00000000000000))*(x1328)*(x1330)*(x1336)))+(((IkReal(-1.00000000000000))*((r02)*(r02))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x1328)*(x1332)*(x1337))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1338=((cj5)*(sj3));
IkReal x1339=((IkReal(1.00000000000000))*(sj3));
if( IKabs(((gconst72)*(((((IkReal(-1.00000000000000))*(r00)*(sj6)*(x1339)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x1339))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst72)*(((((IkReal(-1.00000000000000))*(r01)*(sj6)*(x1338)))+(((IkReal(-1.00000000000000))*(r02)*(sj5)*(x1339)))+(((cj6)*(r00)*(x1338))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst72)*(((((IkReal(-1.00000000000000))*(r00)*(sj6)*(x1339)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x1339)))))), ((gconst72)*(((((IkReal(-1.00000000000000))*(r01)*(sj6)*(x1338)))+(((IkReal(-1.00000000000000))*(r02)*(sj5)*(x1339)))+(((cj6)*(r00)*(x1338)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1340=IKsin(j4);
IkReal x1341=IKcos(j4);
IkReal x1342=((IkReal(1.00000000000000))*(r00));
IkReal x1343=((cj5)*(r01));
IkReal x1344=((cj5)*(r11));
IkReal x1345=((IkReal(1.00000000000000))*(cj3));
IkReal x1346=((IkReal(1.00000000000000))*(cj5));
IkReal x1347=((cj5)*(r21));
IkReal x1348=((sj5)*(x1340));
IkReal x1349=((cj6)*(x1340));
IkReal x1350=((sj6)*(x1341));
IkReal x1351=((sj6)*(x1340));
IkReal x1352=((sj5)*(x1341));
IkReal x1353=((cj6)*(x1341));
evalcond[0]=((((IkReal(-1.00000000000000))*(r21)*(x1353)))+(((IkReal(-1.00000000000000))*(r20)*(x1346)*(x1349)))+(((r22)*(x1348)))+(((IkReal(-1.00000000000000))*(r20)*(x1350)))+(((x1347)*(x1351)))+(((IkReal(-1.00000000000000))*(cj2))));
evalcond[1]=((((r22)*(x1352)))+(((IkReal(-1.00000000000000))*(sj2)*(x1345)))+(((IkReal(-1.00000000000000))*(r20)*(x1346)*(x1353)))+(((r20)*(x1351)))+(((x1347)*(x1350)))+(((r21)*(x1349))));
evalcond[2]=((((IkReal(-1.00000000000000))*(cj5)*(x1342)*(x1349)))+(((r02)*(x1348)))+(((x1343)*(x1351)))+(((IkReal(-1.00000000000000))*(r01)*(x1353)))+(((IkReal(-1.00000000000000))*(x1342)*(x1350))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r10)*(x1346)*(x1349)))+(sj2)+(((IkReal(-1.00000000000000))*(r10)*(x1350)))+(((x1344)*(x1351)))+(((IkReal(-1.00000000000000))*(r11)*(x1353)))+(((r12)*(x1348))));
evalcond[4]=((((IkReal(-1.00000000000000))*(sj3)))+(((r02)*(x1352)))+(((IkReal(-1.00000000000000))*(cj5)*(x1342)*(x1353)))+(((r01)*(x1349)))+(((r00)*(x1351)))+(((x1343)*(x1350))));
evalcond[5]=((((r10)*(x1351)))+(((IkReal(-1.00000000000000))*(r10)*(x1346)*(x1353)))+(((x1344)*(x1350)))+(((IkReal(-1.00000000000000))*(cj2)*(x1345)))+(((r11)*(x1349)))+(((r12)*(x1352))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1354=((IkReal(1.00000000000000))*(sj2));
if( IKabs(((gconst71)*(((((IkReal(-1.00000000000000))*(cj6)*(r01)*(x1354)))+(((IkReal(-1.00000000000000))*(r00)*(sj6)*(x1354))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst71)*(((((IkReal(-1.00000000000000))*(r02)*(sj5)*(x1354)))+(((cj5)*(cj6)*(r00)*(sj2)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(sj6)*(x1354))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst71)*(((((IkReal(-1.00000000000000))*(cj6)*(r01)*(x1354)))+(((IkReal(-1.00000000000000))*(r00)*(sj6)*(x1354)))))), ((gconst71)*(((((IkReal(-1.00000000000000))*(r02)*(sj5)*(x1354)))+(((cj5)*(cj6)*(r00)*(sj2)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(sj6)*(x1354)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1355=IKsin(j4);
IkReal x1356=IKcos(j4);
IkReal x1357=((IkReal(1.00000000000000))*(r00));
IkReal x1358=((cj5)*(r01));
IkReal x1359=((cj5)*(r11));
IkReal x1360=((IkReal(1.00000000000000))*(cj3));
IkReal x1361=((IkReal(1.00000000000000))*(cj5));
IkReal x1362=((cj5)*(r21));
IkReal x1363=((sj5)*(x1355));
IkReal x1364=((cj6)*(x1355));
IkReal x1365=((sj6)*(x1356));
IkReal x1366=((sj6)*(x1355));
IkReal x1367=((sj5)*(x1356));
IkReal x1368=((cj6)*(x1356));
evalcond[0]=((((IkReal(-1.00000000000000))*(r20)*(x1361)*(x1364)))+(((IkReal(-1.00000000000000))*(r21)*(x1368)))+(((r22)*(x1363)))+(((IkReal(-1.00000000000000))*(r20)*(x1365)))+(((IkReal(-1.00000000000000))*(cj2)))+(((x1362)*(x1366))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r20)*(x1361)*(x1368)))+(((r22)*(x1367)))+(((IkReal(-1.00000000000000))*(sj2)*(x1360)))+(((r20)*(x1366)))+(((r21)*(x1364)))+(((x1362)*(x1365))));
evalcond[2]=((((r02)*(x1363)))+(((x1358)*(x1366)))+(((IkReal(-1.00000000000000))*(cj5)*(x1357)*(x1364)))+(((IkReal(-1.00000000000000))*(x1357)*(x1365)))+(((IkReal(-1.00000000000000))*(r01)*(x1368))));
evalcond[3]=((sj2)+(((x1359)*(x1366)))+(((IkReal(-1.00000000000000))*(r10)*(x1365)))+(((IkReal(-1.00000000000000))*(r10)*(x1361)*(x1364)))+(((IkReal(-1.00000000000000))*(r11)*(x1368)))+(((r12)*(x1363))));
evalcond[4]=((((IkReal(-1.00000000000000))*(sj3)))+(((r02)*(x1367)))+(((x1358)*(x1365)))+(((IkReal(-1.00000000000000))*(cj5)*(x1357)*(x1368)))+(((r01)*(x1364)))+(((r00)*(x1366))));
evalcond[5]=((((r10)*(x1366)))+(((IkReal(-1.00000000000000))*(cj2)*(x1360)))+(((x1359)*(x1365)))+(((IkReal(-1.00000000000000))*(r10)*(x1361)*(x1368)))+(((r11)*(x1364)))+(((r12)*(x1367))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1369=((IkReal(1.00000000000000))*(cj2));
IkReal x1370=((sj6)*(x1369));
if( IKabs(((gconst70)*(((((IkReal(-1.00000000000000))*(r00)*(x1370)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x1369))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst70)*(((((IkReal(-1.00000000000000))*(r02)*(sj5)*(x1369)))+(((cj2)*(cj5)*(cj6)*(r00)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(x1370))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst70)*(((((IkReal(-1.00000000000000))*(r00)*(x1370)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x1369)))))), ((gconst70)*(((((IkReal(-1.00000000000000))*(r02)*(sj5)*(x1369)))+(((cj2)*(cj5)*(cj6)*(r00)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(x1370)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x1371=IKsin(j4);
IkReal x1372=IKcos(j4);
IkReal x1373=((IkReal(1.00000000000000))*(cj6));
IkReal x1374=((sj5)*(x1371));
IkReal x1375=((cj5)*(x1371));
IkReal x1376=((IkReal(1.00000000000000))*(sj6)*(x1372));
evalcond[0]=((((IkReal(-1.00000000000000))*(r20)*(x1373)*(x1375)))+(((IkReal(-1.00000000000000))*(r20)*(x1376)))+(((r22)*(x1374)))+(((r21)*(sj6)*(x1375)))+(((IkReal(-1.00000000000000))*(r21)*(x1372)*(x1373)))+(((IkReal(-1.00000000000000))*(cj2))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r00)*(x1376)))+(((r01)*(sj6)*(x1375)))+(((IkReal(-1.00000000000000))*(r00)*(x1373)*(x1375)))+(((r02)*(x1374)))+(((IkReal(-1.00000000000000))*(r01)*(x1372)*(x1373))));
evalcond[2]=((sj2)+(((IkReal(-1.00000000000000))*(r10)*(x1373)*(x1375)))+(((IkReal(-1.00000000000000))*(r11)*(x1372)*(x1373)))+(((r12)*(x1374)))+(((r11)*(sj6)*(x1375)))+(((IkReal(-1.00000000000000))*(r10)*(x1376))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x1377=((cj4)*(cj5));
IkReal x1378=((r01)*(sj6));
IkReal x1379=((cj6)*(r00));
if( IKabs(((((r00)*(sj4)*(sj6)))+(((cj6)*(r01)*(sj4)))+(((x1377)*(x1378)))+(((cj4)*(r02)*(sj5)))+(((IkReal(-1.00000000000000))*(x1377)*(x1379))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((sj5)*(x1379)))+(((IkReal(-1.00000000000000))*(sj5)*(x1378)))+(((cj5)*(r02))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((r00)*(sj4)*(sj6)))+(((cj6)*(r01)*(sj4)))+(((x1377)*(x1378)))+(((cj4)*(r02)*(sj5)))+(((IkReal(-1.00000000000000))*(x1377)*(x1379)))))+IKsqr(((((sj5)*(x1379)))+(((IkReal(-1.00000000000000))*(sj5)*(x1378)))+(((cj5)*(r02)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((r00)*(sj4)*(sj6)))+(((cj6)*(r01)*(sj4)))+(((x1377)*(x1378)))+(((cj4)*(r02)*(sj5)))+(((IkReal(-1.00000000000000))*(x1377)*(x1379)))), ((((sj5)*(x1379)))+(((IkReal(-1.00000000000000))*(sj5)*(x1378)))+(((cj5)*(r02)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x1380=IKsin(j3);
IkReal x1381=IKcos(j3);
IkReal x1382=((r11)*(sj6));
IkReal x1383=((IkReal(1.00000000000000))*(sj5));
IkReal x1384=((cj6)*(sj4));
IkReal x1385=((sj4)*(sj6));
IkReal x1386=((cj4)*(sj5));
IkReal x1387=((cj4)*(cj5));
IkReal x1388=((r01)*(sj6));
IkReal x1389=((r21)*(sj6));
IkReal x1390=((cj6)*(sj5));
IkReal x1391=((IkReal(1.00000000000000))*(x1381));
IkReal x1392=((IkReal(1.00000000000000))*(cj6)*(x1387));
evalcond[0]=((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(x1383)*(x1389)))+(((r20)*(x1390)))+(((sj2)*(x1380))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1383)*(x1388)))+(((r00)*(x1390)))+(((IkReal(-1.00000000000000))*(x1391)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((r10)*(x1390)))+(((cj2)*(x1380)))+(((IkReal(-1.00000000000000))*(x1382)*(x1383))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r20)*(x1392)))+(((r21)*(x1384)))+(((r20)*(x1385)))+(((x1387)*(x1389)))+(((r22)*(x1386)))+(((IkReal(-1.00000000000000))*(sj2)*(x1391))));
evalcond[4]=((((x1387)*(x1388)))+(((IkReal(-1.00000000000000))*(r00)*(x1392)))+(((IkReal(-1.00000000000000))*(x1380)))+(((r00)*(x1385)))+(((r01)*(x1384)))+(((r02)*(x1386))));
evalcond[5]=((((r10)*(x1385)))+(((IkReal(-1.00000000000000))*(r10)*(x1392)))+(((IkReal(-1.00000000000000))*(cj2)*(x1391)))+(((r11)*(x1384)))+(((r12)*(x1386)))+(((x1382)*(x1387))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1393=((IkReal(1.00000000000000))*(sj2));
if( IKabs(((gconst69)*(((((IkReal(-1.00000000000000))*(cj6)*(r01)*(x1393)))+(((IkReal(-1.00000000000000))*(r00)*(sj6)*(x1393))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst69)*(((((IkReal(-1.00000000000000))*(cj5)*(r01)*(sj6)*(x1393)))+(((IkReal(-1.00000000000000))*(r02)*(sj5)*(x1393)))+(((cj5)*(cj6)*(r00)*(sj2))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst69)*(((((IkReal(-1.00000000000000))*(cj6)*(r01)*(x1393)))+(((IkReal(-1.00000000000000))*(r00)*(sj6)*(x1393)))))), ((gconst69)*(((((IkReal(-1.00000000000000))*(cj5)*(r01)*(sj6)*(x1393)))+(((IkReal(-1.00000000000000))*(r02)*(sj5)*(x1393)))+(((cj5)*(cj6)*(r00)*(sj2)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x1394=IKsin(j4);
IkReal x1395=IKcos(j4);
IkReal x1396=((IkReal(1.00000000000000))*(cj6));
IkReal x1397=((sj5)*(x1394));
IkReal x1398=((cj5)*(x1394));
IkReal x1399=((IkReal(1.00000000000000))*(sj6)*(x1395));
evalcond[0]=((((IkReal(-1.00000000000000))*(r21)*(x1395)*(x1396)))+(((IkReal(-1.00000000000000))*(r20)*(x1399)))+(((r21)*(sj6)*(x1398)))+(((r22)*(x1397)))+(((IkReal(-1.00000000000000))*(cj2)))+(((IkReal(-1.00000000000000))*(r20)*(x1396)*(x1398))));
evalcond[1]=((((r01)*(sj6)*(x1398)))+(((IkReal(-1.00000000000000))*(r01)*(x1395)*(x1396)))+(((IkReal(-1.00000000000000))*(r00)*(x1399)))+(((IkReal(-1.00000000000000))*(r00)*(x1396)*(x1398)))+(((r02)*(x1397))));
evalcond[2]=((sj2)+(((r11)*(sj6)*(x1398)))+(((IkReal(-1.00000000000000))*(r10)*(x1399)))+(((IkReal(-1.00000000000000))*(r10)*(x1396)*(x1398)))+(((r12)*(x1397)))+(((IkReal(-1.00000000000000))*(r11)*(x1395)*(x1396))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x1400=((cj4)*(cj5));
IkReal x1401=((r01)*(sj6));
IkReal x1402=((cj6)*(r00));
if( IKabs(((((r00)*(sj4)*(sj6)))+(((cj6)*(r01)*(sj4)))+(((IkReal(-1.00000000000000))*(x1400)*(x1402)))+(((cj4)*(r02)*(sj5)))+(((x1400)*(x1401))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(sj5)*(x1401)))+(((sj5)*(x1402)))+(((cj5)*(r02))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((r00)*(sj4)*(sj6)))+(((cj6)*(r01)*(sj4)))+(((IkReal(-1.00000000000000))*(x1400)*(x1402)))+(((cj4)*(r02)*(sj5)))+(((x1400)*(x1401)))))+IKsqr(((((IkReal(-1.00000000000000))*(sj5)*(x1401)))+(((sj5)*(x1402)))+(((cj5)*(r02)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((r00)*(sj4)*(sj6)))+(((cj6)*(r01)*(sj4)))+(((IkReal(-1.00000000000000))*(x1400)*(x1402)))+(((cj4)*(r02)*(sj5)))+(((x1400)*(x1401)))), ((((IkReal(-1.00000000000000))*(sj5)*(x1401)))+(((sj5)*(x1402)))+(((cj5)*(r02)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x1403=IKsin(j3);
IkReal x1404=IKcos(j3);
IkReal x1405=((r11)*(sj6));
IkReal x1406=((IkReal(1.00000000000000))*(sj5));
IkReal x1407=((cj6)*(sj4));
IkReal x1408=((sj4)*(sj6));
IkReal x1409=((cj4)*(sj5));
IkReal x1410=((cj4)*(cj5));
IkReal x1411=((r01)*(sj6));
IkReal x1412=((r21)*(sj6));
IkReal x1413=((cj6)*(sj5));
IkReal x1414=((IkReal(1.00000000000000))*(x1404));
IkReal x1415=((IkReal(1.00000000000000))*(cj6)*(x1410));
evalcond[0]=((((cj5)*(r22)))+(((r20)*(x1413)))+(((sj2)*(x1403)))+(((IkReal(-1.00000000000000))*(x1406)*(x1412))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1414)))+(((r00)*(x1413)))+(((IkReal(-1.00000000000000))*(x1406)*(x1411)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x1405)*(x1406)))+(((r10)*(x1413)))+(((cj2)*(x1403))));
evalcond[3]=((((r20)*(x1408)))+(((r21)*(x1407)))+(((x1410)*(x1412)))+(((IkReal(-1.00000000000000))*(sj2)*(x1414)))+(((IkReal(-1.00000000000000))*(r20)*(x1415)))+(((r22)*(x1409))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x1403)))+(((r02)*(x1409)))+(((r00)*(x1408)))+(((r01)*(x1407)))+(((x1410)*(x1411)))+(((IkReal(-1.00000000000000))*(r00)*(x1415))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(x1415)))+(((IkReal(-1.00000000000000))*(cj2)*(x1414)))+(((r12)*(x1409)))+(((r11)*(x1407)))+(((x1405)*(x1410)))+(((r10)*(x1408))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
}
}

}

}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}
}
}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x1416=((IkReal(195.000000000000))*(cj5));
IkReal x1417=((IkReal(0.250000000000000))*(cj6));
IkReal x1418=((IkReal(0.250000000000000))*(sj6));
IkReal x1419=((IkReal(195.000000000000))*(cj6)*(sj5));
IkReal x1420=((IkReal(195.000000000000))*(sj5)*(sj6));
if( IKabs(((((IKabs(sj1) != 0)?((IkReal)1/(sj1)):(IkReal)1.0e30))*(((((IkReal(-500.000000000000))*(py)))+(((IkReal(-1.00000000000000))*(r11)*(x1420)))+(((r11)*(x1417)))+(((r12)*(x1416)))+(((r10)*(x1418)))+(((r10)*(x1419)))+(((IkReal(200.000000000000))*(cj1))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((r21)*(x1417)))+(((r20)*(x1418)))+(((r20)*(x1419)))+(((IkReal(-1.00000000000000))*(r21)*(x1420)))+(((IkReal(-500.000000000000))*(pz)))+(((r22)*(x1416))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IKabs(sj1) != 0)?((IkReal)1/(sj1)):(IkReal)1.0e30))*(((((IkReal(-500.000000000000))*(py)))+(((IkReal(-1.00000000000000))*(r11)*(x1420)))+(((r11)*(x1417)))+(((r12)*(x1416)))+(((r10)*(x1418)))+(((r10)*(x1419)))+(((IkReal(200.000000000000))*(cj1)))))))+IKsqr(((((r21)*(x1417)))+(((r20)*(x1418)))+(((r20)*(x1419)))+(((IkReal(-1.00000000000000))*(r21)*(x1420)))+(((IkReal(-500.000000000000))*(pz)))+(((r22)*(x1416)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((((IKabs(sj1) != 0)?((IkReal)1/(sj1)):(IkReal)1.0e30))*(((((IkReal(-500.000000000000))*(py)))+(((IkReal(-1.00000000000000))*(r11)*(x1420)))+(((r11)*(x1417)))+(((r12)*(x1416)))+(((r10)*(x1418)))+(((r10)*(x1419)))+(((IkReal(200.000000000000))*(cj1)))))), ((((r21)*(x1417)))+(((r20)*(x1418)))+(((r20)*(x1419)))+(((IkReal(-1.00000000000000))*(r21)*(x1420)))+(((IkReal(-500.000000000000))*(pz)))+(((r22)*(x1416)))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[3];
IkReal x1421=IKsin(j2);
IkReal x1422=((IkReal(0.390000000000000))*(sj5));
IkReal x1423=((IkReal(0.390000000000000))*(cj5));
IkReal x1424=((IkReal(0.000500000000000000))*(cj6));
IkReal x1425=((IkReal(0.000500000000000000))*(sj6));
IkReal x1426=((IkReal(0.00200000000000000))*(x1421));
evalcond[0]=((((r21)*(x1424)))+(((IkReal(-0.00200000000000000))*(IKcos(j2))))+(((r22)*(x1423)))+(((IkReal(-1.00000000000000))*(pz)))+(((cj6)*(r20)*(x1422)))+(((r20)*(x1425)))+(((IkReal(-1.00000000000000))*(r21)*(sj6)*(x1422))));
evalcond[1]=((((r01)*(x1424)))+(((cj6)*(r00)*(x1422)))+(((r00)*(x1425)))+(((IkReal(-1.00000000000000))*(px)))+(((IkReal(-1.00000000000000))*(r01)*(sj6)*(x1422)))+(((r02)*(x1423)))+(((IkReal(-0.400000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(cj1)*(x1426))));
evalcond[2]=((((r11)*(x1424)))+(((IkReal(0.400000000000000))*(cj1)))+(((r10)*(x1425)))+(((IkReal(-1.00000000000000))*(sj1)*(x1426)))+(((IkReal(-1.00000000000000))*(py)))+(((IkReal(-1.00000000000000))*(r11)*(sj6)*(x1422)))+(((cj6)*(r10)*(x1422)))+(((r12)*(x1423))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst0;
IkReal x1427=(sj6)*(sj6);
IkReal x1428=(cj6)*(cj6);
IkReal x1429=((IkReal(1.00000000000000))*(r20));
IkReal x1430=((r00)*(r21));
IkReal x1431=((r22)*(sj5));
IkReal x1432=((r02)*(sj5));
IkReal x1433=((cj5)*(x1427));
IkReal x1434=((cj5)*(x1428));
gconst0=IKsign(((((IkReal(-1.00000000000000))*(r01)*(x1429)*(x1433)))+(((IkReal(-1.00000000000000))*(r01)*(x1429)*(x1434)))+(((x1430)*(x1434)))+(((x1430)*(x1433)))+(((IkReal(-1.00000000000000))*(sj6)*(x1429)*(x1432)))+(((r00)*(sj6)*(x1431)))+(((cj6)*(r01)*(x1431)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x1432)))));
IkReal x1435=(sj6)*(sj6);
IkReal x1436=(cj6)*(cj6);
IkReal x1437=((IkReal(1.00000000000000))*(r20));
IkReal x1438=((r00)*(r21));
IkReal x1439=((r22)*(sj5));
IkReal x1440=((r02)*(sj5));
IkReal x1441=((cj5)*(x1435));
IkReal x1442=((cj5)*(x1436));
dummyeval[0]=((((x1438)*(x1442)))+(((x1438)*(x1441)))+(((IkReal(-1.00000000000000))*(r01)*(x1437)*(x1442)))+(((IkReal(-1.00000000000000))*(r01)*(x1437)*(x1441)))+(((r00)*(sj6)*(x1439)))+(((IkReal(-1.00000000000000))*(sj6)*(x1437)*(x1440)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x1440)))+(((cj6)*(r01)*(x1439))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst1;
IkReal x1443=(sj6)*(sj6);
IkReal x1444=(cj6)*(cj6);
IkReal x1445=((cj6)*(sj5));
IkReal x1446=((r10)*(r21));
IkReal x1447=((IkReal(1.00000000000000))*(r12));
IkReal x1448=((sj5)*(sj6));
IkReal x1449=((cj5)*(x1444));
IkReal x1450=((IkReal(1.00000000000000))*(r11)*(r20));
IkReal x1451=((cj5)*(x1443));
gconst1=IKsign(((((x1446)*(x1451)))+(((IkReal(-1.00000000000000))*(r21)*(x1445)*(x1447)))+(((IkReal(-1.00000000000000))*(r20)*(x1447)*(x1448)))+(((r10)*(r22)*(x1448)))+(((r11)*(r22)*(x1445)))+(((IkReal(-1.00000000000000))*(x1449)*(x1450)))+(((x1446)*(x1449)))+(((IkReal(-1.00000000000000))*(x1450)*(x1451)))));
IkReal x1452=(sj6)*(sj6);
IkReal x1453=(cj6)*(cj6);
IkReal x1454=((cj6)*(sj5));
IkReal x1455=((r10)*(r21));
IkReal x1456=((IkReal(1.00000000000000))*(r12));
IkReal x1457=((sj5)*(sj6));
IkReal x1458=((cj5)*(x1453));
IkReal x1459=((IkReal(1.00000000000000))*(r11)*(r20));
IkReal x1460=((cj5)*(x1452));
dummyeval[0]=((((IkReal(-1.00000000000000))*(r20)*(x1456)*(x1457)))+(((x1455)*(x1458)))+(((IkReal(-1.00000000000000))*(x1458)*(x1459)))+(((r11)*(r22)*(x1454)))+(((IkReal(-1.00000000000000))*(x1459)*(x1460)))+(((x1455)*(x1460)))+(((IkReal(-1.00000000000000))*(r21)*(x1454)*(x1456)))+(((r10)*(r22)*(x1457))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[2];
IkReal x1461=(sj1)*(sj1);
IkReal x1462=(cj1)*(cj1);
dummyeval[0]=((((cj2)*(x1462)))+(((cj2)*(x1461))));
dummyeval[1]=((x1461)+(x1462));
if( IKabs(dummyeval[0]) < 0.0000010000000000  || IKabs(dummyeval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[4];
IkReal x1463=((IkReal(0.390000000000000))*(sj5));
IkReal x1464=((IkReal(0.390000000000000))*(cj5));
IkReal x1465=((IkReal(0.000500000000000000))*(cj6));
IkReal x1466=((IkReal(0.000500000000000000))*(sj6));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((cj6)*(r20)*(x1463)))+(((r20)*(x1466)))+(((IkReal(-1.00000000000000))*(r21)*(sj6)*(x1463)))+(((IkReal(-1.00000000000000))*(pz)))+(((r22)*(x1464)))+(((r21)*(x1465))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r01)*(sj6)*(x1463)))+(((r01)*(x1465)))+(((r00)*(x1466)))+(((cj6)*(r00)*(x1463)))+(((IkReal(-1.00000000000000))*(px)))+(((r02)*(x1464)))+(((IkReal(-0.00200000000000000))*(cj1)))+(((IkReal(-0.400000000000000))*(sj1))));
evalcond[3]=((((IkReal(0.400000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(py)))+(((r12)*(x1464)))+(((IkReal(-0.00200000000000000))*(sj1)))+(((r11)*(x1465)))+(((r10)*(x1466)))+(((cj6)*(r10)*(x1463)))+(((IkReal(-1.00000000000000))*(r11)*(sj6)*(x1463))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst9;
IkReal x1467=(sj6)*(sj6);
IkReal x1468=(cj6)*(cj6);
IkReal x1469=((IkReal(1.00000000000000))*(r20));
IkReal x1470=((r00)*(r21));
IkReal x1471=((r22)*(sj5));
IkReal x1472=((r02)*(sj5));
IkReal x1473=((cj5)*(x1467));
IkReal x1474=((cj5)*(x1468));
gconst9=IKsign(((((r00)*(sj6)*(x1471)))+(((cj6)*(r01)*(x1471)))+(((IkReal(-1.00000000000000))*(sj6)*(x1469)*(x1472)))+(((x1470)*(x1474)))+(((x1470)*(x1473)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x1472)))+(((IkReal(-1.00000000000000))*(r01)*(x1469)*(x1473)))+(((IkReal(-1.00000000000000))*(r01)*(x1469)*(x1474)))));
IkReal x1475=(sj6)*(sj6);
IkReal x1476=(cj6)*(cj6);
IkReal x1477=((IkReal(1.00000000000000))*(r20));
IkReal x1478=((r00)*(r21));
IkReal x1479=((r22)*(sj5));
IkReal x1480=((r02)*(sj5));
IkReal x1481=((cj5)*(x1475));
IkReal x1482=((cj5)*(x1476));
dummyeval[0]=((((r00)*(sj6)*(x1479)))+(((cj6)*(r01)*(x1479)))+(((IkReal(-1.00000000000000))*(sj6)*(x1477)*(x1480)))+(((IkReal(-1.00000000000000))*(r01)*(x1477)*(x1481)))+(((IkReal(-1.00000000000000))*(r01)*(x1477)*(x1482)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x1480)))+(((x1478)*(x1482)))+(((x1478)*(x1481))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst10;
IkReal x1483=(sj6)*(sj6);
IkReal x1484=(cj6)*(cj6);
IkReal x1485=((cj6)*(sj5));
IkReal x1486=((r10)*(r21));
IkReal x1487=((IkReal(1.00000000000000))*(r12));
IkReal x1488=((sj5)*(sj6));
IkReal x1489=((cj5)*(x1484));
IkReal x1490=((IkReal(1.00000000000000))*(r11)*(r20));
IkReal x1491=((cj5)*(x1483));
gconst10=IKsign(((((IkReal(-1.00000000000000))*(r20)*(x1487)*(x1488)))+(((x1486)*(x1491)))+(((r10)*(r22)*(x1488)))+(((x1486)*(x1489)))+(((r11)*(r22)*(x1485)))+(((IkReal(-1.00000000000000))*(r21)*(x1485)*(x1487)))+(((IkReal(-1.00000000000000))*(x1490)*(x1491)))+(((IkReal(-1.00000000000000))*(x1489)*(x1490)))));
IkReal x1492=(sj6)*(sj6);
IkReal x1493=(cj6)*(cj6);
IkReal x1494=((cj6)*(sj5));
IkReal x1495=((r10)*(r21));
IkReal x1496=((IkReal(1.00000000000000))*(r12));
IkReal x1497=((sj5)*(sj6));
IkReal x1498=((cj5)*(x1493));
IkReal x1499=((IkReal(1.00000000000000))*(r11)*(r20));
IkReal x1500=((cj5)*(x1492));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x1499)*(x1500)))+(((x1495)*(x1498)))+(((r11)*(r22)*(x1494)))+(((r10)*(r22)*(x1497)))+(((x1495)*(x1500)))+(((IkReal(-1.00000000000000))*(r20)*(x1496)*(x1497)))+(((IkReal(-1.00000000000000))*(x1498)*(x1499)))+(((IkReal(-1.00000000000000))*(r21)*(x1494)*(x1496))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=cj1;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
IkReal x1501=((IkReal(0.000500000000000000))*(cj6));
IkReal x1502=((IkReal(0.000500000000000000))*(sj6));
IkReal x1503=((sj5)*(sj6));
IkReal x1504=((cj5)*(r12));
IkReal x1505=((IkReal(0.390000000000000))*(cj5));
IkReal x1506=((IkReal(0.390000000000000))*(cj6)*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((((cj6)*(r10)*(sj5)))+(x1504)+(((IkReal(-1.00000000000000))*(r11)*(x1503))));
evalcond[2]=((((r20)*(x1506)))+(((r20)*(x1502)))+(((IkReal(-1.00000000000000))*(pz)))+(((IkReal(-0.390000000000000))*(r21)*(x1503)))+(((r21)*(x1501)))+(((r22)*(x1505))));
evalcond[3]=((IkReal(-0.400000000000000))+(((r01)*(x1501)))+(((r00)*(x1506)))+(((r00)*(x1502)))+(((IkReal(-1.00000000000000))*(px)))+(((IkReal(-0.390000000000000))*(r01)*(x1503)))+(((r02)*(x1505))));
evalcond[4]=((IkReal(-0.00200000000000000))+(((IkReal(0.390000000000000))*(x1504)))+(((r11)*(x1501)))+(((r10)*(x1506)))+(((r10)*(x1502)))+(((IkReal(-0.390000000000000))*(r11)*(x1503)))+(((IkReal(-1.00000000000000))*(py))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x1507=((sj5)*(sj6));
IkReal x1508=((IkReal(1.00000000000000))*(cj5));
IkReal x1509=((IkReal(1.00000000000000))*(cj6)*(sj5));
if( IKabs(((((IkReal(-1.00000000000000))*(r20)*(x1509)))+(((IkReal(-1.00000000000000))*(r22)*(x1508)))+(((r21)*(x1507))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r00)*(x1509)))+(((r01)*(x1507)))+(((IkReal(-1.00000000000000))*(r02)*(x1508))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(r20)*(x1509)))+(((IkReal(-1.00000000000000))*(r22)*(x1508)))+(((r21)*(x1507)))))+IKsqr(((((IkReal(-1.00000000000000))*(r00)*(x1509)))+(((r01)*(x1507)))+(((IkReal(-1.00000000000000))*(r02)*(x1508)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(r20)*(x1509)))+(((IkReal(-1.00000000000000))*(r22)*(x1508)))+(((r21)*(x1507)))), ((((IkReal(-1.00000000000000))*(r00)*(x1509)))+(((r01)*(x1507)))+(((IkReal(-1.00000000000000))*(r02)*(x1508)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x1510=((cj6)*(sj5));
IkReal x1511=((IkReal(1.00000000000000))*(sj5)*(sj6));
evalcond[0]=((((cj5)*(r22)))+(((r20)*(x1510)))+(IKsin(j3))+(((IkReal(-1.00000000000000))*(r21)*(x1511))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r01)*(x1511)))+(((r00)*(x1510)))+(IKcos(j3))+(((cj5)*(r02))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst15;
IkReal x1512=(sj6)*(sj6);
IkReal x1513=(cj6)*(cj6);
IkReal x1514=((r01)*(r10));
IkReal x1515=((IkReal(1.00000000000000))*(r00));
IkReal x1516=((r02)*(sj5));
IkReal x1517=((r12)*(sj5));
IkReal x1518=((cj5)*(x1512));
IkReal x1519=((cj5)*(x1513));
gconst15=IKsign(((((IkReal(-1.00000000000000))*(r11)*(x1515)*(x1518)))+(((IkReal(-1.00000000000000))*(r11)*(x1515)*(x1519)))+(((x1514)*(x1518)))+(((x1514)*(x1519)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x1517)))+(((r10)*(sj6)*(x1516)))+(((IkReal(-1.00000000000000))*(sj6)*(x1515)*(x1517)))+(((cj6)*(r11)*(x1516)))));
IkReal x1520=(sj6)*(sj6);
IkReal x1521=(cj6)*(cj6);
IkReal x1522=((r01)*(r10));
IkReal x1523=((IkReal(1.00000000000000))*(r00));
IkReal x1524=((r02)*(sj5));
IkReal x1525=((r12)*(sj5));
IkReal x1526=((cj5)*(x1520));
IkReal x1527=((cj5)*(x1521));
dummyeval[0]=((((cj6)*(r11)*(x1524)))+(((x1522)*(x1527)))+(((x1522)*(x1526)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x1525)))+(((r10)*(sj6)*(x1524)))+(((IkReal(-1.00000000000000))*(sj6)*(x1523)*(x1525)))+(((IkReal(-1.00000000000000))*(r11)*(x1523)*(x1526)))+(((IkReal(-1.00000000000000))*(r11)*(x1523)*(x1527))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst16;
IkReal x1528=(cj5)*(cj5);
IkReal x1529=(sj6)*(sj6);
IkReal x1530=(cj6)*(cj6);
IkReal x1531=((r00)*(r20));
IkReal x1532=((cj5)*(sj5));
IkReal x1533=((r01)*(r21));
IkReal x1534=((r21)*(sj6));
IkReal x1535=((sj6)*(x1532));
IkReal x1536=((IkReal(1.00000000000000))*(cj6)*(r00));
IkReal x1537=((cj6)*(r01)*(r20)*(sj6));
gconst16=IKsign(((((r01)*(r22)*(x1535)))+(((r02)*(x1532)*(x1534)))+(((x1528)*(x1530)*(x1531)))+(((cj6)*(r00)*(x1534)))+(((IkReal(-1.00000000000000))*(x1528)*(x1534)*(x1536)))+(((IkReal(-1.00000000000000))*(r22)*(x1532)*(x1536)))+(((x1530)*(x1533)))+(((IkReal(-1.00000000000000))*(x1528)*(x1537)))+(((IkReal(-1.00000000000000))*(cj6)*(r02)*(r20)*(x1532)))+(x1537)+(((x1529)*(x1531)))+(((r02)*(r22)*((sj5)*(sj5))))+(((x1528)*(x1529)*(x1533)))));
IkReal x1538=(cj5)*(cj5);
IkReal x1539=(sj6)*(sj6);
IkReal x1540=(cj6)*(cj6);
IkReal x1541=((r00)*(r20));
IkReal x1542=((cj5)*(sj5));
IkReal x1543=((r01)*(r21));
IkReal x1544=((r21)*(sj6));
IkReal x1545=((sj6)*(x1542));
IkReal x1546=((IkReal(1.00000000000000))*(cj6)*(r00));
IkReal x1547=x1537;
dummyeval[0]=((((r02)*(x1542)*(x1544)))+(((x1539)*(x1541)))+(((IkReal(-1.00000000000000))*(r22)*(x1542)*(x1546)))+(((x1538)*(x1540)*(x1541)))+(x1547)+(((r01)*(r22)*(x1545)))+(((x1538)*(x1539)*(x1543)))+(((r02)*(r22)*((sj5)*(sj5))))+(((x1540)*(x1543)))+(((IkReal(-1.00000000000000))*(x1538)*(x1544)*(x1546)))+(((IkReal(-1.00000000000000))*(cj6)*(r02)*(r20)*(x1542)))+(((cj6)*(r00)*(x1544)))+(((IkReal(-1.00000000000000))*(x1538)*(x1547))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1548=((IkReal(1.00000000000000))*(sj3));
if( IKabs(((gconst16)*(((((IkReal(-1.00000000000000))*(cj6)*(r21)*(x1548)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x1548))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst16)*(((((IkReal(-1.00000000000000))*(r22)*(sj5)*(x1548)))+(((IkReal(-1.00000000000000))*(cj5)*(r21)*(sj6)*(x1548)))+(((cj5)*(cj6)*(r20)*(sj3))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst16)*(((((IkReal(-1.00000000000000))*(cj6)*(r21)*(x1548)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x1548)))))), ((gconst16)*(((((IkReal(-1.00000000000000))*(r22)*(sj5)*(x1548)))+(((IkReal(-1.00000000000000))*(cj5)*(r21)*(sj6)*(x1548)))+(((cj5)*(cj6)*(r20)*(sj3)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1549=IKsin(j4);
IkReal x1550=IKcos(j4);
IkReal x1551=((IkReal(1.00000000000000))*(r00));
IkReal x1552=((cj5)*(r01));
IkReal x1553=((cj5)*(r11));
IkReal x1554=((IkReal(1.00000000000000))*(cj5));
IkReal x1555=((cj5)*(r21));
IkReal x1556=((sj5)*(x1549));
IkReal x1557=((cj6)*(x1549));
IkReal x1558=((sj6)*(x1550));
IkReal x1559=((sj6)*(x1549));
IkReal x1560=((sj5)*(x1550));
IkReal x1561=((cj6)*(x1550));
evalcond[0]=((((x1555)*(x1559)))+(((IkReal(-1.00000000000000))*(r21)*(x1561)))+(((r22)*(x1556)))+(((IkReal(-1.00000000000000))*(r20)*(x1554)*(x1557)))+(((IkReal(-1.00000000000000))*(r20)*(x1558))));
evalcond[1]=((((x1555)*(x1558)))+(((r22)*(x1560)))+(((r21)*(x1557)))+(((r20)*(x1559)))+(((IkReal(-1.00000000000000))*(cj3)))+(((IkReal(-1.00000000000000))*(r20)*(x1554)*(x1561))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r01)*(x1561)))+(((x1552)*(x1559)))+(((IkReal(-1.00000000000000))*(cj5)*(x1551)*(x1557)))+(((r02)*(x1556)))+(((IkReal(-1.00000000000000))*(x1551)*(x1558))));
evalcond[3]=((IkReal(-1.00000000000000))+(((x1553)*(x1559)))+(((IkReal(-1.00000000000000))*(r10)*(x1554)*(x1557)))+(((r12)*(x1556)))+(((IkReal(-1.00000000000000))*(r10)*(x1558)))+(((IkReal(-1.00000000000000))*(r11)*(x1561))));
evalcond[4]=((((r00)*(x1559)))+(((r01)*(x1557)))+(((IkReal(-1.00000000000000))*(cj5)*(x1551)*(x1561)))+(sj3)+(((x1552)*(x1558)))+(((r02)*(x1560))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(x1554)*(x1561)))+(((x1553)*(x1558)))+(((r11)*(x1557)))+(((r12)*(x1560)))+(((r10)*(x1559))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1562=((cj5)*(sj3));
IkReal x1563=((IkReal(1.00000000000000))*(r10));
if( IKabs(((gconst15)*(((((r12)*(sj3)*(sj5)))+(((IkReal(-1.00000000000000))*(cj6)*(x1562)*(x1563)))+(((r11)*(sj6)*(x1562))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst15)*(((((IkReal(-1.00000000000000))*(sj3)*(sj6)*(x1563)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(sj3))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst15)*(((((r12)*(sj3)*(sj5)))+(((IkReal(-1.00000000000000))*(cj6)*(x1562)*(x1563)))+(((r11)*(sj6)*(x1562)))))), ((gconst15)*(((((IkReal(-1.00000000000000))*(sj3)*(sj6)*(x1563)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(sj3)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1564=IKsin(j4);
IkReal x1565=IKcos(j4);
IkReal x1566=((IkReal(1.00000000000000))*(r00));
IkReal x1567=((cj5)*(r01));
IkReal x1568=((cj5)*(r11));
IkReal x1569=((IkReal(1.00000000000000))*(cj5));
IkReal x1570=((cj5)*(r21));
IkReal x1571=((sj5)*(x1564));
IkReal x1572=((cj6)*(x1564));
IkReal x1573=((sj6)*(x1565));
IkReal x1574=((sj6)*(x1564));
IkReal x1575=((sj5)*(x1565));
IkReal x1576=((cj6)*(x1565));
evalcond[0]=((((IkReal(-1.00000000000000))*(r20)*(x1573)))+(((x1570)*(x1574)))+(((IkReal(-1.00000000000000))*(r20)*(x1569)*(x1572)))+(((IkReal(-1.00000000000000))*(r21)*(x1576)))+(((r22)*(x1571))));
evalcond[1]=((((r20)*(x1574)))+(((x1570)*(x1573)))+(((IkReal(-1.00000000000000))*(r20)*(x1569)*(x1576)))+(((r21)*(x1572)))+(((r22)*(x1575)))+(((IkReal(-1.00000000000000))*(cj3))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r01)*(x1576)))+(((x1567)*(x1574)))+(((IkReal(-1.00000000000000))*(x1566)*(x1573)))+(((IkReal(-1.00000000000000))*(cj5)*(x1566)*(x1572)))+(((r02)*(x1571))));
evalcond[3]=((IkReal(-1.00000000000000))+(((r12)*(x1571)))+(((x1568)*(x1574)))+(((IkReal(-1.00000000000000))*(r10)*(x1573)))+(((IkReal(-1.00000000000000))*(r10)*(x1569)*(x1572)))+(((IkReal(-1.00000000000000))*(r11)*(x1576))));
evalcond[4]=((((x1567)*(x1573)))+(sj3)+(((IkReal(-1.00000000000000))*(cj5)*(x1566)*(x1576)))+(((r02)*(x1575)))+(((r01)*(x1572)))+(((r00)*(x1574))));
evalcond[5]=((((r12)*(x1575)))+(((x1568)*(x1573)))+(((r11)*(x1572)))+(((r10)*(x1574)))+(((IkReal(-1.00000000000000))*(r10)*(x1569)*(x1576))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
IkReal x1577=((IkReal(0.000500000000000000))*(cj6));
IkReal x1578=((IkReal(0.000500000000000000))*(sj6));
IkReal x1579=((sj5)*(sj6));
IkReal x1580=((cj5)*(r12));
IkReal x1581=((IkReal(0.390000000000000))*(cj5));
IkReal x1582=((IkReal(0.390000000000000))*(cj6)*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((((cj6)*(r10)*(sj5)))+(x1580)+(((IkReal(-1.00000000000000))*(r11)*(x1579))));
evalcond[2]=((((r20)*(x1578)))+(((r20)*(x1582)))+(((IkReal(-1.00000000000000))*(pz)))+(((r22)*(x1581)))+(((r21)*(x1577)))+(((IkReal(-0.390000000000000))*(r21)*(x1579))));
evalcond[3]=((IkReal(0.400000000000000))+(((IkReal(-1.00000000000000))*(px)))+(((r02)*(x1581)))+(((IkReal(-0.390000000000000))*(r01)*(x1579)))+(((r01)*(x1577)))+(((r00)*(x1578)))+(((r00)*(x1582))));
evalcond[4]=((IkReal(0.00200000000000000))+(((IkReal(0.390000000000000))*(x1580)))+(((IkReal(-0.390000000000000))*(r11)*(x1579)))+(((IkReal(-1.00000000000000))*(py)))+(((r11)*(x1577)))+(((r10)*(x1578)))+(((r10)*(x1582))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x1583=((IkReal(1.00000000000000))*(sj5));
if( IKabs(((((IkReal(-1.00000000000000))*(cj6)*(r20)*(x1583)))+(((r21)*(sj5)*(sj6)))+(((IkReal(-1.00000000000000))*(cj5)*(r22))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r01)*(sj6)*(x1583)))+(((cj6)*(r00)*(sj5)))+(((cj5)*(r02))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(cj6)*(r20)*(x1583)))+(((r21)*(sj5)*(sj6)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))))+IKsqr(((((IkReal(-1.00000000000000))*(r01)*(sj6)*(x1583)))+(((cj6)*(r00)*(sj5)))+(((cj5)*(r02)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(cj6)*(r20)*(x1583)))+(((r21)*(sj5)*(sj6)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))), ((((IkReal(-1.00000000000000))*(r01)*(sj6)*(x1583)))+(((cj6)*(r00)*(sj5)))+(((cj5)*(r02)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x1584=((cj6)*(sj5));
IkReal x1585=((IkReal(1.00000000000000))*(sj5)*(sj6));
evalcond[0]=((((cj5)*(r22)))+(((r20)*(x1584)))+(IKsin(j3))+(((IkReal(-1.00000000000000))*(r21)*(x1585))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r01)*(x1585)))+(((IkReal(-1.00000000000000))*(IKcos(j3))))+(((r00)*(x1584)))+(((cj5)*(r02))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst19;
IkReal x1586=(cj6)*(cj6);
IkReal x1587=(sj6)*(sj6);
IkReal x1588=((r11)*(r20));
IkReal x1589=((r12)*(sj5));
IkReal x1590=((IkReal(1.00000000000000))*(r10));
IkReal x1591=((r22)*(sj5));
IkReal x1592=((cj5)*(x1587));
IkReal x1593=((cj5)*(x1586));
gconst19=IKsign(((((IkReal(-1.00000000000000))*(r21)*(x1590)*(x1592)))+(((IkReal(-1.00000000000000))*(r21)*(x1590)*(x1593)))+(((x1588)*(x1592)))+(((x1588)*(x1593)))+(((r20)*(sj6)*(x1589)))+(((IkReal(-1.00000000000000))*(sj6)*(x1590)*(x1591)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x1591)))+(((cj6)*(r21)*(x1589)))));
IkReal x1594=(cj6)*(cj6);
IkReal x1595=(sj6)*(sj6);
IkReal x1596=((r11)*(r20));
IkReal x1597=((r12)*(sj5));
IkReal x1598=((IkReal(1.00000000000000))*(r10));
IkReal x1599=((r22)*(sj5));
IkReal x1600=((cj5)*(x1595));
IkReal x1601=((cj5)*(x1594));
dummyeval[0]=((((IkReal(-1.00000000000000))*(sj6)*(x1598)*(x1599)))+(((r20)*(sj6)*(x1597)))+(((IkReal(-1.00000000000000))*(r21)*(x1598)*(x1601)))+(((IkReal(-1.00000000000000))*(r21)*(x1598)*(x1600)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x1599)))+(((cj6)*(r21)*(x1597)))+(((x1596)*(x1601)))+(((x1596)*(x1600))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst20;
IkReal x1602=(cj5)*(cj5);
IkReal x1603=(r11)*(r11);
IkReal x1604=(sj6)*(sj6);
IkReal x1605=(cj6)*(cj6);
IkReal x1606=(r10)*(r10);
IkReal x1607=((r11)*(sj6));
IkReal x1608=((IkReal(1.00000000000000))*(x1604));
IkReal x1609=((IkReal(1.00000000000000))*(x1605));
IkReal x1610=((IkReal(2.00000000000000))*(cj6)*(r10));
IkReal x1611=((cj5)*(r12)*(sj5));
gconst20=IKsign(((((IkReal(-1.00000000000000))*((r12)*(r12))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x1602)*(x1606)*(x1609)))+(((IkReal(-1.00000000000000))*(x1603)*(x1609)))+(((x1602)*(x1607)*(x1610)))+(((IkReal(-2.00000000000000))*(x1607)*(x1611)))+(((IkReal(-1.00000000000000))*(x1606)*(x1608)))+(((IkReal(-1.00000000000000))*(x1607)*(x1610)))+(((IkReal(-1.00000000000000))*(x1602)*(x1603)*(x1608)))+(((x1610)*(x1611)))));
IkReal x1612=(cj5)*(cj5);
IkReal x1613=(r11)*(r11);
IkReal x1614=(sj6)*(sj6);
IkReal x1615=(cj6)*(cj6);
IkReal x1616=(r10)*(r10);
IkReal x1617=((r11)*(sj6));
IkReal x1618=((IkReal(1.00000000000000))*(x1614));
IkReal x1619=((IkReal(1.00000000000000))*(x1615));
IkReal x1620=((IkReal(2.00000000000000))*(cj6)*(r10));
IkReal x1621=((cj5)*(r12)*(sj5));
dummyeval[0]=((((x1620)*(x1621)))+(((IkReal(-1.00000000000000))*(x1612)*(x1616)*(x1619)))+(((IkReal(-1.00000000000000))*(x1616)*(x1618)))+(((IkReal(-1.00000000000000))*((r12)*(r12))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x1617)*(x1620)))+(((x1612)*(x1617)*(x1620)))+(((IkReal(-1.00000000000000))*(x1612)*(x1613)*(x1618)))+(((IkReal(-2.00000000000000))*(x1617)*(x1621)))+(((IkReal(-1.00000000000000))*(x1613)*(x1619))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1622=((IkReal(1.00000000000000))*(r10));
if( IKabs(((gconst20)*(((((cj5)*(r11)*(sj6)))+(((IkReal(-1.00000000000000))*(cj5)*(cj6)*(x1622)))+(((r12)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst20)*(((((IkReal(-1.00000000000000))*(cj6)*(r11)))+(((IkReal(-1.00000000000000))*(sj6)*(x1622))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst20)*(((((cj5)*(r11)*(sj6)))+(((IkReal(-1.00000000000000))*(cj5)*(cj6)*(x1622)))+(((r12)*(sj5)))))), ((gconst20)*(((((IkReal(-1.00000000000000))*(cj6)*(r11)))+(((IkReal(-1.00000000000000))*(sj6)*(x1622)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1623=IKsin(j4);
IkReal x1624=IKcos(j4);
IkReal x1625=((IkReal(1.00000000000000))*(r00));
IkReal x1626=((cj5)*(r01));
IkReal x1627=((cj5)*(r11));
IkReal x1628=((IkReal(1.00000000000000))*(cj5));
IkReal x1629=((cj5)*(r21));
IkReal x1630=((sj5)*(x1623));
IkReal x1631=((cj6)*(x1623));
IkReal x1632=((sj6)*(x1624));
IkReal x1633=((sj6)*(x1623));
IkReal x1634=((sj5)*(x1624));
IkReal x1635=((cj6)*(x1624));
evalcond[0]=((((x1629)*(x1633)))+(((IkReal(-1.00000000000000))*(r20)*(x1632)))+(((IkReal(-1.00000000000000))*(r20)*(x1628)*(x1631)))+(((r22)*(x1630)))+(((IkReal(-1.00000000000000))*(r21)*(x1635))));
evalcond[1]=((((r21)*(x1631)))+(((r20)*(x1633)))+(((x1629)*(x1632)))+(((IkReal(-1.00000000000000))*(r20)*(x1628)*(x1635)))+(((r22)*(x1634)))+(((IkReal(-1.00000000000000))*(cj3))));
evalcond[2]=((((r02)*(x1630)))+(((IkReal(-1.00000000000000))*(r01)*(x1635)))+(((IkReal(-1.00000000000000))*(cj5)*(x1625)*(x1631)))+(((IkReal(-1.00000000000000))*(x1625)*(x1632)))+(((x1626)*(x1633))));
evalcond[3]=((IkReal(1.00000000000000))+(((x1627)*(x1633)))+(((r12)*(x1630)))+(((IkReal(-1.00000000000000))*(r10)*(x1628)*(x1631)))+(((IkReal(-1.00000000000000))*(r10)*(x1632)))+(((IkReal(-1.00000000000000))*(r11)*(x1635))));
evalcond[4]=((((r02)*(x1634)))+(((IkReal(-1.00000000000000))*(sj3)))+(((IkReal(-1.00000000000000))*(cj5)*(x1625)*(x1635)))+(((r01)*(x1631)))+(((r00)*(x1633)))+(((x1626)*(x1632))));
evalcond[5]=((((x1627)*(x1632)))+(((r11)*(x1631)))+(((r10)*(x1633)))+(((r12)*(x1634)))+(((IkReal(-1.00000000000000))*(r10)*(x1628)*(x1635))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1636=((cj3)*(sj6));
IkReal x1637=((IkReal(1.00000000000000))*(r10));
IkReal x1638=((cj3)*(cj6));
if( IKabs(((gconst19)*(((((cj3)*(r12)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(x1637)*(x1638)))+(((cj5)*(r11)*(x1636))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst19)*(((((IkReal(-1.00000000000000))*(x1636)*(x1637)))+(((IkReal(-1.00000000000000))*(r11)*(x1638))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst19)*(((((cj3)*(r12)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(x1637)*(x1638)))+(((cj5)*(r11)*(x1636)))))), ((gconst19)*(((((IkReal(-1.00000000000000))*(x1636)*(x1637)))+(((IkReal(-1.00000000000000))*(r11)*(x1638)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1639=IKsin(j4);
IkReal x1640=IKcos(j4);
IkReal x1641=((IkReal(1.00000000000000))*(r00));
IkReal x1642=((cj5)*(r01));
IkReal x1643=((cj5)*(r11));
IkReal x1644=((IkReal(1.00000000000000))*(cj5));
IkReal x1645=((cj5)*(r21));
IkReal x1646=((sj5)*(x1639));
IkReal x1647=((cj6)*(x1639));
IkReal x1648=((sj6)*(x1640));
IkReal x1649=((sj6)*(x1639));
IkReal x1650=((sj5)*(x1640));
IkReal x1651=((cj6)*(x1640));
evalcond[0]=((((IkReal(-1.00000000000000))*(r21)*(x1651)))+(((x1645)*(x1649)))+(((IkReal(-1.00000000000000))*(r20)*(x1648)))+(((r22)*(x1646)))+(((IkReal(-1.00000000000000))*(r20)*(x1644)*(x1647))));
evalcond[1]=((((r22)*(x1650)))+(((r21)*(x1647)))+(((r20)*(x1649)))+(((x1645)*(x1648)))+(((IkReal(-1.00000000000000))*(r20)*(x1644)*(x1651)))+(((IkReal(-1.00000000000000))*(cj3))));
evalcond[2]=((((IkReal(-1.00000000000000))*(cj5)*(x1641)*(x1647)))+(((IkReal(-1.00000000000000))*(x1641)*(x1648)))+(((r02)*(x1646)))+(((IkReal(-1.00000000000000))*(r01)*(x1651)))+(((x1642)*(x1649))));
evalcond[3]=((IkReal(1.00000000000000))+(((r12)*(x1646)))+(((IkReal(-1.00000000000000))*(r10)*(x1644)*(x1647)))+(((IkReal(-1.00000000000000))*(r10)*(x1648)))+(((x1643)*(x1649)))+(((IkReal(-1.00000000000000))*(r11)*(x1651))));
evalcond[4]=((((IkReal(-1.00000000000000))*(sj3)))+(((IkReal(-1.00000000000000))*(cj5)*(x1641)*(x1651)))+(((r02)*(x1650)))+(((r00)*(x1649)))+(((r01)*(x1647)))+(((x1642)*(x1648))));
evalcond[5]=((((r11)*(x1647)))+(((r12)*(x1650)))+(((r10)*(x1649)))+(((IkReal(-1.00000000000000))*(r10)*(x1644)*(x1651)))+(((x1643)*(x1648))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x1652=((cj6)*(sj5));
IkReal x1653=((sj5)*(sj6));
if( IKabs(((((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(r20)*(x1652)))+(((r21)*(x1653))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((cj5)*(r12)))+(((r10)*(x1652)))+(((IkReal(-1.00000000000000))*(r11)*(x1653))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(r20)*(x1652)))+(((r21)*(x1653)))))+IKsqr(((((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((cj5)*(r12)))+(((r10)*(x1652)))+(((IkReal(-1.00000000000000))*(r11)*(x1653)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(r20)*(x1652)))+(((r21)*(x1653)))), ((((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((cj5)*(r12)))+(((r10)*(x1652)))+(((IkReal(-1.00000000000000))*(r11)*(x1653)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[3];
IkReal x1654=IKcos(j3);
IkReal x1655=((cj6)*(sj5));
IkReal x1656=((IkReal(1.00000000000000))*(sj5)*(sj6));
evalcond[0]=((((cj5)*(r22)))+(((r20)*(x1655)))+(((IkReal(-1.00000000000000))*(r21)*(x1656)))+(IKsin(j3)));
evalcond[1]=((((IkReal(-1.00000000000000))*(r01)*(x1656)))+(((sj1)*(x1654)))+(((r00)*(x1655)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((r10)*(x1655)))+(((IkReal(-1.00000000000000))*(r11)*(x1656)))+(((IkReal(-1.00000000000000))*(cj1)*(x1654))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst11;
IkReal x1657=(cj5)*(cj5);
IkReal x1658=(r21)*(r21);
IkReal x1659=(sj6)*(sj6);
IkReal x1660=(cj6)*(cj6);
IkReal x1661=(r20)*(r20);
IkReal x1662=((cj6)*(r20));
IkReal x1663=((IkReal(1.00000000000000))*(x1660));
IkReal x1664=((IkReal(2.00000000000000))*(r21)*(sj6));
IkReal x1665=((cj5)*(r22)*(sj5));
IkReal x1666=((IkReal(1.00000000000000))*(x1659));
gconst11=IKsign(((((IkReal(-1.00000000000000))*(x1657)*(x1658)*(x1666)))+(((IkReal(-1.00000000000000))*(x1662)*(x1664)))+(((IkReal(2.00000000000000))*(x1662)*(x1665)))+(((IkReal(-1.00000000000000))*(x1661)*(x1666)))+(((x1657)*(x1662)*(x1664)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x1658)*(x1663)))+(((IkReal(-1.00000000000000))*(x1657)*(x1661)*(x1663)))+(((IkReal(-1.00000000000000))*(x1664)*(x1665)))));
IkReal x1667=(cj5)*(cj5);
IkReal x1668=(r21)*(r21);
IkReal x1669=(sj6)*(sj6);
IkReal x1670=(cj6)*(cj6);
IkReal x1671=(r20)*(r20);
IkReal x1672=((cj6)*(r20));
IkReal x1673=((IkReal(1.00000000000000))*(x1670));
IkReal x1674=((IkReal(2.00000000000000))*(r21)*(sj6));
IkReal x1675=((cj5)*(r22)*(sj5));
IkReal x1676=((IkReal(1.00000000000000))*(x1669));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x1672)*(x1674)))+(((x1667)*(x1672)*(x1674)))+(((IkReal(-1.00000000000000))*(x1668)*(x1673)))+(((IkReal(2.00000000000000))*(x1672)*(x1675)))+(((IkReal(-1.00000000000000))*(x1671)*(x1676)))+(((IkReal(-1.00000000000000))*(x1667)*(x1671)*(x1673)))+(((IkReal(-1.00000000000000))*(x1667)*(x1668)*(x1676)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x1674)*(x1675))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst12;
IkReal x1677=(cj5)*(cj5);
IkReal x1678=(sj6)*(sj6);
IkReal x1679=(cj6)*(cj6);
IkReal x1680=((r00)*(r20));
IkReal x1681=((cj5)*(sj5));
IkReal x1682=((r01)*(r21));
IkReal x1683=((r21)*(sj6));
IkReal x1684=((sj6)*(x1681));
IkReal x1685=((IkReal(1.00000000000000))*(cj6)*(r00));
IkReal x1686=((cj6)*(r01)*(r20)*(sj6));
gconst12=IKsign(((x1686)+(((r02)*(x1681)*(x1683)))+(((r01)*(r22)*(x1684)))+(((IkReal(-1.00000000000000))*(x1677)*(x1683)*(x1685)))+(((x1677)*(x1678)*(x1682)))+(((IkReal(-1.00000000000000))*(r22)*(x1681)*(x1685)))+(((IkReal(-1.00000000000000))*(cj6)*(r02)*(r20)*(x1681)))+(((x1677)*(x1679)*(x1680)))+(((r02)*(r22)*((sj5)*(sj5))))+(((cj6)*(r00)*(x1683)))+(((x1679)*(x1682)))+(((IkReal(-1.00000000000000))*(x1677)*(x1686)))+(((x1678)*(x1680)))));
IkReal x1687=(cj5)*(cj5);
IkReal x1688=(sj6)*(sj6);
IkReal x1689=(cj6)*(cj6);
IkReal x1690=((r00)*(r20));
IkReal x1691=((cj5)*(sj5));
IkReal x1692=((r01)*(r21));
IkReal x1693=((r21)*(sj6));
IkReal x1694=((sj6)*(x1691));
IkReal x1695=((IkReal(1.00000000000000))*(cj6)*(r00));
IkReal x1696=x1686;
dummyeval[0]=((x1696)+(((r01)*(r22)*(x1694)))+(((x1689)*(x1692)))+(((IkReal(-1.00000000000000))*(x1687)*(x1693)*(x1695)))+(((IkReal(-1.00000000000000))*(x1687)*(x1696)))+(((IkReal(-1.00000000000000))*(cj6)*(r02)*(r20)*(x1691)))+(((r02)*(x1691)*(x1693)))+(((r02)*(r22)*((sj5)*(sj5))))+(((x1688)*(x1690)))+(((cj6)*(r00)*(x1693)))+(((x1687)*(x1688)*(x1692)))+(((x1687)*(x1689)*(x1690)))+(((IkReal(-1.00000000000000))*(r22)*(x1691)*(x1695))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1697=((IkReal(1.00000000000000))*(sj1)*(sj3));
if( IKabs(((gconst12)*(((((IkReal(-1.00000000000000))*(r20)*(sj6)*(x1697)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x1697))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst12)*(((((IkReal(-1.00000000000000))*(r22)*(sj5)*(x1697)))+(((cj5)*(cj6)*(r20)*(sj1)*(sj3)))+(((IkReal(-1.00000000000000))*(cj5)*(r21)*(sj6)*(x1697))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst12)*(((((IkReal(-1.00000000000000))*(r20)*(sj6)*(x1697)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x1697)))))), ((gconst12)*(((((IkReal(-1.00000000000000))*(r22)*(sj5)*(x1697)))+(((cj5)*(cj6)*(r20)*(sj1)*(sj3)))+(((IkReal(-1.00000000000000))*(cj5)*(r21)*(sj6)*(x1697)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1698=IKsin(j4);
IkReal x1699=IKcos(j4);
IkReal x1700=((IkReal(1.00000000000000))*(r00));
IkReal x1701=((cj5)*(r01));
IkReal x1702=((cj5)*(r11));
IkReal x1703=((IkReal(1.00000000000000))*(cj5));
IkReal x1704=((IkReal(1.00000000000000))*(cj1));
IkReal x1705=((cj5)*(r21));
IkReal x1706=((sj5)*(x1698));
IkReal x1707=((cj6)*(x1698));
IkReal x1708=((sj6)*(x1699));
IkReal x1709=((sj6)*(x1698));
IkReal x1710=((sj5)*(x1699));
IkReal x1711=((cj6)*(x1699));
evalcond[0]=((((r22)*(x1706)))+(((IkReal(-1.00000000000000))*(r21)*(x1711)))+(((x1705)*(x1709)))+(((IkReal(-1.00000000000000))*(r20)*(x1708)))+(((IkReal(-1.00000000000000))*(r20)*(x1703)*(x1707))));
evalcond[1]=((((r22)*(x1710)))+(((r20)*(x1709)))+(((x1705)*(x1708)))+(((r21)*(x1707)))+(((IkReal(-1.00000000000000))*(r20)*(x1703)*(x1711)))+(((IkReal(-1.00000000000000))*(cj3))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r01)*(x1711)))+(((r02)*(x1706)))+(((IkReal(-1.00000000000000))*(cj5)*(x1700)*(x1707)))+(((IkReal(-1.00000000000000))*(x1704)))+(((x1701)*(x1709)))+(((IkReal(-1.00000000000000))*(x1700)*(x1708))));
evalcond[3]=((((r12)*(x1706)))+(((IkReal(-1.00000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(r10)*(x1703)*(x1707)))+(((IkReal(-1.00000000000000))*(r10)*(x1708)))+(((IkReal(-1.00000000000000))*(r11)*(x1711)))+(((x1702)*(x1709))));
evalcond[4]=((((r02)*(x1710)))+(((IkReal(-1.00000000000000))*(cj5)*(x1700)*(x1711)))+(((r01)*(x1707)))+(((sj1)*(sj3)))+(((r00)*(x1709)))+(((x1701)*(x1708))));
evalcond[5]=((((r12)*(x1710)))+(((IkReal(-1.00000000000000))*(r10)*(x1703)*(x1711)))+(((r11)*(x1707)))+(((IkReal(-1.00000000000000))*(sj3)*(x1704)))+(((r10)*(x1709)))+(((x1702)*(x1708))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1712=((cj3)*(cj6));
IkReal x1713=((IkReal(1.00000000000000))*(r21));
IkReal x1714=((cj3)*(sj6));
if( IKabs(((gconst11)*(((((IkReal(-1.00000000000000))*(x1712)*(x1713)))+(((IkReal(-1.00000000000000))*(r20)*(x1714))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst11)*(((((cj5)*(r20)*(x1712)))+(((IkReal(-1.00000000000000))*(cj3)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(x1713)*(x1714))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst11)*(((((IkReal(-1.00000000000000))*(x1712)*(x1713)))+(((IkReal(-1.00000000000000))*(r20)*(x1714)))))), ((gconst11)*(((((cj5)*(r20)*(x1712)))+(((IkReal(-1.00000000000000))*(cj3)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(x1713)*(x1714)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1715=IKsin(j4);
IkReal x1716=IKcos(j4);
IkReal x1717=((IkReal(1.00000000000000))*(r00));
IkReal x1718=((cj5)*(r01));
IkReal x1719=((cj5)*(r11));
IkReal x1720=((IkReal(1.00000000000000))*(cj5));
IkReal x1721=((IkReal(1.00000000000000))*(cj1));
IkReal x1722=((cj5)*(r21));
IkReal x1723=((sj5)*(x1715));
IkReal x1724=((cj6)*(x1715));
IkReal x1725=((sj6)*(x1716));
IkReal x1726=((sj6)*(x1715));
IkReal x1727=((sj5)*(x1716));
IkReal x1728=((cj6)*(x1716));
evalcond[0]=((((IkReal(-1.00000000000000))*(r20)*(x1725)))+(((x1722)*(x1726)))+(((r22)*(x1723)))+(((IkReal(-1.00000000000000))*(r21)*(x1728)))+(((IkReal(-1.00000000000000))*(r20)*(x1720)*(x1724))));
evalcond[1]=((((x1722)*(x1725)))+(((r21)*(x1724)))+(((r22)*(x1727)))+(((r20)*(x1726)))+(((IkReal(-1.00000000000000))*(cj3)))+(((IkReal(-1.00000000000000))*(r20)*(x1720)*(x1728))));
evalcond[2]=((((x1718)*(x1726)))+(((r02)*(x1723)))+(((IkReal(-1.00000000000000))*(x1717)*(x1725)))+(((IkReal(-1.00000000000000))*(r01)*(x1728)))+(((IkReal(-1.00000000000000))*(cj5)*(x1717)*(x1724)))+(((IkReal(-1.00000000000000))*(x1721))));
evalcond[3]=((((IkReal(-1.00000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(r11)*(x1728)))+(((IkReal(-1.00000000000000))*(r10)*(x1720)*(x1724)))+(((r12)*(x1723)))+(((IkReal(-1.00000000000000))*(r10)*(x1725)))+(((x1719)*(x1726))));
evalcond[4]=((((r01)*(x1724)))+(((r00)*(x1726)))+(((x1718)*(x1725)))+(((sj1)*(sj3)))+(((r02)*(x1727)))+(((IkReal(-1.00000000000000))*(cj5)*(x1717)*(x1728))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(x1720)*(x1728)))+(((r10)*(x1726)))+(((r11)*(x1724)))+(((r12)*(x1727)))+(((x1719)*(x1725)))+(((IkReal(-1.00000000000000))*(sj3)*(x1721))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1729=((cj6)*(sj1));
IkReal x1730=((IkReal(1.00000000000000))*(sj1)*(sj6));
if( IKabs(((gconst10)*(((((IkReal(-1.00000000000000))*(r21)*(x1729)))+(((IkReal(-1.00000000000000))*(r20)*(x1730))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst10)*(((((cj5)*(r20)*(x1729)))+(((IkReal(-1.00000000000000))*(r22)*(sj1)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r21)*(x1730))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst10)*(((((IkReal(-1.00000000000000))*(r21)*(x1729)))+(((IkReal(-1.00000000000000))*(r20)*(x1730)))))), ((gconst10)*(((((cj5)*(r20)*(x1729)))+(((IkReal(-1.00000000000000))*(r22)*(sj1)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r21)*(x1730)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x1731=IKsin(j4);
IkReal x1732=IKcos(j4);
IkReal x1733=((IkReal(1.00000000000000))*(cj6));
IkReal x1734=((sj5)*(x1731));
IkReal x1735=((cj5)*(x1731));
IkReal x1736=((IkReal(1.00000000000000))*(sj6)*(x1732));
evalcond[0]=((((r21)*(sj6)*(x1735)))+(((IkReal(-1.00000000000000))*(r20)*(x1733)*(x1735)))+(((r22)*(x1734)))+(((IkReal(-1.00000000000000))*(r21)*(x1732)*(x1733)))+(((IkReal(-1.00000000000000))*(r20)*(x1736))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r01)*(x1732)*(x1733)))+(((IkReal(-1.00000000000000))*(r00)*(x1736)))+(((r02)*(x1734)))+(((r01)*(sj6)*(x1735)))+(((IkReal(-1.00000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(r00)*(x1733)*(x1735))));
evalcond[2]=((((r11)*(sj6)*(x1735)))+(((IkReal(-1.00000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(r10)*(x1736)))+(((IkReal(-1.00000000000000))*(r10)*(x1733)*(x1735)))+(((IkReal(-1.00000000000000))*(r11)*(x1732)*(x1733)))+(((r12)*(x1734))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x1737=((cj4)*(cj5));
IkReal x1738=((r21)*(sj6));
IkReal x1739=((IkReal(1.00000000000000))*(cj6)*(r20));
if( IKabs(((((sj5)*(x1738)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(sj5)*(x1739))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((x1737)*(x1738)))+(((cj4)*(r22)*(sj5)))+(((cj6)*(r21)*(sj4)))+(((IkReal(-1.00000000000000))*(x1737)*(x1739)))+(((r20)*(sj4)*(sj6))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((sj5)*(x1738)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(sj5)*(x1739)))))+IKsqr(((((x1737)*(x1738)))+(((cj4)*(r22)*(sj5)))+(((cj6)*(r21)*(sj4)))+(((IkReal(-1.00000000000000))*(x1737)*(x1739)))+(((r20)*(sj4)*(sj6)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((sj5)*(x1738)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(sj5)*(x1739)))), ((((x1737)*(x1738)))+(((cj4)*(r22)*(sj5)))+(((cj6)*(r21)*(sj4)))+(((IkReal(-1.00000000000000))*(x1737)*(x1739)))+(((r20)*(sj4)*(sj6)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x1740=IKcos(j3);
IkReal x1741=IKsin(j3);
IkReal x1742=((r11)*(sj6));
IkReal x1743=((IkReal(1.00000000000000))*(sj5));
IkReal x1744=((IkReal(1.00000000000000))*(cj1));
IkReal x1745=((cj6)*(sj4));
IkReal x1746=((sj4)*(sj6));
IkReal x1747=((cj4)*(sj5));
IkReal x1748=((cj4)*(cj5));
IkReal x1749=((r01)*(sj6));
IkReal x1750=((r21)*(sj6));
IkReal x1751=((cj6)*(sj5));
IkReal x1752=((IkReal(1.00000000000000))*(cj6)*(x1748));
evalcond[0]=((((cj5)*(r22)))+(x1741)+(((r20)*(x1751)))+(((IkReal(-1.00000000000000))*(x1743)*(x1750))));
evalcond[1]=((((sj1)*(x1740)))+(((r00)*(x1751)))+(((IkReal(-1.00000000000000))*(x1743)*(x1749)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x1740)*(x1744)))+(((IkReal(-1.00000000000000))*(x1742)*(x1743)))+(((r10)*(x1751))));
evalcond[3]=((((r22)*(x1747)))+(((r21)*(x1745)))+(((IkReal(-1.00000000000000))*(x1740)))+(((x1748)*(x1750)))+(((r20)*(x1746)))+(((IkReal(-1.00000000000000))*(r20)*(x1752))));
evalcond[4]=((((r02)*(x1747)))+(((sj1)*(x1741)))+(((IkReal(-1.00000000000000))*(r00)*(x1752)))+(((x1748)*(x1749)))+(((r00)*(x1746)))+(((r01)*(x1745))));
evalcond[5]=((((r12)*(x1747)))+(((IkReal(-1.00000000000000))*(x1741)*(x1744)))+(((IkReal(-1.00000000000000))*(r10)*(x1752)))+(((x1742)*(x1748)))+(((r11)*(x1745)))+(((r10)*(x1746))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1753=((cj1)*(cj6));
IkReal x1754=((IkReal(1.00000000000000))*(cj1));
if( IKabs(((gconst9)*(((((IkReal(-1.00000000000000))*(r21)*(x1753)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x1754))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst9)*(((((IkReal(-1.00000000000000))*(r22)*(sj5)*(x1754)))+(((IkReal(-1.00000000000000))*(cj5)*(r21)*(sj6)*(x1754)))+(((cj5)*(r20)*(x1753))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst9)*(((((IkReal(-1.00000000000000))*(r21)*(x1753)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x1754)))))), ((gconst9)*(((((IkReal(-1.00000000000000))*(r22)*(sj5)*(x1754)))+(((IkReal(-1.00000000000000))*(cj5)*(r21)*(sj6)*(x1754)))+(((cj5)*(r20)*(x1753)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x1755=IKsin(j4);
IkReal x1756=IKcos(j4);
IkReal x1757=((IkReal(1.00000000000000))*(cj6));
IkReal x1758=((sj5)*(x1755));
IkReal x1759=((cj5)*(x1755));
IkReal x1760=((IkReal(1.00000000000000))*(sj6)*(x1756));
evalcond[0]=((((IkReal(-1.00000000000000))*(r20)*(x1760)))+(((IkReal(-1.00000000000000))*(r20)*(x1757)*(x1759)))+(((r22)*(x1758)))+(((IkReal(-1.00000000000000))*(r21)*(x1756)*(x1757)))+(((r21)*(sj6)*(x1759))));
evalcond[1]=((((r01)*(sj6)*(x1759)))+(((IkReal(-1.00000000000000))*(r00)*(x1760)))+(((IkReal(-1.00000000000000))*(r01)*(x1756)*(x1757)))+(((r02)*(x1758)))+(((IkReal(-1.00000000000000))*(r00)*(x1757)*(x1759)))+(((IkReal(-1.00000000000000))*(cj1))));
evalcond[2]=((((IkReal(-1.00000000000000))*(sj1)))+(((r11)*(sj6)*(x1759)))+(((IkReal(-1.00000000000000))*(r10)*(x1757)*(x1759)))+(((IkReal(-1.00000000000000))*(r10)*(x1760)))+(((r12)*(x1758)))+(((IkReal(-1.00000000000000))*(r11)*(x1756)*(x1757))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x1761=((cj4)*(cj5));
IkReal x1762=((r21)*(sj6));
IkReal x1763=((IkReal(1.00000000000000))*(cj6)*(r20));
if( IKabs(((((IkReal(-1.00000000000000))*(sj5)*(x1763)))+(((sj5)*(x1762)))+(((IkReal(-1.00000000000000))*(cj5)*(r22))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(x1761)*(x1763)))+(((cj6)*(r21)*(sj4)))+(((r20)*(sj4)*(sj6)))+(((x1761)*(x1762))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(sj5)*(x1763)))+(((sj5)*(x1762)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))))+IKsqr(((((cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(x1761)*(x1763)))+(((cj6)*(r21)*(sj4)))+(((r20)*(sj4)*(sj6)))+(((x1761)*(x1762)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(sj5)*(x1763)))+(((sj5)*(x1762)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))), ((((cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(x1761)*(x1763)))+(((cj6)*(r21)*(sj4)))+(((r20)*(sj4)*(sj6)))+(((x1761)*(x1762)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x1764=IKcos(j3);
IkReal x1765=IKsin(j3);
IkReal x1766=((r11)*(sj6));
IkReal x1767=((IkReal(1.00000000000000))*(sj5));
IkReal x1768=((IkReal(1.00000000000000))*(cj1));
IkReal x1769=((cj6)*(sj4));
IkReal x1770=((sj4)*(sj6));
IkReal x1771=((cj4)*(sj5));
IkReal x1772=((cj4)*(cj5));
IkReal x1773=((r01)*(sj6));
IkReal x1774=((r21)*(sj6));
IkReal x1775=((cj6)*(sj5));
IkReal x1776=((IkReal(1.00000000000000))*(cj6)*(x1772));
evalcond[0]=((((cj5)*(r22)))+(x1765)+(((IkReal(-1.00000000000000))*(x1767)*(x1774)))+(((r20)*(x1775))));
evalcond[1]=((((sj1)*(x1764)))+(((IkReal(-1.00000000000000))*(x1767)*(x1773)))+(((r00)*(x1775)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x1766)*(x1767)))+(((r10)*(x1775)))+(((IkReal(-1.00000000000000))*(x1764)*(x1768))));
evalcond[3]=((((r21)*(x1769)))+(((r22)*(x1771)))+(((IkReal(-1.00000000000000))*(x1764)))+(((IkReal(-1.00000000000000))*(r20)*(x1776)))+(((r20)*(x1770)))+(((x1772)*(x1774))));
evalcond[4]=((((sj1)*(x1765)))+(((r02)*(x1771)))+(((r01)*(x1769)))+(((r00)*(x1770)))+(((IkReal(-1.00000000000000))*(r00)*(x1776)))+(((x1772)*(x1773))));
evalcond[5]=((((r12)*(x1771)))+(((r11)*(x1769)))+(((x1766)*(x1772)))+(((IkReal(-1.00000000000000))*(r10)*(x1776)))+(((r10)*(x1770)))+(((IkReal(-1.00000000000000))*(x1765)*(x1768))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
}
}

}

}

} else
{
IkReal x1777=((IkReal(0.390000000000000))*(sj5));
IkReal x1778=((IkReal(0.390000000000000))*(cj5));
IkReal x1779=((IkReal(0.000500000000000000))*(cj6));
IkReal x1780=((IkReal(0.000500000000000000))*(sj6));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((r20)*(x1780)))+(((r22)*(x1778)))+(((IkReal(-1.00000000000000))*(pz)))+(((cj6)*(r20)*(x1777)))+(((r21)*(x1779)))+(((IkReal(-1.00000000000000))*(r21)*(sj6)*(x1777))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r01)*(sj6)*(x1777)))+(((r02)*(x1778)))+(((cj6)*(r00)*(x1777)))+(((IkReal(0.00200000000000000))*(cj1)))+(((r01)*(x1779)))+(((IkReal(-1.00000000000000))*(px)))+(((IkReal(-0.400000000000000))*(sj1)))+(((r00)*(x1780))));
evalcond[3]=((((r10)*(x1780)))+(((r12)*(x1778)))+(((r11)*(x1779)))+(((IkReal(0.400000000000000))*(cj1)))+(((IkReal(0.00200000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(py)))+(((IkReal(-1.00000000000000))*(r11)*(sj6)*(x1777)))+(((cj6)*(r10)*(x1777))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst21;
IkReal x1781=(cj6)*(cj6);
IkReal x1782=(sj6)*(sj6);
IkReal x1783=((r01)*(r20));
IkReal x1784=((r02)*(sj5));
IkReal x1785=((cj5)*(x1782));
IkReal x1786=((IkReal(1.00000000000000))*(r22)*(sj5));
IkReal x1787=((IkReal(1.00000000000000))*(r00)*(r21));
IkReal x1788=((cj5)*(x1781));
gconst21=IKsign(((((cj6)*(r21)*(x1784)))+(((x1783)*(x1785)))+(((x1783)*(x1788)))+(((IkReal(-1.00000000000000))*(x1787)*(x1788)))+(((r20)*(sj6)*(x1784)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x1786)))+(((IkReal(-1.00000000000000))*(x1785)*(x1787)))+(((IkReal(-1.00000000000000))*(r00)*(sj6)*(x1786)))));
IkReal x1789=(cj6)*(cj6);
IkReal x1790=(sj6)*(sj6);
IkReal x1791=((r01)*(r20));
IkReal x1792=((r02)*(sj5));
IkReal x1793=((cj5)*(x1790));
IkReal x1794=((IkReal(1.00000000000000))*(r22)*(sj5));
IkReal x1795=((IkReal(1.00000000000000))*(r00)*(r21));
IkReal x1796=((cj5)*(x1789));
dummyeval[0]=((((IkReal(-1.00000000000000))*(r00)*(sj6)*(x1794)))+(((IkReal(-1.00000000000000))*(x1795)*(x1796)))+(((cj6)*(r21)*(x1792)))+(((r20)*(sj6)*(x1792)))+(((IkReal(-1.00000000000000))*(x1793)*(x1795)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x1794)))+(((x1791)*(x1793)))+(((x1791)*(x1796))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst22;
IkReal x1797=(cj6)*(cj6);
IkReal x1798=(sj6)*(sj6);
IkReal x1799=((r11)*(r20));
IkReal x1800=((r12)*(sj5));
IkReal x1801=((IkReal(1.00000000000000))*(r10));
IkReal x1802=((r22)*(sj5));
IkReal x1803=((cj5)*(x1798));
IkReal x1804=((cj5)*(x1797));
gconst22=IKsign(((((IkReal(-1.00000000000000))*(r21)*(x1801)*(x1804)))+(((IkReal(-1.00000000000000))*(r21)*(x1801)*(x1803)))+(((x1799)*(x1803)))+(((x1799)*(x1804)))+(((IkReal(-1.00000000000000))*(sj6)*(x1801)*(x1802)))+(((r20)*(sj6)*(x1800)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x1802)))+(((cj6)*(r21)*(x1800)))));
IkReal x1805=(cj6)*(cj6);
IkReal x1806=(sj6)*(sj6);
IkReal x1807=((r11)*(r20));
IkReal x1808=((r12)*(sj5));
IkReal x1809=((IkReal(1.00000000000000))*(r10));
IkReal x1810=((r22)*(sj5));
IkReal x1811=((cj5)*(x1806));
IkReal x1812=((cj5)*(x1805));
dummyeval[0]=((((IkReal(-1.00000000000000))*(r21)*(x1809)*(x1812)))+(((IkReal(-1.00000000000000))*(r21)*(x1809)*(x1811)))+(((r20)*(sj6)*(x1808)))+(((x1807)*(x1811)))+(((x1807)*(x1812)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x1810)))+(((IkReal(-1.00000000000000))*(sj6)*(x1809)*(x1810)))+(((cj6)*(r21)*(x1808))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=cj1;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
IkReal x1813=((IkReal(0.000500000000000000))*(cj6));
IkReal x1814=((IkReal(0.000500000000000000))*(sj6));
IkReal x1815=((sj5)*(sj6));
IkReal x1816=((cj5)*(r12));
IkReal x1817=((IkReal(0.390000000000000))*(cj5));
IkReal x1818=((IkReal(0.390000000000000))*(cj6)*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((((cj6)*(r10)*(sj5)))+(((IkReal(-1.00000000000000))*(r11)*(x1815)))+(x1816));
evalcond[2]=((((r22)*(x1817)))+(((r20)*(x1818)))+(((r20)*(x1814)))+(((IkReal(-1.00000000000000))*(pz)))+(((r21)*(x1813)))+(((IkReal(-0.390000000000000))*(r21)*(x1815))));
evalcond[3]=((IkReal(-0.400000000000000))+(((r02)*(x1817)))+(((IkReal(-0.390000000000000))*(r01)*(x1815)))+(((IkReal(-1.00000000000000))*(px)))+(((r01)*(x1813)))+(((r00)*(x1818)))+(((r00)*(x1814))));
evalcond[4]=((IkReal(0.00200000000000000))+(((IkReal(-0.390000000000000))*(r11)*(x1815)))+(((IkReal(-1.00000000000000))*(py)))+(((IkReal(0.390000000000000))*(x1816)))+(((r11)*(x1813)))+(((r10)*(x1818)))+(((r10)*(x1814))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x1819=((cj6)*(sj5));
IkReal x1820=((sj5)*(sj6));
if( IKabs(((((cj5)*(r22)))+(((r20)*(x1819)))+(((IkReal(-1.00000000000000))*(r21)*(x1820))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r00)*(x1819)))+(((r01)*(x1820)))+(((IkReal(-1.00000000000000))*(cj5)*(r02))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((cj5)*(r22)))+(((r20)*(x1819)))+(((IkReal(-1.00000000000000))*(r21)*(x1820)))))+IKsqr(((((IkReal(-1.00000000000000))*(r00)*(x1819)))+(((r01)*(x1820)))+(((IkReal(-1.00000000000000))*(cj5)*(r02)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((cj5)*(r22)))+(((r20)*(x1819)))+(((IkReal(-1.00000000000000))*(r21)*(x1820)))), ((((IkReal(-1.00000000000000))*(r00)*(x1819)))+(((r01)*(x1820)))+(((IkReal(-1.00000000000000))*(cj5)*(r02)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x1821=((cj6)*(sj5));
IkReal x1822=((IkReal(1.00000000000000))*(sj5)*(sj6));
evalcond[0]=((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(IKsin(j3))))+(((IkReal(-1.00000000000000))*(r21)*(x1822)))+(((r20)*(x1821))));
evalcond[1]=((((r00)*(x1821)))+(IKcos(j3))+(((IkReal(-1.00000000000000))*(r01)*(x1822)))+(((cj5)*(r02))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst27;
IkReal x1823=(sj6)*(sj6);
IkReal x1824=(cj6)*(cj6);
IkReal x1825=((cj6)*(sj5));
IkReal x1826=((r10)*(r21));
IkReal x1827=((IkReal(1.00000000000000))*(r12));
IkReal x1828=((sj5)*(sj6));
IkReal x1829=((cj5)*(x1824));
IkReal x1830=((IkReal(1.00000000000000))*(r11)*(r20));
IkReal x1831=((cj5)*(x1823));
gconst27=IKsign(((((x1826)*(x1831)))+(((x1826)*(x1829)))+(((r10)*(r22)*(x1828)))+(((IkReal(-1.00000000000000))*(r20)*(x1827)*(x1828)))+(((r11)*(r22)*(x1825)))+(((IkReal(-1.00000000000000))*(x1829)*(x1830)))+(((IkReal(-1.00000000000000))*(r21)*(x1825)*(x1827)))+(((IkReal(-1.00000000000000))*(x1830)*(x1831)))));
IkReal x1832=(sj6)*(sj6);
IkReal x1833=(cj6)*(cj6);
IkReal x1834=((cj6)*(sj5));
IkReal x1835=((r10)*(r21));
IkReal x1836=((IkReal(1.00000000000000))*(r12));
IkReal x1837=((sj5)*(sj6));
IkReal x1838=((cj5)*(x1833));
IkReal x1839=((IkReal(1.00000000000000))*(r11)*(r20));
IkReal x1840=((cj5)*(x1832));
dummyeval[0]=((((IkReal(-1.00000000000000))*(r20)*(x1836)*(x1837)))+(((r10)*(r22)*(x1837)))+(((IkReal(-1.00000000000000))*(x1839)*(x1840)))+(((x1835)*(x1838)))+(((IkReal(-1.00000000000000))*(x1838)*(x1839)))+(((IkReal(-1.00000000000000))*(r21)*(x1834)*(x1836)))+(((r11)*(r22)*(x1834)))+(((x1835)*(x1840))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst28;
IkReal x1841=(sj6)*(sj6);
IkReal x1842=(cj6)*(cj6);
IkReal x1843=((r01)*(r10));
IkReal x1844=((IkReal(1.00000000000000))*(r00));
IkReal x1845=((r02)*(sj5));
IkReal x1846=((r12)*(sj5));
IkReal x1847=((cj5)*(x1841));
IkReal x1848=((cj5)*(x1842));
gconst28=IKsign(((((r10)*(sj6)*(x1845)))+(((cj6)*(r11)*(x1845)))+(((IkReal(-1.00000000000000))*(r11)*(x1844)*(x1848)))+(((IkReal(-1.00000000000000))*(r11)*(x1844)*(x1847)))+(((IkReal(-1.00000000000000))*(sj6)*(x1844)*(x1846)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x1846)))+(((x1843)*(x1848)))+(((x1843)*(x1847)))));
IkReal x1849=(sj6)*(sj6);
IkReal x1850=(cj6)*(cj6);
IkReal x1851=((r01)*(r10));
IkReal x1852=((IkReal(1.00000000000000))*(r00));
IkReal x1853=((r02)*(sj5));
IkReal x1854=((r12)*(sj5));
IkReal x1855=((cj5)*(x1849));
IkReal x1856=((cj5)*(x1850));
dummyeval[0]=((((IkReal(-1.00000000000000))*(r11)*(x1852)*(x1855)))+(((IkReal(-1.00000000000000))*(r11)*(x1852)*(x1856)))+(((x1851)*(x1855)))+(((x1851)*(x1856)))+(((cj6)*(r11)*(x1853)))+(((IkReal(-1.00000000000000))*(sj6)*(x1852)*(x1854)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x1854)))+(((r10)*(sj6)*(x1853))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1857=((sj3)*(sj6));
IkReal x1858=((IkReal(1.00000000000000))*(r10));
IkReal x1859=((cj6)*(sj3));
if( IKabs(((gconst28)*(((((r12)*(sj3)*(sj5)))+(((cj5)*(r11)*(x1857)))+(((IkReal(-1.00000000000000))*(cj5)*(x1858)*(x1859))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst28)*(((((IkReal(-1.00000000000000))*(x1857)*(x1858)))+(((IkReal(-1.00000000000000))*(r11)*(x1859))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst28)*(((((r12)*(sj3)*(sj5)))+(((cj5)*(r11)*(x1857)))+(((IkReal(-1.00000000000000))*(cj5)*(x1858)*(x1859)))))), ((gconst28)*(((((IkReal(-1.00000000000000))*(x1857)*(x1858)))+(((IkReal(-1.00000000000000))*(r11)*(x1859)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1860=IKsin(j4);
IkReal x1861=IKcos(j4);
IkReal x1862=((IkReal(1.00000000000000))*(r00));
IkReal x1863=((cj5)*(r01));
IkReal x1864=((cj5)*(r11));
IkReal x1865=((IkReal(1.00000000000000))*(cj5));
IkReal x1866=((cj5)*(r21));
IkReal x1867=((sj5)*(x1860));
IkReal x1868=((cj6)*(x1860));
IkReal x1869=((sj6)*(x1861));
IkReal x1870=((sj6)*(x1860));
IkReal x1871=((sj5)*(x1861));
IkReal x1872=((cj6)*(x1861));
evalcond[0]=((((IkReal(-1.00000000000000))*(r20)*(x1865)*(x1868)))+(((x1866)*(x1870)))+(((r22)*(x1867)))+(((IkReal(-1.00000000000000))*(r21)*(x1872)))+(((IkReal(-1.00000000000000))*(r20)*(x1869))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r20)*(x1865)*(x1872)))+(((r22)*(x1871)))+(cj3)+(((x1866)*(x1869)))+(((r20)*(x1870)))+(((r21)*(x1868))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r01)*(x1872)))+(((x1863)*(x1870)))+(((IkReal(-1.00000000000000))*(cj5)*(x1862)*(x1868)))+(((r02)*(x1867)))+(((IkReal(-1.00000000000000))*(x1862)*(x1869))));
evalcond[3]=((IkReal(1.00000000000000))+(((r12)*(x1867)))+(((IkReal(-1.00000000000000))*(r11)*(x1872)))+(((IkReal(-1.00000000000000))*(r10)*(x1869)))+(((IkReal(-1.00000000000000))*(r10)*(x1865)*(x1868)))+(((x1864)*(x1870))));
evalcond[4]=((sj3)+(((r02)*(x1871)))+(((x1863)*(x1869)))+(((IkReal(-1.00000000000000))*(cj5)*(x1862)*(x1872)))+(((r00)*(x1870)))+(((r01)*(x1868))));
evalcond[5]=((((x1864)*(x1869)))+(((r11)*(x1868)))+(((IkReal(-1.00000000000000))*(r10)*(x1865)*(x1872)))+(((r10)*(x1870)))+(((r12)*(x1871))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1873=((cj3)*(cj5));
IkReal x1874=((IkReal(1.00000000000000))*(cj6));
if( IKabs(((gconst27)*(((((cj3)*(r12)*(sj5)))+(((IkReal(-1.00000000000000))*(r10)*(x1873)*(x1874)))+(((r11)*(sj6)*(x1873))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst27)*(((((IkReal(-1.00000000000000))*(cj3)*(r10)*(sj6)))+(((IkReal(-1.00000000000000))*(cj3)*(r11)*(x1874))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst27)*(((((cj3)*(r12)*(sj5)))+(((IkReal(-1.00000000000000))*(r10)*(x1873)*(x1874)))+(((r11)*(sj6)*(x1873)))))), ((gconst27)*(((((IkReal(-1.00000000000000))*(cj3)*(r10)*(sj6)))+(((IkReal(-1.00000000000000))*(cj3)*(r11)*(x1874)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1875=IKsin(j4);
IkReal x1876=IKcos(j4);
IkReal x1877=((IkReal(1.00000000000000))*(r00));
IkReal x1878=((cj5)*(r01));
IkReal x1879=((cj5)*(r11));
IkReal x1880=((IkReal(1.00000000000000))*(cj5));
IkReal x1881=((cj5)*(r21));
IkReal x1882=((sj5)*(x1875));
IkReal x1883=((cj6)*(x1875));
IkReal x1884=((sj6)*(x1876));
IkReal x1885=((sj6)*(x1875));
IkReal x1886=((sj5)*(x1876));
IkReal x1887=((cj6)*(x1876));
evalcond[0]=((((x1881)*(x1885)))+(((IkReal(-1.00000000000000))*(r20)*(x1884)))+(((IkReal(-1.00000000000000))*(r20)*(x1880)*(x1883)))+(((IkReal(-1.00000000000000))*(r21)*(x1887)))+(((r22)*(x1882))));
evalcond[1]=((((r21)*(x1883)))+(((x1881)*(x1884)))+(cj3)+(((r20)*(x1885)))+(((IkReal(-1.00000000000000))*(r20)*(x1880)*(x1887)))+(((r22)*(x1886))));
evalcond[2]=((((x1878)*(x1885)))+(((IkReal(-1.00000000000000))*(cj5)*(x1877)*(x1883)))+(((IkReal(-1.00000000000000))*(r01)*(x1887)))+(((IkReal(-1.00000000000000))*(x1877)*(x1884)))+(((r02)*(x1882))));
evalcond[3]=((IkReal(1.00000000000000))+(((x1879)*(x1885)))+(((r12)*(x1882)))+(((IkReal(-1.00000000000000))*(r10)*(x1880)*(x1883)))+(((IkReal(-1.00000000000000))*(r10)*(x1884)))+(((IkReal(-1.00000000000000))*(r11)*(x1887))));
evalcond[4]=((sj3)+(((x1878)*(x1884)))+(((r00)*(x1885)))+(((r01)*(x1883)))+(((IkReal(-1.00000000000000))*(cj5)*(x1877)*(x1887)))+(((r02)*(x1886))));
evalcond[5]=((((x1879)*(x1884)))+(((r12)*(x1886)))+(((IkReal(-1.00000000000000))*(r10)*(x1880)*(x1887)))+(((r10)*(x1885)))+(((r11)*(x1883))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
IkReal x1888=((IkReal(0.000500000000000000))*(cj6));
IkReal x1889=((IkReal(0.000500000000000000))*(sj6));
IkReal x1890=((sj5)*(sj6));
IkReal x1891=((cj5)*(r12));
IkReal x1892=((IkReal(0.390000000000000))*(cj5));
IkReal x1893=((IkReal(0.390000000000000))*(cj6)*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((((cj6)*(r10)*(sj5)))+(x1891)+(((IkReal(-1.00000000000000))*(r11)*(x1890))));
evalcond[2]=((((r22)*(x1892)))+(((r21)*(x1888)))+(((r20)*(x1889)))+(((r20)*(x1893)))+(((IkReal(-1.00000000000000))*(pz)))+(((IkReal(-0.390000000000000))*(r21)*(x1890))));
evalcond[3]=((IkReal(0.400000000000000))+(((r02)*(x1892)))+(((r00)*(x1893)))+(((r00)*(x1889)))+(((r01)*(x1888)))+(((IkReal(-1.00000000000000))*(px)))+(((IkReal(-0.390000000000000))*(r01)*(x1890))));
evalcond[4]=((IkReal(-0.00200000000000000))+(((r10)*(x1893)))+(((r10)*(x1889)))+(((IkReal(-1.00000000000000))*(py)))+(((IkReal(-0.390000000000000))*(r11)*(x1890)))+(((IkReal(0.390000000000000))*(x1891)))+(((r11)*(x1888))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x1894=((cj6)*(sj5));
IkReal x1895=((IkReal(1.00000000000000))*(sj5)*(sj6));
if( IKabs(((((cj5)*(r22)))+(((r20)*(x1894)))+(((IkReal(-1.00000000000000))*(r21)*(x1895))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((r00)*(x1894)))+(((IkReal(-1.00000000000000))*(r01)*(x1895)))+(((cj5)*(r02))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((cj5)*(r22)))+(((r20)*(x1894)))+(((IkReal(-1.00000000000000))*(r21)*(x1895)))))+IKsqr(((((r00)*(x1894)))+(((IkReal(-1.00000000000000))*(r01)*(x1895)))+(((cj5)*(r02)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((cj5)*(r22)))+(((r20)*(x1894)))+(((IkReal(-1.00000000000000))*(r21)*(x1895)))), ((((r00)*(x1894)))+(((IkReal(-1.00000000000000))*(r01)*(x1895)))+(((cj5)*(r02)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x1896=((cj6)*(sj5));
IkReal x1897=((IkReal(1.00000000000000))*(sj5)*(sj6));
evalcond[0]=((((cj5)*(r22)))+(((r20)*(x1896)))+(((IkReal(-1.00000000000000))*(IKsin(j3))))+(((IkReal(-1.00000000000000))*(r21)*(x1897))));
evalcond[1]=((((r00)*(x1896)))+(((IkReal(-1.00000000000000))*(r01)*(x1897)))+(((IkReal(-1.00000000000000))*(IKcos(j3))))+(((cj5)*(r02))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst31;
IkReal x1898=(sj6)*(sj6);
IkReal x1899=(cj6)*(cj6);
IkReal x1900=((cj6)*(sj5));
IkReal x1901=((r10)*(r21));
IkReal x1902=((IkReal(1.00000000000000))*(r12));
IkReal x1903=((sj5)*(sj6));
IkReal x1904=((cj5)*(x1899));
IkReal x1905=((IkReal(1.00000000000000))*(r11)*(r20));
IkReal x1906=((cj5)*(x1898));
gconst31=IKsign(((((x1901)*(x1904)))+(((x1901)*(x1906)))+(((r11)*(r22)*(x1900)))+(((IkReal(-1.00000000000000))*(x1905)*(x1906)))+(((r10)*(r22)*(x1903)))+(((IkReal(-1.00000000000000))*(x1904)*(x1905)))+(((IkReal(-1.00000000000000))*(r21)*(x1900)*(x1902)))+(((IkReal(-1.00000000000000))*(r20)*(x1902)*(x1903)))));
IkReal x1907=(sj6)*(sj6);
IkReal x1908=(cj6)*(cj6);
IkReal x1909=((cj6)*(sj5));
IkReal x1910=((r10)*(r21));
IkReal x1911=((IkReal(1.00000000000000))*(r12));
IkReal x1912=((sj5)*(sj6));
IkReal x1913=((cj5)*(x1908));
IkReal x1914=((IkReal(1.00000000000000))*(r11)*(r20));
IkReal x1915=((cj5)*(x1907));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x1914)*(x1915)))+(((IkReal(-1.00000000000000))*(r20)*(x1911)*(x1912)))+(((r11)*(r22)*(x1909)))+(((x1910)*(x1913)))+(((x1910)*(x1915)))+(((r10)*(r22)*(x1912)))+(((IkReal(-1.00000000000000))*(r21)*(x1909)*(x1911)))+(((IkReal(-1.00000000000000))*(x1913)*(x1914))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst32;
IkReal x1916=(r20)*(r20);
IkReal x1917=(cj5)*(cj5);
IkReal x1918=(sj6)*(sj6);
IkReal x1919=(cj6)*(cj6);
IkReal x1920=(r21)*(r21);
IkReal x1921=((cj6)*(r20));
IkReal x1922=((IkReal(2.00000000000000))*(r21)*(sj6));
IkReal x1923=((cj5)*(r22)*(sj5));
gconst32=IKsign(((((IkReal(-1.00000000000000))*(x1917)*(x1921)*(x1922)))+(((x1921)*(x1922)))+(((x1916)*(x1918)))+(((x1916)*(x1917)*(x1919)))+(((x1917)*(x1918)*(x1920)))+(((x1919)*(x1920)))+(((IkReal(-2.00000000000000))*(x1921)*(x1923)))+((((r22)*(r22))*((sj5)*(sj5))))+(((x1922)*(x1923)))));
IkReal x1924=(r20)*(r20);
IkReal x1925=(cj5)*(cj5);
IkReal x1926=(sj6)*(sj6);
IkReal x1927=(cj6)*(cj6);
IkReal x1928=(r21)*(r21);
IkReal x1929=((cj6)*(r20));
IkReal x1930=((IkReal(2.00000000000000))*(r21)*(sj6));
IkReal x1931=((cj5)*(r22)*(sj5));
dummyeval[0]=((((x1927)*(x1928)))+(((x1930)*(x1931)))+(((IkReal(-1.00000000000000))*(x1925)*(x1929)*(x1930)))+(((x1924)*(x1925)*(x1927)))+(((IkReal(-2.00000000000000))*(x1929)*(x1931)))+(((x1929)*(x1930)))+(((x1925)*(x1926)*(x1928)))+((((r22)*(r22))*((sj5)*(sj5))))+(((x1924)*(x1926))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1932=((cj3)*(cj6));
IkReal x1933=((IkReal(1.00000000000000))*(r21));
IkReal x1934=((cj3)*(sj6));
if( IKabs(((gconst32)*(((((IkReal(-1.00000000000000))*(x1932)*(x1933)))+(((IkReal(-1.00000000000000))*(r20)*(x1934))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst32)*(((((IkReal(-1.00000000000000))*(cj5)*(x1933)*(x1934)))+(((cj5)*(r20)*(x1932)))+(((IkReal(-1.00000000000000))*(cj3)*(r22)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst32)*(((((IkReal(-1.00000000000000))*(x1932)*(x1933)))+(((IkReal(-1.00000000000000))*(r20)*(x1934)))))), ((gconst32)*(((((IkReal(-1.00000000000000))*(cj5)*(x1933)*(x1934)))+(((cj5)*(r20)*(x1932)))+(((IkReal(-1.00000000000000))*(cj3)*(r22)*(sj5)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1935=IKsin(j4);
IkReal x1936=IKcos(j4);
IkReal x1937=((IkReal(1.00000000000000))*(r00));
IkReal x1938=((cj5)*(r01));
IkReal x1939=((cj5)*(r11));
IkReal x1940=((IkReal(1.00000000000000))*(cj5));
IkReal x1941=((cj5)*(r21));
IkReal x1942=((sj5)*(x1935));
IkReal x1943=((cj6)*(x1935));
IkReal x1944=((sj6)*(x1936));
IkReal x1945=((sj6)*(x1935));
IkReal x1946=((sj5)*(x1936));
IkReal x1947=((cj6)*(x1936));
evalcond[0]=((((IkReal(-1.00000000000000))*(r20)*(x1944)))+(((IkReal(-1.00000000000000))*(r20)*(x1940)*(x1943)))+(((r22)*(x1942)))+(((x1941)*(x1945)))+(((IkReal(-1.00000000000000))*(r21)*(x1947))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r20)*(x1940)*(x1947)))+(cj3)+(((r20)*(x1945)))+(((r22)*(x1946)))+(((x1941)*(x1944)))+(((r21)*(x1943))));
evalcond[2]=((((x1938)*(x1945)))+(((IkReal(-1.00000000000000))*(x1937)*(x1944)))+(((IkReal(-1.00000000000000))*(r01)*(x1947)))+(((IkReal(-1.00000000000000))*(cj5)*(x1937)*(x1943)))+(((r02)*(x1942))));
evalcond[3]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(r10)*(x1940)*(x1943)))+(((x1939)*(x1945)))+(((r12)*(x1942)))+(((IkReal(-1.00000000000000))*(r11)*(x1947)))+(((IkReal(-1.00000000000000))*(r10)*(x1944))));
evalcond[4]=((((IkReal(-1.00000000000000))*(sj3)))+(((x1938)*(x1944)))+(((r00)*(x1945)))+(((r01)*(x1943)))+(((IkReal(-1.00000000000000))*(cj5)*(x1937)*(x1947)))+(((r02)*(x1946))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(x1940)*(x1947)))+(((r11)*(x1943)))+(((x1939)*(x1944)))+(((r10)*(x1945)))+(((r12)*(x1946))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1948=((cj3)*(sj6));
IkReal x1949=((IkReal(1.00000000000000))*(r10));
IkReal x1950=((cj3)*(cj6));
if( IKabs(((gconst31)*(((((cj3)*(r12)*(sj5)))+(((cj5)*(r11)*(x1948)))+(((IkReal(-1.00000000000000))*(cj5)*(x1949)*(x1950))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst31)*(((((IkReal(-1.00000000000000))*(r11)*(x1950)))+(((IkReal(-1.00000000000000))*(x1948)*(x1949))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst31)*(((((cj3)*(r12)*(sj5)))+(((cj5)*(r11)*(x1948)))+(((IkReal(-1.00000000000000))*(cj5)*(x1949)*(x1950)))))), ((gconst31)*(((((IkReal(-1.00000000000000))*(r11)*(x1950)))+(((IkReal(-1.00000000000000))*(x1948)*(x1949)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1951=IKsin(j4);
IkReal x1952=IKcos(j4);
IkReal x1953=((IkReal(1.00000000000000))*(r00));
IkReal x1954=((cj5)*(r01));
IkReal x1955=((cj5)*(r11));
IkReal x1956=((IkReal(1.00000000000000))*(cj5));
IkReal x1957=((cj5)*(r21));
IkReal x1958=((sj5)*(x1951));
IkReal x1959=((cj6)*(x1951));
IkReal x1960=((sj6)*(x1952));
IkReal x1961=((sj6)*(x1951));
IkReal x1962=((sj5)*(x1952));
IkReal x1963=((cj6)*(x1952));
evalcond[0]=((((IkReal(-1.00000000000000))*(r20)*(x1960)))+(((IkReal(-1.00000000000000))*(r20)*(x1956)*(x1959)))+(((x1957)*(x1961)))+(((r22)*(x1958)))+(((IkReal(-1.00000000000000))*(r21)*(x1963))));
evalcond[1]=((cj3)+(((IkReal(-1.00000000000000))*(r20)*(x1956)*(x1963)))+(((r20)*(x1961)))+(((r21)*(x1959)))+(((x1957)*(x1960)))+(((r22)*(x1962))));
evalcond[2]=((((IkReal(-1.00000000000000))*(cj5)*(x1953)*(x1959)))+(((x1954)*(x1961)))+(((IkReal(-1.00000000000000))*(r01)*(x1963)))+(((IkReal(-1.00000000000000))*(x1953)*(x1960)))+(((r02)*(x1958))));
evalcond[3]=((IkReal(-1.00000000000000))+(((r12)*(x1958)))+(((x1955)*(x1961)))+(((IkReal(-1.00000000000000))*(r11)*(x1963)))+(((IkReal(-1.00000000000000))*(r10)*(x1960)))+(((IkReal(-1.00000000000000))*(r10)*(x1956)*(x1959))));
evalcond[4]=((((r02)*(x1962)))+(((IkReal(-1.00000000000000))*(sj3)))+(((x1954)*(x1960)))+(((IkReal(-1.00000000000000))*(cj5)*(x1953)*(x1963)))+(((r00)*(x1961)))+(((r01)*(x1959))));
evalcond[5]=((((r10)*(x1961)))+(((r11)*(x1959)))+(((r12)*(x1962)))+(((IkReal(-1.00000000000000))*(r10)*(x1956)*(x1963)))+(((x1955)*(x1960))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x1964=((cj6)*(sj5));
IkReal x1965=((IkReal(1.00000000000000))*(sj5)*(sj6));
if( IKabs(((((cj5)*(r22)))+(((r20)*(x1964)))+(((IkReal(-1.00000000000000))*(r21)*(x1965))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((cj5)*(r12)))+(((r10)*(x1964)))+(((IkReal(-1.00000000000000))*(r11)*(x1965))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((cj5)*(r22)))+(((r20)*(x1964)))+(((IkReal(-1.00000000000000))*(r21)*(x1965)))))+IKsqr(((((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((cj5)*(r12)))+(((r10)*(x1964)))+(((IkReal(-1.00000000000000))*(r11)*(x1965)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((cj5)*(r22)))+(((r20)*(x1964)))+(((IkReal(-1.00000000000000))*(r21)*(x1965)))), ((((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((cj5)*(r12)))+(((r10)*(x1964)))+(((IkReal(-1.00000000000000))*(r11)*(x1965)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[3];
IkReal x1966=IKcos(j3);
IkReal x1967=((cj6)*(sj5));
IkReal x1968=((IkReal(1.00000000000000))*(sj5)*(sj6));
evalcond[0]=((((cj5)*(r22)))+(((r20)*(x1967)))+(((IkReal(-1.00000000000000))*(IKsin(j3))))+(((IkReal(-1.00000000000000))*(r21)*(x1968))));
evalcond[1]=((((sj1)*(x1966)))+(((r00)*(x1967)))+(((IkReal(-1.00000000000000))*(r01)*(x1968)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((r10)*(x1967)))+(((IkReal(-1.00000000000000))*(cj1)*(x1966)))+(((IkReal(-1.00000000000000))*(r11)*(x1968))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst23;
IkReal x1969=(r20)*(r20);
IkReal x1970=(cj5)*(cj5);
IkReal x1971=(sj6)*(sj6);
IkReal x1972=(cj6)*(cj6);
IkReal x1973=(r21)*(r21);
IkReal x1974=((cj6)*(r20));
IkReal x1975=((IkReal(2.00000000000000))*(r21)*(sj6));
IkReal x1976=((cj5)*(r22)*(sj5));
gconst23=IKsign(((((x1969)*(x1971)))+(((x1970)*(x1971)*(x1973)))+(((x1972)*(x1973)))+(((x1975)*(x1976)))+(((x1969)*(x1970)*(x1972)))+(((x1974)*(x1975)))+(((IkReal(-2.00000000000000))*(x1974)*(x1976)))+(((IkReal(-1.00000000000000))*(x1970)*(x1974)*(x1975)))+((((r22)*(r22))*((sj5)*(sj5))))));
IkReal x1977=(r20)*(r20);
IkReal x1978=(cj5)*(cj5);
IkReal x1979=(sj6)*(sj6);
IkReal x1980=(cj6)*(cj6);
IkReal x1981=(r21)*(r21);
IkReal x1982=((cj6)*(r20));
IkReal x1983=((IkReal(2.00000000000000))*(r21)*(sj6));
IkReal x1984=((cj5)*(r22)*(sj5));
dummyeval[0]=((((x1980)*(x1981)))+(((IkReal(-1.00000000000000))*(x1978)*(x1982)*(x1983)))+(((x1982)*(x1983)))+(((IkReal(-2.00000000000000))*(x1982)*(x1984)))+(((x1977)*(x1979)))+(((x1977)*(x1978)*(x1980)))+((((r22)*(r22))*((sj5)*(sj5))))+(((x1983)*(x1984)))+(((x1978)*(x1979)*(x1981))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst24;
IkReal x1985=(cj5)*(cj5);
IkReal x1986=(sj6)*(sj6);
IkReal x1987=(cj6)*(cj6);
IkReal x1988=((r00)*(r20));
IkReal x1989=((cj5)*(sj5));
IkReal x1990=((r01)*(r21));
IkReal x1991=((r21)*(sj6));
IkReal x1992=((sj6)*(x1989));
IkReal x1993=((IkReal(1.00000000000000))*(cj6)*(r00));
IkReal x1994=((cj6)*(r01)*(r20)*(sj6));
gconst24=IKsign(((((r02)*(x1989)*(x1991)))+(((IkReal(-1.00000000000000))*(r22)*(x1989)*(x1993)))+(((cj6)*(r00)*(x1991)))+(((IkReal(-1.00000000000000))*(x1985)*(x1994)))+(((x1985)*(x1986)*(x1990)))+(((r01)*(r22)*(x1992)))+(x1994)+(((r02)*(r22)*((sj5)*(sj5))))+(((x1987)*(x1990)))+(((x1985)*(x1987)*(x1988)))+(((x1986)*(x1988)))+(((IkReal(-1.00000000000000))*(x1985)*(x1991)*(x1993)))+(((IkReal(-1.00000000000000))*(cj6)*(r02)*(r20)*(x1989)))));
IkReal x1995=(cj5)*(cj5);
IkReal x1996=(sj6)*(sj6);
IkReal x1997=(cj6)*(cj6);
IkReal x1998=((r00)*(r20));
IkReal x1999=((cj5)*(sj5));
IkReal x2000=((r01)*(r21));
IkReal x2001=((r21)*(sj6));
IkReal x2002=((sj6)*(x1999));
IkReal x2003=((IkReal(1.00000000000000))*(cj6)*(r00));
IkReal x2004=x1994;
dummyeval[0]=((((x1997)*(x2000)))+(((x1995)*(x1997)*(x1998)))+(((x1996)*(x1998)))+(((r01)*(r22)*(x2002)))+(((x1995)*(x1996)*(x2000)))+(x2004)+(((IkReal(-1.00000000000000))*(r22)*(x1999)*(x2003)))+(((IkReal(-1.00000000000000))*(x1995)*(x2001)*(x2003)))+(((IkReal(-1.00000000000000))*(x1995)*(x2004)))+(((r02)*(x1999)*(x2001)))+(((IkReal(-1.00000000000000))*(cj6)*(r02)*(r20)*(x1999)))+(((cj6)*(r00)*(x2001)))+(((r02)*(r22)*((sj5)*(sj5)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x2005=((cj1)*(r20));
IkReal x2006=((cj5)*(cj6));
IkReal x2007=((IkReal(1.00000000000000))*(cj1));
IkReal x2008=((IkReal(1.00000000000000))*(cj3));
IkReal x2009=((sj6)*(x2008));
if( IKabs(((gconst24)*(((((IkReal(-1.00000000000000))*(r22)*(sj5)*(x2007)))+(((IkReal(-1.00000000000000))*(r00)*(x2009)))+(((x2005)*(x2006)))+(((IkReal(-1.00000000000000))*(cj5)*(r21)*(sj6)*(x2007)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x2008))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst24)*(((((IkReal(-1.00000000000000))*(cj5)*(r01)*(x2009)))+(((IkReal(-1.00000000000000))*(r02)*(sj5)*(x2008)))+(((cj1)*(cj6)*(r21)))+(((cj3)*(r00)*(x2006)))+(((sj6)*(x2005))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst24)*(((((IkReal(-1.00000000000000))*(r22)*(sj5)*(x2007)))+(((IkReal(-1.00000000000000))*(r00)*(x2009)))+(((x2005)*(x2006)))+(((IkReal(-1.00000000000000))*(cj5)*(r21)*(sj6)*(x2007)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x2008)))))), ((gconst24)*(((((IkReal(-1.00000000000000))*(cj5)*(r01)*(x2009)))+(((IkReal(-1.00000000000000))*(r02)*(sj5)*(x2008)))+(((cj1)*(cj6)*(r21)))+(((cj3)*(r00)*(x2006)))+(((sj6)*(x2005)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x2010=IKsin(j4);
IkReal x2011=IKcos(j4);
IkReal x2012=((IkReal(1.00000000000000))*(r00));
IkReal x2013=((cj5)*(r01));
IkReal x2014=((cj5)*(r11));
IkReal x2015=((IkReal(1.00000000000000))*(cj5));
IkReal x2016=((cj5)*(r21));
IkReal x2017=((sj5)*(x2010));
IkReal x2018=((cj6)*(x2010));
IkReal x2019=((sj6)*(x2011));
IkReal x2020=((sj6)*(x2010));
IkReal x2021=((sj5)*(x2011));
IkReal x2022=((cj6)*(x2011));
evalcond[0]=((((IkReal(-1.00000000000000))*(r20)*(x2019)))+(((IkReal(-1.00000000000000))*(r21)*(x2022)))+(((r22)*(x2017)))+(((x2016)*(x2020)))+(((IkReal(-1.00000000000000))*(r20)*(x2015)*(x2018))));
evalcond[1]=((cj3)+(((r22)*(x2021)))+(((x2016)*(x2019)))+(((IkReal(-1.00000000000000))*(r20)*(x2015)*(x2022)))+(((r21)*(x2018)))+(((r20)*(x2020))));
evalcond[2]=((cj1)+(((IkReal(-1.00000000000000))*(x2012)*(x2019)))+(((x2013)*(x2020)))+(((IkReal(-1.00000000000000))*(cj5)*(x2012)*(x2018)))+(((r02)*(x2017)))+(((IkReal(-1.00000000000000))*(r01)*(x2022))));
evalcond[3]=((sj1)+(((IkReal(-1.00000000000000))*(r10)*(x2015)*(x2018)))+(((IkReal(-1.00000000000000))*(r10)*(x2019)))+(((r12)*(x2017)))+(((x2014)*(x2020)))+(((IkReal(-1.00000000000000))*(r11)*(x2022))));
evalcond[4]=((((r00)*(x2020)))+(((IkReal(-1.00000000000000))*(cj5)*(x2012)*(x2022)))+(((sj1)*(sj3)))+(((r01)*(x2018)))+(((r02)*(x2021)))+(((x2013)*(x2019))));
evalcond[5]=((((r10)*(x2020)))+(((x2014)*(x2019)))+(((IkReal(-1.00000000000000))*(r10)*(x2015)*(x2022)))+(((IkReal(-1.00000000000000))*(cj1)*(sj3)))+(((r11)*(x2018)))+(((r12)*(x2021))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x2023=((cj3)*(cj6));
IkReal x2024=((IkReal(1.00000000000000))*(r21));
IkReal x2025=((cj3)*(sj6));
if( IKabs(((gconst23)*(((((IkReal(-1.00000000000000))*(x2023)*(x2024)))+(((IkReal(-1.00000000000000))*(r20)*(x2025))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst23)*(((((IkReal(-1.00000000000000))*(cj5)*(x2024)*(x2025)))+(((IkReal(-1.00000000000000))*(cj3)*(r22)*(sj5)))+(((cj5)*(r20)*(x2023))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst23)*(((((IkReal(-1.00000000000000))*(x2023)*(x2024)))+(((IkReal(-1.00000000000000))*(r20)*(x2025)))))), ((gconst23)*(((((IkReal(-1.00000000000000))*(cj5)*(x2024)*(x2025)))+(((IkReal(-1.00000000000000))*(cj3)*(r22)*(sj5)))+(((cj5)*(r20)*(x2023)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x2026=IKsin(j4);
IkReal x2027=IKcos(j4);
IkReal x2028=((IkReal(1.00000000000000))*(r00));
IkReal x2029=((cj5)*(r01));
IkReal x2030=((cj5)*(r11));
IkReal x2031=((IkReal(1.00000000000000))*(cj5));
IkReal x2032=((cj5)*(r21));
IkReal x2033=((sj5)*(x2026));
IkReal x2034=((cj6)*(x2026));
IkReal x2035=((sj6)*(x2027));
IkReal x2036=((sj6)*(x2026));
IkReal x2037=((sj5)*(x2027));
IkReal x2038=((cj6)*(x2027));
evalcond[0]=((((r22)*(x2033)))+(((IkReal(-1.00000000000000))*(r20)*(x2035)))+(((x2032)*(x2036)))+(((IkReal(-1.00000000000000))*(r20)*(x2031)*(x2034)))+(((IkReal(-1.00000000000000))*(r21)*(x2038))));
evalcond[1]=((((r22)*(x2037)))+(((r21)*(x2034)))+(cj3)+(((x2032)*(x2035)))+(((IkReal(-1.00000000000000))*(r20)*(x2031)*(x2038)))+(((r20)*(x2036))));
evalcond[2]=((cj1)+(((IkReal(-1.00000000000000))*(cj5)*(x2028)*(x2034)))+(((r02)*(x2033)))+(((IkReal(-1.00000000000000))*(r01)*(x2038)))+(((x2029)*(x2036)))+(((IkReal(-1.00000000000000))*(x2028)*(x2035))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r10)*(x2035)))+(sj1)+(((r12)*(x2033)))+(((x2030)*(x2036)))+(((IkReal(-1.00000000000000))*(r11)*(x2038)))+(((IkReal(-1.00000000000000))*(r10)*(x2031)*(x2034))));
evalcond[4]=((((r00)*(x2036)))+(((r01)*(x2034)))+(((IkReal(-1.00000000000000))*(cj5)*(x2028)*(x2038)))+(((sj1)*(sj3)))+(((r02)*(x2037)))+(((x2029)*(x2035))));
evalcond[5]=((((r10)*(x2036)))+(((r12)*(x2037)))+(((x2030)*(x2035)))+(((IkReal(-1.00000000000000))*(cj1)*(sj3)))+(((IkReal(-1.00000000000000))*(r10)*(x2031)*(x2038)))+(((r11)*(x2034))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x2039=((cj6)*(sj1));
IkReal x2040=((IkReal(1.00000000000000))*(sj1)*(sj6));
if( IKabs(((gconst22)*(((((IkReal(-1.00000000000000))*(r20)*(x2040)))+(((IkReal(-1.00000000000000))*(r21)*(x2039))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst22)*(((((cj5)*(r20)*(x2039)))+(((IkReal(-1.00000000000000))*(cj5)*(r21)*(x2040)))+(((IkReal(-1.00000000000000))*(r22)*(sj1)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst22)*(((((IkReal(-1.00000000000000))*(r20)*(x2040)))+(((IkReal(-1.00000000000000))*(r21)*(x2039)))))), ((gconst22)*(((((cj5)*(r20)*(x2039)))+(((IkReal(-1.00000000000000))*(cj5)*(r21)*(x2040)))+(((IkReal(-1.00000000000000))*(r22)*(sj1)*(sj5)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x2041=IKsin(j4);
IkReal x2042=IKcos(j4);
IkReal x2043=((IkReal(1.00000000000000))*(cj6));
IkReal x2044=((sj5)*(x2041));
IkReal x2045=((cj5)*(x2041));
IkReal x2046=((IkReal(1.00000000000000))*(sj6)*(x2042));
evalcond[0]=((((r22)*(x2044)))+(((IkReal(-1.00000000000000))*(r21)*(x2042)*(x2043)))+(((r21)*(sj6)*(x2045)))+(((IkReal(-1.00000000000000))*(r20)*(x2046)))+(((IkReal(-1.00000000000000))*(r20)*(x2043)*(x2045))));
evalcond[1]=((cj1)+(((r01)*(sj6)*(x2045)))+(((r02)*(x2044)))+(((IkReal(-1.00000000000000))*(r01)*(x2042)*(x2043)))+(((IkReal(-1.00000000000000))*(r00)*(x2046)))+(((IkReal(-1.00000000000000))*(r00)*(x2043)*(x2045))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r10)*(x2043)*(x2045)))+(((r11)*(sj6)*(x2045)))+(sj1)+(((IkReal(-1.00000000000000))*(r11)*(x2042)*(x2043)))+(((IkReal(-1.00000000000000))*(r10)*(x2046)))+(((r12)*(x2044))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2047=((cj4)*(cj5));
IkReal x2048=((cj6)*(r20));
IkReal x2049=((IkReal(1.00000000000000))*(sj4));
IkReal x2050=((IkReal(1.00000000000000))*(r21)*(sj6));
if( IKabs(((((sj5)*(x2048)))+(((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(sj5)*(x2050))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r20)*(sj6)*(x2049)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(sj5)))+(((x2047)*(x2048)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x2049)))+(((IkReal(-1.00000000000000))*(x2047)*(x2050))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((sj5)*(x2048)))+(((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(sj5)*(x2050)))))+IKsqr(((((IkReal(-1.00000000000000))*(r20)*(sj6)*(x2049)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(sj5)))+(((x2047)*(x2048)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x2049)))+(((IkReal(-1.00000000000000))*(x2047)*(x2050)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((sj5)*(x2048)))+(((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(sj5)*(x2050)))), ((((IkReal(-1.00000000000000))*(r20)*(sj6)*(x2049)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(sj5)))+(((x2047)*(x2048)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x2049)))+(((IkReal(-1.00000000000000))*(x2047)*(x2050)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x2051=IKcos(j3);
IkReal x2052=IKsin(j3);
IkReal x2053=((r11)*(sj6));
IkReal x2054=((IkReal(1.00000000000000))*(sj5));
IkReal x2055=((IkReal(1.00000000000000))*(cj1));
IkReal x2056=((sj4)*(sj6));
IkReal x2057=((cj4)*(sj5));
IkReal x2058=((cj6)*(sj4));
IkReal x2059=((cj4)*(cj5));
IkReal x2060=((r01)*(sj6));
IkReal x2061=((r21)*(sj6));
IkReal x2062=((cj6)*(sj5));
IkReal x2063=((IkReal(1.00000000000000))*(cj6)*(x2059));
evalcond[0]=((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(x2052)))+(((r20)*(x2062)))+(((IkReal(-1.00000000000000))*(x2054)*(x2061))));
evalcond[1]=((((sj1)*(x2051)))+(((IkReal(-1.00000000000000))*(x2054)*(x2060)))+(((r00)*(x2062)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x2051)*(x2055)))+(((r10)*(x2062)))+(((IkReal(-1.00000000000000))*(x2053)*(x2054))));
evalcond[3]=((((r22)*(x2057)))+(x2051)+(((x2059)*(x2061)))+(((IkReal(-1.00000000000000))*(r20)*(x2063)))+(((r20)*(x2056)))+(((r21)*(x2058))));
evalcond[4]=((((r01)*(x2058)))+(((x2059)*(x2060)))+(((sj1)*(x2052)))+(((r02)*(x2057)))+(((IkReal(-1.00000000000000))*(r00)*(x2063)))+(((r00)*(x2056))));
evalcond[5]=((((r10)*(x2056)))+(((r12)*(x2057)))+(((IkReal(-1.00000000000000))*(r10)*(x2063)))+(((x2053)*(x2059)))+(((r11)*(x2058)))+(((IkReal(-1.00000000000000))*(x2052)*(x2055))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x2064=((cj1)*(cj6));
IkReal x2065=((IkReal(1.00000000000000))*(cj1));
if( IKabs(((gconst21)*(((((IkReal(-1.00000000000000))*(r21)*(x2064)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x2065))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst21)*(((((IkReal(-1.00000000000000))*(cj5)*(r21)*(sj6)*(x2065)))+(((cj5)*(r20)*(x2064)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x2065))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst21)*(((((IkReal(-1.00000000000000))*(r21)*(x2064)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x2065)))))), ((gconst21)*(((((IkReal(-1.00000000000000))*(cj5)*(r21)*(sj6)*(x2065)))+(((cj5)*(r20)*(x2064)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x2065)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x2066=IKsin(j4);
IkReal x2067=IKcos(j4);
IkReal x2068=((IkReal(1.00000000000000))*(cj6));
IkReal x2069=((sj5)*(x2066));
IkReal x2070=((cj5)*(x2066));
IkReal x2071=((IkReal(1.00000000000000))*(sj6)*(x2067));
evalcond[0]=((((r22)*(x2069)))+(((r21)*(sj6)*(x2070)))+(((IkReal(-1.00000000000000))*(r21)*(x2067)*(x2068)))+(((IkReal(-1.00000000000000))*(r20)*(x2068)*(x2070)))+(((IkReal(-1.00000000000000))*(r20)*(x2071))));
evalcond[1]=((cj1)+(((IkReal(-1.00000000000000))*(r00)*(x2068)*(x2070)))+(((IkReal(-1.00000000000000))*(r01)*(x2067)*(x2068)))+(((r01)*(sj6)*(x2070)))+(((r02)*(x2069)))+(((IkReal(-1.00000000000000))*(r00)*(x2071))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r10)*(x2071)))+(sj1)+(((r12)*(x2069)))+(((r11)*(sj6)*(x2070)))+(((IkReal(-1.00000000000000))*(r11)*(x2067)*(x2068)))+(((IkReal(-1.00000000000000))*(r10)*(x2068)*(x2070))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2072=((cj4)*(cj5));
IkReal x2073=((cj6)*(r20));
IkReal x2074=((IkReal(1.00000000000000))*(sj4));
IkReal x2075=((IkReal(1.00000000000000))*(r21)*(sj6));
if( IKabs(((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(sj5)*(x2075)))+(((sj5)*(x2073))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r20)*(sj6)*(x2074)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x2074)))+(((x2072)*(x2073)))+(((IkReal(-1.00000000000000))*(x2072)*(x2075))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(sj5)*(x2075)))+(((sj5)*(x2073)))))+IKsqr(((((IkReal(-1.00000000000000))*(r20)*(sj6)*(x2074)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x2074)))+(((x2072)*(x2073)))+(((IkReal(-1.00000000000000))*(x2072)*(x2075)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(sj5)*(x2075)))+(((sj5)*(x2073)))), ((((IkReal(-1.00000000000000))*(r20)*(sj6)*(x2074)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x2074)))+(((x2072)*(x2073)))+(((IkReal(-1.00000000000000))*(x2072)*(x2075)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x2076=IKcos(j3);
IkReal x2077=IKsin(j3);
IkReal x2078=((r11)*(sj6));
IkReal x2079=((IkReal(1.00000000000000))*(sj5));
IkReal x2080=((IkReal(1.00000000000000))*(cj1));
IkReal x2081=((sj4)*(sj6));
IkReal x2082=((cj4)*(sj5));
IkReal x2083=((cj6)*(sj4));
IkReal x2084=((cj4)*(cj5));
IkReal x2085=((r01)*(sj6));
IkReal x2086=((r21)*(sj6));
IkReal x2087=((cj6)*(sj5));
IkReal x2088=((IkReal(1.00000000000000))*(cj6)*(x2084));
evalcond[0]=((((cj5)*(r22)))+(((r20)*(x2087)))+(((IkReal(-1.00000000000000))*(x2077)))+(((IkReal(-1.00000000000000))*(x2079)*(x2086))));
evalcond[1]=((((sj1)*(x2076)))+(((IkReal(-1.00000000000000))*(x2079)*(x2085)))+(((r00)*(x2087)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x2076)*(x2080)))+(((r10)*(x2087)))+(((IkReal(-1.00000000000000))*(x2078)*(x2079))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r20)*(x2088)))+(((x2084)*(x2086)))+(x2076)+(((r20)*(x2081)))+(((r21)*(x2083)))+(((r22)*(x2082))));
evalcond[4]=((((r02)*(x2082)))+(((x2084)*(x2085)))+(((sj1)*(x2077)))+(((r01)*(x2083)))+(((r00)*(x2081)))+(((IkReal(-1.00000000000000))*(r00)*(x2088))));
evalcond[5]=((((x2078)*(x2084)))+(((IkReal(-1.00000000000000))*(x2077)*(x2080)))+(((r10)*(x2081)))+(((IkReal(-1.00000000000000))*(r10)*(x2088)))+(((r11)*(x2083)))+(((r12)*(x2082))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
}
}

}

}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2089=(sj1)*(sj1);
IkReal x2090=(cj1)*(cj1);
IkReal x2091=((cj5)*(r12));
IkReal x2092=((cj6)*(sj5));
IkReal x2093=((IkReal(1.00000000000000))*(sj1));
IkReal x2094=((cj5)*(r02));
IkReal x2095=((IkReal(1.00000000000000))*(cj1));
IkReal x2096=((r01)*(sj5)*(sj6));
IkReal x2097=((r11)*(sj5)*(sj6));
if( IKabs(((((IKabs(((((cj2)*(x2090)))+(((cj2)*(x2089))))) != 0)?((IkReal)1/(((((cj2)*(x2090)))+(((cj2)*(x2089)))))):(IkReal)1.0e30))*(((((cj1)*(x2094)))+(((cj1)*(r00)*(x2092)))+(((sj1)*(x2091)))+(((IkReal(-1.00000000000000))*(x2095)*(x2096)))+(((IkReal(-1.00000000000000))*(x2093)*(x2097)))+(((r10)*(sj1)*(x2092))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IKabs(((x2090)+(x2089))) != 0)?((IkReal)1/(((x2090)+(x2089)))):(IkReal)1.0e30))*(((((cj1)*(x2091)))+(((sj1)*(x2096)))+(((IkReal(-1.00000000000000))*(x2095)*(x2097)))+(((IkReal(-1.00000000000000))*(x2093)*(x2094)))+(((cj1)*(r10)*(x2092)))+(((IkReal(-1.00000000000000))*(r00)*(x2092)*(x2093))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IKabs(((((cj2)*(x2090)))+(((cj2)*(x2089))))) != 0)?((IkReal)1/(((((cj2)*(x2090)))+(((cj2)*(x2089)))))):(IkReal)1.0e30))*(((((cj1)*(x2094)))+(((cj1)*(r00)*(x2092)))+(((sj1)*(x2091)))+(((IkReal(-1.00000000000000))*(x2095)*(x2096)))+(((IkReal(-1.00000000000000))*(x2093)*(x2097)))+(((r10)*(sj1)*(x2092)))))))+IKsqr(((((IKabs(((x2090)+(x2089))) != 0)?((IkReal)1/(((x2090)+(x2089)))):(IkReal)1.0e30))*(((((cj1)*(x2091)))+(((sj1)*(x2096)))+(((IkReal(-1.00000000000000))*(x2095)*(x2097)))+(((IkReal(-1.00000000000000))*(x2093)*(x2094)))+(((cj1)*(r10)*(x2092)))+(((IkReal(-1.00000000000000))*(r00)*(x2092)*(x2093)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IKabs(((((cj2)*(x2090)))+(((cj2)*(x2089))))) != 0)?((IkReal)1/(((((cj2)*(x2090)))+(((cj2)*(x2089)))))):(IkReal)1.0e30))*(((((cj1)*(x2094)))+(((cj1)*(r00)*(x2092)))+(((sj1)*(x2091)))+(((IkReal(-1.00000000000000))*(x2095)*(x2096)))+(((IkReal(-1.00000000000000))*(x2093)*(x2097)))+(((r10)*(sj1)*(x2092)))))), ((((IKabs(((x2090)+(x2089))) != 0)?((IkReal)1/(((x2090)+(x2089)))):(IkReal)1.0e30))*(((((cj1)*(x2091)))+(((sj1)*(x2096)))+(((IkReal(-1.00000000000000))*(x2095)*(x2097)))+(((IkReal(-1.00000000000000))*(x2093)*(x2094)))+(((cj1)*(r10)*(x2092)))+(((IkReal(-1.00000000000000))*(r00)*(x2092)*(x2093)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[3];
IkReal x2098=IKsin(j3);
IkReal x2099=IKcos(j3);
IkReal x2100=((IkReal(1.00000000000000))*(cj1));
IkReal x2101=((cj6)*(sj5));
IkReal x2102=((IkReal(1.00000000000000))*(sj5)*(sj6));
IkReal x2103=((cj2)*(x2098));
evalcond[0]=((((r20)*(x2101)))+(((cj5)*(r22)))+(((sj2)*(x2098)))+(((IkReal(-1.00000000000000))*(r21)*(x2102))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x2100)*(x2103)))+(((sj1)*(x2099)))+(((r00)*(x2101)))+(((IkReal(-1.00000000000000))*(r01)*(x2102)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(sj1)*(x2103)))+(((IkReal(-1.00000000000000))*(r11)*(x2102)))+(((r10)*(x2101)))+(((IkReal(-1.00000000000000))*(x2099)*(x2100))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst2;
IkReal x2104=(cj5)*(cj5);
IkReal x2105=(r21)*(r21);
IkReal x2106=(sj6)*(sj6);
IkReal x2107=(cj6)*(cj6);
IkReal x2108=(r20)*(r20);
IkReal x2109=((cj6)*(r20));
IkReal x2110=((IkReal(1.00000000000000))*(x2107));
IkReal x2111=((IkReal(2.00000000000000))*(r21)*(sj6));
IkReal x2112=((cj5)*(r22)*(sj5));
IkReal x2113=((IkReal(1.00000000000000))*(x2106));
gconst2=IKsign(((((x2104)*(x2109)*(x2111)))+(((IkReal(2.00000000000000))*(x2109)*(x2112)))+(((IkReal(-1.00000000000000))*(x2108)*(x2113)))+(((IkReal(-1.00000000000000))*(x2104)*(x2105)*(x2113)))+(((IkReal(-1.00000000000000))*(x2111)*(x2112)))+(((IkReal(-1.00000000000000))*(x2109)*(x2111)))+(((IkReal(-1.00000000000000))*(x2104)*(x2108)*(x2110)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x2105)*(x2110)))));
IkReal x2114=(cj5)*(cj5);
IkReal x2115=(r21)*(r21);
IkReal x2116=(sj6)*(sj6);
IkReal x2117=(cj6)*(cj6);
IkReal x2118=(r20)*(r20);
IkReal x2119=((cj6)*(r20));
IkReal x2120=((IkReal(1.00000000000000))*(x2117));
IkReal x2121=((IkReal(2.00000000000000))*(r21)*(sj6));
IkReal x2122=((cj5)*(r22)*(sj5));
IkReal x2123=((IkReal(1.00000000000000))*(x2116));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x2119)*(x2121)))+(((IkReal(-1.00000000000000))*(x2118)*(x2123)))+(((IkReal(-1.00000000000000))*(x2114)*(x2115)*(x2123)))+(((IkReal(2.00000000000000))*(x2119)*(x2122)))+(((IkReal(-1.00000000000000))*(x2121)*(x2122)))+(((IkReal(-1.00000000000000))*(x2115)*(x2120)))+(((IkReal(-1.00000000000000))*(x2114)*(x2118)*(x2120)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((x2114)*(x2119)*(x2121))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst3;
IkReal x2124=(cj5)*(cj5);
IkReal x2125=(sj6)*(sj6);
IkReal x2126=(cj6)*(cj6);
IkReal x2127=((r00)*(r20));
IkReal x2128=((cj5)*(sj5));
IkReal x2129=((r01)*(r21));
IkReal x2130=((r21)*(sj6));
IkReal x2131=((sj6)*(x2128));
IkReal x2132=((IkReal(1.00000000000000))*(cj6)*(r00));
IkReal x2133=((cj6)*(r01)*(r20)*(sj6));
gconst3=IKsign(((((x2125)*(x2127)))+(((cj6)*(r00)*(x2130)))+(((r01)*(r22)*(x2131)))+(((r02)*(x2128)*(x2130)))+(((IkReal(-1.00000000000000))*(cj6)*(r02)*(r20)*(x2128)))+(((IkReal(-1.00000000000000))*(r22)*(x2128)*(x2132)))+(x2133)+(((x2124)*(x2126)*(x2127)))+(((r02)*(r22)*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x2124)*(x2130)*(x2132)))+(((IkReal(-1.00000000000000))*(x2124)*(x2133)))+(((x2126)*(x2129)))+(((x2124)*(x2125)*(x2129)))));
IkReal x2134=(cj5)*(cj5);
IkReal x2135=(sj6)*(sj6);
IkReal x2136=(cj6)*(cj6);
IkReal x2137=((r00)*(r20));
IkReal x2138=((cj5)*(sj5));
IkReal x2139=((r01)*(r21));
IkReal x2140=((r21)*(sj6));
IkReal x2141=((sj6)*(x2138));
IkReal x2142=((IkReal(1.00000000000000))*(cj6)*(r00));
IkReal x2143=x2133;
dummyeval[0]=((((x2134)*(x2135)*(x2139)))+(((x2136)*(x2139)))+(((r02)*(x2138)*(x2140)))+(((IkReal(-1.00000000000000))*(x2134)*(x2143)))+(x2143)+(((cj6)*(r00)*(x2140)))+(((IkReal(-1.00000000000000))*(x2134)*(x2140)*(x2142)))+(((x2135)*(x2137)))+(((IkReal(-1.00000000000000))*(cj6)*(r02)*(r20)*(x2138)))+(((r02)*(r22)*((sj5)*(sj5))))+(((r01)*(r22)*(x2141)))+(((IkReal(-1.00000000000000))*(r22)*(x2138)*(x2142)))+(((x2134)*(x2136)*(x2137))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x2144=((sj2)*(sj5));
IkReal x2145=((cj5)*(sj6));
IkReal x2146=((sj2)*(sj6));
IkReal x2147=((cj3)*(r00));
IkReal x2148=((cj3)*(r01)*(sj2));
IkReal x2149=((IkReal(1.00000000000000))*(cj1)*(cj6)*(sj2));
if( IKabs(((gconst3)*(((((x2146)*(x2147)))+(((cj6)*(x2148)))+(((cj1)*(r22)*(x2144)))+(((cj1)*(r21)*(sj2)*(x2145)))+(((IkReal(-1.00000000000000))*(cj5)*(r20)*(x2149))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst3)*(((((IkReal(-1.00000000000000))*(cj5)*(cj6)*(sj2)*(x2147)))+(((x2145)*(x2148)))+(((IkReal(-1.00000000000000))*(cj1)*(r20)*(x2146)))+(((cj3)*(r02)*(x2144)))+(((IkReal(-1.00000000000000))*(r21)*(x2149))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst3)*(((((x2146)*(x2147)))+(((cj6)*(x2148)))+(((cj1)*(r22)*(x2144)))+(((cj1)*(r21)*(sj2)*(x2145)))+(((IkReal(-1.00000000000000))*(cj5)*(r20)*(x2149)))))), ((gconst3)*(((((IkReal(-1.00000000000000))*(cj5)*(cj6)*(sj2)*(x2147)))+(((x2145)*(x2148)))+(((IkReal(-1.00000000000000))*(cj1)*(r20)*(x2146)))+(((cj3)*(r02)*(x2144)))+(((IkReal(-1.00000000000000))*(r21)*(x2149)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x2150=IKsin(j4);
IkReal x2151=IKcos(j4);
IkReal x2152=((IkReal(1.00000000000000))*(r00));
IkReal x2153=((cj5)*(r01));
IkReal x2154=((cj5)*(r11));
IkReal x2155=((cj2)*(cj3));
IkReal x2156=((IkReal(1.00000000000000))*(sj2));
IkReal x2157=((IkReal(1.00000000000000))*(cj5));
IkReal x2158=((cj5)*(r21));
IkReal x2159=((sj5)*(x2150));
IkReal x2160=((cj6)*(x2150));
IkReal x2161=((sj6)*(x2151));
IkReal x2162=((sj6)*(x2150));
IkReal x2163=((sj5)*(x2151));
IkReal x2164=((cj6)*(x2151));
evalcond[0]=((((IkReal(-1.00000000000000))*(r21)*(x2164)))+(((IkReal(-1.00000000000000))*(r20)*(x2157)*(x2160)))+(((r22)*(x2159)))+(((x2158)*(x2162)))+(((IkReal(-1.00000000000000))*(r20)*(x2161)))+(((IkReal(-1.00000000000000))*(cj2))));
evalcond[1]=((((r21)*(x2160)))+(((r20)*(x2162)))+(((IkReal(-1.00000000000000))*(r20)*(x2157)*(x2164)))+(((r22)*(x2163)))+(((x2158)*(x2161)))+(((IkReal(-1.00000000000000))*(cj3)*(x2156))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x2152)*(x2161)))+(((r02)*(x2159)))+(((x2153)*(x2162)))+(((IkReal(-1.00000000000000))*(cj1)*(x2156)))+(((IkReal(-1.00000000000000))*(cj5)*(x2152)*(x2160)))+(((IkReal(-1.00000000000000))*(r01)*(x2164))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r11)*(x2164)))+(((IkReal(-1.00000000000000))*(sj1)*(x2156)))+(((x2154)*(x2162)))+(((IkReal(-1.00000000000000))*(r10)*(x2161)))+(((r12)*(x2159)))+(((IkReal(-1.00000000000000))*(r10)*(x2157)*(x2160))));
evalcond[4]=((((r00)*(x2162)))+(((r01)*(x2160)))+(((sj1)*(sj3)))+(((r02)*(x2163)))+(((x2153)*(x2161)))+(((IkReal(-1.00000000000000))*(cj5)*(x2152)*(x2164)))+(((cj1)*(x2155))));
evalcond[5]=((((r12)*(x2163)))+(((IkReal(-1.00000000000000))*(cj1)*(sj3)))+(((sj1)*(x2155)))+(((x2154)*(x2161)))+(((r10)*(x2162)))+(((r11)*(x2160)))+(((IkReal(-1.00000000000000))*(r10)*(x2157)*(x2164))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x2165=((r22)*(sj5));
IkReal x2166=((cj2)*(cj5));
IkReal x2167=((r21)*(sj6));
IkReal x2168=((cj6)*(r20));
IkReal x2169=((cj6)*(r21));
IkReal x2170=((r20)*(sj6));
IkReal x2171=((IkReal(1.00000000000000))*(cj3)*(sj2));
if( IKabs(((gconst2)*(((((IkReal(-1.00000000000000))*(x2170)*(x2171)))+(((IkReal(-1.00000000000000))*(x2169)*(x2171)))+(((IkReal(-1.00000000000000))*(cj2)*(x2165)))+(((x2166)*(x2168)))+(((IkReal(-1.00000000000000))*(x2166)*(x2167))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst2)*(((((cj2)*(x2170)))+(((IkReal(-1.00000000000000))*(cj5)*(x2167)*(x2171)))+(((cj3)*(cj5)*(sj2)*(x2168)))+(((IkReal(-1.00000000000000))*(x2165)*(x2171)))+(((cj2)*(x2169))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst2)*(((((IkReal(-1.00000000000000))*(x2170)*(x2171)))+(((IkReal(-1.00000000000000))*(x2169)*(x2171)))+(((IkReal(-1.00000000000000))*(cj2)*(x2165)))+(((x2166)*(x2168)))+(((IkReal(-1.00000000000000))*(x2166)*(x2167)))))), ((gconst2)*(((((cj2)*(x2170)))+(((IkReal(-1.00000000000000))*(cj5)*(x2167)*(x2171)))+(((cj3)*(cj5)*(sj2)*(x2168)))+(((IkReal(-1.00000000000000))*(x2165)*(x2171)))+(((cj2)*(x2169)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x2172=IKsin(j4);
IkReal x2173=IKcos(j4);
IkReal x2174=((IkReal(1.00000000000000))*(r00));
IkReal x2175=((cj5)*(r01));
IkReal x2176=((cj5)*(r11));
IkReal x2177=((cj2)*(cj3));
IkReal x2178=((IkReal(1.00000000000000))*(sj2));
IkReal x2179=((IkReal(1.00000000000000))*(cj5));
IkReal x2180=((cj5)*(r21));
IkReal x2181=((sj5)*(x2172));
IkReal x2182=((cj6)*(x2172));
IkReal x2183=((sj6)*(x2173));
IkReal x2184=((sj6)*(x2172));
IkReal x2185=((sj5)*(x2173));
IkReal x2186=((cj6)*(x2173));
evalcond[0]=((((r22)*(x2181)))+(((IkReal(-1.00000000000000))*(r20)*(x2183)))+(((x2180)*(x2184)))+(((IkReal(-1.00000000000000))*(r20)*(x2179)*(x2182)))+(((IkReal(-1.00000000000000))*(r21)*(x2186)))+(((IkReal(-1.00000000000000))*(cj2))));
evalcond[1]=((((r22)*(x2185)))+(((IkReal(-1.00000000000000))*(cj3)*(x2178)))+(((x2180)*(x2183)))+(((r20)*(x2184)))+(((r21)*(x2182)))+(((IkReal(-1.00000000000000))*(r20)*(x2179)*(x2186))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r01)*(x2186)))+(((IkReal(-1.00000000000000))*(cj5)*(x2174)*(x2182)))+(((r02)*(x2181)))+(((x2175)*(x2184)))+(((IkReal(-1.00000000000000))*(cj1)*(x2178)))+(((IkReal(-1.00000000000000))*(x2174)*(x2183))));
evalcond[3]=((((IkReal(-1.00000000000000))*(sj1)*(x2178)))+(((IkReal(-1.00000000000000))*(r10)*(x2179)*(x2182)))+(((IkReal(-1.00000000000000))*(r10)*(x2183)))+(((r12)*(x2181)))+(((x2176)*(x2184)))+(((IkReal(-1.00000000000000))*(r11)*(x2186))));
evalcond[4]=((((sj1)*(sj3)))+(((IkReal(-1.00000000000000))*(cj5)*(x2174)*(x2186)))+(((r02)*(x2185)))+(((x2175)*(x2183)))+(((cj1)*(x2177)))+(((r01)*(x2182)))+(((r00)*(x2184))));
evalcond[5]=((((sj1)*(x2177)))+(((IkReal(-1.00000000000000))*(r10)*(x2179)*(x2186)))+(((IkReal(-1.00000000000000))*(cj1)*(sj3)))+(((r12)*(x2185)))+(((x2176)*(x2183)))+(((r11)*(x2182)))+(((r10)*(x2184))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x2187=((cj2)*(cj6));
IkReal x2188=((cj5)*(sj6));
IkReal x2189=((IkReal(1.00000000000000))*(sj1)*(sj2));
IkReal x2190=((r21)*(x2189));
if( IKabs(((gconst1)*(((((cj2)*(r10)*(sj6)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x2189)))+(((IkReal(-1.00000000000000))*(cj6)*(x2190)))+(((r11)*(x2187))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst1)*(((((IkReal(-1.00000000000000))*(cj5)*(r10)*(x2187)))+(((IkReal(-1.00000000000000))*(x2188)*(x2190)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x2189)))+(((cj5)*(cj6)*(r20)*(sj1)*(sj2)))+(((cj2)*(r11)*(x2188)))+(((cj2)*(r12)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst1)*(((((cj2)*(r10)*(sj6)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x2189)))+(((IkReal(-1.00000000000000))*(cj6)*(x2190)))+(((r11)*(x2187)))))), ((gconst1)*(((((IkReal(-1.00000000000000))*(cj5)*(r10)*(x2187)))+(((IkReal(-1.00000000000000))*(x2188)*(x2190)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x2189)))+(((cj5)*(cj6)*(r20)*(sj1)*(sj2)))+(((cj2)*(r11)*(x2188)))+(((cj2)*(r12)*(sj5)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x2191=IKsin(j4);
IkReal x2192=IKcos(j4);
IkReal x2193=((IkReal(1.00000000000000))*(sj2));
IkReal x2194=((IkReal(1.00000000000000))*(cj6));
IkReal x2195=((sj5)*(x2191));
IkReal x2196=((cj5)*(x2191));
IkReal x2197=((IkReal(1.00000000000000))*(sj6)*(x2192));
evalcond[0]=((((r22)*(x2195)))+(((IkReal(-1.00000000000000))*(r20)*(x2197)))+(((r21)*(sj6)*(x2196)))+(((IkReal(-1.00000000000000))*(r20)*(x2194)*(x2196)))+(((IkReal(-1.00000000000000))*(r21)*(x2192)*(x2194)))+(((IkReal(-1.00000000000000))*(cj2))));
evalcond[1]=((((r01)*(sj6)*(x2196)))+(((IkReal(-1.00000000000000))*(r00)*(x2194)*(x2196)))+(((IkReal(-1.00000000000000))*(r01)*(x2192)*(x2194)))+(((r02)*(x2195)))+(((IkReal(-1.00000000000000))*(cj1)*(x2193)))+(((IkReal(-1.00000000000000))*(r00)*(x2197))));
evalcond[2]=((((r11)*(sj6)*(x2196)))+(((IkReal(-1.00000000000000))*(r10)*(x2197)))+(((IkReal(-1.00000000000000))*(sj1)*(x2193)))+(((IkReal(-1.00000000000000))*(r10)*(x2194)*(x2196)))+(((r12)*(x2195)))+(((IkReal(-1.00000000000000))*(r11)*(x2192)*(x2194))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst4;
gconst4=IKsign(sj2);
dummyeval[0]=sj2;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[2];
IkReal x2198=(sj1)*(sj1);
IkReal x2199=(cj1)*(cj1);
dummyeval[0]=((((cj2)*(x2198)))+(((cj2)*(x2199))));
dummyeval[1]=((x2198)+(x2199));
if( IKabs(dummyeval[0]) < 0.0000010000000000  || IKabs(dummyeval[1]) < 0.0000010000000000  )
{
{
IkReal dummyeval[2];
dummyeval[0]=sj2;
dummyeval[1]=cj1;
if( IKabs(dummyeval[0]) < 0.0000010000000000  || IKabs(dummyeval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[9];
IkReal x2200=((sj4)*(sj5));
IkReal x2201=((cj6)*(r20));
IkReal x2202=((IkReal(1.00000000000000))*(cj4));
IkReal x2203=((IkReal(0.390000000000000))*(sj5));
IkReal x2204=((r21)*(sj6));
IkReal x2205=((IkReal(0.390000000000000))*(cj5));
IkReal x2206=((cj6)*(r00));
IkReal x2207=((IkReal(0.000500000000000000))*(cj6));
IkReal x2208=((r11)*(sj6));
IkReal x2209=((cj5)*(sj4));
IkReal x2210=((r01)*(sj6));
IkReal x2211=((r20)*(sj6));
IkReal x2212=((r10)*(sj6));
IkReal x2213=((cj6)*(r10));
IkReal x2214=((cj6)*(r21));
IkReal x2215=((r00)*(sj6));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(3.14159265358979))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(sj5)*(x2204)))+(((sj5)*(x2201))));
evalcond[2]=((IkReal(-0.00200000000000000))+(((IkReal(-1.00000000000000))*(x2203)*(x2204)))+(((x2201)*(x2203)))+(((IkReal(0.000500000000000000))*(x2211)))+(((IkReal(-1.00000000000000))*(pz)))+(((r22)*(x2205)))+(((r21)*(x2207))));
evalcond[3]=((((r02)*(x2205)))+(((r01)*(x2207)))+(((x2203)*(x2206)))+(((IkReal(0.000500000000000000))*(x2215)))+(((IkReal(-1.00000000000000))*(px)))+(((IkReal(-0.400000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(x2203)*(x2210))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x2203)*(x2208)))+(((r12)*(x2205)))+(((x2203)*(x2213)))+(((IkReal(0.400000000000000))*(cj1)))+(((r11)*(x2207)))+(((IkReal(0.000500000000000000))*(x2212)))+(((IkReal(-1.00000000000000))*(py))));
evalcond[5]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(x2202)*(x2211)))+(((IkReal(-1.00000000000000))*(x2202)*(x2214)))+(((x2204)*(x2209)))+(((IkReal(-1.00000000000000))*(x2201)*(x2209)))+(((r22)*(x2200))));
evalcond[6]=((((cj4)*(r22)*(sj5)))+(((sj4)*(x2211)))+(((sj4)*(x2214)))+(((cj4)*(cj5)*(x2204)))+(((IkReal(-1.00000000000000))*(cj5)*(x2201)*(x2202))));
evalcond[7]=((((r02)*(x2200)))+(((IkReal(-1.00000000000000))*(x2206)*(x2209)))+(((IkReal(-1.00000000000000))*(x2202)*(x2215)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x2202)))+(((x2209)*(x2210))));
evalcond[8]=((((r12)*(x2200)))+(((IkReal(-1.00000000000000))*(x2202)*(x2212)))+(((IkReal(-1.00000000000000))*(x2209)*(x2213)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x2202)))+(((x2208)*(x2209))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst5;
gconst5=IKsign((((sj1)*(sj1))+((cj1)*(cj1))));
dummyeval[0]=(((sj1)*(sj1))+((cj1)*(cj1)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst6;
gconst6=IKsign((((sj1)*(sj1))+((cj1)*(cj1))));
dummyeval[0]=(((sj1)*(sj1))+((cj1)*(cj1)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2216=((IkReal(1.00000000000000))*(sj4));
IkReal x2217=((r00)*(sj6));
IkReal x2218=((cj1)*(cj6));
IkReal x2219=((cj4)*(sj5));
IkReal x2220=((cj4)*(cj5));
IkReal x2221=((r01)*(sj1));
IkReal x2222=((IkReal(1.00000000000000))*(sj6));
IkReal x2223=((cj1)*(r02));
IkReal x2224=((cj1)*(r01));
IkReal x2225=((IkReal(1.00000000000000))*(r02)*(sj1));
IkReal x2226=((cj6)*(r00)*(sj1));
if( IKabs(((gconst6)*(((((IkReal(-1.00000000000000))*(x2219)*(x2225)))+(((r00)*(sj5)*(x2218)))+(((cj5)*(x2223)))+(((IkReal(-1.00000000000000))*(x2220)*(x2221)*(x2222)))+(((IkReal(-1.00000000000000))*(sj1)*(x2216)*(x2217)))+(((IkReal(-1.00000000000000))*(sj5)*(x2222)*(x2224)))+(((IkReal(-1.00000000000000))*(cj6)*(x2216)*(x2221)))+(((x2220)*(x2226))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst6)*(((((IkReal(-1.00000000000000))*(x2219)*(x2223)))+(((IkReal(-1.00000000000000))*(r01)*(x2216)*(x2218)))+(((r00)*(x2218)*(x2220)))+(((IkReal(-1.00000000000000))*(cj5)*(x2225)))+(((IkReal(-1.00000000000000))*(sj5)*(x2226)))+(((IkReal(-1.00000000000000))*(cj1)*(x2216)*(x2217)))+(((IkReal(-1.00000000000000))*(x2220)*(x2222)*(x2224)))+(((sj5)*(sj6)*(x2221))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst6)*(((((IkReal(-1.00000000000000))*(x2219)*(x2225)))+(((r00)*(sj5)*(x2218)))+(((cj5)*(x2223)))+(((IkReal(-1.00000000000000))*(x2220)*(x2221)*(x2222)))+(((IkReal(-1.00000000000000))*(sj1)*(x2216)*(x2217)))+(((IkReal(-1.00000000000000))*(sj5)*(x2222)*(x2224)))+(((IkReal(-1.00000000000000))*(cj6)*(x2216)*(x2221)))+(((x2220)*(x2226)))))), ((gconst6)*(((((IkReal(-1.00000000000000))*(x2219)*(x2223)))+(((IkReal(-1.00000000000000))*(r01)*(x2216)*(x2218)))+(((r00)*(x2218)*(x2220)))+(((IkReal(-1.00000000000000))*(cj5)*(x2225)))+(((IkReal(-1.00000000000000))*(sj5)*(x2226)))+(((IkReal(-1.00000000000000))*(cj1)*(x2216)*(x2217)))+(((IkReal(-1.00000000000000))*(x2220)*(x2222)*(x2224)))+(((sj5)*(sj6)*(x2221)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x2227=IKcos(j3);
IkReal x2228=IKsin(j3);
IkReal x2229=((r11)*(sj6));
IkReal x2230=((IkReal(1.00000000000000))*(sj5));
IkReal x2231=((sj4)*(sj6));
IkReal x2232=((cj4)*(sj5));
IkReal x2233=((cj6)*(sj4));
IkReal x2234=((cj4)*(cj5));
IkReal x2235=((r01)*(sj6));
IkReal x2236=((cj6)*(sj5));
IkReal x2237=((sj1)*(x2227));
IkReal x2238=((cj1)*(x2227));
IkReal x2239=((IkReal(1.00000000000000))*(x2228));
IkReal x2240=((cj1)*(x2239));
IkReal x2241=((IkReal(1.00000000000000))*(cj6)*(x2234));
evalcond[0]=((x2237)+(((IkReal(-1.00000000000000))*(x2240)))+(((IkReal(-1.00000000000000))*(x2230)*(x2235)))+(((r00)*(x2236)))+(((cj5)*(r02))));
evalcond[1]=((((cj5)*(r12)))+(((r10)*(x2236)))+(((IkReal(-1.00000000000000))*(x2229)*(x2230)))+(((IkReal(-1.00000000000000))*(sj1)*(x2239)))+(((IkReal(-1.00000000000000))*(x2238))));
evalcond[2]=((x2238)+(((sj1)*(x2228)))+(((r02)*(x2232)))+(((IkReal(-1.00000000000000))*(r00)*(x2241)))+(((r01)*(x2233)))+(((r00)*(x2231)))+(((x2234)*(x2235))));
evalcond[3]=((x2237)+(((x2229)*(x2234)))+(((IkReal(-1.00000000000000))*(r10)*(x2241)))+(((r10)*(x2231)))+(((IkReal(-1.00000000000000))*(x2240)))+(((r11)*(x2233)))+(((r12)*(x2232))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2242=((cj5)*(r12));
IkReal x2243=((cj6)*(sj5));
IkReal x2244=((IkReal(1.00000000000000))*(sj1));
IkReal x2245=((cj5)*(r02));
IkReal x2246=((IkReal(1.00000000000000))*(cj1));
IkReal x2247=((r01)*(sj5)*(sj6));
IkReal x2248=((r11)*(sj5)*(sj6));
if( IKabs(((gconst5)*(((((cj1)*(x2245)))+(((r10)*(sj1)*(x2243)))+(((IkReal(-1.00000000000000))*(x2244)*(x2248)))+(((cj1)*(r00)*(x2243)))+(((sj1)*(x2242)))+(((IkReal(-1.00000000000000))*(x2246)*(x2247))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst5)*(((((cj1)*(x2242)))+(((IkReal(-1.00000000000000))*(r00)*(x2243)*(x2244)))+(((cj1)*(r10)*(x2243)))+(((IkReal(-1.00000000000000))*(x2244)*(x2245)))+(((sj1)*(x2247)))+(((IkReal(-1.00000000000000))*(x2246)*(x2248))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst5)*(((((cj1)*(x2245)))+(((r10)*(sj1)*(x2243)))+(((IkReal(-1.00000000000000))*(x2244)*(x2248)))+(((cj1)*(r00)*(x2243)))+(((sj1)*(x2242)))+(((IkReal(-1.00000000000000))*(x2246)*(x2247)))))), ((gconst5)*(((((cj1)*(x2242)))+(((IkReal(-1.00000000000000))*(r00)*(x2243)*(x2244)))+(((cj1)*(r10)*(x2243)))+(((IkReal(-1.00000000000000))*(x2244)*(x2245)))+(((sj1)*(x2247)))+(((IkReal(-1.00000000000000))*(x2246)*(x2248)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x2249=IKcos(j3);
IkReal x2250=IKsin(j3);
IkReal x2251=((r11)*(sj6));
IkReal x2252=((IkReal(1.00000000000000))*(sj5));
IkReal x2253=((sj4)*(sj6));
IkReal x2254=((cj4)*(sj5));
IkReal x2255=((cj6)*(sj4));
IkReal x2256=((cj4)*(cj5));
IkReal x2257=((r01)*(sj6));
IkReal x2258=((cj6)*(sj5));
IkReal x2259=((sj1)*(x2249));
IkReal x2260=((cj1)*(x2249));
IkReal x2261=((IkReal(1.00000000000000))*(x2250));
IkReal x2262=((cj1)*(x2261));
IkReal x2263=((IkReal(1.00000000000000))*(cj6)*(x2256));
evalcond[0]=((x2259)+(((IkReal(-1.00000000000000))*(x2252)*(x2257)))+(((r00)*(x2258)))+(((IkReal(-1.00000000000000))*(x2262)))+(((cj5)*(r02))));
evalcond[1]=((((cj5)*(r12)))+(((r10)*(x2258)))+(((IkReal(-1.00000000000000))*(sj1)*(x2261)))+(((IkReal(-1.00000000000000))*(x2251)*(x2252)))+(((IkReal(-1.00000000000000))*(x2260))));
evalcond[2]=((x2260)+(((IkReal(-1.00000000000000))*(r00)*(x2263)))+(((x2256)*(x2257)))+(((sj1)*(x2250)))+(((r00)*(x2253)))+(((r01)*(x2255)))+(((r02)*(x2254))));
evalcond[3]=((((r10)*(x2253)))+(x2259)+(((r12)*(x2254)))+(((IkReal(-1.00000000000000))*(r10)*(x2263)))+(((x2251)*(x2256)))+(((IkReal(-1.00000000000000))*(x2262)))+(((r11)*(x2255))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
IkReal x2264=((sj4)*(sj5));
IkReal x2265=((cj6)*(r20));
IkReal x2266=((IkReal(1.00000000000000))*(cj4));
IkReal x2267=((IkReal(0.390000000000000))*(sj5));
IkReal x2268=((r21)*(sj6));
IkReal x2269=((IkReal(0.390000000000000))*(cj5));
IkReal x2270=((cj6)*(r00));
IkReal x2271=((IkReal(0.000500000000000000))*(cj6));
IkReal x2272=((r11)*(sj6));
IkReal x2273=((cj5)*(sj4));
IkReal x2274=((r01)*(sj6));
IkReal x2275=((r20)*(sj6));
IkReal x2276=((r10)*(sj6));
IkReal x2277=((cj6)*(r10));
IkReal x2278=((cj6)*(r21));
IkReal x2279=((r00)*(sj6));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.11022302462516e-16))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(sj5)*(x2268)))+(((sj5)*(x2265))));
evalcond[2]=((IkReal(0.00200000000000000))+(((r21)*(x2271)))+(((r22)*(x2269)))+(((IkReal(-1.00000000000000))*(pz)))+(((x2265)*(x2267)))+(((IkReal(-1.00000000000000))*(x2267)*(x2268)))+(((IkReal(0.000500000000000000))*(x2275))));
evalcond[3]=((((r01)*(x2271)))+(((IkReal(-1.00000000000000))*(px)))+(((r02)*(x2269)))+(((x2267)*(x2270)))+(((IkReal(-1.00000000000000))*(x2267)*(x2274)))+(((IkReal(-0.400000000000000))*(sj1)))+(((IkReal(0.000500000000000000))*(x2279))));
evalcond[4]=((((IkReal(0.400000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(py)))+(((r11)*(x2271)))+(((r12)*(x2269)))+(((x2267)*(x2277)))+(((IkReal(-1.00000000000000))*(x2267)*(x2272)))+(((IkReal(0.000500000000000000))*(x2276))));
evalcond[5]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x2266)*(x2275)))+(((IkReal(-1.00000000000000))*(x2266)*(x2278)))+(((r22)*(x2264)))+(((x2268)*(x2273)))+(((IkReal(-1.00000000000000))*(x2265)*(x2273))));
evalcond[6]=((((cj4)*(cj5)*(x2268)))+(((sj4)*(x2275)))+(((sj4)*(x2278)))+(((cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(x2265)*(x2266))));
evalcond[7]=((((IkReal(-1.00000000000000))*(x2270)*(x2273)))+(((IkReal(-1.00000000000000))*(x2266)*(x2279)))+(((x2273)*(x2274)))+(((r02)*(x2264)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x2266))));
evalcond[8]=((((IkReal(-1.00000000000000))*(x2266)*(x2276)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x2266)))+(((IkReal(-1.00000000000000))*(x2273)*(x2277)))+(((x2272)*(x2273)))+(((r12)*(x2264))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst7;
gconst7=IKsign(((((IkReal(-1.00000000000000))*((sj1)*(sj1))))+(((IkReal(-1.00000000000000))*((cj1)*(cj1))))));
dummyeval[0]=((((IkReal(-1.00000000000000))*((sj1)*(sj1))))+(((IkReal(-1.00000000000000))*((cj1)*(cj1)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst8;
gconst8=IKsign(((((IkReal(-1.00000000000000))*((sj1)*(sj1))))+(((IkReal(-1.00000000000000))*((cj1)*(cj1))))));
dummyeval[0]=((((IkReal(-1.00000000000000))*((sj1)*(sj1))))+(((IkReal(-1.00000000000000))*((cj1)*(cj1)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2280=((sj1)*(sj6));
IkReal x2281=((r00)*(sj4));
IkReal x2282=((IkReal(1.00000000000000))*(r01));
IkReal x2283=((cj1)*(cj6));
IkReal x2284=((cj1)*(sj6));
IkReal x2285=((cj4)*(cj5));
IkReal x2286=((r02)*(sj1));
IkReal x2287=((cj4)*(sj5));
IkReal x2288=((cj1)*(r02));
IkReal x2289=((cj6)*(r00)*(sj1));
if( IKabs(((gconst8)*(((((IkReal(-1.00000000000000))*(x2285)*(x2289)))+(((r01)*(x2280)*(x2285)))+(((r00)*(sj5)*(x2283)))+(((IkReal(-1.00000000000000))*(sj5)*(x2282)*(x2284)))+(((x2280)*(x2281)))+(((cj6)*(r01)*(sj1)*(sj4)))+(((cj5)*(x2288)))+(((x2286)*(x2287))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst8)*(((((IkReal(-1.00000000000000))*(sj4)*(x2282)*(x2283)))+(((sj5)*(x2289)))+(((IkReal(-1.00000000000000))*(x2282)*(x2284)*(x2285)))+(((IkReal(-1.00000000000000))*(x2287)*(x2288)))+(((r00)*(x2283)*(x2285)))+(((cj5)*(x2286)))+(((IkReal(-1.00000000000000))*(sj5)*(x2280)*(x2282)))+(((IkReal(-1.00000000000000))*(x2281)*(x2284))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst8)*(((((IkReal(-1.00000000000000))*(x2285)*(x2289)))+(((r01)*(x2280)*(x2285)))+(((r00)*(sj5)*(x2283)))+(((IkReal(-1.00000000000000))*(sj5)*(x2282)*(x2284)))+(((x2280)*(x2281)))+(((cj6)*(r01)*(sj1)*(sj4)))+(((cj5)*(x2288)))+(((x2286)*(x2287)))))), ((gconst8)*(((((IkReal(-1.00000000000000))*(sj4)*(x2282)*(x2283)))+(((sj5)*(x2289)))+(((IkReal(-1.00000000000000))*(x2282)*(x2284)*(x2285)))+(((IkReal(-1.00000000000000))*(x2287)*(x2288)))+(((r00)*(x2283)*(x2285)))+(((cj5)*(x2286)))+(((IkReal(-1.00000000000000))*(sj5)*(x2280)*(x2282)))+(((IkReal(-1.00000000000000))*(x2281)*(x2284)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x2290=IKsin(j3);
IkReal x2291=IKcos(j3);
IkReal x2292=((r11)*(sj6));
IkReal x2293=((IkReal(1.00000000000000))*(sj5));
IkReal x2294=((sj4)*(sj6));
IkReal x2295=((cj4)*(sj5));
IkReal x2296=((cj6)*(sj4));
IkReal x2297=((cj4)*(cj5));
IkReal x2298=((r01)*(sj6));
IkReal x2299=((cj6)*(sj5));
IkReal x2300=((sj1)*(x2290));
IkReal x2301=((cj1)*(x2290));
IkReal x2302=((IkReal(1.00000000000000))*(x2291));
IkReal x2303=((cj1)*(x2302));
IkReal x2304=((IkReal(1.00000000000000))*(cj6)*(x2297));
evalcond[0]=((((sj1)*(x2291)))+(x2301)+(((IkReal(-1.00000000000000))*(x2293)*(x2298)))+(((r00)*(x2299)))+(((cj5)*(r02))));
evalcond[1]=((((cj5)*(r12)))+(((r10)*(x2299)))+(x2300)+(((IkReal(-1.00000000000000))*(x2292)*(x2293)))+(((IkReal(-1.00000000000000))*(x2303))));
evalcond[2]=((x2300)+(((IkReal(-1.00000000000000))*(r00)*(x2304)))+(((IkReal(-1.00000000000000))*(x2303)))+(((r02)*(x2295)))+(((r00)*(x2294)))+(((r01)*(x2296)))+(((x2297)*(x2298))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r10)*(x2304)))+(((IkReal(-1.00000000000000))*(x2301)))+(((IkReal(-1.00000000000000))*(sj1)*(x2302)))+(((r10)*(x2294)))+(((x2292)*(x2297)))+(((r12)*(x2295)))+(((r11)*(x2296))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2305=((sj1)*(sj5));
IkReal x2306=((cj6)*(r10));
IkReal x2307=((cj5)*(sj1));
IkReal x2308=((cj1)*(cj5));
IkReal x2309=((cj1)*(sj5));
IkReal x2310=((cj6)*(r00));
IkReal x2311=((r11)*(sj6));
IkReal x2312=((IkReal(1.00000000000000))*(r01)*(sj6));
if( IKabs(((gconst7)*(((((IkReal(-1.00000000000000))*(x2305)*(x2311)))+(((r12)*(x2307)))+(((x2305)*(x2306)))+(((IkReal(-1.00000000000000))*(x2309)*(x2312)))+(((x2309)*(x2310)))+(((r02)*(x2308))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst7)*(((((IkReal(-1.00000000000000))*(r12)*(x2308)))+(((x2305)*(x2310)))+(((x2309)*(x2311)))+(((r02)*(x2307)))+(((IkReal(-1.00000000000000))*(x2305)*(x2312)))+(((IkReal(-1.00000000000000))*(x2306)*(x2309))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst7)*(((((IkReal(-1.00000000000000))*(x2305)*(x2311)))+(((r12)*(x2307)))+(((x2305)*(x2306)))+(((IkReal(-1.00000000000000))*(x2309)*(x2312)))+(((x2309)*(x2310)))+(((r02)*(x2308)))))), ((gconst7)*(((((IkReal(-1.00000000000000))*(r12)*(x2308)))+(((x2305)*(x2310)))+(((x2309)*(x2311)))+(((r02)*(x2307)))+(((IkReal(-1.00000000000000))*(x2305)*(x2312)))+(((IkReal(-1.00000000000000))*(x2306)*(x2309)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x2313=IKsin(j3);
IkReal x2314=IKcos(j3);
IkReal x2315=((r11)*(sj6));
IkReal x2316=((IkReal(1.00000000000000))*(sj5));
IkReal x2317=((sj4)*(sj6));
IkReal x2318=((cj4)*(sj5));
IkReal x2319=((cj6)*(sj4));
IkReal x2320=((cj4)*(cj5));
IkReal x2321=((r01)*(sj6));
IkReal x2322=((cj6)*(sj5));
IkReal x2323=((sj1)*(x2313));
IkReal x2324=((cj1)*(x2313));
IkReal x2325=((IkReal(1.00000000000000))*(x2314));
IkReal x2326=((cj1)*(x2325));
IkReal x2327=((IkReal(1.00000000000000))*(cj6)*(x2320));
evalcond[0]=((x2324)+(((sj1)*(x2314)))+(((r00)*(x2322)))+(((IkReal(-1.00000000000000))*(x2316)*(x2321)))+(((cj5)*(r02))));
evalcond[1]=((((r10)*(x2322)))+(((cj5)*(r12)))+(x2323)+(((IkReal(-1.00000000000000))*(x2315)*(x2316)))+(((IkReal(-1.00000000000000))*(x2326))));
evalcond[2]=((x2323)+(((r01)*(x2319)))+(((x2320)*(x2321)))+(((r00)*(x2317)))+(((IkReal(-1.00000000000000))*(r00)*(x2327)))+(((r02)*(x2318)))+(((IkReal(-1.00000000000000))*(x2326))));
evalcond[3]=((((x2315)*(x2320)))+(((r10)*(x2317)))+(((r11)*(x2319)))+(((r12)*(x2318)))+(((IkReal(-1.00000000000000))*(r10)*(x2327)))+(((IkReal(-1.00000000000000))*(sj1)*(x2325)))+(((IkReal(-1.00000000000000))*(x2324))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
IkReal x2328=((sj4)*(sj5));
IkReal x2329=((IkReal(0.390000000000000))*(sj5));
IkReal x2330=((r21)*(sj6));
IkReal x2331=((IkReal(0.390000000000000))*(cj5));
IkReal x2332=((cj6)*(r00));
IkReal x2333=((IkReal(0.000500000000000000))*(cj6));
IkReal x2334=((r11)*(sj6));
IkReal x2335=((cj5)*(sj4));
IkReal x2336=((IkReal(1.00000000000000))*(r20));
IkReal x2337=((cj4)*(sj6));
IkReal x2338=((r01)*(sj6));
IkReal x2339=((IkReal(0.000500000000000000))*(sj6));
IkReal x2340=((IkReal(1.00000000000000))*(r10));
IkReal x2341=((IkReal(1.00000000000000))*(cj4)*(cj6));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((((r21)*(x2333)))+(((cj6)*(r20)*(x2329)))+(((r22)*(x2331)))+(((IkReal(-1.00000000000000))*(pz)))+(((IkReal(-1.00000000000000))*(x2329)*(x2330)))+(((IkReal(-0.00200000000000000))*(cj2)))+(((r20)*(x2339))));
evalcond[2]=((IkReal(-0.400000000000000))+(((r02)*(x2331)))+(((x2329)*(x2332)))+(((r01)*(x2333)))+(((IkReal(-1.00000000000000))*(px)))+(((r00)*(x2339)))+(((IkReal(-1.00000000000000))*(x2329)*(x2338))));
evalcond[3]=((((r12)*(x2331)))+(((r11)*(x2333)))+(((IkReal(-1.00000000000000))*(py)))+(((IkReal(-0.00200000000000000))*(sj2)))+(((IkReal(-1.00000000000000))*(x2329)*(x2334)))+(((cj6)*(r10)*(x2329)))+(((r10)*(x2339))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r21)*(x2341)))+(((r22)*(x2328)))+(((IkReal(-1.00000000000000))*(cj6)*(x2335)*(x2336)))+(((IkReal(-1.00000000000000))*(x2336)*(x2337)))+(((x2330)*(x2335)))+(((IkReal(-1.00000000000000))*(cj2))));
evalcond[5]=((((r02)*(x2328)))+(((IkReal(-1.00000000000000))*(r01)*(x2341)))+(((IkReal(-1.00000000000000))*(x2332)*(x2335)))+(((x2335)*(x2338)))+(((IkReal(-1.00000000000000))*(r00)*(x2337))));
evalcond[6]=((((IkReal(-1.00000000000000))*(x2337)*(x2340)))+(((IkReal(-1.00000000000000))*(sj2)))+(((IkReal(-1.00000000000000))*(cj6)*(x2335)*(x2340)))+(((x2334)*(x2335)))+(((r12)*(x2328)))+(((IkReal(-1.00000000000000))*(r11)*(x2341))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2342=((IkReal(1.00000000000000))*(cj6));
IkReal x2343=((IkReal(1.00000000000000))*(cj5));
IkReal x2344=((r01)*(sj6));
if( IKabs(((((IkReal(-1.00000000000000))*(cj4)*(r02)*(sj5)))+(((IkReal(-1.00000000000000))*(cj4)*(x2343)*(x2344)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(sj6)))+(((cj4)*(cj5)*(cj6)*(r00)))+(((IkReal(-1.00000000000000))*(r01)*(sj4)*(x2342))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r00)*(sj5)*(x2342)))+(((IkReal(-1.00000000000000))*(r02)*(x2343)))+(((sj5)*(x2344))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(cj4)*(r02)*(sj5)))+(((IkReal(-1.00000000000000))*(cj4)*(x2343)*(x2344)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(sj6)))+(((cj4)*(cj5)*(cj6)*(r00)))+(((IkReal(-1.00000000000000))*(r01)*(sj4)*(x2342)))))+IKsqr(((((IkReal(-1.00000000000000))*(r00)*(sj5)*(x2342)))+(((IkReal(-1.00000000000000))*(r02)*(x2343)))+(((sj5)*(x2344)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(cj4)*(r02)*(sj5)))+(((IkReal(-1.00000000000000))*(cj4)*(x2343)*(x2344)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(sj6)))+(((cj4)*(cj5)*(cj6)*(r00)))+(((IkReal(-1.00000000000000))*(r01)*(sj4)*(x2342)))), ((((IkReal(-1.00000000000000))*(r00)*(sj5)*(x2342)))+(((IkReal(-1.00000000000000))*(r02)*(x2343)))+(((sj5)*(x2344)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x2345=IKsin(j3);
IkReal x2346=IKcos(j3);
IkReal x2347=((r11)*(sj6));
IkReal x2348=((IkReal(1.00000000000000))*(sj5));
IkReal x2349=((sj4)*(sj6));
IkReal x2350=((cj4)*(sj5));
IkReal x2351=((cj6)*(sj4));
IkReal x2352=((cj4)*(cj5));
IkReal x2353=((r01)*(sj6));
IkReal x2354=((r21)*(sj6));
IkReal x2355=((cj6)*(sj5));
IkReal x2356=((IkReal(1.00000000000000))*(cj6)*(x2352));
evalcond[0]=((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(x2348)*(x2354)))+(((r20)*(x2355)))+(((sj2)*(x2345))));
evalcond[1]=((((r00)*(x2355)))+(x2346)+(((IkReal(-1.00000000000000))*(x2348)*(x2353)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((r10)*(x2355)))+(((IkReal(-1.00000000000000))*(cj2)*(x2345)))+(((IkReal(-1.00000000000000))*(x2347)*(x2348))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r20)*(x2356)))+(((r22)*(x2350)))+(((x2352)*(x2354)))+(((IkReal(-1.00000000000000))*(sj2)*(x2346)))+(((r20)*(x2349)))+(((r21)*(x2351))));
evalcond[4]=((((r01)*(x2351)))+(x2345)+(((IkReal(-1.00000000000000))*(r00)*(x2356)))+(((r00)*(x2349)))+(((x2352)*(x2353)))+(((r02)*(x2350))));
evalcond[5]=((((r10)*(x2349)))+(((r12)*(x2350)))+(((cj2)*(x2346)))+(((r11)*(x2351)))+(((IkReal(-1.00000000000000))*(r10)*(x2356)))+(((x2347)*(x2352))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x2357=((sj4)*(sj5));
IkReal x2358=((IkReal(0.390000000000000))*(sj5));
IkReal x2359=((r21)*(sj6));
IkReal x2360=((IkReal(0.390000000000000))*(cj5));
IkReal x2361=((cj6)*(r00));
IkReal x2362=((IkReal(0.000500000000000000))*(cj6));
IkReal x2363=((r11)*(sj6));
IkReal x2364=((cj5)*(sj4));
IkReal x2365=((IkReal(1.00000000000000))*(r20));
IkReal x2366=((cj4)*(sj6));
IkReal x2367=((r01)*(sj6));
IkReal x2368=((IkReal(0.000500000000000000))*(sj6));
IkReal x2369=((IkReal(1.00000000000000))*(r10));
IkReal x2370=((IkReal(1.00000000000000))*(cj4)*(cj6));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((((r20)*(x2368)))+(((IkReal(-1.00000000000000))*(x2358)*(x2359)))+(((IkReal(-1.00000000000000))*(pz)))+(((r22)*(x2360)))+(((cj6)*(r20)*(x2358)))+(((IkReal(-0.00200000000000000))*(cj2)))+(((r21)*(x2362))));
evalcond[2]=((IkReal(0.400000000000000))+(((r02)*(x2360)))+(((x2358)*(x2361)))+(((IkReal(-1.00000000000000))*(x2358)*(x2367)))+(((IkReal(-1.00000000000000))*(px)))+(((r01)*(x2362)))+(((r00)*(x2368))));
evalcond[3]=((((r11)*(x2362)))+(((r12)*(x2360)))+(((cj6)*(r10)*(x2358)))+(((r10)*(x2368)))+(((IkReal(0.00200000000000000))*(sj2)))+(((IkReal(-1.00000000000000))*(x2358)*(x2363)))+(((IkReal(-1.00000000000000))*(py))));
evalcond[4]=((((r22)*(x2357)))+(((IkReal(-1.00000000000000))*(cj6)*(x2364)*(x2365)))+(((IkReal(-1.00000000000000))*(r21)*(x2370)))+(((x2359)*(x2364)))+(((IkReal(-1.00000000000000))*(x2365)*(x2366)))+(((IkReal(-1.00000000000000))*(cj2))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r00)*(x2366)))+(((x2364)*(x2367)))+(((IkReal(-1.00000000000000))*(x2361)*(x2364)))+(((IkReal(-1.00000000000000))*(r01)*(x2370)))+(((r02)*(x2357))));
evalcond[6]=((sj2)+(((IkReal(-1.00000000000000))*(cj6)*(x2364)*(x2369)))+(((r12)*(x2357)))+(((IkReal(-1.00000000000000))*(x2366)*(x2369)))+(((x2363)*(x2364)))+(((IkReal(-1.00000000000000))*(r11)*(x2370))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2371=((cj4)*(cj5));
IkReal x2372=((r01)*(sj6));
IkReal x2373=((cj6)*(r00));
if( IKabs(((((r00)*(sj4)*(sj6)))+(((x2371)*(x2372)))+(((cj6)*(r01)*(sj4)))+(((cj4)*(r02)*(sj5)))+(((IkReal(-1.00000000000000))*(x2371)*(x2373))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((sj5)*(x2373)))+(((IkReal(-1.00000000000000))*(sj5)*(x2372)))+(((cj5)*(r02))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((r00)*(sj4)*(sj6)))+(((x2371)*(x2372)))+(((cj6)*(r01)*(sj4)))+(((cj4)*(r02)*(sj5)))+(((IkReal(-1.00000000000000))*(x2371)*(x2373)))))+IKsqr(((((sj5)*(x2373)))+(((IkReal(-1.00000000000000))*(sj5)*(x2372)))+(((cj5)*(r02)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((r00)*(sj4)*(sj6)))+(((x2371)*(x2372)))+(((cj6)*(r01)*(sj4)))+(((cj4)*(r02)*(sj5)))+(((IkReal(-1.00000000000000))*(x2371)*(x2373)))), ((((sj5)*(x2373)))+(((IkReal(-1.00000000000000))*(sj5)*(x2372)))+(((cj5)*(r02)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x2374=IKsin(j3);
IkReal x2375=IKcos(j3);
IkReal x2376=((r11)*(sj6));
IkReal x2377=((IkReal(1.00000000000000))*(sj5));
IkReal x2378=((cj6)*(sj4));
IkReal x2379=((sj4)*(sj6));
IkReal x2380=((cj4)*(sj5));
IkReal x2381=((cj4)*(cj5));
IkReal x2382=((r01)*(sj6));
IkReal x2383=((r21)*(sj6));
IkReal x2384=((cj6)*(sj5));
IkReal x2385=((IkReal(1.00000000000000))*(x2375));
IkReal x2386=((IkReal(1.00000000000000))*(cj6)*(x2381));
evalcond[0]=((((cj5)*(r22)))+(((r20)*(x2384)))+(((sj2)*(x2374)))+(((IkReal(-1.00000000000000))*(x2377)*(x2383))));
evalcond[1]=((((r00)*(x2384)))+(((IkReal(-1.00000000000000))*(x2385)))+(((IkReal(-1.00000000000000))*(x2377)*(x2382)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x2376)*(x2377)))+(((r10)*(x2384)))+(((cj2)*(x2374))));
evalcond[3]=((((r20)*(x2379)))+(((x2381)*(x2383)))+(((IkReal(-1.00000000000000))*(sj2)*(x2385)))+(((IkReal(-1.00000000000000))*(r20)*(x2386)))+(((r22)*(x2380)))+(((r21)*(x2378))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r00)*(x2386)))+(((x2381)*(x2382)))+(((IkReal(-1.00000000000000))*(x2374)))+(((r02)*(x2380)))+(((r00)*(x2379)))+(((r01)*(x2378))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(x2386)))+(((x2376)*(x2381)))+(((r10)*(x2379)))+(((IkReal(-1.00000000000000))*(cj2)*(x2385)))+(((r12)*(x2380)))+(((r11)*(x2378))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x2387=((sj4)*(sj5));
IkReal x2388=((IkReal(0.390000000000000))*(sj5));
IkReal x2389=((r21)*(sj6));
IkReal x2390=((IkReal(0.390000000000000))*(cj5));
IkReal x2391=((cj6)*(r00));
IkReal x2392=((IkReal(0.000500000000000000))*(cj6));
IkReal x2393=((r11)*(sj6));
IkReal x2394=((cj5)*(sj4));
IkReal x2395=((r01)*(sj6));
IkReal x2396=((IkReal(1.00000000000000))*(r20));
IkReal x2397=((cj4)*(sj6));
IkReal x2398=((IkReal(0.000500000000000000))*(sj6));
IkReal x2399=((IkReal(1.00000000000000))*(r10));
IkReal x2400=((IkReal(1.00000000000000))*(cj4)*(cj6));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((r20)*(x2398)))+(((IkReal(-1.00000000000000))*(pz)))+(((r22)*(x2390)))+(((IkReal(-1.00000000000000))*(x2388)*(x2389)))+(((cj6)*(r20)*(x2388)))+(((r21)*(x2392))));
evalcond[2]=((((r00)*(x2398)))+(((r01)*(x2392)))+(((r02)*(x2390)))+(((IkReal(-1.00000000000000))*(px)))+(((IkReal(-1.00000000000000))*(x2388)*(x2395)))+(((x2388)*(x2391)))+(((IkReal(-0.00200000000000000))*(cj1)))+(((IkReal(-0.400000000000000))*(sj1))));
evalcond[3]=((((r12)*(x2390)))+(((cj6)*(r10)*(x2388)))+(((IkReal(0.400000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(py)))+(((IkReal(-0.00200000000000000))*(sj1)))+(((r10)*(x2398)))+(((IkReal(-1.00000000000000))*(x2388)*(x2393)))+(((r11)*(x2392))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x2396)*(x2397)))+(((IkReal(-1.00000000000000))*(cj6)*(x2394)*(x2396)))+(((r22)*(x2387)))+(((IkReal(-1.00000000000000))*(r21)*(x2400)))+(((x2389)*(x2394))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x2391)*(x2394)))+(((IkReal(-1.00000000000000))*(r01)*(x2400)))+(((r02)*(x2387)))+(((IkReal(-1.00000000000000))*(r00)*(x2397)))+(((x2394)*(x2395)))+(((IkReal(-1.00000000000000))*(cj1))));
evalcond[6]=((((IkReal(-1.00000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(cj6)*(x2394)*(x2399)))+(((x2393)*(x2394)))+(((IkReal(-1.00000000000000))*(x2397)*(x2399)))+(((IkReal(-1.00000000000000))*(r11)*(x2400)))+(((r12)*(x2387))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2401=((cj4)*(cj5));
IkReal x2402=((r21)*(sj6));
IkReal x2403=((IkReal(1.00000000000000))*(cj6)*(r20));
if( IKabs(((((sj5)*(x2402)))+(((IkReal(-1.00000000000000))*(sj5)*(x2403)))+(((IkReal(-1.00000000000000))*(cj5)*(r22))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(x2401)*(x2403)))+(((cj4)*(r22)*(sj5)))+(((x2401)*(x2402)))+(((cj6)*(r21)*(sj4)))+(((r20)*(sj4)*(sj6))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((sj5)*(x2402)))+(((IkReal(-1.00000000000000))*(sj5)*(x2403)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))))+IKsqr(((((IkReal(-1.00000000000000))*(x2401)*(x2403)))+(((cj4)*(r22)*(sj5)))+(((x2401)*(x2402)))+(((cj6)*(r21)*(sj4)))+(((r20)*(sj4)*(sj6)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((sj5)*(x2402)))+(((IkReal(-1.00000000000000))*(sj5)*(x2403)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))), ((((IkReal(-1.00000000000000))*(x2401)*(x2403)))+(((cj4)*(r22)*(sj5)))+(((x2401)*(x2402)))+(((cj6)*(r21)*(sj4)))+(((r20)*(sj4)*(sj6)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x2404=IKcos(j3);
IkReal x2405=IKsin(j3);
IkReal x2406=((r11)*(sj6));
IkReal x2407=((IkReal(1.00000000000000))*(sj5));
IkReal x2408=((IkReal(1.00000000000000))*(cj1));
IkReal x2409=((cj6)*(sj4));
IkReal x2410=((sj4)*(sj6));
IkReal x2411=((cj4)*(sj5));
IkReal x2412=((cj4)*(cj5));
IkReal x2413=((r01)*(sj6));
IkReal x2414=((r21)*(sj6));
IkReal x2415=((cj6)*(sj5));
IkReal x2416=((IkReal(1.00000000000000))*(cj6)*(x2412));
evalcond[0]=((((cj5)*(r22)))+(x2405)+(((IkReal(-1.00000000000000))*(x2407)*(x2414)))+(((r20)*(x2415))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x2407)*(x2413)))+(((r00)*(x2415)))+(((sj1)*(x2404)))+(((cj5)*(r02))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x2404)*(x2408)))+(((cj5)*(r12)))+(((r10)*(x2415)))+(((IkReal(-1.00000000000000))*(x2406)*(x2407))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r20)*(x2416)))+(((r22)*(x2411)))+(((IkReal(-1.00000000000000))*(x2404)))+(((r20)*(x2410)))+(((r21)*(x2409)))+(((x2412)*(x2414))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r00)*(x2416)))+(((r01)*(x2409)))+(((r00)*(x2410)))+(((r02)*(x2411)))+(((sj1)*(x2405)))+(((x2412)*(x2413))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x2405)*(x2408)))+(((r10)*(x2410)))+(((x2406)*(x2412)))+(((r11)*(x2409)))+(((IkReal(-1.00000000000000))*(r10)*(x2416)))+(((r12)*(x2411))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x2417=((sj4)*(sj5));
IkReal x2418=((IkReal(0.390000000000000))*(sj5));
IkReal x2419=((r21)*(sj6));
IkReal x2420=((IkReal(0.390000000000000))*(cj5));
IkReal x2421=((cj6)*(r00));
IkReal x2422=((IkReal(0.000500000000000000))*(cj6));
IkReal x2423=((r11)*(sj6));
IkReal x2424=((cj5)*(sj4));
IkReal x2425=((r01)*(sj6));
IkReal x2426=((IkReal(1.00000000000000))*(r20));
IkReal x2427=((cj4)*(sj6));
IkReal x2428=((IkReal(0.000500000000000000))*(sj6));
IkReal x2429=((IkReal(1.00000000000000))*(r10));
IkReal x2430=((IkReal(1.00000000000000))*(cj4)*(cj6));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((r22)*(x2420)))+(((r21)*(x2422)))+(((cj6)*(r20)*(x2418)))+(((IkReal(-1.00000000000000))*(pz)))+(((IkReal(-1.00000000000000))*(x2418)*(x2419)))+(((r20)*(x2428))));
evalcond[2]=((((x2418)*(x2421)))+(((IkReal(0.00200000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(px)))+(((r00)*(x2428)))+(((r01)*(x2422)))+(((IkReal(-1.00000000000000))*(x2418)*(x2425)))+(((IkReal(-0.400000000000000))*(sj1)))+(((r02)*(x2420))));
evalcond[3]=((((IkReal(0.400000000000000))*(cj1)))+(((r10)*(x2428)))+(((IkReal(0.00200000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(py)))+(((r11)*(x2422)))+(((IkReal(-1.00000000000000))*(x2418)*(x2423)))+(((cj6)*(r10)*(x2418)))+(((r12)*(x2420))));
evalcond[4]=((((r22)*(x2417)))+(((IkReal(-1.00000000000000))*(cj6)*(x2424)*(x2426)))+(((x2419)*(x2424)))+(((IkReal(-1.00000000000000))*(r21)*(x2430)))+(((IkReal(-1.00000000000000))*(x2426)*(x2427))));
evalcond[5]=((cj1)+(((IkReal(-1.00000000000000))*(x2421)*(x2424)))+(((IkReal(-1.00000000000000))*(r01)*(x2430)))+(((x2424)*(x2425)))+(((r02)*(x2417)))+(((IkReal(-1.00000000000000))*(r00)*(x2427))));
evalcond[6]=((sj1)+(((x2423)*(x2424)))+(((IkReal(-1.00000000000000))*(cj6)*(x2424)*(x2429)))+(((IkReal(-1.00000000000000))*(r11)*(x2430)))+(((r12)*(x2417)))+(((IkReal(-1.00000000000000))*(x2427)*(x2429))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2431=((cj4)*(cj5));
IkReal x2432=((cj6)*(r20));
IkReal x2433=((IkReal(1.00000000000000))*(sj4));
IkReal x2434=((IkReal(1.00000000000000))*(r21)*(sj6));
if( IKabs(((((cj5)*(r22)))+(((sj5)*(x2432)))+(((IkReal(-1.00000000000000))*(sj5)*(x2434))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(cj6)*(r21)*(x2433)))+(((IkReal(-1.00000000000000))*(x2431)*(x2434)))+(((x2431)*(x2432)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x2433))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((cj5)*(r22)))+(((sj5)*(x2432)))+(((IkReal(-1.00000000000000))*(sj5)*(x2434)))))+IKsqr(((((IkReal(-1.00000000000000))*(cj6)*(r21)*(x2433)))+(((IkReal(-1.00000000000000))*(x2431)*(x2434)))+(((x2431)*(x2432)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x2433)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((cj5)*(r22)))+(((sj5)*(x2432)))+(((IkReal(-1.00000000000000))*(sj5)*(x2434)))), ((((IkReal(-1.00000000000000))*(cj6)*(r21)*(x2433)))+(((IkReal(-1.00000000000000))*(x2431)*(x2434)))+(((x2431)*(x2432)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x2433)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x2435=IKcos(j3);
IkReal x2436=IKsin(j3);
IkReal x2437=((r11)*(sj6));
IkReal x2438=((IkReal(1.00000000000000))*(sj5));
IkReal x2439=((IkReal(1.00000000000000))*(cj1));
IkReal x2440=((sj4)*(sj6));
IkReal x2441=((cj4)*(sj5));
IkReal x2442=((cj6)*(sj4));
IkReal x2443=((cj4)*(cj5));
IkReal x2444=((r01)*(sj6));
IkReal x2445=((r21)*(sj6));
IkReal x2446=((cj6)*(sj5));
IkReal x2447=((IkReal(1.00000000000000))*(cj6)*(x2443));
evalcond[0]=((((IkReal(-1.00000000000000))*(x2436)))+(((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(x2438)*(x2445)))+(((r20)*(x2446))));
evalcond[1]=((((r00)*(x2446)))+(((IkReal(-1.00000000000000))*(x2438)*(x2444)))+(((sj1)*(x2435)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((r10)*(x2446)))+(((IkReal(-1.00000000000000))*(x2435)*(x2439)))+(((IkReal(-1.00000000000000))*(x2437)*(x2438))));
evalcond[3]=((x2435)+(((IkReal(-1.00000000000000))*(r20)*(x2447)))+(((r22)*(x2441)))+(((x2443)*(x2445)))+(((r20)*(x2440)))+(((r21)*(x2442))));
evalcond[4]=((((r02)*(x2441)))+(((x2443)*(x2444)))+(((r00)*(x2440)))+(((r01)*(x2442)))+(((sj1)*(x2436)))+(((IkReal(-1.00000000000000))*(r00)*(x2447))));
evalcond[5]=((((r10)*(x2440)))+(((IkReal(-1.00000000000000))*(r10)*(x2447)))+(((IkReal(-1.00000000000000))*(x2436)*(x2439)))+(((r12)*(x2441)))+(((x2437)*(x2443)))+(((r11)*(x2442))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2448=((IKabs(sj2) != 0)?((IkReal)1/(sj2)):(IkReal)1.0e30);
IkReal x2449=((IkReal(1.00000000000000))*(sj5));
IkReal x2450=((cj2)*(sj1));
IkReal x2451=((r21)*(sj6));
IkReal x2452=((cj6)*(r20));
IkReal x2453=((cj5)*(r22));
if( IKabs(((x2448)*(((((IkReal(-1.00000000000000))*(x2453)))+(((IkReal(-1.00000000000000))*(x2449)*(x2452)))+(((sj5)*(x2451))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((x2448)*(((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((cj5)*(r12)*(sj2)))+(((sj5)*(x2450)*(x2452)))+(((IkReal(-1.00000000000000))*(r11)*(sj2)*(sj6)*(x2449)))+(((IkReal(-1.00000000000000))*(x2449)*(x2450)*(x2451)))+(((x2450)*(x2453)))+(((cj6)*(r10)*(sj2)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x2448)*(((((IkReal(-1.00000000000000))*(x2453)))+(((IkReal(-1.00000000000000))*(x2449)*(x2452)))+(((sj5)*(x2451)))))))+IKsqr(((x2448)*(((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((cj5)*(r12)*(sj2)))+(((sj5)*(x2450)*(x2452)))+(((IkReal(-1.00000000000000))*(r11)*(sj2)*(sj6)*(x2449)))+(((IkReal(-1.00000000000000))*(x2449)*(x2450)*(x2451)))+(((x2450)*(x2453)))+(((cj6)*(r10)*(sj2)*(sj5)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((x2448)*(((((IkReal(-1.00000000000000))*(x2453)))+(((IkReal(-1.00000000000000))*(x2449)*(x2452)))+(((sj5)*(x2451)))))), ((x2448)*(((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((cj5)*(r12)*(sj2)))+(((sj5)*(x2450)*(x2452)))+(((IkReal(-1.00000000000000))*(r11)*(sj2)*(sj6)*(x2449)))+(((IkReal(-1.00000000000000))*(x2449)*(x2450)*(x2451)))+(((x2450)*(x2453)))+(((cj6)*(r10)*(sj2)*(sj5)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x2454=IKsin(j3);
IkReal x2455=IKcos(j3);
IkReal x2456=((r11)*(sj6));
IkReal x2457=((IkReal(1.00000000000000))*(sj5));
IkReal x2458=((sj4)*(sj6));
IkReal x2459=((cj4)*(sj5));
IkReal x2460=((cj6)*(sj4));
IkReal x2461=((cj4)*(cj5));
IkReal x2462=((r01)*(sj6));
IkReal x2463=((r21)*(sj6));
IkReal x2464=((cj6)*(sj5));
IkReal x2465=((IkReal(1.00000000000000))*(x2455));
IkReal x2466=((sj1)*(x2455));
IkReal x2467=((IkReal(1.00000000000000))*(cj6)*(x2461));
IkReal x2468=((IkReal(1.00000000000000))*(cj2)*(x2454));
evalcond[0]=((((cj5)*(r22)))+(((sj2)*(x2454)))+(((IkReal(-1.00000000000000))*(x2457)*(x2463)))+(((r20)*(x2464))));
evalcond[1]=((x2466)+(((IkReal(-1.00000000000000))*(x2457)*(x2462)))+(((IkReal(-1.00000000000000))*(cj1)*(x2468)))+(((cj5)*(r02)))+(((r00)*(x2464))));
evalcond[2]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x2456)*(x2457)))+(((IkReal(-1.00000000000000))*(cj1)*(x2465)))+(((IkReal(-1.00000000000000))*(sj1)*(x2468)))+(((r10)*(x2464))));
evalcond[3]=((((x2461)*(x2463)))+(((r22)*(x2459)))+(((r21)*(x2460)))+(((IkReal(-1.00000000000000))*(r20)*(x2467)))+(((IkReal(-1.00000000000000))*(sj2)*(x2465)))+(((r20)*(x2458))));
evalcond[4]=((((r02)*(x2459)))+(((r01)*(x2460)))+(((IkReal(-1.00000000000000))*(r00)*(x2467)))+(((x2461)*(x2462)))+(((sj1)*(x2454)))+(((cj1)*(cj2)*(x2455)))+(((r00)*(x2458))));
evalcond[5]=((((cj2)*(x2466)))+(((r10)*(x2458)))+(((r11)*(x2460)))+(((r12)*(x2459)))+(((x2456)*(x2461)))+(((IkReal(-1.00000000000000))*(r10)*(x2467)))+(((IkReal(-1.00000000000000))*(cj1)*(x2454))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2469=(sj1)*(sj1);
IkReal x2470=(cj1)*(cj1);
IkReal x2471=((cj5)*(r12));
IkReal x2472=((cj6)*(sj5));
IkReal x2473=((IkReal(1.00000000000000))*(sj1));
IkReal x2474=((cj5)*(r02));
IkReal x2475=((IkReal(1.00000000000000))*(cj1));
IkReal x2476=((r01)*(sj5)*(sj6));
IkReal x2477=((r11)*(sj5)*(sj6));
if( IKabs(((((IKabs(((((cj2)*(x2470)))+(((cj2)*(x2469))))) != 0)?((IkReal)1/(((((cj2)*(x2470)))+(((cj2)*(x2469)))))):(IkReal)1.0e30))*(((((r10)*(sj1)*(x2472)))+(((IkReal(-1.00000000000000))*(x2473)*(x2477)))+(((sj1)*(x2471)))+(((cj1)*(r00)*(x2472)))+(((IkReal(-1.00000000000000))*(x2475)*(x2476)))+(((cj1)*(x2474))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IKabs(((x2469)+(x2470))) != 0)?((IkReal)1/(((x2469)+(x2470)))):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(x2473)*(x2474)))+(((sj1)*(x2476)))+(((IkReal(-1.00000000000000))*(x2475)*(x2477)))+(((cj1)*(r10)*(x2472)))+(((IkReal(-1.00000000000000))*(r00)*(x2472)*(x2473)))+(((cj1)*(x2471))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IKabs(((((cj2)*(x2470)))+(((cj2)*(x2469))))) != 0)?((IkReal)1/(((((cj2)*(x2470)))+(((cj2)*(x2469)))))):(IkReal)1.0e30))*(((((r10)*(sj1)*(x2472)))+(((IkReal(-1.00000000000000))*(x2473)*(x2477)))+(((sj1)*(x2471)))+(((cj1)*(r00)*(x2472)))+(((IkReal(-1.00000000000000))*(x2475)*(x2476)))+(((cj1)*(x2474)))))))+IKsqr(((((IKabs(((x2469)+(x2470))) != 0)?((IkReal)1/(((x2469)+(x2470)))):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(x2473)*(x2474)))+(((sj1)*(x2476)))+(((IkReal(-1.00000000000000))*(x2475)*(x2477)))+(((cj1)*(r10)*(x2472)))+(((IkReal(-1.00000000000000))*(r00)*(x2472)*(x2473)))+(((cj1)*(x2471)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IKabs(((((cj2)*(x2470)))+(((cj2)*(x2469))))) != 0)?((IkReal)1/(((((cj2)*(x2470)))+(((cj2)*(x2469)))))):(IkReal)1.0e30))*(((((r10)*(sj1)*(x2472)))+(((IkReal(-1.00000000000000))*(x2473)*(x2477)))+(((sj1)*(x2471)))+(((cj1)*(r00)*(x2472)))+(((IkReal(-1.00000000000000))*(x2475)*(x2476)))+(((cj1)*(x2474)))))), ((((IKabs(((x2469)+(x2470))) != 0)?((IkReal)1/(((x2469)+(x2470)))):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(x2473)*(x2474)))+(((sj1)*(x2476)))+(((IkReal(-1.00000000000000))*(x2475)*(x2477)))+(((cj1)*(r10)*(x2472)))+(((IkReal(-1.00000000000000))*(r00)*(x2472)*(x2473)))+(((cj1)*(x2471)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x2478=IKsin(j3);
IkReal x2479=IKcos(j3);
IkReal x2480=((r11)*(sj6));
IkReal x2481=((IkReal(1.00000000000000))*(sj5));
IkReal x2482=((sj4)*(sj6));
IkReal x2483=((cj4)*(sj5));
IkReal x2484=((cj6)*(sj4));
IkReal x2485=((cj4)*(cj5));
IkReal x2486=((r01)*(sj6));
IkReal x2487=((r21)*(sj6));
IkReal x2488=((cj6)*(sj5));
IkReal x2489=((IkReal(1.00000000000000))*(x2479));
IkReal x2490=((sj1)*(x2479));
IkReal x2491=((IkReal(1.00000000000000))*(cj6)*(x2485));
IkReal x2492=((IkReal(1.00000000000000))*(cj2)*(x2478));
evalcond[0]=((((cj5)*(r22)))+(((sj2)*(x2478)))+(((IkReal(-1.00000000000000))*(x2481)*(x2487)))+(((r20)*(x2488))));
evalcond[1]=((x2490)+(((IkReal(-1.00000000000000))*(cj1)*(x2492)))+(((IkReal(-1.00000000000000))*(x2481)*(x2486)))+(((cj5)*(r02)))+(((r00)*(x2488))));
evalcond[2]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(sj1)*(x2492)))+(((IkReal(-1.00000000000000))*(cj1)*(x2489)))+(((IkReal(-1.00000000000000))*(x2480)*(x2481)))+(((r10)*(x2488))));
evalcond[3]=((((x2485)*(x2487)))+(((r22)*(x2483)))+(((IkReal(-1.00000000000000))*(sj2)*(x2489)))+(((IkReal(-1.00000000000000))*(r20)*(x2491)))+(((r21)*(x2484)))+(((r20)*(x2482))));
evalcond[4]=((((r01)*(x2484)))+(((x2485)*(x2486)))+(((r02)*(x2483)))+(((IkReal(-1.00000000000000))*(r00)*(x2491)))+(((sj1)*(x2478)))+(((cj1)*(cj2)*(x2479)))+(((r00)*(x2482))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(x2491)))+(((cj2)*(x2490)))+(((x2480)*(x2485)))+(((IkReal(-1.00000000000000))*(cj1)*(x2478)))+(((r11)*(x2484)))+(((r12)*(x2483)))+(((r10)*(x2482))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2493=((cj4)*(cj5));
IkReal x2494=((r21)*(sj6));
IkReal x2495=((IkReal(1.00000000000000))*(cj6)*(r20));
if( IKabs(((gconst4)*(((((sj5)*(x2494)))+(((IkReal(-1.00000000000000))*(sj5)*(x2495)))+(((IkReal(-1.00000000000000))*(cj5)*(r22))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst4)*(((((IkReal(-1.00000000000000))*(x2493)*(x2495)))+(((x2493)*(x2494)))+(((cj4)*(r22)*(sj5)))+(((cj6)*(r21)*(sj4)))+(((r20)*(sj4)*(sj6))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst4)*(((((sj5)*(x2494)))+(((IkReal(-1.00000000000000))*(sj5)*(x2495)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))))), ((gconst4)*(((((IkReal(-1.00000000000000))*(x2493)*(x2495)))+(((x2493)*(x2494)))+(((cj4)*(r22)*(sj5)))+(((cj6)*(r21)*(sj4)))+(((r20)*(sj4)*(sj6)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x2496=IKsin(j3);
IkReal x2497=IKcos(j3);
IkReal x2498=((r11)*(sj6));
IkReal x2499=((IkReal(1.00000000000000))*(sj5));
IkReal x2500=((sj4)*(sj6));
IkReal x2501=((cj4)*(sj5));
IkReal x2502=((cj6)*(sj4));
IkReal x2503=((cj4)*(cj5));
IkReal x2504=((r01)*(sj6));
IkReal x2505=((r21)*(sj6));
IkReal x2506=((cj6)*(sj5));
IkReal x2507=((IkReal(1.00000000000000))*(x2497));
IkReal x2508=((sj1)*(x2497));
IkReal x2509=((IkReal(1.00000000000000))*(cj6)*(x2503));
IkReal x2510=((IkReal(1.00000000000000))*(cj2)*(x2496));
evalcond[0]=((((cj5)*(r22)))+(((sj2)*(x2496)))+(((IkReal(-1.00000000000000))*(x2499)*(x2505)))+(((r20)*(x2506))));
evalcond[1]=((x2508)+(((IkReal(-1.00000000000000))*(x2499)*(x2504)))+(((IkReal(-1.00000000000000))*(cj1)*(x2510)))+(((r00)*(x2506)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(sj1)*(x2510)))+(((r10)*(x2506)))+(((IkReal(-1.00000000000000))*(x2498)*(x2499)))+(((IkReal(-1.00000000000000))*(cj1)*(x2507))));
evalcond[3]=((((r22)*(x2501)))+(((r21)*(x2502)))+(((IkReal(-1.00000000000000))*(sj2)*(x2507)))+(((r20)*(x2500)))+(((x2503)*(x2505)))+(((IkReal(-1.00000000000000))*(r20)*(x2509))));
evalcond[4]=((((cj1)*(cj2)*(x2497)))+(((sj1)*(x2496)))+(((r02)*(x2501)))+(((IkReal(-1.00000000000000))*(r00)*(x2509)))+(((r00)*(x2500)))+(((x2503)*(x2504)))+(((r01)*(x2502))));
evalcond[5]=((((r12)*(x2501)))+(((r10)*(x2500)))+(((IkReal(-1.00000000000000))*(cj1)*(x2496)))+(((cj2)*(x2508)))+(((IkReal(-1.00000000000000))*(r10)*(x2509)))+(((r11)*(x2502)))+(((x2498)*(x2503))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x2511=((cj2)*(sj6));
IkReal x2512=((cj2)*(cj6));
IkReal x2513=((IkReal(1.00000000000000))*(cj1)*(sj2));
if( IKabs(((gconst0)*(((((IkReal(-1.00000000000000))*(cj6)*(r21)*(x2513)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x2513)))+(((r01)*(x2512)))+(((r00)*(x2511))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst0)*(((((IkReal(-1.00000000000000))*(cj5)*(r00)*(x2512)))+(((IkReal(-1.00000000000000))*(cj5)*(r21)*(sj6)*(x2513)))+(((cj5)*(r01)*(x2511)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x2513)))+(((cj2)*(r02)*(sj5)))+(((cj1)*(cj5)*(cj6)*(r20)*(sj2))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst0)*(((((IkReal(-1.00000000000000))*(cj6)*(r21)*(x2513)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x2513)))+(((r01)*(x2512)))+(((r00)*(x2511)))))), ((gconst0)*(((((IkReal(-1.00000000000000))*(cj5)*(r00)*(x2512)))+(((IkReal(-1.00000000000000))*(cj5)*(r21)*(sj6)*(x2513)))+(((cj5)*(r01)*(x2511)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x2513)))+(((cj2)*(r02)*(sj5)))+(((cj1)*(cj5)*(cj6)*(r20)*(sj2)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x2514=IKsin(j4);
IkReal x2515=IKcos(j4);
IkReal x2516=((IkReal(1.00000000000000))*(sj2));
IkReal x2517=((IkReal(1.00000000000000))*(cj6));
IkReal x2518=((sj5)*(x2514));
IkReal x2519=((cj5)*(x2514));
IkReal x2520=((IkReal(1.00000000000000))*(sj6)*(x2515));
evalcond[0]=((((r21)*(sj6)*(x2519)))+(((IkReal(-1.00000000000000))*(r21)*(x2515)*(x2517)))+(((r22)*(x2518)))+(((IkReal(-1.00000000000000))*(r20)*(x2520)))+(((IkReal(-1.00000000000000))*(r20)*(x2517)*(x2519)))+(((IkReal(-1.00000000000000))*(cj2))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r00)*(x2517)*(x2519)))+(((r01)*(sj6)*(x2519)))+(((r02)*(x2518)))+(((IkReal(-1.00000000000000))*(r00)*(x2520)))+(((IkReal(-1.00000000000000))*(cj1)*(x2516)))+(((IkReal(-1.00000000000000))*(r01)*(x2515)*(x2517))));
evalcond[2]=((((IkReal(-1.00000000000000))*(sj1)*(x2516)))+(((IkReal(-1.00000000000000))*(r10)*(x2517)*(x2519)))+(((r11)*(sj6)*(x2519)))+(((IkReal(-1.00000000000000))*(r11)*(x2515)*(x2517)))+(((r12)*(x2518)))+(((IkReal(-1.00000000000000))*(r10)*(x2520))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst4;
gconst4=IKsign(sj2);
dummyeval[0]=sj2;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[2];
IkReal x2521=(sj1)*(sj1);
IkReal x2522=(cj1)*(cj1);
dummyeval[0]=((((cj2)*(x2522)))+(((cj2)*(x2521))));
dummyeval[1]=((x2521)+(x2522));
if( IKabs(dummyeval[0]) < 0.0000010000000000  || IKabs(dummyeval[1]) < 0.0000010000000000  )
{
{
IkReal dummyeval[2];
dummyeval[0]=sj2;
dummyeval[1]=cj1;
if( IKabs(dummyeval[0]) < 0.0000010000000000  || IKabs(dummyeval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[9];
IkReal x2523=((sj4)*(sj5));
IkReal x2524=((cj6)*(r20));
IkReal x2525=((IkReal(1.00000000000000))*(cj4));
IkReal x2526=((IkReal(0.390000000000000))*(sj5));
IkReal x2527=((r21)*(sj6));
IkReal x2528=((IkReal(0.390000000000000))*(cj5));
IkReal x2529=((cj6)*(r00));
IkReal x2530=((IkReal(0.000500000000000000))*(cj6));
IkReal x2531=((r11)*(sj6));
IkReal x2532=((cj5)*(sj4));
IkReal x2533=((r01)*(sj6));
IkReal x2534=((r20)*(sj6));
IkReal x2535=((r10)*(sj6));
IkReal x2536=((cj6)*(r10));
IkReal x2537=((cj6)*(r21));
IkReal x2538=((r00)*(sj6));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(3.14159265358979))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((cj5)*(r22)))+(((sj5)*(x2524)))+(((IkReal(-1.00000000000000))*(sj5)*(x2527))));
evalcond[2]=((IkReal(-0.00200000000000000))+(((r22)*(x2528)))+(((r21)*(x2530)))+(((IkReal(-1.00000000000000))*(pz)))+(((IkReal(0.000500000000000000))*(x2534)))+(((IkReal(-1.00000000000000))*(x2526)*(x2527)))+(((x2524)*(x2526))));
evalcond[3]=((((r02)*(x2528)))+(((r01)*(x2530)))+(((IkReal(-1.00000000000000))*(x2526)*(x2533)))+(((IkReal(-1.00000000000000))*(px)))+(((IkReal(0.000500000000000000))*(x2538)))+(((x2526)*(x2529)))+(((IkReal(-0.400000000000000))*(sj1))));
evalcond[4]=((((x2526)*(x2536)))+(((r12)*(x2528)))+(((IkReal(0.400000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(x2526)*(x2531)))+(((IkReal(-1.00000000000000))*(py)))+(((IkReal(0.000500000000000000))*(x2535)))+(((r11)*(x2530))));
evalcond[5]=((IkReal(-1.00000000000000))+(((r22)*(x2523)))+(((IkReal(-1.00000000000000))*(x2525)*(x2534)))+(((IkReal(-1.00000000000000))*(x2525)*(x2537)))+(((x2527)*(x2532)))+(((IkReal(-1.00000000000000))*(x2524)*(x2532))));
evalcond[6]=((((cj4)*(cj5)*(x2527)))+(((IkReal(-1.00000000000000))*(cj5)*(x2524)*(x2525)))+(((cj4)*(r22)*(sj5)))+(((sj4)*(x2534)))+(((sj4)*(x2537))));
evalcond[7]=((((r02)*(x2523)))+(((IkReal(-1.00000000000000))*(x2525)*(x2538)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x2525)))+(((IkReal(-1.00000000000000))*(x2529)*(x2532)))+(((x2532)*(x2533))));
evalcond[8]=((((x2531)*(x2532)))+(((IkReal(-1.00000000000000))*(x2525)*(x2535)))+(((IkReal(-1.00000000000000))*(x2532)*(x2536)))+(((r12)*(x2523)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x2525))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst5;
gconst5=IKsign((((sj1)*(sj1))+((cj1)*(cj1))));
dummyeval[0]=(((sj1)*(sj1))+((cj1)*(cj1)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst6;
gconst6=IKsign((((sj1)*(sj1))+((cj1)*(cj1))));
dummyeval[0]=(((sj1)*(sj1))+((cj1)*(cj1)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2539=((IkReal(1.00000000000000))*(sj4));
IkReal x2540=((r00)*(sj6));
IkReal x2541=((cj1)*(cj6));
IkReal x2542=((cj4)*(sj5));
IkReal x2543=((cj4)*(cj5));
IkReal x2544=((r01)*(sj1));
IkReal x2545=((IkReal(1.00000000000000))*(sj6));
IkReal x2546=((cj1)*(r02));
IkReal x2547=((cj1)*(r01));
IkReal x2548=((IkReal(1.00000000000000))*(r02)*(sj1));
IkReal x2549=((cj6)*(r00)*(sj1));
if( IKabs(((gconst6)*(((((IkReal(-1.00000000000000))*(x2542)*(x2548)))+(((IkReal(-1.00000000000000))*(sj1)*(x2539)*(x2540)))+(((x2543)*(x2549)))+(((cj5)*(x2546)))+(((IkReal(-1.00000000000000))*(sj5)*(x2545)*(x2547)))+(((r00)*(sj5)*(x2541)))+(((IkReal(-1.00000000000000))*(x2543)*(x2544)*(x2545)))+(((IkReal(-1.00000000000000))*(cj6)*(x2539)*(x2544))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst6)*(((((IkReal(-1.00000000000000))*(r01)*(x2539)*(x2541)))+(((sj5)*(sj6)*(x2544)))+(((IkReal(-1.00000000000000))*(cj1)*(x2539)*(x2540)))+(((IkReal(-1.00000000000000))*(x2543)*(x2545)*(x2547)))+(((IkReal(-1.00000000000000))*(sj5)*(x2549)))+(((IkReal(-1.00000000000000))*(x2542)*(x2546)))+(((IkReal(-1.00000000000000))*(cj5)*(x2548)))+(((r00)*(x2541)*(x2543))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst6)*(((((IkReal(-1.00000000000000))*(x2542)*(x2548)))+(((IkReal(-1.00000000000000))*(sj1)*(x2539)*(x2540)))+(((x2543)*(x2549)))+(((cj5)*(x2546)))+(((IkReal(-1.00000000000000))*(sj5)*(x2545)*(x2547)))+(((r00)*(sj5)*(x2541)))+(((IkReal(-1.00000000000000))*(x2543)*(x2544)*(x2545)))+(((IkReal(-1.00000000000000))*(cj6)*(x2539)*(x2544)))))), ((gconst6)*(((((IkReal(-1.00000000000000))*(r01)*(x2539)*(x2541)))+(((sj5)*(sj6)*(x2544)))+(((IkReal(-1.00000000000000))*(cj1)*(x2539)*(x2540)))+(((IkReal(-1.00000000000000))*(x2543)*(x2545)*(x2547)))+(((IkReal(-1.00000000000000))*(sj5)*(x2549)))+(((IkReal(-1.00000000000000))*(x2542)*(x2546)))+(((IkReal(-1.00000000000000))*(cj5)*(x2548)))+(((r00)*(x2541)*(x2543)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x2550=IKcos(j3);
IkReal x2551=IKsin(j3);
IkReal x2552=((r11)*(sj6));
IkReal x2553=((IkReal(1.00000000000000))*(sj5));
IkReal x2554=((sj4)*(sj6));
IkReal x2555=((cj4)*(sj5));
IkReal x2556=((cj6)*(sj4));
IkReal x2557=((cj4)*(cj5));
IkReal x2558=((r01)*(sj6));
IkReal x2559=((cj6)*(sj5));
IkReal x2560=((sj1)*(x2550));
IkReal x2561=((cj1)*(x2550));
IkReal x2562=((IkReal(1.00000000000000))*(x2551));
IkReal x2563=((cj1)*(x2562));
IkReal x2564=((IkReal(1.00000000000000))*(cj6)*(x2557));
evalcond[0]=((x2560)+(((IkReal(-1.00000000000000))*(x2563)))+(((r00)*(x2559)))+(((IkReal(-1.00000000000000))*(x2553)*(x2558)))+(((cj5)*(r02))));
evalcond[1]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x2561)))+(((IkReal(-1.00000000000000))*(x2552)*(x2553)))+(((IkReal(-1.00000000000000))*(sj1)*(x2562)))+(((r10)*(x2559))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r00)*(x2564)))+(x2561)+(((r01)*(x2556)))+(((r00)*(x2554)))+(((x2557)*(x2558)))+(((sj1)*(x2551)))+(((r02)*(x2555))));
evalcond[3]=((x2560)+(((r12)*(x2555)))+(((r11)*(x2556)))+(((IkReal(-1.00000000000000))*(x2563)))+(((x2552)*(x2557)))+(((IkReal(-1.00000000000000))*(r10)*(x2564)))+(((r10)*(x2554))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2565=((cj5)*(r12));
IkReal x2566=((cj6)*(sj5));
IkReal x2567=((IkReal(1.00000000000000))*(sj1));
IkReal x2568=((cj5)*(r02));
IkReal x2569=((IkReal(1.00000000000000))*(cj1));
IkReal x2570=((r01)*(sj5)*(sj6));
IkReal x2571=((r11)*(sj5)*(sj6));
if( IKabs(((gconst5)*(((((IkReal(-1.00000000000000))*(x2569)*(x2570)))+(((cj1)*(x2568)))+(((cj1)*(r00)*(x2566)))+(((r10)*(sj1)*(x2566)))+(((IkReal(-1.00000000000000))*(x2567)*(x2571)))+(((sj1)*(x2565))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst5)*(((((IkReal(-1.00000000000000))*(x2569)*(x2571)))+(((cj1)*(x2565)))+(((IkReal(-1.00000000000000))*(r00)*(x2566)*(x2567)))+(((cj1)*(r10)*(x2566)))+(((IkReal(-1.00000000000000))*(x2567)*(x2568)))+(((sj1)*(x2570))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst5)*(((((IkReal(-1.00000000000000))*(x2569)*(x2570)))+(((cj1)*(x2568)))+(((cj1)*(r00)*(x2566)))+(((r10)*(sj1)*(x2566)))+(((IkReal(-1.00000000000000))*(x2567)*(x2571)))+(((sj1)*(x2565)))))), ((gconst5)*(((((IkReal(-1.00000000000000))*(x2569)*(x2571)))+(((cj1)*(x2565)))+(((IkReal(-1.00000000000000))*(r00)*(x2566)*(x2567)))+(((cj1)*(r10)*(x2566)))+(((IkReal(-1.00000000000000))*(x2567)*(x2568)))+(((sj1)*(x2570)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x2572=IKcos(j3);
IkReal x2573=IKsin(j3);
IkReal x2574=((r11)*(sj6));
IkReal x2575=((IkReal(1.00000000000000))*(sj5));
IkReal x2576=((sj4)*(sj6));
IkReal x2577=((cj4)*(sj5));
IkReal x2578=((cj6)*(sj4));
IkReal x2579=((cj4)*(cj5));
IkReal x2580=((r01)*(sj6));
IkReal x2581=((cj6)*(sj5));
IkReal x2582=((sj1)*(x2572));
IkReal x2583=((cj1)*(x2572));
IkReal x2584=((IkReal(1.00000000000000))*(x2573));
IkReal x2585=((cj1)*(x2584));
IkReal x2586=((IkReal(1.00000000000000))*(cj6)*(x2579));
evalcond[0]=((x2582)+(((r00)*(x2581)))+(((IkReal(-1.00000000000000))*(x2585)))+(((IkReal(-1.00000000000000))*(x2575)*(x2580)))+(((cj5)*(r02))));
evalcond[1]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x2583)))+(((r10)*(x2581)))+(((IkReal(-1.00000000000000))*(sj1)*(x2584)))+(((IkReal(-1.00000000000000))*(x2574)*(x2575))));
evalcond[2]=((x2583)+(((IkReal(-1.00000000000000))*(r00)*(x2586)))+(((r01)*(x2578)))+(((x2579)*(x2580)))+(((r00)*(x2576)))+(((r02)*(x2577)))+(((sj1)*(x2573))));
evalcond[3]=((((r10)*(x2576)))+(x2582)+(((x2574)*(x2579)))+(((r11)*(x2578)))+(((r12)*(x2577)))+(((IkReal(-1.00000000000000))*(x2585)))+(((IkReal(-1.00000000000000))*(r10)*(x2586))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
IkReal x2587=((sj4)*(sj5));
IkReal x2588=((cj6)*(r20));
IkReal x2589=((IkReal(1.00000000000000))*(cj4));
IkReal x2590=((IkReal(0.390000000000000))*(sj5));
IkReal x2591=((r21)*(sj6));
IkReal x2592=((IkReal(0.390000000000000))*(cj5));
IkReal x2593=((cj6)*(r00));
IkReal x2594=((IkReal(0.000500000000000000))*(cj6));
IkReal x2595=((r11)*(sj6));
IkReal x2596=((cj5)*(sj4));
IkReal x2597=((r01)*(sj6));
IkReal x2598=((r20)*(sj6));
IkReal x2599=((r10)*(sj6));
IkReal x2600=((cj6)*(r10));
IkReal x2601=((cj6)*(r21));
IkReal x2602=((r00)*(sj6));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.11022302462516e-16))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((sj5)*(x2588)))+(((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(sj5)*(x2591))));
evalcond[2]=((IkReal(0.00200000000000000))+(((r22)*(x2592)))+(((IkReal(-1.00000000000000))*(x2590)*(x2591)))+(((IkReal(-1.00000000000000))*(pz)))+(((IkReal(0.000500000000000000))*(x2598)))+(((x2588)*(x2590)))+(((r21)*(x2594))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x2590)*(x2597)))+(((r01)*(x2594)))+(((IkReal(-1.00000000000000))*(px)))+(((IkReal(-0.400000000000000))*(sj1)))+(((IkReal(0.000500000000000000))*(x2602)))+(((r02)*(x2592)))+(((x2590)*(x2593))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x2590)*(x2595)))+(((IkReal(0.400000000000000))*(cj1)))+(((x2590)*(x2600)))+(((IkReal(-1.00000000000000))*(py)))+(((IkReal(0.000500000000000000))*(x2599)))+(((r12)*(x2592)))+(((r11)*(x2594))));
evalcond[5]=((IkReal(1.00000000000000))+(((r22)*(x2587)))+(((x2591)*(x2596)))+(((IkReal(-1.00000000000000))*(x2589)*(x2598)))+(((IkReal(-1.00000000000000))*(x2588)*(x2596)))+(((IkReal(-1.00000000000000))*(x2589)*(x2601))));
evalcond[6]=((((IkReal(-1.00000000000000))*(cj5)*(x2588)*(x2589)))+(((cj4)*(r22)*(sj5)))+(((sj4)*(x2598)))+(((sj4)*(x2601)))+(((cj4)*(cj5)*(x2591))));
evalcond[7]=((((IkReal(-1.00000000000000))*(x2593)*(x2596)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x2589)))+(((IkReal(-1.00000000000000))*(x2589)*(x2602)))+(((x2596)*(x2597)))+(((r02)*(x2587))));
evalcond[8]=((((IkReal(-1.00000000000000))*(cj6)*(r11)*(x2589)))+(((IkReal(-1.00000000000000))*(x2596)*(x2600)))+(((IkReal(-1.00000000000000))*(x2589)*(x2599)))+(((r12)*(x2587)))+(((x2595)*(x2596))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst7;
gconst7=IKsign(((((IkReal(-1.00000000000000))*((sj1)*(sj1))))+(((IkReal(-1.00000000000000))*((cj1)*(cj1))))));
dummyeval[0]=((((IkReal(-1.00000000000000))*((sj1)*(sj1))))+(((IkReal(-1.00000000000000))*((cj1)*(cj1)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst8;
gconst8=IKsign(((((IkReal(-1.00000000000000))*((sj1)*(sj1))))+(((IkReal(-1.00000000000000))*((cj1)*(cj1))))));
dummyeval[0]=((((IkReal(-1.00000000000000))*((sj1)*(sj1))))+(((IkReal(-1.00000000000000))*((cj1)*(cj1)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2603=((sj1)*(sj6));
IkReal x2604=((r00)*(sj4));
IkReal x2605=((IkReal(1.00000000000000))*(r01));
IkReal x2606=((cj1)*(cj6));
IkReal x2607=((cj1)*(sj6));
IkReal x2608=((cj4)*(cj5));
IkReal x2609=((r02)*(sj1));
IkReal x2610=((cj4)*(sj5));
IkReal x2611=((cj1)*(r02));
IkReal x2612=((cj6)*(r00)*(sj1));
if( IKabs(((gconst8)*(((((x2603)*(x2604)))+(((cj5)*(x2611)))+(((r00)*(sj5)*(x2606)))+(((r01)*(x2603)*(x2608)))+(((IkReal(-1.00000000000000))*(sj5)*(x2605)*(x2607)))+(((IkReal(-1.00000000000000))*(x2608)*(x2612)))+(((cj6)*(r01)*(sj1)*(sj4)))+(((x2609)*(x2610))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst8)*(((((sj5)*(x2612)))+(((cj5)*(x2609)))+(((IkReal(-1.00000000000000))*(sj4)*(x2605)*(x2606)))+(((r00)*(x2606)*(x2608)))+(((IkReal(-1.00000000000000))*(x2604)*(x2607)))+(((IkReal(-1.00000000000000))*(x2605)*(x2607)*(x2608)))+(((IkReal(-1.00000000000000))*(sj5)*(x2603)*(x2605)))+(((IkReal(-1.00000000000000))*(x2610)*(x2611))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst8)*(((((x2603)*(x2604)))+(((cj5)*(x2611)))+(((r00)*(sj5)*(x2606)))+(((r01)*(x2603)*(x2608)))+(((IkReal(-1.00000000000000))*(sj5)*(x2605)*(x2607)))+(((IkReal(-1.00000000000000))*(x2608)*(x2612)))+(((cj6)*(r01)*(sj1)*(sj4)))+(((x2609)*(x2610)))))), ((gconst8)*(((((sj5)*(x2612)))+(((cj5)*(x2609)))+(((IkReal(-1.00000000000000))*(sj4)*(x2605)*(x2606)))+(((r00)*(x2606)*(x2608)))+(((IkReal(-1.00000000000000))*(x2604)*(x2607)))+(((IkReal(-1.00000000000000))*(x2605)*(x2607)*(x2608)))+(((IkReal(-1.00000000000000))*(sj5)*(x2603)*(x2605)))+(((IkReal(-1.00000000000000))*(x2610)*(x2611)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x2613=IKsin(j3);
IkReal x2614=IKcos(j3);
IkReal x2615=((r11)*(sj6));
IkReal x2616=((IkReal(1.00000000000000))*(sj5));
IkReal x2617=((sj4)*(sj6));
IkReal x2618=((cj4)*(sj5));
IkReal x2619=((cj6)*(sj4));
IkReal x2620=((cj4)*(cj5));
IkReal x2621=((r01)*(sj6));
IkReal x2622=((cj6)*(sj5));
IkReal x2623=((sj1)*(x2613));
IkReal x2624=((cj1)*(x2613));
IkReal x2625=((IkReal(1.00000000000000))*(x2614));
IkReal x2626=((cj1)*(x2625));
IkReal x2627=((IkReal(1.00000000000000))*(cj6)*(x2620));
evalcond[0]=((((r00)*(x2622)))+(((sj1)*(x2614)))+(((IkReal(-1.00000000000000))*(x2616)*(x2621)))+(x2624)+(((cj5)*(r02))));
evalcond[1]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x2626)))+(((r10)*(x2622)))+(((IkReal(-1.00000000000000))*(x2615)*(x2616)))+(x2623));
evalcond[2]=((((r00)*(x2617)))+(((r01)*(x2619)))+(((IkReal(-1.00000000000000))*(r00)*(x2627)))+(((r02)*(x2618)))+(((x2620)*(x2621)))+(((IkReal(-1.00000000000000))*(x2626)))+(x2623));
evalcond[3]=((((IkReal(-1.00000000000000))*(x2624)))+(((x2615)*(x2620)))+(((IkReal(-1.00000000000000))*(r10)*(x2627)))+(((r11)*(x2619)))+(((r10)*(x2617)))+(((r12)*(x2618)))+(((IkReal(-1.00000000000000))*(sj1)*(x2625))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2628=((sj1)*(sj5));
IkReal x2629=((cj6)*(r10));
IkReal x2630=((cj5)*(sj1));
IkReal x2631=((cj1)*(cj5));
IkReal x2632=((cj1)*(sj5));
IkReal x2633=((cj6)*(r00));
IkReal x2634=((r11)*(sj6));
IkReal x2635=((IkReal(1.00000000000000))*(r01)*(sj6));
if( IKabs(((gconst7)*(((((x2628)*(x2629)))+(((r12)*(x2630)))+(((IkReal(-1.00000000000000))*(x2632)*(x2635)))+(((x2632)*(x2633)))+(((IkReal(-1.00000000000000))*(x2628)*(x2634)))+(((r02)*(x2631))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst7)*(((((IkReal(-1.00000000000000))*(r12)*(x2631)))+(((IkReal(-1.00000000000000))*(x2628)*(x2635)))+(((IkReal(-1.00000000000000))*(x2629)*(x2632)))+(((x2632)*(x2634)))+(((x2628)*(x2633)))+(((r02)*(x2630))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst7)*(((((x2628)*(x2629)))+(((r12)*(x2630)))+(((IkReal(-1.00000000000000))*(x2632)*(x2635)))+(((x2632)*(x2633)))+(((IkReal(-1.00000000000000))*(x2628)*(x2634)))+(((r02)*(x2631)))))), ((gconst7)*(((((IkReal(-1.00000000000000))*(r12)*(x2631)))+(((IkReal(-1.00000000000000))*(x2628)*(x2635)))+(((IkReal(-1.00000000000000))*(x2629)*(x2632)))+(((x2632)*(x2634)))+(((x2628)*(x2633)))+(((r02)*(x2630)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x2636=IKsin(j3);
IkReal x2637=IKcos(j3);
IkReal x2638=((r11)*(sj6));
IkReal x2639=((IkReal(1.00000000000000))*(sj5));
IkReal x2640=((sj4)*(sj6));
IkReal x2641=((cj4)*(sj5));
IkReal x2642=((cj6)*(sj4));
IkReal x2643=((cj4)*(cj5));
IkReal x2644=((r01)*(sj6));
IkReal x2645=((cj6)*(sj5));
IkReal x2646=((sj1)*(x2636));
IkReal x2647=((cj1)*(x2636));
IkReal x2648=((IkReal(1.00000000000000))*(x2637));
IkReal x2649=((cj1)*(x2648));
IkReal x2650=((IkReal(1.00000000000000))*(cj6)*(x2643));
evalcond[0]=((((sj1)*(x2637)))+(((r00)*(x2645)))+(((IkReal(-1.00000000000000))*(x2639)*(x2644)))+(x2647)+(((cj5)*(r02))));
evalcond[1]=((((cj5)*(r12)))+(((r10)*(x2645)))+(((IkReal(-1.00000000000000))*(x2638)*(x2639)))+(((IkReal(-1.00000000000000))*(x2649)))+(x2646));
evalcond[2]=((((IkReal(-1.00000000000000))*(r00)*(x2650)))+(((r02)*(x2641)))+(((r00)*(x2640)))+(((r01)*(x2642)))+(((IkReal(-1.00000000000000))*(x2649)))+(((x2643)*(x2644)))+(x2646));
evalcond[3]=((((r12)*(x2641)))+(((r11)*(x2642)))+(((x2638)*(x2643)))+(((r10)*(x2640)))+(((IkReal(-1.00000000000000))*(r10)*(x2650)))+(((IkReal(-1.00000000000000))*(x2647)))+(((IkReal(-1.00000000000000))*(sj1)*(x2648))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
IkReal x2651=((sj4)*(sj5));
IkReal x2652=((IkReal(0.390000000000000))*(sj5));
IkReal x2653=((r21)*(sj6));
IkReal x2654=((IkReal(0.390000000000000))*(cj5));
IkReal x2655=((cj6)*(r00));
IkReal x2656=((IkReal(0.000500000000000000))*(cj6));
IkReal x2657=((r11)*(sj6));
IkReal x2658=((cj5)*(sj4));
IkReal x2659=((IkReal(1.00000000000000))*(r20));
IkReal x2660=((cj4)*(sj6));
IkReal x2661=((r01)*(sj6));
IkReal x2662=((IkReal(0.000500000000000000))*(sj6));
IkReal x2663=((IkReal(1.00000000000000))*(r10));
IkReal x2664=((IkReal(1.00000000000000))*(cj4)*(cj6));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x2652)*(x2653)))+(((r21)*(x2656)))+(((cj6)*(r20)*(x2652)))+(((IkReal(-1.00000000000000))*(pz)))+(((r22)*(x2654)))+(((IkReal(-0.00200000000000000))*(cj2)))+(((r20)*(x2662))));
evalcond[2]=((IkReal(-0.400000000000000))+(((IkReal(-1.00000000000000))*(x2652)*(x2661)))+(((r02)*(x2654)))+(((IkReal(-1.00000000000000))*(px)))+(((r01)*(x2656)))+(((x2652)*(x2655)))+(((r00)*(x2662))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x2652)*(x2657)))+(((r12)*(x2654)))+(((r11)*(x2656)))+(((r10)*(x2662)))+(((IkReal(-1.00000000000000))*(py)))+(((IkReal(-0.00200000000000000))*(sj2)))+(((cj6)*(r10)*(x2652))));
evalcond[4]=((((x2653)*(x2658)))+(((r22)*(x2651)))+(((IkReal(-1.00000000000000))*(x2659)*(x2660)))+(((IkReal(-1.00000000000000))*(r21)*(x2664)))+(((IkReal(-1.00000000000000))*(cj6)*(x2658)*(x2659)))+(((IkReal(-1.00000000000000))*(cj2))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x2655)*(x2658)))+(((IkReal(-1.00000000000000))*(r00)*(x2660)))+(((x2658)*(x2661)))+(((IkReal(-1.00000000000000))*(r01)*(x2664)))+(((r02)*(x2651))));
evalcond[6]=((((r12)*(x2651)))+(((IkReal(-1.00000000000000))*(sj2)))+(((IkReal(-1.00000000000000))*(r11)*(x2664)))+(((IkReal(-1.00000000000000))*(x2660)*(x2663)))+(((x2657)*(x2658)))+(((IkReal(-1.00000000000000))*(cj6)*(x2658)*(x2663))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2665=((IkReal(1.00000000000000))*(cj6));
IkReal x2666=((IkReal(1.00000000000000))*(cj5));
IkReal x2667=((r01)*(sj6));
if( IKabs(((((IkReal(-1.00000000000000))*(r01)*(sj4)*(x2665)))+(((IkReal(-1.00000000000000))*(cj4)*(x2666)*(x2667)))+(((IkReal(-1.00000000000000))*(cj4)*(r02)*(sj5)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(sj6)))+(((cj4)*(cj5)*(cj6)*(r00))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r02)*(x2666)))+(((IkReal(-1.00000000000000))*(r00)*(sj5)*(x2665)))+(((sj5)*(x2667))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(r01)*(sj4)*(x2665)))+(((IkReal(-1.00000000000000))*(cj4)*(x2666)*(x2667)))+(((IkReal(-1.00000000000000))*(cj4)*(r02)*(sj5)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(sj6)))+(((cj4)*(cj5)*(cj6)*(r00)))))+IKsqr(((((IkReal(-1.00000000000000))*(r02)*(x2666)))+(((IkReal(-1.00000000000000))*(r00)*(sj5)*(x2665)))+(((sj5)*(x2667)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(r01)*(sj4)*(x2665)))+(((IkReal(-1.00000000000000))*(cj4)*(x2666)*(x2667)))+(((IkReal(-1.00000000000000))*(cj4)*(r02)*(sj5)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(sj6)))+(((cj4)*(cj5)*(cj6)*(r00)))), ((((IkReal(-1.00000000000000))*(r02)*(x2666)))+(((IkReal(-1.00000000000000))*(r00)*(sj5)*(x2665)))+(((sj5)*(x2667)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x2668=IKsin(j3);
IkReal x2669=IKcos(j3);
IkReal x2670=((r11)*(sj6));
IkReal x2671=((IkReal(1.00000000000000))*(sj5));
IkReal x2672=((sj4)*(sj6));
IkReal x2673=((cj4)*(sj5));
IkReal x2674=((cj6)*(sj4));
IkReal x2675=((cj4)*(cj5));
IkReal x2676=((r01)*(sj6));
IkReal x2677=((r21)*(sj6));
IkReal x2678=((cj6)*(sj5));
IkReal x2679=((IkReal(1.00000000000000))*(cj6)*(x2675));
evalcond[0]=((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(x2671)*(x2677)))+(((sj2)*(x2668)))+(((r20)*(x2678))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x2671)*(x2676)))+(((r00)*(x2678)))+(x2669)+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x2670)*(x2671)))+(((IkReal(-1.00000000000000))*(cj2)*(x2668)))+(((r10)*(x2678))));
evalcond[3]=((((IkReal(-1.00000000000000))*(sj2)*(x2669)))+(((r21)*(x2674)))+(((r22)*(x2673)))+(((x2675)*(x2677)))+(((IkReal(-1.00000000000000))*(r20)*(x2679)))+(((r20)*(x2672))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r00)*(x2679)))+(((r02)*(x2673)))+(((x2675)*(x2676)))+(((r00)*(x2672)))+(((r01)*(x2674)))+(x2668));
evalcond[5]=((((r12)*(x2673)))+(((r10)*(x2672)))+(((x2670)*(x2675)))+(((cj2)*(x2669)))+(((r11)*(x2674)))+(((IkReal(-1.00000000000000))*(r10)*(x2679))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x2680=((sj4)*(sj5));
IkReal x2681=((IkReal(0.390000000000000))*(sj5));
IkReal x2682=((r21)*(sj6));
IkReal x2683=((IkReal(0.390000000000000))*(cj5));
IkReal x2684=((cj6)*(r00));
IkReal x2685=((IkReal(0.000500000000000000))*(cj6));
IkReal x2686=((r11)*(sj6));
IkReal x2687=((cj5)*(sj4));
IkReal x2688=((IkReal(1.00000000000000))*(r20));
IkReal x2689=((cj4)*(sj6));
IkReal x2690=((r01)*(sj6));
IkReal x2691=((IkReal(0.000500000000000000))*(sj6));
IkReal x2692=((IkReal(1.00000000000000))*(r10));
IkReal x2693=((IkReal(1.00000000000000))*(cj4)*(cj6));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((((r22)*(x2683)))+(((r21)*(x2685)))+(((IkReal(-1.00000000000000))*(pz)))+(((cj6)*(r20)*(x2681)))+(((IkReal(-1.00000000000000))*(x2681)*(x2682)))+(((r20)*(x2691)))+(((IkReal(-0.00200000000000000))*(cj2))));
evalcond[2]=((IkReal(0.400000000000000))+(((r02)*(x2683)))+(((IkReal(-1.00000000000000))*(x2681)*(x2690)))+(((r01)*(x2685)))+(((IkReal(-1.00000000000000))*(px)))+(((r00)*(x2691)))+(((x2681)*(x2684))));
evalcond[3]=((((r11)*(x2685)))+(((r10)*(x2691)))+(((IkReal(0.00200000000000000))*(sj2)))+(((IkReal(-1.00000000000000))*(py)))+(((IkReal(-1.00000000000000))*(x2681)*(x2686)))+(((r12)*(x2683)))+(((cj6)*(r10)*(x2681))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x2688)*(x2689)))+(((r22)*(x2680)))+(((IkReal(-1.00000000000000))*(cj6)*(x2687)*(x2688)))+(((x2682)*(x2687)))+(((IkReal(-1.00000000000000))*(cj2)))+(((IkReal(-1.00000000000000))*(r21)*(x2693))));
evalcond[5]=((((r02)*(x2680)))+(((IkReal(-1.00000000000000))*(r00)*(x2689)))+(((IkReal(-1.00000000000000))*(x2684)*(x2687)))+(((x2687)*(x2690)))+(((IkReal(-1.00000000000000))*(r01)*(x2693))));
evalcond[6]=((sj2)+(((IkReal(-1.00000000000000))*(x2689)*(x2692)))+(((IkReal(-1.00000000000000))*(cj6)*(x2687)*(x2692)))+(((x2686)*(x2687)))+(((IkReal(-1.00000000000000))*(r11)*(x2693)))+(((r12)*(x2680))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2694=((cj4)*(cj5));
IkReal x2695=((r01)*(sj6));
IkReal x2696=((cj6)*(r00));
if( IKabs(((((r00)*(sj4)*(sj6)))+(((cj6)*(r01)*(sj4)))+(((IkReal(-1.00000000000000))*(x2694)*(x2696)))+(((cj4)*(r02)*(sj5)))+(((x2694)*(x2695))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(sj5)*(x2695)))+(((sj5)*(x2696)))+(((cj5)*(r02))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((r00)*(sj4)*(sj6)))+(((cj6)*(r01)*(sj4)))+(((IkReal(-1.00000000000000))*(x2694)*(x2696)))+(((cj4)*(r02)*(sj5)))+(((x2694)*(x2695)))))+IKsqr(((((IkReal(-1.00000000000000))*(sj5)*(x2695)))+(((sj5)*(x2696)))+(((cj5)*(r02)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((r00)*(sj4)*(sj6)))+(((cj6)*(r01)*(sj4)))+(((IkReal(-1.00000000000000))*(x2694)*(x2696)))+(((cj4)*(r02)*(sj5)))+(((x2694)*(x2695)))), ((((IkReal(-1.00000000000000))*(sj5)*(x2695)))+(((sj5)*(x2696)))+(((cj5)*(r02)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x2697=IKsin(j3);
IkReal x2698=IKcos(j3);
IkReal x2699=((r11)*(sj6));
IkReal x2700=((IkReal(1.00000000000000))*(sj5));
IkReal x2701=((cj6)*(sj4));
IkReal x2702=((sj4)*(sj6));
IkReal x2703=((cj4)*(sj5));
IkReal x2704=((cj4)*(cj5));
IkReal x2705=((r01)*(sj6));
IkReal x2706=((r21)*(sj6));
IkReal x2707=((cj6)*(sj5));
IkReal x2708=((IkReal(1.00000000000000))*(x2698));
IkReal x2709=((IkReal(1.00000000000000))*(cj6)*(x2704));
evalcond[0]=((((cj5)*(r22)))+(((r20)*(x2707)))+(((sj2)*(x2697)))+(((IkReal(-1.00000000000000))*(x2700)*(x2706))));
evalcond[1]=((((r00)*(x2707)))+(((IkReal(-1.00000000000000))*(x2708)))+(((IkReal(-1.00000000000000))*(x2700)*(x2705)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((r10)*(x2707)))+(((IkReal(-1.00000000000000))*(x2699)*(x2700)))+(((cj2)*(x2697))));
evalcond[3]=((((r22)*(x2703)))+(((x2704)*(x2706)))+(((IkReal(-1.00000000000000))*(r20)*(x2709)))+(((r20)*(x2702)))+(((r21)*(x2701)))+(((IkReal(-1.00000000000000))*(sj2)*(x2708))));
evalcond[4]=((((r00)*(x2702)))+(((IkReal(-1.00000000000000))*(r00)*(x2709)))+(((x2704)*(x2705)))+(((r01)*(x2701)))+(((IkReal(-1.00000000000000))*(x2697)))+(((r02)*(x2703))));
evalcond[5]=((((r12)*(x2703)))+(((IkReal(-1.00000000000000))*(r10)*(x2709)))+(((r11)*(x2701)))+(((x2699)*(x2704)))+(((r10)*(x2702)))+(((IkReal(-1.00000000000000))*(cj2)*(x2708))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x2710=((sj4)*(sj5));
IkReal x2711=((IkReal(0.390000000000000))*(sj5));
IkReal x2712=((r21)*(sj6));
IkReal x2713=((IkReal(0.390000000000000))*(cj5));
IkReal x2714=((cj6)*(r00));
IkReal x2715=((IkReal(0.000500000000000000))*(cj6));
IkReal x2716=((r11)*(sj6));
IkReal x2717=((cj5)*(sj4));
IkReal x2718=((r01)*(sj6));
IkReal x2719=((IkReal(1.00000000000000))*(r20));
IkReal x2720=((cj4)*(sj6));
IkReal x2721=((IkReal(0.000500000000000000))*(sj6));
IkReal x2722=((IkReal(1.00000000000000))*(r10));
IkReal x2723=((IkReal(1.00000000000000))*(cj4)*(cj6));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((r22)*(x2713)))+(((cj6)*(r20)*(x2711)))+(((IkReal(-1.00000000000000))*(pz)))+(((r20)*(x2721)))+(((r21)*(x2715)))+(((IkReal(-1.00000000000000))*(x2711)*(x2712))));
evalcond[2]=((((r02)*(x2713)))+(((IkReal(-1.00000000000000))*(px)))+(((x2711)*(x2714)))+(((r00)*(x2721)))+(((IkReal(-0.00200000000000000))*(cj1)))+(((IkReal(-0.400000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(x2711)*(x2718)))+(((r01)*(x2715))));
evalcond[3]=((((r12)*(x2713)))+(((IkReal(0.400000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(py)))+(((IkReal(-0.00200000000000000))*(sj1)))+(((cj6)*(r10)*(x2711)))+(((r10)*(x2721)))+(((r11)*(x2715)))+(((IkReal(-1.00000000000000))*(x2711)*(x2716))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r21)*(x2723)))+(((IkReal(-1.00000000000000))*(x2719)*(x2720)))+(((IkReal(-1.00000000000000))*(cj6)*(x2717)*(x2719)))+(((x2712)*(x2717)))+(((r22)*(x2710))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x2714)*(x2717)))+(((IkReal(-1.00000000000000))*(r01)*(x2723)))+(((r02)*(x2710)))+(((IkReal(-1.00000000000000))*(r00)*(x2720)))+(((IkReal(-1.00000000000000))*(cj1)))+(((x2717)*(x2718))));
evalcond[6]=((((r12)*(x2710)))+(((IkReal(-1.00000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(cj6)*(x2717)*(x2722)))+(((x2716)*(x2717)))+(((IkReal(-1.00000000000000))*(x2720)*(x2722)))+(((IkReal(-1.00000000000000))*(r11)*(x2723))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2724=((cj4)*(cj5));
IkReal x2725=((r21)*(sj6));
IkReal x2726=((IkReal(1.00000000000000))*(cj6)*(r20));
if( IKabs(((((sj5)*(x2725)))+(((IkReal(-1.00000000000000))*(sj5)*(x2726)))+(((IkReal(-1.00000000000000))*(cj5)*(r22))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(x2724)*(x2726)))+(((x2724)*(x2725)))+(((cj4)*(r22)*(sj5)))+(((cj6)*(r21)*(sj4)))+(((r20)*(sj4)*(sj6))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((sj5)*(x2725)))+(((IkReal(-1.00000000000000))*(sj5)*(x2726)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))))+IKsqr(((((IkReal(-1.00000000000000))*(x2724)*(x2726)))+(((x2724)*(x2725)))+(((cj4)*(r22)*(sj5)))+(((cj6)*(r21)*(sj4)))+(((r20)*(sj4)*(sj6)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((sj5)*(x2725)))+(((IkReal(-1.00000000000000))*(sj5)*(x2726)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))), ((((IkReal(-1.00000000000000))*(x2724)*(x2726)))+(((x2724)*(x2725)))+(((cj4)*(r22)*(sj5)))+(((cj6)*(r21)*(sj4)))+(((r20)*(sj4)*(sj6)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x2727=IKcos(j3);
IkReal x2728=IKsin(j3);
IkReal x2729=((r11)*(sj6));
IkReal x2730=((IkReal(1.00000000000000))*(sj5));
IkReal x2731=((IkReal(1.00000000000000))*(cj1));
IkReal x2732=((cj6)*(sj4));
IkReal x2733=((sj4)*(sj6));
IkReal x2734=((cj4)*(sj5));
IkReal x2735=((cj4)*(cj5));
IkReal x2736=((r01)*(sj6));
IkReal x2737=((r21)*(sj6));
IkReal x2738=((cj6)*(sj5));
IkReal x2739=((IkReal(1.00000000000000))*(cj6)*(x2735));
evalcond[0]=((x2728)+(((IkReal(-1.00000000000000))*(x2730)*(x2737)))+(((cj5)*(r22)))+(((r20)*(x2738))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x2730)*(x2736)))+(((r00)*(x2738)))+(((sj1)*(x2727)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x2727)*(x2731)))+(((r10)*(x2738)))+(((IkReal(-1.00000000000000))*(x2729)*(x2730))));
evalcond[3]=((((r21)*(x2732)))+(((r22)*(x2734)))+(((x2735)*(x2737)))+(((IkReal(-1.00000000000000))*(x2727)))+(((r20)*(x2733)))+(((IkReal(-1.00000000000000))*(r20)*(x2739))));
evalcond[4]=((((r02)*(x2734)))+(((r01)*(x2732)))+(((x2735)*(x2736)))+(((r00)*(x2733)))+(((sj1)*(x2728)))+(((IkReal(-1.00000000000000))*(r00)*(x2739))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x2728)*(x2731)))+(((r12)*(x2734)))+(((r10)*(x2733)))+(((IkReal(-1.00000000000000))*(r10)*(x2739)))+(((r11)*(x2732)))+(((x2729)*(x2735))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x2740=((sj4)*(sj5));
IkReal x2741=((IkReal(0.390000000000000))*(sj5));
IkReal x2742=((r21)*(sj6));
IkReal x2743=((IkReal(0.390000000000000))*(cj5));
IkReal x2744=((cj6)*(r00));
IkReal x2745=((IkReal(0.000500000000000000))*(cj6));
IkReal x2746=((r11)*(sj6));
IkReal x2747=((cj5)*(sj4));
IkReal x2748=((r01)*(sj6));
IkReal x2749=((IkReal(1.00000000000000))*(r20));
IkReal x2750=((cj4)*(sj6));
IkReal x2751=((IkReal(0.000500000000000000))*(sj6));
IkReal x2752=((IkReal(1.00000000000000))*(r10));
IkReal x2753=((IkReal(1.00000000000000))*(cj4)*(cj6));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((r21)*(x2745)))+(((r22)*(x2743)))+(((cj6)*(r20)*(x2741)))+(((IkReal(-1.00000000000000))*(x2741)*(x2742)))+(((IkReal(-1.00000000000000))*(pz)))+(((r20)*(x2751))));
evalcond[2]=((((IkReal(0.00200000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(x2741)*(x2748)))+(((IkReal(-1.00000000000000))*(px)))+(((r01)*(x2745)))+(((r00)*(x2751)))+(((x2741)*(x2744)))+(((IkReal(-0.400000000000000))*(sj1)))+(((r02)*(x2743))));
evalcond[3]=((((r11)*(x2745)))+(((r12)*(x2743)))+(((r10)*(x2751)))+(((IkReal(0.400000000000000))*(cj1)))+(((cj6)*(r10)*(x2741)))+(((IkReal(-1.00000000000000))*(x2741)*(x2746)))+(((IkReal(0.00200000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(py))));
evalcond[4]=((((r22)*(x2740)))+(((x2742)*(x2747)))+(((IkReal(-1.00000000000000))*(cj6)*(x2747)*(x2749)))+(((IkReal(-1.00000000000000))*(x2749)*(x2750)))+(((IkReal(-1.00000000000000))*(r21)*(x2753))));
evalcond[5]=((cj1)+(((IkReal(-1.00000000000000))*(r01)*(x2753)))+(((IkReal(-1.00000000000000))*(x2744)*(x2747)))+(((IkReal(-1.00000000000000))*(r00)*(x2750)))+(((x2747)*(x2748)))+(((r02)*(x2740))));
evalcond[6]=((sj1)+(((x2746)*(x2747)))+(((IkReal(-1.00000000000000))*(cj6)*(x2747)*(x2752)))+(((r12)*(x2740)))+(((IkReal(-1.00000000000000))*(x2750)*(x2752)))+(((IkReal(-1.00000000000000))*(r11)*(x2753))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2754=((cj4)*(cj5));
IkReal x2755=((cj6)*(r20));
IkReal x2756=((IkReal(1.00000000000000))*(sj4));
IkReal x2757=((IkReal(1.00000000000000))*(r21)*(sj6));
if( IKabs(((((cj5)*(r22)))+(((sj5)*(x2755)))+(((IkReal(-1.00000000000000))*(sj5)*(x2757))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((x2754)*(x2755)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(x2754)*(x2757)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x2756)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x2756))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((cj5)*(r22)))+(((sj5)*(x2755)))+(((IkReal(-1.00000000000000))*(sj5)*(x2757)))))+IKsqr(((((x2754)*(x2755)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(x2754)*(x2757)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x2756)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x2756)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((cj5)*(r22)))+(((sj5)*(x2755)))+(((IkReal(-1.00000000000000))*(sj5)*(x2757)))), ((((x2754)*(x2755)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(x2754)*(x2757)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x2756)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x2756)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x2758=IKcos(j3);
IkReal x2759=IKsin(j3);
IkReal x2760=((r11)*(sj6));
IkReal x2761=((IkReal(1.00000000000000))*(sj5));
IkReal x2762=((IkReal(1.00000000000000))*(cj1));
IkReal x2763=((sj4)*(sj6));
IkReal x2764=((cj4)*(sj5));
IkReal x2765=((cj6)*(sj4));
IkReal x2766=((cj4)*(cj5));
IkReal x2767=((r01)*(sj6));
IkReal x2768=((r21)*(sj6));
IkReal x2769=((cj6)*(sj5));
IkReal x2770=((IkReal(1.00000000000000))*(cj6)*(x2766));
evalcond[0]=((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(x2761)*(x2768)))+(((r20)*(x2769)))+(((IkReal(-1.00000000000000))*(x2759))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x2761)*(x2767)))+(((r00)*(x2769)))+(((sj1)*(x2758)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x2760)*(x2761)))+(((IkReal(-1.00000000000000))*(x2758)*(x2762)))+(((r10)*(x2769))));
evalcond[3]=((x2758)+(((r20)*(x2763)))+(((IkReal(-1.00000000000000))*(r20)*(x2770)))+(((r21)*(x2765)))+(((r22)*(x2764)))+(((x2766)*(x2768))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r00)*(x2770)))+(((r00)*(x2763)))+(((r01)*(x2765)))+(((sj1)*(x2759)))+(((r02)*(x2764)))+(((x2766)*(x2767))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(x2770)))+(((r12)*(x2764)))+(((IkReal(-1.00000000000000))*(x2759)*(x2762)))+(((r10)*(x2763)))+(((x2760)*(x2766)))+(((r11)*(x2765))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2771=((IKabs(sj2) != 0)?((IkReal)1/(sj2)):(IkReal)1.0e30);
IkReal x2772=((IkReal(1.00000000000000))*(sj5));
IkReal x2773=((cj2)*(sj1));
IkReal x2774=((r21)*(sj6));
IkReal x2775=((cj6)*(r20));
IkReal x2776=((cj5)*(r22));
if( IKabs(((x2771)*(((((IkReal(-1.00000000000000))*(x2776)))+(((IkReal(-1.00000000000000))*(x2772)*(x2775)))+(((sj5)*(x2774))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((x2771)*(((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((cj5)*(r12)*(sj2)))+(((sj5)*(x2773)*(x2775)))+(((IkReal(-1.00000000000000))*(r11)*(sj2)*(sj6)*(x2772)))+(((IkReal(-1.00000000000000))*(x2772)*(x2773)*(x2774)))+(((x2773)*(x2776)))+(((cj6)*(r10)*(sj2)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x2771)*(((((IkReal(-1.00000000000000))*(x2776)))+(((IkReal(-1.00000000000000))*(x2772)*(x2775)))+(((sj5)*(x2774)))))))+IKsqr(((x2771)*(((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((cj5)*(r12)*(sj2)))+(((sj5)*(x2773)*(x2775)))+(((IkReal(-1.00000000000000))*(r11)*(sj2)*(sj6)*(x2772)))+(((IkReal(-1.00000000000000))*(x2772)*(x2773)*(x2774)))+(((x2773)*(x2776)))+(((cj6)*(r10)*(sj2)*(sj5)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((x2771)*(((((IkReal(-1.00000000000000))*(x2776)))+(((IkReal(-1.00000000000000))*(x2772)*(x2775)))+(((sj5)*(x2774)))))), ((x2771)*(((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((cj5)*(r12)*(sj2)))+(((sj5)*(x2773)*(x2775)))+(((IkReal(-1.00000000000000))*(r11)*(sj2)*(sj6)*(x2772)))+(((IkReal(-1.00000000000000))*(x2772)*(x2773)*(x2774)))+(((x2773)*(x2776)))+(((cj6)*(r10)*(sj2)*(sj5)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x2777=IKsin(j3);
IkReal x2778=IKcos(j3);
IkReal x2779=((r11)*(sj6));
IkReal x2780=((IkReal(1.00000000000000))*(sj5));
IkReal x2781=((sj4)*(sj6));
IkReal x2782=((cj4)*(sj5));
IkReal x2783=((cj6)*(sj4));
IkReal x2784=((cj4)*(cj5));
IkReal x2785=((r01)*(sj6));
IkReal x2786=((r21)*(sj6));
IkReal x2787=((cj6)*(sj5));
IkReal x2788=((IkReal(1.00000000000000))*(x2778));
IkReal x2789=((sj1)*(x2778));
IkReal x2790=((IkReal(1.00000000000000))*(cj6)*(x2784));
IkReal x2791=((IkReal(1.00000000000000))*(cj2)*(x2777));
evalcond[0]=((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(x2780)*(x2786)))+(((sj2)*(x2777)))+(((r20)*(x2787))));
evalcond[1]=((x2789)+(((IkReal(-1.00000000000000))*(x2780)*(x2785)))+(((r00)*(x2787)))+(((IkReal(-1.00000000000000))*(cj1)*(x2791)))+(((cj5)*(r02))));
evalcond[2]=((((IkReal(-1.00000000000000))*(cj1)*(x2788)))+(((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(sj1)*(x2791)))+(((IkReal(-1.00000000000000))*(x2779)*(x2780)))+(((r10)*(x2787))));
evalcond[3]=((((r21)*(x2783)))+(((IkReal(-1.00000000000000))*(r20)*(x2790)))+(((IkReal(-1.00000000000000))*(sj2)*(x2788)))+(((x2784)*(x2786)))+(((r22)*(x2782)))+(((r20)*(x2781))));
evalcond[4]=((((sj1)*(x2777)))+(((x2784)*(x2785)))+(((r02)*(x2782)))+(((cj1)*(cj2)*(x2778)))+(((r01)*(x2783)))+(((r00)*(x2781)))+(((IkReal(-1.00000000000000))*(r00)*(x2790))));
evalcond[5]=((((x2779)*(x2784)))+(((cj2)*(x2789)))+(((r12)*(x2782)))+(((IkReal(-1.00000000000000))*(r10)*(x2790)))+(((r11)*(x2783)))+(((IkReal(-1.00000000000000))*(cj1)*(x2777)))+(((r10)*(x2781))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2792=(sj1)*(sj1);
IkReal x2793=(cj1)*(cj1);
IkReal x2794=((cj5)*(r12));
IkReal x2795=((cj6)*(sj5));
IkReal x2796=((IkReal(1.00000000000000))*(sj1));
IkReal x2797=((cj5)*(r02));
IkReal x2798=((IkReal(1.00000000000000))*(cj1));
IkReal x2799=((r01)*(sj5)*(sj6));
IkReal x2800=((r11)*(sj5)*(sj6));
if( IKabs(((((IKabs(((((cj2)*(x2792)))+(((cj2)*(x2793))))) != 0)?((IkReal)1/(((((cj2)*(x2792)))+(((cj2)*(x2793)))))):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(x2798)*(x2799)))+(((r10)*(sj1)*(x2795)))+(((cj1)*(x2797)))+(((cj1)*(r00)*(x2795)))+(((sj1)*(x2794)))+(((IkReal(-1.00000000000000))*(x2796)*(x2800))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IKabs(((x2792)+(x2793))) != 0)?((IkReal)1/(((x2792)+(x2793)))):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(x2796)*(x2797)))+(((cj1)*(x2794)))+(((sj1)*(x2799)))+(((cj1)*(r10)*(x2795)))+(((IkReal(-1.00000000000000))*(x2798)*(x2800)))+(((IkReal(-1.00000000000000))*(r00)*(x2795)*(x2796))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IKabs(((((cj2)*(x2792)))+(((cj2)*(x2793))))) != 0)?((IkReal)1/(((((cj2)*(x2792)))+(((cj2)*(x2793)))))):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(x2798)*(x2799)))+(((r10)*(sj1)*(x2795)))+(((cj1)*(x2797)))+(((cj1)*(r00)*(x2795)))+(((sj1)*(x2794)))+(((IkReal(-1.00000000000000))*(x2796)*(x2800)))))))+IKsqr(((((IKabs(((x2792)+(x2793))) != 0)?((IkReal)1/(((x2792)+(x2793)))):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(x2796)*(x2797)))+(((cj1)*(x2794)))+(((sj1)*(x2799)))+(((cj1)*(r10)*(x2795)))+(((IkReal(-1.00000000000000))*(x2798)*(x2800)))+(((IkReal(-1.00000000000000))*(r00)*(x2795)*(x2796)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IKabs(((((cj2)*(x2792)))+(((cj2)*(x2793))))) != 0)?((IkReal)1/(((((cj2)*(x2792)))+(((cj2)*(x2793)))))):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(x2798)*(x2799)))+(((r10)*(sj1)*(x2795)))+(((cj1)*(x2797)))+(((cj1)*(r00)*(x2795)))+(((sj1)*(x2794)))+(((IkReal(-1.00000000000000))*(x2796)*(x2800)))))), ((((IKabs(((x2792)+(x2793))) != 0)?((IkReal)1/(((x2792)+(x2793)))):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(x2796)*(x2797)))+(((cj1)*(x2794)))+(((sj1)*(x2799)))+(((cj1)*(r10)*(x2795)))+(((IkReal(-1.00000000000000))*(x2798)*(x2800)))+(((IkReal(-1.00000000000000))*(r00)*(x2795)*(x2796)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x2801=IKsin(j3);
IkReal x2802=IKcos(j3);
IkReal x2803=((r11)*(sj6));
IkReal x2804=((IkReal(1.00000000000000))*(sj5));
IkReal x2805=((sj4)*(sj6));
IkReal x2806=((cj4)*(sj5));
IkReal x2807=((cj6)*(sj4));
IkReal x2808=((cj4)*(cj5));
IkReal x2809=((r01)*(sj6));
IkReal x2810=((r21)*(sj6));
IkReal x2811=((cj6)*(sj5));
IkReal x2812=((IkReal(1.00000000000000))*(x2802));
IkReal x2813=((sj1)*(x2802));
IkReal x2814=((IkReal(1.00000000000000))*(cj6)*(x2808));
IkReal x2815=((IkReal(1.00000000000000))*(cj2)*(x2801));
evalcond[0]=((((IkReal(-1.00000000000000))*(x2804)*(x2810)))+(((cj5)*(r22)))+(((sj2)*(x2801)))+(((r20)*(x2811))));
evalcond[1]=((((r00)*(x2811)))+(((IkReal(-1.00000000000000))*(cj1)*(x2815)))+(((IkReal(-1.00000000000000))*(x2804)*(x2809)))+(x2813)+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((r10)*(x2811)))+(((IkReal(-1.00000000000000))*(cj1)*(x2812)))+(((IkReal(-1.00000000000000))*(x2803)*(x2804)))+(((IkReal(-1.00000000000000))*(sj1)*(x2815))));
evalcond[3]=((((r20)*(x2805)))+(((IkReal(-1.00000000000000))*(sj2)*(x2812)))+(((IkReal(-1.00000000000000))*(r20)*(x2814)))+(((r21)*(x2807)))+(((r22)*(x2806)))+(((x2808)*(x2810))));
evalcond[4]=((((sj1)*(x2801)))+(((x2808)*(x2809)))+(((r02)*(x2806)))+(((cj1)*(cj2)*(x2802)))+(((IkReal(-1.00000000000000))*(r00)*(x2814)))+(((r01)*(x2807)))+(((r00)*(x2805))));
evalcond[5]=((((r12)*(x2806)))+(((r10)*(x2805)))+(((IkReal(-1.00000000000000))*(cj1)*(x2801)))+(((x2803)*(x2808)))+(((cj2)*(x2813)))+(((r11)*(x2807)))+(((IkReal(-1.00000000000000))*(r10)*(x2814))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2816=((cj4)*(cj5));
IkReal x2817=((r21)*(sj6));
IkReal x2818=((IkReal(1.00000000000000))*(cj6)*(r20));
if( IKabs(((gconst4)*(((((IkReal(-1.00000000000000))*(sj5)*(x2818)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x2817))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst4)*(((((cj4)*(r22)*(sj5)))+(((cj6)*(r21)*(sj4)))+(((r20)*(sj4)*(sj6)))+(((x2816)*(x2817)))+(((IkReal(-1.00000000000000))*(x2816)*(x2818))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst4)*(((((IkReal(-1.00000000000000))*(sj5)*(x2818)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x2817)))))), ((gconst4)*(((((cj4)*(r22)*(sj5)))+(((cj6)*(r21)*(sj4)))+(((r20)*(sj4)*(sj6)))+(((x2816)*(x2817)))+(((IkReal(-1.00000000000000))*(x2816)*(x2818)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x2819=IKsin(j3);
IkReal x2820=IKcos(j3);
IkReal x2821=((r11)*(sj6));
IkReal x2822=((IkReal(1.00000000000000))*(sj5));
IkReal x2823=((sj4)*(sj6));
IkReal x2824=((cj4)*(sj5));
IkReal x2825=((cj6)*(sj4));
IkReal x2826=((cj4)*(cj5));
IkReal x2827=((r01)*(sj6));
IkReal x2828=((r21)*(sj6));
IkReal x2829=((cj6)*(sj5));
IkReal x2830=((IkReal(1.00000000000000))*(x2820));
IkReal x2831=((sj1)*(x2820));
IkReal x2832=((IkReal(1.00000000000000))*(cj6)*(x2826));
IkReal x2833=((IkReal(1.00000000000000))*(cj2)*(x2819));
evalcond[0]=((((cj5)*(r22)))+(((sj2)*(x2819)))+(((r20)*(x2829)))+(((IkReal(-1.00000000000000))*(x2822)*(x2828))));
evalcond[1]=((((IkReal(-1.00000000000000))*(cj1)*(x2833)))+(((IkReal(-1.00000000000000))*(x2822)*(x2827)))+(((r00)*(x2829)))+(x2831)+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(cj1)*(x2830)))+(((IkReal(-1.00000000000000))*(sj1)*(x2833)))+(((r10)*(x2829)))+(((IkReal(-1.00000000000000))*(x2821)*(x2822))));
evalcond[3]=((((IkReal(-1.00000000000000))*(sj2)*(x2830)))+(((r20)*(x2823)))+(((IkReal(-1.00000000000000))*(r20)*(x2832)))+(((r21)*(x2825)))+(((r22)*(x2824)))+(((x2826)*(x2828))));
evalcond[4]=((((r02)*(x2824)))+(((IkReal(-1.00000000000000))*(r00)*(x2832)))+(((cj1)*(cj2)*(x2820)))+(((r00)*(x2823)))+(((sj1)*(x2819)))+(((r01)*(x2825)))+(((x2826)*(x2827))));
evalcond[5]=((((x2821)*(x2826)))+(((r10)*(x2823)))+(((IkReal(-1.00000000000000))*(r10)*(x2832)))+(((r11)*(x2825)))+(((IkReal(-1.00000000000000))*(cj1)*(x2819)))+(((cj2)*(x2831)))+(((r12)*(x2824))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x2834=((IkReal(0.250000000000000))*(cj6));
IkReal x2835=((IkReal(0.250000000000000))*(sj6));
IkReal x2836=((IkReal(195.000000000000))*(sj5));
IkReal x2837=((IkReal(195.000000000000))*(cj5));
if( IKabs(((((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(r01)*(sj6)*(x2836)))+(((r02)*(x2837)))+(((IkReal(-500.000000000000))*(px)))+(((IkReal(-200.000000000000))*(sj1)))+(((r00)*(x2835)))+(((r01)*(x2834)))+(((cj6)*(r00)*(x2836))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((cj6)*(r20)*(x2836)))+(((IkReal(-500.000000000000))*(pz)))+(((IkReal(-1.00000000000000))*(r21)*(sj6)*(x2836)))+(((r20)*(x2835)))+(((r22)*(x2837)))+(((r21)*(x2834))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(r01)*(sj6)*(x2836)))+(((r02)*(x2837)))+(((IkReal(-500.000000000000))*(px)))+(((IkReal(-200.000000000000))*(sj1)))+(((r00)*(x2835)))+(((r01)*(x2834)))+(((cj6)*(r00)*(x2836)))))))+IKsqr(((((cj6)*(r20)*(x2836)))+(((IkReal(-500.000000000000))*(pz)))+(((IkReal(-1.00000000000000))*(r21)*(sj6)*(x2836)))+(((r20)*(x2835)))+(((r22)*(x2837)))+(((r21)*(x2834)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j2array[0]=IKatan2(((((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(r01)*(sj6)*(x2836)))+(((r02)*(x2837)))+(((IkReal(-500.000000000000))*(px)))+(((IkReal(-200.000000000000))*(sj1)))+(((r00)*(x2835)))+(((r01)*(x2834)))+(((cj6)*(r00)*(x2836)))))), ((((cj6)*(r20)*(x2836)))+(((IkReal(-500.000000000000))*(pz)))+(((IkReal(-1.00000000000000))*(r21)*(sj6)*(x2836)))+(((r20)*(x2835)))+(((r22)*(x2837)))+(((r21)*(x2834)))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[3];
IkReal x2838=IKsin(j2);
IkReal x2839=((IkReal(0.390000000000000))*(sj5));
IkReal x2840=((IkReal(0.390000000000000))*(cj5));
IkReal x2841=((IkReal(0.000500000000000000))*(cj6));
IkReal x2842=((IkReal(0.000500000000000000))*(sj6));
IkReal x2843=((IkReal(0.00200000000000000))*(x2838));
evalcond[0]=((((cj6)*(r20)*(x2839)))+(((r21)*(x2841)))+(((r20)*(x2842)))+(((IkReal(-0.00200000000000000))*(IKcos(j2))))+(((IkReal(-1.00000000000000))*(r21)*(sj6)*(x2839)))+(((IkReal(-1.00000000000000))*(pz)))+(((r22)*(x2840))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r01)*(sj6)*(x2839)))+(((IkReal(-1.00000000000000))*(px)))+(((r00)*(x2842)))+(((r01)*(x2841)))+(((IkReal(-0.400000000000000))*(sj1)))+(((cj6)*(r00)*(x2839)))+(((r02)*(x2840)))+(((IkReal(-1.00000000000000))*(cj1)*(x2843))));
evalcond[2]=((((IkReal(-1.00000000000000))*(sj1)*(x2843)))+(((r11)*(x2841)))+(((IkReal(0.400000000000000))*(cj1)))+(((r12)*(x2840)))+(((cj6)*(r10)*(x2839)))+(((IkReal(-1.00000000000000))*(py)))+(((r10)*(x2842)))+(((IkReal(-1.00000000000000))*(r11)*(sj6)*(x2839))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst0;
IkReal x2844=(sj6)*(sj6);
IkReal x2845=(cj6)*(cj6);
IkReal x2846=((IkReal(1.00000000000000))*(r20));
IkReal x2847=((r00)*(r21));
IkReal x2848=((r22)*(sj5));
IkReal x2849=((r02)*(sj5));
IkReal x2850=((cj5)*(x2844));
IkReal x2851=((cj5)*(x2845));
gconst0=IKsign(((((IkReal(-1.00000000000000))*(sj6)*(x2846)*(x2849)))+(((x2847)*(x2850)))+(((x2847)*(x2851)))+(((r00)*(sj6)*(x2848)))+(((IkReal(-1.00000000000000))*(r01)*(x2846)*(x2851)))+(((IkReal(-1.00000000000000))*(r01)*(x2846)*(x2850)))+(((cj6)*(r01)*(x2848)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x2849)))));
IkReal x2852=(sj6)*(sj6);
IkReal x2853=(cj6)*(cj6);
IkReal x2854=((IkReal(1.00000000000000))*(r20));
IkReal x2855=((r00)*(r21));
IkReal x2856=((r22)*(sj5));
IkReal x2857=((r02)*(sj5));
IkReal x2858=((cj5)*(x2852));
IkReal x2859=((cj5)*(x2853));
dummyeval[0]=((((x2855)*(x2859)))+(((x2855)*(x2858)))+(((IkReal(-1.00000000000000))*(sj6)*(x2854)*(x2857)))+(((IkReal(-1.00000000000000))*(r01)*(x2854)*(x2859)))+(((IkReal(-1.00000000000000))*(r01)*(x2854)*(x2858)))+(((r00)*(sj6)*(x2856)))+(((cj6)*(r01)*(x2856)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x2857))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst1;
IkReal x2860=(sj6)*(sj6);
IkReal x2861=(cj6)*(cj6);
IkReal x2862=((cj6)*(sj5));
IkReal x2863=((r10)*(r21));
IkReal x2864=((IkReal(1.00000000000000))*(r12));
IkReal x2865=((sj5)*(sj6));
IkReal x2866=((cj5)*(x2861));
IkReal x2867=((IkReal(1.00000000000000))*(r11)*(r20));
IkReal x2868=((cj5)*(x2860));
gconst1=IKsign(((((IkReal(-1.00000000000000))*(r21)*(x2862)*(x2864)))+(((r11)*(r22)*(x2862)))+(((x2863)*(x2866)))+(((x2863)*(x2868)))+(((r10)*(r22)*(x2865)))+(((IkReal(-1.00000000000000))*(x2867)*(x2868)))+(((IkReal(-1.00000000000000))*(r20)*(x2864)*(x2865)))+(((IkReal(-1.00000000000000))*(x2866)*(x2867)))));
IkReal x2869=(sj6)*(sj6);
IkReal x2870=(cj6)*(cj6);
IkReal x2871=((cj6)*(sj5));
IkReal x2872=((r10)*(r21));
IkReal x2873=((IkReal(1.00000000000000))*(r12));
IkReal x2874=((sj5)*(sj6));
IkReal x2875=((cj5)*(x2870));
IkReal x2876=((IkReal(1.00000000000000))*(r11)*(r20));
IkReal x2877=((cj5)*(x2869));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x2876)*(x2877)))+(((IkReal(-1.00000000000000))*(r21)*(x2871)*(x2873)))+(((x2872)*(x2877)))+(((x2872)*(x2875)))+(((IkReal(-1.00000000000000))*(r20)*(x2873)*(x2874)))+(((r10)*(r22)*(x2874)))+(((IkReal(-1.00000000000000))*(x2875)*(x2876)))+(((r11)*(r22)*(x2871))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[2];
IkReal x2878=(sj1)*(sj1);
IkReal x2879=(cj1)*(cj1);
dummyeval[0]=((((cj2)*(x2879)))+(((cj2)*(x2878))));
dummyeval[1]=((x2879)+(x2878));
if( IKabs(dummyeval[0]) < 0.0000010000000000  || IKabs(dummyeval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[4];
IkReal x2880=((IkReal(0.390000000000000))*(sj5));
IkReal x2881=((IkReal(0.390000000000000))*(cj5));
IkReal x2882=((IkReal(0.000500000000000000))*(cj6));
IkReal x2883=((IkReal(0.000500000000000000))*(sj6));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((r20)*(x2883)))+(((r22)*(x2881)))+(((r21)*(x2882)))+(((cj6)*(r20)*(x2880)))+(((IkReal(-1.00000000000000))*(pz)))+(((IkReal(-1.00000000000000))*(r21)*(sj6)*(x2880))));
evalcond[2]=((((cj6)*(r00)*(x2880)))+(((r00)*(x2883)))+(((IkReal(-1.00000000000000))*(r01)*(sj6)*(x2880)))+(((r01)*(x2882)))+(((IkReal(-1.00000000000000))*(px)))+(((r02)*(x2881)))+(((IkReal(-0.00200000000000000))*(cj1)))+(((IkReal(-0.400000000000000))*(sj1))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r11)*(sj6)*(x2880)))+(((IkReal(0.400000000000000))*(cj1)))+(((r11)*(x2882)))+(((IkReal(-1.00000000000000))*(py)))+(((IkReal(-0.00200000000000000))*(sj1)))+(((r10)*(x2883)))+(((r12)*(x2881)))+(((cj6)*(r10)*(x2880))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst9;
IkReal x2884=(sj6)*(sj6);
IkReal x2885=(cj6)*(cj6);
IkReal x2886=((IkReal(1.00000000000000))*(r20));
IkReal x2887=((r00)*(r21));
IkReal x2888=((r22)*(sj5));
IkReal x2889=((r02)*(sj5));
IkReal x2890=((cj5)*(x2884));
IkReal x2891=((cj5)*(x2885));
gconst9=IKsign(((((IkReal(-1.00000000000000))*(cj6)*(r21)*(x2889)))+(((cj6)*(r01)*(x2888)))+(((x2887)*(x2891)))+(((x2887)*(x2890)))+(((IkReal(-1.00000000000000))*(r01)*(x2886)*(x2891)))+(((IkReal(-1.00000000000000))*(r01)*(x2886)*(x2890)))+(((r00)*(sj6)*(x2888)))+(((IkReal(-1.00000000000000))*(sj6)*(x2886)*(x2889)))));
IkReal x2892=(sj6)*(sj6);
IkReal x2893=(cj6)*(cj6);
IkReal x2894=((IkReal(1.00000000000000))*(r20));
IkReal x2895=((r00)*(r21));
IkReal x2896=((r22)*(sj5));
IkReal x2897=((r02)*(sj5));
IkReal x2898=((cj5)*(x2892));
IkReal x2899=((cj5)*(x2893));
dummyeval[0]=((((IkReal(-1.00000000000000))*(cj6)*(r21)*(x2897)))+(((IkReal(-1.00000000000000))*(sj6)*(x2894)*(x2897)))+(((x2895)*(x2898)))+(((x2895)*(x2899)))+(((cj6)*(r01)*(x2896)))+(((IkReal(-1.00000000000000))*(r01)*(x2894)*(x2898)))+(((IkReal(-1.00000000000000))*(r01)*(x2894)*(x2899)))+(((r00)*(sj6)*(x2896))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst10;
IkReal x2900=(sj6)*(sj6);
IkReal x2901=(cj6)*(cj6);
IkReal x2902=((cj6)*(sj5));
IkReal x2903=((r10)*(r21));
IkReal x2904=((IkReal(1.00000000000000))*(r12));
IkReal x2905=((sj5)*(sj6));
IkReal x2906=((cj5)*(x2901));
IkReal x2907=((IkReal(1.00000000000000))*(r11)*(r20));
IkReal x2908=((cj5)*(x2900));
gconst10=IKsign(((((r10)*(r22)*(x2905)))+(((IkReal(-1.00000000000000))*(x2906)*(x2907)))+(((IkReal(-1.00000000000000))*(r21)*(x2902)*(x2904)))+(((x2903)*(x2906)))+(((x2903)*(x2908)))+(((IkReal(-1.00000000000000))*(x2907)*(x2908)))+(((IkReal(-1.00000000000000))*(r20)*(x2904)*(x2905)))+(((r11)*(r22)*(x2902)))));
IkReal x2909=(sj6)*(sj6);
IkReal x2910=(cj6)*(cj6);
IkReal x2911=((cj6)*(sj5));
IkReal x2912=((r10)*(r21));
IkReal x2913=((IkReal(1.00000000000000))*(r12));
IkReal x2914=((sj5)*(sj6));
IkReal x2915=((cj5)*(x2910));
IkReal x2916=((IkReal(1.00000000000000))*(r11)*(r20));
IkReal x2917=((cj5)*(x2909));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x2915)*(x2916)))+(((r10)*(r22)*(x2914)))+(((r11)*(r22)*(x2911)))+(((IkReal(-1.00000000000000))*(r20)*(x2913)*(x2914)))+(((IkReal(-1.00000000000000))*(r21)*(x2911)*(x2913)))+(((x2912)*(x2917)))+(((x2912)*(x2915)))+(((IkReal(-1.00000000000000))*(x2916)*(x2917))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=cj1;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
IkReal x2918=((IkReal(0.000500000000000000))*(cj6));
IkReal x2919=((IkReal(0.000500000000000000))*(sj6));
IkReal x2920=((sj5)*(sj6));
IkReal x2921=((cj5)*(r12));
IkReal x2922=((IkReal(0.390000000000000))*(cj5));
IkReal x2923=((IkReal(0.390000000000000))*(cj6)*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((((cj6)*(r10)*(sj5)))+(((IkReal(-1.00000000000000))*(r11)*(x2920)))+(x2921));
evalcond[2]=((((r22)*(x2922)))+(((r20)*(x2919)))+(((IkReal(-0.390000000000000))*(r21)*(x2920)))+(((IkReal(-1.00000000000000))*(pz)))+(((r20)*(x2923)))+(((r21)*(x2918))));
evalcond[3]=((IkReal(-0.400000000000000))+(((r01)*(x2918)))+(((r00)*(x2919)))+(((r00)*(x2923)))+(((IkReal(-1.00000000000000))*(px)))+(((IkReal(-0.390000000000000))*(r01)*(x2920)))+(((r02)*(x2922))));
evalcond[4]=((IkReal(-0.00200000000000000))+(((r11)*(x2918)))+(((IkReal(0.390000000000000))*(x2921)))+(((IkReal(-0.390000000000000))*(r11)*(x2920)))+(((r10)*(x2923)))+(((IkReal(-1.00000000000000))*(py)))+(((r10)*(x2919))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x2924=((sj5)*(sj6));
IkReal x2925=((IkReal(1.00000000000000))*(cj5));
IkReal x2926=((IkReal(1.00000000000000))*(cj6)*(sj5));
if( IKabs(((((IkReal(-1.00000000000000))*(r20)*(x2926)))+(((r21)*(x2924)))+(((IkReal(-1.00000000000000))*(r22)*(x2925))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r02)*(x2925)))+(((r01)*(x2924)))+(((IkReal(-1.00000000000000))*(r00)*(x2926))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(r20)*(x2926)))+(((r21)*(x2924)))+(((IkReal(-1.00000000000000))*(r22)*(x2925)))))+IKsqr(((((IkReal(-1.00000000000000))*(r02)*(x2925)))+(((r01)*(x2924)))+(((IkReal(-1.00000000000000))*(r00)*(x2926)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(r20)*(x2926)))+(((r21)*(x2924)))+(((IkReal(-1.00000000000000))*(r22)*(x2925)))), ((((IkReal(-1.00000000000000))*(r02)*(x2925)))+(((r01)*(x2924)))+(((IkReal(-1.00000000000000))*(r00)*(x2926)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x2927=((cj6)*(sj5));
IkReal x2928=((IkReal(1.00000000000000))*(sj5)*(sj6));
evalcond[0]=((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(r21)*(x2928)))+(IKsin(j3))+(((r20)*(x2927))));
evalcond[1]=((((r00)*(x2927)))+(IKcos(j3))+(((IkReal(-1.00000000000000))*(r01)*(x2928)))+(((cj5)*(r02))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst15;
IkReal x2929=(sj6)*(sj6);
IkReal x2930=(cj6)*(cj6);
IkReal x2931=((r01)*(r10));
IkReal x2932=((IkReal(1.00000000000000))*(r00));
IkReal x2933=((r02)*(sj5));
IkReal x2934=((r12)*(sj5));
IkReal x2935=((cj5)*(x2929));
IkReal x2936=((cj5)*(x2930));
gconst15=IKsign(((((IkReal(-1.00000000000000))*(cj6)*(r01)*(x2934)))+(((r10)*(sj6)*(x2933)))+(((IkReal(-1.00000000000000))*(sj6)*(x2932)*(x2934)))+(((cj6)*(r11)*(x2933)))+(((IkReal(-1.00000000000000))*(r11)*(x2932)*(x2935)))+(((IkReal(-1.00000000000000))*(r11)*(x2932)*(x2936)))+(((x2931)*(x2936)))+(((x2931)*(x2935)))));
IkReal x2937=(sj6)*(sj6);
IkReal x2938=(cj6)*(cj6);
IkReal x2939=((r01)*(r10));
IkReal x2940=((IkReal(1.00000000000000))*(r00));
IkReal x2941=((r02)*(sj5));
IkReal x2942=((r12)*(sj5));
IkReal x2943=((cj5)*(x2937));
IkReal x2944=((cj5)*(x2938));
dummyeval[0]=((((x2939)*(x2943)))+(((x2939)*(x2944)))+(((r10)*(sj6)*(x2941)))+(((cj6)*(r11)*(x2941)))+(((IkReal(-1.00000000000000))*(r11)*(x2940)*(x2943)))+(((IkReal(-1.00000000000000))*(r11)*(x2940)*(x2944)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x2942)))+(((IkReal(-1.00000000000000))*(sj6)*(x2940)*(x2942))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst16;
IkReal x2945=(cj5)*(cj5);
IkReal x2946=(sj6)*(sj6);
IkReal x2947=(cj6)*(cj6);
IkReal x2948=((r00)*(r20));
IkReal x2949=((cj5)*(sj5));
IkReal x2950=((r01)*(r21));
IkReal x2951=((r21)*(sj6));
IkReal x2952=((sj6)*(x2949));
IkReal x2953=((IkReal(1.00000000000000))*(cj6)*(r00));
IkReal x2954=((cj6)*(r01)*(r20)*(sj6));
gconst16=IKsign(((((IkReal(-1.00000000000000))*(x2945)*(x2951)*(x2953)))+(((x2946)*(x2948)))+(((IkReal(-1.00000000000000))*(cj6)*(r02)*(r20)*(x2949)))+(((x2947)*(x2950)))+(((x2945)*(x2947)*(x2948)))+(((r02)*(x2949)*(x2951)))+(((IkReal(-1.00000000000000))*(x2945)*(x2954)))+(((r01)*(r22)*(x2952)))+(((IkReal(-1.00000000000000))*(r22)*(x2949)*(x2953)))+(((x2945)*(x2946)*(x2950)))+(((r02)*(r22)*((sj5)*(sj5))))+(((cj6)*(r00)*(x2951)))+(x2954)));
IkReal x2955=(cj5)*(cj5);
IkReal x2956=(sj6)*(sj6);
IkReal x2957=(cj6)*(cj6);
IkReal x2958=((r00)*(r20));
IkReal x2959=((cj5)*(sj5));
IkReal x2960=((r01)*(r21));
IkReal x2961=((r21)*(sj6));
IkReal x2962=((sj6)*(x2959));
IkReal x2963=((IkReal(1.00000000000000))*(cj6)*(r00));
IkReal x2964=x2954;
dummyeval[0]=((((cj6)*(r00)*(x2961)))+(((x2955)*(x2957)*(x2958)))+(((r02)*(x2959)*(x2961)))+(((r01)*(r22)*(x2962)))+(((IkReal(-1.00000000000000))*(cj6)*(r02)*(r20)*(x2959)))+(((x2957)*(x2960)))+(((r02)*(r22)*((sj5)*(sj5))))+(((x2955)*(x2956)*(x2960)))+(((IkReal(-1.00000000000000))*(r22)*(x2959)*(x2963)))+(((IkReal(-1.00000000000000))*(x2955)*(x2961)*(x2963)))+(x2964)+(((x2956)*(x2958)))+(((IkReal(-1.00000000000000))*(x2955)*(x2964))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x2965=((IkReal(1.00000000000000))*(sj3));
if( IKabs(((gconst16)*(((((IkReal(-1.00000000000000))*(cj6)*(r21)*(x2965)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x2965))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst16)*(((((IkReal(-1.00000000000000))*(cj5)*(r21)*(sj6)*(x2965)))+(((cj5)*(cj6)*(r20)*(sj3)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x2965))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst16)*(((((IkReal(-1.00000000000000))*(cj6)*(r21)*(x2965)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x2965)))))), ((gconst16)*(((((IkReal(-1.00000000000000))*(cj5)*(r21)*(sj6)*(x2965)))+(((cj5)*(cj6)*(r20)*(sj3)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x2965)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x2966=IKsin(j4);
IkReal x2967=IKcos(j4);
IkReal x2968=((IkReal(1.00000000000000))*(r00));
IkReal x2969=((cj5)*(r01));
IkReal x2970=((cj5)*(r11));
IkReal x2971=((IkReal(1.00000000000000))*(cj5));
IkReal x2972=((cj5)*(r21));
IkReal x2973=((sj5)*(x2966));
IkReal x2974=((cj6)*(x2966));
IkReal x2975=((sj6)*(x2967));
IkReal x2976=((sj6)*(x2966));
IkReal x2977=((sj5)*(x2967));
IkReal x2978=((cj6)*(x2967));
evalcond[0]=((((IkReal(-1.00000000000000))*(r21)*(x2978)))+(((IkReal(-1.00000000000000))*(r20)*(x2971)*(x2974)))+(((r22)*(x2973)))+(((IkReal(-1.00000000000000))*(r20)*(x2975)))+(((x2972)*(x2976))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r20)*(x2971)*(x2978)))+(((r22)*(x2977)))+(((r20)*(x2976)))+(((IkReal(-1.00000000000000))*(cj3)))+(((x2972)*(x2975)))+(((r21)*(x2974))));
evalcond[2]=((((r02)*(x2973)))+(((IkReal(-1.00000000000000))*(x2968)*(x2975)))+(((x2969)*(x2976)))+(((IkReal(-1.00000000000000))*(r01)*(x2978)))+(((IkReal(-1.00000000000000))*(cj5)*(x2968)*(x2974))));
evalcond[3]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(r11)*(x2978)))+(((x2970)*(x2976)))+(((r12)*(x2973)))+(((IkReal(-1.00000000000000))*(r10)*(x2975)))+(((IkReal(-1.00000000000000))*(r10)*(x2971)*(x2974))));
evalcond[4]=((sj3)+(((r02)*(x2977)))+(((r01)*(x2974)))+(((x2969)*(x2975)))+(((r00)*(x2976)))+(((IkReal(-1.00000000000000))*(cj5)*(x2968)*(x2978))));
evalcond[5]=((((x2970)*(x2975)))+(((r10)*(x2976)))+(((r12)*(x2977)))+(((r11)*(x2974)))+(((IkReal(-1.00000000000000))*(r10)*(x2971)*(x2978))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x2979=((cj5)*(sj3));
IkReal x2980=((IkReal(1.00000000000000))*(r10));
if( IKabs(((gconst15)*(((((r12)*(sj3)*(sj5)))+(((r11)*(sj6)*(x2979)))+(((IkReal(-1.00000000000000))*(cj6)*(x2979)*(x2980))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst15)*(((((IkReal(-1.00000000000000))*(cj6)*(r11)*(sj3)))+(((IkReal(-1.00000000000000))*(sj3)*(sj6)*(x2980))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst15)*(((((r12)*(sj3)*(sj5)))+(((r11)*(sj6)*(x2979)))+(((IkReal(-1.00000000000000))*(cj6)*(x2979)*(x2980)))))), ((gconst15)*(((((IkReal(-1.00000000000000))*(cj6)*(r11)*(sj3)))+(((IkReal(-1.00000000000000))*(sj3)*(sj6)*(x2980)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x2981=IKsin(j4);
IkReal x2982=IKcos(j4);
IkReal x2983=((IkReal(1.00000000000000))*(r00));
IkReal x2984=((cj5)*(r01));
IkReal x2985=((cj5)*(r11));
IkReal x2986=((IkReal(1.00000000000000))*(cj5));
IkReal x2987=((cj5)*(r21));
IkReal x2988=((sj5)*(x2981));
IkReal x2989=((cj6)*(x2981));
IkReal x2990=((sj6)*(x2982));
IkReal x2991=((sj6)*(x2981));
IkReal x2992=((sj5)*(x2982));
IkReal x2993=((cj6)*(x2982));
evalcond[0]=((((IkReal(-1.00000000000000))*(r20)*(x2986)*(x2989)))+(((x2987)*(x2991)))+(((IkReal(-1.00000000000000))*(r21)*(x2993)))+(((IkReal(-1.00000000000000))*(r20)*(x2990)))+(((r22)*(x2988))));
evalcond[1]=((((x2987)*(x2990)))+(((r20)*(x2991)))+(((IkReal(-1.00000000000000))*(r20)*(x2986)*(x2993)))+(((r22)*(x2992)))+(((IkReal(-1.00000000000000))*(cj3)))+(((r21)*(x2989))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x2983)*(x2990)))+(((x2984)*(x2991)))+(((r02)*(x2988)))+(((IkReal(-1.00000000000000))*(cj5)*(x2983)*(x2989)))+(((IkReal(-1.00000000000000))*(r01)*(x2993))));
evalcond[3]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(r10)*(x2986)*(x2989)))+(((x2985)*(x2991)))+(((IkReal(-1.00000000000000))*(r10)*(x2990)))+(((r12)*(x2988)))+(((IkReal(-1.00000000000000))*(r11)*(x2993))));
evalcond[4]=((sj3)+(((r00)*(x2991)))+(((r01)*(x2989)))+(((IkReal(-1.00000000000000))*(cj5)*(x2983)*(x2993)))+(((r02)*(x2992)))+(((x2984)*(x2990))));
evalcond[5]=((((r11)*(x2989)))+(((r12)*(x2992)))+(((x2985)*(x2990)))+(((IkReal(-1.00000000000000))*(r10)*(x2986)*(x2993)))+(((r10)*(x2991))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
IkReal x2994=((IkReal(0.000500000000000000))*(cj6));
IkReal x2995=((IkReal(0.000500000000000000))*(sj6));
IkReal x2996=((sj5)*(sj6));
IkReal x2997=((cj5)*(r12));
IkReal x2998=((IkReal(0.390000000000000))*(cj5));
IkReal x2999=((IkReal(0.390000000000000))*(cj6)*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((((cj6)*(r10)*(sj5)))+(((IkReal(-1.00000000000000))*(r11)*(x2996)))+(x2997));
evalcond[2]=((((IkReal(-0.390000000000000))*(r21)*(x2996)))+(((r20)*(x2999)))+(((r20)*(x2995)))+(((IkReal(-1.00000000000000))*(pz)))+(((r21)*(x2994)))+(((r22)*(x2998))));
evalcond[3]=((IkReal(0.400000000000000))+(((IkReal(-0.390000000000000))*(r01)*(x2996)))+(((r00)*(x2995)))+(((r00)*(x2999)))+(((r01)*(x2994)))+(((IkReal(-1.00000000000000))*(px)))+(((r02)*(x2998))));
evalcond[4]=((IkReal(0.00200000000000000))+(((IkReal(0.390000000000000))*(x2997)))+(((IkReal(-0.390000000000000))*(r11)*(x2996)))+(((IkReal(-1.00000000000000))*(py)))+(((r10)*(x2995)))+(((r10)*(x2999)))+(((r11)*(x2994))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3000=((IkReal(1.00000000000000))*(sj5));
if( IKabs(((((r21)*(sj5)*(sj6)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(x3000))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r01)*(sj6)*(x3000)))+(((cj6)*(r00)*(sj5)))+(((cj5)*(r02))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((r21)*(sj5)*(sj6)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(x3000)))))+IKsqr(((((IkReal(-1.00000000000000))*(r01)*(sj6)*(x3000)))+(((cj6)*(r00)*(sj5)))+(((cj5)*(r02)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((r21)*(sj5)*(sj6)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(cj6)*(r20)*(x3000)))), ((((IkReal(-1.00000000000000))*(r01)*(sj6)*(x3000)))+(((cj6)*(r00)*(sj5)))+(((cj5)*(r02)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x3001=((cj6)*(sj5));
IkReal x3002=((IkReal(1.00000000000000))*(sj5)*(sj6));
evalcond[0]=((((cj5)*(r22)))+(IKsin(j3))+(((r20)*(x3001)))+(((IkReal(-1.00000000000000))*(r21)*(x3002))));
evalcond[1]=((((r00)*(x3001)))+(((IkReal(-1.00000000000000))*(r01)*(x3002)))+(((IkReal(-1.00000000000000))*(IKcos(j3))))+(((cj5)*(r02))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst19;
IkReal x3003=(cj6)*(cj6);
IkReal x3004=(sj6)*(sj6);
IkReal x3005=((r11)*(r20));
IkReal x3006=((r12)*(sj5));
IkReal x3007=((IkReal(1.00000000000000))*(r10));
IkReal x3008=((r22)*(sj5));
IkReal x3009=((cj5)*(x3004));
IkReal x3010=((cj5)*(x3003));
gconst19=IKsign(((((IkReal(-1.00000000000000))*(r21)*(x3007)*(x3010)))+(((cj6)*(r21)*(x3006)))+(((IkReal(-1.00000000000000))*(r21)*(x3007)*(x3009)))+(((IkReal(-1.00000000000000))*(sj6)*(x3007)*(x3008)))+(((x3005)*(x3009)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x3008)))+(((x3005)*(x3010)))+(((r20)*(sj6)*(x3006)))));
IkReal x3011=(cj6)*(cj6);
IkReal x3012=(sj6)*(sj6);
IkReal x3013=((r11)*(r20));
IkReal x3014=((r12)*(sj5));
IkReal x3015=((IkReal(1.00000000000000))*(r10));
IkReal x3016=((r22)*(sj5));
IkReal x3017=((cj5)*(x3012));
IkReal x3018=((cj5)*(x3011));
dummyeval[0]=((((cj6)*(r21)*(x3014)))+(((IkReal(-1.00000000000000))*(sj6)*(x3015)*(x3016)))+(((x3013)*(x3017)))+(((x3013)*(x3018)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x3016)))+(((IkReal(-1.00000000000000))*(r21)*(x3015)*(x3017)))+(((IkReal(-1.00000000000000))*(r21)*(x3015)*(x3018)))+(((r20)*(sj6)*(x3014))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst20;
IkReal x3019=(cj5)*(cj5);
IkReal x3020=(r11)*(r11);
IkReal x3021=(sj6)*(sj6);
IkReal x3022=(cj6)*(cj6);
IkReal x3023=(r10)*(r10);
IkReal x3024=((r11)*(sj6));
IkReal x3025=((IkReal(1.00000000000000))*(x3021));
IkReal x3026=((IkReal(1.00000000000000))*(x3022));
IkReal x3027=((IkReal(2.00000000000000))*(cj6)*(r10));
IkReal x3028=((cj5)*(r12)*(sj5));
gconst20=IKsign(((((IkReal(-1.00000000000000))*(x3019)*(x3020)*(x3025)))+(((IkReal(-1.00000000000000))*(x3019)*(x3023)*(x3026)))+(((x3019)*(x3024)*(x3027)))+(((x3027)*(x3028)))+(((IkReal(-1.00000000000000))*((r12)*(r12))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x3020)*(x3026)))+(((IkReal(-2.00000000000000))*(x3024)*(x3028)))+(((IkReal(-1.00000000000000))*(x3024)*(x3027)))+(((IkReal(-1.00000000000000))*(x3023)*(x3025)))));
IkReal x3029=(cj5)*(cj5);
IkReal x3030=(r11)*(r11);
IkReal x3031=(sj6)*(sj6);
IkReal x3032=(cj6)*(cj6);
IkReal x3033=(r10)*(r10);
IkReal x3034=((r11)*(sj6));
IkReal x3035=((IkReal(1.00000000000000))*(x3031));
IkReal x3036=((IkReal(1.00000000000000))*(x3032));
IkReal x3037=((IkReal(2.00000000000000))*(cj6)*(r10));
IkReal x3038=((cj5)*(r12)*(sj5));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x3030)*(x3036)))+(((IkReal(-1.00000000000000))*((r12)*(r12))*((sj5)*(sj5))))+(((x3037)*(x3038)))+(((IkReal(-1.00000000000000))*(x3029)*(x3030)*(x3035)))+(((x3029)*(x3034)*(x3037)))+(((IkReal(-1.00000000000000))*(x3033)*(x3035)))+(((IkReal(-1.00000000000000))*(x3034)*(x3037)))+(((IkReal(-2.00000000000000))*(x3034)*(x3038)))+(((IkReal(-1.00000000000000))*(x3029)*(x3033)*(x3036))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x3039=((IkReal(1.00000000000000))*(r10));
if( IKabs(((gconst20)*(((((IkReal(-1.00000000000000))*(cj5)*(cj6)*(x3039)))+(((cj5)*(r11)*(sj6)))+(((r12)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst20)*(((((IkReal(-1.00000000000000))*(sj6)*(x3039)))+(((IkReal(-1.00000000000000))*(cj6)*(r11))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst20)*(((((IkReal(-1.00000000000000))*(cj5)*(cj6)*(x3039)))+(((cj5)*(r11)*(sj6)))+(((r12)*(sj5)))))), ((gconst20)*(((((IkReal(-1.00000000000000))*(sj6)*(x3039)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x3040=IKsin(j4);
IkReal x3041=IKcos(j4);
IkReal x3042=((IkReal(1.00000000000000))*(r00));
IkReal x3043=((cj5)*(r01));
IkReal x3044=((cj5)*(r11));
IkReal x3045=((IkReal(1.00000000000000))*(cj5));
IkReal x3046=((cj5)*(r21));
IkReal x3047=((sj5)*(x3040));
IkReal x3048=((cj6)*(x3040));
IkReal x3049=((sj6)*(x3041));
IkReal x3050=((sj6)*(x3040));
IkReal x3051=((sj5)*(x3041));
IkReal x3052=((cj6)*(x3041));
evalcond[0]=((((r22)*(x3047)))+(((IkReal(-1.00000000000000))*(r20)*(x3045)*(x3048)))+(((IkReal(-1.00000000000000))*(r21)*(x3052)))+(((IkReal(-1.00000000000000))*(r20)*(x3049)))+(((x3046)*(x3050))));
evalcond[1]=((((r21)*(x3048)))+(((x3046)*(x3049)))+(((r22)*(x3051)))+(((IkReal(-1.00000000000000))*(cj3)))+(((IkReal(-1.00000000000000))*(r20)*(x3045)*(x3052)))+(((r20)*(x3050))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x3042)*(x3049)))+(((IkReal(-1.00000000000000))*(r01)*(x3052)))+(((IkReal(-1.00000000000000))*(cj5)*(x3042)*(x3048)))+(((x3043)*(x3050)))+(((r02)*(x3047))));
evalcond[3]=((IkReal(1.00000000000000))+(((x3044)*(x3050)))+(((IkReal(-1.00000000000000))*(r10)*(x3045)*(x3048)))+(((IkReal(-1.00000000000000))*(r11)*(x3052)))+(((IkReal(-1.00000000000000))*(r10)*(x3049)))+(((r12)*(x3047))));
evalcond[4]=((((x3043)*(x3049)))+(((IkReal(-1.00000000000000))*(sj3)))+(((r02)*(x3051)))+(((r00)*(x3050)))+(((IkReal(-1.00000000000000))*(cj5)*(x3042)*(x3052)))+(((r01)*(x3048))));
evalcond[5]=((((r12)*(x3051)))+(((r10)*(x3050)))+(((x3044)*(x3049)))+(((IkReal(-1.00000000000000))*(r10)*(x3045)*(x3052)))+(((r11)*(x3048))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x3053=((cj3)*(sj6));
IkReal x3054=((IkReal(1.00000000000000))*(r10));
IkReal x3055=((cj3)*(cj6));
if( IKabs(((gconst19)*(((((cj3)*(r12)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(x3054)*(x3055)))+(((cj5)*(r11)*(x3053))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst19)*(((((IkReal(-1.00000000000000))*(x3053)*(x3054)))+(((IkReal(-1.00000000000000))*(r11)*(x3055))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst19)*(((((cj3)*(r12)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(x3054)*(x3055)))+(((cj5)*(r11)*(x3053)))))), ((gconst19)*(((((IkReal(-1.00000000000000))*(x3053)*(x3054)))+(((IkReal(-1.00000000000000))*(r11)*(x3055)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x3056=IKsin(j4);
IkReal x3057=IKcos(j4);
IkReal x3058=((IkReal(1.00000000000000))*(r00));
IkReal x3059=((cj5)*(r01));
IkReal x3060=((cj5)*(r11));
IkReal x3061=((IkReal(1.00000000000000))*(cj5));
IkReal x3062=((cj5)*(r21));
IkReal x3063=((sj5)*(x3056));
IkReal x3064=((cj6)*(x3056));
IkReal x3065=((sj6)*(x3057));
IkReal x3066=((sj6)*(x3056));
IkReal x3067=((sj5)*(x3057));
IkReal x3068=((cj6)*(x3057));
evalcond[0]=((((r22)*(x3063)))+(((IkReal(-1.00000000000000))*(r21)*(x3068)))+(((IkReal(-1.00000000000000))*(r20)*(x3061)*(x3064)))+(((IkReal(-1.00000000000000))*(r20)*(x3065)))+(((x3062)*(x3066))));
evalcond[1]=((((r22)*(x3067)))+(((IkReal(-1.00000000000000))*(r20)*(x3061)*(x3068)))+(((r20)*(x3066)))+(((x3062)*(x3065)))+(((IkReal(-1.00000000000000))*(cj3)))+(((r21)*(x3064))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x3058)*(x3065)))+(((IkReal(-1.00000000000000))*(cj5)*(x3058)*(x3064)))+(((x3059)*(x3066)))+(((IkReal(-1.00000000000000))*(r01)*(x3068)))+(((r02)*(x3063))));
evalcond[3]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(r10)*(x3061)*(x3064)))+(((r12)*(x3063)))+(((x3060)*(x3066)))+(((IkReal(-1.00000000000000))*(r10)*(x3065)))+(((IkReal(-1.00000000000000))*(r11)*(x3068))));
evalcond[4]=((((IkReal(-1.00000000000000))*(sj3)))+(((r00)*(x3066)))+(((r01)*(x3064)))+(((IkReal(-1.00000000000000))*(cj5)*(x3058)*(x3068)))+(((x3059)*(x3065)))+(((r02)*(x3067))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(x3061)*(x3068)))+(((r11)*(x3064)))+(((r10)*(x3066)))+(((r12)*(x3067)))+(((x3060)*(x3065))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3069=((cj6)*(sj5));
IkReal x3070=((sj5)*(sj6));
if( IKabs(((((IkReal(-1.00000000000000))*(r20)*(x3069)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((r21)*(x3070))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(r11)*(x3070)))+(((r10)*(x3069))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(r20)*(x3069)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((r21)*(x3070)))))+IKsqr(((((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(r11)*(x3070)))+(((r10)*(x3069)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(r20)*(x3069)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((r21)*(x3070)))), ((((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(r11)*(x3070)))+(((r10)*(x3069)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[3];
IkReal x3071=IKcos(j3);
IkReal x3072=((cj6)*(sj5));
IkReal x3073=((IkReal(1.00000000000000))*(sj5)*(sj6));
evalcond[0]=((((cj5)*(r22)))+(IKsin(j3))+(((r20)*(x3072)))+(((IkReal(-1.00000000000000))*(r21)*(x3073))));
evalcond[1]=((((r00)*(x3072)))+(((IkReal(-1.00000000000000))*(r01)*(x3073)))+(((sj1)*(x3071)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((r10)*(x3072)))+(((IkReal(-1.00000000000000))*(r11)*(x3073)))+(((IkReal(-1.00000000000000))*(cj1)*(x3071))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst11;
IkReal x3074=(cj5)*(cj5);
IkReal x3075=(r21)*(r21);
IkReal x3076=(sj6)*(sj6);
IkReal x3077=(cj6)*(cj6);
IkReal x3078=(r20)*(r20);
IkReal x3079=((cj6)*(r20));
IkReal x3080=((IkReal(1.00000000000000))*(x3077));
IkReal x3081=((IkReal(2.00000000000000))*(r21)*(sj6));
IkReal x3082=((cj5)*(r22)*(sj5));
IkReal x3083=((IkReal(1.00000000000000))*(x3076));
gconst11=IKsign(((((IkReal(2.00000000000000))*(x3079)*(x3082)))+(((IkReal(-1.00000000000000))*(x3079)*(x3081)))+(((IkReal(-1.00000000000000))*(x3075)*(x3080)))+(((IkReal(-1.00000000000000))*(x3078)*(x3083)))+(((IkReal(-1.00000000000000))*(x3074)*(x3078)*(x3080)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x3074)*(x3075)*(x3083)))+(((IkReal(-1.00000000000000))*(x3081)*(x3082)))+(((x3074)*(x3079)*(x3081)))));
IkReal x3084=(cj5)*(cj5);
IkReal x3085=(r21)*(r21);
IkReal x3086=(sj6)*(sj6);
IkReal x3087=(cj6)*(cj6);
IkReal x3088=(r20)*(r20);
IkReal x3089=((cj6)*(r20));
IkReal x3090=((IkReal(1.00000000000000))*(x3087));
IkReal x3091=((IkReal(2.00000000000000))*(r21)*(sj6));
IkReal x3092=((cj5)*(r22)*(sj5));
IkReal x3093=((IkReal(1.00000000000000))*(x3086));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x3085)*(x3090)))+(((IkReal(-1.00000000000000))*(x3089)*(x3091)))+(((x3084)*(x3089)*(x3091)))+(((IkReal(-1.00000000000000))*(x3091)*(x3092)))+(((IkReal(-1.00000000000000))*(x3084)*(x3088)*(x3090)))+(((IkReal(2.00000000000000))*(x3089)*(x3092)))+(((IkReal(-1.00000000000000))*(x3088)*(x3093)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x3084)*(x3085)*(x3093))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst12;
IkReal x3094=(cj5)*(cj5);
IkReal x3095=(sj6)*(sj6);
IkReal x3096=(cj6)*(cj6);
IkReal x3097=((r00)*(r20));
IkReal x3098=((cj5)*(sj5));
IkReal x3099=((r01)*(r21));
IkReal x3100=((r21)*(sj6));
IkReal x3101=((sj6)*(x3098));
IkReal x3102=((IkReal(1.00000000000000))*(cj6)*(r00));
IkReal x3103=((cj6)*(r01)*(r20)*(sj6));
gconst12=IKsign(((((r02)*(x3098)*(x3100)))+(x3103)+(((x3094)*(x3095)*(x3099)))+(((IkReal(-1.00000000000000))*(cj6)*(r02)*(r20)*(x3098)))+(((r01)*(r22)*(x3101)))+(((cj6)*(r00)*(x3100)))+(((x3094)*(x3096)*(x3097)))+(((IkReal(-1.00000000000000))*(x3094)*(x3103)))+(((x3096)*(x3099)))+(((r02)*(r22)*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x3094)*(x3100)*(x3102)))+(((IkReal(-1.00000000000000))*(r22)*(x3098)*(x3102)))+(((x3095)*(x3097)))));
IkReal x3104=(cj5)*(cj5);
IkReal x3105=(sj6)*(sj6);
IkReal x3106=(cj6)*(cj6);
IkReal x3107=((r00)*(r20));
IkReal x3108=((cj5)*(sj5));
IkReal x3109=((r01)*(r21));
IkReal x3110=((r21)*(sj6));
IkReal x3111=((sj6)*(x3108));
IkReal x3112=((IkReal(1.00000000000000))*(cj6)*(r00));
IkReal x3113=x3103;
dummyeval[0]=((x3113)+(((IkReal(-1.00000000000000))*(x3104)*(x3110)*(x3112)))+(((IkReal(-1.00000000000000))*(r22)*(x3108)*(x3112)))+(((x3104)*(x3105)*(x3109)))+(((r01)*(r22)*(x3111)))+(((x3104)*(x3106)*(x3107)))+(((cj6)*(r00)*(x3110)))+(((r02)*(r22)*((sj5)*(sj5))))+(((r02)*(x3108)*(x3110)))+(((x3106)*(x3109)))+(((x3105)*(x3107)))+(((IkReal(-1.00000000000000))*(cj6)*(r02)*(r20)*(x3108)))+(((IkReal(-1.00000000000000))*(x3104)*(x3113))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x3114=((IkReal(1.00000000000000))*(sj1)*(sj3));
if( IKabs(((gconst12)*(((((IkReal(-1.00000000000000))*(cj6)*(r21)*(x3114)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x3114))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst12)*(((((IkReal(-1.00000000000000))*(r22)*(sj5)*(x3114)))+(((cj5)*(cj6)*(r20)*(sj1)*(sj3)))+(((IkReal(-1.00000000000000))*(cj5)*(r21)*(sj6)*(x3114))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst12)*(((((IkReal(-1.00000000000000))*(cj6)*(r21)*(x3114)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x3114)))))), ((gconst12)*(((((IkReal(-1.00000000000000))*(r22)*(sj5)*(x3114)))+(((cj5)*(cj6)*(r20)*(sj1)*(sj3)))+(((IkReal(-1.00000000000000))*(cj5)*(r21)*(sj6)*(x3114)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x3115=IKsin(j4);
IkReal x3116=IKcos(j4);
IkReal x3117=((IkReal(1.00000000000000))*(r00));
IkReal x3118=((cj5)*(r01));
IkReal x3119=((cj5)*(r11));
IkReal x3120=((IkReal(1.00000000000000))*(cj5));
IkReal x3121=((IkReal(1.00000000000000))*(cj1));
IkReal x3122=((cj5)*(r21));
IkReal x3123=((sj5)*(x3115));
IkReal x3124=((cj6)*(x3115));
IkReal x3125=((sj6)*(x3116));
IkReal x3126=((sj6)*(x3115));
IkReal x3127=((sj5)*(x3116));
IkReal x3128=((cj6)*(x3116));
evalcond[0]=((((IkReal(-1.00000000000000))*(r20)*(x3125)))+(((IkReal(-1.00000000000000))*(r20)*(x3120)*(x3124)))+(((r22)*(x3123)))+(((IkReal(-1.00000000000000))*(r21)*(x3128)))+(((x3122)*(x3126))));
evalcond[1]=((((r20)*(x3126)))+(((r21)*(x3124)))+(((IkReal(-1.00000000000000))*(r20)*(x3120)*(x3128)))+(((r22)*(x3127)))+(((x3122)*(x3125)))+(((IkReal(-1.00000000000000))*(cj3))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x3117)*(x3125)))+(((IkReal(-1.00000000000000))*(cj5)*(x3117)*(x3124)))+(((x3118)*(x3126)))+(((r02)*(x3123)))+(((IkReal(-1.00000000000000))*(r01)*(x3128)))+(((IkReal(-1.00000000000000))*(x3121))));
evalcond[3]=((((IkReal(-1.00000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(r10)*(x3120)*(x3124)))+(((x3119)*(x3126)))+(((IkReal(-1.00000000000000))*(r11)*(x3128)))+(((IkReal(-1.00000000000000))*(r10)*(x3125)))+(((r12)*(x3123))));
evalcond[4]=((((r00)*(x3126)))+(((r01)*(x3124)))+(((IkReal(-1.00000000000000))*(cj5)*(x3117)*(x3128)))+(((sj1)*(sj3)))+(((x3118)*(x3125)))+(((r02)*(x3127))));
evalcond[5]=((((IkReal(-1.00000000000000))*(sj3)*(x3121)))+(((IkReal(-1.00000000000000))*(r10)*(x3120)*(x3128)))+(((x3119)*(x3125)))+(((r10)*(x3126)))+(((r12)*(x3127)))+(((r11)*(x3124))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x3129=((cj3)*(cj6));
IkReal x3130=((IkReal(1.00000000000000))*(r21));
IkReal x3131=((cj3)*(sj6));
if( IKabs(((gconst11)*(((((IkReal(-1.00000000000000))*(r20)*(x3131)))+(((IkReal(-1.00000000000000))*(x3129)*(x3130))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst11)*(((((cj5)*(r20)*(x3129)))+(((IkReal(-1.00000000000000))*(cj5)*(x3130)*(x3131)))+(((IkReal(-1.00000000000000))*(cj3)*(r22)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst11)*(((((IkReal(-1.00000000000000))*(r20)*(x3131)))+(((IkReal(-1.00000000000000))*(x3129)*(x3130)))))), ((gconst11)*(((((cj5)*(r20)*(x3129)))+(((IkReal(-1.00000000000000))*(cj5)*(x3130)*(x3131)))+(((IkReal(-1.00000000000000))*(cj3)*(r22)*(sj5)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x3132=IKsin(j4);
IkReal x3133=IKcos(j4);
IkReal x3134=((IkReal(1.00000000000000))*(r00));
IkReal x3135=((cj5)*(r01));
IkReal x3136=((cj5)*(r11));
IkReal x3137=((IkReal(1.00000000000000))*(cj5));
IkReal x3138=((IkReal(1.00000000000000))*(cj1));
IkReal x3139=((cj5)*(r21));
IkReal x3140=((sj5)*(x3132));
IkReal x3141=((cj6)*(x3132));
IkReal x3142=((sj6)*(x3133));
IkReal x3143=((sj6)*(x3132));
IkReal x3144=((sj5)*(x3133));
IkReal x3145=((cj6)*(x3133));
evalcond[0]=((((IkReal(-1.00000000000000))*(r20)*(x3137)*(x3141)))+(((r22)*(x3140)))+(((x3139)*(x3143)))+(((IkReal(-1.00000000000000))*(r21)*(x3145)))+(((IkReal(-1.00000000000000))*(r20)*(x3142))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r20)*(x3137)*(x3145)))+(((r22)*(x3144)))+(((r20)*(x3143)))+(((x3139)*(x3142)))+(((r21)*(x3141)))+(((IkReal(-1.00000000000000))*(cj3))));
evalcond[2]=((((r02)*(x3140)))+(((x3135)*(x3143)))+(((IkReal(-1.00000000000000))*(x3134)*(x3142)))+(((IkReal(-1.00000000000000))*(cj5)*(x3134)*(x3141)))+(((IkReal(-1.00000000000000))*(x3138)))+(((IkReal(-1.00000000000000))*(r01)*(x3145))));
evalcond[3]=((((IkReal(-1.00000000000000))*(sj1)))+(((r12)*(x3140)))+(((IkReal(-1.00000000000000))*(r10)*(x3137)*(x3141)))+(((IkReal(-1.00000000000000))*(r10)*(x3142)))+(((IkReal(-1.00000000000000))*(r11)*(x3145)))+(((x3136)*(x3143))));
evalcond[4]=((((r02)*(x3144)))+(((x3135)*(x3142)))+(((sj1)*(sj3)))+(((r01)*(x3141)))+(((r00)*(x3143)))+(((IkReal(-1.00000000000000))*(cj5)*(x3134)*(x3145))));
evalcond[5]=((((r10)*(x3143)))+(((r12)*(x3144)))+(((IkReal(-1.00000000000000))*(sj3)*(x3138)))+(((IkReal(-1.00000000000000))*(r10)*(x3137)*(x3145)))+(((r11)*(x3141)))+(((x3136)*(x3142))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x3146=((cj6)*(sj1));
IkReal x3147=((IkReal(1.00000000000000))*(sj1)*(sj6));
if( IKabs(((gconst10)*(((((IkReal(-1.00000000000000))*(r20)*(x3147)))+(((IkReal(-1.00000000000000))*(r21)*(x3146))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst10)*(((((IkReal(-1.00000000000000))*(cj5)*(r21)*(x3147)))+(((IkReal(-1.00000000000000))*(r22)*(sj1)*(sj5)))+(((cj5)*(r20)*(x3146))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst10)*(((((IkReal(-1.00000000000000))*(r20)*(x3147)))+(((IkReal(-1.00000000000000))*(r21)*(x3146)))))), ((gconst10)*(((((IkReal(-1.00000000000000))*(cj5)*(r21)*(x3147)))+(((IkReal(-1.00000000000000))*(r22)*(sj1)*(sj5)))+(((cj5)*(r20)*(x3146)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x3148=IKsin(j4);
IkReal x3149=IKcos(j4);
IkReal x3150=((IkReal(1.00000000000000))*(cj6));
IkReal x3151=((sj5)*(x3148));
IkReal x3152=((cj5)*(x3148));
IkReal x3153=((IkReal(1.00000000000000))*(sj6)*(x3149));
evalcond[0]=((((r22)*(x3151)))+(((IkReal(-1.00000000000000))*(r20)*(x3150)*(x3152)))+(((IkReal(-1.00000000000000))*(r20)*(x3153)))+(((IkReal(-1.00000000000000))*(r21)*(x3149)*(x3150)))+(((r21)*(sj6)*(x3152))));
evalcond[1]=((((r02)*(x3151)))+(((IkReal(-1.00000000000000))*(r01)*(x3149)*(x3150)))+(((r01)*(sj6)*(x3152)))+(((IkReal(-1.00000000000000))*(r00)*(x3150)*(x3152)))+(((IkReal(-1.00000000000000))*(r00)*(x3153)))+(((IkReal(-1.00000000000000))*(cj1))));
evalcond[2]=((((IkReal(-1.00000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(r11)*(x3149)*(x3150)))+(((IkReal(-1.00000000000000))*(r10)*(x3150)*(x3152)))+(((r12)*(x3151)))+(((r11)*(sj6)*(x3152)))+(((IkReal(-1.00000000000000))*(r10)*(x3153))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3154=((cj4)*(cj5));
IkReal x3155=((r21)*(sj6));
IkReal x3156=((IkReal(1.00000000000000))*(cj6)*(r20));
if( IKabs(((((sj5)*(x3155)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(sj5)*(x3156))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((cj4)*(r22)*(sj5)))+(((x3154)*(x3155)))+(((cj6)*(r21)*(sj4)))+(((IkReal(-1.00000000000000))*(x3154)*(x3156)))+(((r20)*(sj4)*(sj6))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((sj5)*(x3155)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(sj5)*(x3156)))))+IKsqr(((((cj4)*(r22)*(sj5)))+(((x3154)*(x3155)))+(((cj6)*(r21)*(sj4)))+(((IkReal(-1.00000000000000))*(x3154)*(x3156)))+(((r20)*(sj4)*(sj6)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((sj5)*(x3155)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((IkReal(-1.00000000000000))*(sj5)*(x3156)))), ((((cj4)*(r22)*(sj5)))+(((x3154)*(x3155)))+(((cj6)*(r21)*(sj4)))+(((IkReal(-1.00000000000000))*(x3154)*(x3156)))+(((r20)*(sj4)*(sj6)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x3157=IKcos(j3);
IkReal x3158=IKsin(j3);
IkReal x3159=((r11)*(sj6));
IkReal x3160=((IkReal(1.00000000000000))*(sj5));
IkReal x3161=((IkReal(1.00000000000000))*(cj1));
IkReal x3162=((cj6)*(sj4));
IkReal x3163=((sj4)*(sj6));
IkReal x3164=((cj4)*(sj5));
IkReal x3165=((cj4)*(cj5));
IkReal x3166=((r01)*(sj6));
IkReal x3167=((r21)*(sj6));
IkReal x3168=((cj6)*(sj5));
IkReal x3169=((IkReal(1.00000000000000))*(cj6)*(x3165));
evalcond[0]=((x3158)+(((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(x3160)*(x3167)))+(((r20)*(x3168))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x3160)*(x3166)))+(((sj1)*(x3157)))+(((r00)*(x3168)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x3157)*(x3161)))+(((r10)*(x3168)))+(((IkReal(-1.00000000000000))*(x3159)*(x3160))));
evalcond[3]=((((r22)*(x3164)))+(((IkReal(-1.00000000000000))*(x3157)))+(((r20)*(x3163)))+(((r21)*(x3162)))+(((IkReal(-1.00000000000000))*(r20)*(x3169)))+(((x3165)*(x3167))));
evalcond[4]=((((r02)*(x3164)))+(((sj1)*(x3158)))+(((r01)*(x3162)))+(((r00)*(x3163)))+(((IkReal(-1.00000000000000))*(r00)*(x3169)))+(((x3165)*(x3166))));
evalcond[5]=((((r11)*(x3162)))+(((r10)*(x3163)))+(((IkReal(-1.00000000000000))*(x3158)*(x3161)))+(((r12)*(x3164)))+(((x3159)*(x3165)))+(((IkReal(-1.00000000000000))*(r10)*(x3169))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x3170=((cj1)*(cj6));
IkReal x3171=((IkReal(1.00000000000000))*(cj1));
if( IKabs(((gconst9)*(((((IkReal(-1.00000000000000))*(r20)*(sj6)*(x3171)))+(((IkReal(-1.00000000000000))*(r21)*(x3170))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst9)*(((((IkReal(-1.00000000000000))*(cj5)*(r21)*(sj6)*(x3171)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x3171)))+(((cj5)*(r20)*(x3170))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst9)*(((((IkReal(-1.00000000000000))*(r20)*(sj6)*(x3171)))+(((IkReal(-1.00000000000000))*(r21)*(x3170)))))), ((gconst9)*(((((IkReal(-1.00000000000000))*(cj5)*(r21)*(sj6)*(x3171)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x3171)))+(((cj5)*(r20)*(x3170)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x3172=IKsin(j4);
IkReal x3173=IKcos(j4);
IkReal x3174=((IkReal(1.00000000000000))*(cj6));
IkReal x3175=((sj5)*(x3172));
IkReal x3176=((cj5)*(x3172));
IkReal x3177=((IkReal(1.00000000000000))*(sj6)*(x3173));
evalcond[0]=((((r21)*(sj6)*(x3176)))+(((r22)*(x3175)))+(((IkReal(-1.00000000000000))*(r20)*(x3174)*(x3176)))+(((IkReal(-1.00000000000000))*(r21)*(x3173)*(x3174)))+(((IkReal(-1.00000000000000))*(r20)*(x3177))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r00)*(x3174)*(x3176)))+(((IkReal(-1.00000000000000))*(r01)*(x3173)*(x3174)))+(((IkReal(-1.00000000000000))*(r00)*(x3177)))+(((r01)*(sj6)*(x3176)))+(((r02)*(x3175)))+(((IkReal(-1.00000000000000))*(cj1))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r10)*(x3174)*(x3176)))+(((IkReal(-1.00000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(r10)*(x3177)))+(((IkReal(-1.00000000000000))*(r11)*(x3173)*(x3174)))+(((r11)*(sj6)*(x3176)))+(((r12)*(x3175))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3178=((cj4)*(cj5));
IkReal x3179=((r21)*(sj6));
IkReal x3180=((IkReal(1.00000000000000))*(cj6)*(r20));
if( IKabs(((((sj5)*(x3179)))+(((IkReal(-1.00000000000000))*(sj5)*(x3180)))+(((IkReal(-1.00000000000000))*(cj5)*(r22))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((cj4)*(r22)*(sj5)))+(((cj6)*(r21)*(sj4)))+(((IkReal(-1.00000000000000))*(x3178)*(x3180)))+(((x3178)*(x3179)))+(((r20)*(sj4)*(sj6))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((sj5)*(x3179)))+(((IkReal(-1.00000000000000))*(sj5)*(x3180)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))))+IKsqr(((((cj4)*(r22)*(sj5)))+(((cj6)*(r21)*(sj4)))+(((IkReal(-1.00000000000000))*(x3178)*(x3180)))+(((x3178)*(x3179)))+(((r20)*(sj4)*(sj6)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((sj5)*(x3179)))+(((IkReal(-1.00000000000000))*(sj5)*(x3180)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))), ((((cj4)*(r22)*(sj5)))+(((cj6)*(r21)*(sj4)))+(((IkReal(-1.00000000000000))*(x3178)*(x3180)))+(((x3178)*(x3179)))+(((r20)*(sj4)*(sj6)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x3181=IKcos(j3);
IkReal x3182=IKsin(j3);
IkReal x3183=((r11)*(sj6));
IkReal x3184=((IkReal(1.00000000000000))*(sj5));
IkReal x3185=((IkReal(1.00000000000000))*(cj1));
IkReal x3186=((cj6)*(sj4));
IkReal x3187=((sj4)*(sj6));
IkReal x3188=((cj4)*(sj5));
IkReal x3189=((cj4)*(cj5));
IkReal x3190=((r01)*(sj6));
IkReal x3191=((r21)*(sj6));
IkReal x3192=((cj6)*(sj5));
IkReal x3193=((IkReal(1.00000000000000))*(cj6)*(x3189));
evalcond[0]=((x3182)+(((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(x3184)*(x3191)))+(((r20)*(x3192))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x3184)*(x3190)))+(((r00)*(x3192)))+(((sj1)*(x3181)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x3183)*(x3184)))+(((IkReal(-1.00000000000000))*(x3181)*(x3185)))+(((r10)*(x3192))));
evalcond[3]=((((r22)*(x3188)))+(((r20)*(x3187)))+(((IkReal(-1.00000000000000))*(r20)*(x3193)))+(((IkReal(-1.00000000000000))*(x3181)))+(((r21)*(x3186)))+(((x3189)*(x3191))));
evalcond[4]=((((r01)*(x3186)))+(((r00)*(x3187)))+(((sj1)*(x3182)))+(((IkReal(-1.00000000000000))*(r00)*(x3193)))+(((r02)*(x3188)))+(((x3189)*(x3190))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(x3193)))+(((r12)*(x3188)))+(((IkReal(-1.00000000000000))*(x3182)*(x3185)))+(((x3183)*(x3189)))+(((r11)*(x3186)))+(((r10)*(x3187))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
}
}

}

}

} else
{
IkReal x3194=((IkReal(0.390000000000000))*(sj5));
IkReal x3195=((IkReal(0.390000000000000))*(cj5));
IkReal x3196=((IkReal(0.000500000000000000))*(cj6));
IkReal x3197=((IkReal(0.000500000000000000))*(sj6));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((r21)*(x3196)))+(((IkReal(-1.00000000000000))*(r21)*(sj6)*(x3194)))+(((r20)*(x3197)))+(((IkReal(-1.00000000000000))*(pz)))+(((r22)*(x3195)))+(((cj6)*(r20)*(x3194))));
evalcond[2]=((((r00)*(x3197)))+(((IkReal(0.00200000000000000))*(cj1)))+(((r01)*(x3196)))+(((IkReal(-1.00000000000000))*(r01)*(sj6)*(x3194)))+(((IkReal(-1.00000000000000))*(px)))+(((cj6)*(r00)*(x3194)))+(((r02)*(x3195)))+(((IkReal(-0.400000000000000))*(sj1))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r11)*(sj6)*(x3194)))+(((IkReal(0.400000000000000))*(cj1)))+(((r11)*(x3196)))+(((IkReal(0.00200000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(py)))+(((r12)*(x3195)))+(((cj6)*(r10)*(x3194)))+(((r10)*(x3197))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst21;
IkReal x3198=(cj6)*(cj6);
IkReal x3199=(sj6)*(sj6);
IkReal x3200=((r01)*(r20));
IkReal x3201=((r02)*(sj5));
IkReal x3202=((cj5)*(x3199));
IkReal x3203=((IkReal(1.00000000000000))*(r22)*(sj5));
IkReal x3204=((IkReal(1.00000000000000))*(r00)*(r21));
IkReal x3205=((cj5)*(x3198));
gconst21=IKsign(((((IkReal(-1.00000000000000))*(r00)*(sj6)*(x3203)))+(((IkReal(-1.00000000000000))*(x3204)*(x3205)))+(((r20)*(sj6)*(x3201)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x3203)))+(((IkReal(-1.00000000000000))*(x3202)*(x3204)))+(((x3200)*(x3205)))+(((x3200)*(x3202)))+(((cj6)*(r21)*(x3201)))));
IkReal x3206=(cj6)*(cj6);
IkReal x3207=(sj6)*(sj6);
IkReal x3208=((r01)*(r20));
IkReal x3209=((r02)*(sj5));
IkReal x3210=((cj5)*(x3207));
IkReal x3211=((IkReal(1.00000000000000))*(r22)*(sj5));
IkReal x3212=((IkReal(1.00000000000000))*(r00)*(r21));
IkReal x3213=((cj5)*(x3206));
dummyeval[0]=((((r20)*(sj6)*(x3209)))+(((x3208)*(x3210)))+(((x3208)*(x3213)))+(((IkReal(-1.00000000000000))*(x3210)*(x3212)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x3211)))+(((IkReal(-1.00000000000000))*(x3212)*(x3213)))+(((IkReal(-1.00000000000000))*(r00)*(sj6)*(x3211)))+(((cj6)*(r21)*(x3209))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst22;
IkReal x3214=(cj6)*(cj6);
IkReal x3215=(sj6)*(sj6);
IkReal x3216=((r11)*(r20));
IkReal x3217=((r12)*(sj5));
IkReal x3218=((IkReal(1.00000000000000))*(r10));
IkReal x3219=((r22)*(sj5));
IkReal x3220=((cj5)*(x3215));
IkReal x3221=((cj5)*(x3214));
gconst22=IKsign(((((x3216)*(x3220)))+(((x3216)*(x3221)))+(((cj6)*(r21)*(x3217)))+(((IkReal(-1.00000000000000))*(r21)*(x3218)*(x3221)))+(((IkReal(-1.00000000000000))*(r21)*(x3218)*(x3220)))+(((r20)*(sj6)*(x3217)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x3219)))+(((IkReal(-1.00000000000000))*(sj6)*(x3218)*(x3219)))));
IkReal x3222=(cj6)*(cj6);
IkReal x3223=(sj6)*(sj6);
IkReal x3224=((r11)*(r20));
IkReal x3225=((r12)*(sj5));
IkReal x3226=((IkReal(1.00000000000000))*(r10));
IkReal x3227=((r22)*(sj5));
IkReal x3228=((cj5)*(x3223));
IkReal x3229=((cj5)*(x3222));
dummyeval[0]=((((r20)*(sj6)*(x3225)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x3227)))+(((IkReal(-1.00000000000000))*(r21)*(x3226)*(x3228)))+(((IkReal(-1.00000000000000))*(r21)*(x3226)*(x3229)))+(((x3224)*(x3229)))+(((x3224)*(x3228)))+(((IkReal(-1.00000000000000))*(sj6)*(x3226)*(x3227)))+(((cj6)*(r21)*(x3225))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=cj1;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
IkReal x3230=((IkReal(0.000500000000000000))*(cj6));
IkReal x3231=((IkReal(0.000500000000000000))*(sj6));
IkReal x3232=((sj5)*(sj6));
IkReal x3233=((cj5)*(r12));
IkReal x3234=((IkReal(0.390000000000000))*(cj5));
IkReal x3235=((IkReal(0.390000000000000))*(cj6)*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((((cj6)*(r10)*(sj5)))+(x3233)+(((IkReal(-1.00000000000000))*(r11)*(x3232))));
evalcond[2]=((((IkReal(-0.390000000000000))*(r21)*(x3232)))+(((r22)*(x3234)))+(((r20)*(x3231)))+(((r20)*(x3235)))+(((IkReal(-1.00000000000000))*(pz)))+(((r21)*(x3230))));
evalcond[3]=((IkReal(-0.400000000000000))+(((IkReal(-0.390000000000000))*(r01)*(x3232)))+(((r01)*(x3230)))+(((r00)*(x3231)))+(((r00)*(x3235)))+(((IkReal(-1.00000000000000))*(px)))+(((r02)*(x3234))));
evalcond[4]=((IkReal(0.00200000000000000))+(((r11)*(x3230)))+(((IkReal(-1.00000000000000))*(py)))+(((IkReal(0.390000000000000))*(x3233)))+(((IkReal(-0.390000000000000))*(r11)*(x3232)))+(((r10)*(x3231)))+(((r10)*(x3235))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3236=((cj6)*(sj5));
IkReal x3237=((sj5)*(sj6));
if( IKabs(((((cj5)*(r22)))+(((r20)*(x3236)))+(((IkReal(-1.00000000000000))*(r21)*(x3237))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((r01)*(x3237)))+(((IkReal(-1.00000000000000))*(cj5)*(r02)))+(((IkReal(-1.00000000000000))*(r00)*(x3236))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((cj5)*(r22)))+(((r20)*(x3236)))+(((IkReal(-1.00000000000000))*(r21)*(x3237)))))+IKsqr(((((r01)*(x3237)))+(((IkReal(-1.00000000000000))*(cj5)*(r02)))+(((IkReal(-1.00000000000000))*(r00)*(x3236)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((cj5)*(r22)))+(((r20)*(x3236)))+(((IkReal(-1.00000000000000))*(r21)*(x3237)))), ((((r01)*(x3237)))+(((IkReal(-1.00000000000000))*(cj5)*(r02)))+(((IkReal(-1.00000000000000))*(r00)*(x3236)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x3238=((cj6)*(sj5));
IkReal x3239=((IkReal(1.00000000000000))*(sj5)*(sj6));
evalcond[0]=((((cj5)*(r22)))+(((r20)*(x3238)))+(((IkReal(-1.00000000000000))*(IKsin(j3))))+(((IkReal(-1.00000000000000))*(r21)*(x3239))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r01)*(x3239)))+(((r00)*(x3238)))+(IKcos(j3))+(((cj5)*(r02))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst27;
IkReal x3240=(sj6)*(sj6);
IkReal x3241=(cj6)*(cj6);
IkReal x3242=((cj6)*(sj5));
IkReal x3243=((r10)*(r21));
IkReal x3244=((IkReal(1.00000000000000))*(r12));
IkReal x3245=((sj5)*(sj6));
IkReal x3246=((cj5)*(x3241));
IkReal x3247=((IkReal(1.00000000000000))*(r11)*(r20));
IkReal x3248=((cj5)*(x3240));
gconst27=IKsign(((((r10)*(r22)*(x3245)))+(((r11)*(r22)*(x3242)))+(((IkReal(-1.00000000000000))*(r21)*(x3242)*(x3244)))+(((IkReal(-1.00000000000000))*(r20)*(x3244)*(x3245)))+(((IkReal(-1.00000000000000))*(x3246)*(x3247)))+(((IkReal(-1.00000000000000))*(x3247)*(x3248)))+(((x3243)*(x3246)))+(((x3243)*(x3248)))));
IkReal x3249=(sj6)*(sj6);
IkReal x3250=(cj6)*(cj6);
IkReal x3251=((cj6)*(sj5));
IkReal x3252=((r10)*(r21));
IkReal x3253=((IkReal(1.00000000000000))*(r12));
IkReal x3254=((sj5)*(sj6));
IkReal x3255=((cj5)*(x3250));
IkReal x3256=((IkReal(1.00000000000000))*(r11)*(r20));
IkReal x3257=((cj5)*(x3249));
dummyeval[0]=((((IkReal(-1.00000000000000))*(r21)*(x3251)*(x3253)))+(((x3252)*(x3257)))+(((x3252)*(x3255)))+(((IkReal(-1.00000000000000))*(x3256)*(x3257)))+(((r10)*(r22)*(x3254)))+(((r11)*(r22)*(x3251)))+(((IkReal(-1.00000000000000))*(x3255)*(x3256)))+(((IkReal(-1.00000000000000))*(r20)*(x3253)*(x3254))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst28;
IkReal x3258=(sj6)*(sj6);
IkReal x3259=(cj6)*(cj6);
IkReal x3260=((r01)*(r10));
IkReal x3261=((IkReal(1.00000000000000))*(r00));
IkReal x3262=((r02)*(sj5));
IkReal x3263=((r12)*(sj5));
IkReal x3264=((cj5)*(x3258));
IkReal x3265=((cj5)*(x3259));
gconst28=IKsign(((((r10)*(sj6)*(x3262)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x3263)))+(((IkReal(-1.00000000000000))*(sj6)*(x3261)*(x3263)))+(((cj6)*(r11)*(x3262)))+(((IkReal(-1.00000000000000))*(r11)*(x3261)*(x3264)))+(((IkReal(-1.00000000000000))*(r11)*(x3261)*(x3265)))+(((x3260)*(x3264)))+(((x3260)*(x3265)))));
IkReal x3266=(sj6)*(sj6);
IkReal x3267=(cj6)*(cj6);
IkReal x3268=((r01)*(r10));
IkReal x3269=((IkReal(1.00000000000000))*(r00));
IkReal x3270=((r02)*(sj5));
IkReal x3271=((r12)*(sj5));
IkReal x3272=((cj5)*(x3266));
IkReal x3273=((cj5)*(x3267));
dummyeval[0]=((((cj6)*(r11)*(x3270)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x3271)))+(((IkReal(-1.00000000000000))*(r11)*(x3269)*(x3273)))+(((IkReal(-1.00000000000000))*(r11)*(x3269)*(x3272)))+(((x3268)*(x3272)))+(((x3268)*(x3273)))+(((IkReal(-1.00000000000000))*(sj6)*(x3269)*(x3271)))+(((r10)*(sj6)*(x3270))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x3274=((sj3)*(sj6));
IkReal x3275=((IkReal(1.00000000000000))*(r10));
IkReal x3276=((cj6)*(sj3));
if( IKabs(((gconst28)*(((((r12)*(sj3)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(x3275)*(x3276)))+(((cj5)*(r11)*(x3274))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst28)*(((((IkReal(-1.00000000000000))*(r11)*(x3276)))+(((IkReal(-1.00000000000000))*(x3274)*(x3275))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst28)*(((((r12)*(sj3)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(x3275)*(x3276)))+(((cj5)*(r11)*(x3274)))))), ((gconst28)*(((((IkReal(-1.00000000000000))*(r11)*(x3276)))+(((IkReal(-1.00000000000000))*(x3274)*(x3275)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x3277=IKsin(j4);
IkReal x3278=IKcos(j4);
IkReal x3279=((IkReal(1.00000000000000))*(r00));
IkReal x3280=((cj5)*(r01));
IkReal x3281=((cj5)*(r11));
IkReal x3282=((IkReal(1.00000000000000))*(cj5));
IkReal x3283=((cj5)*(r21));
IkReal x3284=((sj5)*(x3277));
IkReal x3285=((cj6)*(x3277));
IkReal x3286=((sj6)*(x3278));
IkReal x3287=((sj6)*(x3277));
IkReal x3288=((sj5)*(x3278));
IkReal x3289=((cj6)*(x3278));
evalcond[0]=((((IkReal(-1.00000000000000))*(r20)*(x3286)))+(((x3283)*(x3287)))+(((IkReal(-1.00000000000000))*(r20)*(x3282)*(x3285)))+(((r22)*(x3284)))+(((IkReal(-1.00000000000000))*(r21)*(x3289))));
evalcond[1]=((((r20)*(x3287)))+(cj3)+(((x3283)*(x3286)))+(((IkReal(-1.00000000000000))*(r20)*(x3282)*(x3289)))+(((r22)*(x3288)))+(((r21)*(x3285))));
evalcond[2]=((((IkReal(-1.00000000000000))*(cj5)*(x3279)*(x3285)))+(((r02)*(x3284)))+(((IkReal(-1.00000000000000))*(x3279)*(x3286)))+(((x3280)*(x3287)))+(((IkReal(-1.00000000000000))*(r01)*(x3289))));
evalcond[3]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(r10)*(x3286)))+(((IkReal(-1.00000000000000))*(r10)*(x3282)*(x3285)))+(((IkReal(-1.00000000000000))*(r11)*(x3289)))+(((x3281)*(x3287)))+(((r12)*(x3284))));
evalcond[4]=((((IkReal(-1.00000000000000))*(cj5)*(x3279)*(x3289)))+(((r00)*(x3287)))+(sj3)+(((r02)*(x3288)))+(((x3280)*(x3286)))+(((r01)*(x3285))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(x3282)*(x3289)))+(((r10)*(x3287)))+(((x3281)*(x3286)))+(((r11)*(x3285)))+(((r12)*(x3288))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x3290=((cj3)*(cj5));
IkReal x3291=((IkReal(1.00000000000000))*(cj6));
if( IKabs(((gconst27)*(((((IkReal(-1.00000000000000))*(r10)*(x3290)*(x3291)))+(((cj3)*(r12)*(sj5)))+(((r11)*(sj6)*(x3290))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst27)*(((((IkReal(-1.00000000000000))*(cj3)*(r10)*(sj6)))+(((IkReal(-1.00000000000000))*(cj3)*(r11)*(x3291))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst27)*(((((IkReal(-1.00000000000000))*(r10)*(x3290)*(x3291)))+(((cj3)*(r12)*(sj5)))+(((r11)*(sj6)*(x3290)))))), ((gconst27)*(((((IkReal(-1.00000000000000))*(cj3)*(r10)*(sj6)))+(((IkReal(-1.00000000000000))*(cj3)*(r11)*(x3291)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x3292=IKsin(j4);
IkReal x3293=IKcos(j4);
IkReal x3294=((IkReal(1.00000000000000))*(r00));
IkReal x3295=((cj5)*(r01));
IkReal x3296=((cj5)*(r11));
IkReal x3297=((IkReal(1.00000000000000))*(cj5));
IkReal x3298=((cj5)*(r21));
IkReal x3299=((sj5)*(x3292));
IkReal x3300=((cj6)*(x3292));
IkReal x3301=((sj6)*(x3293));
IkReal x3302=((sj6)*(x3292));
IkReal x3303=((sj5)*(x3293));
IkReal x3304=((cj6)*(x3293));
evalcond[0]=((((x3298)*(x3302)))+(((IkReal(-1.00000000000000))*(r21)*(x3304)))+(((r22)*(x3299)))+(((IkReal(-1.00000000000000))*(r20)*(x3301)))+(((IkReal(-1.00000000000000))*(r20)*(x3297)*(x3300))));
evalcond[1]=((cj3)+(((r21)*(x3300)))+(((r22)*(x3303)))+(((x3298)*(x3301)))+(((IkReal(-1.00000000000000))*(r20)*(x3297)*(x3304)))+(((r20)*(x3302))));
evalcond[2]=((((r02)*(x3299)))+(((IkReal(-1.00000000000000))*(r01)*(x3304)))+(((IkReal(-1.00000000000000))*(x3294)*(x3301)))+(((x3295)*(x3302)))+(((IkReal(-1.00000000000000))*(cj5)*(x3294)*(x3300))));
evalcond[3]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(r10)*(x3297)*(x3300)))+(((IkReal(-1.00000000000000))*(r11)*(x3304)))+(((x3296)*(x3302)))+(((IkReal(-1.00000000000000))*(r10)*(x3301)))+(((r12)*(x3299))));
evalcond[4]=((sj3)+(((r02)*(x3303)))+(((x3295)*(x3301)))+(((IkReal(-1.00000000000000))*(cj5)*(x3294)*(x3304)))+(((r00)*(x3302)))+(((r01)*(x3300))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(x3297)*(x3304)))+(((r10)*(x3302)))+(((r11)*(x3300)))+(((x3296)*(x3301)))+(((r12)*(x3303))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
IkReal x3305=((IkReal(0.000500000000000000))*(cj6));
IkReal x3306=((IkReal(0.000500000000000000))*(sj6));
IkReal x3307=((sj5)*(sj6));
IkReal x3308=((cj5)*(r12));
IkReal x3309=((IkReal(0.390000000000000))*(cj5));
IkReal x3310=((IkReal(0.390000000000000))*(cj6)*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r11)*(x3307)))+(((cj6)*(r10)*(sj5)))+(x3308));
evalcond[2]=((((r21)*(x3305)))+(((r22)*(x3309)))+(((IkReal(-1.00000000000000))*(pz)))+(((r20)*(x3310)))+(((IkReal(-0.390000000000000))*(r21)*(x3307)))+(((r20)*(x3306))));
evalcond[3]=((IkReal(0.400000000000000))+(((r02)*(x3309)))+(((IkReal(-1.00000000000000))*(px)))+(((IkReal(-0.390000000000000))*(r01)*(x3307)))+(((r00)*(x3306)))+(((r00)*(x3310)))+(((r01)*(x3305))));
evalcond[4]=((IkReal(-0.00200000000000000))+(((r10)*(x3306)))+(((r11)*(x3305)))+(((r10)*(x3310)))+(((IkReal(-1.00000000000000))*(py)))+(((IkReal(-0.390000000000000))*(r11)*(x3307)))+(((IkReal(0.390000000000000))*(x3308))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3311=((cj6)*(sj5));
IkReal x3312=((IkReal(1.00000000000000))*(sj5)*(sj6));
if( IKabs(((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(r21)*(x3312)))+(((r20)*(x3311))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r01)*(x3312)))+(((r00)*(x3311)))+(((cj5)*(r02))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(r21)*(x3312)))+(((r20)*(x3311)))))+IKsqr(((((IkReal(-1.00000000000000))*(r01)*(x3312)))+(((r00)*(x3311)))+(((cj5)*(r02)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(r21)*(x3312)))+(((r20)*(x3311)))), ((((IkReal(-1.00000000000000))*(r01)*(x3312)))+(((r00)*(x3311)))+(((cj5)*(r02)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x3313=((cj6)*(sj5));
IkReal x3314=((IkReal(1.00000000000000))*(sj5)*(sj6));
evalcond[0]=((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(r21)*(x3314)))+(((IkReal(-1.00000000000000))*(IKsin(j3))))+(((r20)*(x3313))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r01)*(x3314)))+(((IkReal(-1.00000000000000))*(IKcos(j3))))+(((r00)*(x3313)))+(((cj5)*(r02))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst31;
IkReal x3315=(sj6)*(sj6);
IkReal x3316=(cj6)*(cj6);
IkReal x3317=((cj6)*(sj5));
IkReal x3318=((r10)*(r21));
IkReal x3319=((IkReal(1.00000000000000))*(r12));
IkReal x3320=((sj5)*(sj6));
IkReal x3321=((cj5)*(x3316));
IkReal x3322=((IkReal(1.00000000000000))*(r11)*(r20));
IkReal x3323=((cj5)*(x3315));
gconst31=IKsign(((((IkReal(-1.00000000000000))*(x3322)*(x3323)))+(((IkReal(-1.00000000000000))*(x3321)*(x3322)))+(((IkReal(-1.00000000000000))*(r21)*(x3317)*(x3319)))+(((r11)*(r22)*(x3317)))+(((IkReal(-1.00000000000000))*(r20)*(x3319)*(x3320)))+(((r10)*(r22)*(x3320)))+(((x3318)*(x3321)))+(((x3318)*(x3323)))));
IkReal x3324=(sj6)*(sj6);
IkReal x3325=(cj6)*(cj6);
IkReal x3326=((cj6)*(sj5));
IkReal x3327=((r10)*(r21));
IkReal x3328=((IkReal(1.00000000000000))*(r12));
IkReal x3329=((sj5)*(sj6));
IkReal x3330=((cj5)*(x3325));
IkReal x3331=((IkReal(1.00000000000000))*(r11)*(r20));
IkReal x3332=((cj5)*(x3324));
dummyeval[0]=((((r11)*(r22)*(x3326)))+(((IkReal(-1.00000000000000))*(x3331)*(x3332)))+(((IkReal(-1.00000000000000))*(x3330)*(x3331)))+(((x3327)*(x3330)))+(((x3327)*(x3332)))+(((IkReal(-1.00000000000000))*(r20)*(x3328)*(x3329)))+(((IkReal(-1.00000000000000))*(r21)*(x3326)*(x3328)))+(((r10)*(r22)*(x3329))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst32;
IkReal x3333=(r20)*(r20);
IkReal x3334=(cj5)*(cj5);
IkReal x3335=(sj6)*(sj6);
IkReal x3336=(cj6)*(cj6);
IkReal x3337=(r21)*(r21);
IkReal x3338=((cj6)*(r20));
IkReal x3339=((IkReal(2.00000000000000))*(r21)*(sj6));
IkReal x3340=((cj5)*(r22)*(sj5));
gconst32=IKsign(((((x3333)*(x3335)))+(((IkReal(-1.00000000000000))*(x3334)*(x3338)*(x3339)))+(((x3339)*(x3340)))+(((x3336)*(x3337)))+(((x3334)*(x3335)*(x3337)))+(((x3338)*(x3339)))+(((IkReal(-2.00000000000000))*(x3338)*(x3340)))+((((r22)*(r22))*((sj5)*(sj5))))+(((x3333)*(x3334)*(x3336)))));
IkReal x3341=(r20)*(r20);
IkReal x3342=(cj5)*(cj5);
IkReal x3343=(sj6)*(sj6);
IkReal x3344=(cj6)*(cj6);
IkReal x3345=(r21)*(r21);
IkReal x3346=((cj6)*(r20));
IkReal x3347=((IkReal(2.00000000000000))*(r21)*(sj6));
IkReal x3348=((cj5)*(r22)*(sj5));
dummyeval[0]=((((x3344)*(x3345)))+(((x3347)*(x3348)))+(((x3341)*(x3342)*(x3344)))+(((x3346)*(x3347)))+(((x3341)*(x3343)))+(((IkReal(-2.00000000000000))*(x3346)*(x3348)))+(((x3342)*(x3343)*(x3345)))+((((r22)*(r22))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x3342)*(x3346)*(x3347))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x3349=((cj3)*(cj6));
IkReal x3350=((IkReal(1.00000000000000))*(r21));
IkReal x3351=((cj3)*(sj6));
if( IKabs(((gconst32)*(((((IkReal(-1.00000000000000))*(x3349)*(x3350)))+(((IkReal(-1.00000000000000))*(r20)*(x3351))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst32)*(((((cj5)*(r20)*(x3349)))+(((IkReal(-1.00000000000000))*(cj5)*(x3350)*(x3351)))+(((IkReal(-1.00000000000000))*(cj3)*(r22)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst32)*(((((IkReal(-1.00000000000000))*(x3349)*(x3350)))+(((IkReal(-1.00000000000000))*(r20)*(x3351)))))), ((gconst32)*(((((cj5)*(r20)*(x3349)))+(((IkReal(-1.00000000000000))*(cj5)*(x3350)*(x3351)))+(((IkReal(-1.00000000000000))*(cj3)*(r22)*(sj5)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x3352=IKsin(j4);
IkReal x3353=IKcos(j4);
IkReal x3354=((IkReal(1.00000000000000))*(r00));
IkReal x3355=((cj5)*(r01));
IkReal x3356=((cj5)*(r11));
IkReal x3357=((IkReal(1.00000000000000))*(cj5));
IkReal x3358=((cj5)*(r21));
IkReal x3359=((sj5)*(x3352));
IkReal x3360=((cj6)*(x3352));
IkReal x3361=((sj6)*(x3353));
IkReal x3362=((sj6)*(x3352));
IkReal x3363=((sj5)*(x3353));
IkReal x3364=((cj6)*(x3353));
evalcond[0]=((((x3358)*(x3362)))+(((IkReal(-1.00000000000000))*(r20)*(x3361)))+(((IkReal(-1.00000000000000))*(r21)*(x3364)))+(((IkReal(-1.00000000000000))*(r20)*(x3357)*(x3360)))+(((r22)*(x3359))));
evalcond[1]=((cj3)+(((r22)*(x3363)))+(((r21)*(x3360)))+(((x3358)*(x3361)))+(((r20)*(x3362)))+(((IkReal(-1.00000000000000))*(r20)*(x3357)*(x3364))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r01)*(x3364)))+(((IkReal(-1.00000000000000))*(x3354)*(x3361)))+(((IkReal(-1.00000000000000))*(cj5)*(x3354)*(x3360)))+(((x3355)*(x3362)))+(((r02)*(x3359))));
evalcond[3]=((IkReal(-1.00000000000000))+(((x3356)*(x3362)))+(((r12)*(x3359)))+(((IkReal(-1.00000000000000))*(r10)*(x3357)*(x3360)))+(((IkReal(-1.00000000000000))*(r10)*(x3361)))+(((IkReal(-1.00000000000000))*(r11)*(x3364))));
evalcond[4]=((((IkReal(-1.00000000000000))*(sj3)))+(((r02)*(x3363)))+(((r01)*(x3360)))+(((r00)*(x3362)))+(((IkReal(-1.00000000000000))*(cj5)*(x3354)*(x3364)))+(((x3355)*(x3361))));
evalcond[5]=((((x3356)*(x3361)))+(((IkReal(-1.00000000000000))*(r10)*(x3357)*(x3364)))+(((r10)*(x3362)))+(((r12)*(x3363)))+(((r11)*(x3360))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x3365=((cj3)*(sj6));
IkReal x3366=((IkReal(1.00000000000000))*(r10));
IkReal x3367=((cj3)*(cj6));
if( IKabs(((gconst31)*(((((cj3)*(r12)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(x3366)*(x3367)))+(((cj5)*(r11)*(x3365))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst31)*(((((IkReal(-1.00000000000000))*(x3365)*(x3366)))+(((IkReal(-1.00000000000000))*(r11)*(x3367))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst31)*(((((cj3)*(r12)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(x3366)*(x3367)))+(((cj5)*(r11)*(x3365)))))), ((gconst31)*(((((IkReal(-1.00000000000000))*(x3365)*(x3366)))+(((IkReal(-1.00000000000000))*(r11)*(x3367)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x3368=IKsin(j4);
IkReal x3369=IKcos(j4);
IkReal x3370=((IkReal(1.00000000000000))*(r00));
IkReal x3371=((cj5)*(r01));
IkReal x3372=((cj5)*(r11));
IkReal x3373=((IkReal(1.00000000000000))*(cj5));
IkReal x3374=((cj5)*(r21));
IkReal x3375=((sj5)*(x3368));
IkReal x3376=((cj6)*(x3368));
IkReal x3377=((sj6)*(x3369));
IkReal x3378=((sj6)*(x3368));
IkReal x3379=((sj5)*(x3369));
IkReal x3380=((cj6)*(x3369));
evalcond[0]=((((r22)*(x3375)))+(((IkReal(-1.00000000000000))*(r21)*(x3380)))+(((IkReal(-1.00000000000000))*(r20)*(x3373)*(x3376)))+(((x3374)*(x3378)))+(((IkReal(-1.00000000000000))*(r20)*(x3377))));
evalcond[1]=((cj3)+(((r22)*(x3379)))+(((x3374)*(x3377)))+(((IkReal(-1.00000000000000))*(r20)*(x3373)*(x3380)))+(((r21)*(x3376)))+(((r20)*(x3378))));
evalcond[2]=((((r02)*(x3375)))+(((IkReal(-1.00000000000000))*(x3370)*(x3377)))+(((x3371)*(x3378)))+(((IkReal(-1.00000000000000))*(r01)*(x3380)))+(((IkReal(-1.00000000000000))*(cj5)*(x3370)*(x3376))));
evalcond[3]=((IkReal(-1.00000000000000))+(((r12)*(x3375)))+(((IkReal(-1.00000000000000))*(r10)*(x3373)*(x3376)))+(((x3372)*(x3378)))+(((IkReal(-1.00000000000000))*(r10)*(x3377)))+(((IkReal(-1.00000000000000))*(r11)*(x3380))));
evalcond[4]=((((r01)*(x3376)))+(((IkReal(-1.00000000000000))*(sj3)))+(((IkReal(-1.00000000000000))*(cj5)*(x3370)*(x3380)))+(((r02)*(x3379)))+(((x3371)*(x3377)))+(((r00)*(x3378))));
evalcond[5]=((((r12)*(x3379)))+(((r10)*(x3378)))+(((x3372)*(x3377)))+(((r11)*(x3376)))+(((IkReal(-1.00000000000000))*(r10)*(x3373)*(x3380))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3381=((cj6)*(sj5));
IkReal x3382=((IkReal(1.00000000000000))*(sj5)*(sj6));
if( IKabs(((((cj5)*(r22)))+(((r20)*(x3381)))+(((IkReal(-1.00000000000000))*(r21)*(x3382))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((cj5)*(r12)))+(((r10)*(x3381)))+(((IkReal(-1.00000000000000))*(r11)*(x3382))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((cj5)*(r22)))+(((r20)*(x3381)))+(((IkReal(-1.00000000000000))*(r21)*(x3382)))))+IKsqr(((((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((cj5)*(r12)))+(((r10)*(x3381)))+(((IkReal(-1.00000000000000))*(r11)*(x3382)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((cj5)*(r22)))+(((r20)*(x3381)))+(((IkReal(-1.00000000000000))*(r21)*(x3382)))), ((((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((cj5)*(r12)))+(((r10)*(x3381)))+(((IkReal(-1.00000000000000))*(r11)*(x3382)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[3];
IkReal x3383=IKcos(j3);
IkReal x3384=((cj6)*(sj5));
IkReal x3385=((IkReal(1.00000000000000))*(sj5)*(sj6));
evalcond[0]=((((cj5)*(r22)))+(((r20)*(x3384)))+(((IkReal(-1.00000000000000))*(IKsin(j3))))+(((IkReal(-1.00000000000000))*(r21)*(x3385))));
evalcond[1]=((((sj1)*(x3383)))+(((IkReal(-1.00000000000000))*(r01)*(x3385)))+(((r00)*(x3384)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((r10)*(x3384)))+(((IkReal(-1.00000000000000))*(cj1)*(x3383)))+(((IkReal(-1.00000000000000))*(r11)*(x3385))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst23;
IkReal x3386=(r20)*(r20);
IkReal x3387=(cj5)*(cj5);
IkReal x3388=(sj6)*(sj6);
IkReal x3389=(cj6)*(cj6);
IkReal x3390=(r21)*(r21);
IkReal x3391=((cj6)*(r20));
IkReal x3392=((IkReal(2.00000000000000))*(r21)*(sj6));
IkReal x3393=((cj5)*(r22)*(sj5));
gconst23=IKsign(((((x3387)*(x3388)*(x3390)))+(((x3391)*(x3392)))+(((x3389)*(x3390)))+(((IkReal(-2.00000000000000))*(x3391)*(x3393)))+(((x3386)*(x3387)*(x3389)))+(((x3392)*(x3393)))+(((IkReal(-1.00000000000000))*(x3387)*(x3391)*(x3392)))+((((r22)*(r22))*((sj5)*(sj5))))+(((x3386)*(x3388)))));
IkReal x3394=(r20)*(r20);
IkReal x3395=(cj5)*(cj5);
IkReal x3396=(sj6)*(sj6);
IkReal x3397=(cj6)*(cj6);
IkReal x3398=(r21)*(r21);
IkReal x3399=((cj6)*(r20));
IkReal x3400=((IkReal(2.00000000000000))*(r21)*(sj6));
IkReal x3401=((cj5)*(r22)*(sj5));
dummyeval[0]=((((x3395)*(x3396)*(x3398)))+(((x3394)*(x3395)*(x3397)))+(((IkReal(-1.00000000000000))*(x3395)*(x3399)*(x3400)))+(((x3394)*(x3396)))+(((IkReal(-2.00000000000000))*(x3399)*(x3401)))+(((x3399)*(x3400)))+(((x3397)*(x3398)))+(((x3400)*(x3401)))+((((r22)*(r22))*((sj5)*(sj5)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst24;
IkReal x3402=(cj5)*(cj5);
IkReal x3403=(sj6)*(sj6);
IkReal x3404=(cj6)*(cj6);
IkReal x3405=((r00)*(r20));
IkReal x3406=((cj5)*(sj5));
IkReal x3407=((r01)*(r21));
IkReal x3408=((r21)*(sj6));
IkReal x3409=((sj6)*(x3406));
IkReal x3410=((IkReal(1.00000000000000))*(cj6)*(r00));
IkReal x3411=((cj6)*(r01)*(r20)*(sj6));
gconst24=IKsign(((((IkReal(-1.00000000000000))*(x3402)*(x3411)))+(((r01)*(r22)*(x3409)))+(((x3402)*(x3404)*(x3405)))+(((cj6)*(r00)*(x3408)))+(x3411)+(((x3403)*(x3405)))+(((r02)*(r22)*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(r22)*(x3406)*(x3410)))+(((IkReal(-1.00000000000000))*(cj6)*(r02)*(r20)*(x3406)))+(((x3404)*(x3407)))+(((x3402)*(x3403)*(x3407)))+(((IkReal(-1.00000000000000))*(x3402)*(x3408)*(x3410)))+(((r02)*(x3406)*(x3408)))));
IkReal x3412=(cj5)*(cj5);
IkReal x3413=(sj6)*(sj6);
IkReal x3414=(cj6)*(cj6);
IkReal x3415=((r00)*(r20));
IkReal x3416=((cj5)*(sj5));
IkReal x3417=((r01)*(r21));
IkReal x3418=((r21)*(sj6));
IkReal x3419=((sj6)*(x3416));
IkReal x3420=((IkReal(1.00000000000000))*(cj6)*(r00));
IkReal x3421=x3411;
dummyeval[0]=((((IkReal(-1.00000000000000))*(x3412)*(x3421)))+(((IkReal(-1.00000000000000))*(x3412)*(x3418)*(x3420)))+(((r01)*(r22)*(x3419)))+(((IkReal(-1.00000000000000))*(r22)*(x3416)*(x3420)))+(((x3414)*(x3417)))+(((r02)*(x3416)*(x3418)))+(x3421)+(((cj6)*(r00)*(x3418)))+(((x3412)*(x3413)*(x3417)))+(((r02)*(r22)*((sj5)*(sj5))))+(((x3413)*(x3415)))+(((IkReal(-1.00000000000000))*(cj6)*(r02)*(r20)*(x3416)))+(((x3412)*(x3414)*(x3415))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x3422=((cj1)*(r20));
IkReal x3423=((cj5)*(cj6));
IkReal x3424=((IkReal(1.00000000000000))*(cj1));
IkReal x3425=((IkReal(1.00000000000000))*(cj3));
IkReal x3426=((sj6)*(x3425));
if( IKabs(((gconst24)*(((((IkReal(-1.00000000000000))*(cj5)*(r21)*(sj6)*(x3424)))+(((IkReal(-1.00000000000000))*(r00)*(x3426)))+(((x3422)*(x3423)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x3424)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x3425))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst24)*(((((sj6)*(x3422)))+(((cj1)*(cj6)*(r21)))+(((IkReal(-1.00000000000000))*(r02)*(sj5)*(x3425)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(x3426)))+(((cj3)*(r00)*(x3423))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst24)*(((((IkReal(-1.00000000000000))*(cj5)*(r21)*(sj6)*(x3424)))+(((IkReal(-1.00000000000000))*(r00)*(x3426)))+(((x3422)*(x3423)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x3424)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x3425)))))), ((gconst24)*(((((sj6)*(x3422)))+(((cj1)*(cj6)*(r21)))+(((IkReal(-1.00000000000000))*(r02)*(sj5)*(x3425)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(x3426)))+(((cj3)*(r00)*(x3423)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x3427=IKsin(j4);
IkReal x3428=IKcos(j4);
IkReal x3429=((IkReal(1.00000000000000))*(r00));
IkReal x3430=((cj5)*(r01));
IkReal x3431=((cj5)*(r11));
IkReal x3432=((IkReal(1.00000000000000))*(cj5));
IkReal x3433=((cj5)*(r21));
IkReal x3434=((sj5)*(x3427));
IkReal x3435=((cj6)*(x3427));
IkReal x3436=((sj6)*(x3428));
IkReal x3437=((sj6)*(x3427));
IkReal x3438=((sj5)*(x3428));
IkReal x3439=((cj6)*(x3428));
evalcond[0]=((((x3433)*(x3437)))+(((IkReal(-1.00000000000000))*(r20)*(x3436)))+(((r22)*(x3434)))+(((IkReal(-1.00000000000000))*(r21)*(x3439)))+(((IkReal(-1.00000000000000))*(r20)*(x3432)*(x3435))));
evalcond[1]=((cj3)+(((r20)*(x3437)))+(((x3433)*(x3436)))+(((r21)*(x3435)))+(((r22)*(x3438)))+(((IkReal(-1.00000000000000))*(r20)*(x3432)*(x3439))));
evalcond[2]=((((IkReal(-1.00000000000000))*(cj5)*(x3429)*(x3435)))+(cj1)+(((x3430)*(x3437)))+(((IkReal(-1.00000000000000))*(r01)*(x3439)))+(((r02)*(x3434)))+(((IkReal(-1.00000000000000))*(x3429)*(x3436))));
evalcond[3]=((sj1)+(((IkReal(-1.00000000000000))*(r10)*(x3432)*(x3435)))+(((IkReal(-1.00000000000000))*(r10)*(x3436)))+(((r12)*(x3434)))+(((x3431)*(x3437)))+(((IkReal(-1.00000000000000))*(r11)*(x3439))));
evalcond[4]=((((IkReal(-1.00000000000000))*(cj5)*(x3429)*(x3439)))+(((r01)*(x3435)))+(((x3430)*(x3436)))+(((sj1)*(sj3)))+(((r02)*(x3438)))+(((r00)*(x3437))));
evalcond[5]=((((r10)*(x3437)))+(((IkReal(-1.00000000000000))*(r10)*(x3432)*(x3439)))+(((IkReal(-1.00000000000000))*(cj1)*(sj3)))+(((r12)*(x3438)))+(((x3431)*(x3436)))+(((r11)*(x3435))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x3440=((cj3)*(cj6));
IkReal x3441=((IkReal(1.00000000000000))*(r21));
IkReal x3442=((cj3)*(sj6));
if( IKabs(((gconst23)*(((((IkReal(-1.00000000000000))*(r20)*(x3442)))+(((IkReal(-1.00000000000000))*(x3440)*(x3441))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst23)*(((((IkReal(-1.00000000000000))*(cj3)*(r22)*(sj5)))+(((cj5)*(r20)*(x3440)))+(((IkReal(-1.00000000000000))*(cj5)*(x3441)*(x3442))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst23)*(((((IkReal(-1.00000000000000))*(r20)*(x3442)))+(((IkReal(-1.00000000000000))*(x3440)*(x3441)))))), ((gconst23)*(((((IkReal(-1.00000000000000))*(cj3)*(r22)*(sj5)))+(((cj5)*(r20)*(x3440)))+(((IkReal(-1.00000000000000))*(cj5)*(x3441)*(x3442)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x3443=IKsin(j4);
IkReal x3444=IKcos(j4);
IkReal x3445=((IkReal(1.00000000000000))*(r00));
IkReal x3446=((cj5)*(r01));
IkReal x3447=((cj5)*(r11));
IkReal x3448=((IkReal(1.00000000000000))*(cj5));
IkReal x3449=((cj5)*(r21));
IkReal x3450=((sj5)*(x3443));
IkReal x3451=((cj6)*(x3443));
IkReal x3452=((sj6)*(x3444));
IkReal x3453=((sj6)*(x3443));
IkReal x3454=((sj5)*(x3444));
IkReal x3455=((cj6)*(x3444));
evalcond[0]=((((IkReal(-1.00000000000000))*(r20)*(x3448)*(x3451)))+(((r22)*(x3450)))+(((IkReal(-1.00000000000000))*(r21)*(x3455)))+(((IkReal(-1.00000000000000))*(r20)*(x3452)))+(((x3449)*(x3453))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r20)*(x3448)*(x3455)))+(cj3)+(((r21)*(x3451)))+(((r22)*(x3454)))+(((r20)*(x3453)))+(((x3449)*(x3452))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r01)*(x3455)))+(cj1)+(((r02)*(x3450)))+(((x3446)*(x3453)))+(((IkReal(-1.00000000000000))*(x3445)*(x3452)))+(((IkReal(-1.00000000000000))*(cj5)*(x3445)*(x3451))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r11)*(x3455)))+(sj1)+(((x3447)*(x3453)))+(((r12)*(x3450)))+(((IkReal(-1.00000000000000))*(r10)*(x3448)*(x3451)))+(((IkReal(-1.00000000000000))*(r10)*(x3452))));
evalcond[4]=((((sj1)*(sj3)))+(((r02)*(x3454)))+(((x3446)*(x3452)))+(((r00)*(x3453)))+(((IkReal(-1.00000000000000))*(cj5)*(x3445)*(x3455)))+(((r01)*(x3451))));
evalcond[5]=((((x3447)*(x3452)))+(((r12)*(x3454)))+(((IkReal(-1.00000000000000))*(cj1)*(sj3)))+(((IkReal(-1.00000000000000))*(r10)*(x3448)*(x3455)))+(((r10)*(x3453)))+(((r11)*(x3451))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x3456=((cj6)*(sj1));
IkReal x3457=((IkReal(1.00000000000000))*(sj1)*(sj6));
if( IKabs(((gconst22)*(((((IkReal(-1.00000000000000))*(r21)*(x3456)))+(((IkReal(-1.00000000000000))*(r20)*(x3457))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst22)*(((((IkReal(-1.00000000000000))*(cj5)*(r21)*(x3457)))+(((cj5)*(r20)*(x3456)))+(((IkReal(-1.00000000000000))*(r22)*(sj1)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst22)*(((((IkReal(-1.00000000000000))*(r21)*(x3456)))+(((IkReal(-1.00000000000000))*(r20)*(x3457)))))), ((gconst22)*(((((IkReal(-1.00000000000000))*(cj5)*(r21)*(x3457)))+(((cj5)*(r20)*(x3456)))+(((IkReal(-1.00000000000000))*(r22)*(sj1)*(sj5)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x3458=IKsin(j4);
IkReal x3459=IKcos(j4);
IkReal x3460=((IkReal(1.00000000000000))*(cj6));
IkReal x3461=((sj5)*(x3458));
IkReal x3462=((cj5)*(x3458));
IkReal x3463=((IkReal(1.00000000000000))*(sj6)*(x3459));
evalcond[0]=((((IkReal(-1.00000000000000))*(r21)*(x3459)*(x3460)))+(((IkReal(-1.00000000000000))*(r20)*(x3463)))+(((r21)*(sj6)*(x3462)))+(((IkReal(-1.00000000000000))*(r20)*(x3460)*(x3462)))+(((r22)*(x3461))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r00)*(x3463)))+(((IkReal(-1.00000000000000))*(r00)*(x3460)*(x3462)))+(cj1)+(((r01)*(sj6)*(x3462)))+(((IkReal(-1.00000000000000))*(r01)*(x3459)*(x3460)))+(((r02)*(x3461))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r11)*(x3459)*(x3460)))+(sj1)+(((IkReal(-1.00000000000000))*(r10)*(x3463)))+(((IkReal(-1.00000000000000))*(r10)*(x3460)*(x3462)))+(((r12)*(x3461)))+(((r11)*(sj6)*(x3462))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3464=((cj4)*(cj5));
IkReal x3465=((cj6)*(r20));
IkReal x3466=((IkReal(1.00000000000000))*(sj4));
IkReal x3467=((IkReal(1.00000000000000))*(r21)*(sj6));
if( IKabs(((((cj5)*(r22)))+(((sj5)*(x3465)))+(((IkReal(-1.00000000000000))*(sj5)*(x3467))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((x3464)*(x3465)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(x3464)*(x3467)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x3466)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x3466))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((cj5)*(r22)))+(((sj5)*(x3465)))+(((IkReal(-1.00000000000000))*(sj5)*(x3467)))))+IKsqr(((((x3464)*(x3465)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(x3464)*(x3467)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x3466)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x3466)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((cj5)*(r22)))+(((sj5)*(x3465)))+(((IkReal(-1.00000000000000))*(sj5)*(x3467)))), ((((x3464)*(x3465)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(x3464)*(x3467)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x3466)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x3466)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x3468=IKcos(j3);
IkReal x3469=IKsin(j3);
IkReal x3470=((r11)*(sj6));
IkReal x3471=((IkReal(1.00000000000000))*(sj5));
IkReal x3472=((IkReal(1.00000000000000))*(cj1));
IkReal x3473=((sj4)*(sj6));
IkReal x3474=((cj4)*(sj5));
IkReal x3475=((cj6)*(sj4));
IkReal x3476=((cj4)*(cj5));
IkReal x3477=((r01)*(sj6));
IkReal x3478=((r21)*(sj6));
IkReal x3479=((cj6)*(sj5));
IkReal x3480=((IkReal(1.00000000000000))*(cj6)*(x3476));
evalcond[0]=((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(x3471)*(x3478)))+(((r20)*(x3479)))+(((IkReal(-1.00000000000000))*(x3469))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x3471)*(x3477)))+(((r00)*(x3479)))+(((sj1)*(x3468)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((r10)*(x3479)))+(((IkReal(-1.00000000000000))*(x3468)*(x3472)))+(((IkReal(-1.00000000000000))*(x3470)*(x3471))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r20)*(x3480)))+(((x3476)*(x3478)))+(x3468)+(((r20)*(x3473)))+(((r21)*(x3475)))+(((r22)*(x3474))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r00)*(x3480)))+(((x3476)*(x3477)))+(((r01)*(x3475)))+(((r00)*(x3473)))+(((sj1)*(x3469)))+(((r02)*(x3474))));
evalcond[5]=((((x3470)*(x3476)))+(((IkReal(-1.00000000000000))*(r10)*(x3480)))+(((r12)*(x3474)))+(((IkReal(-1.00000000000000))*(x3469)*(x3472)))+(((r10)*(x3473)))+(((r11)*(x3475))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x3481=((cj1)*(cj6));
IkReal x3482=((IkReal(1.00000000000000))*(cj1));
if( IKabs(((gconst21)*(((((IkReal(-1.00000000000000))*(r21)*(x3481)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x3482))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst21)*(((((IkReal(-1.00000000000000))*(r22)*(sj5)*(x3482)))+(((cj5)*(r20)*(x3481)))+(((IkReal(-1.00000000000000))*(cj5)*(r21)*(sj6)*(x3482))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst21)*(((((IkReal(-1.00000000000000))*(r21)*(x3481)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x3482)))))), ((gconst21)*(((((IkReal(-1.00000000000000))*(r22)*(sj5)*(x3482)))+(((cj5)*(r20)*(x3481)))+(((IkReal(-1.00000000000000))*(cj5)*(r21)*(sj6)*(x3482)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x3483=IKsin(j4);
IkReal x3484=IKcos(j4);
IkReal x3485=((IkReal(1.00000000000000))*(cj6));
IkReal x3486=((sj5)*(x3483));
IkReal x3487=((cj5)*(x3483));
IkReal x3488=((IkReal(1.00000000000000))*(sj6)*(x3484));
evalcond[0]=((((IkReal(-1.00000000000000))*(r20)*(x3488)))+(((r21)*(sj6)*(x3487)))+(((r22)*(x3486)))+(((IkReal(-1.00000000000000))*(r21)*(x3484)*(x3485)))+(((IkReal(-1.00000000000000))*(r20)*(x3485)*(x3487))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r00)*(x3488)))+(cj1)+(((r01)*(sj6)*(x3487)))+(((IkReal(-1.00000000000000))*(r00)*(x3485)*(x3487)))+(((r02)*(x3486)))+(((IkReal(-1.00000000000000))*(r01)*(x3484)*(x3485))));
evalcond[2]=((sj1)+(((IkReal(-1.00000000000000))*(r10)*(x3488)))+(((r11)*(sj6)*(x3487)))+(((IkReal(-1.00000000000000))*(r11)*(x3484)*(x3485)))+(((r12)*(x3486)))+(((IkReal(-1.00000000000000))*(r10)*(x3485)*(x3487))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3489=((cj4)*(cj5));
IkReal x3490=((cj6)*(r20));
IkReal x3491=((IkReal(1.00000000000000))*(sj4));
IkReal x3492=((IkReal(1.00000000000000))*(r21)*(sj6));
if( IKabs(((((cj5)*(r22)))+(((sj5)*(x3490)))+(((IkReal(-1.00000000000000))*(sj5)*(x3492))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r20)*(sj6)*(x3491)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x3491)))+(((IkReal(-1.00000000000000))*(x3489)*(x3492)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(sj5)))+(((x3489)*(x3490))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((cj5)*(r22)))+(((sj5)*(x3490)))+(((IkReal(-1.00000000000000))*(sj5)*(x3492)))))+IKsqr(((((IkReal(-1.00000000000000))*(r20)*(sj6)*(x3491)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x3491)))+(((IkReal(-1.00000000000000))*(x3489)*(x3492)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(sj5)))+(((x3489)*(x3490)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((cj5)*(r22)))+(((sj5)*(x3490)))+(((IkReal(-1.00000000000000))*(sj5)*(x3492)))), ((((IkReal(-1.00000000000000))*(r20)*(sj6)*(x3491)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x3491)))+(((IkReal(-1.00000000000000))*(x3489)*(x3492)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(sj5)))+(((x3489)*(x3490)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x3493=IKcos(j3);
IkReal x3494=IKsin(j3);
IkReal x3495=((r11)*(sj6));
IkReal x3496=((IkReal(1.00000000000000))*(sj5));
IkReal x3497=((IkReal(1.00000000000000))*(cj1));
IkReal x3498=((sj4)*(sj6));
IkReal x3499=((cj4)*(sj5));
IkReal x3500=((cj6)*(sj4));
IkReal x3501=((cj4)*(cj5));
IkReal x3502=((r01)*(sj6));
IkReal x3503=((r21)*(sj6));
IkReal x3504=((cj6)*(sj5));
IkReal x3505=((IkReal(1.00000000000000))*(cj6)*(x3501));
evalcond[0]=((((cj5)*(r22)))+(((r20)*(x3504)))+(((IkReal(-1.00000000000000))*(x3496)*(x3503)))+(((IkReal(-1.00000000000000))*(x3494))));
evalcond[1]=((((r00)*(x3504)))+(((IkReal(-1.00000000000000))*(x3496)*(x3502)))+(((sj1)*(x3493)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((r10)*(x3504)))+(((IkReal(-1.00000000000000))*(x3493)*(x3497)))+(((IkReal(-1.00000000000000))*(x3495)*(x3496))));
evalcond[3]=((((r20)*(x3498)))+(((x3501)*(x3503)))+(x3493)+(((r22)*(x3499)))+(((IkReal(-1.00000000000000))*(r20)*(x3505)))+(((r21)*(x3500))));
evalcond[4]=((((r01)*(x3500)))+(((x3501)*(x3502)))+(((r00)*(x3498)))+(((IkReal(-1.00000000000000))*(r00)*(x3505)))+(((r02)*(x3499)))+(((sj1)*(x3494))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(x3505)))+(((x3495)*(x3501)))+(((IkReal(-1.00000000000000))*(x3494)*(x3497)))+(((r10)*(x3498)))+(((r11)*(x3500)))+(((r12)*(x3499))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
}
}

}

}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3506=(sj1)*(sj1);
IkReal x3507=(cj1)*(cj1);
IkReal x3508=((cj5)*(r12));
IkReal x3509=((cj6)*(sj5));
IkReal x3510=((IkReal(1.00000000000000))*(sj1));
IkReal x3511=((cj5)*(r02));
IkReal x3512=((IkReal(1.00000000000000))*(cj1));
IkReal x3513=((r01)*(sj5)*(sj6));
IkReal x3514=((r11)*(sj5)*(sj6));
if( IKabs(((((IKabs(((((cj2)*(x3506)))+(((cj2)*(x3507))))) != 0)?((IkReal)1/(((((cj2)*(x3506)))+(((cj2)*(x3507)))))):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(x3512)*(x3513)))+(((cj1)*(r00)*(x3509)))+(((r10)*(sj1)*(x3509)))+(((IkReal(-1.00000000000000))*(x3510)*(x3514)))+(((cj1)*(x3511)))+(((sj1)*(x3508))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IKabs(((x3506)+(x3507))) != 0)?((IkReal)1/(((x3506)+(x3507)))):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(x3512)*(x3514)))+(((IkReal(-1.00000000000000))*(x3510)*(x3511)))+(((cj1)*(x3508)))+(((sj1)*(x3513)))+(((IkReal(-1.00000000000000))*(r00)*(x3509)*(x3510)))+(((cj1)*(r10)*(x3509))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IKabs(((((cj2)*(x3506)))+(((cj2)*(x3507))))) != 0)?((IkReal)1/(((((cj2)*(x3506)))+(((cj2)*(x3507)))))):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(x3512)*(x3513)))+(((cj1)*(r00)*(x3509)))+(((r10)*(sj1)*(x3509)))+(((IkReal(-1.00000000000000))*(x3510)*(x3514)))+(((cj1)*(x3511)))+(((sj1)*(x3508)))))))+IKsqr(((((IKabs(((x3506)+(x3507))) != 0)?((IkReal)1/(((x3506)+(x3507)))):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(x3512)*(x3514)))+(((IkReal(-1.00000000000000))*(x3510)*(x3511)))+(((cj1)*(x3508)))+(((sj1)*(x3513)))+(((IkReal(-1.00000000000000))*(r00)*(x3509)*(x3510)))+(((cj1)*(r10)*(x3509)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IKabs(((((cj2)*(x3506)))+(((cj2)*(x3507))))) != 0)?((IkReal)1/(((((cj2)*(x3506)))+(((cj2)*(x3507)))))):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(x3512)*(x3513)))+(((cj1)*(r00)*(x3509)))+(((r10)*(sj1)*(x3509)))+(((IkReal(-1.00000000000000))*(x3510)*(x3514)))+(((cj1)*(x3511)))+(((sj1)*(x3508)))))), ((((IKabs(((x3506)+(x3507))) != 0)?((IkReal)1/(((x3506)+(x3507)))):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(x3512)*(x3514)))+(((IkReal(-1.00000000000000))*(x3510)*(x3511)))+(((cj1)*(x3508)))+(((sj1)*(x3513)))+(((IkReal(-1.00000000000000))*(r00)*(x3509)*(x3510)))+(((cj1)*(r10)*(x3509)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[3];
IkReal x3515=IKsin(j3);
IkReal x3516=IKcos(j3);
IkReal x3517=((IkReal(1.00000000000000))*(cj1));
IkReal x3518=((cj6)*(sj5));
IkReal x3519=((IkReal(1.00000000000000))*(sj5)*(sj6));
IkReal x3520=((cj2)*(x3515));
evalcond[0]=((((cj5)*(r22)))+(((r20)*(x3518)))+(((sj2)*(x3515)))+(((IkReal(-1.00000000000000))*(r21)*(x3519))));
evalcond[1]=((((r00)*(x3518)))+(((IkReal(-1.00000000000000))*(x3517)*(x3520)))+(((sj1)*(x3516)))+(((IkReal(-1.00000000000000))*(r01)*(x3519)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(sj1)*(x3520)))+(((r10)*(x3518)))+(((IkReal(-1.00000000000000))*(r11)*(x3519)))+(((IkReal(-1.00000000000000))*(x3516)*(x3517))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst2;
IkReal x3521=(cj5)*(cj5);
IkReal x3522=(r21)*(r21);
IkReal x3523=(sj6)*(sj6);
IkReal x3524=(cj6)*(cj6);
IkReal x3525=(r20)*(r20);
IkReal x3526=((cj6)*(r20));
IkReal x3527=((IkReal(1.00000000000000))*(x3524));
IkReal x3528=((IkReal(2.00000000000000))*(r21)*(sj6));
IkReal x3529=((cj5)*(r22)*(sj5));
IkReal x3530=((IkReal(1.00000000000000))*(x3523));
gconst2=IKsign(((((IkReal(-1.00000000000000))*(x3522)*(x3527)))+(((IkReal(-1.00000000000000))*(x3521)*(x3525)*(x3527)))+(((IkReal(-1.00000000000000))*(x3526)*(x3528)))+(((IkReal(-1.00000000000000))*(x3525)*(x3530)))+(((IkReal(2.00000000000000))*(x3526)*(x3529)))+(((x3521)*(x3526)*(x3528)))+(((IkReal(-1.00000000000000))*(x3521)*(x3522)*(x3530)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x3528)*(x3529)))));
IkReal x3531=(cj5)*(cj5);
IkReal x3532=(r21)*(r21);
IkReal x3533=(sj6)*(sj6);
IkReal x3534=(cj6)*(cj6);
IkReal x3535=(r20)*(r20);
IkReal x3536=((cj6)*(r20));
IkReal x3537=((IkReal(1.00000000000000))*(x3534));
IkReal x3538=((IkReal(2.00000000000000))*(r21)*(sj6));
IkReal x3539=((cj5)*(r22)*(sj5));
IkReal x3540=((IkReal(1.00000000000000))*(x3533));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x3538)*(x3539)))+(((IkReal(2.00000000000000))*(x3536)*(x3539)))+(((IkReal(-1.00000000000000))*(x3531)*(x3532)*(x3540)))+(((IkReal(-1.00000000000000))*(x3535)*(x3540)))+(((x3531)*(x3536)*(x3538)))+(((IkReal(-1.00000000000000))*(x3532)*(x3537)))+(((IkReal(-1.00000000000000))*(x3531)*(x3535)*(x3537)))+(((IkReal(-1.00000000000000))*((r22)*(r22))*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x3536)*(x3538))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst3;
IkReal x3541=(cj5)*(cj5);
IkReal x3542=(sj6)*(sj6);
IkReal x3543=(cj6)*(cj6);
IkReal x3544=((r00)*(r20));
IkReal x3545=((cj5)*(sj5));
IkReal x3546=((r01)*(r21));
IkReal x3547=((r21)*(sj6));
IkReal x3548=((sj6)*(x3545));
IkReal x3549=((IkReal(1.00000000000000))*(cj6)*(r00));
IkReal x3550=((cj6)*(r01)*(r20)*(sj6));
gconst3=IKsign(((((x3541)*(x3542)*(x3546)))+(((r01)*(r22)*(x3548)))+(((x3542)*(x3544)))+(((x3543)*(x3546)))+(((IkReal(-1.00000000000000))*(r22)*(x3545)*(x3549)))+(x3550)+(((cj6)*(r00)*(x3547)))+(((IkReal(-1.00000000000000))*(x3541)*(x3547)*(x3549)))+(((r02)*(x3545)*(x3547)))+(((r02)*(r22)*((sj5)*(sj5))))+(((IkReal(-1.00000000000000))*(x3541)*(x3550)))+(((x3541)*(x3543)*(x3544)))+(((IkReal(-1.00000000000000))*(cj6)*(r02)*(r20)*(x3545)))));
IkReal x3551=(cj5)*(cj5);
IkReal x3552=(sj6)*(sj6);
IkReal x3553=(cj6)*(cj6);
IkReal x3554=((r00)*(r20));
IkReal x3555=((cj5)*(sj5));
IkReal x3556=((r01)*(r21));
IkReal x3557=((r21)*(sj6));
IkReal x3558=((sj6)*(x3555));
IkReal x3559=((IkReal(1.00000000000000))*(cj6)*(r00));
IkReal x3560=x3550;
dummyeval[0]=((((r01)*(r22)*(x3558)))+(((IkReal(-1.00000000000000))*(r22)*(x3555)*(x3559)))+(x3560)+(((x3551)*(x3552)*(x3556)))+(((cj6)*(r00)*(x3557)))+(((x3552)*(x3554)))+(((x3551)*(x3553)*(x3554)))+(((x3553)*(x3556)))+(((r02)*(r22)*((sj5)*(sj5))))+(((r02)*(x3555)*(x3557)))+(((IkReal(-1.00000000000000))*(cj6)*(r02)*(r20)*(x3555)))+(((IkReal(-1.00000000000000))*(x3551)*(x3560)))+(((IkReal(-1.00000000000000))*(x3551)*(x3557)*(x3559))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x3561=((sj2)*(sj5));
IkReal x3562=((cj5)*(sj6));
IkReal x3563=((sj2)*(sj6));
IkReal x3564=((cj3)*(r00));
IkReal x3565=((cj3)*(r01)*(sj2));
IkReal x3566=((IkReal(1.00000000000000))*(cj1)*(cj6)*(sj2));
if( IKabs(((gconst3)*(((((x3563)*(x3564)))+(((cj1)*(r21)*(sj2)*(x3562)))+(((cj1)*(r22)*(x3561)))+(((IkReal(-1.00000000000000))*(cj5)*(r20)*(x3566)))+(((cj6)*(x3565))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst3)*(((((x3562)*(x3565)))+(((IkReal(-1.00000000000000))*(r21)*(x3566)))+(((cj3)*(r02)*(x3561)))+(((IkReal(-1.00000000000000))*(cj1)*(r20)*(x3563)))+(((IkReal(-1.00000000000000))*(cj5)*(cj6)*(sj2)*(x3564))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst3)*(((((x3563)*(x3564)))+(((cj1)*(r21)*(sj2)*(x3562)))+(((cj1)*(r22)*(x3561)))+(((IkReal(-1.00000000000000))*(cj5)*(r20)*(x3566)))+(((cj6)*(x3565)))))), ((gconst3)*(((((x3562)*(x3565)))+(((IkReal(-1.00000000000000))*(r21)*(x3566)))+(((cj3)*(r02)*(x3561)))+(((IkReal(-1.00000000000000))*(cj1)*(r20)*(x3563)))+(((IkReal(-1.00000000000000))*(cj5)*(cj6)*(sj2)*(x3564)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x3567=IKsin(j4);
IkReal x3568=IKcos(j4);
IkReal x3569=((IkReal(1.00000000000000))*(r00));
IkReal x3570=((cj5)*(r01));
IkReal x3571=((cj5)*(r11));
IkReal x3572=((cj2)*(cj3));
IkReal x3573=((IkReal(1.00000000000000))*(sj2));
IkReal x3574=((IkReal(1.00000000000000))*(cj5));
IkReal x3575=((cj5)*(r21));
IkReal x3576=((sj5)*(x3567));
IkReal x3577=((cj6)*(x3567));
IkReal x3578=((sj6)*(x3568));
IkReal x3579=((sj6)*(x3567));
IkReal x3580=((sj5)*(x3568));
IkReal x3581=((cj6)*(x3568));
evalcond[0]=((((IkReal(-1.00000000000000))*(r20)*(x3574)*(x3577)))+(((IkReal(-1.00000000000000))*(r20)*(x3578)))+(((x3575)*(x3579)))+(((IkReal(-1.00000000000000))*(r21)*(x3581)))+(((r22)*(x3576)))+(((IkReal(-1.00000000000000))*(cj2))));
evalcond[1]=((((r21)*(x3577)))+(((IkReal(-1.00000000000000))*(cj3)*(x3573)))+(((IkReal(-1.00000000000000))*(r20)*(x3574)*(x3581)))+(((x3575)*(x3578)))+(((r20)*(x3579)))+(((r22)*(x3580))));
evalcond[2]=((((x3570)*(x3579)))+(((IkReal(-1.00000000000000))*(r01)*(x3581)))+(((IkReal(-1.00000000000000))*(x3569)*(x3578)))+(((r02)*(x3576)))+(((IkReal(-1.00000000000000))*(cj5)*(x3569)*(x3577)))+(((IkReal(-1.00000000000000))*(cj1)*(x3573))));
evalcond[3]=((((x3571)*(x3579)))+(((r12)*(x3576)))+(((IkReal(-1.00000000000000))*(sj1)*(x3573)))+(((IkReal(-1.00000000000000))*(r11)*(x3581)))+(((IkReal(-1.00000000000000))*(r10)*(x3578)))+(((IkReal(-1.00000000000000))*(r10)*(x3574)*(x3577))));
evalcond[4]=((((x3570)*(x3578)))+(((r00)*(x3579)))+(((r01)*(x3577)))+(((r02)*(x3580)))+(((IkReal(-1.00000000000000))*(cj5)*(x3569)*(x3581)))+(((sj1)*(sj3)))+(((cj1)*(x3572))));
evalcond[5]=((((r10)*(x3579)))+(((r12)*(x3580)))+(((x3571)*(x3578)))+(((IkReal(-1.00000000000000))*(cj1)*(sj3)))+(((IkReal(-1.00000000000000))*(r10)*(x3574)*(x3581)))+(((sj1)*(x3572)))+(((r11)*(x3577))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x3582=((r22)*(sj5));
IkReal x3583=((cj2)*(cj5));
IkReal x3584=((r21)*(sj6));
IkReal x3585=((cj6)*(r20));
IkReal x3586=((cj6)*(r21));
IkReal x3587=((r20)*(sj6));
IkReal x3588=((IkReal(1.00000000000000))*(cj3)*(sj2));
if( IKabs(((gconst2)*(((((x3583)*(x3585)))+(((IkReal(-1.00000000000000))*(x3587)*(x3588)))+(((IkReal(-1.00000000000000))*(x3583)*(x3584)))+(((IkReal(-1.00000000000000))*(cj2)*(x3582)))+(((IkReal(-1.00000000000000))*(x3586)*(x3588))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst2)*(((((IkReal(-1.00000000000000))*(cj5)*(x3584)*(x3588)))+(((IkReal(-1.00000000000000))*(x3582)*(x3588)))+(((cj3)*(cj5)*(sj2)*(x3585)))+(((cj2)*(x3587)))+(((cj2)*(x3586))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst2)*(((((x3583)*(x3585)))+(((IkReal(-1.00000000000000))*(x3587)*(x3588)))+(((IkReal(-1.00000000000000))*(x3583)*(x3584)))+(((IkReal(-1.00000000000000))*(cj2)*(x3582)))+(((IkReal(-1.00000000000000))*(x3586)*(x3588)))))), ((gconst2)*(((((IkReal(-1.00000000000000))*(cj5)*(x3584)*(x3588)))+(((IkReal(-1.00000000000000))*(x3582)*(x3588)))+(((cj3)*(cj5)*(sj2)*(x3585)))+(((cj2)*(x3587)))+(((cj2)*(x3586)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x3589=IKsin(j4);
IkReal x3590=IKcos(j4);
IkReal x3591=((IkReal(1.00000000000000))*(r00));
IkReal x3592=((cj5)*(r01));
IkReal x3593=((cj5)*(r11));
IkReal x3594=((cj2)*(cj3));
IkReal x3595=((IkReal(1.00000000000000))*(sj2));
IkReal x3596=((IkReal(1.00000000000000))*(cj5));
IkReal x3597=((cj5)*(r21));
IkReal x3598=((sj5)*(x3589));
IkReal x3599=((cj6)*(x3589));
IkReal x3600=((sj6)*(x3590));
IkReal x3601=((sj6)*(x3589));
IkReal x3602=((sj5)*(x3590));
IkReal x3603=((cj6)*(x3590));
evalcond[0]=((((IkReal(-1.00000000000000))*(r20)*(x3596)*(x3599)))+(((IkReal(-1.00000000000000))*(r20)*(x3600)))+(((x3597)*(x3601)))+(((r22)*(x3598)))+(((IkReal(-1.00000000000000))*(r21)*(x3603)))+(((IkReal(-1.00000000000000))*(cj2))));
evalcond[1]=((((r21)*(x3599)))+(((r22)*(x3602)))+(((x3597)*(x3600)))+(((IkReal(-1.00000000000000))*(r20)*(x3596)*(x3603)))+(((r20)*(x3601)))+(((IkReal(-1.00000000000000))*(cj3)*(x3595))));
evalcond[2]=((((IkReal(-1.00000000000000))*(cj1)*(x3595)))+(((r02)*(x3598)))+(((x3592)*(x3601)))+(((IkReal(-1.00000000000000))*(cj5)*(x3591)*(x3599)))+(((IkReal(-1.00000000000000))*(x3591)*(x3600)))+(((IkReal(-1.00000000000000))*(r01)*(x3603))));
evalcond[3]=((((x3593)*(x3601)))+(((r12)*(x3598)))+(((IkReal(-1.00000000000000))*(sj1)*(x3595)))+(((IkReal(-1.00000000000000))*(r11)*(x3603)))+(((IkReal(-1.00000000000000))*(r10)*(x3600)))+(((IkReal(-1.00000000000000))*(r10)*(x3596)*(x3599))));
evalcond[4]=((((IkReal(-1.00000000000000))*(cj5)*(x3591)*(x3603)))+(((r02)*(x3602)))+(((sj1)*(sj3)))+(((x3592)*(x3600)))+(((cj1)*(x3594)))+(((r00)*(x3601)))+(((r01)*(x3599))));
evalcond[5]=((((sj1)*(x3594)))+(((r11)*(x3599)))+(((IkReal(-1.00000000000000))*(cj1)*(sj3)))+(((x3593)*(x3600)))+(((r10)*(x3601)))+(((IkReal(-1.00000000000000))*(r10)*(x3596)*(x3603)))+(((r12)*(x3602))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x3604=((cj2)*(cj6));
IkReal x3605=((cj5)*(sj6));
IkReal x3606=((IkReal(1.00000000000000))*(sj1)*(sj2));
IkReal x3607=((r21)*(x3606));
if( IKabs(((gconst1)*(((((cj2)*(r10)*(sj6)))+(((r11)*(x3604)))+(((IkReal(-1.00000000000000))*(cj6)*(x3607)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x3606))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst1)*(((((cj2)*(r11)*(x3605)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x3606)))+(((cj5)*(cj6)*(r20)*(sj1)*(sj2)))+(((IkReal(-1.00000000000000))*(cj5)*(r10)*(x3604)))+(((cj2)*(r12)*(sj5)))+(((IkReal(-1.00000000000000))*(x3605)*(x3607))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst1)*(((((cj2)*(r10)*(sj6)))+(((r11)*(x3604)))+(((IkReal(-1.00000000000000))*(cj6)*(x3607)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x3606)))))), ((gconst1)*(((((cj2)*(r11)*(x3605)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x3606)))+(((cj5)*(cj6)*(r20)*(sj1)*(sj2)))+(((IkReal(-1.00000000000000))*(cj5)*(r10)*(x3604)))+(((cj2)*(r12)*(sj5)))+(((IkReal(-1.00000000000000))*(x3605)*(x3607)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x3608=IKsin(j4);
IkReal x3609=IKcos(j4);
IkReal x3610=((IkReal(1.00000000000000))*(sj2));
IkReal x3611=((IkReal(1.00000000000000))*(cj6));
IkReal x3612=((sj5)*(x3608));
IkReal x3613=((cj5)*(x3608));
IkReal x3614=((IkReal(1.00000000000000))*(sj6)*(x3609));
evalcond[0]=((((r21)*(sj6)*(x3613)))+(((r22)*(x3612)))+(((IkReal(-1.00000000000000))*(r20)*(x3611)*(x3613)))+(((IkReal(-1.00000000000000))*(r21)*(x3609)*(x3611)))+(((IkReal(-1.00000000000000))*(r20)*(x3614)))+(((IkReal(-1.00000000000000))*(cj2))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r00)*(x3614)))+(((r01)*(sj6)*(x3613)))+(((r02)*(x3612)))+(((IkReal(-1.00000000000000))*(cj1)*(x3610)))+(((IkReal(-1.00000000000000))*(r00)*(x3611)*(x3613)))+(((IkReal(-1.00000000000000))*(r01)*(x3609)*(x3611))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r10)*(x3614)))+(((r11)*(sj6)*(x3613)))+(((IkReal(-1.00000000000000))*(r11)*(x3609)*(x3611)))+(((IkReal(-1.00000000000000))*(r10)*(x3611)*(x3613)))+(((IkReal(-1.00000000000000))*(sj1)*(x3610)))+(((r12)*(x3612))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst4;
gconst4=IKsign(sj2);
dummyeval[0]=sj2;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[2];
IkReal x3615=(sj1)*(sj1);
IkReal x3616=(cj1)*(cj1);
dummyeval[0]=((((cj2)*(x3615)))+(((cj2)*(x3616))));
dummyeval[1]=((x3615)+(x3616));
if( IKabs(dummyeval[0]) < 0.0000010000000000  || IKabs(dummyeval[1]) < 0.0000010000000000  )
{
{
IkReal dummyeval[2];
dummyeval[0]=sj2;
dummyeval[1]=cj1;
if( IKabs(dummyeval[0]) < 0.0000010000000000  || IKabs(dummyeval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[9];
IkReal x3617=((sj4)*(sj5));
IkReal x3618=((cj6)*(r20));
IkReal x3619=((IkReal(1.00000000000000))*(cj4));
IkReal x3620=((IkReal(0.390000000000000))*(sj5));
IkReal x3621=((r21)*(sj6));
IkReal x3622=((IkReal(0.390000000000000))*(cj5));
IkReal x3623=((cj6)*(r00));
IkReal x3624=((IkReal(0.000500000000000000))*(cj6));
IkReal x3625=((r11)*(sj6));
IkReal x3626=((cj5)*(sj4));
IkReal x3627=((r01)*(sj6));
IkReal x3628=((r20)*(sj6));
IkReal x3629=((r10)*(sj6));
IkReal x3630=((cj6)*(r10));
IkReal x3631=((cj6)*(r21));
IkReal x3632=((r00)*(sj6));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(3.14159265358979))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((cj5)*(r22)))+(((sj5)*(x3618)))+(((IkReal(-1.00000000000000))*(sj5)*(x3621))));
evalcond[2]=((IkReal(-0.00200000000000000))+(((IkReal(0.000500000000000000))*(x3628)))+(((r21)*(x3624)))+(((x3618)*(x3620)))+(((IkReal(-1.00000000000000))*(pz)))+(((r22)*(x3622)))+(((IkReal(-1.00000000000000))*(x3620)*(x3621))));
evalcond[3]=((((r01)*(x3624)))+(((r02)*(x3622)))+(((x3620)*(x3623)))+(((IkReal(-1.00000000000000))*(px)))+(((IkReal(0.000500000000000000))*(x3632)))+(((IkReal(-0.400000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(x3620)*(x3627))));
evalcond[4]=((((x3620)*(x3630)))+(((IkReal(0.000500000000000000))*(x3629)))+(((IkReal(0.400000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(py)))+(((r11)*(x3624)))+(((r12)*(x3622)))+(((IkReal(-1.00000000000000))*(x3620)*(x3625))));
evalcond[5]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(x3618)*(x3626)))+(((IkReal(-1.00000000000000))*(x3619)*(x3631)))+(((r22)*(x3617)))+(((x3621)*(x3626)))+(((IkReal(-1.00000000000000))*(x3619)*(x3628))));
evalcond[6]=((((sj4)*(x3628)))+(((cj4)*(cj5)*(x3621)))+(((cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(x3618)*(x3619)))+(((sj4)*(x3631))));
evalcond[7]=((((x3626)*(x3627)))+(((IkReal(-1.00000000000000))*(x3619)*(x3632)))+(((r02)*(x3617)))+(((IkReal(-1.00000000000000))*(x3623)*(x3626)))+(((IkReal(-1.00000000000000))*(cj6)*(r01)*(x3619))));
evalcond[8]=((((IkReal(-1.00000000000000))*(x3626)*(x3630)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x3619)))+(((x3625)*(x3626)))+(((IkReal(-1.00000000000000))*(x3619)*(x3629)))+(((r12)*(x3617))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst5;
gconst5=IKsign((((sj1)*(sj1))+((cj1)*(cj1))));
dummyeval[0]=(((sj1)*(sj1))+((cj1)*(cj1)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst6;
gconst6=IKsign((((sj1)*(sj1))+((cj1)*(cj1))));
dummyeval[0]=(((sj1)*(sj1))+((cj1)*(cj1)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3633=((IkReal(1.00000000000000))*(sj4));
IkReal x3634=((r00)*(sj6));
IkReal x3635=((cj1)*(cj6));
IkReal x3636=((cj4)*(sj5));
IkReal x3637=((cj4)*(cj5));
IkReal x3638=((r01)*(sj1));
IkReal x3639=((IkReal(1.00000000000000))*(sj6));
IkReal x3640=((cj1)*(r02));
IkReal x3641=((cj1)*(r01));
IkReal x3642=((IkReal(1.00000000000000))*(r02)*(sj1));
IkReal x3643=((cj6)*(r00)*(sj1));
if( IKabs(((gconst6)*(((((IkReal(-1.00000000000000))*(cj6)*(x3633)*(x3638)))+(((IkReal(-1.00000000000000))*(x3637)*(x3638)*(x3639)))+(((IkReal(-1.00000000000000))*(x3636)*(x3642)))+(((x3637)*(x3643)))+(((cj5)*(x3640)))+(((r00)*(sj5)*(x3635)))+(((IkReal(-1.00000000000000))*(sj5)*(x3639)*(x3641)))+(((IkReal(-1.00000000000000))*(sj1)*(x3633)*(x3634))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst6)*(((((sj5)*(sj6)*(x3638)))+(((IkReal(-1.00000000000000))*(r01)*(x3633)*(x3635)))+(((IkReal(-1.00000000000000))*(x3636)*(x3640)))+(((IkReal(-1.00000000000000))*(sj5)*(x3643)))+(((r00)*(x3635)*(x3637)))+(((IkReal(-1.00000000000000))*(x3637)*(x3639)*(x3641)))+(((IkReal(-1.00000000000000))*(cj5)*(x3642)))+(((IkReal(-1.00000000000000))*(cj1)*(x3633)*(x3634))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst6)*(((((IkReal(-1.00000000000000))*(cj6)*(x3633)*(x3638)))+(((IkReal(-1.00000000000000))*(x3637)*(x3638)*(x3639)))+(((IkReal(-1.00000000000000))*(x3636)*(x3642)))+(((x3637)*(x3643)))+(((cj5)*(x3640)))+(((r00)*(sj5)*(x3635)))+(((IkReal(-1.00000000000000))*(sj5)*(x3639)*(x3641)))+(((IkReal(-1.00000000000000))*(sj1)*(x3633)*(x3634)))))), ((gconst6)*(((((sj5)*(sj6)*(x3638)))+(((IkReal(-1.00000000000000))*(r01)*(x3633)*(x3635)))+(((IkReal(-1.00000000000000))*(x3636)*(x3640)))+(((IkReal(-1.00000000000000))*(sj5)*(x3643)))+(((r00)*(x3635)*(x3637)))+(((IkReal(-1.00000000000000))*(x3637)*(x3639)*(x3641)))+(((IkReal(-1.00000000000000))*(cj5)*(x3642)))+(((IkReal(-1.00000000000000))*(cj1)*(x3633)*(x3634)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x3644=IKcos(j3);
IkReal x3645=IKsin(j3);
IkReal x3646=((r11)*(sj6));
IkReal x3647=((IkReal(1.00000000000000))*(sj5));
IkReal x3648=((sj4)*(sj6));
IkReal x3649=((cj4)*(sj5));
IkReal x3650=((cj6)*(sj4));
IkReal x3651=((cj4)*(cj5));
IkReal x3652=((r01)*(sj6));
IkReal x3653=((cj6)*(sj5));
IkReal x3654=((sj1)*(x3644));
IkReal x3655=((cj1)*(x3644));
IkReal x3656=((IkReal(1.00000000000000))*(x3645));
IkReal x3657=((cj1)*(x3656));
IkReal x3658=((IkReal(1.00000000000000))*(cj6)*(x3651));
evalcond[0]=((((r00)*(x3653)))+(x3654)+(((IkReal(-1.00000000000000))*(x3647)*(x3652)))+(((cj5)*(r02)))+(((IkReal(-1.00000000000000))*(x3657))));
evalcond[1]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x3646)*(x3647)))+(((IkReal(-1.00000000000000))*(x3655)))+(((r10)*(x3653)))+(((IkReal(-1.00000000000000))*(sj1)*(x3656))));
evalcond[2]=((((r00)*(x3648)))+(((x3651)*(x3652)))+(x3655)+(((r02)*(x3649)))+(((IkReal(-1.00000000000000))*(r00)*(x3658)))+(((sj1)*(x3645)))+(((r01)*(x3650))));
evalcond[3]=((((x3646)*(x3651)))+(((r12)*(x3649)))+(((r11)*(x3650)))+(((IkReal(-1.00000000000000))*(r10)*(x3658)))+(x3654)+(((r10)*(x3648)))+(((IkReal(-1.00000000000000))*(x3657))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3659=((cj5)*(r12));
IkReal x3660=((cj6)*(sj5));
IkReal x3661=((IkReal(1.00000000000000))*(sj1));
IkReal x3662=((cj5)*(r02));
IkReal x3663=((IkReal(1.00000000000000))*(cj1));
IkReal x3664=((r01)*(sj5)*(sj6));
IkReal x3665=((r11)*(sj5)*(sj6));
if( IKabs(((gconst5)*(((((IkReal(-1.00000000000000))*(x3663)*(x3664)))+(((cj1)*(x3662)))+(((IkReal(-1.00000000000000))*(x3661)*(x3665)))+(((r10)*(sj1)*(x3660)))+(((sj1)*(x3659)))+(((cj1)*(r00)*(x3660))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst5)*(((((IkReal(-1.00000000000000))*(x3663)*(x3665)))+(((cj1)*(r10)*(x3660)))+(((IkReal(-1.00000000000000))*(x3661)*(x3662)))+(((IkReal(-1.00000000000000))*(r00)*(x3660)*(x3661)))+(((sj1)*(x3664)))+(((cj1)*(x3659))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst5)*(((((IkReal(-1.00000000000000))*(x3663)*(x3664)))+(((cj1)*(x3662)))+(((IkReal(-1.00000000000000))*(x3661)*(x3665)))+(((r10)*(sj1)*(x3660)))+(((sj1)*(x3659)))+(((cj1)*(r00)*(x3660)))))), ((gconst5)*(((((IkReal(-1.00000000000000))*(x3663)*(x3665)))+(((cj1)*(r10)*(x3660)))+(((IkReal(-1.00000000000000))*(x3661)*(x3662)))+(((IkReal(-1.00000000000000))*(r00)*(x3660)*(x3661)))+(((sj1)*(x3664)))+(((cj1)*(x3659)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x3666=IKcos(j3);
IkReal x3667=IKsin(j3);
IkReal x3668=((r11)*(sj6));
IkReal x3669=((IkReal(1.00000000000000))*(sj5));
IkReal x3670=((sj4)*(sj6));
IkReal x3671=((cj4)*(sj5));
IkReal x3672=((cj6)*(sj4));
IkReal x3673=((cj4)*(cj5));
IkReal x3674=((r01)*(sj6));
IkReal x3675=((cj6)*(sj5));
IkReal x3676=((sj1)*(x3666));
IkReal x3677=((cj1)*(x3666));
IkReal x3678=((IkReal(1.00000000000000))*(x3667));
IkReal x3679=((cj1)*(x3678));
IkReal x3680=((IkReal(1.00000000000000))*(cj6)*(x3673));
evalcond[0]=((((r00)*(x3675)))+(x3676)+(((IkReal(-1.00000000000000))*(x3669)*(x3674)))+(((IkReal(-1.00000000000000))*(x3679)))+(((cj5)*(r02))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x3668)*(x3669)))+(((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(sj1)*(x3678)))+(((IkReal(-1.00000000000000))*(x3677)))+(((r10)*(x3675))));
evalcond[2]=((((r01)*(x3672)))+(((r00)*(x3670)))+(((sj1)*(x3667)))+(((x3673)*(x3674)))+(x3677)+(((IkReal(-1.00000000000000))*(r00)*(x3680)))+(((r02)*(x3671))));
evalcond[3]=((((r11)*(x3672)))+(((r12)*(x3671)))+(((x3668)*(x3673)))+(x3676)+(((r10)*(x3670)))+(((IkReal(-1.00000000000000))*(x3679)))+(((IkReal(-1.00000000000000))*(r10)*(x3680))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
IkReal x3681=((sj4)*(sj5));
IkReal x3682=((cj6)*(r20));
IkReal x3683=((IkReal(1.00000000000000))*(cj4));
IkReal x3684=((IkReal(0.390000000000000))*(sj5));
IkReal x3685=((r21)*(sj6));
IkReal x3686=((IkReal(0.390000000000000))*(cj5));
IkReal x3687=((cj6)*(r00));
IkReal x3688=((IkReal(0.000500000000000000))*(cj6));
IkReal x3689=((r11)*(sj6));
IkReal x3690=((cj5)*(sj4));
IkReal x3691=((r01)*(sj6));
IkReal x3692=((r20)*(sj6));
IkReal x3693=((r10)*(sj6));
IkReal x3694=((cj6)*(r10));
IkReal x3695=((cj6)*(r21));
IkReal x3696=((r00)*(sj6));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.11022302462516e-16))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(sj5)*(x3685)))+(((sj5)*(x3682))));
evalcond[2]=((IkReal(0.00200000000000000))+(((r21)*(x3688)))+(((IkReal(0.000500000000000000))*(x3692)))+(((IkReal(-1.00000000000000))*(pz)))+(((x3682)*(x3684)))+(((IkReal(-1.00000000000000))*(x3684)*(x3685)))+(((r22)*(x3686))));
evalcond[3]=((((r01)*(x3688)))+(((IkReal(0.000500000000000000))*(x3696)))+(((x3684)*(x3687)))+(((IkReal(-1.00000000000000))*(px)))+(((r02)*(x3686)))+(((IkReal(-0.400000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(x3684)*(x3691))));
evalcond[4]=((((IkReal(0.400000000000000))*(cj1)))+(((IkReal(0.000500000000000000))*(x3693)))+(((IkReal(-1.00000000000000))*(py)))+(((x3684)*(x3694)))+(((r12)*(x3686)))+(((IkReal(-1.00000000000000))*(x3684)*(x3689)))+(((r11)*(x3688))));
evalcond[5]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x3682)*(x3690)))+(((x3685)*(x3690)))+(((IkReal(-1.00000000000000))*(x3683)*(x3692)))+(((IkReal(-1.00000000000000))*(x3683)*(x3695)))+(((r22)*(x3681))));
evalcond[6]=((((cj4)*(cj5)*(x3685)))+(((cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(x3682)*(x3683)))+(((sj4)*(x3692)))+(((sj4)*(x3695))));
evalcond[7]=((((IkReal(-1.00000000000000))*(cj6)*(r01)*(x3683)))+(((IkReal(-1.00000000000000))*(x3687)*(x3690)))+(((x3690)*(x3691)))+(((r02)*(x3681)))+(((IkReal(-1.00000000000000))*(x3683)*(x3696))));
evalcond[8]=((((x3689)*(x3690)))+(((r12)*(x3681)))+(((IkReal(-1.00000000000000))*(x3683)*(x3693)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x3683)))+(((IkReal(-1.00000000000000))*(x3690)*(x3694))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst7;
gconst7=IKsign(((((IkReal(-1.00000000000000))*((sj1)*(sj1))))+(((IkReal(-1.00000000000000))*((cj1)*(cj1))))));
dummyeval[0]=((((IkReal(-1.00000000000000))*((sj1)*(sj1))))+(((IkReal(-1.00000000000000))*((cj1)*(cj1)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst8;
gconst8=IKsign(((((IkReal(-1.00000000000000))*((sj1)*(sj1))))+(((IkReal(-1.00000000000000))*((cj1)*(cj1))))));
dummyeval[0]=((((IkReal(-1.00000000000000))*((sj1)*(sj1))))+(((IkReal(-1.00000000000000))*((cj1)*(cj1)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3697=((sj1)*(sj6));
IkReal x3698=((r00)*(sj4));
IkReal x3699=((IkReal(1.00000000000000))*(r01));
IkReal x3700=((cj1)*(cj6));
IkReal x3701=((cj1)*(sj6));
IkReal x3702=((cj4)*(cj5));
IkReal x3703=((r02)*(sj1));
IkReal x3704=((cj4)*(sj5));
IkReal x3705=((cj1)*(r02));
IkReal x3706=((cj6)*(r00)*(sj1));
if( IKabs(((gconst8)*(((((IkReal(-1.00000000000000))*(x3702)*(x3706)))+(((x3697)*(x3698)))+(((cj5)*(x3705)))+(((r01)*(x3697)*(x3702)))+(((cj6)*(r01)*(sj1)*(sj4)))+(((IkReal(-1.00000000000000))*(sj5)*(x3699)*(x3701)))+(((r00)*(sj5)*(x3700)))+(((x3703)*(x3704))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst8)*(((((IkReal(-1.00000000000000))*(x3698)*(x3701)))+(((IkReal(-1.00000000000000))*(sj4)*(x3699)*(x3700)))+(((cj5)*(x3703)))+(((r00)*(x3700)*(x3702)))+(((IkReal(-1.00000000000000))*(sj5)*(x3697)*(x3699)))+(((IkReal(-1.00000000000000))*(x3704)*(x3705)))+(((sj5)*(x3706)))+(((IkReal(-1.00000000000000))*(x3699)*(x3701)*(x3702))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst8)*(((((IkReal(-1.00000000000000))*(x3702)*(x3706)))+(((x3697)*(x3698)))+(((cj5)*(x3705)))+(((r01)*(x3697)*(x3702)))+(((cj6)*(r01)*(sj1)*(sj4)))+(((IkReal(-1.00000000000000))*(sj5)*(x3699)*(x3701)))+(((r00)*(sj5)*(x3700)))+(((x3703)*(x3704)))))), ((gconst8)*(((((IkReal(-1.00000000000000))*(x3698)*(x3701)))+(((IkReal(-1.00000000000000))*(sj4)*(x3699)*(x3700)))+(((cj5)*(x3703)))+(((r00)*(x3700)*(x3702)))+(((IkReal(-1.00000000000000))*(sj5)*(x3697)*(x3699)))+(((IkReal(-1.00000000000000))*(x3704)*(x3705)))+(((sj5)*(x3706)))+(((IkReal(-1.00000000000000))*(x3699)*(x3701)*(x3702)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x3707=IKsin(j3);
IkReal x3708=IKcos(j3);
IkReal x3709=((r11)*(sj6));
IkReal x3710=((IkReal(1.00000000000000))*(sj5));
IkReal x3711=((sj4)*(sj6));
IkReal x3712=((cj4)*(sj5));
IkReal x3713=((cj6)*(sj4));
IkReal x3714=((cj4)*(cj5));
IkReal x3715=((r01)*(sj6));
IkReal x3716=((cj6)*(sj5));
IkReal x3717=((sj1)*(x3707));
IkReal x3718=((cj1)*(x3707));
IkReal x3719=((IkReal(1.00000000000000))*(x3708));
IkReal x3720=((cj1)*(x3719));
IkReal x3721=((IkReal(1.00000000000000))*(cj6)*(x3714));
evalcond[0]=((((sj1)*(x3708)))+(((IkReal(-1.00000000000000))*(x3710)*(x3715)))+(((r00)*(x3716)))+(x3718)+(((cj5)*(r02))));
evalcond[1]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x3720)))+(x3717)+(((IkReal(-1.00000000000000))*(x3709)*(x3710)))+(((r10)*(x3716))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x3720)))+(((IkReal(-1.00000000000000))*(r00)*(x3721)))+(((r00)*(x3711)))+(((x3714)*(x3715)))+(((r01)*(x3713)))+(x3717)+(((r02)*(x3712))));
evalcond[3]=((((r11)*(x3713)))+(((r12)*(x3712)))+(((x3709)*(x3714)))+(((IkReal(-1.00000000000000))*(sj1)*(x3719)))+(((IkReal(-1.00000000000000))*(r10)*(x3721)))+(((r10)*(x3711)))+(((IkReal(-1.00000000000000))*(x3718))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3722=((sj1)*(sj5));
IkReal x3723=((cj6)*(r10));
IkReal x3724=((cj5)*(sj1));
IkReal x3725=((cj1)*(cj5));
IkReal x3726=((cj1)*(sj5));
IkReal x3727=((cj6)*(r00));
IkReal x3728=((r11)*(sj6));
IkReal x3729=((IkReal(1.00000000000000))*(r01)*(sj6));
if( IKabs(((gconst7)*(((((IkReal(-1.00000000000000))*(x3726)*(x3729)))+(((x3726)*(x3727)))+(((r02)*(x3725)))+(((r12)*(x3724)))+(((x3722)*(x3723)))+(((IkReal(-1.00000000000000))*(x3722)*(x3728))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst7)*(((((x3726)*(x3728)))+(((r02)*(x3724)))+(((x3722)*(x3727)))+(((IkReal(-1.00000000000000))*(x3722)*(x3729)))+(((IkReal(-1.00000000000000))*(x3723)*(x3726)))+(((IkReal(-1.00000000000000))*(r12)*(x3725))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst7)*(((((IkReal(-1.00000000000000))*(x3726)*(x3729)))+(((x3726)*(x3727)))+(((r02)*(x3725)))+(((r12)*(x3724)))+(((x3722)*(x3723)))+(((IkReal(-1.00000000000000))*(x3722)*(x3728)))))), ((gconst7)*(((((x3726)*(x3728)))+(((r02)*(x3724)))+(((x3722)*(x3727)))+(((IkReal(-1.00000000000000))*(x3722)*(x3729)))+(((IkReal(-1.00000000000000))*(x3723)*(x3726)))+(((IkReal(-1.00000000000000))*(r12)*(x3725)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x3730=IKsin(j3);
IkReal x3731=IKcos(j3);
IkReal x3732=((r11)*(sj6));
IkReal x3733=((IkReal(1.00000000000000))*(sj5));
IkReal x3734=((sj4)*(sj6));
IkReal x3735=((cj4)*(sj5));
IkReal x3736=((cj6)*(sj4));
IkReal x3737=((cj4)*(cj5));
IkReal x3738=((r01)*(sj6));
IkReal x3739=((cj6)*(sj5));
IkReal x3740=((sj1)*(x3730));
IkReal x3741=((cj1)*(x3730));
IkReal x3742=((IkReal(1.00000000000000))*(x3731));
IkReal x3743=((cj1)*(x3742));
IkReal x3744=((IkReal(1.00000000000000))*(cj6)*(x3737));
evalcond[0]=((((r00)*(x3739)))+(((sj1)*(x3731)))+(x3741)+(((IkReal(-1.00000000000000))*(x3733)*(x3738)))+(((cj5)*(r02))));
evalcond[1]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x3743)))+(x3740)+(((IkReal(-1.00000000000000))*(x3732)*(x3733)))+(((r10)*(x3739))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r00)*(x3744)))+(((r01)*(x3736)))+(((r00)*(x3734)))+(((IkReal(-1.00000000000000))*(x3743)))+(((r02)*(x3735)))+(x3740)+(((x3737)*(x3738))));
evalcond[3]=((((x3732)*(x3737)))+(((r11)*(x3736)))+(((r12)*(x3735)))+(((IkReal(-1.00000000000000))*(x3741)))+(((IkReal(-1.00000000000000))*(r10)*(x3744)))+(((IkReal(-1.00000000000000))*(sj1)*(x3742)))+(((r10)*(x3734))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
IkReal x3745=((sj4)*(sj5));
IkReal x3746=((IkReal(0.390000000000000))*(sj5));
IkReal x3747=((r21)*(sj6));
IkReal x3748=((IkReal(0.390000000000000))*(cj5));
IkReal x3749=((cj6)*(r00));
IkReal x3750=((IkReal(0.000500000000000000))*(cj6));
IkReal x3751=((r11)*(sj6));
IkReal x3752=((cj5)*(sj4));
IkReal x3753=((IkReal(1.00000000000000))*(r20));
IkReal x3754=((cj4)*(sj6));
IkReal x3755=((r01)*(sj6));
IkReal x3756=((IkReal(0.000500000000000000))*(sj6));
IkReal x3757=((IkReal(1.00000000000000))*(r10));
IkReal x3758=((IkReal(1.00000000000000))*(cj4)*(cj6));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((((r20)*(x3756)))+(((cj6)*(r20)*(x3746)))+(((IkReal(-1.00000000000000))*(x3746)*(x3747)))+(((r22)*(x3748)))+(((IkReal(-1.00000000000000))*(pz)))+(((r21)*(x3750)))+(((IkReal(-0.00200000000000000))*(cj2))));
evalcond[2]=((IkReal(-0.400000000000000))+(((r00)*(x3756)))+(((r01)*(x3750)))+(((IkReal(-1.00000000000000))*(x3746)*(x3755)))+(((IkReal(-1.00000000000000))*(px)))+(((r02)*(x3748)))+(((x3746)*(x3749))));
evalcond[3]=((((r12)*(x3748)))+(((IkReal(-1.00000000000000))*(x3746)*(x3751)))+(((r11)*(x3750)))+(((r10)*(x3756)))+(((IkReal(-1.00000000000000))*(py)))+(((IkReal(-0.00200000000000000))*(sj2)))+(((cj6)*(r10)*(x3746))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r21)*(x3758)))+(((IkReal(-1.00000000000000))*(x3753)*(x3754)))+(((IkReal(-1.00000000000000))*(cj6)*(x3752)*(x3753)))+(((r22)*(x3745)))+(((x3747)*(x3752)))+(((IkReal(-1.00000000000000))*(cj2))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r01)*(x3758)))+(((x3752)*(x3755)))+(((r02)*(x3745)))+(((IkReal(-1.00000000000000))*(x3749)*(x3752)))+(((IkReal(-1.00000000000000))*(r00)*(x3754))));
evalcond[6]=((((IkReal(-1.00000000000000))*(sj2)))+(((x3751)*(x3752)))+(((r12)*(x3745)))+(((IkReal(-1.00000000000000))*(r11)*(x3758)))+(((IkReal(-1.00000000000000))*(cj6)*(x3752)*(x3757)))+(((IkReal(-1.00000000000000))*(x3754)*(x3757))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3759=((IkReal(1.00000000000000))*(cj6));
IkReal x3760=((IkReal(1.00000000000000))*(cj5));
IkReal x3761=((r01)*(sj6));
if( IKabs(((((IkReal(-1.00000000000000))*(cj4)*(r02)*(sj5)))+(((IkReal(-1.00000000000000))*(cj4)*(x3760)*(x3761)))+(((IkReal(-1.00000000000000))*(r01)*(sj4)*(x3759)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(sj6)))+(((cj4)*(cj5)*(cj6)*(r00))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((sj5)*(x3761)))+(((IkReal(-1.00000000000000))*(r00)*(sj5)*(x3759)))+(((IkReal(-1.00000000000000))*(r02)*(x3760))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(cj4)*(r02)*(sj5)))+(((IkReal(-1.00000000000000))*(cj4)*(x3760)*(x3761)))+(((IkReal(-1.00000000000000))*(r01)*(sj4)*(x3759)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(sj6)))+(((cj4)*(cj5)*(cj6)*(r00)))))+IKsqr(((((sj5)*(x3761)))+(((IkReal(-1.00000000000000))*(r00)*(sj5)*(x3759)))+(((IkReal(-1.00000000000000))*(r02)*(x3760)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(cj4)*(r02)*(sj5)))+(((IkReal(-1.00000000000000))*(cj4)*(x3760)*(x3761)))+(((IkReal(-1.00000000000000))*(r01)*(sj4)*(x3759)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(sj6)))+(((cj4)*(cj5)*(cj6)*(r00)))), ((((sj5)*(x3761)))+(((IkReal(-1.00000000000000))*(r00)*(sj5)*(x3759)))+(((IkReal(-1.00000000000000))*(r02)*(x3760)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x3762=IKsin(j3);
IkReal x3763=IKcos(j3);
IkReal x3764=((r11)*(sj6));
IkReal x3765=((IkReal(1.00000000000000))*(sj5));
IkReal x3766=((sj4)*(sj6));
IkReal x3767=((cj4)*(sj5));
IkReal x3768=((cj6)*(sj4));
IkReal x3769=((cj4)*(cj5));
IkReal x3770=((r01)*(sj6));
IkReal x3771=((r21)*(sj6));
IkReal x3772=((cj6)*(sj5));
IkReal x3773=((IkReal(1.00000000000000))*(cj6)*(x3769));
evalcond[0]=((((cj5)*(r22)))+(((sj2)*(x3762)))+(((IkReal(-1.00000000000000))*(x3765)*(x3771)))+(((r20)*(x3772))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x3765)*(x3770)))+(x3763)+(((r00)*(x3772)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(cj2)*(x3762)))+(((IkReal(-1.00000000000000))*(x3764)*(x3765)))+(((r10)*(x3772))));
evalcond[3]=((((r22)*(x3767)))+(((IkReal(-1.00000000000000))*(r20)*(x3773)))+(((r21)*(x3768)))+(((x3769)*(x3771)))+(((IkReal(-1.00000000000000))*(sj2)*(x3763)))+(((r20)*(x3766))));
evalcond[4]=((((r02)*(x3767)))+(((x3769)*(x3770)))+(x3762)+(((IkReal(-1.00000000000000))*(r00)*(x3773)))+(((r00)*(x3766)))+(((r01)*(x3768))));
evalcond[5]=((((r10)*(x3766)))+(((cj2)*(x3763)))+(((r11)*(x3768)))+(((r12)*(x3767)))+(((x3764)*(x3769)))+(((IkReal(-1.00000000000000))*(r10)*(x3773))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x3774=((sj4)*(sj5));
IkReal x3775=((IkReal(0.390000000000000))*(sj5));
IkReal x3776=((r21)*(sj6));
IkReal x3777=((IkReal(0.390000000000000))*(cj5));
IkReal x3778=((cj6)*(r00));
IkReal x3779=((IkReal(0.000500000000000000))*(cj6));
IkReal x3780=((r11)*(sj6));
IkReal x3781=((cj5)*(sj4));
IkReal x3782=((IkReal(1.00000000000000))*(r20));
IkReal x3783=((cj4)*(sj6));
IkReal x3784=((r01)*(sj6));
IkReal x3785=((IkReal(0.000500000000000000))*(sj6));
IkReal x3786=((IkReal(1.00000000000000))*(r10));
IkReal x3787=((IkReal(1.00000000000000))*(cj4)*(cj6));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((((r21)*(x3779)))+(((r22)*(x3777)))+(((cj6)*(r20)*(x3775)))+(((r20)*(x3785)))+(((IkReal(-1.00000000000000))*(pz)))+(((IkReal(-1.00000000000000))*(x3775)*(x3776)))+(((IkReal(-0.00200000000000000))*(cj2))));
evalcond[2]=((IkReal(0.400000000000000))+(((r02)*(x3777)))+(((x3775)*(x3778)))+(((IkReal(-1.00000000000000))*(px)))+(((r00)*(x3785)))+(((IkReal(-1.00000000000000))*(x3775)*(x3784)))+(((r01)*(x3779))));
evalcond[3]=((((cj6)*(r10)*(x3775)))+(((IkReal(0.00200000000000000))*(sj2)))+(((IkReal(-1.00000000000000))*(py)))+(((r11)*(x3779)))+(((r12)*(x3777)))+(((IkReal(-1.00000000000000))*(x3775)*(x3780)))+(((r10)*(x3785))));
evalcond[4]=((((r22)*(x3774)))+(((IkReal(-1.00000000000000))*(x3782)*(x3783)))+(((IkReal(-1.00000000000000))*(cj6)*(x3781)*(x3782)))+(((x3776)*(x3781)))+(((IkReal(-1.00000000000000))*(r21)*(x3787)))+(((IkReal(-1.00000000000000))*(cj2))));
evalcond[5]=((((r02)*(x3774)))+(((IkReal(-1.00000000000000))*(r01)*(x3787)))+(((IkReal(-1.00000000000000))*(r00)*(x3783)))+(((IkReal(-1.00000000000000))*(x3778)*(x3781)))+(((x3781)*(x3784))));
evalcond[6]=((sj2)+(((IkReal(-1.00000000000000))*(cj6)*(x3781)*(x3786)))+(((IkReal(-1.00000000000000))*(r11)*(x3787)))+(((IkReal(-1.00000000000000))*(x3783)*(x3786)))+(((r12)*(x3774)))+(((x3780)*(x3781))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3788=((cj4)*(cj5));
IkReal x3789=((r01)*(sj6));
IkReal x3790=((cj6)*(r00));
if( IKabs(((((r00)*(sj4)*(sj6)))+(((cj6)*(r01)*(sj4)))+(((x3788)*(x3789)))+(((cj4)*(r02)*(sj5)))+(((IkReal(-1.00000000000000))*(x3788)*(x3790))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((sj5)*(x3790)))+(((IkReal(-1.00000000000000))*(sj5)*(x3789)))+(((cj5)*(r02))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((r00)*(sj4)*(sj6)))+(((cj6)*(r01)*(sj4)))+(((x3788)*(x3789)))+(((cj4)*(r02)*(sj5)))+(((IkReal(-1.00000000000000))*(x3788)*(x3790)))))+IKsqr(((((sj5)*(x3790)))+(((IkReal(-1.00000000000000))*(sj5)*(x3789)))+(((cj5)*(r02)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((r00)*(sj4)*(sj6)))+(((cj6)*(r01)*(sj4)))+(((x3788)*(x3789)))+(((cj4)*(r02)*(sj5)))+(((IkReal(-1.00000000000000))*(x3788)*(x3790)))), ((((sj5)*(x3790)))+(((IkReal(-1.00000000000000))*(sj5)*(x3789)))+(((cj5)*(r02)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x3791=IKsin(j3);
IkReal x3792=IKcos(j3);
IkReal x3793=((r11)*(sj6));
IkReal x3794=((IkReal(1.00000000000000))*(sj5));
IkReal x3795=((cj6)*(sj4));
IkReal x3796=((sj4)*(sj6));
IkReal x3797=((cj4)*(sj5));
IkReal x3798=((cj4)*(cj5));
IkReal x3799=((r01)*(sj6));
IkReal x3800=((r21)*(sj6));
IkReal x3801=((cj6)*(sj5));
IkReal x3802=((IkReal(1.00000000000000))*(x3792));
IkReal x3803=((IkReal(1.00000000000000))*(cj6)*(x3798));
evalcond[0]=((((cj5)*(r22)))+(((sj2)*(x3791)))+(((IkReal(-1.00000000000000))*(x3794)*(x3800)))+(((r20)*(x3801))));
evalcond[1]=((((r00)*(x3801)))+(((IkReal(-1.00000000000000))*(x3802)))+(((IkReal(-1.00000000000000))*(x3794)*(x3799)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((cj2)*(x3791)))+(((r10)*(x3801)))+(((IkReal(-1.00000000000000))*(x3793)*(x3794))));
evalcond[3]=((((r21)*(x3795)))+(((IkReal(-1.00000000000000))*(sj2)*(x3802)))+(((r22)*(x3797)))+(((x3798)*(x3800)))+(((IkReal(-1.00000000000000))*(r20)*(x3803)))+(((r20)*(x3796))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x3791)))+(((IkReal(-1.00000000000000))*(r00)*(x3803)))+(((x3798)*(x3799)))+(((r02)*(x3797)))+(((r00)*(x3796)))+(((r01)*(x3795))));
evalcond[5]=((((x3793)*(x3798)))+(((IkReal(-1.00000000000000))*(cj2)*(x3802)))+(((r10)*(x3796)))+(((r12)*(x3797)))+(((r11)*(x3795)))+(((IkReal(-1.00000000000000))*(r10)*(x3803))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x3804=((sj4)*(sj5));
IkReal x3805=((IkReal(0.390000000000000))*(sj5));
IkReal x3806=((r21)*(sj6));
IkReal x3807=((IkReal(0.390000000000000))*(cj5));
IkReal x3808=((cj6)*(r00));
IkReal x3809=((IkReal(0.000500000000000000))*(cj6));
IkReal x3810=((r11)*(sj6));
IkReal x3811=((cj5)*(sj4));
IkReal x3812=((r01)*(sj6));
IkReal x3813=((IkReal(1.00000000000000))*(r20));
IkReal x3814=((cj4)*(sj6));
IkReal x3815=((IkReal(0.000500000000000000))*(sj6));
IkReal x3816=((IkReal(1.00000000000000))*(r10));
IkReal x3817=((IkReal(1.00000000000000))*(cj4)*(cj6));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x3805)*(x3806)))+(((r21)*(x3809)))+(((r22)*(x3807)))+(((IkReal(-1.00000000000000))*(pz)))+(((r20)*(x3815)))+(((cj6)*(r20)*(x3805))));
evalcond[2]=((((r01)*(x3809)))+(((x3805)*(x3808)))+(((r02)*(x3807)))+(((IkReal(-1.00000000000000))*(px)))+(((IkReal(-0.00200000000000000))*(cj1)))+(((IkReal(-0.400000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(x3805)*(x3812)))+(((r00)*(x3815))));
evalcond[3]=((((r11)*(x3809)))+(((r12)*(x3807)))+(((IkReal(0.400000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(py)))+(((r10)*(x3815)))+(((IkReal(-0.00200000000000000))*(sj1)))+(((cj6)*(r10)*(x3805)))+(((IkReal(-1.00000000000000))*(x3805)*(x3810))));
evalcond[4]=((((r22)*(x3804)))+(((x3806)*(x3811)))+(((IkReal(-1.00000000000000))*(x3813)*(x3814)))+(((IkReal(-1.00000000000000))*(cj6)*(x3811)*(x3813)))+(((IkReal(-1.00000000000000))*(r21)*(x3817))));
evalcond[5]=((((x3811)*(x3812)))+(((IkReal(-1.00000000000000))*(r01)*(x3817)))+(((IkReal(-1.00000000000000))*(r00)*(x3814)))+(((r02)*(x3804)))+(((IkReal(-1.00000000000000))*(x3808)*(x3811)))+(((IkReal(-1.00000000000000))*(cj1))));
evalcond[6]=((((x3810)*(x3811)))+(((IkReal(-1.00000000000000))*(sj1)))+(((r12)*(x3804)))+(((IkReal(-1.00000000000000))*(x3814)*(x3816)))+(((IkReal(-1.00000000000000))*(cj6)*(x3811)*(x3816)))+(((IkReal(-1.00000000000000))*(r11)*(x3817))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3818=((cj4)*(cj5));
IkReal x3819=((r21)*(sj6));
IkReal x3820=((IkReal(1.00000000000000))*(cj6)*(r20));
if( IKabs(((((IkReal(-1.00000000000000))*(sj5)*(x3820)))+(((sj5)*(x3819)))+(((IkReal(-1.00000000000000))*(cj5)*(r22))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((cj4)*(r22)*(sj5)))+(((x3818)*(x3819)))+(((cj6)*(r21)*(sj4)))+(((r20)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(x3818)*(x3820))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(sj5)*(x3820)))+(((sj5)*(x3819)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))))+IKsqr(((((cj4)*(r22)*(sj5)))+(((x3818)*(x3819)))+(((cj6)*(r21)*(sj4)))+(((r20)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(x3818)*(x3820)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(sj5)*(x3820)))+(((sj5)*(x3819)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))), ((((cj4)*(r22)*(sj5)))+(((x3818)*(x3819)))+(((cj6)*(r21)*(sj4)))+(((r20)*(sj4)*(sj6)))+(((IkReal(-1.00000000000000))*(x3818)*(x3820)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x3821=IKcos(j3);
IkReal x3822=IKsin(j3);
IkReal x3823=((r11)*(sj6));
IkReal x3824=((IkReal(1.00000000000000))*(sj5));
IkReal x3825=((IkReal(1.00000000000000))*(cj1));
IkReal x3826=((cj6)*(sj4));
IkReal x3827=((sj4)*(sj6));
IkReal x3828=((cj4)*(sj5));
IkReal x3829=((cj4)*(cj5));
IkReal x3830=((r01)*(sj6));
IkReal x3831=((r21)*(sj6));
IkReal x3832=((cj6)*(sj5));
IkReal x3833=((IkReal(1.00000000000000))*(cj6)*(x3829));
evalcond[0]=((((cj5)*(r22)))+(((r20)*(x3832)))+(x3822)+(((IkReal(-1.00000000000000))*(x3824)*(x3831))));
evalcond[1]=((((r00)*(x3832)))+(((sj1)*(x3821)))+(((IkReal(-1.00000000000000))*(x3824)*(x3830)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x3821)*(x3825)))+(((IkReal(-1.00000000000000))*(x3823)*(x3824)))+(((r10)*(x3832))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r20)*(x3833)))+(((x3829)*(x3831)))+(((IkReal(-1.00000000000000))*(x3821)))+(((r22)*(x3828)))+(((r20)*(x3827)))+(((r21)*(x3826))));
evalcond[4]=((((x3829)*(x3830)))+(((r02)*(x3828)))+(((IkReal(-1.00000000000000))*(r00)*(x3833)))+(((sj1)*(x3822)))+(((r01)*(x3826)))+(((r00)*(x3827))));
evalcond[5]=((((r12)*(x3828)))+(((IkReal(-1.00000000000000))*(r10)*(x3833)))+(((r11)*(x3826)))+(((IkReal(-1.00000000000000))*(x3822)*(x3825)))+(((r10)*(x3827)))+(((x3823)*(x3829))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x3834=((sj4)*(sj5));
IkReal x3835=((IkReal(0.390000000000000))*(sj5));
IkReal x3836=((r21)*(sj6));
IkReal x3837=((IkReal(0.390000000000000))*(cj5));
IkReal x3838=((cj6)*(r00));
IkReal x3839=((IkReal(0.000500000000000000))*(cj6));
IkReal x3840=((r11)*(sj6));
IkReal x3841=((cj5)*(sj4));
IkReal x3842=((r01)*(sj6));
IkReal x3843=((IkReal(1.00000000000000))*(r20));
IkReal x3844=((cj4)*(sj6));
IkReal x3845=((IkReal(0.000500000000000000))*(sj6));
IkReal x3846=((IkReal(1.00000000000000))*(r10));
IkReal x3847=((IkReal(1.00000000000000))*(cj4)*(cj6));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((cj6)*(r20)*(x3835)))+(((r20)*(x3845)))+(((IkReal(-1.00000000000000))*(pz)))+(((r21)*(x3839)))+(((IkReal(-1.00000000000000))*(x3835)*(x3836)))+(((r22)*(x3837))));
evalcond[2]=((((x3835)*(x3838)))+(((r02)*(x3837)))+(((r01)*(x3839)))+(((IkReal(0.00200000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(x3835)*(x3842)))+(((IkReal(-1.00000000000000))*(px)))+(((r00)*(x3845)))+(((IkReal(-0.400000000000000))*(sj1))));
evalcond[3]=((((IkReal(0.400000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(x3835)*(x3840)))+(((IkReal(0.00200000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(py)))+(((r12)*(x3837)))+(((cj6)*(r10)*(x3835)))+(((r11)*(x3839)))+(((r10)*(x3845))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r21)*(x3847)))+(((IkReal(-1.00000000000000))*(x3843)*(x3844)))+(((x3836)*(x3841)))+(((IkReal(-1.00000000000000))*(cj6)*(x3841)*(x3843)))+(((r22)*(x3834))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r00)*(x3844)))+(((IkReal(-1.00000000000000))*(x3838)*(x3841)))+(cj1)+(((r02)*(x3834)))+(((x3841)*(x3842)))+(((IkReal(-1.00000000000000))*(r01)*(x3847))));
evalcond[6]=((sj1)+(((IkReal(-1.00000000000000))*(x3844)*(x3846)))+(((IkReal(-1.00000000000000))*(r11)*(x3847)))+(((r12)*(x3834)))+(((IkReal(-1.00000000000000))*(cj6)*(x3841)*(x3846)))+(((x3840)*(x3841))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3848=((cj4)*(cj5));
IkReal x3849=((cj6)*(r20));
IkReal x3850=((IkReal(1.00000000000000))*(sj4));
IkReal x3851=((IkReal(1.00000000000000))*(r21)*(sj6));
if( IKabs(((((cj5)*(r22)))+(((sj5)*(x3849)))+(((IkReal(-1.00000000000000))*(sj5)*(x3851))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(x3848)*(x3851)))+(((x3848)*(x3849)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x3850)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x3850))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((cj5)*(r22)))+(((sj5)*(x3849)))+(((IkReal(-1.00000000000000))*(sj5)*(x3851)))))+IKsqr(((((IkReal(-1.00000000000000))*(x3848)*(x3851)))+(((x3848)*(x3849)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x3850)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x3850)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((cj5)*(r22)))+(((sj5)*(x3849)))+(((IkReal(-1.00000000000000))*(sj5)*(x3851)))), ((((IkReal(-1.00000000000000))*(x3848)*(x3851)))+(((x3848)*(x3849)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x3850)))+(((IkReal(-1.00000000000000))*(cj6)*(r21)*(x3850)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x3852=IKcos(j3);
IkReal x3853=IKsin(j3);
IkReal x3854=((r11)*(sj6));
IkReal x3855=((IkReal(1.00000000000000))*(sj5));
IkReal x3856=((IkReal(1.00000000000000))*(cj1));
IkReal x3857=((sj4)*(sj6));
IkReal x3858=((cj4)*(sj5));
IkReal x3859=((cj6)*(sj4));
IkReal x3860=((cj4)*(cj5));
IkReal x3861=((r01)*(sj6));
IkReal x3862=((r21)*(sj6));
IkReal x3863=((cj6)*(sj5));
IkReal x3864=((IkReal(1.00000000000000))*(cj6)*(x3860));
evalcond[0]=((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(x3853)))+(((r20)*(x3863)))+(((IkReal(-1.00000000000000))*(x3855)*(x3862))));
evalcond[1]=((((r00)*(x3863)))+(((IkReal(-1.00000000000000))*(x3855)*(x3861)))+(((sj1)*(x3852)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x3854)*(x3855)))+(((r10)*(x3863)))+(((IkReal(-1.00000000000000))*(x3852)*(x3856))));
evalcond[3]=((((x3860)*(x3862)))+(((IkReal(-1.00000000000000))*(r20)*(x3864)))+(((r21)*(x3859)))+(((r20)*(x3857)))+(x3852)+(((r22)*(x3858))));
evalcond[4]=((((r02)*(x3858)))+(((x3860)*(x3861)))+(((r01)*(x3859)))+(((r00)*(x3857)))+(((IkReal(-1.00000000000000))*(r00)*(x3864)))+(((sj1)*(x3853))));
evalcond[5]=((((r11)*(x3859)))+(((r10)*(x3857)))+(((IkReal(-1.00000000000000))*(r10)*(x3864)))+(((IkReal(-1.00000000000000))*(x3853)*(x3856)))+(((r12)*(x3858)))+(((x3854)*(x3860))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3865=((IKabs(sj2) != 0)?((IkReal)1/(sj2)):(IkReal)1.0e30);
IkReal x3866=((IkReal(1.00000000000000))*(sj5));
IkReal x3867=((cj2)*(sj1));
IkReal x3868=((r21)*(sj6));
IkReal x3869=((cj6)*(r20));
IkReal x3870=((cj5)*(r22));
if( IKabs(((x3865)*(((((IkReal(-1.00000000000000))*(x3866)*(x3869)))+(((sj5)*(x3868)))+(((IkReal(-1.00000000000000))*(x3870))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((x3865)*(((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((cj5)*(r12)*(sj2)))+(((x3867)*(x3870)))+(((sj5)*(x3867)*(x3869)))+(((IkReal(-1.00000000000000))*(r11)*(sj2)*(sj6)*(x3866)))+(((IkReal(-1.00000000000000))*(x3866)*(x3867)*(x3868)))+(((cj6)*(r10)*(sj2)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x3865)*(((((IkReal(-1.00000000000000))*(x3866)*(x3869)))+(((sj5)*(x3868)))+(((IkReal(-1.00000000000000))*(x3870)))))))+IKsqr(((x3865)*(((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((cj5)*(r12)*(sj2)))+(((x3867)*(x3870)))+(((sj5)*(x3867)*(x3869)))+(((IkReal(-1.00000000000000))*(r11)*(sj2)*(sj6)*(x3866)))+(((IkReal(-1.00000000000000))*(x3866)*(x3867)*(x3868)))+(((cj6)*(r10)*(sj2)*(sj5)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((x3865)*(((((IkReal(-1.00000000000000))*(x3866)*(x3869)))+(((sj5)*(x3868)))+(((IkReal(-1.00000000000000))*(x3870)))))), ((x3865)*(((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((cj5)*(r12)*(sj2)))+(((x3867)*(x3870)))+(((sj5)*(x3867)*(x3869)))+(((IkReal(-1.00000000000000))*(r11)*(sj2)*(sj6)*(x3866)))+(((IkReal(-1.00000000000000))*(x3866)*(x3867)*(x3868)))+(((cj6)*(r10)*(sj2)*(sj5)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x3871=IKsin(j3);
IkReal x3872=IKcos(j3);
IkReal x3873=((r11)*(sj6));
IkReal x3874=((IkReal(1.00000000000000))*(sj5));
IkReal x3875=((sj4)*(sj6));
IkReal x3876=((cj4)*(sj5));
IkReal x3877=((cj6)*(sj4));
IkReal x3878=((cj4)*(cj5));
IkReal x3879=((r01)*(sj6));
IkReal x3880=((r21)*(sj6));
IkReal x3881=((cj6)*(sj5));
IkReal x3882=((IkReal(1.00000000000000))*(x3872));
IkReal x3883=((sj1)*(x3872));
IkReal x3884=((IkReal(1.00000000000000))*(cj6)*(x3878));
IkReal x3885=((IkReal(1.00000000000000))*(cj2)*(x3871));
evalcond[0]=((((cj5)*(r22)))+(((r20)*(x3881)))+(((IkReal(-1.00000000000000))*(x3874)*(x3880)))+(((sj2)*(x3871))));
evalcond[1]=((((IkReal(-1.00000000000000))*(cj1)*(x3885)))+(((IkReal(-1.00000000000000))*(x3874)*(x3879)))+(((r00)*(x3881)))+(x3883)+(((cj5)*(r02))));
evalcond[2]=((((IkReal(-1.00000000000000))*(cj1)*(x3882)))+(((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x3873)*(x3874)))+(((IkReal(-1.00000000000000))*(sj1)*(x3885)))+(((r10)*(x3881))));
evalcond[3]=((((r20)*(x3875)))+(((x3878)*(x3880)))+(((IkReal(-1.00000000000000))*(r20)*(x3884)))+(((r22)*(x3876)))+(((r21)*(x3877)))+(((IkReal(-1.00000000000000))*(sj2)*(x3882))));
evalcond[4]=((((r00)*(x3875)))+(((cj1)*(cj2)*(x3872)))+(((r01)*(x3877)))+(((IkReal(-1.00000000000000))*(r00)*(x3884)))+(((sj1)*(x3871)))+(((x3878)*(x3879)))+(((r02)*(x3876))));
evalcond[5]=((((IkReal(-1.00000000000000))*(cj1)*(x3871)))+(((cj2)*(x3883)))+(((x3873)*(x3878)))+(((r10)*(x3875)))+(((IkReal(-1.00000000000000))*(r10)*(x3884)))+(((r12)*(x3876)))+(((r11)*(x3877))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3886=(sj1)*(sj1);
IkReal x3887=(cj1)*(cj1);
IkReal x3888=((cj5)*(r12));
IkReal x3889=((cj6)*(sj5));
IkReal x3890=((IkReal(1.00000000000000))*(sj1));
IkReal x3891=((cj5)*(r02));
IkReal x3892=((IkReal(1.00000000000000))*(cj1));
IkReal x3893=((r01)*(sj5)*(sj6));
IkReal x3894=((r11)*(sj5)*(sj6));
if( IKabs(((((IKabs(((((cj2)*(x3887)))+(((cj2)*(x3886))))) != 0)?((IkReal)1/(((((cj2)*(x3887)))+(((cj2)*(x3886)))))):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(x3892)*(x3893)))+(((cj1)*(r00)*(x3889)))+(((cj1)*(x3891)))+(((r10)*(sj1)*(x3889)))+(((sj1)*(x3888)))+(((IkReal(-1.00000000000000))*(x3890)*(x3894))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IKabs(((x3887)+(x3886))) != 0)?((IkReal)1/(((x3887)+(x3886)))):(IkReal)1.0e30))*(((((cj1)*(x3888)))+(((IkReal(-1.00000000000000))*(r00)*(x3889)*(x3890)))+(((sj1)*(x3893)))+(((IkReal(-1.00000000000000))*(x3892)*(x3894)))+(((cj1)*(r10)*(x3889)))+(((IkReal(-1.00000000000000))*(x3890)*(x3891))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IKabs(((((cj2)*(x3887)))+(((cj2)*(x3886))))) != 0)?((IkReal)1/(((((cj2)*(x3887)))+(((cj2)*(x3886)))))):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(x3892)*(x3893)))+(((cj1)*(r00)*(x3889)))+(((cj1)*(x3891)))+(((r10)*(sj1)*(x3889)))+(((sj1)*(x3888)))+(((IkReal(-1.00000000000000))*(x3890)*(x3894)))))))+IKsqr(((((IKabs(((x3887)+(x3886))) != 0)?((IkReal)1/(((x3887)+(x3886)))):(IkReal)1.0e30))*(((((cj1)*(x3888)))+(((IkReal(-1.00000000000000))*(r00)*(x3889)*(x3890)))+(((sj1)*(x3893)))+(((IkReal(-1.00000000000000))*(x3892)*(x3894)))+(((cj1)*(r10)*(x3889)))+(((IkReal(-1.00000000000000))*(x3890)*(x3891)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IKabs(((((cj2)*(x3887)))+(((cj2)*(x3886))))) != 0)?((IkReal)1/(((((cj2)*(x3887)))+(((cj2)*(x3886)))))):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(x3892)*(x3893)))+(((cj1)*(r00)*(x3889)))+(((cj1)*(x3891)))+(((r10)*(sj1)*(x3889)))+(((sj1)*(x3888)))+(((IkReal(-1.00000000000000))*(x3890)*(x3894)))))), ((((IKabs(((x3887)+(x3886))) != 0)?((IkReal)1/(((x3887)+(x3886)))):(IkReal)1.0e30))*(((((cj1)*(x3888)))+(((IkReal(-1.00000000000000))*(r00)*(x3889)*(x3890)))+(((sj1)*(x3893)))+(((IkReal(-1.00000000000000))*(x3892)*(x3894)))+(((cj1)*(r10)*(x3889)))+(((IkReal(-1.00000000000000))*(x3890)*(x3891)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x3895=IKsin(j3);
IkReal x3896=IKcos(j3);
IkReal x3897=((r11)*(sj6));
IkReal x3898=((IkReal(1.00000000000000))*(sj5));
IkReal x3899=((sj4)*(sj6));
IkReal x3900=((cj4)*(sj5));
IkReal x3901=((cj6)*(sj4));
IkReal x3902=((cj4)*(cj5));
IkReal x3903=((r01)*(sj6));
IkReal x3904=((r21)*(sj6));
IkReal x3905=((cj6)*(sj5));
IkReal x3906=((IkReal(1.00000000000000))*(x3896));
IkReal x3907=((sj1)*(x3896));
IkReal x3908=((IkReal(1.00000000000000))*(cj6)*(x3902));
IkReal x3909=((IkReal(1.00000000000000))*(cj2)*(x3895));
evalcond[0]=((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(x3898)*(x3904)))+(((r20)*(x3905)))+(((sj2)*(x3895))));
evalcond[1]=((((r00)*(x3905)))+(x3907)+(((IkReal(-1.00000000000000))*(x3898)*(x3903)))+(((IkReal(-1.00000000000000))*(cj1)*(x3909)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((r10)*(x3905)))+(((IkReal(-1.00000000000000))*(sj1)*(x3909)))+(((IkReal(-1.00000000000000))*(x3897)*(x3898)))+(((IkReal(-1.00000000000000))*(cj1)*(x3906))));
evalcond[3]=((((r20)*(x3899)))+(((r22)*(x3900)))+(((x3902)*(x3904)))+(((IkReal(-1.00000000000000))*(sj2)*(x3906)))+(((r21)*(x3901)))+(((IkReal(-1.00000000000000))*(r20)*(x3908))));
evalcond[4]=((((cj1)*(cj2)*(x3896)))+(((x3902)*(x3903)))+(((r01)*(x3901)))+(((sj1)*(x3895)))+(((r00)*(x3899)))+(((IkReal(-1.00000000000000))*(r00)*(x3908)))+(((r02)*(x3900))));
evalcond[5]=((((r10)*(x3899)))+(((x3897)*(x3902)))+(((IkReal(-1.00000000000000))*(cj1)*(x3895)))+(((r12)*(x3900)))+(((r11)*(x3901)))+(((IkReal(-1.00000000000000))*(r10)*(x3908)))+(((cj2)*(x3907))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3910=((cj4)*(cj5));
IkReal x3911=((r21)*(sj6));
IkReal x3912=((IkReal(1.00000000000000))*(cj6)*(r20));
if( IKabs(((gconst4)*(((((sj5)*(x3911)))+(((IkReal(-1.00000000000000))*(sj5)*(x3912)))+(((IkReal(-1.00000000000000))*(cj5)*(r22))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst4)*(((((x3910)*(x3911)))+(((cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(x3910)*(x3912)))+(((cj6)*(r21)*(sj4)))+(((r20)*(sj4)*(sj6))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst4)*(((((sj5)*(x3911)))+(((IkReal(-1.00000000000000))*(sj5)*(x3912)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))))), ((gconst4)*(((((x3910)*(x3911)))+(((cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(x3910)*(x3912)))+(((cj6)*(r21)*(sj4)))+(((r20)*(sj4)*(sj6)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x3913=IKsin(j3);
IkReal x3914=IKcos(j3);
IkReal x3915=((r11)*(sj6));
IkReal x3916=((IkReal(1.00000000000000))*(sj5));
IkReal x3917=((sj4)*(sj6));
IkReal x3918=((cj4)*(sj5));
IkReal x3919=((cj6)*(sj4));
IkReal x3920=((cj4)*(cj5));
IkReal x3921=((r01)*(sj6));
IkReal x3922=((r21)*(sj6));
IkReal x3923=((cj6)*(sj5));
IkReal x3924=((IkReal(1.00000000000000))*(x3914));
IkReal x3925=((sj1)*(x3914));
IkReal x3926=((IkReal(1.00000000000000))*(cj6)*(x3920));
IkReal x3927=((IkReal(1.00000000000000))*(cj2)*(x3913));
evalcond[0]=((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(x3916)*(x3922)))+(((sj2)*(x3913)))+(((r20)*(x3923))));
evalcond[1]=((((IkReal(-1.00000000000000))*(cj1)*(x3927)))+(((IkReal(-1.00000000000000))*(x3916)*(x3921)))+(x3925)+(((cj5)*(r02)))+(((r00)*(x3923))));
evalcond[2]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x3915)*(x3916)))+(((IkReal(-1.00000000000000))*(cj1)*(x3924)))+(((r10)*(x3923)))+(((IkReal(-1.00000000000000))*(sj1)*(x3927))));
evalcond[3]=((((r21)*(x3919)))+(((x3920)*(x3922)))+(((IkReal(-1.00000000000000))*(r20)*(x3926)))+(((r20)*(x3917)))+(((IkReal(-1.00000000000000))*(sj2)*(x3924)))+(((r22)*(x3918))));
evalcond[4]=((((cj1)*(cj2)*(x3914)))+(((x3920)*(x3921)))+(((sj1)*(x3913)))+(((r00)*(x3917)))+(((r01)*(x3919)))+(((r02)*(x3918)))+(((IkReal(-1.00000000000000))*(r00)*(x3926))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(x3926)))+(((cj2)*(x3925)))+(((IkReal(-1.00000000000000))*(cj1)*(x3913)))+(((r10)*(x3917)))+(((r11)*(x3919)))+(((x3915)*(x3920)))+(((r12)*(x3918))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x3928=((cj2)*(sj6));
IkReal x3929=((cj2)*(cj6));
IkReal x3930=((IkReal(1.00000000000000))*(cj1)*(sj2));
if( IKabs(((gconst0)*(((((IkReal(-1.00000000000000))*(cj6)*(r21)*(x3930)))+(((r01)*(x3929)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x3930)))+(((r00)*(x3928))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst0)*(((((IkReal(-1.00000000000000))*(cj5)*(r21)*(sj6)*(x3930)))+(((cj5)*(r01)*(x3928)))+(((cj2)*(r02)*(sj5)))+(((cj1)*(cj5)*(cj6)*(r20)*(sj2)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x3930)))+(((IkReal(-1.00000000000000))*(cj5)*(r00)*(x3929))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst0)*(((((IkReal(-1.00000000000000))*(cj6)*(r21)*(x3930)))+(((r01)*(x3929)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x3930)))+(((r00)*(x3928)))))), ((gconst0)*(((((IkReal(-1.00000000000000))*(cj5)*(r21)*(sj6)*(x3930)))+(((cj5)*(r01)*(x3928)))+(((cj2)*(r02)*(sj5)))+(((cj1)*(cj5)*(cj6)*(r20)*(sj2)))+(((IkReal(-1.00000000000000))*(r22)*(sj5)*(x3930)))+(((IkReal(-1.00000000000000))*(cj5)*(r00)*(x3929)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[3];
IkReal x3931=IKsin(j4);
IkReal x3932=IKcos(j4);
IkReal x3933=((IkReal(1.00000000000000))*(sj2));
IkReal x3934=((IkReal(1.00000000000000))*(cj6));
IkReal x3935=((sj5)*(x3931));
IkReal x3936=((cj5)*(x3931));
IkReal x3937=((IkReal(1.00000000000000))*(sj6)*(x3932));
evalcond[0]=((((r22)*(x3935)))+(((IkReal(-1.00000000000000))*(r21)*(x3932)*(x3934)))+(((IkReal(-1.00000000000000))*(r20)*(x3934)*(x3936)))+(((IkReal(-1.00000000000000))*(r20)*(x3937)))+(((r21)*(sj6)*(x3936)))+(((IkReal(-1.00000000000000))*(cj2))));
evalcond[1]=((((r01)*(sj6)*(x3936)))+(((IkReal(-1.00000000000000))*(r01)*(x3932)*(x3934)))+(((IkReal(-1.00000000000000))*(cj1)*(x3933)))+(((IkReal(-1.00000000000000))*(r00)*(x3937)))+(((IkReal(-1.00000000000000))*(r00)*(x3934)*(x3936)))+(((r02)*(x3935))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r10)*(x3934)*(x3936)))+(((IkReal(-1.00000000000000))*(r11)*(x3932)*(x3934)))+(((IkReal(-1.00000000000000))*(sj1)*(x3933)))+(((r11)*(sj6)*(x3936)))+(((IkReal(-1.00000000000000))*(r10)*(x3937)))+(((r12)*(x3935))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst4;
gconst4=IKsign(sj2);
dummyeval[0]=sj2;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[2];
IkReal x3938=(sj1)*(sj1);
IkReal x3939=(cj1)*(cj1);
dummyeval[0]=((((cj2)*(x3939)))+(((cj2)*(x3938))));
dummyeval[1]=((x3939)+(x3938));
if( IKabs(dummyeval[0]) < 0.0000010000000000  || IKabs(dummyeval[1]) < 0.0000010000000000  )
{
{
IkReal dummyeval[2];
dummyeval[0]=sj2;
dummyeval[1]=cj1;
if( IKabs(dummyeval[0]) < 0.0000010000000000  || IKabs(dummyeval[1]) < 0.0000010000000000  )
{
{
IkReal evalcond[9];
IkReal x3940=((sj4)*(sj5));
IkReal x3941=((cj6)*(r20));
IkReal x3942=((IkReal(1.00000000000000))*(cj4));
IkReal x3943=((IkReal(0.390000000000000))*(sj5));
IkReal x3944=((r21)*(sj6));
IkReal x3945=((IkReal(0.390000000000000))*(cj5));
IkReal x3946=((cj6)*(r00));
IkReal x3947=((IkReal(0.000500000000000000))*(cj6));
IkReal x3948=((r11)*(sj6));
IkReal x3949=((cj5)*(sj4));
IkReal x3950=((r01)*(sj6));
IkReal x3951=((r20)*(sj6));
IkReal x3952=((r10)*(sj6));
IkReal x3953=((cj6)*(r10));
IkReal x3954=((cj6)*(r21));
IkReal x3955=((r00)*(sj6));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(3.14159265358979))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(sj5)*(x3944)))+(((sj5)*(x3941))));
evalcond[2]=((IkReal(-0.00200000000000000))+(((r22)*(x3945)))+(((IkReal(0.000500000000000000))*(x3951)))+(((x3941)*(x3943)))+(((IkReal(-1.00000000000000))*(pz)))+(((IkReal(-1.00000000000000))*(x3943)*(x3944)))+(((r21)*(x3947))));
evalcond[3]=((((r01)*(x3947)))+(((IkReal(0.000500000000000000))*(x3955)))+(((IkReal(-1.00000000000000))*(px)))+(((x3943)*(x3946)))+(((IkReal(-1.00000000000000))*(x3943)*(x3950)))+(((r02)*(x3945)))+(((IkReal(-0.400000000000000))*(sj1))));
evalcond[4]=((((IkReal(0.000500000000000000))*(x3952)))+(((IkReal(0.400000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(py)))+(((r12)*(x3945)))+(((x3943)*(x3953)))+(((IkReal(-1.00000000000000))*(x3943)*(x3948)))+(((r11)*(x3947))));
evalcond[5]=((IkReal(-1.00000000000000))+(((r22)*(x3940)))+(((IkReal(-1.00000000000000))*(x3942)*(x3951)))+(((IkReal(-1.00000000000000))*(x3942)*(x3954)))+(((x3944)*(x3949)))+(((IkReal(-1.00000000000000))*(x3941)*(x3949))));
evalcond[6]=((((sj4)*(x3954)))+(((sj4)*(x3951)))+(((cj4)*(cj5)*(x3944)))+(((cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(x3941)*(x3942))));
evalcond[7]=((((IkReal(-1.00000000000000))*(cj6)*(r01)*(x3942)))+(((x3949)*(x3950)))+(((IkReal(-1.00000000000000))*(x3942)*(x3955)))+(((IkReal(-1.00000000000000))*(x3946)*(x3949)))+(((r02)*(x3940))));
evalcond[8]=((((IkReal(-1.00000000000000))*(cj6)*(r11)*(x3942)))+(((IkReal(-1.00000000000000))*(x3942)*(x3952)))+(((x3948)*(x3949)))+(((r12)*(x3940)))+(((IkReal(-1.00000000000000))*(x3949)*(x3953))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst5;
gconst5=IKsign((((sj1)*(sj1))+((cj1)*(cj1))));
dummyeval[0]=(((sj1)*(sj1))+((cj1)*(cj1)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst6;
gconst6=IKsign((((sj1)*(sj1))+((cj1)*(cj1))));
dummyeval[0]=(((sj1)*(sj1))+((cj1)*(cj1)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3956=((IkReal(1.00000000000000))*(sj4));
IkReal x3957=((r00)*(sj6));
IkReal x3958=((cj1)*(cj6));
IkReal x3959=((cj4)*(sj5));
IkReal x3960=((cj4)*(cj5));
IkReal x3961=((r01)*(sj1));
IkReal x3962=((IkReal(1.00000000000000))*(sj6));
IkReal x3963=((cj1)*(r02));
IkReal x3964=((cj1)*(r01));
IkReal x3965=((IkReal(1.00000000000000))*(r02)*(sj1));
IkReal x3966=((cj6)*(r00)*(sj1));
if( IKabs(((gconst6)*(((((cj5)*(x3963)))+(((IkReal(-1.00000000000000))*(sj1)*(x3956)*(x3957)))+(((r00)*(sj5)*(x3958)))+(((x3960)*(x3966)))+(((IkReal(-1.00000000000000))*(x3960)*(x3961)*(x3962)))+(((IkReal(-1.00000000000000))*(x3959)*(x3965)))+(((IkReal(-1.00000000000000))*(sj5)*(x3962)*(x3964)))+(((IkReal(-1.00000000000000))*(cj6)*(x3956)*(x3961))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst6)*(((((IkReal(-1.00000000000000))*(x3960)*(x3962)*(x3964)))+(((sj5)*(sj6)*(x3961)))+(((IkReal(-1.00000000000000))*(r01)*(x3956)*(x3958)))+(((r00)*(x3958)*(x3960)))+(((IkReal(-1.00000000000000))*(x3959)*(x3963)))+(((IkReal(-1.00000000000000))*(cj5)*(x3965)))+(((IkReal(-1.00000000000000))*(cj1)*(x3956)*(x3957)))+(((IkReal(-1.00000000000000))*(sj5)*(x3966))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst6)*(((((cj5)*(x3963)))+(((IkReal(-1.00000000000000))*(sj1)*(x3956)*(x3957)))+(((r00)*(sj5)*(x3958)))+(((x3960)*(x3966)))+(((IkReal(-1.00000000000000))*(x3960)*(x3961)*(x3962)))+(((IkReal(-1.00000000000000))*(x3959)*(x3965)))+(((IkReal(-1.00000000000000))*(sj5)*(x3962)*(x3964)))+(((IkReal(-1.00000000000000))*(cj6)*(x3956)*(x3961)))))), ((gconst6)*(((((IkReal(-1.00000000000000))*(x3960)*(x3962)*(x3964)))+(((sj5)*(sj6)*(x3961)))+(((IkReal(-1.00000000000000))*(r01)*(x3956)*(x3958)))+(((r00)*(x3958)*(x3960)))+(((IkReal(-1.00000000000000))*(x3959)*(x3963)))+(((IkReal(-1.00000000000000))*(cj5)*(x3965)))+(((IkReal(-1.00000000000000))*(cj1)*(x3956)*(x3957)))+(((IkReal(-1.00000000000000))*(sj5)*(x3966)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x3967=IKcos(j3);
IkReal x3968=IKsin(j3);
IkReal x3969=((r11)*(sj6));
IkReal x3970=((IkReal(1.00000000000000))*(sj5));
IkReal x3971=((sj4)*(sj6));
IkReal x3972=((cj4)*(sj5));
IkReal x3973=((cj6)*(sj4));
IkReal x3974=((cj4)*(cj5));
IkReal x3975=((r01)*(sj6));
IkReal x3976=((cj6)*(sj5));
IkReal x3977=((sj1)*(x3967));
IkReal x3978=((cj1)*(x3967));
IkReal x3979=((IkReal(1.00000000000000))*(x3968));
IkReal x3980=((cj1)*(x3979));
IkReal x3981=((IkReal(1.00000000000000))*(cj6)*(x3974));
evalcond[0]=((x3977)+(((IkReal(-1.00000000000000))*(x3970)*(x3975)))+(((r00)*(x3976)))+(((IkReal(-1.00000000000000))*(x3980)))+(((cj5)*(r02))));
evalcond[1]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x3969)*(x3970)))+(((r10)*(x3976)))+(((IkReal(-1.00000000000000))*(sj1)*(x3979)))+(((IkReal(-1.00000000000000))*(x3978))));
evalcond[2]=((((r02)*(x3972)))+(((x3974)*(x3975)))+(x3978)+(((r01)*(x3973)))+(((IkReal(-1.00000000000000))*(r00)*(x3981)))+(((r00)*(x3971)))+(((sj1)*(x3968))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r10)*(x3981)))+(((r11)*(x3973)))+(((r10)*(x3971)))+(((r12)*(x3972)))+(x3977)+(((x3969)*(x3974)))+(((IkReal(-1.00000000000000))*(x3980))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x3982=((cj5)*(r12));
IkReal x3983=((cj6)*(sj5));
IkReal x3984=((IkReal(1.00000000000000))*(sj1));
IkReal x3985=((cj5)*(r02));
IkReal x3986=((IkReal(1.00000000000000))*(cj1));
IkReal x3987=((r01)*(sj5)*(sj6));
IkReal x3988=((r11)*(sj5)*(sj6));
if( IKabs(((gconst5)*(((((IkReal(-1.00000000000000))*(x3984)*(x3988)))+(((sj1)*(x3982)))+(((IkReal(-1.00000000000000))*(x3986)*(x3987)))+(((cj1)*(r00)*(x3983)))+(((r10)*(sj1)*(x3983)))+(((cj1)*(x3985))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst5)*(((((IkReal(-1.00000000000000))*(r00)*(x3983)*(x3984)))+(((cj1)*(r10)*(x3983)))+(((IkReal(-1.00000000000000))*(x3984)*(x3985)))+(((sj1)*(x3987)))+(((IkReal(-1.00000000000000))*(x3986)*(x3988)))+(((cj1)*(x3982))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst5)*(((((IkReal(-1.00000000000000))*(x3984)*(x3988)))+(((sj1)*(x3982)))+(((IkReal(-1.00000000000000))*(x3986)*(x3987)))+(((cj1)*(r00)*(x3983)))+(((r10)*(sj1)*(x3983)))+(((cj1)*(x3985)))))), ((gconst5)*(((((IkReal(-1.00000000000000))*(r00)*(x3983)*(x3984)))+(((cj1)*(r10)*(x3983)))+(((IkReal(-1.00000000000000))*(x3984)*(x3985)))+(((sj1)*(x3987)))+(((IkReal(-1.00000000000000))*(x3986)*(x3988)))+(((cj1)*(x3982)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x3989=IKcos(j3);
IkReal x3990=IKsin(j3);
IkReal x3991=((r11)*(sj6));
IkReal x3992=((IkReal(1.00000000000000))*(sj5));
IkReal x3993=((sj4)*(sj6));
IkReal x3994=((cj4)*(sj5));
IkReal x3995=((cj6)*(sj4));
IkReal x3996=((cj4)*(cj5));
IkReal x3997=((r01)*(sj6));
IkReal x3998=((cj6)*(sj5));
IkReal x3999=((sj1)*(x3989));
IkReal x4000=((cj1)*(x3989));
IkReal x4001=((IkReal(1.00000000000000))*(x3990));
IkReal x4002=((cj1)*(x4001));
IkReal x4003=((IkReal(1.00000000000000))*(cj6)*(x3996));
evalcond[0]=((((IkReal(-1.00000000000000))*(x4002)))+(((IkReal(-1.00000000000000))*(x3992)*(x3997)))+(x3999)+(((r00)*(x3998)))+(((cj5)*(r02))));
evalcond[1]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x4000)))+(((r10)*(x3998)))+(((IkReal(-1.00000000000000))*(sj1)*(x4001)))+(((IkReal(-1.00000000000000))*(x3991)*(x3992))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r00)*(x4003)))+(((x3996)*(x3997)))+(((r02)*(x3994)))+(x4000)+(((r00)*(x3993)))+(((r01)*(x3995)))+(((sj1)*(x3990))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r10)*(x4003)))+(((IkReal(-1.00000000000000))*(x4002)))+(((r10)*(x3993)))+(((r12)*(x3994)))+(x3999)+(((r11)*(x3995)))+(((x3991)*(x3996))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
IkReal x4004=((sj4)*(sj5));
IkReal x4005=((cj6)*(r20));
IkReal x4006=((IkReal(1.00000000000000))*(cj4));
IkReal x4007=((IkReal(0.390000000000000))*(sj5));
IkReal x4008=((r21)*(sj6));
IkReal x4009=((IkReal(0.390000000000000))*(cj5));
IkReal x4010=((cj6)*(r00));
IkReal x4011=((IkReal(0.000500000000000000))*(cj6));
IkReal x4012=((r11)*(sj6));
IkReal x4013=((cj5)*(sj4));
IkReal x4014=((r01)*(sj6));
IkReal x4015=((r20)*(sj6));
IkReal x4016=((r10)*(sj6));
IkReal x4017=((cj6)*(r10));
IkReal x4018=((cj6)*(r21));
IkReal x4019=((r00)*(sj6));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.11022302462516e-16))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((cj5)*(r22)))+(((sj5)*(x4005)))+(((IkReal(-1.00000000000000))*(sj5)*(x4008))));
evalcond[2]=((IkReal(0.00200000000000000))+(((x4005)*(x4007)))+(((r22)*(x4009)))+(((IkReal(0.000500000000000000))*(x4015)))+(((IkReal(-1.00000000000000))*(pz)))+(((r21)*(x4011)))+(((IkReal(-1.00000000000000))*(x4007)*(x4008))));
evalcond[3]=((((r01)*(x4011)))+(((IkReal(0.000500000000000000))*(x4019)))+(((IkReal(-1.00000000000000))*(px)))+(((r02)*(x4009)))+(((IkReal(-1.00000000000000))*(x4007)*(x4014)))+(((x4007)*(x4010)))+(((IkReal(-0.400000000000000))*(sj1))));
evalcond[4]=((((r12)*(x4009)))+(((IkReal(0.400000000000000))*(cj1)))+(((IkReal(0.000500000000000000))*(x4016)))+(((IkReal(-1.00000000000000))*(py)))+(((IkReal(-1.00000000000000))*(x4007)*(x4012)))+(((r11)*(x4011)))+(((x4007)*(x4017))));
evalcond[5]=((IkReal(1.00000000000000))+(((r22)*(x4004)))+(((IkReal(-1.00000000000000))*(x4005)*(x4013)))+(((IkReal(-1.00000000000000))*(x4006)*(x4018)))+(((IkReal(-1.00000000000000))*(x4006)*(x4015)))+(((x4008)*(x4013))));
evalcond[6]=((((cj4)*(cj5)*(x4008)))+(((cj4)*(r22)*(sj5)))+(((sj4)*(x4015)))+(((sj4)*(x4018)))+(((IkReal(-1.00000000000000))*(cj5)*(x4005)*(x4006))));
evalcond[7]=((((IkReal(-1.00000000000000))*(cj6)*(r01)*(x4006)))+(((x4013)*(x4014)))+(((r02)*(x4004)))+(((IkReal(-1.00000000000000))*(x4006)*(x4019)))+(((IkReal(-1.00000000000000))*(x4010)*(x4013))));
evalcond[8]=((((r12)*(x4004)))+(((IkReal(-1.00000000000000))*(cj6)*(r11)*(x4006)))+(((x4012)*(x4013)))+(((IkReal(-1.00000000000000))*(x4006)*(x4016)))+(((IkReal(-1.00000000000000))*(x4013)*(x4017))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst7;
gconst7=IKsign(((((IkReal(-1.00000000000000))*((sj1)*(sj1))))+(((IkReal(-1.00000000000000))*((cj1)*(cj1))))));
dummyeval[0]=((((IkReal(-1.00000000000000))*((sj1)*(sj1))))+(((IkReal(-1.00000000000000))*((cj1)*(cj1)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst8;
gconst8=IKsign(((((IkReal(-1.00000000000000))*((sj1)*(sj1))))+(((IkReal(-1.00000000000000))*((cj1)*(cj1))))));
dummyeval[0]=((((IkReal(-1.00000000000000))*((sj1)*(sj1))))+(((IkReal(-1.00000000000000))*((cj1)*(cj1)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x4020=((sj1)*(sj6));
IkReal x4021=((r00)*(sj4));
IkReal x4022=((IkReal(1.00000000000000))*(r01));
IkReal x4023=((cj1)*(cj6));
IkReal x4024=((cj1)*(sj6));
IkReal x4025=((cj4)*(cj5));
IkReal x4026=((r02)*(sj1));
IkReal x4027=((cj4)*(sj5));
IkReal x4028=((cj1)*(r02));
IkReal x4029=((cj6)*(r00)*(sj1));
if( IKabs(((gconst8)*(((((IkReal(-1.00000000000000))*(sj5)*(x4022)*(x4024)))+(((r00)*(sj5)*(x4023)))+(((cj5)*(x4028)))+(((x4020)*(x4021)))+(((cj6)*(r01)*(sj1)*(sj4)))+(((IkReal(-1.00000000000000))*(x4025)*(x4029)))+(((r01)*(x4020)*(x4025)))+(((x4026)*(x4027))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst8)*(((((cj5)*(x4026)))+(((IkReal(-1.00000000000000))*(x4027)*(x4028)))+(((IkReal(-1.00000000000000))*(x4022)*(x4024)*(x4025)))+(((sj5)*(x4029)))+(((r00)*(x4023)*(x4025)))+(((IkReal(-1.00000000000000))*(sj4)*(x4022)*(x4023)))+(((IkReal(-1.00000000000000))*(sj5)*(x4020)*(x4022)))+(((IkReal(-1.00000000000000))*(x4021)*(x4024))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst8)*(((((IkReal(-1.00000000000000))*(sj5)*(x4022)*(x4024)))+(((r00)*(sj5)*(x4023)))+(((cj5)*(x4028)))+(((x4020)*(x4021)))+(((cj6)*(r01)*(sj1)*(sj4)))+(((IkReal(-1.00000000000000))*(x4025)*(x4029)))+(((r01)*(x4020)*(x4025)))+(((x4026)*(x4027)))))), ((gconst8)*(((((cj5)*(x4026)))+(((IkReal(-1.00000000000000))*(x4027)*(x4028)))+(((IkReal(-1.00000000000000))*(x4022)*(x4024)*(x4025)))+(((sj5)*(x4029)))+(((r00)*(x4023)*(x4025)))+(((IkReal(-1.00000000000000))*(sj4)*(x4022)*(x4023)))+(((IkReal(-1.00000000000000))*(sj5)*(x4020)*(x4022)))+(((IkReal(-1.00000000000000))*(x4021)*(x4024)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x4030=IKsin(j3);
IkReal x4031=IKcos(j3);
IkReal x4032=((r11)*(sj6));
IkReal x4033=((IkReal(1.00000000000000))*(sj5));
IkReal x4034=((sj4)*(sj6));
IkReal x4035=((cj4)*(sj5));
IkReal x4036=((cj6)*(sj4));
IkReal x4037=((cj4)*(cj5));
IkReal x4038=((r01)*(sj6));
IkReal x4039=((cj6)*(sj5));
IkReal x4040=((sj1)*(x4030));
IkReal x4041=((cj1)*(x4030));
IkReal x4042=((IkReal(1.00000000000000))*(x4031));
IkReal x4043=((cj1)*(x4042));
IkReal x4044=((IkReal(1.00000000000000))*(cj6)*(x4037));
evalcond[0]=((x4041)+(((r00)*(x4039)))+(((sj1)*(x4031)))+(((IkReal(-1.00000000000000))*(x4033)*(x4038)))+(((cj5)*(r02))));
evalcond[1]=((((cj5)*(r12)))+(x4040)+(((r10)*(x4039)))+(((IkReal(-1.00000000000000))*(x4043)))+(((IkReal(-1.00000000000000))*(x4032)*(x4033))));
evalcond[2]=((((x4037)*(x4038)))+(((r02)*(x4035)))+(((IkReal(-1.00000000000000))*(r00)*(x4044)))+(x4040)+(((r00)*(x4034)))+(((r01)*(x4036)))+(((IkReal(-1.00000000000000))*(x4043))));
evalcond[3]=((((x4032)*(x4037)))+(((IkReal(-1.00000000000000))*(sj1)*(x4042)))+(((IkReal(-1.00000000000000))*(r10)*(x4044)))+(((IkReal(-1.00000000000000))*(x4041)))+(((r10)*(x4034)))+(((r12)*(x4035)))+(((r11)*(x4036))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x4045=((sj1)*(sj5));
IkReal x4046=((cj6)*(r10));
IkReal x4047=((cj5)*(sj1));
IkReal x4048=((cj1)*(cj5));
IkReal x4049=((cj1)*(sj5));
IkReal x4050=((cj6)*(r00));
IkReal x4051=((r11)*(sj6));
IkReal x4052=((IkReal(1.00000000000000))*(r01)*(sj6));
if( IKabs(((gconst7)*(((((x4045)*(x4046)))+(((x4049)*(x4050)))+(((r02)*(x4048)))+(((r12)*(x4047)))+(((IkReal(-1.00000000000000))*(x4049)*(x4052)))+(((IkReal(-1.00000000000000))*(x4045)*(x4051))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst7)*(((((IkReal(-1.00000000000000))*(r12)*(x4048)))+(((x4049)*(x4051)))+(((x4045)*(x4050)))+(((r02)*(x4047)))+(((IkReal(-1.00000000000000))*(x4045)*(x4052)))+(((IkReal(-1.00000000000000))*(x4046)*(x4049))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst7)*(((((x4045)*(x4046)))+(((x4049)*(x4050)))+(((r02)*(x4048)))+(((r12)*(x4047)))+(((IkReal(-1.00000000000000))*(x4049)*(x4052)))+(((IkReal(-1.00000000000000))*(x4045)*(x4051)))))), ((gconst7)*(((((IkReal(-1.00000000000000))*(r12)*(x4048)))+(((x4049)*(x4051)))+(((x4045)*(x4050)))+(((r02)*(x4047)))+(((IkReal(-1.00000000000000))*(x4045)*(x4052)))+(((IkReal(-1.00000000000000))*(x4046)*(x4049)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x4053=IKsin(j3);
IkReal x4054=IKcos(j3);
IkReal x4055=((r11)*(sj6));
IkReal x4056=((IkReal(1.00000000000000))*(sj5));
IkReal x4057=((sj4)*(sj6));
IkReal x4058=((cj4)*(sj5));
IkReal x4059=((cj6)*(sj4));
IkReal x4060=((cj4)*(cj5));
IkReal x4061=((r01)*(sj6));
IkReal x4062=((cj6)*(sj5));
IkReal x4063=((sj1)*(x4053));
IkReal x4064=((cj1)*(x4053));
IkReal x4065=((IkReal(1.00000000000000))*(x4054));
IkReal x4066=((cj1)*(x4065));
IkReal x4067=((IkReal(1.00000000000000))*(cj6)*(x4060));
evalcond[0]=((x4064)+(((r00)*(x4062)))+(((sj1)*(x4054)))+(((IkReal(-1.00000000000000))*(x4056)*(x4061)))+(((cj5)*(r02))));
evalcond[1]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x4055)*(x4056)))+(x4063)+(((IkReal(-1.00000000000000))*(x4066)))+(((r10)*(x4062))));
evalcond[2]=((((x4060)*(x4061)))+(((r02)*(x4058)))+(x4063)+(((IkReal(-1.00000000000000))*(r00)*(x4067)))+(((IkReal(-1.00000000000000))*(x4066)))+(((r00)*(x4057)))+(((r01)*(x4059))));
evalcond[3]=((((r11)*(x4059)))+(((IkReal(-1.00000000000000))*(r10)*(x4067)))+(((r12)*(x4058)))+(((IkReal(-1.00000000000000))*(x4064)))+(((x4055)*(x4060)))+(((r10)*(x4057)))+(((IkReal(-1.00000000000000))*(sj1)*(x4065))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
IkReal x4068=((sj4)*(sj5));
IkReal x4069=((IkReal(0.390000000000000))*(sj5));
IkReal x4070=((r21)*(sj6));
IkReal x4071=((IkReal(0.390000000000000))*(cj5));
IkReal x4072=((cj6)*(r00));
IkReal x4073=((IkReal(0.000500000000000000))*(cj6));
IkReal x4074=((r11)*(sj6));
IkReal x4075=((cj5)*(sj4));
IkReal x4076=((IkReal(1.00000000000000))*(r20));
IkReal x4077=((cj4)*(sj6));
IkReal x4078=((r01)*(sj6));
IkReal x4079=((IkReal(0.000500000000000000))*(sj6));
IkReal x4080=((IkReal(1.00000000000000))*(r10));
IkReal x4081=((IkReal(1.00000000000000))*(cj4)*(cj6));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x4069)*(x4070)))+(((r20)*(x4079)))+(((cj6)*(r20)*(x4069)))+(((r22)*(x4071)))+(((IkReal(-1.00000000000000))*(pz)))+(((IkReal(-0.00200000000000000))*(cj2)))+(((r21)*(x4073))));
evalcond[2]=((IkReal(-0.400000000000000))+(((IkReal(-1.00000000000000))*(x4069)*(x4078)))+(((r00)*(x4079)))+(((r01)*(x4073)))+(((IkReal(-1.00000000000000))*(px)))+(((r02)*(x4071)))+(((x4069)*(x4072))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x4069)*(x4074)))+(((r12)*(x4071)))+(((r10)*(x4079)))+(((IkReal(-1.00000000000000))*(py)))+(((cj6)*(r10)*(x4069)))+(((IkReal(-0.00200000000000000))*(sj2)))+(((r11)*(x4073))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r21)*(x4081)))+(((x4070)*(x4075)))+(((r22)*(x4068)))+(((IkReal(-1.00000000000000))*(cj6)*(x4075)*(x4076)))+(((IkReal(-1.00000000000000))*(cj2)))+(((IkReal(-1.00000000000000))*(x4076)*(x4077))));
evalcond[5]=((((r02)*(x4068)))+(((x4075)*(x4078)))+(((IkReal(-1.00000000000000))*(r01)*(x4081)))+(((IkReal(-1.00000000000000))*(r00)*(x4077)))+(((IkReal(-1.00000000000000))*(x4072)*(x4075))));
evalcond[6]=((((IkReal(-1.00000000000000))*(sj2)))+(((x4074)*(x4075)))+(((IkReal(-1.00000000000000))*(r11)*(x4081)))+(((IkReal(-1.00000000000000))*(cj6)*(x4075)*(x4080)))+(((r12)*(x4068)))+(((IkReal(-1.00000000000000))*(x4077)*(x4080))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x4082=((IkReal(1.00000000000000))*(cj6));
IkReal x4083=((IkReal(1.00000000000000))*(cj5));
IkReal x4084=((r01)*(sj6));
if( IKabs(((((IkReal(-1.00000000000000))*(r01)*(sj4)*(x4082)))+(((IkReal(-1.00000000000000))*(cj4)*(r02)*(sj5)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(sj6)))+(((cj4)*(cj5)*(cj6)*(r00)))+(((IkReal(-1.00000000000000))*(cj4)*(x4083)*(x4084))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r02)*(x4083)))+(((IkReal(-1.00000000000000))*(r00)*(sj5)*(x4082)))+(((sj5)*(x4084))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(r01)*(sj4)*(x4082)))+(((IkReal(-1.00000000000000))*(cj4)*(r02)*(sj5)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(sj6)))+(((cj4)*(cj5)*(cj6)*(r00)))+(((IkReal(-1.00000000000000))*(cj4)*(x4083)*(x4084)))))+IKsqr(((((IkReal(-1.00000000000000))*(r02)*(x4083)))+(((IkReal(-1.00000000000000))*(r00)*(sj5)*(x4082)))+(((sj5)*(x4084)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(r01)*(sj4)*(x4082)))+(((IkReal(-1.00000000000000))*(cj4)*(r02)*(sj5)))+(((IkReal(-1.00000000000000))*(r00)*(sj4)*(sj6)))+(((cj4)*(cj5)*(cj6)*(r00)))+(((IkReal(-1.00000000000000))*(cj4)*(x4083)*(x4084)))), ((((IkReal(-1.00000000000000))*(r02)*(x4083)))+(((IkReal(-1.00000000000000))*(r00)*(sj5)*(x4082)))+(((sj5)*(x4084)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x4085=IKsin(j3);
IkReal x4086=IKcos(j3);
IkReal x4087=((r11)*(sj6));
IkReal x4088=((IkReal(1.00000000000000))*(sj5));
IkReal x4089=((sj4)*(sj6));
IkReal x4090=((cj4)*(sj5));
IkReal x4091=((cj6)*(sj4));
IkReal x4092=((cj4)*(cj5));
IkReal x4093=((r01)*(sj6));
IkReal x4094=((r21)*(sj6));
IkReal x4095=((cj6)*(sj5));
IkReal x4096=((IkReal(1.00000000000000))*(cj6)*(x4092));
evalcond[0]=((((r20)*(x4095)))+(((cj5)*(r22)))+(((sj2)*(x4085)))+(((IkReal(-1.00000000000000))*(x4088)*(x4094))));
evalcond[1]=((((r00)*(x4095)))+(x4086)+(((IkReal(-1.00000000000000))*(x4088)*(x4093)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((r10)*(x4095)))+(((IkReal(-1.00000000000000))*(cj2)*(x4085)))+(((IkReal(-1.00000000000000))*(x4087)*(x4088))));
evalcond[3]=((((r20)*(x4089)))+(((IkReal(-1.00000000000000))*(r20)*(x4096)))+(((IkReal(-1.00000000000000))*(sj2)*(x4086)))+(((r21)*(x4091)))+(((r22)*(x4090)))+(((x4092)*(x4094))));
evalcond[4]=((((r00)*(x4089)))+(((r01)*(x4091)))+(x4085)+(((IkReal(-1.00000000000000))*(r00)*(x4096)))+(((r02)*(x4090)))+(((x4092)*(x4093))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(x4096)))+(((x4087)*(x4092)))+(((r10)*(x4089)))+(((r11)*(x4091)))+(((cj2)*(x4086)))+(((r12)*(x4090))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x4097=((sj4)*(sj5));
IkReal x4098=((IkReal(0.390000000000000))*(sj5));
IkReal x4099=((r21)*(sj6));
IkReal x4100=((IkReal(0.390000000000000))*(cj5));
IkReal x4101=((cj6)*(r00));
IkReal x4102=((IkReal(0.000500000000000000))*(cj6));
IkReal x4103=((r11)*(sj6));
IkReal x4104=((cj5)*(sj4));
IkReal x4105=((IkReal(1.00000000000000))*(r20));
IkReal x4106=((cj4)*(sj6));
IkReal x4107=((r01)*(sj6));
IkReal x4108=((IkReal(0.000500000000000000))*(sj6));
IkReal x4109=((IkReal(1.00000000000000))*(r10));
IkReal x4110=((IkReal(1.00000000000000))*(cj4)*(cj6));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((((r22)*(x4100)))+(((IkReal(-1.00000000000000))*(x4098)*(x4099)))+(((r20)*(x4108)))+(((IkReal(-1.00000000000000))*(pz)))+(((cj6)*(r20)*(x4098)))+(((r21)*(x4102)))+(((IkReal(-0.00200000000000000))*(cj2))));
evalcond[2]=((IkReal(0.400000000000000))+(((IkReal(-1.00000000000000))*(x4098)*(x4107)))+(((x4098)*(x4101)))+(((IkReal(-1.00000000000000))*(px)))+(((r02)*(x4100)))+(((r00)*(x4108)))+(((r01)*(x4102))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x4098)*(x4103)))+(((cj6)*(r10)*(x4098)))+(((IkReal(0.00200000000000000))*(sj2)))+(((IkReal(-1.00000000000000))*(py)))+(((r12)*(x4100)))+(((r11)*(x4102)))+(((r10)*(x4108))));
evalcond[4]=((((x4099)*(x4104)))+(((IkReal(-1.00000000000000))*(x4105)*(x4106)))+(((IkReal(-1.00000000000000))*(cj6)*(x4104)*(x4105)))+(((r22)*(x4097)))+(((IkReal(-1.00000000000000))*(r21)*(x4110)))+(((IkReal(-1.00000000000000))*(cj2))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r01)*(x4110)))+(((IkReal(-1.00000000000000))*(x4101)*(x4104)))+(((r02)*(x4097)))+(((IkReal(-1.00000000000000))*(r00)*(x4106)))+(((x4104)*(x4107))));
evalcond[6]=((((IkReal(-1.00000000000000))*(r11)*(x4110)))+(sj2)+(((IkReal(-1.00000000000000))*(cj6)*(x4104)*(x4109)))+(((x4103)*(x4104)))+(((IkReal(-1.00000000000000))*(x4106)*(x4109)))+(((r12)*(x4097))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x4111=((cj4)*(cj5));
IkReal x4112=((r01)*(sj6));
IkReal x4113=((cj6)*(r00));
if( IKabs(((((IkReal(-1.00000000000000))*(x4111)*(x4113)))+(((r00)*(sj4)*(sj6)))+(((cj6)*(r01)*(sj4)))+(((cj4)*(r02)*(sj5)))+(((x4111)*(x4112))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((sj5)*(x4113)))+(((IkReal(-1.00000000000000))*(sj5)*(x4112)))+(((cj5)*(r02))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(x4111)*(x4113)))+(((r00)*(sj4)*(sj6)))+(((cj6)*(r01)*(sj4)))+(((cj4)*(r02)*(sj5)))+(((x4111)*(x4112)))))+IKsqr(((((sj5)*(x4113)))+(((IkReal(-1.00000000000000))*(sj5)*(x4112)))+(((cj5)*(r02)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(x4111)*(x4113)))+(((r00)*(sj4)*(sj6)))+(((cj6)*(r01)*(sj4)))+(((cj4)*(r02)*(sj5)))+(((x4111)*(x4112)))), ((((sj5)*(x4113)))+(((IkReal(-1.00000000000000))*(sj5)*(x4112)))+(((cj5)*(r02)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x4114=IKsin(j3);
IkReal x4115=IKcos(j3);
IkReal x4116=((r11)*(sj6));
IkReal x4117=((IkReal(1.00000000000000))*(sj5));
IkReal x4118=((cj6)*(sj4));
IkReal x4119=((sj4)*(sj6));
IkReal x4120=((cj4)*(sj5));
IkReal x4121=((cj4)*(cj5));
IkReal x4122=((r01)*(sj6));
IkReal x4123=((r21)*(sj6));
IkReal x4124=((cj6)*(sj5));
IkReal x4125=((IkReal(1.00000000000000))*(x4115));
IkReal x4126=((IkReal(1.00000000000000))*(cj6)*(x4121));
evalcond[0]=((((cj5)*(r22)))+(((r20)*(x4124)))+(((sj2)*(x4114)))+(((IkReal(-1.00000000000000))*(x4117)*(x4123))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x4125)))+(((r00)*(x4124)))+(((IkReal(-1.00000000000000))*(x4117)*(x4122)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x4116)*(x4117)))+(((cj2)*(x4114)))+(((r10)*(x4124))));
evalcond[3]=((((r21)*(x4118)))+(((r20)*(x4119)))+(((IkReal(-1.00000000000000))*(sj2)*(x4125)))+(((IkReal(-1.00000000000000))*(r20)*(x4126)))+(((x4121)*(x4123)))+(((r22)*(x4120))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r00)*(x4126)))+(((r02)*(x4120)))+(((x4121)*(x4122)))+(((r00)*(x4119)))+(((IkReal(-1.00000000000000))*(x4114)))+(((r01)*(x4118))));
evalcond[5]=((((r12)*(x4120)))+(((IkReal(-1.00000000000000))*(cj2)*(x4125)))+(((x4116)*(x4121)))+(((IkReal(-1.00000000000000))*(r10)*(x4126)))+(((r11)*(x4118)))+(((r10)*(x4119))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x4127=((sj4)*(sj5));
IkReal x4128=((IkReal(0.390000000000000))*(sj5));
IkReal x4129=((r21)*(sj6));
IkReal x4130=((IkReal(0.390000000000000))*(cj5));
IkReal x4131=((cj6)*(r00));
IkReal x4132=((IkReal(0.000500000000000000))*(cj6));
IkReal x4133=((r11)*(sj6));
IkReal x4134=((cj5)*(sj4));
IkReal x4135=((r01)*(sj6));
IkReal x4136=((IkReal(1.00000000000000))*(r20));
IkReal x4137=((cj4)*(sj6));
IkReal x4138=((IkReal(0.000500000000000000))*(sj6));
IkReal x4139=((IkReal(1.00000000000000))*(r10));
IkReal x4140=((IkReal(1.00000000000000))*(cj4)*(cj6));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x4128)*(x4129)))+(((r22)*(x4130)))+(((cj6)*(r20)*(x4128)))+(((r21)*(x4132)))+(((IkReal(-1.00000000000000))*(pz)))+(((r20)*(x4138))));
evalcond[2]=((((r00)*(x4138)))+(((x4128)*(x4131)))+(((r01)*(x4132)))+(((IkReal(-1.00000000000000))*(x4128)*(x4135)))+(((IkReal(-1.00000000000000))*(px)))+(((IkReal(-0.00200000000000000))*(cj1)))+(((IkReal(-0.400000000000000))*(sj1)))+(((r02)*(x4130))));
evalcond[3]=((((cj6)*(r10)*(x4128)))+(((r11)*(x4132)))+(((IkReal(0.400000000000000))*(cj1)))+(((r10)*(x4138)))+(((IkReal(-1.00000000000000))*(x4128)*(x4133)))+(((IkReal(-1.00000000000000))*(py)))+(((r12)*(x4130)))+(((IkReal(-0.00200000000000000))*(sj1))));
evalcond[4]=((((x4129)*(x4134)))+(((r22)*(x4127)))+(((IkReal(-1.00000000000000))*(x4136)*(x4137)))+(((IkReal(-1.00000000000000))*(cj6)*(x4134)*(x4136)))+(((IkReal(-1.00000000000000))*(r21)*(x4140))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r00)*(x4137)))+(((r02)*(x4127)))+(((IkReal(-1.00000000000000))*(r01)*(x4140)))+(((x4134)*(x4135)))+(((IkReal(-1.00000000000000))*(x4131)*(x4134)))+(((IkReal(-1.00000000000000))*(cj1))));
evalcond[6]=((((r12)*(x4127)))+(((IkReal(-1.00000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(x4137)*(x4139)))+(((IkReal(-1.00000000000000))*(r11)*(x4140)))+(((x4133)*(x4134)))+(((IkReal(-1.00000000000000))*(cj6)*(x4134)*(x4139))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x4141=((cj4)*(cj5));
IkReal x4142=((r21)*(sj6));
IkReal x4143=((IkReal(1.00000000000000))*(cj6)*(r20));
if( IKabs(((((IkReal(-1.00000000000000))*(sj5)*(x4143)))+(((sj5)*(x4142)))+(((IkReal(-1.00000000000000))*(cj5)*(r22))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(x4141)*(x4143)))+(((cj4)*(r22)*(sj5)))+(((x4141)*(x4142)))+(((cj6)*(r21)*(sj4)))+(((r20)*(sj4)*(sj6))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(sj5)*(x4143)))+(((sj5)*(x4142)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))))+IKsqr(((((IkReal(-1.00000000000000))*(x4141)*(x4143)))+(((cj4)*(r22)*(sj5)))+(((x4141)*(x4142)))+(((cj6)*(r21)*(sj4)))+(((r20)*(sj4)*(sj6)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(sj5)*(x4143)))+(((sj5)*(x4142)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))), ((((IkReal(-1.00000000000000))*(x4141)*(x4143)))+(((cj4)*(r22)*(sj5)))+(((x4141)*(x4142)))+(((cj6)*(r21)*(sj4)))+(((r20)*(sj4)*(sj6)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x4144=IKcos(j3);
IkReal x4145=IKsin(j3);
IkReal x4146=((r11)*(sj6));
IkReal x4147=((IkReal(1.00000000000000))*(sj5));
IkReal x4148=((IkReal(1.00000000000000))*(cj1));
IkReal x4149=((cj6)*(sj4));
IkReal x4150=((sj4)*(sj6));
IkReal x4151=((cj4)*(sj5));
IkReal x4152=((cj4)*(cj5));
IkReal x4153=((r01)*(sj6));
IkReal x4154=((r21)*(sj6));
IkReal x4155=((cj6)*(sj5));
IkReal x4156=((IkReal(1.00000000000000))*(cj6)*(x4152));
evalcond[0]=((((cj5)*(r22)))+(((IkReal(-1.00000000000000))*(x4147)*(x4154)))+(x4145)+(((r20)*(x4155))));
evalcond[1]=((((r00)*(x4155)))+(((IkReal(-1.00000000000000))*(x4147)*(x4153)))+(((sj1)*(x4144)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x4146)*(x4147)))+(((r10)*(x4155)))+(((IkReal(-1.00000000000000))*(x4144)*(x4148))));
evalcond[3]=((((x4152)*(x4154)))+(((r21)*(x4149)))+(((IkReal(-1.00000000000000))*(x4144)))+(((r22)*(x4151)))+(((r20)*(x4150)))+(((IkReal(-1.00000000000000))*(r20)*(x4156))));
evalcond[4]=((((r02)*(x4151)))+(((x4152)*(x4153)))+(((r00)*(x4150)))+(((r01)*(x4149)))+(((sj1)*(x4145)))+(((IkReal(-1.00000000000000))*(r00)*(x4156))));
evalcond[5]=((((r10)*(x4150)))+(((r12)*(x4151)))+(((r11)*(x4149)))+(((IkReal(-1.00000000000000))*(x4145)*(x4148)))+(((IkReal(-1.00000000000000))*(r10)*(x4156)))+(((x4146)*(x4152))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x4157=((sj4)*(sj5));
IkReal x4158=((IkReal(0.390000000000000))*(sj5));
IkReal x4159=((r21)*(sj6));
IkReal x4160=((IkReal(0.390000000000000))*(cj5));
IkReal x4161=((cj6)*(r00));
IkReal x4162=((IkReal(0.000500000000000000))*(cj6));
IkReal x4163=((r11)*(sj6));
IkReal x4164=((cj5)*(sj4));
IkReal x4165=((r01)*(sj6));
IkReal x4166=((IkReal(1.00000000000000))*(r20));
IkReal x4167=((cj4)*(sj6));
IkReal x4168=((IkReal(0.000500000000000000))*(sj6));
IkReal x4169=((IkReal(1.00000000000000))*(r10));
IkReal x4170=((IkReal(1.00000000000000))*(cj4)*(cj6));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((((r22)*(x4160)))+(((r20)*(x4168)))+(((IkReal(-1.00000000000000))*(pz)))+(((r21)*(x4162)))+(((cj6)*(r20)*(x4158)))+(((IkReal(-1.00000000000000))*(x4158)*(x4159))));
evalcond[2]=((((r01)*(x4162)))+(((x4158)*(x4161)))+(((r00)*(x4168)))+(((IkReal(0.00200000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(px)))+(((IkReal(-1.00000000000000))*(x4158)*(x4165)))+(((r02)*(x4160)))+(((IkReal(-0.400000000000000))*(sj1))));
evalcond[3]=((((r10)*(x4168)))+(((IkReal(0.400000000000000))*(cj1)))+(((IkReal(0.00200000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(py)))+(((IkReal(-1.00000000000000))*(x4158)*(x4163)))+(((r11)*(x4162)))+(((r12)*(x4160)))+(((cj6)*(r10)*(x4158))));
evalcond[4]=((((r22)*(x4157)))+(((IkReal(-1.00000000000000))*(r21)*(x4170)))+(((IkReal(-1.00000000000000))*(cj6)*(x4164)*(x4166)))+(((x4159)*(x4164)))+(((IkReal(-1.00000000000000))*(x4166)*(x4167))));
evalcond[5]=((((r02)*(x4157)))+(cj1)+(((IkReal(-1.00000000000000))*(r01)*(x4170)))+(((IkReal(-1.00000000000000))*(x4161)*(x4164)))+(((IkReal(-1.00000000000000))*(r00)*(x4167)))+(((x4164)*(x4165))));
evalcond[6]=((sj1)+(((r12)*(x4157)))+(((IkReal(-1.00000000000000))*(cj6)*(x4164)*(x4169)))+(((IkReal(-1.00000000000000))*(x4167)*(x4169)))+(((x4163)*(x4164)))+(((IkReal(-1.00000000000000))*(r11)*(x4170))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  )
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x4171=((cj4)*(cj5));
IkReal x4172=((cj6)*(r20));
IkReal x4173=((IkReal(1.00000000000000))*(sj4));
IkReal x4174=((IkReal(1.00000000000000))*(r21)*(sj6));
if( IKabs(((((IkReal(-1.00000000000000))*(sj5)*(x4174)))+(((cj5)*(r22)))+(((sj5)*(x4172))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(cj6)*(r21)*(x4173)))+(((IkReal(-1.00000000000000))*(x4171)*(x4174)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(sj5)))+(((x4171)*(x4172)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x4173))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(sj5)*(x4174)))+(((cj5)*(r22)))+(((sj5)*(x4172)))))+IKsqr(((((IkReal(-1.00000000000000))*(cj6)*(r21)*(x4173)))+(((IkReal(-1.00000000000000))*(x4171)*(x4174)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(sj5)))+(((x4171)*(x4172)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x4173)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IkReal(-1.00000000000000))*(sj5)*(x4174)))+(((cj5)*(r22)))+(((sj5)*(x4172)))), ((((IkReal(-1.00000000000000))*(cj6)*(r21)*(x4173)))+(((IkReal(-1.00000000000000))*(x4171)*(x4174)))+(((IkReal(-1.00000000000000))*(cj4)*(r22)*(sj5)))+(((x4171)*(x4172)))+(((IkReal(-1.00000000000000))*(r20)*(sj6)*(x4173)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x4175=IKcos(j3);
IkReal x4176=IKsin(j3);
IkReal x4177=((r11)*(sj6));
IkReal x4178=((IkReal(1.00000000000000))*(sj5));
IkReal x4179=((IkReal(1.00000000000000))*(cj1));
IkReal x4180=((sj4)*(sj6));
IkReal x4181=((cj4)*(sj5));
IkReal x4182=((cj6)*(sj4));
IkReal x4183=((cj4)*(cj5));
IkReal x4184=((r01)*(sj6));
IkReal x4185=((r21)*(sj6));
IkReal x4186=((cj6)*(sj5));
IkReal x4187=((IkReal(1.00000000000000))*(cj6)*(x4183));
evalcond[0]=((((cj5)*(r22)))+(((r20)*(x4186)))+(((IkReal(-1.00000000000000))*(x4176)))+(((IkReal(-1.00000000000000))*(x4178)*(x4185))));
evalcond[1]=((((sj1)*(x4175)))+(((r00)*(x4186)))+(((IkReal(-1.00000000000000))*(x4178)*(x4184)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(x4177)*(x4178)))+(((IkReal(-1.00000000000000))*(x4175)*(x4179)))+(((r10)*(x4186))));
evalcond[3]=((((r20)*(x4180)))+(((r21)*(x4182)))+(((IkReal(-1.00000000000000))*(r20)*(x4187)))+(((r22)*(x4181)))+(((x4183)*(x4185)))+(x4175));
evalcond[4]=((((r02)*(x4181)))+(((IkReal(-1.00000000000000))*(r00)*(x4187)))+(((sj1)*(x4176)))+(((x4183)*(x4184)))+(((r01)*(x4182)))+(((r00)*(x4180))));
evalcond[5]=((((r12)*(x4181)))+(((r11)*(x4182)))+(((IkReal(-1.00000000000000))*(x4176)*(x4179)))+(((x4177)*(x4183)))+(((r10)*(x4180)))+(((IkReal(-1.00000000000000))*(r10)*(x4187))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x4188=((IKabs(sj2) != 0)?((IkReal)1/(sj2)):(IkReal)1.0e30);
IkReal x4189=((IkReal(1.00000000000000))*(sj5));
IkReal x4190=((cj2)*(sj1));
IkReal x4191=((r21)*(sj6));
IkReal x4192=((cj6)*(r20));
IkReal x4193=((cj5)*(r22));
if( IKabs(((x4188)*(((((sj5)*(x4191)))+(((IkReal(-1.00000000000000))*(x4193)))+(((IkReal(-1.00000000000000))*(x4189)*(x4192))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((x4188)*(((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((cj5)*(r12)*(sj2)))+(((x4190)*(x4193)))+(((IkReal(-1.00000000000000))*(r11)*(sj2)*(sj6)*(x4189)))+(((IkReal(-1.00000000000000))*(x4189)*(x4190)*(x4191)))+(((sj5)*(x4190)*(x4192)))+(((cj6)*(r10)*(sj2)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((x4188)*(((((sj5)*(x4191)))+(((IkReal(-1.00000000000000))*(x4193)))+(((IkReal(-1.00000000000000))*(x4189)*(x4192)))))))+IKsqr(((x4188)*(((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((cj5)*(r12)*(sj2)))+(((x4190)*(x4193)))+(((IkReal(-1.00000000000000))*(r11)*(sj2)*(sj6)*(x4189)))+(((IkReal(-1.00000000000000))*(x4189)*(x4190)*(x4191)))+(((sj5)*(x4190)*(x4192)))+(((cj6)*(r10)*(sj2)*(sj5)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((x4188)*(((((sj5)*(x4191)))+(((IkReal(-1.00000000000000))*(x4193)))+(((IkReal(-1.00000000000000))*(x4189)*(x4192)))))), ((x4188)*(((IKabs(cj1) != 0)?((IkReal)1/(cj1)):(IkReal)1.0e30))*(((((cj5)*(r12)*(sj2)))+(((x4190)*(x4193)))+(((IkReal(-1.00000000000000))*(r11)*(sj2)*(sj6)*(x4189)))+(((IkReal(-1.00000000000000))*(x4189)*(x4190)*(x4191)))+(((sj5)*(x4190)*(x4192)))+(((cj6)*(r10)*(sj2)*(sj5)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x4194=IKsin(j3);
IkReal x4195=IKcos(j3);
IkReal x4196=((r11)*(sj6));
IkReal x4197=((IkReal(1.00000000000000))*(sj5));
IkReal x4198=((sj4)*(sj6));
IkReal x4199=((cj4)*(sj5));
IkReal x4200=((cj6)*(sj4));
IkReal x4201=((cj4)*(cj5));
IkReal x4202=((r01)*(sj6));
IkReal x4203=((r21)*(sj6));
IkReal x4204=((cj6)*(sj5));
IkReal x4205=((IkReal(1.00000000000000))*(x4195));
IkReal x4206=((sj1)*(x4195));
IkReal x4207=((IkReal(1.00000000000000))*(cj6)*(x4201));
IkReal x4208=((IkReal(1.00000000000000))*(cj2)*(x4194));
evalcond[0]=((((cj5)*(r22)))+(((sj2)*(x4194)))+(((IkReal(-1.00000000000000))*(x4197)*(x4203)))+(((r20)*(x4204))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x4197)*(x4202)))+(((r00)*(x4204)))+(((IkReal(-1.00000000000000))*(cj1)*(x4208)))+(x4206)+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((IkReal(-1.00000000000000))*(cj1)*(x4205)))+(((IkReal(-1.00000000000000))*(sj1)*(x4208)))+(((IkReal(-1.00000000000000))*(x4196)*(x4197)))+(((r10)*(x4204))));
evalcond[3]=((((r20)*(x4198)))+(((IkReal(-1.00000000000000))*(sj2)*(x4205)))+(((r22)*(x4199)))+(((x4201)*(x4203)))+(((r21)*(x4200)))+(((IkReal(-1.00000000000000))*(r20)*(x4207))));
evalcond[4]=((((r02)*(x4199)))+(((sj1)*(x4194)))+(((IkReal(-1.00000000000000))*(r00)*(x4207)))+(((cj1)*(cj2)*(x4195)))+(((r01)*(x4200)))+(((x4201)*(x4202)))+(((r00)*(x4198))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(x4207)))+(((r11)*(x4200)))+(((r12)*(x4199)))+(((x4196)*(x4201)))+(((cj2)*(x4206)))+(((r10)*(x4198)))+(((IkReal(-1.00000000000000))*(cj1)*(x4194))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x4209=(sj1)*(sj1);
IkReal x4210=(cj1)*(cj1);
IkReal x4211=((cj5)*(r12));
IkReal x4212=((cj6)*(sj5));
IkReal x4213=((IkReal(1.00000000000000))*(sj1));
IkReal x4214=((cj5)*(r02));
IkReal x4215=((IkReal(1.00000000000000))*(cj1));
IkReal x4216=((r01)*(sj5)*(sj6));
IkReal x4217=((r11)*(sj5)*(sj6));
if( IKabs(((((IKabs(((((cj2)*(x4209)))+(((cj2)*(x4210))))) != 0)?((IkReal)1/(((((cj2)*(x4209)))+(((cj2)*(x4210)))))):(IkReal)1.0e30))*(((((r10)*(sj1)*(x4212)))+(((IkReal(-1.00000000000000))*(x4213)*(x4217)))+(((cj1)*(r00)*(x4212)))+(((sj1)*(x4211)))+(((IkReal(-1.00000000000000))*(x4215)*(x4216)))+(((cj1)*(x4214))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IKabs(((x4210)+(x4209))) != 0)?((IkReal)1/(((x4210)+(x4209)))):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(x4213)*(x4214)))+(((sj1)*(x4216)))+(((IkReal(-1.00000000000000))*(x4215)*(x4217)))+(((IkReal(-1.00000000000000))*(r00)*(x4212)*(x4213)))+(((cj1)*(x4211)))+(((cj1)*(r10)*(x4212))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IKabs(((((cj2)*(x4209)))+(((cj2)*(x4210))))) != 0)?((IkReal)1/(((((cj2)*(x4209)))+(((cj2)*(x4210)))))):(IkReal)1.0e30))*(((((r10)*(sj1)*(x4212)))+(((IkReal(-1.00000000000000))*(x4213)*(x4217)))+(((cj1)*(r00)*(x4212)))+(((sj1)*(x4211)))+(((IkReal(-1.00000000000000))*(x4215)*(x4216)))+(((cj1)*(x4214)))))))+IKsqr(((((IKabs(((x4210)+(x4209))) != 0)?((IkReal)1/(((x4210)+(x4209)))):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(x4213)*(x4214)))+(((sj1)*(x4216)))+(((IkReal(-1.00000000000000))*(x4215)*(x4217)))+(((IkReal(-1.00000000000000))*(r00)*(x4212)*(x4213)))+(((cj1)*(x4211)))+(((cj1)*(r10)*(x4212)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((IKabs(((((cj2)*(x4209)))+(((cj2)*(x4210))))) != 0)?((IkReal)1/(((((cj2)*(x4209)))+(((cj2)*(x4210)))))):(IkReal)1.0e30))*(((((r10)*(sj1)*(x4212)))+(((IkReal(-1.00000000000000))*(x4213)*(x4217)))+(((cj1)*(r00)*(x4212)))+(((sj1)*(x4211)))+(((IkReal(-1.00000000000000))*(x4215)*(x4216)))+(((cj1)*(x4214)))))), ((((IKabs(((x4210)+(x4209))) != 0)?((IkReal)1/(((x4210)+(x4209)))):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(x4213)*(x4214)))+(((sj1)*(x4216)))+(((IkReal(-1.00000000000000))*(x4215)*(x4217)))+(((IkReal(-1.00000000000000))*(r00)*(x4212)*(x4213)))+(((cj1)*(x4211)))+(((cj1)*(r10)*(x4212)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x4218=IKsin(j3);
IkReal x4219=IKcos(j3);
IkReal x4220=((r11)*(sj6));
IkReal x4221=((IkReal(1.00000000000000))*(sj5));
IkReal x4222=((sj4)*(sj6));
IkReal x4223=((cj4)*(sj5));
IkReal x4224=((cj6)*(sj4));
IkReal x4225=((cj4)*(cj5));
IkReal x4226=((r01)*(sj6));
IkReal x4227=((r21)*(sj6));
IkReal x4228=((cj6)*(sj5));
IkReal x4229=((IkReal(1.00000000000000))*(x4219));
IkReal x4230=((sj1)*(x4219));
IkReal x4231=((IkReal(1.00000000000000))*(cj6)*(x4225));
IkReal x4232=((IkReal(1.00000000000000))*(cj2)*(x4218));
evalcond[0]=((((cj5)*(r22)))+(((sj2)*(x4218)))+(((IkReal(-1.00000000000000))*(x4221)*(x4227)))+(((r20)*(x4228))));
evalcond[1]=((((r00)*(x4228)))+(((IkReal(-1.00000000000000))*(x4221)*(x4226)))+(x4230)+(((IkReal(-1.00000000000000))*(cj1)*(x4232)))+(((cj5)*(r02))));
evalcond[2]=((((cj5)*(r12)))+(((r10)*(x4228)))+(((IkReal(-1.00000000000000))*(sj1)*(x4232)))+(((IkReal(-1.00000000000000))*(cj1)*(x4229)))+(((IkReal(-1.00000000000000))*(x4220)*(x4221))));
evalcond[3]=((((IkReal(-1.00000000000000))*(sj2)*(x4229)))+(((r22)*(x4223)))+(((r21)*(x4224)))+(((x4225)*(x4227)))+(((r20)*(x4222)))+(((IkReal(-1.00000000000000))*(r20)*(x4231))));
evalcond[4]=((((r01)*(x4224)))+(((r00)*(x4222)))+(((r02)*(x4223)))+(((IkReal(-1.00000000000000))*(r00)*(x4231)))+(((sj1)*(x4218)))+(((x4225)*(x4226)))+(((cj1)*(cj2)*(x4219))));
evalcond[5]=((((r10)*(x4222)))+(((x4220)*(x4225)))+(((IkReal(-1.00000000000000))*(r10)*(x4231)))+(((cj2)*(x4230)))+(((IkReal(-1.00000000000000))*(cj1)*(x4218)))+(((r11)*(x4224)))+(((r12)*(x4223))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x4233=((cj4)*(cj5));
IkReal x4234=((r21)*(sj6));
IkReal x4235=((IkReal(1.00000000000000))*(cj6)*(r20));
if( IKabs(((gconst4)*(((((IkReal(-1.00000000000000))*(sj5)*(x4235)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x4234))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst4)*(((((cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(x4233)*(x4235)))+(((cj6)*(r21)*(sj4)))+(((x4233)*(x4234)))+(((r20)*(sj4)*(sj6))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst4)*(((((IkReal(-1.00000000000000))*(sj5)*(x4235)))+(((IkReal(-1.00000000000000))*(cj5)*(r22)))+(((sj5)*(x4234)))))), ((gconst4)*(((((cj4)*(r22)*(sj5)))+(((IkReal(-1.00000000000000))*(x4233)*(x4235)))+(((cj6)*(r21)*(sj4)))+(((x4233)*(x4234)))+(((r20)*(sj4)*(sj6)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[6];
IkReal x4236=IKsin(j3);
IkReal x4237=IKcos(j3);
IkReal x4238=((r11)*(sj6));
IkReal x4239=((IkReal(1.00000000000000))*(sj5));
IkReal x4240=((sj4)*(sj6));
IkReal x4241=((cj4)*(sj5));
IkReal x4242=((cj6)*(sj4));
IkReal x4243=((cj4)*(cj5));
IkReal x4244=((r01)*(sj6));
IkReal x4245=((r21)*(sj6));
IkReal x4246=((cj6)*(sj5));
IkReal x4247=((IkReal(1.00000000000000))*(x4237));
IkReal x4248=((sj1)*(x4237));
IkReal x4249=((IkReal(1.00000000000000))*(cj6)*(x4243));
IkReal x4250=((IkReal(1.00000000000000))*(cj2)*(x4236));
evalcond[0]=((((cj5)*(r22)))+(((r20)*(x4246)))+(((sj2)*(x4236)))+(((IkReal(-1.00000000000000))*(x4239)*(x4245))));
evalcond[1]=((((r00)*(x4246)))+(((IkReal(-1.00000000000000))*(cj1)*(x4250)))+(x4248)+(((IkReal(-1.00000000000000))*(x4239)*(x4244)))+(((cj5)*(r02))));
evalcond[2]=((((IkReal(-1.00000000000000))*(sj1)*(x4250)))+(((cj5)*(r12)))+(((r10)*(x4246)))+(((IkReal(-1.00000000000000))*(cj1)*(x4247)))+(((IkReal(-1.00000000000000))*(x4238)*(x4239))));
evalcond[3]=((((r20)*(x4240)))+(((r22)*(x4241)))+(((IkReal(-1.00000000000000))*(sj2)*(x4247)))+(((x4243)*(x4245)))+(((IkReal(-1.00000000000000))*(r20)*(x4249)))+(((r21)*(x4242))));
evalcond[4]=((((r00)*(x4240)))+(((r01)*(x4242)))+(((x4243)*(x4244)))+(((sj1)*(x4236)))+(((r02)*(x4241)))+(((cj1)*(cj2)*(x4237)))+(((IkReal(-1.00000000000000))*(r00)*(x4249))));
evalcond[5]=((((r10)*(x4240)))+(((IkReal(-1.00000000000000))*(cj1)*(x4236)))+(((x4238)*(x4243)))+(((IkReal(-1.00000000000000))*(r10)*(x4249)))+(((cj2)*(x4248)))+(((r12)*(x4241)))+(((r11)*(x4242))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}
}
}

}

}
    }
}
return solutions.GetNumSolutions()>0;
}

static inline bool checkconsistency8(const IkReal* Breal)
{
    IkReal norm = 0.1;
    for(int i = 0; i < 7; ++i) {
        norm += IKabs(Breal[i]);
    }
    IkReal tol = 1e-5*norm; // have to increase the threshold since many computations are involved
    return IKabs(Breal[0]*Breal[1]-Breal[2]) < tol && IKabs(Breal[1]*Breal[1]-Breal[3]) < tol && IKabs(Breal[0]*Breal[3]-Breal[4]) < tol && IKabs(Breal[1]*Breal[3]-Breal[5]) < tol && IKabs(Breal[0]*Breal[5]-Breal[6]) < tol;
}
/// \brief Solve the det Ax^2+Bx+C = 0 problem using the Manocha and Canny method (1994)
///
/// matcoeffs is of length 54*3, for 3 matrices
static inline void solvedialyticpoly8qep(const IkReal* matcoeffs, IkReal* rawroots, int& numroots)
{
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    IkReal IKFAST_ALIGNED16(M[16*16]) = {0};
    IkReal IKFAST_ALIGNED16(A[8*8]);
    IkReal IKFAST_ALIGNED16(work[16*16*15]);
    int ipiv[8];
    int info, coeffindex;
    const int worksize=16*16*15;
    const int matrixdim = 8;
    const int matrixdim2 = 16;
    numroots = 0;
    // first setup M = [0 I; -C -B] and A
    coeffindex = 0;
    for(int j = 0; j < 4; ++j) {
        for(int k = 0; k < 6; ++k) {
            M[matrixdim+(j+4)+2*matrixdim*k] = M[matrixdim+j+2*matrixdim*(k+2)] = -matcoeffs[coeffindex++];
        }
    }
    for(int j = 0; j < 4; ++j) {
        for(int k = 0; k < 6; ++k) {
            M[matrixdim+(j+4)+2*matrixdim*k+matrixdim*2*matrixdim] = M[matrixdim+j+2*matrixdim*(k+2)+matrixdim*2*matrixdim] = -matcoeffs[coeffindex++];
        }
    }
    for(int j = 0; j < 4; ++j) {
        for(int k = 0; k < 6; ++k) {
            A[(j+4)+matrixdim*k] = A[j+matrixdim*(k+2)] = matcoeffs[coeffindex++];
        }
        for(int k = 0; k < 2; ++k) {
            A[j+matrixdim*k] = A[(j+4)+matrixdim*(k+6)] = 0;
        }
    }
    const IkReal lfpossibilities[4][4] = {{1,-1,1,1},{1,0,-2,1},{1,1,2,0},{1,-1,4,1}};
    int lfindex = -1;
    bool bsingular = true;
    do {
        dgetrf_(&matrixdim,&matrixdim,A,&matrixdim,&ipiv[0],&info);
        if( info == 0 ) {
            bsingular = false;
            for(int j = 0; j < matrixdim; ++j) {
                if( IKabs(A[j*matrixdim+j]) < 100*tol ) {
                    bsingular = true;
                    break;
                }
            }
            if( !bsingular ) {
                break;
            }
        }
        if( lfindex == 3 ) {
            break;
        }
        // transform by the linear functional
        lfindex++;
        const IkReal* lf = lfpossibilities[lfindex];
        // have to reinitialize A
        coeffindex = 0;
        for(int j = 0; j < 4; ++j) {
            for(int k = 0; k < 6; ++k) {
                IkReal a = matcoeffs[coeffindex+48], b = matcoeffs[coeffindex+24], c = matcoeffs[coeffindex];
                A[(j+4)+matrixdim*k] = A[j+matrixdim*(k+2)] = lf[0]*lf[0]*a+lf[0]*lf[2]*b+lf[2]*lf[2]*c;
                M[matrixdim+(j+4)+2*matrixdim*k] = M[matrixdim+j+2*matrixdim*(k+2)] = -(lf[1]*lf[1]*a + lf[1]*lf[3]*b + lf[3]*lf[3]*c);
                M[matrixdim+(j+4)+2*matrixdim*k+matrixdim*2*matrixdim] = M[matrixdim+j+2*matrixdim*(k+2)+matrixdim*2*matrixdim] = -(2*lf[0]*lf[1]*a + (lf[0]*lf[3]+lf[1]*lf[2])*b + 2*lf[2]*lf[3]*c);
                coeffindex++;
            }
            for(int k = 0; k < 2; ++k) {
                A[j+matrixdim*k] = A[(j+4)+matrixdim*(k+6)] = 0;
            }
        }
    } while(lfindex<4);

    if( bsingular ) {
        return;
    }
    dgetrs_("No transpose", &matrixdim, &matrixdim2, A, &matrixdim, &ipiv[0], &M[matrixdim], &matrixdim2, &info);
    if( info != 0 ) {
        return;
    }

    // set identity in upper corner
    for(int j = 0; j < matrixdim; ++j) {
        M[matrixdim*2*matrixdim+j+matrixdim*2*j] = 1;
    }
    IkReal IKFAST_ALIGNED16(wr[16]);
    IkReal IKFAST_ALIGNED16(wi[16]);
    IkReal IKFAST_ALIGNED16(vr[16*16]);
    int one=1;
    dgeev_("N", "V", &matrixdim2, M, &matrixdim2, wr, wi,NULL, &one, vr, &matrixdim2, work, &worksize, &info);
    if( info != 0 ) {
        return;
    }
    IkReal Breal[matrixdim-1];
    for(int i = 0; i < matrixdim2; ++i) {
        if( IKabs(wi[i]) < tol*100 ) {
            IkReal* ev = vr+matrixdim2*i;
            if( IKabs(wr[i]) > 1 ) {
                ev += matrixdim;
            }
            // consistency has to be checked!!
            if( IKabs(ev[0]) < tol ) {
                continue;
            }
            IkReal iconst = 1/ev[0];
            for(int j = 1; j < matrixdim; ++j) {
                Breal[j-1] = ev[j]*iconst;
            }
            if( checkconsistency8(Breal) ) {
                if( lfindex >= 0 ) {
                    const IkReal* lf = lfpossibilities[lfindex];
                    rawroots[numroots++] = (wr[i]*lf[0]+lf[1])/(wr[i]*lf[2]+lf[3]);
                }
                else {
                    rawroots[numroots++] = wr[i];
                }
                bool bsmall0=IKabs(ev[0]) > IKabs(ev[2]);
                bool bsmall1=IKabs(ev[0]) > IKabs(ev[1]);
                if( bsmall0 && bsmall1 ) {
                    rawroots[numroots++] = ev[2]/ev[0];
                    rawroots[numroots++] = ev[1]/ev[0];
                }
                else if( bsmall0 && !bsmall1 ) {
                    rawroots[numroots++] = ev[3]/ev[1];
                    rawroots[numroots++] = ev[1]/ev[0];
                }
                else if( !bsmall0 && bsmall1 ) {
                    rawroots[numroots++] = ev[6]/ev[4];
                    rawroots[numroots++] = ev[7]/ev[6];
                }
                else if( !bsmall0 && !bsmall1 ) {
                    rawroots[numroots++] = ev[7]/ev[5];
                    rawroots[numroots++] = ev[7]/ev[6];
                }
            }
        }
    }
}};


/// solves the inverse kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API bool ComputeIk(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions) {
IKSolver solver;
return solver.ComputeIk(eetrans,eerot,pfree,solutions);
}

IKFAST_API const char* GetKinematicsHash() { return "<robot:GenericRobot - cob3_3 (e2dd794ce8555362ff4c38dd220c9234)>"; }

IKFAST_API const char* GetIkFastVersion() { return IKFAST_STRINGIZE(IKFAST_VERSION); }

#ifdef IKFAST_NAMESPACE
} // end namespace
#endif

#ifndef IKFAST_NO_MAIN
#include <stdio.h>
#include <stdlib.h>
#ifdef IKFAST_NAMESPACE
using namespace IKFAST_NAMESPACE;
#endif
int main(int argc, char** argv)
{
    if( argc != 12+GetNumFreeParameters()+1 ) {
        printf("\nUsage: ./ik r00 r01 r02 t0 r10 r11 r12 t1 r20 r21 r22 t2 free0 ...\n\n"
               "Returns the ik solutions given the transformation of the end effector specified by\n"
               "a 3x3 rotation R (rXX), and a 3x1 translation (tX).\n"
               "There are %d free parameters that have to be specified.\n\n",GetNumFreeParameters());
        return 1;
    }

    IkSolutionList<IkReal> solutions;
    std::vector<IkReal> vfree(GetNumFreeParameters());
    IkReal eerot[9],eetrans[3];
    eerot[0] = atof(argv[1]); eerot[1] = atof(argv[2]); eerot[2] = atof(argv[3]); eetrans[0] = atof(argv[4]);
    eerot[3] = atof(argv[5]); eerot[4] = atof(argv[6]); eerot[5] = atof(argv[7]); eetrans[1] = atof(argv[8]);
    eerot[6] = atof(argv[9]); eerot[7] = atof(argv[10]); eerot[8] = atof(argv[11]); eetrans[2] = atof(argv[12]);
    for(std::size_t i = 0; i < vfree.size(); ++i)
        vfree[i] = atof(argv[13+i]);
    bool bSuccess = ComputeIk(eetrans, eerot, vfree.size() > 0 ? &vfree[0] : NULL, solutions);

    if( !bSuccess ) {
        fprintf(stderr,"Failed to get ik solution\n");
        return -1;
    }

    printf("Found %d ik solutions:\n", (int)solutions.GetNumSolutions());
    std::vector<IkReal> solvalues(GetNumJoints());
    for(std::size_t i = 0; i < solutions.GetNumSolutions(); ++i) {
        const IkSolutionBase<IkReal>& sol = solutions.GetSolution(i);
        printf("sol%d (free=%d): ", (int)i, (int)sol.GetFree().size());
        std::vector<IkReal> vsolfree(sol.GetFree().size());
        sol.GetSolution(&solvalues[0],vsolfree.size()>0?&vsolfree[0]:NULL);
        for( std::size_t j = 0; j < solvalues.size(); ++j)
            printf("%.15f, ", solvalues[j]);
        printf("\n");
    }
    return 0;
}

#endif
