# Software License Agreement (BSD License)
#
# Copyright (C) 2013, Jack O'Quin
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
#  * Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
#  * Redistributions in binary form must reproduce the above
#    copyright notice, this list of conditions and the following
#    disclaimer in the documentation and/or other materials provided
#    with the distribution.
#  * Neither the name of the author nor of other contributors may be
#    used to endorse or promote products derived from this software
#    without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
# FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
# COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
# ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

"""
.. module:: common

This module provides some common definitions for the ROCON resource
scheduler, part of the `Robotics in Concert`_ project.

.. include:: weblinks.rst

"""

# (unicode_literals not compatible with python2 uuid module)
from __future__ import absolute_import, print_function

HEARTBEAT_HZ = 1.0 / 4.0
""" Default requester heartbeat frequency (Hz)."""

SCHEDULER_TOPIC = 'rocon_scheduler'
""" Default ROCON scheduler topic name. """


def feedback_topic(uuid, scheduler_topic=SCHEDULER_TOPIC):
    """ Construct scheduler feedback topic name.

    :param uuid: UUID_ of the requester.
    :type uuid: :class:`uuid.UUID`

    :param scheduler_topic: Topic name for the corresponding
                  scheduler. If missing, the usual scheduler topic
                  name is assumed.
    :type scheduler_topic: str
    :returns: Topic name string for replying to this requester.

    """
    return scheduler_topic + '_' + uuid.hex
