/// autogenerated analytical inverse kinematics code from ikfast program part of OpenRAVE
/// \author Rosen Diankov
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///     http://www.apache.org/licenses/LICENSE-2.0
/// 
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// ikfast version 61 generated on 2014-10-24 09:56:14.433677
/// To compile with gcc:
///     gcc -lstdc++ ik.cpp
/// To compile without any main function as a shared object (might need -llapack):
///     gcc -fPIC -lstdc++ -DIKFAST_NO_MAIN -DIKFAST_CLIBRARY -shared -Wl,-soname,libik.so -o libik.so ik.cpp
#define IKFAST_HAS_LIBRARY
#include "ikfast.h" // found inside share/openrave-X.Y/python/ikfast.h
using namespace ikfast;

// check if the included ikfast version matches what this file was compiled with
#define IKFAST_COMPILE_ASSERT(x) extern int __dummy[(int)x]
IKFAST_COMPILE_ASSERT(IKFAST_VERSION==61);

#include <cmath>
#include <vector>
#include <limits>
#include <algorithm>
#include <complex>

#define IKFAST_STRINGIZE2(s) #s
#define IKFAST_STRINGIZE(s) IKFAST_STRINGIZE2(s)

#ifndef IKFAST_ASSERT
#include <stdexcept>
#include <sstream>
#include <iostream>

#ifdef _MSC_VER
#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __FUNCDNAME__
#endif
#endif

#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __func__
#endif

#define IKFAST_ASSERT(b) { if( !(b) ) { std::stringstream ss; ss << "ikfast exception: " << __FILE__ << ":" << __LINE__ << ": " <<__PRETTY_FUNCTION__ << ": Assertion '" << #b << "' failed"; throw std::runtime_error(ss.str()); } }

#endif

#if defined(_MSC_VER)
#define IKFAST_ALIGNED16(x) __declspec(align(16)) x
#else
#define IKFAST_ALIGNED16(x) x __attribute((aligned(16)))
#endif

#define IK2PI  ((IkReal)6.28318530717959)
#define IKPI  ((IkReal)3.14159265358979)
#define IKPI_2  ((IkReal)1.57079632679490)

#ifdef _MSC_VER
#ifndef isnan
#define isnan _isnan
#endif
#endif // _MSC_VER

// lapack routines
extern "C" {
  void dgetrf_ (const int* m, const int* n, double* a, const int* lda, int* ipiv, int* info);
  void zgetrf_ (const int* m, const int* n, std::complex<double>* a, const int* lda, int* ipiv, int* info);
  void dgetri_(const int* n, const double* a, const int* lda, int* ipiv, double* work, const int* lwork, int* info);
  void dgesv_ (const int* n, const int* nrhs, double* a, const int* lda, int* ipiv, double* b, const int* ldb, int* info);
  void dgetrs_(const char *trans, const int *n, const int *nrhs, double *a, const int *lda, int *ipiv, double *b, const int *ldb, int *info);
  void dgeev_(const char *jobvl, const char *jobvr, const int *n, double *a, const int *lda, double *wr, double *wi,double *vl, const int *ldvl, double *vr, const int *ldvr, double *work, const int *lwork, int *info);
}

using namespace std; // necessary to get std math routines

#ifdef IKFAST_NAMESPACE
namespace IKFAST_NAMESPACE {
#endif

inline float IKabs(float f) { return fabsf(f); }
inline double IKabs(double f) { return fabs(f); }

inline float IKsqr(float f) { return f*f; }
inline double IKsqr(double f) { return f*f; }

inline float IKlog(float f) { return logf(f); }
inline double IKlog(double f) { return log(f); }

// allows asin and acos to exceed 1
#ifndef IKFAST_SINCOS_THRESH
#define IKFAST_SINCOS_THRESH ((IkReal)0.000001)
#endif

// used to check input to atan2 for degenerate cases
#ifndef IKFAST_ATAN2_MAGTHRESH
#define IKFAST_ATAN2_MAGTHRESH ((IkReal)2e-6)
#endif

// minimum distance of separate solutions
#ifndef IKFAST_SOLUTION_THRESH
#define IKFAST_SOLUTION_THRESH ((IkReal)1e-6)
#endif

inline float IKasin(float f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return float(-IKPI_2);
else if( f >= 1 ) return float(IKPI_2);
return asinf(f);
}
inline double IKasin(double f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return -IKPI_2;
else if( f >= 1 ) return IKPI_2;
return asin(f);
}

// return positive value in [0,y)
inline float IKfmod(float x, float y)
{
    while(x < 0) {
        x += y;
    }
    return fmodf(x,y);
}

// return positive value in [0,y)
inline double IKfmod(double x, double y)
{
    while(x < 0) {
        x += y;
    }
    return fmod(x,y);
}

inline float IKacos(float f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return float(IKPI);
else if( f >= 1 ) return float(0);
return acosf(f);
}
inline double IKacos(double f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return IKPI;
else if( f >= 1 ) return 0;
return acos(f);
}
inline float IKsin(float f) { return sinf(f); }
inline double IKsin(double f) { return sin(f); }
inline float IKcos(float f) { return cosf(f); }
inline double IKcos(double f) { return cos(f); }
inline float IKtan(float f) { return tanf(f); }
inline double IKtan(double f) { return tan(f); }
inline float IKsqrt(float f) { if( f <= 0.0f ) return 0.0f; return sqrtf(f); }
inline double IKsqrt(double f) { if( f <= 0.0 ) return 0.0; return sqrt(f); }
inline float IKatan2(float fy, float fx) {
    if( isnan(fy) ) {
        IKFAST_ASSERT(!isnan(fx)); // if both are nan, probably wrong value will be returned
        return float(IKPI_2);
    }
    else if( isnan(fx) ) {
        return 0;
    }
    return atan2f(fy,fx);
}
inline double IKatan2(double fy, double fx) {
    if( isnan(fy) ) {
        IKFAST_ASSERT(!isnan(fx)); // if both are nan, probably wrong value will be returned
        return IKPI_2;
    }
    else if( isnan(fx) ) {
        return 0;
    }
    return atan2(fy,fx);
}

inline float IKsign(float f) {
    if( f > 0 ) {
        return float(1);
    }
    else if( f < 0 ) {
        return float(-1);
    }
    return 0;
}

inline double IKsign(double f) {
    if( f > 0 ) {
        return 1.0;
    }
    else if( f < 0 ) {
        return -1.0;
    }
    return 0;
}

/// solves the forward kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API void ComputeFk(const IkReal* j, IkReal* eetrans, IkReal* eerot) {
IkReal x0,x1,x2,x3,x4,x5,x6,x7,x8,x9,x10,x11,x12,x13,x14,x15,x16,x17,x18,x19,x20,x21,x22,x23,x24;
x0=IKcos(j[0]);
x1=IKsin(j[1]);
x2=IKcos(j[2]);
x3=IKcos(j[1]);
x4=IKsin(j[2]);
x5=IKsin(j[3]);
x6=IKsin(j[0]);
x7=IKcos(j[3]);
x8=IKcos(j[4]);
x9=IKsin(j[4]);
x10=((IkReal(0.0750000000000000))*(x0));
x11=((IkReal(0.0800000000000000))*(x6));
x12=((IkReal(1.00000000000000))*(x0));
x13=((IkReal(1.00000000000000))*(x6));
x14=((IkReal(0.327500000000000))*(x0));
x15=((IkReal(0.327500000000000))*(x6));
x16=((IkReal(0.300000000000000))*(x1));
x17=((IkReal(0.0800000000000000))*(x0));
x18=((IkReal(0.0750000000000000))*(x6));
x19=((x3)*(x4));
x20=((x1)*(x2));
x21=((x2)*(x3));
x22=((x1)*(x4));
x23=((IkReal(0.0750000000000000))*(x20));
x24=((x1)*(x11));
IkReal x25=((IkReal(1.00000000000000))*(x19));
eetrans[0]=((((x0)*(x16)))+(((IkReal(-1.00000000000000))*(x10)*(x25)))+(x10)+(((x10)*(x20)))+(((x7)*(((((x17)*(x22)))+(((x17)*(x21)))))))+(((x14)*(x21)))+(((x14)*(x22)))+(((x5)*(((((IkReal(-1.00000000000000))*(x17)*(x25)))+(((x17)*(x20))))))));
IkReal x26=((IkReal(1.00000000000000))*(x19));
eetrans[1]=((((x7)*(((((x11)*(x21)))+(((x11)*(x22)))))))+(((x15)*(x21)))+(((x15)*(x22)))+(x18)+(((IkReal(-1.00000000000000))*(x18)*(x26)))+(((x16)*(x6)))+(((x5)*(((((x11)*(x20)))+(((IkReal(-1.00000000000000))*(x11)*(x26)))))))+(((x18)*(x20))));
eetrans[2]=((IkReal(0.330000000000000))+(((x7)*(((((IkReal(0.0800000000000000))*(x19)))+(((IkReal(-0.0800000000000000))*(x20)))))))+(((IkReal(0.327500000000000))*(x19)))+(((IkReal(-0.327500000000000))*(x20)))+(((IkReal(0.0750000000000000))*(x21)))+(((IkReal(0.300000000000000))*(x3)))+(((IkReal(0.0750000000000000))*(x22)))+(((x5)*(((((IkReal(0.0800000000000000))*(x21)))+(((IkReal(0.0800000000000000))*(x22))))))));
IkReal x27=((IkReal(1.00000000000000))*(x12));
eerot[0]=((((IkReal(-1.00000000000000))*(x13)*(x9)))+(((x8)*(((((x5)*(((((IkReal(-1.00000000000000))*(x21)*(x27)))+(((IkReal(-1.00000000000000))*(x22)*(x27)))))))+(((x7)*(((((x0)*(x20)))+(((IkReal(-1.00000000000000))*(x19)*(x27))))))))))));
IkReal x28=((IkReal(1.00000000000000))*(x13));
eerot[1]=((((x8)*(((((x5)*(((((IkReal(-1.00000000000000))*(x21)*(x28)))+(((IkReal(-1.00000000000000))*(x22)*(x28)))))))+(((x7)*(((((x20)*(x6)))+(((IkReal(-1.00000000000000))*(x19)*(x28)))))))))))+(((x0)*(x9))));
eerot[2]=((x8)*(((((x5)*(((((IkReal(1.00000000000000))*(x20)))+(((IkReal(-1.00000000000000))*(x19)))))))+(((x7)*(((x21)+(x22))))))));
}

IKFAST_API int GetNumFreeParameters() { return 0; }
IKFAST_API int* GetFreeParameters() { return NULL; }
IKFAST_API int GetNumJoints() { return 5; }

IKFAST_API int GetIkRealSize() { return sizeof(IkReal); }

IKFAST_API int GetIkType() { return 0x56000007; }

class IKSolver {
public:
IkReal j0,cj0,sj0,htj0,j1,cj1,sj1,htj1,j2,cj2,sj2,htj2,j3,cj3,sj3,htj3,j4,cj4,sj4,htj4,new_r00,r00,rxp0_0,new_r01,r01,rxp0_1,new_r02,r02,rxp0_2,new_px,px,npx,new_py,py,npy,new_pz,pz,npz,pp;
unsigned char _ij0[2], _nj0,_ij1[2], _nj1,_ij2[2], _nj2,_ij3[2], _nj3,_ij4[2], _nj4;

bool ComputeIk(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions) {
j0=numeric_limits<IkReal>::quiet_NaN(); _ij0[0] = -1; _ij0[1] = -1; _nj0 = -1; j1=numeric_limits<IkReal>::quiet_NaN(); _ij1[0] = -1; _ij1[1] = -1; _nj1 = -1; j2=numeric_limits<IkReal>::quiet_NaN(); _ij2[0] = -1; _ij2[1] = -1; _nj2 = -1; j3=numeric_limits<IkReal>::quiet_NaN(); _ij3[0] = -1; _ij3[1] = -1; _nj3 = -1; j4=numeric_limits<IkReal>::quiet_NaN(); _ij4[0] = -1; _ij4[1] = -1; _nj4 = -1; 
for(int dummyiter = 0; dummyiter < 1; ++dummyiter) {
    solutions.Clear();
px = eetrans[0]; py = eetrans[1]; pz = eetrans[2];

r00 = eerot[0];
r01 = eerot[1];
r02 = eerot[2];
px = eetrans[0]; py = eetrans[1]; pz = eetrans[2];
new_r00=r00;
new_px=px;
new_r01=r01;
new_py=py;
new_r02=r02;
new_pz=((IkReal(-0.330000000000000))+(pz));
r00 = new_r00; r01 = new_r01; r02 = new_r02; px = new_px; py = new_py; pz = new_pz;

pp=(((px)*(px))+((pz)*(pz))+((py)*(py)));
{
IkReal j0array[2], cj0array[2], sj0array[2];
bool j0valid[2]={false};
_nj0 = 2;
if( IKabs(((IkReal(-1.00000000000000))*(py))) < IKFAST_ATAN2_MAGTHRESH && IKabs(px) < IKFAST_ATAN2_MAGTHRESH )
    continue;
IkReal x29=IKatan2(((IkReal(-1.00000000000000))*(py)), px);
j0array[0]=((IkReal(-1.00000000000000))*(x29));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
j0array[1]=((IkReal(3.14159265358979))+(((IkReal(-1.00000000000000))*(x29))));
sj0array[1]=IKsin(j0array[1]);
cj0array[1]=IKcos(j0array[1]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
if( j0array[1] > IKPI )
{
    j0array[1]-=IK2PI;
}
else if( j0array[1] < -IKPI )
{    j0array[1]+=IK2PI;
}
j0valid[1] = true;
for(int ij0 = 0; ij0 < 2; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 2; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];

IkReal op[4+1], zeror[4];
int numroots;
op[0]=((((IkReal(-0.00325687500000000))*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-2.40000000000000))*(px)*(r00)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.676575000000000))*(px)*(pz)*(r00)*(r02)))+(((IkReal(-4.00000000000000))*((cj0)*(cj0))*((px)*(px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-8.00000000000000))*(pz)*(r00)*(r02)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(0.763425000000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(1.20000000000000))*(pp)*(px)*(r00)*(r02)))+(((IkReal(-2.40000000000000))*(pz)*((py)*(py))*((r01)*(r01))))+(((IkReal(0.763425000000000))*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.180000000000000))*(px)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(0.600000000000000))*(cj0)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(0.0567750000000000))*(cj0)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(1.20000000000000))*(cj0)*(pp)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(-1.00000000000000))*((pp)*(pp))*((r02)*(r02))))+(((IkReal(-4.80000000000000))*(cj0)*(px)*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(-4.80000000000000))*(cj0)*(py)*(r00)*(r02)*(sj0)*((px)*(px))))+(((IkReal(0.138050000000000))*(cj0)*(px)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-0.0283875000000000))*(cj0)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(0.0130275000000000))*(pz)*((r02)*(r02))))+(((IkReal(-0.381712500000000))*(pp)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.180000000000000))*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(-8.00000000000000))*(px)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(-8.00000000000000))*(py)*(r00)*(r01)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(4.00000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(4.00000000000000))*(pp)*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(-0.00709687500000000))*(cj0)*(px)*((r02)*(r02))))+(((IkReal(0.180000000000000))*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(-0.382500000000000))*((py)*(py))*((r01)*(r01))))+(((IkReal(-8.00000000000000))*(py)*(r01)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(-0.600000000000000))*(pp)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(4.00000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(0.180000000000000))*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(0.600000000000000))*(r01)*(r02)*(sj0)*((pz)*(pz)*(pz))))+(((IkReal(4.00000000000000))*(pp)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(0.763425000000000))*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(-4.00000000000000))*((py)*(py)*(py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(2.61418359375000e-5))*((r02)*(r02))))+(((IkReal(0.600000000000000))*(px)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(0.600000000000000))*(cj0)*(pz)*(r00)*(r02)*((px)*(px))))+(((IkReal(0.625375000000000))*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-2.40000000000000))*(cj0)*(pp)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(-0.00325687500000000))*(cj0)*(py)*(r00)*(r01)))+(((IkReal(0.0690250000000000))*((cj0)*(cj0))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(4.00000000000000))*(pp)*(px)*(pz)*(r00)*(r02)))+(((IkReal(4.00000000000000))*(pp)*(py)*(pz)*(r01)*(r02)))+(((IkReal(-1.00000000000000))*((cj0)*(cj0))*((pp)*(pp))*((r00)*(r00))))+(((IkReal(-0.0283875000000000))*(cj0)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(-0.765000000000000))*(px)*(py)*(r00)*(r01)))+(((IkReal(-0.00709687500000000))*(py)*(sj0)*((r02)*(r02))))+(((IkReal(1.20000000000000))*(pp)*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(0.600000000000000))*(cj0)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(-4.80000000000000))*(cj0)*(px)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(0.0130275000000000))*(py)*(r01)*(r02)))+(((IkReal(4.00000000000000))*(pp)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(-4.00000000000000))*((px)*(px))*((py)*(py))*((r00)*(r00))*((sj0)*(sj0))))+(((IkReal(-2.40000000000000))*(r01)*(r02)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.763425000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)))+(((IkReal(2.40000000000000))*(cj0)*(px)*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(-4.00000000000000))*((cj0)*(cj0))*((px)*(px))*((py)*(py))*((r01)*(r01))))+(((IkReal(-16.0000000000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))*((py)*(py))))+(((IkReal(0.600000000000000))*(cj0)*(px)*(py)*(pz)*(r01)*(r02)))+(((IkReal(-2.40000000000000))*(pz)*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(4.00000000000000))*(pp)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-4.80000000000000))*(py)*(r01)*(r02)*((pz)*(pz))))+(((IkReal(-0.180000000000000))*(cj0)*(pp)*(r00)*(r02)))+(((IkReal(0.00384000000000000))*(cj0)*(pz)*(r00)*(r02)))+(((IkReal(0.00115200000000000))*(r01)*(r02)*(sj0)))+(((IkReal(2.40000000000000))*(px)*(py)*(pz)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(2.40000000000000))*(cj0)*(px)*(py)*(pz)*(sj0)*((r00)*(r00))))+(((IkReal(-0.600000000000000))*(cj0)*(pp)*(pz)*(r00)*(r02)))+(((IkReal(-2.40000000000000))*(r00)*(r02)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(-16.0000000000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)*((px)*(px))))+(((IkReal(-4.00000000000000))*((px)*(px))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(0.600000000000000))*(py)*(sj0)*((px)*(px))*((r00)*(r00))))+(((IkReal(-0.00325687500000000))*(px)*(r00)*(r01)*(sj0)))+(((IkReal(-8.00000000000000))*(py)*(pz)*(r01)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-0.00325687500000000))*(cj0)*(px)*((r00)*(r00))))+(((IkReal(0.0690250000000000))*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(-0.180000000000000))*(pp)*(r01)*(r02)*(sj0)))+(((IkReal(0.00218614183593750))*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(0.00437228367187500))*(cj0)*(r00)*(r01)*(sj0)))+(((IkReal(0.600000000000000))*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(4.00000000000000))*(pp)*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-2.40000000000000))*(pz)*((px)*(px))*((r00)*(r00))))+(((IkReal(-8.00000000000000))*(pz)*(r01)*(r02)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(1.20000000000000))*(pp)*(px)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(1.20000000000000))*(pp)*(py)*(r01)*(r02)))+(((IkReal(0.600000000000000))*(px)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(2.40000000000000))*(py)*(r01)*(r02)*((pz)*(pz))*((sj0)*(sj0))))+(((IkReal(0.300000000000000))*(pp)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(0.00218614183593750))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.180000000000000))*(cj0)*(px)*(pz)*((r00)*(r00))))+(((IkReal(-8.00000000000000))*(px)*(r00)*(r01)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(0.600000000000000))*(cj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(0.180000000000000))*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(0.180000000000000))*(cj0)*(py)*(pz)*(r00)*(r01)))+(((IkReal(0.763425000000000))*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(-4.80000000000000))*(px)*(py)*(pz)*(r00)*(r01)))+(((IkReal(0.138050000000000))*(cj0)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-8.00000000000000))*(cj0)*(py)*(sj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-0.381712500000000))*(pp)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(2.40000000000000))*(cj0)*(px)*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(2.40000000000000))*(px)*(py)*(pz)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(-1.20000000000000))*(pp)*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(1.20000000000000))*(pp)*(pz)*((r02)*(r02))))+(((IkReal(0.0283875000000000))*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-4.00000000000000))*((py)*(py))*((pz)*(pz))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(1.20000000000000))*(cj0)*(py)*(r00)*(r01)*((px)*(px))))+(((IkReal(2.40000000000000))*(cj0)*(pz)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(0.763425000000000))*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(0.180000000000000))*(cj0)*(px)*(py)*(r01)*(r02)))+(((IkReal(-0.294075000000000))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-8.00000000000000))*(px)*(pz)*(r00)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-4.00000000000000))*((py)*(py))*((pz)*(pz))*((r01)*(r01))))+(((IkReal(0.00384000000000000))*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-2.00000000000000))*(cj0)*(r00)*(r01)*(sj0)*((pp)*(pp))))+(((IkReal(0.600000000000000))*(cj0)*(px)*((py)*(py))*((r01)*(r01))))+(((IkReal(2.40000000000000))*(px)*(r00)*(r02)*((cj0)*(cj0))*((pz)*(pz))))+(((IkReal(0.180000000000000))*(cj0)*(r00)*(r02)*((px)*(px))))+(((IkReal(-4.00000000000000))*((pz)*(pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(-1.20000000000000))*(pp)*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.625375000000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-0.382500000000000))*((px)*(px))*((r00)*(r00))))+(((IkReal(-2.40000000000000))*(pz)*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(-0.0283875000000000))*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(0.763425000000000))*(cj0)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(-0.300000000000000))*(cj0)*(pp)*(px)*((r00)*(r00))))+(((IkReal(0.763425000000000))*(cj0)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(0.0690250000000000))*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(-0.300000000000000))*(pp)*(px)*(r00)*(r01)*(sj0)))+(((IkReal(-8.00000000000000))*(px)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(-2.40000000000000))*((pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(-4.00000000000000))*((cj0)*(cj0))*((px)*(px))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.0442125000000000))*(pp)*((r02)*(r02))))+(((IkReal(-0.300000000000000))*(pp)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(0.600000000000000))*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(2.40000000000000))*(cj0)*(py)*(r00)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(-2.40000000000000))*(py)*(r01)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-8.00000000000000))*(cj0)*(px)*(py)*(sj0)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(0.180000000000000))*(cj0)*(px)*(pz)*((r02)*(r02))))+(((IkReal(0.180000000000000))*(px)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(1.20000000000000))*(px)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(0.00115200000000000))*(cj0)*(r00)*(r02)))+(((IkReal(0.0690250000000000))*((pz)*(pz))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-0.0283875000000000))*(px)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(0.625375000000000))*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(0.625375000000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(0.180000000000000))*(cj0)*(r00)*(r02)*((pz)*(pz))))+(((IkReal(-0.676575000000000))*(py)*(pz)*(r01)*(r02)))+(((IkReal(0.763425000000000))*(cj0)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(2.40000000000000))*(pz)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(-1.00000000000000))*((pp)*(pp))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.0130275000000000))*(px)*(r00)*(r02)))+(((IkReal(0.0283875000000000))*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(-0.300000000000000))*(cj0)*(pp)*(py)*(r00)*(r01)))+(((IkReal(-8.00000000000000))*(cj0)*(px)*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(-16.0000000000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(0.300000000000000))*(cj0)*(pp)*(px)*((r02)*(r02))))+(((IkReal(2.40000000000000))*(cj0)*(pz)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(1.20000000000000))*(cj0)*(pp)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(0.600000000000000))*(py)*(sj0)*((pz)*(pz))*((r01)*(r01))))+(((IkReal(2.40000000000000))*(pz)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.600000000000000))*(cj0)*(px)*((pz)*(pz))*((r00)*(r00))))+(((IkReal(-4.80000000000000))*(px)*(r00)*(r02)*((pz)*(pz)))));
op[1]=((((IkReal(0.360000000000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(4.80000000000000))*(py)*(sj0)*((px)*(px))*((r00)*(r00))))+(((IkReal(-0.360000000000000))*(py)*(pz)*(r01)*(r02)))+(((IkReal(0.000945000000000000))*(cj0)*(px)*((r00)*(r00))))+(((IkReal(-0.108000000000000))*(px)*(r00)*(r02)))+(((IkReal(-4.80000000000000))*(pp)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(0.0307200000000000))*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(2.40000000000000))*(pp)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-2.40000000000000))*(cj0)*(pp)*(px)*((r00)*(r00))))+(((IkReal(-0.360000000000000))*((pz)*(pz))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.180000000000000))*(pp)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.00921600000000000))*(r01)*(r02)*(sj0)))+(((IkReal(4.80000000000000))*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(9.60000000000000))*(px)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-0.108000000000000))*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-0.360000000000000))*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(4.80000000000000))*(cj0)*(pz)*(r00)*(r02)*((px)*(px))))+(((IkReal(0.360000000000000))*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-0.360000000000000))*((cj0)*(cj0))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(0.108000000000000))*(cj0)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(0.360000000000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(-0.180000000000000))*(pp)*((r02)*(r02))))+(((IkReal(-0.720000000000000))*(px)*(py)*(r00)*(r01)))+(((IkReal(1.44000000000000))*(cj0)*(py)*(pz)*(r00)*(r01)))+(((IkReal(1.44000000000000))*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(-0.360000000000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(-1.44000000000000))*(pp)*(r01)*(r02)*(sj0)))+(((IkReal(0.00390825000000000))*(cj0)*(r00)*(r01)*(sj0)))+(((IkReal(4.80000000000000))*(px)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(-0.360000000000000))*((py)*(py))*((r01)*(r01))))+(((IkReal(1.44000000000000))*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(-0.360000000000000))*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(-2.40000000000000))*(pp)*(px)*(r00)*(r01)*(sj0)))+(((IkReal(0.000945000000000000))*(cj0)*(py)*(r00)*(r01)))+(((IkReal(-0.360000000000000))*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(4.80000000000000))*(cj0)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(0.000945000000000000))*(px)*(r00)*(r01)*(sj0)))+(((IkReal(-0.720000000000000))*(cj0)*(px)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-0.360000000000000))*(cj0)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-4.80000000000000))*(cj0)*(pp)*(pz)*(r00)*(r02)))+(((IkReal(1.44000000000000))*(cj0)*(r00)*(r02)*((pz)*(pz))))+(((IkReal(1.44000000000000))*(px)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(4.80000000000000))*(cj0)*(px)*((py)*(py))*((r01)*(r01))))+(((IkReal(0.00195412500000000))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(4.80000000000000))*(py)*(sj0)*((pz)*(pz))*((r01)*(r01))))+(((IkReal(-0.360000000000000))*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(0.00921600000000000))*(cj0)*(r00)*(r02)))+(((IkReal(4.80000000000000))*(r01)*(r02)*(sj0)*((pz)*(pz)*(pz))))+(((IkReal(0.108000000000000))*(cj0)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(-1.44000000000000))*(cj0)*(pp)*(r00)*(r02)))+(((IkReal(0.108000000000000))*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(0.0307200000000000))*(cj0)*(pz)*(r00)*(r02)))+(((IkReal(1.44000000000000))*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-0.360000000000000))*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(4.80000000000000))*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(4.80000000000000))*(cj0)*(px)*((pz)*(pz))*((r00)*(r00))))+(((IkReal(0.360000000000000))*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(9.60000000000000))*(cj0)*(py)*(r00)*(r01)*((px)*(px))))+(((IkReal(-0.360000000000000))*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(4.80000000000000))*(cj0)*(px)*(py)*(pz)*(r01)*(r02)))+(((IkReal(-2.40000000000000))*(pp)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-0.0297750000000000))*(py)*(sj0)*((r02)*(r02))))+(((IkReal(1.44000000000000))*(cj0)*(r00)*(r02)*((px)*(px))))+(((IkReal(0.00195412500000000))*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-0.360000000000000))*(cj0)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-0.360000000000000))*((px)*(px))*((r00)*(r00))))+(((IkReal(2.40000000000000))*(cj0)*(pp)*(px)*((r02)*(r02))))+(((IkReal(1.44000000000000))*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(4.80000000000000))*(cj0)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(1.44000000000000))*(px)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(4.80000000000000))*(cj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(1.44000000000000))*(cj0)*(px)*(pz)*((r02)*(r02))))+(((IkReal(-0.0297750000000000))*(cj0)*(px)*((r02)*(r02))))+(((IkReal(-2.40000000000000))*(cj0)*(pp)*(py)*(r00)*(r01)))+(((IkReal(1.44000000000000))*(cj0)*(px)*(py)*(r01)*(r02)))+(((IkReal(-0.720000000000000))*(cj0)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(-0.360000000000000))*(cj0)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(0.00425812500000000))*((r02)*(r02))))+(((IkReal(0.108000000000000))*(px)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(-0.108000000000000))*(py)*(r01)*(r02)))+(((IkReal(0.360000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)))+(((IkReal(-0.360000000000000))*(px)*(pz)*(r00)*(r02)))+(((IkReal(-0.108000000000000))*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(0.000945000000000000))*(py)*(sj0)*((r01)*(r01))))+(((IkReal(4.80000000000000))*(px)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(-0.216000000000000))*(cj0)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(-0.108000000000000))*(pz)*((r02)*(r02))))+(((IkReal(0.180000000000000))*(pp)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(1.44000000000000))*(cj0)*(px)*(pz)*((r00)*(r00)))));
op[2]=((((IkReal(-16.0000000000000))*(pz)*(r01)*(r02)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.0129437163281250))*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(0.201806250000000))*(cj0)*(px)*((r02)*(r02))))+(((IkReal(0.276100000000000))*(cj0)*(px)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-1.62925000000000))*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(1.20000000000000))*(r01)*(r02)*(sj0)*((pz)*(pz)*(pz))))+(((IkReal(1.20000000000000))*(cj0)*(pz)*(r00)*(r02)*((px)*(px))))+(((IkReal(0.676575000000000))*(pp)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(8.00000000000000))*(pp)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(1.52685000000000))*(py)*(pz)*(r01)*(r02)))+(((IkReal(-32.0000000000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-16.0000000000000))*(px)*(r00)*(r01)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(-8.00000000000000))*((px)*(px))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(-1.35315000000000))*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(8.00000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(-8.00000000000000))*((py)*(py))*((pz)*(pz))*((r01)*(r01))))+(((IkReal(-1.20000000000000))*(pp)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(0.138050000000000))*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(0.209486250000000))*(cj0)*(py)*(r00)*(r01)))+(((IkReal(0.600000000000000))*(pp)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(8.00000000000000))*(pp)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.209486250000000))*(px)*(r00)*(r01)*(sj0)))+(((IkReal(-16.0000000000000))*(cj0)*(py)*(sj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(0.676575000000000))*(pp)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.00768000000000000))*(cj0)*(pz)*(r00)*(r02)))+(((IkReal(0.209486250000000))*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-1.62925000000000))*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-2.00000000000000))*((pp)*(pp))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(1.20000000000000))*(cj0)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(-1.35315000000000))*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-2.00000000000000))*((pp)*(pp))*((r02)*(r02))))+(((IkReal(0.209486250000000))*(cj0)*(px)*((r00)*(r00))))+(((IkReal(-16.0000000000000))*(py)*(pz)*(r01)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(1.20000000000000))*(px)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(1.35315000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)))+(((IkReal(8.00000000000000))*(pp)*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(pz)*(r00)*(r02)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(8.00000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(8.00000000000000))*(pp)*(px)*(pz)*(r00)*(r02)))+(((IkReal(-32.0000000000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)*((px)*(px))))+(((IkReal(-2.00000000000000))*((cj0)*(cj0))*((pp)*(pp))*((r00)*(r00))))+(((IkReal(-1.35315000000000))*(cj0)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-16.0000000000000))*(py)*(r01)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(-4.00000000000000))*(cj0)*(r00)*(r01)*(sj0)*((pp)*(pp))))+(((IkReal(8.00000000000000))*(cj0)*(pp)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(0.276100000000000))*(cj0)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(1.20000000000000))*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-0.765000000000000))*((py)*(py))*((r01)*(r01))))+(((IkReal(1.20000000000000))*(cj0)*(px)*((pz)*(pz))*((r00)*(r00))))+(((IkReal(-1.62925000000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-16.0000000000000))*(px)*(pz)*(r00)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-1.35315000000000))*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(-16.0000000000000))*(cj0)*(px)*(py)*(sj0)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(0.00116828367187500))*((r02)*(r02))))+(((IkReal(-1.52842500000000))*(pp)*((r02)*(r02))))+(((IkReal(1.20000000000000))*(cj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-1.53000000000000))*(px)*(py)*(r00)*(r01)))+(((IkReal(-8.00000000000000))*((cj0)*(cj0))*((px)*(px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-16.0000000000000))*(px)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(-1.35315000000000))*(cj0)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-8.00000000000000))*((cj0)*(cj0))*((px)*(px))*((py)*(py))*((r01)*(r01))))+(((IkReal(0.201806250000000))*(py)*(sj0)*((r02)*(r02))))+(((IkReal(2.40000000000000))*(cj0)*(py)*(r00)*(r01)*((px)*(px))))+(((IkReal(-0.765000000000000))*((px)*(px))*((r00)*(r00))))+(((IkReal(8.00000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(1.52685000000000))*(px)*(pz)*(r00)*(r02)))+(((IkReal(-16.0000000000000))*(px)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(0.138050000000000))*((cj0)*(cj0))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(-0.600000000000000))*(pp)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-8.00000000000000))*((py)*(py)*(py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(1.20000000000000))*(px)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(8.00000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(-8.00000000000000))*((px)*(px))*((py)*(py))*((r00)*(r00))*((sj0)*(sj0))))+(((IkReal(1.20000000000000))*(cj0)*(px)*((py)*(py))*((r01)*(r01))))+(((IkReal(2.29185000000000))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.600000000000000))*(pp)*(px)*(r00)*(r01)*(sj0)))+(((IkReal(-1.35315000000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(-32.0000000000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))*((py)*(py))))+(((IkReal(-0.0129437163281250))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(1.20000000000000))*(py)*(sj0)*((pz)*(pz))*((r01)*(r01))))+(((IkReal(1.20000000000000))*(py)*(sj0)*((px)*(px))*((r00)*(r00))))+(((IkReal(8.00000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(-0.600000000000000))*(cj0)*(pp)*(px)*((r00)*(r00))))+(((IkReal(-1.62925000000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(-8.00000000000000))*((py)*(py))*((pz)*(pz))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(0.138050000000000))*((pz)*(pz))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(cj0)*(px)*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(8.00000000000000))*(pp)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(-16.0000000000000))*(py)*(r00)*(r01)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(-1.35315000000000))*(cj0)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(8.00000000000000))*(cj0)*(pp)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(0.600000000000000))*(cj0)*(pp)*(px)*((r02)*(r02))))+(((IkReal(8.00000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(0.00768000000000000))*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-1.35315000000000))*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(-8.00000000000000))*((cj0)*(cj0))*((px)*(px))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(1.20000000000000))*(cj0)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(-1.20000000000000))*(cj0)*(pp)*(pz)*(r00)*(r02)))+(((IkReal(0.138050000000000))*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(8.00000000000000))*(pp)*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(-8.00000000000000))*((pz)*(pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.600000000000000))*(cj0)*(pp)*(py)*(r00)*(r01)))+(((IkReal(1.20000000000000))*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(2.40000000000000))*(px)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-0.0258874326562500))*(cj0)*(r00)*(r01)*(sj0)))+(((IkReal(8.00000000000000))*(pp)*(py)*(pz)*(r01)*(r02)))+(((IkReal(1.20000000000000))*(cj0)*(px)*(py)*(pz)*(r01)*(r02))));
op[3]=((((IkReal(0.360000000000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(4.80000000000000))*(py)*(sj0)*((px)*(px))*((r00)*(r00))))+(((IkReal(-0.360000000000000))*(py)*(pz)*(r01)*(r02)))+(((IkReal(0.000945000000000000))*(cj0)*(px)*((r00)*(r00))))+(((IkReal(-4.80000000000000))*(pp)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(0.108000000000000))*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-1.44000000000000))*(px)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(0.0307200000000000))*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(2.40000000000000))*(pp)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-2.40000000000000))*(cj0)*(pp)*(px)*((r00)*(r00))))+(((IkReal(-0.360000000000000))*((pz)*(pz))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.180000000000000))*(pp)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(4.80000000000000))*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(9.60000000000000))*(px)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-0.360000000000000))*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(4.80000000000000))*(cj0)*(pz)*(r00)*(r02)*((px)*(px))))+(((IkReal(0.360000000000000))*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-0.360000000000000))*((cj0)*(cj0))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(-0.108000000000000))*(cj0)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(0.360000000000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(-0.180000000000000))*(pp)*((r02)*(r02))))+(((IkReal(0.108000000000000))*(px)*(r00)*(r02)))+(((IkReal(-0.720000000000000))*(px)*(py)*(r00)*(r01)))+(((IkReal(0.216000000000000))*(cj0)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(-0.360000000000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(-1.44000000000000))*(px)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(-1.44000000000000))*(cj0)*(px)*(pz)*((r00)*(r00))))+(((IkReal(0.108000000000000))*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.00390825000000000))*(cj0)*(r00)*(r01)*(sj0)))+(((IkReal(4.80000000000000))*(px)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(-0.108000000000000))*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(1.44000000000000))*(pp)*(r01)*(r02)*(sj0)))+(((IkReal(-0.360000000000000))*((py)*(py))*((r01)*(r01))))+(((IkReal(-0.360000000000000))*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(-2.40000000000000))*(pp)*(px)*(r00)*(r01)*(sj0)))+(((IkReal(0.000945000000000000))*(cj0)*(py)*(r00)*(r01)))+(((IkReal(-0.360000000000000))*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(4.80000000000000))*(cj0)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(0.000945000000000000))*(px)*(r00)*(r01)*(sj0)))+(((IkReal(-0.720000000000000))*(cj0)*(px)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(1.44000000000000))*(cj0)*(pp)*(r00)*(r02)))+(((IkReal(-0.360000000000000))*(cj0)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-4.80000000000000))*(cj0)*(pp)*(pz)*(r00)*(r02)))+(((IkReal(-1.44000000000000))*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(4.80000000000000))*(cj0)*(px)*((py)*(py))*((r01)*(r01))))+(((IkReal(0.00195412500000000))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(4.80000000000000))*(py)*(sj0)*((pz)*(pz))*((r01)*(r01))))+(((IkReal(-1.44000000000000))*(cj0)*(r00)*(r02)*((px)*(px))))+(((IkReal(-0.360000000000000))*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(-1.44000000000000))*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(4.80000000000000))*(r01)*(r02)*(sj0)*((pz)*(pz)*(pz))))+(((IkReal(-0.00921600000000000))*(cj0)*(r00)*(r02)))+(((IkReal(-1.44000000000000))*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(0.0307200000000000))*(cj0)*(pz)*(r00)*(r02)))+(((IkReal(-0.108000000000000))*(px)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(-0.360000000000000))*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(4.80000000000000))*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(4.80000000000000))*(cj0)*(px)*((pz)*(pz))*((r00)*(r00))))+(((IkReal(0.360000000000000))*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(9.60000000000000))*(cj0)*(py)*(r00)*(r01)*((px)*(px))))+(((IkReal(-0.360000000000000))*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(4.80000000000000))*(cj0)*(px)*(py)*(pz)*(r01)*(r02)))+(((IkReal(-2.40000000000000))*(pp)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(0.108000000000000))*(py)*(r01)*(r02)))+(((IkReal(-1.44000000000000))*(cj0)*(py)*(pz)*(r00)*(r01)))+(((IkReal(-0.0297750000000000))*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-1.44000000000000))*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(0.00195412500000000))*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-0.360000000000000))*(cj0)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-1.44000000000000))*(cj0)*(px)*(pz)*((r02)*(r02))))+(((IkReal(-0.360000000000000))*((px)*(px))*((r00)*(r00))))+(((IkReal(2.40000000000000))*(cj0)*(pp)*(px)*((r02)*(r02))))+(((IkReal(4.80000000000000))*(cj0)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(-0.108000000000000))*(cj0)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(4.80000000000000))*(cj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-0.0297750000000000))*(cj0)*(px)*((r02)*(r02))))+(((IkReal(-2.40000000000000))*(cj0)*(pp)*(py)*(r00)*(r01)))+(((IkReal(-0.720000000000000))*(cj0)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(-0.360000000000000))*(cj0)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(0.00425812500000000))*((r02)*(r02))))+(((IkReal(-0.00921600000000000))*(r01)*(r02)*(sj0)))+(((IkReal(0.360000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)))+(((IkReal(-0.360000000000000))*(px)*(pz)*(r00)*(r02)))+(((IkReal(0.000945000000000000))*(py)*(sj0)*((r01)*(r01))))+(((IkReal(0.108000000000000))*(pz)*((r02)*(r02))))+(((IkReal(4.80000000000000))*(px)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(-1.44000000000000))*(cj0)*(r00)*(r02)*((pz)*(pz))))+(((IkReal(-1.44000000000000))*(cj0)*(px)*(py)*(r01)*(r02)))+(((IkReal(0.180000000000000))*(pp)*((cj0)*(cj0))*((r00)*(r00)))));
op[4]=((((IkReal(-0.00325687500000000))*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-0.676575000000000))*(px)*(pz)*(r00)*(r02)))+(((IkReal(-4.00000000000000))*((cj0)*(cj0))*((px)*(px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-8.00000000000000))*(pz)*(r00)*(r02)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(-1.20000000000000))*(pp)*(py)*(r01)*(r02)))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(0.763425000000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(2.40000000000000))*(px)*(r00)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.0130275000000000))*(pz)*((r02)*(r02))))+(((IkReal(-0.0567750000000000))*(cj0)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(0.763425000000000))*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-2.40000000000000))*(px)*(py)*(pz)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(4.80000000000000))*(cj0)*(px)*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(0.600000000000000))*(cj0)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(-1.00000000000000))*((pp)*(pp))*((r02)*(r02))))+(((IkReal(0.138050000000000))*(cj0)*(px)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-2.40000000000000))*(pz)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-0.381712500000000))*(pp)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-8.00000000000000))*(px)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(-8.00000000000000))*(py)*(r00)*(r01)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(4.00000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(4.00000000000000))*(pp)*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(-1.20000000000000))*(pp)*(px)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(-0.00709687500000000))*(cj0)*(px)*((r02)*(r02))))+(((IkReal(-0.180000000000000))*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(-0.382500000000000))*((py)*(py))*((r01)*(r01))))+(((IkReal(-0.180000000000000))*(px)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(-2.40000000000000))*(py)*(r01)*(r02)*((pz)*(pz))*((sj0)*(sj0))))+(((IkReal(-8.00000000000000))*(py)*(r01)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(-0.600000000000000))*(pp)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(4.80000000000000))*(py)*(r01)*(r02)*((pz)*(pz))))+(((IkReal(4.00000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-0.180000000000000))*(px)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(0.600000000000000))*(r01)*(r02)*(sj0)*((pz)*(pz)*(pz))))+(((IkReal(2.40000000000000))*(r00)*(r02)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(4.00000000000000))*(pp)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(0.763425000000000))*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(-0.180000000000000))*(cj0)*(r00)*(r02)*((px)*(px))))+(((IkReal(-4.00000000000000))*((py)*(py)*(py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(2.61418359375000e-5))*((r02)*(r02))))+(((IkReal(4.80000000000000))*(cj0)*(px)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(0.600000000000000))*(px)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(0.600000000000000))*(cj0)*(pz)*(r00)*(r02)*((px)*(px))))+(((IkReal(-2.40000000000000))*(px)*(r00)*(r02)*((cj0)*(cj0))*((pz)*(pz))))+(((IkReal(0.625375000000000))*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-1.20000000000000))*(pp)*(pz)*((r02)*(r02))))+(((IkReal(-0.00325687500000000))*(cj0)*(py)*(r00)*(r01)))+(((IkReal(0.0690250000000000))*((cj0)*(cj0))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(4.00000000000000))*(pp)*(px)*(pz)*(r00)*(r02)))+(((IkReal(4.00000000000000))*(pp)*(py)*(pz)*(r01)*(r02)))+(((IkReal(-1.00000000000000))*((cj0)*(cj0))*((pp)*(pp))*((r00)*(r00))))+(((IkReal(2.40000000000000))*(pz)*((py)*(py))*((r01)*(r01))))+(((IkReal(-0.765000000000000))*(px)*(py)*(r00)*(r01)))+(((IkReal(-0.00709687500000000))*(py)*(sj0)*((r02)*(r02))))+(((IkReal(0.600000000000000))*(cj0)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(2.40000000000000))*((pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(4.00000000000000))*(pp)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(-4.00000000000000))*((px)*(px))*((py)*(py))*((r00)*(r00))*((sj0)*(sj0))))+(((IkReal(-0.180000000000000))*(cj0)*(px)*(pz)*((r00)*(r00))))+(((IkReal(-0.00115200000000000))*(cj0)*(r00)*(r02)))+(((IkReal(1.20000000000000))*(pp)*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-0.763425000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)))+(((IkReal(0.0283875000000000))*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-4.00000000000000))*((cj0)*(cj0))*((px)*(px))*((py)*(py))*((r01)*(r01))))+(((IkReal(-0.0283875000000000))*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))*((py)*(py))))+(((IkReal(0.600000000000000))*(cj0)*(px)*(py)*(pz)*(r01)*(r02)))+(((IkReal(4.80000000000000))*(px)*(r00)*(r02)*((pz)*(pz))))+(((IkReal(4.00000000000000))*(pp)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-0.0130275000000000))*(px)*(r00)*(r02)))+(((IkReal(0.00384000000000000))*(cj0)*(pz)*(r00)*(r02)))+(((IkReal(-0.600000000000000))*(cj0)*(pp)*(pz)*(r00)*(r02)))+(((IkReal(-0.180000000000000))*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(-16.0000000000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)*((px)*(px))))+(((IkReal(-2.40000000000000))*(cj0)*(py)*(r00)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(-4.00000000000000))*((px)*(px))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(0.600000000000000))*(py)*(sj0)*((px)*(px))*((r00)*(r00))))+(((IkReal(-0.00325687500000000))*(px)*(r00)*(r01)*(sj0)))+(((IkReal(-8.00000000000000))*(py)*(pz)*(r01)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-0.00325687500000000))*(cj0)*(px)*((r00)*(r00))))+(((IkReal(-1.20000000000000))*(cj0)*(pp)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(-2.40000000000000))*(px)*(py)*(pz)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(0.0690250000000000))*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(0.00218614183593750))*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-0.180000000000000))*(cj0)*(r00)*(r02)*((pz)*(pz))))+(((IkReal(0.00437228367187500))*(cj0)*(r00)*(r01)*(sj0)))+(((IkReal(0.600000000000000))*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(4.00000000000000))*(pp)*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-8.00000000000000))*(pz)*(r01)*(r02)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(0.600000000000000))*(px)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(0.300000000000000))*(pp)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-2.40000000000000))*(cj0)*(px)*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(2.40000000000000))*(py)*(r01)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(0.00218614183593750))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-8.00000000000000))*(px)*(r00)*(r01)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(0.600000000000000))*(cj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(4.80000000000000))*(cj0)*(py)*(r00)*(r02)*(sj0)*((px)*(px))))+(((IkReal(0.763425000000000))*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(0.138050000000000))*(cj0)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-8.00000000000000))*(cj0)*(py)*(sj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-0.381712500000000))*(pp)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-0.180000000000000))*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-2.40000000000000))*(cj0)*(px)*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(-4.00000000000000))*((py)*(py))*((pz)*(pz))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(1.20000000000000))*(cj0)*(py)*(r00)*(r01)*((px)*(px))))+(((IkReal(-2.40000000000000))*(cj0)*(px)*(py)*(pz)*(sj0)*((r00)*(r00))))+(((IkReal(0.763425000000000))*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(-2.40000000000000))*(cj0)*(pz)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(0.180000000000000))*(cj0)*(pp)*(r00)*(r02)))+(((IkReal(0.0283875000000000))*(cj0)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(-0.294075000000000))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-8.00000000000000))*(px)*(pz)*(r00)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-1.20000000000000))*(cj0)*(pp)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(-4.00000000000000))*((py)*(py))*((pz)*(pz))*((r01)*(r01))))+(((IkReal(0.00384000000000000))*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-2.00000000000000))*(cj0)*(r00)*(r01)*(sj0)*((pp)*(pp))))+(((IkReal(0.600000000000000))*(cj0)*(px)*((py)*(py))*((r01)*(r01))))+(((IkReal(-4.00000000000000))*((pz)*(pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.0130275000000000))*(py)*(r01)*(r02)))+(((IkReal(0.625375000000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-0.382500000000000))*((px)*(px))*((r00)*(r00))))+(((IkReal(2.40000000000000))*(pz)*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(0.0283875000000000))*(cj0)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(0.763425000000000))*(cj0)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(-0.300000000000000))*(cj0)*(pp)*(px)*((r00)*(r00))))+(((IkReal(0.763425000000000))*(cj0)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(2.40000000000000))*(r01)*(r02)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(2.40000000000000))*(pz)*((px)*(px))*((r00)*(r00))))+(((IkReal(-0.180000000000000))*(cj0)*(py)*(pz)*(r00)*(r01)))+(((IkReal(0.0690250000000000))*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(-0.180000000000000))*(cj0)*(px)*(py)*(r01)*(r02)))+(((IkReal(-0.300000000000000))*(pp)*(px)*(r00)*(r01)*(sj0)))+(((IkReal(-8.00000000000000))*(px)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(-4.00000000000000))*((cj0)*(cj0))*((px)*(px))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.0442125000000000))*(pp)*((r02)*(r02))))+(((IkReal(-1.20000000000000))*(pp)*(px)*(r00)*(r02)))+(((IkReal(2.40000000000000))*(cj0)*(pp)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(-1.20000000000000))*(pp)*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-0.300000000000000))*(pp)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(0.600000000000000))*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-8.00000000000000))*(cj0)*(px)*(py)*(sj0)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(1.20000000000000))*(pp)*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-0.0283875000000000))*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(1.20000000000000))*(px)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(0.0690250000000000))*((pz)*(pz))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.180000000000000))*(pp)*(r01)*(r02)*(sj0)))+(((IkReal(0.625375000000000))*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(-0.180000000000000))*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(0.625375000000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(-0.676575000000000))*(py)*(pz)*(r01)*(r02)))+(((IkReal(0.0283875000000000))*(px)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(0.763425000000000))*(cj0)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-1.00000000000000))*((pp)*(pp))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-2.40000000000000))*(cj0)*(pz)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(-0.300000000000000))*(cj0)*(pp)*(py)*(r00)*(r01)))+(((IkReal(-8.00000000000000))*(cj0)*(px)*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(-16.0000000000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(0.300000000000000))*(cj0)*(pp)*(px)*((r02)*(r02))))+(((IkReal(0.600000000000000))*(py)*(sj0)*((pz)*(pz))*((r01)*(r01))))+(((IkReal(-0.180000000000000))*(cj0)*(px)*(pz)*((r02)*(r02))))+(((IkReal(0.600000000000000))*(cj0)*(px)*((pz)*(pz))*((r00)*(r00))))+(((IkReal(-2.40000000000000))*(pz)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(4.80000000000000))*(px)*(py)*(pz)*(r00)*(r01)))+(((IkReal(-0.00115200000000000))*(r01)*(r02)*(sj0)))+(((IkReal(2.40000000000000))*(pz)*((cj0)*(cj0))*((px)*(px))*((r02)*(r02)))));
polyroots4(op,zeror,numroots);
IkReal j1array[4], cj1array[4], sj1array[4], tempj1array[1];
int numsolutions = 0;
for(int ij1 = 0; ij1 < numroots; ++ij1)
{
IkReal htj1 = zeror[ij1];
tempj1array[0]=((IkReal(2.00000000000000))*(atan(htj1)));
for(int kj1 = 0; kj1 < 1; ++kj1)
{
j1array[numsolutions] = tempj1array[kj1];
if( j1array[numsolutions] > IKPI )
{
    j1array[numsolutions]-=IK2PI;
}
else if( j1array[numsolutions] < -IKPI )
{
    j1array[numsolutions]+=IK2PI;
}
sj1array[numsolutions] = IKsin(j1array[numsolutions]);
cj1array[numsolutions] = IKcos(j1array[numsolutions]);
numsolutions++;
}
}
bool j1valid[4]={true,true,true,true};
_nj1 = 4;
for(int ij1 = 0; ij1 < numsolutions; ++ij1)
    {
if( !j1valid[ij1] )
{
    continue;
}
    j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
htj1 = IKtan(j1/2);

_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < numsolutions; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
{
IkReal j4array[2], cj4array[2], sj4array[2];
bool j4valid[2]={false};
_nj4 = 2;
sj4array[0]=((((IkReal(-1.00000000000000))*(r00)*(sj0)))+(((cj0)*(r01))));
if( sj4array[0] >= -1-IKFAST_SINCOS_THRESH && sj4array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j4valid[0] = j4valid[1] = true;
    j4array[0] = IKasin(sj4array[0]);
    cj4array[0] = IKcos(j4array[0]);
    sj4array[1] = sj4array[0];
    j4array[1] = j4array[0] > 0 ? (IKPI-j4array[0]) : (-IKPI-j4array[0]);
    cj4array[1] = -cj4array[0];
}
else if( isnan(sj4array[0]) )
{
    // probably any value will work
    j4valid[0] = true;
    cj4array[0] = 1; sj4array[0] = 0; j4array[0] = 0;
}
for(int ij4 = 0; ij4 < 2; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 2; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];

{
IkReal dummyeval[1];
IkReal gconst0;
gconst0=IKsign(cj4);
dummyeval[0]=cj4;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst1;
gconst1=IKsign(cj4);
dummyeval[0]=cj4;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[9];
IkReal x30=(py)*(py);
IkReal x31=(px)*(px);
IkReal x32=(pz)*(pz);
IkReal x33=((r02)*(sj1));
IkReal x34=((cj1)*(pz));
IkReal x35=((IkReal(0.150000000000000))*(r00));
IkReal x36=((IkReal(0.600000000000000))*(r02));
IkReal x37=((cj0)*(px));
IkReal x38=((r01)*(sj0));
IkReal x39=((IkReal(1.00000000000000))*(cj1));
IkReal x40=((py)*(sj0));
IkReal x41=((py)*(r01));
IkReal x42=((IkReal(0.150000000000000))*(sj1));
IkReal x43=((IkReal(1.00000000000000))*(pz));
IkReal x44=((px)*(sj1));
IkReal x45=((IkReal(0.600000000000000))*(r00));
IkReal x46=((cj0)*(r00));
IkReal x47=((IkReal(0.0843750000000000))*(cj1));
IkReal x48=((IkReal(2.00000000000000))*(pz));
IkReal x49=((cj1)*(px));
IkReal x50=((IkReal(1.00000000000000))*(px));
IkReal x51=((IkReal(0.300000000000000))*(cj1));
IkReal x52=((IkReal(0.0956250000000000))*(sj1));
IkReal x53=((IkReal(1.00000000000000))*(sj1));
IkReal x54=((cj0)*(pz));
IkReal x55=((IkReal(0.150000000000000))*(cj1));
IkReal x56=((IkReal(2.00000000000000))*(sj1));
IkReal x57=((IkReal(2.00000000000000))*(cj1));
IkReal x58=((IkReal(2.00000000000000))*(r00));
IkReal x59=((IkReal(0.300000000000000))*(sj1));
IkReal x60=((r02)*(x40));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j4)), IkReal(6.28318530717959))));
evalcond[1]=((((cj0)*(py)))+(((IkReal(-1.00000000000000))*(sj0)*(x50))));
evalcond[2]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(r00)*(sj0)))+(((cj0)*(r01))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x38)*(x39)))+(x33)+(((IkReal(-1.00000000000000))*(x39)*(x46))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r02)*(x39)))+(((IkReal(-1.00000000000000))*(x38)*(x53)))+(((IkReal(-1.00000000000000))*(x46)*(x53))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r02)*(x43)))+(((r02)*(x51)))+(((IkReal(0.0750000000000000))*(x38)))+(((IkReal(-1.00000000000000))*(r00)*(x50)))+(((IkReal(-1.00000000000000))*(x41)))+(((x46)*(x59)))+(((x38)*(x59)))+(((IkReal(0.0750000000000000))*(x46))));
evalcond[6]=((((x46)*(x51)))+(x60)+(((IkReal(-0.300000000000000))*(x33)))+(((IkReal(-1.00000000000000))*(x43)*(x46)))+(((x38)*(x51)))+(((IkReal(-1.00000000000000))*(x38)*(x43)))+(((r02)*(x37)))+(((IkReal(-0.0750000000000000))*(r02))));
evalcond[7]=((((x40)*(x44)*(x58)))+(((IkReal(-1.00000000000000))*(pp)*(r02)*(x39)))+(((IkReal(-0.150000000000000))*(pz)*(x33)))+(((x33)*(x37)*(x48)))+(((IkReal(-1.00000000000000))*(px)*(x45)))+(((IkReal(-1.00000000000000))*(pz)*(x36)))+(((IkReal(-1.00000000000000))*(x41)*(x42)))+(((x31)*(x46)*(x56)))+(((x37)*(x41)*(x56)))+(((px)*(x34)*(x58)))+(((x30)*(x38)*(x56)))+(((x38)*(x52)))+(((x55)*(x60)))+(((x46)*(x52)))+(((r02)*(x32)*(x57)))+(((r02)*(x37)*(x55)))+(((IkReal(-1.00000000000000))*(pp)*(x46)*(x53)))+(((IkReal(0.0450000000000000))*(x38)))+(((IkReal(2.00000000000000))*(x34)*(x41)))+(((IkReal(-1.00000000000000))*(pp)*(x38)*(x53)))+(((IkReal(-1.00000000000000))*(x35)*(x44)))+(((x33)*(x40)*(x48)))+(((IkReal(-0.600000000000000))*(x41)))+(((r02)*(x47)))+(((IkReal(-0.150000000000000))*(x34)*(x38)))+(((IkReal(-1.00000000000000))*(cj0)*(x34)*(x35)))+(((IkReal(0.0450000000000000))*(x46))));
evalcond[8]=((((IkReal(-0.150000000000000))*(r02)*(x34)))+(((IkReal(-1.00000000000000))*(pp)*(x38)*(x39)))+(((IkReal(2.00000000000000))*(r02)*(x34)*(x37)))+(((IkReal(0.0450000000000000))*(r02)))+(((IkReal(-1.00000000000000))*(x35)*(x49)))+(((pp)*(x33)))+(((x31)*(x46)*(x57)))+(((x45)*(x54)))+(((IkReal(-0.150000000000000))*(x33)*(x37)))+(((IkReal(-0.150000000000000))*(x33)*(x40)))+(((IkReal(2.00000000000000))*(x34)*(x60)))+(((x30)*(x38)*(x57)))+(((IkReal(0.600000000000000))*(pz)*(x38)))+(((IkReal(-1.00000000000000))*(x36)*(x37)))+(((x40)*(x49)*(x58)))+(((IkReal(-1.00000000000000))*(sj1)*(x41)*(x48)))+(((IkReal(-2.00000000000000))*(x32)*(x33)))+(((IkReal(-1.00000000000000))*(x38)*(x47)))+(((IkReal(0.0956250000000000))*(x33)))+(((x37)*(x41)*(x57)))+(((sj1)*(x35)*(x54)))+(((IkReal(-1.00000000000000))*(x41)*(x55)))+(((IkReal(-1.00000000000000))*(r00)*(x44)*(x48)))+(((IkReal(-1.00000000000000))*(pp)*(x39)*(x46)))+(((IkReal(-1.00000000000000))*(x36)*(x40)))+(((pz)*(x38)*(x42)))+(((IkReal(-1.00000000000000))*(x46)*(x47))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[2], cj3array[2], sj3array[2];
bool j3valid[2]={false};
_nj3 = 2;
IkReal x61=((IkReal(11.1614434376257))*(sj1));
IkReal x62=((py)*(sj0));
IkReal x63=((cj0)*(px));
if( (((IkReal(0.440063160535554))+(((IkReal(-0.837108257821925))*(sj1)))+(((x61)*(x62)))+(((IkReal(11.1614434376257))*(cj1)*(pz)))+(((IkReal(-18.6024057293761))*(pp)))+(((IkReal(2.79036085940642))*(x62)))+(((IkReal(2.79036085940642))*(x63)))+(((x61)*(x63))))) < -1-IKFAST_SINCOS_THRESH || (((IkReal(0.440063160535554))+(((IkReal(-0.837108257821925))*(sj1)))+(((x61)*(x62)))+(((IkReal(11.1614434376257))*(cj1)*(pz)))+(((IkReal(-18.6024057293761))*(pp)))+(((IkReal(2.79036085940642))*(x62)))+(((IkReal(2.79036085940642))*(x63)))+(((x61)*(x63))))) > 1+IKFAST_SINCOS_THRESH )
    continue;
IkReal x64=IKasin(((IkReal(0.440063160535554))+(((IkReal(-0.837108257821925))*(sj1)))+(((x61)*(x62)))+(((IkReal(11.1614434376257))*(cj1)*(pz)))+(((IkReal(-18.6024057293761))*(pp)))+(((IkReal(2.79036085940642))*(x62)))+(((IkReal(2.79036085940642))*(x63)))+(((x61)*(x63)))));
j3array[0]=((IkReal(-1.34567065063197))+(((IkReal(-1.00000000000000))*(x64))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
j3array[1]=((IkReal(1.79592200295782))+(x64));
sj3array[1]=IKsin(j3array[1]);
cj3array[1]=IKcos(j3array[1]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
if( j3array[1] > IKPI )
{
    j3array[1]-=IK2PI;
}
else if( j3array[1] < -IKPI )
{    j3array[1]+=IK2PI;
}
j3valid[1] = true;
for(int ij3 = 0; ij3 < 2; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 2; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[1];
IkReal x65=((IkReal(2.00000000000000))*(sj0));
IkReal x66=((px)*(py));
IkReal x67=((r00)*(sj0));
IkReal x68=((cj0)*(r01));
IkReal x69=((py)*(r00));
IkReal x70=((IkReal(2.00000000000000))*(cj0));
IkReal x71=((px)*(r01));
IkReal x72=((IkReal(0.600000000000000))*(cj1));
IkReal x73=((py)*(r02));
IkReal x74=((IkReal(0.600000000000000))*(sj1));
IkReal x75=((IkReal(0.0450000000000000))*(sj1));
IkReal x76=((px)*(r02));
evalcond[0]=((IkReal(-0.119281250000000))+(((IkReal(-1.00000000000000))*(x67)*(x75)))+(((r01)*(x65)*(x66)))+(((IkReal(-0.0956250000000000))*(x67)))+(((x69)*(x74)))+(((cj0)*(x72)*(x73)))+(((IkReal(-1.00000000000000))*(pz)*(x68)*(x72)))+(((pp)*(x68)))+(((IkReal(-1.00000000000000))*(pp)*(x67)))+(((IkReal(0.0956250000000000))*(x68)))+(((IkReal(-2.00000000000000))*(x68)*((py)*(py))))+(((IkReal(-0.150000000000000))*(x71)))+(((IkReal(-1.00000000000000))*(r00)*(x66)*(x70)))+(((IkReal(-0.0120000000000000))*(IKsin(j3))))+(((IkReal(-1.00000000000000))*(x71)*(x74)))+(((IkReal(-1.00000000000000))*(sj0)*(x72)*(x76)))+(((pz)*(x67)*(x72)))+(((pz)*(x65)*(x76)))+(((IkReal(-0.0524000000000000))*(IKcos(j3))))+(((IkReal(-1.00000000000000))*(pz)*(x70)*(x73)))+(((IkReal(0.150000000000000))*(x69)))+(((r00)*(x65)*((px)*(px))))+(((x68)*(x75))));
if( IKabs(evalcond[0]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst8;
gconst8=IKsign(((IkReal(0.112881250000000))+(((IkReal(0.0524000000000000))*(cj3)))+(((IkReal(0.00640000000000000))*((sj3)*(sj3))))+(((IkReal(0.00640000000000000))*((cj3)*(cj3))))+(((IkReal(0.0120000000000000))*(sj3)))));
dummyeval[0]=((IkReal(17.6376953125000))+(((IkReal(8.18750000000000))*(cj3)))+((cj3)*(cj3))+(((IkReal(1.87500000000000))*(sj3)))+((sj3)*(sj3)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst9;
gconst9=IKsign(((IkReal(0.112881250000000))+(((IkReal(0.0524000000000000))*(cj3)))+(((IkReal(0.00640000000000000))*((sj3)*(sj3))))+(((IkReal(0.00640000000000000))*((cj3)*(cj3))))+(((IkReal(0.0120000000000000))*(sj3)))));
dummyeval[0]=((IkReal(17.6376953125000))+(((IkReal(8.18750000000000))*(cj3)))+((cj3)*(cj3))+(((IkReal(1.87500000000000))*(sj3)))+((sj3)*(sj3)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x77=((pz)*(sj1));
IkReal x78=((cj0)*(r01));
IkReal x79=((IkReal(0.0800000000000000))*(sj3));
IkReal x80=((r00)*(sj0));
IkReal x81=((IkReal(0.00600000000000000))*(cj1));
IkReal x82=((IkReal(0.0750000000000000))*(cj1));
IkReal x83=((IkReal(0.0245625000000000))*(cj1));
IkReal x84=((px)*(r01));
IkReal x85=((IkReal(0.00562500000000000))*(cj1));
IkReal x86=((IkReal(0.0800000000000000))*(cj3));
IkReal x87=((px)*(sj1));
IkReal x88=((cj1)*(pz));
IkReal x89=((IkReal(0.0750000000000000))*(sj0));
IkReal x90=((IkReal(0.327500000000000))*(cj0));
IkReal x91=((py)*(sj1));
IkReal x92=((cj0)*(r02));
IkReal x93=((IkReal(0.00600000000000000))*(sj1));
IkReal x94=((IkReal(0.327500000000000))*(sj0));
IkReal x95=((cj1)*(py)*(r00));
IkReal x96=((IkReal(0.0800000000000000))*(r02)*(sj0)*(x87));
if( IKabs(((gconst9)*(((IkReal(-0.0982500000000000))+(((x79)*(x95)))+(((py)*(r00)*(x82)))+(((r02)*(x87)*(x89)))+(((IkReal(-1.00000000000000))*(x80)*(x85)))+(((IkReal(0.0750000000000000))*(x77)*(x78)))+(((cj0)*(x86)*(x87)))+(((IkReal(-0.0245625000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(cj1)*(x79)*(x84)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((IkReal(-1.00000000000000))*(x79)*(x91)*(x92)))+(((IkReal(-1.00000000000000))*(x77)*(x79)*(x80)))+(((IkReal(-1.00000000000000))*(x82)*(x84)))+(((IkReal(0.327500000000000))*(x88)))+(((IkReal(-0.0750000000000000))*(x91)*(x92)))+(((IkReal(-1.00000000000000))*(sj3)*(x80)*(x81)))+(((r02)*(sj0)*(x79)*(x87)))+(((IkReal(-1.00000000000000))*(cj3)*(x93)))+(((x78)*(x85)))+(((sj3)*(x78)*(x81)))+(((x77)*(x78)*(x79)))+(((x86)*(x88)))+(((x87)*(x90)))+(((x91)*(x94)))+(((sj0)*(x86)*(x91)))+(((IkReal(-0.0750000000000000))*(x77)*(x80))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst9)*(((IkReal(-0.0225000000000000))+(((IkReal(-0.0240000000000000))*(sj3)))+(((IkReal(0.327500000000000))*(cj1)*(x84)))+(((IkReal(0.0750000000000000))*(cj0)*(x87)))+(((IkReal(-1.00000000000000))*(sj3)*(x93)))+(((x89)*(x91)))+(((IkReal(-0.327500000000000))*(x95)))+(((IkReal(-1.00000000000000))*(x77)*(x78)*(x86)))+(((x77)*(x80)*(x86)))+(((cj1)*(x84)*(x86)))+(((IkReal(-1.00000000000000))*(r02)*(x87)*(x94)))+(((cj0)*(x79)*(x87)))+(((x80)*(x83)))+(((pz)*(x82)))+(((r02)*(x90)*(x91)))+(((x86)*(x91)*(x92)))+(((x79)*(x88)))+(((cj3)*(x80)*(x81)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x86)*(x87)))+(((IkReal(0.327500000000000))*(x77)*(x80)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((sj0)*(x79)*(x91)))+(((IkReal(-1.00000000000000))*(x78)*(x83)))+(((IkReal(-1.00000000000000))*(x86)*(x95)))+(((IkReal(-0.327500000000000))*(x77)*(x78)))+(((IkReal(-1.00000000000000))*(cj3)*(x78)*(x81))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst9)*(((IkReal(-0.0982500000000000))+(((x79)*(x95)))+(((py)*(r00)*(x82)))+(((r02)*(x87)*(x89)))+(((IkReal(-1.00000000000000))*(x80)*(x85)))+(((IkReal(0.0750000000000000))*(x77)*(x78)))+(((cj0)*(x86)*(x87)))+(((IkReal(-0.0245625000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(cj1)*(x79)*(x84)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((IkReal(-1.00000000000000))*(x79)*(x91)*(x92)))+(((IkReal(-1.00000000000000))*(x77)*(x79)*(x80)))+(((IkReal(-1.00000000000000))*(x82)*(x84)))+(((IkReal(0.327500000000000))*(x88)))+(((IkReal(-0.0750000000000000))*(x91)*(x92)))+(((IkReal(-1.00000000000000))*(sj3)*(x80)*(x81)))+(((r02)*(sj0)*(x79)*(x87)))+(((IkReal(-1.00000000000000))*(cj3)*(x93)))+(((x78)*(x85)))+(((sj3)*(x78)*(x81)))+(((x77)*(x78)*(x79)))+(((x86)*(x88)))+(((x87)*(x90)))+(((x91)*(x94)))+(((sj0)*(x86)*(x91)))+(((IkReal(-0.0750000000000000))*(x77)*(x80)))))), ((gconst9)*(((IkReal(-0.0225000000000000))+(((IkReal(-0.0240000000000000))*(sj3)))+(((IkReal(0.327500000000000))*(cj1)*(x84)))+(((IkReal(0.0750000000000000))*(cj0)*(x87)))+(((IkReal(-1.00000000000000))*(sj3)*(x93)))+(((x89)*(x91)))+(((IkReal(-0.327500000000000))*(x95)))+(((IkReal(-1.00000000000000))*(x77)*(x78)*(x86)))+(((x77)*(x80)*(x86)))+(((cj1)*(x84)*(x86)))+(((IkReal(-1.00000000000000))*(r02)*(x87)*(x94)))+(((cj0)*(x79)*(x87)))+(((x80)*(x83)))+(((pz)*(x82)))+(((r02)*(x90)*(x91)))+(((x86)*(x91)*(x92)))+(((x79)*(x88)))+(((cj3)*(x80)*(x81)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x86)*(x87)))+(((IkReal(0.327500000000000))*(x77)*(x80)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((sj0)*(x79)*(x91)))+(((IkReal(-1.00000000000000))*(x78)*(x83)))+(((IkReal(-1.00000000000000))*(x86)*(x95)))+(((IkReal(-0.327500000000000))*(x77)*(x78)))+(((IkReal(-1.00000000000000))*(cj3)*(x78)*(x81)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x97=IKcos(j2);
IkReal x98=IKsin(j2);
IkReal x99=((IkReal(0.0800000000000000))*(sj3));
IkReal x100=((cj0)*(r01));
IkReal x101=((IkReal(1.00000000000000))*(px));
IkReal x102=((py)*(sj1));
IkReal x103=((cj0)*(r02));
IkReal x104=((IkReal(0.0750000000000000))*(cj1));
IkReal x105=((r02)*(sj0));
IkReal x106=((IkReal(0.0750000000000000))*(sj1));
IkReal x107=((cj1)*(pz));
IkReal x108=((r00)*(sj0));
IkReal x109=((IkReal(0.0800000000000000))*(cj3));
IkReal x110=((pz)*(sj1));
IkReal x111=((IkReal(1.00000000000000))*(sj0));
IkReal x112=((cj1)*(py));
IkReal x113=((IkReal(0.0750000000000000))*(x98));
IkReal x114=((IkReal(0.327500000000000))*(x97));
IkReal x115=((IkReal(0.0750000000000000))*(x97));
IkReal x116=((IkReal(0.327500000000000))*(x98));
IkReal x117=((sj1)*(x108));
IkReal x118=((x98)*(x99));
IkReal x119=((x109)*(x97));
IkReal x120=((x97)*(x99));
IkReal x121=((x109)*(x98));
IkReal x122=((x113)+(x118));
IkReal x123=((x114)+(x119));
IkReal x124=((x120)+(x121)+(x116)+(x115));
evalcond[0]=((((IkReal(-1.00000000000000))*(cj0)*(cj1)*(x101)))+(((IkReal(-1.00000000000000))*(x111)*(x112)))+(x123)+(((IkReal(-1.00000000000000))*(x122)))+(x104)+(x110));
evalcond[1]=((IkReal(0.300000000000000))+(x124)+(((IkReal(-1.00000000000000))*(cj0)*(sj1)*(x101)))+(x106)+(((IkReal(-1.00000000000000))*(x102)*(x111)))+(((IkReal(-1.00000000000000))*(x107))));
evalcond[2]=((((x108)*(x110)))+(((x102)*(x103)))+(((cj1)*(px)*(r01)))+(x122)+(((IkReal(-1.00000000000000))*(x100)*(x104)))+(((IkReal(-1.00000000000000))*(x100)*(x110)))+(((IkReal(-1.00000000000000))*(sj1)*(x101)*(x105)))+(((x104)*(x108)))+(((IkReal(-1.00000000000000))*(x123)))+(((IkReal(-1.00000000000000))*(r00)*(x112))));
evalcond[3]=((((IkReal(-0.300000000000000))*(x108)))+(((IkReal(-1.00000000000000))*(x106)*(x108)))+(((IkReal(-1.00000000000000))*(cj1)*(x101)*(x105)))+(((IkReal(-1.00000000000000))*(r01)*(sj1)*(x101)))+(((x100)*(x106)))+(((r00)*(x102)))+(((IkReal(0.300000000000000))*(x100)))+(((IkReal(-1.00000000000000))*(x100)*(x107)))+(x124)+(((x107)*(x108)))+(((x103)*(x112))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x125=((IkReal(0.0800000000000000))*(cj1));
IkReal x126=((cj0)*(px));
IkReal x127=((py)*(sj0));
IkReal x128=((IkReal(0.0750000000000000))*(cj1));
IkReal x129=((IkReal(0.327500000000000))*(cj1));
IkReal x130=((IkReal(0.327500000000000))*(sj1));
IkReal x131=((IkReal(0.0750000000000000))*(sj1));
IkReal x132=((IkReal(0.00600000000000000))*(sj1));
IkReal x133=((IkReal(0.00600000000000000))*(cj1));
IkReal x134=((IkReal(0.0800000000000000))*(sj1)*(sj3));
IkReal x135=((IkReal(0.0800000000000000))*(cj3)*(sj1));
if( IKabs(((gconst8)*(((IkReal(-0.0982500000000000))+(((x126)*(x130)))+(((IkReal(-1.00000000000000))*(cj3)*(x132)))+(((pz)*(x134)))+(((pz)*(x131)))+(((IkReal(-0.0245625000000000))*(sj1)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((sj3)*(x133)))+(((pz)*(x129)))+(((x127)*(x130)))+(((IkReal(-1.00000000000000))*(sj3)*(x125)*(x126)))+(((x126)*(x135)))+(((IkReal(-1.00000000000000))*(x126)*(x128)))+(((IkReal(0.00562500000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(x127)*(x128)))+(((x127)*(x135)))+(((IkReal(-1.00000000000000))*(sj3)*(x125)*(x127)))+(((cj3)*(pz)*(x125))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst8)*(((IkReal(-0.0225000000000000))+(((IkReal(-0.0240000000000000))*(sj3)))+(((IkReal(-1.00000000000000))*(sj3)*(x132)))+(((IkReal(-1.00000000000000))*(pz)*(x135)))+(((IkReal(-1.00000000000000))*(cj3)*(x133)))+(((x127)*(x134)))+(((x126)*(x129)))+(((x126)*(x134)))+(((pz)*(x128)))+(((x127)*(x131)))+(((x126)*(x131)))+(((IkReal(-0.0245625000000000))*(cj1)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((cj3)*(x125)*(x126)))+(((x127)*(x129)))+(((pz)*(sj3)*(x125)))+(((IkReal(-1.00000000000000))*(pz)*(x130)))+(((cj3)*(x125)*(x127))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst8)*(((IkReal(-0.0982500000000000))+(((x126)*(x130)))+(((IkReal(-1.00000000000000))*(cj3)*(x132)))+(((pz)*(x134)))+(((pz)*(x131)))+(((IkReal(-0.0245625000000000))*(sj1)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((sj3)*(x133)))+(((pz)*(x129)))+(((x127)*(x130)))+(((IkReal(-1.00000000000000))*(sj3)*(x125)*(x126)))+(((x126)*(x135)))+(((IkReal(-1.00000000000000))*(x126)*(x128)))+(((IkReal(0.00562500000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(x127)*(x128)))+(((x127)*(x135)))+(((IkReal(-1.00000000000000))*(sj3)*(x125)*(x127)))+(((cj3)*(pz)*(x125)))))), ((gconst8)*(((IkReal(-0.0225000000000000))+(((IkReal(-0.0240000000000000))*(sj3)))+(((IkReal(-1.00000000000000))*(sj3)*(x132)))+(((IkReal(-1.00000000000000))*(pz)*(x135)))+(((IkReal(-1.00000000000000))*(cj3)*(x133)))+(((x127)*(x134)))+(((x126)*(x129)))+(((x126)*(x134)))+(((pz)*(x128)))+(((x127)*(x131)))+(((x126)*(x131)))+(((IkReal(-0.0245625000000000))*(cj1)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((cj3)*(x125)*(x126)))+(((x127)*(x129)))+(((pz)*(sj3)*(x125)))+(((IkReal(-1.00000000000000))*(pz)*(x130)))+(((cj3)*(x125)*(x127)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x136=IKcos(j2);
IkReal x137=IKsin(j2);
IkReal x138=((IkReal(0.0800000000000000))*(sj3));
IkReal x139=((cj0)*(r01));
IkReal x140=((IkReal(1.00000000000000))*(px));
IkReal x141=((py)*(sj1));
IkReal x142=((cj0)*(r02));
IkReal x143=((IkReal(0.0750000000000000))*(cj1));
IkReal x144=((r02)*(sj0));
IkReal x145=((IkReal(0.0750000000000000))*(sj1));
IkReal x146=((cj1)*(pz));
IkReal x147=((r00)*(sj0));
IkReal x148=((IkReal(0.0800000000000000))*(cj3));
IkReal x149=((pz)*(sj1));
IkReal x150=((IkReal(1.00000000000000))*(sj0));
IkReal x151=((cj1)*(py));
IkReal x152=((IkReal(0.0750000000000000))*(x137));
IkReal x153=((IkReal(0.327500000000000))*(x136));
IkReal x154=((IkReal(0.0750000000000000))*(x136));
IkReal x155=((IkReal(0.327500000000000))*(x137));
IkReal x156=((sj1)*(x147));
IkReal x157=((x137)*(x138));
IkReal x158=((x136)*(x148));
IkReal x159=((x136)*(x138));
IkReal x160=((x137)*(x148));
IkReal x161=((x157)+(x152));
IkReal x162=((x153)+(x158));
IkReal x163=((x155)+(x154)+(x159)+(x160));
evalcond[0]=((((IkReal(-1.00000000000000))*(cj0)*(cj1)*(x140)))+(((IkReal(-1.00000000000000))*(x150)*(x151)))+(x162)+(((IkReal(-1.00000000000000))*(x161)))+(x143)+(x149));
evalcond[1]=((IkReal(0.300000000000000))+(((IkReal(-1.00000000000000))*(x141)*(x150)))+(((IkReal(-1.00000000000000))*(cj0)*(sj1)*(x140)))+(((IkReal(-1.00000000000000))*(x146)))+(x163)+(x145));
evalcond[2]=((((cj1)*(px)*(r01)))+(x161)+(((IkReal(-1.00000000000000))*(x139)*(x149)))+(((IkReal(-1.00000000000000))*(sj1)*(x140)*(x144)))+(((x143)*(x147)))+(((IkReal(-1.00000000000000))*(r00)*(x151)))+(((IkReal(-1.00000000000000))*(x139)*(x143)))+(((x147)*(x149)))+(((x141)*(x142)))+(((IkReal(-1.00000000000000))*(x162))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x139)*(x146)))+(((x139)*(x145)))+(((IkReal(-0.300000000000000))*(x147)))+(((r00)*(x141)))+(((IkReal(-1.00000000000000))*(cj1)*(x140)*(x144)))+(x163)+(((IkReal(-1.00000000000000))*(r01)*(sj1)*(x140)))+(((x142)*(x151)))+(((IkReal(-1.00000000000000))*(x145)*(x147)))+(((IkReal(0.300000000000000))*(x139)))+(((x146)*(x147))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
IkReal x164=(py)*(py);
IkReal x165=(px)*(px);
IkReal x166=(pz)*(pz);
IkReal x167=((r02)*(sj1));
IkReal x168=((cj1)*(pz));
IkReal x169=((IkReal(0.150000000000000))*(r00));
IkReal x170=((IkReal(0.600000000000000))*(r02));
IkReal x171=((cj0)*(px));
IkReal x172=((r01)*(sj0));
IkReal x173=((IkReal(1.00000000000000))*(cj1));
IkReal x174=((py)*(sj0));
IkReal x175=((py)*(r01));
IkReal x176=((IkReal(0.150000000000000))*(sj1));
IkReal x177=((IkReal(1.00000000000000))*(pz));
IkReal x178=((px)*(sj1));
IkReal x179=((IkReal(0.600000000000000))*(r00));
IkReal x180=((cj0)*(r00));
IkReal x181=((IkReal(0.0843750000000000))*(cj1));
IkReal x182=((IkReal(2.00000000000000))*(pz));
IkReal x183=((cj1)*(px));
IkReal x184=((IkReal(1.00000000000000))*(px));
IkReal x185=((IkReal(0.300000000000000))*(cj1));
IkReal x186=((IkReal(0.0956250000000000))*(sj1));
IkReal x187=((IkReal(1.00000000000000))*(sj1));
IkReal x188=((cj0)*(pz));
IkReal x189=((IkReal(0.150000000000000))*(cj1));
IkReal x190=((IkReal(2.00000000000000))*(sj1));
IkReal x191=((IkReal(2.00000000000000))*(cj1));
IkReal x192=((IkReal(2.00000000000000))*(r00));
IkReal x193=((IkReal(0.300000000000000))*(sj1));
IkReal x194=((r02)*(x174));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j4)), IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(sj0)*(x184)))+(((cj0)*(py))));
evalcond[2]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(r00)*(sj0)))+(((cj0)*(r01))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x173)*(x180)))+(x167)+(((IkReal(-1.00000000000000))*(x172)*(x173))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x180)*(x187)))+(((IkReal(-1.00000000000000))*(x172)*(x187)))+(((IkReal(-1.00000000000000))*(r02)*(x173))));
evalcond[5]=((((x172)*(x193)))+(((IkReal(-1.00000000000000))*(x175)))+(((r02)*(x185)))+(((IkReal(-1.00000000000000))*(r02)*(x177)))+(((IkReal(0.0750000000000000))*(x172)))+(((x180)*(x193)))+(((IkReal(-1.00000000000000))*(r00)*(x184)))+(((IkReal(0.0750000000000000))*(x180))));
evalcond[6]=((((IkReal(-1.00000000000000))*(x172)*(x177)))+(((IkReal(-1.00000000000000))*(x177)*(x180)))+(x194)+(((IkReal(-0.300000000000000))*(x167)))+(((x180)*(x185)))+(((x172)*(x185)))+(((r02)*(x171)))+(((IkReal(-0.0750000000000000))*(r02))));
evalcond[7]=((((x167)*(x174)*(x182)))+(((IkReal(2.00000000000000))*(x168)*(x175)))+(((IkReal(0.0450000000000000))*(x172)))+(((IkReal(-1.00000000000000))*(x169)*(x178)))+(((IkReal(0.0450000000000000))*(x180)))+(((IkReal(-1.00000000000000))*(pp)*(r02)*(x173)))+(((x174)*(x178)*(x192)))+(((r02)*(x166)*(x191)))+(((px)*(x168)*(x192)))+(((IkReal(-0.150000000000000))*(x168)*(x172)))+(((x165)*(x180)*(x190)))+(((IkReal(-1.00000000000000))*(pz)*(x170)))+(((IkReal(-1.00000000000000))*(pp)*(x180)*(x187)))+(((IkReal(-1.00000000000000))*(x175)*(x176)))+(((IkReal(-1.00000000000000))*(cj0)*(x168)*(x169)))+(((IkReal(-1.00000000000000))*(px)*(x179)))+(((IkReal(-0.150000000000000))*(pz)*(x167)))+(((x172)*(x186)))+(((r02)*(x171)*(x189)))+(((x167)*(x171)*(x182)))+(((IkReal(-1.00000000000000))*(pp)*(x172)*(x187)))+(((r02)*(x181)))+(((x164)*(x172)*(x190)))+(((x171)*(x175)*(x190)))+(((x189)*(x194)))+(((IkReal(-0.600000000000000))*(x175)))+(((x180)*(x186))));
evalcond[8]=((((IkReal(-1.00000000000000))*(x172)*(x181)))+(((IkReal(-0.150000000000000))*(x167)*(x174)))+(((IkReal(0.0450000000000000))*(r02)))+(((IkReal(0.600000000000000))*(pz)*(x172)))+(((IkReal(-1.00000000000000))*(x180)*(x181)))+(((pp)*(x167)))+(((pz)*(x172)*(x176)))+(((IkReal(-0.150000000000000))*(x167)*(x171)))+(((x179)*(x188)))+(((IkReal(-2.00000000000000))*(x166)*(x167)))+(((IkReal(-1.00000000000000))*(r00)*(x178)*(x182)))+(((IkReal(-1.00000000000000))*(x169)*(x183)))+(((IkReal(2.00000000000000))*(r02)*(x168)*(x171)))+(((IkReal(-0.150000000000000))*(r02)*(x168)))+(((IkReal(0.0956250000000000))*(x167)))+(((IkReal(-1.00000000000000))*(pp)*(x173)*(x180)))+(((x164)*(x172)*(x191)))+(((IkReal(-1.00000000000000))*(x170)*(x171)))+(((IkReal(-1.00000000000000))*(x175)*(x189)))+(((IkReal(-1.00000000000000))*(sj1)*(x175)*(x182)))+(((IkReal(2.00000000000000))*(x168)*(x194)))+(((IkReal(-1.00000000000000))*(x170)*(x174)))+(((sj1)*(x169)*(x188)))+(((x165)*(x180)*(x191)))+(((x171)*(x175)*(x191)))+(((IkReal(-1.00000000000000))*(pp)*(x172)*(x173)))+(((x174)*(x183)*(x192))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[2], cj3array[2], sj3array[2];
bool j3valid[2]={false};
_nj3 = 2;
IkReal x195=((IkReal(11.1614434376257))*(sj1));
IkReal x196=((py)*(sj0));
IkReal x197=((cj0)*(px));
if( (((IkReal(0.440063160535554))+(((IkReal(-0.837108257821925))*(sj1)))+(((x195)*(x196)))+(((IkReal(11.1614434376257))*(cj1)*(pz)))+(((IkReal(-18.6024057293761))*(pp)))+(((IkReal(2.79036085940642))*(x196)))+(((IkReal(2.79036085940642))*(x197)))+(((x195)*(x197))))) < -1-IKFAST_SINCOS_THRESH || (((IkReal(0.440063160535554))+(((IkReal(-0.837108257821925))*(sj1)))+(((x195)*(x196)))+(((IkReal(11.1614434376257))*(cj1)*(pz)))+(((IkReal(-18.6024057293761))*(pp)))+(((IkReal(2.79036085940642))*(x196)))+(((IkReal(2.79036085940642))*(x197)))+(((x195)*(x197))))) > 1+IKFAST_SINCOS_THRESH )
    continue;
IkReal x198=IKasin(((IkReal(0.440063160535554))+(((IkReal(-0.837108257821925))*(sj1)))+(((x195)*(x196)))+(((IkReal(11.1614434376257))*(cj1)*(pz)))+(((IkReal(-18.6024057293761))*(pp)))+(((IkReal(2.79036085940642))*(x196)))+(((IkReal(2.79036085940642))*(x197)))+(((x195)*(x197)))));
j3array[0]=((IkReal(-1.34567065063197))+(((IkReal(-1.00000000000000))*(x198))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
j3array[1]=((IkReal(1.79592200295782))+(x198));
sj3array[1]=IKsin(j3array[1]);
cj3array[1]=IKcos(j3array[1]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
if( j3array[1] > IKPI )
{
    j3array[1]-=IK2PI;
}
else if( j3array[1] < -IKPI )
{    j3array[1]+=IK2PI;
}
j3valid[1] = true;
for(int ij3 = 0; ij3 < 2; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 2; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[1];
IkReal x199=((IkReal(2.00000000000000))*(sj0));
IkReal x200=((px)*(py));
IkReal x201=((r00)*(sj0));
IkReal x202=((cj0)*(r01));
IkReal x203=((py)*(r00));
IkReal x204=((IkReal(2.00000000000000))*(cj0));
IkReal x205=((px)*(r01));
IkReal x206=((IkReal(0.600000000000000))*(cj1));
IkReal x207=((py)*(r02));
IkReal x208=((IkReal(0.600000000000000))*(sj1));
IkReal x209=((IkReal(0.0450000000000000))*(sj1));
IkReal x210=((px)*(r02));
evalcond[0]=((IkReal(0.119281250000000))+(((x203)*(x208)))+(((pp)*(x202)))+(((r01)*(x199)*(x200)))+(((IkReal(-1.00000000000000))*(pp)*(x201)))+(((r00)*(x199)*((px)*(px))))+(((IkReal(0.0956250000000000))*(x202)))+(((IkReal(-1.00000000000000))*(r00)*(x200)*(x204)))+(((IkReal(-2.00000000000000))*(x202)*((py)*(py))))+(((IkReal(-1.00000000000000))*(pz)*(x204)*(x207)))+(((IkReal(-1.00000000000000))*(pz)*(x202)*(x206)))+(((IkReal(-0.0956250000000000))*(x201)))+(((IkReal(-1.00000000000000))*(sj0)*(x206)*(x210)))+(((pz)*(x201)*(x206)))+(((x202)*(x209)))+(((IkReal(0.150000000000000))*(x203)))+(((pz)*(x199)*(x210)))+(((IkReal(-1.00000000000000))*(x201)*(x209)))+(((IkReal(0.0120000000000000))*(IKsin(j3))))+(((IkReal(0.0524000000000000))*(IKcos(j3))))+(((IkReal(-0.150000000000000))*(x205)))+(((IkReal(-1.00000000000000))*(x205)*(x208)))+(((cj0)*(x206)*(x207))));
if( IKabs(evalcond[0]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst10;
gconst10=IKsign(((IkReal(0.112881250000000))+(((IkReal(0.0524000000000000))*(cj3)))+(((IkReal(0.00640000000000000))*((sj3)*(sj3))))+(((IkReal(0.00640000000000000))*((cj3)*(cj3))))+(((IkReal(0.0120000000000000))*(sj3)))));
dummyeval[0]=((IkReal(17.6376953125000))+(((IkReal(8.18750000000000))*(cj3)))+((cj3)*(cj3))+(((IkReal(1.87500000000000))*(sj3)))+((sj3)*(sj3)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst11;
gconst11=IKsign(((IkReal(-0.112881250000000))+(((IkReal(-0.00640000000000000))*((sj3)*(sj3))))+(((IkReal(-0.0120000000000000))*(sj3)))+(((IkReal(-0.00640000000000000))*((cj3)*(cj3))))+(((IkReal(-0.0524000000000000))*(cj3)))));
dummyeval[0]=((IkReal(-17.6376953125000))+(((IkReal(-1.87500000000000))*(sj3)))+(((IkReal(-1.00000000000000))*((cj3)*(cj3))))+(((IkReal(-8.18750000000000))*(cj3)))+(((IkReal(-1.00000000000000))*((sj3)*(sj3)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x211=((pz)*(r01));
IkReal x212=((py)*(r02));
IkReal x213=((cj1)*(r01));
IkReal x214=((IkReal(0.00600000000000000))*(cj0));
IkReal x215=((IkReal(0.0750000000000000))*(sj1));
IkReal x216=((py)*(sj0));
IkReal x217=((cj1)*(pz));
IkReal x218=((r00)*(sj0));
IkReal x219=((px)*(sj3));
IkReal x220=((IkReal(0.0800000000000000))*(sj3));
IkReal x221=((IkReal(0.0800000000000000))*(cj3));
IkReal x222=((IkReal(0.00600000000000000))*(sj3));
IkReal x223=((IkReal(0.00600000000000000))*(cj3));
IkReal x224=((IkReal(0.327500000000000))*(sj1));
IkReal x225=((IkReal(0.0800000000000000))*(cj0)*(sj1));
IkReal x226=((cj0)*(x224));
IkReal x227=((sj1)*(x221));
IkReal x228=((px)*(r02)*(sj0));
IkReal x229=((cj1)*(py)*(r00));
IkReal x230=((IkReal(0.0800000000000000))*(sj1)*(x228));
if( IKabs(((gconst11)*(((IkReal(0.0982500000000000))+(((IkReal(0.00562500000000000))*(cj0)*(x213)))+(((x220)*(x229)))+(((IkReal(-1.00000000000000))*(cj1)*(x218)*(x222)))+(((IkReal(-1.00000000000000))*(cj0)*(x212)*(x215)))+(((cj0)*(sj1)*(x211)*(x220)))+(((sj3)*(x213)*(x214)))+(((IkReal(0.0750000000000000))*(x229)))+(((IkReal(-1.00000000000000))*(cj0)*(px)*(x227)))+(((IkReal(0.0245625000000000))*(sj1)))+(((IkReal(-0.327500000000000))*(x217)))+(((IkReal(-1.00000000000000))*(x217)*(x221)))+(((IkReal(0.0800000000000000))*(r02)*(sj0)*(sj1)*(x219)))+(((IkReal(-0.00562500000000000))*(cj1)*(x218)))+(((IkReal(-0.0750000000000000))*(px)*(x213)))+(((IkReal(-1.00000000000000))*(pz)*(sj1)*(x218)*(x220)))+(((IkReal(-1.00000000000000))*(cj0)*(sj1)*(x212)*(x220)))+(((x215)*(x228)))+(((IkReal(-1.00000000000000))*(x216)*(x224)))+(((IkReal(-1.00000000000000))*(x216)*(x227)))+(((IkReal(-1.00000000000000))*(pz)*(x215)*(x218)))+(((IkReal(-1.00000000000000))*(px)*(x226)))+(((cj0)*(x211)*(x215)))+(((sj1)*(x223)))+(((IkReal(0.0240000000000000))*(cj3)))+(((IkReal(-0.0800000000000000))*(x213)*(x219))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst11)*(((IkReal(0.0225000000000000))+(((cj1)*(x218)*(x223)))+(((IkReal(-1.00000000000000))*(x221)*(x229)))+(((IkReal(-0.0245625000000000))*(cj0)*(x213)))+(((IkReal(0.00562500000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(x211)*(x226)))+(((IkReal(-0.0750000000000000))*(x217)))+(((IkReal(-1.00000000000000))*(x217)*(x220)))+(((IkReal(-1.00000000000000))*(x224)*(x228)))+(((pz)*(x218)*(x227)))+(((IkReal(-1.00000000000000))*(cj0)*(x211)*(x227)))+(((IkReal(-1.00000000000000))*(x219)*(x225)))+(((IkReal(-0.327500000000000))*(x229)))+(((IkReal(0.327500000000000))*(px)*(x213)))+(((IkReal(-1.00000000000000))*(x215)*(x216)))+(((IkReal(-1.00000000000000))*(sj1)*(x216)*(x220)))+(((IkReal(-1.00000000000000))*(x227)*(x228)))+(((px)*(x213)*(x221)))+(((IkReal(0.0245625000000000))*(cj1)*(x218)))+(((x212)*(x226)))+(((sj1)*(x222)))+(((IkReal(-1.00000000000000))*(cj0)*(px)*(x215)))+(((IkReal(-1.00000000000000))*(cj3)*(x213)*(x214)))+(((pz)*(x218)*(x224)))+(((IkReal(0.0240000000000000))*(sj3)))+(((cj0)*(x212)*(x227))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst11)*(((IkReal(0.0982500000000000))+(((IkReal(0.00562500000000000))*(cj0)*(x213)))+(((x220)*(x229)))+(((IkReal(-1.00000000000000))*(cj1)*(x218)*(x222)))+(((IkReal(-1.00000000000000))*(cj0)*(x212)*(x215)))+(((cj0)*(sj1)*(x211)*(x220)))+(((sj3)*(x213)*(x214)))+(((IkReal(0.0750000000000000))*(x229)))+(((IkReal(-1.00000000000000))*(cj0)*(px)*(x227)))+(((IkReal(0.0245625000000000))*(sj1)))+(((IkReal(-0.327500000000000))*(x217)))+(((IkReal(-1.00000000000000))*(x217)*(x221)))+(((IkReal(0.0800000000000000))*(r02)*(sj0)*(sj1)*(x219)))+(((IkReal(-0.00562500000000000))*(cj1)*(x218)))+(((IkReal(-0.0750000000000000))*(px)*(x213)))+(((IkReal(-1.00000000000000))*(pz)*(sj1)*(x218)*(x220)))+(((IkReal(-1.00000000000000))*(cj0)*(sj1)*(x212)*(x220)))+(((x215)*(x228)))+(((IkReal(-1.00000000000000))*(x216)*(x224)))+(((IkReal(-1.00000000000000))*(x216)*(x227)))+(((IkReal(-1.00000000000000))*(pz)*(x215)*(x218)))+(((IkReal(-1.00000000000000))*(px)*(x226)))+(((cj0)*(x211)*(x215)))+(((sj1)*(x223)))+(((IkReal(0.0240000000000000))*(cj3)))+(((IkReal(-0.0800000000000000))*(x213)*(x219)))))), ((gconst11)*(((IkReal(0.0225000000000000))+(((cj1)*(x218)*(x223)))+(((IkReal(-1.00000000000000))*(x221)*(x229)))+(((IkReal(-0.0245625000000000))*(cj0)*(x213)))+(((IkReal(0.00562500000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(x211)*(x226)))+(((IkReal(-0.0750000000000000))*(x217)))+(((IkReal(-1.00000000000000))*(x217)*(x220)))+(((IkReal(-1.00000000000000))*(x224)*(x228)))+(((pz)*(x218)*(x227)))+(((IkReal(-1.00000000000000))*(cj0)*(x211)*(x227)))+(((IkReal(-1.00000000000000))*(x219)*(x225)))+(((IkReal(-0.327500000000000))*(x229)))+(((IkReal(0.327500000000000))*(px)*(x213)))+(((IkReal(-1.00000000000000))*(x215)*(x216)))+(((IkReal(-1.00000000000000))*(sj1)*(x216)*(x220)))+(((IkReal(-1.00000000000000))*(x227)*(x228)))+(((px)*(x213)*(x221)))+(((IkReal(0.0245625000000000))*(cj1)*(x218)))+(((x212)*(x226)))+(((sj1)*(x222)))+(((IkReal(-1.00000000000000))*(cj0)*(px)*(x215)))+(((IkReal(-1.00000000000000))*(cj3)*(x213)*(x214)))+(((pz)*(x218)*(x224)))+(((IkReal(0.0240000000000000))*(sj3)))+(((cj0)*(x212)*(x227)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x231=IKcos(j2);
IkReal x232=IKsin(j2);
IkReal x233=((IkReal(0.0800000000000000))*(sj3));
IkReal x234=((cj0)*(r01));
IkReal x235=((IkReal(1.00000000000000))*(px));
IkReal x236=((py)*(sj1));
IkReal x237=((cj0)*(r02));
IkReal x238=((IkReal(0.0750000000000000))*(cj1));
IkReal x239=((r02)*(sj0));
IkReal x240=((IkReal(0.0750000000000000))*(sj1));
IkReal x241=((cj1)*(pz));
IkReal x242=((r00)*(sj0));
IkReal x243=((IkReal(0.0800000000000000))*(cj3));
IkReal x244=((pz)*(sj1));
IkReal x245=((IkReal(1.00000000000000))*(sj0));
IkReal x246=((cj1)*(py));
IkReal x247=((IkReal(0.327500000000000))*(x231));
IkReal x248=((IkReal(0.0750000000000000))*(x232));
IkReal x249=((IkReal(0.0750000000000000))*(x231));
IkReal x250=((IkReal(0.327500000000000))*(x232));
IkReal x251=((sj1)*(x242));
IkReal x252=((x231)*(x243));
IkReal x253=((x232)*(x233));
IkReal x254=((x231)*(x233));
IkReal x255=((x232)*(x243));
IkReal x256=((x253)+(x248));
IkReal x257=((x252)+(x247));
IkReal x258=((x254)+(x255)+(x250)+(x249));
evalcond[0]=((((IkReal(-1.00000000000000))*(x256)))+(((IkReal(-1.00000000000000))*(x245)*(x246)))+(x238)+(x257)+(x244)+(((IkReal(-1.00000000000000))*(cj0)*(cj1)*(x235))));
evalcond[1]=((IkReal(0.300000000000000))+(((IkReal(-1.00000000000000))*(x236)*(x245)))+(x258)+(x240)+(((IkReal(-1.00000000000000))*(cj0)*(sj1)*(x235)))+(((IkReal(-1.00000000000000))*(x241))));
evalcond[2]=((((x242)*(x244)))+(((IkReal(-1.00000000000000))*(x256)))+(x257)+(((cj1)*(px)*(r01)))+(((IkReal(-1.00000000000000))*(sj1)*(x235)*(x239)))+(((x238)*(x242)))+(((IkReal(-1.00000000000000))*(x234)*(x238)))+(((x236)*(x237)))+(((IkReal(-1.00000000000000))*(r00)*(x246)))+(((IkReal(-1.00000000000000))*(x234)*(x244))));
evalcond[3]=((((x237)*(x246)))+(((IkReal(-1.00000000000000))*(cj1)*(x235)*(x239)))+(((IkReal(-1.00000000000000))*(x258)))+(((IkReal(-0.300000000000000))*(x242)))+(((IkReal(-1.00000000000000))*(r01)*(sj1)*(x235)))+(((x241)*(x242)))+(((x234)*(x240)))+(((IkReal(-1.00000000000000))*(x234)*(x241)))+(((IkReal(0.300000000000000))*(x234)))+(((IkReal(-1.00000000000000))*(x240)*(x242)))+(((r00)*(x236))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x259=((IkReal(0.0800000000000000))*(cj1));
IkReal x260=((cj0)*(px));
IkReal x261=((py)*(sj0));
IkReal x262=((IkReal(0.0750000000000000))*(cj1));
IkReal x263=((IkReal(0.327500000000000))*(cj1));
IkReal x264=((IkReal(0.327500000000000))*(sj1));
IkReal x265=((IkReal(0.0750000000000000))*(sj1));
IkReal x266=((IkReal(0.00600000000000000))*(sj1));
IkReal x267=((IkReal(0.00600000000000000))*(cj1));
IkReal x268=((IkReal(0.0800000000000000))*(sj1)*(sj3));
IkReal x269=((IkReal(0.0800000000000000))*(cj3)*(sj1));
if( IKabs(((gconst10)*(((IkReal(-0.0982500000000000))+(((IkReal(-1.00000000000000))*(x261)*(x262)))+(((pz)*(x263)))+(((pz)*(x268)))+(((cj3)*(pz)*(x259)))+(((IkReal(-1.00000000000000))*(sj3)*(x259)*(x261)))+(((IkReal(-0.0245625000000000))*(sj1)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((IkReal(-1.00000000000000))*(x260)*(x262)))+(((x261)*(x269)))+(((IkReal(-1.00000000000000))*(cj3)*(x266)))+(((sj3)*(x267)))+(((x261)*(x264)))+(((IkReal(-1.00000000000000))*(sj3)*(x259)*(x260)))+(((x260)*(x264)))+(((x260)*(x269)))+(((IkReal(0.00562500000000000))*(cj1)))+(((pz)*(x265))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst10)*(((IkReal(-0.0225000000000000))+(((IkReal(-0.0240000000000000))*(sj3)))+(((pz)*(sj3)*(x259)))+(((cj3)*(x259)*(x260)))+(((x261)*(x265)))+(((x261)*(x263)))+(((x260)*(x265)))+(((IkReal(-1.00000000000000))*(pz)*(x269)))+(((IkReal(-1.00000000000000))*(sj3)*(x266)))+(((x261)*(x268)))+(((x260)*(x263)))+(((IkReal(-1.00000000000000))*(pz)*(x264)))+(((IkReal(-0.0245625000000000))*(cj1)))+(((cj3)*(x259)*(x261)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(cj3)*(x267)))+(((x260)*(x268)))+(((pz)*(x262))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst10)*(((IkReal(-0.0982500000000000))+(((IkReal(-1.00000000000000))*(x261)*(x262)))+(((pz)*(x263)))+(((pz)*(x268)))+(((cj3)*(pz)*(x259)))+(((IkReal(-1.00000000000000))*(sj3)*(x259)*(x261)))+(((IkReal(-0.0245625000000000))*(sj1)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((IkReal(-1.00000000000000))*(x260)*(x262)))+(((x261)*(x269)))+(((IkReal(-1.00000000000000))*(cj3)*(x266)))+(((sj3)*(x267)))+(((x261)*(x264)))+(((IkReal(-1.00000000000000))*(sj3)*(x259)*(x260)))+(((x260)*(x264)))+(((x260)*(x269)))+(((IkReal(0.00562500000000000))*(cj1)))+(((pz)*(x265)))))), ((gconst10)*(((IkReal(-0.0225000000000000))+(((IkReal(-0.0240000000000000))*(sj3)))+(((pz)*(sj3)*(x259)))+(((cj3)*(x259)*(x260)))+(((x261)*(x265)))+(((x261)*(x263)))+(((x260)*(x265)))+(((IkReal(-1.00000000000000))*(pz)*(x269)))+(((IkReal(-1.00000000000000))*(sj3)*(x266)))+(((x261)*(x268)))+(((x260)*(x263)))+(((IkReal(-1.00000000000000))*(pz)*(x264)))+(((IkReal(-0.0245625000000000))*(cj1)))+(((cj3)*(x259)*(x261)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(cj3)*(x267)))+(((x260)*(x268)))+(((pz)*(x262)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x270=IKcos(j2);
IkReal x271=IKsin(j2);
IkReal x272=((IkReal(0.0800000000000000))*(sj3));
IkReal x273=((cj0)*(r01));
IkReal x274=((IkReal(1.00000000000000))*(px));
IkReal x275=((py)*(sj1));
IkReal x276=((cj0)*(r02));
IkReal x277=((IkReal(0.0750000000000000))*(cj1));
IkReal x278=((r02)*(sj0));
IkReal x279=((IkReal(0.0750000000000000))*(sj1));
IkReal x280=((cj1)*(pz));
IkReal x281=((r00)*(sj0));
IkReal x282=((IkReal(0.0800000000000000))*(cj3));
IkReal x283=((pz)*(sj1));
IkReal x284=((IkReal(1.00000000000000))*(sj0));
IkReal x285=((cj1)*(py));
IkReal x286=((IkReal(0.327500000000000))*(x270));
IkReal x287=((IkReal(0.0750000000000000))*(x271));
IkReal x288=((IkReal(0.0750000000000000))*(x270));
IkReal x289=((IkReal(0.327500000000000))*(x271));
IkReal x290=((sj1)*(x281));
IkReal x291=((x270)*(x282));
IkReal x292=((x271)*(x272));
IkReal x293=((x270)*(x272));
IkReal x294=((x271)*(x282));
IkReal x295=((x287)+(x292));
IkReal x296=((x286)+(x291));
IkReal x297=((x289)+(x288)+(x293)+(x294));
evalcond[0]=((((IkReal(-1.00000000000000))*(cj0)*(cj1)*(x274)))+(x283)+(x296)+(((IkReal(-1.00000000000000))*(x295)))+(x277)+(((IkReal(-1.00000000000000))*(x284)*(x285))));
evalcond[1]=((IkReal(0.300000000000000))+(((IkReal(-1.00000000000000))*(x280)))+(((IkReal(-1.00000000000000))*(x275)*(x284)))+(x297)+(((IkReal(-1.00000000000000))*(cj0)*(sj1)*(x274)))+(x279));
evalcond[2]=((((x281)*(x283)))+(((IkReal(-1.00000000000000))*(sj1)*(x274)*(x278)))+(((IkReal(-1.00000000000000))*(x273)*(x277)))+(x296)+(((cj1)*(px)*(r01)))+(((x275)*(x276)))+(((IkReal(-1.00000000000000))*(x295)))+(((IkReal(-1.00000000000000))*(x273)*(x283)))+(((x277)*(x281)))+(((IkReal(-1.00000000000000))*(r00)*(x285))));
evalcond[3]=((((x280)*(x281)))+(((IkReal(-1.00000000000000))*(x279)*(x281)))+(((r00)*(x275)))+(((x273)*(x279)))+(((IkReal(-1.00000000000000))*(r01)*(sj1)*(x274)))+(((IkReal(0.300000000000000))*(x273)))+(((IkReal(-1.00000000000000))*(x297)))+(((IkReal(-0.300000000000000))*(x281)))+(((x276)*(x285)))+(((IkReal(-1.00000000000000))*(x273)*(x280)))+(((IkReal(-1.00000000000000))*(cj1)*(x274)*(x278))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x298=((px)*(r00));
IkReal x299=((cj0)*(r00));
IkReal x300=((IkReal(15720.0000000000))*(cj1));
IkReal x301=((IkReal(3600.00000000000))*(sj1));
IkReal x302=((r01)*(sj0));
IkReal x303=((IkReal(3600.00000000000))*(cj1));
IkReal x304=((py)*(r01));
IkReal x305=((pz)*(r02));
IkReal x306=((IkReal(12000.0000000000))*(pz));
IkReal x307=((IkReal(52400.0000000000))*(r02));
IkReal x308=((cj0)*(px));
IkReal x309=((py)*(sj0));
IkReal x310=((IkReal(52400.0000000000))*(pz));
IkReal x311=((IkReal(15720.0000000000))*(sj1));
IkReal x312=((IkReal(12000.0000000000))*(r02));
IkReal x313=((sj1)*(x302));
if( IKabs(((gconst1)*(((((IkReal(-1.00000000000000))*(x302)*(x306)))+(((IkReal(-900.000000000000))*(r02)))+(((IkReal(-1.00000000000000))*(x299)*(x306)))+(((x299)*(x303)))+(((IkReal(-52400.0000000000))*(x305)))+(((IkReal(-1.00000000000000))*(r02)*(x301)))+(((x308)*(x312)))+(((x299)*(x311)))+(((x302)*(x303)))+(((x309)*(x312)))+(((IkReal(3930.00000000000))*(x302)))+(((x302)*(x311)))+(((IkReal(-52400.0000000000))*(x304)))+(((r02)*(x300)))+(((IkReal(-960.000000000000))*(cj4)))+(((IkReal(3930.00000000000))*(x299)))+(((IkReal(-52400.0000000000))*(x298))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst1)*(((((IkReal(-1.00000000000000))*(x299)*(x301)))+(((IkReal(-900.000000000000))*(x302)))+(((IkReal(-1.00000000000000))*(r02)*(x311)))+(((IkReal(12000.0000000000))*(x304)))+(((IkReal(-1.00000000000000))*(r02)*(x303)))+(((IkReal(-3930.00000000000))*(r02)))+(((IkReal(-1.00000000000000))*(x302)*(x310)))+(((IkReal(12000.0000000000))*(x305)))+(((IkReal(-1.00000000000000))*(x299)*(x310)))+(((x307)*(x309)))+(((IkReal(12000.0000000000))*(x298)))+(((x300)*(x302)))+(((x299)*(x300)))+(((x307)*(x308)))+(((IkReal(-900.000000000000))*(x299)))+(((IkReal(-4192.00000000000))*(cj4)))+(((IkReal(-1.00000000000000))*(x301)*(x302))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst1)*(((((IkReal(-1.00000000000000))*(x302)*(x306)))+(((IkReal(-900.000000000000))*(r02)))+(((IkReal(-1.00000000000000))*(x299)*(x306)))+(((x299)*(x303)))+(((IkReal(-52400.0000000000))*(x305)))+(((IkReal(-1.00000000000000))*(r02)*(x301)))+(((x308)*(x312)))+(((x299)*(x311)))+(((x302)*(x303)))+(((x309)*(x312)))+(((IkReal(3930.00000000000))*(x302)))+(((x302)*(x311)))+(((IkReal(-52400.0000000000))*(x304)))+(((r02)*(x300)))+(((IkReal(-960.000000000000))*(cj4)))+(((IkReal(3930.00000000000))*(x299)))+(((IkReal(-52400.0000000000))*(x298)))))), ((gconst1)*(((((IkReal(-1.00000000000000))*(x299)*(x301)))+(((IkReal(-900.000000000000))*(x302)))+(((IkReal(-1.00000000000000))*(r02)*(x311)))+(((IkReal(12000.0000000000))*(x304)))+(((IkReal(-1.00000000000000))*(r02)*(x303)))+(((IkReal(-3930.00000000000))*(r02)))+(((IkReal(-1.00000000000000))*(x302)*(x310)))+(((IkReal(12000.0000000000))*(x305)))+(((IkReal(-1.00000000000000))*(x299)*(x310)))+(((x307)*(x309)))+(((IkReal(12000.0000000000))*(x298)))+(((x300)*(x302)))+(((x299)*(x300)))+(((x307)*(x308)))+(((IkReal(-900.000000000000))*(x299)))+(((IkReal(-4192.00000000000))*(cj4)))+(((IkReal(-1.00000000000000))*(x301)*(x302)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x314=IKcos(j3);
IkReal x315=IKsin(j3);
IkReal x316=((r01)*(sj0));
IkReal x317=((IkReal(0.300000000000000))*(r02));
IkReal x318=((r00)*(sj0));
IkReal x319=((py)*(sj0));
IkReal x320=((IkReal(0.600000000000000))*(cj1));
IkReal x321=((IkReal(0.150000000000000))*(px));
IkReal x322=((IkReal(1.00000000000000))*(pz));
IkReal x323=((py)*(r00));
IkReal x324=((IkReal(0.300000000000000))*(cj1));
IkReal x325=((IkReal(1.00000000000000))*(pp));
IkReal x326=((cj0)*(r00));
IkReal x327=((IkReal(0.0450000000000000))*(sj1));
IkReal x328=((IkReal(0.600000000000000))*(sj1));
IkReal x329=((cj0)*(r01));
IkReal x330=((IkReal(2.00000000000000))*(pz));
IkReal x331=((cj0)*(px));
IkReal x332=((IkReal(0.300000000000000))*(sj1));
IkReal x333=((IkReal(2.00000000000000))*(px)*(py));
IkReal x334=((IkReal(0.0120000000000000))*(x315));
IkReal x335=((cj4)*(x315));
IkReal x336=((IkReal(0.0524000000000000))*(x314));
IkReal x337=((cj4)*(x314));
IkReal x338=((cj0)*(py)*(r02));
IkReal x339=((px)*(r02)*(sj0));
evalcond[0]=((IkReal(0.0236562500000000))+(((x319)*(x328)))+(((IkReal(-1.00000000000000))*(x325)))+(((IkReal(-1.00000000000000))*(x327)))+(((x328)*(x331)))+(((cj0)*(x321)))+(x336)+(x334)+(((pz)*(x320)))+(((IkReal(0.150000000000000))*(x319))));
evalcond[1]=((((IkReal(-1.00000000000000))*(py)*(r01)))+(((x326)*(x332)))+(((IkReal(-1.00000000000000))*(px)*(r00)))+(((IkReal(0.0750000000000000))*(x316)))+(((IkReal(0.0750000000000000))*(x326)))+(((cj1)*(x317)))+(((IkReal(0.0750000000000000))*(x337)))+(((IkReal(-0.327500000000000))*(x335)))+(((x316)*(x332)))+(((IkReal(-1.00000000000000))*(r02)*(x322))));
evalcond[2]=((((IkReal(-0.0800000000000000))*(cj4)))+(((IkReal(-1.00000000000000))*(x316)*(x322)))+(((r02)*(x319)))+(((x324)*(x326)))+(((x316)*(x324)))+(((IkReal(-0.0750000000000000))*(x335)))+(((IkReal(-1.00000000000000))*(x322)*(x326)))+(((IkReal(-0.0750000000000000))*(r02)))+(((IkReal(-1.00000000000000))*(sj1)*(x317)))+(((r02)*(x331)))+(((IkReal(-0.327500000000000))*(x337))));
evalcond[3]=((((x330)*(x339)))+(((IkReal(-0.119281250000000))*(sj4)))+(((IkReal(-1.00000000000000))*(sj4)*(x334)))+(((IkReal(-1.00000000000000))*(px)*(r01)*(x328)))+(((IkReal(-2.00000000000000))*(x329)*((py)*(py))))+(((IkReal(-1.00000000000000))*(sj4)*(x336)))+(((x316)*(x333)))+(((IkReal(-1.00000000000000))*(pz)*(x320)*(x329)))+(((IkReal(-1.00000000000000))*(r01)*(x321)))+(((x327)*(x329)))+(((x320)*(x338)))+(((IkReal(-1.00000000000000))*(x318)*(x327)))+(((pp)*(x329)))+(((IkReal(0.150000000000000))*(x323)))+(((IkReal(-0.0956250000000000))*(x318)))+(((IkReal(-2.00000000000000))*(x323)*(x331)))+(((IkReal(-1.00000000000000))*(x330)*(x338)))+(((IkReal(-1.00000000000000))*(x320)*(x339)))+(((pz)*(x318)*(x320)))+(((IkReal(0.0956250000000000))*(x329)))+(((IkReal(-1.00000000000000))*(x318)*(x325)))+(((IkReal(2.00000000000000))*(x318)*((px)*(px))))+(((x323)*(x328))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst2;
gconst2=IKsign(((((cj4)*((cj3)*(cj3))))+(((cj4)*((sj3)*(sj3))))));
dummyeval[0]=((((cj4)*((cj3)*(cj3))))+(((cj4)*((sj3)*(sj3)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst3;
IkReal x340=((IkReal(0.0800000000000000))*(cj4));
gconst3=IKsign(((((x340)*((sj3)*(sj3))))+(((x340)*((cj3)*(cj3))))+(((IkReal(0.0750000000000000))*(cj4)*(sj3)))+(((IkReal(0.327500000000000))*(cj3)*(cj4)))));
IkReal x341=((IkReal(1.06666666666667))*(cj4));
dummyeval[0]=((((IkReal(4.36666666666667))*(cj3)*(cj4)))+(((x341)*((sj3)*(sj3))))+(((cj4)*(sj3)))+(((x341)*((cj3)*(cj3)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[11];
IkReal x342=((IkReal(0.0524000000000000))*(cj3));
IkReal x343=((IkReal(0.0120000000000000))*(sj3));
IkReal x344=(py)*(py);
IkReal x345=(px)*(px);
IkReal x346=(pz)*(pz);
IkReal x347=((r01)*(sj0));
IkReal x348=((py)*(r00));
IkReal x349=((pz)*(sj1));
IkReal x350=((py)*(r01));
IkReal x351=((px)*(sj0));
IkReal x352=((IkReal(0.600000000000000))*(r02));
IkReal x353=((IkReal(0.150000000000000))*(cj1));
IkReal x354=((cj0)*(sj1));
IkReal x355=((IkReal(0.150000000000000))*(px));
IkReal x356=((IkReal(2.00000000000000))*(cj1));
IkReal x357=((cj0)*(r01));
IkReal x358=((r02)*(sj1));
IkReal x359=((px)*(r00));
IkReal x360=((IkReal(0.300000000000000))*(r00));
IkReal x361=((IkReal(1.00000000000000))*(pz));
IkReal x362=((r00)*(sj1));
IkReal x363=((cj0)*(r00));
IkReal x364=((cj0)*(cj1));
IkReal x365=((IkReal(1.00000000000000))*(sj1));
IkReal x366=((IkReal(0.0956250000000000))*(r00));
IkReal x367=((IkReal(0.600000000000000))*(pz));
IkReal x368=((IkReal(0.600000000000000))*(sj1));
IkReal x369=((IkReal(2.00000000000000))*(px));
IkReal x370=((IkReal(2.00000000000000))*(sj1));
IkReal x371=((IkReal(0.150000000000000))*(sj1));
IkReal x372=((cj1)*(r02));
IkReal x373=((cj0)*(px));
IkReal x374=((IkReal(0.0843750000000000))*(cj1));
IkReal x375=((py)*(sj0));
IkReal x376=((pz)*(r02));
IkReal x377=((IkReal(1.00000000000000))*(cj1));
IkReal x378=((cj0)*(py));
IkReal x379=((r00)*(sj0));
IkReal x380=((r02)*(x375));
IkReal x381=((pp)*(x377));
IkReal x382=((IkReal(1.00000000000000))*(pp)*(r00));
IkReal x383=((x342)+(x343));
IkReal x384=((IkReal(2.00000000000000))*(r00)*(x345));
IkReal x385=((cj0)*(x369)*(x376));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j4)), IkReal(6.28318530717959))));
evalcond[1]=((x378)+(((IkReal(-1.00000000000000))*(x351))));
evalcond[2]=((IkReal(-1.00000000000000))+(x357)+(((IkReal(-1.00000000000000))*(x379))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x363)*(x377)))+(x358)+(((IkReal(-1.00000000000000))*(x347)*(x377))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r00)*(x354)))+(((IkReal(-1.00000000000000))*(x372)))+(((IkReal(-1.00000000000000))*(x347)*(x365))));
evalcond[5]=((IkReal(0.0236562500000000))+(x383)+(((IkReal(0.150000000000000))*(x375)))+(((cj0)*(x355)))+(((IkReal(-1.00000000000000))*(pp)))+(((IkReal(0.600000000000000))*(px)*(x354)))+(((x368)*(x375)))+(((cj1)*(x367)))+(((IkReal(-0.0450000000000000))*(sj1))));
evalcond[6]=((((IkReal(0.300000000000000))*(x372)))+(((IkReal(-1.00000000000000))*(r02)*(x361)))+(((x354)*(x360)))+(((IkReal(-1.00000000000000))*(x350)))+(((IkReal(-1.00000000000000))*(x359)))+(((IkReal(0.0750000000000000))*(x363)))+(((IkReal(0.0750000000000000))*(x347)))+(((IkReal(0.300000000000000))*(sj1)*(x347))));
evalcond[7]=((((r02)*(x373)))+(((IkReal(-1.00000000000000))*(x361)*(x363)))+(x380)+(((IkReal(-1.00000000000000))*(x347)*(x361)))+(((IkReal(0.300000000000000))*(cj1)*(x347)))+(((x360)*(x364)))+(((IkReal(-0.0750000000000000))*(r02)))+(((IkReal(-0.300000000000000))*(x358))));
evalcond[8]=((IkReal(-0.119281250000000))+(((IkReal(2.00000000000000))*(x351)*(x376)))+(((IkReal(-2.00000000000000))*(x376)*(x378)))+(((IkReal(-1.00000000000000))*(x383)))+(((IkReal(-0.0450000000000000))*(sj0)*(x362)))+(((IkReal(-1.00000000000000))*(cj0)*(x348)*(x369)))+(((IkReal(-2.00000000000000))*(x344)*(x357)))+(((py)*(x352)*(x364)))+(((IkReal(-1.00000000000000))*(sj0)*(x366)))+(((IkReal(0.0450000000000000))*(r01)*(x354)))+(((x348)*(x368)))+(((IkReal(-1.00000000000000))*(cj1)*(x351)*(x352)))+(((IkReal(-1.00000000000000))*(cj1)*(x357)*(x367)))+(((IkReal(-1.00000000000000))*(r01)*(x355)))+(((IkReal(0.150000000000000))*(x348)))+(((IkReal(2.00000000000000))*(x345)*(x379)))+(((IkReal(-1.00000000000000))*(px)*(r01)*(x368)))+(((cj1)*(x367)*(x379)))+(((py)*(x347)*(x369)))+(((IkReal(-1.00000000000000))*(pp)*(x379)))+(((pp)*(x357)))+(((IkReal(0.0956250000000000))*(x357))));
evalcond[9]=((((IkReal(2.00000000000000))*(x349)*(x380)))+(((IkReal(-1.00000000000000))*(x354)*(x382)))+(((IkReal(0.0956250000000000))*(sj1)*(x347)))+(((IkReal(-1.00000000000000))*(pp)*(x347)*(x365)))+(((IkReal(0.0843750000000000))*(x372)))+(((IkReal(-0.600000000000000))*(x359)))+(((IkReal(0.0450000000000000))*(x347)))+(((IkReal(-1.00000000000000))*(pz)*(x347)*(x353)))+(((r02)*(x353)*(x373)))+(((IkReal(-1.00000000000000))*(pz)*(x352)))+(((r02)*(x346)*(x356)))+(((IkReal(0.0450000000000000))*(x363)))+(((IkReal(-1.00000000000000))*(x350)*(x371)))+(((x348)*(x351)*(x370)))+(((IkReal(-0.150000000000000))*(r02)*(x349)))+(((IkReal(-0.600000000000000))*(x350)))+(((x344)*(x347)*(x370)))+(((x354)*(x366)))+(((IkReal(-1.00000000000000))*(pp)*(x372)))+(((IkReal(-1.00000000000000))*(x355)*(x362)))+(((x354)*(x384)))+(((pz)*(x356)*(x359)))+(((x353)*(x380)))+(((pz)*(x350)*(x356)))+(((x350)*(x354)*(x369)))+(((IkReal(-1.00000000000000))*(pz)*(x353)*(x363)))+(((cj0)*(r02)*(x349)*(x369))));
evalcond[10]=((((IkReal(-1.00000000000000))*(x353)*(x359)))+(((x356)*(x375)*(x376)))+(((IkReal(-1.00000000000000))*(x363)*(x381)))+(((IkReal(-2.00000000000000))*(x349)*(x350)))+(((IkReal(-0.150000000000000))*(x358)*(x375)))+(((x363)*(x367)))+(((IkReal(-1.00000000000000))*(x353)*(x376)))+(((x345)*(x356)*(x363)))+(((IkReal(0.0450000000000000))*(r02)))+(((IkReal(-2.00000000000000))*(x346)*(x358)))+(((IkReal(-1.00000000000000))*(x352)*(x375)))+(((IkReal(0.150000000000000))*(x347)*(x349)))+(((pp)*(x358)))+(((IkReal(0.0956250000000000))*(x358)))+(((x344)*(x347)*(x356)))+(((x356)*(x373)*(x376)))+(((x348)*(x351)*(x356)))+(((IkReal(-1.00000000000000))*(x363)*(x374)))+(((IkReal(0.150000000000000))*(x349)*(x363)))+(((IkReal(-1.00000000000000))*(x352)*(x373)))+(((IkReal(-1.00000000000000))*(x347)*(x374)))+(((x347)*(x367)))+(((IkReal(-1.00000000000000))*(r02)*(x354)*(x355)))+(((IkReal(-1.00000000000000))*(x347)*(x381)))+(((x350)*(x356)*(x373)))+(((IkReal(-1.00000000000000))*(x350)*(x353)))+(((IkReal(-2.00000000000000))*(x349)*(x359))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  && IKabs(evalcond[9]) < 0.0000010000000000  && IKabs(evalcond[10]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst4;
gconst4=IKsign(((IkReal(0.112881250000000))+(((IkReal(0.0524000000000000))*(cj3)))+(((IkReal(0.00640000000000000))*((sj3)*(sj3))))+(((IkReal(0.00640000000000000))*((cj3)*(cj3))))+(((IkReal(0.0120000000000000))*(sj3)))));
dummyeval[0]=((IkReal(17.6376953125000))+(((IkReal(8.18750000000000))*(cj3)))+((cj3)*(cj3))+(((IkReal(1.87500000000000))*(sj3)))+((sj3)*(sj3)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst5;
gconst5=IKsign(((IkReal(0.112881250000000))+(((IkReal(0.0524000000000000))*(cj3)))+(((IkReal(0.00640000000000000))*((sj3)*(sj3))))+(((IkReal(0.00640000000000000))*((cj3)*(cj3))))+(((IkReal(0.0120000000000000))*(sj3)))));
dummyeval[0]=((IkReal(17.6376953125000))+(((IkReal(8.18750000000000))*(cj3)))+((cj3)*(cj3))+(((IkReal(1.87500000000000))*(sj3)))+((sj3)*(sj3)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x386=((pz)*(r01));
IkReal x387=((py)*(r02));
IkReal x388=((cj1)*(r01));
IkReal x389=((IkReal(0.00600000000000000))*(cj0));
IkReal x390=((cj1)*(pz));
IkReal x391=((r00)*(sj0));
IkReal x392=((IkReal(0.0750000000000000))*(px));
IkReal x393=((cj0)*(sj1));
IkReal x394=((px)*(sj3));
IkReal x395=((IkReal(0.0800000000000000))*(sj3));
IkReal x396=((sj0)*(sj1));
IkReal x397=((IkReal(0.327500000000000))*(px));
IkReal x398=((IkReal(0.00600000000000000))*(cj1));
IkReal x399=((IkReal(0.0750000000000000))*(py));
IkReal x400=((IkReal(0.0800000000000000))*(cj3));
IkReal x401=((pz)*(sj1));
IkReal x402=((IkReal(0.00600000000000000))*(sj1));
IkReal x403=((IkReal(0.0800000000000000))*(x393));
IkReal x404=((sj1)*(x400));
IkReal x405=((cj1)*(py)*(r00));
IkReal x406=((IkReal(0.0800000000000000))*(px)*(r02)*(x396));
if( IKabs(((gconst5)*(((IkReal(-0.0982500000000000))+(((IkReal(0.0800000000000000))*(r02)*(x394)*(x396)))+(((px)*(x393)*(x400)))+(((IkReal(-0.0800000000000000))*(x388)*(x394)))+(((IkReal(-0.0750000000000000))*(x391)*(x401)))+(((sj3)*(x388)*(x389)))+(((IkReal(-1.00000000000000))*(x388)*(x392)))+(((x393)*(x397)))+(((IkReal(-0.00562500000000000))*(cj1)*(x391)))+(((IkReal(-0.0245625000000000))*(sj1)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((IkReal(-1.00000000000000))*(sj3)*(x391)*(x398)))+(((IkReal(0.327500000000000))*(py)*(x396)))+(((x395)*(x405)))+(((cj1)*(r00)*(x399)))+(((IkReal(-0.0750000000000000))*(x387)*(x393)))+(((IkReal(0.327500000000000))*(x390)))+(((x390)*(x400)))+(((IkReal(-1.00000000000000))*(x387)*(x393)*(x395)))+(((IkReal(0.00562500000000000))*(cj0)*(x388)))+(((py)*(x396)*(x400)))+(((r02)*(x392)*(x396)))+(((IkReal(0.0750000000000000))*(x386)*(x393)))+(((x386)*(x393)*(x395)))+(((IkReal(-1.00000000000000))*(cj3)*(x402)))+(((IkReal(-1.00000000000000))*(x391)*(x395)*(x401))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst5)*(((IkReal(-0.0225000000000000))+(((IkReal(-0.0240000000000000))*(sj3)))+(((x387)*(x393)*(x400)))+(((px)*(x388)*(x400)))+(((IkReal(-1.00000000000000))*(px)*(r02)*(x396)*(x400)))+(((IkReal(-0.327500000000000))*(x386)*(x393)))+(((IkReal(0.327500000000000))*(x391)*(x401)))+(((x391)*(x400)*(x401)))+(((IkReal(-1.00000000000000))*(r02)*(x396)*(x397)))+(((IkReal(0.0750000000000000))*(x390)))+(((IkReal(-1.00000000000000))*(x400)*(x405)))+(((IkReal(-0.327500000000000))*(x405)))+(((IkReal(-1.00000000000000))*(x386)*(x393)*(x400)))+(((x392)*(x393)))+(((cj3)*(x391)*(x398)))+(((x396)*(x399)))+(((IkReal(-1.00000000000000))*(sj3)*(x402)))+(((IkReal(0.0245625000000000))*(cj1)*(x391)))+(((x390)*(x395)))+(((py)*(x395)*(x396)))+(((IkReal(0.327500000000000))*(x387)*(x393)))+(((x394)*(x403)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((x388)*(x397)))+(((IkReal(-0.0245625000000000))*(cj0)*(x388)))+(((IkReal(-1.00000000000000))*(cj3)*(x388)*(x389))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst5)*(((IkReal(-0.0982500000000000))+(((IkReal(0.0800000000000000))*(r02)*(x394)*(x396)))+(((px)*(x393)*(x400)))+(((IkReal(-0.0800000000000000))*(x388)*(x394)))+(((IkReal(-0.0750000000000000))*(x391)*(x401)))+(((sj3)*(x388)*(x389)))+(((IkReal(-1.00000000000000))*(x388)*(x392)))+(((x393)*(x397)))+(((IkReal(-0.00562500000000000))*(cj1)*(x391)))+(((IkReal(-0.0245625000000000))*(sj1)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((IkReal(-1.00000000000000))*(sj3)*(x391)*(x398)))+(((IkReal(0.327500000000000))*(py)*(x396)))+(((x395)*(x405)))+(((cj1)*(r00)*(x399)))+(((IkReal(-0.0750000000000000))*(x387)*(x393)))+(((IkReal(0.327500000000000))*(x390)))+(((x390)*(x400)))+(((IkReal(-1.00000000000000))*(x387)*(x393)*(x395)))+(((IkReal(0.00562500000000000))*(cj0)*(x388)))+(((py)*(x396)*(x400)))+(((r02)*(x392)*(x396)))+(((IkReal(0.0750000000000000))*(x386)*(x393)))+(((x386)*(x393)*(x395)))+(((IkReal(-1.00000000000000))*(cj3)*(x402)))+(((IkReal(-1.00000000000000))*(x391)*(x395)*(x401)))))), ((gconst5)*(((IkReal(-0.0225000000000000))+(((IkReal(-0.0240000000000000))*(sj3)))+(((x387)*(x393)*(x400)))+(((px)*(x388)*(x400)))+(((IkReal(-1.00000000000000))*(px)*(r02)*(x396)*(x400)))+(((IkReal(-0.327500000000000))*(x386)*(x393)))+(((IkReal(0.327500000000000))*(x391)*(x401)))+(((x391)*(x400)*(x401)))+(((IkReal(-1.00000000000000))*(r02)*(x396)*(x397)))+(((IkReal(0.0750000000000000))*(x390)))+(((IkReal(-1.00000000000000))*(x400)*(x405)))+(((IkReal(-0.327500000000000))*(x405)))+(((IkReal(-1.00000000000000))*(x386)*(x393)*(x400)))+(((x392)*(x393)))+(((cj3)*(x391)*(x398)))+(((x396)*(x399)))+(((IkReal(-1.00000000000000))*(sj3)*(x402)))+(((IkReal(0.0245625000000000))*(cj1)*(x391)))+(((x390)*(x395)))+(((py)*(x395)*(x396)))+(((IkReal(0.327500000000000))*(x387)*(x393)))+(((x394)*(x403)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((x388)*(x397)))+(((IkReal(-0.0245625000000000))*(cj0)*(x388)))+(((IkReal(-1.00000000000000))*(cj3)*(x388)*(x389)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x407=IKcos(j2);
IkReal x408=IKsin(j2);
IkReal x409=((IkReal(0.0800000000000000))*(sj3));
IkReal x410=((cj0)*(r01));
IkReal x411=((IkReal(1.00000000000000))*(px));
IkReal x412=((py)*(sj1));
IkReal x413=((cj0)*(r02));
IkReal x414=((IkReal(0.0750000000000000))*(cj1));
IkReal x415=((r02)*(sj0));
IkReal x416=((IkReal(0.0750000000000000))*(sj1));
IkReal x417=((cj1)*(pz));
IkReal x418=((r00)*(sj0));
IkReal x419=((IkReal(0.0800000000000000))*(cj3));
IkReal x420=((pz)*(sj1));
IkReal x421=((IkReal(1.00000000000000))*(sj0));
IkReal x422=((cj1)*(py));
IkReal x423=((IkReal(0.0750000000000000))*(x408));
IkReal x424=((IkReal(0.327500000000000))*(x407));
IkReal x425=((IkReal(0.0750000000000000))*(x407));
IkReal x426=((IkReal(0.327500000000000))*(x408));
IkReal x427=((sj1)*(x418));
IkReal x428=((x408)*(x409));
IkReal x429=((x407)*(x419));
IkReal x430=((x407)*(x409));
IkReal x431=((x408)*(x419));
IkReal x432=((x428)+(x423));
IkReal x433=((x429)+(x424));
IkReal x434=((x430)+(x431)+(x426)+(x425));
evalcond[0]=((x433)+(x420)+(((IkReal(-1.00000000000000))*(cj0)*(cj1)*(x411)))+(((IkReal(-1.00000000000000))*(x421)*(x422)))+(((IkReal(-1.00000000000000))*(x432)))+(x414));
evalcond[1]=((IkReal(0.300000000000000))+(((IkReal(-1.00000000000000))*(x412)*(x421)))+(x434)+(((IkReal(-1.00000000000000))*(cj0)*(sj1)*(x411)))+(((IkReal(-1.00000000000000))*(x417)))+(x416));
evalcond[2]=((((IkReal(-1.00000000000000))*(x410)*(x414)))+(((x412)*(x413)))+(x432)+(((x418)*(x420)))+(((IkReal(-1.00000000000000))*(r00)*(x422)))+(((cj1)*(px)*(r01)))+(((IkReal(-1.00000000000000))*(x410)*(x420)))+(((x414)*(x418)))+(((IkReal(-1.00000000000000))*(x433)))+(((IkReal(-1.00000000000000))*(sj1)*(x411)*(x415))));
evalcond[3]=((x434)+(((IkReal(-0.300000000000000))*(x418)))+(((IkReal(-1.00000000000000))*(x416)*(x418)))+(((x413)*(x422)))+(((IkReal(-1.00000000000000))*(x410)*(x417)))+(((IkReal(0.300000000000000))*(x410)))+(((IkReal(-1.00000000000000))*(r01)*(sj1)*(x411)))+(((x417)*(x418)))+(((IkReal(-1.00000000000000))*(cj1)*(x411)*(x415)))+(((r00)*(x412)))+(((x410)*(x416))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x435=((IkReal(0.0800000000000000))*(cj1));
IkReal x436=((cj0)*(px));
IkReal x437=((py)*(sj0));
IkReal x438=((IkReal(0.0750000000000000))*(cj1));
IkReal x439=((IkReal(0.327500000000000))*(cj1));
IkReal x440=((IkReal(0.327500000000000))*(sj1));
IkReal x441=((IkReal(0.0750000000000000))*(sj1));
IkReal x442=((IkReal(0.00600000000000000))*(sj1));
IkReal x443=((IkReal(0.00600000000000000))*(cj1));
IkReal x444=((IkReal(0.0800000000000000))*(sj1)*(sj3));
IkReal x445=((IkReal(0.0800000000000000))*(cj3)*(sj1));
if( IKabs(((gconst4)*(((IkReal(-0.0982500000000000))+(((IkReal(-1.00000000000000))*(cj3)*(x442)))+(((pz)*(x439)))+(((x437)*(x440)))+(((x437)*(x445)))+(((IkReal(-0.0245625000000000))*(sj1)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((pz)*(x441)))+(((x436)*(x440)))+(((IkReal(-1.00000000000000))*(x436)*(x438)))+(((IkReal(-1.00000000000000))*(x437)*(x438)))+(((cj3)*(pz)*(x435)))+(((IkReal(-1.00000000000000))*(sj3)*(x435)*(x436)))+(((IkReal(-1.00000000000000))*(sj3)*(x435)*(x437)))+(((IkReal(0.00562500000000000))*(cj1)))+(((pz)*(x444)))+(((x436)*(x445)))+(((sj3)*(x443))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst4)*(((IkReal(-0.0225000000000000))+(((IkReal(-0.0240000000000000))*(sj3)))+(((pz)*(sj3)*(x435)))+(((x436)*(x441)))+(((x436)*(x439)))+(((cj3)*(x435)*(x437)))+(((x436)*(x444)))+(((IkReal(-1.00000000000000))*(pz)*(x440)))+(((IkReal(-1.00000000000000))*(pz)*(x445)))+(((IkReal(-1.00000000000000))*(cj3)*(x443)))+(((cj3)*(x435)*(x436)))+(((x437)*(x444)))+(((IkReal(-1.00000000000000))*(sj3)*(x442)))+(((x437)*(x439)))+(((pz)*(x438)))+(((IkReal(-0.0245625000000000))*(cj1)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((x437)*(x441))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst4)*(((IkReal(-0.0982500000000000))+(((IkReal(-1.00000000000000))*(cj3)*(x442)))+(((pz)*(x439)))+(((x437)*(x440)))+(((x437)*(x445)))+(((IkReal(-0.0245625000000000))*(sj1)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((pz)*(x441)))+(((x436)*(x440)))+(((IkReal(-1.00000000000000))*(x436)*(x438)))+(((IkReal(-1.00000000000000))*(x437)*(x438)))+(((cj3)*(pz)*(x435)))+(((IkReal(-1.00000000000000))*(sj3)*(x435)*(x436)))+(((IkReal(-1.00000000000000))*(sj3)*(x435)*(x437)))+(((IkReal(0.00562500000000000))*(cj1)))+(((pz)*(x444)))+(((x436)*(x445)))+(((sj3)*(x443)))))), ((gconst4)*(((IkReal(-0.0225000000000000))+(((IkReal(-0.0240000000000000))*(sj3)))+(((pz)*(sj3)*(x435)))+(((x436)*(x441)))+(((x436)*(x439)))+(((cj3)*(x435)*(x437)))+(((x436)*(x444)))+(((IkReal(-1.00000000000000))*(pz)*(x440)))+(((IkReal(-1.00000000000000))*(pz)*(x445)))+(((IkReal(-1.00000000000000))*(cj3)*(x443)))+(((cj3)*(x435)*(x436)))+(((x437)*(x444)))+(((IkReal(-1.00000000000000))*(sj3)*(x442)))+(((x437)*(x439)))+(((pz)*(x438)))+(((IkReal(-0.0245625000000000))*(cj1)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((x437)*(x441)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x446=IKcos(j2);
IkReal x447=IKsin(j2);
IkReal x448=((IkReal(0.0800000000000000))*(sj3));
IkReal x449=((cj0)*(r01));
IkReal x450=((IkReal(1.00000000000000))*(px));
IkReal x451=((py)*(sj1));
IkReal x452=((cj0)*(r02));
IkReal x453=((IkReal(0.0750000000000000))*(cj1));
IkReal x454=((r02)*(sj0));
IkReal x455=((IkReal(0.0750000000000000))*(sj1));
IkReal x456=((cj1)*(pz));
IkReal x457=((r00)*(sj0));
IkReal x458=((IkReal(0.0800000000000000))*(cj3));
IkReal x459=((pz)*(sj1));
IkReal x460=((IkReal(1.00000000000000))*(sj0));
IkReal x461=((cj1)*(py));
IkReal x462=((IkReal(0.0750000000000000))*(x447));
IkReal x463=((IkReal(0.327500000000000))*(x446));
IkReal x464=((IkReal(0.0750000000000000))*(x446));
IkReal x465=((IkReal(0.327500000000000))*(x447));
IkReal x466=((sj1)*(x457));
IkReal x467=((x447)*(x448));
IkReal x468=((x446)*(x458));
IkReal x469=((x446)*(x448));
IkReal x470=((x447)*(x458));
IkReal x471=((x462)+(x467));
IkReal x472=((x468)+(x463));
IkReal x473=((x470)+(x469)+(x465)+(x464));
evalcond[0]=((((IkReal(-1.00000000000000))*(x460)*(x461)))+(x472)+(x459)+(x453)+(((IkReal(-1.00000000000000))*(cj0)*(cj1)*(x450)))+(((IkReal(-1.00000000000000))*(x471))));
evalcond[1]=((IkReal(0.300000000000000))+(x473)+(((IkReal(-1.00000000000000))*(x456)))+(x455)+(((IkReal(-1.00000000000000))*(x451)*(x460)))+(((IkReal(-1.00000000000000))*(cj0)*(sj1)*(x450))));
evalcond[2]=((x471)+(((IkReal(-1.00000000000000))*(x449)*(x453)))+(((IkReal(-1.00000000000000))*(sj1)*(x450)*(x454)))+(((IkReal(-1.00000000000000))*(x449)*(x459)))+(((cj1)*(px)*(r01)))+(((x457)*(x459)))+(((x453)*(x457)))+(((x451)*(x452)))+(((IkReal(-1.00000000000000))*(r00)*(x461)))+(((IkReal(-1.00000000000000))*(x472))));
evalcond[3]=((((x452)*(x461)))+(x473)+(((x456)*(x457)))+(((IkReal(-1.00000000000000))*(r01)*(sj1)*(x450)))+(((IkReal(-0.300000000000000))*(x457)))+(((IkReal(-1.00000000000000))*(cj1)*(x450)*(x454)))+(((r00)*(x451)))+(((x449)*(x455)))+(((IkReal(-1.00000000000000))*(x455)*(x457)))+(((IkReal(-1.00000000000000))*(x449)*(x456)))+(((IkReal(0.300000000000000))*(x449))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
IkReal x474=((IkReal(0.0524000000000000))*(cj3));
IkReal x475=((IkReal(0.0120000000000000))*(sj3));
IkReal x476=(py)*(py);
IkReal x477=(px)*(px);
IkReal x478=(pz)*(pz);
IkReal x479=((r01)*(sj0));
IkReal x480=((py)*(r00));
IkReal x481=((pz)*(sj1));
IkReal x482=((py)*(r01));
IkReal x483=((px)*(sj0));
IkReal x484=((IkReal(0.600000000000000))*(r02));
IkReal x485=((IkReal(0.150000000000000))*(cj1));
IkReal x486=((cj0)*(sj1));
IkReal x487=((IkReal(0.150000000000000))*(px));
IkReal x488=((IkReal(2.00000000000000))*(cj1));
IkReal x489=((cj0)*(r01));
IkReal x490=((r02)*(sj1));
IkReal x491=((px)*(r00));
IkReal x492=((IkReal(0.300000000000000))*(r00));
IkReal x493=((IkReal(1.00000000000000))*(pz));
IkReal x494=((r00)*(sj1));
IkReal x495=((cj0)*(r00));
IkReal x496=((cj0)*(cj1));
IkReal x497=((IkReal(1.00000000000000))*(sj1));
IkReal x498=((IkReal(0.0956250000000000))*(r00));
IkReal x499=((IkReal(0.600000000000000))*(pz));
IkReal x500=((IkReal(0.600000000000000))*(sj1));
IkReal x501=((IkReal(2.00000000000000))*(px));
IkReal x502=((IkReal(2.00000000000000))*(sj1));
IkReal x503=((IkReal(0.150000000000000))*(sj1));
IkReal x504=((cj1)*(r02));
IkReal x505=((cj0)*(px));
IkReal x506=((IkReal(0.0843750000000000))*(cj1));
IkReal x507=((py)*(sj0));
IkReal x508=((pz)*(r02));
IkReal x509=((IkReal(1.00000000000000))*(cj1));
IkReal x510=((cj0)*(py));
IkReal x511=((r00)*(sj0));
IkReal x512=((r02)*(x507));
IkReal x513=((pp)*(x509));
IkReal x514=((IkReal(1.00000000000000))*(pp)*(r00));
IkReal x515=((x474)+(x475));
IkReal x516=((IkReal(2.00000000000000))*(r00)*(x477));
IkReal x517=((cj0)*(x501)*(x508));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j4)), IkReal(6.28318530717959))));
evalcond[1]=((x510)+(((IkReal(-1.00000000000000))*(x483))));
evalcond[2]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x511)))+(x489));
evalcond[3]=((((IkReal(-1.00000000000000))*(x495)*(x509)))+(((IkReal(-1.00000000000000))*(x479)*(x509)))+(x490));
evalcond[4]=((((IkReal(-1.00000000000000))*(r00)*(x486)))+(((IkReal(-1.00000000000000))*(x504)))+(((IkReal(-1.00000000000000))*(x479)*(x497))));
evalcond[5]=((IkReal(0.0236562500000000))+(((x500)*(x507)))+(((IkReal(0.600000000000000))*(px)*(x486)))+(x515)+(((cj1)*(x499)))+(((IkReal(-1.00000000000000))*(pp)))+(((IkReal(0.150000000000000))*(x507)))+(((cj0)*(x487)))+(((IkReal(-0.0450000000000000))*(sj1))));
evalcond[6]=((((IkReal(0.300000000000000))*(sj1)*(x479)))+(((IkReal(0.0750000000000000))*(x495)))+(((IkReal(-1.00000000000000))*(r02)*(x493)))+(((x486)*(x492)))+(((IkReal(-1.00000000000000))*(x482)))+(((IkReal(0.300000000000000))*(x504)))+(((IkReal(0.0750000000000000))*(x479)))+(((IkReal(-1.00000000000000))*(x491))));
evalcond[7]=((x512)+(((IkReal(-1.00000000000000))*(x479)*(x493)))+(((x492)*(x496)))+(((r02)*(x505)))+(((IkReal(-0.300000000000000))*(x490)))+(((IkReal(-1.00000000000000))*(x493)*(x495)))+(((IkReal(-0.0750000000000000))*(r02)))+(((IkReal(0.300000000000000))*(cj1)*(x479))));
evalcond[8]=((IkReal(0.119281250000000))+(((x480)*(x500)))+(((pp)*(x489)))+(((IkReal(-1.00000000000000))*(pp)*(x511)))+(((IkReal(2.00000000000000))*(x477)*(x511)))+(x515)+(((IkReal(-1.00000000000000))*(cj1)*(x489)*(x499)))+(((py)*(x484)*(x496)))+(((py)*(x479)*(x501)))+(((IkReal(2.00000000000000))*(x483)*(x508)))+(((IkReal(-1.00000000000000))*(cj0)*(x480)*(x501)))+(((IkReal(0.0956250000000000))*(x489)))+(((IkReal(0.0450000000000000))*(r01)*(x486)))+(((IkReal(-1.00000000000000))*(r01)*(x487)))+(((IkReal(-1.00000000000000))*(cj1)*(x483)*(x484)))+(((IkReal(-0.0450000000000000))*(sj0)*(x494)))+(((IkReal(-2.00000000000000))*(x476)*(x489)))+(((IkReal(-1.00000000000000))*(px)*(r01)*(x500)))+(((IkReal(0.150000000000000))*(x480)))+(((IkReal(-1.00000000000000))*(sj0)*(x498)))+(((cj1)*(x499)*(x511)))+(((IkReal(-2.00000000000000))*(x508)*(x510))));
evalcond[9]=((((IkReal(-0.150000000000000))*(r02)*(x481)))+(((x486)*(x516)))+(((r02)*(x485)*(x505)))+(((IkReal(-1.00000000000000))*(pz)*(x485)*(x495)))+(((x485)*(x512)))+(((pz)*(x488)*(x491)))+(((x480)*(x483)*(x502)))+(((IkReal(2.00000000000000))*(x481)*(x512)))+(((x486)*(x498)))+(((IkReal(-0.600000000000000))*(x482)))+(((IkReal(-1.00000000000000))*(pz)*(x484)))+(((r02)*(x478)*(x488)))+(((x482)*(x486)*(x501)))+(((IkReal(-1.00000000000000))*(pz)*(x479)*(x485)))+(((IkReal(-1.00000000000000))*(pp)*(x504)))+(((IkReal(0.0450000000000000))*(x479)))+(((IkReal(-1.00000000000000))*(x486)*(x514)))+(((x476)*(x479)*(x502)))+(((IkReal(0.0956250000000000))*(sj1)*(x479)))+(((cj0)*(r02)*(x481)*(x501)))+(((IkReal(-0.600000000000000))*(x491)))+(((IkReal(0.0450000000000000))*(x495)))+(((pz)*(x482)*(x488)))+(((IkReal(-1.00000000000000))*(x482)*(x503)))+(((IkReal(0.0843750000000000))*(x504)))+(((IkReal(-1.00000000000000))*(pp)*(x479)*(x497)))+(((IkReal(-1.00000000000000))*(x487)*(x494))));
evalcond[10]=((((x477)*(x488)*(x495)))+(((IkReal(-1.00000000000000))*(x485)*(x508)))+(((x476)*(x479)*(x488)))+(((x495)*(x499)))+(((x480)*(x483)*(x488)))+(((IkReal(0.0450000000000000))*(r02)))+(((IkReal(0.150000000000000))*(x481)*(x495)))+(((IkReal(-1.00000000000000))*(x479)*(x513)))+(((IkReal(-2.00000000000000))*(x478)*(x490)))+(((IkReal(-1.00000000000000))*(x479)*(x506)))+(((IkReal(-1.00000000000000))*(x484)*(x507)))+(((IkReal(-1.00000000000000))*(x484)*(x505)))+(((IkReal(0.0956250000000000))*(x490)))+(((IkReal(0.150000000000000))*(x479)*(x481)))+(((IkReal(-1.00000000000000))*(x485)*(x491)))+(((IkReal(-0.150000000000000))*(x490)*(x507)))+(((pp)*(x490)))+(((IkReal(-1.00000000000000))*(r02)*(x486)*(x487)))+(((IkReal(-2.00000000000000))*(x481)*(x482)))+(((x479)*(x499)))+(((x482)*(x488)*(x505)))+(((IkReal(-2.00000000000000))*(x481)*(x491)))+(((IkReal(-1.00000000000000))*(x495)*(x506)))+(((x488)*(x507)*(x508)))+(((IkReal(-1.00000000000000))*(x482)*(x485)))+(((IkReal(-1.00000000000000))*(x495)*(x513)))+(((x488)*(x505)*(x508))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  && IKabs(evalcond[9]) < 0.0000010000000000  && IKabs(evalcond[10]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst6;
gconst6=IKsign(((IkReal(0.112881250000000))+(((IkReal(0.0524000000000000))*(cj3)))+(((IkReal(0.00640000000000000))*((sj3)*(sj3))))+(((IkReal(0.00640000000000000))*((cj3)*(cj3))))+(((IkReal(0.0120000000000000))*(sj3)))));
dummyeval[0]=((IkReal(17.6376953125000))+(((IkReal(8.18750000000000))*(cj3)))+((cj3)*(cj3))+(((IkReal(1.87500000000000))*(sj3)))+((sj3)*(sj3)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst7;
gconst7=IKsign(((IkReal(-0.112881250000000))+(((IkReal(-0.00640000000000000))*((sj3)*(sj3))))+(((IkReal(-0.0120000000000000))*(sj3)))+(((IkReal(-0.00640000000000000))*((cj3)*(cj3))))+(((IkReal(-0.0524000000000000))*(cj3)))));
dummyeval[0]=((IkReal(-17.6376953125000))+(((IkReal(-1.87500000000000))*(sj3)))+(((IkReal(-1.00000000000000))*((cj3)*(cj3))))+(((IkReal(-8.18750000000000))*(cj3)))+(((IkReal(-1.00000000000000))*((sj3)*(sj3)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x518=((cj0)*(r01));
IkReal x519=((pz)*(sj1));
IkReal x520=((IkReal(0.0800000000000000))*(sj3));
IkReal x521=((IkReal(0.00600000000000000))*(cj1));
IkReal x522=((IkReal(0.0750000000000000))*(cj1));
IkReal x523=((r00)*(sj0));
IkReal x524=((IkReal(0.0245625000000000))*(cj1));
IkReal x525=((px)*(r01));
IkReal x526=((IkReal(0.00562500000000000))*(cj1));
IkReal x527=((IkReal(0.0800000000000000))*(cj3));
IkReal x528=((cj1)*(pz));
IkReal x529=((px)*(r02));
IkReal x530=((py)*(sj1));
IkReal x531=((cj0)*(r02));
IkReal x532=((IkReal(0.00600000000000000))*(sj1));
IkReal x533=((IkReal(0.327500000000000))*(sj0));
IkReal x534=((IkReal(0.0750000000000000))*(sj0)*(sj1));
IkReal x535=((cj0)*(px)*(sj1));
IkReal x536=((cj1)*(py)*(r00));
IkReal x537=((IkReal(0.0800000000000000))*(sj0)*(sj1)*(x529));
if( IKabs(((gconst7)*(((IkReal(0.0982500000000000))+(((IkReal(-1.00000000000000))*(sj0)*(x527)*(x530)))+(((sj0)*(sj1)*(x520)*(x529)))+(((IkReal(-0.327500000000000))*(x528)))+(((IkReal(-1.00000000000000))*(x522)*(x525)))+(((IkReal(-1.00000000000000))*(x527)*(x528)))+(((IkReal(-1.00000000000000))*(x520)*(x530)*(x531)))+(((IkReal(-1.00000000000000))*(x523)*(x526)))+(((IkReal(-1.00000000000000))*(x527)*(x535)))+(((IkReal(-0.327500000000000))*(x535)))+(((IkReal(-0.0750000000000000))*(x519)*(x523)))+(((IkReal(-0.0750000000000000))*(x530)*(x531)))+(((IkReal(-1.00000000000000))*(cj1)*(x520)*(x525)))+(((IkReal(-1.00000000000000))*(x519)*(x520)*(x523)))+(((IkReal(0.0245625000000000))*(sj1)))+(((py)*(r00)*(x522)))+(((sj3)*(x518)*(x521)))+(((IkReal(-1.00000000000000))*(x530)*(x533)))+(((x529)*(x534)))+(((IkReal(-1.00000000000000))*(sj3)*(x521)*(x523)))+(((cj3)*(x532)))+(((x518)*(x519)*(x520)))+(((x518)*(x526)))+(((IkReal(0.0240000000000000))*(cj3)))+(((x520)*(x536)))+(((IkReal(0.0750000000000000))*(x518)*(x519))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst7)*(((IkReal(0.0225000000000000))+(((IkReal(-0.0750000000000000))*(sj0)*(x530)))+(((x527)*(x530)*(x531)))+(((IkReal(-1.00000000000000))*(sj1)*(x529)*(x533)))+(((IkReal(0.00562500000000000))*(sj1)))+(((IkReal(0.327500000000000))*(x519)*(x523)))+(((IkReal(-1.00000000000000))*(sj0)*(x520)*(x530)))+(((IkReal(-1.00000000000000))*(x520)*(x528)))+(((IkReal(-0.327500000000000))*(x536)))+(((cj1)*(x525)*(x527)))+(((IkReal(-1.00000000000000))*(pz)*(x522)))+(((IkReal(0.327500000000000))*(cj1)*(x525)))+(((x523)*(x524)))+(((IkReal(0.327500000000000))*(x530)*(x531)))+(((IkReal(-1.00000000000000))*(sj0)*(sj1)*(x527)*(x529)))+(((cj3)*(x521)*(x523)))+(((IkReal(-0.0750000000000000))*(x535)))+(((IkReal(-1.00000000000000))*(x527)*(x536)))+(((IkReal(-1.00000000000000))*(cj3)*(x518)*(x521)))+(((IkReal(-1.00000000000000))*(x518)*(x519)*(x527)))+(((sj3)*(x532)))+(((IkReal(-1.00000000000000))*(x518)*(x524)))+(((IkReal(-0.327500000000000))*(x518)*(x519)))+(((IkReal(-1.00000000000000))*(x520)*(x535)))+(((IkReal(0.0240000000000000))*(sj3)))+(((x519)*(x523)*(x527))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst7)*(((IkReal(0.0982500000000000))+(((IkReal(-1.00000000000000))*(sj0)*(x527)*(x530)))+(((sj0)*(sj1)*(x520)*(x529)))+(((IkReal(-0.327500000000000))*(x528)))+(((IkReal(-1.00000000000000))*(x522)*(x525)))+(((IkReal(-1.00000000000000))*(x527)*(x528)))+(((IkReal(-1.00000000000000))*(x520)*(x530)*(x531)))+(((IkReal(-1.00000000000000))*(x523)*(x526)))+(((IkReal(-1.00000000000000))*(x527)*(x535)))+(((IkReal(-0.327500000000000))*(x535)))+(((IkReal(-0.0750000000000000))*(x519)*(x523)))+(((IkReal(-0.0750000000000000))*(x530)*(x531)))+(((IkReal(-1.00000000000000))*(cj1)*(x520)*(x525)))+(((IkReal(-1.00000000000000))*(x519)*(x520)*(x523)))+(((IkReal(0.0245625000000000))*(sj1)))+(((py)*(r00)*(x522)))+(((sj3)*(x518)*(x521)))+(((IkReal(-1.00000000000000))*(x530)*(x533)))+(((x529)*(x534)))+(((IkReal(-1.00000000000000))*(sj3)*(x521)*(x523)))+(((cj3)*(x532)))+(((x518)*(x519)*(x520)))+(((x518)*(x526)))+(((IkReal(0.0240000000000000))*(cj3)))+(((x520)*(x536)))+(((IkReal(0.0750000000000000))*(x518)*(x519)))))), ((gconst7)*(((IkReal(0.0225000000000000))+(((IkReal(-0.0750000000000000))*(sj0)*(x530)))+(((x527)*(x530)*(x531)))+(((IkReal(-1.00000000000000))*(sj1)*(x529)*(x533)))+(((IkReal(0.00562500000000000))*(sj1)))+(((IkReal(0.327500000000000))*(x519)*(x523)))+(((IkReal(-1.00000000000000))*(sj0)*(x520)*(x530)))+(((IkReal(-1.00000000000000))*(x520)*(x528)))+(((IkReal(-0.327500000000000))*(x536)))+(((cj1)*(x525)*(x527)))+(((IkReal(-1.00000000000000))*(pz)*(x522)))+(((IkReal(0.327500000000000))*(cj1)*(x525)))+(((x523)*(x524)))+(((IkReal(0.327500000000000))*(x530)*(x531)))+(((IkReal(-1.00000000000000))*(sj0)*(sj1)*(x527)*(x529)))+(((cj3)*(x521)*(x523)))+(((IkReal(-0.0750000000000000))*(x535)))+(((IkReal(-1.00000000000000))*(x527)*(x536)))+(((IkReal(-1.00000000000000))*(cj3)*(x518)*(x521)))+(((IkReal(-1.00000000000000))*(x518)*(x519)*(x527)))+(((sj3)*(x532)))+(((IkReal(-1.00000000000000))*(x518)*(x524)))+(((IkReal(-0.327500000000000))*(x518)*(x519)))+(((IkReal(-1.00000000000000))*(x520)*(x535)))+(((IkReal(0.0240000000000000))*(sj3)))+(((x519)*(x523)*(x527)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x538=IKcos(j2);
IkReal x539=IKsin(j2);
IkReal x540=((IkReal(0.0800000000000000))*(sj3));
IkReal x541=((cj0)*(r01));
IkReal x542=((IkReal(1.00000000000000))*(px));
IkReal x543=((py)*(sj1));
IkReal x544=((cj0)*(r02));
IkReal x545=((IkReal(0.0750000000000000))*(cj1));
IkReal x546=((r02)*(sj0));
IkReal x547=((IkReal(0.0750000000000000))*(sj1));
IkReal x548=((cj1)*(pz));
IkReal x549=((r00)*(sj0));
IkReal x550=((IkReal(0.0800000000000000))*(cj3));
IkReal x551=((pz)*(sj1));
IkReal x552=((IkReal(1.00000000000000))*(sj0));
IkReal x553=((cj1)*(py));
IkReal x554=((IkReal(0.327500000000000))*(x538));
IkReal x555=((IkReal(0.0750000000000000))*(x539));
IkReal x556=((IkReal(0.0750000000000000))*(x538));
IkReal x557=((IkReal(0.327500000000000))*(x539));
IkReal x558=((sj1)*(x549));
IkReal x559=((x538)*(x550));
IkReal x560=((x539)*(x540));
IkReal x561=((x538)*(x540));
IkReal x562=((x539)*(x550));
IkReal x563=((x560)+(x555));
IkReal x564=((x559)+(x554));
IkReal x565=((x562)+(x561)+(x557)+(x556));
evalcond[0]=((((IkReal(-1.00000000000000))*(x552)*(x553)))+(x545)+(x564)+(((IkReal(-1.00000000000000))*(x563)))+(((IkReal(-1.00000000000000))*(cj0)*(cj1)*(x542)))+(x551));
evalcond[1]=((IkReal(0.300000000000000))+(x547)+(((IkReal(-1.00000000000000))*(x543)*(x552)))+(x565)+(((IkReal(-1.00000000000000))*(cj0)*(sj1)*(x542)))+(((IkReal(-1.00000000000000))*(x548))));
evalcond[2]=((((x549)*(x551)))+(((x545)*(x549)))+(x564)+(((IkReal(-1.00000000000000))*(x541)*(x545)))+(((IkReal(-1.00000000000000))*(x563)))+(((cj1)*(px)*(r01)))+(((x543)*(x544)))+(((IkReal(-1.00000000000000))*(sj1)*(x542)*(x546)))+(((IkReal(-1.00000000000000))*(r00)*(x553)))+(((IkReal(-1.00000000000000))*(x541)*(x551))));
evalcond[3]=((((IkReal(0.300000000000000))*(x541)))+(((IkReal(-1.00000000000000))*(x547)*(x549)))+(((IkReal(-0.300000000000000))*(x549)))+(((x548)*(x549)))+(((IkReal(-1.00000000000000))*(x541)*(x548)))+(((IkReal(-1.00000000000000))*(x565)))+(((IkReal(-1.00000000000000))*(cj1)*(x542)*(x546)))+(((IkReal(-1.00000000000000))*(r01)*(sj1)*(x542)))+(((r00)*(x543)))+(((x541)*(x547)))+(((x544)*(x553))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x566=((IkReal(0.0800000000000000))*(cj1));
IkReal x567=((cj0)*(px));
IkReal x568=((py)*(sj0));
IkReal x569=((IkReal(0.0750000000000000))*(cj1));
IkReal x570=((IkReal(0.327500000000000))*(cj1));
IkReal x571=((IkReal(0.327500000000000))*(sj1));
IkReal x572=((IkReal(0.0750000000000000))*(sj1));
IkReal x573=((IkReal(0.00600000000000000))*(sj1));
IkReal x574=((IkReal(0.00600000000000000))*(cj1));
IkReal x575=((IkReal(0.0800000000000000))*(sj1)*(sj3));
IkReal x576=((IkReal(0.0800000000000000))*(cj3)*(sj1));
if( IKabs(((gconst6)*(((IkReal(-0.0982500000000000))+(((x568)*(x576)))+(((IkReal(-1.00000000000000))*(x568)*(x569)))+(((IkReal(-1.00000000000000))*(cj3)*(x573)))+(((IkReal(-0.0245625000000000))*(sj1)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((x567)*(x576)))+(((pz)*(x575)))+(((pz)*(x570)))+(((sj3)*(x574)))+(((x567)*(x571)))+(((IkReal(-1.00000000000000))*(sj3)*(x566)*(x568)))+(((IkReal(0.00562500000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(x567)*(x569)))+(((x568)*(x571)))+(((cj3)*(pz)*(x566)))+(((pz)*(x572)))+(((IkReal(-1.00000000000000))*(sj3)*(x566)*(x567))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst6)*(((IkReal(-0.0225000000000000))+(((IkReal(-0.0240000000000000))*(sj3)))+(((x568)*(x572)))+(((IkReal(-1.00000000000000))*(pz)*(x571)))+(((x567)*(x572)))+(((IkReal(-1.00000000000000))*(sj3)*(x573)))+(((pz)*(x569)))+(((pz)*(sj3)*(x566)))+(((IkReal(-1.00000000000000))*(pz)*(x576)))+(((x568)*(x570)))+(((x568)*(x575)))+(((x567)*(x570)))+(((cj3)*(x566)*(x567)))+(((IkReal(-1.00000000000000))*(cj3)*(x574)))+(((IkReal(-0.0245625000000000))*(cj1)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((x567)*(x575)))+(((cj3)*(x566)*(x568))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst6)*(((IkReal(-0.0982500000000000))+(((x568)*(x576)))+(((IkReal(-1.00000000000000))*(x568)*(x569)))+(((IkReal(-1.00000000000000))*(cj3)*(x573)))+(((IkReal(-0.0245625000000000))*(sj1)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((x567)*(x576)))+(((pz)*(x575)))+(((pz)*(x570)))+(((sj3)*(x574)))+(((x567)*(x571)))+(((IkReal(-1.00000000000000))*(sj3)*(x566)*(x568)))+(((IkReal(0.00562500000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(x567)*(x569)))+(((x568)*(x571)))+(((cj3)*(pz)*(x566)))+(((pz)*(x572)))+(((IkReal(-1.00000000000000))*(sj3)*(x566)*(x567)))))), ((gconst6)*(((IkReal(-0.0225000000000000))+(((IkReal(-0.0240000000000000))*(sj3)))+(((x568)*(x572)))+(((IkReal(-1.00000000000000))*(pz)*(x571)))+(((x567)*(x572)))+(((IkReal(-1.00000000000000))*(sj3)*(x573)))+(((pz)*(x569)))+(((pz)*(sj3)*(x566)))+(((IkReal(-1.00000000000000))*(pz)*(x576)))+(((x568)*(x570)))+(((x568)*(x575)))+(((x567)*(x570)))+(((cj3)*(x566)*(x567)))+(((IkReal(-1.00000000000000))*(cj3)*(x574)))+(((IkReal(-0.0245625000000000))*(cj1)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((x567)*(x575)))+(((cj3)*(x566)*(x568)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x577=IKcos(j2);
IkReal x578=IKsin(j2);
IkReal x579=((IkReal(0.0800000000000000))*(sj3));
IkReal x580=((cj0)*(r01));
IkReal x581=((IkReal(1.00000000000000))*(px));
IkReal x582=((py)*(sj1));
IkReal x583=((cj0)*(r02));
IkReal x584=((IkReal(0.0750000000000000))*(cj1));
IkReal x585=((r02)*(sj0));
IkReal x586=((IkReal(0.0750000000000000))*(sj1));
IkReal x587=((cj1)*(pz));
IkReal x588=((r00)*(sj0));
IkReal x589=((IkReal(0.0800000000000000))*(cj3));
IkReal x590=((pz)*(sj1));
IkReal x591=((IkReal(1.00000000000000))*(sj0));
IkReal x592=((cj1)*(py));
IkReal x593=((IkReal(0.327500000000000))*(x577));
IkReal x594=((IkReal(0.0750000000000000))*(x578));
IkReal x595=((IkReal(0.0750000000000000))*(x577));
IkReal x596=((IkReal(0.327500000000000))*(x578));
IkReal x597=((sj1)*(x588));
IkReal x598=((x577)*(x589));
IkReal x599=((x578)*(x579));
IkReal x600=((x577)*(x579));
IkReal x601=((x578)*(x589));
IkReal x602=((x594)+(x599));
IkReal x603=((x593)+(x598));
IkReal x604=((x596)+(x595)+(x601)+(x600));
evalcond[0]=((((IkReal(-1.00000000000000))*(x591)*(x592)))+(((IkReal(-1.00000000000000))*(x602)))+(x590)+(x584)+(((IkReal(-1.00000000000000))*(cj0)*(cj1)*(x581)))+(x603));
evalcond[1]=((IkReal(0.300000000000000))+(((IkReal(-1.00000000000000))*(x582)*(x591)))+(((IkReal(-1.00000000000000))*(x587)))+(((IkReal(-1.00000000000000))*(cj0)*(sj1)*(x581)))+(x586)+(x604));
evalcond[2]=((((IkReal(-1.00000000000000))*(sj1)*(x581)*(x585)))+(((IkReal(-1.00000000000000))*(r00)*(x592)))+(((x584)*(x588)))+(((x588)*(x590)))+(((IkReal(-1.00000000000000))*(x580)*(x584)))+(((cj1)*(px)*(r01)))+(((x582)*(x583)))+(((IkReal(-1.00000000000000))*(x602)))+(((IkReal(-1.00000000000000))*(x580)*(x590)))+(x603));
evalcond[3]=((((IkReal(-1.00000000000000))*(x580)*(x587)))+(((IkReal(-0.300000000000000))*(x588)))+(((IkReal(-1.00000000000000))*(r01)*(sj1)*(x581)))+(((x583)*(x592)))+(((x587)*(x588)))+(((x580)*(x586)))+(((IkReal(-1.00000000000000))*(cj1)*(x581)*(x585)))+(((IkReal(-1.00000000000000))*(x604)))+(((r00)*(x582)))+(((IkReal(0.300000000000000))*(x580)))+(((IkReal(-1.00000000000000))*(x586)*(x588))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x605=((r02)*(sj1));
IkReal x606=((cj0)*(px));
IkReal x607=((IkReal(0.0800000000000000))*(sj3));
IkReal x608=((cj4)*(sj3));
IkReal x609=((pz)*(sj1));
IkReal x610=((IkReal(0.0800000000000000))*(cj3));
IkReal x611=((IkReal(1.00000000000000))*(cj1));
IkReal x612=((py)*(sj0));
IkReal x613=((cj1)*(r01)*(sj0));
IkReal x614=((cj1)*(cj3)*(cj4));
IkReal x615=((cj0)*(cj1)*(r00));
IkReal x616=((IkReal(0.0800000000000000))*(x615));
if( IKabs(((gconst3)*(((((IkReal(-1.00000000000000))*(x610)*(x615)))+(((IkReal(-0.327500000000000))*(x615)))+(((x605)*(x610)))+(((x608)*(x609)))+(((IkReal(-0.327500000000000))*(x613)))+(((IkReal(-1.00000000000000))*(x610)*(x613)))+(((IkReal(-1.00000000000000))*(x606)*(x608)*(x611)))+(((IkReal(-1.00000000000000))*(x608)*(x611)*(x612)))+(((IkReal(0.327500000000000))*(x605)))+(((IkReal(0.0750000000000000))*(cj1)*(x608))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst3)*(((((IkReal(-0.0750000000000000))*(x615)))+(((IkReal(-1.00000000000000))*(x607)*(x613)))+(((x606)*(x614)))+(((x612)*(x614)))+(((x605)*(x607)))+(((IkReal(-0.0750000000000000))*(x614)))+(((IkReal(-1.00000000000000))*(x607)*(x615)))+(((IkReal(0.0750000000000000))*(x605)))+(((IkReal(-1.00000000000000))*(cj3)*(cj4)*(x609)))+(((IkReal(-0.0750000000000000))*(x613))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst3)*(((((IkReal(-1.00000000000000))*(x610)*(x615)))+(((IkReal(-0.327500000000000))*(x615)))+(((x605)*(x610)))+(((x608)*(x609)))+(((IkReal(-0.327500000000000))*(x613)))+(((IkReal(-1.00000000000000))*(x610)*(x613)))+(((IkReal(-1.00000000000000))*(x606)*(x608)*(x611)))+(((IkReal(-1.00000000000000))*(x608)*(x611)*(x612)))+(((IkReal(0.327500000000000))*(x605)))+(((IkReal(0.0750000000000000))*(cj1)*(x608)))))), ((gconst3)*(((((IkReal(-0.0750000000000000))*(x615)))+(((IkReal(-1.00000000000000))*(x607)*(x613)))+(((x606)*(x614)))+(((x612)*(x614)))+(((x605)*(x607)))+(((IkReal(-0.0750000000000000))*(x614)))+(((IkReal(-1.00000000000000))*(x607)*(x615)))+(((IkReal(0.0750000000000000))*(x605)))+(((IkReal(-1.00000000000000))*(cj3)*(cj4)*(x609)))+(((IkReal(-0.0750000000000000))*(x613)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x617=IKcos(j2);
IkReal x618=IKsin(j2);
IkReal x619=(py)*(py);
IkReal x620=(px)*(px);
IkReal x621=(pz)*(pz);
IkReal x622=((sj0)*(sj1));
IkReal x623=((IkReal(1.00000000000000))*(r01));
IkReal x624=((r00)*(sj1));
IkReal x625=((IkReal(0.0750000000000000))*(r00));
IkReal x626=((IkReal(0.0491250000000000))*(sj3));
IkReal x627=((cj1)*(r01));
IkReal x628=((IkReal(0.150000000000000))*(py));
IkReal x629=((pz)*(r02));
IkReal x630=((px)*(r02));
IkReal x631=((IkReal(0.0750000000000000))*(sj4));
IkReal x632=((cj1)*(sj0));
IkReal x633=((pz)*(r00));
IkReal x634=((IkReal(0.0750000000000000))*(cj0));
IkReal x635=((IkReal(2.00000000000000))*(cj0));
IkReal x636=((cj1)*(r02));
IkReal x637=((IkReal(0.150000000000000))*(sj1));
IkReal x638=((px)*(r00));
IkReal x639=((IkReal(2.00000000000000))*(py));
IkReal x640=((r02)*(sj1));
IkReal x641=((IkReal(0.150000000000000))*(cj1));
IkReal x642=((IkReal(0.108031250000000))*(cj3));
IkReal x643=((cj0)*(py));
IkReal x644=((r01)*(sj1));
IkReal x645=((IkReal(0.0800000000000000))*(cj3));
IkReal x646=((IkReal(0.150000000000000))*(pz));
IkReal x647=((IkReal(0.0491250000000000))*(cj3));
IkReal x648=((cj1)*(pz));
IkReal x649=((IkReal(0.0952312500000000))*(sj3));
IkReal x650=((IkReal(0.600000000000000))*(py));
IkReal x651=((IkReal(1.00000000000000))*(py));
IkReal x652=((px)*(sj1));
IkReal x653=((IkReal(1.00000000000000))*(cj0));
IkReal x654=((cj0)*(r00));
IkReal x655=((IkReal(0.600000000000000))*(cj0));
IkReal x656=((IkReal(1.00000000000000))*(sj3));
IkReal x657=((pz)*(sj1));
IkReal x658=((IkReal(0.0800000000000000))*(sj3));
IkReal x659=((px)*(py));
IkReal x660=((cj1)*(r00));
IkReal x661=((r01)*(sj0));
IkReal x662=((cj1)*(px));
IkReal x663=((cj4)*(x618));
IkReal x664=((cj4)*(x617));
IkReal x665=((sj4)*(x618));
IkReal x666=((IkReal(2.00000000000000))*(x621));
IkReal x667=((sj4)*(x617));
IkReal x668=((IkReal(2.00000000000000))*(x619));
IkReal x669=((x617)*(x658));
IkReal x670=((px)*(x629)*(x635));
evalcond[0]=((((IkReal(-1.00000000000000))*(cj3)*(x663)))+(x640)+(((IkReal(-1.00000000000000))*(x623)*(x632)))+(((IkReal(-1.00000000000000))*(x653)*(x660)))+(((IkReal(-1.00000000000000))*(x656)*(x664))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x656)*(x663)))+(((IkReal(-1.00000000000000))*(x622)*(x623)))+(((IkReal(-1.00000000000000))*(x624)*(x653)))+(((IkReal(-1.00000000000000))*(x636)))+(((cj3)*(x664))));
evalcond[2]=((x657)+(((IkReal(0.327500000000000))*(x617)))+(((IkReal(-0.0750000000000000))*(x618)))+(((x617)*(x645)))+(((IkReal(-1.00000000000000))*(x632)*(x651)))+(((IkReal(-1.00000000000000))*(x653)*(x662)))+(((IkReal(-1.00000000000000))*(x618)*(x658)))+(((IkReal(0.0750000000000000))*(cj1))));
evalcond[3]=((IkReal(0.300000000000000))+(x669)+(((x618)*(x645)))+(((IkReal(0.0750000000000000))*(x617)))+(((IkReal(-1.00000000000000))*(x652)*(x653)))+(((IkReal(0.327500000000000))*(x618)))+(((IkReal(-1.00000000000000))*(x622)*(x651)))+(((IkReal(-1.00000000000000))*(x648)))+(((IkReal(0.0750000000000000))*(sj1))));
evalcond[4]=((((x625)*(x632)))+(((IkReal(-1.00000000000000))*(x651)*(x660)))+(((x658)*(x665)))+(((px)*(x627)))+(((IkReal(-1.00000000000000))*(x627)*(x634)))+(((IkReal(-1.00000000000000))*(x622)*(x630)))+(((IkReal(-1.00000000000000))*(cj0)*(x623)*(x657)))+(((IkReal(-0.327500000000000))*(x667)))+(((x640)*(x643)))+(((x622)*(x633)))+(((IkReal(-1.00000000000000))*(x645)*(x667)))+(((x618)*(x631))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x630)*(x632)))+(((x658)*(x667)))+(((IkReal(-1.00000000000000))*(cj0)*(x623)*(x648)))+(((x632)*(x633)))+(((x645)*(x665)))+(((IkReal(-0.300000000000000))*(r00)*(sj0)))+(((IkReal(-1.00000000000000))*(x622)*(x625)))+(((IkReal(-1.00000000000000))*(x623)*(x652)))+(((x636)*(x643)))+(((x617)*(x631)))+(((IkReal(0.300000000000000))*(cj0)*(r01)))+(((py)*(x624)))+(((x634)*(x644)))+(((IkReal(0.327500000000000))*(x665))));
evalcond[6]=((((IkReal(0.0843750000000000))*(x636)))+(((IkReal(-1.00000000000000))*(x647)*(x663)))+(((IkReal(0.0450000000000000))*(x654)))+(((IkReal(-0.600000000000000))*(x629)))+(((IkReal(-0.150000000000000))*(px)*(x624)))+(((IkReal(-1.00000000000000))*(x628)*(x644)))+(((IkReal(-1.00000000000000))*(sj0)*(x627)*(x646)))+(((x642)*(x664)))+(((IkReal(2.00000000000000))*(x633)*(x662)))+(((IkReal(-1.00000000000000))*(x629)*(x637)))+(((x636)*(x666)))+(((IkReal(-1.00000000000000))*(pp)*(x636)))+(((x649)*(x663)))+(((x620)*(x624)*(x635)))+(((IkReal(0.0956250000000000))*(cj0)*(x624)))+(((pz)*(x627)*(x639)))+(((r01)*(x622)*(x668)))+(((IkReal(0.0450000000000000))*(x661)))+(((r02)*(x628)*(x632)))+(((x626)*(x664)))+(((IkReal(-0.0120000000000000))*(x663)))+(((IkReal(0.0524000000000000))*(x664)))+(((IkReal(-0.600000000000000))*(x638)))+(((x635)*(x644)*(x659)))+(((cj0)*(x630)*(x641)))+(((IkReal(0.0956250000000000))*(r01)*(x622)))+(((IkReal(-1.00000000000000))*(pp)*(x624)*(x653)))+(((IkReal(-1.00000000000000))*(pp)*(x622)*(x623)))+(((IkReal(-1.00000000000000))*(r01)*(x650)))+(((IkReal(-1.00000000000000))*(cj0)*(x633)*(x641)))+(((x622)*(x629)*(x639)))+(((x622)*(x638)*(x639)))+(((x629)*(x635)*(x652))));
evalcond[7]=((((IkReal(-1.00000000000000))*(x627)*(x628)))+(((r01)*(x622)*(x646)))+(((x632)*(x638)*(x639)))+(((IkReal(-1.00000000000000))*(x638)*(x641)))+(((x620)*(x635)*(x660)))+(((IkReal(-0.0843750000000000))*(sj0)*(x627)))+(((IkReal(0.0450000000000000))*(r02)))+(((IkReal(-1.00000000000000))*(cj0)*(x630)*(x637)))+(((IkReal(-0.0120000000000000))*(x664)))+(((IkReal(0.0956250000000000))*(x640)))+(((IkReal(-1.00000000000000))*(pp)*(x623)*(x632)))+(((IkReal(-2.00000000000000))*(px)*(pz)*(x624)))+(((IkReal(-0.0843750000000000))*(cj1)*(x654)))+(((IkReal(0.600000000000000))*(pz)*(x661)))+(((IkReal(-1.00000000000000))*(pz)*(x639)*(x644)))+(((x629)*(x635)*(x662)))+(((x633)*(x655)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x650)))+(((IkReal(-1.00000000000000))*(x629)*(x641)))+(((IkReal(-1.00000000000000))*(x640)*(x666)))+(((IkReal(-0.0524000000000000))*(x663)))+(((x627)*(x635)*(x659)))+(((cj0)*(x624)*(x646)))+(((IkReal(-1.00000000000000))*(pp)*(x653)*(x660)))+(((x649)*(x664)))+(((IkReal(-1.00000000000000))*(x647)*(x664)))+(((IkReal(-1.00000000000000))*(x630)*(x655)))+(((pp)*(x640)))+(((IkReal(-1.00000000000000))*(x626)*(x663)))+(((sj0)*(x627)*(x668)))+(((IkReal(-1.00000000000000))*(r02)*(x622)*(x628)))+(((x629)*(x632)*(x639)))+(((IkReal(-1.00000000000000))*(x642)*(x663))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  || IKabs(evalcond[6]) > 0.000001  || IKabs(evalcond[7]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x671=((IkReal(1.00000000000000))*(cj1));
IkReal x672=((cj0)*(r00));
IkReal x673=((cj3)*(r02));
IkReal x674=((sj1)*(sj3));
IkReal x675=((r01)*(sj0));
IkReal x676=((cj3)*(x675));
if( IKabs(((gconst2)*(((((IkReal(-1.00000000000000))*(x671)*(x676)))+(((IkReal(-1.00000000000000))*(x672)*(x674)))+(((IkReal(-1.00000000000000))*(r02)*(sj3)*(x671)))+(((sj1)*(x673)))+(((IkReal(-1.00000000000000))*(cj3)*(x671)*(x672)))+(((IkReal(-1.00000000000000))*(x674)*(x675))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst2)*(((((IkReal(-1.00000000000000))*(sj3)*(x671)*(x672)))+(((cj3)*(sj1)*(x672)))+(((cj1)*(x673)))+(((sj1)*(x676)))+(((IkReal(-1.00000000000000))*(sj3)*(x671)*(x675)))+(((r02)*(x674))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst2)*(((((IkReal(-1.00000000000000))*(x671)*(x676)))+(((IkReal(-1.00000000000000))*(x672)*(x674)))+(((IkReal(-1.00000000000000))*(r02)*(sj3)*(x671)))+(((sj1)*(x673)))+(((IkReal(-1.00000000000000))*(cj3)*(x671)*(x672)))+(((IkReal(-1.00000000000000))*(x674)*(x675)))))), ((gconst2)*(((((IkReal(-1.00000000000000))*(sj3)*(x671)*(x672)))+(((cj3)*(sj1)*(x672)))+(((cj1)*(x673)))+(((sj1)*(x676)))+(((IkReal(-1.00000000000000))*(sj3)*(x671)*(x675)))+(((r02)*(x674)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x677=IKcos(j2);
IkReal x678=IKsin(j2);
IkReal x679=(py)*(py);
IkReal x680=(px)*(px);
IkReal x681=(pz)*(pz);
IkReal x682=((sj0)*(sj1));
IkReal x683=((IkReal(1.00000000000000))*(r01));
IkReal x684=((r00)*(sj1));
IkReal x685=((IkReal(0.0750000000000000))*(r00));
IkReal x686=((IkReal(0.0491250000000000))*(sj3));
IkReal x687=((cj1)*(r01));
IkReal x688=((IkReal(0.150000000000000))*(py));
IkReal x689=((pz)*(r02));
IkReal x690=((px)*(r02));
IkReal x691=((IkReal(0.0750000000000000))*(sj4));
IkReal x692=((cj1)*(sj0));
IkReal x693=((pz)*(r00));
IkReal x694=((IkReal(0.0750000000000000))*(cj0));
IkReal x695=((IkReal(2.00000000000000))*(cj0));
IkReal x696=((cj1)*(r02));
IkReal x697=((IkReal(0.150000000000000))*(sj1));
IkReal x698=((px)*(r00));
IkReal x699=((IkReal(2.00000000000000))*(py));
IkReal x700=((r02)*(sj1));
IkReal x701=((IkReal(0.150000000000000))*(cj1));
IkReal x702=((IkReal(0.108031250000000))*(cj3));
IkReal x703=((cj0)*(py));
IkReal x704=((r01)*(sj1));
IkReal x705=((IkReal(0.0800000000000000))*(cj3));
IkReal x706=((IkReal(0.150000000000000))*(pz));
IkReal x707=((IkReal(0.0491250000000000))*(cj3));
IkReal x708=((cj1)*(pz));
IkReal x709=((IkReal(0.0952312500000000))*(sj3));
IkReal x710=((IkReal(0.600000000000000))*(py));
IkReal x711=((IkReal(1.00000000000000))*(py));
IkReal x712=((px)*(sj1));
IkReal x713=((IkReal(1.00000000000000))*(cj0));
IkReal x714=((cj0)*(r00));
IkReal x715=((IkReal(0.600000000000000))*(cj0));
IkReal x716=((IkReal(1.00000000000000))*(sj3));
IkReal x717=((pz)*(sj1));
IkReal x718=((IkReal(0.0800000000000000))*(sj3));
IkReal x719=((px)*(py));
IkReal x720=((cj1)*(r00));
IkReal x721=((r01)*(sj0));
IkReal x722=((cj1)*(px));
IkReal x723=((cj4)*(x678));
IkReal x724=((cj4)*(x677));
IkReal x725=((sj4)*(x678));
IkReal x726=((IkReal(2.00000000000000))*(x681));
IkReal x727=((sj4)*(x677));
IkReal x728=((IkReal(2.00000000000000))*(x679));
IkReal x729=((x677)*(x718));
IkReal x730=((px)*(x689)*(x695));
evalcond[0]=((((IkReal(-1.00000000000000))*(cj3)*(x723)))+(((IkReal(-1.00000000000000))*(x716)*(x724)))+(x700)+(((IkReal(-1.00000000000000))*(x683)*(x692)))+(((IkReal(-1.00000000000000))*(x713)*(x720))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x716)*(x723)))+(((IkReal(-1.00000000000000))*(x682)*(x683)))+(((IkReal(-1.00000000000000))*(x696)))+(((IkReal(-1.00000000000000))*(x684)*(x713)))+(((cj3)*(x724))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x713)*(x722)))+(((IkReal(-1.00000000000000))*(x678)*(x718)))+(((IkReal(-0.0750000000000000))*(x678)))+(((IkReal(-1.00000000000000))*(x692)*(x711)))+(((IkReal(0.327500000000000))*(x677)))+(x717)+(((IkReal(0.0750000000000000))*(cj1)))+(((x677)*(x705))));
evalcond[3]=((IkReal(0.300000000000000))+(((IkReal(-1.00000000000000))*(x682)*(x711)))+(((IkReal(-1.00000000000000))*(x708)))+(x729)+(((x678)*(x705)))+(((IkReal(0.0750000000000000))*(x677)))+(((IkReal(0.327500000000000))*(x678)))+(((IkReal(-1.00000000000000))*(x712)*(x713)))+(((IkReal(0.0750000000000000))*(sj1))));
evalcond[4]=((((x685)*(x692)))+(((IkReal(-1.00000000000000))*(cj0)*(x683)*(x717)))+(((IkReal(-1.00000000000000))*(x682)*(x690)))+(((x700)*(x703)))+(((IkReal(-0.327500000000000))*(x727)))+(((px)*(x687)))+(((IkReal(-1.00000000000000))*(x705)*(x727)))+(((x678)*(x691)))+(((IkReal(-1.00000000000000))*(x687)*(x694)))+(((IkReal(-1.00000000000000))*(x711)*(x720)))+(((x682)*(x693)))+(((x718)*(x725))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x683)*(x712)))+(((x692)*(x693)))+(((x696)*(x703)))+(((IkReal(-0.300000000000000))*(r00)*(sj0)))+(((py)*(x684)))+(((IkReal(-1.00000000000000))*(x682)*(x685)))+(((IkReal(-1.00000000000000))*(x690)*(x692)))+(((x694)*(x704)))+(((x718)*(x727)))+(((x705)*(x725)))+(((IkReal(-1.00000000000000))*(cj0)*(x683)*(x708)))+(((IkReal(0.300000000000000))*(cj0)*(r01)))+(((IkReal(0.327500000000000))*(x725)))+(((x677)*(x691))));
evalcond[6]=((((r02)*(x688)*(x692)))+(((IkReal(-0.150000000000000))*(px)*(x684)))+(((IkReal(-0.600000000000000))*(x698)))+(((IkReal(0.0450000000000000))*(x721)))+(((x709)*(x723)))+(((x682)*(x689)*(x699)))+(((x695)*(x704)*(x719)))+(((IkReal(-0.600000000000000))*(x689)))+(((IkReal(2.00000000000000))*(x693)*(x722)))+(((IkReal(-1.00000000000000))*(pp)*(x682)*(x683)))+(((IkReal(0.0956250000000000))*(cj0)*(x684)))+(((IkReal(-1.00000000000000))*(pp)*(x696)))+(((IkReal(0.0524000000000000))*(x724)))+(((IkReal(-0.0120000000000000))*(x723)))+(((IkReal(-1.00000000000000))*(x689)*(x697)))+(((x680)*(x684)*(x695)))+(((IkReal(-1.00000000000000))*(pp)*(x684)*(x713)))+(((x702)*(x724)))+(((cj0)*(x690)*(x701)))+(((IkReal(0.0843750000000000))*(x696)))+(((IkReal(-1.00000000000000))*(sj0)*(x687)*(x706)))+(((IkReal(-1.00000000000000))*(x707)*(x723)))+(((IkReal(-1.00000000000000))*(r01)*(x710)))+(((x686)*(x724)))+(((r01)*(x682)*(x728)))+(((x682)*(x698)*(x699)))+(((x689)*(x695)*(x712)))+(((pz)*(x687)*(x699)))+(((IkReal(-1.00000000000000))*(cj0)*(x693)*(x701)))+(((x696)*(x726)))+(((IkReal(0.0956250000000000))*(r01)*(x682)))+(((IkReal(-1.00000000000000))*(x688)*(x704)))+(((IkReal(0.0450000000000000))*(x714))));
evalcond[7]=((((IkReal(-1.00000000000000))*(pp)*(x713)*(x720)))+(((IkReal(-1.00000000000000))*(pp)*(x683)*(x692)))+(((IkReal(0.600000000000000))*(pz)*(x721)))+(((sj0)*(x687)*(x728)))+(((x689)*(x695)*(x722)))+(((IkReal(-1.00000000000000))*(x702)*(x723)))+(((IkReal(0.0450000000000000))*(r02)))+(((IkReal(-1.00000000000000))*(r02)*(x682)*(x688)))+(((IkReal(-0.0843750000000000))*(cj1)*(x714)))+(((x709)*(x724)))+(((IkReal(-1.00000000000000))*(x698)*(x701)))+(((IkReal(-0.0524000000000000))*(x723)))+(((cj0)*(x684)*(x706)))+(((x692)*(x698)*(x699)))+(((IkReal(-1.00000000000000))*(x707)*(x724)))+(((x687)*(x695)*(x719)))+(((IkReal(-0.0120000000000000))*(x724)))+(((IkReal(0.0956250000000000))*(x700)))+(((r01)*(x682)*(x706)))+(((IkReal(-0.0843750000000000))*(sj0)*(x687)))+(((x689)*(x692)*(x699)))+(((IkReal(-2.00000000000000))*(px)*(pz)*(x684)))+(((IkReal(-1.00000000000000))*(x687)*(x688)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x710)))+(((IkReal(-1.00000000000000))*(x686)*(x723)))+(((IkReal(-1.00000000000000))*(x689)*(x701)))+(((x680)*(x695)*(x720)))+(((x693)*(x715)))+(((IkReal(-1.00000000000000))*(pz)*(x699)*(x704)))+(((IkReal(-1.00000000000000))*(cj0)*(x690)*(x697)))+(((pp)*(x700)))+(((IkReal(-1.00000000000000))*(x690)*(x715)))+(((IkReal(-1.00000000000000))*(x700)*(x726))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  || IKabs(evalcond[6]) > 0.000001  || IKabs(evalcond[7]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x731=((r01)*(sj0));
IkReal x732=((IkReal(15720.0000000000))*(sj1));
IkReal x733=((px)*(r00));
IkReal x734=((IkReal(3600.00000000000))*(sj1));
IkReal x735=((cj0)*(r00));
IkReal x736=((cj1)*(r02));
IkReal x737=((py)*(r01));
IkReal x738=((cj4)*(sj1));
IkReal x739=((pz)*(r02));
IkReal x740=((cj4)*(pp));
IkReal x741=((cj0)*(cj4)*(px));
IkReal x742=((cj1)*(cj4)*(pz));
IkReal x743=((cj4)*(py)*(sj0));
IkReal x744=((py)*(sj0)*(x738));
if( IKabs(((gconst0)*(((((IkReal(-11250.0000000000))*(x741)))+(((IkReal(-11250.0000000000))*(x743)))+(((x732)*(x735)))+(((IkReal(3930.00000000000))*(x731)))+(((x731)*(x732)))+(((IkReal(-45000.0000000000))*(x744)))+(((IkReal(-45000.0000000000))*(cj0)*(px)*(x738)))+(((IkReal(-45000.0000000000))*(x742)))+(((IkReal(3930.00000000000))*(x735)))+(((IkReal(-52400.0000000000))*(x739)))+(((IkReal(3375.00000000000))*(x738)))+(((IkReal(-52400.0000000000))*(x733)))+(((IkReal(15720.0000000000))*(x736)))+(((IkReal(-1774.21875000000))*(cj4)))+(((IkReal(-52400.0000000000))*(x737)))+(((IkReal(75000.0000000000))*(x740))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst0)*(((((IkReal(-49125.0000000000))*(x743)))+(((IkReal(-1.00000000000000))*(x734)*(x735)))+(((IkReal(-196500.000000000))*(x742)))+(((IkReal(-3600.00000000000))*(x736)))+(((IkReal(-900.000000000000))*(x731)))+(((IkReal(12000.0000000000))*(x737)))+(((IkReal(-196500.000000000))*(x744)))+(((IkReal(-196500.000000000))*(cj0)*(px)*(x738)))+(((IkReal(-1.00000000000000))*(x731)*(x734)))+(((IkReal(12000.0000000000))*(x739)))+(((IkReal(12000.0000000000))*(x733)))+(((IkReal(327500.000000000))*(x740)))+(((IkReal(-7747.42187500000))*(cj4)))+(((IkReal(-900.000000000000))*(x735)))+(((IkReal(14737.5000000000))*(x738)))+(((IkReal(-49125.0000000000))*(x741))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst0)*(((((IkReal(-11250.0000000000))*(x741)))+(((IkReal(-11250.0000000000))*(x743)))+(((x732)*(x735)))+(((IkReal(3930.00000000000))*(x731)))+(((x731)*(x732)))+(((IkReal(-45000.0000000000))*(x744)))+(((IkReal(-45000.0000000000))*(cj0)*(px)*(x738)))+(((IkReal(-45000.0000000000))*(x742)))+(((IkReal(3930.00000000000))*(x735)))+(((IkReal(-52400.0000000000))*(x739)))+(((IkReal(3375.00000000000))*(x738)))+(((IkReal(-52400.0000000000))*(x733)))+(((IkReal(15720.0000000000))*(x736)))+(((IkReal(-1774.21875000000))*(cj4)))+(((IkReal(-52400.0000000000))*(x737)))+(((IkReal(75000.0000000000))*(x740)))))), ((gconst0)*(((((IkReal(-49125.0000000000))*(x743)))+(((IkReal(-1.00000000000000))*(x734)*(x735)))+(((IkReal(-196500.000000000))*(x742)))+(((IkReal(-3600.00000000000))*(x736)))+(((IkReal(-900.000000000000))*(x731)))+(((IkReal(12000.0000000000))*(x737)))+(((IkReal(-196500.000000000))*(x744)))+(((IkReal(-196500.000000000))*(cj0)*(px)*(x738)))+(((IkReal(-1.00000000000000))*(x731)*(x734)))+(((IkReal(12000.0000000000))*(x739)))+(((IkReal(12000.0000000000))*(x733)))+(((IkReal(327500.000000000))*(x740)))+(((IkReal(-7747.42187500000))*(cj4)))+(((IkReal(-900.000000000000))*(x735)))+(((IkReal(14737.5000000000))*(x738)))+(((IkReal(-49125.0000000000))*(x741)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x745=IKcos(j3);
IkReal x746=IKsin(j3);
IkReal x747=((r01)*(sj0));
IkReal x748=((IkReal(0.300000000000000))*(r02));
IkReal x749=((r00)*(sj0));
IkReal x750=((py)*(sj0));
IkReal x751=((IkReal(0.600000000000000))*(cj1));
IkReal x752=((IkReal(0.150000000000000))*(px));
IkReal x753=((IkReal(1.00000000000000))*(pz));
IkReal x754=((py)*(r00));
IkReal x755=((IkReal(0.300000000000000))*(cj1));
IkReal x756=((IkReal(1.00000000000000))*(pp));
IkReal x757=((cj0)*(r00));
IkReal x758=((IkReal(0.0450000000000000))*(sj1));
IkReal x759=((IkReal(0.600000000000000))*(sj1));
IkReal x760=((cj0)*(r01));
IkReal x761=((IkReal(2.00000000000000))*(pz));
IkReal x762=((cj0)*(px));
IkReal x763=((IkReal(0.300000000000000))*(sj1));
IkReal x764=((IkReal(2.00000000000000))*(px)*(py));
IkReal x765=((IkReal(0.0120000000000000))*(x746));
IkReal x766=((cj4)*(x746));
IkReal x767=((IkReal(0.0524000000000000))*(x745));
IkReal x768=((cj4)*(x745));
IkReal x769=((cj0)*(py)*(r02));
IkReal x770=((px)*(r02)*(sj0));
evalcond[0]=((IkReal(0.0236562500000000))+(((x750)*(x759)))+(((cj0)*(x752)))+(((IkReal(-1.00000000000000))*(x756)))+(((IkReal(-1.00000000000000))*(x758)))+(x765)+(x767)+(((pz)*(x751)))+(((x759)*(x762)))+(((IkReal(0.150000000000000))*(x750))));
evalcond[1]=((((IkReal(-1.00000000000000))*(py)*(r01)))+(((IkReal(-0.327500000000000))*(x766)))+(((IkReal(-1.00000000000000))*(px)*(r00)))+(((cj1)*(x748)))+(((IkReal(-1.00000000000000))*(r02)*(x753)))+(((IkReal(0.0750000000000000))*(x757)))+(((IkReal(0.0750000000000000))*(x768)))+(((x757)*(x763)))+(((x747)*(x763)))+(((IkReal(0.0750000000000000))*(x747))));
evalcond[2]=((((x747)*(x755)))+(((IkReal(-0.0800000000000000))*(cj4)))+(((IkReal(-1.00000000000000))*(x753)*(x757)))+(((IkReal(-0.0750000000000000))*(x766)))+(((r02)*(x750)))+(((r02)*(x762)))+(((IkReal(-0.0750000000000000))*(r02)))+(((IkReal(-1.00000000000000))*(sj1)*(x748)))+(((x755)*(x757)))+(((IkReal(-0.327500000000000))*(x768)))+(((IkReal(-1.00000000000000))*(x747)*(x753))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x761)*(x769)))+(((IkReal(-1.00000000000000))*(sj4)*(x767)))+(((IkReal(-1.00000000000000))*(pz)*(x751)*(x760)))+(((IkReal(-0.119281250000000))*(sj4)))+(((IkReal(-0.0956250000000000))*(x749)))+(((IkReal(-2.00000000000000))*(x760)*((py)*(py))))+(((IkReal(-1.00000000000000))*(r01)*(x752)))+(((IkReal(-1.00000000000000))*(px)*(r01)*(x759)))+(((IkReal(-1.00000000000000))*(x749)*(x758)))+(((x761)*(x770)))+(((x754)*(x759)))+(((pz)*(x749)*(x751)))+(((IkReal(0.150000000000000))*(x754)))+(((IkReal(-2.00000000000000))*(x754)*(x762)))+(((x747)*(x764)))+(((IkReal(-1.00000000000000))*(x751)*(x770)))+(((x758)*(x760)))+(((IkReal(2.00000000000000))*(x749)*((px)*(px))))+(((x751)*(x769)))+(((IkReal(0.0956250000000000))*(x760)))+(((IkReal(-1.00000000000000))*(sj4)*(x765)))+(((pp)*(x760)))+(((IkReal(-1.00000000000000))*(x749)*(x756))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst2;
gconst2=IKsign(((((cj4)*((cj3)*(cj3))))+(((cj4)*((sj3)*(sj3))))));
dummyeval[0]=((((cj4)*((cj3)*(cj3))))+(((cj4)*((sj3)*(sj3)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst3;
IkReal x771=((IkReal(0.0800000000000000))*(cj4));
gconst3=IKsign(((((IkReal(0.0750000000000000))*(cj4)*(sj3)))+(((x771)*((sj3)*(sj3))))+(((x771)*((cj3)*(cj3))))+(((IkReal(0.327500000000000))*(cj3)*(cj4)))));
IkReal x772=((IkReal(1.06666666666667))*(cj4));
dummyeval[0]=((((x772)*((cj3)*(cj3))))+(((x772)*((sj3)*(sj3))))+(((IkReal(4.36666666666667))*(cj3)*(cj4)))+(((cj4)*(sj3))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[11];
IkReal x773=((IkReal(0.0524000000000000))*(cj3));
IkReal x774=((IkReal(0.0120000000000000))*(sj3));
IkReal x775=(py)*(py);
IkReal x776=(px)*(px);
IkReal x777=(pz)*(pz);
IkReal x778=((r01)*(sj0));
IkReal x779=((py)*(r00));
IkReal x780=((pz)*(sj1));
IkReal x781=((py)*(r01));
IkReal x782=((px)*(sj0));
IkReal x783=((IkReal(0.600000000000000))*(r02));
IkReal x784=((IkReal(0.150000000000000))*(cj1));
IkReal x785=((cj0)*(sj1));
IkReal x786=((IkReal(0.150000000000000))*(px));
IkReal x787=((IkReal(2.00000000000000))*(cj1));
IkReal x788=((cj0)*(r01));
IkReal x789=((r02)*(sj1));
IkReal x790=((px)*(r00));
IkReal x791=((IkReal(0.300000000000000))*(r00));
IkReal x792=((IkReal(1.00000000000000))*(pz));
IkReal x793=((r00)*(sj1));
IkReal x794=((cj0)*(r00));
IkReal x795=((cj0)*(cj1));
IkReal x796=((IkReal(1.00000000000000))*(sj1));
IkReal x797=((IkReal(0.0956250000000000))*(r00));
IkReal x798=((IkReal(0.600000000000000))*(pz));
IkReal x799=((IkReal(0.600000000000000))*(sj1));
IkReal x800=((IkReal(2.00000000000000))*(px));
IkReal x801=((IkReal(2.00000000000000))*(sj1));
IkReal x802=((IkReal(0.150000000000000))*(sj1));
IkReal x803=((cj1)*(r02));
IkReal x804=((cj0)*(px));
IkReal x805=((IkReal(0.0843750000000000))*(cj1));
IkReal x806=((py)*(sj0));
IkReal x807=((pz)*(r02));
IkReal x808=((IkReal(1.00000000000000))*(cj1));
IkReal x809=((cj0)*(py));
IkReal x810=((r00)*(sj0));
IkReal x811=((r02)*(x806));
IkReal x812=((pp)*(x808));
IkReal x813=((IkReal(1.00000000000000))*(pp)*(r00));
IkReal x814=((x773)+(x774));
IkReal x815=((IkReal(2.00000000000000))*(r00)*(x776));
IkReal x816=((cj0)*(x800)*(x807));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j4)), IkReal(6.28318530717959))));
evalcond[1]=((x809)+(((IkReal(-1.00000000000000))*(x782))));
evalcond[2]=((IkReal(-1.00000000000000))+(x788)+(((IkReal(-1.00000000000000))*(x810))));
evalcond[3]=((x789)+(((IkReal(-1.00000000000000))*(x778)*(x808)))+(((IkReal(-1.00000000000000))*(x794)*(x808))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r00)*(x785)))+(((IkReal(-1.00000000000000))*(x778)*(x796)))+(((IkReal(-1.00000000000000))*(x803))));
evalcond[5]=((IkReal(0.0236562500000000))+(((x799)*(x806)))+(((IkReal(-1.00000000000000))*(pp)))+(((cj1)*(x798)))+(((IkReal(0.150000000000000))*(x806)))+(((IkReal(0.600000000000000))*(px)*(x785)))+(x814)+(((IkReal(-0.0450000000000000))*(sj1)))+(((cj0)*(x786))));
evalcond[6]=((((IkReal(0.0750000000000000))*(x794)))+(((IkReal(0.300000000000000))*(x803)))+(((IkReal(-1.00000000000000))*(r02)*(x792)))+(((IkReal(0.0750000000000000))*(x778)))+(((IkReal(-1.00000000000000))*(x790)))+(((IkReal(0.300000000000000))*(sj1)*(x778)))+(((IkReal(-1.00000000000000))*(x781)))+(((x785)*(x791))));
evalcond[7]=((((IkReal(-1.00000000000000))*(x792)*(x794)))+(((IkReal(0.300000000000000))*(cj1)*(x778)))+(((r02)*(x804)))+(((IkReal(-0.300000000000000))*(x789)))+(((IkReal(-1.00000000000000))*(x778)*(x792)))+(((IkReal(-0.0750000000000000))*(r02)))+(x811)+(((x791)*(x795))));
evalcond[8]=((IkReal(-0.119281250000000))+(((IkReal(-1.00000000000000))*(sj0)*(x797)))+(((py)*(x778)*(x800)))+(((IkReal(2.00000000000000))*(x776)*(x810)))+(((pp)*(x788)))+(((IkReal(-2.00000000000000))*(x807)*(x809)))+(((IkReal(-1.00000000000000))*(px)*(r01)*(x799)))+(((IkReal(-1.00000000000000))*(r01)*(x786)))+(((cj1)*(x798)*(x810)))+(((IkReal(0.0956250000000000))*(x788)))+(((IkReal(2.00000000000000))*(x782)*(x807)))+(((IkReal(-1.00000000000000))*(x814)))+(((IkReal(-2.00000000000000))*(x775)*(x788)))+(((IkReal(-1.00000000000000))*(cj1)*(x782)*(x783)))+(((IkReal(-1.00000000000000))*(pp)*(x810)))+(((IkReal(-0.0450000000000000))*(sj0)*(x793)))+(((x779)*(x799)))+(((py)*(x783)*(x795)))+(((IkReal(0.0450000000000000))*(r01)*(x785)))+(((IkReal(-1.00000000000000))*(cj0)*(x779)*(x800)))+(((IkReal(-1.00000000000000))*(cj1)*(x788)*(x798)))+(((IkReal(0.150000000000000))*(x779))));
evalcond[9]=((((r02)*(x777)*(x787)))+(((pz)*(x781)*(x787)))+(((x785)*(x797)))+(((IkReal(0.0450000000000000))*(x778)))+(((IkReal(-1.00000000000000))*(pp)*(x778)*(x796)))+(((IkReal(-1.00000000000000))*(x781)*(x802)))+(((r02)*(x784)*(x804)))+(((IkReal(0.0956250000000000))*(sj1)*(x778)))+(((IkReal(-1.00000000000000))*(pz)*(x778)*(x784)))+(((IkReal(-1.00000000000000))*(pz)*(x784)*(x794)))+(((IkReal(-1.00000000000000))*(pp)*(x803)))+(((x785)*(x815)))+(((IkReal(-0.600000000000000))*(x790)))+(((IkReal(0.0843750000000000))*(x803)))+(((IkReal(-1.00000000000000))*(pz)*(x783)))+(((IkReal(0.0450000000000000))*(x794)))+(((x775)*(x778)*(x801)))+(((cj0)*(r02)*(x780)*(x800)))+(((x784)*(x811)))+(((IkReal(-1.00000000000000))*(x786)*(x793)))+(((x781)*(x785)*(x800)))+(((x779)*(x782)*(x801)))+(((IkReal(-0.600000000000000))*(x781)))+(((IkReal(-0.150000000000000))*(r02)*(x780)))+(((IkReal(2.00000000000000))*(x780)*(x811)))+(((IkReal(-1.00000000000000))*(x785)*(x813)))+(((pz)*(x787)*(x790))));
evalcond[10]=((((IkReal(-1.00000000000000))*(r02)*(x785)*(x786)))+(((IkReal(-1.00000000000000))*(x781)*(x784)))+(((IkReal(-1.00000000000000))*(x783)*(x804)))+(((IkReal(-1.00000000000000))*(x778)*(x805)))+(((IkReal(-2.00000000000000))*(x777)*(x789)))+(((IkReal(0.0956250000000000))*(x789)))+(((IkReal(0.150000000000000))*(x780)*(x794)))+(((x776)*(x787)*(x794)))+(((IkReal(-1.00000000000000))*(x778)*(x812)))+(((IkReal(-1.00000000000000))*(x794)*(x812)))+(((IkReal(0.0450000000000000))*(r02)))+(((IkReal(-1.00000000000000))*(x783)*(x806)))+(((x775)*(x778)*(x787)))+(((IkReal(-2.00000000000000))*(x780)*(x790)))+(((IkReal(-1.00000000000000))*(x794)*(x805)))+(((IkReal(-2.00000000000000))*(x780)*(x781)))+(((x778)*(x798)))+(((IkReal(-1.00000000000000))*(x784)*(x807)))+(((IkReal(-0.150000000000000))*(x789)*(x806)))+(((x794)*(x798)))+(((IkReal(-1.00000000000000))*(x784)*(x790)))+(((x779)*(x782)*(x787)))+(((x787)*(x804)*(x807)))+(((pp)*(x789)))+(((x787)*(x806)*(x807)))+(((x781)*(x787)*(x804)))+(((IkReal(0.150000000000000))*(x778)*(x780))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  && IKabs(evalcond[9]) < 0.0000010000000000  && IKabs(evalcond[10]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst4;
gconst4=IKsign(((IkReal(0.112881250000000))+(((IkReal(0.0524000000000000))*(cj3)))+(((IkReal(0.00640000000000000))*((sj3)*(sj3))))+(((IkReal(0.00640000000000000))*((cj3)*(cj3))))+(((IkReal(0.0120000000000000))*(sj3)))));
dummyeval[0]=((IkReal(17.6376953125000))+(((IkReal(8.18750000000000))*(cj3)))+((cj3)*(cj3))+(((IkReal(1.87500000000000))*(sj3)))+((sj3)*(sj3)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst5;
gconst5=IKsign(((IkReal(0.112881250000000))+(((IkReal(0.0524000000000000))*(cj3)))+(((IkReal(0.00640000000000000))*((sj3)*(sj3))))+(((IkReal(0.00640000000000000))*((cj3)*(cj3))))+(((IkReal(0.0120000000000000))*(sj3)))));
dummyeval[0]=((IkReal(17.6376953125000))+(((IkReal(8.18750000000000))*(cj3)))+((cj3)*(cj3))+(((IkReal(1.87500000000000))*(sj3)))+((sj3)*(sj3)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x817=((pz)*(r01));
IkReal x818=((py)*(r02));
IkReal x819=((cj1)*(r01));
IkReal x820=((IkReal(0.00600000000000000))*(cj0));
IkReal x821=((cj1)*(pz));
IkReal x822=((r00)*(sj0));
IkReal x823=((IkReal(0.0750000000000000))*(px));
IkReal x824=((cj0)*(sj1));
IkReal x825=((px)*(sj3));
IkReal x826=((IkReal(0.0800000000000000))*(sj3));
IkReal x827=((sj0)*(sj1));
IkReal x828=((IkReal(0.327500000000000))*(px));
IkReal x829=((IkReal(0.00600000000000000))*(cj1));
IkReal x830=((IkReal(0.0750000000000000))*(py));
IkReal x831=((IkReal(0.0800000000000000))*(cj3));
IkReal x832=((pz)*(sj1));
IkReal x833=((IkReal(0.00600000000000000))*(sj1));
IkReal x834=((IkReal(0.0800000000000000))*(x824));
IkReal x835=((sj1)*(x831));
IkReal x836=((cj1)*(py)*(r00));
IkReal x837=((IkReal(0.0800000000000000))*(px)*(r02)*(x827));
if( IKabs(((gconst5)*(((IkReal(-0.0982500000000000))+(((IkReal(-1.00000000000000))*(cj3)*(x833)))+(((IkReal(0.327500000000000))*(x821)))+(((x821)*(x831)))+(((IkReal(-1.00000000000000))*(x822)*(x826)*(x832)))+(((IkReal(0.0800000000000000))*(r02)*(x825)*(x827)))+(((IkReal(-0.0750000000000000))*(x818)*(x824)))+(((py)*(x827)*(x831)))+(((sj3)*(x819)*(x820)))+(((IkReal(-1.00000000000000))*(x818)*(x824)*(x826)))+(((IkReal(-0.0245625000000000))*(sj1)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((IkReal(-1.00000000000000))*(sj3)*(x822)*(x829)))+(((IkReal(0.00562500000000000))*(cj0)*(x819)))+(((x817)*(x824)*(x826)))+(((x826)*(x836)))+(((IkReal(-0.00562500000000000))*(cj1)*(x822)))+(((px)*(x824)*(x831)))+(((IkReal(-0.0800000000000000))*(x819)*(x825)))+(((r02)*(x823)*(x827)))+(((IkReal(-1.00000000000000))*(x819)*(x823)))+(((cj1)*(r00)*(x830)))+(((x824)*(x828)))+(((IkReal(0.327500000000000))*(py)*(x827)))+(((IkReal(-0.0750000000000000))*(x822)*(x832)))+(((IkReal(0.0750000000000000))*(x817)*(x824))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst5)*(((IkReal(-0.0225000000000000))+(((IkReal(0.0750000000000000))*(x821)))+(((IkReal(-1.00000000000000))*(sj3)*(x833)))+(((IkReal(-0.0240000000000000))*(sj3)))+(((IkReal(-0.327500000000000))*(x836)))+(((x822)*(x831)*(x832)))+(((IkReal(-1.00000000000000))*(x831)*(x836)))+(((x818)*(x824)*(x831)))+(((x827)*(x830)))+(((IkReal(-1.00000000000000))*(cj3)*(x819)*(x820)))+(((x819)*(x828)))+(((IkReal(-0.327500000000000))*(x817)*(x824)))+(((x821)*(x826)))+(((x823)*(x824)))+(((IkReal(0.327500000000000))*(x822)*(x832)))+(((IkReal(0.0245625000000000))*(cj1)*(x822)))+(((IkReal(-1.00000000000000))*(px)*(r02)*(x827)*(x831)))+(((IkReal(-1.00000000000000))*(r02)*(x827)*(x828)))+(((IkReal(0.327500000000000))*(x818)*(x824)))+(((cj3)*(x822)*(x829)))+(((py)*(x826)*(x827)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((x825)*(x834)))+(((IkReal(-0.0245625000000000))*(cj0)*(x819)))+(((px)*(x819)*(x831)))+(((IkReal(-1.00000000000000))*(x817)*(x824)*(x831))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst5)*(((IkReal(-0.0982500000000000))+(((IkReal(-1.00000000000000))*(cj3)*(x833)))+(((IkReal(0.327500000000000))*(x821)))+(((x821)*(x831)))+(((IkReal(-1.00000000000000))*(x822)*(x826)*(x832)))+(((IkReal(0.0800000000000000))*(r02)*(x825)*(x827)))+(((IkReal(-0.0750000000000000))*(x818)*(x824)))+(((py)*(x827)*(x831)))+(((sj3)*(x819)*(x820)))+(((IkReal(-1.00000000000000))*(x818)*(x824)*(x826)))+(((IkReal(-0.0245625000000000))*(sj1)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((IkReal(-1.00000000000000))*(sj3)*(x822)*(x829)))+(((IkReal(0.00562500000000000))*(cj0)*(x819)))+(((x817)*(x824)*(x826)))+(((x826)*(x836)))+(((IkReal(-0.00562500000000000))*(cj1)*(x822)))+(((px)*(x824)*(x831)))+(((IkReal(-0.0800000000000000))*(x819)*(x825)))+(((r02)*(x823)*(x827)))+(((IkReal(-1.00000000000000))*(x819)*(x823)))+(((cj1)*(r00)*(x830)))+(((x824)*(x828)))+(((IkReal(0.327500000000000))*(py)*(x827)))+(((IkReal(-0.0750000000000000))*(x822)*(x832)))+(((IkReal(0.0750000000000000))*(x817)*(x824)))))), ((gconst5)*(((IkReal(-0.0225000000000000))+(((IkReal(0.0750000000000000))*(x821)))+(((IkReal(-1.00000000000000))*(sj3)*(x833)))+(((IkReal(-0.0240000000000000))*(sj3)))+(((IkReal(-0.327500000000000))*(x836)))+(((x822)*(x831)*(x832)))+(((IkReal(-1.00000000000000))*(x831)*(x836)))+(((x818)*(x824)*(x831)))+(((x827)*(x830)))+(((IkReal(-1.00000000000000))*(cj3)*(x819)*(x820)))+(((x819)*(x828)))+(((IkReal(-0.327500000000000))*(x817)*(x824)))+(((x821)*(x826)))+(((x823)*(x824)))+(((IkReal(0.327500000000000))*(x822)*(x832)))+(((IkReal(0.0245625000000000))*(cj1)*(x822)))+(((IkReal(-1.00000000000000))*(px)*(r02)*(x827)*(x831)))+(((IkReal(-1.00000000000000))*(r02)*(x827)*(x828)))+(((IkReal(0.327500000000000))*(x818)*(x824)))+(((cj3)*(x822)*(x829)))+(((py)*(x826)*(x827)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((x825)*(x834)))+(((IkReal(-0.0245625000000000))*(cj0)*(x819)))+(((px)*(x819)*(x831)))+(((IkReal(-1.00000000000000))*(x817)*(x824)*(x831)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x838=IKcos(j2);
IkReal x839=IKsin(j2);
IkReal x840=((IkReal(0.0800000000000000))*(sj3));
IkReal x841=((cj0)*(r01));
IkReal x842=((IkReal(1.00000000000000))*(px));
IkReal x843=((py)*(sj1));
IkReal x844=((cj0)*(r02));
IkReal x845=((IkReal(0.0750000000000000))*(cj1));
IkReal x846=((r02)*(sj0));
IkReal x847=((IkReal(0.0750000000000000))*(sj1));
IkReal x848=((cj1)*(pz));
IkReal x849=((r00)*(sj0));
IkReal x850=((IkReal(0.0800000000000000))*(cj3));
IkReal x851=((pz)*(sj1));
IkReal x852=((IkReal(1.00000000000000))*(sj0));
IkReal x853=((cj1)*(py));
IkReal x854=((IkReal(0.0750000000000000))*(x839));
IkReal x855=((IkReal(0.327500000000000))*(x838));
IkReal x856=((IkReal(0.0750000000000000))*(x838));
IkReal x857=((IkReal(0.327500000000000))*(x839));
IkReal x858=((sj1)*(x849));
IkReal x859=((x839)*(x840));
IkReal x860=((x838)*(x850));
IkReal x861=((x838)*(x840));
IkReal x862=((x839)*(x850));
IkReal x863=((x854)+(x859));
IkReal x864=((x860)+(x855));
IkReal x865=((x862)+(x861)+(x856)+(x857));
evalcond[0]=((((IkReal(-1.00000000000000))*(cj0)*(cj1)*(x842)))+(x864)+(x845)+(((IkReal(-1.00000000000000))*(x863)))+(x851)+(((IkReal(-1.00000000000000))*(x852)*(x853))));
evalcond[1]=((IkReal(0.300000000000000))+(((IkReal(-1.00000000000000))*(cj0)*(sj1)*(x842)))+(((IkReal(-1.00000000000000))*(x843)*(x852)))+(x865)+(x847)+(((IkReal(-1.00000000000000))*(x848))));
evalcond[2]=((((x843)*(x844)))+(((IkReal(-1.00000000000000))*(x864)))+(((IkReal(-1.00000000000000))*(x841)*(x851)))+(x863)+(((x849)*(x851)))+(((cj1)*(px)*(r01)))+(((IkReal(-1.00000000000000))*(x841)*(x845)))+(((IkReal(-1.00000000000000))*(r00)*(x853)))+(((x845)*(x849)))+(((IkReal(-1.00000000000000))*(sj1)*(x842)*(x846))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x847)*(x849)))+(((IkReal(-0.300000000000000))*(x849)))+(((x848)*(x849)))+(((r00)*(x843)))+(((x844)*(x853)))+(((IkReal(-1.00000000000000))*(r01)*(sj1)*(x842)))+(x865)+(((IkReal(-1.00000000000000))*(x841)*(x848)))+(((x841)*(x847)))+(((IkReal(0.300000000000000))*(x841)))+(((IkReal(-1.00000000000000))*(cj1)*(x842)*(x846))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x866=((IkReal(0.0800000000000000))*(cj1));
IkReal x867=((cj0)*(px));
IkReal x868=((py)*(sj0));
IkReal x869=((IkReal(0.0750000000000000))*(cj1));
IkReal x870=((IkReal(0.327500000000000))*(cj1));
IkReal x871=((IkReal(0.327500000000000))*(sj1));
IkReal x872=((IkReal(0.0750000000000000))*(sj1));
IkReal x873=((IkReal(0.00600000000000000))*(sj1));
IkReal x874=((IkReal(0.00600000000000000))*(cj1));
IkReal x875=((IkReal(0.0800000000000000))*(sj1)*(sj3));
IkReal x876=((IkReal(0.0800000000000000))*(cj3)*(sj1));
if( IKabs(((gconst4)*(((IkReal(-0.0982500000000000))+(((sj3)*(x874)))+(((x868)*(x871)))+(((IkReal(-0.0245625000000000))*(sj1)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((x867)*(x871)))+(((IkReal(-1.00000000000000))*(x867)*(x869)))+(((pz)*(x870)))+(((IkReal(-1.00000000000000))*(sj3)*(x866)*(x868)))+(((x868)*(x876)))+(((IkReal(0.00562500000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(cj3)*(x873)))+(((IkReal(-1.00000000000000))*(x868)*(x869)))+(((pz)*(x872)))+(((x867)*(x876)))+(((IkReal(-1.00000000000000))*(sj3)*(x866)*(x867)))+(((pz)*(x875)))+(((cj3)*(pz)*(x866))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst4)*(((IkReal(-0.0225000000000000))+(((IkReal(-0.0240000000000000))*(sj3)))+(((cj3)*(x866)*(x868)))+(((x868)*(x870)))+(((IkReal(-1.00000000000000))*(sj3)*(x873)))+(((x868)*(x875)))+(((x867)*(x875)))+(((x867)*(x870)))+(((x868)*(x872)))+(((pz)*(x869)))+(((cj3)*(x866)*(x867)))+(((pz)*(sj3)*(x866)))+(((IkReal(-0.0245625000000000))*(cj1)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(pz)*(x871)))+(((IkReal(-1.00000000000000))*(pz)*(x876)))+(((IkReal(-1.00000000000000))*(cj3)*(x874)))+(((x867)*(x872))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst4)*(((IkReal(-0.0982500000000000))+(((sj3)*(x874)))+(((x868)*(x871)))+(((IkReal(-0.0245625000000000))*(sj1)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((x867)*(x871)))+(((IkReal(-1.00000000000000))*(x867)*(x869)))+(((pz)*(x870)))+(((IkReal(-1.00000000000000))*(sj3)*(x866)*(x868)))+(((x868)*(x876)))+(((IkReal(0.00562500000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(cj3)*(x873)))+(((IkReal(-1.00000000000000))*(x868)*(x869)))+(((pz)*(x872)))+(((x867)*(x876)))+(((IkReal(-1.00000000000000))*(sj3)*(x866)*(x867)))+(((pz)*(x875)))+(((cj3)*(pz)*(x866)))))), ((gconst4)*(((IkReal(-0.0225000000000000))+(((IkReal(-0.0240000000000000))*(sj3)))+(((cj3)*(x866)*(x868)))+(((x868)*(x870)))+(((IkReal(-1.00000000000000))*(sj3)*(x873)))+(((x868)*(x875)))+(((x867)*(x875)))+(((x867)*(x870)))+(((x868)*(x872)))+(((pz)*(x869)))+(((cj3)*(x866)*(x867)))+(((pz)*(sj3)*(x866)))+(((IkReal(-0.0245625000000000))*(cj1)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(pz)*(x871)))+(((IkReal(-1.00000000000000))*(pz)*(x876)))+(((IkReal(-1.00000000000000))*(cj3)*(x874)))+(((x867)*(x872)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x877=IKcos(j2);
IkReal x878=IKsin(j2);
IkReal x879=((IkReal(0.0800000000000000))*(sj3));
IkReal x880=((cj0)*(r01));
IkReal x881=((IkReal(1.00000000000000))*(px));
IkReal x882=((py)*(sj1));
IkReal x883=((cj0)*(r02));
IkReal x884=((IkReal(0.0750000000000000))*(cj1));
IkReal x885=((r02)*(sj0));
IkReal x886=((IkReal(0.0750000000000000))*(sj1));
IkReal x887=((cj1)*(pz));
IkReal x888=((r00)*(sj0));
IkReal x889=((IkReal(0.0800000000000000))*(cj3));
IkReal x890=((pz)*(sj1));
IkReal x891=((IkReal(1.00000000000000))*(sj0));
IkReal x892=((cj1)*(py));
IkReal x893=((IkReal(0.0750000000000000))*(x878));
IkReal x894=((IkReal(0.327500000000000))*(x877));
IkReal x895=((IkReal(0.0750000000000000))*(x877));
IkReal x896=((IkReal(0.327500000000000))*(x878));
IkReal x897=((sj1)*(x888));
IkReal x898=((x878)*(x879));
IkReal x899=((x877)*(x889));
IkReal x900=((x877)*(x879));
IkReal x901=((x878)*(x889));
IkReal x902=((x893)+(x898));
IkReal x903=((x894)+(x899));
IkReal x904=((x900)+(x901)+(x896)+(x895));
evalcond[0]=((((IkReal(-1.00000000000000))*(x891)*(x892)))+(x884)+(((IkReal(-1.00000000000000))*(x902)))+(x903)+(((IkReal(-1.00000000000000))*(cj0)*(cj1)*(x881)))+(x890));
evalcond[1]=((IkReal(0.300000000000000))+(x886)+(((IkReal(-1.00000000000000))*(x887)))+(x904)+(((IkReal(-1.00000000000000))*(x882)*(x891)))+(((IkReal(-1.00000000000000))*(cj0)*(sj1)*(x881))));
evalcond[2]=((((cj1)*(px)*(r01)))+(x902)+(((IkReal(-1.00000000000000))*(x903)))+(((IkReal(-1.00000000000000))*(r00)*(x892)))+(((IkReal(-1.00000000000000))*(x880)*(x890)))+(((IkReal(-1.00000000000000))*(x880)*(x884)))+(((IkReal(-1.00000000000000))*(sj1)*(x881)*(x885)))+(((x884)*(x888)))+(((x882)*(x883)))+(((x888)*(x890))));
evalcond[3]=((((IkReal(0.300000000000000))*(x880)))+(((x887)*(x888)))+(((IkReal(-1.00000000000000))*(x880)*(x887)))+(((r00)*(x882)))+(((x883)*(x892)))+(((x880)*(x886)))+(((IkReal(-1.00000000000000))*(x886)*(x888)))+(((IkReal(-1.00000000000000))*(r01)*(sj1)*(x881)))+(((IkReal(-0.300000000000000))*(x888)))+(x904)+(((IkReal(-1.00000000000000))*(cj1)*(x881)*(x885))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
IkReal x905=((IkReal(0.0524000000000000))*(cj3));
IkReal x906=((IkReal(0.0120000000000000))*(sj3));
IkReal x907=(py)*(py);
IkReal x908=(px)*(px);
IkReal x909=(pz)*(pz);
IkReal x910=((r01)*(sj0));
IkReal x911=((py)*(r00));
IkReal x912=((pz)*(sj1));
IkReal x913=((py)*(r01));
IkReal x914=((px)*(sj0));
IkReal x915=((IkReal(0.600000000000000))*(r02));
IkReal x916=((IkReal(0.150000000000000))*(cj1));
IkReal x917=((cj0)*(sj1));
IkReal x918=((IkReal(0.150000000000000))*(px));
IkReal x919=((IkReal(2.00000000000000))*(cj1));
IkReal x920=((cj0)*(r01));
IkReal x921=((r02)*(sj1));
IkReal x922=((px)*(r00));
IkReal x923=((IkReal(0.300000000000000))*(r00));
IkReal x924=((IkReal(1.00000000000000))*(pz));
IkReal x925=((r00)*(sj1));
IkReal x926=((cj0)*(r00));
IkReal x927=((cj0)*(cj1));
IkReal x928=((IkReal(1.00000000000000))*(sj1));
IkReal x929=((IkReal(0.0956250000000000))*(r00));
IkReal x930=((IkReal(0.600000000000000))*(pz));
IkReal x931=((IkReal(0.600000000000000))*(sj1));
IkReal x932=((IkReal(2.00000000000000))*(px));
IkReal x933=((IkReal(2.00000000000000))*(sj1));
IkReal x934=((IkReal(0.150000000000000))*(sj1));
IkReal x935=((cj1)*(r02));
IkReal x936=((cj0)*(px));
IkReal x937=((IkReal(0.0843750000000000))*(cj1));
IkReal x938=((py)*(sj0));
IkReal x939=((pz)*(r02));
IkReal x940=((IkReal(1.00000000000000))*(cj1));
IkReal x941=((cj0)*(py));
IkReal x942=((r00)*(sj0));
IkReal x943=((r02)*(x938));
IkReal x944=((pp)*(x940));
IkReal x945=((IkReal(1.00000000000000))*(pp)*(r00));
IkReal x946=((x905)+(x906));
IkReal x947=((IkReal(2.00000000000000))*(r00)*(x908));
IkReal x948=((cj0)*(x932)*(x939));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j4)), IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x914)))+(x941));
evalcond[2]=((IkReal(1.00000000000000))+(x920)+(((IkReal(-1.00000000000000))*(x942))));
evalcond[3]=((x921)+(((IkReal(-1.00000000000000))*(x910)*(x940)))+(((IkReal(-1.00000000000000))*(x926)*(x940))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x910)*(x928)))+(((IkReal(-1.00000000000000))*(x935)))+(((IkReal(-1.00000000000000))*(r00)*(x917))));
evalcond[5]=((IkReal(0.0236562500000000))+(((IkReal(-1.00000000000000))*(pp)))+(x946)+(((IkReal(0.150000000000000))*(x938)))+(((IkReal(0.600000000000000))*(px)*(x917)))+(((cj0)*(x918)))+(((x931)*(x938)))+(((IkReal(-0.0450000000000000))*(sj1)))+(((cj1)*(x930))));
evalcond[6]=((((x917)*(x923)))+(((IkReal(-1.00000000000000))*(x913)))+(((IkReal(0.300000000000000))*(x935)))+(((IkReal(0.300000000000000))*(sj1)*(x910)))+(((IkReal(-1.00000000000000))*(r02)*(x924)))+(((IkReal(0.0750000000000000))*(x926)))+(((IkReal(-1.00000000000000))*(x922)))+(((IkReal(0.0750000000000000))*(x910))));
evalcond[7]=((((IkReal(0.300000000000000))*(cj1)*(x910)))+(x943)+(((IkReal(-0.300000000000000))*(x921)))+(((IkReal(-1.00000000000000))*(x924)*(x926)))+(((x923)*(x927)))+(((IkReal(-1.00000000000000))*(x910)*(x924)))+(((IkReal(-0.0750000000000000))*(r02)))+(((r02)*(x936))));
evalcond[8]=((IkReal(0.119281250000000))+(((cj1)*(x930)*(x942)))+(((IkReal(-2.00000000000000))*(x939)*(x941)))+(((pp)*(x920)))+(((IkReal(0.0956250000000000))*(x920)))+(((IkReal(0.0450000000000000))*(r01)*(x917)))+(((IkReal(-1.00000000000000))*(r01)*(x918)))+(x946)+(((IkReal(-1.00000000000000))*(px)*(r01)*(x931)))+(((IkReal(2.00000000000000))*(x908)*(x942)))+(((IkReal(0.150000000000000))*(x911)))+(((IkReal(-2.00000000000000))*(x907)*(x920)))+(((py)*(x915)*(x927)))+(((IkReal(-1.00000000000000))*(cj0)*(x911)*(x932)))+(((IkReal(-1.00000000000000))*(cj1)*(x914)*(x915)))+(((IkReal(2.00000000000000))*(x914)*(x939)))+(((x911)*(x931)))+(((IkReal(-1.00000000000000))*(cj1)*(x920)*(x930)))+(((py)*(x910)*(x932)))+(((IkReal(-1.00000000000000))*(sj0)*(x929)))+(((IkReal(-1.00000000000000))*(pp)*(x942)))+(((IkReal(-0.0450000000000000))*(sj0)*(x925))));
evalcond[9]=((((x917)*(x947)))+(((IkReal(0.0450000000000000))*(x926)))+(((r02)*(x916)*(x936)))+(((IkReal(-0.150000000000000))*(r02)*(x912)))+(((IkReal(-1.00000000000000))*(pz)*(x910)*(x916)))+(((IkReal(-1.00000000000000))*(pp)*(x910)*(x928)))+(((x911)*(x914)*(x933)))+(((IkReal(-1.00000000000000))*(pp)*(x935)))+(((pz)*(x913)*(x919)))+(((x916)*(x943)))+(((IkReal(-0.600000000000000))*(x922)))+(((IkReal(-0.600000000000000))*(x913)))+(((IkReal(0.0843750000000000))*(x935)))+(((IkReal(2.00000000000000))*(x912)*(x943)))+(((IkReal(-1.00000000000000))*(x917)*(x945)))+(((x917)*(x929)))+(((pz)*(x919)*(x922)))+(((IkReal(-1.00000000000000))*(x913)*(x934)))+(((IkReal(-1.00000000000000))*(pz)*(x916)*(x926)))+(((r02)*(x909)*(x919)))+(((IkReal(0.0956250000000000))*(sj1)*(x910)))+(((x907)*(x910)*(x933)))+(((IkReal(-1.00000000000000))*(x918)*(x925)))+(((IkReal(-1.00000000000000))*(pz)*(x915)))+(((x913)*(x917)*(x932)))+(((cj0)*(r02)*(x912)*(x932)))+(((IkReal(0.0450000000000000))*(x910))));
evalcond[10]=((((IkReal(0.0956250000000000))*(x921)))+(((x910)*(x930)))+(((x911)*(x914)*(x919)))+(((IkReal(0.0450000000000000))*(r02)))+(((x919)*(x938)*(x939)))+(((IkReal(-1.00000000000000))*(x910)*(x944)))+(((IkReal(-1.00000000000000))*(x910)*(x937)))+(((x919)*(x936)*(x939)))+(((IkReal(-1.00000000000000))*(x915)*(x938)))+(((IkReal(-1.00000000000000))*(x916)*(x922)))+(((x908)*(x919)*(x926)))+(((IkReal(-1.00000000000000))*(x913)*(x916)))+(((IkReal(-1.00000000000000))*(x915)*(x936)))+(((IkReal(-1.00000000000000))*(x916)*(x939)))+(((x913)*(x919)*(x936)))+(((IkReal(-1.00000000000000))*(x926)*(x944)))+(((IkReal(-2.00000000000000))*(x912)*(x913)))+(((IkReal(-0.150000000000000))*(x921)*(x938)))+(((IkReal(0.150000000000000))*(x910)*(x912)))+(((pp)*(x921)))+(((IkReal(-2.00000000000000))*(x909)*(x921)))+(((IkReal(0.150000000000000))*(x912)*(x926)))+(((IkReal(-2.00000000000000))*(x912)*(x922)))+(((IkReal(-1.00000000000000))*(x926)*(x937)))+(((x926)*(x930)))+(((x907)*(x910)*(x919)))+(((IkReal(-1.00000000000000))*(r02)*(x917)*(x918))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  && IKabs(evalcond[9]) < 0.0000010000000000  && IKabs(evalcond[10]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst6;
gconst6=IKsign(((IkReal(0.112881250000000))+(((IkReal(0.0524000000000000))*(cj3)))+(((IkReal(0.00640000000000000))*((sj3)*(sj3))))+(((IkReal(0.00640000000000000))*((cj3)*(cj3))))+(((IkReal(0.0120000000000000))*(sj3)))));
dummyeval[0]=((IkReal(17.6376953125000))+(((IkReal(8.18750000000000))*(cj3)))+((cj3)*(cj3))+(((IkReal(1.87500000000000))*(sj3)))+((sj3)*(sj3)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst7;
gconst7=IKsign(((IkReal(-0.112881250000000))+(((IkReal(-0.00640000000000000))*((sj3)*(sj3))))+(((IkReal(-0.0120000000000000))*(sj3)))+(((IkReal(-0.00640000000000000))*((cj3)*(cj3))))+(((IkReal(-0.0524000000000000))*(cj3)))));
dummyeval[0]=((IkReal(-17.6376953125000))+(((IkReal(-1.87500000000000))*(sj3)))+(((IkReal(-1.00000000000000))*((cj3)*(cj3))))+(((IkReal(-8.18750000000000))*(cj3)))+(((IkReal(-1.00000000000000))*((sj3)*(sj3)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x949=((cj0)*(r01));
IkReal x950=((pz)*(sj1));
IkReal x951=((IkReal(0.0800000000000000))*(sj3));
IkReal x952=((IkReal(0.00600000000000000))*(cj1));
IkReal x953=((IkReal(0.0750000000000000))*(cj1));
IkReal x954=((r00)*(sj0));
IkReal x955=((IkReal(0.0245625000000000))*(cj1));
IkReal x956=((px)*(r01));
IkReal x957=((IkReal(0.00562500000000000))*(cj1));
IkReal x958=((IkReal(0.0800000000000000))*(cj3));
IkReal x959=((cj1)*(pz));
IkReal x960=((px)*(r02));
IkReal x961=((py)*(sj1));
IkReal x962=((cj0)*(r02));
IkReal x963=((IkReal(0.00600000000000000))*(sj1));
IkReal x964=((IkReal(0.327500000000000))*(sj0));
IkReal x965=((IkReal(0.0750000000000000))*(sj0)*(sj1));
IkReal x966=((cj0)*(px)*(sj1));
IkReal x967=((cj1)*(py)*(r00));
IkReal x968=((IkReal(0.0800000000000000))*(sj0)*(sj1)*(x960));
if( IKabs(((gconst7)*(((IkReal(0.0982500000000000))+(((IkReal(-1.00000000000000))*(x951)*(x961)*(x962)))+(((IkReal(-1.00000000000000))*(cj1)*(x951)*(x956)))+(((sj3)*(x949)*(x952)))+(((IkReal(-1.00000000000000))*(x958)*(x966)))+(((IkReal(-1.00000000000000))*(sj3)*(x952)*(x954)))+(((IkReal(-0.327500000000000))*(x966)))+(((IkReal(-0.0750000000000000))*(x961)*(x962)))+(((IkReal(-1.00000000000000))*(sj0)*(x958)*(x961)))+(((IkReal(-0.327500000000000))*(x959)))+(((IkReal(-1.00000000000000))*(x954)*(x957)))+(((py)*(r00)*(x953)))+(((IkReal(-1.00000000000000))*(x961)*(x964)))+(((IkReal(0.0245625000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(x950)*(x951)*(x954)))+(((x949)*(x957)))+(((cj3)*(x963)))+(((x949)*(x950)*(x951)))+(((IkReal(0.0750000000000000))*(x949)*(x950)))+(((IkReal(-1.00000000000000))*(x953)*(x956)))+(((IkReal(-0.0750000000000000))*(x950)*(x954)))+(((sj0)*(sj1)*(x951)*(x960)))+(((IkReal(0.0240000000000000))*(cj3)))+(((x951)*(x967)))+(((IkReal(-1.00000000000000))*(x958)*(x959)))+(((x960)*(x965))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst7)*(((IkReal(0.0225000000000000))+(((IkReal(-1.00000000000000))*(cj3)*(x949)*(x952)))+(((IkReal(-0.0750000000000000))*(sj0)*(x961)))+(((IkReal(-1.00000000000000))*(x951)*(x959)))+(((IkReal(0.00562500000000000))*(sj1)))+(((IkReal(-0.327500000000000))*(x967)))+(((IkReal(-1.00000000000000))*(x951)*(x966)))+(((x950)*(x954)*(x958)))+(((IkReal(0.327500000000000))*(x961)*(x962)))+(((cj3)*(x952)*(x954)))+(((IkReal(-1.00000000000000))*(pz)*(x953)))+(((IkReal(-1.00000000000000))*(sj0)*(x951)*(x961)))+(((IkReal(-0.0750000000000000))*(x966)))+(((IkReal(-1.00000000000000))*(sj0)*(sj1)*(x958)*(x960)))+(((IkReal(-0.327500000000000))*(x949)*(x950)))+(((IkReal(-1.00000000000000))*(x958)*(x967)))+(((IkReal(0.327500000000000))*(x950)*(x954)))+(((sj3)*(x963)))+(((x958)*(x961)*(x962)))+(((cj1)*(x956)*(x958)))+(((IkReal(-1.00000000000000))*(sj1)*(x960)*(x964)))+(((IkReal(-1.00000000000000))*(x949)*(x950)*(x958)))+(((IkReal(-1.00000000000000))*(x949)*(x955)))+(((IkReal(0.327500000000000))*(cj1)*(x956)))+(((IkReal(0.0240000000000000))*(sj3)))+(((x954)*(x955))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst7)*(((IkReal(0.0982500000000000))+(((IkReal(-1.00000000000000))*(x951)*(x961)*(x962)))+(((IkReal(-1.00000000000000))*(cj1)*(x951)*(x956)))+(((sj3)*(x949)*(x952)))+(((IkReal(-1.00000000000000))*(x958)*(x966)))+(((IkReal(-1.00000000000000))*(sj3)*(x952)*(x954)))+(((IkReal(-0.327500000000000))*(x966)))+(((IkReal(-0.0750000000000000))*(x961)*(x962)))+(((IkReal(-1.00000000000000))*(sj0)*(x958)*(x961)))+(((IkReal(-0.327500000000000))*(x959)))+(((IkReal(-1.00000000000000))*(x954)*(x957)))+(((py)*(r00)*(x953)))+(((IkReal(-1.00000000000000))*(x961)*(x964)))+(((IkReal(0.0245625000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(x950)*(x951)*(x954)))+(((x949)*(x957)))+(((cj3)*(x963)))+(((x949)*(x950)*(x951)))+(((IkReal(0.0750000000000000))*(x949)*(x950)))+(((IkReal(-1.00000000000000))*(x953)*(x956)))+(((IkReal(-0.0750000000000000))*(x950)*(x954)))+(((sj0)*(sj1)*(x951)*(x960)))+(((IkReal(0.0240000000000000))*(cj3)))+(((x951)*(x967)))+(((IkReal(-1.00000000000000))*(x958)*(x959)))+(((x960)*(x965)))))), ((gconst7)*(((IkReal(0.0225000000000000))+(((IkReal(-1.00000000000000))*(cj3)*(x949)*(x952)))+(((IkReal(-0.0750000000000000))*(sj0)*(x961)))+(((IkReal(-1.00000000000000))*(x951)*(x959)))+(((IkReal(0.00562500000000000))*(sj1)))+(((IkReal(-0.327500000000000))*(x967)))+(((IkReal(-1.00000000000000))*(x951)*(x966)))+(((x950)*(x954)*(x958)))+(((IkReal(0.327500000000000))*(x961)*(x962)))+(((cj3)*(x952)*(x954)))+(((IkReal(-1.00000000000000))*(pz)*(x953)))+(((IkReal(-1.00000000000000))*(sj0)*(x951)*(x961)))+(((IkReal(-0.0750000000000000))*(x966)))+(((IkReal(-1.00000000000000))*(sj0)*(sj1)*(x958)*(x960)))+(((IkReal(-0.327500000000000))*(x949)*(x950)))+(((IkReal(-1.00000000000000))*(x958)*(x967)))+(((IkReal(0.327500000000000))*(x950)*(x954)))+(((sj3)*(x963)))+(((x958)*(x961)*(x962)))+(((cj1)*(x956)*(x958)))+(((IkReal(-1.00000000000000))*(sj1)*(x960)*(x964)))+(((IkReal(-1.00000000000000))*(x949)*(x950)*(x958)))+(((IkReal(-1.00000000000000))*(x949)*(x955)))+(((IkReal(0.327500000000000))*(cj1)*(x956)))+(((IkReal(0.0240000000000000))*(sj3)))+(((x954)*(x955)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x969=IKcos(j2);
IkReal x970=IKsin(j2);
IkReal x971=((IkReal(0.0800000000000000))*(sj3));
IkReal x972=((cj0)*(r01));
IkReal x973=((IkReal(1.00000000000000))*(px));
IkReal x974=((py)*(sj1));
IkReal x975=((cj0)*(r02));
IkReal x976=((IkReal(0.0750000000000000))*(cj1));
IkReal x977=((r02)*(sj0));
IkReal x978=((IkReal(0.0750000000000000))*(sj1));
IkReal x979=((cj1)*(pz));
IkReal x980=((r00)*(sj0));
IkReal x981=((IkReal(0.0800000000000000))*(cj3));
IkReal x982=((pz)*(sj1));
IkReal x983=((IkReal(1.00000000000000))*(sj0));
IkReal x984=((cj1)*(py));
IkReal x985=((IkReal(0.327500000000000))*(x969));
IkReal x986=((IkReal(0.0750000000000000))*(x970));
IkReal x987=((IkReal(0.0750000000000000))*(x969));
IkReal x988=((IkReal(0.327500000000000))*(x970));
IkReal x989=((sj1)*(x980));
IkReal x990=((x969)*(x981));
IkReal x991=((x970)*(x971));
IkReal x992=((x969)*(x971));
IkReal x993=((x970)*(x981));
IkReal x994=((x986)+(x991));
IkReal x995=((x985)+(x990));
IkReal x996=((x988)+(x987)+(x993)+(x992));
evalcond[0]=((((IkReal(-1.00000000000000))*(x994)))+(((IkReal(-1.00000000000000))*(cj0)*(cj1)*(x973)))+(x976)+(x982)+(((IkReal(-1.00000000000000))*(x983)*(x984)))+(x995));
evalcond[1]=((IkReal(0.300000000000000))+(x978)+(((IkReal(-1.00000000000000))*(x979)))+(((IkReal(-1.00000000000000))*(x974)*(x983)))+(((IkReal(-1.00000000000000))*(cj0)*(sj1)*(x973)))+(x996));
evalcond[2]=((((IkReal(-1.00000000000000))*(x972)*(x976)))+(((IkReal(-1.00000000000000))*(x994)))+(((x980)*(x982)))+(((IkReal(-1.00000000000000))*(r00)*(x984)))+(((cj1)*(px)*(r01)))+(((IkReal(-1.00000000000000))*(x972)*(x982)))+(((x976)*(x980)))+(((x974)*(x975)))+(((IkReal(-1.00000000000000))*(sj1)*(x973)*(x977)))+(x995));
evalcond[3]=((((x979)*(x980)))+(((IkReal(-1.00000000000000))*(r01)*(sj1)*(x973)))+(((IkReal(-0.300000000000000))*(x980)))+(((x972)*(x978)))+(((IkReal(0.300000000000000))*(x972)))+(((IkReal(-1.00000000000000))*(x978)*(x980)))+(((IkReal(-1.00000000000000))*(x996)))+(((IkReal(-1.00000000000000))*(cj1)*(x973)*(x977)))+(((IkReal(-1.00000000000000))*(x972)*(x979)))+(((x975)*(x984)))+(((r00)*(x974))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x997=((IkReal(0.0800000000000000))*(cj1));
IkReal x998=((cj0)*(px));
IkReal x999=((py)*(sj0));
IkReal x1000=((IkReal(0.0750000000000000))*(cj1));
IkReal x1001=((IkReal(0.327500000000000))*(cj1));
IkReal x1002=((IkReal(0.327500000000000))*(sj1));
IkReal x1003=((IkReal(0.0750000000000000))*(sj1));
IkReal x1004=((IkReal(0.00600000000000000))*(sj1));
IkReal x1005=((IkReal(0.00600000000000000))*(cj1));
IkReal x1006=((IkReal(0.0800000000000000))*(sj1)*(sj3));
IkReal x1007=((IkReal(0.0800000000000000))*(cj3)*(sj1));
if( IKabs(((gconst6)*(((IkReal(-0.0982500000000000))+(((pz)*(x1003)))+(((IkReal(-1.00000000000000))*(x1000)*(x998)))+(((x1002)*(x998)))+(((pz)*(x1001)))+(((sj3)*(x1005)))+(((IkReal(-0.0245625000000000))*(sj1)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((pz)*(x1006)))+(((cj3)*(pz)*(x997)))+(((IkReal(-1.00000000000000))*(sj3)*(x997)*(x998)))+(((x1007)*(x999)))+(((x1007)*(x998)))+(((IkReal(0.00562500000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(x1000)*(x999)))+(((IkReal(-1.00000000000000))*(cj3)*(x1004)))+(((IkReal(-1.00000000000000))*(sj3)*(x997)*(x999)))+(((x1002)*(x999))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst6)*(((IkReal(-0.0225000000000000))+(((IkReal(-1.00000000000000))*(pz)*(x1007)))+(((IkReal(-0.0240000000000000))*(sj3)))+(((pz)*(sj3)*(x997)))+(((IkReal(-1.00000000000000))*(pz)*(x1002)))+(((x1003)*(x998)))+(((x1003)*(x999)))+(((cj3)*(x997)*(x998)))+(((IkReal(-1.00000000000000))*(sj3)*(x1004)))+(((IkReal(-1.00000000000000))*(cj3)*(x1005)))+(((IkReal(-0.0245625000000000))*(cj1)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((x1001)*(x998)))+(((cj3)*(x997)*(x999)))+(((x1001)*(x999)))+(((x1006)*(x998)))+(((pz)*(x1000)))+(((x1006)*(x999))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst6)*(((IkReal(-0.0982500000000000))+(((pz)*(x1003)))+(((IkReal(-1.00000000000000))*(x1000)*(x998)))+(((x1002)*(x998)))+(((pz)*(x1001)))+(((sj3)*(x1005)))+(((IkReal(-0.0245625000000000))*(sj1)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((pz)*(x1006)))+(((cj3)*(pz)*(x997)))+(((IkReal(-1.00000000000000))*(sj3)*(x997)*(x998)))+(((x1007)*(x999)))+(((x1007)*(x998)))+(((IkReal(0.00562500000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(x1000)*(x999)))+(((IkReal(-1.00000000000000))*(cj3)*(x1004)))+(((IkReal(-1.00000000000000))*(sj3)*(x997)*(x999)))+(((x1002)*(x999)))))), ((gconst6)*(((IkReal(-0.0225000000000000))+(((IkReal(-1.00000000000000))*(pz)*(x1007)))+(((IkReal(-0.0240000000000000))*(sj3)))+(((pz)*(sj3)*(x997)))+(((IkReal(-1.00000000000000))*(pz)*(x1002)))+(((x1003)*(x998)))+(((x1003)*(x999)))+(((cj3)*(x997)*(x998)))+(((IkReal(-1.00000000000000))*(sj3)*(x1004)))+(((IkReal(-1.00000000000000))*(cj3)*(x1005)))+(((IkReal(-0.0245625000000000))*(cj1)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((x1001)*(x998)))+(((cj3)*(x997)*(x999)))+(((x1001)*(x999)))+(((x1006)*(x998)))+(((pz)*(x1000)))+(((x1006)*(x999)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x1008=IKcos(j2);
IkReal x1009=IKsin(j2);
IkReal x1010=((IkReal(0.0800000000000000))*(sj3));
IkReal x1011=((cj0)*(r01));
IkReal x1012=((IkReal(1.00000000000000))*(px));
IkReal x1013=((py)*(sj1));
IkReal x1014=((cj0)*(r02));
IkReal x1015=((IkReal(0.0750000000000000))*(cj1));
IkReal x1016=((r02)*(sj0));
IkReal x1017=((IkReal(0.0750000000000000))*(sj1));
IkReal x1018=((cj1)*(pz));
IkReal x1019=((r00)*(sj0));
IkReal x1020=((IkReal(0.0800000000000000))*(cj3));
IkReal x1021=((pz)*(sj1));
IkReal x1022=((IkReal(1.00000000000000))*(sj0));
IkReal x1023=((cj1)*(py));
IkReal x1024=((IkReal(0.327500000000000))*(x1008));
IkReal x1025=((IkReal(0.0750000000000000))*(x1009));
IkReal x1026=((IkReal(0.0750000000000000))*(x1008));
IkReal x1027=((IkReal(0.327500000000000))*(x1009));
IkReal x1028=((sj1)*(x1019));
IkReal x1029=((x1008)*(x1020));
IkReal x1030=((x1009)*(x1010));
IkReal x1031=((x1008)*(x1010));
IkReal x1032=((x1009)*(x1020));
IkReal x1033=((x1030)+(x1025));
IkReal x1034=((x1024)+(x1029));
IkReal x1035=((x1032)+(x1031)+(x1027)+(x1026));
evalcond[0]=((x1034)+(((IkReal(-1.00000000000000))*(x1033)))+(((IkReal(-1.00000000000000))*(x1022)*(x1023)))+(((IkReal(-1.00000000000000))*(cj0)*(cj1)*(x1012)))+(x1015)+(x1021));
evalcond[1]=((IkReal(0.300000000000000))+(((IkReal(-1.00000000000000))*(x1013)*(x1022)))+(((IkReal(-1.00000000000000))*(cj0)*(sj1)*(x1012)))+(x1035)+(((IkReal(-1.00000000000000))*(x1018)))+(x1017));
evalcond[2]=((((x1013)*(x1014)))+(((IkReal(-1.00000000000000))*(x1011)*(x1015)))+(((IkReal(-1.00000000000000))*(r00)*(x1023)))+(((IkReal(-1.00000000000000))*(x1011)*(x1021)))+(x1034)+(((IkReal(-1.00000000000000))*(x1033)))+(((IkReal(-1.00000000000000))*(sj1)*(x1012)*(x1016)))+(((cj1)*(px)*(r01)))+(((x1019)*(x1021)))+(((x1015)*(x1019))));
evalcond[3]=((((r00)*(x1013)))+(((IkReal(-1.00000000000000))*(x1017)*(x1019)))+(((x1011)*(x1017)))+(((IkReal(-1.00000000000000))*(cj1)*(x1012)*(x1016)))+(((IkReal(-1.00000000000000))*(x1011)*(x1018)))+(((x1014)*(x1023)))+(((IkReal(-0.300000000000000))*(x1019)))+(((IkReal(-1.00000000000000))*(x1035)))+(((IkReal(0.300000000000000))*(x1011)))+(((x1018)*(x1019)))+(((IkReal(-1.00000000000000))*(r01)*(sj1)*(x1012))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x1036=((r02)*(sj1));
IkReal x1037=((cj0)*(px));
IkReal x1038=((IkReal(0.0800000000000000))*(sj3));
IkReal x1039=((cj4)*(sj3));
IkReal x1040=((pz)*(sj1));
IkReal x1041=((IkReal(0.0800000000000000))*(cj3));
IkReal x1042=((IkReal(1.00000000000000))*(cj1));
IkReal x1043=((py)*(sj0));
IkReal x1044=((cj1)*(r01)*(sj0));
IkReal x1045=((cj1)*(cj3)*(cj4));
IkReal x1046=((cj0)*(cj1)*(r00));
IkReal x1047=((IkReal(0.0800000000000000))*(x1046));
if( IKabs(((gconst3)*(((((IkReal(-1.00000000000000))*(x1039)*(x1042)*(x1043)))+(((x1039)*(x1040)))+(((IkReal(-0.327500000000000))*(x1046)))+(((IkReal(-1.00000000000000))*(x1041)*(x1044)))+(((IkReal(-0.327500000000000))*(x1044)))+(((x1036)*(x1041)))+(((IkReal(-1.00000000000000))*(x1037)*(x1039)*(x1042)))+(((IkReal(0.0750000000000000))*(cj1)*(x1039)))+(((IkReal(-1.00000000000000))*(x1041)*(x1046)))+(((IkReal(0.327500000000000))*(x1036))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst3)*(((((IkReal(0.0750000000000000))*(x1036)))+(((IkReal(-1.00000000000000))*(x1038)*(x1044)))+(((x1043)*(x1045)))+(((IkReal(-0.0750000000000000))*(x1044)))+(((IkReal(-0.0750000000000000))*(x1045)))+(((IkReal(-1.00000000000000))*(x1038)*(x1046)))+(((x1036)*(x1038)))+(((IkReal(-1.00000000000000))*(cj3)*(cj4)*(x1040)))+(((IkReal(-0.0750000000000000))*(x1046)))+(((x1037)*(x1045))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst3)*(((((IkReal(-1.00000000000000))*(x1039)*(x1042)*(x1043)))+(((x1039)*(x1040)))+(((IkReal(-0.327500000000000))*(x1046)))+(((IkReal(-1.00000000000000))*(x1041)*(x1044)))+(((IkReal(-0.327500000000000))*(x1044)))+(((x1036)*(x1041)))+(((IkReal(-1.00000000000000))*(x1037)*(x1039)*(x1042)))+(((IkReal(0.0750000000000000))*(cj1)*(x1039)))+(((IkReal(-1.00000000000000))*(x1041)*(x1046)))+(((IkReal(0.327500000000000))*(x1036)))))), ((gconst3)*(((((IkReal(0.0750000000000000))*(x1036)))+(((IkReal(-1.00000000000000))*(x1038)*(x1044)))+(((x1043)*(x1045)))+(((IkReal(-0.0750000000000000))*(x1044)))+(((IkReal(-0.0750000000000000))*(x1045)))+(((IkReal(-1.00000000000000))*(x1038)*(x1046)))+(((x1036)*(x1038)))+(((IkReal(-1.00000000000000))*(cj3)*(cj4)*(x1040)))+(((IkReal(-0.0750000000000000))*(x1046)))+(((x1037)*(x1045)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x1048=IKcos(j2);
IkReal x1049=IKsin(j2);
IkReal x1050=(py)*(py);
IkReal x1051=(px)*(px);
IkReal x1052=(pz)*(pz);
IkReal x1053=((sj0)*(sj1));
IkReal x1054=((IkReal(1.00000000000000))*(r01));
IkReal x1055=((r00)*(sj1));
IkReal x1056=((IkReal(0.0750000000000000))*(r00));
IkReal x1057=((IkReal(0.0491250000000000))*(sj3));
IkReal x1058=((cj1)*(r01));
IkReal x1059=((IkReal(0.150000000000000))*(py));
IkReal x1060=((pz)*(r02));
IkReal x1061=((px)*(r02));
IkReal x1062=((IkReal(0.0750000000000000))*(sj4));
IkReal x1063=((cj1)*(sj0));
IkReal x1064=((pz)*(r00));
IkReal x1065=((IkReal(0.0750000000000000))*(cj0));
IkReal x1066=((IkReal(2.00000000000000))*(cj0));
IkReal x1067=((cj1)*(r02));
IkReal x1068=((IkReal(0.150000000000000))*(sj1));
IkReal x1069=((px)*(r00));
IkReal x1070=((IkReal(2.00000000000000))*(py));
IkReal x1071=((r02)*(sj1));
IkReal x1072=((IkReal(0.150000000000000))*(cj1));
IkReal x1073=((IkReal(0.108031250000000))*(cj3));
IkReal x1074=((cj0)*(py));
IkReal x1075=((r01)*(sj1));
IkReal x1076=((IkReal(0.0800000000000000))*(cj3));
IkReal x1077=((IkReal(0.150000000000000))*(pz));
IkReal x1078=((IkReal(0.0491250000000000))*(cj3));
IkReal x1079=((cj1)*(pz));
IkReal x1080=((IkReal(0.0952312500000000))*(sj3));
IkReal x1081=((IkReal(0.600000000000000))*(py));
IkReal x1082=((IkReal(1.00000000000000))*(py));
IkReal x1083=((px)*(sj1));
IkReal x1084=((IkReal(1.00000000000000))*(cj0));
IkReal x1085=((cj0)*(r00));
IkReal x1086=((IkReal(0.600000000000000))*(cj0));
IkReal x1087=((IkReal(1.00000000000000))*(sj3));
IkReal x1088=((pz)*(sj1));
IkReal x1089=((IkReal(0.0800000000000000))*(sj3));
IkReal x1090=((px)*(py));
IkReal x1091=((cj1)*(r00));
IkReal x1092=((r01)*(sj0));
IkReal x1093=((cj1)*(px));
IkReal x1094=((cj4)*(x1049));
IkReal x1095=((cj4)*(x1048));
IkReal x1096=((sj4)*(x1049));
IkReal x1097=((IkReal(2.00000000000000))*(x1052));
IkReal x1098=((sj4)*(x1048));
IkReal x1099=((IkReal(2.00000000000000))*(x1050));
IkReal x1100=((x1048)*(x1089));
IkReal x1101=((px)*(x1060)*(x1066));
evalcond[0]=((((IkReal(-1.00000000000000))*(x1084)*(x1091)))+(((IkReal(-1.00000000000000))*(x1087)*(x1095)))+(((IkReal(-1.00000000000000))*(x1054)*(x1063)))+(((IkReal(-1.00000000000000))*(cj3)*(x1094)))+(x1071));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1067)))+(((IkReal(-1.00000000000000))*(x1087)*(x1094)))+(((IkReal(-1.00000000000000))*(x1053)*(x1054)))+(((cj3)*(x1095)))+(((IkReal(-1.00000000000000))*(x1055)*(x1084))));
evalcond[2]=((x1088)+(((IkReal(-0.0750000000000000))*(x1049)))+(((x1048)*(x1076)))+(((IkReal(-1.00000000000000))*(x1084)*(x1093)))+(((IkReal(0.327500000000000))*(x1048)))+(((IkReal(-1.00000000000000))*(x1049)*(x1089)))+(((IkReal(-1.00000000000000))*(x1063)*(x1082)))+(((IkReal(0.0750000000000000))*(cj1))));
evalcond[3]=((IkReal(0.300000000000000))+(x1100)+(((IkReal(0.327500000000000))*(x1049)))+(((IkReal(-1.00000000000000))*(x1083)*(x1084)))+(((IkReal(-1.00000000000000))*(x1079)))+(((IkReal(0.0750000000000000))*(x1048)))+(((IkReal(-1.00000000000000))*(x1053)*(x1082)))+(((IkReal(0.0750000000000000))*(sj1)))+(((x1049)*(x1076))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x1076)*(x1098)))+(((x1089)*(x1096)))+(((x1049)*(x1062)))+(((x1053)*(x1064)))+(((x1071)*(x1074)))+(((IkReal(-1.00000000000000))*(x1082)*(x1091)))+(((IkReal(-1.00000000000000))*(x1058)*(x1065)))+(((x1056)*(x1063)))+(((px)*(x1058)))+(((IkReal(-1.00000000000000))*(cj0)*(x1054)*(x1088)))+(((IkReal(-0.327500000000000))*(x1098)))+(((IkReal(-1.00000000000000))*(x1053)*(x1061))));
evalcond[5]=((((py)*(x1055)))+(((IkReal(-1.00000000000000))*(x1061)*(x1063)))+(((IkReal(-1.00000000000000))*(x1054)*(x1083)))+(((x1089)*(x1098)))+(((x1063)*(x1064)))+(((x1065)*(x1075)))+(((x1076)*(x1096)))+(((IkReal(-0.300000000000000))*(r00)*(sj0)))+(((IkReal(-1.00000000000000))*(x1053)*(x1056)))+(((IkReal(0.300000000000000))*(cj0)*(r01)))+(((IkReal(-1.00000000000000))*(cj0)*(x1054)*(x1079)))+(((x1048)*(x1062)))+(((x1067)*(x1074)))+(((IkReal(0.327500000000000))*(x1096))));
evalcond[6]=((((IkReal(0.0450000000000000))*(x1092)))+(((r01)*(x1053)*(x1099)))+(((IkReal(-1.00000000000000))*(x1078)*(x1094)))+(((r02)*(x1059)*(x1063)))+(((IkReal(0.0450000000000000))*(x1085)))+(((IkReal(2.00000000000000))*(x1064)*(x1093)))+(((pz)*(x1058)*(x1070)))+(((x1060)*(x1066)*(x1083)))+(((IkReal(-1.00000000000000))*(r01)*(x1081)))+(((cj0)*(x1061)*(x1072)))+(((IkReal(-1.00000000000000))*(cj0)*(x1064)*(x1072)))+(((x1080)*(x1094)))+(((IkReal(-0.600000000000000))*(x1060)))+(((x1057)*(x1095)))+(((IkReal(-1.00000000000000))*(pp)*(x1055)*(x1084)))+(((IkReal(-0.600000000000000))*(x1069)))+(((IkReal(0.0956250000000000))*(r01)*(x1053)))+(((IkReal(0.0843750000000000))*(x1067)))+(((IkReal(-1.00000000000000))*(pp)*(x1053)*(x1054)))+(((IkReal(-1.00000000000000))*(x1060)*(x1068)))+(((IkReal(0.0524000000000000))*(x1095)))+(((x1051)*(x1055)*(x1066)))+(((IkReal(-1.00000000000000))*(sj0)*(x1058)*(x1077)))+(((IkReal(-0.0120000000000000))*(x1094)))+(((x1053)*(x1060)*(x1070)))+(((IkReal(-1.00000000000000))*(pp)*(x1067)))+(((IkReal(-1.00000000000000))*(x1059)*(x1075)))+(((x1067)*(x1097)))+(((x1073)*(x1095)))+(((x1053)*(x1069)*(x1070)))+(((IkReal(-0.150000000000000))*(px)*(x1055)))+(((x1066)*(x1075)*(x1090)))+(((IkReal(0.0956250000000000))*(cj0)*(x1055))));
evalcond[7]=((((x1060)*(x1063)*(x1070)))+(((IkReal(-1.00000000000000))*(x1058)*(x1059)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x1081)))+(((IkReal(0.0956250000000000))*(x1071)))+(((IkReal(-1.00000000000000))*(x1060)*(x1072)))+(((IkReal(0.0450000000000000))*(r02)))+(((IkReal(-1.00000000000000))*(pz)*(x1070)*(x1075)))+(((x1051)*(x1066)*(x1091)))+(((IkReal(0.600000000000000))*(pz)*(x1092)))+(((x1060)*(x1066)*(x1093)))+(((r01)*(x1053)*(x1077)))+(((pp)*(x1071)))+(((x1063)*(x1069)*(x1070)))+(((IkReal(-0.0524000000000000))*(x1094)))+(((IkReal(-1.00000000000000))*(x1057)*(x1094)))+(((x1064)*(x1086)))+(((IkReal(-1.00000000000000))*(cj0)*(x1061)*(x1068)))+(((IkReal(-0.0843750000000000))*(cj1)*(x1085)))+(((IkReal(-1.00000000000000))*(x1078)*(x1095)))+(((IkReal(-1.00000000000000))*(x1073)*(x1094)))+(((IkReal(-1.00000000000000))*(x1069)*(x1072)))+(((cj0)*(x1055)*(x1077)))+(((IkReal(-2.00000000000000))*(px)*(pz)*(x1055)))+(((IkReal(-1.00000000000000))*(r02)*(x1053)*(x1059)))+(((x1080)*(x1095)))+(((sj0)*(x1058)*(x1099)))+(((IkReal(-1.00000000000000))*(x1061)*(x1086)))+(((IkReal(-1.00000000000000))*(pp)*(x1054)*(x1063)))+(((x1058)*(x1066)*(x1090)))+(((IkReal(-1.00000000000000))*(x1071)*(x1097)))+(((IkReal(-0.0120000000000000))*(x1095)))+(((IkReal(-0.0843750000000000))*(sj0)*(x1058)))+(((IkReal(-1.00000000000000))*(pp)*(x1084)*(x1091))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  || IKabs(evalcond[6]) > 0.000001  || IKabs(evalcond[7]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x1102=((IkReal(1.00000000000000))*(cj1));
IkReal x1103=((cj0)*(r00));
IkReal x1104=((cj3)*(r02));
IkReal x1105=((sj1)*(sj3));
IkReal x1106=((r01)*(sj0));
IkReal x1107=((cj3)*(x1106));
if( IKabs(((gconst2)*(((((sj1)*(x1104)))+(((IkReal(-1.00000000000000))*(x1103)*(x1105)))+(((IkReal(-1.00000000000000))*(r02)*(sj3)*(x1102)))+(((IkReal(-1.00000000000000))*(x1105)*(x1106)))+(((IkReal(-1.00000000000000))*(cj3)*(x1102)*(x1103)))+(((IkReal(-1.00000000000000))*(x1102)*(x1107))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst2)*(((((sj1)*(x1107)))+(((r02)*(x1105)))+(((cj1)*(x1104)))+(((cj3)*(sj1)*(x1103)))+(((IkReal(-1.00000000000000))*(sj3)*(x1102)*(x1103)))+(((IkReal(-1.00000000000000))*(sj3)*(x1102)*(x1106))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst2)*(((((sj1)*(x1104)))+(((IkReal(-1.00000000000000))*(x1103)*(x1105)))+(((IkReal(-1.00000000000000))*(r02)*(sj3)*(x1102)))+(((IkReal(-1.00000000000000))*(x1105)*(x1106)))+(((IkReal(-1.00000000000000))*(cj3)*(x1102)*(x1103)))+(((IkReal(-1.00000000000000))*(x1102)*(x1107)))))), ((gconst2)*(((((sj1)*(x1107)))+(((r02)*(x1105)))+(((cj1)*(x1104)))+(((cj3)*(sj1)*(x1103)))+(((IkReal(-1.00000000000000))*(sj3)*(x1102)*(x1103)))+(((IkReal(-1.00000000000000))*(sj3)*(x1102)*(x1106)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x1108=IKcos(j2);
IkReal x1109=IKsin(j2);
IkReal x1110=(py)*(py);
IkReal x1111=(px)*(px);
IkReal x1112=(pz)*(pz);
IkReal x1113=((sj0)*(sj1));
IkReal x1114=((IkReal(1.00000000000000))*(r01));
IkReal x1115=((r00)*(sj1));
IkReal x1116=((IkReal(0.0750000000000000))*(r00));
IkReal x1117=((IkReal(0.0491250000000000))*(sj3));
IkReal x1118=((cj1)*(r01));
IkReal x1119=((IkReal(0.150000000000000))*(py));
IkReal x1120=((pz)*(r02));
IkReal x1121=((px)*(r02));
IkReal x1122=((IkReal(0.0750000000000000))*(sj4));
IkReal x1123=((cj1)*(sj0));
IkReal x1124=((pz)*(r00));
IkReal x1125=((IkReal(0.0750000000000000))*(cj0));
IkReal x1126=((IkReal(2.00000000000000))*(cj0));
IkReal x1127=((cj1)*(r02));
IkReal x1128=((IkReal(0.150000000000000))*(sj1));
IkReal x1129=((px)*(r00));
IkReal x1130=((IkReal(2.00000000000000))*(py));
IkReal x1131=((r02)*(sj1));
IkReal x1132=((IkReal(0.150000000000000))*(cj1));
IkReal x1133=((IkReal(0.108031250000000))*(cj3));
IkReal x1134=((cj0)*(py));
IkReal x1135=((r01)*(sj1));
IkReal x1136=((IkReal(0.0800000000000000))*(cj3));
IkReal x1137=((IkReal(0.150000000000000))*(pz));
IkReal x1138=((IkReal(0.0491250000000000))*(cj3));
IkReal x1139=((cj1)*(pz));
IkReal x1140=((IkReal(0.0952312500000000))*(sj3));
IkReal x1141=((IkReal(0.600000000000000))*(py));
IkReal x1142=((IkReal(1.00000000000000))*(py));
IkReal x1143=((px)*(sj1));
IkReal x1144=((IkReal(1.00000000000000))*(cj0));
IkReal x1145=((cj0)*(r00));
IkReal x1146=((IkReal(0.600000000000000))*(cj0));
IkReal x1147=((IkReal(1.00000000000000))*(sj3));
IkReal x1148=((pz)*(sj1));
IkReal x1149=((IkReal(0.0800000000000000))*(sj3));
IkReal x1150=((px)*(py));
IkReal x1151=((cj1)*(r00));
IkReal x1152=((r01)*(sj0));
IkReal x1153=((cj1)*(px));
IkReal x1154=((cj4)*(x1109));
IkReal x1155=((cj4)*(x1108));
IkReal x1156=((sj4)*(x1109));
IkReal x1157=((IkReal(2.00000000000000))*(x1112));
IkReal x1158=((sj4)*(x1108));
IkReal x1159=((IkReal(2.00000000000000))*(x1110));
IkReal x1160=((x1108)*(x1149));
IkReal x1161=((px)*(x1120)*(x1126));
evalcond[0]=((((IkReal(-1.00000000000000))*(x1147)*(x1155)))+(((IkReal(-1.00000000000000))*(cj3)*(x1154)))+(x1131)+(((IkReal(-1.00000000000000))*(x1144)*(x1151)))+(((IkReal(-1.00000000000000))*(x1114)*(x1123))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1127)))+(((cj3)*(x1155)))+(((IkReal(-1.00000000000000))*(x1113)*(x1114)))+(((IkReal(-1.00000000000000))*(x1147)*(x1154)))+(((IkReal(-1.00000000000000))*(x1115)*(x1144))));
evalcond[2]=((((IkReal(-0.0750000000000000))*(x1109)))+(x1148)+(((IkReal(-1.00000000000000))*(x1144)*(x1153)))+(((x1108)*(x1136)))+(((IkReal(-1.00000000000000))*(x1123)*(x1142)))+(((IkReal(-1.00000000000000))*(x1109)*(x1149)))+(((IkReal(0.327500000000000))*(x1108)))+(((IkReal(0.0750000000000000))*(cj1))));
evalcond[3]=((IkReal(0.300000000000000))+(x1160)+(((IkReal(-1.00000000000000))*(x1139)))+(((IkReal(-1.00000000000000))*(x1113)*(x1142)))+(((IkReal(-1.00000000000000))*(x1143)*(x1144)))+(((IkReal(0.327500000000000))*(x1109)))+(((IkReal(0.0750000000000000))*(x1108)))+(((IkReal(0.0750000000000000))*(sj1)))+(((x1109)*(x1136))));
evalcond[4]=((((x1131)*(x1134)))+(((x1116)*(x1123)))+(((IkReal(-1.00000000000000))*(x1136)*(x1158)))+(((IkReal(-1.00000000000000))*(cj0)*(x1114)*(x1148)))+(((x1149)*(x1156)))+(((x1109)*(x1122)))+(((x1113)*(x1124)))+(((IkReal(-0.327500000000000))*(x1158)))+(((IkReal(-1.00000000000000))*(x1142)*(x1151)))+(((IkReal(-1.00000000000000))*(x1118)*(x1125)))+(((IkReal(-1.00000000000000))*(x1113)*(x1121)))+(((px)*(x1118))));
evalcond[5]=((((IkReal(-1.00000000000000))*(cj0)*(x1114)*(x1139)))+(((x1125)*(x1135)))+(((x1136)*(x1156)))+(((IkReal(-1.00000000000000))*(x1121)*(x1123)))+(((IkReal(-0.300000000000000))*(r00)*(sj0)))+(((x1108)*(x1122)))+(((py)*(x1115)))+(((x1123)*(x1124)))+(((IkReal(-1.00000000000000))*(x1113)*(x1116)))+(((IkReal(-1.00000000000000))*(x1114)*(x1143)))+(((x1127)*(x1134)))+(((IkReal(0.300000000000000))*(cj0)*(r01)))+(((IkReal(0.327500000000000))*(x1156)))+(((x1149)*(x1158))));
evalcond[6]=((((x1133)*(x1155)))+(((IkReal(-0.600000000000000))*(x1129)))+(((pz)*(x1118)*(x1130)))+(((IkReal(-1.00000000000000))*(pp)*(x1115)*(x1144)))+(((IkReal(2.00000000000000))*(x1124)*(x1153)))+(((IkReal(0.0956250000000000))*(cj0)*(x1115)))+(((x1126)*(x1135)*(x1150)))+(((r02)*(x1119)*(x1123)))+(((IkReal(0.0450000000000000))*(x1145)))+(((IkReal(0.0843750000000000))*(x1127)))+(((IkReal(-1.00000000000000))*(pp)*(x1113)*(x1114)))+(((IkReal(-1.00000000000000))*(sj0)*(x1118)*(x1137)))+(((IkReal(-1.00000000000000))*(x1138)*(x1154)))+(((IkReal(0.0450000000000000))*(x1152)))+(((IkReal(-0.0120000000000000))*(x1154)))+(((IkReal(-1.00000000000000))*(cj0)*(x1124)*(x1132)))+(((IkReal(0.0524000000000000))*(x1155)))+(((x1120)*(x1126)*(x1143)))+(((r01)*(x1113)*(x1159)))+(((IkReal(-0.150000000000000))*(px)*(x1115)))+(((x1117)*(x1155)))+(((IkReal(-1.00000000000000))*(pp)*(x1127)))+(((x1113)*(x1120)*(x1130)))+(((IkReal(-0.600000000000000))*(x1120)))+(((IkReal(-1.00000000000000))*(x1119)*(x1135)))+(((x1127)*(x1157)))+(((x1113)*(x1129)*(x1130)))+(((x1111)*(x1115)*(x1126)))+(((cj0)*(x1121)*(x1132)))+(((IkReal(-1.00000000000000))*(x1120)*(x1128)))+(((IkReal(-1.00000000000000))*(r01)*(x1141)))+(((x1140)*(x1154)))+(((IkReal(0.0956250000000000))*(r01)*(x1113))));
evalcond[7]=((((IkReal(0.0956250000000000))*(x1131)))+(((x1120)*(x1123)*(x1130)))+(((x1120)*(x1126)*(x1153)))+(((IkReal(-1.00000000000000))*(x1129)*(x1132)))+(((IkReal(-1.00000000000000))*(pp)*(x1144)*(x1151)))+(((x1118)*(x1126)*(x1150)))+(((IkReal(-1.00000000000000))*(pz)*(x1130)*(x1135)))+(((IkReal(0.0450000000000000))*(r02)))+(((IkReal(0.600000000000000))*(pz)*(x1152)))+(((IkReal(-1.00000000000000))*(r02)*(x1113)*(x1119)))+(((IkReal(-1.00000000000000))*(x1118)*(x1119)))+(((cj0)*(x1115)*(x1137)))+(((x1111)*(x1126)*(x1151)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x1141)))+(((pp)*(x1131)))+(((IkReal(-1.00000000000000))*(x1121)*(x1146)))+(((IkReal(-1.00000000000000))*(x1131)*(x1157)))+(((IkReal(-0.0843750000000000))*(sj0)*(x1118)))+(((IkReal(-1.00000000000000))*(x1120)*(x1132)))+(((x1124)*(x1146)))+(((sj0)*(x1118)*(x1159)))+(((IkReal(-1.00000000000000))*(x1138)*(x1155)))+(((IkReal(-0.0120000000000000))*(x1155)))+(((IkReal(-1.00000000000000))*(pp)*(x1114)*(x1123)))+(((IkReal(-1.00000000000000))*(x1133)*(x1154)))+(((x1123)*(x1129)*(x1130)))+(((r01)*(x1113)*(x1137)))+(((IkReal(-1.00000000000000))*(cj0)*(x1121)*(x1128)))+(((IkReal(-0.0524000000000000))*(x1154)))+(((IkReal(-2.00000000000000))*(px)*(pz)*(x1115)))+(((x1140)*(x1155)))+(((IkReal(-1.00000000000000))*(x1117)*(x1154)))+(((IkReal(-0.0843750000000000))*(cj1)*(x1145))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  || IKabs(evalcond[6]) > 0.000001  || IKabs(evalcond[7]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}
}
}
    }
}
}
}
return solutions.GetNumSolutions()>0;
}
static inline void polyroots4(IkReal rawcoeffs[4+1], IkReal rawroots[4], int& numroots)
{
    using std::complex;
    IKFAST_ASSERT(rawcoeffs[0] != 0);
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    const IkReal tolsqrt = sqrt(std::numeric_limits<IkReal>::epsilon());
    complex<IkReal> coeffs[4];
    const int maxsteps = 110;
    for(int i = 0; i < 4; ++i) {
        coeffs[i] = complex<IkReal>(rawcoeffs[i+1]/rawcoeffs[0]);
    }
    complex<IkReal> roots[4];
    IkReal err[4];
    roots[0] = complex<IkReal>(1,0);
    roots[1] = complex<IkReal>(0.4,0.9); // any complex number not a root of unity works
    err[0] = 1.0;
    err[1] = 1.0;
    for(int i = 2; i < 4; ++i) {
        roots[i] = roots[i-1]*roots[1];
        err[i] = 1.0;
    }
    for(int step = 0; step < maxsteps; ++step) {
        bool changed = false;
        for(int i = 0; i < 4; ++i) {
            if ( err[i] >= tol ) {
                changed = true;
                // evaluate
                complex<IkReal> x = roots[i] + coeffs[0];
                for(int j = 1; j < 4; ++j) {
                    x = roots[i] * x + coeffs[j];
                }
                for(int j = 0; j < 4; ++j) {
                    if( i != j ) {
                        if( roots[i] != roots[j] ) {
                            x /= (roots[i] - roots[j]);
                        }
                    }
                }
                roots[i] -= x;
                err[i] = abs(x);
            }
        }
        if( !changed ) {
            break;
        }
    }

    numroots = 0;
    bool visited[4] = {false};
    for(int i = 0; i < 4; ++i) {
        if( !visited[i] ) {
            // might be a multiple root, in which case it will have more error than the other roots
            // find any neighboring roots, and take the average
            complex<IkReal> newroot=roots[i];
            int n = 1;
            for(int j = i+1; j < 4; ++j) {
                if( abs(roots[i]-roots[j]) < 8*tolsqrt ) {
                    newroot += roots[j];
                    n += 1;
                    visited[j] = true;
                }
            }
            if( n > 1 ) {
                newroot /= n;
            }
            // there are still cases where even the mean is not accurate enough, until a better multi-root algorithm is used, need to use the sqrt
            if( IKabs(imag(newroot)) < tolsqrt ) {
                rawroots[numroots++] = real(newroot);
            }
        }
    }
}
};


/// solves the inverse kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API bool ComputeIk(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions) {
IKSolver solver;
return solver.ComputeIk(eetrans,eerot,pfree,solutions);
}

IKFAST_API const char* GetKinematicsHash() { return "76eda3aa6f0ad735cb91d01eee207a60"; }

IKFAST_API const char* GetIkFastVersion() { return IKFAST_STRINGIZE(IKFAST_VERSION); }

#ifdef IKFAST_NAMESPACE
} // end namespace
#endif

#ifndef IKFAST_NO_MAIN
#include <stdio.h>
#include <stdlib.h>
#ifdef IKFAST_NAMESPACE
using namespace IKFAST_NAMESPACE;
#endif
int main(int argc, char** argv)
{
    if( argc != 12+GetNumFreeParameters()+1 ) {
        printf("\nUsage: ./ik r00 r01 r02 t0 r10 r11 r12 t1 r20 r21 r22 t2 free0 ...\n\n"
               "Returns the ik solutions given the transformation of the end effector specified by\n"
               "a 3x3 rotation R (rXX), and a 3x1 translation (tX).\n"
               "There are %d free parameters that have to be specified.\n\n",GetNumFreeParameters());
        return 1;
    }

    IkSolutionList<IkReal> solutions;
    std::vector<IkReal> vfree(GetNumFreeParameters());
    IkReal eerot[9],eetrans[3];
    eerot[0] = atof(argv[1]); eerot[1] = atof(argv[2]); eerot[2] = atof(argv[3]); eetrans[0] = atof(argv[4]);
    eerot[3] = atof(argv[5]); eerot[4] = atof(argv[6]); eerot[5] = atof(argv[7]); eetrans[1] = atof(argv[8]);
    eerot[6] = atof(argv[9]); eerot[7] = atof(argv[10]); eerot[8] = atof(argv[11]); eetrans[2] = atof(argv[12]);
    for(std::size_t i = 0; i < vfree.size(); ++i)
        vfree[i] = atof(argv[13+i]);
    bool bSuccess = ComputeIk(eetrans, eerot, vfree.size() > 0 ? &vfree[0] : NULL, solutions);

    if( !bSuccess ) {
        fprintf(stderr,"Failed to get ik solution\n");
        return -1;
    }

    printf("Found %d ik solutions:\n", (int)solutions.GetNumSolutions());
    std::vector<IkReal> solvalues(GetNumJoints());
    for(std::size_t i = 0; i < solutions.GetNumSolutions(); ++i) {
        const IkSolutionBase<IkReal>& sol = solutions.GetSolution(i);
        printf("sol%d (free=%d): ", (int)i, (int)sol.GetFree().size());
        std::vector<IkReal> vsolfree(sol.GetFree().size());
        sol.GetSolution(&solvalues[0],vsolfree.size()>0?&vsolfree[0]:NULL);
        for( std::size_t j = 0; j < solvalues.size(); ++j)
            printf("%.15f, ", solvalues[j]);
        printf("\n");
    }
    return 0;
}

#endif
