/// autogenerated analytical inverse kinematics code from ikfast program part of OpenRAVE
/// \author Rosen Diankov
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///     http://www.apache.org/licenses/LICENSE-2.0
/// 
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// ikfast version 61 generated on 2014-05-16 11:22:51.936116
/// To compile with gcc:
///     gcc -lstdc++ ik.cpp
/// To compile without any main function as a shared object (might need -llapack):
///     gcc -fPIC -lstdc++ -DIKFAST_NO_MAIN -DIKFAST_CLIBRARY -shared -Wl,-soname,libik.so -o libik.so ik.cpp
#define IKFAST_HAS_LIBRARY
#include "ikfast.h" // found inside share/openrave-X.Y/python/ikfast.h
using namespace ikfast;

// check if the included ikfast version matches what this file was compiled with
#define IKFAST_COMPILE_ASSERT(x) extern int __dummy[(int)x]
IKFAST_COMPILE_ASSERT(IKFAST_VERSION==61);

#include <cmath>
#include <vector>
#include <limits>
#include <algorithm>
#include <complex>

#define IKFAST_STRINGIZE2(s) #s
#define IKFAST_STRINGIZE(s) IKFAST_STRINGIZE2(s)

#ifndef IKFAST_ASSERT
#include <stdexcept>
#include <sstream>
#include <iostream>

#ifdef _MSC_VER
#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __FUNCDNAME__
#endif
#endif

#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __func__
#endif

#define IKFAST_ASSERT(b) { if( !(b) ) { std::stringstream ss; ss << "ikfast exception: " << __FILE__ << ":" << __LINE__ << ": " <<__PRETTY_FUNCTION__ << ": Assertion '" << #b << "' failed"; throw std::runtime_error(ss.str()); } }

#endif

#if defined(_MSC_VER)
#define IKFAST_ALIGNED16(x) __declspec(align(16)) x
#else
#define IKFAST_ALIGNED16(x) x __attribute((aligned(16)))
#endif

#define IK2PI  ((IkReal)6.28318530717959)
#define IKPI  ((IkReal)3.14159265358979)
#define IKPI_2  ((IkReal)1.57079632679490)

#ifdef _MSC_VER
#ifndef isnan
#define isnan _isnan
#endif
#endif // _MSC_VER

// lapack routines
extern "C" {
  void dgetrf_ (const int* m, const int* n, double* a, const int* lda, int* ipiv, int* info);
  void zgetrf_ (const int* m, const int* n, std::complex<double>* a, const int* lda, int* ipiv, int* info);
  void dgetri_(const int* n, const double* a, const int* lda, int* ipiv, double* work, const int* lwork, int* info);
  void dgesv_ (const int* n, const int* nrhs, double* a, const int* lda, int* ipiv, double* b, const int* ldb, int* info);
  void dgetrs_(const char *trans, const int *n, const int *nrhs, double *a, const int *lda, int *ipiv, double *b, const int *ldb, int *info);
  void dgeev_(const char *jobvl, const char *jobvr, const int *n, double *a, const int *lda, double *wr, double *wi,double *vl, const int *ldvl, double *vr, const int *ldvr, double *work, const int *lwork, int *info);
}

using namespace std; // necessary to get std math routines

#ifdef IKFAST_NAMESPACE
namespace IKFAST_NAMESPACE {
#endif

inline float IKabs(float f) { return fabsf(f); }
inline double IKabs(double f) { return fabs(f); }

inline float IKsqr(float f) { return f*f; }
inline double IKsqr(double f) { return f*f; }

inline float IKlog(float f) { return logf(f); }
inline double IKlog(double f) { return log(f); }

// allows asin and acos to exceed 1
#ifndef IKFAST_SINCOS_THRESH
#define IKFAST_SINCOS_THRESH ((IkReal)0.000001)
#endif

// used to check input to atan2 for degenerate cases
#ifndef IKFAST_ATAN2_MAGTHRESH
#define IKFAST_ATAN2_MAGTHRESH ((IkReal)2e-6)
#endif

// minimum distance of separate solutions
#ifndef IKFAST_SOLUTION_THRESH
#define IKFAST_SOLUTION_THRESH ((IkReal)1e-6)
#endif

inline float IKasin(float f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return float(-IKPI_2);
else if( f >= 1 ) return float(IKPI_2);
return asinf(f);
}
inline double IKasin(double f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return -IKPI_2;
else if( f >= 1 ) return IKPI_2;
return asin(f);
}

// return positive value in [0,y)
inline float IKfmod(float x, float y)
{
    while(x < 0) {
        x += y;
    }
    return fmodf(x,y);
}

// return positive value in [0,y)
inline double IKfmod(double x, double y)
{
    while(x < 0) {
        x += y;
    }
    return fmod(x,y);
}

inline float IKacos(float f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return float(IKPI);
else if( f >= 1 ) return float(0);
return acosf(f);
}
inline double IKacos(double f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return IKPI;
else if( f >= 1 ) return 0;
return acos(f);
}
inline float IKsin(float f) { return sinf(f); }
inline double IKsin(double f) { return sin(f); }
inline float IKcos(float f) { return cosf(f); }
inline double IKcos(double f) { return cos(f); }
inline float IKtan(float f) { return tanf(f); }
inline double IKtan(double f) { return tan(f); }
inline float IKsqrt(float f) { if( f <= 0.0f ) return 0.0f; return sqrtf(f); }
inline double IKsqrt(double f) { if( f <= 0.0 ) return 0.0; return sqrt(f); }
inline float IKatan2(float fy, float fx) {
    if( isnan(fy) ) {
        IKFAST_ASSERT(!isnan(fx)); // if both are nan, probably wrong value will be returned
        return float(IKPI_2);
    }
    else if( isnan(fx) ) {
        return 0;
    }
    return atan2f(fy,fx);
}
inline double IKatan2(double fy, double fx) {
    if( isnan(fy) ) {
        IKFAST_ASSERT(!isnan(fx)); // if both are nan, probably wrong value will be returned
        return IKPI_2;
    }
    else if( isnan(fx) ) {
        return 0;
    }
    return atan2(fy,fx);
}

inline float IKsign(float f) {
    if( f > 0 ) {
        return float(1);
    }
    else if( f < 0 ) {
        return float(-1);
    }
    return 0;
}

inline double IKsign(double f) {
    if( f > 0 ) {
        return 1.0;
    }
    else if( f < 0 ) {
        return -1.0;
    }
    return 0;
}

/// solves the forward kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API void ComputeFk(const IkReal* j, IkReal* eetrans, IkReal* eerot) {
IkReal x0,x1,x2,x3,x4,x5,x6,x7,x8,x9,x10,x11,x12,x13,x14,x15,x16,x17,x18,x19,x20,x21,x22,x23,x24;
x0=IKcos(j[0]);
x1=IKsin(j[1]);
x2=IKcos(j[2]);
x3=IKcos(j[1]);
x4=IKsin(j[2]);
x5=IKsin(j[0]);
x6=IKsin(j[3]);
x7=IKcos(j[3]);
x8=IKcos(j[4]);
x9=IKsin(j[4]);
x10=((IkReal(0.0750000000000000))*(x0));
x11=((IkReal(0.0800000000000000))*(x5));
x12=((IkReal(0.320000000000000))*(x0));
x13=((IkReal(0.0800000000000000))*(x1));
x14=((IkReal(1.00000000000000))*(x0));
x15=((IkReal(1.00000000000000))*(x5));
x16=((IkReal(0.0800000000000000))*(x0));
x17=((IkReal(0.0750000000000000))*(x5));
x18=((x3)*(x4));
x19=((x1)*(x5));
x20=((x2)*(x3));
x21=((x1)*(x4));
x22=((x1)*(x2));
x23=((IkReal(0.0750000000000000))*(x22));
x24=((x1)*(x11));
IkReal x25=((x0)*(x13));
IkReal x26=((IkReal(1.00000000000000))*(x18));
eetrans[0]=((((x10)*(x22)))+(x10)+(((x6)*(((((IkReal(-1.00000000000000))*(x16)*(x26)))+(((x2)*(x25)))))))+(((x12)*(x20)))+(((IkReal(0.300000000000000))*(x0)*(x1)))+(((x12)*(x21)))+(((x7)*(((((x16)*(x20)))+(((x25)*(x4)))))))+(((IkReal(-1.00000000000000))*(x10)*(x26))));
IkReal x27=((IkReal(1.00000000000000))*(x18));
eetrans[1]=((((IkReal(0.320000000000000))*(x19)*(x4)))+(((IkReal(0.320000000000000))*(x20)*(x5)))+(((x6)*(((((IkReal(-1.00000000000000))*(x11)*(x27)))+(((x11)*(x22)))))))+(((IkReal(-1.00000000000000))*(x17)*(x27)))+(((IkReal(0.300000000000000))*(x19)))+(x17)+(((x17)*(x22)))+(((x7)*(((((x11)*(x21)))+(((x11)*(x20))))))));
eetrans[2]=((IkReal(0.330000000000000))+(((x6)*(((((x13)*(x4)))+(((IkReal(0.0800000000000000))*(x20)))))))+(((IkReal(0.320000000000000))*(x18)))+(((IkReal(0.0750000000000000))*(x21)))+(((IkReal(0.300000000000000))*(x3)))+(((IkReal(-0.320000000000000))*(x22)))+(((x7)*(((((IkReal(0.0800000000000000))*(x18)))+(((IkReal(-1.00000000000000))*(x13)*(x2)))))))+(((IkReal(0.0750000000000000))*(x20))));
IkReal x28=((IkReal(1.00000000000000))*(x14));
eerot[0]=((((x8)*(((((x6)*(((((IkReal(-1.00000000000000))*(x21)*(x28)))+(((IkReal(-1.00000000000000))*(x20)*(x28)))))))+(((x7)*(((((IkReal(-1.00000000000000))*(x18)*(x28)))+(((x0)*(x22)))))))))))+(((IkReal(-1.00000000000000))*(x15)*(x9))));
IkReal x29=((IkReal(1.00000000000000))*(x15));
eerot[1]=((((x8)*(((((x6)*(((((IkReal(-1.00000000000000))*(x20)*(x29)))+(((IkReal(-1.00000000000000))*(x21)*(x29)))))))+(((x7)*(((((IkReal(-1.00000000000000))*(x18)*(x29)))+(((x19)*(x2)))))))))))+(((x0)*(x9))));
eerot[2]=((x8)*(((((x6)*(((((IkReal(-1.00000000000000))*(x18)))+(((IkReal(1.00000000000000))*(x22)))))))+(((x7)*(((x20)+(x21))))))));
}

IKFAST_API int GetNumFreeParameters() { return 0; }
IKFAST_API int* GetFreeParameters() { return NULL; }
IKFAST_API int GetNumJoints() { return 5; }

IKFAST_API int GetIkRealSize() { return sizeof(IkReal); }

IKFAST_API int GetIkType() { return 0x56000007; }

class IKSolver {
public:
IkReal j0,cj0,sj0,htj0,j1,cj1,sj1,htj1,j2,cj2,sj2,htj2,j3,cj3,sj3,htj3,j4,cj4,sj4,htj4,new_r00,r00,rxp0_0,new_r01,r01,rxp0_1,new_r02,r02,rxp0_2,new_px,px,npx,new_py,py,npy,new_pz,pz,npz,pp;
unsigned char _ij0[2], _nj0,_ij1[2], _nj1,_ij2[2], _nj2,_ij3[2], _nj3,_ij4[2], _nj4;

bool ComputeIk(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions) {
j0=numeric_limits<IkReal>::quiet_NaN(); _ij0[0] = -1; _ij0[1] = -1; _nj0 = -1; j1=numeric_limits<IkReal>::quiet_NaN(); _ij1[0] = -1; _ij1[1] = -1; _nj1 = -1; j2=numeric_limits<IkReal>::quiet_NaN(); _ij2[0] = -1; _ij2[1] = -1; _nj2 = -1; j3=numeric_limits<IkReal>::quiet_NaN(); _ij3[0] = -1; _ij3[1] = -1; _nj3 = -1; j4=numeric_limits<IkReal>::quiet_NaN(); _ij4[0] = -1; _ij4[1] = -1; _nj4 = -1; 
for(int dummyiter = 0; dummyiter < 1; ++dummyiter) {
    solutions.Clear();
px = eetrans[0]; py = eetrans[1]; pz = eetrans[2];

r00 = eerot[0];
r01 = eerot[1];
r02 = eerot[2];
px = eetrans[0]; py = eetrans[1]; pz = eetrans[2];
new_r00=r00;
new_px=px;
new_r01=r01;
new_py=py;
new_r02=r02;
new_pz=((IkReal(-0.330000000000000))+(pz));
r00 = new_r00; r01 = new_r01; r02 = new_r02; px = new_px; py = new_py; pz = new_pz;

pp=(((px)*(px))+((pz)*(pz))+((py)*(py)));
{
IkReal j0array[2], cj0array[2], sj0array[2];
bool j0valid[2]={false};
_nj0 = 2;
if( IKabs(((IkReal(-1.00000000000000))*(py))) < IKFAST_ATAN2_MAGTHRESH && IKabs(px) < IKFAST_ATAN2_MAGTHRESH )
    continue;
IkReal x30=IKatan2(((IkReal(-1.00000000000000))*(py)), px);
j0array[0]=((IkReal(-1.00000000000000))*(x30));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
j0array[1]=((IkReal(3.14159265358979))+(((IkReal(-1.00000000000000))*(x30))));
sj0array[1]=IKsin(j0array[1]);
cj0array[1]=IKcos(j0array[1]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
if( j0array[1] > IKPI )
{
    j0array[1]-=IK2PI;
}
else if( j0array[1] < -IKPI )
{    j0array[1]+=IK2PI;
}
j0valid[1] = true;
for(int ij0 = 0; ij0 < 2; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 2; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];

IkReal op[4+1], zeror[4];
int numroots;
op[0]=((((IkReal(-2.40000000000000))*(px)*(r00)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-4.00000000000000))*((cj0)*(cj0))*((px)*(px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-8.00000000000000))*(pz)*(r00)*(r02)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(-0.313500000000000))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(-0.00564000000000000))*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-0.00180000000000000))*(cj0)*(py)*(r00)*(r01)))+(((IkReal(1.20000000000000))*(pp)*(px)*(r00)*(r02)))+(((IkReal(-2.40000000000000))*(pz)*((py)*(py))*((r01)*(r01))))+(((IkReal(0.644800000000000))*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(0.180000000000000))*(px)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(0.600000000000000))*(cj0)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(0.0225600000000000))*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(1.20000000000000))*(cj0)*(pp)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(-0.0225600000000000))*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-1.00000000000000))*((pp)*(pp))*((r02)*(r02))))+(((IkReal(0.00720000000000000))*(pz)*((r02)*(r02))))+(((IkReal(-4.80000000000000))*(cj0)*(px)*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(-4.80000000000000))*(cj0)*(py)*(r00)*(r02)*(sj0)*((px)*(px))))+(((IkReal(-0.372000000000000))*(pp)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.0225600000000000))*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(0.180000000000000))*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(-0.00564000000000000))*(cj0)*(px)*((r02)*(r02))))+(((IkReal(-8.00000000000000))*(px)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(-8.00000000000000))*(py)*(r00)*(r01)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(4.00000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(4.00000000000000))*(pp)*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(0.0496000000000000))*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(0.180000000000000))*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(-0.382500000000000))*((py)*(py))*((r01)*(r01))))+(((IkReal(-8.00000000000000))*(py)*(r01)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(0.00720000000000000))*(py)*(r01)*(r02)))+(((IkReal(-0.600000000000000))*(pp)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(0.644800000000000))*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(4.00000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(0.180000000000000))*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(0.600000000000000))*(r01)*(r02)*(sj0)*((pz)*(pz)*(pz))))+(((IkReal(4.00000000000000))*(pp)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-4.00000000000000))*((py)*(py)*(py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.600000000000000))*(px)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(0.600000000000000))*(cj0)*(pz)*(r00)*(r02)*((px)*(px))))+(((IkReal(0.00453600000000000))*(cj0)*(r00)*(r01)*(sj0)))+(((IkReal(-2.40000000000000))*(cj0)*(pp)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(4.00000000000000))*(pp)*(px)*(pz)*(r00)*(r02)))+(((IkReal(0.744000000000000))*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(4.00000000000000))*(pp)*(py)*(pz)*(r01)*(r02)))+(((IkReal(-1.00000000000000))*((cj0)*(cj0))*((pp)*(pp))*((r00)*(r00))))+(((IkReal(-0.765000000000000))*(px)*(py)*(r00)*(r01)))+(((IkReal(1.20000000000000))*(pp)*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(0.600000000000000))*(cj0)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(-4.80000000000000))*(cj0)*(px)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(0.744000000000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(4.00000000000000))*(pp)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(-4.00000000000000))*((px)*(px))*((py)*(py))*((r00)*(r00))*((sj0)*(sj0))))+(((IkReal(-2.40000000000000))*(r01)*(r02)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(2.40000000000000))*(cj0)*(px)*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(-4.00000000000000))*((cj0)*(cj0))*((px)*(px))*((py)*(py))*((r01)*(r01))))+(((IkReal(-0.00180000000000000))*(cj0)*(px)*((r00)*(r00))))+(((IkReal(-0.372000000000000))*(pp)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-16.0000000000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))*((py)*(py))))+(((IkReal(0.600000000000000))*(cj0)*(px)*(py)*(pz)*(r01)*(r02)))+(((IkReal(-2.40000000000000))*(pz)*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(4.00000000000000))*(pp)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-4.80000000000000))*(py)*(r01)*(r02)*((pz)*(pz))))+(((IkReal(-0.180000000000000))*(cj0)*(pp)*(r00)*(r02)))+(((IkReal(0.00384000000000000))*(cj0)*(pz)*(r00)*(r02)))+(((IkReal(0.00115200000000000))*(r01)*(r02)*(sj0)))+(((IkReal(2.40000000000000))*(px)*(py)*(pz)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(2.40000000000000))*(cj0)*(px)*(py)*(pz)*(sj0)*((r00)*(r00))))+(((IkReal(-0.600000000000000))*(cj0)*(pp)*(pz)*(r00)*(r02)))+(((IkReal(-2.40000000000000))*(r00)*(r02)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(0.744000000000000))*(cj0)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(-16.0000000000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)*((px)*(px))))+(((IkReal(-4.00000000000000))*((px)*(px))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(0.600000000000000))*(py)*(sj0)*((px)*(px))*((r00)*(r00))))+(((IkReal(-8.00000000000000))*(py)*(pz)*(r01)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(0.00720000000000000))*(px)*(r00)*(r02)))+(((IkReal(-0.180000000000000))*(pp)*(r01)*(r02)*(sj0)))+(((IkReal(-0.0345000000000000))*(pp)*((r02)*(r02))))+(((IkReal(0.000108000000000000))*((r02)*(r02))))+(((IkReal(0.600000000000000))*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(4.00000000000000))*(pp)*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-2.40000000000000))*(pz)*((px)*(px))*((r00)*(r00))))+(((IkReal(-8.00000000000000))*(pz)*(r01)*(r02)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.00180000000000000))*(px)*(r00)*(r01)*(sj0)))+(((IkReal(1.20000000000000))*(pp)*(px)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(0.0451200000000000))*(cj0)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(1.20000000000000))*(pp)*(py)*(r01)*(r02)))+(((IkReal(0.600000000000000))*(px)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(2.40000000000000))*(py)*(r01)*(r02)*((pz)*(pz))*((sj0)*(sj0))))+(((IkReal(0.300000000000000))*(pp)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-0.00180000000000000))*(py)*(sj0)*((r01)*(r01))))+(((IkReal(0.744000000000000))*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(0.180000000000000))*(cj0)*(px)*(pz)*((r00)*(r00))))+(((IkReal(-8.00000000000000))*(px)*(r00)*(r01)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(0.600000000000000))*(cj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(0.180000000000000))*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(0.180000000000000))*(cj0)*(py)*(pz)*(r00)*(r01)))+(((IkReal(-0.744000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)))+(((IkReal(0.0992000000000000))*(cj0)*(px)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-4.80000000000000))*(px)*(py)*(pz)*(r00)*(r01)))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(0.644800000000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-8.00000000000000))*(cj0)*(py)*(sj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(2.40000000000000))*(cj0)*(px)*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(-0.696000000000000))*(py)*(pz)*(r01)*(r02)))+(((IkReal(2.40000000000000))*(px)*(py)*(pz)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(-1.20000000000000))*(pp)*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(1.20000000000000))*(pp)*(pz)*((r02)*(r02))))+(((IkReal(-4.00000000000000))*((py)*(py))*((pz)*(pz))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(-0.0225600000000000))*(cj0)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(1.20000000000000))*(cj0)*(py)*(r00)*(r01)*((px)*(px))))+(((IkReal(0.00226800000000000))*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(2.40000000000000))*(cj0)*(pz)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(0.180000000000000))*(cj0)*(px)*(py)*(r01)*(r02)))+(((IkReal(-8.00000000000000))*(px)*(pz)*(r00)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(0.0496000000000000))*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(-4.00000000000000))*((py)*(py))*((pz)*(pz))*((r01)*(r01))))+(((IkReal(0.00384000000000000))*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-2.00000000000000))*(cj0)*(r00)*(r01)*(sj0)*((pp)*(pp))))+(((IkReal(0.600000000000000))*(cj0)*(px)*((py)*(py))*((r01)*(r01))))+(((IkReal(2.40000000000000))*(px)*(r00)*(r02)*((cj0)*(cj0))*((pz)*(pz))))+(((IkReal(0.180000000000000))*(cj0)*(r00)*(r02)*((px)*(px))))+(((IkReal(-4.00000000000000))*((pz)*(pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(-1.20000000000000))*(pp)*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-0.382500000000000))*((px)*(px))*((r00)*(r00))))+(((IkReal(-2.40000000000000))*(pz)*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(-0.300000000000000))*(cj0)*(pp)*(px)*((r00)*(r00))))+(((IkReal(0.0496000000000000))*((cj0)*(cj0))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(0.0992000000000000))*(cj0)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(-0.300000000000000))*(pp)*(px)*(r00)*(r01)*(sj0)))+(((IkReal(0.0496000000000000))*((pz)*(pz))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-8.00000000000000))*(px)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(-2.40000000000000))*((pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(-4.00000000000000))*((cj0)*(cj0))*((px)*(px))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.696000000000000))*(px)*(pz)*(r00)*(r02)))+(((IkReal(-0.300000000000000))*(pp)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(0.600000000000000))*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(2.40000000000000))*(cj0)*(py)*(r00)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(-2.40000000000000))*(py)*(r01)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-8.00000000000000))*(cj0)*(px)*(py)*(sj0)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(0.644800000000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(0.180000000000000))*(cj0)*(px)*(pz)*((r02)*(r02))))+(((IkReal(0.744000000000000))*(cj0)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(0.180000000000000))*(px)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(1.20000000000000))*(px)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(0.00115200000000000))*(cj0)*(r00)*(r02)))+(((IkReal(0.744000000000000))*(cj0)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(0.744000000000000))*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-0.0225600000000000))*(cj0)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(0.180000000000000))*(cj0)*(r00)*(r02)*((pz)*(pz))))+(((IkReal(2.40000000000000))*(pz)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(-1.00000000000000))*((pp)*(pp))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(-0.300000000000000))*(cj0)*(pp)*(py)*(r00)*(r01)))+(((IkReal(-8.00000000000000))*(cj0)*(px)*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(-16.0000000000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(0.300000000000000))*(cj0)*(pp)*(px)*((r02)*(r02))))+(((IkReal(2.40000000000000))*(cj0)*(pz)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(1.20000000000000))*(cj0)*(pp)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(0.600000000000000))*(py)*(sj0)*((pz)*(pz))*((r01)*(r01))))+(((IkReal(2.40000000000000))*(pz)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.600000000000000))*(cj0)*(px)*((pz)*(pz))*((r00)*(r00))))+(((IkReal(0.00226800000000000))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-4.80000000000000))*(px)*(r00)*(r02)*((pz)*(pz))))+(((IkReal(-0.0225600000000000))*(px)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(0.744000000000000))*((cj0)*(cj0))*((px)*(px))*((r00)*(r00)))));
op[1]=((((IkReal(0.360000000000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(4.80000000000000))*(py)*(sj0)*((px)*(px))*((r00)*(r00))))+(((IkReal(-0.360000000000000))*(py)*(pz)*(r01)*(r02)))+(((IkReal(-0.108000000000000))*(px)*(r00)*(r02)))+(((IkReal(-4.80000000000000))*(pp)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(0.0307200000000000))*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(2.40000000000000))*(pp)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-2.40000000000000))*(cj0)*(pp)*(px)*((r00)*(r00))))+(((IkReal(-0.360000000000000))*((pz)*(pz))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.180000000000000))*(pp)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.00921600000000000))*(r01)*(r02)*(sj0)))+(((IkReal(4.80000000000000))*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(9.60000000000000))*(px)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-0.108000000000000))*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.00216000000000000))*(cj0)*(r00)*(r01)*(sj0)))+(((IkReal(-0.360000000000000))*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(4.80000000000000))*(cj0)*(pz)*(r00)*(r02)*((px)*(px))))+(((IkReal(0.360000000000000))*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-0.360000000000000))*((cj0)*(cj0))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(0.108000000000000))*(cj0)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(0.360000000000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(0.00108000000000000))*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-0.180000000000000))*(pp)*((r02)*(r02))))+(((IkReal(-0.720000000000000))*(px)*(py)*(r00)*(r01)))+(((IkReal(1.44000000000000))*(cj0)*(py)*(pz)*(r00)*(r01)))+(((IkReal(1.44000000000000))*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(-0.360000000000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(0.0126000000000000))*(px)*(r00)*(r01)*(sj0)))+(((IkReal(-0.0181200000000000))*(cj0)*(px)*((r02)*(r02))))+(((IkReal(0.0126000000000000))*(cj0)*(py)*(r00)*(r01)))+(((IkReal(-1.44000000000000))*(pp)*(r01)*(r02)*(sj0)))+(((IkReal(4.80000000000000))*(px)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(-0.360000000000000))*((py)*(py))*((r01)*(r01))))+(((IkReal(1.44000000000000))*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(-0.360000000000000))*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(-2.40000000000000))*(pp)*(px)*(r00)*(r01)*(sj0)))+(((IkReal(-0.360000000000000))*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(4.80000000000000))*(cj0)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(-0.720000000000000))*(cj0)*(px)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-0.360000000000000))*(cj0)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-4.80000000000000))*(cj0)*(pp)*(pz)*(r00)*(r02)))+(((IkReal(1.44000000000000))*(cj0)*(r00)*(r02)*((pz)*(pz))))+(((IkReal(1.44000000000000))*(px)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(4.80000000000000))*(cj0)*(px)*((py)*(py))*((r01)*(r01))))+(((IkReal(4.80000000000000))*(py)*(sj0)*((pz)*(pz))*((r01)*(r01))))+(((IkReal(-0.360000000000000))*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(0.00921600000000000))*(cj0)*(r00)*(r02)))+(((IkReal(4.80000000000000))*(r01)*(r02)*(sj0)*((pz)*(pz)*(pz))))+(((IkReal(0.0126000000000000))*(py)*(sj0)*((r01)*(r01))))+(((IkReal(0.108000000000000))*(cj0)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(-1.44000000000000))*(cj0)*(pp)*(r00)*(r02)))+(((IkReal(0.108000000000000))*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(0.0307200000000000))*(cj0)*(pz)*(r00)*(r02)))+(((IkReal(1.44000000000000))*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-0.0181200000000000))*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-0.360000000000000))*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(0.0126000000000000))*(cj0)*(px)*((r00)*(r00))))+(((IkReal(4.80000000000000))*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(4.80000000000000))*(cj0)*(px)*((pz)*(pz))*((r00)*(r00))))+(((IkReal(0.360000000000000))*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(9.60000000000000))*(cj0)*(py)*(r00)*(r01)*((px)*(px))))+(((IkReal(-0.360000000000000))*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(4.80000000000000))*(cj0)*(px)*(py)*(pz)*(r01)*(r02)))+(((IkReal(-2.40000000000000))*(pp)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(0.00108000000000000))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(1.44000000000000))*(cj0)*(r00)*(r02)*((px)*(px))))+(((IkReal(-0.360000000000000))*(cj0)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-0.360000000000000))*((px)*(px))*((r00)*(r00))))+(((IkReal(2.40000000000000))*(cj0)*(pp)*(px)*((r02)*(r02))))+(((IkReal(1.44000000000000))*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(4.80000000000000))*(cj0)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(1.44000000000000))*(px)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(4.80000000000000))*(cj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(1.44000000000000))*(cj0)*(px)*(pz)*((r02)*(r02))))+(((IkReal(-2.40000000000000))*(cj0)*(pp)*(py)*(r00)*(r01)))+(((IkReal(1.44000000000000))*(cj0)*(px)*(py)*(r01)*(r02)))+(((IkReal(-0.720000000000000))*(cj0)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(-0.360000000000000))*(cj0)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(0.108000000000000))*(px)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(-0.108000000000000))*(py)*(r01)*(r02)))+(((IkReal(0.360000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)))+(((IkReal(-0.360000000000000))*(px)*(pz)*(r00)*(r02)))+(((IkReal(-0.108000000000000))*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(4.80000000000000))*(px)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(-0.216000000000000))*(cj0)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(-0.108000000000000))*(pz)*((r02)*(r02))))+(((IkReal(0.00338400000000000))*((r02)*(r02))))+(((IkReal(0.180000000000000))*(pp)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(1.44000000000000))*(cj0)*(px)*(pz)*((r00)*(r00)))));
op[2]=((((IkReal(-16.0000000000000))*(pz)*(r01)*(r02)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(1.20000000000000))*(r01)*(r02)*(sj0)*((pz)*(pz)*(pz))))+(((IkReal(1.20000000000000))*(cj0)*(pz)*(r00)*(r02)*((px)*(px))))+(((IkReal(8.00000000000000))*(pp)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-1.39200000000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(-32.0000000000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-16.0000000000000))*(px)*(r00)*(r01)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(-8.00000000000000))*((px)*(px))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(8.00000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(-8.00000000000000))*((py)*(py))*((pz)*(pz))*((r01)*(r01))))+(((IkReal(-1.20000000000000))*(pp)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-1.50900000000000))*(pp)*((r02)*(r02))))+(((IkReal(0.600000000000000))*(pp)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(8.00000000000000))*(pp)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(cj0)*(py)*(sj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(0.00768000000000000))*(cj0)*(pz)*(r00)*(r02)))+(((IkReal(-0.0255600000000000))*(cj0)*(r00)*(r01)*(sj0)))+(((IkReal(0.0992000000000000))*((pz)*(pz))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-1.39200000000000))*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(-2.00000000000000))*((pp)*(pp))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-1.39200000000000))*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(1.20000000000000))*(cj0)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(-2.00000000000000))*((pp)*(pp))*((r02)*(r02))))+(((IkReal(0.0992000000000000))*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(-1.39200000000000))*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(1.39200000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)))+(((IkReal(0.696000000000000))*(pp)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(py)*(pz)*(r01)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(1.20000000000000))*(px)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(8.00000000000000))*(pp)*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(pz)*(r00)*(r02)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(8.00000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(8.00000000000000))*(pp)*(px)*(pz)*(r00)*(r02)))+(((IkReal(0.204720000000000))*(cj0)*(px)*((r02)*(r02))))+(((IkReal(-1.39200000000000))*(cj0)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-32.0000000000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)*((px)*(px))))+(((IkReal(0.0992000000000000))*((cj0)*(cj0))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(-2.00000000000000))*((cj0)*(cj0))*((pp)*(pp))*((r00)*(r00))))+(((IkReal(0.212400000000000))*(cj0)*(px)*((r00)*(r00))))+(((IkReal(0.00133200000000000))*((r02)*(r02))))+(((IkReal(2.25300000000000))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(0.198400000000000))*(cj0)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(-16.0000000000000))*(py)*(r01)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(-4.00000000000000))*(cj0)*(r00)*(r01)*(sj0)*((pp)*(pp))))+(((IkReal(8.00000000000000))*(cj0)*(pp)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(1.20000000000000))*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-1.59040000000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(-1.59040000000000))*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(-0.765000000000000))*((py)*(py))*((r01)*(r01))))+(((IkReal(1.20000000000000))*(cj0)*(px)*((pz)*(pz))*((r00)*(r00))))+(((IkReal(-16.0000000000000))*(px)*(pz)*(r00)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(cj0)*(px)*(py)*(sj0)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(0.212400000000000))*(cj0)*(py)*(r00)*(r01)))+(((IkReal(0.212400000000000))*(py)*(sj0)*((r01)*(r01))))+(((IkReal(1.20000000000000))*(cj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-1.53000000000000))*(px)*(py)*(r00)*(r01)))+(((IkReal(1.48800000000000))*(px)*(pz)*(r00)*(r02)))+(((IkReal(-8.00000000000000))*((cj0)*(cj0))*((px)*(px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-16.0000000000000))*(px)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(0.204720000000000))*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-8.00000000000000))*((cj0)*(cj0))*((px)*(px))*((py)*(py))*((r01)*(r01))))+(((IkReal(0.198400000000000))*(cj0)*(px)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(2.40000000000000))*(cj0)*(py)*(r00)*(r01)*((px)*(px))))+(((IkReal(-0.765000000000000))*((px)*(px))*((r00)*(r00))))+(((IkReal(-1.39200000000000))*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(8.00000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-16.0000000000000))*(px)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(-0.600000000000000))*(pp)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-8.00000000000000))*((py)*(py)*(py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(1.20000000000000))*(px)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(0.212400000000000))*(px)*(r00)*(r01)*(sj0)))+(((IkReal(8.00000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(-8.00000000000000))*((px)*(px))*((py)*(py))*((r00)*(r00))*((sj0)*(sj0))))+(((IkReal(1.20000000000000))*(cj0)*(px)*((py)*(py))*((r01)*(r01))))+(((IkReal(1.48800000000000))*(py)*(pz)*(r01)*(r02)))+(((IkReal(-0.600000000000000))*(pp)*(px)*(r00)*(r01)*(sj0)))+(((IkReal(-0.0127800000000000))*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-32.0000000000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))*((py)*(py))))+(((IkReal(1.20000000000000))*(py)*(sj0)*((pz)*(pz))*((r01)*(r01))))+(((IkReal(1.20000000000000))*(py)*(sj0)*((px)*(px))*((r00)*(r00))))+(((IkReal(8.00000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(-0.600000000000000))*(cj0)*(pp)*(px)*((r00)*(r00))))+(((IkReal(-8.00000000000000))*((py)*(py))*((pz)*(pz))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(-16.0000000000000))*(cj0)*(px)*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(0.0992000000000000))*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(8.00000000000000))*(pp)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(-16.0000000000000))*(py)*(r00)*(r01)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(-1.59040000000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(8.00000000000000))*(cj0)*(pp)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(0.600000000000000))*(cj0)*(pp)*(px)*((r02)*(r02))))+(((IkReal(8.00000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(0.00768000000000000))*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-8.00000000000000))*((cj0)*(cj0))*((px)*(px))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(1.20000000000000))*(cj0)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(0.696000000000000))*(pp)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-1.20000000000000))*(cj0)*(pp)*(pz)*(r00)*(r02)))+(((IkReal(-0.0127800000000000))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(8.00000000000000))*(pp)*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(-8.00000000000000))*((pz)*(pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.600000000000000))*(cj0)*(pp)*(py)*(r00)*(r01)))+(((IkReal(1.20000000000000))*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(-1.59040000000000))*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(2.40000000000000))*(px)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-1.39200000000000))*(cj0)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-1.39200000000000))*(cj0)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(8.00000000000000))*(pp)*(py)*(pz)*(r01)*(r02)))+(((IkReal(1.20000000000000))*(cj0)*(px)*(py)*(pz)*(r01)*(r02))));
op[3]=((((IkReal(0.360000000000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(4.80000000000000))*(py)*(sj0)*((px)*(px))*((r00)*(r00))))+(((IkReal(-0.360000000000000))*(py)*(pz)*(r01)*(r02)))+(((IkReal(-4.80000000000000))*(pp)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(0.108000000000000))*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-1.44000000000000))*(px)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(0.0307200000000000))*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(2.40000000000000))*(pp)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-2.40000000000000))*(cj0)*(pp)*(px)*((r00)*(r00))))+(((IkReal(-0.360000000000000))*((pz)*(pz))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.180000000000000))*(pp)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(4.80000000000000))*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(9.60000000000000))*(px)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(0.00216000000000000))*(cj0)*(r00)*(r01)*(sj0)))+(((IkReal(-0.360000000000000))*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(4.80000000000000))*(cj0)*(pz)*(r00)*(r02)*((px)*(px))))+(((IkReal(0.360000000000000))*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-0.360000000000000))*((cj0)*(cj0))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(-0.108000000000000))*(cj0)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(0.360000000000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(0.00108000000000000))*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-0.180000000000000))*(pp)*((r02)*(r02))))+(((IkReal(0.108000000000000))*(px)*(r00)*(r02)))+(((IkReal(-0.720000000000000))*(px)*(py)*(r00)*(r01)))+(((IkReal(0.216000000000000))*(cj0)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(-0.360000000000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(-1.44000000000000))*(px)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(0.0126000000000000))*(px)*(r00)*(r01)*(sj0)))+(((IkReal(-0.0181200000000000))*(cj0)*(px)*((r02)*(r02))))+(((IkReal(0.0126000000000000))*(cj0)*(py)*(r00)*(r01)))+(((IkReal(-1.44000000000000))*(cj0)*(px)*(pz)*((r00)*(r00))))+(((IkReal(0.108000000000000))*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(4.80000000000000))*(px)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(-0.108000000000000))*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(1.44000000000000))*(pp)*(r01)*(r02)*(sj0)))+(((IkReal(-0.360000000000000))*((py)*(py))*((r01)*(r01))))+(((IkReal(-0.360000000000000))*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(-2.40000000000000))*(pp)*(px)*(r00)*(r01)*(sj0)))+(((IkReal(-0.360000000000000))*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(4.80000000000000))*(cj0)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(-0.720000000000000))*(cj0)*(px)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(1.44000000000000))*(cj0)*(pp)*(r00)*(r02)))+(((IkReal(-0.360000000000000))*(cj0)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-4.80000000000000))*(cj0)*(pp)*(pz)*(r00)*(r02)))+(((IkReal(-1.44000000000000))*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(4.80000000000000))*(cj0)*(px)*((py)*(py))*((r01)*(r01))))+(((IkReal(4.80000000000000))*(py)*(sj0)*((pz)*(pz))*((r01)*(r01))))+(((IkReal(-1.44000000000000))*(cj0)*(r00)*(r02)*((px)*(px))))+(((IkReal(-0.360000000000000))*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(-1.44000000000000))*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(4.80000000000000))*(r01)*(r02)*(sj0)*((pz)*(pz)*(pz))))+(((IkReal(0.0126000000000000))*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-0.00921600000000000))*(cj0)*(r00)*(r02)))+(((IkReal(-1.44000000000000))*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(0.0307200000000000))*(cj0)*(pz)*(r00)*(r02)))+(((IkReal(-0.0181200000000000))*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-0.108000000000000))*(px)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(-0.360000000000000))*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(0.0126000000000000))*(cj0)*(px)*((r00)*(r00))))+(((IkReal(4.80000000000000))*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(4.80000000000000))*(cj0)*(px)*((pz)*(pz))*((r00)*(r00))))+(((IkReal(0.360000000000000))*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(9.60000000000000))*(cj0)*(py)*(r00)*(r01)*((px)*(px))))+(((IkReal(-0.360000000000000))*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(4.80000000000000))*(cj0)*(px)*(py)*(pz)*(r01)*(r02)))+(((IkReal(-2.40000000000000))*(pp)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(0.108000000000000))*(py)*(r01)*(r02)))+(((IkReal(-1.44000000000000))*(cj0)*(py)*(pz)*(r00)*(r01)))+(((IkReal(-1.44000000000000))*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(0.00108000000000000))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-0.360000000000000))*(cj0)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-1.44000000000000))*(cj0)*(px)*(pz)*((r02)*(r02))))+(((IkReal(-0.360000000000000))*((px)*(px))*((r00)*(r00))))+(((IkReal(2.40000000000000))*(cj0)*(pp)*(px)*((r02)*(r02))))+(((IkReal(4.80000000000000))*(cj0)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(-0.108000000000000))*(cj0)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(4.80000000000000))*(cj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-2.40000000000000))*(cj0)*(pp)*(py)*(r00)*(r01)))+(((IkReal(-0.720000000000000))*(cj0)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(-0.360000000000000))*(cj0)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(-0.00921600000000000))*(r01)*(r02)*(sj0)))+(((IkReal(0.360000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)))+(((IkReal(-0.360000000000000))*(px)*(pz)*(r00)*(r02)))+(((IkReal(0.108000000000000))*(pz)*((r02)*(r02))))+(((IkReal(4.80000000000000))*(px)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(0.00338400000000000))*((r02)*(r02))))+(((IkReal(-1.44000000000000))*(cj0)*(r00)*(r02)*((pz)*(pz))))+(((IkReal(-1.44000000000000))*(cj0)*(px)*(py)*(r01)*(r02)))+(((IkReal(0.180000000000000))*(pp)*((cj0)*(cj0))*((r00)*(r00)))));
op[4]=((((IkReal(-4.00000000000000))*((cj0)*(cj0))*((px)*(px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-8.00000000000000))*(pz)*(r00)*(r02)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(-0.313500000000000))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-1.20000000000000))*(pp)*(py)*(r01)*(r02)))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(-0.00564000000000000))*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-0.00180000000000000))*(cj0)*(py)*(r00)*(r01)))+(((IkReal(2.40000000000000))*(px)*(r00)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(0.644800000000000))*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(-2.40000000000000))*(px)*(py)*(pz)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(4.80000000000000))*(cj0)*(px)*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(-0.00720000000000000))*(px)*(r00)*(r02)))+(((IkReal(0.600000000000000))*(cj0)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(-1.00000000000000))*((pp)*(pp))*((r02)*(r02))))+(((IkReal(-0.372000000000000))*(pp)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-2.40000000000000))*(pz)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-0.00564000000000000))*(cj0)*(px)*((r02)*(r02))))+(((IkReal(-8.00000000000000))*(px)*(r00)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(-8.00000000000000))*(py)*(r00)*(r01)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(4.00000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(4.00000000000000))*(pp)*(px)*(pz)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(0.0496000000000000))*((cj0)*(cj0))*((px)*(px))*((r02)*(r02))))+(((IkReal(-1.20000000000000))*(pp)*(px)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(-0.180000000000000))*(py)*(pz)*(sj0)*((r02)*(r02))))+(((IkReal(-0.382500000000000))*((py)*(py))*((r01)*(r01))))+(((IkReal(-0.180000000000000))*(px)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(-2.40000000000000))*(py)*(r01)*(r02)*((pz)*(pz))*((sj0)*(sj0))))+(((IkReal(-8.00000000000000))*(py)*(r01)*(r02)*((pz)*(pz)*(pz))))+(((IkReal(-0.600000000000000))*(pp)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(4.80000000000000))*(py)*(r01)*(r02)*((pz)*(pz))))+(((IkReal(0.644800000000000))*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(4.00000000000000))*(pp)*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(-0.180000000000000))*(px)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(0.600000000000000))*(r01)*(r02)*(sj0)*((pz)*(pz)*(pz))))+(((IkReal(2.40000000000000))*(r00)*(r02)*((cj0)*(cj0))*((px)*(px)*(px))))+(((IkReal(4.00000000000000))*(pp)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.180000000000000))*(cj0)*(r00)*(r02)*((px)*(px))))+(((IkReal(0.0225600000000000))*(px)*(r00)*(r02)*((cj0)*(cj0))))+(((IkReal(-4.00000000000000))*((py)*(py)*(py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(4.80000000000000))*(cj0)*(px)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(0.600000000000000))*(px)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(0.600000000000000))*(cj0)*(pz)*(r00)*(r02)*((px)*(px))))+(((IkReal(-2.40000000000000))*(px)*(r00)*(r02)*((cj0)*(cj0))*((pz)*(pz))))+(((IkReal(0.00453600000000000))*(cj0)*(r00)*(r01)*(sj0)))+(((IkReal(-1.20000000000000))*(pp)*(pz)*((r02)*(r02))))+(((IkReal(4.00000000000000))*(pp)*(px)*(pz)*(r00)*(r02)))+(((IkReal(0.744000000000000))*(px)*(py)*(r00)*(r01)*((sj0)*(sj0))))+(((IkReal(4.00000000000000))*(pp)*(py)*(pz)*(r01)*(r02)))+(((IkReal(-1.00000000000000))*((cj0)*(cj0))*((pp)*(pp))*((r00)*(r00))))+(((IkReal(2.40000000000000))*(pz)*((py)*(py))*((r01)*(r01))))+(((IkReal(-0.765000000000000))*(px)*(py)*(r00)*(r01)))+(((IkReal(0.600000000000000))*(cj0)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(2.40000000000000))*((pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(0.744000000000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(4.00000000000000))*(pp)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(-4.00000000000000))*((px)*(px))*((py)*(py))*((r00)*(r00))*((sj0)*(sj0))))+(((IkReal(-0.180000000000000))*(cj0)*(px)*(pz)*((r00)*(r00))))+(((IkReal(-0.00115200000000000))*(cj0)*(r00)*(r02)))+(((IkReal(1.20000000000000))*(pp)*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-4.00000000000000))*((cj0)*(cj0))*((px)*(px))*((py)*(py))*((r01)*(r01))))+(((IkReal(-0.00180000000000000))*(cj0)*(px)*((r00)*(r00))))+(((IkReal(-0.372000000000000))*(pp)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-16.0000000000000))*(cj0)*(r00)*(r01)*(sj0)*((px)*(px))*((py)*(py))))+(((IkReal(0.600000000000000))*(cj0)*(px)*(py)*(pz)*(r01)*(r02)))+(((IkReal(0.0225600000000000))*(cj0)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(4.80000000000000))*(px)*(r00)*(r02)*((pz)*(pz))))+(((IkReal(4.00000000000000))*(pp)*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.00384000000000000))*(cj0)*(pz)*(r00)*(r02)))+(((IkReal(-0.600000000000000))*(cj0)*(pp)*(pz)*(r00)*(r02)))+(((IkReal(-0.180000000000000))*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(0.744000000000000))*(cj0)*(px)*(py)*(sj0)*((r00)*(r00))))+(((IkReal(-16.0000000000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)*((px)*(px))))+(((IkReal(-2.40000000000000))*(cj0)*(py)*(r00)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(-4.00000000000000))*((px)*(px))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(0.600000000000000))*(py)*(sj0)*((px)*(px))*((r00)*(r00))))+(((IkReal(-0.00720000000000000))*(pz)*((r02)*(r02))))+(((IkReal(-8.00000000000000))*(py)*(pz)*(r01)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(-1.20000000000000))*(cj0)*(pp)*(px)*(r01)*(r02)*(sj0)))+(((IkReal(-2.40000000000000))*(px)*(py)*(pz)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(-0.0345000000000000))*(pp)*((r02)*(r02))))+(((IkReal(0.000108000000000000))*((r02)*(r02))))+(((IkReal(-0.180000000000000))*(cj0)*(r00)*(r02)*((pz)*(pz))))+(((IkReal(0.600000000000000))*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(4.00000000000000))*(pp)*(py)*(pz)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-8.00000000000000))*(pz)*(r01)*(r02)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(-0.00180000000000000))*(px)*(r00)*(r01)*(sj0)))+(((IkReal(0.600000000000000))*(px)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(0.300000000000000))*(pp)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(-0.00180000000000000))*(py)*(sj0)*((r01)*(r01))))+(((IkReal(-2.40000000000000))*(cj0)*(px)*(r01)*(r02)*(sj0)*((pz)*(pz))))+(((IkReal(0.0225600000000000))*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(2.40000000000000))*(py)*(r01)*(r02)*((cj0)*(cj0))*((px)*(px))))+(((IkReal(0.744000000000000))*(px)*(py)*(r00)*(r01)*((cj0)*(cj0))))+(((IkReal(-8.00000000000000))*(px)*(r00)*(r01)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(0.600000000000000))*(cj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-0.744000000000000))*(cj0)*(pp)*(r00)*(r01)*(sj0)))+(((IkReal(4.80000000000000))*(cj0)*(py)*(r00)*(r02)*(sj0)*((px)*(px))))+(((IkReal(0.0992000000000000))*(cj0)*(px)*(py)*(sj0)*((r02)*(r02))))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(0.644800000000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-8.00000000000000))*(cj0)*(py)*(sj0)*((px)*(px)*(px))*((r00)*(r00))))+(((IkReal(-0.696000000000000))*(py)*(pz)*(r01)*(r02)))+(((IkReal(-0.180000000000000))*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-2.40000000000000))*(cj0)*(px)*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(-4.00000000000000))*((py)*(py))*((pz)*(pz))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(1.20000000000000))*(cj0)*(py)*(r00)*(r01)*((px)*(px))))+(((IkReal(-2.40000000000000))*(cj0)*(px)*(py)*(pz)*(sj0)*((r00)*(r00))))+(((IkReal(0.00226800000000000))*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-2.40000000000000))*(cj0)*(pz)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(0.180000000000000))*(cj0)*(pp)*(r00)*(r02)))+(((IkReal(-8.00000000000000))*(px)*(pz)*(r00)*(r02)*((py)*(py))*((sj0)*(sj0))))+(((IkReal(-1.20000000000000))*(cj0)*(pp)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(0.0496000000000000))*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(-4.00000000000000))*((py)*(py))*((pz)*(pz))*((r01)*(r01))))+(((IkReal(0.00384000000000000))*(pz)*(r01)*(r02)*(sj0)))+(((IkReal(-2.00000000000000))*(cj0)*(r00)*(r01)*(sj0)*((pp)*(pp))))+(((IkReal(0.600000000000000))*(cj0)*(px)*((py)*(py))*((r01)*(r01))))+(((IkReal(-4.00000000000000))*((pz)*(pz)*(pz)*(pz))*((r02)*(r02))))+(((IkReal(-0.382500000000000))*((px)*(px))*((r00)*(r00))))+(((IkReal(2.40000000000000))*(pz)*((py)*(py))*((r02)*(r02))*((sj0)*(sj0))))+(((IkReal(-0.0225600000000000))*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(-0.300000000000000))*(cj0)*(pp)*(px)*((r00)*(r00))))+(((IkReal(2.40000000000000))*(r01)*(r02)*((py)*(py)*(py))*((sj0)*(sj0))))+(((IkReal(2.40000000000000))*(pz)*((px)*(px))*((r00)*(r00))))+(((IkReal(-0.180000000000000))*(cj0)*(py)*(pz)*(r00)*(r01)))+(((IkReal(0.0496000000000000))*((cj0)*(cj0))*((pz)*(pz))*((r00)*(r00))))+(((IkReal(-0.180000000000000))*(cj0)*(px)*(py)*(r01)*(r02)))+(((IkReal(0.0992000000000000))*(cj0)*(r00)*(r01)*(sj0)*((pz)*(pz))))+(((IkReal(-0.300000000000000))*(pp)*(px)*(r00)*(r01)*(sj0)))+(((IkReal(0.0496000000000000))*((pz)*(pz))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-8.00000000000000))*(px)*(py)*(r00)*(r01)*((pz)*(pz))))+(((IkReal(-4.00000000000000))*((cj0)*(cj0))*((px)*(px))*((pz)*(pz))*((r02)*(r02))))+(((IkReal(-1.20000000000000))*(pp)*(px)*(r00)*(r02)))+(((IkReal(2.40000000000000))*(cj0)*(pp)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(-1.20000000000000))*(pp)*(py)*(r01)*(r02)*((sj0)*(sj0))))+(((IkReal(-0.696000000000000))*(px)*(pz)*(r00)*(r02)))+(((IkReal(-0.300000000000000))*(pp)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(0.600000000000000))*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(-0.0451200000000000))*(cj0)*(pz)*(r00)*(r01)*(sj0)))+(((IkReal(-8.00000000000000))*(cj0)*(px)*(py)*(sj0)*((pz)*(pz))*((r02)*(r02))))+(((IkReal(0.644800000000000))*(cj0)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(1.20000000000000))*(pp)*(pz)*((cj0)*(cj0))*((r00)*(r00))))+(((IkReal(0.744000000000000))*(cj0)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(1.20000000000000))*(px)*(r00)*(r01)*(sj0)*((py)*(py))))+(((IkReal(0.744000000000000))*(cj0)*(px)*(py)*(sj0)*((r01)*(r01))))+(((IkReal(0.180000000000000))*(pp)*(r01)*(r02)*(sj0)))+(((IkReal(0.744000000000000))*((py)*(py))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-0.180000000000000))*(py)*(pz)*(sj0)*((r01)*(r01))))+(((IkReal(-0.00720000000000000))*(py)*(r01)*(r02)))+(((IkReal(-1.00000000000000))*((pp)*(pp))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(-2.40000000000000))*(cj0)*(pz)*(r00)*(r01)*(sj0)*((px)*(px))))+(((IkReal(4.00000000000000))*(cj0)*(pp)*(py)*(pz)*(r00)*(r02)*(sj0)))+(((IkReal(-0.300000000000000))*(cj0)*(pp)*(py)*(r00)*(r01)))+(((IkReal(-8.00000000000000))*(cj0)*(px)*(sj0)*((py)*(py)*(py))*((r01)*(r01))))+(((IkReal(-16.0000000000000))*(cj0)*(px)*(pz)*(r01)*(r02)*(sj0)*((py)*(py))))+(((IkReal(0.300000000000000))*(cj0)*(pp)*(px)*((r02)*(r02))))+(((IkReal(-0.0225600000000000))*(pz)*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.600000000000000))*(py)*(sj0)*((pz)*(pz))*((r01)*(r01))))+(((IkReal(-0.180000000000000))*(cj0)*(px)*(pz)*((r02)*(r02))))+(((IkReal(0.0225600000000000))*(cj0)*(py)*(r00)*(r02)*(sj0)))+(((IkReal(0.600000000000000))*(cj0)*(px)*((pz)*(pz))*((r00)*(r00))))+(((IkReal(-2.40000000000000))*(pz)*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(0.00226800000000000))*((r01)*(r01))*((sj0)*(sj0))))+(((IkReal(0.744000000000000))*((cj0)*(cj0))*((px)*(px))*((r00)*(r00))))+(((IkReal(4.80000000000000))*(px)*(py)*(pz)*(r00)*(r01)))+(((IkReal(-0.00115200000000000))*(r01)*(r02)*(sj0)))+(((IkReal(2.40000000000000))*(pz)*((cj0)*(cj0))*((px)*(px))*((r02)*(r02)))));
polyroots4(op,zeror,numroots);
IkReal j1array[4], cj1array[4], sj1array[4], tempj1array[1];
int numsolutions = 0;
for(int ij1 = 0; ij1 < numroots; ++ij1)
{
IkReal htj1 = zeror[ij1];
tempj1array[0]=((IkReal(2.00000000000000))*(atan(htj1)));
for(int kj1 = 0; kj1 < 1; ++kj1)
{
j1array[numsolutions] = tempj1array[kj1];
if( j1array[numsolutions] > IKPI )
{
    j1array[numsolutions]-=IK2PI;
}
else if( j1array[numsolutions] < -IKPI )
{
    j1array[numsolutions]+=IK2PI;
}
sj1array[numsolutions] = IKsin(j1array[numsolutions]);
cj1array[numsolutions] = IKcos(j1array[numsolutions]);
numsolutions++;
}
}
bool j1valid[4]={true,true,true,true};
_nj1 = 4;
for(int ij1 = 0; ij1 < numsolutions; ++ij1)
    {
if( !j1valid[ij1] )
{
    continue;
}
    j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
htj1 = IKtan(j1/2);

_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < numsolutions; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
{
IkReal j4array[2], cj4array[2], sj4array[2];
bool j4valid[2]={false};
_nj4 = 2;
sj4array[0]=((((IkReal(-1.00000000000000))*(r00)*(sj0)))+(((cj0)*(r01))));
if( sj4array[0] >= -1-IKFAST_SINCOS_THRESH && sj4array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j4valid[0] = j4valid[1] = true;
    j4array[0] = IKasin(sj4array[0]);
    cj4array[0] = IKcos(j4array[0]);
    sj4array[1] = sj4array[0];
    j4array[1] = j4array[0] > 0 ? (IKPI-j4array[0]) : (-IKPI-j4array[0]);
    cj4array[1] = -cj4array[0];
}
else if( isnan(sj4array[0]) )
{
    // probably any value will work
    j4valid[0] = true;
    cj4array[0] = 1; sj4array[0] = 0; j4array[0] = 0;
}
for(int ij4 = 0; ij4 < 2; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 2; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];

{
IkReal dummyeval[1];
IkReal gconst0;
gconst0=IKsign(cj4);
dummyeval[0]=cj4;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst1;
gconst1=IKsign(cj4);
dummyeval[0]=cj4;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[9];
IkReal x31=(py)*(py);
IkReal x32=(px)*(px);
IkReal x33=(pz)*(pz);
IkReal x34=((r02)*(sj1));
IkReal x35=((cj1)*(pz));
IkReal x36=((IkReal(0.150000000000000))*(r00));
IkReal x37=((IkReal(0.600000000000000))*(r02));
IkReal x38=((cj0)*(px));
IkReal x39=((r01)*(sj0));
IkReal x40=((IkReal(1.00000000000000))*(cj1));
IkReal x41=((py)*(sj0));
IkReal x42=((py)*(r01));
IkReal x43=((IkReal(0.150000000000000))*(sj1));
IkReal x44=((IkReal(1.00000000000000))*(pz));
IkReal x45=((px)*(sj1));
IkReal x46=((IkReal(0.600000000000000))*(r00));
IkReal x47=((cj0)*(r00));
IkReal x48=((IkReal(0.0843750000000000))*(cj1));
IkReal x49=((IkReal(2.00000000000000))*(pz));
IkReal x50=((cj1)*(px));
IkReal x51=((IkReal(1.00000000000000))*(px));
IkReal x52=((IkReal(0.300000000000000))*(cj1));
IkReal x53=((IkReal(0.0956250000000000))*(sj1));
IkReal x54=((IkReal(1.00000000000000))*(sj1));
IkReal x55=((cj0)*(pz));
IkReal x56=((IkReal(0.150000000000000))*(cj1));
IkReal x57=((IkReal(2.00000000000000))*(sj1));
IkReal x58=((IkReal(2.00000000000000))*(cj1));
IkReal x59=((IkReal(2.00000000000000))*(r00));
IkReal x60=((IkReal(0.300000000000000))*(sj1));
IkReal x61=((r02)*(x41));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j4)), IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(sj0)*(x51)))+(((cj0)*(py))));
evalcond[2]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(r00)*(sj0)))+(((cj0)*(r01))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x40)*(x47)))+(x34)+(((IkReal(-1.00000000000000))*(x39)*(x40))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r02)*(x40)))+(((IkReal(-1.00000000000000))*(x39)*(x54)))+(((IkReal(-1.00000000000000))*(x47)*(x54))));
evalcond[5]=((((IkReal(0.0750000000000000))*(x39)))+(((r02)*(x52)))+(((IkReal(-1.00000000000000))*(r00)*(x51)))+(((IkReal(0.0750000000000000))*(x47)))+(((x39)*(x60)))+(((IkReal(-1.00000000000000))*(x42)))+(((IkReal(-1.00000000000000))*(r02)*(x44)))+(((x47)*(x60))));
evalcond[6]=((x61)+(((r02)*(x38)))+(((IkReal(-1.00000000000000))*(x39)*(x44)))+(((x47)*(x52)))+(((IkReal(-1.00000000000000))*(x44)*(x47)))+(((IkReal(-0.0750000000000000))*(r02)))+(((IkReal(-0.300000000000000))*(x34)))+(((x39)*(x52))));
evalcond[7]=((((r02)*(x33)*(x58)))+(((IkReal(-1.00000000000000))*(x42)*(x43)))+(((x39)*(x53)))+(((x34)*(x41)*(x49)))+(((x34)*(x38)*(x49)))+(((px)*(x35)*(x59)))+(((x41)*(x45)*(x59)))+(((IkReal(-1.00000000000000))*(pp)*(x47)*(x54)))+(((x56)*(x61)))+(((x38)*(x42)*(x57)))+(((IkReal(-1.00000000000000))*(x36)*(x45)))+(((IkReal(-1.00000000000000))*(cj0)*(x35)*(x36)))+(((IkReal(-1.00000000000000))*(pp)*(x39)*(x54)))+(((IkReal(-0.600000000000000))*(x42)))+(((x32)*(x47)*(x57)))+(((IkReal(-0.150000000000000))*(pz)*(x34)))+(((IkReal(-1.00000000000000))*(pz)*(x37)))+(((IkReal(-1.00000000000000))*(px)*(x46)))+(((r02)*(x38)*(x56)))+(((IkReal(-1.00000000000000))*(pp)*(r02)*(x40)))+(((r02)*(x48)))+(((x47)*(x53)))+(((x31)*(x39)*(x57)))+(((IkReal(0.0450000000000000))*(x39)))+(((IkReal(2.00000000000000))*(x35)*(x42)))+(((IkReal(-0.150000000000000))*(x35)*(x39)))+(((IkReal(0.0450000000000000))*(x47))));
evalcond[8]=((((pz)*(x39)*(x43)))+(((IkReal(-1.00000000000000))*(pp)*(x40)*(x47)))+(((IkReal(0.600000000000000))*(pz)*(x39)))+(((IkReal(0.0450000000000000))*(r02)))+(((pp)*(x34)))+(((x41)*(x50)*(x59)))+(((IkReal(-0.150000000000000))*(x34)*(x41)))+(((IkReal(-2.00000000000000))*(x33)*(x34)))+(((x31)*(x39)*(x58)))+(((IkReal(-1.00000000000000))*(x47)*(x48)))+(((sj1)*(x36)*(x55)))+(((IkReal(2.00000000000000))*(r02)*(x35)*(x38)))+(((x32)*(x47)*(x58)))+(((IkReal(-1.00000000000000))*(x39)*(x48)))+(((IkReal(-1.00000000000000))*(r00)*(x45)*(x49)))+(((IkReal(-1.00000000000000))*(sj1)*(x42)*(x49)))+(((IkReal(-1.00000000000000))*(pp)*(x39)*(x40)))+(((IkReal(-1.00000000000000))*(x37)*(x41)))+(((IkReal(-1.00000000000000))*(x42)*(x56)))+(((IkReal(-1.00000000000000))*(x36)*(x50)))+(((IkReal(0.0956250000000000))*(x34)))+(((IkReal(-0.150000000000000))*(r02)*(x35)))+(((IkReal(-0.150000000000000))*(x34)*(x38)))+(((x46)*(x55)))+(((x38)*(x42)*(x58)))+(((IkReal(-1.00000000000000))*(x37)*(x38)))+(((IkReal(2.00000000000000))*(x35)*(x61))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[2], cj3array[2], sj3array[2];
bool j3valid[2]={false};
_nj3 = 2;
IkReal x62=((IkReal(11.4095661394664))*(sj1));
IkReal x63=((cj0)*(px));
IkReal x64=((py)*(sj0));
if( (((IkReal(0.357499739036614))+(((IkReal(-19.0159435657774))*(pp)))+(((IkReal(2.85239153486660))*(x63)))+(((x62)*(x64)))+(((x62)*(x63)))+(((IkReal(2.85239153486660))*(x64)))+(((IkReal(11.4095661394664))*(cj1)*(pz)))+(((IkReal(-0.855717460459981))*(sj1))))) < -1-IKFAST_SINCOS_THRESH || (((IkReal(0.357499739036614))+(((IkReal(-19.0159435657774))*(pp)))+(((IkReal(2.85239153486660))*(x63)))+(((x62)*(x64)))+(((x62)*(x63)))+(((IkReal(2.85239153486660))*(x64)))+(((IkReal(11.4095661394664))*(cj1)*(pz)))+(((IkReal(-0.855717460459981))*(sj1))))) > 1+IKFAST_SINCOS_THRESH )
    continue;
IkReal x65=IKasin(((IkReal(0.357499739036614))+(((IkReal(-19.0159435657774))*(pp)))+(((IkReal(2.85239153486660))*(x63)))+(((x62)*(x64)))+(((x62)*(x63)))+(((IkReal(2.85239153486660))*(x64)))+(((IkReal(11.4095661394664))*(cj1)*(pz)))+(((IkReal(-0.855717460459981))*(sj1)))));
j3array[0]=((IkReal(-1.34057673951805))+(((IkReal(-1.00000000000000))*(x65))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
j3array[1]=((IkReal(1.80101591407174))+(x65));
sj3array[1]=IKsin(j3array[1]);
cj3array[1]=IKcos(j3array[1]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
if( j3array[1] > IKPI )
{
    j3array[1]-=IK2PI;
}
else if( j3array[1] < -IKPI )
{    j3array[1]+=IK2PI;
}
j3valid[1] = true;
for(int ij3 = 0; ij3 < 2; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 2; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[1];
IkReal x66=((IkReal(2.00000000000000))*(sj0));
IkReal x67=((px)*(py));
IkReal x68=((r00)*(sj0));
IkReal x69=((cj0)*(r01));
IkReal x70=((py)*(r00));
IkReal x71=((IkReal(2.00000000000000))*(cj0));
IkReal x72=((px)*(r01));
IkReal x73=((IkReal(0.600000000000000))*(cj1));
IkReal x74=((py)*(r02));
IkReal x75=((IkReal(0.600000000000000))*(sj1));
IkReal x76=((IkReal(0.0450000000000000))*(sj1));
IkReal x77=((px)*(r02));
evalcond[0]=((IkReal(-0.114425000000000))+(((IkReal(-1.00000000000000))*(pz)*(x71)*(x74)))+(((IkReal(0.150000000000000))*(x70)))+(((IkReal(-1.00000000000000))*(sj0)*(x73)*(x77)))+(((IkReal(-1.00000000000000))*(x68)*(x76)))+(((IkReal(0.0956250000000000))*(x69)))+(((cj0)*(x73)*(x74)))+(((IkReal(-2.00000000000000))*(x69)*((py)*(py))))+(((IkReal(-1.00000000000000))*(pz)*(x69)*(x73)))+(((IkReal(-1.00000000000000))*(x72)*(x75)))+(((r00)*(x66)*((px)*(px))))+(((pz)*(x68)*(x73)))+(((IkReal(-0.150000000000000))*(x72)))+(((pz)*(x66)*(x77)))+(((pp)*(x69)))+(((IkReal(-0.0120000000000000))*(IKsin(j3))))+(((x70)*(x75)))+(((IkReal(-0.0512000000000000))*(IKcos(j3))))+(((IkReal(-1.00000000000000))*(pp)*(x68)))+(((r01)*(x66)*(x67)))+(((IkReal(-0.0956250000000000))*(x68)))+(((IkReal(-1.00000000000000))*(r00)*(x67)*(x71)))+(((x69)*(x76))));
if( IKabs(evalcond[0]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst8;
gconst8=IKsign(((IkReal(0.108025000000000))+(((IkReal(0.0512000000000000))*(cj3)))+(((IkReal(0.00640000000000000))*((sj3)*(sj3))))+(((IkReal(0.00640000000000000))*((cj3)*(cj3))))+(((IkReal(0.0120000000000000))*(sj3)))));
dummyeval[0]=((IkReal(16.8789062500000))+((cj3)*(cj3))+(((IkReal(1.87500000000000))*(sj3)))+((sj3)*(sj3))+(((IkReal(8.00000000000000))*(cj3))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst9;
gconst9=IKsign(((IkReal(0.108025000000000))+(((IkReal(0.0512000000000000))*(cj3)))+(((IkReal(0.00640000000000000))*((sj3)*(sj3))))+(((IkReal(0.00640000000000000))*((cj3)*(cj3))))+(((IkReal(0.0120000000000000))*(sj3)))));
dummyeval[0]=((IkReal(16.8789062500000))+((cj3)*(cj3))+(((IkReal(1.87500000000000))*(sj3)))+((sj3)*(sj3))+(((IkReal(8.00000000000000))*(cj3))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x78=((r02)*(sj0));
IkReal x79=((IkReal(0.0800000000000000))*(sj1));
IkReal x80=((cj3)*(px));
IkReal x81=((cj0)*(r01));
IkReal x82=((IkReal(0.0240000000000000))*(cj1));
IkReal x83=((pz)*(sj3));
IkReal x84=((IkReal(0.00600000000000000))*(cj1));
IkReal x85=((IkReal(0.00562500000000000))*(cj1));
IkReal x86=((IkReal(0.0750000000000000))*(sj1));
IkReal x87=((r00)*(sj0));
IkReal x88=((cj3)*(pz));
IkReal x89=((IkReal(0.320000000000000))*(py));
IkReal x90=((IkReal(0.0800000000000000))*(cj1));
IkReal x91=((IkReal(0.0750000000000000))*(cj1));
IkReal x92=((py)*(sj0));
IkReal x93=((IkReal(0.320000000000000))*(sj1));
IkReal x94=((cj0)*(px));
IkReal x95=((py)*(r00));
IkReal x96=((IkReal(0.00600000000000000))*(sj1));
IkReal x97=((cj1)*(px)*(r01));
IkReal x98=((cj0)*(py)*(r02));
IkReal x99=((px)*(sj3)*(x79));
if( IKabs(((gconst9)*(((IkReal(-0.0960000000000000))+(((IkReal(-1.00000000000000))*(sj3)*(x79)*(x98)))+(((sj0)*(sj1)*(x89)))+(((IkReal(-1.00000000000000))*(px)*(r01)*(sj3)*(x90)))+(((cj3)*(x79)*(x92)))+(((sj3)*(x81)*(x84)))+(((px)*(x78)*(x86)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((IkReal(-0.0240000000000000))*(sj1)))+(((x93)*(x94)))+(((x79)*(x81)*(x83)))+(((IkReal(-1.00000000000000))*(x85)*(x87)))+(((IkReal(-1.00000000000000))*(x86)*(x98)))+(((sj3)*(x90)*(x95)))+(((IkReal(-1.00000000000000))*(x79)*(x83)*(x87)))+(((cj0)*(x79)*(x80)))+(((IkReal(-1.00000000000000))*(sj3)*(x84)*(x87)))+(((IkReal(0.320000000000000))*(cj1)*(pz)))+(((pz)*(x81)*(x86)))+(((x88)*(x90)))+(((IkReal(-1.00000000000000))*(pz)*(x86)*(x87)))+(((IkReal(-1.00000000000000))*(px)*(r01)*(x91)))+(((x78)*(x99)))+(((x81)*(x85)))+(((IkReal(-1.00000000000000))*(cj3)*(x96)))+(((x91)*(x95))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst9)*(((IkReal(-0.0225000000000000))+(((IkReal(-0.0240000000000000))*(sj3)))+(((cj0)*(r02)*(sj1)*(x89)))+(((x79)*(x87)*(x88)))+(((cj3)*(x79)*(x98)))+(((IkReal(-1.00000000000000))*(pz)*(x81)*(x93)))+(((IkReal(-1.00000000000000))*(px)*(x78)*(x93)))+(((IkReal(-1.00000000000000))*(cj1)*(r00)*(x89)))+(((IkReal(-1.00000000000000))*(x78)*(x79)*(x80)))+(((pz)*(x91)))+(((IkReal(-1.00000000000000))*(x79)*(x81)*(x88)))+(((x82)*(x87)))+(((IkReal(-1.00000000000000))*(cj3)*(x90)*(x95)))+(((sj3)*(x79)*(x92)))+(((IkReal(-1.00000000000000))*(sj3)*(x96)))+(((cj3)*(x84)*(x87)))+(((pz)*(x87)*(x93)))+(((r01)*(x80)*(x90)))+(((x83)*(x90)))+(((IkReal(-1.00000000000000))*(cj3)*(x81)*(x84)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((x86)*(x94)))+(((sj3)*(x79)*(x94)))+(((IkReal(0.320000000000000))*(x97)))+(((x86)*(x92)))+(((IkReal(-1.00000000000000))*(x81)*(x82))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst9)*(((IkReal(-0.0960000000000000))+(((IkReal(-1.00000000000000))*(sj3)*(x79)*(x98)))+(((sj0)*(sj1)*(x89)))+(((IkReal(-1.00000000000000))*(px)*(r01)*(sj3)*(x90)))+(((cj3)*(x79)*(x92)))+(((sj3)*(x81)*(x84)))+(((px)*(x78)*(x86)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((IkReal(-0.0240000000000000))*(sj1)))+(((x93)*(x94)))+(((x79)*(x81)*(x83)))+(((IkReal(-1.00000000000000))*(x85)*(x87)))+(((IkReal(-1.00000000000000))*(x86)*(x98)))+(((sj3)*(x90)*(x95)))+(((IkReal(-1.00000000000000))*(x79)*(x83)*(x87)))+(((cj0)*(x79)*(x80)))+(((IkReal(-1.00000000000000))*(sj3)*(x84)*(x87)))+(((IkReal(0.320000000000000))*(cj1)*(pz)))+(((pz)*(x81)*(x86)))+(((x88)*(x90)))+(((IkReal(-1.00000000000000))*(pz)*(x86)*(x87)))+(((IkReal(-1.00000000000000))*(px)*(r01)*(x91)))+(((x78)*(x99)))+(((x81)*(x85)))+(((IkReal(-1.00000000000000))*(cj3)*(x96)))+(((x91)*(x95)))))), ((gconst9)*(((IkReal(-0.0225000000000000))+(((IkReal(-0.0240000000000000))*(sj3)))+(((cj0)*(r02)*(sj1)*(x89)))+(((x79)*(x87)*(x88)))+(((cj3)*(x79)*(x98)))+(((IkReal(-1.00000000000000))*(pz)*(x81)*(x93)))+(((IkReal(-1.00000000000000))*(px)*(x78)*(x93)))+(((IkReal(-1.00000000000000))*(cj1)*(r00)*(x89)))+(((IkReal(-1.00000000000000))*(x78)*(x79)*(x80)))+(((pz)*(x91)))+(((IkReal(-1.00000000000000))*(x79)*(x81)*(x88)))+(((x82)*(x87)))+(((IkReal(-1.00000000000000))*(cj3)*(x90)*(x95)))+(((sj3)*(x79)*(x92)))+(((IkReal(-1.00000000000000))*(sj3)*(x96)))+(((cj3)*(x84)*(x87)))+(((pz)*(x87)*(x93)))+(((r01)*(x80)*(x90)))+(((x83)*(x90)))+(((IkReal(-1.00000000000000))*(cj3)*(x81)*(x84)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((x86)*(x94)))+(((sj3)*(x79)*(x94)))+(((IkReal(0.320000000000000))*(x97)))+(((x86)*(x92)))+(((IkReal(-1.00000000000000))*(x81)*(x82)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x100=IKcos(j2);
IkReal x101=IKsin(j2);
IkReal x102=((IkReal(0.0800000000000000))*(sj3));
IkReal x103=((cj0)*(r01));
IkReal x104=((IkReal(1.00000000000000))*(px));
IkReal x105=((py)*(sj1));
IkReal x106=((cj0)*(r02));
IkReal x107=((IkReal(0.0750000000000000))*(cj1));
IkReal x108=((r02)*(sj0));
IkReal x109=((IkReal(0.0750000000000000))*(sj1));
IkReal x110=((cj1)*(pz));
IkReal x111=((r00)*(sj0));
IkReal x112=((IkReal(0.0800000000000000))*(cj3));
IkReal x113=((pz)*(sj1));
IkReal x114=((IkReal(1.00000000000000))*(sj0));
IkReal x115=((cj1)*(py));
IkReal x116=((IkReal(0.0750000000000000))*(x101));
IkReal x117=((IkReal(0.320000000000000))*(x100));
IkReal x118=((IkReal(0.320000000000000))*(x101));
IkReal x119=((IkReal(0.0750000000000000))*(x100));
IkReal x120=((sj1)*(x111));
IkReal x121=((x101)*(x102));
IkReal x122=((x100)*(x112));
IkReal x123=((x100)*(x102));
IkReal x124=((x101)*(x112));
IkReal x125=((x121)+(x116));
IkReal x126=((x122)+(x117));
IkReal x127=((x124)+(x123)+(x119)+(x118));
evalcond[0]=((((IkReal(-1.00000000000000))*(cj0)*(cj1)*(x104)))+(((IkReal(-1.00000000000000))*(x114)*(x115)))+(x126)+(((IkReal(-1.00000000000000))*(x125)))+(x107)+(x113));
evalcond[1]=((IkReal(0.300000000000000))+(((IkReal(-1.00000000000000))*(x105)*(x114)))+(((IkReal(-1.00000000000000))*(cj0)*(sj1)*(x104)))+(x127)+(x109)+(((IkReal(-1.00000000000000))*(x110))));
evalcond[2]=((((IkReal(-1.00000000000000))*(sj1)*(x104)*(x108)))+(((x111)*(x113)))+(((x107)*(x111)))+(((x105)*(x106)))+(((IkReal(-1.00000000000000))*(x126)))+(((IkReal(-1.00000000000000))*(r00)*(x115)))+(((cj1)*(px)*(r01)))+(x125)+(((IkReal(-1.00000000000000))*(x103)*(x113)))+(((IkReal(-1.00000000000000))*(x103)*(x107))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x109)*(x111)))+(((IkReal(-1.00000000000000))*(r01)*(sj1)*(x104)))+(((x110)*(x111)))+(((IkReal(-1.00000000000000))*(cj1)*(x104)*(x108)))+(((IkReal(-1.00000000000000))*(x103)*(x110)))+(x127)+(((IkReal(0.300000000000000))*(x103)))+(((x106)*(x115)))+(((IkReal(-0.300000000000000))*(x111)))+(((r00)*(x105)))+(((x103)*(x109))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x128=((IkReal(0.0800000000000000))*(cj1));
IkReal x129=((cj0)*(px));
IkReal x130=((py)*(sj0));
IkReal x131=((IkReal(0.320000000000000))*(sj1));
IkReal x132=((IkReal(0.00600000000000000))*(cj3));
IkReal x133=((pz)*(sj3));
IkReal x134=((IkReal(0.0750000000000000))*(cj1));
IkReal x135=((IkReal(0.0800000000000000))*(sj1));
IkReal x136=((IkReal(0.0750000000000000))*(sj1));
IkReal x137=((IkReal(0.00600000000000000))*(sj3));
IkReal x138=((cj3)*(pz));
IkReal x139=((IkReal(0.320000000000000))*(cj1));
if( IKabs(((gconst8)*(((IkReal(-0.0960000000000000))+(((IkReal(-1.00000000000000))*(sj1)*(x132)))+(((IkReal(-1.00000000000000))*(x130)*(x134)))+(((IkReal(-1.00000000000000))*(sj3)*(x128)*(x130)))+(((cj3)*(x129)*(x135)))+(((cj3)*(x130)*(x135)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((x133)*(x135)))+(((IkReal(-0.0240000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(sj3)*(x128)*(x129)))+(((x128)*(x138)))+(((IkReal(-1.00000000000000))*(x129)*(x134)))+(((x130)*(x131)))+(((cj1)*(x137)))+(((pz)*(x136)))+(((pz)*(x139)))+(((IkReal(0.00562500000000000))*(cj1)))+(((x129)*(x131))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst8)*(((IkReal(-0.0225000000000000))+(((IkReal(-0.0240000000000000))*(sj3)))+(((sj3)*(x129)*(x135)))+(((x129)*(x139)))+(((pz)*(x134)))+(((x130)*(x139)))+(((IkReal(-1.00000000000000))*(x135)*(x138)))+(((IkReal(-1.00000000000000))*(pz)*(x131)))+(((x130)*(x136)))+(((IkReal(-0.0240000000000000))*(cj1)))+(((sj3)*(x130)*(x135)))+(((cj3)*(x128)*(x130)))+(((IkReal(-1.00000000000000))*(cj1)*(x132)))+(((x128)*(x133)))+(((x129)*(x136)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(sj1)*(x137)))+(((cj3)*(x128)*(x129))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst8)*(((IkReal(-0.0960000000000000))+(((IkReal(-1.00000000000000))*(sj1)*(x132)))+(((IkReal(-1.00000000000000))*(x130)*(x134)))+(((IkReal(-1.00000000000000))*(sj3)*(x128)*(x130)))+(((cj3)*(x129)*(x135)))+(((cj3)*(x130)*(x135)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((x133)*(x135)))+(((IkReal(-0.0240000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(sj3)*(x128)*(x129)))+(((x128)*(x138)))+(((IkReal(-1.00000000000000))*(x129)*(x134)))+(((x130)*(x131)))+(((cj1)*(x137)))+(((pz)*(x136)))+(((pz)*(x139)))+(((IkReal(0.00562500000000000))*(cj1)))+(((x129)*(x131)))))), ((gconst8)*(((IkReal(-0.0225000000000000))+(((IkReal(-0.0240000000000000))*(sj3)))+(((sj3)*(x129)*(x135)))+(((x129)*(x139)))+(((pz)*(x134)))+(((x130)*(x139)))+(((IkReal(-1.00000000000000))*(x135)*(x138)))+(((IkReal(-1.00000000000000))*(pz)*(x131)))+(((x130)*(x136)))+(((IkReal(-0.0240000000000000))*(cj1)))+(((sj3)*(x130)*(x135)))+(((cj3)*(x128)*(x130)))+(((IkReal(-1.00000000000000))*(cj1)*(x132)))+(((x128)*(x133)))+(((x129)*(x136)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(sj1)*(x137)))+(((cj3)*(x128)*(x129)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x140=IKcos(j2);
IkReal x141=IKsin(j2);
IkReal x142=((IkReal(0.0800000000000000))*(sj3));
IkReal x143=((cj0)*(r01));
IkReal x144=((IkReal(1.00000000000000))*(px));
IkReal x145=((py)*(sj1));
IkReal x146=((cj0)*(r02));
IkReal x147=((IkReal(0.0750000000000000))*(cj1));
IkReal x148=((r02)*(sj0));
IkReal x149=((IkReal(0.0750000000000000))*(sj1));
IkReal x150=((cj1)*(pz));
IkReal x151=((r00)*(sj0));
IkReal x152=((IkReal(0.0800000000000000))*(cj3));
IkReal x153=((pz)*(sj1));
IkReal x154=((IkReal(1.00000000000000))*(sj0));
IkReal x155=((cj1)*(py));
IkReal x156=((IkReal(0.0750000000000000))*(x141));
IkReal x157=((IkReal(0.320000000000000))*(x140));
IkReal x158=((IkReal(0.320000000000000))*(x141));
IkReal x159=((IkReal(0.0750000000000000))*(x140));
IkReal x160=((sj1)*(x151));
IkReal x161=((x141)*(x142));
IkReal x162=((x140)*(x152));
IkReal x163=((x140)*(x142));
IkReal x164=((x141)*(x152));
IkReal x165=((x156)+(x161));
IkReal x166=((x157)+(x162));
IkReal x167=((x159)+(x158)+(x163)+(x164));
evalcond[0]=((((IkReal(-1.00000000000000))*(x154)*(x155)))+(x153)+(((IkReal(-1.00000000000000))*(x165)))+(x166)+(((IkReal(-1.00000000000000))*(cj0)*(cj1)*(x144)))+(x147));
evalcond[1]=((IkReal(0.300000000000000))+(((IkReal(-1.00000000000000))*(x150)))+(x167)+(((IkReal(-1.00000000000000))*(x145)*(x154)))+(x149)+(((IkReal(-1.00000000000000))*(cj0)*(sj1)*(x144))));
evalcond[2]=((((x151)*(x153)))+(((IkReal(-1.00000000000000))*(x143)*(x147)))+(((IkReal(-1.00000000000000))*(x166)))+(((cj1)*(px)*(r01)))+(x165)+(((x147)*(x151)))+(((IkReal(-1.00000000000000))*(sj1)*(x144)*(x148)))+(((IkReal(-1.00000000000000))*(x143)*(x153)))+(((x145)*(x146)))+(((IkReal(-1.00000000000000))*(r00)*(x155))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r01)*(sj1)*(x144)))+(((r00)*(x145)))+(((x143)*(x149)))+(((IkReal(0.300000000000000))*(x143)))+(((x150)*(x151)))+(x167)+(((IkReal(-0.300000000000000))*(x151)))+(((IkReal(-1.00000000000000))*(x143)*(x150)))+(((IkReal(-1.00000000000000))*(cj1)*(x144)*(x148)))+(((IkReal(-1.00000000000000))*(x149)*(x151)))+(((x146)*(x155))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
IkReal x168=(py)*(py);
IkReal x169=(px)*(px);
IkReal x170=(pz)*(pz);
IkReal x171=((r02)*(sj1));
IkReal x172=((cj1)*(pz));
IkReal x173=((IkReal(0.150000000000000))*(r00));
IkReal x174=((IkReal(0.600000000000000))*(r02));
IkReal x175=((cj0)*(px));
IkReal x176=((r01)*(sj0));
IkReal x177=((IkReal(1.00000000000000))*(cj1));
IkReal x178=((py)*(sj0));
IkReal x179=((py)*(r01));
IkReal x180=((IkReal(0.150000000000000))*(sj1));
IkReal x181=((IkReal(1.00000000000000))*(pz));
IkReal x182=((px)*(sj1));
IkReal x183=((IkReal(0.600000000000000))*(r00));
IkReal x184=((cj0)*(r00));
IkReal x185=((IkReal(0.0843750000000000))*(cj1));
IkReal x186=((IkReal(2.00000000000000))*(pz));
IkReal x187=((cj1)*(px));
IkReal x188=((IkReal(1.00000000000000))*(px));
IkReal x189=((IkReal(0.300000000000000))*(cj1));
IkReal x190=((IkReal(0.0956250000000000))*(sj1));
IkReal x191=((IkReal(1.00000000000000))*(sj1));
IkReal x192=((cj0)*(pz));
IkReal x193=((IkReal(0.150000000000000))*(cj1));
IkReal x194=((IkReal(2.00000000000000))*(sj1));
IkReal x195=((IkReal(2.00000000000000))*(cj1));
IkReal x196=((IkReal(2.00000000000000))*(r00));
IkReal x197=((IkReal(0.300000000000000))*(sj1));
IkReal x198=((r02)*(x178));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j4)), IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(sj0)*(x188)))+(((cj0)*(py))));
evalcond[2]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(r00)*(sj0)))+(((cj0)*(r01))));
evalcond[3]=((x171)+(((IkReal(-1.00000000000000))*(x177)*(x184)))+(((IkReal(-1.00000000000000))*(x176)*(x177))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x176)*(x191)))+(((IkReal(-1.00000000000000))*(r02)*(x177)))+(((IkReal(-1.00000000000000))*(x184)*(x191))));
evalcond[5]=((((x184)*(x197)))+(((IkReal(-1.00000000000000))*(r02)*(x181)))+(((IkReal(-1.00000000000000))*(r00)*(x188)))+(((IkReal(0.0750000000000000))*(x184)))+(((r02)*(x189)))+(((x176)*(x197)))+(((IkReal(-1.00000000000000))*(x179)))+(((IkReal(0.0750000000000000))*(x176))));
evalcond[6]=((((IkReal(-1.00000000000000))*(x181)*(x184)))+(((x184)*(x189)))+(((IkReal(-0.300000000000000))*(x171)))+(((IkReal(-1.00000000000000))*(x176)*(x181)))+(x198)+(((r02)*(x175)))+(((IkReal(-0.0750000000000000))*(r02)))+(((x176)*(x189))));
evalcond[7]=((((IkReal(2.00000000000000))*(x172)*(x179)))+(((IkReal(-1.00000000000000))*(pp)*(r02)*(x177)))+(((r02)*(x185)))+(((x178)*(x182)*(x196)))+(((x171)*(x178)*(x186)))+(((IkReal(-1.00000000000000))*(x173)*(x182)))+(((IkReal(-0.600000000000000))*(x179)))+(((IkReal(-0.150000000000000))*(x172)*(x176)))+(((IkReal(-1.00000000000000))*(pp)*(x184)*(x191)))+(((x168)*(x176)*(x194)))+(((x176)*(x190)))+(((IkReal(-1.00000000000000))*(pz)*(x174)))+(((x193)*(x198)))+(((x175)*(x179)*(x194)))+(((IkReal(-1.00000000000000))*(px)*(x183)))+(((x184)*(x190)))+(((r02)*(x170)*(x195)))+(((x171)*(x175)*(x186)))+(((px)*(x172)*(x196)))+(((IkReal(0.0450000000000000))*(x184)))+(((IkReal(-1.00000000000000))*(pp)*(x176)*(x191)))+(((IkReal(-1.00000000000000))*(cj0)*(x172)*(x173)))+(((IkReal(-1.00000000000000))*(x179)*(x180)))+(((IkReal(-0.150000000000000))*(pz)*(x171)))+(((x169)*(x184)*(x194)))+(((r02)*(x175)*(x193)))+(((IkReal(0.0450000000000000))*(x176))));
evalcond[8]=((((IkReal(0.0956250000000000))*(x171)))+(((IkReal(0.600000000000000))*(pz)*(x176)))+(((x168)*(x176)*(x195)))+(((IkReal(0.0450000000000000))*(r02)))+(((IkReal(-0.150000000000000))*(x171)*(x178)))+(((IkReal(-1.00000000000000))*(r00)*(x182)*(x186)))+(((IkReal(-1.00000000000000))*(x174)*(x178)))+(((x169)*(x184)*(x195)))+(((IkReal(-0.150000000000000))*(r02)*(x172)))+(((IkReal(-1.00000000000000))*(pp)*(x177)*(x184)))+(((IkReal(2.00000000000000))*(r02)*(x172)*(x175)))+(((IkReal(-1.00000000000000))*(x174)*(x175)))+(((IkReal(-1.00000000000000))*(pp)*(x176)*(x177)))+(((x183)*(x192)))+(((IkReal(-1.00000000000000))*(x176)*(x185)))+(((pp)*(x171)))+(((IkReal(-2.00000000000000))*(x170)*(x171)))+(((IkReal(-1.00000000000000))*(x184)*(x185)))+(((IkReal(-1.00000000000000))*(x173)*(x187)))+(((sj1)*(x173)*(x192)))+(((IkReal(-0.150000000000000))*(x171)*(x175)))+(((x175)*(x179)*(x195)))+(((IkReal(-1.00000000000000))*(sj1)*(x179)*(x186)))+(((IkReal(2.00000000000000))*(x172)*(x198)))+(((x178)*(x187)*(x196)))+(((pz)*(x176)*(x180)))+(((IkReal(-1.00000000000000))*(x179)*(x193))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal j3array[2], cj3array[2], sj3array[2];
bool j3valid[2]={false};
_nj3 = 2;
IkReal x199=((IkReal(11.4095661394664))*(sj1));
IkReal x200=((cj0)*(px));
IkReal x201=((py)*(sj0));
if( (((IkReal(0.357499739036614))+(((IkReal(-19.0159435657774))*(pp)))+(((x199)*(x201)))+(((IkReal(2.85239153486660))*(x200)))+(((x199)*(x200)))+(((IkReal(2.85239153486660))*(x201)))+(((IkReal(11.4095661394664))*(cj1)*(pz)))+(((IkReal(-0.855717460459981))*(sj1))))) < -1-IKFAST_SINCOS_THRESH || (((IkReal(0.357499739036614))+(((IkReal(-19.0159435657774))*(pp)))+(((x199)*(x201)))+(((IkReal(2.85239153486660))*(x200)))+(((x199)*(x200)))+(((IkReal(2.85239153486660))*(x201)))+(((IkReal(11.4095661394664))*(cj1)*(pz)))+(((IkReal(-0.855717460459981))*(sj1))))) > 1+IKFAST_SINCOS_THRESH )
    continue;
IkReal x202=IKasin(((IkReal(0.357499739036614))+(((IkReal(-19.0159435657774))*(pp)))+(((x199)*(x201)))+(((IkReal(2.85239153486660))*(x200)))+(((x199)*(x200)))+(((IkReal(2.85239153486660))*(x201)))+(((IkReal(11.4095661394664))*(cj1)*(pz)))+(((IkReal(-0.855717460459981))*(sj1)))));
j3array[0]=((IkReal(-1.34057673951805))+(((IkReal(-1.00000000000000))*(x202))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
j3array[1]=((IkReal(1.80101591407174))+(x202));
sj3array[1]=IKsin(j3array[1]);
cj3array[1]=IKcos(j3array[1]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
if( j3array[1] > IKPI )
{
    j3array[1]-=IK2PI;
}
else if( j3array[1] < -IKPI )
{    j3array[1]+=IK2PI;
}
j3valid[1] = true;
for(int ij3 = 0; ij3 < 2; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 2; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[1];
IkReal x203=((IkReal(2.00000000000000))*(sj0));
IkReal x204=((px)*(py));
IkReal x205=((r00)*(sj0));
IkReal x206=((cj0)*(r01));
IkReal x207=((py)*(r00));
IkReal x208=((IkReal(2.00000000000000))*(cj0));
IkReal x209=((px)*(r01));
IkReal x210=((IkReal(0.600000000000000))*(cj1));
IkReal x211=((py)*(r02));
IkReal x212=((IkReal(0.600000000000000))*(sj1));
IkReal x213=((IkReal(0.0450000000000000))*(sj1));
IkReal x214=((px)*(r02));
evalcond[0]=((IkReal(0.114425000000000))+(((IkReal(0.0956250000000000))*(x206)))+(((IkReal(0.150000000000000))*(x207)))+(((IkReal(-0.0956250000000000))*(x205)))+(((IkReal(-1.00000000000000))*(pz)*(x208)*(x211)))+(((IkReal(-1.00000000000000))*(x205)*(x213)))+(((pz)*(x203)*(x214)))+(((r00)*(x203)*((px)*(px))))+(((IkReal(-0.150000000000000))*(x209)))+(((IkReal(-1.00000000000000))*(x209)*(x212)))+(((pp)*(x206)))+(((IkReal(-1.00000000000000))*(r00)*(x204)*(x208)))+(((cj0)*(x210)*(x211)))+(((IkReal(-1.00000000000000))*(pz)*(x206)*(x210)))+(((IkReal(0.0512000000000000))*(IKcos(j3))))+(((IkReal(-1.00000000000000))*(sj0)*(x210)*(x214)))+(((r01)*(x203)*(x204)))+(((IkReal(-1.00000000000000))*(pp)*(x205)))+(((x206)*(x213)))+(((IkReal(0.0120000000000000))*(IKsin(j3))))+(((pz)*(x205)*(x210)))+(((IkReal(-2.00000000000000))*(x206)*((py)*(py))))+(((x207)*(x212))));
if( IKabs(evalcond[0]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst10;
gconst10=IKsign(((IkReal(0.108025000000000))+(((IkReal(0.0512000000000000))*(cj3)))+(((IkReal(0.00640000000000000))*((sj3)*(sj3))))+(((IkReal(0.00640000000000000))*((cj3)*(cj3))))+(((IkReal(0.0120000000000000))*(sj3)))));
dummyeval[0]=((IkReal(16.8789062500000))+((cj3)*(cj3))+(((IkReal(1.87500000000000))*(sj3)))+((sj3)*(sj3))+(((IkReal(8.00000000000000))*(cj3))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst11;
gconst11=IKsign(((IkReal(-0.108025000000000))+(((IkReal(-0.0512000000000000))*(cj3)))+(((IkReal(-0.00640000000000000))*((sj3)*(sj3))))+(((IkReal(-0.0120000000000000))*(sj3)))+(((IkReal(-0.00640000000000000))*((cj3)*(cj3))))));
dummyeval[0]=((IkReal(-16.8789062500000))+(((IkReal(-1.87500000000000))*(sj3)))+(((IkReal(-1.00000000000000))*((cj3)*(cj3))))+(((IkReal(-8.00000000000000))*(cj3)))+(((IkReal(-1.00000000000000))*((sj3)*(sj3)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x215=((r02)*(sj0));
IkReal x216=((IkReal(0.0800000000000000))*(sj1));
IkReal x217=((cj3)*(px));
IkReal x218=((cj0)*(r01));
IkReal x219=((IkReal(0.0240000000000000))*(cj1));
IkReal x220=((pz)*(sj3));
IkReal x221=((IkReal(0.00600000000000000))*(cj1));
IkReal x222=((IkReal(0.0750000000000000))*(sj1));
IkReal x223=((py)*(sj0));
IkReal x224=((IkReal(0.00562500000000000))*(cj1));
IkReal x225=((r00)*(sj0));
IkReal x226=((cj3)*(pz));
IkReal x227=((IkReal(0.320000000000000))*(sj1));
IkReal x228=((IkReal(0.0800000000000000))*(cj1));
IkReal x229=((IkReal(0.0750000000000000))*(cj1));
IkReal x230=((py)*(r00));
IkReal x231=((IkReal(0.320000000000000))*(cj1));
IkReal x232=((cj0)*(px));
IkReal x233=((IkReal(0.00600000000000000))*(sj1));
IkReal x234=((cj1)*(px)*(r01));
IkReal x235=((cj0)*(py)*(r02));
IkReal x236=((px)*(sj3)*(x216));
if( IKabs(((gconst11)*(((IkReal(0.0960000000000000))+(((IkReal(-1.00000000000000))*(pz)*(x222)*(x225)))+(((IkReal(-1.00000000000000))*(pz)*(x231)))+(((pz)*(x218)*(x222)))+(((IkReal(-1.00000000000000))*(x223)*(x227)))+(((x215)*(x236)))+(((cj3)*(x233)))+(((x216)*(x218)*(x220)))+(((IkReal(-1.00000000000000))*(sj3)*(x221)*(x225)))+(((px)*(x215)*(x222)))+(((sj3)*(x228)*(x230)))+(((x229)*(x230)))+(((IkReal(-1.00000000000000))*(x216)*(x220)*(x225)))+(((IkReal(-1.00000000000000))*(cj3)*(x216)*(x223)))+(((IkReal(-1.00000000000000))*(x227)*(x232)))+(((sj3)*(x218)*(x221)))+(((IkReal(0.0240000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(px)*(r01)*(sj3)*(x228)))+(((IkReal(-1.00000000000000))*(x226)*(x228)))+(((IkReal(-1.00000000000000))*(x222)*(x235)))+(((IkReal(-1.00000000000000))*(sj3)*(x216)*(x235)))+(((IkReal(-1.00000000000000))*(cj0)*(x216)*(x217)))+(((IkReal(-1.00000000000000))*(px)*(r01)*(x229)))+(((IkReal(-1.00000000000000))*(x224)*(x225)))+(((IkReal(0.0240000000000000))*(cj3)))+(((x218)*(x224))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst11)*(((IkReal(0.0225000000000000))+(((IkReal(-1.00000000000000))*(pz)*(x218)*(x227)))+(((x216)*(x225)*(x226)))+(((IkReal(-1.00000000000000))*(x222)*(x232)))+(((IkReal(0.00562500000000000))*(sj1)))+(((cj3)*(x221)*(x225)))+(((IkReal(-1.00000000000000))*(x222)*(x223)))+(((IkReal(-1.00000000000000))*(cj3)*(x218)*(x221)))+(((x219)*(x225)))+(((r01)*(x217)*(x228)))+(((sj3)*(x233)))+(((IkReal(-1.00000000000000))*(x218)*(x219)))+(((IkReal(-1.00000000000000))*(x230)*(x231)))+(((IkReal(-1.00000000000000))*(sj3)*(x216)*(x232)))+(((IkReal(-1.00000000000000))*(x215)*(x216)*(x217)))+(((px)*(r01)*(x231)))+(((IkReal(-1.00000000000000))*(x220)*(x228)))+(((IkReal(-1.00000000000000))*(sj3)*(x216)*(x223)))+(((x227)*(x235)))+(((IkReal(-1.00000000000000))*(pz)*(x229)))+(((IkReal(-1.00000000000000))*(x216)*(x218)*(x226)))+(((IkReal(-1.00000000000000))*(cj3)*(x228)*(x230)))+(((cj3)*(x216)*(x235)))+(((IkReal(-1.00000000000000))*(px)*(x215)*(x227)))+(((IkReal(0.0240000000000000))*(sj3)))+(((pz)*(x225)*(x227))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst11)*(((IkReal(0.0960000000000000))+(((IkReal(-1.00000000000000))*(pz)*(x222)*(x225)))+(((IkReal(-1.00000000000000))*(pz)*(x231)))+(((pz)*(x218)*(x222)))+(((IkReal(-1.00000000000000))*(x223)*(x227)))+(((x215)*(x236)))+(((cj3)*(x233)))+(((x216)*(x218)*(x220)))+(((IkReal(-1.00000000000000))*(sj3)*(x221)*(x225)))+(((px)*(x215)*(x222)))+(((sj3)*(x228)*(x230)))+(((x229)*(x230)))+(((IkReal(-1.00000000000000))*(x216)*(x220)*(x225)))+(((IkReal(-1.00000000000000))*(cj3)*(x216)*(x223)))+(((IkReal(-1.00000000000000))*(x227)*(x232)))+(((sj3)*(x218)*(x221)))+(((IkReal(0.0240000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(px)*(r01)*(sj3)*(x228)))+(((IkReal(-1.00000000000000))*(x226)*(x228)))+(((IkReal(-1.00000000000000))*(x222)*(x235)))+(((IkReal(-1.00000000000000))*(sj3)*(x216)*(x235)))+(((IkReal(-1.00000000000000))*(cj0)*(x216)*(x217)))+(((IkReal(-1.00000000000000))*(px)*(r01)*(x229)))+(((IkReal(-1.00000000000000))*(x224)*(x225)))+(((IkReal(0.0240000000000000))*(cj3)))+(((x218)*(x224)))))), ((gconst11)*(((IkReal(0.0225000000000000))+(((IkReal(-1.00000000000000))*(pz)*(x218)*(x227)))+(((x216)*(x225)*(x226)))+(((IkReal(-1.00000000000000))*(x222)*(x232)))+(((IkReal(0.00562500000000000))*(sj1)))+(((cj3)*(x221)*(x225)))+(((IkReal(-1.00000000000000))*(x222)*(x223)))+(((IkReal(-1.00000000000000))*(cj3)*(x218)*(x221)))+(((x219)*(x225)))+(((r01)*(x217)*(x228)))+(((sj3)*(x233)))+(((IkReal(-1.00000000000000))*(x218)*(x219)))+(((IkReal(-1.00000000000000))*(x230)*(x231)))+(((IkReal(-1.00000000000000))*(sj3)*(x216)*(x232)))+(((IkReal(-1.00000000000000))*(x215)*(x216)*(x217)))+(((px)*(r01)*(x231)))+(((IkReal(-1.00000000000000))*(x220)*(x228)))+(((IkReal(-1.00000000000000))*(sj3)*(x216)*(x223)))+(((x227)*(x235)))+(((IkReal(-1.00000000000000))*(pz)*(x229)))+(((IkReal(-1.00000000000000))*(x216)*(x218)*(x226)))+(((IkReal(-1.00000000000000))*(cj3)*(x228)*(x230)))+(((cj3)*(x216)*(x235)))+(((IkReal(-1.00000000000000))*(px)*(x215)*(x227)))+(((IkReal(0.0240000000000000))*(sj3)))+(((pz)*(x225)*(x227)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x237=IKcos(j2);
IkReal x238=IKsin(j2);
IkReal x239=((IkReal(0.0800000000000000))*(sj3));
IkReal x240=((cj0)*(r01));
IkReal x241=((IkReal(1.00000000000000))*(px));
IkReal x242=((py)*(sj1));
IkReal x243=((cj0)*(r02));
IkReal x244=((IkReal(0.0750000000000000))*(cj1));
IkReal x245=((r02)*(sj0));
IkReal x246=((IkReal(0.0750000000000000))*(sj1));
IkReal x247=((cj1)*(pz));
IkReal x248=((r00)*(sj0));
IkReal x249=((IkReal(0.0800000000000000))*(cj3));
IkReal x250=((pz)*(sj1));
IkReal x251=((IkReal(1.00000000000000))*(sj0));
IkReal x252=((cj1)*(py));
IkReal x253=((IkReal(0.320000000000000))*(x237));
IkReal x254=((IkReal(0.0750000000000000))*(x238));
IkReal x255=((IkReal(0.320000000000000))*(x238));
IkReal x256=((IkReal(0.0750000000000000))*(x237));
IkReal x257=((sj1)*(x248));
IkReal x258=((x237)*(x249));
IkReal x259=((x238)*(x239));
IkReal x260=((x237)*(x239));
IkReal x261=((x238)*(x249));
IkReal x262=((x259)+(x254));
IkReal x263=((x258)+(x253));
IkReal x264=((x255)+(x256)+(x261)+(x260));
evalcond[0]=((x250)+(((IkReal(-1.00000000000000))*(x251)*(x252)))+(x244)+(((IkReal(-1.00000000000000))*(x262)))+(((IkReal(-1.00000000000000))*(cj0)*(cj1)*(x241)))+(x263));
evalcond[1]=((IkReal(0.300000000000000))+(((IkReal(-1.00000000000000))*(x247)))+(((IkReal(-1.00000000000000))*(cj0)*(sj1)*(x241)))+(((IkReal(-1.00000000000000))*(x242)*(x251)))+(x246)+(x264));
evalcond[2]=((((x244)*(x248)))+(((IkReal(-1.00000000000000))*(x240)*(x244)))+(((IkReal(-1.00000000000000))*(x240)*(x250)))+(((IkReal(-1.00000000000000))*(r00)*(x252)))+(((cj1)*(px)*(r01)))+(((IkReal(-1.00000000000000))*(sj1)*(x241)*(x245)))+(((x248)*(x250)))+(((x242)*(x243)))+(((IkReal(-1.00000000000000))*(x262)))+(x263));
evalcond[3]=((((IkReal(-1.00000000000000))*(x240)*(x247)))+(((x247)*(x248)))+(((IkReal(-1.00000000000000))*(cj1)*(x241)*(x245)))+(((x243)*(x252)))+(((r00)*(x242)))+(((IkReal(-1.00000000000000))*(x264)))+(((IkReal(-0.300000000000000))*(x248)))+(((IkReal(-1.00000000000000))*(r01)*(sj1)*(x241)))+(((IkReal(0.300000000000000))*(x240)))+(((x240)*(x246)))+(((IkReal(-1.00000000000000))*(x246)*(x248))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x265=((IkReal(0.0800000000000000))*(cj1));
IkReal x266=((cj0)*(px));
IkReal x267=((py)*(sj0));
IkReal x268=((IkReal(0.320000000000000))*(sj1));
IkReal x269=((IkReal(0.00600000000000000))*(cj3));
IkReal x270=((pz)*(sj3));
IkReal x271=((IkReal(0.0750000000000000))*(cj1));
IkReal x272=((IkReal(0.0800000000000000))*(sj1));
IkReal x273=((IkReal(0.0750000000000000))*(sj1));
IkReal x274=((IkReal(0.00600000000000000))*(sj3));
IkReal x275=((cj3)*(pz));
IkReal x276=((IkReal(0.320000000000000))*(cj1));
if( IKabs(((gconst10)*(((IkReal(-0.0960000000000000))+(((cj3)*(x266)*(x272)))+(((cj3)*(x267)*(x272)))+(((x266)*(x268)))+(((IkReal(-1.00000000000000))*(sj3)*(x265)*(x266)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((IkReal(-1.00000000000000))*(sj3)*(x265)*(x267)))+(((x270)*(x272)))+(((IkReal(-0.0240000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(x267)*(x271)))+(((pz)*(x273)))+(((IkReal(-1.00000000000000))*(x266)*(x271)))+(((pz)*(x276)))+(((IkReal(0.00562500000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(sj1)*(x269)))+(((x265)*(x275)))+(((x267)*(x268)))+(((cj1)*(x274))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst10)*(((IkReal(-0.0225000000000000))+(((sj3)*(x266)*(x272)))+(((IkReal(-0.0240000000000000))*(sj3)))+(((x267)*(x273)))+(((x267)*(x276)))+(((x266)*(x276)))+(((IkReal(-1.00000000000000))*(pz)*(x268)))+(((x266)*(x273)))+(((x265)*(x270)))+(((IkReal(-1.00000000000000))*(sj1)*(x274)))+(((cj3)*(x265)*(x267)))+(((sj3)*(x267)*(x272)))+(((IkReal(-0.0240000000000000))*(cj1)))+(((cj3)*(x265)*(x266)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(x272)*(x275)))+(((IkReal(-1.00000000000000))*(cj1)*(x269)))+(((pz)*(x271))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst10)*(((IkReal(-0.0960000000000000))+(((cj3)*(x266)*(x272)))+(((cj3)*(x267)*(x272)))+(((x266)*(x268)))+(((IkReal(-1.00000000000000))*(sj3)*(x265)*(x266)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((IkReal(-1.00000000000000))*(sj3)*(x265)*(x267)))+(((x270)*(x272)))+(((IkReal(-0.0240000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(x267)*(x271)))+(((pz)*(x273)))+(((IkReal(-1.00000000000000))*(x266)*(x271)))+(((pz)*(x276)))+(((IkReal(0.00562500000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(sj1)*(x269)))+(((x265)*(x275)))+(((x267)*(x268)))+(((cj1)*(x274)))))), ((gconst10)*(((IkReal(-0.0225000000000000))+(((sj3)*(x266)*(x272)))+(((IkReal(-0.0240000000000000))*(sj3)))+(((x267)*(x273)))+(((x267)*(x276)))+(((x266)*(x276)))+(((IkReal(-1.00000000000000))*(pz)*(x268)))+(((x266)*(x273)))+(((x265)*(x270)))+(((IkReal(-1.00000000000000))*(sj1)*(x274)))+(((cj3)*(x265)*(x267)))+(((sj3)*(x267)*(x272)))+(((IkReal(-0.0240000000000000))*(cj1)))+(((cj3)*(x265)*(x266)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(x272)*(x275)))+(((IkReal(-1.00000000000000))*(cj1)*(x269)))+(((pz)*(x271)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x277=IKcos(j2);
IkReal x278=IKsin(j2);
IkReal x279=((IkReal(0.0800000000000000))*(sj3));
IkReal x280=((cj0)*(r01));
IkReal x281=((IkReal(1.00000000000000))*(px));
IkReal x282=((py)*(sj1));
IkReal x283=((cj0)*(r02));
IkReal x284=((IkReal(0.0750000000000000))*(cj1));
IkReal x285=((r02)*(sj0));
IkReal x286=((IkReal(0.0750000000000000))*(sj1));
IkReal x287=((cj1)*(pz));
IkReal x288=((r00)*(sj0));
IkReal x289=((IkReal(0.0800000000000000))*(cj3));
IkReal x290=((pz)*(sj1));
IkReal x291=((IkReal(1.00000000000000))*(sj0));
IkReal x292=((cj1)*(py));
IkReal x293=((IkReal(0.320000000000000))*(x277));
IkReal x294=((IkReal(0.0750000000000000))*(x278));
IkReal x295=((IkReal(0.320000000000000))*(x278));
IkReal x296=((IkReal(0.0750000000000000))*(x277));
IkReal x297=((sj1)*(x288));
IkReal x298=((x277)*(x289));
IkReal x299=((x278)*(x279));
IkReal x300=((x277)*(x279));
IkReal x301=((x278)*(x289));
IkReal x302=((x299)+(x294));
IkReal x303=((x298)+(x293));
IkReal x304=((x300)+(x301)+(x295)+(x296));
evalcond[0]=((((IkReal(-1.00000000000000))*(x302)))+(x284)+(x303)+(((IkReal(-1.00000000000000))*(x291)*(x292)))+(x290)+(((IkReal(-1.00000000000000))*(cj0)*(cj1)*(x281))));
evalcond[1]=((IkReal(0.300000000000000))+(((IkReal(-1.00000000000000))*(x282)*(x291)))+(x286)+(x304)+(((IkReal(-1.00000000000000))*(cj0)*(sj1)*(x281)))+(((IkReal(-1.00000000000000))*(x287))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x302)))+(((x288)*(x290)))+(x303)+(((x282)*(x283)))+(((IkReal(-1.00000000000000))*(sj1)*(x281)*(x285)))+(((IkReal(-1.00000000000000))*(x280)*(x284)))+(((cj1)*(px)*(r01)))+(((IkReal(-1.00000000000000))*(x280)*(x290)))+(((x284)*(x288)))+(((IkReal(-1.00000000000000))*(r00)*(x292))));
evalcond[3]=((((x280)*(x286)))+(((IkReal(-1.00000000000000))*(x280)*(x287)))+(((IkReal(-1.00000000000000))*(x286)*(x288)))+(((IkReal(-1.00000000000000))*(x304)))+(((IkReal(0.300000000000000))*(x280)))+(((x283)*(x292)))+(((r00)*(x282)))+(((IkReal(-1.00000000000000))*(cj1)*(x281)*(x285)))+(((x287)*(x288)))+(((IkReal(-0.300000000000000))*(x288)))+(((IkReal(-1.00000000000000))*(r01)*(sj1)*(x281))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x305=((r01)*(sj0));
IkReal x306=((cj0)*(r00));
IkReal x307=((IkReal(12800.0000000000))*(pz));
IkReal x308=((IkReal(900.000000000000))*(cj1));
IkReal x309=((IkReal(3000.00000000000))*(pz));
IkReal x310=((IkReal(3840.00000000000))*(sj1));
IkReal x311=((IkReal(900.000000000000))*(sj1));
IkReal x312=((px)*(r00));
IkReal x313=((IkReal(3840.00000000000))*(cj1));
IkReal x314=((py)*(r01));
IkReal x315=((py)*(r02)*(sj0));
IkReal x316=((cj0)*(px)*(r02));
if( IKabs(((gconst1)*(((((IkReal(-1.00000000000000))*(r02)*(x307)))+(((x306)*(x310)))+(((IkReal(-1.00000000000000))*(r02)*(x311)))+(((x305)*(x310)))+(((IkReal(-1.00000000000000))*(x305)*(x309)))+(((IkReal(3000.00000000000))*(x315)))+(((IkReal(-12800.0000000000))*(x314)))+(((x305)*(x308)))+(((IkReal(3000.00000000000))*(x316)))+(((IkReal(-12800.0000000000))*(x312)))+(((IkReal(960.000000000000))*(x306)))+(((IkReal(-225.000000000000))*(r02)))+(((r02)*(x313)))+(((x306)*(x308)))+(((IkReal(960.000000000000))*(x305)))+(((IkReal(-1.00000000000000))*(x306)*(x309)))+(((IkReal(-240.000000000000))*(cj4))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst1)*(((((IkReal(-1.00000000000000))*(x306)*(x307)))+(((IkReal(-1.00000000000000))*(x305)*(x307)))+(((IkReal(-960.000000000000))*(r02)))+(((IkReal(3000.00000000000))*(x314)))+(((x305)*(x313)))+(((IkReal(-225.000000000000))*(x306)))+(((IkReal(-1.00000000000000))*(r02)*(x308)))+(((IkReal(3000.00000000000))*(x312)))+(((IkReal(-225.000000000000))*(x305)))+(((IkReal(12800.0000000000))*(x316)))+(((r02)*(x309)))+(((IkReal(12800.0000000000))*(x315)))+(((IkReal(-1.00000000000000))*(r02)*(x310)))+(((IkReal(-1024.00000000000))*(cj4)))+(((IkReal(-1.00000000000000))*(x305)*(x311)))+(((IkReal(-1.00000000000000))*(x306)*(x311)))+(((x306)*(x313))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst1)*(((((IkReal(-1.00000000000000))*(r02)*(x307)))+(((x306)*(x310)))+(((IkReal(-1.00000000000000))*(r02)*(x311)))+(((x305)*(x310)))+(((IkReal(-1.00000000000000))*(x305)*(x309)))+(((IkReal(3000.00000000000))*(x315)))+(((IkReal(-12800.0000000000))*(x314)))+(((x305)*(x308)))+(((IkReal(3000.00000000000))*(x316)))+(((IkReal(-12800.0000000000))*(x312)))+(((IkReal(960.000000000000))*(x306)))+(((IkReal(-225.000000000000))*(r02)))+(((r02)*(x313)))+(((x306)*(x308)))+(((IkReal(960.000000000000))*(x305)))+(((IkReal(-1.00000000000000))*(x306)*(x309)))+(((IkReal(-240.000000000000))*(cj4)))))), ((gconst1)*(((((IkReal(-1.00000000000000))*(x306)*(x307)))+(((IkReal(-1.00000000000000))*(x305)*(x307)))+(((IkReal(-960.000000000000))*(r02)))+(((IkReal(3000.00000000000))*(x314)))+(((x305)*(x313)))+(((IkReal(-225.000000000000))*(x306)))+(((IkReal(-1.00000000000000))*(r02)*(x308)))+(((IkReal(3000.00000000000))*(x312)))+(((IkReal(-225.000000000000))*(x305)))+(((IkReal(12800.0000000000))*(x316)))+(((r02)*(x309)))+(((IkReal(12800.0000000000))*(x315)))+(((IkReal(-1.00000000000000))*(r02)*(x310)))+(((IkReal(-1024.00000000000))*(cj4)))+(((IkReal(-1.00000000000000))*(x305)*(x311)))+(((IkReal(-1.00000000000000))*(x306)*(x311)))+(((x306)*(x313)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x317=IKcos(j3);
IkReal x318=IKsin(j3);
IkReal x319=((r01)*(sj0));
IkReal x320=((IkReal(0.300000000000000))*(r02));
IkReal x321=((r00)*(sj0));
IkReal x322=((py)*(sj0));
IkReal x323=((IkReal(0.600000000000000))*(cj1));
IkReal x324=((IkReal(0.150000000000000))*(px));
IkReal x325=((IkReal(0.320000000000000))*(cj4));
IkReal x326=((IkReal(1.00000000000000))*(pz));
IkReal x327=((py)*(r00));
IkReal x328=((IkReal(0.300000000000000))*(cj1));
IkReal x329=((IkReal(1.00000000000000))*(pp));
IkReal x330=((cj0)*(r00));
IkReal x331=((IkReal(0.0450000000000000))*(sj1));
IkReal x332=((IkReal(0.600000000000000))*(sj1));
IkReal x333=((IkReal(0.0750000000000000))*(cj4));
IkReal x334=((cj0)*(r01));
IkReal x335=((IkReal(2.00000000000000))*(pz));
IkReal x336=((cj0)*(px));
IkReal x337=((IkReal(0.300000000000000))*(sj1));
IkReal x338=((IkReal(2.00000000000000))*(px)*(py));
IkReal x339=((IkReal(0.0120000000000000))*(x318));
IkReal x340=((IkReal(0.0512000000000000))*(x317));
IkReal x341=((cj0)*(py)*(r02));
IkReal x342=((px)*(r02)*(sj0));
evalcond[0]=((IkReal(0.0188000000000000))+(((IkReal(-1.00000000000000))*(x329)))+(((pz)*(x323)))+(((cj0)*(x324)))+(((IkReal(0.150000000000000))*(x322)))+(((IkReal(-1.00000000000000))*(x331)))+(x339)+(((x332)*(x336)))+(x340)+(((x322)*(x332))));
evalcond[1]=((((IkReal(-1.00000000000000))*(py)*(r01)))+(((IkReal(-1.00000000000000))*(r02)*(x326)))+(((IkReal(0.0750000000000000))*(x319)))+(((cj1)*(x320)))+(((IkReal(-1.00000000000000))*(px)*(r00)))+(((x330)*(x337)))+(((IkReal(0.0750000000000000))*(x330)))+(((IkReal(-1.00000000000000))*(x318)*(x325)))+(((x317)*(x333)))+(((x319)*(x337))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x318)*(x333)))+(((x319)*(x328)))+(((IkReal(-0.0800000000000000))*(cj4)))+(((IkReal(-1.00000000000000))*(sj1)*(x320)))+(((IkReal(-1.00000000000000))*(x326)*(x330)))+(((r02)*(x322)))+(((IkReal(-0.0750000000000000))*(r02)))+(((r02)*(x336)))+(((IkReal(-1.00000000000000))*(x319)*(x326)))+(((x328)*(x330)))+(((IkReal(-1.00000000000000))*(x317)*(x325))));
evalcond[3]=((((IkReal(0.150000000000000))*(x327)))+(((x335)*(x342)))+(((IkReal(2.00000000000000))*(x321)*((px)*(px))))+(((IkReal(-2.00000000000000))*(x334)*((py)*(py))))+(((pp)*(x334)))+(((IkReal(-1.00000000000000))*(sj4)*(x340)))+(((IkReal(-0.0956250000000000))*(x321)))+(((IkReal(-1.00000000000000))*(x321)*(x329)))+(((IkReal(-1.00000000000000))*(x321)*(x331)))+(((pz)*(x321)*(x323)))+(((x323)*(x341)))+(((x331)*(x334)))+(((IkReal(-1.00000000000000))*(px)*(r01)*(x332)))+(((x327)*(x332)))+(((IkReal(0.0956250000000000))*(x334)))+(((IkReal(-0.114425000000000))*(sj4)))+(((IkReal(-1.00000000000000))*(pz)*(x323)*(x334)))+(((IkReal(-1.00000000000000))*(x335)*(x341)))+(((IkReal(-1.00000000000000))*(sj4)*(x339)))+(((IkReal(-1.00000000000000))*(x323)*(x342)))+(((IkReal(-2.00000000000000))*(x327)*(x336)))+(((IkReal(-1.00000000000000))*(r01)*(x324)))+(((x319)*(x338))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst2;
gconst2=IKsign(((((cj4)*((cj3)*(cj3))))+(((cj4)*((sj3)*(sj3))))));
dummyeval[0]=((((cj4)*((cj3)*(cj3))))+(((cj4)*((sj3)*(sj3)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst3;
IkReal x343=((IkReal(0.0800000000000000))*(cj4));
gconst3=IKsign(((((IkReal(0.320000000000000))*(cj3)*(cj4)))+(((IkReal(0.0750000000000000))*(cj4)*(sj3)))+(((x343)*((cj3)*(cj3))))+(((x343)*((sj3)*(sj3))))));
IkReal x344=((IkReal(1.06666666666667))*(cj4));
dummyeval[0]=((((IkReal(4.26666666666667))*(cj3)*(cj4)))+(((x344)*((sj3)*(sj3))))+(((x344)*((cj3)*(cj3))))+(((cj4)*(sj3))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[11];
IkReal x345=((IkReal(0.0512000000000000))*(cj3));
IkReal x346=((IkReal(0.0120000000000000))*(sj3));
IkReal x347=(py)*(py);
IkReal x348=(px)*(px);
IkReal x349=(pz)*(pz);
IkReal x350=((r01)*(sj0));
IkReal x351=((py)*(r00));
IkReal x352=((pz)*(sj1));
IkReal x353=((py)*(r01));
IkReal x354=((px)*(sj0));
IkReal x355=((IkReal(0.600000000000000))*(r02));
IkReal x356=((IkReal(0.150000000000000))*(cj1));
IkReal x357=((cj0)*(sj1));
IkReal x358=((IkReal(0.150000000000000))*(px));
IkReal x359=((IkReal(2.00000000000000))*(cj1));
IkReal x360=((cj0)*(r01));
IkReal x361=((r02)*(sj1));
IkReal x362=((px)*(r00));
IkReal x363=((IkReal(0.300000000000000))*(r00));
IkReal x364=((IkReal(1.00000000000000))*(pz));
IkReal x365=((r00)*(sj1));
IkReal x366=((cj0)*(r00));
IkReal x367=((cj0)*(cj1));
IkReal x368=((IkReal(1.00000000000000))*(sj1));
IkReal x369=((IkReal(0.0956250000000000))*(r00));
IkReal x370=((IkReal(0.600000000000000))*(pz));
IkReal x371=((IkReal(0.600000000000000))*(sj1));
IkReal x372=((IkReal(2.00000000000000))*(px));
IkReal x373=((IkReal(2.00000000000000))*(sj1));
IkReal x374=((IkReal(0.150000000000000))*(sj1));
IkReal x375=((cj1)*(r02));
IkReal x376=((cj0)*(px));
IkReal x377=((IkReal(0.0843750000000000))*(cj1));
IkReal x378=((py)*(sj0));
IkReal x379=((pz)*(r02));
IkReal x380=((IkReal(1.00000000000000))*(cj1));
IkReal x381=((cj0)*(py));
IkReal x382=((r00)*(sj0));
IkReal x383=((r02)*(x378));
IkReal x384=((pp)*(x380));
IkReal x385=((IkReal(1.00000000000000))*(pp)*(r00));
IkReal x386=((x346)+(x345));
IkReal x387=((IkReal(2.00000000000000))*(r00)*(x348));
IkReal x388=((cj0)*(x372)*(x379));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j4)), IkReal(6.28318530717959))));
evalcond[1]=((x381)+(((IkReal(-1.00000000000000))*(x354))));
evalcond[2]=((IkReal(-1.00000000000000))+(x360)+(((IkReal(-1.00000000000000))*(x382))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x366)*(x380)))+(x361)+(((IkReal(-1.00000000000000))*(x350)*(x380))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r00)*(x357)))+(((IkReal(-1.00000000000000))*(x375)))+(((IkReal(-1.00000000000000))*(x350)*(x368))));
evalcond[5]=((IkReal(0.0188000000000000))+(x386)+(((IkReal(0.600000000000000))*(px)*(x357)))+(((IkReal(0.150000000000000))*(x378)))+(((IkReal(-1.00000000000000))*(pp)))+(((x371)*(x378)))+(((cj0)*(x358)))+(((cj1)*(x370)))+(((IkReal(-0.0450000000000000))*(sj1))));
evalcond[6]=((((IkReal(0.300000000000000))*(x375)))+(((x357)*(x363)))+(((IkReal(0.0750000000000000))*(x350)))+(((IkReal(-1.00000000000000))*(r02)*(x364)))+(((IkReal(-1.00000000000000))*(x353)))+(((IkReal(0.300000000000000))*(sj1)*(x350)))+(((IkReal(0.0750000000000000))*(x366)))+(((IkReal(-1.00000000000000))*(x362))));
evalcond[7]=((((IkReal(-1.00000000000000))*(x350)*(x364)))+(x383)+(((x363)*(x367)))+(((IkReal(0.300000000000000))*(cj1)*(x350)))+(((r02)*(x376)))+(((IkReal(-0.300000000000000))*(x361)))+(((IkReal(-1.00000000000000))*(x364)*(x366)))+(((IkReal(-0.0750000000000000))*(r02))));
evalcond[8]=((IkReal(-0.114425000000000))+(((IkReal(-2.00000000000000))*(x379)*(x381)))+(((IkReal(-2.00000000000000))*(x347)*(x360)))+(((IkReal(-1.00000000000000))*(sj0)*(x369)))+(((x351)*(x371)))+(((IkReal(-1.00000000000000))*(x386)))+(((IkReal(-1.00000000000000))*(cj1)*(x354)*(x355)))+(((IkReal(0.150000000000000))*(x351)))+(((IkReal(-1.00000000000000))*(pp)*(x382)))+(((py)*(x350)*(x372)))+(((IkReal(-0.0450000000000000))*(sj0)*(x365)))+(((py)*(x355)*(x367)))+(((cj1)*(x370)*(x382)))+(((IkReal(-1.00000000000000))*(px)*(r01)*(x371)))+(((IkReal(-1.00000000000000))*(cj0)*(x351)*(x372)))+(((IkReal(-1.00000000000000))*(cj1)*(x360)*(x370)))+(((IkReal(0.0956250000000000))*(x360)))+(((IkReal(0.0450000000000000))*(r01)*(x357)))+(((IkReal(-1.00000000000000))*(r01)*(x358)))+(((IkReal(2.00000000000000))*(x354)*(x379)))+(((IkReal(2.00000000000000))*(x348)*(x382)))+(((pp)*(x360))));
evalcond[9]=((((IkReal(-1.00000000000000))*(x357)*(x385)))+(((x353)*(x357)*(x372)))+(((cj0)*(r02)*(x352)*(x372)))+(((x357)*(x387)))+(((r02)*(x356)*(x376)))+(((IkReal(-0.150000000000000))*(r02)*(x352)))+(((IkReal(-1.00000000000000))*(x358)*(x365)))+(((IkReal(0.0450000000000000))*(x350)))+(((x347)*(x350)*(x373)))+(((IkReal(-0.600000000000000))*(x362)))+(((IkReal(-1.00000000000000))*(pp)*(x375)))+(((x356)*(x383)))+(((pz)*(x353)*(x359)))+(((IkReal(0.0843750000000000))*(x375)))+(((IkReal(-1.00000000000000))*(pz)*(x350)*(x356)))+(((r02)*(x349)*(x359)))+(((IkReal(0.0956250000000000))*(sj1)*(x350)))+(((IkReal(2.00000000000000))*(x352)*(x383)))+(((IkReal(-1.00000000000000))*(pz)*(x356)*(x366)))+(((IkReal(-0.600000000000000))*(x353)))+(((IkReal(-1.00000000000000))*(x353)*(x374)))+(((x357)*(x369)))+(((x351)*(x354)*(x373)))+(((IkReal(-1.00000000000000))*(pz)*(x355)))+(((IkReal(-1.00000000000000))*(pp)*(x350)*(x368)))+(((IkReal(0.0450000000000000))*(x366)))+(((pz)*(x359)*(x362))));
evalcond[10]=((((IkReal(-1.00000000000000))*(x356)*(x379)))+(((IkReal(-1.00000000000000))*(x350)*(x384)))+(((x347)*(x350)*(x359)))+(((IkReal(-1.00000000000000))*(x366)*(x384)))+(((IkReal(0.150000000000000))*(x352)*(x366)))+(((x366)*(x370)))+(((IkReal(0.0450000000000000))*(r02)))+(((IkReal(-1.00000000000000))*(x355)*(x378)))+(((x353)*(x359)*(x376)))+(((IkReal(-1.00000000000000))*(x356)*(x362)))+(((IkReal(-2.00000000000000))*(x349)*(x361)))+(((x359)*(x378)*(x379)))+(((x359)*(x376)*(x379)))+(((x351)*(x354)*(x359)))+(((x348)*(x359)*(x366)))+(((IkReal(-1.00000000000000))*(x350)*(x377)))+(((IkReal(-2.00000000000000))*(x352)*(x362)))+(((IkReal(-1.00000000000000))*(x353)*(x356)))+(((pp)*(x361)))+(((IkReal(-1.00000000000000))*(r02)*(x357)*(x358)))+(((IkReal(0.0956250000000000))*(x361)))+(((IkReal(-1.00000000000000))*(x366)*(x377)))+(((IkReal(-0.150000000000000))*(x361)*(x378)))+(((x350)*(x370)))+(((IkReal(-2.00000000000000))*(x352)*(x353)))+(((IkReal(-1.00000000000000))*(x355)*(x376)))+(((IkReal(0.150000000000000))*(x350)*(x352))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  && IKabs(evalcond[9]) < 0.0000010000000000  && IKabs(evalcond[10]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst4;
gconst4=IKsign(((IkReal(0.108025000000000))+(((IkReal(0.0512000000000000))*(cj3)))+(((IkReal(0.00640000000000000))*((sj3)*(sj3))))+(((IkReal(0.00640000000000000))*((cj3)*(cj3))))+(((IkReal(0.0120000000000000))*(sj3)))));
dummyeval[0]=((IkReal(16.8789062500000))+((cj3)*(cj3))+(((IkReal(1.87500000000000))*(sj3)))+((sj3)*(sj3))+(((IkReal(8.00000000000000))*(cj3))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst5;
gconst5=IKsign(((IkReal(0.108025000000000))+(((IkReal(0.0512000000000000))*(cj3)))+(((IkReal(0.00640000000000000))*((sj3)*(sj3))))+(((IkReal(0.00640000000000000))*((cj3)*(cj3))))+(((IkReal(0.0120000000000000))*(sj3)))));
dummyeval[0]=((IkReal(16.8789062500000))+((cj3)*(cj3))+(((IkReal(1.87500000000000))*(sj3)))+((sj3)*(sj3))+(((IkReal(8.00000000000000))*(cj3))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x389=((r02)*(sj0));
IkReal x390=((IkReal(0.0800000000000000))*(sj1));
IkReal x391=((cj3)*(px));
IkReal x392=((cj0)*(r01));
IkReal x393=((IkReal(0.0240000000000000))*(cj1));
IkReal x394=((pz)*(sj3));
IkReal x395=((IkReal(0.00600000000000000))*(cj1));
IkReal x396=((IkReal(0.320000000000000))*(px));
IkReal x397=((cj0)*(sj1));
IkReal x398=((cj1)*(r01));
IkReal x399=((IkReal(0.0750000000000000))*(px));
IkReal x400=((IkReal(0.00562500000000000))*(cj1));
IkReal x401=((py)*(r02));
IkReal x402=((IkReal(0.0750000000000000))*(pz));
IkReal x403=((r00)*(sj0));
IkReal x404=((cj3)*(pz));
IkReal x405=((IkReal(0.320000000000000))*(py));
IkReal x406=((sj0)*(sj1));
IkReal x407=((IkReal(0.0800000000000000))*(cj1));
IkReal x408=((cj1)*(r00));
IkReal x409=((IkReal(0.0750000000000000))*(py));
IkReal x410=((cj3)*(py));
IkReal x411=((IkReal(0.00600000000000000))*(sj1));
IkReal x412=((py)*(sj3));
IkReal x413=((IkReal(0.320000000000000))*(pz)*(sj1));
IkReal x414=((px)*(sj3)*(x390));
if( IKabs(((gconst5)*(((IkReal(-0.0960000000000000))+(((x390)*(x392)*(x394)))+(((sj1)*(x392)*(x402)))+(((x392)*(x400)))+(((r00)*(x407)*(x412)))+(((x405)*(x406)))+(((IkReal(-1.00000000000000))*(x400)*(x403)))+(((cj0)*(x390)*(x391)))+(((IkReal(-0.0750000000000000))*(x397)*(x401)))+(((IkReal(-1.00000000000000))*(sj1)*(x402)*(x403)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((x404)*(x407)))+(((sj1)*(x389)*(x399)))+(((IkReal(-0.0240000000000000))*(sj1)))+(((x389)*(x414)))+(((x408)*(x409)))+(((IkReal(-1.00000000000000))*(x398)*(x399)))+(((IkReal(-0.0800000000000000))*(px)*(sj3)*(x398)))+(((sj0)*(x390)*(x410)))+(((IkReal(-1.00000000000000))*(sj3)*(x395)*(x403)))+(((IkReal(0.320000000000000))*(cj1)*(pz)))+(((IkReal(-1.00000000000000))*(x390)*(x394)*(x403)))+(((x396)*(x397)))+(((IkReal(-1.00000000000000))*(cj3)*(x411)))+(((sj3)*(x392)*(x395)))+(((IkReal(-1.00000000000000))*(cj0)*(sj3)*(x390)*(x401))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst5)*(((IkReal(-0.0225000000000000))+(((IkReal(-0.0240000000000000))*(sj3)))+(((IkReal(-1.00000000000000))*(x390)*(x392)*(x404)))+(((IkReal(-1.00000000000000))*(x392)*(x393)))+(((cj0)*(x414)))+(((x390)*(x403)*(x404)))+(((cj1)*(x402)))+(((x406)*(x409)))+(((IkReal(0.320000000000000))*(x397)*(x401)))+(((IkReal(-1.00000000000000))*(sj1)*(x389)*(x396)))+(((x396)*(x398)))+(((x397)*(x399)))+(((x394)*(x407)))+(((IkReal(-1.00000000000000))*(x392)*(x413)))+(((IkReal(-1.00000000000000))*(x389)*(x390)*(x391)))+(((IkReal(-1.00000000000000))*(sj3)*(x411)))+(((cj3)*(x395)*(x403)))+(((cj0)*(cj3)*(x390)*(x401)))+(((sj0)*(x390)*(x412)))+(((IkReal(-1.00000000000000))*(x405)*(x408)))+(((x393)*(x403)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((IkReal(0.0800000000000000))*(x391)*(x398)))+(((x403)*(x413)))+(((IkReal(-1.00000000000000))*(r00)*(x407)*(x410)))+(((IkReal(-1.00000000000000))*(cj3)*(x392)*(x395))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst5)*(((IkReal(-0.0960000000000000))+(((x390)*(x392)*(x394)))+(((sj1)*(x392)*(x402)))+(((x392)*(x400)))+(((r00)*(x407)*(x412)))+(((x405)*(x406)))+(((IkReal(-1.00000000000000))*(x400)*(x403)))+(((cj0)*(x390)*(x391)))+(((IkReal(-0.0750000000000000))*(x397)*(x401)))+(((IkReal(-1.00000000000000))*(sj1)*(x402)*(x403)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((x404)*(x407)))+(((sj1)*(x389)*(x399)))+(((IkReal(-0.0240000000000000))*(sj1)))+(((x389)*(x414)))+(((x408)*(x409)))+(((IkReal(-1.00000000000000))*(x398)*(x399)))+(((IkReal(-0.0800000000000000))*(px)*(sj3)*(x398)))+(((sj0)*(x390)*(x410)))+(((IkReal(-1.00000000000000))*(sj3)*(x395)*(x403)))+(((IkReal(0.320000000000000))*(cj1)*(pz)))+(((IkReal(-1.00000000000000))*(x390)*(x394)*(x403)))+(((x396)*(x397)))+(((IkReal(-1.00000000000000))*(cj3)*(x411)))+(((sj3)*(x392)*(x395)))+(((IkReal(-1.00000000000000))*(cj0)*(sj3)*(x390)*(x401)))))), ((gconst5)*(((IkReal(-0.0225000000000000))+(((IkReal(-0.0240000000000000))*(sj3)))+(((IkReal(-1.00000000000000))*(x390)*(x392)*(x404)))+(((IkReal(-1.00000000000000))*(x392)*(x393)))+(((cj0)*(x414)))+(((x390)*(x403)*(x404)))+(((cj1)*(x402)))+(((x406)*(x409)))+(((IkReal(0.320000000000000))*(x397)*(x401)))+(((IkReal(-1.00000000000000))*(sj1)*(x389)*(x396)))+(((x396)*(x398)))+(((x397)*(x399)))+(((x394)*(x407)))+(((IkReal(-1.00000000000000))*(x392)*(x413)))+(((IkReal(-1.00000000000000))*(x389)*(x390)*(x391)))+(((IkReal(-1.00000000000000))*(sj3)*(x411)))+(((cj3)*(x395)*(x403)))+(((cj0)*(cj3)*(x390)*(x401)))+(((sj0)*(x390)*(x412)))+(((IkReal(-1.00000000000000))*(x405)*(x408)))+(((x393)*(x403)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((IkReal(0.0800000000000000))*(x391)*(x398)))+(((x403)*(x413)))+(((IkReal(-1.00000000000000))*(r00)*(x407)*(x410)))+(((IkReal(-1.00000000000000))*(cj3)*(x392)*(x395)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x415=IKcos(j2);
IkReal x416=IKsin(j2);
IkReal x417=((IkReal(0.0800000000000000))*(sj3));
IkReal x418=((cj0)*(r01));
IkReal x419=((IkReal(1.00000000000000))*(px));
IkReal x420=((py)*(sj1));
IkReal x421=((cj0)*(r02));
IkReal x422=((IkReal(0.0750000000000000))*(cj1));
IkReal x423=((r02)*(sj0));
IkReal x424=((IkReal(0.0750000000000000))*(sj1));
IkReal x425=((cj1)*(pz));
IkReal x426=((r00)*(sj0));
IkReal x427=((IkReal(0.0800000000000000))*(cj3));
IkReal x428=((pz)*(sj1));
IkReal x429=((IkReal(1.00000000000000))*(sj0));
IkReal x430=((cj1)*(py));
IkReal x431=((IkReal(0.0750000000000000))*(x416));
IkReal x432=((IkReal(0.320000000000000))*(x415));
IkReal x433=((IkReal(0.320000000000000))*(x416));
IkReal x434=((IkReal(0.0750000000000000))*(x415));
IkReal x435=((sj1)*(x426));
IkReal x436=((x416)*(x417));
IkReal x437=((x415)*(x427));
IkReal x438=((x415)*(x417));
IkReal x439=((x416)*(x427));
IkReal x440=((x431)+(x436));
IkReal x441=((x432)+(x437));
IkReal x442=((x438)+(x439)+(x433)+(x434));
evalcond[0]=((x428)+(x422)+(x441)+(((IkReal(-1.00000000000000))*(x429)*(x430)))+(((IkReal(-1.00000000000000))*(cj0)*(cj1)*(x419)))+(((IkReal(-1.00000000000000))*(x440))));
evalcond[1]=((IkReal(0.300000000000000))+(((IkReal(-1.00000000000000))*(cj0)*(sj1)*(x419)))+(((IkReal(-1.00000000000000))*(x420)*(x429)))+(x424)+(x442)+(((IkReal(-1.00000000000000))*(x425))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x418)*(x422)))+(x440)+(((IkReal(-1.00000000000000))*(x418)*(x428)))+(((x420)*(x421)))+(((cj1)*(px)*(r01)))+(((IkReal(-1.00000000000000))*(x441)))+(((IkReal(-1.00000000000000))*(r00)*(x430)))+(((x422)*(x426)))+(((IkReal(-1.00000000000000))*(sj1)*(x419)*(x423)))+(((x426)*(x428))));
evalcond[3]=((((IkReal(-0.300000000000000))*(x426)))+(((IkReal(-1.00000000000000))*(r01)*(sj1)*(x419)))+(((x418)*(x424)))+(((x421)*(x430)))+(((x425)*(x426)))+(x442)+(((IkReal(-1.00000000000000))*(cj1)*(x419)*(x423)))+(((r00)*(x420)))+(((IkReal(0.300000000000000))*(x418)))+(((IkReal(-1.00000000000000))*(x424)*(x426)))+(((IkReal(-1.00000000000000))*(x418)*(x425))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x443=((IkReal(0.0800000000000000))*(cj1));
IkReal x444=((cj0)*(px));
IkReal x445=((py)*(sj0));
IkReal x446=((IkReal(0.320000000000000))*(sj1));
IkReal x447=((IkReal(0.00600000000000000))*(cj3));
IkReal x448=((pz)*(sj3));
IkReal x449=((IkReal(0.0750000000000000))*(cj1));
IkReal x450=((IkReal(0.0800000000000000))*(sj1));
IkReal x451=((IkReal(0.0750000000000000))*(sj1));
IkReal x452=((IkReal(0.00600000000000000))*(sj3));
IkReal x453=((cj3)*(pz));
IkReal x454=((IkReal(0.320000000000000))*(cj1));
if( IKabs(((gconst4)*(((IkReal(-0.0960000000000000))+(((x445)*(x446)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((IkReal(-0.0240000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(sj3)*(x443)*(x445)))+(((x448)*(x450)))+(((x443)*(x453)))+(((pz)*(x451)))+(((IkReal(-1.00000000000000))*(sj3)*(x443)*(x444)))+(((cj3)*(x444)*(x450)))+(((cj1)*(x452)))+(((IkReal(-1.00000000000000))*(x445)*(x449)))+(((IkReal(-1.00000000000000))*(sj1)*(x447)))+(((IkReal(0.00562500000000000))*(cj1)))+(((x444)*(x446)))+(((pz)*(x454)))+(((cj3)*(x445)*(x450)))+(((IkReal(-1.00000000000000))*(x444)*(x449))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst4)*(((IkReal(-0.0225000000000000))+(((IkReal(-0.0240000000000000))*(sj3)))+(((IkReal(-1.00000000000000))*(pz)*(x446)))+(((pz)*(x449)))+(((x445)*(x454)))+(((IkReal(-1.00000000000000))*(cj1)*(x447)))+(((x444)*(x451)))+(((cj3)*(x443)*(x444)))+(((IkReal(-0.0240000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(sj1)*(x452)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((x443)*(x448)))+(((cj3)*(x443)*(x445)))+(((x445)*(x451)))+(((sj3)*(x445)*(x450)))+(((sj3)*(x444)*(x450)))+(((IkReal(-1.00000000000000))*(x450)*(x453)))+(((x444)*(x454))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst4)*(((IkReal(-0.0960000000000000))+(((x445)*(x446)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((IkReal(-0.0240000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(sj3)*(x443)*(x445)))+(((x448)*(x450)))+(((x443)*(x453)))+(((pz)*(x451)))+(((IkReal(-1.00000000000000))*(sj3)*(x443)*(x444)))+(((cj3)*(x444)*(x450)))+(((cj1)*(x452)))+(((IkReal(-1.00000000000000))*(x445)*(x449)))+(((IkReal(-1.00000000000000))*(sj1)*(x447)))+(((IkReal(0.00562500000000000))*(cj1)))+(((x444)*(x446)))+(((pz)*(x454)))+(((cj3)*(x445)*(x450)))+(((IkReal(-1.00000000000000))*(x444)*(x449)))))), ((gconst4)*(((IkReal(-0.0225000000000000))+(((IkReal(-0.0240000000000000))*(sj3)))+(((IkReal(-1.00000000000000))*(pz)*(x446)))+(((pz)*(x449)))+(((x445)*(x454)))+(((IkReal(-1.00000000000000))*(cj1)*(x447)))+(((x444)*(x451)))+(((cj3)*(x443)*(x444)))+(((IkReal(-0.0240000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(sj1)*(x452)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((x443)*(x448)))+(((cj3)*(x443)*(x445)))+(((x445)*(x451)))+(((sj3)*(x445)*(x450)))+(((sj3)*(x444)*(x450)))+(((IkReal(-1.00000000000000))*(x450)*(x453)))+(((x444)*(x454)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x455=IKcos(j2);
IkReal x456=IKsin(j2);
IkReal x457=((IkReal(0.0800000000000000))*(sj3));
IkReal x458=((cj0)*(r01));
IkReal x459=((IkReal(1.00000000000000))*(px));
IkReal x460=((py)*(sj1));
IkReal x461=((cj0)*(r02));
IkReal x462=((IkReal(0.0750000000000000))*(cj1));
IkReal x463=((r02)*(sj0));
IkReal x464=((IkReal(0.0750000000000000))*(sj1));
IkReal x465=((cj1)*(pz));
IkReal x466=((r00)*(sj0));
IkReal x467=((IkReal(0.0800000000000000))*(cj3));
IkReal x468=((pz)*(sj1));
IkReal x469=((IkReal(1.00000000000000))*(sj0));
IkReal x470=((cj1)*(py));
IkReal x471=((IkReal(0.0750000000000000))*(x456));
IkReal x472=((IkReal(0.320000000000000))*(x455));
IkReal x473=((IkReal(0.320000000000000))*(x456));
IkReal x474=((IkReal(0.0750000000000000))*(x455));
IkReal x475=((sj1)*(x466));
IkReal x476=((x456)*(x457));
IkReal x477=((x455)*(x467));
IkReal x478=((x455)*(x457));
IkReal x479=((x456)*(x467));
IkReal x480=((x476)+(x471));
IkReal x481=((x477)+(x472));
IkReal x482=((x474)+(x473)+(x478)+(x479));
evalcond[0]=((((IkReal(-1.00000000000000))*(cj0)*(cj1)*(x459)))+(x468)+(x462)+(x481)+(((IkReal(-1.00000000000000))*(x480)))+(((IkReal(-1.00000000000000))*(x469)*(x470))));
evalcond[1]=((IkReal(0.300000000000000))+(((IkReal(-1.00000000000000))*(x465)))+(x464)+(((IkReal(-1.00000000000000))*(x460)*(x469)))+(x482)+(((IkReal(-1.00000000000000))*(cj0)*(sj1)*(x459))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x458)*(x462)))+(((x460)*(x461)))+(((x466)*(x468)))+(((IkReal(-1.00000000000000))*(sj1)*(x459)*(x463)))+(((cj1)*(px)*(r01)))+(((x462)*(x466)))+(x480)+(((IkReal(-1.00000000000000))*(r00)*(x470)))+(((IkReal(-1.00000000000000))*(x481)))+(((IkReal(-1.00000000000000))*(x458)*(x468))));
evalcond[3]=((((r00)*(x460)))+(((x465)*(x466)))+(((IkReal(-1.00000000000000))*(cj1)*(x459)*(x463)))+(((x458)*(x464)))+(((x461)*(x470)))+(((IkReal(-1.00000000000000))*(x458)*(x465)))+(((IkReal(-0.300000000000000))*(x466)))+(x482)+(((IkReal(0.300000000000000))*(x458)))+(((IkReal(-1.00000000000000))*(r01)*(sj1)*(x459)))+(((IkReal(-1.00000000000000))*(x464)*(x466))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
IkReal x483=((IkReal(0.0512000000000000))*(cj3));
IkReal x484=((IkReal(0.0120000000000000))*(sj3));
IkReal x485=(py)*(py);
IkReal x486=(px)*(px);
IkReal x487=(pz)*(pz);
IkReal x488=((r01)*(sj0));
IkReal x489=((py)*(r00));
IkReal x490=((pz)*(sj1));
IkReal x491=((py)*(r01));
IkReal x492=((px)*(sj0));
IkReal x493=((IkReal(0.600000000000000))*(r02));
IkReal x494=((IkReal(0.150000000000000))*(cj1));
IkReal x495=((cj0)*(sj1));
IkReal x496=((IkReal(0.150000000000000))*(px));
IkReal x497=((IkReal(2.00000000000000))*(cj1));
IkReal x498=((cj0)*(r01));
IkReal x499=((r02)*(sj1));
IkReal x500=((px)*(r00));
IkReal x501=((IkReal(0.300000000000000))*(r00));
IkReal x502=((IkReal(1.00000000000000))*(pz));
IkReal x503=((r00)*(sj1));
IkReal x504=((cj0)*(r00));
IkReal x505=((cj0)*(cj1));
IkReal x506=((IkReal(1.00000000000000))*(sj1));
IkReal x507=((IkReal(0.0956250000000000))*(r00));
IkReal x508=((IkReal(0.600000000000000))*(pz));
IkReal x509=((IkReal(0.600000000000000))*(sj1));
IkReal x510=((IkReal(2.00000000000000))*(px));
IkReal x511=((IkReal(2.00000000000000))*(sj1));
IkReal x512=((IkReal(0.150000000000000))*(sj1));
IkReal x513=((cj1)*(r02));
IkReal x514=((cj0)*(px));
IkReal x515=((IkReal(0.0843750000000000))*(cj1));
IkReal x516=((py)*(sj0));
IkReal x517=((pz)*(r02));
IkReal x518=((IkReal(1.00000000000000))*(cj1));
IkReal x519=((cj0)*(py));
IkReal x520=((r00)*(sj0));
IkReal x521=((r02)*(x516));
IkReal x522=((pp)*(x518));
IkReal x523=((IkReal(1.00000000000000))*(pp)*(r00));
IkReal x524=((x483)+(x484));
IkReal x525=((IkReal(2.00000000000000))*(r00)*(x486));
IkReal x526=((cj0)*(x510)*(x517));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j4)), IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x492)))+(x519));
evalcond[2]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x520)))+(x498));
evalcond[3]=((((IkReal(-1.00000000000000))*(x488)*(x518)))+(x499)+(((IkReal(-1.00000000000000))*(x504)*(x518))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x488)*(x506)))+(((IkReal(-1.00000000000000))*(r00)*(x495)))+(((IkReal(-1.00000000000000))*(x513))));
evalcond[5]=((IkReal(0.0188000000000000))+(((cj0)*(x496)))+(((IkReal(0.150000000000000))*(x516)))+(((x509)*(x516)))+(((cj1)*(x508)))+(((IkReal(-1.00000000000000))*(pp)))+(((IkReal(0.600000000000000))*(px)*(x495)))+(((IkReal(-0.0450000000000000))*(sj1)))+(x524));
evalcond[6]=((((IkReal(-1.00000000000000))*(x500)))+(((IkReal(0.0750000000000000))*(x504)))+(((IkReal(0.300000000000000))*(sj1)*(x488)))+(((x495)*(x501)))+(((IkReal(-1.00000000000000))*(r02)*(x502)))+(((IkReal(0.300000000000000))*(x513)))+(((IkReal(0.0750000000000000))*(x488)))+(((IkReal(-1.00000000000000))*(x491))));
evalcond[7]=((((IkReal(-0.300000000000000))*(x499)))+(((IkReal(0.300000000000000))*(cj1)*(x488)))+(((IkReal(-1.00000000000000))*(x502)*(x504)))+(((r02)*(x514)))+(((IkReal(-1.00000000000000))*(x488)*(x502)))+(((IkReal(-0.0750000000000000))*(r02)))+(x521)+(((x501)*(x505))));
evalcond[8]=((IkReal(0.114425000000000))+(((cj1)*(x508)*(x520)))+(((IkReal(0.0956250000000000))*(x498)))+(((pp)*(x498)))+(((IkReal(-1.00000000000000))*(cj0)*(x489)*(x510)))+(((IkReal(-1.00000000000000))*(cj1)*(x498)*(x508)))+(((IkReal(0.0450000000000000))*(r01)*(x495)))+(((IkReal(-2.00000000000000))*(x485)*(x498)))+(((IkReal(-1.00000000000000))*(pp)*(x520)))+(((py)*(x493)*(x505)))+(((IkReal(0.150000000000000))*(x489)))+(((IkReal(-1.00000000000000))*(cj1)*(x492)*(x493)))+(((IkReal(-1.00000000000000))*(px)*(r01)*(x509)))+(((IkReal(-1.00000000000000))*(r01)*(x496)))+(((py)*(x488)*(x510)))+(((IkReal(2.00000000000000))*(x486)*(x520)))+(((IkReal(-0.0450000000000000))*(sj0)*(x503)))+(((IkReal(2.00000000000000))*(x492)*(x517)))+(((IkReal(-2.00000000000000))*(x517)*(x519)))+(((IkReal(-1.00000000000000))*(sj0)*(x507)))+(x524)+(((x489)*(x509))));
evalcond[9]=((((IkReal(0.0843750000000000))*(x513)))+(((IkReal(-1.00000000000000))*(x491)*(x512)))+(((pz)*(x491)*(x497)))+(((IkReal(0.0450000000000000))*(x504)))+(((IkReal(0.0450000000000000))*(x488)))+(((x491)*(x495)*(x510)))+(((x495)*(x525)))+(((IkReal(-0.150000000000000))*(r02)*(x490)))+(((IkReal(-1.00000000000000))*(pp)*(x513)))+(((r02)*(x494)*(x514)))+(((r02)*(x487)*(x497)))+(((x495)*(x507)))+(((IkReal(-1.00000000000000))*(x495)*(x523)))+(((IkReal(0.0956250000000000))*(sj1)*(x488)))+(((IkReal(-1.00000000000000))*(pz)*(x488)*(x494)))+(((IkReal(2.00000000000000))*(x490)*(x521)))+(((x489)*(x492)*(x511)))+(((pz)*(x497)*(x500)))+(((x485)*(x488)*(x511)))+(((cj0)*(r02)*(x490)*(x510)))+(((IkReal(-1.00000000000000))*(pz)*(x494)*(x504)))+(((IkReal(-0.600000000000000))*(x491)))+(((IkReal(-1.00000000000000))*(pp)*(x488)*(x506)))+(((IkReal(-0.600000000000000))*(x500)))+(((x494)*(x521)))+(((IkReal(-1.00000000000000))*(x496)*(x503)))+(((IkReal(-1.00000000000000))*(pz)*(x493))));
evalcond[10]=((((IkReal(-2.00000000000000))*(x490)*(x491)))+(((IkReal(-1.00000000000000))*(x488)*(x522)))+(((IkReal(-1.00000000000000))*(r02)*(x495)*(x496)))+(((IkReal(-2.00000000000000))*(x490)*(x500)))+(((IkReal(-1.00000000000000))*(x494)*(x517)))+(((IkReal(-2.00000000000000))*(x487)*(x499)))+(((x497)*(x516)*(x517)))+(((IkReal(0.150000000000000))*(x488)*(x490)))+(((x489)*(x492)*(x497)))+(((IkReal(0.0450000000000000))*(r02)))+(((IkReal(-1.00000000000000))*(x494)*(x500)))+(((IkReal(-1.00000000000000))*(x488)*(x515)))+(((x486)*(x497)*(x504)))+(((IkReal(-1.00000000000000))*(x504)*(x515)))+(((x504)*(x508)))+(((pp)*(x499)))+(((x488)*(x508)))+(((x485)*(x488)*(x497)))+(((IkReal(-1.00000000000000))*(x493)*(x514)))+(((IkReal(-0.150000000000000))*(x499)*(x516)))+(((IkReal(0.150000000000000))*(x490)*(x504)))+(((IkReal(-1.00000000000000))*(x491)*(x494)))+(((IkReal(-1.00000000000000))*(x504)*(x522)))+(((IkReal(-1.00000000000000))*(x493)*(x516)))+(((IkReal(0.0956250000000000))*(x499)))+(((x491)*(x497)*(x514)))+(((x497)*(x514)*(x517))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  && IKabs(evalcond[9]) < 0.0000010000000000  && IKabs(evalcond[10]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst6;
gconst6=IKsign(((IkReal(0.108025000000000))+(((IkReal(0.0512000000000000))*(cj3)))+(((IkReal(0.00640000000000000))*((sj3)*(sj3))))+(((IkReal(0.00640000000000000))*((cj3)*(cj3))))+(((IkReal(0.0120000000000000))*(sj3)))));
dummyeval[0]=((IkReal(16.8789062500000))+((cj3)*(cj3))+(((IkReal(1.87500000000000))*(sj3)))+((sj3)*(sj3))+(((IkReal(8.00000000000000))*(cj3))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst7;
gconst7=IKsign(((IkReal(-0.108025000000000))+(((IkReal(-0.0512000000000000))*(cj3)))+(((IkReal(-0.00640000000000000))*((sj3)*(sj3))))+(((IkReal(-0.0120000000000000))*(sj3)))+(((IkReal(-0.00640000000000000))*((cj3)*(cj3))))));
dummyeval[0]=((IkReal(-16.8789062500000))+(((IkReal(-1.87500000000000))*(sj3)))+(((IkReal(-1.00000000000000))*((cj3)*(cj3))))+(((IkReal(-8.00000000000000))*(cj3)))+(((IkReal(-1.00000000000000))*((sj3)*(sj3)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x527=((r02)*(sj0));
IkReal x528=((IkReal(0.0800000000000000))*(sj1));
IkReal x529=((cj3)*(px));
IkReal x530=((cj0)*(r01));
IkReal x531=((IkReal(0.0240000000000000))*(cj1));
IkReal x532=((pz)*(sj3));
IkReal x533=((IkReal(0.00600000000000000))*(cj1));
IkReal x534=((IkReal(0.0750000000000000))*(sj1));
IkReal x535=((py)*(sj0));
IkReal x536=((IkReal(0.00562500000000000))*(cj1));
IkReal x537=((r00)*(sj0));
IkReal x538=((cj3)*(pz));
IkReal x539=((IkReal(0.320000000000000))*(sj1));
IkReal x540=((IkReal(0.0800000000000000))*(cj1));
IkReal x541=((IkReal(0.0750000000000000))*(cj1));
IkReal x542=((py)*(r00));
IkReal x543=((IkReal(0.320000000000000))*(cj1));
IkReal x544=((cj0)*(px));
IkReal x545=((IkReal(0.00600000000000000))*(sj1));
IkReal x546=((cj1)*(px)*(r01));
IkReal x547=((cj0)*(py)*(r02));
IkReal x548=((px)*(sj3)*(x528));
if( IKabs(((gconst7)*(((IkReal(0.0960000000000000))+(((IkReal(-1.00000000000000))*(x535)*(x539)))+(((sj3)*(x540)*(x542)))+(((IkReal(-1.00000000000000))*(cj3)*(x528)*(x535)))+(((IkReal(-1.00000000000000))*(sj3)*(x528)*(x547)))+(((px)*(x527)*(x534)))+(((IkReal(-1.00000000000000))*(x534)*(x547)))+(((IkReal(-1.00000000000000))*(x536)*(x537)))+(((x528)*(x530)*(x532)))+(((IkReal(-1.00000000000000))*(pz)*(x534)*(x537)))+(((IkReal(-1.00000000000000))*(pz)*(x543)))+(((sj3)*(x530)*(x533)))+(((IkReal(0.0240000000000000))*(sj1)))+(((x530)*(x536)))+(((IkReal(-1.00000000000000))*(cj0)*(x528)*(x529)))+(((IkReal(-1.00000000000000))*(x539)*(x544)))+(((x541)*(x542)))+(((pz)*(x530)*(x534)))+(((IkReal(-1.00000000000000))*(px)*(r01)*(x541)))+(((x527)*(x548)))+(((cj3)*(x545)))+(((IkReal(-1.00000000000000))*(sj3)*(x533)*(x537)))+(((IkReal(0.0240000000000000))*(cj3)))+(((IkReal(-1.00000000000000))*(x528)*(x532)*(x537)))+(((IkReal(-1.00000000000000))*(px)*(r01)*(sj3)*(x540)))+(((IkReal(-1.00000000000000))*(x538)*(x540))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst7)*(((IkReal(0.0225000000000000))+(((cj3)*(x533)*(x537)))+(((IkReal(-1.00000000000000))*(pz)*(x530)*(x539)))+(((IkReal(-1.00000000000000))*(sj3)*(x528)*(x535)))+(((IkReal(0.00562500000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(pz)*(x541)))+(((IkReal(-1.00000000000000))*(x527)*(x528)*(x529)))+(((x539)*(x547)))+(((IkReal(-1.00000000000000))*(cj3)*(x540)*(x542)))+(((IkReal(-1.00000000000000))*(x542)*(x543)))+(((IkReal(-1.00000000000000))*(x530)*(x531)))+(((IkReal(-1.00000000000000))*(x534)*(x535)))+(((cj3)*(x528)*(x547)))+(((x528)*(x537)*(x538)))+(((IkReal(-1.00000000000000))*(x528)*(x530)*(x538)))+(((pz)*(x537)*(x539)))+(((r01)*(x529)*(x540)))+(((IkReal(-1.00000000000000))*(cj3)*(x530)*(x533)))+(((IkReal(-1.00000000000000))*(x534)*(x544)))+(((IkReal(-1.00000000000000))*(px)*(x527)*(x539)))+(((IkReal(-1.00000000000000))*(x532)*(x540)))+(((px)*(r01)*(x543)))+(((x531)*(x537)))+(((IkReal(-1.00000000000000))*(sj3)*(x528)*(x544)))+(((sj3)*(x545)))+(((IkReal(0.0240000000000000))*(sj3))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst7)*(((IkReal(0.0960000000000000))+(((IkReal(-1.00000000000000))*(x535)*(x539)))+(((sj3)*(x540)*(x542)))+(((IkReal(-1.00000000000000))*(cj3)*(x528)*(x535)))+(((IkReal(-1.00000000000000))*(sj3)*(x528)*(x547)))+(((px)*(x527)*(x534)))+(((IkReal(-1.00000000000000))*(x534)*(x547)))+(((IkReal(-1.00000000000000))*(x536)*(x537)))+(((x528)*(x530)*(x532)))+(((IkReal(-1.00000000000000))*(pz)*(x534)*(x537)))+(((IkReal(-1.00000000000000))*(pz)*(x543)))+(((sj3)*(x530)*(x533)))+(((IkReal(0.0240000000000000))*(sj1)))+(((x530)*(x536)))+(((IkReal(-1.00000000000000))*(cj0)*(x528)*(x529)))+(((IkReal(-1.00000000000000))*(x539)*(x544)))+(((x541)*(x542)))+(((pz)*(x530)*(x534)))+(((IkReal(-1.00000000000000))*(px)*(r01)*(x541)))+(((x527)*(x548)))+(((cj3)*(x545)))+(((IkReal(-1.00000000000000))*(sj3)*(x533)*(x537)))+(((IkReal(0.0240000000000000))*(cj3)))+(((IkReal(-1.00000000000000))*(x528)*(x532)*(x537)))+(((IkReal(-1.00000000000000))*(px)*(r01)*(sj3)*(x540)))+(((IkReal(-1.00000000000000))*(x538)*(x540)))))), ((gconst7)*(((IkReal(0.0225000000000000))+(((cj3)*(x533)*(x537)))+(((IkReal(-1.00000000000000))*(pz)*(x530)*(x539)))+(((IkReal(-1.00000000000000))*(sj3)*(x528)*(x535)))+(((IkReal(0.00562500000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(pz)*(x541)))+(((IkReal(-1.00000000000000))*(x527)*(x528)*(x529)))+(((x539)*(x547)))+(((IkReal(-1.00000000000000))*(cj3)*(x540)*(x542)))+(((IkReal(-1.00000000000000))*(x542)*(x543)))+(((IkReal(-1.00000000000000))*(x530)*(x531)))+(((IkReal(-1.00000000000000))*(x534)*(x535)))+(((cj3)*(x528)*(x547)))+(((x528)*(x537)*(x538)))+(((IkReal(-1.00000000000000))*(x528)*(x530)*(x538)))+(((pz)*(x537)*(x539)))+(((r01)*(x529)*(x540)))+(((IkReal(-1.00000000000000))*(cj3)*(x530)*(x533)))+(((IkReal(-1.00000000000000))*(x534)*(x544)))+(((IkReal(-1.00000000000000))*(px)*(x527)*(x539)))+(((IkReal(-1.00000000000000))*(x532)*(x540)))+(((px)*(r01)*(x543)))+(((x531)*(x537)))+(((IkReal(-1.00000000000000))*(sj3)*(x528)*(x544)))+(((sj3)*(x545)))+(((IkReal(0.0240000000000000))*(sj3)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x549=IKcos(j2);
IkReal x550=IKsin(j2);
IkReal x551=((IkReal(0.0800000000000000))*(sj3));
IkReal x552=((cj0)*(r01));
IkReal x553=((IkReal(1.00000000000000))*(px));
IkReal x554=((py)*(sj1));
IkReal x555=((cj0)*(r02));
IkReal x556=((IkReal(0.0750000000000000))*(cj1));
IkReal x557=((r02)*(sj0));
IkReal x558=((IkReal(0.0750000000000000))*(sj1));
IkReal x559=((cj1)*(pz));
IkReal x560=((r00)*(sj0));
IkReal x561=((IkReal(0.0800000000000000))*(cj3));
IkReal x562=((pz)*(sj1));
IkReal x563=((IkReal(1.00000000000000))*(sj0));
IkReal x564=((cj1)*(py));
IkReal x565=((IkReal(0.320000000000000))*(x549));
IkReal x566=((IkReal(0.0750000000000000))*(x550));
IkReal x567=((IkReal(0.320000000000000))*(x550));
IkReal x568=((IkReal(0.0750000000000000))*(x549));
IkReal x569=((sj1)*(x560));
IkReal x570=((x549)*(x561));
IkReal x571=((x550)*(x551));
IkReal x572=((x549)*(x551));
IkReal x573=((x550)*(x561));
IkReal x574=((x571)+(x566));
IkReal x575=((x570)+(x565));
IkReal x576=((x573)+(x572)+(x568)+(x567));
evalcond[0]=((x575)+(((IkReal(-1.00000000000000))*(x574)))+(x562)+(((IkReal(-1.00000000000000))*(cj0)*(cj1)*(x553)))+(((IkReal(-1.00000000000000))*(x563)*(x564)))+(x556));
evalcond[1]=((IkReal(0.300000000000000))+(x576)+(((IkReal(-1.00000000000000))*(cj0)*(sj1)*(x553)))+(((IkReal(-1.00000000000000))*(x559)))+(((IkReal(-1.00000000000000))*(x554)*(x563)))+(x558));
evalcond[2]=((x575)+(((IkReal(-1.00000000000000))*(x574)))+(((IkReal(-1.00000000000000))*(sj1)*(x553)*(x557)))+(((x554)*(x555)))+(((x556)*(x560)))+(((IkReal(-1.00000000000000))*(x552)*(x562)))+(((cj1)*(px)*(r01)))+(((IkReal(-1.00000000000000))*(x552)*(x556)))+(((x560)*(x562)))+(((IkReal(-1.00000000000000))*(r00)*(x564))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x552)*(x559)))+(((IkReal(-1.00000000000000))*(r01)*(sj1)*(x553)))+(((x552)*(x558)))+(((x559)*(x560)))+(((IkReal(-1.00000000000000))*(x576)))+(((IkReal(-1.00000000000000))*(x558)*(x560)))+(((IkReal(0.300000000000000))*(x552)))+(((r00)*(x554)))+(((x555)*(x564)))+(((IkReal(-1.00000000000000))*(cj1)*(x553)*(x557)))+(((IkReal(-0.300000000000000))*(x560))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x577=((IkReal(0.0800000000000000))*(cj1));
IkReal x578=((cj0)*(px));
IkReal x579=((py)*(sj0));
IkReal x580=((IkReal(0.320000000000000))*(sj1));
IkReal x581=((IkReal(0.00600000000000000))*(cj3));
IkReal x582=((pz)*(sj3));
IkReal x583=((IkReal(0.0750000000000000))*(cj1));
IkReal x584=((IkReal(0.0800000000000000))*(sj1));
IkReal x585=((IkReal(0.0750000000000000))*(sj1));
IkReal x586=((IkReal(0.00600000000000000))*(sj3));
IkReal x587=((cj3)*(pz));
IkReal x588=((IkReal(0.320000000000000))*(cj1));
if( IKabs(((gconst6)*(((IkReal(-0.0960000000000000))+(((cj1)*(x586)))+(((pz)*(x588)))+(((IkReal(-1.00000000000000))*(sj3)*(x577)*(x579)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((IkReal(-1.00000000000000))*(sj3)*(x577)*(x578)))+(((IkReal(-0.0240000000000000))*(sj1)))+(((x577)*(x587)))+(((x579)*(x580)))+(((pz)*(x585)))+(((cj3)*(x579)*(x584)))+(((x578)*(x580)))+(((IkReal(0.00562500000000000))*(cj1)))+(((cj3)*(x578)*(x584)))+(((x582)*(x584)))+(((IkReal(-1.00000000000000))*(x579)*(x583)))+(((IkReal(-1.00000000000000))*(sj1)*(x581)))+(((IkReal(-1.00000000000000))*(x578)*(x583))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst6)*(((IkReal(-0.0225000000000000))+(((sj3)*(x578)*(x584)))+(((IkReal(-1.00000000000000))*(sj1)*(x586)))+(((x579)*(x588)))+(((IkReal(-0.0240000000000000))*(sj3)))+(((x578)*(x585)))+(((cj3)*(x577)*(x579)))+(((pz)*(x583)))+(((x578)*(x588)))+(((IkReal(-1.00000000000000))*(cj1)*(x581)))+(((IkReal(-1.00000000000000))*(x584)*(x587)))+(((sj3)*(x579)*(x584)))+(((x577)*(x582)))+(((IkReal(-0.0240000000000000))*(cj1)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(pz)*(x580)))+(((x579)*(x585)))+(((cj3)*(x577)*(x578))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst6)*(((IkReal(-0.0960000000000000))+(((cj1)*(x586)))+(((pz)*(x588)))+(((IkReal(-1.00000000000000))*(sj3)*(x577)*(x579)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((IkReal(-1.00000000000000))*(sj3)*(x577)*(x578)))+(((IkReal(-0.0240000000000000))*(sj1)))+(((x577)*(x587)))+(((x579)*(x580)))+(((pz)*(x585)))+(((cj3)*(x579)*(x584)))+(((x578)*(x580)))+(((IkReal(0.00562500000000000))*(cj1)))+(((cj3)*(x578)*(x584)))+(((x582)*(x584)))+(((IkReal(-1.00000000000000))*(x579)*(x583)))+(((IkReal(-1.00000000000000))*(sj1)*(x581)))+(((IkReal(-1.00000000000000))*(x578)*(x583)))))), ((gconst6)*(((IkReal(-0.0225000000000000))+(((sj3)*(x578)*(x584)))+(((IkReal(-1.00000000000000))*(sj1)*(x586)))+(((x579)*(x588)))+(((IkReal(-0.0240000000000000))*(sj3)))+(((x578)*(x585)))+(((cj3)*(x577)*(x579)))+(((pz)*(x583)))+(((x578)*(x588)))+(((IkReal(-1.00000000000000))*(cj1)*(x581)))+(((IkReal(-1.00000000000000))*(x584)*(x587)))+(((sj3)*(x579)*(x584)))+(((x577)*(x582)))+(((IkReal(-0.0240000000000000))*(cj1)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(pz)*(x580)))+(((x579)*(x585)))+(((cj3)*(x577)*(x578)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x589=IKcos(j2);
IkReal x590=IKsin(j2);
IkReal x591=((IkReal(0.0800000000000000))*(sj3));
IkReal x592=((cj0)*(r01));
IkReal x593=((IkReal(1.00000000000000))*(px));
IkReal x594=((py)*(sj1));
IkReal x595=((cj0)*(r02));
IkReal x596=((IkReal(0.0750000000000000))*(cj1));
IkReal x597=((r02)*(sj0));
IkReal x598=((IkReal(0.0750000000000000))*(sj1));
IkReal x599=((cj1)*(pz));
IkReal x600=((r00)*(sj0));
IkReal x601=((IkReal(0.0800000000000000))*(cj3));
IkReal x602=((pz)*(sj1));
IkReal x603=((IkReal(1.00000000000000))*(sj0));
IkReal x604=((cj1)*(py));
IkReal x605=((IkReal(0.320000000000000))*(x589));
IkReal x606=((IkReal(0.0750000000000000))*(x590));
IkReal x607=((IkReal(0.320000000000000))*(x590));
IkReal x608=((IkReal(0.0750000000000000))*(x589));
IkReal x609=((sj1)*(x600));
IkReal x610=((x589)*(x601));
IkReal x611=((x590)*(x591));
IkReal x612=((x589)*(x591));
IkReal x613=((x590)*(x601));
IkReal x614=((x611)+(x606));
IkReal x615=((x610)+(x605));
IkReal x616=((x612)+(x613)+(x607)+(x608));
evalcond[0]=((((IkReal(-1.00000000000000))*(cj0)*(cj1)*(x593)))+(((IkReal(-1.00000000000000))*(x603)*(x604)))+(((IkReal(-1.00000000000000))*(x614)))+(x615)+(x596)+(x602));
evalcond[1]=((IkReal(0.300000000000000))+(((IkReal(-1.00000000000000))*(cj0)*(sj1)*(x593)))+(((IkReal(-1.00000000000000))*(x594)*(x603)))+(x616)+(x598)+(((IkReal(-1.00000000000000))*(x599))));
evalcond[2]=((((x594)*(x595)))+(((IkReal(-1.00000000000000))*(x592)*(x596)))+(((x600)*(x602)))+(((IkReal(-1.00000000000000))*(sj1)*(x593)*(x597)))+(((x596)*(x600)))+(((cj1)*(px)*(r01)))+(((IkReal(-1.00000000000000))*(x614)))+(x615)+(((IkReal(-1.00000000000000))*(x592)*(x602)))+(((IkReal(-1.00000000000000))*(r00)*(x604))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x592)*(x599)))+(((x595)*(x604)))+(((x599)*(x600)))+(((x592)*(x598)))+(((IkReal(0.300000000000000))*(x592)))+(((IkReal(-0.300000000000000))*(x600)))+(((r00)*(x594)))+(((IkReal(-1.00000000000000))*(x616)))+(((IkReal(-1.00000000000000))*(cj1)*(x593)*(x597)))+(((IkReal(-1.00000000000000))*(x598)*(x600)))+(((IkReal(-1.00000000000000))*(r01)*(sj1)*(x593))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x617=((IkReal(0.0800000000000000))*(cj3));
IkReal x618=((IkReal(0.0750000000000000))*(cj1));
IkReal x619=((r01)*(sj0));
IkReal x620=((r02)*(sj1));
IkReal x621=((IkReal(0.0800000000000000))*(sj3));
IkReal x622=((cj3)*(cj4));
IkReal x623=((cj4)*(sj3));
IkReal x624=((pz)*(sj1));
IkReal x625=((cj0)*(cj1)*(r00));
IkReal x626=((cj0)*(cj1)*(px));
IkReal x627=((cj1)*(py)*(sj0));
if( IKabs(((gconst3)*(((((IkReal(-0.320000000000000))*(cj1)*(x619)))+(((IkReal(-0.320000000000000))*(x625)))+(((IkReal(-1.00000000000000))*(cj1)*(x617)*(x619)))+(((x617)*(x620)))+(((x623)*(x624)))+(((x618)*(x623)))+(((IkReal(-1.00000000000000))*(x623)*(x626)))+(((IkReal(-1.00000000000000))*(x617)*(x625)))+(((IkReal(-1.00000000000000))*(x623)*(x627)))+(((IkReal(0.320000000000000))*(x620))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst3)*(((((IkReal(-1.00000000000000))*(x618)*(x619)))+(((IkReal(-1.00000000000000))*(cj1)*(x619)*(x621)))+(((x622)*(x626)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x618)))+(((IkReal(-1.00000000000000))*(x621)*(x625)))+(((IkReal(-1.00000000000000))*(x622)*(x624)))+(((IkReal(-1.00000000000000))*(x618)*(x622)))+(((x622)*(x627)))+(((IkReal(0.0750000000000000))*(x620)))+(((x620)*(x621))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst3)*(((((IkReal(-0.320000000000000))*(cj1)*(x619)))+(((IkReal(-0.320000000000000))*(x625)))+(((IkReal(-1.00000000000000))*(cj1)*(x617)*(x619)))+(((x617)*(x620)))+(((x623)*(x624)))+(((x618)*(x623)))+(((IkReal(-1.00000000000000))*(x623)*(x626)))+(((IkReal(-1.00000000000000))*(x617)*(x625)))+(((IkReal(-1.00000000000000))*(x623)*(x627)))+(((IkReal(0.320000000000000))*(x620)))))), ((gconst3)*(((((IkReal(-1.00000000000000))*(x618)*(x619)))+(((IkReal(-1.00000000000000))*(cj1)*(x619)*(x621)))+(((x622)*(x626)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x618)))+(((IkReal(-1.00000000000000))*(x621)*(x625)))+(((IkReal(-1.00000000000000))*(x622)*(x624)))+(((IkReal(-1.00000000000000))*(x618)*(x622)))+(((x622)*(x627)))+(((IkReal(0.0750000000000000))*(x620)))+(((x620)*(x621)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x628=IKcos(j2);
IkReal x629=IKsin(j2);
IkReal x630=(py)*(py);
IkReal x631=(px)*(px);
IkReal x632=(pz)*(pz);
IkReal x633=((sj0)*(sj1));
IkReal x634=((IkReal(1.00000000000000))*(r01));
IkReal x635=((r00)*(sj1));
IkReal x636=((IkReal(0.0480000000000000))*(sj3));
IkReal x637=((IkReal(0.0750000000000000))*(r00));
IkReal x638=((IkReal(0.0800000000000000))*(sj3));
IkReal x639=((cj1)*(r01));
IkReal x640=((IkReal(0.150000000000000))*(py));
IkReal x641=((pz)*(r02));
IkReal x642=((px)*(r02));
IkReal x643=((IkReal(0.0750000000000000))*(sj4));
IkReal x644=((cj1)*(sj0));
IkReal x645=((pz)*(r00));
IkReal x646=((IkReal(0.0750000000000000))*(cj0));
IkReal x647=((IkReal(2.00000000000000))*(cj0));
IkReal x648=((cj1)*(r02));
IkReal x649=((IkReal(0.150000000000000))*(sj1));
IkReal x650=((px)*(r00));
IkReal x651=((IkReal(2.00000000000000))*(py));
IkReal x652=((IkReal(0.0903750000000000))*(sj3));
IkReal x653=((r02)*(sj1));
IkReal x654=((IkReal(0.150000000000000))*(cj1));
IkReal x655=((cj0)*(py));
IkReal x656=((IkReal(0.0480000000000000))*(cj3));
IkReal x657=((r01)*(sj1));
IkReal x658=((IkReal(0.0800000000000000))*(cj3));
IkReal x659=((IkReal(0.150000000000000))*(pz));
IkReal x660=((IkReal(1.00000000000000))*(cj1));
IkReal x661=((cj0)*(r00));
IkReal x662=((IkReal(0.600000000000000))*(py));
IkReal x663=((IkReal(1.00000000000000))*(py));
IkReal x664=((px)*(sj1));
IkReal x665=((IkReal(1.00000000000000))*(cj0));
IkReal x666=((cj0)*(pz));
IkReal x667=((IkReal(0.103175000000000))*(cj3));
IkReal x668=((IkReal(0.600000000000000))*(cj0));
IkReal x669=((IkReal(1.00000000000000))*(sj3));
IkReal x670=((px)*(py));
IkReal x671=((r01)*(sj0));
IkReal x672=((IkReal(2.00000000000000))*(px));
IkReal x673=((cj4)*(x629));
IkReal x674=((cj4)*(x628));
IkReal x675=((sj4)*(x629));
IkReal x676=((IkReal(2.00000000000000))*(x632));
IkReal x677=((sj4)*(x628));
IkReal x678=((IkReal(2.00000000000000))*(x630));
IkReal x679=((px)*(x641)*(x647));
evalcond[0]=((x653)+(((IkReal(-1.00000000000000))*(x669)*(x674)))+(((IkReal(-1.00000000000000))*(x660)*(x661)))+(((IkReal(-1.00000000000000))*(x634)*(x644)))+(((IkReal(-1.00000000000000))*(cj3)*(x673))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x669)*(x673)))+(((IkReal(-1.00000000000000))*(x633)*(x634)))+(((cj3)*(x674)))+(((IkReal(-1.00000000000000))*(x635)*(x665)))+(((IkReal(-1.00000000000000))*(x648))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x629)*(x638)))+(((IkReal(-1.00000000000000))*(x644)*(x663)))+(((pz)*(sj1)))+(((x628)*(x658)))+(((IkReal(-0.0750000000000000))*(x629)))+(((IkReal(-1.00000000000000))*(cj0)*(px)*(x660)))+(((IkReal(0.0750000000000000))*(cj1)))+(((IkReal(0.320000000000000))*(x628))));
evalcond[3]=((IkReal(0.300000000000000))+(((IkReal(0.320000000000000))*(x629)))+(((IkReal(-1.00000000000000))*(x633)*(x663)))+(((x628)*(x638)))+(((IkReal(0.0750000000000000))*(x628)))+(((IkReal(-1.00000000000000))*(pz)*(x660)))+(((IkReal(-1.00000000000000))*(x664)*(x665)))+(((x629)*(x658)))+(((IkReal(0.0750000000000000))*(sj1))));
evalcond[4]=((((x638)*(x675)))+(((IkReal(-0.320000000000000))*(x677)))+(((x629)*(x643)))+(((IkReal(-1.00000000000000))*(x658)*(x677)))+(((x633)*(x645)))+(((IkReal(-1.00000000000000))*(sj1)*(x634)*(x666)))+(((px)*(x639)))+(((x637)*(x644)))+(((IkReal(-1.00000000000000))*(x633)*(x642)))+(((x653)*(x655)))+(((IkReal(-1.00000000000000))*(x639)*(x646)))+(((IkReal(-1.00000000000000))*(py)*(r00)*(x660))));
evalcond[5]=((((x628)*(x643)))+(((x646)*(x657)))+(((py)*(x635)))+(((x638)*(x677)))+(((IkReal(-0.300000000000000))*(r00)*(sj0)))+(((x658)*(x675)))+(((x644)*(x645)))+(((IkReal(-1.00000000000000))*(x634)*(x664)))+(((IkReal(-1.00000000000000))*(x633)*(x637)))+(((x648)*(x655)))+(((IkReal(0.320000000000000))*(x675)))+(((IkReal(-1.00000000000000))*(cj1)*(x634)*(x666)))+(((IkReal(0.300000000000000))*(cj0)*(r01)))+(((IkReal(-1.00000000000000))*(x642)*(x644))));
evalcond[6]=((((cj1)*(x645)*(x672)))+(((x647)*(x657)*(x670)))+(((x633)*(x650)*(x651)))+(((IkReal(-1.00000000000000))*(sj0)*(x639)*(x659)))+(((IkReal(0.0512000000000000))*(x674)))+(((cj0)*(x642)*(x654)))+(((IkReal(0.0956250000000000))*(cj0)*(x635)))+(((x633)*(x641)*(x651)))+(((IkReal(-0.600000000000000))*(x641)))+(((IkReal(-1.00000000000000))*(r01)*(x662)))+(((IkReal(-1.00000000000000))*(pp)*(x635)*(x665)))+(((x652)*(x673)))+(((IkReal(0.0450000000000000))*(x671)))+(((IkReal(-1.00000000000000))*(x640)*(x657)))+(((IkReal(-1.00000000000000))*(x641)*(x649)))+(((x636)*(x674)))+(((IkReal(-1.00000000000000))*(pp)*(x633)*(x634)))+(((IkReal(0.0450000000000000))*(x661)))+(((r01)*(x633)*(x678)))+(((IkReal(-1.00000000000000))*(cj0)*(x645)*(x654)))+(((x631)*(x635)*(x647)))+(((IkReal(-0.600000000000000))*(x650)))+(((x641)*(x647)*(x664)))+(((IkReal(-1.00000000000000))*(x656)*(x673)))+(((r02)*(x640)*(x644)))+(((IkReal(0.0956250000000000))*(r01)*(x633)))+(((IkReal(-0.0120000000000000))*(x673)))+(((IkReal(-1.00000000000000))*(pp)*(x648)))+(((x648)*(x676)))+(((IkReal(0.0843750000000000))*(x648)))+(((pz)*(x639)*(x651)))+(((x667)*(x674)))+(((IkReal(-0.150000000000000))*(px)*(x635))));
evalcond[7]=((((IkReal(-1.00000000000000))*(x636)*(x673)))+(((IkReal(-1.00000000000000))*(cj0)*(x642)*(x649)))+(((IkReal(-1.00000000000000))*(x641)*(x654)))+(((IkReal(-1.00000000000000))*(x642)*(x668)))+(((IkReal(-1.00000000000000))*(r02)*(x633)*(x640)))+(((cj0)*(x635)*(x659)))+(((IkReal(0.0450000000000000))*(r02)))+(((cj1)*(x679)))+(((IkReal(-1.00000000000000))*(pp)*(x660)*(x661)))+(((IkReal(-1.00000000000000))*(x667)*(x673)))+(((IkReal(-1.00000000000000))*(pp)*(x634)*(x644)))+(((sj0)*(x639)*(x678)))+(((IkReal(-0.0843750000000000))*(sj0)*(x639)))+(((x639)*(x647)*(x670)))+(((IkReal(-1.00000000000000))*(x653)*(x676)))+(((cj1)*(r00)*(x631)*(x647)))+(((IkReal(0.0956250000000000))*(x653)))+(((x652)*(x674)))+(((x644)*(x650)*(x651)))+(((r01)*(x633)*(x659)))+(((IkReal(-1.00000000000000))*(pz)*(x635)*(x672)))+(((IkReal(-0.0512000000000000))*(x673)))+(((IkReal(-1.00000000000000))*(x639)*(x640)))+(((IkReal(-1.00000000000000))*(x650)*(x654)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x662)))+(((x641)*(x644)*(x651)))+(((pp)*(x653)))+(((IkReal(-1.00000000000000))*(x656)*(x674)))+(((IkReal(-0.0843750000000000))*(cj1)*(x661)))+(((x645)*(x668)))+(((IkReal(-0.0120000000000000))*(x674)))+(((IkReal(0.600000000000000))*(pz)*(x671)))+(((IkReal(-1.00000000000000))*(pz)*(x651)*(x657))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  || IKabs(evalcond[6]) > 0.000001  || IKabs(evalcond[7]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x680=((IkReal(1.00000000000000))*(cj1));
IkReal x681=((cj0)*(r00));
IkReal x682=((cj3)*(r02));
IkReal x683=((sj1)*(sj3));
IkReal x684=((r01)*(sj0));
IkReal x685=((cj3)*(x684));
if( IKabs(((gconst2)*(((((IkReal(-1.00000000000000))*(x683)*(x684)))+(((IkReal(-1.00000000000000))*(cj3)*(x680)*(x681)))+(((IkReal(-1.00000000000000))*(x680)*(x685)))+(((IkReal(-1.00000000000000))*(r02)*(sj3)*(x680)))+(((IkReal(-1.00000000000000))*(x681)*(x683)))+(((sj1)*(x682))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst2)*(((((IkReal(-1.00000000000000))*(sj3)*(x680)*(x684)))+(((cj3)*(sj1)*(x681)))+(((cj1)*(x682)))+(((IkReal(-1.00000000000000))*(sj3)*(x680)*(x681)))+(((r02)*(x683)))+(((sj1)*(x685))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst2)*(((((IkReal(-1.00000000000000))*(x683)*(x684)))+(((IkReal(-1.00000000000000))*(cj3)*(x680)*(x681)))+(((IkReal(-1.00000000000000))*(x680)*(x685)))+(((IkReal(-1.00000000000000))*(r02)*(sj3)*(x680)))+(((IkReal(-1.00000000000000))*(x681)*(x683)))+(((sj1)*(x682)))))), ((gconst2)*(((((IkReal(-1.00000000000000))*(sj3)*(x680)*(x684)))+(((cj3)*(sj1)*(x681)))+(((cj1)*(x682)))+(((IkReal(-1.00000000000000))*(sj3)*(x680)*(x681)))+(((r02)*(x683)))+(((sj1)*(x685)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x686=IKcos(j2);
IkReal x687=IKsin(j2);
IkReal x688=(py)*(py);
IkReal x689=(px)*(px);
IkReal x690=(pz)*(pz);
IkReal x691=((sj0)*(sj1));
IkReal x692=((IkReal(1.00000000000000))*(r01));
IkReal x693=((r00)*(sj1));
IkReal x694=((IkReal(0.0480000000000000))*(sj3));
IkReal x695=((IkReal(0.0750000000000000))*(r00));
IkReal x696=((IkReal(0.0800000000000000))*(sj3));
IkReal x697=((cj1)*(r01));
IkReal x698=((IkReal(0.150000000000000))*(py));
IkReal x699=((pz)*(r02));
IkReal x700=((px)*(r02));
IkReal x701=((IkReal(0.0750000000000000))*(sj4));
IkReal x702=((cj1)*(sj0));
IkReal x703=((pz)*(r00));
IkReal x704=((IkReal(0.0750000000000000))*(cj0));
IkReal x705=((IkReal(2.00000000000000))*(cj0));
IkReal x706=((cj1)*(r02));
IkReal x707=((IkReal(0.150000000000000))*(sj1));
IkReal x708=((px)*(r00));
IkReal x709=((IkReal(2.00000000000000))*(py));
IkReal x710=((IkReal(0.0903750000000000))*(sj3));
IkReal x711=((r02)*(sj1));
IkReal x712=((IkReal(0.150000000000000))*(cj1));
IkReal x713=((cj0)*(py));
IkReal x714=((IkReal(0.0480000000000000))*(cj3));
IkReal x715=((r01)*(sj1));
IkReal x716=((IkReal(0.0800000000000000))*(cj3));
IkReal x717=((IkReal(0.150000000000000))*(pz));
IkReal x718=((IkReal(1.00000000000000))*(cj1));
IkReal x719=((cj0)*(r00));
IkReal x720=((IkReal(0.600000000000000))*(py));
IkReal x721=((IkReal(1.00000000000000))*(py));
IkReal x722=((px)*(sj1));
IkReal x723=((IkReal(1.00000000000000))*(cj0));
IkReal x724=((cj0)*(pz));
IkReal x725=((IkReal(0.103175000000000))*(cj3));
IkReal x726=((IkReal(0.600000000000000))*(cj0));
IkReal x727=((IkReal(1.00000000000000))*(sj3));
IkReal x728=((px)*(py));
IkReal x729=((r01)*(sj0));
IkReal x730=((IkReal(2.00000000000000))*(px));
IkReal x731=((cj4)*(x687));
IkReal x732=((cj4)*(x686));
IkReal x733=((sj4)*(x687));
IkReal x734=((IkReal(2.00000000000000))*(x690));
IkReal x735=((sj4)*(x686));
IkReal x736=((IkReal(2.00000000000000))*(x688));
IkReal x737=((px)*(x699)*(x705));
evalcond[0]=((((IkReal(-1.00000000000000))*(x718)*(x719)))+(((IkReal(-1.00000000000000))*(x727)*(x732)))+(((IkReal(-1.00000000000000))*(cj3)*(x731)))+(x711)+(((IkReal(-1.00000000000000))*(x692)*(x702))));
evalcond[1]=((((cj3)*(x732)))+(((IkReal(-1.00000000000000))*(x693)*(x723)))+(((IkReal(-1.00000000000000))*(x691)*(x692)))+(((IkReal(-1.00000000000000))*(x727)*(x731)))+(((IkReal(-1.00000000000000))*(x706))));
evalcond[2]=((((IkReal(-0.0750000000000000))*(x687)))+(((IkReal(-1.00000000000000))*(x702)*(x721)))+(((x686)*(x716)))+(((pz)*(sj1)))+(((IkReal(0.320000000000000))*(x686)))+(((IkReal(-1.00000000000000))*(x687)*(x696)))+(((IkReal(-1.00000000000000))*(cj0)*(px)*(x718)))+(((IkReal(0.0750000000000000))*(cj1))));
evalcond[3]=((IkReal(0.300000000000000))+(((IkReal(-1.00000000000000))*(x691)*(x721)))+(((IkReal(0.320000000000000))*(x687)))+(((IkReal(-1.00000000000000))*(x722)*(x723)))+(((IkReal(0.0750000000000000))*(x686)))+(((x686)*(x696)))+(((IkReal(-1.00000000000000))*(pz)*(x718)))+(((x687)*(x716)))+(((IkReal(0.0750000000000000))*(sj1))));
evalcond[4]=((((px)*(x697)))+(((IkReal(-1.00000000000000))*(x691)*(x700)))+(((x695)*(x702)))+(((IkReal(-1.00000000000000))*(py)*(r00)*(x718)))+(((IkReal(-0.320000000000000))*(x735)))+(((IkReal(-1.00000000000000))*(sj1)*(x692)*(x724)))+(((x687)*(x701)))+(((IkReal(-1.00000000000000))*(x697)*(x704)))+(((x711)*(x713)))+(((x696)*(x733)))+(((IkReal(-1.00000000000000))*(x716)*(x735)))+(((x691)*(x703))));
evalcond[5]=((((IkReal(0.320000000000000))*(x733)))+(((x702)*(x703)))+(((x706)*(x713)))+(((IkReal(-1.00000000000000))*(x692)*(x722)))+(((x696)*(x735)))+(((IkReal(-1.00000000000000))*(cj1)*(x692)*(x724)))+(((IkReal(-0.300000000000000))*(r00)*(sj0)))+(((x704)*(x715)))+(((py)*(x693)))+(((IkReal(-1.00000000000000))*(x700)*(x702)))+(((x716)*(x733)))+(((IkReal(0.300000000000000))*(cj0)*(r01)))+(((IkReal(-1.00000000000000))*(x691)*(x695)))+(((x686)*(x701))));
evalcond[6]=((((IkReal(-1.00000000000000))*(pp)*(x693)*(x723)))+(((IkReal(0.0956250000000000))*(cj0)*(x693)))+(((x706)*(x734)))+(((IkReal(-0.600000000000000))*(x699)))+(((IkReal(0.0512000000000000))*(x732)))+(((IkReal(-0.150000000000000))*(px)*(x693)))+(((x691)*(x699)*(x709)))+(((pz)*(x697)*(x709)))+(((r02)*(x698)*(x702)))+(((r01)*(x691)*(x736)))+(((IkReal(-1.00000000000000))*(x698)*(x715)))+(((IkReal(-1.00000000000000))*(sj0)*(x697)*(x717)))+(((x694)*(x732)))+(((x705)*(x715)*(x728)))+(((cj0)*(x700)*(x712)))+(((x689)*(x693)*(x705)))+(((IkReal(0.0450000000000000))*(x729)))+(((IkReal(-0.0120000000000000))*(x731)))+(((IkReal(0.0956250000000000))*(r01)*(x691)))+(((IkReal(-1.00000000000000))*(x714)*(x731)))+(((IkReal(-0.600000000000000))*(x708)))+(((x725)*(x732)))+(((IkReal(-1.00000000000000))*(pp)*(x691)*(x692)))+(((x691)*(x708)*(x709)))+(((IkReal(0.0843750000000000))*(x706)))+(((IkReal(-1.00000000000000))*(cj0)*(x703)*(x712)))+(((x699)*(x705)*(x722)))+(((x710)*(x731)))+(((cj1)*(x703)*(x730)))+(((IkReal(0.0450000000000000))*(x719)))+(((IkReal(-1.00000000000000))*(r01)*(x720)))+(((IkReal(-1.00000000000000))*(pp)*(x706)))+(((IkReal(-1.00000000000000))*(x699)*(x707))));
evalcond[7]=((((IkReal(0.0956250000000000))*(x711)))+(((x702)*(x708)*(x709)))+(((IkReal(-0.0512000000000000))*(x731)))+(((IkReal(-1.00000000000000))*(x699)*(x712)))+(((IkReal(-1.00000000000000))*(pp)*(x692)*(x702)))+(((IkReal(0.0450000000000000))*(r02)))+(((x699)*(x702)*(x709)))+(((cj1)*(x737)))+(((IkReal(-1.00000000000000))*(cj0)*(x700)*(x707)))+(((IkReal(-1.00000000000000))*(pp)*(x718)*(x719)))+(((cj0)*(x693)*(x717)))+(((IkReal(-0.0843750000000000))*(sj0)*(x697)))+(((IkReal(-1.00000000000000))*(pz)*(x709)*(x715)))+(((pp)*(x711)))+(((r01)*(x691)*(x717)))+(((IkReal(-1.00000000000000))*(pz)*(x693)*(x730)))+(((x697)*(x705)*(x728)))+(((IkReal(-1.00000000000000))*(x714)*(x732)))+(((sj0)*(x697)*(x736)))+(((IkReal(-0.0120000000000000))*(x732)))+(((IkReal(-1.00000000000000))*(x697)*(x698)))+(((IkReal(-1.00000000000000))*(x711)*(x734)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x720)))+(((cj1)*(r00)*(x689)*(x705)))+(((IkReal(-1.00000000000000))*(x725)*(x731)))+(((IkReal(0.600000000000000))*(pz)*(x729)))+(((IkReal(-1.00000000000000))*(x694)*(x731)))+(((IkReal(-0.0843750000000000))*(cj1)*(x719)))+(((IkReal(-1.00000000000000))*(x708)*(x712)))+(((x710)*(x732)))+(((IkReal(-1.00000000000000))*(r02)*(x691)*(x698)))+(((IkReal(-1.00000000000000))*(x700)*(x726)))+(((x703)*(x726))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  || IKabs(evalcond[6]) > 0.000001  || IKabs(evalcond[7]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x738=((r01)*(sj0));
IkReal x739=((cj0)*(sj1));
IkReal x740=((cj4)*(px));
IkReal x741=((cj0)*(r00));
IkReal x742=((cj4)*(pp));
IkReal x743=((cj1)*(r02));
IkReal x744=((pz)*(r02));
IkReal x745=((cj4)*(sj1));
IkReal x746=((px)*(r00));
IkReal x747=((py)*(r01));
IkReal x748=((cj4)*(py)*(sj0));
IkReal x749=((cj1)*(cj4)*(pz));
if( IKabs(((gconst0)*(((((IkReal(3840.00000000000))*(r00)*(x739)))+(((IkReal(3840.00000000000))*(sj1)*(x738)))+(((IkReal(-12800.0000000000))*(x747)))+(((IkReal(-12800.0000000000))*(x744)))+(((IkReal(-2812.50000000000))*(x748)))+(((IkReal(-352.500000000000))*(cj4)))+(((IkReal(960.000000000000))*(x738)))+(((IkReal(843.750000000000))*(x745)))+(((IkReal(3840.00000000000))*(x743)))+(((IkReal(-12800.0000000000))*(x746)))+(((IkReal(-11250.0000000000))*(x749)))+(((IkReal(-2812.50000000000))*(cj0)*(x740)))+(((IkReal(-11250.0000000000))*(x739)*(x740)))+(((IkReal(960.000000000000))*(x741)))+(((IkReal(18750.0000000000))*(x742)))+(((IkReal(-11250.0000000000))*(py)*(sj0)*(x745))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst0)*(((((IkReal(-12000.0000000000))*(cj0)*(x740)))+(((IkReal(-900.000000000000))*(r00)*(x739)))+(((IkReal(-12000.0000000000))*(x748)))+(((IkReal(-48000.0000000000))*(x739)*(x740)))+(((IkReal(-48000.0000000000))*(py)*(sj0)*(x745)))+(((IkReal(3000.00000000000))*(x747)))+(((IkReal(-48000.0000000000))*(x749)))+(((IkReal(-900.000000000000))*(sj1)*(x738)))+(((IkReal(-225.000000000000))*(x741)))+(((IkReal(3000.00000000000))*(x746)))+(((IkReal(3000.00000000000))*(x744)))+(((IkReal(-900.000000000000))*(x743)))+(((IkReal(80000.0000000000))*(x742)))+(((IkReal(-225.000000000000))*(x738)))+(((IkReal(3600.00000000000))*(x745)))+(((IkReal(-1504.00000000000))*(cj4))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst0)*(((((IkReal(3840.00000000000))*(r00)*(x739)))+(((IkReal(3840.00000000000))*(sj1)*(x738)))+(((IkReal(-12800.0000000000))*(x747)))+(((IkReal(-12800.0000000000))*(x744)))+(((IkReal(-2812.50000000000))*(x748)))+(((IkReal(-352.500000000000))*(cj4)))+(((IkReal(960.000000000000))*(x738)))+(((IkReal(843.750000000000))*(x745)))+(((IkReal(3840.00000000000))*(x743)))+(((IkReal(-12800.0000000000))*(x746)))+(((IkReal(-11250.0000000000))*(x749)))+(((IkReal(-2812.50000000000))*(cj0)*(x740)))+(((IkReal(-11250.0000000000))*(x739)*(x740)))+(((IkReal(960.000000000000))*(x741)))+(((IkReal(18750.0000000000))*(x742)))+(((IkReal(-11250.0000000000))*(py)*(sj0)*(x745)))))), ((gconst0)*(((((IkReal(-12000.0000000000))*(cj0)*(x740)))+(((IkReal(-900.000000000000))*(r00)*(x739)))+(((IkReal(-12000.0000000000))*(x748)))+(((IkReal(-48000.0000000000))*(x739)*(x740)))+(((IkReal(-48000.0000000000))*(py)*(sj0)*(x745)))+(((IkReal(3000.00000000000))*(x747)))+(((IkReal(-48000.0000000000))*(x749)))+(((IkReal(-900.000000000000))*(sj1)*(x738)))+(((IkReal(-225.000000000000))*(x741)))+(((IkReal(3000.00000000000))*(x746)))+(((IkReal(3000.00000000000))*(x744)))+(((IkReal(-900.000000000000))*(x743)))+(((IkReal(80000.0000000000))*(x742)))+(((IkReal(-225.000000000000))*(x738)))+(((IkReal(3600.00000000000))*(x745)))+(((IkReal(-1504.00000000000))*(cj4)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x750=IKcos(j3);
IkReal x751=IKsin(j3);
IkReal x752=((r01)*(sj0));
IkReal x753=((IkReal(0.300000000000000))*(r02));
IkReal x754=((r00)*(sj0));
IkReal x755=((py)*(sj0));
IkReal x756=((IkReal(0.600000000000000))*(cj1));
IkReal x757=((IkReal(0.150000000000000))*(px));
IkReal x758=((IkReal(0.320000000000000))*(cj4));
IkReal x759=((IkReal(1.00000000000000))*(pz));
IkReal x760=((py)*(r00));
IkReal x761=((IkReal(0.300000000000000))*(cj1));
IkReal x762=((IkReal(1.00000000000000))*(pp));
IkReal x763=((cj0)*(r00));
IkReal x764=((IkReal(0.0450000000000000))*(sj1));
IkReal x765=((IkReal(0.600000000000000))*(sj1));
IkReal x766=((IkReal(0.0750000000000000))*(cj4));
IkReal x767=((cj0)*(r01));
IkReal x768=((IkReal(2.00000000000000))*(pz));
IkReal x769=((cj0)*(px));
IkReal x770=((IkReal(0.300000000000000))*(sj1));
IkReal x771=((IkReal(2.00000000000000))*(px)*(py));
IkReal x772=((IkReal(0.0120000000000000))*(x751));
IkReal x773=((IkReal(0.0512000000000000))*(x750));
IkReal x774=((cj0)*(py)*(r02));
IkReal x775=((px)*(r02)*(sj0));
evalcond[0]=((IkReal(0.0188000000000000))+(((cj0)*(x757)))+(((pz)*(x756)))+(((IkReal(0.150000000000000))*(x755)))+(((x755)*(x765)))+(((IkReal(-1.00000000000000))*(x762)))+(x773)+(x772)+(((IkReal(-1.00000000000000))*(x764)))+(((x765)*(x769))));
evalcond[1]=((((IkReal(-1.00000000000000))*(py)*(r01)))+(((x752)*(x770)))+(((IkReal(0.0750000000000000))*(x763)))+(((IkReal(-1.00000000000000))*(px)*(r00)))+(((cj1)*(x753)))+(((x750)*(x766)))+(((IkReal(0.0750000000000000))*(x752)))+(((IkReal(-1.00000000000000))*(r02)*(x759)))+(((x763)*(x770)))+(((IkReal(-1.00000000000000))*(x751)*(x758))));
evalcond[2]=((((IkReal(-0.0800000000000000))*(cj4)))+(((r02)*(x769)))+(((x752)*(x761)))+(((IkReal(-1.00000000000000))*(x759)*(x763)))+(((r02)*(x755)))+(((IkReal(-1.00000000000000))*(sj1)*(x753)))+(((IkReal(-1.00000000000000))*(x752)*(x759)))+(((x761)*(x763)))+(((IkReal(-0.0750000000000000))*(r02)))+(((IkReal(-1.00000000000000))*(x751)*(x766)))+(((IkReal(-1.00000000000000))*(x750)*(x758))));
evalcond[3]=((((pp)*(x767)))+(((x752)*(x771)))+(((IkReal(-1.00000000000000))*(x754)*(x764)))+(((IkReal(-1.00000000000000))*(r01)*(x757)))+(((pz)*(x754)*(x756)))+(((IkReal(0.150000000000000))*(x760)))+(((IkReal(-1.00000000000000))*(x754)*(x762)))+(((IkReal(-2.00000000000000))*(x760)*(x769)))+(((IkReal(-1.00000000000000))*(pz)*(x756)*(x767)))+(((IkReal(-1.00000000000000))*(x768)*(x774)))+(((x756)*(x774)))+(((IkReal(-1.00000000000000))*(sj4)*(x772)))+(((IkReal(0.0956250000000000))*(x767)))+(((IkReal(-2.00000000000000))*(x767)*((py)*(py))))+(((IkReal(-0.114425000000000))*(sj4)))+(((IkReal(-1.00000000000000))*(sj4)*(x773)))+(((x768)*(x775)))+(((IkReal(2.00000000000000))*(x754)*((px)*(px))))+(((IkReal(-0.0956250000000000))*(x754)))+(((IkReal(-1.00000000000000))*(px)*(r01)*(x765)))+(((x760)*(x765)))+(((IkReal(-1.00000000000000))*(x756)*(x775)))+(((x764)*(x767))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst2;
gconst2=IKsign(((((cj4)*((cj3)*(cj3))))+(((cj4)*((sj3)*(sj3))))));
dummyeval[0]=((((cj4)*((cj3)*(cj3))))+(((cj4)*((sj3)*(sj3)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst3;
IkReal x776=((IkReal(0.0800000000000000))*(cj4));
gconst3=IKsign(((((IkReal(0.320000000000000))*(cj3)*(cj4)))+(((IkReal(0.0750000000000000))*(cj4)*(sj3)))+(((x776)*((sj3)*(sj3))))+(((x776)*((cj3)*(cj3))))));
IkReal x777=((IkReal(1.06666666666667))*(cj4));
dummyeval[0]=((((IkReal(4.26666666666667))*(cj3)*(cj4)))+(((x777)*((cj3)*(cj3))))+(((x777)*((sj3)*(sj3))))+(((cj4)*(sj3))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[11];
IkReal x778=((IkReal(0.0512000000000000))*(cj3));
IkReal x779=((IkReal(0.0120000000000000))*(sj3));
IkReal x780=(py)*(py);
IkReal x781=(px)*(px);
IkReal x782=(pz)*(pz);
IkReal x783=((r01)*(sj0));
IkReal x784=((py)*(r00));
IkReal x785=((pz)*(sj1));
IkReal x786=((py)*(r01));
IkReal x787=((px)*(sj0));
IkReal x788=((IkReal(0.600000000000000))*(r02));
IkReal x789=((IkReal(0.150000000000000))*(cj1));
IkReal x790=((cj0)*(sj1));
IkReal x791=((IkReal(0.150000000000000))*(px));
IkReal x792=((IkReal(2.00000000000000))*(cj1));
IkReal x793=((cj0)*(r01));
IkReal x794=((r02)*(sj1));
IkReal x795=((px)*(r00));
IkReal x796=((IkReal(0.300000000000000))*(r00));
IkReal x797=((IkReal(1.00000000000000))*(pz));
IkReal x798=((r00)*(sj1));
IkReal x799=((cj0)*(r00));
IkReal x800=((cj0)*(cj1));
IkReal x801=((IkReal(1.00000000000000))*(sj1));
IkReal x802=((IkReal(0.0956250000000000))*(r00));
IkReal x803=((IkReal(0.600000000000000))*(pz));
IkReal x804=((IkReal(0.600000000000000))*(sj1));
IkReal x805=((IkReal(2.00000000000000))*(px));
IkReal x806=((IkReal(2.00000000000000))*(sj1));
IkReal x807=((IkReal(0.150000000000000))*(sj1));
IkReal x808=((cj1)*(r02));
IkReal x809=((cj0)*(px));
IkReal x810=((IkReal(0.0843750000000000))*(cj1));
IkReal x811=((py)*(sj0));
IkReal x812=((pz)*(r02));
IkReal x813=((IkReal(1.00000000000000))*(cj1));
IkReal x814=((cj0)*(py));
IkReal x815=((r00)*(sj0));
IkReal x816=((r02)*(x811));
IkReal x817=((pp)*(x813));
IkReal x818=((IkReal(1.00000000000000))*(pp)*(r00));
IkReal x819=((x779)+(x778));
IkReal x820=((IkReal(2.00000000000000))*(r00)*(x781));
IkReal x821=((cj0)*(x805)*(x812));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j4)), IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x787)))+(x814));
evalcond[2]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(x815)))+(x793));
evalcond[3]=((((IkReal(-1.00000000000000))*(x799)*(x813)))+(x794)+(((IkReal(-1.00000000000000))*(x783)*(x813))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x808)))+(((IkReal(-1.00000000000000))*(r00)*(x790)))+(((IkReal(-1.00000000000000))*(x783)*(x801))));
evalcond[5]=((IkReal(0.0188000000000000))+(((cj0)*(x791)))+(((x804)*(x811)))+(((IkReal(-1.00000000000000))*(pp)))+(((cj1)*(x803)))+(((IkReal(0.150000000000000))*(x811)))+(((IkReal(0.600000000000000))*(px)*(x790)))+(x819)+(((IkReal(-0.0450000000000000))*(sj1))));
evalcond[6]=((((IkReal(-1.00000000000000))*(r02)*(x797)))+(((IkReal(0.0750000000000000))*(x783)))+(((IkReal(-1.00000000000000))*(x786)))+(((IkReal(0.300000000000000))*(x808)))+(((IkReal(0.300000000000000))*(sj1)*(x783)))+(((IkReal(0.0750000000000000))*(x799)))+(((x790)*(x796)))+(((IkReal(-1.00000000000000))*(x795))));
evalcond[7]=((((r02)*(x809)))+(((IkReal(0.300000000000000))*(cj1)*(x783)))+(((IkReal(-1.00000000000000))*(x797)*(x799)))+(((IkReal(-1.00000000000000))*(x783)*(x797)))+(((IkReal(-0.300000000000000))*(x794)))+(((IkReal(-0.0750000000000000))*(r02)))+(x816)+(((x796)*(x800))));
evalcond[8]=((IkReal(-0.114425000000000))+(((pp)*(x793)))+(((IkReal(2.00000000000000))*(x787)*(x812)))+(((IkReal(0.0450000000000000))*(r01)*(x790)))+(((IkReal(-0.0450000000000000))*(sj0)*(x798)))+(((IkReal(-1.00000000000000))*(cj1)*(x787)*(x788)))+(((cj1)*(x803)*(x815)))+(((IkReal(2.00000000000000))*(x781)*(x815)))+(((IkReal(-1.00000000000000))*(r01)*(x791)))+(((IkReal(-2.00000000000000))*(x780)*(x793)))+(((IkReal(0.0956250000000000))*(x793)))+(((IkReal(-2.00000000000000))*(x812)*(x814)))+(((IkReal(-1.00000000000000))*(px)*(r01)*(x804)))+(((IkReal(-1.00000000000000))*(x819)))+(((IkReal(0.150000000000000))*(x784)))+(((x784)*(x804)))+(((IkReal(-1.00000000000000))*(pp)*(x815)))+(((IkReal(-1.00000000000000))*(sj0)*(x802)))+(((py)*(x783)*(x805)))+(((py)*(x788)*(x800)))+(((IkReal(-1.00000000000000))*(cj0)*(x784)*(x805)))+(((IkReal(-1.00000000000000))*(cj1)*(x793)*(x803))));
evalcond[9]=((((IkReal(0.0843750000000000))*(x808)))+(((r02)*(x789)*(x809)))+(((IkReal(-1.00000000000000))*(pz)*(x789)*(x799)))+(((IkReal(-1.00000000000000))*(pp)*(x783)*(x801)))+(((IkReal(-0.600000000000000))*(x786)))+(((x790)*(x802)))+(((x780)*(x783)*(x806)))+(((r02)*(x782)*(x792)))+(((IkReal(-1.00000000000000))*(pp)*(x808)))+(((pz)*(x786)*(x792)))+(((IkReal(-1.00000000000000))*(pz)*(x788)))+(((x789)*(x816)))+(((cj0)*(r02)*(x785)*(x805)))+(((IkReal(2.00000000000000))*(x785)*(x816)))+(((x784)*(x787)*(x806)))+(((IkReal(-1.00000000000000))*(pz)*(x783)*(x789)))+(((IkReal(-0.150000000000000))*(r02)*(x785)))+(((IkReal(0.0450000000000000))*(x799)))+(((pz)*(x792)*(x795)))+(((IkReal(-1.00000000000000))*(x791)*(x798)))+(((x790)*(x820)))+(((IkReal(-1.00000000000000))*(x786)*(x807)))+(((IkReal(-1.00000000000000))*(x790)*(x818)))+(((IkReal(-0.600000000000000))*(x795)))+(((x786)*(x790)*(x805)))+(((IkReal(0.0956250000000000))*(sj1)*(x783)))+(((IkReal(0.0450000000000000))*(x783))));
evalcond[10]=((((x783)*(x803)))+(((IkReal(-1.00000000000000))*(x783)*(x810)))+(((x784)*(x787)*(x792)))+(((x799)*(x803)))+(((IkReal(0.0450000000000000))*(r02)))+(((IkReal(-1.00000000000000))*(x788)*(x811)))+(((IkReal(-1.00000000000000))*(r02)*(x790)*(x791)))+(((IkReal(-1.00000000000000))*(x799)*(x810)))+(((IkReal(-2.00000000000000))*(x785)*(x786)))+(((pp)*(x794)))+(((IkReal(0.0956250000000000))*(x794)))+(((IkReal(-1.00000000000000))*(x789)*(x795)))+(((IkReal(-1.00000000000000))*(x783)*(x817)))+(((IkReal(0.150000000000000))*(x785)*(x799)))+(((IkReal(-1.00000000000000))*(x799)*(x817)))+(((x781)*(x792)*(x799)))+(((IkReal(-1.00000000000000))*(x786)*(x789)))+(((IkReal(-2.00000000000000))*(x782)*(x794)))+(((IkReal(-0.150000000000000))*(x794)*(x811)))+(((IkReal(-2.00000000000000))*(x785)*(x795)))+(((x786)*(x792)*(x809)))+(((x792)*(x811)*(x812)))+(((IkReal(-1.00000000000000))*(x789)*(x812)))+(((x780)*(x783)*(x792)))+(((x792)*(x809)*(x812)))+(((IkReal(0.150000000000000))*(x783)*(x785)))+(((IkReal(-1.00000000000000))*(x788)*(x809))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  && IKabs(evalcond[9]) < 0.0000010000000000  && IKabs(evalcond[10]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst4;
gconst4=IKsign(((IkReal(0.108025000000000))+(((IkReal(0.0512000000000000))*(cj3)))+(((IkReal(0.00640000000000000))*((sj3)*(sj3))))+(((IkReal(0.00640000000000000))*((cj3)*(cj3))))+(((IkReal(0.0120000000000000))*(sj3)))));
dummyeval[0]=((IkReal(16.8789062500000))+((cj3)*(cj3))+(((IkReal(1.87500000000000))*(sj3)))+((sj3)*(sj3))+(((IkReal(8.00000000000000))*(cj3))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst5;
gconst5=IKsign(((IkReal(0.108025000000000))+(((IkReal(0.0512000000000000))*(cj3)))+(((IkReal(0.00640000000000000))*((sj3)*(sj3))))+(((IkReal(0.00640000000000000))*((cj3)*(cj3))))+(((IkReal(0.0120000000000000))*(sj3)))));
dummyeval[0]=((IkReal(16.8789062500000))+((cj3)*(cj3))+(((IkReal(1.87500000000000))*(sj3)))+((sj3)*(sj3))+(((IkReal(8.00000000000000))*(cj3))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x822=((r02)*(sj0));
IkReal x823=((IkReal(0.0800000000000000))*(sj1));
IkReal x824=((cj3)*(px));
IkReal x825=((cj0)*(r01));
IkReal x826=((IkReal(0.0240000000000000))*(cj1));
IkReal x827=((pz)*(sj3));
IkReal x828=((IkReal(0.00600000000000000))*(cj1));
IkReal x829=((IkReal(0.320000000000000))*(px));
IkReal x830=((cj0)*(sj1));
IkReal x831=((cj1)*(r01));
IkReal x832=((IkReal(0.0750000000000000))*(px));
IkReal x833=((IkReal(0.00562500000000000))*(cj1));
IkReal x834=((py)*(r02));
IkReal x835=((IkReal(0.0750000000000000))*(pz));
IkReal x836=((r00)*(sj0));
IkReal x837=((cj3)*(pz));
IkReal x838=((IkReal(0.320000000000000))*(py));
IkReal x839=((sj0)*(sj1));
IkReal x840=((IkReal(0.0800000000000000))*(cj1));
IkReal x841=((cj1)*(r00));
IkReal x842=((IkReal(0.0750000000000000))*(py));
IkReal x843=((cj3)*(py));
IkReal x844=((IkReal(0.00600000000000000))*(sj1));
IkReal x845=((py)*(sj3));
IkReal x846=((IkReal(0.320000000000000))*(pz)*(sj1));
IkReal x847=((px)*(sj3)*(x823));
if( IKabs(((gconst5)*(((IkReal(-0.0960000000000000))+(((IkReal(-0.0800000000000000))*(px)*(sj3)*(x831)))+(((sj0)*(x823)*(x843)))+(((IkReal(-1.00000000000000))*(sj1)*(x835)*(x836)))+(((x838)*(x839)))+(((x837)*(x840)))+(((IkReal(-1.00000000000000))*(cj0)*(sj3)*(x823)*(x834)))+(((IkReal(-1.00000000000000))*(x831)*(x832)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((sj1)*(x825)*(x835)))+(((sj3)*(x825)*(x828)))+(((IkReal(-0.0240000000000000))*(sj1)))+(((sj1)*(x822)*(x832)))+(((x841)*(x842)))+(((x825)*(x833)))+(((IkReal(-1.00000000000000))*(x833)*(x836)))+(((IkReal(-1.00000000000000))*(cj3)*(x844)))+(((IkReal(-1.00000000000000))*(sj3)*(x828)*(x836)))+(((IkReal(-1.00000000000000))*(x823)*(x827)*(x836)))+(((IkReal(0.320000000000000))*(cj1)*(pz)))+(((x829)*(x830)))+(((x823)*(x825)*(x827)))+(((r00)*(x840)*(x845)))+(((x822)*(x847)))+(((IkReal(-0.0750000000000000))*(x830)*(x834)))+(((cj0)*(x823)*(x824))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst5)*(((IkReal(-0.0225000000000000))+(((IkReal(-1.00000000000000))*(cj3)*(x825)*(x828)))+(((IkReal(-0.0240000000000000))*(sj3)))+(((IkReal(-1.00000000000000))*(x822)*(x823)*(x824)))+(((x830)*(x832)))+(((IkReal(-1.00000000000000))*(x825)*(x826)))+(((IkReal(-1.00000000000000))*(sj3)*(x844)))+(((x827)*(x840)))+(((IkReal(-1.00000000000000))*(sj1)*(x822)*(x829)))+(((x829)*(x831)))+(((x826)*(x836)))+(((cj1)*(x835)))+(((IkReal(-1.00000000000000))*(x838)*(x841)))+(((x839)*(x842)))+(((IkReal(-1.00000000000000))*(x823)*(x825)*(x837)))+(((x823)*(x836)*(x837)))+(((sj0)*(x823)*(x845)))+(((x836)*(x846)))+(((cj0)*(cj3)*(x823)*(x834)))+(((IkReal(-1.00000000000000))*(x825)*(x846)))+(((IkReal(-1.00000000000000))*(r00)*(x840)*(x843)))+(((IkReal(0.0800000000000000))*(x824)*(x831)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((cj3)*(x828)*(x836)))+(((cj0)*(x847)))+(((IkReal(0.320000000000000))*(x830)*(x834))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst5)*(((IkReal(-0.0960000000000000))+(((IkReal(-0.0800000000000000))*(px)*(sj3)*(x831)))+(((sj0)*(x823)*(x843)))+(((IkReal(-1.00000000000000))*(sj1)*(x835)*(x836)))+(((x838)*(x839)))+(((x837)*(x840)))+(((IkReal(-1.00000000000000))*(cj0)*(sj3)*(x823)*(x834)))+(((IkReal(-1.00000000000000))*(x831)*(x832)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((sj1)*(x825)*(x835)))+(((sj3)*(x825)*(x828)))+(((IkReal(-0.0240000000000000))*(sj1)))+(((sj1)*(x822)*(x832)))+(((x841)*(x842)))+(((x825)*(x833)))+(((IkReal(-1.00000000000000))*(x833)*(x836)))+(((IkReal(-1.00000000000000))*(cj3)*(x844)))+(((IkReal(-1.00000000000000))*(sj3)*(x828)*(x836)))+(((IkReal(-1.00000000000000))*(x823)*(x827)*(x836)))+(((IkReal(0.320000000000000))*(cj1)*(pz)))+(((x829)*(x830)))+(((x823)*(x825)*(x827)))+(((r00)*(x840)*(x845)))+(((x822)*(x847)))+(((IkReal(-0.0750000000000000))*(x830)*(x834)))+(((cj0)*(x823)*(x824)))))), ((gconst5)*(((IkReal(-0.0225000000000000))+(((IkReal(-1.00000000000000))*(cj3)*(x825)*(x828)))+(((IkReal(-0.0240000000000000))*(sj3)))+(((IkReal(-1.00000000000000))*(x822)*(x823)*(x824)))+(((x830)*(x832)))+(((IkReal(-1.00000000000000))*(x825)*(x826)))+(((IkReal(-1.00000000000000))*(sj3)*(x844)))+(((x827)*(x840)))+(((IkReal(-1.00000000000000))*(sj1)*(x822)*(x829)))+(((x829)*(x831)))+(((x826)*(x836)))+(((cj1)*(x835)))+(((IkReal(-1.00000000000000))*(x838)*(x841)))+(((x839)*(x842)))+(((IkReal(-1.00000000000000))*(x823)*(x825)*(x837)))+(((x823)*(x836)*(x837)))+(((sj0)*(x823)*(x845)))+(((x836)*(x846)))+(((cj0)*(cj3)*(x823)*(x834)))+(((IkReal(-1.00000000000000))*(x825)*(x846)))+(((IkReal(-1.00000000000000))*(r00)*(x840)*(x843)))+(((IkReal(0.0800000000000000))*(x824)*(x831)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((cj3)*(x828)*(x836)))+(((cj0)*(x847)))+(((IkReal(0.320000000000000))*(x830)*(x834)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x848=IKcos(j2);
IkReal x849=IKsin(j2);
IkReal x850=((IkReal(0.0800000000000000))*(sj3));
IkReal x851=((cj0)*(r01));
IkReal x852=((IkReal(1.00000000000000))*(px));
IkReal x853=((py)*(sj1));
IkReal x854=((cj0)*(r02));
IkReal x855=((IkReal(0.0750000000000000))*(cj1));
IkReal x856=((r02)*(sj0));
IkReal x857=((IkReal(0.0750000000000000))*(sj1));
IkReal x858=((cj1)*(pz));
IkReal x859=((r00)*(sj0));
IkReal x860=((IkReal(0.0800000000000000))*(cj3));
IkReal x861=((pz)*(sj1));
IkReal x862=((IkReal(1.00000000000000))*(sj0));
IkReal x863=((cj1)*(py));
IkReal x864=((IkReal(0.0750000000000000))*(x849));
IkReal x865=((IkReal(0.320000000000000))*(x848));
IkReal x866=((IkReal(0.320000000000000))*(x849));
IkReal x867=((IkReal(0.0750000000000000))*(x848));
IkReal x868=((sj1)*(x859));
IkReal x869=((x849)*(x850));
IkReal x870=((x848)*(x860));
IkReal x871=((x848)*(x850));
IkReal x872=((x849)*(x860));
IkReal x873=((x869)+(x864));
IkReal x874=((x865)+(x870));
IkReal x875=((x867)+(x866)+(x871)+(x872));
evalcond[0]=((((IkReal(-1.00000000000000))*(x862)*(x863)))+(x861)+(((IkReal(-1.00000000000000))*(cj0)*(cj1)*(x852)))+(x855)+(x874)+(((IkReal(-1.00000000000000))*(x873))));
evalcond[1]=((IkReal(0.300000000000000))+(((IkReal(-1.00000000000000))*(x858)))+(((IkReal(-1.00000000000000))*(cj0)*(sj1)*(x852)))+(((IkReal(-1.00000000000000))*(x853)*(x862)))+(x857)+(x875));
evalcond[2]=((((IkReal(-1.00000000000000))*(r00)*(x863)))+(((x859)*(x861)))+(((x855)*(x859)))+(((IkReal(-1.00000000000000))*(x874)))+(((x853)*(x854)))+(((IkReal(-1.00000000000000))*(sj1)*(x852)*(x856)))+(((IkReal(-1.00000000000000))*(x851)*(x861)))+(((cj1)*(px)*(r01)))+(((IkReal(-1.00000000000000))*(x851)*(x855)))+(x873));
evalcond[3]=((((IkReal(-1.00000000000000))*(x851)*(x858)))+(((IkReal(-1.00000000000000))*(cj1)*(x852)*(x856)))+(((r00)*(x853)))+(((x851)*(x857)))+(((IkReal(-1.00000000000000))*(r01)*(sj1)*(x852)))+(((IkReal(-1.00000000000000))*(x857)*(x859)))+(x875)+(((IkReal(0.300000000000000))*(x851)))+(((x854)*(x863)))+(((x858)*(x859)))+(((IkReal(-0.300000000000000))*(x859))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x876=((IkReal(0.0800000000000000))*(cj1));
IkReal x877=((cj0)*(px));
IkReal x878=((py)*(sj0));
IkReal x879=((IkReal(0.320000000000000))*(sj1));
IkReal x880=((IkReal(0.00600000000000000))*(cj3));
IkReal x881=((pz)*(sj3));
IkReal x882=((IkReal(0.0750000000000000))*(cj1));
IkReal x883=((IkReal(0.0800000000000000))*(sj1));
IkReal x884=((IkReal(0.0750000000000000))*(sj1));
IkReal x885=((IkReal(0.00600000000000000))*(sj3));
IkReal x886=((cj3)*(pz));
IkReal x887=((IkReal(0.320000000000000))*(cj1));
if( IKabs(((gconst4)*(((IkReal(-0.0960000000000000))+(((IkReal(-1.00000000000000))*(sj1)*(x880)))+(((IkReal(-1.00000000000000))*(sj3)*(x876)*(x878)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((IkReal(-0.0240000000000000))*(sj1)))+(((x877)*(x879)))+(((x881)*(x883)))+(((pz)*(x884)))+(((pz)*(x887)))+(((cj1)*(x885)))+(((IkReal(0.00562500000000000))*(cj1)))+(((x878)*(x879)))+(((cj3)*(x878)*(x883)))+(((x876)*(x886)))+(((IkReal(-1.00000000000000))*(sj3)*(x876)*(x877)))+(((IkReal(-1.00000000000000))*(x877)*(x882)))+(((cj3)*(x877)*(x883)))+(((IkReal(-1.00000000000000))*(x878)*(x882))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst4)*(((IkReal(-0.0225000000000000))+(((x876)*(x881)))+(((cj3)*(x876)*(x877)))+(((IkReal(-0.0240000000000000))*(sj3)))+(((IkReal(-1.00000000000000))*(x883)*(x886)))+(((sj3)*(x878)*(x883)))+(((x877)*(x887)))+(((sj3)*(x877)*(x883)))+(((x878)*(x884)))+(((cj3)*(x876)*(x878)))+(((IkReal(-1.00000000000000))*(cj1)*(x880)))+(((x877)*(x884)))+(((x878)*(x887)))+(((IkReal(-0.0240000000000000))*(cj1)))+(((pz)*(x882)))+(((IkReal(-1.00000000000000))*(sj1)*(x885)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(pz)*(x879))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst4)*(((IkReal(-0.0960000000000000))+(((IkReal(-1.00000000000000))*(sj1)*(x880)))+(((IkReal(-1.00000000000000))*(sj3)*(x876)*(x878)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((IkReal(-0.0240000000000000))*(sj1)))+(((x877)*(x879)))+(((x881)*(x883)))+(((pz)*(x884)))+(((pz)*(x887)))+(((cj1)*(x885)))+(((IkReal(0.00562500000000000))*(cj1)))+(((x878)*(x879)))+(((cj3)*(x878)*(x883)))+(((x876)*(x886)))+(((IkReal(-1.00000000000000))*(sj3)*(x876)*(x877)))+(((IkReal(-1.00000000000000))*(x877)*(x882)))+(((cj3)*(x877)*(x883)))+(((IkReal(-1.00000000000000))*(x878)*(x882)))))), ((gconst4)*(((IkReal(-0.0225000000000000))+(((x876)*(x881)))+(((cj3)*(x876)*(x877)))+(((IkReal(-0.0240000000000000))*(sj3)))+(((IkReal(-1.00000000000000))*(x883)*(x886)))+(((sj3)*(x878)*(x883)))+(((x877)*(x887)))+(((sj3)*(x877)*(x883)))+(((x878)*(x884)))+(((cj3)*(x876)*(x878)))+(((IkReal(-1.00000000000000))*(cj1)*(x880)))+(((x877)*(x884)))+(((x878)*(x887)))+(((IkReal(-0.0240000000000000))*(cj1)))+(((pz)*(x882)))+(((IkReal(-1.00000000000000))*(sj1)*(x885)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(pz)*(x879)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x888=IKcos(j2);
IkReal x889=IKsin(j2);
IkReal x890=((IkReal(0.0800000000000000))*(sj3));
IkReal x891=((cj0)*(r01));
IkReal x892=((IkReal(1.00000000000000))*(px));
IkReal x893=((py)*(sj1));
IkReal x894=((cj0)*(r02));
IkReal x895=((IkReal(0.0750000000000000))*(cj1));
IkReal x896=((r02)*(sj0));
IkReal x897=((IkReal(0.0750000000000000))*(sj1));
IkReal x898=((cj1)*(pz));
IkReal x899=((r00)*(sj0));
IkReal x900=((IkReal(0.0800000000000000))*(cj3));
IkReal x901=((pz)*(sj1));
IkReal x902=((IkReal(1.00000000000000))*(sj0));
IkReal x903=((cj1)*(py));
IkReal x904=((IkReal(0.0750000000000000))*(x889));
IkReal x905=((IkReal(0.320000000000000))*(x888));
IkReal x906=((IkReal(0.320000000000000))*(x889));
IkReal x907=((IkReal(0.0750000000000000))*(x888));
IkReal x908=((sj1)*(x899));
IkReal x909=((x889)*(x890));
IkReal x910=((x888)*(x900));
IkReal x911=((x888)*(x890));
IkReal x912=((x889)*(x900));
IkReal x913=((x904)+(x909));
IkReal x914=((x905)+(x910));
IkReal x915=((x906)+(x907)+(x912)+(x911));
evalcond[0]=((((IkReal(-1.00000000000000))*(x902)*(x903)))+(((IkReal(-1.00000000000000))*(cj0)*(cj1)*(x892)))+(((IkReal(-1.00000000000000))*(x913)))+(x901)+(x914)+(x895));
evalcond[1]=((IkReal(0.300000000000000))+(((IkReal(-1.00000000000000))*(cj0)*(sj1)*(x892)))+(((IkReal(-1.00000000000000))*(x893)*(x902)))+(((IkReal(-1.00000000000000))*(x898)))+(x915)+(x897));
evalcond[2]=((((x895)*(x899)))+(((IkReal(-1.00000000000000))*(x891)*(x895)))+(((IkReal(-1.00000000000000))*(x891)*(x901)))+(((cj1)*(px)*(r01)))+(((x893)*(x894)))+(((IkReal(-1.00000000000000))*(sj1)*(x892)*(x896)))+(((IkReal(-1.00000000000000))*(x914)))+(x913)+(((IkReal(-1.00000000000000))*(r00)*(x903)))+(((x899)*(x901))));
evalcond[3]=((((IkReal(-0.300000000000000))*(x899)))+(((IkReal(-1.00000000000000))*(x897)*(x899)))+(((IkReal(-1.00000000000000))*(r01)*(sj1)*(x892)))+(((IkReal(-1.00000000000000))*(x891)*(x898)))+(((x891)*(x897)))+(x915)+(((x894)*(x903)))+(((IkReal(-1.00000000000000))*(cj1)*(x892)*(x896)))+(((r00)*(x893)))+(((IkReal(0.300000000000000))*(x891)))+(((x898)*(x899))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
IkReal x916=((IkReal(0.0512000000000000))*(cj3));
IkReal x917=((IkReal(0.0120000000000000))*(sj3));
IkReal x918=(py)*(py);
IkReal x919=(px)*(px);
IkReal x920=(pz)*(pz);
IkReal x921=((r01)*(sj0));
IkReal x922=((py)*(r00));
IkReal x923=((pz)*(sj1));
IkReal x924=((py)*(r01));
IkReal x925=((px)*(sj0));
IkReal x926=((IkReal(0.600000000000000))*(r02));
IkReal x927=((IkReal(0.150000000000000))*(cj1));
IkReal x928=((cj0)*(sj1));
IkReal x929=((IkReal(0.150000000000000))*(px));
IkReal x930=((IkReal(2.00000000000000))*(cj1));
IkReal x931=((cj0)*(r01));
IkReal x932=((r02)*(sj1));
IkReal x933=((px)*(r00));
IkReal x934=((IkReal(0.300000000000000))*(r00));
IkReal x935=((IkReal(1.00000000000000))*(pz));
IkReal x936=((r00)*(sj1));
IkReal x937=((cj0)*(r00));
IkReal x938=((cj0)*(cj1));
IkReal x939=((IkReal(1.00000000000000))*(sj1));
IkReal x940=((IkReal(0.0956250000000000))*(r00));
IkReal x941=((IkReal(0.600000000000000))*(pz));
IkReal x942=((IkReal(0.600000000000000))*(sj1));
IkReal x943=((IkReal(2.00000000000000))*(px));
IkReal x944=((IkReal(2.00000000000000))*(sj1));
IkReal x945=((IkReal(0.150000000000000))*(sj1));
IkReal x946=((cj1)*(r02));
IkReal x947=((cj0)*(px));
IkReal x948=((IkReal(0.0843750000000000))*(cj1));
IkReal x949=((py)*(sj0));
IkReal x950=((pz)*(r02));
IkReal x951=((IkReal(1.00000000000000))*(cj1));
IkReal x952=((cj0)*(py));
IkReal x953=((r00)*(sj0));
IkReal x954=((r02)*(x949));
IkReal x955=((pp)*(x951));
IkReal x956=((IkReal(1.00000000000000))*(pp)*(r00));
IkReal x957=((x917)+(x916));
IkReal x958=((IkReal(2.00000000000000))*(r00)*(x919));
IkReal x959=((cj0)*(x943)*(x950));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j4)), IkReal(6.28318530717959))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x925)))+(x952));
evalcond[2]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x953)))+(x931));
evalcond[3]=((((IkReal(-1.00000000000000))*(x937)*(x951)))+(x932)+(((IkReal(-1.00000000000000))*(x921)*(x951))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r00)*(x928)))+(((IkReal(-1.00000000000000))*(x921)*(x939)))+(((IkReal(-1.00000000000000))*(x946))));
evalcond[5]=((IkReal(0.0188000000000000))+(((IkReal(0.150000000000000))*(x949)))+(((x942)*(x949)))+(((IkReal(-1.00000000000000))*(pp)))+(((IkReal(0.600000000000000))*(px)*(x928)))+(x957)+(((cj1)*(x941)))+(((cj0)*(x929)))+(((IkReal(-0.0450000000000000))*(sj1))));
evalcond[6]=((((IkReal(0.300000000000000))*(sj1)*(x921)))+(((IkReal(-1.00000000000000))*(r02)*(x935)))+(((IkReal(-1.00000000000000))*(x933)))+(((IkReal(0.300000000000000))*(x946)))+(((IkReal(-1.00000000000000))*(x924)))+(((IkReal(0.0750000000000000))*(x937)))+(((IkReal(0.0750000000000000))*(x921)))+(((x928)*(x934))));
evalcond[7]=((((IkReal(0.300000000000000))*(cj1)*(x921)))+(((IkReal(-1.00000000000000))*(x935)*(x937)))+(((r02)*(x947)))+(x954)+(((IkReal(-0.300000000000000))*(x932)))+(((IkReal(-0.0750000000000000))*(r02)))+(((x934)*(x938)))+(((IkReal(-1.00000000000000))*(x921)*(x935))));
evalcond[8]=((IkReal(0.114425000000000))+(((x922)*(x942)))+(((py)*(x921)*(x943)))+(((IkReal(-1.00000000000000))*(cj1)*(x931)*(x941)))+(((IkReal(-1.00000000000000))*(px)*(r01)*(x942)))+(((IkReal(-1.00000000000000))*(sj0)*(x940)))+(((IkReal(2.00000000000000))*(x925)*(x950)))+(((IkReal(0.150000000000000))*(x922)))+(((IkReal(-2.00000000000000))*(x918)*(x931)))+(((IkReal(-1.00000000000000))*(cj0)*(x922)*(x943)))+(((cj1)*(x941)*(x953)))+(((IkReal(2.00000000000000))*(x919)*(x953)))+(x957)+(((IkReal(-1.00000000000000))*(pp)*(x953)))+(((pp)*(x931)))+(((IkReal(0.0956250000000000))*(x931)))+(((IkReal(-0.0450000000000000))*(sj0)*(x936)))+(((IkReal(-2.00000000000000))*(x950)*(x952)))+(((py)*(x926)*(x938)))+(((IkReal(0.0450000000000000))*(r01)*(x928)))+(((IkReal(-1.00000000000000))*(r01)*(x929)))+(((IkReal(-1.00000000000000))*(cj1)*(x925)*(x926))));
evalcond[9]=((((x924)*(x928)*(x943)))+(((x928)*(x958)))+(((r02)*(x927)*(x947)))+(((IkReal(-0.600000000000000))*(x933)))+(((r02)*(x920)*(x930)))+(((IkReal(-1.00000000000000))*(x928)*(x956)))+(((IkReal(-1.00000000000000))*(pp)*(x921)*(x939)))+(((IkReal(2.00000000000000))*(x923)*(x954)))+(((x928)*(x940)))+(((x918)*(x921)*(x944)))+(((cj0)*(r02)*(x923)*(x943)))+(((x922)*(x925)*(x944)))+(((IkReal(-1.00000000000000))*(pz)*(x926)))+(((x927)*(x954)))+(((IkReal(-1.00000000000000))*(pz)*(x921)*(x927)))+(((IkReal(-1.00000000000000))*(x929)*(x936)))+(((pz)*(x924)*(x930)))+(((pz)*(x930)*(x933)))+(((IkReal(-1.00000000000000))*(pp)*(x946)))+(((IkReal(0.0956250000000000))*(sj1)*(x921)))+(((IkReal(-1.00000000000000))*(x924)*(x945)))+(((IkReal(0.0843750000000000))*(x946)))+(((IkReal(-0.150000000000000))*(r02)*(x923)))+(((IkReal(0.0450000000000000))*(x921)))+(((IkReal(-1.00000000000000))*(pz)*(x927)*(x937)))+(((IkReal(0.0450000000000000))*(x937)))+(((IkReal(-0.600000000000000))*(x924))));
evalcond[10]=((((IkReal(-1.00000000000000))*(x926)*(x947)))+(((IkReal(-1.00000000000000))*(x927)*(x933)))+(((x930)*(x949)*(x950)))+(((IkReal(-2.00000000000000))*(x923)*(x924)))+(((IkReal(0.0450000000000000))*(r02)))+(((IkReal(-1.00000000000000))*(x921)*(x955)))+(((pp)*(x932)))+(((IkReal(-1.00000000000000))*(x921)*(x948)))+(((IkReal(-2.00000000000000))*(x920)*(x932)))+(((IkReal(0.0956250000000000))*(x932)))+(((x921)*(x941)))+(((IkReal(0.150000000000000))*(x921)*(x923)))+(((IkReal(-1.00000000000000))*(x926)*(x949)))+(((x924)*(x930)*(x947)))+(((IkReal(0.150000000000000))*(x923)*(x937)))+(((IkReal(-1.00000000000000))*(x937)*(x948)))+(((x919)*(x930)*(x937)))+(((x930)*(x947)*(x950)))+(((IkReal(-1.00000000000000))*(x937)*(x955)))+(((x937)*(x941)))+(((x922)*(x925)*(x930)))+(((x918)*(x921)*(x930)))+(((IkReal(-0.150000000000000))*(x932)*(x949)))+(((IkReal(-1.00000000000000))*(x924)*(x927)))+(((IkReal(-1.00000000000000))*(x927)*(x950)))+(((IkReal(-1.00000000000000))*(r02)*(x928)*(x929)))+(((IkReal(-2.00000000000000))*(x923)*(x933))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  && IKabs(evalcond[9]) < 0.0000010000000000  && IKabs(evalcond[10]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst6;
gconst6=IKsign(((IkReal(0.108025000000000))+(((IkReal(0.0512000000000000))*(cj3)))+(((IkReal(0.00640000000000000))*((sj3)*(sj3))))+(((IkReal(0.00640000000000000))*((cj3)*(cj3))))+(((IkReal(0.0120000000000000))*(sj3)))));
dummyeval[0]=((IkReal(16.8789062500000))+((cj3)*(cj3))+(((IkReal(1.87500000000000))*(sj3)))+((sj3)*(sj3))+(((IkReal(8.00000000000000))*(cj3))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst7;
gconst7=IKsign(((IkReal(-0.108025000000000))+(((IkReal(-0.0512000000000000))*(cj3)))+(((IkReal(-0.00640000000000000))*((sj3)*(sj3))))+(((IkReal(-0.0120000000000000))*(sj3)))+(((IkReal(-0.00640000000000000))*((cj3)*(cj3))))));
dummyeval[0]=((IkReal(-16.8789062500000))+(((IkReal(-1.87500000000000))*(sj3)))+(((IkReal(-1.00000000000000))*((cj3)*(cj3))))+(((IkReal(-8.00000000000000))*(cj3)))+(((IkReal(-1.00000000000000))*((sj3)*(sj3)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x960=((r02)*(sj0));
IkReal x961=((IkReal(0.0800000000000000))*(sj1));
IkReal x962=((cj3)*(px));
IkReal x963=((cj0)*(r01));
IkReal x964=((IkReal(0.0240000000000000))*(cj1));
IkReal x965=((pz)*(sj3));
IkReal x966=((IkReal(0.00600000000000000))*(cj1));
IkReal x967=((IkReal(0.0750000000000000))*(sj1));
IkReal x968=((py)*(sj0));
IkReal x969=((IkReal(0.00562500000000000))*(cj1));
IkReal x970=((r00)*(sj0));
IkReal x971=((cj3)*(pz));
IkReal x972=((IkReal(0.320000000000000))*(sj1));
IkReal x973=((IkReal(0.0800000000000000))*(cj1));
IkReal x974=((IkReal(0.0750000000000000))*(cj1));
IkReal x975=((py)*(r00));
IkReal x976=((IkReal(0.320000000000000))*(cj1));
IkReal x977=((cj0)*(px));
IkReal x978=((IkReal(0.00600000000000000))*(sj1));
IkReal x979=((cj1)*(px)*(r01));
IkReal x980=((cj0)*(py)*(r02));
IkReal x981=((px)*(sj3)*(x961));
if( IKabs(((gconst7)*(((IkReal(0.0960000000000000))+(((IkReal(-1.00000000000000))*(x971)*(x973)))+(((IkReal(-1.00000000000000))*(sj3)*(x961)*(x980)))+(((IkReal(-1.00000000000000))*(x961)*(x965)*(x970)))+(((cj3)*(x978)))+(((px)*(x960)*(x967)))+(((sj3)*(x973)*(x975)))+(((x960)*(x981)))+(((IkReal(-1.00000000000000))*(x969)*(x970)))+(((sj3)*(x963)*(x966)))+(((IkReal(-1.00000000000000))*(cj3)*(x961)*(x968)))+(((IkReal(-1.00000000000000))*(px)*(r01)*(x974)))+(((IkReal(-1.00000000000000))*(pz)*(x967)*(x970)))+(((IkReal(-1.00000000000000))*(x972)*(x977)))+(((IkReal(-1.00000000000000))*(cj0)*(x961)*(x962)))+(((IkReal(-1.00000000000000))*(sj3)*(x966)*(x970)))+(((IkReal(-1.00000000000000))*(pz)*(x976)))+(((IkReal(-1.00000000000000))*(x968)*(x972)))+(((IkReal(0.0240000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(x967)*(x980)))+(((pz)*(x963)*(x967)))+(((IkReal(-1.00000000000000))*(px)*(r01)*(sj3)*(x973)))+(((x961)*(x963)*(x965)))+(((x974)*(x975)))+(((IkReal(0.0240000000000000))*(cj3)))+(((x963)*(x969))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst7)*(((IkReal(0.0225000000000000))+(((x961)*(x970)*(x971)))+(((IkReal(-1.00000000000000))*(pz)*(x963)*(x972)))+(((cj3)*(x966)*(x970)))+(((IkReal(0.00562500000000000))*(sj1)))+(((pz)*(x970)*(x972)))+(((IkReal(-1.00000000000000))*(px)*(x960)*(x972)))+(((IkReal(-1.00000000000000))*(x967)*(x977)))+(((IkReal(-1.00000000000000))*(sj3)*(x961)*(x977)))+(((IkReal(-1.00000000000000))*(pz)*(x974)))+(((x972)*(x980)))+(((IkReal(-1.00000000000000))*(x967)*(x968)))+(((IkReal(-1.00000000000000))*(x960)*(x961)*(x962)))+(((sj3)*(x978)))+(((IkReal(-1.00000000000000))*(x975)*(x976)))+(((IkReal(-1.00000000000000))*(sj3)*(x961)*(x968)))+(((x964)*(x970)))+(((IkReal(-1.00000000000000))*(x963)*(x964)))+(((cj3)*(x961)*(x980)))+(((IkReal(-1.00000000000000))*(x965)*(x973)))+(((IkReal(-1.00000000000000))*(x961)*(x963)*(x971)))+(((px)*(r01)*(x976)))+(((IkReal(-1.00000000000000))*(cj3)*(x963)*(x966)))+(((IkReal(0.0240000000000000))*(sj3)))+(((r01)*(x962)*(x973)))+(((IkReal(-1.00000000000000))*(cj3)*(x973)*(x975))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst7)*(((IkReal(0.0960000000000000))+(((IkReal(-1.00000000000000))*(x971)*(x973)))+(((IkReal(-1.00000000000000))*(sj3)*(x961)*(x980)))+(((IkReal(-1.00000000000000))*(x961)*(x965)*(x970)))+(((cj3)*(x978)))+(((px)*(x960)*(x967)))+(((sj3)*(x973)*(x975)))+(((x960)*(x981)))+(((IkReal(-1.00000000000000))*(x969)*(x970)))+(((sj3)*(x963)*(x966)))+(((IkReal(-1.00000000000000))*(cj3)*(x961)*(x968)))+(((IkReal(-1.00000000000000))*(px)*(r01)*(x974)))+(((IkReal(-1.00000000000000))*(pz)*(x967)*(x970)))+(((IkReal(-1.00000000000000))*(x972)*(x977)))+(((IkReal(-1.00000000000000))*(cj0)*(x961)*(x962)))+(((IkReal(-1.00000000000000))*(sj3)*(x966)*(x970)))+(((IkReal(-1.00000000000000))*(pz)*(x976)))+(((IkReal(-1.00000000000000))*(x968)*(x972)))+(((IkReal(0.0240000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(x967)*(x980)))+(((pz)*(x963)*(x967)))+(((IkReal(-1.00000000000000))*(px)*(r01)*(sj3)*(x973)))+(((x961)*(x963)*(x965)))+(((x974)*(x975)))+(((IkReal(0.0240000000000000))*(cj3)))+(((x963)*(x969)))))), ((gconst7)*(((IkReal(0.0225000000000000))+(((x961)*(x970)*(x971)))+(((IkReal(-1.00000000000000))*(pz)*(x963)*(x972)))+(((cj3)*(x966)*(x970)))+(((IkReal(0.00562500000000000))*(sj1)))+(((pz)*(x970)*(x972)))+(((IkReal(-1.00000000000000))*(px)*(x960)*(x972)))+(((IkReal(-1.00000000000000))*(x967)*(x977)))+(((IkReal(-1.00000000000000))*(sj3)*(x961)*(x977)))+(((IkReal(-1.00000000000000))*(pz)*(x974)))+(((x972)*(x980)))+(((IkReal(-1.00000000000000))*(x967)*(x968)))+(((IkReal(-1.00000000000000))*(x960)*(x961)*(x962)))+(((sj3)*(x978)))+(((IkReal(-1.00000000000000))*(x975)*(x976)))+(((IkReal(-1.00000000000000))*(sj3)*(x961)*(x968)))+(((x964)*(x970)))+(((IkReal(-1.00000000000000))*(x963)*(x964)))+(((cj3)*(x961)*(x980)))+(((IkReal(-1.00000000000000))*(x965)*(x973)))+(((IkReal(-1.00000000000000))*(x961)*(x963)*(x971)))+(((px)*(r01)*(x976)))+(((IkReal(-1.00000000000000))*(cj3)*(x963)*(x966)))+(((IkReal(0.0240000000000000))*(sj3)))+(((r01)*(x962)*(x973)))+(((IkReal(-1.00000000000000))*(cj3)*(x973)*(x975)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x982=IKcos(j2);
IkReal x983=IKsin(j2);
IkReal x984=((IkReal(0.0800000000000000))*(sj3));
IkReal x985=((cj0)*(r01));
IkReal x986=((IkReal(1.00000000000000))*(px));
IkReal x987=((py)*(sj1));
IkReal x988=((cj0)*(r02));
IkReal x989=((IkReal(0.0750000000000000))*(cj1));
IkReal x990=((r02)*(sj0));
IkReal x991=((IkReal(0.0750000000000000))*(sj1));
IkReal x992=((cj1)*(pz));
IkReal x993=((r00)*(sj0));
IkReal x994=((IkReal(0.0800000000000000))*(cj3));
IkReal x995=((pz)*(sj1));
IkReal x996=((IkReal(1.00000000000000))*(sj0));
IkReal x997=((cj1)*(py));
IkReal x998=((IkReal(0.320000000000000))*(x982));
IkReal x999=((IkReal(0.0750000000000000))*(x983));
IkReal x1000=((IkReal(0.320000000000000))*(x983));
IkReal x1001=((IkReal(0.0750000000000000))*(x982));
IkReal x1002=((sj1)*(x993));
IkReal x1003=((x982)*(x994));
IkReal x1004=((x983)*(x984));
IkReal x1005=((x982)*(x984));
IkReal x1006=((x983)*(x994));
IkReal x1007=((x1004)+(x999));
IkReal x1008=((x1003)+(x998));
IkReal x1009=((x1006)+(x1005)+(x1001)+(x1000));
evalcond[0]=((((IkReal(-1.00000000000000))*(x996)*(x997)))+(x989)+(((IkReal(-1.00000000000000))*(x1007)))+(x1008)+(((IkReal(-1.00000000000000))*(cj0)*(cj1)*(x986)))+(x995));
evalcond[1]=((IkReal(0.300000000000000))+(((IkReal(-1.00000000000000))*(x992)))+(((IkReal(-1.00000000000000))*(cj0)*(sj1)*(x986)))+(x1009)+(((IkReal(-1.00000000000000))*(x987)*(x996)))+(x991));
evalcond[2]=((((x993)*(x995)))+(((IkReal(-1.00000000000000))*(sj1)*(x986)*(x990)))+(((x987)*(x988)))+(((IkReal(-1.00000000000000))*(x985)*(x989)))+(((IkReal(-1.00000000000000))*(x1007)))+(((cj1)*(px)*(r01)))+(x1008)+(((x989)*(x993)))+(((IkReal(-1.00000000000000))*(x985)*(x995)))+(((IkReal(-1.00000000000000))*(r00)*(x997))));
evalcond[3]=((((IkReal(0.300000000000000))*(x985)))+(((IkReal(-1.00000000000000))*(x1009)))+(((x985)*(x991)))+(((IkReal(-0.300000000000000))*(x993)))+(((x988)*(x997)))+(((IkReal(-1.00000000000000))*(x991)*(x993)))+(((x992)*(x993)))+(((IkReal(-1.00000000000000))*(x985)*(x992)))+(((IkReal(-1.00000000000000))*(cj1)*(x986)*(x990)))+(((IkReal(-1.00000000000000))*(r01)*(sj1)*(x986)))+(((r00)*(x987))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x1010=((IkReal(0.0800000000000000))*(cj1));
IkReal x1011=((cj0)*(px));
IkReal x1012=((py)*(sj0));
IkReal x1013=((IkReal(0.320000000000000))*(sj1));
IkReal x1014=((IkReal(0.00600000000000000))*(cj3));
IkReal x1015=((pz)*(sj3));
IkReal x1016=((IkReal(0.0750000000000000))*(cj1));
IkReal x1017=((IkReal(0.0800000000000000))*(sj1));
IkReal x1018=((IkReal(0.0750000000000000))*(sj1));
IkReal x1019=((IkReal(0.00600000000000000))*(sj3));
IkReal x1020=((cj3)*(pz));
IkReal x1021=((IkReal(0.320000000000000))*(cj1));
if( IKabs(((gconst6)*(((IkReal(-0.0960000000000000))+(((IkReal(-1.00000000000000))*(sj3)*(x1010)*(x1012)))+(((x1010)*(x1020)))+(((IkReal(-1.00000000000000))*(x1012)*(x1016)))+(((x1012)*(x1013)))+(((IkReal(-1.00000000000000))*(x1011)*(x1016)))+(((pz)*(x1018)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((IkReal(-0.0240000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(sj3)*(x1010)*(x1011)))+(((cj3)*(x1012)*(x1017)))+(((cj3)*(x1011)*(x1017)))+(((pz)*(x1021)))+(((IkReal(0.00562500000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(sj1)*(x1014)))+(((x1011)*(x1013)))+(((cj1)*(x1019)))+(((x1015)*(x1017))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst6)*(((IkReal(-0.0225000000000000))+(((IkReal(-1.00000000000000))*(sj1)*(x1019)))+(((IkReal(-0.0240000000000000))*(sj3)))+(((x1011)*(x1018)))+(((x1012)*(x1021)))+(((sj3)*(x1012)*(x1017)))+(((IkReal(-1.00000000000000))*(cj1)*(x1014)))+(((sj3)*(x1011)*(x1017)))+(((IkReal(-1.00000000000000))*(x1017)*(x1020)))+(((x1011)*(x1021)))+(((IkReal(-0.0240000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(pz)*(x1013)))+(((x1012)*(x1018)))+(((x1010)*(x1015)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((cj3)*(x1010)*(x1012)))+(((cj3)*(x1010)*(x1011)))+(((pz)*(x1016))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst6)*(((IkReal(-0.0960000000000000))+(((IkReal(-1.00000000000000))*(sj3)*(x1010)*(x1012)))+(((x1010)*(x1020)))+(((IkReal(-1.00000000000000))*(x1012)*(x1016)))+(((x1012)*(x1013)))+(((IkReal(-1.00000000000000))*(x1011)*(x1016)))+(((pz)*(x1018)))+(((IkReal(-0.0240000000000000))*(cj3)))+(((IkReal(-0.0240000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(sj3)*(x1010)*(x1011)))+(((cj3)*(x1012)*(x1017)))+(((cj3)*(x1011)*(x1017)))+(((pz)*(x1021)))+(((IkReal(0.00562500000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(sj1)*(x1014)))+(((x1011)*(x1013)))+(((cj1)*(x1019)))+(((x1015)*(x1017)))))), ((gconst6)*(((IkReal(-0.0225000000000000))+(((IkReal(-1.00000000000000))*(sj1)*(x1019)))+(((IkReal(-0.0240000000000000))*(sj3)))+(((x1011)*(x1018)))+(((x1012)*(x1021)))+(((sj3)*(x1012)*(x1017)))+(((IkReal(-1.00000000000000))*(cj1)*(x1014)))+(((sj3)*(x1011)*(x1017)))+(((IkReal(-1.00000000000000))*(x1017)*(x1020)))+(((x1011)*(x1021)))+(((IkReal(-0.0240000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(pz)*(x1013)))+(((x1012)*(x1018)))+(((x1010)*(x1015)))+(((IkReal(-0.00562500000000000))*(sj1)))+(((cj3)*(x1010)*(x1012)))+(((cj3)*(x1010)*(x1011)))+(((pz)*(x1016)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[4];
IkReal x1022=IKcos(j2);
IkReal x1023=IKsin(j2);
IkReal x1024=((IkReal(0.0800000000000000))*(sj3));
IkReal x1025=((cj0)*(r01));
IkReal x1026=((IkReal(1.00000000000000))*(px));
IkReal x1027=((py)*(sj1));
IkReal x1028=((cj0)*(r02));
IkReal x1029=((IkReal(0.0750000000000000))*(cj1));
IkReal x1030=((r02)*(sj0));
IkReal x1031=((IkReal(0.0750000000000000))*(sj1));
IkReal x1032=((cj1)*(pz));
IkReal x1033=((r00)*(sj0));
IkReal x1034=((IkReal(0.0800000000000000))*(cj3));
IkReal x1035=((pz)*(sj1));
IkReal x1036=((IkReal(1.00000000000000))*(sj0));
IkReal x1037=((cj1)*(py));
IkReal x1038=((IkReal(0.320000000000000))*(x1022));
IkReal x1039=((IkReal(0.0750000000000000))*(x1023));
IkReal x1040=((IkReal(0.320000000000000))*(x1023));
IkReal x1041=((IkReal(0.0750000000000000))*(x1022));
IkReal x1042=((sj1)*(x1033));
IkReal x1043=((x1022)*(x1034));
IkReal x1044=((x1023)*(x1024));
IkReal x1045=((x1022)*(x1024));
IkReal x1046=((x1023)*(x1034));
IkReal x1047=((x1044)+(x1039));
IkReal x1048=((x1043)+(x1038));
IkReal x1049=((x1041)+(x1040)+(x1046)+(x1045));
evalcond[0]=((((IkReal(-1.00000000000000))*(x1036)*(x1037)))+(x1048)+(((IkReal(-1.00000000000000))*(cj0)*(cj1)*(x1026)))+(x1035)+(((IkReal(-1.00000000000000))*(x1047)))+(x1029));
evalcond[1]=((IkReal(0.300000000000000))+(x1049)+(x1031)+(((IkReal(-1.00000000000000))*(x1032)))+(((IkReal(-1.00000000000000))*(cj0)*(sj1)*(x1026)))+(((IkReal(-1.00000000000000))*(x1027)*(x1036))));
evalcond[2]=((x1048)+(((x1033)*(x1035)))+(((x1029)*(x1033)))+(((IkReal(-1.00000000000000))*(x1047)))+(((IkReal(-1.00000000000000))*(sj1)*(x1026)*(x1030)))+(((x1027)*(x1028)))+(((cj1)*(px)*(r01)))+(((IkReal(-1.00000000000000))*(x1025)*(x1029)))+(((IkReal(-1.00000000000000))*(r00)*(x1037)))+(((IkReal(-1.00000000000000))*(x1025)*(x1035))));
evalcond[3]=((((IkReal(-0.300000000000000))*(x1033)))+(((x1032)*(x1033)))+(((IkReal(-1.00000000000000))*(cj1)*(x1026)*(x1030)))+(((IkReal(-1.00000000000000))*(x1025)*(x1032)))+(((IkReal(0.300000000000000))*(x1025)))+(((x1025)*(x1031)))+(((r00)*(x1027)))+(((x1028)*(x1037)))+(((IkReal(-1.00000000000000))*(x1049)))+(((IkReal(-1.00000000000000))*(r01)*(sj1)*(x1026)))+(((IkReal(-1.00000000000000))*(x1031)*(x1033))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x1050=((IkReal(0.0800000000000000))*(cj3));
IkReal x1051=((IkReal(0.0750000000000000))*(cj1));
IkReal x1052=((r01)*(sj0));
IkReal x1053=((r02)*(sj1));
IkReal x1054=((IkReal(0.0800000000000000))*(sj3));
IkReal x1055=((cj3)*(cj4));
IkReal x1056=((cj4)*(sj3));
IkReal x1057=((pz)*(sj1));
IkReal x1058=((cj0)*(cj1)*(r00));
IkReal x1059=((cj0)*(cj1)*(px));
IkReal x1060=((cj1)*(py)*(sj0));
if( IKabs(((gconst3)*(((((IkReal(-0.320000000000000))*(x1058)))+(((IkReal(-1.00000000000000))*(cj1)*(x1050)*(x1052)))+(((IkReal(-0.320000000000000))*(cj1)*(x1052)))+(((IkReal(-1.00000000000000))*(x1056)*(x1059)))+(((x1056)*(x1057)))+(((x1050)*(x1053)))+(((IkReal(-1.00000000000000))*(x1050)*(x1058)))+(((IkReal(-1.00000000000000))*(x1056)*(x1060)))+(((IkReal(0.320000000000000))*(x1053)))+(((x1051)*(x1056))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst3)*(((((IkReal(-1.00000000000000))*(x1051)*(x1055)))+(((x1055)*(x1060)))+(((x1055)*(x1059)))+(((IkReal(-1.00000000000000))*(x1054)*(x1058)))+(((IkReal(-1.00000000000000))*(x1051)*(x1052)))+(((IkReal(0.0750000000000000))*(x1053)))+(((IkReal(-1.00000000000000))*(cj1)*(x1052)*(x1054)))+(((x1053)*(x1054)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x1051)))+(((IkReal(-1.00000000000000))*(x1055)*(x1057))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst3)*(((((IkReal(-0.320000000000000))*(x1058)))+(((IkReal(-1.00000000000000))*(cj1)*(x1050)*(x1052)))+(((IkReal(-0.320000000000000))*(cj1)*(x1052)))+(((IkReal(-1.00000000000000))*(x1056)*(x1059)))+(((x1056)*(x1057)))+(((x1050)*(x1053)))+(((IkReal(-1.00000000000000))*(x1050)*(x1058)))+(((IkReal(-1.00000000000000))*(x1056)*(x1060)))+(((IkReal(0.320000000000000))*(x1053)))+(((x1051)*(x1056)))))), ((gconst3)*(((((IkReal(-1.00000000000000))*(x1051)*(x1055)))+(((x1055)*(x1060)))+(((x1055)*(x1059)))+(((IkReal(-1.00000000000000))*(x1054)*(x1058)))+(((IkReal(-1.00000000000000))*(x1051)*(x1052)))+(((IkReal(0.0750000000000000))*(x1053)))+(((IkReal(-1.00000000000000))*(cj1)*(x1052)*(x1054)))+(((x1053)*(x1054)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x1051)))+(((IkReal(-1.00000000000000))*(x1055)*(x1057)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x1061=IKcos(j2);
IkReal x1062=IKsin(j2);
IkReal x1063=(py)*(py);
IkReal x1064=(px)*(px);
IkReal x1065=(pz)*(pz);
IkReal x1066=((sj0)*(sj1));
IkReal x1067=((IkReal(1.00000000000000))*(r01));
IkReal x1068=((r00)*(sj1));
IkReal x1069=((IkReal(0.0480000000000000))*(sj3));
IkReal x1070=((IkReal(0.0750000000000000))*(r00));
IkReal x1071=((IkReal(0.0800000000000000))*(sj3));
IkReal x1072=((cj1)*(r01));
IkReal x1073=((IkReal(0.150000000000000))*(py));
IkReal x1074=((pz)*(r02));
IkReal x1075=((px)*(r02));
IkReal x1076=((IkReal(0.0750000000000000))*(sj4));
IkReal x1077=((cj1)*(sj0));
IkReal x1078=((pz)*(r00));
IkReal x1079=((IkReal(0.0750000000000000))*(cj0));
IkReal x1080=((IkReal(2.00000000000000))*(cj0));
IkReal x1081=((cj1)*(r02));
IkReal x1082=((IkReal(0.150000000000000))*(sj1));
IkReal x1083=((px)*(r00));
IkReal x1084=((IkReal(2.00000000000000))*(py));
IkReal x1085=((IkReal(0.0903750000000000))*(sj3));
IkReal x1086=((r02)*(sj1));
IkReal x1087=((IkReal(0.150000000000000))*(cj1));
IkReal x1088=((cj0)*(py));
IkReal x1089=((IkReal(0.0480000000000000))*(cj3));
IkReal x1090=((r01)*(sj1));
IkReal x1091=((IkReal(0.0800000000000000))*(cj3));
IkReal x1092=((IkReal(0.150000000000000))*(pz));
IkReal x1093=((IkReal(1.00000000000000))*(cj1));
IkReal x1094=((cj0)*(r00));
IkReal x1095=((IkReal(0.600000000000000))*(py));
IkReal x1096=((IkReal(1.00000000000000))*(py));
IkReal x1097=((px)*(sj1));
IkReal x1098=((IkReal(1.00000000000000))*(cj0));
IkReal x1099=((cj0)*(pz));
IkReal x1100=((IkReal(0.103175000000000))*(cj3));
IkReal x1101=((IkReal(0.600000000000000))*(cj0));
IkReal x1102=((IkReal(1.00000000000000))*(sj3));
IkReal x1103=((px)*(py));
IkReal x1104=((r01)*(sj0));
IkReal x1105=((IkReal(2.00000000000000))*(px));
IkReal x1106=((cj4)*(x1062));
IkReal x1107=((cj4)*(x1061));
IkReal x1108=((sj4)*(x1062));
IkReal x1109=((IkReal(2.00000000000000))*(x1065));
IkReal x1110=((sj4)*(x1061));
IkReal x1111=((IkReal(2.00000000000000))*(x1063));
IkReal x1112=((px)*(x1074)*(x1080));
evalcond[0]=((((IkReal(-1.00000000000000))*(x1067)*(x1077)))+(x1086)+(((IkReal(-1.00000000000000))*(x1093)*(x1094)))+(((IkReal(-1.00000000000000))*(cj3)*(x1106)))+(((IkReal(-1.00000000000000))*(x1102)*(x1107))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1102)*(x1106)))+(((IkReal(-1.00000000000000))*(x1081)))+(((cj3)*(x1107)))+(((IkReal(-1.00000000000000))*(x1068)*(x1098)))+(((IkReal(-1.00000000000000))*(x1066)*(x1067))));
evalcond[2]=((((IkReal(-1.00000000000000))*(cj0)*(px)*(x1093)))+(((IkReal(0.320000000000000))*(x1061)))+(((IkReal(-1.00000000000000))*(x1062)*(x1071)))+(((pz)*(sj1)))+(((IkReal(-0.0750000000000000))*(x1062)))+(((x1061)*(x1091)))+(((IkReal(-1.00000000000000))*(x1077)*(x1096)))+(((IkReal(0.0750000000000000))*(cj1))));
evalcond[3]=((IkReal(0.300000000000000))+(((IkReal(-1.00000000000000))*(x1097)*(x1098)))+(((x1062)*(x1091)))+(((IkReal(0.320000000000000))*(x1062)))+(((IkReal(0.0750000000000000))*(x1061)))+(((x1061)*(x1071)))+(((IkReal(-1.00000000000000))*(x1066)*(x1096)))+(((IkReal(0.0750000000000000))*(sj1)))+(((IkReal(-1.00000000000000))*(pz)*(x1093))));
evalcond[4]=((((IkReal(-1.00000000000000))*(py)*(r00)*(x1093)))+(((IkReal(-1.00000000000000))*(x1066)*(x1075)))+(((IkReal(-1.00000000000000))*(sj1)*(x1067)*(x1099)))+(((IkReal(-0.320000000000000))*(x1110)))+(((x1066)*(x1078)))+(((px)*(x1072)))+(((x1086)*(x1088)))+(((x1071)*(x1108)))+(((x1062)*(x1076)))+(((IkReal(-1.00000000000000))*(x1091)*(x1110)))+(((IkReal(-1.00000000000000))*(x1072)*(x1079)))+(((x1070)*(x1077))));
evalcond[5]=((((x1061)*(x1076)))+(((IkReal(0.320000000000000))*(x1108)))+(((py)*(x1068)))+(((IkReal(-1.00000000000000))*(x1067)*(x1097)))+(((IkReal(-0.300000000000000))*(r00)*(sj0)))+(((x1077)*(x1078)))+(((x1081)*(x1088)))+(((IkReal(-1.00000000000000))*(x1066)*(x1070)))+(((x1071)*(x1110)))+(((IkReal(0.300000000000000))*(cj0)*(r01)))+(((IkReal(-1.00000000000000))*(x1075)*(x1077)))+(((IkReal(-1.00000000000000))*(cj1)*(x1067)*(x1099)))+(((x1091)*(x1108)))+(((x1079)*(x1090))));
evalcond[6]=((((x1069)*(x1107)))+(((cj0)*(x1075)*(x1087)))+(((IkReal(-1.00000000000000))*(pp)*(x1081)))+(((IkReal(-0.150000000000000))*(px)*(x1068)))+(((x1085)*(x1106)))+(((IkReal(-0.600000000000000))*(x1083)))+(((IkReal(0.0450000000000000))*(x1104)))+(((IkReal(0.0956250000000000))*(r01)*(x1066)))+(((x1081)*(x1109)))+(((IkReal(-1.00000000000000))*(x1074)*(x1082)))+(((cj1)*(x1078)*(x1105)))+(((x1066)*(x1074)*(x1084)))+(((IkReal(-1.00000000000000))*(sj0)*(x1072)*(x1092)))+(((IkReal(-1.00000000000000))*(r01)*(x1095)))+(((r01)*(x1066)*(x1111)))+(((IkReal(-0.600000000000000))*(x1074)))+(((x1066)*(x1083)*(x1084)))+(((x1100)*(x1107)))+(((IkReal(0.0843750000000000))*(x1081)))+(((IkReal(-1.00000000000000))*(x1089)*(x1106)))+(((x1064)*(x1068)*(x1080)))+(((r02)*(x1073)*(x1077)))+(((IkReal(-1.00000000000000))*(x1073)*(x1090)))+(((IkReal(0.0956250000000000))*(cj0)*(x1068)))+(((IkReal(0.0512000000000000))*(x1107)))+(((IkReal(-1.00000000000000))*(cj0)*(x1078)*(x1087)))+(((IkReal(-0.0120000000000000))*(x1106)))+(((IkReal(-1.00000000000000))*(pp)*(x1066)*(x1067)))+(((IkReal(-1.00000000000000))*(pp)*(x1068)*(x1098)))+(((x1074)*(x1080)*(x1097)))+(((IkReal(0.0450000000000000))*(x1094)))+(((pz)*(x1072)*(x1084)))+(((x1080)*(x1090)*(x1103))));
evalcond[7]=((((IkReal(-0.0512000000000000))*(x1106)))+(((IkReal(-1.00000000000000))*(x1089)*(x1107)))+(((IkReal(0.0450000000000000))*(r02)))+(((x1078)*(x1101)))+(((IkReal(-1.00000000000000))*(pz)*(x1068)*(x1105)))+(((IkReal(0.600000000000000))*(pz)*(x1104)))+(((cj0)*(x1068)*(x1092)))+(((IkReal(-1.00000000000000))*(r02)*(x1066)*(x1073)))+(((x1072)*(x1080)*(x1103)))+(((IkReal(-0.0843750000000000))*(sj0)*(x1072)))+(((IkReal(-1.00000000000000))*(pp)*(x1067)*(x1077)))+(((x1085)*(x1107)))+(((IkReal(-1.00000000000000))*(pp)*(x1093)*(x1094)))+(((IkReal(-1.00000000000000))*(x1075)*(x1101)))+(((cj1)*(r00)*(x1064)*(x1080)))+(((IkReal(-1.00000000000000))*(x1074)*(x1087)))+(((pp)*(x1086)))+(((IkReal(-0.0120000000000000))*(x1107)))+(((IkReal(-1.00000000000000))*(x1083)*(x1087)))+(((IkReal(-1.00000000000000))*(cj0)*(x1075)*(x1082)))+(((x1074)*(x1077)*(x1084)))+(((IkReal(-0.0843750000000000))*(cj1)*(x1094)))+(((IkReal(-1.00000000000000))*(x1069)*(x1106)))+(((IkReal(-1.00000000000000))*(pz)*(x1084)*(x1090)))+(((sj0)*(x1072)*(x1111)))+(((IkReal(-1.00000000000000))*(x1072)*(x1073)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x1095)))+(((IkReal(0.0956250000000000))*(x1086)))+(((IkReal(-1.00000000000000))*(x1086)*(x1109)))+(((cj1)*(x1112)))+(((IkReal(-1.00000000000000))*(x1100)*(x1106)))+(((x1077)*(x1083)*(x1084)))+(((r01)*(x1066)*(x1092))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  || IKabs(evalcond[6]) > 0.000001  || IKabs(evalcond[7]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j2array[1], cj2array[1], sj2array[1];
bool j2valid[1]={false};
_nj2 = 1;
IkReal x1113=((IkReal(1.00000000000000))*(cj1));
IkReal x1114=((cj0)*(r00));
IkReal x1115=((cj3)*(r02));
IkReal x1116=((sj1)*(sj3));
IkReal x1117=((r01)*(sj0));
IkReal x1118=((cj3)*(x1117));
if( IKabs(((gconst2)*(((((IkReal(-1.00000000000000))*(cj3)*(x1113)*(x1114)))+(((IkReal(-1.00000000000000))*(x1113)*(x1118)))+(((IkReal(-1.00000000000000))*(r02)*(sj3)*(x1113)))+(((sj1)*(x1115)))+(((IkReal(-1.00000000000000))*(x1116)*(x1117)))+(((IkReal(-1.00000000000000))*(x1114)*(x1116))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst2)*(((((r02)*(x1116)))+(((sj1)*(x1118)))+(((IkReal(-1.00000000000000))*(sj3)*(x1113)*(x1114)))+(((IkReal(-1.00000000000000))*(sj3)*(x1113)*(x1117)))+(((cj1)*(x1115)))+(((cj3)*(sj1)*(x1114))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j2array[0]=IKatan2(((gconst2)*(((((IkReal(-1.00000000000000))*(cj3)*(x1113)*(x1114)))+(((IkReal(-1.00000000000000))*(x1113)*(x1118)))+(((IkReal(-1.00000000000000))*(r02)*(sj3)*(x1113)))+(((sj1)*(x1115)))+(((IkReal(-1.00000000000000))*(x1116)*(x1117)))+(((IkReal(-1.00000000000000))*(x1114)*(x1116)))))), ((gconst2)*(((((r02)*(x1116)))+(((sj1)*(x1118)))+(((IkReal(-1.00000000000000))*(sj3)*(x1113)*(x1114)))+(((IkReal(-1.00000000000000))*(sj3)*(x1113)*(x1117)))+(((cj1)*(x1115)))+(((cj3)*(sj1)*(x1114)))))));
sj2array[0]=IKsin(j2array[0]);
cj2array[0]=IKcos(j2array[0]);
if( j2array[0] > IKPI )
{
    j2array[0]-=IK2PI;
}
else if( j2array[0] < -IKPI )
{    j2array[0]+=IK2PI;
}
j2valid[0] = true;
for(int ij2 = 0; ij2 < 1; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 1; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];
{
IkReal evalcond[8];
IkReal x1119=IKcos(j2);
IkReal x1120=IKsin(j2);
IkReal x1121=(py)*(py);
IkReal x1122=(px)*(px);
IkReal x1123=(pz)*(pz);
IkReal x1124=((sj0)*(sj1));
IkReal x1125=((IkReal(1.00000000000000))*(r01));
IkReal x1126=((r00)*(sj1));
IkReal x1127=((IkReal(0.0480000000000000))*(sj3));
IkReal x1128=((IkReal(0.0750000000000000))*(r00));
IkReal x1129=((IkReal(0.0800000000000000))*(sj3));
IkReal x1130=((cj1)*(r01));
IkReal x1131=((IkReal(0.150000000000000))*(py));
IkReal x1132=((pz)*(r02));
IkReal x1133=((px)*(r02));
IkReal x1134=((IkReal(0.0750000000000000))*(sj4));
IkReal x1135=((cj1)*(sj0));
IkReal x1136=((pz)*(r00));
IkReal x1137=((IkReal(0.0750000000000000))*(cj0));
IkReal x1138=((IkReal(2.00000000000000))*(cj0));
IkReal x1139=((cj1)*(r02));
IkReal x1140=((IkReal(0.150000000000000))*(sj1));
IkReal x1141=((px)*(r00));
IkReal x1142=((IkReal(2.00000000000000))*(py));
IkReal x1143=((IkReal(0.0903750000000000))*(sj3));
IkReal x1144=((r02)*(sj1));
IkReal x1145=((IkReal(0.150000000000000))*(cj1));
IkReal x1146=((cj0)*(py));
IkReal x1147=((IkReal(0.0480000000000000))*(cj3));
IkReal x1148=((r01)*(sj1));
IkReal x1149=((IkReal(0.0800000000000000))*(cj3));
IkReal x1150=((IkReal(0.150000000000000))*(pz));
IkReal x1151=((IkReal(1.00000000000000))*(cj1));
IkReal x1152=((cj0)*(r00));
IkReal x1153=((IkReal(0.600000000000000))*(py));
IkReal x1154=((IkReal(1.00000000000000))*(py));
IkReal x1155=((px)*(sj1));
IkReal x1156=((IkReal(1.00000000000000))*(cj0));
IkReal x1157=((cj0)*(pz));
IkReal x1158=((IkReal(0.103175000000000))*(cj3));
IkReal x1159=((IkReal(0.600000000000000))*(cj0));
IkReal x1160=((IkReal(1.00000000000000))*(sj3));
IkReal x1161=((px)*(py));
IkReal x1162=((r01)*(sj0));
IkReal x1163=((IkReal(2.00000000000000))*(px));
IkReal x1164=((cj4)*(x1120));
IkReal x1165=((cj4)*(x1119));
IkReal x1166=((sj4)*(x1120));
IkReal x1167=((IkReal(2.00000000000000))*(x1123));
IkReal x1168=((sj4)*(x1119));
IkReal x1169=((IkReal(2.00000000000000))*(x1121));
IkReal x1170=((px)*(x1132)*(x1138));
evalcond[0]=((x1144)+(((IkReal(-1.00000000000000))*(x1160)*(x1165)))+(((IkReal(-1.00000000000000))*(x1151)*(x1152)))+(((IkReal(-1.00000000000000))*(x1125)*(x1135)))+(((IkReal(-1.00000000000000))*(cj3)*(x1164))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1160)*(x1164)))+(((IkReal(-1.00000000000000))*(x1139)))+(((cj3)*(x1165)))+(((IkReal(-1.00000000000000))*(x1126)*(x1156)))+(((IkReal(-1.00000000000000))*(x1124)*(x1125))));
evalcond[2]=((((IkReal(-1.00000000000000))*(cj0)*(px)*(x1151)))+(((IkReal(-0.0750000000000000))*(x1120)))+(((IkReal(0.320000000000000))*(x1119)))+(((pz)*(sj1)))+(((IkReal(-1.00000000000000))*(x1135)*(x1154)))+(((x1119)*(x1149)))+(((IkReal(0.0750000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(x1120)*(x1129))));
evalcond[3]=((IkReal(0.300000000000000))+(((x1120)*(x1149)))+(((IkReal(-1.00000000000000))*(x1124)*(x1154)))+(((IkReal(-1.00000000000000))*(pz)*(x1151)))+(((IkReal(0.0750000000000000))*(x1119)))+(((IkReal(0.320000000000000))*(x1120)))+(((IkReal(-1.00000000000000))*(x1155)*(x1156)))+(((x1119)*(x1129)))+(((IkReal(0.0750000000000000))*(sj1))));
evalcond[4]=((((IkReal(-0.320000000000000))*(x1168)))+(((x1124)*(x1136)))+(((px)*(x1130)))+(((IkReal(-1.00000000000000))*(py)*(r00)*(x1151)))+(((IkReal(-1.00000000000000))*(x1130)*(x1137)))+(((x1129)*(x1166)))+(((IkReal(-1.00000000000000))*(x1124)*(x1133)))+(((IkReal(-1.00000000000000))*(sj1)*(x1125)*(x1157)))+(((x1128)*(x1135)))+(((x1144)*(x1146)))+(((IkReal(-1.00000000000000))*(x1149)*(x1168)))+(((x1120)*(x1134))));
evalcond[5]=((((IkReal(0.320000000000000))*(x1166)))+(((x1137)*(x1148)))+(((x1149)*(x1166)))+(((x1135)*(x1136)))+(((x1119)*(x1134)))+(((py)*(x1126)))+(((IkReal(-1.00000000000000))*(x1133)*(x1135)))+(((IkReal(-0.300000000000000))*(r00)*(sj0)))+(((IkReal(-1.00000000000000))*(x1124)*(x1128)))+(((IkReal(-1.00000000000000))*(cj1)*(x1125)*(x1157)))+(((x1129)*(x1168)))+(((IkReal(-1.00000000000000))*(x1125)*(x1155)))+(((IkReal(0.300000000000000))*(cj0)*(r01)))+(((x1139)*(x1146))));
evalcond[6]=((((x1124)*(x1132)*(x1142)))+(((IkReal(-1.00000000000000))*(x1131)*(x1148)))+(((IkReal(0.0512000000000000))*(x1165)))+(((cj0)*(x1133)*(x1145)))+(((pz)*(x1130)*(x1142)))+(((x1139)*(x1167)))+(((r02)*(x1131)*(x1135)))+(((x1143)*(x1164)))+(((IkReal(-1.00000000000000))*(pp)*(x1139)))+(((IkReal(0.0450000000000000))*(x1162)))+(((IkReal(-1.00000000000000))*(x1132)*(x1140)))+(((IkReal(-1.00000000000000))*(sj0)*(x1130)*(x1150)))+(((IkReal(0.0450000000000000))*(x1152)))+(((IkReal(-0.600000000000000))*(x1132)))+(((x1127)*(x1165)))+(((x1158)*(x1165)))+(((x1138)*(x1148)*(x1161)))+(((r01)*(x1124)*(x1169)))+(((cj1)*(x1136)*(x1163)))+(((IkReal(-0.0120000000000000))*(x1164)))+(((IkReal(0.0956250000000000))*(cj0)*(x1126)))+(((IkReal(-1.00000000000000))*(pp)*(x1124)*(x1125)))+(((IkReal(-0.600000000000000))*(x1141)))+(((x1122)*(x1126)*(x1138)))+(((IkReal(0.0956250000000000))*(r01)*(x1124)))+(((x1132)*(x1138)*(x1155)))+(((IkReal(-1.00000000000000))*(r01)*(x1153)))+(((IkReal(-1.00000000000000))*(x1147)*(x1164)))+(((IkReal(-1.00000000000000))*(cj0)*(x1136)*(x1145)))+(((IkReal(-0.150000000000000))*(px)*(x1126)))+(((IkReal(0.0843750000000000))*(x1139)))+(((x1124)*(x1141)*(x1142)))+(((IkReal(-1.00000000000000))*(pp)*(x1126)*(x1156))));
evalcond[7]=((((IkReal(-1.00000000000000))*(x1130)*(x1131)))+(((IkReal(-1.00000000000000))*(pz)*(x1126)*(x1163)))+(((r01)*(x1124)*(x1150)))+(((IkReal(-0.0843750000000000))*(cj1)*(x1152)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x1153)))+(((IkReal(-0.0843750000000000))*(sj0)*(x1130)))+(((x1130)*(x1138)*(x1161)))+(((cj0)*(x1126)*(x1150)))+(((IkReal(0.0450000000000000))*(r02)))+(((IkReal(-1.00000000000000))*(pz)*(x1142)*(x1148)))+(((IkReal(-1.00000000000000))*(x1141)*(x1145)))+(((IkReal(0.0956250000000000))*(x1144)))+(((IkReal(-1.00000000000000))*(x1158)*(x1164)))+(((IkReal(-1.00000000000000))*(pp)*(x1125)*(x1135)))+(((IkReal(-1.00000000000000))*(x1133)*(x1159)))+(((cj1)*(x1170)))+(((pp)*(x1144)))+(((cj1)*(r00)*(x1122)*(x1138)))+(((IkReal(-1.00000000000000))*(x1132)*(x1145)))+(((IkReal(-0.0512000000000000))*(x1164)))+(((x1143)*(x1165)))+(((x1136)*(x1159)))+(((x1135)*(x1141)*(x1142)))+(((IkReal(-1.00000000000000))*(x1144)*(x1167)))+(((IkReal(-1.00000000000000))*(x1147)*(x1165)))+(((IkReal(0.600000000000000))*(pz)*(x1162)))+(((IkReal(-1.00000000000000))*(pp)*(x1151)*(x1152)))+(((IkReal(-1.00000000000000))*(x1127)*(x1164)))+(((IkReal(-0.0120000000000000))*(x1165)))+(((IkReal(-1.00000000000000))*(cj0)*(x1133)*(x1140)))+(((IkReal(-1.00000000000000))*(r02)*(x1124)*(x1131)))+(((x1132)*(x1135)*(x1142)))+(((sj0)*(x1130)*(x1169))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  || IKabs(evalcond[6]) > 0.000001  || IKabs(evalcond[7]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(5);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}
}
}
    }
}
}
}
return solutions.GetNumSolutions()>0;
}
static inline void polyroots4(IkReal rawcoeffs[4+1], IkReal rawroots[4], int& numroots)
{
    using std::complex;
    IKFAST_ASSERT(rawcoeffs[0] != 0);
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    const IkReal tolsqrt = sqrt(std::numeric_limits<IkReal>::epsilon());
    complex<IkReal> coeffs[4];
    const int maxsteps = 110;
    for(int i = 0; i < 4; ++i) {
        coeffs[i] = complex<IkReal>(rawcoeffs[i+1]/rawcoeffs[0]);
    }
    complex<IkReal> roots[4];
    IkReal err[4];
    roots[0] = complex<IkReal>(1,0);
    roots[1] = complex<IkReal>(0.4,0.9); // any complex number not a root of unity works
    err[0] = 1.0;
    err[1] = 1.0;
    for(int i = 2; i < 4; ++i) {
        roots[i] = roots[i-1]*roots[1];
        err[i] = 1.0;
    }
    for(int step = 0; step < maxsteps; ++step) {
        bool changed = false;
        for(int i = 0; i < 4; ++i) {
            if ( err[i] >= tol ) {
                changed = true;
                // evaluate
                complex<IkReal> x = roots[i] + coeffs[0];
                for(int j = 1; j < 4; ++j) {
                    x = roots[i] * x + coeffs[j];
                }
                for(int j = 0; j < 4; ++j) {
                    if( i != j ) {
                        if( roots[i] != roots[j] ) {
                            x /= (roots[i] - roots[j]);
                        }
                    }
                }
                roots[i] -= x;
                err[i] = abs(x);
            }
        }
        if( !changed ) {
            break;
        }
    }

    numroots = 0;
    bool visited[4] = {false};
    for(int i = 0; i < 4; ++i) {
        if( !visited[i] ) {
            // might be a multiple root, in which case it will have more error than the other roots
            // find any neighboring roots, and take the average
            complex<IkReal> newroot=roots[i];
            int n = 1;
            for(int j = i+1; j < 4; ++j) {
                if( abs(roots[i]-roots[j]) < 8*tolsqrt ) {
                    newroot += roots[j];
                    n += 1;
                    visited[j] = true;
                }
            }
            if( n > 1 ) {
                newroot /= n;
            }
            // there are still cases where even the mean is not accurate enough, until a better multi-root algorithm is used, need to use the sqrt
            if( IKabs(imag(newroot)) < tolsqrt ) {
                rawroots[numroots++] = real(newroot);
            }
        }
    }
}
};


/// solves the inverse kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API bool ComputeIk(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions) {
IKSolver solver;
return solver.ComputeIk(eetrans,eerot,pfree,solutions);
}

IKFAST_API const char* GetKinematicsHash() { return "e1ede99669e4a55117e29b2cffeb063c"; }

IKFAST_API const char* GetIkFastVersion() { return IKFAST_STRINGIZE(IKFAST_VERSION); }

#ifdef IKFAST_NAMESPACE
} // end namespace
#endif

#ifndef IKFAST_NO_MAIN
#include <stdio.h>
#include <stdlib.h>
#ifdef IKFAST_NAMESPACE
using namespace IKFAST_NAMESPACE;
#endif
int main(int argc, char** argv)
{
    if( argc != 12+GetNumFreeParameters()+1 ) {
        printf("\nUsage: ./ik r00 r01 r02 t0 r10 r11 r12 t1 r20 r21 r22 t2 free0 ...\n\n"
               "Returns the ik solutions given the transformation of the end effector specified by\n"
               "a 3x3 rotation R (rXX), and a 3x1 translation (tX).\n"
               "There are %d free parameters that have to be specified.\n\n",GetNumFreeParameters());
        return 1;
    }

    IkSolutionList<IkReal> solutions;
    std::vector<IkReal> vfree(GetNumFreeParameters());
    IkReal eerot[9],eetrans[3];
    eerot[0] = atof(argv[1]); eerot[1] = atof(argv[2]); eerot[2] = atof(argv[3]); eetrans[0] = atof(argv[4]);
    eerot[3] = atof(argv[5]); eerot[4] = atof(argv[6]); eerot[5] = atof(argv[7]); eetrans[1] = atof(argv[8]);
    eerot[6] = atof(argv[9]); eerot[7] = atof(argv[10]); eerot[8] = atof(argv[11]); eetrans[2] = atof(argv[12]);
    for(std::size_t i = 0; i < vfree.size(); ++i)
        vfree[i] = atof(argv[13+i]);
    bool bSuccess = ComputeIk(eetrans, eerot, vfree.size() > 0 ? &vfree[0] : NULL, solutions);

    if( !bSuccess ) {
        fprintf(stderr,"Failed to get ik solution\n");
        return -1;
    }

    printf("Found %d ik solutions:\n", (int)solutions.GetNumSolutions());
    std::vector<IkReal> solvalues(GetNumJoints());
    for(std::size_t i = 0; i < solutions.GetNumSolutions(); ++i) {
        const IkSolutionBase<IkReal>& sol = solutions.GetSolution(i);
        printf("sol%d (free=%d): ", (int)i, (int)sol.GetFree().size());
        std::vector<IkReal> vsolfree(sol.GetFree().size());
        sol.GetSolution(&solvalues[0],vsolfree.size()>0?&vsolfree[0]:NULL);
        for( std::size_t j = 0; j < solvalues.size(); ++j)
            printf("%.15f, ", solvalues[j]);
        printf("\n");
    }
    return 0;
}

#endif
