/// autogenerated analytical inverse kinematics code from ikfast program part of OpenRAVE
/// \author Rosen Diankov
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///     http://www.apache.org/licenses/LICENSE-2.0
/// 
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// ikfast version 61 generated on 2014-05-16 09:39:50.406073
/// To compile with gcc:
///     gcc -lstdc++ ik.cpp
/// To compile without any main function as a shared object (might need -llapack):
///     gcc -fPIC -lstdc++ -DIKFAST_NO_MAIN -DIKFAST_CLIBRARY -shared -Wl,-soname,libik.so -o libik.so ik.cpp
#define IKFAST_HAS_LIBRARY
#include "ikfast.h" // found inside share/openrave-X.Y/python/ikfast.h
using namespace ikfast;

// check if the included ikfast version matches what this file was compiled with
#define IKFAST_COMPILE_ASSERT(x) extern int __dummy[(int)x]
IKFAST_COMPILE_ASSERT(IKFAST_VERSION==61);

#include <cmath>
#include <vector>
#include <limits>
#include <algorithm>
#include <complex>

#define IKFAST_STRINGIZE2(s) #s
#define IKFAST_STRINGIZE(s) IKFAST_STRINGIZE2(s)

#ifndef IKFAST_ASSERT
#include <stdexcept>
#include <sstream>
#include <iostream>

#ifdef _MSC_VER
#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __FUNCDNAME__
#endif
#endif

#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __func__
#endif

#define IKFAST_ASSERT(b) { if( !(b) ) { std::stringstream ss; ss << "ikfast exception: " << __FILE__ << ":" << __LINE__ << ": " <<__PRETTY_FUNCTION__ << ": Assertion '" << #b << "' failed"; throw std::runtime_error(ss.str()); } }

#endif

#if defined(_MSC_VER)
#define IKFAST_ALIGNED16(x) __declspec(align(16)) x
#else
#define IKFAST_ALIGNED16(x) x __attribute((aligned(16)))
#endif

#define IK2PI  ((IkReal)6.28318530717959)
#define IKPI  ((IkReal)3.14159265358979)
#define IKPI_2  ((IkReal)1.57079632679490)

#ifdef _MSC_VER
#ifndef isnan
#define isnan _isnan
#endif
#endif // _MSC_VER

// lapack routines
extern "C" {
  void dgetrf_ (const int* m, const int* n, double* a, const int* lda, int* ipiv, int* info);
  void zgetrf_ (const int* m, const int* n, std::complex<double>* a, const int* lda, int* ipiv, int* info);
  void dgetri_(const int* n, const double* a, const int* lda, int* ipiv, double* work, const int* lwork, int* info);
  void dgesv_ (const int* n, const int* nrhs, double* a, const int* lda, int* ipiv, double* b, const int* ldb, int* info);
  void dgetrs_(const char *trans, const int *n, const int *nrhs, double *a, const int *lda, int *ipiv, double *b, const int *ldb, int *info);
  void dgeev_(const char *jobvl, const char *jobvr, const int *n, double *a, const int *lda, double *wr, double *wi,double *vl, const int *ldvl, double *vr, const int *ldvr, double *work, const int *lwork, int *info);
}

using namespace std; // necessary to get std math routines

#ifdef IKFAST_NAMESPACE
namespace IKFAST_NAMESPACE {
#endif

inline float IKabs(float f) { return fabsf(f); }
inline double IKabs(double f) { return fabs(f); }

inline float IKsqr(float f) { return f*f; }
inline double IKsqr(double f) { return f*f; }

inline float IKlog(float f) { return logf(f); }
inline double IKlog(double f) { return log(f); }

// allows asin and acos to exceed 1
#ifndef IKFAST_SINCOS_THRESH
#define IKFAST_SINCOS_THRESH ((IkReal)0.000001)
#endif

// used to check input to atan2 for degenerate cases
#ifndef IKFAST_ATAN2_MAGTHRESH
#define IKFAST_ATAN2_MAGTHRESH ((IkReal)2e-6)
#endif

// minimum distance of separate solutions
#ifndef IKFAST_SOLUTION_THRESH
#define IKFAST_SOLUTION_THRESH ((IkReal)1e-6)
#endif

inline float IKasin(float f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return float(-IKPI_2);
else if( f >= 1 ) return float(IKPI_2);
return asinf(f);
}
inline double IKasin(double f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return -IKPI_2;
else if( f >= 1 ) return IKPI_2;
return asin(f);
}

// return positive value in [0,y)
inline float IKfmod(float x, float y)
{
    while(x < 0) {
        x += y;
    }
    return fmodf(x,y);
}

// return positive value in [0,y)
inline double IKfmod(double x, double y)
{
    while(x < 0) {
        x += y;
    }
    return fmod(x,y);
}

inline float IKacos(float f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return float(IKPI);
else if( f >= 1 ) return float(0);
return acosf(f);
}
inline double IKacos(double f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return IKPI;
else if( f >= 1 ) return 0;
return acos(f);
}
inline float IKsin(float f) { return sinf(f); }
inline double IKsin(double f) { return sin(f); }
inline float IKcos(float f) { return cosf(f); }
inline double IKcos(double f) { return cos(f); }
inline float IKtan(float f) { return tanf(f); }
inline double IKtan(double f) { return tan(f); }
inline float IKsqrt(float f) { if( f <= 0.0f ) return 0.0f; return sqrtf(f); }
inline double IKsqrt(double f) { if( f <= 0.0 ) return 0.0; return sqrt(f); }
inline float IKatan2(float fy, float fx) {
    if( isnan(fy) ) {
        IKFAST_ASSERT(!isnan(fx)); // if both are nan, probably wrong value will be returned
        return float(IKPI_2);
    }
    else if( isnan(fx) ) {
        return 0;
    }
    return atan2f(fy,fx);
}
inline double IKatan2(double fy, double fx) {
    if( isnan(fy) ) {
        IKFAST_ASSERT(!isnan(fx)); // if both are nan, probably wrong value will be returned
        return IKPI_2;
    }
    else if( isnan(fx) ) {
        return 0;
    }
    return atan2(fy,fx);
}

inline float IKsign(float f) {
    if( f > 0 ) {
        return float(1);
    }
    else if( f < 0 ) {
        return float(-1);
    }
    return 0;
}

inline double IKsign(double f) {
    if( f > 0 ) {
        return 1.0;
    }
    else if( f < 0 ) {
        return -1.0;
    }
    return 0;
}

/// solves the forward kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API void ComputeFk(const IkReal* j, IkReal* eetrans, IkReal* eerot) {
IkReal x0,x1,x2,x3,x4,x5,x6,x7,x8,x9,x10,x11,x12,x13,x14,x15,x16,x17,x18,x19,x20,x21,x22,x23,x24,x25,x26,x27,x28,x29,x30,x31,x32,x33,x34,x35,x36,x37,x38,x39,x40,x41,x42,x43,x44,x45,x46,x47,x48,x49,x50,x51,x52,x53,x54,x55;
x0=IKcos(j[0]);
x1=IKcos(j[1]);
x2=IKcos(j[2]);
x3=IKsin(j[1]);
x4=IKsin(j[2]);
x5=IKsin(j[3]);
x6=IKcos(j[3]);
x7=IKsin(j[0]);
x8=IKcos(j[5]);
x9=IKsin(j[5]);
x10=IKcos(j[4]);
x11=IKsin(j[4]);
x12=((IkReal(0.0650000000000000))*(x2));
x13=((IkReal(0.0950000000000000))*(x6));
x14=((IkReal(1.00000000000000))*(x10));
x15=((IkReal(1.00000000000000))*(x11));
x16=((IkReal(1.00000000000000))*(x7));
x17=((IkReal(0.0950000000000000))*(x4));
x18=((IkReal(1.00000000000000))*(x2));
x19=((IkReal(0.350000000000000))*(x1));
x20=((IkReal(0.0650000000000000))*(x0));
x21=((IkReal(0.350000000000000))*(x2));
x22=((IkReal(0.0650000000000000))*(x7));
x23=((IkReal(0.0650000000000000))*(x6));
x24=((IkReal(0.0950000000000000))*(x2));
x25=((IkReal(1.00000000000000))*(x4));
x26=((x3)*(x7));
x27=((x0)*(x3));
x28=((x3)*(x4));
x29=((x11)*(x6));
x30=((x1)*(x4));
x31=((x1)*(x7));
x32=((x1)*(x18));
x33=((x0)*(x1)*(x2));
x34=((x25)*(x27));
x35=((x16)*(x28));
x36=((x28)+(((IkReal(-1.00000000000000))*(x32))));
x37=((((x1)*(x25)))+(((x18)*(x3))));
x38=((IkReal(-1.00000000000000))*(x37));
x39=((x33)+(((IkReal(-1.00000000000000))*(x34))));
x40=((((x2)*(x31)))+(((IkReal(-1.00000000000000))*(x35))));
x41=((x37)*(x5));
x42=((x38)*(x6));
x43=((((IkReal(-1.00000000000000))*(x0)*(x1)*(x25)))+(((IkReal(-1.00000000000000))*(x18)*(x27))));
x44=((((x18)*(x27)))+(((x0)*(x1)*(x25))));
IkReal x56=((IkReal(1.00000000000000))*(x16));
x45=((((IkReal(-1.00000000000000))*(x2)*(x3)*(x56)))+(((IkReal(-1.00000000000000))*(x30)*(x56))));
x46=((((x16)*(x30)))+(((x16)*(x2)*(x3))));
x47=((x39)*(x6));
x48=((x40)*(x6));
x49=((x11)*(x43));
x50=((x11)*(x45));
x51=((x47)+(((IkReal(-1.00000000000000))*(x16)*(x5))));
x52=((x48)+(((x0)*(x5))));
x53=((((IkReal(-1.00000000000000))*(x16)*(x6)))+(((x5)*(((x34)+(((IkReal(-1.00000000000000))*(x0)*(x32))))))));
x54=((((x5)*(((((IkReal(-1.00000000000000))*(x1)*(x16)*(x2)))+(x35)))))+(((x0)*(x6))));
x55=((x10)*(x51));
eerot[0]=((((x8)*(((x55)+(x49)))))+(((x53)*(x9))));
eerot[1]=((((x9)*(((((IkReal(-1.00000000000000))*(x15)*(x43)))+(((IkReal(-1.00000000000000))*(x14)*(x51)))))))+(((x53)*(x8))));
eerot[2]=((((x10)*(x44)))+(((x11)*(x51))));
eetrans[0]=((((x10)*(((((x12)*(x27)))+(((x20)*(x30)))))))+(((x13)*(x7)))+(((IkReal(0.350000000000000))*(x27)))+(((x0)*(x19)*(x4)))+(((x5)*(((((x0)*(x1)*(x24)))+(((IkReal(-1.00000000000000))*(x17)*(x27)))))))+(((x11)*(((((x23)*(x39)))+(((IkReal(-1.00000000000000))*(x22)*(x5)))))))+(((x21)*(x27))));
eerot[3]=((((x54)*(x9)))+(((x8)*(((x50)+(((x10)*(x52))))))));
eerot[4]=((((x54)*(x8)))+(((x9)*(((((IkReal(-1.00000000000000))*(x15)*(x45)))+(((IkReal(-1.00000000000000))*(x14)*(x52))))))));
eerot[5]=((((x11)*(x52)))+(((x10)*(x46))));
eetrans[1]=((((x21)*(x26)))+(((IkReal(-1.00000000000000))*(x0)*(x13)))+(((x19)*(x4)*(x7)))+(((IkReal(0.350000000000000))*(x26)))+(((x10)*(((((x22)*(x30)))+(((x12)*(x26)))))))+(((x11)*(((((x23)*(x40)))+(((x20)*(x5)))))))+(((x5)*(((((x24)*(x31)))+(((IkReal(-1.00000000000000))*(x17)*(x26))))))));
eerot[6]=((((x41)*(x9)))+(((x8)*(((((x11)*(x36)))+(((x10)*(x42))))))));
eerot[7]=((((x41)*(x8)))+(((x9)*(((((IkReal(-1.00000000000000))*(x14)*(x42)))+(((IkReal(-1.00000000000000))*(x15)*(x36))))))));
eerot[8]=((((x10)*(((x32)+(((IkReal(-1.00000000000000))*(x25)*(x3)))))))+(((x29)*(x38))));
IkReal x57=((IkReal(1.00000000000000))*(x3));
eetrans[2]=((IkReal(0.410000000000000))+(((x5)*(((((IkReal(-1.00000000000000))*(x1)*(x17)))+(((IkReal(-1.00000000000000))*(x24)*(x57)))))))+(((x10)*(((((x1)*(x12)))+(((IkReal(-0.0650000000000000))*(x28)))))))+(x19)+(((IkReal(-0.350000000000000))*(x28)))+(((x19)*(x2)))+(((x29)*(((((IkReal(-0.0650000000000000))*(x30)))+(((IkReal(-1.00000000000000))*(x12)*(x57))))))));
}

IKFAST_API int GetNumFreeParameters() { return 0; }
IKFAST_API int* GetFreeParameters() { return NULL; }
IKFAST_API int GetNumJoints() { return 6; }

IKFAST_API int GetIkRealSize() { return sizeof(IkReal); }

IKFAST_API int GetIkType() { return 0x67000001; }

class IKSolver {
public:
IkReal j0,cj0,sj0,htj0,j1,cj1,sj1,htj1,j2,cj2,sj2,htj2,j3,cj3,sj3,htj3,j4,cj4,sj4,htj4,j5,cj5,sj5,htj5,new_r00,r00,rxp0_0,new_r01,r01,rxp0_1,new_r02,r02,rxp0_2,new_r10,r10,rxp1_0,new_r11,r11,rxp1_1,new_r12,r12,rxp1_2,new_r20,r20,rxp2_0,new_r21,r21,rxp2_1,new_r22,r22,rxp2_2,new_px,px,npx,new_py,py,npy,new_pz,pz,npz,pp;
unsigned char _ij0[2], _nj0,_ij1[2], _nj1,_ij2[2], _nj2,_ij3[2], _nj3,_ij4[2], _nj4,_ij5[2], _nj5;

bool ComputeIk(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions) {
j0=numeric_limits<IkReal>::quiet_NaN(); _ij0[0] = -1; _ij0[1] = -1; _nj0 = -1; j1=numeric_limits<IkReal>::quiet_NaN(); _ij1[0] = -1; _ij1[1] = -1; _nj1 = -1; j2=numeric_limits<IkReal>::quiet_NaN(); _ij2[0] = -1; _ij2[1] = -1; _nj2 = -1; j3=numeric_limits<IkReal>::quiet_NaN(); _ij3[0] = -1; _ij3[1] = -1; _nj3 = -1; j4=numeric_limits<IkReal>::quiet_NaN(); _ij4[0] = -1; _ij4[1] = -1; _nj4 = -1; j5=numeric_limits<IkReal>::quiet_NaN(); _ij5[0] = -1; _ij5[1] = -1; _nj5 = -1; 
for(int dummyiter = 0; dummyiter < 1; ++dummyiter) {
    solutions.Clear();
r00 = eerot[0*3+0];
r01 = eerot[0*3+1];
r02 = eerot[0*3+2];
r10 = eerot[1*3+0];
r11 = eerot[1*3+1];
r12 = eerot[1*3+2];
r20 = eerot[2*3+0];
r21 = eerot[2*3+1];
r22 = eerot[2*3+2];
px = eetrans[0]; py = eetrans[1]; pz = eetrans[2];

new_r00=r00;
new_r01=r01;
new_r02=r02;
new_px=((px)+(((IkReal(-0.0650000000000000))*(r02))));
new_r10=r10;
new_r11=r11;
new_r12=r12;
new_py=((((IkReal(-0.0650000000000000))*(r12)))+(py));
new_r20=r20;
new_r21=r21;
new_r22=r22;
new_pz=((IkReal(-0.410000000000000))+(((IkReal(-0.0650000000000000))*(r22)))+(pz));
r00 = new_r00; r01 = new_r01; r02 = new_r02; r10 = new_r10; r11 = new_r11; r12 = new_r12; r20 = new_r20; r21 = new_r21; r22 = new_r22; px = new_px; py = new_py; pz = new_pz;
pp=(((px)*(px))+((pz)*(pz))+((py)*(py)));
npx=((((py)*(r10)))+(((pz)*(r20)))+(((px)*(r00))));
npy=((((px)*(r01)))+(((pz)*(r21)))+(((py)*(r11))));
npz=((((py)*(r12)))+(((pz)*(r22)))+(((px)*(r02))));
rxp0_0=((((IkReal(-1.00000000000000))*(py)*(r20)))+(((pz)*(r10))));
rxp0_1=((((px)*(r20)))+(((IkReal(-1.00000000000000))*(pz)*(r00))));
rxp0_2=((((py)*(r00)))+(((IkReal(-1.00000000000000))*(px)*(r10))));
rxp1_0=((((pz)*(r11)))+(((IkReal(-1.00000000000000))*(py)*(r21))));
rxp1_1=((((IkReal(-1.00000000000000))*(pz)*(r01)))+(((px)*(r21))));
rxp1_2=((((py)*(r01)))+(((IkReal(-1.00000000000000))*(px)*(r11))));
rxp2_0=((((IkReal(-1.00000000000000))*(py)*(r22)))+(((pz)*(r12))));
rxp2_1=((((px)*(r22)))+(((IkReal(-1.00000000000000))*(pz)*(r02))));
rxp2_2=((((py)*(r02)))+(((IkReal(-1.00000000000000))*(px)*(r12))));
IkReal op[8+1], zeror[8];
int numroots;
IkReal gconst0;
gconst0=((((IkReal(-1.00000000000000))*(rxp2_2)))+(((IkReal(0.0950000000000000))*(r20))));
IkReal gconst1;
gconst1=((IkReal(-0.190000000000000))*(r21));
IkReal gconst2;
gconst2=((((IkReal(-1.00000000000000))*(rxp2_2)))+(((IkReal(-0.0950000000000000))*(r20))));
IkReal gconst3;
gconst3=((IkReal(-0.00902500000000000))+(((IkReal(-0.190000000000000))*(npy)))+(((IkReal(0.700000000000000))*(npz)))+(((IkReal(-1.00000000000000))*(pp))));
IkReal gconst4;
gconst4=((IkReal(-0.380000000000000))*(npx));
IkReal gconst5;
gconst5=((IkReal(-0.00902500000000000))+(((IkReal(0.700000000000000))*(npz)))+(((IkReal(-1.00000000000000))*(pp)))+(((IkReal(0.190000000000000))*(npy))));
IkReal gconst6;
gconst6=((((IkReal(-1.00000000000000))*(rxp2_2)))+(((IkReal(0.0950000000000000))*(r20))));
IkReal gconst7;
gconst7=((IkReal(-0.190000000000000))*(r21));
IkReal gconst8;
gconst8=((((IkReal(-1.00000000000000))*(rxp2_2)))+(((IkReal(-0.0950000000000000))*(r20))));
IkReal gconst9;
gconst9=((IkReal(-0.00902500000000000))+(((IkReal(-0.190000000000000))*(npy)))+(((IkReal(0.700000000000000))*(npz)))+(((IkReal(-1.00000000000000))*(pp))));
IkReal gconst10;
gconst10=((IkReal(-0.380000000000000))*(npx));
IkReal gconst11;
gconst11=((IkReal(-0.00902500000000000))+(((IkReal(0.700000000000000))*(npz)))+(((IkReal(-1.00000000000000))*(pp)))+(((IkReal(0.190000000000000))*(npy))));
IkReal gconst12;
gconst12=((((IkReal(0.190000000000000))*(r22)))+(((IkReal(2.00000000000000))*(rxp0_2))));
IkReal gconst13;
gconst13=((IkReal(-4.00000000000000))*(rxp1_2));
IkReal gconst14;
gconst14=((((IkReal(-2.00000000000000))*(rxp0_2)))+(((IkReal(0.190000000000000))*(r22))));
IkReal gconst15;
gconst15=((IkReal(-1.40000000000000))*(npx));
IkReal gconst16;
gconst16=((IkReal(2.80000000000000))*(npy));
IkReal gconst17;
gconst17=((IkReal(1.40000000000000))*(npx));
IkReal gconst18;
gconst18=((((IkReal(0.190000000000000))*(r22)))+(((IkReal(2.00000000000000))*(rxp0_2))));
IkReal gconst19;
gconst19=((IkReal(-4.00000000000000))*(rxp1_2));
IkReal gconst20;
gconst20=((((IkReal(-2.00000000000000))*(rxp0_2)))+(((IkReal(0.190000000000000))*(r22))));
IkReal gconst21;
gconst21=((IkReal(-1.40000000000000))*(npx));
IkReal gconst22;
gconst22=((IkReal(2.80000000000000))*(npy));
IkReal gconst23;
gconst23=((IkReal(1.40000000000000))*(npx));
IkReal gconst24;
gconst24=((rxp2_2)+(((IkReal(-0.0950000000000000))*(r20))));
IkReal gconst25;
gconst25=((IkReal(0.190000000000000))*(r21));
IkReal gconst26;
gconst26=((rxp2_2)+(((IkReal(0.0950000000000000))*(r20))));
IkReal gconst27;
gconst27=((IkReal(-0.00902500000000000))+(((IkReal(-0.700000000000000))*(npz)))+(((IkReal(-0.190000000000000))*(npy)))+(((IkReal(-1.00000000000000))*(pp))));
IkReal gconst28;
gconst28=((IkReal(-0.380000000000000))*(npx));
IkReal gconst29;
gconst29=((IkReal(-0.00902500000000000))+(((IkReal(-0.700000000000000))*(npz)))+(((IkReal(-1.00000000000000))*(pp)))+(((IkReal(0.190000000000000))*(npy))));
IkReal gconst30;
gconst30=((rxp2_2)+(((IkReal(-0.0950000000000000))*(r20))));
IkReal gconst31;
gconst31=((IkReal(0.190000000000000))*(r21));
IkReal gconst32;
gconst32=((rxp2_2)+(((IkReal(0.0950000000000000))*(r20))));
IkReal gconst33;
gconst33=((IkReal(-0.00902500000000000))+(((IkReal(-0.700000000000000))*(npz)))+(((IkReal(-0.190000000000000))*(npy)))+(((IkReal(-1.00000000000000))*(pp))));
IkReal gconst34;
gconst34=((IkReal(-0.380000000000000))*(npx));
IkReal gconst35;
gconst35=((IkReal(-0.00902500000000000))+(((IkReal(-0.700000000000000))*(npz)))+(((IkReal(-1.00000000000000))*(pp)))+(((IkReal(0.190000000000000))*(npy))));
IkReal x58=((IkReal(1.00000000000000))*(gconst26));
IkReal x59=((gconst30)*(gconst34));
IkReal x60=((gconst31)*(gconst33));
IkReal x61=((IkReal(1.00000000000000))*(gconst17));
IkReal x62=((gconst2)*(gconst6));
IkReal x63=((gconst11)*(gconst3));
IkReal x64=((gconst25)*(gconst29));
IkReal x65=((gconst14)*(gconst28));
IkReal x66=((gconst0)*(gconst5));
IkReal x67=((IkReal(1.00000000000000))*(gconst6));
IkReal x68=((IkReal(1.00000000000000))*(gconst14));
IkReal x69=((gconst21)*(gconst32));
IkReal x70=((gconst10)*(gconst6));
IkReal x71=((gconst21)*(gconst8));
IkReal x72=((gconst13)*(gconst5));
IkReal x73=((gconst7)*(gconst9));
IkReal x74=((gconst30)*(gconst35));
IkReal x75=((gconst26)*(gconst27));
IkReal x76=((gconst22)*(gconst30));
IkReal x77=((IkReal(1.00000000000000))*(gconst29));
IkReal x78=((gconst19)*(gconst33));
IkReal x79=((gconst26)*(gconst28));
IkReal x80=((gconst2)*(gconst4));
IkReal x81=((gconst18)*(gconst35));
IkReal x82=((gconst1)*(gconst5));
IkReal x83=((gconst21)*(gconst7));
IkReal x84=((gconst12)*(gconst5));
IkReal x85=((gconst18)*(gconst34));
IkReal x86=((gconst23)*(gconst30));
IkReal x87=((gconst3)*(gconst8));
IkReal x88=((gconst29)*(gconst33));
IkReal x89=((gconst32)*(gconst33));
IkReal x90=((gconst8)*(gconst9));
IkReal x91=((gconst21)*(gconst31));
IkReal x92=((gconst18)*(gconst2));
IkReal x93=((gconst14)*(gconst6));
IkReal x94=((gconst19)*(gconst9));
IkReal x95=((IkReal(1.00000000000000))*(gconst10)*(gconst4));
IkReal x96=((gconst27)*(x89));
IkReal x97=((IkReal(1.00000000000000))*(gconst2)*(gconst9));
op[0]=((((IkReal(-1.00000000000000))*(x58)*(x96)))+(((x60)*(x79)))+(((IkReal(-1.00000000000000))*(x60)*(x64)))+(((x59)*(x64)))+(((IkReal(-1.00000000000000))*(gconst28)*(x58)*(x59)))+(((x74)*(x75)))+(((IkReal(-1.00000000000000))*(gconst24)*(x74)*(x77)))+(((gconst24)*(gconst32)*(x88))));
op[1]=((((IkReal(-1.00000000000000))*(gconst24)*(x77)*(x86)))+(((gconst17)*(gconst25)*(x59)))+(((gconst16)*(gconst26)*(x60)))+(((x75)*(x81)))+(((IkReal(-1.00000000000000))*(gconst15)*(x58)*(x89)))+(((IkReal(-1.00000000000000))*(gconst16)*(x58)*(x59)))+(((IkReal(-1.00000000000000))*(gconst24)*(x61)*(x74)))+(((IkReal(-1.00000000000000))*(gconst28)*(x58)*(x85)))+(((x60)*(x65)))+(((gconst12)*(gconst32)*(x88)))+(((IkReal(-1.00000000000000))*(gconst28)*(x58)*(x76)))+(((IkReal(-1.00000000000000))*(gconst24)*(x77)*(x81)))+(((x78)*(x79)))+(((IkReal(-1.00000000000000))*(gconst27)*(x58)*(x69)))+(((IkReal(-1.00000000000000))*(x64)*(x91)))+(((IkReal(-1.00000000000000))*(gconst25)*(x60)*(x61)))+(((x64)*(x85)))+(((x75)*(x86)))+(((x64)*(x76)))+(((x79)*(x91)))+(((IkReal(-1.00000000000000))*(x64)*(x78)))+(((gconst14)*(gconst27)*(x74)))+(((gconst15)*(gconst26)*(x74)))+(((gconst13)*(gconst29)*(x59)))+(((IkReal(-1.00000000000000))*(gconst20)*(gconst27)*(gconst33)*(x58)))+(((gconst24)*(gconst29)*(x69)))+(((gconst17)*(gconst24)*(x89)))+(((IkReal(-1.00000000000000))*(gconst13)*(x60)*(x77)))+(((IkReal(-1.00000000000000))*(x68)*(x96)))+(((IkReal(-1.00000000000000))*(gconst12)*(x74)*(x77)))+(((IkReal(-1.00000000000000))*(x59)*(x65)))+(((gconst20)*(gconst24)*(x88))));
op[2]=((((gconst17)*(gconst21)*(gconst24)*(gconst32)))+(((gconst15)*(gconst23)*(gconst26)*(gconst30)))+(((IkReal(-1.00000000000000))*(gconst24)*(gconst29)*(gconst35)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst26)*(gconst3)*(gconst32)*(gconst33)))+(((IkReal(-1.00000000000000))*(gconst13)*(gconst21)*(gconst29)*(gconst31)))+(((gconst13)*(gconst22)*(gconst29)*(gconst30)))+(((gconst24)*(gconst32)*(gconst33)*(gconst5)))+(((gconst14)*(gconst23)*(gconst27)*(gconst30)))+(((IkReal(-1.00000000000000))*(gconst12)*(gconst18)*(gconst29)*(gconst35)))+(((IkReal(-1.00000000000000))*(gconst16)*(gconst22)*(gconst26)*(gconst30)))+(((gconst16)*(gconst19)*(gconst26)*(gconst33)))+(((IkReal(-1.00000000000000))*(gconst25)*(gconst29)*(gconst33)*(gconst7)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst16)*(gconst30)*(gconst34)))+(((gconst14)*(gconst16)*(gconst31)*(gconst33)))+(((gconst0)*(gconst29)*(gconst32)*(gconst33)))+(((gconst2)*(gconst28)*(gconst31)*(gconst33)))+(((IkReal(-1.00000000000000))*(gconst0)*(gconst29)*(gconst30)*(gconst35)))+(((IkReal(-1.00000000000000))*(gconst20)*(gconst21)*(gconst26)*(gconst27)))+(((gconst13)*(gconst18)*(gconst29)*(gconst34)))+(((gconst10)*(gconst25)*(gconst29)*(gconst30)))+(((gconst14)*(gconst21)*(gconst28)*(gconst31)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst20)*(gconst27)*(gconst33)))+(((IkReal(-1.00000000000000))*(gconst26)*(gconst28)*(gconst34)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst18)*(gconst23)*(gconst24)*(gconst29)))+(((gconst25)*(gconst30)*(gconst34)*(gconst5)))+(((gconst14)*(gconst19)*(gconst28)*(gconst33)))+(((gconst26)*(gconst3)*(gconst30)*(gconst35)))+(((gconst20)*(gconst21)*(gconst24)*(gconst29)))+(((IkReal(-1.00000000000000))*(gconst17)*(gconst23)*(gconst24)*(gconst30)))+(((IkReal(-1.00000000000000))*(gconst18)*(gconst22)*(gconst26)*(gconst28)))+(((IkReal(-1.00000000000000))*(gconst16)*(gconst18)*(gconst26)*(gconst34)))+(((IkReal(-1.00000000000000))*(gconst19)*(gconst21)*(gconst25)*(gconst29)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst21)*(gconst27)*(gconst32)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst18)*(gconst28)*(gconst34)))+(((IkReal(-1.00000000000000))*(gconst12)*(gconst23)*(gconst29)*(gconst30)))+(((gconst11)*(gconst26)*(gconst27)*(gconst30)))+(((IkReal(-1.00000000000000))*(gconst17)*(gconst18)*(gconst24)*(gconst35)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst15)*(gconst32)*(gconst33)))+(((gconst13)*(gconst17)*(gconst30)*(gconst34)))+(((gconst17)*(gconst18)*(gconst25)*(gconst34)))+(((IkReal(-1.00000000000000))*(gconst2)*(gconst27)*(gconst32)*(gconst33)))+(((gconst25)*(gconst29)*(gconst34)*(gconst6)))+(((gconst24)*(gconst29)*(gconst33)*(gconst8)))+(((gconst16)*(gconst21)*(gconst26)*(gconst31)))+(((IkReal(-1.00000000000000))*(gconst17)*(gconst19)*(gconst25)*(gconst33)))+(((gconst18)*(gconst22)*(gconst25)*(gconst29)))+(((gconst1)*(gconst29)*(gconst30)*(gconst34)))+(((IkReal(-1.00000000000000))*(gconst26)*(gconst30)*(gconst34)*(gconst4)))+(((gconst15)*(gconst18)*(gconst26)*(gconst35)))+(((gconst12)*(gconst17)*(gconst32)*(gconst33)))+(((gconst26)*(gconst28)*(gconst33)*(gconst7)))+(((gconst26)*(gconst28)*(gconst31)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst24)*(gconst30)*(gconst35)*(gconst5)))+(((gconst19)*(gconst21)*(gconst26)*(gconst28)))+(((IkReal(-1.00000000000000))*(gconst10)*(gconst26)*(gconst28)*(gconst30)))+(((gconst2)*(gconst27)*(gconst30)*(gconst35)))+(((IkReal(-1.00000000000000))*(gconst12)*(gconst17)*(gconst30)*(gconst35)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst22)*(gconst28)*(gconst30)))+(((IkReal(-1.00000000000000))*(gconst26)*(gconst27)*(gconst32)*(gconst9)))+(((gconst14)*(gconst15)*(gconst30)*(gconst35)))+(((IkReal(-1.00000000000000))*(gconst11)*(gconst24)*(gconst29)*(gconst30)))+(((IkReal(-1.00000000000000))*(gconst25)*(gconst31)*(gconst33)*(gconst5)))+(((gconst26)*(gconst31)*(gconst33)*(gconst4)))+(((IkReal(-1.00000000000000))*(gconst13)*(gconst17)*(gconst31)*(gconst33)))+(((gconst12)*(gconst20)*(gconst29)*(gconst33)))+(((gconst18)*(gconst23)*(gconst26)*(gconst27)))+(((IkReal(-1.00000000000000))*(gconst15)*(gconst21)*(gconst26)*(gconst32)))+(((gconst24)*(gconst29)*(gconst32)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst2)*(gconst28)*(gconst30)*(gconst34)))+(((gconst17)*(gconst22)*(gconst25)*(gconst30)))+(((IkReal(-1.00000000000000))*(gconst1)*(gconst29)*(gconst31)*(gconst33)))+(((gconst26)*(gconst27)*(gconst35)*(gconst6)))+(((gconst12)*(gconst21)*(gconst29)*(gconst32)))+(((gconst14)*(gconst18)*(gconst27)*(gconst35)))+(((IkReal(-1.00000000000000))*(gconst17)*(gconst21)*(gconst25)*(gconst31)))+(((IkReal(-1.00000000000000))*(gconst26)*(gconst27)*(gconst33)*(gconst8)))+(((IkReal(-1.00000000000000))*(gconst13)*(gconst19)*(gconst29)*(gconst33)))+(((gconst17)*(gconst20)*(gconst24)*(gconst33)))+(((IkReal(-1.00000000000000))*(gconst25)*(gconst29)*(gconst31)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst15)*(gconst20)*(gconst26)*(gconst33))));
op[3]=((((IkReal(-1.00000000000000))*(gconst14)*(gconst27)*(gconst33)*(gconst8)))+(((IkReal(-1.00000000000000))*(gconst15)*(gconst26)*(gconst32)*(gconst9)))+(((gconst14)*(gconst16)*(gconst19)*(gconst33)))+(((gconst12)*(gconst29)*(gconst32)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst21)*(gconst25)*(gconst31)*(gconst5)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst15)*(gconst20)*(gconst33)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst20)*(gconst21)*(gconst27)))+(((gconst10)*(gconst18)*(gconst25)*(gconst29)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst27)*(gconst32)*(gconst9)))+(((gconst13)*(gconst30)*(gconst34)*(gconst5)))+(((gconst21)*(gconst26)*(gconst28)*(gconst7)))+(((gconst17)*(gconst24)*(gconst33)*(gconst8)))+(((gconst15)*(gconst18)*(gconst23)*(gconst26)))+(((gconst13)*(gconst17)*(gconst22)*(gconst30)))+(((IkReal(-1.00000000000000))*(gconst18)*(gconst24)*(gconst35)*(gconst5)))+(((gconst17)*(gconst24)*(gconst32)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst10)*(gconst14)*(gconst28)*(gconst30)))+(((IkReal(-1.00000000000000))*(gconst2)*(gconst21)*(gconst27)*(gconst32)))+(((gconst14)*(gconst27)*(gconst35)*(gconst6)))+(((gconst20)*(gconst24)*(gconst29)*(gconst9)))+(((gconst18)*(gconst26)*(gconst3)*(gconst35)))+(((gconst2)*(gconst23)*(gconst27)*(gconst30)))+(((gconst14)*(gconst16)*(gconst21)*(gconst31)))+(((gconst22)*(gconst25)*(gconst29)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst19)*(gconst25)*(gconst29)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst2)*(gconst22)*(gconst28)*(gconst30)))+(((gconst0)*(gconst21)*(gconst29)*(gconst32)))+(((IkReal(-1.00000000000000))*(gconst17)*(gconst25)*(gconst33)*(gconst7)))+(((gconst15)*(gconst2)*(gconst30)*(gconst35)))+(((gconst1)*(gconst18)*(gconst29)*(gconst34)))+(((IkReal(-1.00000000000000))*(gconst17)*(gconst25)*(gconst31)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst11)*(gconst12)*(gconst29)*(gconst30)))+(((IkReal(-1.00000000000000))*(gconst16)*(gconst26)*(gconst34)*(gconst6)))+(((gconst11)*(gconst18)*(gconst26)*(gconst27)))+(((IkReal(-1.00000000000000))*(gconst17)*(gconst18)*(gconst23)*(gconst24)))+(((IkReal(-1.00000000000000))*(gconst12)*(gconst17)*(gconst18)*(gconst35)))+(((gconst14)*(gconst19)*(gconst21)*(gconst28)))+(((gconst12)*(gconst17)*(gconst21)*(gconst32)))+(((gconst23)*(gconst26)*(gconst3)*(gconst30)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst16)*(gconst22)*(gconst30)))+(((IkReal(-1.00000000000000))*(gconst10)*(gconst16)*(gconst26)*(gconst30)))+(((gconst12)*(gconst32)*(gconst33)*(gconst5)))+(((gconst14)*(gconst28)*(gconst31)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst15)*(gconst21)*(gconst32)))+(((IkReal(-1.00000000000000))*(gconst20)*(gconst26)*(gconst27)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst17)*(gconst24)*(gconst35)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst17)*(gconst19)*(gconst21)*(gconst25)))+(((IkReal(-1.00000000000000))*(gconst1)*(gconst19)*(gconst29)*(gconst33)))+(((gconst2)*(gconst21)*(gconst28)*(gconst31)))+(((IkReal(-1.00000000000000))*(gconst12)*(gconst18)*(gconst23)*(gconst29)))+(((IkReal(-1.00000000000000))*(gconst21)*(gconst26)*(gconst27)*(gconst8)))+(((gconst10)*(gconst13)*(gconst29)*(gconst30)))+(((IkReal(-1.00000000000000))*(gconst11)*(gconst17)*(gconst24)*(gconst30)))+(((IkReal(-1.00000000000000))*(gconst1)*(gconst17)*(gconst31)*(gconst33)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst30)*(gconst34)*(gconst4)))+(((IkReal(-1.00000000000000))*(gconst18)*(gconst26)*(gconst34)*(gconst4)))+(((IkReal(-1.00000000000000))*(gconst23)*(gconst24)*(gconst30)*(gconst5)))+(((gconst16)*(gconst19)*(gconst21)*(gconst26)))+(((gconst14)*(gconst18)*(gconst23)*(gconst27)))+(((IkReal(-1.00000000000000))*(gconst19)*(gconst25)*(gconst33)*(gconst5)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst16)*(gconst18)*(gconst34)))+(((gconst17)*(gconst25)*(gconst34)*(gconst6)))+(((gconst14)*(gconst31)*(gconst33)*(gconst4)))+(((gconst17)*(gconst20)*(gconst21)*(gconst24)))+(((gconst21)*(gconst26)*(gconst31)*(gconst4)))+(((gconst13)*(gconst17)*(gconst18)*(gconst34)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst18)*(gconst22)*(gconst28)))+(((IkReal(-1.00000000000000))*(gconst21)*(gconst26)*(gconst3)*(gconst32)))+(((IkReal(-1.00000000000000))*(gconst0)*(gconst17)*(gconst30)*(gconst35)))+(((gconst1)*(gconst22)*(gconst29)*(gconst30)))+(((gconst21)*(gconst24)*(gconst29)*(gconst8)))+(((gconst14)*(gconst28)*(gconst33)*(gconst7)))+(((gconst0)*(gconst17)*(gconst32)*(gconst33)))+(((gconst11)*(gconst15)*(gconst26)*(gconst30)))+(((gconst14)*(gconst15)*(gconst18)*(gconst35)))+(((IkReal(-1.00000000000000))*(gconst22)*(gconst26)*(gconst28)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst12)*(gconst29)*(gconst35)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst0)*(gconst23)*(gconst29)*(gconst30)))+(((IkReal(-1.00000000000000))*(gconst22)*(gconst26)*(gconst30)*(gconst4)))+(((IkReal(-1.00000000000000))*(gconst10)*(gconst18)*(gconst26)*(gconst28)))+(((gconst14)*(gconst15)*(gconst23)*(gconst30)))+(((gconst12)*(gconst17)*(gconst20)*(gconst33)))+(((gconst12)*(gconst29)*(gconst33)*(gconst8)))+(((IkReal(-1.00000000000000))*(gconst13)*(gconst19)*(gconst21)*(gconst29)))+(((gconst19)*(gconst26)*(gconst28)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst15)*(gconst2)*(gconst32)*(gconst33)))+(((gconst20)*(gconst24)*(gconst33)*(gconst5)))+(((IkReal(-1.00000000000000))*(gconst16)*(gconst2)*(gconst30)*(gconst34)))+(((gconst18)*(gconst25)*(gconst34)*(gconst5)))+(((gconst19)*(gconst26)*(gconst33)*(gconst4)))+(((IkReal(-1.00000000000000))*(gconst23)*(gconst24)*(gconst29)*(gconst6)))+(((gconst13)*(gconst18)*(gconst22)*(gconst29)))+(((gconst16)*(gconst26)*(gconst31)*(gconst9)))+(((gconst16)*(gconst2)*(gconst31)*(gconst33)))+(((gconst11)*(gconst14)*(gconst27)*(gconst30)))+(((IkReal(-1.00000000000000))*(gconst13)*(gconst29)*(gconst33)*(gconst7)))+(((IkReal(-1.00000000000000))*(gconst13)*(gconst31)*(gconst33)*(gconst5)))+(((gconst23)*(gconst26)*(gconst27)*(gconst6)))+(((gconst16)*(gconst26)*(gconst33)*(gconst7)))+(((IkReal(-1.00000000000000))*(gconst12)*(gconst17)*(gconst23)*(gconst30)))+(((IkReal(-1.00000000000000))*(gconst15)*(gconst26)*(gconst33)*(gconst8)))+(((IkReal(-1.00000000000000))*(gconst21)*(gconst25)*(gconst29)*(gconst7)))+(((gconst22)*(gconst25)*(gconst30)*(gconst5)))+(((gconst18)*(gconst2)*(gconst27)*(gconst35)))+(((gconst21)*(gconst24)*(gconst32)*(gconst5)))+(((IkReal(-1.00000000000000))*(gconst13)*(gconst17)*(gconst19)*(gconst33)))+(((gconst19)*(gconst2)*(gconst28)*(gconst33)))+(((IkReal(-1.00000000000000))*(gconst20)*(gconst26)*(gconst3)*(gconst33)))+(((gconst12)*(gconst20)*(gconst21)*(gconst29)))+(((IkReal(-1.00000000000000))*(gconst15)*(gconst20)*(gconst21)*(gconst26)))+(((gconst15)*(gconst26)*(gconst35)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst13)*(gconst29)*(gconst31)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst13)*(gconst17)*(gconst21)*(gconst31)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst28)*(gconst34)*(gconst6)))+(((gconst14)*(gconst3)*(gconst30)*(gconst35)))+(((gconst1)*(gconst17)*(gconst30)*(gconst34)))+(((IkReal(-1.00000000000000))*(gconst12)*(gconst30)*(gconst35)*(gconst5)))+(((IkReal(-1.00000000000000))*(gconst11)*(gconst18)*(gconst24)*(gconst29)))+(((gconst0)*(gconst20)*(gconst29)*(gconst33)))+(((IkReal(-1.00000000000000))*(gconst1)*(gconst21)*(gconst29)*(gconst31)))+(((IkReal(-1.00000000000000))*(gconst18)*(gconst2)*(gconst28)*(gconst34)))+(((gconst17)*(gconst18)*(gconst22)*(gconst25)))+(((gconst10)*(gconst17)*(gconst25)*(gconst30)))+(((IkReal(-1.00000000000000))*(gconst16)*(gconst18)*(gconst22)*(gconst26)))+(((IkReal(-1.00000000000000))*(gconst2)*(gconst20)*(gconst27)*(gconst33)))+(((IkReal(-1.00000000000000))*(gconst0)*(gconst18)*(gconst29)*(gconst35)))+(((gconst13)*(gconst29)*(gconst34)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst3)*(gconst32)*(gconst33))));
op[4]=((((gconst0)*(gconst32)*(gconst33)*(gconst5)))+(((gconst12)*(gconst20)*(gconst33)*(gconst5)))+(((IkReal(-1.00000000000000))*(gconst26)*(gconst3)*(gconst32)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst18)*(gconst34)*(gconst4)))+(((IkReal(-1.00000000000000))*(gconst1)*(gconst29)*(gconst31)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst10)*(gconst16)*(gconst18)*(gconst26)))+(((gconst24)*(gconst33)*(gconst5)*(gconst8)))+(((gconst0)*(gconst20)*(gconst21)*(gconst29)))+(((gconst11)*(gconst26)*(gconst27)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst15)*(gconst20)*(gconst21)))+(((IkReal(-1.00000000000000))*(gconst10)*(gconst2)*(gconst28)*(gconst30)))+(((IkReal(-1.00000000000000))*(gconst26)*(gconst34)*(gconst4)*(gconst6)))+(((gconst26)*(gconst28)*(gconst7)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst12)*(gconst17)*(gconst18)*(gconst23)))+(((gconst2)*(gconst3)*(gconst30)*(gconst35)))+(((gconst12)*(gconst20)*(gconst29)*(gconst9)))+(((gconst12)*(gconst17)*(gconst32)*(gconst9)))+(((gconst13)*(gconst17)*(gconst34)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst2)*(gconst28)*(gconst34)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst18)*(gconst2)*(gconst22)*(gconst28)))+(((IkReal(-1.00000000000000))*(gconst2)*(gconst27)*(gconst33)*(gconst8)))+(((gconst14)*(gconst16)*(gconst19)*(gconst21)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst21)*(gconst27)*(gconst8)))+(((IkReal(-1.00000000000000))*(gconst25)*(gconst31)*(gconst5)*(gconst9)))+(((gconst14)*(gconst21)*(gconst31)*(gconst4)))+(((IkReal(-1.00000000000000))*(gconst1)*(gconst31)*(gconst33)*(gconst5)))+(((gconst24)*(gconst32)*(gconst5)*(gconst9)))+(((gconst12)*(gconst21)*(gconst32)*(gconst5)))+(((gconst12)*(gconst17)*(gconst33)*(gconst8)))+(((IkReal(-1.00000000000000))*(gconst12)*(gconst18)*(gconst35)*(gconst5)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst22)*(gconst28)*(gconst6)))+(((gconst10)*(gconst25)*(gconst30)*(gconst5)))+(((IkReal(-1.00000000000000))*(gconst2)*(gconst30)*(gconst34)*(gconst4)))+(((gconst19)*(gconst2)*(gconst21)*(gconst28)))+(((gconst14)*(gconst19)*(gconst28)*(gconst9)))+(((gconst1)*(gconst17)*(gconst22)*(gconst30)))+(((gconst14)*(gconst15)*(gconst35)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst26)*(gconst27)*(gconst8)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst10)*(gconst26)*(gconst28)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst20)*(gconst27)*(gconst9)))+(((gconst2)*(gconst28)*(gconst31)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst17)*(gconst23)*(gconst24)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst26)*(gconst3)*(gconst33)*(gconst8)))+(((IkReal(-1.00000000000000))*(gconst25)*(gconst29)*(gconst7)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst21)*(gconst3)*(gconst32)))+(((IkReal(-1.00000000000000))*(gconst1)*(gconst17)*(gconst21)*(gconst31)))+(((IkReal(-1.00000000000000))*(gconst17)*(gconst21)*(gconst25)*(gconst7)))+(((gconst0)*(gconst17)*(gconst21)*(gconst32)))+(((gconst20)*(gconst21)*(gconst24)*(gconst5)))+(((IkReal(-1.00000000000000))*(gconst17)*(gconst19)*(gconst25)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst16)*(gconst2)*(gconst22)*(gconst30)))+(((IkReal(-1.00000000000000))*(gconst13)*(gconst17)*(gconst31)*(gconst9)))+(((gconst1)*(gconst30)*(gconst34)*(gconst5)))+(((gconst18)*(gconst22)*(gconst25)*(gconst5)))+(((IkReal(-1.00000000000000))*(gconst19)*(gconst21)*(gconst25)*(gconst5)))+(((gconst14)*(gconst21)*(gconst28)*(gconst7)))+(((IkReal(-1.00000000000000))*(gconst11)*(gconst24)*(gconst29)*(gconst6)))+(((gconst12)*(gconst17)*(gconst20)*(gconst21)))+(((gconst14)*(gconst23)*(gconst27)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst12)*(gconst23)*(gconst29)*(gconst6)))+(((gconst17)*(gconst22)*(gconst25)*(gconst6)))+(((gconst16)*(gconst21)*(gconst26)*(gconst7)))+(((IkReal(-1.00000000000000))*(gconst15)*(gconst2)*(gconst20)*(gconst33)))+(((IkReal(-1.00000000000000))*(gconst0)*(gconst17)*(gconst23)*(gconst30)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst20)*(gconst3)*(gconst33)))+(((IkReal(-1.00000000000000))*(gconst16)*(gconst18)*(gconst2)*(gconst34)))+(((gconst13)*(gconst17)*(gconst18)*(gconst22)))+(((IkReal(-1.00000000000000))*(gconst15)*(gconst21)*(gconst26)*(gconst8)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst16)*(gconst18)*(gconst22)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst16)*(gconst34)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst13)*(gconst19)*(gconst29)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst10)*(gconst14)*(gconst18)*(gconst28)))+(((gconst14)*(gconst23)*(gconst3)*(gconst30)))+(((IkReal(-1.00000000000000))*(gconst11)*(gconst17)*(gconst18)*(gconst24)))+(((gconst14)*(gconst19)*(gconst33)*(gconst4)))+(((gconst13)*(gconst22)*(gconst30)*(gconst5)))+(((gconst10)*(gconst13)*(gconst17)*(gconst30)))+(((gconst1)*(gconst29)*(gconst34)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst0)*(gconst18)*(gconst23)*(gconst29)))+(((gconst17)*(gconst20)*(gconst24)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst0)*(gconst17)*(gconst18)*(gconst35)))+(((IkReal(-1.00000000000000))*(gconst2)*(gconst20)*(gconst21)*(gconst27)))+(((IkReal(-1.00000000000000))*(gconst13)*(gconst17)*(gconst33)*(gconst7)))+(((IkReal(-1.00000000000000))*(gconst16)*(gconst22)*(gconst26)*(gconst6)))+(((gconst15)*(gconst2)*(gconst23)*(gconst30)))+(((IkReal(-1.00000000000000))*(gconst11)*(gconst12)*(gconst18)*(gconst29)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst15)*(gconst33)*(gconst8)))+(((gconst25)*(gconst34)*(gconst5)*(gconst6)))+(((gconst15)*(gconst18)*(gconst2)*(gconst35)))+(((gconst26)*(gconst3)*(gconst35)*(gconst6)))+(((gconst14)*(gconst16)*(gconst33)*(gconst7)))+(((IkReal(-1.00000000000000))*(gconst18)*(gconst23)*(gconst24)*(gconst5)))+(((gconst10)*(gconst13)*(gconst18)*(gconst29)))+(((gconst10)*(gconst17)*(gconst18)*(gconst25)))+(((gconst0)*(gconst17)*(gconst20)*(gconst33)))+(((gconst16)*(gconst19)*(gconst2)*(gconst33)))+(((IkReal(-1.00000000000000))*(gconst11)*(gconst24)*(gconst30)*(gconst5)))+(((IkReal(-1.00000000000000))*(gconst10)*(gconst26)*(gconst30)*(gconst4)))+(((gconst14)*(gconst16)*(gconst31)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst1)*(gconst17)*(gconst19)*(gconst33)))+(((IkReal(-1.00000000000000))*(gconst15)*(gconst20)*(gconst26)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst18)*(gconst22)*(gconst26)*(gconst4)))+(((IkReal(-1.00000000000000))*(gconst10)*(gconst14)*(gconst16)*(gconst30)))+(((IkReal(-1.00000000000000))*(gconst25)*(gconst33)*(gconst5)*(gconst7)))+(((gconst2)*(gconst31)*(gconst33)*(gconst4)))+(((IkReal(-1.00000000000000))*(gconst1)*(gconst19)*(gconst21)*(gconst29)))+(((IkReal(-1.00000000000000))*(gconst2)*(gconst27)*(gconst32)*(gconst9)))+(((gconst1)*(gconst10)*(gconst29)*(gconst30)))+(((gconst14)*(gconst15)*(gconst18)*(gconst23)))+(((IkReal(-1.00000000000000))*(gconst13)*(gconst17)*(gconst19)*(gconst21)))+(((gconst0)*(gconst29)*(gconst32)*(gconst9)))+(((gconst14)*(gconst18)*(gconst3)*(gconst35)))+(((gconst12)*(gconst21)*(gconst29)*(gconst8)))+(((gconst13)*(gconst22)*(gconst29)*(gconst6)))+(((gconst2)*(gconst27)*(gconst35)*(gconst6)))+(((gconst1)*(gconst17)*(gconst18)*(gconst34)))+(((IkReal(-1.00000000000000))*(gconst12)*(gconst17)*(gconst35)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst15)*(gconst32)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst13)*(gconst21)*(gconst31)*(gconst5)))+(((gconst11)*(gconst2)*(gconst27)*(gconst30)))+(((IkReal(-1.00000000000000))*(gconst1)*(gconst29)*(gconst33)*(gconst7)))+(((gconst11)*(gconst14)*(gconst15)*(gconst30)))+(((gconst11)*(gconst26)*(gconst3)*(gconst30)))+(((gconst18)*(gconst2)*(gconst23)*(gconst27)))+(((gconst1)*(gconst18)*(gconst22)*(gconst29)))+(((IkReal(-1.00000000000000))*(gconst13)*(gconst21)*(gconst29)*(gconst7)))+(((gconst24)*(gconst29)*(gconst8)*(gconst9)))+(((gconst2)*(gconst28)*(gconst33)*(gconst7)))+(((IkReal(-1.00000000000000))*(gconst0)*(gconst30)*(gconst35)*(gconst5)))+(((IkReal(-1.00000000000000))*(gconst13)*(gconst19)*(gconst33)*(gconst5)))+(((IkReal(-1.00000000000000))*(gconst15)*(gconst2)*(gconst21)*(gconst32)))+(((IkReal(-1.00000000000000))*(gconst0)*(gconst29)*(gconst35)*(gconst6)))+(((gconst13)*(gconst18)*(gconst34)*(gconst5)))+(((gconst16)*(gconst19)*(gconst26)*(gconst9)))+(((gconst10)*(gconst25)*(gconst29)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst11)*(gconst12)*(gconst17)*(gconst30)))+(((IkReal(-1.00000000000000))*(gconst2)*(gconst3)*(gconst32)*(gconst33)))+(((gconst26)*(gconst31)*(gconst4)*(gconst9)))+(((gconst11)*(gconst14)*(gconst18)*(gconst27)))+(((gconst19)*(gconst21)*(gconst26)*(gconst4)))+(((gconst17)*(gconst21)*(gconst24)*(gconst8)))+(((gconst15)*(gconst23)*(gconst26)*(gconst6)))+(((gconst26)*(gconst33)*(gconst4)*(gconst7)))+(((gconst18)*(gconst23)*(gconst26)*(gconst3)))+(((gconst11)*(gconst15)*(gconst18)*(gconst26)))+(((IkReal(-1.00000000000000))*(gconst12)*(gconst23)*(gconst30)*(gconst5)))+(((gconst16)*(gconst2)*(gconst21)*(gconst31)))+(((IkReal(-1.00000000000000))*(gconst0)*(gconst11)*(gconst29)*(gconst30)))+(((IkReal(-1.00000000000000))*(gconst24)*(gconst35)*(gconst5)*(gconst6)))+(((gconst0)*(gconst29)*(gconst33)*(gconst8)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst22)*(gconst30)*(gconst4)))+(((IkReal(-1.00000000000000))*(gconst20)*(gconst21)*(gconst26)*(gconst3))));
op[5]=((((IkReal(-1.00000000000000))*(gconst1)*(gconst19)*(gconst29)*(gconst9)))+(((gconst2)*(gconst23)*(gconst27)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst1)*(gconst17)*(gconst33)*(gconst7)))+(((IkReal(-1.00000000000000))*(gconst0)*(gconst11)*(gconst18)*(gconst29)))+(((IkReal(-1.00000000000000))*(gconst11)*(gconst12)*(gconst29)*(gconst6)))+(((gconst23)*(gconst26)*(gconst3)*(gconst6)))+(((gconst0)*(gconst17)*(gconst33)*(gconst8)))+(((gconst1)*(gconst17)*(gconst34)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst15)*(gconst2)*(gconst33)*(gconst8)))+(((gconst14)*(gconst31)*(gconst4)*(gconst9)))+(((gconst16)*(gconst2)*(gconst31)*(gconst9)))+(((gconst11)*(gconst18)*(gconst2)*(gconst27)))+(((gconst1)*(gconst18)*(gconst34)*(gconst5)))+(((gconst14)*(gconst28)*(gconst7)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst15)*(gconst20)*(gconst9)))+(((gconst12)*(gconst17)*(gconst20)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst16)*(gconst22)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst10)*(gconst16)*(gconst26)*(gconst6)))+(((gconst13)*(gconst18)*(gconst22)*(gconst5)))+(((IkReal(-1.00000000000000))*(gconst2)*(gconst21)*(gconst3)*(gconst32)))+(((gconst15)*(gconst18)*(gconst2)*(gconst23)))+(((IkReal(-1.00000000000000))*(gconst12)*(gconst35)*(gconst5)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst15)*(gconst26)*(gconst8)*(gconst9)))+(((gconst12)*(gconst32)*(gconst5)*(gconst9)))+(((gconst11)*(gconst18)*(gconst26)*(gconst3)))+(((IkReal(-1.00000000000000))*(gconst13)*(gconst19)*(gconst21)*(gconst5)))+(((gconst11)*(gconst14)*(gconst27)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst1)*(gconst17)*(gconst31)*(gconst9)))+(((gconst2)*(gconst23)*(gconst3)*(gconst30)))+(((IkReal(-1.00000000000000))*(gconst11)*(gconst18)*(gconst24)*(gconst5)))+(((IkReal(-1.00000000000000))*(gconst18)*(gconst2)*(gconst34)*(gconst4)))+(((gconst0)*(gconst17)*(gconst20)*(gconst21)))+(((gconst22)*(gconst25)*(gconst5)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst13)*(gconst33)*(gconst5)*(gconst7)))+(((gconst0)*(gconst17)*(gconst32)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst21)*(gconst25)*(gconst5)*(gconst7)))+(((gconst0)*(gconst20)*(gconst29)*(gconst9)))+(((gconst0)*(gconst20)*(gconst33)*(gconst5)))+(((gconst0)*(gconst21)*(gconst32)*(gconst5)))+(((gconst18)*(gconst2)*(gconst3)*(gconst35)))+(((gconst12)*(gconst17)*(gconst21)*(gconst8)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst3)*(gconst33)*(gconst8)))+(((gconst10)*(gconst17)*(gconst25)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst3)*(gconst32)*(gconst9)))+(((gconst14)*(gconst33)*(gconst4)*(gconst7)))+(((IkReal(-1.00000000000000))*(gconst19)*(gconst25)*(gconst5)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst2)*(gconst20)*(gconst3)*(gconst33)))+(((gconst15)*(gconst2)*(gconst35)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst2)*(gconst22)*(gconst28)*(gconst6)))+(((gconst14)*(gconst15)*(gconst23)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst1)*(gconst21)*(gconst31)*(gconst5)))+(((gconst2)*(gconst21)*(gconst28)*(gconst7)))+(((IkReal(-1.00000000000000))*(gconst11)*(gconst12)*(gconst30)*(gconst5)))+(((gconst19)*(gconst26)*(gconst4)*(gconst9)))+(((gconst11)*(gconst14)*(gconst3)*(gconst30)))+(((IkReal(-1.00000000000000))*(gconst10)*(gconst16)*(gconst2)*(gconst30)))+(((gconst19)*(gconst2)*(gconst33)*(gconst4)))+(((gconst1)*(gconst10)*(gconst18)*(gconst29)))+(((IkReal(-1.00000000000000))*(gconst10)*(gconst18)*(gconst2)*(gconst28)))+(((gconst11)*(gconst15)*(gconst26)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst27)*(gconst8)*(gconst9)))+(((gconst11)*(gconst14)*(gconst15)*(gconst18)))+(((IkReal(-1.00000000000000))*(gconst17)*(gconst25)*(gconst7)*(gconst9)))+(((gconst13)*(gconst34)*(gconst5)*(gconst6)))+(((gconst16)*(gconst2)*(gconst33)*(gconst7)))+(((IkReal(-1.00000000000000))*(gconst12)*(gconst18)*(gconst23)*(gconst5)))+(((IkReal(-1.00000000000000))*(gconst10)*(gconst14)*(gconst28)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst1)*(gconst19)*(gconst33)*(gconst5)))+(((IkReal(-1.00000000000000))*(gconst16)*(gconst18)*(gconst2)*(gconst22)))+(((gconst10)*(gconst13)*(gconst29)*(gconst6)))+(((gconst19)*(gconst2)*(gconst28)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst15)*(gconst21)*(gconst8)))+(((IkReal(-1.00000000000000))*(gconst20)*(gconst26)*(gconst3)*(gconst9)))+(((gconst1)*(gconst10)*(gconst17)*(gconst30)))+(((gconst14)*(gconst18)*(gconst23)*(gconst3)))+(((IkReal(-1.00000000000000))*(gconst2)*(gconst22)*(gconst30)*(gconst4)))+(((gconst16)*(gconst26)*(gconst7)*(gconst9)))+(((gconst21)*(gconst24)*(gconst5)*(gconst8)))+(((IkReal(-1.00000000000000))*(gconst0)*(gconst18)*(gconst35)*(gconst5)))+(((gconst14)*(gconst16)*(gconst19)*(gconst9)))+(((gconst16)*(gconst19)*(gconst2)*(gconst21)))+(((gconst1)*(gconst17)*(gconst18)*(gconst22)))+(((IkReal(-1.00000000000000))*(gconst10)*(gconst14)*(gconst16)*(gconst18)))+(((IkReal(-1.00000000000000))*(gconst0)*(gconst23)*(gconst29)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst0)*(gconst17)*(gconst35)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst20)*(gconst21)*(gconst3)))+(((gconst13)*(gconst17)*(gconst22)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst13)*(gconst17)*(gconst21)*(gconst7)))+(((IkReal(-1.00000000000000))*(gconst21)*(gconst26)*(gconst3)*(gconst8)))+(((IkReal(-1.00000000000000))*(gconst15)*(gconst2)*(gconst32)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst23)*(gconst24)*(gconst5)*(gconst6)))+(((gconst1)*(gconst22)*(gconst29)*(gconst6)))+(((gconst2)*(gconst21)*(gconst31)*(gconst4)))+(((gconst10)*(gconst13)*(gconst30)*(gconst5)))+(((IkReal(-1.00000000000000))*(gconst10)*(gconst18)*(gconst26)*(gconst4)))+(((gconst14)*(gconst3)*(gconst35)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst0)*(gconst23)*(gconst30)*(gconst5)))+(((gconst12)*(gconst29)*(gconst8)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst1)*(gconst17)*(gconst19)*(gconst21)))+(((IkReal(-1.00000000000000))*(gconst13)*(gconst17)*(gconst19)*(gconst9)))+(((gconst10)*(gconst18)*(gconst25)*(gconst5)))+(((IkReal(-1.00000000000000))*(gconst13)*(gconst29)*(gconst7)*(gconst9)))+(((gconst0)*(gconst21)*(gconst29)*(gconst8)))+(((gconst20)*(gconst24)*(gconst5)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst18)*(gconst22)*(gconst4)))+(((IkReal(-1.00000000000000))*(gconst1)*(gconst21)*(gconst29)*(gconst7)))+(((IkReal(-1.00000000000000))*(gconst13)*(gconst31)*(gconst5)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst11)*(gconst17)*(gconst24)*(gconst6)))+(((gconst14)*(gconst16)*(gconst21)*(gconst7)))+(((gconst21)*(gconst26)*(gconst4)*(gconst7)))+(((IkReal(-1.00000000000000))*(gconst15)*(gconst2)*(gconst20)*(gconst21)))+(((gconst12)*(gconst33)*(gconst5)*(gconst8)))+(((IkReal(-1.00000000000000))*(gconst12)*(gconst17)*(gconst23)*(gconst6)))+(((gconst11)*(gconst15)*(gconst2)*(gconst30)))+(((IkReal(-1.00000000000000))*(gconst2)*(gconst20)*(gconst27)*(gconst9)))+(((gconst1)*(gconst22)*(gconst30)*(gconst5)))+(((IkReal(-1.00000000000000))*(gconst0)*(gconst17)*(gconst18)*(gconst23)))+(((gconst10)*(gconst13)*(gconst17)*(gconst18)))+(((gconst12)*(gconst20)*(gconst21)*(gconst5)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst34)*(gconst4)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst0)*(gconst11)*(gconst17)*(gconst30)))+(((gconst17)*(gconst24)*(gconst8)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst2)*(gconst21)*(gconst27)*(gconst8)))+(((IkReal(-1.00000000000000))*(gconst10)*(gconst14)*(gconst30)*(gconst4)))+(((IkReal(-1.00000000000000))*(gconst11)*(gconst12)*(gconst17)*(gconst18)))+(((IkReal(-1.00000000000000))*(gconst22)*(gconst26)*(gconst4)*(gconst6)))+(((gconst14)*(gconst19)*(gconst21)*(gconst4)))+(((IkReal(-1.00000000000000))*(gconst16)*(gconst2)*(gconst34)*(gconst6))));
op[6]=((((gconst12)*(gconst20)*(gconst5)*(gconst9)))+(((gconst11)*(gconst2)*(gconst3)*(gconst30)))+(((gconst14)*(gconst21)*(gconst4)*(gconst7)))+(((IkReal(-1.00000000000000))*(gconst13)*(gconst21)*(gconst5)*(gconst7)))+(((gconst0)*(gconst20)*(gconst21)*(gconst5)))+(((IkReal(-1.00000000000000))*(gconst2)*(gconst20)*(gconst21)*(gconst3)))+(((gconst1)*(gconst18)*(gconst22)*(gconst5)))+(((gconst11)*(gconst15)*(gconst18)*(gconst2)))+(((gconst1)*(gconst10)*(gconst30)*(gconst5)))+(((gconst14)*(gconst23)*(gconst3)*(gconst6)))+(((gconst0)*(gconst17)*(gconst21)*(gconst8)))+(((IkReal(-1.00000000000000))*(gconst1)*(gconst17)*(gconst19)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst13)*(gconst19)*(gconst5)*(gconst9)))+(((gconst15)*(gconst2)*(gconst23)*(gconst6)))+(((gconst11)*(gconst26)*(gconst3)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst0)*(gconst35)*(gconst5)*(gconst6)))+(((gconst14)*(gconst16)*(gconst7)*(gconst9)))+(((gconst12)*(gconst21)*(gconst5)*(gconst8)))+(((gconst0)*(gconst17)*(gconst20)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst15)*(gconst2)*(gconst21)*(gconst8)))+(((gconst2)*(gconst31)*(gconst4)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst26)*(gconst3)*(gconst8)*(gconst9)))+(((gconst24)*(gconst5)*(gconst8)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst10)*(gconst16)*(gconst18)*(gconst2)))+(((gconst2)*(gconst3)*(gconst35)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst1)*(gconst29)*(gconst7)*(gconst9)))+(((gconst1)*(gconst10)*(gconst17)*(gconst18)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst22)*(gconst4)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst10)*(gconst14)*(gconst16)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst16)*(gconst2)*(gconst22)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst20)*(gconst3)*(gconst9)))+(((gconst18)*(gconst2)*(gconst23)*(gconst3)))+(((gconst2)*(gconst28)*(gconst7)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst11)*(gconst12)*(gconst17)*(gconst6)))+(((gconst13)*(gconst22)*(gconst5)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst10)*(gconst2)*(gconst28)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst10)*(gconst2)*(gconst30)*(gconst4)))+(((IkReal(-1.00000000000000))*(gconst1)*(gconst17)*(gconst21)*(gconst7)))+(((gconst10)*(gconst13)*(gconst17)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst10)*(gconst26)*(gconst4)*(gconst6)))+(((gconst14)*(gconst19)*(gconst4)*(gconst9)))+(((gconst1)*(gconst34)*(gconst5)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst11)*(gconst12)*(gconst18)*(gconst5)))+(((gconst19)*(gconst2)*(gconst21)*(gconst4)))+(((IkReal(-1.00000000000000))*(gconst0)*(gconst17)*(gconst23)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst0)*(gconst11)*(gconst30)*(gconst5)))+(((IkReal(-1.00000000000000))*(gconst10)*(gconst14)*(gconst18)*(gconst4)))+(((IkReal(-1.00000000000000))*(gconst13)*(gconst17)*(gconst7)*(gconst9)))+(((gconst26)*(gconst4)*(gconst7)*(gconst9)))+(((gconst0)*(gconst29)*(gconst8)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst0)*(gconst11)*(gconst17)*(gconst18)))+(((IkReal(-1.00000000000000))*(gconst2)*(gconst27)*(gconst8)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst2)*(gconst3)*(gconst33)*(gconst8)))+(((gconst16)*(gconst19)*(gconst2)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst2)*(gconst34)*(gconst4)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst12)*(gconst23)*(gconst5)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst1)*(gconst31)*(gconst5)*(gconst9)))+(((gconst11)*(gconst14)*(gconst18)*(gconst3)))+(((IkReal(-1.00000000000000))*(gconst1)*(gconst33)*(gconst5)*(gconst7)))+(((gconst2)*(gconst33)*(gconst4)*(gconst7)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst21)*(gconst3)*(gconst8)))+(((IkReal(-1.00000000000000))*(gconst15)*(gconst2)*(gconst20)*(gconst9)))+(((gconst16)*(gconst2)*(gconst21)*(gconst7)))+(((IkReal(-1.00000000000000))*(gconst25)*(gconst5)*(gconst7)*(gconst9)))+(((gconst10)*(gconst25)*(gconst5)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst0)*(gconst18)*(gconst23)*(gconst5)))+(((IkReal(-1.00000000000000))*(gconst1)*(gconst19)*(gconst21)*(gconst5)))+(((IkReal(-1.00000000000000))*(gconst2)*(gconst3)*(gconst32)*(gconst9)))+(((gconst0)*(gconst33)*(gconst5)*(gconst8)))+(((IkReal(-1.00000000000000))*(gconst14)*(gconst15)*(gconst8)*(gconst9)))+(((gconst11)*(gconst2)*(gconst27)*(gconst6)))+(((gconst11)*(gconst14)*(gconst15)*(gconst6)))+(((IkReal(-1.00000000000000))*(gconst11)*(gconst24)*(gconst5)*(gconst6)))+(((gconst10)*(gconst13)*(gconst18)*(gconst5)))+(((gconst0)*(gconst32)*(gconst5)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst18)*(gconst2)*(gconst22)*(gconst4)))+(((gconst1)*(gconst17)*(gconst22)*(gconst6)))+(((gconst12)*(gconst17)*(gconst8)*(gconst9)))+(((IkReal(-1.00000000000000))*(gconst0)*(gconst11)*(gconst29)*(gconst6)))+(((gconst1)*(gconst10)*(gconst29)*(gconst6))));
op[7]=((((x70)*(x72)))+(((gconst11)*(gconst15)*(x62)))+(((IkReal(-1.00000000000000))*(gconst10)*(gconst14)*(gconst4)*(x67)))+(((IkReal(-1.00000000000000))*(gconst11)*(gconst18)*(x66)))+(((x63)*(x93)))+(((IkReal(-1.00000000000000))*(gconst15)*(gconst2)*(x90)))+(((gconst23)*(gconst3)*(x62)))+(((IkReal(-1.00000000000000))*(x82)*(x94)))+(((IkReal(-1.00000000000000))*(gconst22)*(gconst4)*(x62)))+(((x84)*(x90)))+(((IkReal(-1.00000000000000))*(gconst10)*(gconst16)*(x62)))+(((gconst22)*(gconst6)*(x82)))+(((gconst20)*(gconst9)*(x66)))+(((x80)*(x83)))+(((gconst0)*(gconst17)*(x90)))+(((IkReal(-1.00000000000000))*(x72)*(x73)))+(((IkReal(-1.00000000000000))*(gconst10)*(gconst18)*(x80)))+(((IkReal(-1.00000000000000))*(gconst2)*(gconst3)*(x71)))+(((IkReal(-1.00000000000000))*(gconst11)*(x67)*(x84)))+(((IkReal(-1.00000000000000))*(gconst1)*(x61)*(x73)))+(((gconst10)*(gconst18)*(x82)))+(((x63)*(x92)))+(((IkReal(-1.00000000000000))*(x82)*(x83)))+(((x66)*(x71)))+(((gconst16)*(gconst2)*(x73)))+(((IkReal(-1.00000000000000))*(gconst0)*(gconst11)*(gconst6)*(x61)))+(((IkReal(-1.00000000000000))*(gconst23)*(x66)*(x67)))+(((gconst14)*(gconst4)*(x73)))+(((x80)*(x94)))+(((gconst1)*(gconst17)*(x70)))+(((IkReal(-1.00000000000000))*(gconst9)*(x68)*(x87)))+(((IkReal(-1.00000000000000))*(gconst20)*(gconst3)*(x97))));
op[8]=((((IkReal(-1.00000000000000))*(gconst11)*(x66)*(x67)))+(((x66)*(x90)))+(((IkReal(-1.00000000000000))*(x73)*(x82)))+(((x62)*(x63)))+(((x73)*(x80)))+(((x70)*(x82)))+(((IkReal(-1.00000000000000))*(x87)*(x97)))+(((IkReal(-1.00000000000000))*(x62)*(x95))));
polyroots8(op,zeror,numroots);
IkReal j4array[8], cj4array[8], sj4array[8], tempj4array[1];
int numsolutions = 0;
for(int ij4 = 0; ij4 < numroots; ++ij4)
{
IkReal htj4 = zeror[ij4];
tempj4array[0]=((IkReal(2.00000000000000))*(atan(htj4)));
for(int kj4 = 0; kj4 < 1; ++kj4)
{
j4array[numsolutions] = tempj4array[kj4];
if( j4array[numsolutions] > IKPI )
{
    j4array[numsolutions]-=IK2PI;
}
else if( j4array[numsolutions] < -IKPI )
{
    j4array[numsolutions]+=IK2PI;
}
sj4array[numsolutions] = IKsin(j4array[numsolutions]);
cj4array[numsolutions] = IKcos(j4array[numsolutions]);
numsolutions++;
}
}
bool j4valid[8]={true,true,true,true,true,true,true,true};
_nj4 = 8;
for(int ij4 = 0; ij4 < numsolutions; ++ij4)
    {
if( !j4valid[ij4] )
{
    continue;
}
    j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
htj4 = IKtan(j4/2);

_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < numsolutions; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
{
IkReal dummyeval[1];
IkReal gconst52;
IkReal x98=(sj4)*(sj4);
IkReal x99=((IkReal(0.0180500000000000))*(cj4));
IkReal x100=((IkReal(0.190000000000000))*(sj4));
IkReal x101=((IkReal(0.0665000000000000))*(cj4)*(sj4));
IkReal x102=((IkReal(0.700000000000000))*(x98));
gconst52=IKsign(((((IkReal(-1.00000000000000))*(npy)*(r21)*(x99)))+(((npy)*(r20)*(x101)))+(((IkReal(-1.00000000000000))*(npx)*(rxp0_2)*(x100)))+(((npy)*(rxp0_2)*(x102)))+(((IkReal(-1.00000000000000))*(npx)*(rxp1_2)*(x102)))+(((IkReal(-1.00000000000000))*(npx)*(r21)*(x101)))+(((IkReal(-1.00000000000000))*(npy)*(rxp1_2)*(x100)))+(((IkReal(-1.00000000000000))*(npx)*(r20)*(x99)))));
IkReal x103=(sj4)*(sj4);
IkReal x104=((cj4)*(r20));
IkReal x105=((npy)*(sj4));
IkReal x106=((cj4)*(r21));
IkReal x107=((npx)*(sj4));
IkReal x108=((IkReal(38.7811634349030))*(x103));
dummyeval[0]=((((IkReal(-1.00000000000000))*(npx)*(rxp1_2)*(x108)))+(((IkReal(-10.5263157894737))*(rxp0_2)*(x107)))+(((npy)*(rxp0_2)*(x108)))+(((IkReal(-1.00000000000000))*(npy)*(x106)))+(((IkReal(3.68421052631579))*(x104)*(x105)))+(((IkReal(-3.68421052631579))*(x106)*(x107)))+(((IkReal(-1.00000000000000))*(npx)*(x104)))+(((IkReal(-10.5263157894737))*(rxp1_2)*(x105))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j5array[1], cj5array[1], sj5array[1];
bool j5valid[1]={false};
_nj5 = 1;
IkReal x109=(cj4)*(cj4);
IkReal x110=(sj4)*(sj4);
IkReal x111=((rxp0_2)*(sj4));
IkReal x112=((IkReal(0.700000000000000))*(cj4));
IkReal x113=((npx)*(rxp2_2));
IkReal x114=((IkReal(0.190000000000000))*(cj4));
IkReal x115=((rxp1_2)*(sj4));
IkReal x116=((IkReal(0.000857375000000000))*(cj4));
IkReal x117=((npy)*(rxp2_2));
IkReal x118=((IkReal(0.0950000000000000))*(cj4)*(pp));
IkReal x119=((IkReal(0.0180500000000000))*(r22)*(sj4));
IkReal x120=((IkReal(0.0665000000000000))*(npz)*(x109));
IkReal x121=((IkReal(0.0665000000000000))*(r22)*(x110));
if( IKabs(((gconst52)*(((((IkReal(-1.00000000000000))*(npy)*(x119)))+(((r20)*(x118)))+(((pp)*(x111)))+(((IkReal(-1.00000000000000))*(r20)*(x120)))+(((IkReal(-1.00000000000000))*(npx)*(x121)))+(((sj4)*(x112)*(x113)))+(((r20)*(x116)))+(((IkReal(-1.00000000000000))*(npz)*(x111)*(x112)))+(((IkReal(0.00902500000000000))*(x111)))+(((x114)*(x117))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst52)*(((((IkReal(0.00902500000000000))*(x115)))+(((IkReal(-1.00000000000000))*(npy)*(x121)))+(((IkReal(-1.00000000000000))*(x113)*(x114)))+(((IkReal(-1.00000000000000))*(r21)*(x120)))+(((r21)*(x118)))+(((sj4)*(x112)*(x117)))+(((IkReal(-1.00000000000000))*(npz)*(x112)*(x115)))+(((npx)*(x119)))+(((r21)*(x116)))+(((pp)*(x115))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j5array[0]=IKatan2(((gconst52)*(((((IkReal(-1.00000000000000))*(npy)*(x119)))+(((r20)*(x118)))+(((pp)*(x111)))+(((IkReal(-1.00000000000000))*(r20)*(x120)))+(((IkReal(-1.00000000000000))*(npx)*(x121)))+(((sj4)*(x112)*(x113)))+(((r20)*(x116)))+(((IkReal(-1.00000000000000))*(npz)*(x111)*(x112)))+(((IkReal(0.00902500000000000))*(x111)))+(((x114)*(x117)))))), ((gconst52)*(((((IkReal(0.00902500000000000))*(x115)))+(((IkReal(-1.00000000000000))*(npy)*(x121)))+(((IkReal(-1.00000000000000))*(x113)*(x114)))+(((IkReal(-1.00000000000000))*(r21)*(x120)))+(((r21)*(x118)))+(((sj4)*(x112)*(x117)))+(((IkReal(-1.00000000000000))*(npz)*(x112)*(x115)))+(((npx)*(x119)))+(((r21)*(x116)))+(((pp)*(x115)))))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
for(int ij5 = 0; ij5 < 1; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 1; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[2];
IkReal x122=IKcos(j5);
IkReal x123=IKsin(j5);
IkReal x124=((IkReal(0.0950000000000000))*(cj4));
IkReal x125=((sj4)*(x122));
IkReal x126=((sj4)*(x123));
evalcond[0]=((((IkReal(-1.00000000000000))*(rxp1_2)*(x126)))+(((rxp0_2)*(x125)))+(((IkReal(-1.00000000000000))*(r21)*(x123)*(x124)))+(((IkReal(-1.00000000000000))*(cj4)*(rxp2_2)))+(((r20)*(x122)*(x124)))+(((IkReal(0.0950000000000000))*(r22)*(sj4))));
evalcond[1]=((IkReal(-0.00902500000000000))+(((IkReal(-0.190000000000000))*(npx)*(x123)))+(((IkReal(-1.00000000000000))*(pp)))+(((IkReal(0.700000000000000))*(npy)*(x126)))+(((IkReal(0.700000000000000))*(cj4)*(npz)))+(((IkReal(-0.190000000000000))*(npy)*(x122)))+(((IkReal(-0.700000000000000))*(npx)*(x125))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal j2array[2], cj2array[2], sj2array[2];
bool j2valid[2]={false};
_nj2 = 2;
IkReal x127=((IkReal(2.85714285714286))*(sj4));
cj2array[0]=((IkReal(-1.00000000000000))+(((IkReal(2.85714285714286))*(cj4)*(npz)))+(((npy)*(sj5)*(x127)))+(((IkReal(-1.00000000000000))*(cj5)*(npx)*(x127))));
if( cj2array[0] >= -1-IKFAST_SINCOS_THRESH && cj2array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j2valid[0] = j2valid[1] = true;
    j2array[0] = IKacos(cj2array[0]);
    sj2array[0] = IKsin(j2array[0]);
    cj2array[1] = cj2array[0];
    j2array[1] = -j2array[0];
    sj2array[1] = -sj2array[0];
}
else if( isnan(cj2array[0]) )
{
    // probably any value will work
    j2valid[0] = true;
    cj2array[0] = 1; sj2array[0] = 0; j2array[0] = 0;
}
for(int ij2 = 0; ij2 < 2; ++ij2)
{
if( !j2valid[ij2] )
{
    continue;
}
_ij2[0] = ij2; _ij2[1] = -1;
for(int iij2 = ij2+1; iij2 < 2; ++iij2)
{
if( j2valid[iij2] && IKabs(cj2array[ij2]-cj2array[iij2]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij2]-sj2array[iij2]) < IKFAST_SOLUTION_THRESH )
{
    j2valid[iij2]=false; _ij2[1] = iij2; break; 
}
}
j2 = j2array[ij2]; cj2 = cj2array[ij2]; sj2 = sj2array[ij2];

{
IkReal dummyeval[1];
IkReal gconst53;
gconst53=IKsign(sj2);
dummyeval[0]=sj2;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal j0array[2], cj0array[2], sj0array[2];
bool j0valid[2]={false};
_nj0 = 2;
IkReal x128=((cj5)*(sj4));
IkReal x129=((sj4)*(sj5));
if( IKabs(((((IkReal(-1.00000000000000))*(cj4)*(r12)))+(((IkReal(-1.00000000000000))*(r11)*(x129)))+(((r10)*(x128))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(r00)*(x128)))+(((cj4)*(r02)))+(((r01)*(x129))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
IkReal x130=IKatan2(((((IkReal(-1.00000000000000))*(cj4)*(r12)))+(((IkReal(-1.00000000000000))*(r11)*(x129)))+(((r10)*(x128)))), ((((IkReal(-1.00000000000000))*(r00)*(x128)))+(((cj4)*(r02)))+(((r01)*(x129)))));
j0array[0]=((IkReal(-1.00000000000000))*(x130));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
j0array[1]=((IkReal(3.14159265358979))+(((IkReal(-1.00000000000000))*(x130))));
sj0array[1]=IKsin(j0array[1]);
cj0array[1]=IKcos(j0array[1]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
if( j0array[1] > IKPI )
{
    j0array[1]-=IK2PI;
}
else if( j0array[1] < -IKPI )
{    j0array[1]+=IK2PI;
}
j0valid[1] = true;
for(int ij0 = 0; ij0 < 2; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 2; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];

{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x131=((cj4)*(cj5));
IkReal x132=((IkReal(1.00000000000000))*(sj0));
IkReal x133=((cj0)*(r10));
IkReal x134=((cj0)*(r11));
IkReal x135=((cj4)*(sj5));
if( IKabs(((((x131)*(x133)))+(((IkReal(-1.00000000000000))*(r02)*(sj4)*(x132)))+(((IkReal(-1.00000000000000))*(r00)*(x131)*(x132)))+(((IkReal(-1.00000000000000))*(x134)*(x135)))+(((cj0)*(r12)*(sj4)))+(((r01)*(sj0)*(x135))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((cj5)*(x134)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(x132)))+(((IkReal(-1.00000000000000))*(r00)*(sj5)*(x132)))+(((sj5)*(x133))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((x131)*(x133)))+(((IkReal(-1.00000000000000))*(r02)*(sj4)*(x132)))+(((IkReal(-1.00000000000000))*(r00)*(x131)*(x132)))+(((IkReal(-1.00000000000000))*(x134)*(x135)))+(((cj0)*(r12)*(sj4)))+(((r01)*(sj0)*(x135)))))+IKsqr(((((cj5)*(x134)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(x132)))+(((IkReal(-1.00000000000000))*(r00)*(sj5)*(x132)))+(((sj5)*(x133)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j3array[0]=IKatan2(((((x131)*(x133)))+(((IkReal(-1.00000000000000))*(r02)*(sj4)*(x132)))+(((IkReal(-1.00000000000000))*(r00)*(x131)*(x132)))+(((IkReal(-1.00000000000000))*(x134)*(x135)))+(((cj0)*(r12)*(sj4)))+(((r01)*(sj0)*(x135)))), ((((cj5)*(x134)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(x132)))+(((IkReal(-1.00000000000000))*(r00)*(sj5)*(x132)))+(((sj5)*(x133)))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[4];
IkReal x136=IKcos(j3);
IkReal x137=IKsin(j3);
IkReal x138=((r00)*(sj0));
IkReal x139=((cj4)*(cj5));
IkReal x140=((IkReal(1.00000000000000))*(cj0));
IkReal x141=((IkReal(0.350000000000000))*(sj2));
IkReal x142=((cj4)*(sj5));
IkReal x143=((r01)*(sj0));
evalcond[0]=((IkReal(0.0950000000000000))+(((cj5)*(npy)))+(((IkReal(-1.00000000000000))*(x137)*(x141)))+(((npx)*(sj5))));
evalcond[1]=((((x136)*(x141)))+(((npx)*(x139)))+(((IkReal(-1.00000000000000))*(npy)*(x142)))+(((npz)*(sj4))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r10)*(sj5)*(x140)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x140)))+(((sj5)*(x138)))+(((cj5)*(x143)))+(x136));
evalcond[3]=((((IkReal(-1.00000000000000))*(r10)*(x139)*(x140)))+(((cj0)*(r11)*(x142)))+(((IkReal(-1.00000000000000))*(r12)*(sj4)*(x140)))+(((r02)*(sj0)*(sj4)))+(((x138)*(x139)))+(x137)+(((IkReal(-1.00000000000000))*(x142)*(x143))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst74;
gconst74=IKsign(((((sj3)*((cj2)*(cj2))))+(((sj3)*((sj2)*(sj2))))));
dummyeval[0]=((((sj3)*((cj2)*(cj2))))+(((sj3)*((sj2)*(sj2)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst75;
gconst75=IKsign(((((cj3)*((sj2)*(sj2))))+(((cj3)*((cj2)*(cj2))))));
dummyeval[0]=((((cj3)*((sj2)*(sj2))))+(((cj3)*((cj2)*(cj2)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[9];
IkReal x144=((sj0)*(sj4));
IkReal x145=((IkReal(1.00000000000000))*(r12));
IkReal x146=((cj4)*(cj5));
IkReal x147=((IkReal(1.00000000000000))*(cj0));
IkReal x148=((cj4)*(sj0));
IkReal x149=((IkReal(1.00000000000000))*(sj5));
IkReal x150=((cj0)*(cj4));
IkReal x151=((r00)*(sj0));
IkReal x152=((sj4)*(sj5));
IkReal x153=((IkReal(1.00000000000000))*(cj5));
IkReal x154=((r01)*(sj5));
IkReal x155=((cj0)*(sj4));
IkReal x156=((r11)*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j3)), IkReal(6.28318530717959))));
evalcond[1]=((IkReal(0.0950000000000000))+(((cj5)*(npy)))+(((IkReal(-0.350000000000000))*(sj2)))+(((npx)*(sj5))));
evalcond[2]=((IkReal(-0.350000000000000))+(((IkReal(-0.350000000000000))*(cj2)))+(((npy)*(x152)))+(((cj4)*(npz)))+(((IkReal(-1.00000000000000))*(npx)*(sj4)*(x153))));
evalcond[3]=((((IkReal(-1.00000000000000))*(cj4)*(npy)*(x149)))+(((npz)*(sj4)))+(((npx)*(x146))));
evalcond[4]=((((sj5)*(x151)))+(((cj5)*(r01)*(sj0)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x147)))+(((IkReal(-1.00000000000000))*(r10)*(sj5)*(x147))));
evalcond[5]=((((r20)*(x146)))+(((r22)*(sj4)))+(((IkReal(-1.00000000000000))*(cj4)*(r21)*(x149))));
evalcond[6]=((((IkReal(-1.00000000000000))*(r00)*(x144)*(x153)))+(((IkReal(-1.00000000000000))*(r11)*(x147)*(x152)))+(((IkReal(-1.00000000000000))*(x145)*(x150)))+(((r02)*(x148)))+(((cj5)*(r10)*(x155)))+(((x144)*(x154))));
evalcond[7]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(r01)*(x148)*(x149)))+(((r02)*(x144)))+(((x146)*(x151)))+(((x150)*(x156)))+(((IkReal(-1.00000000000000))*(x145)*(x155)))+(((IkReal(-1.00000000000000))*(r10)*(x146)*(x147))));
evalcond[8]=((((IkReal(-1.00000000000000))*(x144)*(x145)))+(((IkReal(-1.00000000000000))*(r02)*(sj4)*(x147)))+(((x148)*(x156)))+(((x150)*(x154)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x146)))+(((IkReal(-1.00000000000000))*(r00)*(x146)*(x147))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst76;
gconst76=IKsign((((cj2)*(cj2))+((sj2)*(sj2))));
dummyeval[0]=(((cj2)*(cj2))+((sj2)*(sj2)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst77;
gconst77=IKsign((((cj2)*(cj2))+((sj2)*(sj2))));
dummyeval[0]=(((cj2)*(cj2))+((sj2)*(sj2)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x157=((cj2)*(sj5));
IkReal x158=((r10)*(sj0));
IkReal x159=((cj2)*(cj5));
IkReal x160=((cj0)*(r00));
IkReal x161=((sj2)*(sj5));
IkReal x162=((r11)*(sj0));
IkReal x163=((cj5)*(sj2));
IkReal x164=((cj0)*(r01));
if( IKabs(((gconst77)*(((((x160)*(x161)))+(((r21)*(x159)))+(((x162)*(x163)))+(((x163)*(x164)))+(((x158)*(x161)))+(((r20)*(x157))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst77)*(((((IkReal(-1.00000000000000))*(x159)*(x162)))+(((IkReal(-1.00000000000000))*(x159)*(x164)))+(((IkReal(-1.00000000000000))*(x157)*(x158)))+(((IkReal(-1.00000000000000))*(x157)*(x160)))+(((r20)*(x161)))+(((r21)*(x163))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst77)*(((((x160)*(x161)))+(((r21)*(x159)))+(((x162)*(x163)))+(((x163)*(x164)))+(((x158)*(x161)))+(((r20)*(x157)))))), ((gconst77)*(((((IkReal(-1.00000000000000))*(x159)*(x162)))+(((IkReal(-1.00000000000000))*(x159)*(x164)))+(((IkReal(-1.00000000000000))*(x157)*(x158)))+(((IkReal(-1.00000000000000))*(x157)*(x160)))+(((r20)*(x161)))+(((r21)*(x163)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x165=IKsin(j1);
IkReal x166=IKcos(j1);
IkReal x167=((cj0)*(sj4));
IkReal x168=((IkReal(1.00000000000000))*(sj5));
IkReal x169=((cj5)*(sj0));
IkReal x170=((IkReal(1.00000000000000))*(cj4));
IkReal x171=((IkReal(1.00000000000000))*(cj5));
IkReal x172=((sj2)*(x165));
IkReal x173=((IkReal(1.00000000000000))*(x166));
IkReal x174=((cj2)*(x165));
IkReal x175=((cj2)*(x173));
evalcond[0]=((((IkReal(-1.00000000000000))*(x174)))+(((r20)*(sj5)))+(((IkReal(-1.00000000000000))*(sj2)*(x173)))+(((cj5)*(r21))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r20)*(sj4)*(x171)))+(((IkReal(-1.00000000000000))*(x175)))+(x172)+(((cj4)*(r22)))+(((r21)*(sj4)*(sj5))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x175)))+(x172)+(((IkReal(-1.00000000000000))*(r11)*(x169)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x168)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x168)))+(((IkReal(-1.00000000000000))*(cj0)*(r01)*(x171))));
evalcond[3]=((((r10)*(sj4)*(x169)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x170)))+(x174)+(((cj5)*(r00)*(x167)))+(((sj2)*(x166)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x170)))+(((IkReal(-1.00000000000000))*(r01)*(x167)*(x168)))+(((IkReal(-1.00000000000000))*(r11)*(sj0)*(sj4)*(x168))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x176=((r20)*(sj5));
IkReal x177=((sj2)*(sj4));
IkReal x178=((cj5)*(r20));
IkReal x179=((cj5)*(r21));
IkReal x180=((cj4)*(r22));
IkReal x181=((r21)*(sj5));
IkReal x182=((cj2)*(sj4));
if( IKabs(((gconst76)*(((((IkReal(-1.00000000000000))*(x177)*(x181)))+(((x177)*(x178)))+(((IkReal(-1.00000000000000))*(sj2)*(x180)))+(((cj2)*(x179)))+(((cj2)*(x176))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst76)*(((((IkReal(-1.00000000000000))*(x178)*(x182)))+(((sj2)*(x179)))+(((cj2)*(x180)))+(((x181)*(x182)))+(((sj2)*(x176))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst76)*(((((IkReal(-1.00000000000000))*(x177)*(x181)))+(((x177)*(x178)))+(((IkReal(-1.00000000000000))*(sj2)*(x180)))+(((cj2)*(x179)))+(((cj2)*(x176)))))), ((gconst76)*(((((IkReal(-1.00000000000000))*(x178)*(x182)))+(((sj2)*(x179)))+(((cj2)*(x180)))+(((x181)*(x182)))+(((sj2)*(x176)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x183=IKsin(j1);
IkReal x184=IKcos(j1);
IkReal x185=((cj0)*(sj4));
IkReal x186=((IkReal(1.00000000000000))*(sj5));
IkReal x187=((cj5)*(sj0));
IkReal x188=((IkReal(1.00000000000000))*(cj4));
IkReal x189=((IkReal(1.00000000000000))*(cj5));
IkReal x190=((sj2)*(x183));
IkReal x191=((IkReal(1.00000000000000))*(x184));
IkReal x192=((cj2)*(x183));
IkReal x193=((cj2)*(x191));
evalcond[0]=((((IkReal(-1.00000000000000))*(x192)))+(((IkReal(-1.00000000000000))*(sj2)*(x191)))+(((r20)*(sj5)))+(((cj5)*(r21))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x193)))+(x190)+(((cj4)*(r22)))+(((r21)*(sj4)*(sj5)))+(((IkReal(-1.00000000000000))*(r20)*(sj4)*(x189))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r10)*(sj0)*(x186)))+(((IkReal(-1.00000000000000))*(x193)))+(((IkReal(-1.00000000000000))*(cj0)*(r01)*(x189)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x186)))+(x190)+(((IkReal(-1.00000000000000))*(r11)*(x187))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r12)*(sj0)*(x188)))+(((sj2)*(x184)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x188)))+(x192)+(((IkReal(-1.00000000000000))*(r11)*(sj0)*(sj4)*(x186)))+(((cj5)*(r00)*(x185)))+(((IkReal(-1.00000000000000))*(r01)*(x185)*(x186)))+(((r10)*(sj4)*(x187))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
IkReal x194=((sj0)*(sj4));
IkReal x195=((IkReal(1.00000000000000))*(r12));
IkReal x196=((cj4)*(cj5));
IkReal x197=((IkReal(1.00000000000000))*(cj0));
IkReal x198=((cj4)*(sj0));
IkReal x199=((IkReal(1.00000000000000))*(sj5));
IkReal x200=((cj0)*(cj4));
IkReal x201=((r00)*(sj0));
IkReal x202=((sj4)*(sj5));
IkReal x203=((IkReal(1.00000000000000))*(cj5));
IkReal x204=((r01)*(sj5));
IkReal x205=((cj0)*(sj4));
IkReal x206=((r11)*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j3)), IkReal(6.28318530717959))));
evalcond[1]=((IkReal(0.0950000000000000))+(((cj5)*(npy)))+(((IkReal(0.350000000000000))*(sj2)))+(((npx)*(sj5))));
evalcond[2]=((IkReal(-0.350000000000000))+(((npy)*(x202)))+(((IkReal(-0.350000000000000))*(cj2)))+(((cj4)*(npz)))+(((IkReal(-1.00000000000000))*(npx)*(sj4)*(x203))));
evalcond[3]=((((npx)*(x196)))+(((IkReal(-1.00000000000000))*(cj4)*(npy)*(x199)))+(((npz)*(sj4))));
evalcond[4]=((((sj5)*(x201)))+(((IkReal(-1.00000000000000))*(r10)*(sj5)*(x197)))+(((cj5)*(r01)*(sj0)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x197))));
evalcond[5]=((((r22)*(sj4)))+(((r20)*(x196)))+(((IkReal(-1.00000000000000))*(cj4)*(r21)*(x199))));
evalcond[6]=((((x194)*(x204)))+(((IkReal(-1.00000000000000))*(x195)*(x200)))+(((cj5)*(r10)*(x205)))+(((IkReal(-1.00000000000000))*(r11)*(x197)*(x202)))+(((IkReal(-1.00000000000000))*(r00)*(x194)*(x203)))+(((r02)*(x198))));
evalcond[7]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(r01)*(x198)*(x199)))+(((IkReal(-1.00000000000000))*(x195)*(x205)))+(((r02)*(x194)))+(((x196)*(x201)))+(((x200)*(x206)))+(((IkReal(-1.00000000000000))*(r10)*(x196)*(x197))));
evalcond[8]=((((IkReal(-1.00000000000000))*(r00)*(x196)*(x197)))+(((IkReal(-1.00000000000000))*(r02)*(sj4)*(x197)))+(((IkReal(-1.00000000000000))*(x194)*(x195)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x196)))+(((x198)*(x206)))+(((x200)*(x204))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst78;
gconst78=IKsign(((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2))))));
dummyeval[0]=((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst79;
gconst79=IKsign((((cj2)*(cj2))+((sj2)*(sj2))));
dummyeval[0]=(((cj2)*(cj2))+((sj2)*(sj2)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x207=((IkReal(1.00000000000000))*(sj2));
IkReal x208=((cj2)*(sj5));
IkReal x209=((cj0)*(r00));
IkReal x210=((cj5)*(r21));
IkReal x211=((cj5)*(r11)*(sj0));
IkReal x212=((r10)*(sj0)*(sj5));
IkReal x213=((cj0)*(cj5)*(r01));
if( IKabs(((gconst79)*(((((IkReal(-1.00000000000000))*(sj5)*(x207)*(x209)))+(((IkReal(-1.00000000000000))*(x207)*(x212)))+(((IkReal(-1.00000000000000))*(x207)*(x211)))+(((IkReal(-1.00000000000000))*(cj2)*(x210)))+(((IkReal(-1.00000000000000))*(x207)*(x213)))+(((IkReal(-1.00000000000000))*(r20)*(x208))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst79)*(((((r10)*(sj0)*(x208)))+(((x208)*(x209)))+(((IkReal(-1.00000000000000))*(x207)*(x210)))+(((cj2)*(x213)))+(((cj2)*(x211)))+(((IkReal(-1.00000000000000))*(r20)*(sj5)*(x207))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst79)*(((((IkReal(-1.00000000000000))*(sj5)*(x207)*(x209)))+(((IkReal(-1.00000000000000))*(x207)*(x212)))+(((IkReal(-1.00000000000000))*(x207)*(x211)))+(((IkReal(-1.00000000000000))*(cj2)*(x210)))+(((IkReal(-1.00000000000000))*(x207)*(x213)))+(((IkReal(-1.00000000000000))*(r20)*(x208)))))), ((gconst79)*(((((r10)*(sj0)*(x208)))+(((x208)*(x209)))+(((IkReal(-1.00000000000000))*(x207)*(x210)))+(((cj2)*(x213)))+(((cj2)*(x211)))+(((IkReal(-1.00000000000000))*(r20)*(sj5)*(x207)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x214=IKsin(j1);
IkReal x215=IKcos(j1);
IkReal x216=((cj5)*(sj0));
IkReal x217=((IkReal(1.00000000000000))*(r11));
IkReal x218=((cj5)*(sj4));
IkReal x219=((cj0)*(r00));
IkReal x220=((IkReal(1.00000000000000))*(sj0));
IkReal x221=((sj4)*(sj5));
IkReal x222=((IkReal(1.00000000000000))*(cj0));
IkReal x223=((sj2)*(x215));
IkReal x224=((cj2)*(x214));
IkReal x225=((cj2)*(x215));
IkReal x226=((sj2)*(x214));
IkReal x227=((x223)+(x224));
evalcond[0]=((((r20)*(sj5)))+(x227)+(((cj5)*(r21))));
evalcond[1]=((((r21)*(x221)))+(((cj4)*(r22)))+(((IkReal(-1.00000000000000))*(x225)))+(x226)+(((IkReal(-1.00000000000000))*(r20)*(x218))));
evalcond[2]=((((IkReal(-1.00000000000000))*(sj5)*(x219)))+(((IkReal(-1.00000000000000))*(x216)*(x217)))+(((IkReal(-1.00000000000000))*(r10)*(sj5)*(x220)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(x222)))+(x225)+(((IkReal(-1.00000000000000))*(x226))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r01)*(x221)*(x222)))+(((IkReal(-1.00000000000000))*(cj4)*(r02)*(x222)))+(((x218)*(x219)))+(((IkReal(-1.00000000000000))*(cj4)*(r12)*(x220)))+(((IkReal(-1.00000000000000))*(sj0)*(x217)*(x221)))+(x227)+(((r10)*(sj4)*(x216))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x228=((cj4)*(r22));
IkReal x229=((cj2)*(r20));
IkReal x230=((cj5)*(r21));
IkReal x231=((sj2)*(sj5));
IkReal x232=((r21)*(sj4));
IkReal x233=((IkReal(1.00000000000000))*(cj2));
IkReal x234=((cj5)*(sj4));
if( IKabs(((gconst78)*(((((sj2)*(x228)))+(((x231)*(x232)))+(((cj2)*(x230)))+(((IkReal(-1.00000000000000))*(r20)*(sj2)*(x234)))+(((sj5)*(x229))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst78)*(((((r20)*(x231)))+(((IkReal(-1.00000000000000))*(x228)*(x233)))+(((sj2)*(x230)))+(((x229)*(x234)))+(((IkReal(-1.00000000000000))*(sj5)*(x232)*(x233))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst78)*(((((sj2)*(x228)))+(((x231)*(x232)))+(((cj2)*(x230)))+(((IkReal(-1.00000000000000))*(r20)*(sj2)*(x234)))+(((sj5)*(x229)))))), ((gconst78)*(((((r20)*(x231)))+(((IkReal(-1.00000000000000))*(x228)*(x233)))+(((sj2)*(x230)))+(((x229)*(x234)))+(((IkReal(-1.00000000000000))*(sj5)*(x232)*(x233)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x235=IKsin(j1);
IkReal x236=IKcos(j1);
IkReal x237=((cj5)*(sj0));
IkReal x238=((IkReal(1.00000000000000))*(r11));
IkReal x239=((cj5)*(sj4));
IkReal x240=((cj0)*(r00));
IkReal x241=((IkReal(1.00000000000000))*(sj0));
IkReal x242=((sj4)*(sj5));
IkReal x243=((IkReal(1.00000000000000))*(cj0));
IkReal x244=((sj2)*(x236));
IkReal x245=((cj2)*(x235));
IkReal x246=((cj2)*(x236));
IkReal x247=((sj2)*(x235));
IkReal x248=((x245)+(x244));
evalcond[0]=((((r20)*(sj5)))+(x248)+(((cj5)*(r21))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x246)))+(((cj4)*(r22)))+(((r21)*(x242)))+(x247)+(((IkReal(-1.00000000000000))*(r20)*(x239))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x247)))+(((IkReal(-1.00000000000000))*(sj5)*(x240)))+(((IkReal(-1.00000000000000))*(r10)*(sj5)*(x241)))+(x246)+(((IkReal(-1.00000000000000))*(x237)*(x238)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(x243))));
evalcond[3]=((((x239)*(x240)))+(((IkReal(-1.00000000000000))*(cj4)*(r12)*(x241)))+(((IkReal(-1.00000000000000))*(r01)*(x242)*(x243)))+(((r10)*(sj4)*(x237)))+(x248)+(((IkReal(-1.00000000000000))*(cj4)*(r02)*(x243)))+(((IkReal(-1.00000000000000))*(sj0)*(x238)*(x242))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
IkReal x249=((IkReal(1.00000000000000))*(r10));
IkReal x250=((sj0)*(sj5));
IkReal x251=((r02)*(sj0));
IkReal x252=((cj4)*(cj5));
IkReal x253=((IkReal(1.00000000000000))*(cj4));
IkReal x254=((cj0)*(r12));
IkReal x255=((IkReal(1.00000000000000))*(cj0));
IkReal x256=((cj5)*(r11));
IkReal x257=((cj5)*(r01));
IkReal x258=((r00)*(sj0));
IkReal x259=((npy)*(sj5));
IkReal x260=((IkReal(1.00000000000000))*(sj4));
IkReal x261=((cj0)*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(3.14159265358979))+(j3)), IkReal(6.28318530717959))));
evalcond[1]=((IkReal(0.0950000000000000))+(((cj5)*(npy)))+(((npx)*(sj5))));
evalcond[2]=((IkReal(-0.350000000000000))+(((IkReal(-0.350000000000000))*(cj2)))+(((IkReal(-1.00000000000000))*(cj5)*(npx)*(x260)))+(((cj4)*(npz)))+(((sj4)*(x259))));
evalcond[3]=((((npx)*(x252)))+(((IkReal(-1.00000000000000))*(x253)*(x259)))+(((IkReal(0.350000000000000))*(sj2)))+(((npz)*(sj4))));
evalcond[4]=((((r20)*(sj5)))+(((cj5)*(r21))));
evalcond[5]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x255)*(x256)))+(((sj0)*(x257)))+(((IkReal(-1.00000000000000))*(x249)*(x261)))+(((r00)*(x250))));
evalcond[6]=((((IkReal(-1.00000000000000))*(x255)*(x257)))+(((IkReal(-1.00000000000000))*(sj0)*(x256)))+(((IkReal(-1.00000000000000))*(x249)*(x250)))+(((IkReal(-1.00000000000000))*(r00)*(sj5)*(x255))));
evalcond[7]=((((IkReal(-1.00000000000000))*(r11)*(sj4)*(sj5)*(x255)))+(((cj4)*(x251)))+(((r01)*(sj4)*(x250)))+(((IkReal(-1.00000000000000))*(x253)*(x254)))+(((cj0)*(cj5)*(r10)*(sj4)))+(((IkReal(-1.00000000000000))*(cj5)*(x258)*(x260))));
evalcond[8]=((((IkReal(-1.00000000000000))*(cj0)*(x249)*(x252)))+(((IkReal(-1.00000000000000))*(x254)*(x260)))+(((x252)*(x258)))+(((sj4)*(x251)))+(((cj4)*(r11)*(x261)))+(((IkReal(-1.00000000000000))*(r01)*(x250)*(x253))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst80;
gconst80=IKsign(((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2))))));
dummyeval[0]=((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst81;
gconst81=IKsign(((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2))))));
dummyeval[0]=((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x262=((cj4)*(r22));
IkReal x263=((IkReal(1.00000000000000))*(sj0));
IkReal x264=((IkReal(1.00000000000000))*(cj2));
IkReal x265=((cj4)*(r12));
IkReal x266=((cj5)*(sj4));
IkReal x267=((IkReal(1.00000000000000))*(sj2));
IkReal x268=((r10)*(sj0));
IkReal x269=((cj0)*(r00));
IkReal x270=((cj0)*(r01));
IkReal x271=((sj4)*(sj5));
IkReal x272=((sj2)*(x271));
IkReal x273=((cj0)*(cj4)*(r02));
if( IKabs(((gconst81)*(((((IkReal(-1.00000000000000))*(cj2)*(r11)*(x263)*(x271)))+(((IkReal(-1.00000000000000))*(x264)*(x270)*(x271)))+(((cj2)*(x266)*(x269)))+(((cj2)*(x266)*(x268)))+(((IkReal(-1.00000000000000))*(cj2)*(x263)*(x265)))+(((IkReal(-1.00000000000000))*(r20)*(x266)*(x267)))+(((IkReal(-1.00000000000000))*(x264)*(x273)))+(((r21)*(x272)))+(((sj2)*(x262))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst81)*(((((IkReal(-1.00000000000000))*(r11)*(x263)*(x272)))+(((IkReal(-1.00000000000000))*(sj2)*(x263)*(x265)))+(((sj2)*(x266)*(x269)))+(((cj2)*(r20)*(x266)))+(((sj2)*(x266)*(x268)))+(((IkReal(-1.00000000000000))*(x267)*(x270)*(x271)))+(((IkReal(-1.00000000000000))*(r21)*(x264)*(x271)))+(((IkReal(-1.00000000000000))*(x262)*(x264)))+(((IkReal(-1.00000000000000))*(x267)*(x273))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst81)*(((((IkReal(-1.00000000000000))*(cj2)*(r11)*(x263)*(x271)))+(((IkReal(-1.00000000000000))*(x264)*(x270)*(x271)))+(((cj2)*(x266)*(x269)))+(((cj2)*(x266)*(x268)))+(((IkReal(-1.00000000000000))*(cj2)*(x263)*(x265)))+(((IkReal(-1.00000000000000))*(r20)*(x266)*(x267)))+(((IkReal(-1.00000000000000))*(x264)*(x273)))+(((r21)*(x272)))+(((sj2)*(x262)))))), ((gconst81)*(((((IkReal(-1.00000000000000))*(r11)*(x263)*(x272)))+(((IkReal(-1.00000000000000))*(sj2)*(x263)*(x265)))+(((sj2)*(x266)*(x269)))+(((cj2)*(r20)*(x266)))+(((sj2)*(x266)*(x268)))+(((IkReal(-1.00000000000000))*(x267)*(x270)*(x271)))+(((IkReal(-1.00000000000000))*(r21)*(x264)*(x271)))+(((IkReal(-1.00000000000000))*(x262)*(x264)))+(((IkReal(-1.00000000000000))*(x267)*(x273)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x274=IKcos(j1);
IkReal x275=IKsin(j1);
IkReal x276=((IkReal(1.00000000000000))*(sj4));
IkReal x277=((cj5)*(r00));
IkReal x278=((cj5)*(r20));
IkReal x279=((r12)*(sj0));
IkReal x280=((r21)*(sj5));
IkReal x281=((IkReal(1.00000000000000))*(cj4));
IkReal x282=((sj2)*(x274));
IkReal x283=((cj2)*(x275));
IkReal x284=((cj2)*(x274));
IkReal x285=((r11)*(sj0)*(sj5));
IkReal x286=((cj0)*(x281));
IkReal x287=((cj0)*(r01)*(sj5));
IkReal x288=((cj5)*(r10)*(sj0));
IkReal x289=((sj2)*(x275));
IkReal x290=((x283)+(x282));
evalcond[0]=((((sj4)*(x280)))+(x289)+(((cj4)*(r22)))+(((IkReal(-1.00000000000000))*(x284)))+(((IkReal(-1.00000000000000))*(x276)*(x278))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x280)*(x281)))+(((cj4)*(x278)))+(((r22)*(sj4)))+(x290));
evalcond[2]=((((IkReal(-1.00000000000000))*(x279)*(x281)))+(((cj0)*(sj4)*(x277)))+(x290)+(((IkReal(-1.00000000000000))*(x276)*(x285)))+(((sj4)*(x288)))+(((IkReal(-1.00000000000000))*(x276)*(x287)))+(((IkReal(-1.00000000000000))*(r02)*(x286))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x281)*(x288)))+(x284)+(((IkReal(-1.00000000000000))*(x276)*(x279)))+(((cj4)*(x285)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x276)))+(((cj4)*(x287)))+(((IkReal(-1.00000000000000))*(x289)))+(((IkReal(-1.00000000000000))*(x277)*(x286))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x291=((cj4)*(r22));
IkReal x292=((r21)*(sj5));
IkReal x293=((cj2)*(cj4));
IkReal x294=((cj2)*(sj4));
IkReal x295=((sj2)*(sj4));
IkReal x296=((cj5)*(r20));
IkReal x297=((cj4)*(sj2));
if( IKabs(((gconst80)*(((((IkReal(-1.00000000000000))*(x295)*(x296)))+(((x292)*(x295)))+(((r22)*(x294)))+(((sj2)*(x291)))+(((IkReal(-1.00000000000000))*(x292)*(x293)))+(((x293)*(x296))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst80)*(((((x294)*(x296)))+(((x296)*(x297)))+(((IkReal(-1.00000000000000))*(cj2)*(x291)))+(((IkReal(-1.00000000000000))*(x292)*(x297)))+(((IkReal(-1.00000000000000))*(x292)*(x294)))+(((r22)*(x295))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst80)*(((((IkReal(-1.00000000000000))*(x295)*(x296)))+(((x292)*(x295)))+(((r22)*(x294)))+(((sj2)*(x291)))+(((IkReal(-1.00000000000000))*(x292)*(x293)))+(((x293)*(x296)))))), ((gconst80)*(((((x294)*(x296)))+(((x296)*(x297)))+(((IkReal(-1.00000000000000))*(cj2)*(x291)))+(((IkReal(-1.00000000000000))*(x292)*(x297)))+(((IkReal(-1.00000000000000))*(x292)*(x294)))+(((r22)*(x295)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x298=IKcos(j1);
IkReal x299=IKsin(j1);
IkReal x300=((IkReal(1.00000000000000))*(sj4));
IkReal x301=((cj5)*(r00));
IkReal x302=((cj5)*(r20));
IkReal x303=((r12)*(sj0));
IkReal x304=((r21)*(sj5));
IkReal x305=((IkReal(1.00000000000000))*(cj4));
IkReal x306=((sj2)*(x298));
IkReal x307=((cj2)*(x299));
IkReal x308=((cj2)*(x298));
IkReal x309=((r11)*(sj0)*(sj5));
IkReal x310=((cj0)*(x305));
IkReal x311=((cj0)*(r01)*(sj5));
IkReal x312=((cj5)*(r10)*(sj0));
IkReal x313=((sj2)*(x299));
IkReal x314=((x306)+(x307));
evalcond[0]=((((cj4)*(r22)))+(x313)+(((IkReal(-1.00000000000000))*(x308)))+(((IkReal(-1.00000000000000))*(x300)*(x302)))+(((sj4)*(x304))));
evalcond[1]=((((r22)*(sj4)))+(((cj4)*(x302)))+(x314)+(((IkReal(-1.00000000000000))*(x304)*(x305))));
evalcond[2]=((((sj4)*(x312)))+(((IkReal(-1.00000000000000))*(x303)*(x305)))+(((IkReal(-1.00000000000000))*(x300)*(x309)))+(((cj0)*(sj4)*(x301)))+(x314)+(((IkReal(-1.00000000000000))*(r02)*(x310)))+(((IkReal(-1.00000000000000))*(x300)*(x311))));
evalcond[3]=((((cj4)*(x309)))+(((IkReal(-1.00000000000000))*(x301)*(x310)))+(((IkReal(-1.00000000000000))*(x300)*(x303)))+(x308)+(((cj4)*(x311)))+(((IkReal(-1.00000000000000))*(x305)*(x312)))+(((IkReal(-1.00000000000000))*(x313)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x300))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
IkReal x315=((IkReal(1.00000000000000))*(r10));
IkReal x316=((sj0)*(sj5));
IkReal x317=((r02)*(sj0));
IkReal x318=((cj4)*(cj5));
IkReal x319=((IkReal(1.00000000000000))*(cj4));
IkReal x320=((cj0)*(r12));
IkReal x321=((IkReal(1.00000000000000))*(cj0));
IkReal x322=((cj5)*(r11));
IkReal x323=((cj5)*(r01));
IkReal x324=((r00)*(sj0));
IkReal x325=((npy)*(sj5));
IkReal x326=((IkReal(1.00000000000000))*(sj4));
IkReal x327=((cj0)*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(j3, IkReal(6.28318530717959))));
evalcond[1]=((IkReal(0.0950000000000000))+(((cj5)*(npy)))+(((npx)*(sj5))));
evalcond[2]=((IkReal(-0.350000000000000))+(((IkReal(-0.350000000000000))*(cj2)))+(((cj4)*(npz)))+(((sj4)*(x325)))+(((IkReal(-1.00000000000000))*(cj5)*(npx)*(x326))));
evalcond[3]=((((npx)*(x318)))+(((IkReal(-1.00000000000000))*(x319)*(x325)))+(((IkReal(-0.350000000000000))*(sj2)))+(((npz)*(sj4))));
evalcond[4]=((((r20)*(sj5)))+(((cj5)*(r21))));
evalcond[5]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(x321)*(x322)))+(((sj0)*(x323)))+(((IkReal(-1.00000000000000))*(x315)*(x327)))+(((r00)*(x316))));
evalcond[6]=((((IkReal(-1.00000000000000))*(sj0)*(x322)))+(((IkReal(-1.00000000000000))*(x321)*(x323)))+(((IkReal(-1.00000000000000))*(r00)*(sj5)*(x321)))+(((IkReal(-1.00000000000000))*(x315)*(x316))));
evalcond[7]=((((IkReal(-1.00000000000000))*(x319)*(x320)))+(((cj4)*(x317)))+(((IkReal(-1.00000000000000))*(r11)*(sj4)*(sj5)*(x321)))+(((IkReal(-1.00000000000000))*(cj5)*(x324)*(x326)))+(((cj0)*(cj5)*(r10)*(sj4)))+(((r01)*(sj4)*(x316))));
evalcond[8]=((((IkReal(-1.00000000000000))*(x320)*(x326)))+(((x318)*(x324)))+(((IkReal(-1.00000000000000))*(r01)*(x316)*(x319)))+(((sj4)*(x317)))+(((IkReal(-1.00000000000000))*(cj0)*(x315)*(x318)))+(((cj4)*(r11)*(x327))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst82;
gconst82=IKsign((((cj2)*(cj2))+((sj2)*(sj2))));
dummyeval[0]=(((cj2)*(cj2))+((sj2)*(sj2)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst83;
gconst83=IKsign(((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2))))));
dummyeval[0]=((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x328=((cj4)*(r22));
IkReal x329=((r11)*(sj0));
IkReal x330=((IkReal(1.00000000000000))*(cj2));
IkReal x331=((sj2)*(sj4));
IkReal x332=((IkReal(1.00000000000000))*(sj2));
IkReal x333=((cj2)*(sj4));
IkReal x334=((cj0)*(r01));
IkReal x335=((cj5)*(r20));
IkReal x336=((IkReal(1.00000000000000))*(sj4)*(sj5));
IkReal x337=((cj0)*(cj4)*(r02));
IkReal x338=((cj4)*(r12)*(sj0));
IkReal x339=((cj5)*(r10)*(sj0));
IkReal x340=((cj0)*(cj5)*(r00));
if( IKabs(((gconst83)*(((((x333)*(x339)))+(((x333)*(x340)))+(((IkReal(-1.00000000000000))*(x330)*(x337)))+(((IkReal(-1.00000000000000))*(x331)*(x335)))+(((IkReal(-1.00000000000000))*(sj4)*(sj5)*(x330)*(x334)))+(((sj2)*(x328)))+(((IkReal(-1.00000000000000))*(x330)*(x338)))+(((IkReal(-1.00000000000000))*(sj4)*(sj5)*(x329)*(x330)))+(((r21)*(sj5)*(x331))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst83)*(((((x333)*(x335)))+(((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj5)*(x330)))+(((IkReal(-1.00000000000000))*(x332)*(x338)))+(((x331)*(x339)))+(((x331)*(x340)))+(((IkReal(-1.00000000000000))*(x332)*(x337)))+(((IkReal(-1.00000000000000))*(x328)*(x330)))+(((IkReal(-1.00000000000000))*(sj5)*(x329)*(x331)))+(((IkReal(-1.00000000000000))*(sj5)*(x331)*(x334))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst83)*(((((x333)*(x339)))+(((x333)*(x340)))+(((IkReal(-1.00000000000000))*(x330)*(x337)))+(((IkReal(-1.00000000000000))*(x331)*(x335)))+(((IkReal(-1.00000000000000))*(sj4)*(sj5)*(x330)*(x334)))+(((sj2)*(x328)))+(((IkReal(-1.00000000000000))*(x330)*(x338)))+(((IkReal(-1.00000000000000))*(sj4)*(sj5)*(x329)*(x330)))+(((r21)*(sj5)*(x331)))))), ((gconst83)*(((((x333)*(x335)))+(((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj5)*(x330)))+(((IkReal(-1.00000000000000))*(x332)*(x338)))+(((x331)*(x339)))+(((x331)*(x340)))+(((IkReal(-1.00000000000000))*(x332)*(x337)))+(((IkReal(-1.00000000000000))*(x328)*(x330)))+(((IkReal(-1.00000000000000))*(sj5)*(x329)*(x331)))+(((IkReal(-1.00000000000000))*(sj5)*(x331)*(x334)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x341=IKcos(j1);
IkReal x342=IKsin(j1);
IkReal x343=((IkReal(1.00000000000000))*(sj4));
IkReal x344=((cj5)*(r00));
IkReal x345=((cj5)*(r20));
IkReal x346=((r12)*(sj0));
IkReal x347=((r21)*(sj5));
IkReal x348=((IkReal(1.00000000000000))*(cj4));
IkReal x349=((sj2)*(x342));
IkReal x350=((IkReal(1.00000000000000))*(x341));
IkReal x351=((r11)*(sj0)*(sj5));
IkReal x352=((cj0)*(x348));
IkReal x353=((cj0)*(r01)*(sj5));
IkReal x354=((cj2)*(x342));
IkReal x355=((cj5)*(r10)*(sj0));
IkReal x356=((cj2)*(x350));
evalcond[0]=((((sj4)*(x347)))+(((IkReal(-1.00000000000000))*(x343)*(x345)))+(((cj4)*(r22)))+(x349)+(((IkReal(-1.00000000000000))*(x356))));
evalcond[1]=((((r22)*(sj4)))+(((IkReal(-1.00000000000000))*(x347)*(x348)))+(((IkReal(-1.00000000000000))*(sj2)*(x350)))+(((IkReal(-1.00000000000000))*(x354)))+(((cj4)*(x345))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x343)*(x351)))+(((sj2)*(x341)))+(((IkReal(-1.00000000000000))*(x346)*(x348)))+(((IkReal(-1.00000000000000))*(x343)*(x353)))+(((IkReal(-1.00000000000000))*(r02)*(x352)))+(x354)+(((sj4)*(x355)))+(((cj0)*(sj4)*(x344))));
evalcond[3]=((((IkReal(-1.00000000000000))*(cj0)*(r02)*(x343)))+(((IkReal(-1.00000000000000))*(x348)*(x355)))+(((IkReal(-1.00000000000000))*(x344)*(x352)))+(((IkReal(-1.00000000000000))*(x343)*(x346)))+(x349)+(((cj4)*(x353)))+(((IkReal(-1.00000000000000))*(x356)))+(((cj4)*(x351))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x357=((IkReal(1.00000000000000))*(cj2));
IkReal x358=((cj4)*(r22));
IkReal x359=((r21)*(sj5));
IkReal x360=((r22)*(sj4));
IkReal x361=((cj5)*(r20)*(sj4));
IkReal x362=((cj4)*(cj5)*(r20));
IkReal x363=((IkReal(1.00000000000000))*(sj2)*(x359));
if( IKabs(((gconst82)*(((((cj2)*(x360)))+(((IkReal(-1.00000000000000))*(sj2)*(x358)))+(((IkReal(-1.00000000000000))*(cj4)*(x357)*(x359)))+(((sj2)*(x361)))+(((cj2)*(x362)))+(((IkReal(-1.00000000000000))*(sj4)*(x363))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst82)*(((((IkReal(-1.00000000000000))*(cj4)*(x363)))+(((cj2)*(sj4)*(x359)))+(((sj2)*(x360)))+(((sj2)*(x362)))+(((IkReal(-1.00000000000000))*(x357)*(x361)))+(((cj2)*(x358))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst82)*(((((cj2)*(x360)))+(((IkReal(-1.00000000000000))*(sj2)*(x358)))+(((IkReal(-1.00000000000000))*(cj4)*(x357)*(x359)))+(((sj2)*(x361)))+(((cj2)*(x362)))+(((IkReal(-1.00000000000000))*(sj4)*(x363)))))), ((gconst82)*(((((IkReal(-1.00000000000000))*(cj4)*(x363)))+(((cj2)*(sj4)*(x359)))+(((sj2)*(x360)))+(((sj2)*(x362)))+(((IkReal(-1.00000000000000))*(x357)*(x361)))+(((cj2)*(x358)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x364=IKcos(j1);
IkReal x365=IKsin(j1);
IkReal x366=((IkReal(1.00000000000000))*(sj4));
IkReal x367=((cj5)*(r00));
IkReal x368=((cj5)*(r20));
IkReal x369=((r12)*(sj0));
IkReal x370=((r21)*(sj5));
IkReal x371=((IkReal(1.00000000000000))*(cj4));
IkReal x372=((sj2)*(x365));
IkReal x373=((IkReal(1.00000000000000))*(x364));
IkReal x374=((r11)*(sj0)*(sj5));
IkReal x375=((cj0)*(x371));
IkReal x376=((cj0)*(r01)*(sj5));
IkReal x377=((cj2)*(x365));
IkReal x378=((cj5)*(r10)*(sj0));
IkReal x379=((cj2)*(x373));
evalcond[0]=((((sj4)*(x370)))+(x372)+(((cj4)*(r22)))+(((IkReal(-1.00000000000000))*(x379)))+(((IkReal(-1.00000000000000))*(x366)*(x368))));
evalcond[1]=((((IkReal(-1.00000000000000))*(sj2)*(x373)))+(((cj4)*(x368)))+(((IkReal(-1.00000000000000))*(x370)*(x371)))+(((r22)*(sj4)))+(((IkReal(-1.00000000000000))*(x377))));
evalcond[2]=((((sj2)*(x364)))+(((cj0)*(sj4)*(x367)))+(x377)+(((IkReal(-1.00000000000000))*(x366)*(x374)))+(((sj4)*(x378)))+(((IkReal(-1.00000000000000))*(x366)*(x376)))+(((IkReal(-1.00000000000000))*(x369)*(x371)))+(((IkReal(-1.00000000000000))*(r02)*(x375))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x371)*(x378)))+(x372)+(((cj4)*(x376)))+(((cj4)*(x374)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x366)))+(((IkReal(-1.00000000000000))*(x379)))+(((IkReal(-1.00000000000000))*(x367)*(x375)))+(((IkReal(-1.00000000000000))*(x366)*(x369))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}
}
}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x380=((IkReal(1.00000000000000))*(sj4));
IkReal x381=((r22)*(sj2));
IkReal x382=((cj2)*(cj4));
IkReal x383=((cj3)*(cj5)*(r20));
IkReal x384=((cj2)*(r21)*(sj5));
IkReal x385=((r21)*(sj2)*(sj5));
IkReal x386=((IkReal(1.00000000000000))*(cj5)*(r20));
if( IKabs(((gconst75)*(((((IkReal(-1.00000000000000))*(x382)*(x386)))+(((r21)*(sj5)*(x382)))+(((IkReal(-1.00000000000000))*(cj3)*(x380)*(x385)))+(((sj2)*(sj4)*(x383)))+(((IkReal(-1.00000000000000))*(cj3)*(cj4)*(x381)))+(((IkReal(-1.00000000000000))*(cj2)*(r22)*(x380))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst75)*(((((cj3)*(r22)*(x382)))+(((cj4)*(x385)))+(((IkReal(-1.00000000000000))*(x380)*(x381)))+(((IkReal(-1.00000000000000))*(cj2)*(x380)*(x383)))+(((cj3)*(sj4)*(x384)))+(((IkReal(-1.00000000000000))*(cj4)*(sj2)*(x386))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst75)*(((((IkReal(-1.00000000000000))*(x382)*(x386)))+(((r21)*(sj5)*(x382)))+(((IkReal(-1.00000000000000))*(cj3)*(x380)*(x385)))+(((sj2)*(sj4)*(x383)))+(((IkReal(-1.00000000000000))*(cj3)*(cj4)*(x381)))+(((IkReal(-1.00000000000000))*(cj2)*(r22)*(x380)))))), ((gconst75)*(((((cj3)*(r22)*(x382)))+(((cj4)*(x385)))+(((IkReal(-1.00000000000000))*(x380)*(x381)))+(((IkReal(-1.00000000000000))*(cj2)*(x380)*(x383)))+(((cj3)*(sj4)*(x384)))+(((IkReal(-1.00000000000000))*(cj4)*(sj2)*(x386)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[6];
IkReal x387=IKsin(j1);
IkReal x388=IKcos(j1);
IkReal x389=((IkReal(1.00000000000000))*(sj2));
IkReal x390=((cj5)*(r00));
IkReal x391=((cj0)*(sj4));
IkReal x392=((cj5)*(sj4));
IkReal x393=((IkReal(1.00000000000000))*(sj5));
IkReal x394=((r10)*(sj0));
IkReal x395=((IkReal(1.00000000000000))*(sj0));
IkReal x396=((cj0)*(r01));
IkReal x397=((cj4)*(sj5));
IkReal x398=((IkReal(1.00000000000000))*(cj5));
IkReal x399=((cj2)*(x388));
IkReal x400=((sj0)*(x393));
IkReal x401=((cj3)*(x387));
IkReal x402=((IkReal(1.00000000000000))*(cj0)*(cj4));
IkReal x403=((sj3)*(x387));
IkReal x404=((sj2)*(x388));
evalcond[0]=((((r20)*(sj5)))+(((IkReal(-1.00000000000000))*(cj2)*(x403)))+(((IkReal(-1.00000000000000))*(sj3)*(x388)*(x389)))+(((cj5)*(r21))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r20)*(x392)))+(((cj4)*(r22)))+(((sj2)*(x387)))+(((IkReal(-1.00000000000000))*(x399)))+(((r21)*(sj4)*(sj5))));
evalcond[2]=((((cj2)*(x401)))+(((cj3)*(x404)))+(((IkReal(-1.00000000000000))*(cj4)*(r21)*(x393)))+(((cj4)*(cj5)*(r20)))+(((r22)*(sj4))));
evalcond[3]=((((sj2)*(x403)))+(((IkReal(-1.00000000000000))*(x393)*(x394)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x395)))+(((IkReal(-1.00000000000000))*(sj3)*(x399)))+(((IkReal(-1.00000000000000))*(x396)*(x398)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x393))));
evalcond[4]=((((IkReal(-1.00000000000000))*(cj4)*(r12)*(x395)))+(((cj2)*(x387)))+(((IkReal(-1.00000000000000))*(r02)*(x402)))+(((IkReal(-1.00000000000000))*(r11)*(sj4)*(x400)))+(((x390)*(x391)))+(((x392)*(x394)))+(x404)+(((IkReal(-1.00000000000000))*(r01)*(x391)*(x393))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x390)*(x402)))+(((IkReal(-1.00000000000000))*(r12)*(sj4)*(x395)))+(((IkReal(-1.00000000000000))*(r02)*(x391)))+(((cj3)*(x399)))+(((IkReal(-1.00000000000000))*(x389)*(x401)))+(((r11)*(sj0)*(x397)))+(((x396)*(x397)))+(((IkReal(-1.00000000000000))*(cj4)*(x394)*(x398))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x405=((cj2)*(r20));
IkReal x406=((sj3)*(sj4));
IkReal x407=((cj2)*(r21));
IkReal x408=((sj2)*(sj5));
IkReal x409=((cj5)*(sj2));
IkReal x410=((cj4)*(r22)*(sj3));
if( IKabs(((gconst74)*(((((cj5)*(x407)))+(((r20)*(x406)*(x409)))+(((IkReal(-1.00000000000000))*(r21)*(x406)*(x408)))+(((IkReal(-1.00000000000000))*(sj2)*(x410)))+(((sj5)*(x405))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst74)*(((((sj5)*(x406)*(x407)))+(((r20)*(x408)))+(((r21)*(x409)))+(((cj2)*(x410)))+(((IkReal(-1.00000000000000))*(cj5)*(x405)*(x406))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst74)*(((((cj5)*(x407)))+(((r20)*(x406)*(x409)))+(((IkReal(-1.00000000000000))*(r21)*(x406)*(x408)))+(((IkReal(-1.00000000000000))*(sj2)*(x410)))+(((sj5)*(x405)))))), ((gconst74)*(((((sj5)*(x406)*(x407)))+(((r20)*(x408)))+(((r21)*(x409)))+(((cj2)*(x410)))+(((IkReal(-1.00000000000000))*(cj5)*(x405)*(x406)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[6];
IkReal x411=IKsin(j1);
IkReal x412=IKcos(j1);
IkReal x413=((IkReal(1.00000000000000))*(sj2));
IkReal x414=((cj5)*(r00));
IkReal x415=((cj0)*(sj4));
IkReal x416=((cj5)*(sj4));
IkReal x417=((IkReal(1.00000000000000))*(sj5));
IkReal x418=((r10)*(sj0));
IkReal x419=((IkReal(1.00000000000000))*(sj0));
IkReal x420=((cj0)*(r01));
IkReal x421=((cj4)*(sj5));
IkReal x422=((IkReal(1.00000000000000))*(cj5));
IkReal x423=((cj2)*(x412));
IkReal x424=((sj0)*(x417));
IkReal x425=((cj3)*(x411));
IkReal x426=((IkReal(1.00000000000000))*(cj0)*(cj4));
IkReal x427=((sj3)*(x411));
IkReal x428=((sj2)*(x412));
evalcond[0]=((((IkReal(-1.00000000000000))*(sj3)*(x412)*(x413)))+(((r20)*(sj5)))+(((IkReal(-1.00000000000000))*(cj2)*(x427)))+(((cj5)*(r21))));
evalcond[1]=((((cj4)*(r22)))+(((IkReal(-1.00000000000000))*(x423)))+(((IkReal(-1.00000000000000))*(r20)*(x416)))+(((sj2)*(x411)))+(((r21)*(sj4)*(sj5))));
evalcond[2]=((((cj3)*(x428)))+(((cj4)*(cj5)*(r20)))+(((r22)*(sj4)))+(((cj2)*(x425)))+(((IkReal(-1.00000000000000))*(cj4)*(r21)*(x417))));
evalcond[3]=((((IkReal(-1.00000000000000))*(sj3)*(x423)))+(((IkReal(-1.00000000000000))*(x420)*(x422)))+(((sj2)*(x427)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x419)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x417)))+(((IkReal(-1.00000000000000))*(x417)*(x418))));
evalcond[4]=((((x414)*(x415)))+(((IkReal(-1.00000000000000))*(r01)*(x415)*(x417)))+(x428)+(((x416)*(x418)))+(((IkReal(-1.00000000000000))*(r11)*(sj4)*(x424)))+(((IkReal(-1.00000000000000))*(cj4)*(r12)*(x419)))+(((IkReal(-1.00000000000000))*(r02)*(x426)))+(((cj2)*(x411))));
evalcond[5]=((((IkReal(-1.00000000000000))*(cj4)*(x418)*(x422)))+(((cj3)*(x423)))+(((IkReal(-1.00000000000000))*(x414)*(x426)))+(((x420)*(x421)))+(((r11)*(sj0)*(x421)))+(((IkReal(-1.00000000000000))*(r12)*(sj4)*(x419)))+(((IkReal(-1.00000000000000))*(r02)*(x415)))+(((IkReal(-1.00000000000000))*(x413)*(x425))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}
}
}

} else
{
{
IkReal j3array[1], cj3array[1], sj3array[1];
bool j3valid[1]={false};
_nj3 = 1;
IkReal x429=((IkReal(20.0000000000000))*(sj5));
IkReal x430=((IkReal(20.0000000000000))*(cj5));
if( IKabs(((gconst53)*(((IkReal(1.90000000000000))+(((npy)*(x430)))+(((npx)*(x429))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst53)*(((((cj4)*(npy)*(x429)))+(((IkReal(-1.00000000000000))*(cj4)*(npx)*(x430)))+(((IkReal(-20.0000000000000))*(npz)*(sj4))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j3array[0]=IKatan2(((gconst53)*(((IkReal(1.90000000000000))+(((npy)*(x430)))+(((npx)*(x429)))))), ((gconst53)*(((((cj4)*(npy)*(x429)))+(((IkReal(-1.00000000000000))*(cj4)*(npx)*(x430)))+(((IkReal(-20.0000000000000))*(npz)*(sj4)))))));
sj3array[0]=IKsin(j3array[0]);
cj3array[0]=IKcos(j3array[0]);
if( j3array[0] > IKPI )
{
    j3array[0]-=IK2PI;
}
else if( j3array[0] < -IKPI )
{    j3array[0]+=IK2PI;
}
j3valid[0] = true;
for(int ij3 = 0; ij3 < 1; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 1; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];
{
IkReal evalcond[2];
IkReal x431=((IkReal(0.350000000000000))*(sj2));
evalcond[0]=((IkReal(0.0950000000000000))+(((IkReal(-1.00000000000000))*(x431)*(IKsin(j3))))+(((cj5)*(npy)))+(((npx)*(sj5))));
evalcond[1]=((((IkReal(-1.00000000000000))*(cj4)*(npy)*(sj5)))+(((cj4)*(cj5)*(npx)))+(((x431)*(IKcos(j3))))+(((npz)*(sj4))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst86;
gconst86=IKsign(((((sj3)*((cj2)*(cj2))))+(((sj3)*((sj2)*(sj2))))));
dummyeval[0]=((((sj3)*((cj2)*(cj2))))+(((sj3)*((sj2)*(sj2)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst87;
gconst87=IKsign(((((cj3)*((sj2)*(sj2))))+(((cj3)*((cj2)*(cj2))))));
dummyeval[0]=((((cj3)*((sj2)*(sj2))))+(((cj3)*((cj2)*(cj2)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst84;
IkReal x432=(cj5)*(cj5);
IkReal x433=(sj5)*(sj5);
IkReal x434=((IkReal(1.00000000000000))*(r10));
IkReal x435=((cj4)*(sj5));
IkReal x436=((r00)*(r11));
IkReal x437=((cj4)*(cj5));
IkReal x438=((sj4)*(x432));
IkReal x439=((sj4)*(x433));
gconst84=IKsign(((((x436)*(x439)))+(((x436)*(x438)))+(((r00)*(r12)*(x435)))+(((r01)*(r12)*(x437)))+(((IkReal(-1.00000000000000))*(r02)*(x434)*(x435)))+(((IkReal(-1.00000000000000))*(r01)*(x434)*(x439)))+(((IkReal(-1.00000000000000))*(r02)*(r11)*(x437)))+(((IkReal(-1.00000000000000))*(r01)*(x434)*(x438)))));
IkReal x440=(cj5)*(cj5);
IkReal x441=(sj5)*(sj5);
IkReal x442=((IkReal(1.00000000000000))*(r10));
IkReal x443=((cj4)*(sj5));
IkReal x444=((r00)*(r11));
IkReal x445=((cj4)*(cj5));
IkReal x446=((sj4)*(x440));
IkReal x447=((sj4)*(x441));
dummyeval[0]=((((r00)*(r12)*(x443)))+(((IkReal(-1.00000000000000))*(r01)*(x442)*(x447)))+(((IkReal(-1.00000000000000))*(r01)*(x442)*(x446)))+(((IkReal(-1.00000000000000))*(r02)*(r11)*(x445)))+(((x444)*(x447)))+(((x444)*(x446)))+(((IkReal(-1.00000000000000))*(r02)*(x442)*(x443)))+(((r01)*(r12)*(x445))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
IkReal x448=((cj5)*(npx));
IkReal x449=((IkReal(1.00000000000000))*(cj4)*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j3)), IkReal(6.28318530717959))));
evalcond[1]=((IkReal(0.0950000000000000))+(((cj5)*(npy)))+(((IkReal(-0.350000000000000))*(sj2)))+(((npx)*(sj5))));
evalcond[2]=((IkReal(-0.350000000000000))+(((IkReal(-0.350000000000000))*(cj2)))+(((cj4)*(npz)))+(((npy)*(sj4)*(sj5)))+(((IkReal(-1.00000000000000))*(sj4)*(x448))));
evalcond[3]=((((cj4)*(x448)))+(((IkReal(-1.00000000000000))*(npy)*(x449)))+(((npz)*(sj4))));
evalcond[4]=((((cj4)*(cj5)*(r20)))+(((r22)*(sj4)))+(((IkReal(-1.00000000000000))*(r21)*(x449))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst102;
gconst102=IKsign((((cj2)*(cj2))+((sj2)*(sj2))));
dummyeval[0]=(((cj2)*(cj2))+((sj2)*(sj2)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst100;
IkReal x450=(cj5)*(cj5);
IkReal x451=(sj5)*(sj5);
IkReal x452=((sj4)*(sj5));
IkReal x453=((IkReal(1.00000000000000))*(r12));
IkReal x454=((cj5)*(sj4));
IkReal x455=((cj4)*(r00)*(r11));
IkReal x456=((IkReal(1.00000000000000))*(cj4)*(r01)*(r10));
gconst100=IKsign(((((IkReal(-1.00000000000000))*(r00)*(x452)*(x453)))+(((IkReal(-1.00000000000000))*(x450)*(x456)))+(((x450)*(x455)))+(((x451)*(x455)))+(((IkReal(-1.00000000000000))*(x451)*(x456)))+(((r02)*(r11)*(x454)))+(((r02)*(r10)*(x452)))+(((IkReal(-1.00000000000000))*(r01)*(x453)*(x454)))));
IkReal x457=(cj5)*(cj5);
IkReal x458=(sj5)*(sj5);
IkReal x459=((sj4)*(sj5));
IkReal x460=((IkReal(1.00000000000000))*(r12));
IkReal x461=((cj5)*(sj4));
IkReal x462=((cj4)*(r00)*(r11));
IkReal x463=x456;
dummyeval[0]=((((IkReal(-1.00000000000000))*(x458)*(x463)))+(((x457)*(x462)))+(((r02)*(r10)*(x459)))+(((IkReal(-1.00000000000000))*(r01)*(x460)*(x461)))+(((IkReal(-1.00000000000000))*(x457)*(x463)))+(((IkReal(-1.00000000000000))*(r00)*(x459)*(x460)))+(((x458)*(x462)))+(((r02)*(r11)*(x461))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst101;
IkReal x464=(cj4)*(cj4);
IkReal x465=(sj4)*(sj4);
IkReal x466=((r00)*(r12));
IkReal x467=((r02)*(r11));
IkReal x468=((cj5)*(x464));
IkReal x469=((sj5)*(x465));
IkReal x470=((IkReal(1.00000000000000))*(r02)*(r10));
IkReal x471=((IkReal(1.00000000000000))*(r01)*(r12));
IkReal x472=((cj5)*(x465));
IkReal x473=((sj5)*(x464));
gconst101=IKsign(((((IkReal(-1.00000000000000))*(x468)*(x470)))+(((x467)*(x473)))+(((IkReal(-1.00000000000000))*(x471)*(x473)))+(((x466)*(x468)))+(((x466)*(x472)))+(((IkReal(-1.00000000000000))*(x470)*(x472)))+(((x467)*(x469)))+(((IkReal(-1.00000000000000))*(x469)*(x471)))));
IkReal x474=(cj4)*(cj4);
IkReal x475=(sj4)*(sj4);
IkReal x476=((r00)*(r12));
IkReal x477=((r02)*(r11));
IkReal x478=((cj5)*(x474));
IkReal x479=((sj5)*(x475));
IkReal x480=((IkReal(1.00000000000000))*(r02)*(r10));
IkReal x481=((IkReal(1.00000000000000))*(r01)*(r12));
IkReal x482=((cj5)*(x475));
IkReal x483=((sj5)*(x474));
dummyeval[0]=((((x476)*(x482)))+(((IkReal(-1.00000000000000))*(x478)*(x480)))+(((x476)*(x478)))+(((IkReal(-1.00000000000000))*(x481)*(x483)))+(((x477)*(x483)))+(((x477)*(x479)))+(((IkReal(-1.00000000000000))*(x480)*(x482)))+(((IkReal(-1.00000000000000))*(x479)*(x481))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x484=((cj5)*(sj4));
IkReal x485=((IkReal(1.00000000000000))*(cj4));
IkReal x486=((IkReal(1.00000000000000))*(sj4)*(sj5));
if( IKabs(((gconst101)*(((((r10)*(x484)))+(((IkReal(-1.00000000000000))*(r11)*(x486)))+(((IkReal(-1.00000000000000))*(r12)*(x485))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst101)*(((((IkReal(-1.00000000000000))*(r01)*(x486)))+(((r00)*(x484)))+(((IkReal(-1.00000000000000))*(r02)*(x485))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst101)*(((((r10)*(x484)))+(((IkReal(-1.00000000000000))*(r11)*(x486)))+(((IkReal(-1.00000000000000))*(r12)*(x485)))))), ((gconst101)*(((((IkReal(-1.00000000000000))*(r01)*(x486)))+(((r00)*(x484)))+(((IkReal(-1.00000000000000))*(r02)*(x485)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[4];
IkReal x487=IKsin(j0);
IkReal x488=IKcos(j0);
IkReal x489=((IkReal(1.00000000000000))*(sj5));
IkReal x490=((cj5)*(r10));
IkReal x491=((IkReal(1.00000000000000))*(r12));
IkReal x492=((cj4)*(cj5));
IkReal x493=((r11)*(sj5));
IkReal x494=((IkReal(1.00000000000000))*(cj5));
IkReal x495=((r00)*(x487));
IkReal x496=((sj4)*(x488));
IkReal x497=((r01)*(x487));
IkReal x498=((sj4)*(x487));
IkReal x499=((cj4)*(x487));
IkReal x500=((cj4)*(x488));
evalcond[0]=((((cj5)*(x497)))+(((IkReal(-1.00000000000000))*(r10)*(x488)*(x489)))+(((sj5)*(x495)))+(((IkReal(-1.00000000000000))*(r11)*(x488)*(x494))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r11)*(x489)*(x496)))+(((x490)*(x496)))+(((r02)*(x499)))+(((IkReal(-1.00000000000000))*(x491)*(x500)))+(((IkReal(-1.00000000000000))*(sj4)*(x494)*(x495)))+(((sj4)*(sj5)*(x497))));
evalcond[2]=((IkReal(1.00000000000000))+(((x493)*(x500)))+(((IkReal(-1.00000000000000))*(x491)*(x496)))+(((r02)*(x498)))+(((IkReal(-1.00000000000000))*(cj4)*(x489)*(x497)))+(((IkReal(-1.00000000000000))*(x490)*(x500)))+(((x492)*(x495))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x491)*(x498)))+(((IkReal(-1.00000000000000))*(x490)*(x499)))+(((IkReal(-1.00000000000000))*(r02)*(x496)))+(((IkReal(-1.00000000000000))*(r00)*(x488)*(x492)))+(((r01)*(sj5)*(x500)))+(((x493)*(x499))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst103;
gconst103=IKsign((((cj2)*(cj2))+((sj2)*(sj2))));
dummyeval[0]=(((cj2)*(cj2))+((sj2)*(sj2)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst104;
gconst104=IKsign((((cj2)*(cj2))+((sj2)*(sj2))));
dummyeval[0]=(((cj2)*(cj2))+((sj2)*(sj2)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x501=((cj2)*(sj5));
IkReal x502=((r10)*(sj0));
IkReal x503=((cj2)*(cj5));
IkReal x504=((cj0)*(r00));
IkReal x505=((sj2)*(sj5));
IkReal x506=((r11)*(sj0));
IkReal x507=((cj5)*(sj2));
IkReal x508=((cj0)*(r01));
if( IKabs(((gconst104)*(((((r20)*(x501)))+(((x504)*(x505)))+(((x507)*(x508)))+(((x506)*(x507)))+(((x502)*(x505)))+(((r21)*(x503))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst104)*(((((r20)*(x505)))+(((IkReal(-1.00000000000000))*(x501)*(x504)))+(((IkReal(-1.00000000000000))*(x501)*(x502)))+(((r21)*(x507)))+(((IkReal(-1.00000000000000))*(x503)*(x506)))+(((IkReal(-1.00000000000000))*(x503)*(x508))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst104)*(((((r20)*(x501)))+(((x504)*(x505)))+(((x507)*(x508)))+(((x506)*(x507)))+(((x502)*(x505)))+(((r21)*(x503)))))), ((gconst104)*(((((r20)*(x505)))+(((IkReal(-1.00000000000000))*(x501)*(x504)))+(((IkReal(-1.00000000000000))*(x501)*(x502)))+(((r21)*(x507)))+(((IkReal(-1.00000000000000))*(x503)*(x506)))+(((IkReal(-1.00000000000000))*(x503)*(x508)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x509=IKsin(j1);
IkReal x510=IKcos(j1);
IkReal x511=((cj0)*(sj4));
IkReal x512=((IkReal(1.00000000000000))*(sj5));
IkReal x513=((cj5)*(sj0));
IkReal x514=((IkReal(1.00000000000000))*(cj4));
IkReal x515=((IkReal(1.00000000000000))*(cj5));
IkReal x516=((sj2)*(x509));
IkReal x517=((IkReal(1.00000000000000))*(x510));
IkReal x518=((cj2)*(x509));
IkReal x519=((cj2)*(x517));
evalcond[0]=((((IkReal(-1.00000000000000))*(sj2)*(x517)))+(((IkReal(-1.00000000000000))*(x518)))+(((r20)*(sj5)))+(((cj5)*(r21))));
evalcond[1]=((x516)+(((IkReal(-1.00000000000000))*(r20)*(sj4)*(x515)))+(((cj4)*(r22)))+(((IkReal(-1.00000000000000))*(x519)))+(((r21)*(sj4)*(sj5))));
evalcond[2]=((x516)+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x512)))+(((IkReal(-1.00000000000000))*(cj0)*(r01)*(x515)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x512)))+(((IkReal(-1.00000000000000))*(x519)))+(((IkReal(-1.00000000000000))*(r11)*(x513))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r11)*(sj0)*(sj4)*(x512)))+(((sj2)*(x510)))+(x518)+(((r10)*(sj4)*(x513)))+(((IkReal(-1.00000000000000))*(r01)*(x511)*(x512)))+(((cj5)*(r00)*(x511)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x514)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x514))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x520=((r20)*(sj5));
IkReal x521=((cj4)*(r22));
IkReal x522=((sj2)*(sj4));
IkReal x523=((cj5)*(r20));
IkReal x524=((cj5)*(r21));
IkReal x525=((r21)*(sj5));
IkReal x526=((cj2)*(sj4));
if( IKabs(((gconst103)*(((((x522)*(x523)))+(((IkReal(-1.00000000000000))*(sj2)*(x521)))+(((cj2)*(x520)))+(((IkReal(-1.00000000000000))*(x522)*(x525)))+(((cj2)*(x524))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst103)*(((((cj2)*(x521)))+(((sj2)*(x524)))+(((sj2)*(x520)))+(((IkReal(-1.00000000000000))*(x523)*(x526)))+(((x525)*(x526))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst103)*(((((x522)*(x523)))+(((IkReal(-1.00000000000000))*(sj2)*(x521)))+(((cj2)*(x520)))+(((IkReal(-1.00000000000000))*(x522)*(x525)))+(((cj2)*(x524)))))), ((gconst103)*(((((cj2)*(x521)))+(((sj2)*(x524)))+(((sj2)*(x520)))+(((IkReal(-1.00000000000000))*(x523)*(x526)))+(((x525)*(x526)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x527=IKsin(j1);
IkReal x528=IKcos(j1);
IkReal x529=((cj0)*(sj4));
IkReal x530=((IkReal(1.00000000000000))*(sj5));
IkReal x531=((cj5)*(sj0));
IkReal x532=((IkReal(1.00000000000000))*(cj4));
IkReal x533=((IkReal(1.00000000000000))*(cj5));
IkReal x534=((sj2)*(x527));
IkReal x535=((IkReal(1.00000000000000))*(x528));
IkReal x536=((cj2)*(x527));
IkReal x537=((cj2)*(x535));
evalcond[0]=((((r20)*(sj5)))+(((IkReal(-1.00000000000000))*(x536)))+(((IkReal(-1.00000000000000))*(sj2)*(x535)))+(((cj5)*(r21))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x537)))+(((cj4)*(r22)))+(((IkReal(-1.00000000000000))*(r20)*(sj4)*(x533)))+(((r21)*(sj4)*(sj5)))+(x534));
evalcond[2]=((((IkReal(-1.00000000000000))*(cj0)*(r01)*(x533)))+(((IkReal(-1.00000000000000))*(x537)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x530)))+(((IkReal(-1.00000000000000))*(r11)*(x531)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x530)))+(x534));
evalcond[3]=((((sj2)*(x528)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x532)))+(((IkReal(-1.00000000000000))*(r11)*(sj0)*(sj4)*(x530)))+(((IkReal(-1.00000000000000))*(r01)*(x529)*(x530)))+(((cj5)*(r00)*(x529)))+(((r10)*(sj4)*(x531)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x532)))+(x536));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x538=((IkReal(1.00000000000000))*(sj5));
IkReal x539=((IkReal(1.00000000000000))*(cj5));
if( IKabs(((gconst100)*(((((IkReal(-1.00000000000000))*(r10)*(x538)))+(((IkReal(-1.00000000000000))*(r11)*(x539))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst100)*(((((IkReal(-1.00000000000000))*(r01)*(x539)))+(((IkReal(-1.00000000000000))*(r00)*(x538))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst100)*(((((IkReal(-1.00000000000000))*(r10)*(x538)))+(((IkReal(-1.00000000000000))*(r11)*(x539)))))), ((gconst100)*(((((IkReal(-1.00000000000000))*(r01)*(x539)))+(((IkReal(-1.00000000000000))*(r00)*(x538)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[4];
IkReal x540=IKsin(j0);
IkReal x541=IKcos(j0);
IkReal x542=((IkReal(1.00000000000000))*(sj5));
IkReal x543=((cj5)*(r10));
IkReal x544=((IkReal(1.00000000000000))*(r12));
IkReal x545=((cj4)*(cj5));
IkReal x546=((r11)*(sj5));
IkReal x547=((IkReal(1.00000000000000))*(cj5));
IkReal x548=((r00)*(x540));
IkReal x549=((sj4)*(x541));
IkReal x550=((r01)*(x540));
IkReal x551=((sj4)*(x540));
IkReal x552=((cj4)*(x540));
IkReal x553=((cj4)*(x541));
evalcond[0]=((((cj5)*(x550)))+(((IkReal(-1.00000000000000))*(r11)*(x541)*(x547)))+(((sj5)*(x548)))+(((IkReal(-1.00000000000000))*(r10)*(x541)*(x542))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x544)*(x553)))+(((IkReal(-1.00000000000000))*(sj4)*(x547)*(x548)))+(((sj4)*(sj5)*(x550)))+(((r02)*(x552)))+(((IkReal(-1.00000000000000))*(r11)*(x542)*(x549)))+(((x543)*(x549))));
evalcond[2]=((IkReal(1.00000000000000))+(((x545)*(x548)))+(((IkReal(-1.00000000000000))*(x543)*(x553)))+(((IkReal(-1.00000000000000))*(cj4)*(x542)*(x550)))+(((x546)*(x553)))+(((r02)*(x551)))+(((IkReal(-1.00000000000000))*(x544)*(x549))));
evalcond[3]=((((x546)*(x552)))+(((r01)*(sj5)*(x553)))+(((IkReal(-1.00000000000000))*(r02)*(x549)))+(((IkReal(-1.00000000000000))*(x543)*(x552)))+(((IkReal(-1.00000000000000))*(r00)*(x541)*(x545)))+(((IkReal(-1.00000000000000))*(x544)*(x551))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst103;
gconst103=IKsign((((cj2)*(cj2))+((sj2)*(sj2))));
dummyeval[0]=(((cj2)*(cj2))+((sj2)*(sj2)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst104;
gconst104=IKsign((((cj2)*(cj2))+((sj2)*(sj2))));
dummyeval[0]=(((cj2)*(cj2))+((sj2)*(sj2)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x554=((cj2)*(sj5));
IkReal x555=((r10)*(sj0));
IkReal x556=((cj2)*(cj5));
IkReal x557=((cj0)*(r00));
IkReal x558=((sj2)*(sj5));
IkReal x559=((r11)*(sj0));
IkReal x560=((cj5)*(sj2));
IkReal x561=((cj0)*(r01));
if( IKabs(((gconst104)*(((((x560)*(x561)))+(((r21)*(x556)))+(((r20)*(x554)))+(((x555)*(x558)))+(((x559)*(x560)))+(((x557)*(x558))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst104)*(((((IkReal(-1.00000000000000))*(x554)*(x557)))+(((r20)*(x558)))+(((IkReal(-1.00000000000000))*(x554)*(x555)))+(((IkReal(-1.00000000000000))*(x556)*(x559)))+(((IkReal(-1.00000000000000))*(x556)*(x561)))+(((r21)*(x560))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst104)*(((((x560)*(x561)))+(((r21)*(x556)))+(((r20)*(x554)))+(((x555)*(x558)))+(((x559)*(x560)))+(((x557)*(x558)))))), ((gconst104)*(((((IkReal(-1.00000000000000))*(x554)*(x557)))+(((r20)*(x558)))+(((IkReal(-1.00000000000000))*(x554)*(x555)))+(((IkReal(-1.00000000000000))*(x556)*(x559)))+(((IkReal(-1.00000000000000))*(x556)*(x561)))+(((r21)*(x560)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x562=IKsin(j1);
IkReal x563=IKcos(j1);
IkReal x564=((cj0)*(sj4));
IkReal x565=((IkReal(1.00000000000000))*(sj5));
IkReal x566=((cj5)*(sj0));
IkReal x567=((IkReal(1.00000000000000))*(cj4));
IkReal x568=((IkReal(1.00000000000000))*(cj5));
IkReal x569=((sj2)*(x562));
IkReal x570=((IkReal(1.00000000000000))*(x563));
IkReal x571=((cj2)*(x562));
IkReal x572=((cj2)*(x570));
evalcond[0]=((((r20)*(sj5)))+(((IkReal(-1.00000000000000))*(sj2)*(x570)))+(((IkReal(-1.00000000000000))*(x571)))+(((cj5)*(r21))));
evalcond[1]=((x569)+(((IkReal(-1.00000000000000))*(r20)*(sj4)*(x568)))+(((cj4)*(r22)))+(((IkReal(-1.00000000000000))*(x572)))+(((r21)*(sj4)*(sj5))));
evalcond[2]=((((IkReal(-1.00000000000000))*(cj0)*(r01)*(x568)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x565)))+(x569)+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x565)))+(((IkReal(-1.00000000000000))*(x572)))+(((IkReal(-1.00000000000000))*(r11)*(x566))));
evalcond[3]=((x571)+(((r10)*(sj4)*(x566)))+(((cj5)*(r00)*(x564)))+(((IkReal(-1.00000000000000))*(r01)*(x564)*(x565)))+(((sj2)*(x563)))+(((IkReal(-1.00000000000000))*(r11)*(sj0)*(sj4)*(x565)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x567)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x567))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x573=((r20)*(sj5));
IkReal x574=((cj4)*(r22));
IkReal x575=((sj2)*(sj4));
IkReal x576=((cj5)*(r20));
IkReal x577=((cj5)*(r21));
IkReal x578=((r21)*(sj5));
IkReal x579=((cj2)*(sj4));
if( IKabs(((gconst103)*(((((cj2)*(x573)))+(((x575)*(x576)))+(((IkReal(-1.00000000000000))*(sj2)*(x574)))+(((cj2)*(x577)))+(((IkReal(-1.00000000000000))*(x575)*(x578))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst103)*(((((IkReal(-1.00000000000000))*(x576)*(x579)))+(((cj2)*(x574)))+(((sj2)*(x573)))+(((sj2)*(x577)))+(((x578)*(x579))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst103)*(((((cj2)*(x573)))+(((x575)*(x576)))+(((IkReal(-1.00000000000000))*(sj2)*(x574)))+(((cj2)*(x577)))+(((IkReal(-1.00000000000000))*(x575)*(x578)))))), ((gconst103)*(((((IkReal(-1.00000000000000))*(x576)*(x579)))+(((cj2)*(x574)))+(((sj2)*(x573)))+(((sj2)*(x577)))+(((x578)*(x579)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x580=IKsin(j1);
IkReal x581=IKcos(j1);
IkReal x582=((cj0)*(sj4));
IkReal x583=((IkReal(1.00000000000000))*(sj5));
IkReal x584=((cj5)*(sj0));
IkReal x585=((IkReal(1.00000000000000))*(cj4));
IkReal x586=((IkReal(1.00000000000000))*(cj5));
IkReal x587=((sj2)*(x580));
IkReal x588=((IkReal(1.00000000000000))*(x581));
IkReal x589=((cj2)*(x580));
IkReal x590=((cj2)*(x588));
evalcond[0]=((((IkReal(-1.00000000000000))*(sj2)*(x588)))+(((r20)*(sj5)))+(((IkReal(-1.00000000000000))*(x589)))+(((cj5)*(r21))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x590)))+(((cj4)*(r22)))+(x587)+(((IkReal(-1.00000000000000))*(r20)*(sj4)*(x586)))+(((r21)*(sj4)*(sj5))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x590)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x583)))+(((IkReal(-1.00000000000000))*(r11)*(x584)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x583)))+(((IkReal(-1.00000000000000))*(cj0)*(r01)*(x586)))+(x587));
evalcond[3]=((((r10)*(sj4)*(x584)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x585)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x585)))+(((IkReal(-1.00000000000000))*(r01)*(x582)*(x583)))+(((sj2)*(x581)))+(x589)+(((cj5)*(r00)*(x582)))+(((IkReal(-1.00000000000000))*(r11)*(sj0)*(sj4)*(x583))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x591=((cj2)*(sj5));
IkReal x592=((r21)*(sj4));
IkReal x593=((r20)*(sj2));
IkReal x594=((cj5)*(sj4));
IkReal x595=((cj5)*(r21));
IkReal x596=((IkReal(1.00000000000000))*(sj2));
IkReal x597=((cj4)*(r22));
if( IKabs(((gconst102)*(((((x593)*(x594)))+(((cj2)*(x595)))+(((IkReal(-1.00000000000000))*(x596)*(x597)))+(((r20)*(x591)))+(((IkReal(-1.00000000000000))*(sj5)*(x592)*(x596))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst102)*(((((cj2)*(x597)))+(((sj2)*(x595)))+(((IkReal(-1.00000000000000))*(cj2)*(r20)*(x594)))+(((x591)*(x592)))+(((sj5)*(x593))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst102)*(((((x593)*(x594)))+(((cj2)*(x595)))+(((IkReal(-1.00000000000000))*(x596)*(x597)))+(((r20)*(x591)))+(((IkReal(-1.00000000000000))*(sj5)*(x592)*(x596)))))), ((gconst102)*(((((cj2)*(x597)))+(((sj2)*(x595)))+(((IkReal(-1.00000000000000))*(cj2)*(r20)*(x594)))+(((x591)*(x592)))+(((sj5)*(x593)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[2];
IkReal x598=IKsin(j1);
IkReal x599=IKcos(j1);
IkReal x600=((IkReal(1.00000000000000))*(x599));
evalcond[0]=((((IkReal(-1.00000000000000))*(sj2)*(x600)))+(((IkReal(-1.00000000000000))*(cj2)*(x598)))+(((r20)*(sj5)))+(((cj5)*(r21))));
evalcond[1]=((((IkReal(-1.00000000000000))*(cj5)*(r20)*(sj4)))+(((IkReal(-1.00000000000000))*(cj2)*(x600)))+(((cj4)*(r22)))+(((r21)*(sj4)*(sj5)))+(((sj2)*(x598))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst106;
IkReal x601=(cj5)*(cj5);
IkReal x602=(sj5)*(sj5);
IkReal x603=((sj4)*(sj5));
IkReal x604=((IkReal(1.00000000000000))*(r12));
IkReal x605=((cj5)*(sj4));
IkReal x606=((cj4)*(r00)*(r11));
IkReal x607=((IkReal(1.00000000000000))*(cj4)*(r01)*(r10));
gconst106=IKsign(((((x602)*(x606)))+(((r02)*(r10)*(x603)))+(((r02)*(r11)*(x605)))+(((IkReal(-1.00000000000000))*(x601)*(x607)))+(((x601)*(x606)))+(((IkReal(-1.00000000000000))*(x602)*(x607)))+(((IkReal(-1.00000000000000))*(r00)*(x603)*(x604)))+(((IkReal(-1.00000000000000))*(r01)*(x604)*(x605)))));
IkReal x608=(cj5)*(cj5);
IkReal x609=(sj5)*(sj5);
IkReal x610=((sj4)*(sj5));
IkReal x611=((IkReal(1.00000000000000))*(r12));
IkReal x612=((cj5)*(sj4));
IkReal x613=((cj4)*(r00)*(r11));
IkReal x614=x607;
dummyeval[0]=((((IkReal(-1.00000000000000))*(r00)*(x610)*(x611)))+(((x609)*(x613)))+(((r02)*(r10)*(x610)))+(((x608)*(x613)))+(((IkReal(-1.00000000000000))*(r01)*(x611)*(x612)))+(((r02)*(r11)*(x612)))+(((IkReal(-1.00000000000000))*(x608)*(x614)))+(((IkReal(-1.00000000000000))*(x609)*(x614))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst105;
IkReal x615=(cj5)*(cj5);
IkReal x616=(sj5)*(sj5);
IkReal x617=((IkReal(1.00000000000000))*(x616));
IkReal x618=((IkReal(2.00000000000000))*(cj5)*(sj5));
IkReal x619=((IkReal(1.00000000000000))*(x615));
gconst105=IKsign(((((IkReal(-1.00000000000000))*(x617)*((r10)*(r10))))+(((IkReal(-1.00000000000000))*(r10)*(r11)*(x618)))+(((IkReal(-1.00000000000000))*(x617)*((r00)*(r00))))+(((IkReal(-1.00000000000000))*(r00)*(r01)*(x618)))+(((IkReal(-1.00000000000000))*(x619)*((r11)*(r11))))+(((IkReal(-1.00000000000000))*(x619)*((r01)*(r01))))));
IkReal x620=(cj5)*(cj5);
IkReal x621=(sj5)*(sj5);
IkReal x622=((IkReal(1.00000000000000))*(x621));
IkReal x623=((IkReal(2.00000000000000))*(cj5)*(sj5));
IkReal x624=((IkReal(1.00000000000000))*(x620));
dummyeval[0]=((((IkReal(-1.00000000000000))*(r00)*(r01)*(x623)))+(((IkReal(-1.00000000000000))*(x624)*((r11)*(r11))))+(((IkReal(-1.00000000000000))*(x622)*((r00)*(r00))))+(((IkReal(-1.00000000000000))*(x622)*((r10)*(r10))))+(((IkReal(-1.00000000000000))*(r10)*(r11)*(x623)))+(((IkReal(-1.00000000000000))*(x624)*((r01)*(r01)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x625=((cj1)*(cj2));
IkReal x626=((r00)*(sj5));
IkReal x627=((cj5)*(r01));
IkReal x628=((r10)*(sj5));
IkReal x629=((cj5)*(r11));
IkReal x630=((IkReal(1.00000000000000))*(sj1)*(sj2));
if( IKabs(((gconst105)*(((((IkReal(-1.00000000000000))*(x629)*(x630)))+(((x625)*(x628)))+(((x625)*(x629)))+(((IkReal(-1.00000000000000))*(x628)*(x630))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst105)*(((((IkReal(-1.00000000000000))*(x626)*(x630)))+(((IkReal(-1.00000000000000))*(x627)*(x630)))+(((x625)*(x626)))+(((x625)*(x627))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst105)*(((((IkReal(-1.00000000000000))*(x629)*(x630)))+(((x625)*(x628)))+(((x625)*(x629)))+(((IkReal(-1.00000000000000))*(x628)*(x630)))))), ((gconst105)*(((((IkReal(-1.00000000000000))*(x626)*(x630)))+(((IkReal(-1.00000000000000))*(x627)*(x630)))+(((x625)*(x626)))+(((x625)*(x627)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[6];
IkReal x631=IKsin(j0);
IkReal x632=IKcos(j0);
IkReal x633=((IkReal(1.00000000000000))*(r10));
IkReal x634=((IkReal(1.00000000000000))*(sj4));
IkReal x635=((cj5)*(r01));
IkReal x636=((cj5)*(r00));
IkReal x637=((cj4)*(r01));
IkReal x638=((IkReal(1.00000000000000))*(cj4));
IkReal x639=((cj4)*(r11));
IkReal x640=((sj5)*(x631));
IkReal x641=((r11)*(x634));
IkReal x642=((sj5)*(x632));
IkReal x643=((r02)*(x632));
IkReal x644=((r12)*(x632));
IkReal x645=((IkReal(1.00000000000000))*(x632));
IkReal x646=((cj4)*(x631));
IkReal x647=((cj5)*(x631));
IkReal x648=((cj5)*(sj4)*(x632));
evalcond[0]=((((IkReal(-1.00000000000000))*(cj5)*(r11)*(x645)))+(((r00)*(x640)))+(((x631)*(x635)))+(((IkReal(-1.00000000000000))*(x633)*(x642))));
evalcond[1]=((((IkReal(-1.00000000000000))*(cj1)*(cj2)))+(((IkReal(-1.00000000000000))*(x633)*(x640)))+(((sj1)*(sj2)))+(((IkReal(-1.00000000000000))*(r00)*(x642)))+(((IkReal(-1.00000000000000))*(x635)*(x645)))+(((IkReal(-1.00000000000000))*(r11)*(x647))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x638)*(x644)))+(((IkReal(-1.00000000000000))*(x631)*(x634)*(x636)))+(((r01)*(sj4)*(x640)))+(((r10)*(x648)))+(((r02)*(x646)))+(((IkReal(-1.00000000000000))*(x641)*(x642))));
evalcond[3]=((IkReal(1.00000000000000))+(((x639)*(x642)))+(((r02)*(sj4)*(x631)))+(((IkReal(-1.00000000000000))*(x637)*(x640)))+(((IkReal(-1.00000000000000))*(x634)*(x644)))+(((IkReal(-1.00000000000000))*(cj4)*(cj5)*(x632)*(x633)))+(((x636)*(x646))));
evalcond[4]=((((cj1)*(sj2)))+(((r10)*(sj4)*(x647)))+(((IkReal(-1.00000000000000))*(x640)*(x641)))+(((IkReal(-1.00000000000000))*(r12)*(x631)*(x638)))+(((IkReal(-1.00000000000000))*(r01)*(x634)*(x642)))+(((sj4)*(x632)*(x636)))+(((cj2)*(sj1)))+(((IkReal(-1.00000000000000))*(x638)*(x643))));
evalcond[5]=((((x639)*(x640)))+(((IkReal(-1.00000000000000))*(x632)*(x636)*(x638)))+(((IkReal(-1.00000000000000))*(cj5)*(x633)*(x646)))+(((IkReal(-1.00000000000000))*(r12)*(x631)*(x634)))+(((x637)*(x642)))+(((IkReal(-1.00000000000000))*(x634)*(x643))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x649=((IkReal(1.00000000000000))*(cj5));
IkReal x650=((IkReal(1.00000000000000))*(sj5));
if( IKabs(((gconst106)*(((((IkReal(-1.00000000000000))*(r11)*(x649)))+(((IkReal(-1.00000000000000))*(r10)*(x650))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst106)*(((((IkReal(-1.00000000000000))*(r00)*(x650)))+(((IkReal(-1.00000000000000))*(r01)*(x649))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst106)*(((((IkReal(-1.00000000000000))*(r11)*(x649)))+(((IkReal(-1.00000000000000))*(r10)*(x650)))))), ((gconst106)*(((((IkReal(-1.00000000000000))*(r00)*(x650)))+(((IkReal(-1.00000000000000))*(r01)*(x649)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[6];
IkReal x651=IKsin(j0);
IkReal x652=IKcos(j0);
IkReal x653=((IkReal(1.00000000000000))*(r10));
IkReal x654=((IkReal(1.00000000000000))*(sj4));
IkReal x655=((cj5)*(r01));
IkReal x656=((cj5)*(r00));
IkReal x657=((cj4)*(r01));
IkReal x658=((IkReal(1.00000000000000))*(cj4));
IkReal x659=((cj4)*(r11));
IkReal x660=((sj5)*(x651));
IkReal x661=((r11)*(x654));
IkReal x662=((sj5)*(x652));
IkReal x663=((r02)*(x652));
IkReal x664=((r12)*(x652));
IkReal x665=((IkReal(1.00000000000000))*(x652));
IkReal x666=((cj4)*(x651));
IkReal x667=((cj5)*(x651));
IkReal x668=((cj5)*(sj4)*(x652));
evalcond[0]=((((x651)*(x655)))+(((r00)*(x660)))+(((IkReal(-1.00000000000000))*(x653)*(x662)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x665))));
evalcond[1]=((((IkReal(-1.00000000000000))*(cj1)*(cj2)))+(((IkReal(-1.00000000000000))*(r00)*(x662)))+(((IkReal(-1.00000000000000))*(x655)*(x665)))+(((IkReal(-1.00000000000000))*(x653)*(x660)))+(((sj1)*(sj2)))+(((IkReal(-1.00000000000000))*(r11)*(x667))));
evalcond[2]=((((r01)*(sj4)*(x660)))+(((r02)*(x666)))+(((IkReal(-1.00000000000000))*(x661)*(x662)))+(((IkReal(-1.00000000000000))*(x651)*(x654)*(x656)))+(((r10)*(x668)))+(((IkReal(-1.00000000000000))*(x658)*(x664))));
evalcond[3]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(cj4)*(cj5)*(x652)*(x653)))+(((IkReal(-1.00000000000000))*(x654)*(x664)))+(((r02)*(sj4)*(x651)))+(((IkReal(-1.00000000000000))*(x657)*(x660)))+(((x659)*(x662)))+(((x656)*(x666))));
evalcond[4]=((((cj1)*(sj2)))+(((r10)*(sj4)*(x667)))+(((IkReal(-1.00000000000000))*(r01)*(x654)*(x662)))+(((IkReal(-1.00000000000000))*(x660)*(x661)))+(((IkReal(-1.00000000000000))*(r12)*(x651)*(x658)))+(((sj4)*(x652)*(x656)))+(((cj2)*(sj1)))+(((IkReal(-1.00000000000000))*(x658)*(x663))));
evalcond[5]=((((IkReal(-1.00000000000000))*(cj5)*(x653)*(x666)))+(((IkReal(-1.00000000000000))*(x652)*(x656)*(x658)))+(((IkReal(-1.00000000000000))*(r12)*(x651)*(x654)))+(((x659)*(x660)))+(((x657)*(x662)))+(((IkReal(-1.00000000000000))*(x654)*(x663))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
IkReal x669=((cj5)*(npx));
IkReal x670=((IkReal(1.00000000000000))*(cj4)*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j3)), IkReal(6.28318530717959))));
evalcond[1]=((IkReal(0.0950000000000000))+(((cj5)*(npy)))+(((IkReal(0.350000000000000))*(sj2)))+(((npx)*(sj5))));
evalcond[2]=((IkReal(-0.350000000000000))+(((IkReal(-0.350000000000000))*(cj2)))+(((cj4)*(npz)))+(((IkReal(-1.00000000000000))*(sj4)*(x669)))+(((npy)*(sj4)*(sj5))));
evalcond[3]=((((cj4)*(x669)))+(((IkReal(-1.00000000000000))*(npy)*(x670)))+(((npz)*(sj4))));
evalcond[4]=((((cj4)*(cj5)*(r20)))+(((r22)*(sj4)))+(((IkReal(-1.00000000000000))*(r21)*(x670))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst109;
gconst109=IKsign(((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2))))));
dummyeval[0]=((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst107;
IkReal x671=(sj5)*(sj5);
IkReal x672=(cj5)*(cj5);
IkReal x673=((cj5)*(sj4));
IkReal x674=((IkReal(1.00000000000000))*(r02));
IkReal x675=((sj4)*(sj5));
IkReal x676=((cj4)*(r01)*(r10));
IkReal x677=((IkReal(1.00000000000000))*(cj4)*(r00)*(r11));
gconst107=IKsign(((((r00)*(r12)*(x675)))+(((x672)*(x676)))+(((IkReal(-1.00000000000000))*(r10)*(x674)*(x675)))+(((IkReal(-1.00000000000000))*(x672)*(x677)))+(((x671)*(x676)))+(((IkReal(-1.00000000000000))*(r11)*(x673)*(x674)))+(((IkReal(-1.00000000000000))*(x671)*(x677)))+(((r01)*(r12)*(x673)))));
IkReal x678=(sj5)*(sj5);
IkReal x679=(cj5)*(cj5);
IkReal x680=((cj5)*(sj4));
IkReal x681=((IkReal(1.00000000000000))*(r02));
IkReal x682=((sj4)*(sj5));
IkReal x683=((cj4)*(r01)*(r10));
IkReal x684=x677;
dummyeval[0]=((((IkReal(-1.00000000000000))*(r10)*(x681)*(x682)))+(((r00)*(r12)*(x682)))+(((IkReal(-1.00000000000000))*(x679)*(x684)))+(((IkReal(-1.00000000000000))*(x678)*(x684)))+(((IkReal(-1.00000000000000))*(r11)*(x680)*(x681)))+(((x679)*(x683)))+(((r01)*(r12)*(x680)))+(((x678)*(x683))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst108;
IkReal x685=(cj4)*(cj4);
IkReal x686=(sj4)*(sj4);
IkReal x687=((cj5)*(r10));
IkReal x688=((r01)*(sj5));
IkReal x689=((r12)*(x686));
IkReal x690=((IkReal(1.00000000000000))*(cj5)*(r00));
IkReal x691=((r02)*(x685));
IkReal x692=((IkReal(1.00000000000000))*(r11)*(sj5));
IkReal x693=((r12)*(x685));
IkReal x694=((r02)*(x686));
gconst108=IKsign(((((x687)*(x694)))+(((x688)*(x689)))+(((IkReal(-1.00000000000000))*(x692)*(x694)))+(((IkReal(-1.00000000000000))*(x689)*(x690)))+(((x687)*(x691)))+(((x688)*(x693)))+(((IkReal(-1.00000000000000))*(x691)*(x692)))+(((IkReal(-1.00000000000000))*(x690)*(x693)))));
IkReal x695=(cj4)*(cj4);
IkReal x696=(sj4)*(sj4);
IkReal x697=((cj5)*(r10));
IkReal x698=((r01)*(sj5));
IkReal x699=((r12)*(x696));
IkReal x700=((IkReal(1.00000000000000))*(cj5)*(r00));
IkReal x701=((r02)*(x695));
IkReal x702=((IkReal(1.00000000000000))*(r11)*(sj5));
IkReal x703=((r12)*(x695));
IkReal x704=((r02)*(x696));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x700)*(x703)))+(((x698)*(x699)))+(((x697)*(x704)))+(((IkReal(-1.00000000000000))*(x701)*(x702)))+(((x697)*(x701)))+(((IkReal(-1.00000000000000))*(x699)*(x700)))+(((IkReal(-1.00000000000000))*(x702)*(x704)))+(((x698)*(x703))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x705=((cj5)*(sj4));
IkReal x706=((IkReal(1.00000000000000))*(cj4));
IkReal x707=((IkReal(1.00000000000000))*(sj4)*(sj5));
if( IKabs(((gconst108)*(((((IkReal(-1.00000000000000))*(r11)*(x707)))+(((IkReal(-1.00000000000000))*(r12)*(x706)))+(((r10)*(x705))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst108)*(((((r00)*(x705)))+(((IkReal(-1.00000000000000))*(r01)*(x707)))+(((IkReal(-1.00000000000000))*(r02)*(x706))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst108)*(((((IkReal(-1.00000000000000))*(r11)*(x707)))+(((IkReal(-1.00000000000000))*(r12)*(x706)))+(((r10)*(x705)))))), ((gconst108)*(((((r00)*(x705)))+(((IkReal(-1.00000000000000))*(r01)*(x707)))+(((IkReal(-1.00000000000000))*(r02)*(x706)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[4];
IkReal x708=IKsin(j0);
IkReal x709=IKcos(j0);
IkReal x710=((IkReal(1.00000000000000))*(sj5));
IkReal x711=((cj5)*(r10));
IkReal x712=((IkReal(1.00000000000000))*(r12));
IkReal x713=((cj4)*(cj5));
IkReal x714=((r11)*(sj5));
IkReal x715=((IkReal(1.00000000000000))*(cj5));
IkReal x716=((r00)*(x708));
IkReal x717=((sj4)*(x709));
IkReal x718=((r01)*(x708));
IkReal x719=((sj4)*(x708));
IkReal x720=((cj4)*(x708));
IkReal x721=((cj4)*(x709));
evalcond[0]=((((IkReal(-1.00000000000000))*(r10)*(x709)*(x710)))+(((IkReal(-1.00000000000000))*(r11)*(x709)*(x715)))+(((cj5)*(x718)))+(((sj5)*(x716))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x712)*(x721)))+(((sj4)*(sj5)*(x718)))+(((IkReal(-1.00000000000000))*(r11)*(x710)*(x717)))+(((x711)*(x717)))+(((IkReal(-1.00000000000000))*(sj4)*(x715)*(x716)))+(((r02)*(x720))));
evalcond[2]=((IkReal(-1.00000000000000))+(((r02)*(x719)))+(((IkReal(-1.00000000000000))*(x711)*(x721)))+(((IkReal(-1.00000000000000))*(x712)*(x717)))+(((x713)*(x716)))+(((IkReal(-1.00000000000000))*(cj4)*(x710)*(x718)))+(((x714)*(x721))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x712)*(x719)))+(((IkReal(-1.00000000000000))*(x711)*(x720)))+(((IkReal(-1.00000000000000))*(r02)*(x717)))+(((x714)*(x720)))+(((r01)*(sj5)*(x721)))+(((IkReal(-1.00000000000000))*(r00)*(x709)*(x713))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst110;
gconst110=IKsign(((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2))))));
dummyeval[0]=((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst111;
gconst111=IKsign((((cj2)*(cj2))+((sj2)*(sj2))));
dummyeval[0]=(((cj2)*(cj2))+((sj2)*(sj2)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x722=((IkReal(1.00000000000000))*(sj2));
IkReal x723=((r20)*(sj5));
IkReal x724=((IkReal(1.00000000000000))*(cj2));
IkReal x725=((cj5)*(r21));
IkReal x726=((cj5)*(r11)*(sj0));
IkReal x727=((r10)*(sj0)*(sj5));
IkReal x728=((cj0)*(r00)*(sj5));
IkReal x729=((cj0)*(cj5)*(r01));
if( IKabs(((gconst111)*(((((IkReal(-1.00000000000000))*(x723)*(x724)))+(((IkReal(-1.00000000000000))*(x722)*(x726)))+(((IkReal(-1.00000000000000))*(x724)*(x725)))+(((IkReal(-1.00000000000000))*(x722)*(x728)))+(((IkReal(-1.00000000000000))*(x722)*(x727)))+(((IkReal(-1.00000000000000))*(x722)*(x729))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst111)*(((((cj2)*(x727)))+(((cj2)*(x726)))+(((cj2)*(x729)))+(((IkReal(-1.00000000000000))*(x722)*(x723)))+(((IkReal(-1.00000000000000))*(x722)*(x725)))+(((cj2)*(x728))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst111)*(((((IkReal(-1.00000000000000))*(x723)*(x724)))+(((IkReal(-1.00000000000000))*(x722)*(x726)))+(((IkReal(-1.00000000000000))*(x724)*(x725)))+(((IkReal(-1.00000000000000))*(x722)*(x728)))+(((IkReal(-1.00000000000000))*(x722)*(x727)))+(((IkReal(-1.00000000000000))*(x722)*(x729)))))), ((gconst111)*(((((cj2)*(x727)))+(((cj2)*(x726)))+(((cj2)*(x729)))+(((IkReal(-1.00000000000000))*(x722)*(x723)))+(((IkReal(-1.00000000000000))*(x722)*(x725)))+(((cj2)*(x728)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x730=IKsin(j1);
IkReal x731=IKcos(j1);
IkReal x732=((cj5)*(sj0));
IkReal x733=((IkReal(1.00000000000000))*(r11));
IkReal x734=((cj5)*(sj4));
IkReal x735=((cj0)*(r00));
IkReal x736=((IkReal(1.00000000000000))*(sj0));
IkReal x737=((sj4)*(sj5));
IkReal x738=((IkReal(1.00000000000000))*(cj0));
IkReal x739=((sj2)*(x731));
IkReal x740=((cj2)*(x730));
IkReal x741=((cj2)*(x731));
IkReal x742=((sj2)*(x730));
IkReal x743=((x740)+(x739));
evalcond[0]=((x743)+(((r20)*(sj5)))+(((cj5)*(r21))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x741)))+(((IkReal(-1.00000000000000))*(r20)*(x734)))+(((r21)*(x737)))+(x742)+(((cj4)*(r22))));
evalcond[2]=((x741)+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(x738)))+(((IkReal(-1.00000000000000))*(sj5)*(x735)))+(((IkReal(-1.00000000000000))*(x742)))+(((IkReal(-1.00000000000000))*(r10)*(sj5)*(x736)))+(((IkReal(-1.00000000000000))*(x732)*(x733))));
evalcond[3]=((((IkReal(-1.00000000000000))*(cj4)*(r02)*(x738)))+(x743)+(((IkReal(-1.00000000000000))*(cj4)*(r12)*(x736)))+(((IkReal(-1.00000000000000))*(sj0)*(x733)*(x737)))+(((x734)*(x735)))+(((IkReal(-1.00000000000000))*(r01)*(x737)*(x738)))+(((r10)*(sj4)*(x732))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x744=((cj4)*(r22));
IkReal x745=((r20)*(sj5));
IkReal x746=((cj5)*(r21));
IkReal x747=((sj2)*(sj4));
IkReal x748=((r21)*(sj5));
IkReal x749=((IkReal(1.00000000000000))*(cj2));
IkReal x750=((cj5)*(r20));
if( IKabs(((gconst110)*(((((IkReal(-1.00000000000000))*(x747)*(x750)))+(((sj2)*(x744)))+(((x747)*(x748)))+(((cj2)*(x745)))+(((cj2)*(x746))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst110)*(((((cj2)*(sj4)*(x750)))+(((sj2)*(x746)))+(((IkReal(-1.00000000000000))*(sj4)*(x748)*(x749)))+(((IkReal(-1.00000000000000))*(x744)*(x749)))+(((sj2)*(x745))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst110)*(((((IkReal(-1.00000000000000))*(x747)*(x750)))+(((sj2)*(x744)))+(((x747)*(x748)))+(((cj2)*(x745)))+(((cj2)*(x746)))))), ((gconst110)*(((((cj2)*(sj4)*(x750)))+(((sj2)*(x746)))+(((IkReal(-1.00000000000000))*(sj4)*(x748)*(x749)))+(((IkReal(-1.00000000000000))*(x744)*(x749)))+(((sj2)*(x745)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x751=IKsin(j1);
IkReal x752=IKcos(j1);
IkReal x753=((cj5)*(sj0));
IkReal x754=((IkReal(1.00000000000000))*(r11));
IkReal x755=((cj5)*(sj4));
IkReal x756=((cj0)*(r00));
IkReal x757=((IkReal(1.00000000000000))*(sj0));
IkReal x758=((sj4)*(sj5));
IkReal x759=((IkReal(1.00000000000000))*(cj0));
IkReal x760=((sj2)*(x752));
IkReal x761=((cj2)*(x751));
IkReal x762=((cj2)*(x752));
IkReal x763=((sj2)*(x751));
IkReal x764=((x760)+(x761));
evalcond[0]=((x764)+(((r20)*(sj5)))+(((cj5)*(r21))));
evalcond[1]=((((cj4)*(r22)))+(((IkReal(-1.00000000000000))*(x762)))+(x763)+(((IkReal(-1.00000000000000))*(r20)*(x755)))+(((r21)*(x758))));
evalcond[2]=((((IkReal(-1.00000000000000))*(cj5)*(r01)*(x759)))+(((IkReal(-1.00000000000000))*(x753)*(x754)))+(x762)+(((IkReal(-1.00000000000000))*(r10)*(sj5)*(x757)))+(((IkReal(-1.00000000000000))*(x763)))+(((IkReal(-1.00000000000000))*(sj5)*(x756))));
evalcond[3]=((((IkReal(-1.00000000000000))*(sj0)*(x754)*(x758)))+(((IkReal(-1.00000000000000))*(cj4)*(r02)*(x759)))+(((r10)*(sj4)*(x753)))+(x764)+(((IkReal(-1.00000000000000))*(r01)*(x758)*(x759)))+(((x755)*(x756)))+(((IkReal(-1.00000000000000))*(cj4)*(r12)*(x757))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x765=((IkReal(1.00000000000000))*(cj5));
IkReal x766=((IkReal(1.00000000000000))*(sj5));
if( IKabs(((gconst107)*(((((IkReal(-1.00000000000000))*(r11)*(x765)))+(((IkReal(-1.00000000000000))*(r10)*(x766))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst107)*(((((IkReal(-1.00000000000000))*(r01)*(x765)))+(((IkReal(-1.00000000000000))*(r00)*(x766))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst107)*(((((IkReal(-1.00000000000000))*(r11)*(x765)))+(((IkReal(-1.00000000000000))*(r10)*(x766)))))), ((gconst107)*(((((IkReal(-1.00000000000000))*(r01)*(x765)))+(((IkReal(-1.00000000000000))*(r00)*(x766)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[4];
IkReal x767=IKsin(j0);
IkReal x768=IKcos(j0);
IkReal x769=((IkReal(1.00000000000000))*(sj5));
IkReal x770=((cj5)*(r10));
IkReal x771=((IkReal(1.00000000000000))*(r12));
IkReal x772=((cj4)*(cj5));
IkReal x773=((r11)*(sj5));
IkReal x774=((IkReal(1.00000000000000))*(cj5));
IkReal x775=((r00)*(x767));
IkReal x776=((sj4)*(x768));
IkReal x777=((r01)*(x767));
IkReal x778=((sj4)*(x767));
IkReal x779=((cj4)*(x767));
IkReal x780=((cj4)*(x768));
evalcond[0]=((((IkReal(-1.00000000000000))*(r11)*(x768)*(x774)))+(((cj5)*(x777)))+(((IkReal(-1.00000000000000))*(r10)*(x768)*(x769)))+(((sj5)*(x775))));
evalcond[1]=((((r02)*(x779)))+(((IkReal(-1.00000000000000))*(r11)*(x769)*(x776)))+(((sj4)*(sj5)*(x777)))+(((IkReal(-1.00000000000000))*(sj4)*(x774)*(x775)))+(((x770)*(x776)))+(((IkReal(-1.00000000000000))*(x771)*(x780))));
evalcond[2]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(x771)*(x776)))+(((x773)*(x780)))+(((IkReal(-1.00000000000000))*(x770)*(x780)))+(((IkReal(-1.00000000000000))*(cj4)*(x769)*(x777)))+(((x772)*(x775)))+(((r02)*(x778))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r02)*(x776)))+(((IkReal(-1.00000000000000))*(r00)*(x768)*(x772)))+(((IkReal(-1.00000000000000))*(x771)*(x778)))+(((IkReal(-1.00000000000000))*(x770)*(x779)))+(((r01)*(sj5)*(x780)))+(((x773)*(x779))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst110;
gconst110=IKsign(((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2))))));
dummyeval[0]=((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst111;
gconst111=IKsign((((cj2)*(cj2))+((sj2)*(sj2))));
dummyeval[0]=(((cj2)*(cj2))+((sj2)*(sj2)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x781=((IkReal(1.00000000000000))*(sj2));
IkReal x782=((r20)*(sj5));
IkReal x783=((IkReal(1.00000000000000))*(cj2));
IkReal x784=((cj5)*(r21));
IkReal x785=((cj5)*(r11)*(sj0));
IkReal x786=((r10)*(sj0)*(sj5));
IkReal x787=((cj0)*(r00)*(sj5));
IkReal x788=((cj0)*(cj5)*(r01));
if( IKabs(((gconst111)*(((((IkReal(-1.00000000000000))*(x783)*(x784)))+(((IkReal(-1.00000000000000))*(x781)*(x788)))+(((IkReal(-1.00000000000000))*(x781)*(x785)))+(((IkReal(-1.00000000000000))*(x781)*(x786)))+(((IkReal(-1.00000000000000))*(x782)*(x783)))+(((IkReal(-1.00000000000000))*(x781)*(x787))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst111)*(((((IkReal(-1.00000000000000))*(x781)*(x784)))+(((IkReal(-1.00000000000000))*(x781)*(x782)))+(((cj2)*(x785)))+(((cj2)*(x786)))+(((cj2)*(x788)))+(((cj2)*(x787))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst111)*(((((IkReal(-1.00000000000000))*(x783)*(x784)))+(((IkReal(-1.00000000000000))*(x781)*(x788)))+(((IkReal(-1.00000000000000))*(x781)*(x785)))+(((IkReal(-1.00000000000000))*(x781)*(x786)))+(((IkReal(-1.00000000000000))*(x782)*(x783)))+(((IkReal(-1.00000000000000))*(x781)*(x787)))))), ((gconst111)*(((((IkReal(-1.00000000000000))*(x781)*(x784)))+(((IkReal(-1.00000000000000))*(x781)*(x782)))+(((cj2)*(x785)))+(((cj2)*(x786)))+(((cj2)*(x788)))+(((cj2)*(x787)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x789=IKsin(j1);
IkReal x790=IKcos(j1);
IkReal x791=((cj5)*(sj0));
IkReal x792=((IkReal(1.00000000000000))*(r11));
IkReal x793=((cj5)*(sj4));
IkReal x794=((cj0)*(r00));
IkReal x795=((IkReal(1.00000000000000))*(sj0));
IkReal x796=((sj4)*(sj5));
IkReal x797=((IkReal(1.00000000000000))*(cj0));
IkReal x798=((sj2)*(x790));
IkReal x799=((cj2)*(x789));
IkReal x800=((cj2)*(x790));
IkReal x801=((sj2)*(x789));
IkReal x802=((x799)+(x798));
evalcond[0]=((x802)+(((r20)*(sj5)))+(((cj5)*(r21))));
evalcond[1]=((x801)+(((IkReal(-1.00000000000000))*(r20)*(x793)))+(((IkReal(-1.00000000000000))*(x800)))+(((cj4)*(r22)))+(((r21)*(x796))));
evalcond[2]=((x800)+(((IkReal(-1.00000000000000))*(x801)))+(((IkReal(-1.00000000000000))*(x791)*(x792)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(x797)))+(((IkReal(-1.00000000000000))*(sj5)*(x794)))+(((IkReal(-1.00000000000000))*(r10)*(sj5)*(x795))));
evalcond[3]=((((IkReal(-1.00000000000000))*(cj4)*(r02)*(x797)))+(x802)+(((IkReal(-1.00000000000000))*(sj0)*(x792)*(x796)))+(((IkReal(-1.00000000000000))*(r01)*(x796)*(x797)))+(((IkReal(-1.00000000000000))*(cj4)*(r12)*(x795)))+(((x793)*(x794)))+(((r10)*(sj4)*(x791))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x803=((cj4)*(r22));
IkReal x804=((r20)*(sj5));
IkReal x805=((cj5)*(r21));
IkReal x806=((sj2)*(sj4));
IkReal x807=((r21)*(sj5));
IkReal x808=((IkReal(1.00000000000000))*(cj2));
IkReal x809=((cj5)*(r20));
if( IKabs(((gconst110)*(((((cj2)*(x804)))+(((IkReal(-1.00000000000000))*(x806)*(x809)))+(((cj2)*(x805)))+(((sj2)*(x803)))+(((x806)*(x807))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst110)*(((((cj2)*(sj4)*(x809)))+(((sj2)*(x804)))+(((sj2)*(x805)))+(((IkReal(-1.00000000000000))*(x803)*(x808)))+(((IkReal(-1.00000000000000))*(sj4)*(x807)*(x808))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst110)*(((((cj2)*(x804)))+(((IkReal(-1.00000000000000))*(x806)*(x809)))+(((cj2)*(x805)))+(((sj2)*(x803)))+(((x806)*(x807)))))), ((gconst110)*(((((cj2)*(sj4)*(x809)))+(((sj2)*(x804)))+(((sj2)*(x805)))+(((IkReal(-1.00000000000000))*(x803)*(x808)))+(((IkReal(-1.00000000000000))*(sj4)*(x807)*(x808)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x810=IKsin(j1);
IkReal x811=IKcos(j1);
IkReal x812=((cj5)*(sj0));
IkReal x813=((IkReal(1.00000000000000))*(r11));
IkReal x814=((cj5)*(sj4));
IkReal x815=((cj0)*(r00));
IkReal x816=((IkReal(1.00000000000000))*(sj0));
IkReal x817=((sj4)*(sj5));
IkReal x818=((IkReal(1.00000000000000))*(cj0));
IkReal x819=((sj2)*(x811));
IkReal x820=((cj2)*(x810));
IkReal x821=((cj2)*(x811));
IkReal x822=((sj2)*(x810));
IkReal x823=((x820)+(x819));
evalcond[0]=((x823)+(((r20)*(sj5)))+(((cj5)*(r21))));
evalcond[1]=((x822)+(((IkReal(-1.00000000000000))*(x821)))+(((cj4)*(r22)))+(((r21)*(x817)))+(((IkReal(-1.00000000000000))*(r20)*(x814))));
evalcond[2]=((x821)+(((IkReal(-1.00000000000000))*(r10)*(sj5)*(x816)))+(((IkReal(-1.00000000000000))*(x822)))+(((IkReal(-1.00000000000000))*(sj5)*(x815)))+(((IkReal(-1.00000000000000))*(x812)*(x813)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(x818))));
evalcond[3]=((x823)+(((IkReal(-1.00000000000000))*(cj4)*(r02)*(x818)))+(((IkReal(-1.00000000000000))*(sj0)*(x813)*(x817)))+(((r10)*(sj4)*(x812)))+(((IkReal(-1.00000000000000))*(cj4)*(r12)*(x816)))+(((x814)*(x815)))+(((IkReal(-1.00000000000000))*(r01)*(x817)*(x818))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x824=((cj4)*(r22));
IkReal x825=((cj2)*(sj5));
IkReal x826=((r21)*(sj4));
IkReal x827=((cj2)*(cj5));
IkReal x828=((sj2)*(sj5));
IkReal x829=((r20)*(sj4));
IkReal x830=((cj5)*(sj2));
if( IKabs(((gconst109)*(((((x826)*(x828)))+(((r21)*(x827)))+(((sj2)*(x824)))+(((r20)*(x825)))+(((IkReal(-1.00000000000000))*(x829)*(x830))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst109)*(((((x827)*(x829)))+(((IkReal(-1.00000000000000))*(cj2)*(x824)))+(((IkReal(-1.00000000000000))*(x825)*(x826)))+(((r21)*(x830)))+(((r20)*(x828))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst109)*(((((x826)*(x828)))+(((r21)*(x827)))+(((sj2)*(x824)))+(((r20)*(x825)))+(((IkReal(-1.00000000000000))*(x829)*(x830)))))), ((gconst109)*(((((x827)*(x829)))+(((IkReal(-1.00000000000000))*(cj2)*(x824)))+(((IkReal(-1.00000000000000))*(x825)*(x826)))+(((r21)*(x830)))+(((r20)*(x828)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[2];
IkReal x831=IKsin(j1);
IkReal x832=IKcos(j1);
evalcond[0]=((((cj2)*(x831)))+(((sj2)*(x832)))+(((r20)*(sj5)))+(((cj5)*(r21))));
evalcond[1]=((((IkReal(-1.00000000000000))*(cj5)*(r20)*(sj4)))+(((sj2)*(x831)))+(((IkReal(-1.00000000000000))*(cj2)*(x832)))+(((cj4)*(r22)))+(((r21)*(sj4)*(sj5))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst113;
IkReal x833=(sj5)*(sj5);
IkReal x834=(cj5)*(cj5);
IkReal x835=((cj5)*(sj4));
IkReal x836=((IkReal(1.00000000000000))*(r02));
IkReal x837=((sj4)*(sj5));
IkReal x838=((cj4)*(r01)*(r10));
IkReal x839=((IkReal(1.00000000000000))*(cj4)*(r00)*(r11));
gconst113=IKsign(((((IkReal(-1.00000000000000))*(x834)*(x839)))+(((x833)*(x838)))+(((IkReal(-1.00000000000000))*(r10)*(x836)*(x837)))+(((IkReal(-1.00000000000000))*(r11)*(x835)*(x836)))+(((x834)*(x838)))+(((IkReal(-1.00000000000000))*(x833)*(x839)))+(((r00)*(r12)*(x837)))+(((r01)*(r12)*(x835)))));
IkReal x840=(sj5)*(sj5);
IkReal x841=(cj5)*(cj5);
IkReal x842=((cj5)*(sj4));
IkReal x843=((IkReal(1.00000000000000))*(r02));
IkReal x844=((sj4)*(sj5));
IkReal x845=((cj4)*(r01)*(r10));
IkReal x846=x839;
dummyeval[0]=((((x841)*(x845)))+(((r00)*(r12)*(x844)))+(((IkReal(-1.00000000000000))*(r11)*(x842)*(x843)))+(((IkReal(-1.00000000000000))*(x841)*(x846)))+(((r01)*(r12)*(x842)))+(((IkReal(-1.00000000000000))*(r10)*(x843)*(x844)))+(((x840)*(x845)))+(((IkReal(-1.00000000000000))*(x840)*(x846))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst112;
IkReal x847=(cj5)*(cj5);
IkReal x848=(sj5)*(sj5);
IkReal x849=((IkReal(1.00000000000000))*(x848));
IkReal x850=((IkReal(2.00000000000000))*(cj5)*(sj5));
IkReal x851=((IkReal(1.00000000000000))*(x847));
gconst112=IKsign(((((IkReal(-1.00000000000000))*(x851)*((r11)*(r11))))+(((IkReal(-1.00000000000000))*(x849)*((r00)*(r00))))+(((IkReal(-1.00000000000000))*(x849)*((r10)*(r10))))+(((IkReal(-1.00000000000000))*(r10)*(r11)*(x850)))+(((IkReal(-1.00000000000000))*(r00)*(r01)*(x850)))+(((IkReal(-1.00000000000000))*(x851)*((r01)*(r01))))));
IkReal x852=(cj5)*(cj5);
IkReal x853=(sj5)*(sj5);
IkReal x854=((IkReal(1.00000000000000))*(x853));
IkReal x855=((IkReal(2.00000000000000))*(cj5)*(sj5));
IkReal x856=((IkReal(1.00000000000000))*(x852));
dummyeval[0]=((((IkReal(-1.00000000000000))*(r10)*(r11)*(x855)))+(((IkReal(-1.00000000000000))*(x854)*((r00)*(r00))))+(((IkReal(-1.00000000000000))*(x854)*((r10)*(r10))))+(((IkReal(-1.00000000000000))*(r00)*(r01)*(x855)))+(((IkReal(-1.00000000000000))*(x856)*((r11)*(r11))))+(((IkReal(-1.00000000000000))*(x856)*((r01)*(r01)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x857=((sj1)*(sj2));
IkReal x858=((IkReal(1.00000000000000))*(cj1)*(cj2)*(cj5));
IkReal x859=((IkReal(1.00000000000000))*(cj1)*(cj2)*(sj5));
if( IKabs(((gconst112)*(((((cj5)*(r11)*(x857)))+(((IkReal(-1.00000000000000))*(r11)*(x858)))+(((IkReal(-1.00000000000000))*(r10)*(x859)))+(((r10)*(sj5)*(x857))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst112)*(((((r00)*(sj5)*(x857)))+(((IkReal(-1.00000000000000))*(r01)*(x858)))+(((cj5)*(r01)*(x857)))+(((IkReal(-1.00000000000000))*(r00)*(x859))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst112)*(((((cj5)*(r11)*(x857)))+(((IkReal(-1.00000000000000))*(r11)*(x858)))+(((IkReal(-1.00000000000000))*(r10)*(x859)))+(((r10)*(sj5)*(x857)))))), ((gconst112)*(((((r00)*(sj5)*(x857)))+(((IkReal(-1.00000000000000))*(r01)*(x858)))+(((cj5)*(r01)*(x857)))+(((IkReal(-1.00000000000000))*(r00)*(x859)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[6];
IkReal x860=IKsin(j0);
IkReal x861=IKcos(j0);
IkReal x862=((IkReal(1.00000000000000))*(r10));
IkReal x863=((IkReal(1.00000000000000))*(sj4));
IkReal x864=((cj5)*(r01));
IkReal x865=((cj5)*(r00));
IkReal x866=((cj4)*(r01));
IkReal x867=((IkReal(1.00000000000000))*(cj4));
IkReal x868=((cj4)*(r11));
IkReal x869=((sj5)*(x860));
IkReal x870=((r11)*(x863));
IkReal x871=((sj5)*(x861));
IkReal x872=((r02)*(x861));
IkReal x873=((r12)*(x861));
IkReal x874=((IkReal(1.00000000000000))*(x861));
IkReal x875=((cj4)*(x860));
IkReal x876=((cj5)*(x860));
IkReal x877=((cj5)*(sj4)*(x861));
evalcond[0]=((((IkReal(-1.00000000000000))*(cj5)*(r11)*(x874)))+(((r00)*(x869)))+(((IkReal(-1.00000000000000))*(x862)*(x871)))+(((x860)*(x864))));
evalcond[1]=((((IkReal(-1.00000000000000))*(sj1)*(sj2)))+(((IkReal(-1.00000000000000))*(r00)*(x871)))+(((IkReal(-1.00000000000000))*(r11)*(x876)))+(((cj1)*(cj2)))+(((IkReal(-1.00000000000000))*(x864)*(x874)))+(((IkReal(-1.00000000000000))*(x862)*(x869))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x860)*(x863)*(x865)))+(((IkReal(-1.00000000000000))*(x870)*(x871)))+(((r10)*(x877)))+(((r01)*(sj4)*(x869)))+(((IkReal(-1.00000000000000))*(x867)*(x873)))+(((r02)*(x875))));
evalcond[3]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(x866)*(x869)))+(((x868)*(x871)))+(((r02)*(sj4)*(x860)))+(((IkReal(-1.00000000000000))*(x863)*(x873)))+(((x865)*(x875)))+(((IkReal(-1.00000000000000))*(cj4)*(cj5)*(x861)*(x862))));
evalcond[4]=((((cj1)*(sj2)))+(((IkReal(-1.00000000000000))*(x869)*(x870)))+(((IkReal(-1.00000000000000))*(r01)*(x863)*(x871)))+(((r10)*(sj4)*(x876)))+(((IkReal(-1.00000000000000))*(x867)*(x872)))+(((sj4)*(x861)*(x865)))+(((cj2)*(sj1)))+(((IkReal(-1.00000000000000))*(r12)*(x860)*(x867))));
evalcond[5]=((((IkReal(-1.00000000000000))*(cj5)*(x862)*(x875)))+(((x866)*(x871)))+(((x868)*(x869)))+(((IkReal(-1.00000000000000))*(x861)*(x865)*(x867)))+(((IkReal(-1.00000000000000))*(x863)*(x872)))+(((IkReal(-1.00000000000000))*(r12)*(x860)*(x863))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x878=((IkReal(1.00000000000000))*(cj5));
IkReal x879=((IkReal(1.00000000000000))*(sj5));
if( IKabs(((gconst113)*(((((IkReal(-1.00000000000000))*(r10)*(x879)))+(((IkReal(-1.00000000000000))*(r11)*(x878))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst113)*(((((IkReal(-1.00000000000000))*(r00)*(x879)))+(((IkReal(-1.00000000000000))*(r01)*(x878))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst113)*(((((IkReal(-1.00000000000000))*(r10)*(x879)))+(((IkReal(-1.00000000000000))*(r11)*(x878)))))), ((gconst113)*(((((IkReal(-1.00000000000000))*(r00)*(x879)))+(((IkReal(-1.00000000000000))*(r01)*(x878)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[6];
IkReal x880=IKsin(j0);
IkReal x881=IKcos(j0);
IkReal x882=((IkReal(1.00000000000000))*(r10));
IkReal x883=((IkReal(1.00000000000000))*(sj4));
IkReal x884=((cj5)*(r01));
IkReal x885=((cj5)*(r00));
IkReal x886=((cj4)*(r01));
IkReal x887=((IkReal(1.00000000000000))*(cj4));
IkReal x888=((cj4)*(r11));
IkReal x889=((sj5)*(x880));
IkReal x890=((r11)*(x883));
IkReal x891=((sj5)*(x881));
IkReal x892=((r02)*(x881));
IkReal x893=((r12)*(x881));
IkReal x894=((IkReal(1.00000000000000))*(x881));
IkReal x895=((cj4)*(x880));
IkReal x896=((cj5)*(x880));
IkReal x897=((cj5)*(sj4)*(x881));
evalcond[0]=((((r00)*(x889)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x894)))+(((IkReal(-1.00000000000000))*(x882)*(x891)))+(((x880)*(x884))));
evalcond[1]=((((IkReal(-1.00000000000000))*(sj1)*(sj2)))+(((IkReal(-1.00000000000000))*(x884)*(x894)))+(((IkReal(-1.00000000000000))*(r11)*(x896)))+(((IkReal(-1.00000000000000))*(x882)*(x889)))+(((IkReal(-1.00000000000000))*(r00)*(x891)))+(((cj1)*(cj2))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x887)*(x893)))+(((IkReal(-1.00000000000000))*(x880)*(x883)*(x885)))+(((r02)*(x895)))+(((r01)*(sj4)*(x889)))+(((IkReal(-1.00000000000000))*(x890)*(x891)))+(((r10)*(x897))));
evalcond[3]=((IkReal(-1.00000000000000))+(((x888)*(x891)))+(((IkReal(-1.00000000000000))*(x886)*(x889)))+(((IkReal(-1.00000000000000))*(x883)*(x893)))+(((r02)*(sj4)*(x880)))+(((x885)*(x895)))+(((IkReal(-1.00000000000000))*(cj4)*(cj5)*(x881)*(x882))));
evalcond[4]=((((cj1)*(sj2)))+(((sj4)*(x881)*(x885)))+(((IkReal(-1.00000000000000))*(x887)*(x892)))+(((IkReal(-1.00000000000000))*(r12)*(x880)*(x887)))+(((r10)*(sj4)*(x896)))+(((IkReal(-1.00000000000000))*(x889)*(x890)))+(((IkReal(-1.00000000000000))*(r01)*(x883)*(x891)))+(((cj2)*(sj1))));
evalcond[5]=((((IkReal(-1.00000000000000))*(cj5)*(x882)*(x895)))+(((x888)*(x889)))+(((x886)*(x891)))+(((IkReal(-1.00000000000000))*(x881)*(x885)*(x887)))+(((IkReal(-1.00000000000000))*(r12)*(x880)*(x883)))+(((IkReal(-1.00000000000000))*(x883)*(x892))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
IkReal x898=((cj5)*(npx));
IkReal x899=((npy)*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(3.14159265358979))+(j3)), IkReal(6.28318530717959))));
evalcond[1]=((IkReal(0.0950000000000000))+(((cj5)*(npy)))+(((npx)*(sj5))));
evalcond[2]=((IkReal(-0.350000000000000))+(((IkReal(-1.00000000000000))*(sj4)*(x898)))+(((IkReal(-0.350000000000000))*(cj2)))+(((cj4)*(npz)))+(((sj4)*(x899))));
evalcond[3]=((((IkReal(0.350000000000000))*(sj2)))+(((IkReal(-1.00000000000000))*(cj4)*(x899)))+(((cj4)*(x898)))+(((npz)*(sj4))));
evalcond[4]=((((r20)*(sj5)))+(((cj5)*(r21))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst114;
IkReal x900=(sj5)*(sj5);
IkReal x901=(cj5)*(cj5);
IkReal x902=((IkReal(2.00000000000000))*(cj5)*(sj5));
gconst114=IKsign(((((r00)*(r01)*(x902)))+(((x901)*((r11)*(r11))))+(((x900)*((r00)*(r00))))+(((r10)*(r11)*(x902)))+(((x901)*((r01)*(r01))))+(((x900)*((r10)*(r10))))));
IkReal x903=(sj5)*(sj5);
IkReal x904=(cj5)*(cj5);
IkReal x905=((IkReal(2.00000000000000))*(cj5)*(sj5));
dummyeval[0]=((((x904)*((r11)*(r11))))+(((r10)*(r11)*(x905)))+(((x903)*((r10)*(r10))))+(((r00)*(r01)*(x905)))+(((x904)*((r01)*(r01))))+(((x903)*((r00)*(r00)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst116;
gconst116=IKsign(((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2))))));
dummyeval[0]=((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst115;
IkReal x906=(cj5)*(cj5);
IkReal x907=(sj5)*(sj5);
IkReal x908=((IkReal(1.00000000000000))*(r10));
IkReal x909=((cj4)*(sj5));
IkReal x910=((r00)*(r11));
IkReal x911=((cj4)*(cj5));
IkReal x912=((sj4)*(x906));
IkReal x913=((sj4)*(x907));
gconst115=IKsign(((((IkReal(-1.00000000000000))*(r01)*(x908)*(x913)))+(((IkReal(-1.00000000000000))*(r01)*(x908)*(x912)))+(((x910)*(x913)))+(((IkReal(-1.00000000000000))*(r02)*(x908)*(x909)))+(((x910)*(x912)))+(((IkReal(-1.00000000000000))*(r02)*(r11)*(x911)))+(((r00)*(r12)*(x909)))+(((r01)*(r12)*(x911)))));
IkReal x914=(cj5)*(cj5);
IkReal x915=(sj5)*(sj5);
IkReal x916=((IkReal(1.00000000000000))*(r10));
IkReal x917=((cj4)*(sj5));
IkReal x918=((r00)*(r11));
IkReal x919=((cj4)*(cj5));
IkReal x920=((sj4)*(x914));
IkReal x921=((sj4)*(x915));
dummyeval[0]=((((x918)*(x921)))+(((IkReal(-1.00000000000000))*(r01)*(x916)*(x920)))+(((IkReal(-1.00000000000000))*(r02)*(x916)*(x917)))+(((r00)*(r12)*(x917)))+(((r01)*(r12)*(x919)))+(((IkReal(-1.00000000000000))*(r01)*(x916)*(x921)))+(((IkReal(-1.00000000000000))*(r02)*(r11)*(x919)))+(((x918)*(x920))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x922=((cj5)*(sj4));
IkReal x923=((IkReal(1.00000000000000))*(cj4));
IkReal x924=((IkReal(1.00000000000000))*(sj4)*(sj5));
if( IKabs(((gconst115)*(((((IkReal(-1.00000000000000))*(r11)*(x924)))+(((IkReal(-1.00000000000000))*(r12)*(x923)))+(((r10)*(x922))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst115)*(((((IkReal(-1.00000000000000))*(r01)*(x924)))+(((r00)*(x922)))+(((IkReal(-1.00000000000000))*(r02)*(x923))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst115)*(((((IkReal(-1.00000000000000))*(r11)*(x924)))+(((IkReal(-1.00000000000000))*(r12)*(x923)))+(((r10)*(x922)))))), ((gconst115)*(((((IkReal(-1.00000000000000))*(r01)*(x924)))+(((r00)*(x922)))+(((IkReal(-1.00000000000000))*(r02)*(x923)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[4];
IkReal x925=IKsin(j0);
IkReal x926=IKcos(j0);
IkReal x927=((IkReal(1.00000000000000))*(cj5));
IkReal x928=((r01)*(sj5));
IkReal x929=((IkReal(1.00000000000000))*(r12));
IkReal x930=((IkReal(1.00000000000000))*(r10));
IkReal x931=((r11)*(sj5));
IkReal x932=((cj4)*(x925));
IkReal x933=((sj4)*(x925));
IkReal x934=((sj4)*(x926));
IkReal x935=((sj5)*(x925));
IkReal x936=((cj4)*(x926));
IkReal x937=((sj5)*(x926));
evalcond[0]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x930)*(x937)))+(((r00)*(x935)))+(((IkReal(-1.00000000000000))*(r11)*(x926)*(x927)))+(((cj5)*(r01)*(x925))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r01)*(x926)*(x927)))+(((IkReal(-1.00000000000000))*(r00)*(x937)))+(((IkReal(-1.00000000000000))*(r11)*(x925)*(x927)))+(((IkReal(-1.00000000000000))*(x930)*(x935))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x931)*(x934)))+(((x928)*(x933)))+(((IkReal(-1.00000000000000))*(r00)*(x927)*(x933)))+(((IkReal(-1.00000000000000))*(x929)*(x936)))+(((r02)*(x932)))+(((cj5)*(r10)*(x934))));
evalcond[3]=((((x931)*(x936)))+(((IkReal(-1.00000000000000))*(r10)*(x927)*(x936)))+(((r02)*(x933)))+(((IkReal(-1.00000000000000))*(x928)*(x932)))+(((IkReal(-1.00000000000000))*(x929)*(x934)))+(((cj5)*(r00)*(x932))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst117;
gconst117=IKsign(((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2))))));
dummyeval[0]=((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst118;
gconst118=IKsign(((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2))))));
dummyeval[0]=((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x938=((cj4)*(r22));
IkReal x939=((r11)*(sj0));
IkReal x940=((IkReal(1.00000000000000))*(cj2));
IkReal x941=((sj2)*(sj4));
IkReal x942=((IkReal(1.00000000000000))*(sj2));
IkReal x943=((cj2)*(sj4));
IkReal x944=((cj0)*(r01));
IkReal x945=((cj5)*(r20));
IkReal x946=((IkReal(1.00000000000000))*(sj4)*(sj5));
IkReal x947=((cj0)*(cj4)*(r02));
IkReal x948=((cj4)*(r12)*(sj0));
IkReal x949=((cj5)*(r10)*(sj0));
IkReal x950=((cj0)*(cj5)*(r00));
if( IKabs(((gconst118)*(((((r21)*(sj5)*(x941)))+(((IkReal(-1.00000000000000))*(x941)*(x945)))+(((IkReal(-1.00000000000000))*(x940)*(x948)))+(((IkReal(-1.00000000000000))*(x940)*(x947)))+(((x943)*(x949)))+(((sj2)*(x938)))+(((IkReal(-1.00000000000000))*(sj4)*(sj5)*(x940)*(x944)))+(((IkReal(-1.00000000000000))*(sj4)*(sj5)*(x939)*(x940)))+(((x943)*(x950))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst118)*(((((IkReal(-1.00000000000000))*(sj5)*(x939)*(x941)))+(((IkReal(-1.00000000000000))*(sj5)*(x941)*(x944)))+(((x941)*(x949)))+(((IkReal(-1.00000000000000))*(x942)*(x947)))+(((x943)*(x945)))+(((IkReal(-1.00000000000000))*(x942)*(x948)))+(((IkReal(-1.00000000000000))*(x938)*(x940)))+(((x941)*(x950)))+(((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj5)*(x940))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst118)*(((((r21)*(sj5)*(x941)))+(((IkReal(-1.00000000000000))*(x941)*(x945)))+(((IkReal(-1.00000000000000))*(x940)*(x948)))+(((IkReal(-1.00000000000000))*(x940)*(x947)))+(((x943)*(x949)))+(((sj2)*(x938)))+(((IkReal(-1.00000000000000))*(sj4)*(sj5)*(x940)*(x944)))+(((IkReal(-1.00000000000000))*(sj4)*(sj5)*(x939)*(x940)))+(((x943)*(x950)))))), ((gconst118)*(((((IkReal(-1.00000000000000))*(sj5)*(x939)*(x941)))+(((IkReal(-1.00000000000000))*(sj5)*(x941)*(x944)))+(((x941)*(x949)))+(((IkReal(-1.00000000000000))*(x942)*(x947)))+(((x943)*(x945)))+(((IkReal(-1.00000000000000))*(x942)*(x948)))+(((IkReal(-1.00000000000000))*(x938)*(x940)))+(((x941)*(x950)))+(((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj5)*(x940)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x951=IKcos(j1);
IkReal x952=IKsin(j1);
IkReal x953=((IkReal(1.00000000000000))*(sj4));
IkReal x954=((cj5)*(r00));
IkReal x955=((cj5)*(r20));
IkReal x956=((r12)*(sj0));
IkReal x957=((r21)*(sj5));
IkReal x958=((IkReal(1.00000000000000))*(cj4));
IkReal x959=((sj2)*(x951));
IkReal x960=((cj2)*(x952));
IkReal x961=((cj2)*(x951));
IkReal x962=((r11)*(sj0)*(sj5));
IkReal x963=((cj0)*(x958));
IkReal x964=((cj0)*(r01)*(sj5));
IkReal x965=((cj5)*(r10)*(sj0));
IkReal x966=((sj2)*(x952));
IkReal x967=((x959)+(x960));
evalcond[0]=((((IkReal(-1.00000000000000))*(x961)))+(((cj4)*(r22)))+(((sj4)*(x957)))+(x966)+(((IkReal(-1.00000000000000))*(x953)*(x955))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x957)*(x958)))+(((r22)*(sj4)))+(((cj4)*(x955)))+(x967));
evalcond[2]=((((IkReal(-1.00000000000000))*(x953)*(x962)))+(((IkReal(-1.00000000000000))*(x953)*(x964)))+(((IkReal(-1.00000000000000))*(x956)*(x958)))+(((cj0)*(sj4)*(x954)))+(x967)+(((sj4)*(x965)))+(((IkReal(-1.00000000000000))*(r02)*(x963))));
evalcond[3]=((((cj4)*(x962)))+(((IkReal(-1.00000000000000))*(x958)*(x965)))+(((IkReal(-1.00000000000000))*(x966)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x953)))+(((IkReal(-1.00000000000000))*(x953)*(x956)))+(((IkReal(-1.00000000000000))*(x954)*(x963)))+(x961)+(((cj4)*(x964))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x968=((cj4)*(r22));
IkReal x969=((cj2)*(sj4));
IkReal x970=((sj2)*(sj4));
IkReal x971=((r21)*(sj5));
IkReal x972=((cj5)*(r20));
IkReal x973=((cj4)*(sj2));
IkReal x974=((IkReal(1.00000000000000))*(cj2)*(x971));
if( IKabs(((gconst117)*(((((sj2)*(x968)))+(((IkReal(-1.00000000000000))*(x970)*(x972)))+(((cj2)*(cj4)*(x972)))+(((r22)*(x969)))+(((IkReal(-1.00000000000000))*(cj4)*(x974)))+(((x970)*(x971))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst117)*(((((IkReal(-1.00000000000000))*(cj2)*(x968)))+(((r22)*(x970)))+(((x972)*(x973)))+(((IkReal(-1.00000000000000))*(x971)*(x973)))+(((x969)*(x972)))+(((IkReal(-1.00000000000000))*(x969)*(x971))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst117)*(((((sj2)*(x968)))+(((IkReal(-1.00000000000000))*(x970)*(x972)))+(((cj2)*(cj4)*(x972)))+(((r22)*(x969)))+(((IkReal(-1.00000000000000))*(cj4)*(x974)))+(((x970)*(x971)))))), ((gconst117)*(((((IkReal(-1.00000000000000))*(cj2)*(x968)))+(((r22)*(x970)))+(((x972)*(x973)))+(((IkReal(-1.00000000000000))*(x971)*(x973)))+(((x969)*(x972)))+(((IkReal(-1.00000000000000))*(x969)*(x971)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x975=IKcos(j1);
IkReal x976=IKsin(j1);
IkReal x977=((IkReal(1.00000000000000))*(sj4));
IkReal x978=((cj5)*(r00));
IkReal x979=((cj5)*(r20));
IkReal x980=((r12)*(sj0));
IkReal x981=((r21)*(sj5));
IkReal x982=((IkReal(1.00000000000000))*(cj4));
IkReal x983=((sj2)*(x975));
IkReal x984=((cj2)*(x976));
IkReal x985=((cj2)*(x975));
IkReal x986=((r11)*(sj0)*(sj5));
IkReal x987=((cj0)*(x982));
IkReal x988=((cj0)*(r01)*(sj5));
IkReal x989=((cj5)*(r10)*(sj0));
IkReal x990=((sj2)*(x976));
IkReal x991=((x984)+(x983));
evalcond[0]=((((sj4)*(x981)))+(((cj4)*(r22)))+(((IkReal(-1.00000000000000))*(x985)))+(((IkReal(-1.00000000000000))*(x977)*(x979)))+(x990));
evalcond[1]=((((cj4)*(x979)))+(((r22)*(sj4)))+(((IkReal(-1.00000000000000))*(x981)*(x982)))+(x991));
evalcond[2]=((((IkReal(-1.00000000000000))*(r02)*(x987)))+(((IkReal(-1.00000000000000))*(x977)*(x986)))+(((sj4)*(x989)))+(((cj0)*(sj4)*(x978)))+(((IkReal(-1.00000000000000))*(x980)*(x982)))+(((IkReal(-1.00000000000000))*(x977)*(x988)))+(x991));
evalcond[3]=((((cj4)*(x986)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x977)))+(((IkReal(-1.00000000000000))*(x978)*(x987)))+(x985)+(((IkReal(-1.00000000000000))*(x977)*(x980)))+(((IkReal(-1.00000000000000))*(x982)*(x989)))+(((IkReal(-1.00000000000000))*(x990)))+(((cj4)*(x988))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x992=((cj4)*(r22));
IkReal x993=((cj2)*(sj4));
IkReal x994=((sj2)*(sj4));
IkReal x995=((r21)*(sj5));
IkReal x996=((cj5)*(r20));
IkReal x997=((cj4)*(sj2));
IkReal x998=((IkReal(1.00000000000000))*(cj2)*(x995));
if( IKabs(((gconst116)*(((((cj2)*(cj4)*(x996)))+(((x994)*(x995)))+(((r22)*(x993)))+(((sj2)*(x992)))+(((IkReal(-1.00000000000000))*(cj4)*(x998)))+(((IkReal(-1.00000000000000))*(x994)*(x996))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst116)*(((((r22)*(x994)))+(((IkReal(-1.00000000000000))*(x993)*(x995)))+(((IkReal(-1.00000000000000))*(x995)*(x997)))+(((IkReal(-1.00000000000000))*(cj2)*(x992)))+(((x996)*(x997)))+(((x993)*(x996))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst116)*(((((cj2)*(cj4)*(x996)))+(((x994)*(x995)))+(((r22)*(x993)))+(((sj2)*(x992)))+(((IkReal(-1.00000000000000))*(cj4)*(x998)))+(((IkReal(-1.00000000000000))*(x994)*(x996)))))), ((gconst116)*(((((r22)*(x994)))+(((IkReal(-1.00000000000000))*(x993)*(x995)))+(((IkReal(-1.00000000000000))*(x995)*(x997)))+(((IkReal(-1.00000000000000))*(cj2)*(x992)))+(((x996)*(x997)))+(((x993)*(x996)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[2];
IkReal x999=IKcos(j1);
IkReal x1000=IKsin(j1);
IkReal x1001=((cj5)*(r20));
IkReal x1002=((r21)*(sj5));
evalcond[0]=((((sj4)*(x1002)))+(((cj4)*(r22)))+(((sj2)*(x1000)))+(((IkReal(-1.00000000000000))*(cj2)*(x999)))+(((IkReal(-1.00000000000000))*(sj4)*(x1001))));
evalcond[1]=((((cj4)*(x1001)))+(((r22)*(sj4)))+(((cj2)*(x1000)))+(((sj2)*(x999)))+(((IkReal(-1.00000000000000))*(cj4)*(x1002))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst119;
IkReal x1003=(sj5)*(sj5);
IkReal x1004=(cj5)*(cj5);
IkReal x1005=((IkReal(2.00000000000000))*(cj5)*(sj5));
gconst119=IKsign(((((x1003)*((r10)*(r10))))+(((x1004)*((r11)*(r11))))+(((x1003)*((r00)*(r00))))+(((x1004)*((r01)*(r01))))+(((r00)*(r01)*(x1005)))+(((r10)*(r11)*(x1005)))));
IkReal x1006=(sj5)*(sj5);
IkReal x1007=(cj5)*(cj5);
IkReal x1008=((IkReal(2.00000000000000))*(cj5)*(sj5));
dummyeval[0]=((((x1006)*((r10)*(r10))))+(((x1006)*((r00)*(r00))))+(((x1007)*((r11)*(r11))))+(((r10)*(r11)*(x1008)))+(((r00)*(r01)*(x1008)))+(((x1007)*((r01)*(r01)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst120;
IkReal x1009=(cj5)*(cj5);
IkReal x1010=(sj5)*(sj5);
IkReal x1011=((IkReal(1.00000000000000))*(r10));
IkReal x1012=((cj4)*(sj5));
IkReal x1013=((r00)*(r11));
IkReal x1014=((cj4)*(cj5));
IkReal x1015=((sj4)*(x1009));
IkReal x1016=((sj4)*(x1010));
gconst120=IKsign(((((x1013)*(x1015)))+(((x1013)*(x1016)))+(((r01)*(r12)*(x1014)))+(((r00)*(r12)*(x1012)))+(((IkReal(-1.00000000000000))*(r02)*(r11)*(x1014)))+(((IkReal(-1.00000000000000))*(r01)*(x1011)*(x1016)))+(((IkReal(-1.00000000000000))*(r01)*(x1011)*(x1015)))+(((IkReal(-1.00000000000000))*(r02)*(x1011)*(x1012)))));
IkReal x1017=(cj5)*(cj5);
IkReal x1018=(sj5)*(sj5);
IkReal x1019=((IkReal(1.00000000000000))*(r10));
IkReal x1020=((cj4)*(sj5));
IkReal x1021=((r00)*(r11));
IkReal x1022=((cj4)*(cj5));
IkReal x1023=((sj4)*(x1017));
IkReal x1024=((sj4)*(x1018));
dummyeval[0]=((((x1021)*(x1024)))+(((IkReal(-1.00000000000000))*(r01)*(x1019)*(x1024)))+(((r00)*(r12)*(x1020)))+(((IkReal(-1.00000000000000))*(r02)*(x1019)*(x1020)))+(((r01)*(r12)*(x1022)))+(((x1021)*(x1023)))+(((IkReal(-1.00000000000000))*(r02)*(r11)*(x1022)))+(((IkReal(-1.00000000000000))*(r01)*(x1019)*(x1023))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x1025=((cj5)*(sj4));
IkReal x1026=((IkReal(1.00000000000000))*(cj4));
IkReal x1027=((IkReal(1.00000000000000))*(sj4)*(sj5));
if( IKabs(((gconst120)*(((((IkReal(-1.00000000000000))*(r11)*(x1027)))+(((IkReal(-1.00000000000000))*(r12)*(x1026)))+(((r10)*(x1025))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst120)*(((((IkReal(-1.00000000000000))*(r01)*(x1027)))+(((IkReal(-1.00000000000000))*(r02)*(x1026)))+(((r00)*(x1025))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst120)*(((((IkReal(-1.00000000000000))*(r11)*(x1027)))+(((IkReal(-1.00000000000000))*(r12)*(x1026)))+(((r10)*(x1025)))))), ((gconst120)*(((((IkReal(-1.00000000000000))*(r01)*(x1027)))+(((IkReal(-1.00000000000000))*(r02)*(x1026)))+(((r00)*(x1025)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[6];
IkReal x1028=IKsin(j0);
IkReal x1029=IKcos(j0);
IkReal x1030=((IkReal(1.00000000000000))*(r10));
IkReal x1031=((IkReal(1.00000000000000))*(sj4));
IkReal x1032=((cj5)*(r01));
IkReal x1033=((cj5)*(r00));
IkReal x1034=((cj4)*(r01));
IkReal x1035=((IkReal(1.00000000000000))*(cj4));
IkReal x1036=((cj4)*(r11));
IkReal x1037=((sj5)*(x1028));
IkReal x1038=((r11)*(x1031));
IkReal x1039=((sj5)*(x1029));
IkReal x1040=((r02)*(x1029));
IkReal x1041=((r12)*(x1029));
IkReal x1042=((IkReal(1.00000000000000))*(x1029));
IkReal x1043=((cj4)*(x1028));
IkReal x1044=((cj5)*(x1028));
IkReal x1045=((cj5)*(sj4)*(x1029));
evalcond[0]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x1030)*(x1039)))+(((r00)*(x1037)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x1042)))+(((x1028)*(x1032))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r11)*(x1044)))+(((IkReal(-1.00000000000000))*(x1032)*(x1042)))+(((IkReal(-1.00000000000000))*(r00)*(x1039)))+(((IkReal(-1.00000000000000))*(x1030)*(x1037))));
evalcond[2]=((((r01)*(sj4)*(x1037)))+(((r02)*(x1043)))+(((IkReal(-1.00000000000000))*(x1028)*(x1031)*(x1033)))+(((IkReal(-1.00000000000000))*(x1035)*(x1041)))+(((IkReal(-1.00000000000000))*(x1038)*(x1039)))+(((r10)*(x1045))));
evalcond[3]=((((x1036)*(x1039)))+(((IkReal(-1.00000000000000))*(cj4)*(cj5)*(x1029)*(x1030)))+(((IkReal(-1.00000000000000))*(x1031)*(x1041)))+(((x1033)*(x1043)))+(((r02)*(sj4)*(x1028)))+(((IkReal(-1.00000000000000))*(x1034)*(x1037))));
evalcond[4]=((((cj1)*(sj2)))+(((IkReal(-1.00000000000000))*(x1035)*(x1040)))+(((sj4)*(x1029)*(x1033)))+(((IkReal(-1.00000000000000))*(x1037)*(x1038)))+(((IkReal(-1.00000000000000))*(r01)*(x1031)*(x1039)))+(((IkReal(-1.00000000000000))*(r12)*(x1028)*(x1035)))+(((cj2)*(sj1)))+(((r10)*(sj4)*(x1044))));
evalcond[5]=((((IkReal(-1.00000000000000))*(sj1)*(sj2)))+(((IkReal(-1.00000000000000))*(x1029)*(x1033)*(x1035)))+(((x1034)*(x1039)))+(((IkReal(-1.00000000000000))*(r12)*(x1028)*(x1031)))+(((IkReal(-1.00000000000000))*(cj5)*(x1030)*(x1043)))+(((IkReal(-1.00000000000000))*(x1031)*(x1040)))+(((cj1)*(cj2)))+(((x1036)*(x1037))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
if( IKabs(((gconst119)*(((((IkReal(-1.00000000000000))*(r00)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r01))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst119)*(((((cj5)*(r11)))+(((r10)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst119)*(((((IkReal(-1.00000000000000))*(r00)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)))))), ((gconst119)*(((((cj5)*(r11)))+(((r10)*(sj5)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[6];
IkReal x1046=IKsin(j0);
IkReal x1047=IKcos(j0);
IkReal x1048=((IkReal(1.00000000000000))*(r10));
IkReal x1049=((IkReal(1.00000000000000))*(sj4));
IkReal x1050=((cj5)*(r01));
IkReal x1051=((cj5)*(r00));
IkReal x1052=((cj4)*(r01));
IkReal x1053=((IkReal(1.00000000000000))*(cj4));
IkReal x1054=((cj4)*(r11));
IkReal x1055=((sj5)*(x1046));
IkReal x1056=((r11)*(x1049));
IkReal x1057=((sj5)*(x1047));
IkReal x1058=((r02)*(x1047));
IkReal x1059=((r12)*(x1047));
IkReal x1060=((IkReal(1.00000000000000))*(x1047));
IkReal x1061=((cj4)*(x1046));
IkReal x1062=((cj5)*(x1046));
IkReal x1063=((cj5)*(sj4)*(x1047));
evalcond[0]=((IkReal(1.00000000000000))+(((x1046)*(x1050)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x1060)))+(((r00)*(x1055)))+(((IkReal(-1.00000000000000))*(x1048)*(x1057))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1050)*(x1060)))+(((IkReal(-1.00000000000000))*(r00)*(x1057)))+(((IkReal(-1.00000000000000))*(x1048)*(x1055)))+(((IkReal(-1.00000000000000))*(r11)*(x1062))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x1046)*(x1049)*(x1051)))+(((IkReal(-1.00000000000000))*(x1056)*(x1057)))+(((IkReal(-1.00000000000000))*(x1053)*(x1059)))+(((r02)*(x1061)))+(((r10)*(x1063)))+(((r01)*(sj4)*(x1055))));
evalcond[3]=((((x1054)*(x1057)))+(((x1051)*(x1061)))+(((r02)*(sj4)*(x1046)))+(((IkReal(-1.00000000000000))*(x1052)*(x1055)))+(((IkReal(-1.00000000000000))*(x1049)*(x1059)))+(((IkReal(-1.00000000000000))*(cj4)*(cj5)*(x1047)*(x1048))));
evalcond[4]=((((cj1)*(sj2)))+(((IkReal(-1.00000000000000))*(r01)*(x1049)*(x1057)))+(((IkReal(-1.00000000000000))*(x1053)*(x1058)))+(((IkReal(-1.00000000000000))*(r12)*(x1046)*(x1053)))+(((IkReal(-1.00000000000000))*(x1055)*(x1056)))+(((sj4)*(x1047)*(x1051)))+(((r10)*(sj4)*(x1062)))+(((cj2)*(sj1))));
evalcond[5]=((((IkReal(-1.00000000000000))*(sj1)*(sj2)))+(((IkReal(-1.00000000000000))*(x1049)*(x1058)))+(((IkReal(-1.00000000000000))*(cj5)*(x1048)*(x1061)))+(((IkReal(-1.00000000000000))*(r12)*(x1046)*(x1049)))+(((IkReal(-1.00000000000000))*(x1047)*(x1051)*(x1053)))+(((cj1)*(cj2)))+(((x1054)*(x1055)))+(((x1052)*(x1057))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
if( IKabs(((gconst114)*(((((IkReal(-1.00000000000000))*(r00)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r01))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst114)*(((((cj5)*(r11)))+(((r10)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst114)*(((((IkReal(-1.00000000000000))*(r00)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)))))), ((gconst114)*(((((cj5)*(r11)))+(((r10)*(sj5)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[4];
IkReal x1064=IKsin(j0);
IkReal x1065=IKcos(j0);
IkReal x1066=((IkReal(1.00000000000000))*(cj5));
IkReal x1067=((r01)*(sj5));
IkReal x1068=((IkReal(1.00000000000000))*(r12));
IkReal x1069=((IkReal(1.00000000000000))*(r10));
IkReal x1070=((r11)*(sj5));
IkReal x1071=((cj4)*(x1064));
IkReal x1072=((sj4)*(x1064));
IkReal x1073=((sj4)*(x1065));
IkReal x1074=((sj5)*(x1064));
IkReal x1075=((cj4)*(x1065));
IkReal x1076=((sj5)*(x1065));
evalcond[0]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x1069)*(x1076)))+(((IkReal(-1.00000000000000))*(r11)*(x1065)*(x1066)))+(((cj5)*(r01)*(x1064)))+(((r00)*(x1074))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r11)*(x1064)*(x1066)))+(((IkReal(-1.00000000000000))*(r00)*(x1076)))+(((IkReal(-1.00000000000000))*(x1069)*(x1074)))+(((IkReal(-1.00000000000000))*(r01)*(x1065)*(x1066))));
evalcond[2]=((((r02)*(x1071)))+(((IkReal(-1.00000000000000))*(x1068)*(x1075)))+(((x1067)*(x1072)))+(((IkReal(-1.00000000000000))*(x1070)*(x1073)))+(((cj5)*(r10)*(x1073)))+(((IkReal(-1.00000000000000))*(r00)*(x1066)*(x1072))));
evalcond[3]=((((r02)*(x1072)))+(((x1070)*(x1075)))+(((cj5)*(r00)*(x1071)))+(((IkReal(-1.00000000000000))*(r10)*(x1066)*(x1075)))+(((IkReal(-1.00000000000000))*(x1067)*(x1071)))+(((IkReal(-1.00000000000000))*(x1068)*(x1073))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst117;
gconst117=IKsign(((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2))))));
dummyeval[0]=((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst118;
gconst118=IKsign(((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2))))));
dummyeval[0]=((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x1077=((cj4)*(r22));
IkReal x1078=((r11)*(sj0));
IkReal x1079=((IkReal(1.00000000000000))*(cj2));
IkReal x1080=((sj2)*(sj4));
IkReal x1081=((IkReal(1.00000000000000))*(sj2));
IkReal x1082=((cj2)*(sj4));
IkReal x1083=((cj0)*(r01));
IkReal x1084=((cj5)*(r20));
IkReal x1085=((IkReal(1.00000000000000))*(sj4)*(sj5));
IkReal x1086=((cj0)*(cj4)*(r02));
IkReal x1087=((cj4)*(r12)*(sj0));
IkReal x1088=((cj5)*(r10)*(sj0));
IkReal x1089=((cj0)*(cj5)*(r00));
if( IKabs(((gconst118)*(((((IkReal(-1.00000000000000))*(x1079)*(x1087)))+(((x1082)*(x1089)))+(((sj2)*(x1077)))+(((IkReal(-1.00000000000000))*(sj4)*(sj5)*(x1078)*(x1079)))+(((IkReal(-1.00000000000000))*(x1080)*(x1084)))+(((IkReal(-1.00000000000000))*(x1079)*(x1086)))+(((IkReal(-1.00000000000000))*(sj4)*(sj5)*(x1079)*(x1083)))+(((r21)*(sj5)*(x1080)))+(((x1082)*(x1088))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst118)*(((((IkReal(-1.00000000000000))*(sj5)*(x1080)*(x1083)))+(((IkReal(-1.00000000000000))*(x1081)*(x1087)))+(((IkReal(-1.00000000000000))*(sj5)*(x1078)*(x1080)))+(((x1082)*(x1084)))+(((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj5)*(x1079)))+(((IkReal(-1.00000000000000))*(x1077)*(x1079)))+(((IkReal(-1.00000000000000))*(x1081)*(x1086)))+(((x1080)*(x1088)))+(((x1080)*(x1089))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst118)*(((((IkReal(-1.00000000000000))*(x1079)*(x1087)))+(((x1082)*(x1089)))+(((sj2)*(x1077)))+(((IkReal(-1.00000000000000))*(sj4)*(sj5)*(x1078)*(x1079)))+(((IkReal(-1.00000000000000))*(x1080)*(x1084)))+(((IkReal(-1.00000000000000))*(x1079)*(x1086)))+(((IkReal(-1.00000000000000))*(sj4)*(sj5)*(x1079)*(x1083)))+(((r21)*(sj5)*(x1080)))+(((x1082)*(x1088)))))), ((gconst118)*(((((IkReal(-1.00000000000000))*(sj5)*(x1080)*(x1083)))+(((IkReal(-1.00000000000000))*(x1081)*(x1087)))+(((IkReal(-1.00000000000000))*(sj5)*(x1078)*(x1080)))+(((x1082)*(x1084)))+(((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj5)*(x1079)))+(((IkReal(-1.00000000000000))*(x1077)*(x1079)))+(((IkReal(-1.00000000000000))*(x1081)*(x1086)))+(((x1080)*(x1088)))+(((x1080)*(x1089)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x1090=IKcos(j1);
IkReal x1091=IKsin(j1);
IkReal x1092=((IkReal(1.00000000000000))*(sj4));
IkReal x1093=((cj5)*(r00));
IkReal x1094=((cj5)*(r20));
IkReal x1095=((r12)*(sj0));
IkReal x1096=((r21)*(sj5));
IkReal x1097=((IkReal(1.00000000000000))*(cj4));
IkReal x1098=((sj2)*(x1090));
IkReal x1099=((cj2)*(x1091));
IkReal x1100=((cj2)*(x1090));
IkReal x1101=((r11)*(sj0)*(sj5));
IkReal x1102=((cj0)*(x1097));
IkReal x1103=((cj0)*(r01)*(sj5));
IkReal x1104=((cj5)*(r10)*(sj0));
IkReal x1105=((sj2)*(x1091));
IkReal x1106=((x1098)+(x1099));
evalcond[0]=((x1105)+(((IkReal(-1.00000000000000))*(x1100)))+(((sj4)*(x1096)))+(((cj4)*(r22)))+(((IkReal(-1.00000000000000))*(x1092)*(x1094))));
evalcond[1]=((x1106)+(((r22)*(sj4)))+(((cj4)*(x1094)))+(((IkReal(-1.00000000000000))*(x1096)*(x1097))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x1095)*(x1097)))+(x1106)+(((sj4)*(x1104)))+(((IkReal(-1.00000000000000))*(x1092)*(x1101)))+(((IkReal(-1.00000000000000))*(x1092)*(x1103)))+(((cj0)*(sj4)*(x1093)))+(((IkReal(-1.00000000000000))*(r02)*(x1102))));
evalcond[3]=((((IkReal(-1.00000000000000))*(cj0)*(r02)*(x1092)))+(x1100)+(((cj4)*(x1101)))+(((IkReal(-1.00000000000000))*(x1093)*(x1102)))+(((IkReal(-1.00000000000000))*(x1092)*(x1095)))+(((IkReal(-1.00000000000000))*(x1097)*(x1104)))+(((cj4)*(x1103)))+(((IkReal(-1.00000000000000))*(x1105))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x1107=((cj4)*(r22));
IkReal x1108=((cj2)*(sj4));
IkReal x1109=((sj2)*(sj4));
IkReal x1110=((r21)*(sj5));
IkReal x1111=((cj5)*(r20));
IkReal x1112=((cj4)*(sj2));
IkReal x1113=((IkReal(1.00000000000000))*(cj2)*(x1110));
if( IKabs(((gconst117)*(((((cj2)*(cj4)*(x1111)))+(((IkReal(-1.00000000000000))*(x1109)*(x1111)))+(((IkReal(-1.00000000000000))*(cj4)*(x1113)))+(((sj2)*(x1107)))+(((r22)*(x1108)))+(((x1109)*(x1110))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst117)*(((((IkReal(-1.00000000000000))*(x1108)*(x1110)))+(((IkReal(-1.00000000000000))*(x1110)*(x1112)))+(((IkReal(-1.00000000000000))*(cj2)*(x1107)))+(((x1111)*(x1112)))+(((r22)*(x1109)))+(((x1108)*(x1111))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst117)*(((((cj2)*(cj4)*(x1111)))+(((IkReal(-1.00000000000000))*(x1109)*(x1111)))+(((IkReal(-1.00000000000000))*(cj4)*(x1113)))+(((sj2)*(x1107)))+(((r22)*(x1108)))+(((x1109)*(x1110)))))), ((gconst117)*(((((IkReal(-1.00000000000000))*(x1108)*(x1110)))+(((IkReal(-1.00000000000000))*(x1110)*(x1112)))+(((IkReal(-1.00000000000000))*(cj2)*(x1107)))+(((x1111)*(x1112)))+(((r22)*(x1109)))+(((x1108)*(x1111)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x1114=IKcos(j1);
IkReal x1115=IKsin(j1);
IkReal x1116=((IkReal(1.00000000000000))*(sj4));
IkReal x1117=((cj5)*(r00));
IkReal x1118=((cj5)*(r20));
IkReal x1119=((r12)*(sj0));
IkReal x1120=((r21)*(sj5));
IkReal x1121=((IkReal(1.00000000000000))*(cj4));
IkReal x1122=((sj2)*(x1114));
IkReal x1123=((cj2)*(x1115));
IkReal x1124=((cj2)*(x1114));
IkReal x1125=((r11)*(sj0)*(sj5));
IkReal x1126=((cj0)*(x1121));
IkReal x1127=((cj0)*(r01)*(sj5));
IkReal x1128=((cj5)*(r10)*(sj0));
IkReal x1129=((sj2)*(x1115));
IkReal x1130=((x1122)+(x1123));
evalcond[0]=((((IkReal(-1.00000000000000))*(x1116)*(x1118)))+(((cj4)*(r22)))+(x1129)+(((sj4)*(x1120)))+(((IkReal(-1.00000000000000))*(x1124))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1120)*(x1121)))+(x1130)+(((r22)*(sj4)))+(((cj4)*(x1118))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r02)*(x1126)))+(((IkReal(-1.00000000000000))*(x1119)*(x1121)))+(((cj0)*(sj4)*(x1117)))+(x1130)+(((IkReal(-1.00000000000000))*(x1116)*(x1127)))+(((sj4)*(x1128)))+(((IkReal(-1.00000000000000))*(x1116)*(x1125))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x1116)*(x1119)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x1116)))+(((cj4)*(x1125)))+(((cj4)*(x1127)))+(((IkReal(-1.00000000000000))*(x1117)*(x1126)))+(((IkReal(-1.00000000000000))*(x1129)))+(x1124)+(((IkReal(-1.00000000000000))*(x1121)*(x1128))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
IkReal x1131=((cj5)*(npx));
IkReal x1132=((npy)*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(j3, IkReal(6.28318530717959))));
evalcond[1]=((IkReal(0.0950000000000000))+(((cj5)*(npy)))+(((npx)*(sj5))));
evalcond[2]=((IkReal(-0.350000000000000))+(((sj4)*(x1132)))+(((IkReal(-0.350000000000000))*(cj2)))+(((cj4)*(npz)))+(((IkReal(-1.00000000000000))*(sj4)*(x1131))));
evalcond[3]=((((cj4)*(x1131)))+(((IkReal(-0.350000000000000))*(sj2)))+(((IkReal(-1.00000000000000))*(cj4)*(x1132)))+(((npz)*(sj4))));
evalcond[4]=((((r20)*(sj5)))+(((cj5)*(r21))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst121;
IkReal x1133=(cj5)*(cj5);
IkReal x1134=(sj5)*(sj5);
IkReal x1135=((IkReal(1.00000000000000))*(x1134));
IkReal x1136=((IkReal(2.00000000000000))*(cj5)*(sj5));
IkReal x1137=((IkReal(1.00000000000000))*(x1133));
gconst121=IKsign(((((IkReal(-1.00000000000000))*(x1135)*((r10)*(r10))))+(((IkReal(-1.00000000000000))*(x1137)*((r01)*(r01))))+(((IkReal(-1.00000000000000))*(r10)*(r11)*(x1136)))+(((IkReal(-1.00000000000000))*(r00)*(r01)*(x1136)))+(((IkReal(-1.00000000000000))*(x1137)*((r11)*(r11))))+(((IkReal(-1.00000000000000))*(x1135)*((r00)*(r00))))));
IkReal x1138=(cj5)*(cj5);
IkReal x1139=(sj5)*(sj5);
IkReal x1140=((IkReal(1.00000000000000))*(x1139));
IkReal x1141=((IkReal(2.00000000000000))*(cj5)*(sj5));
IkReal x1142=((IkReal(1.00000000000000))*(x1138));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x1140)*((r10)*(r10))))+(((IkReal(-1.00000000000000))*(x1142)*((r01)*(r01))))+(((IkReal(-1.00000000000000))*(x1140)*((r00)*(r00))))+(((IkReal(-1.00000000000000))*(x1142)*((r11)*(r11))))+(((IkReal(-1.00000000000000))*(r10)*(r11)*(x1141)))+(((IkReal(-1.00000000000000))*(r00)*(r01)*(x1141))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst123;
gconst123=IKsign((((cj2)*(cj2))+((sj2)*(sj2))));
dummyeval[0]=(((cj2)*(cj2))+((sj2)*(sj2)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst122;
IkReal x1143=(sj5)*(sj5);
IkReal x1144=(cj5)*(cj5);
IkReal x1145=((cj4)*(cj5));
IkReal x1146=((IkReal(1.00000000000000))*(r12));
IkReal x1147=((cj4)*(sj5));
IkReal x1148=((r01)*(r10));
IkReal x1149=((sj4)*(x1144));
IkReal x1150=((IkReal(1.00000000000000))*(r00)*(r11));
IkReal x1151=((sj4)*(x1143));
gconst122=IKsign(((((IkReal(-1.00000000000000))*(r01)*(x1145)*(x1146)))+(((IkReal(-1.00000000000000))*(x1150)*(x1151)))+(((r02)*(r10)*(x1147)))+(((r02)*(r11)*(x1145)))+(((x1148)*(x1149)))+(((IkReal(-1.00000000000000))*(x1149)*(x1150)))+(((IkReal(-1.00000000000000))*(r00)*(x1146)*(x1147)))+(((x1148)*(x1151)))));
IkReal x1152=(sj5)*(sj5);
IkReal x1153=(cj5)*(cj5);
IkReal x1154=((cj4)*(cj5));
IkReal x1155=((IkReal(1.00000000000000))*(r12));
IkReal x1156=((cj4)*(sj5));
IkReal x1157=((r01)*(r10));
IkReal x1158=((sj4)*(x1153));
IkReal x1159=((IkReal(1.00000000000000))*(r00)*(r11));
IkReal x1160=((sj4)*(x1152));
dummyeval[0]=((((x1157)*(x1160)))+(((r02)*(r10)*(x1156)))+(((r02)*(r11)*(x1154)))+(((IkReal(-1.00000000000000))*(r01)*(x1154)*(x1155)))+(((IkReal(-1.00000000000000))*(x1159)*(x1160)))+(((x1157)*(x1158)))+(((IkReal(-1.00000000000000))*(r00)*(x1155)*(x1156)))+(((IkReal(-1.00000000000000))*(x1158)*(x1159))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x1161=((cj5)*(sj4));
IkReal x1162=((IkReal(1.00000000000000))*(cj4));
IkReal x1163=((IkReal(1.00000000000000))*(sj4)*(sj5));
if( IKabs(((gconst122)*(((((r10)*(x1161)))+(((IkReal(-1.00000000000000))*(r11)*(x1163)))+(((IkReal(-1.00000000000000))*(r12)*(x1162))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst122)*(((((IkReal(-1.00000000000000))*(r01)*(x1163)))+(((r00)*(x1161)))+(((IkReal(-1.00000000000000))*(r02)*(x1162))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst122)*(((((r10)*(x1161)))+(((IkReal(-1.00000000000000))*(r11)*(x1163)))+(((IkReal(-1.00000000000000))*(r12)*(x1162)))))), ((gconst122)*(((((IkReal(-1.00000000000000))*(r01)*(x1163)))+(((r00)*(x1161)))+(((IkReal(-1.00000000000000))*(r02)*(x1162)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[4];
IkReal x1164=IKsin(j0);
IkReal x1165=IKcos(j0);
IkReal x1166=((IkReal(1.00000000000000))*(cj5));
IkReal x1167=((r01)*(sj5));
IkReal x1168=((IkReal(1.00000000000000))*(r12));
IkReal x1169=((IkReal(1.00000000000000))*(r10));
IkReal x1170=((r11)*(sj5));
IkReal x1171=((cj4)*(x1164));
IkReal x1172=((sj4)*(x1164));
IkReal x1173=((sj4)*(x1165));
IkReal x1174=((sj5)*(x1164));
IkReal x1175=((cj4)*(x1165));
IkReal x1176=((sj5)*(x1165));
evalcond[0]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(x1169)*(x1176)))+(((IkReal(-1.00000000000000))*(r11)*(x1165)*(x1166)))+(((r00)*(x1174)))+(((cj5)*(r01)*(x1164))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1169)*(x1174)))+(((IkReal(-1.00000000000000))*(r00)*(x1176)))+(((IkReal(-1.00000000000000))*(r11)*(x1164)*(x1166)))+(((IkReal(-1.00000000000000))*(r01)*(x1165)*(x1166))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x1170)*(x1173)))+(((IkReal(-1.00000000000000))*(x1168)*(x1175)))+(((r02)*(x1171)))+(((cj5)*(r10)*(x1173)))+(((IkReal(-1.00000000000000))*(r00)*(x1166)*(x1172)))+(((x1167)*(x1172))));
evalcond[3]=((((x1170)*(x1175)))+(((IkReal(-1.00000000000000))*(r10)*(x1166)*(x1175)))+(((cj5)*(r00)*(x1171)))+(((IkReal(-1.00000000000000))*(x1168)*(x1173)))+(((IkReal(-1.00000000000000))*(x1167)*(x1171)))+(((r02)*(x1172))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst124;
gconst124=IKsign((((cj2)*(cj2))+((sj2)*(sj2))));
dummyeval[0]=(((cj2)*(cj2))+((sj2)*(sj2)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst125;
gconst125=IKsign(((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2))))));
dummyeval[0]=((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x1177=((cj4)*(r22));
IkReal x1178=((r11)*(sj0));
IkReal x1179=((IkReal(1.00000000000000))*(cj2));
IkReal x1180=((sj2)*(sj4));
IkReal x1181=((IkReal(1.00000000000000))*(sj2));
IkReal x1182=((cj2)*(sj4));
IkReal x1183=((cj0)*(r01));
IkReal x1184=((cj5)*(r20));
IkReal x1185=((IkReal(1.00000000000000))*(sj4)*(sj5));
IkReal x1186=((cj0)*(cj4)*(r02));
IkReal x1187=((cj4)*(r12)*(sj0));
IkReal x1188=((cj5)*(r10)*(sj0));
IkReal x1189=((cj0)*(cj5)*(r00));
if( IKabs(((gconst125)*(((((sj2)*(x1177)))+(((IkReal(-1.00000000000000))*(x1179)*(x1187)))+(((r21)*(sj5)*(x1180)))+(((x1182)*(x1188)))+(((IkReal(-1.00000000000000))*(x1180)*(x1184)))+(((x1182)*(x1189)))+(((IkReal(-1.00000000000000))*(sj4)*(sj5)*(x1179)*(x1183)))+(((IkReal(-1.00000000000000))*(x1179)*(x1186)))+(((IkReal(-1.00000000000000))*(sj4)*(sj5)*(x1178)*(x1179))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst125)*(((((IkReal(-1.00000000000000))*(sj5)*(x1178)*(x1180)))+(((IkReal(-1.00000000000000))*(x1181)*(x1187)))+(((IkReal(-1.00000000000000))*(x1177)*(x1179)))+(((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj5)*(x1179)))+(((x1180)*(x1189)))+(((x1182)*(x1184)))+(((IkReal(-1.00000000000000))*(x1181)*(x1186)))+(((IkReal(-1.00000000000000))*(sj5)*(x1180)*(x1183)))+(((x1180)*(x1188))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst125)*(((((sj2)*(x1177)))+(((IkReal(-1.00000000000000))*(x1179)*(x1187)))+(((r21)*(sj5)*(x1180)))+(((x1182)*(x1188)))+(((IkReal(-1.00000000000000))*(x1180)*(x1184)))+(((x1182)*(x1189)))+(((IkReal(-1.00000000000000))*(sj4)*(sj5)*(x1179)*(x1183)))+(((IkReal(-1.00000000000000))*(x1179)*(x1186)))+(((IkReal(-1.00000000000000))*(sj4)*(sj5)*(x1178)*(x1179)))))), ((gconst125)*(((((IkReal(-1.00000000000000))*(sj5)*(x1178)*(x1180)))+(((IkReal(-1.00000000000000))*(x1181)*(x1187)))+(((IkReal(-1.00000000000000))*(x1177)*(x1179)))+(((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj5)*(x1179)))+(((x1180)*(x1189)))+(((x1182)*(x1184)))+(((IkReal(-1.00000000000000))*(x1181)*(x1186)))+(((IkReal(-1.00000000000000))*(sj5)*(x1180)*(x1183)))+(((x1180)*(x1188)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x1190=IKcos(j1);
IkReal x1191=IKsin(j1);
IkReal x1192=((IkReal(1.00000000000000))*(sj4));
IkReal x1193=((cj5)*(r00));
IkReal x1194=((cj5)*(r20));
IkReal x1195=((r12)*(sj0));
IkReal x1196=((r21)*(sj5));
IkReal x1197=((IkReal(1.00000000000000))*(cj4));
IkReal x1198=((sj2)*(x1191));
IkReal x1199=((IkReal(1.00000000000000))*(x1190));
IkReal x1200=((r11)*(sj0)*(sj5));
IkReal x1201=((cj0)*(x1197));
IkReal x1202=((cj0)*(r01)*(sj5));
IkReal x1203=((cj2)*(x1191));
IkReal x1204=((cj5)*(r10)*(sj0));
IkReal x1205=((cj2)*(x1199));
evalcond[0]=((((IkReal(-1.00000000000000))*(x1205)))+(((sj4)*(x1196)))+(((cj4)*(r22)))+(((IkReal(-1.00000000000000))*(x1192)*(x1194)))+(x1198));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1196)*(x1197)))+(((r22)*(sj4)))+(((IkReal(-1.00000000000000))*(x1203)))+(((IkReal(-1.00000000000000))*(sj2)*(x1199)))+(((cj4)*(x1194))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x1195)*(x1197)))+(((IkReal(-1.00000000000000))*(r02)*(x1201)))+(((sj2)*(x1190)))+(((IkReal(-1.00000000000000))*(x1192)*(x1200)))+(((sj4)*(x1204)))+(x1203)+(((cj0)*(sj4)*(x1193)))+(((IkReal(-1.00000000000000))*(x1192)*(x1202))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x1205)))+(((cj4)*(x1200)))+(((IkReal(-1.00000000000000))*(x1197)*(x1204)))+(x1198)+(((IkReal(-1.00000000000000))*(x1193)*(x1201)))+(((IkReal(-1.00000000000000))*(x1192)*(x1195)))+(((cj4)*(x1202)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x1192))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x1206=((IkReal(1.00000000000000))*(cj2));
IkReal x1207=((cj2)*(r22));
IkReal x1208=((r21)*(sj5));
IkReal x1209=((r22)*(sj2));
IkReal x1210=((cj5)*(r20)*(sj4));
IkReal x1211=((cj4)*(cj5)*(r20));
IkReal x1212=((IkReal(1.00000000000000))*(sj2)*(x1208));
if( IKabs(((gconst124)*(((((IkReal(-1.00000000000000))*(sj4)*(x1212)))+(((sj2)*(x1210)))+(((IkReal(-1.00000000000000))*(cj4)*(x1206)*(x1208)))+(((sj4)*(x1207)))+(((IkReal(-1.00000000000000))*(cj4)*(x1209)))+(((cj2)*(x1211))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst124)*(((((sj4)*(x1209)))+(((cj4)*(x1207)))+(((sj2)*(x1211)))+(((IkReal(-1.00000000000000))*(x1206)*(x1210)))+(((IkReal(-1.00000000000000))*(cj4)*(x1212)))+(((cj2)*(sj4)*(x1208))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst124)*(((((IkReal(-1.00000000000000))*(sj4)*(x1212)))+(((sj2)*(x1210)))+(((IkReal(-1.00000000000000))*(cj4)*(x1206)*(x1208)))+(((sj4)*(x1207)))+(((IkReal(-1.00000000000000))*(cj4)*(x1209)))+(((cj2)*(x1211)))))), ((gconst124)*(((((sj4)*(x1209)))+(((cj4)*(x1207)))+(((sj2)*(x1211)))+(((IkReal(-1.00000000000000))*(x1206)*(x1210)))+(((IkReal(-1.00000000000000))*(cj4)*(x1212)))+(((cj2)*(sj4)*(x1208)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x1213=IKcos(j1);
IkReal x1214=IKsin(j1);
IkReal x1215=((IkReal(1.00000000000000))*(sj4));
IkReal x1216=((cj5)*(r00));
IkReal x1217=((cj5)*(r20));
IkReal x1218=((r12)*(sj0));
IkReal x1219=((r21)*(sj5));
IkReal x1220=((IkReal(1.00000000000000))*(cj4));
IkReal x1221=((sj2)*(x1214));
IkReal x1222=((IkReal(1.00000000000000))*(x1213));
IkReal x1223=((r11)*(sj0)*(sj5));
IkReal x1224=((cj0)*(x1220));
IkReal x1225=((cj0)*(r01)*(sj5));
IkReal x1226=((cj2)*(x1214));
IkReal x1227=((cj5)*(r10)*(sj0));
IkReal x1228=((cj2)*(x1222));
evalcond[0]=((((sj4)*(x1219)))+(x1221)+(((IkReal(-1.00000000000000))*(x1228)))+(((IkReal(-1.00000000000000))*(x1215)*(x1217)))+(((cj4)*(r22))));
evalcond[1]=((((IkReal(-1.00000000000000))*(sj2)*(x1222)))+(((r22)*(sj4)))+(((IkReal(-1.00000000000000))*(x1226)))+(((cj4)*(x1217)))+(((IkReal(-1.00000000000000))*(x1219)*(x1220))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x1218)*(x1220)))+(x1226)+(((IkReal(-1.00000000000000))*(x1215)*(x1225)))+(((sj4)*(x1227)))+(((IkReal(-1.00000000000000))*(r02)*(x1224)))+(((sj2)*(x1213)))+(((IkReal(-1.00000000000000))*(x1215)*(x1223)))+(((cj0)*(sj4)*(x1216))));
evalcond[3]=((((cj4)*(x1223)))+(((IkReal(-1.00000000000000))*(x1215)*(x1218)))+(x1221)+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x1215)))+(((IkReal(-1.00000000000000))*(x1216)*(x1224)))+(((IkReal(-1.00000000000000))*(x1228)))+(((IkReal(-1.00000000000000))*(x1220)*(x1227)))+(((cj4)*(x1225))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x1229=((IkReal(1.00000000000000))*(cj2));
IkReal x1230=((cj2)*(r22));
IkReal x1231=((r21)*(sj5));
IkReal x1232=((r22)*(sj2));
IkReal x1233=((cj5)*(r20)*(sj4));
IkReal x1234=((cj4)*(cj5)*(r20));
IkReal x1235=((IkReal(1.00000000000000))*(sj2)*(x1231));
if( IKabs(((gconst123)*(((((IkReal(-1.00000000000000))*(cj4)*(x1229)*(x1231)))+(((cj2)*(x1234)))+(((IkReal(-1.00000000000000))*(cj4)*(x1232)))+(((sj4)*(x1230)))+(((IkReal(-1.00000000000000))*(sj4)*(x1235)))+(((sj2)*(x1233))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst123)*(((((IkReal(-1.00000000000000))*(cj4)*(x1235)))+(((IkReal(-1.00000000000000))*(x1229)*(x1233)))+(((sj4)*(x1232)))+(((cj2)*(sj4)*(x1231)))+(((sj2)*(x1234)))+(((cj4)*(x1230))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst123)*(((((IkReal(-1.00000000000000))*(cj4)*(x1229)*(x1231)))+(((cj2)*(x1234)))+(((IkReal(-1.00000000000000))*(cj4)*(x1232)))+(((sj4)*(x1230)))+(((IkReal(-1.00000000000000))*(sj4)*(x1235)))+(((sj2)*(x1233)))))), ((gconst123)*(((((IkReal(-1.00000000000000))*(cj4)*(x1235)))+(((IkReal(-1.00000000000000))*(x1229)*(x1233)))+(((sj4)*(x1232)))+(((cj2)*(sj4)*(x1231)))+(((sj2)*(x1234)))+(((cj4)*(x1230)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[2];
IkReal x1236=IKcos(j1);
IkReal x1237=IKsin(j1);
IkReal x1238=((cj5)*(r20));
IkReal x1239=((r21)*(sj5));
IkReal x1240=((IkReal(1.00000000000000))*(x1236));
evalcond[0]=((((IkReal(-1.00000000000000))*(sj4)*(x1238)))+(((IkReal(-1.00000000000000))*(cj2)*(x1240)))+(((cj4)*(r22)))+(((sj4)*(x1239)))+(((sj2)*(x1237))));
evalcond[1]=((((IkReal(-1.00000000000000))*(cj2)*(x1237)))+(((cj4)*(x1238)))+(((r22)*(sj4)))+(((IkReal(-1.00000000000000))*(sj2)*(x1240)))+(((IkReal(-1.00000000000000))*(cj4)*(x1239))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst126;
IkReal x1241=(cj5)*(cj5);
IkReal x1242=(sj5)*(sj5);
IkReal x1243=((IkReal(1.00000000000000))*(x1242));
IkReal x1244=((IkReal(2.00000000000000))*(cj5)*(sj5));
IkReal x1245=((IkReal(1.00000000000000))*(x1241));
gconst126=IKsign(((((IkReal(-1.00000000000000))*(r10)*(r11)*(x1244)))+(((IkReal(-1.00000000000000))*(x1245)*((r11)*(r11))))+(((IkReal(-1.00000000000000))*(x1243)*((r00)*(r00))))+(((IkReal(-1.00000000000000))*(r00)*(r01)*(x1244)))+(((IkReal(-1.00000000000000))*(x1245)*((r01)*(r01))))+(((IkReal(-1.00000000000000))*(x1243)*((r10)*(r10))))));
IkReal x1246=(cj5)*(cj5);
IkReal x1247=(sj5)*(sj5);
IkReal x1248=((IkReal(1.00000000000000))*(x1247));
IkReal x1249=((IkReal(2.00000000000000))*(cj5)*(sj5));
IkReal x1250=((IkReal(1.00000000000000))*(x1246));
dummyeval[0]=((((IkReal(-1.00000000000000))*(r00)*(r01)*(x1249)))+(((IkReal(-1.00000000000000))*(x1248)*((r00)*(r00))))+(((IkReal(-1.00000000000000))*(r10)*(r11)*(x1249)))+(((IkReal(-1.00000000000000))*(x1248)*((r10)*(r10))))+(((IkReal(-1.00000000000000))*(x1250)*((r01)*(r01))))+(((IkReal(-1.00000000000000))*(x1250)*((r11)*(r11)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst127;
IkReal x1251=(sj5)*(sj5);
IkReal x1252=(cj5)*(cj5);
IkReal x1253=((cj4)*(cj5));
IkReal x1254=((IkReal(1.00000000000000))*(r12));
IkReal x1255=((cj4)*(sj5));
IkReal x1256=((r01)*(r10));
IkReal x1257=((sj4)*(x1252));
IkReal x1258=((IkReal(1.00000000000000))*(r00)*(r11));
IkReal x1259=((sj4)*(x1251));
gconst127=IKsign(((((IkReal(-1.00000000000000))*(x1257)*(x1258)))+(((x1256)*(x1259)))+(((IkReal(-1.00000000000000))*(x1258)*(x1259)))+(((r02)*(r11)*(x1253)))+(((r02)*(r10)*(x1255)))+(((x1256)*(x1257)))+(((IkReal(-1.00000000000000))*(r00)*(x1254)*(x1255)))+(((IkReal(-1.00000000000000))*(r01)*(x1253)*(x1254)))));
IkReal x1260=(sj5)*(sj5);
IkReal x1261=(cj5)*(cj5);
IkReal x1262=((cj4)*(cj5));
IkReal x1263=((IkReal(1.00000000000000))*(r12));
IkReal x1264=((cj4)*(sj5));
IkReal x1265=((r01)*(r10));
IkReal x1266=((sj4)*(x1261));
IkReal x1267=((IkReal(1.00000000000000))*(r00)*(r11));
IkReal x1268=((sj4)*(x1260));
dummyeval[0]=((((IkReal(-1.00000000000000))*(r01)*(x1262)*(x1263)))+(((IkReal(-1.00000000000000))*(r00)*(x1263)*(x1264)))+(((IkReal(-1.00000000000000))*(x1266)*(x1267)))+(((r02)*(r11)*(x1262)))+(((IkReal(-1.00000000000000))*(x1267)*(x1268)))+(((x1265)*(x1268)))+(((r02)*(r10)*(x1264)))+(((x1265)*(x1266))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x1269=((cj5)*(sj4));
IkReal x1270=((IkReal(1.00000000000000))*(cj4));
IkReal x1271=((IkReal(1.00000000000000))*(sj4)*(sj5));
if( IKabs(((gconst127)*(((((IkReal(-1.00000000000000))*(r11)*(x1271)))+(((r10)*(x1269)))+(((IkReal(-1.00000000000000))*(r12)*(x1270))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst127)*(((((IkReal(-1.00000000000000))*(r02)*(x1270)))+(((r00)*(x1269)))+(((IkReal(-1.00000000000000))*(r01)*(x1271))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst127)*(((((IkReal(-1.00000000000000))*(r11)*(x1271)))+(((r10)*(x1269)))+(((IkReal(-1.00000000000000))*(r12)*(x1270)))))), ((gconst127)*(((((IkReal(-1.00000000000000))*(r02)*(x1270)))+(((r00)*(x1269)))+(((IkReal(-1.00000000000000))*(r01)*(x1271)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[6];
IkReal x1272=IKsin(j0);
IkReal x1273=IKcos(j0);
IkReal x1274=((IkReal(1.00000000000000))*(r10));
IkReal x1275=((IkReal(1.00000000000000))*(sj4));
IkReal x1276=((cj5)*(r01));
IkReal x1277=((cj5)*(r00));
IkReal x1278=((cj4)*(r01));
IkReal x1279=((IkReal(1.00000000000000))*(cj4));
IkReal x1280=((cj4)*(r11));
IkReal x1281=((sj5)*(x1272));
IkReal x1282=((r11)*(x1275));
IkReal x1283=((sj5)*(x1273));
IkReal x1284=((r02)*(x1273));
IkReal x1285=((r12)*(x1273));
IkReal x1286=((IkReal(1.00000000000000))*(x1273));
IkReal x1287=((cj4)*(x1272));
IkReal x1288=((cj5)*(x1272));
IkReal x1289=((cj5)*(sj4)*(x1273));
evalcond[0]=((IkReal(-1.00000000000000))+(((r00)*(x1281)))+(((IkReal(-1.00000000000000))*(x1274)*(x1283)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x1286)))+(((x1272)*(x1276))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1274)*(x1281)))+(((IkReal(-1.00000000000000))*(x1276)*(x1286)))+(((IkReal(-1.00000000000000))*(r00)*(x1283)))+(((IkReal(-1.00000000000000))*(r11)*(x1288))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x1282)*(x1283)))+(((r10)*(x1289)))+(((r02)*(x1287)))+(((r01)*(sj4)*(x1281)))+(((IkReal(-1.00000000000000))*(x1279)*(x1285)))+(((IkReal(-1.00000000000000))*(x1272)*(x1275)*(x1277))));
evalcond[3]=((((x1277)*(x1287)))+(((IkReal(-1.00000000000000))*(cj4)*(cj5)*(x1273)*(x1274)))+(((r02)*(sj4)*(x1272)))+(((IkReal(-1.00000000000000))*(x1275)*(x1285)))+(((x1280)*(x1283)))+(((IkReal(-1.00000000000000))*(x1278)*(x1281))));
evalcond[4]=((((cj1)*(sj2)))+(((IkReal(-1.00000000000000))*(x1279)*(x1284)))+(((r10)*(sj4)*(x1288)))+(((IkReal(-1.00000000000000))*(x1281)*(x1282)))+(((sj4)*(x1273)*(x1277)))+(((IkReal(-1.00000000000000))*(r12)*(x1272)*(x1279)))+(((IkReal(-1.00000000000000))*(r01)*(x1275)*(x1283)))+(((cj2)*(sj1))));
evalcond[5]=((((IkReal(-1.00000000000000))*(cj5)*(x1274)*(x1287)))+(((IkReal(-1.00000000000000))*(cj1)*(cj2)))+(((IkReal(-1.00000000000000))*(x1273)*(x1277)*(x1279)))+(((IkReal(-1.00000000000000))*(x1275)*(x1284)))+(((IkReal(-1.00000000000000))*(r12)*(x1272)*(x1275)))+(((x1278)*(x1283)))+(((sj1)*(sj2)))+(((x1280)*(x1281))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
if( IKabs(((gconst126)*(((((IkReal(-1.00000000000000))*(r00)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r01))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst126)*(((((cj5)*(r11)))+(((r10)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst126)*(((((IkReal(-1.00000000000000))*(r00)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)))))), ((gconst126)*(((((cj5)*(r11)))+(((r10)*(sj5)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[6];
IkReal x1290=IKsin(j0);
IkReal x1291=IKcos(j0);
IkReal x1292=((IkReal(1.00000000000000))*(r10));
IkReal x1293=((IkReal(1.00000000000000))*(sj4));
IkReal x1294=((cj5)*(r01));
IkReal x1295=((cj5)*(r00));
IkReal x1296=((cj4)*(r01));
IkReal x1297=((IkReal(1.00000000000000))*(cj4));
IkReal x1298=((cj4)*(r11));
IkReal x1299=((sj5)*(x1290));
IkReal x1300=((r11)*(x1293));
IkReal x1301=((sj5)*(x1291));
IkReal x1302=((r02)*(x1291));
IkReal x1303=((r12)*(x1291));
IkReal x1304=((IkReal(1.00000000000000))*(x1291));
IkReal x1305=((cj4)*(x1290));
IkReal x1306=((cj5)*(x1290));
IkReal x1307=((cj5)*(sj4)*(x1291));
evalcond[0]=((IkReal(-1.00000000000000))+(((r00)*(x1299)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x1304)))+(((x1290)*(x1294)))+(((IkReal(-1.00000000000000))*(x1292)*(x1301))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1292)*(x1299)))+(((IkReal(-1.00000000000000))*(r11)*(x1306)))+(((IkReal(-1.00000000000000))*(x1294)*(x1304)))+(((IkReal(-1.00000000000000))*(r00)*(x1301))));
evalcond[2]=((((r01)*(sj4)*(x1299)))+(((IkReal(-1.00000000000000))*(x1300)*(x1301)))+(((IkReal(-1.00000000000000))*(x1290)*(x1293)*(x1295)))+(((r02)*(x1305)))+(((r10)*(x1307)))+(((IkReal(-1.00000000000000))*(x1297)*(x1303))));
evalcond[3]=((((IkReal(-1.00000000000000))*(cj4)*(cj5)*(x1291)*(x1292)))+(((x1295)*(x1305)))+(((IkReal(-1.00000000000000))*(x1296)*(x1299)))+(((IkReal(-1.00000000000000))*(x1293)*(x1303)))+(((r02)*(sj4)*(x1290)))+(((x1298)*(x1301))));
evalcond[4]=((((cj1)*(sj2)))+(((IkReal(-1.00000000000000))*(r01)*(x1293)*(x1301)))+(((sj4)*(x1291)*(x1295)))+(((IkReal(-1.00000000000000))*(x1299)*(x1300)))+(((IkReal(-1.00000000000000))*(r12)*(x1290)*(x1297)))+(((r10)*(sj4)*(x1306)))+(((cj2)*(sj1)))+(((IkReal(-1.00000000000000))*(x1297)*(x1302))));
evalcond[5]=((((IkReal(-1.00000000000000))*(cj1)*(cj2)))+(((IkReal(-1.00000000000000))*(x1293)*(x1302)))+(((IkReal(-1.00000000000000))*(r12)*(x1290)*(x1293)))+(((x1296)*(x1301)))+(((sj1)*(sj2)))+(((IkReal(-1.00000000000000))*(x1291)*(x1295)*(x1297)))+(((IkReal(-1.00000000000000))*(cj5)*(x1292)*(x1305)))+(((x1298)*(x1299))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
if( IKabs(((gconst121)*(((((IkReal(-1.00000000000000))*(r00)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r01))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst121)*(((((cj5)*(r11)))+(((r10)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst121)*(((((IkReal(-1.00000000000000))*(r00)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)))))), ((gconst121)*(((((cj5)*(r11)))+(((r10)*(sj5)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[4];
IkReal x1308=IKsin(j0);
IkReal x1309=IKcos(j0);
IkReal x1310=((IkReal(1.00000000000000))*(cj5));
IkReal x1311=((r01)*(sj5));
IkReal x1312=((IkReal(1.00000000000000))*(r12));
IkReal x1313=((IkReal(1.00000000000000))*(r10));
IkReal x1314=((r11)*(sj5));
IkReal x1315=((cj4)*(x1308));
IkReal x1316=((sj4)*(x1308));
IkReal x1317=((sj4)*(x1309));
IkReal x1318=((sj5)*(x1308));
IkReal x1319=((cj4)*(x1309));
IkReal x1320=((sj5)*(x1309));
evalcond[0]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(x1313)*(x1320)))+(((r00)*(x1318)))+(((IkReal(-1.00000000000000))*(r11)*(x1309)*(x1310)))+(((cj5)*(r01)*(x1308))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r00)*(x1320)))+(((IkReal(-1.00000000000000))*(x1313)*(x1318)))+(((IkReal(-1.00000000000000))*(r11)*(x1308)*(x1310)))+(((IkReal(-1.00000000000000))*(r01)*(x1309)*(x1310))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r00)*(x1310)*(x1316)))+(((x1311)*(x1316)))+(((cj5)*(r10)*(x1317)))+(((IkReal(-1.00000000000000))*(x1314)*(x1317)))+(((r02)*(x1315)))+(((IkReal(-1.00000000000000))*(x1312)*(x1319))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x1312)*(x1317)))+(((cj5)*(r00)*(x1315)))+(((r02)*(x1316)))+(((IkReal(-1.00000000000000))*(r10)*(x1310)*(x1319)))+(((x1314)*(x1319)))+(((IkReal(-1.00000000000000))*(x1311)*(x1315))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst124;
gconst124=IKsign((((cj2)*(cj2))+((sj2)*(sj2))));
dummyeval[0]=(((cj2)*(cj2))+((sj2)*(sj2)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst125;
gconst125=IKsign(((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2))))));
dummyeval[0]=((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x1321=((cj4)*(r22));
IkReal x1322=((r11)*(sj0));
IkReal x1323=((IkReal(1.00000000000000))*(cj2));
IkReal x1324=((sj2)*(sj4));
IkReal x1325=((IkReal(1.00000000000000))*(sj2));
IkReal x1326=((cj2)*(sj4));
IkReal x1327=((cj0)*(r01));
IkReal x1328=((cj5)*(r20));
IkReal x1329=((IkReal(1.00000000000000))*(sj4)*(sj5));
IkReal x1330=((cj0)*(cj4)*(r02));
IkReal x1331=((cj4)*(r12)*(sj0));
IkReal x1332=((cj5)*(r10)*(sj0));
IkReal x1333=((cj0)*(cj5)*(r00));
if( IKabs(((gconst125)*(((((sj2)*(x1321)))+(((r21)*(sj5)*(x1324)))+(((IkReal(-1.00000000000000))*(x1323)*(x1331)))+(((IkReal(-1.00000000000000))*(sj4)*(sj5)*(x1322)*(x1323)))+(((x1326)*(x1333)))+(((IkReal(-1.00000000000000))*(x1323)*(x1330)))+(((x1326)*(x1332)))+(((IkReal(-1.00000000000000))*(x1324)*(x1328)))+(((IkReal(-1.00000000000000))*(sj4)*(sj5)*(x1323)*(x1327))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst125)*(((((IkReal(-1.00000000000000))*(sj5)*(x1324)*(x1327)))+(((IkReal(-1.00000000000000))*(x1325)*(x1330)))+(((x1324)*(x1332)))+(((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj5)*(x1323)))+(((IkReal(-1.00000000000000))*(sj5)*(x1322)*(x1324)))+(((x1326)*(x1328)))+(((IkReal(-1.00000000000000))*(x1321)*(x1323)))+(((x1324)*(x1333)))+(((IkReal(-1.00000000000000))*(x1325)*(x1331))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst125)*(((((sj2)*(x1321)))+(((r21)*(sj5)*(x1324)))+(((IkReal(-1.00000000000000))*(x1323)*(x1331)))+(((IkReal(-1.00000000000000))*(sj4)*(sj5)*(x1322)*(x1323)))+(((x1326)*(x1333)))+(((IkReal(-1.00000000000000))*(x1323)*(x1330)))+(((x1326)*(x1332)))+(((IkReal(-1.00000000000000))*(x1324)*(x1328)))+(((IkReal(-1.00000000000000))*(sj4)*(sj5)*(x1323)*(x1327)))))), ((gconst125)*(((((IkReal(-1.00000000000000))*(sj5)*(x1324)*(x1327)))+(((IkReal(-1.00000000000000))*(x1325)*(x1330)))+(((x1324)*(x1332)))+(((IkReal(-1.00000000000000))*(r21)*(sj4)*(sj5)*(x1323)))+(((IkReal(-1.00000000000000))*(sj5)*(x1322)*(x1324)))+(((x1326)*(x1328)))+(((IkReal(-1.00000000000000))*(x1321)*(x1323)))+(((x1324)*(x1333)))+(((IkReal(-1.00000000000000))*(x1325)*(x1331)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x1334=IKcos(j1);
IkReal x1335=IKsin(j1);
IkReal x1336=((IkReal(1.00000000000000))*(sj4));
IkReal x1337=((cj5)*(r00));
IkReal x1338=((cj5)*(r20));
IkReal x1339=((r12)*(sj0));
IkReal x1340=((r21)*(sj5));
IkReal x1341=((IkReal(1.00000000000000))*(cj4));
IkReal x1342=((sj2)*(x1335));
IkReal x1343=((IkReal(1.00000000000000))*(x1334));
IkReal x1344=((r11)*(sj0)*(sj5));
IkReal x1345=((cj0)*(x1341));
IkReal x1346=((cj0)*(r01)*(sj5));
IkReal x1347=((cj2)*(x1335));
IkReal x1348=((cj5)*(r10)*(sj0));
IkReal x1349=((cj2)*(x1343));
evalcond[0]=((((sj4)*(x1340)))+(((IkReal(-1.00000000000000))*(x1336)*(x1338)))+(((cj4)*(r22)))+(((IkReal(-1.00000000000000))*(x1349)))+(x1342));
evalcond[1]=((((cj4)*(x1338)))+(((IkReal(-1.00000000000000))*(x1340)*(x1341)))+(((r22)*(sj4)))+(((IkReal(-1.00000000000000))*(sj2)*(x1343)))+(((IkReal(-1.00000000000000))*(x1347))));
evalcond[2]=((((sj2)*(x1334)))+(((IkReal(-1.00000000000000))*(x1339)*(x1341)))+(((cj0)*(sj4)*(x1337)))+(((sj4)*(x1348)))+(((IkReal(-1.00000000000000))*(r02)*(x1345)))+(x1347)+(((IkReal(-1.00000000000000))*(x1336)*(x1344)))+(((IkReal(-1.00000000000000))*(x1336)*(x1346))));
evalcond[3]=((((IkReal(-1.00000000000000))*(cj0)*(r02)*(x1336)))+(((cj4)*(x1344)))+(((IkReal(-1.00000000000000))*(x1336)*(x1339)))+(((IkReal(-1.00000000000000))*(x1337)*(x1345)))+(((IkReal(-1.00000000000000))*(x1341)*(x1348)))+(((cj4)*(x1346)))+(((IkReal(-1.00000000000000))*(x1349)))+(x1342));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x1350=((IkReal(1.00000000000000))*(cj2));
IkReal x1351=((cj2)*(r22));
IkReal x1352=((r21)*(sj5));
IkReal x1353=((r22)*(sj2));
IkReal x1354=((cj5)*(r20)*(sj4));
IkReal x1355=((cj4)*(cj5)*(r20));
IkReal x1356=((IkReal(1.00000000000000))*(sj2)*(x1352));
if( IKabs(((gconst124)*(((((IkReal(-1.00000000000000))*(cj4)*(x1350)*(x1352)))+(((sj4)*(x1351)))+(((cj2)*(x1355)))+(((IkReal(-1.00000000000000))*(cj4)*(x1353)))+(((IkReal(-1.00000000000000))*(sj4)*(x1356)))+(((sj2)*(x1354))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst124)*(((((cj4)*(x1351)))+(((IkReal(-1.00000000000000))*(cj4)*(x1356)))+(((IkReal(-1.00000000000000))*(x1350)*(x1354)))+(((cj2)*(sj4)*(x1352)))+(((sj2)*(x1355)))+(((sj4)*(x1353))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst124)*(((((IkReal(-1.00000000000000))*(cj4)*(x1350)*(x1352)))+(((sj4)*(x1351)))+(((cj2)*(x1355)))+(((IkReal(-1.00000000000000))*(cj4)*(x1353)))+(((IkReal(-1.00000000000000))*(sj4)*(x1356)))+(((sj2)*(x1354)))))), ((gconst124)*(((((cj4)*(x1351)))+(((IkReal(-1.00000000000000))*(cj4)*(x1356)))+(((IkReal(-1.00000000000000))*(x1350)*(x1354)))+(((cj2)*(sj4)*(x1352)))+(((sj2)*(x1355)))+(((sj4)*(x1353)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x1357=IKcos(j1);
IkReal x1358=IKsin(j1);
IkReal x1359=((IkReal(1.00000000000000))*(sj4));
IkReal x1360=((cj5)*(r00));
IkReal x1361=((cj5)*(r20));
IkReal x1362=((r12)*(sj0));
IkReal x1363=((r21)*(sj5));
IkReal x1364=((IkReal(1.00000000000000))*(cj4));
IkReal x1365=((sj2)*(x1358));
IkReal x1366=((IkReal(1.00000000000000))*(x1357));
IkReal x1367=((r11)*(sj0)*(sj5));
IkReal x1368=((cj0)*(x1364));
IkReal x1369=((cj0)*(r01)*(sj5));
IkReal x1370=((cj2)*(x1358));
IkReal x1371=((cj5)*(r10)*(sj0));
IkReal x1372=((cj2)*(x1366));
evalcond[0]=((x1365)+(((IkReal(-1.00000000000000))*(x1359)*(x1361)))+(((IkReal(-1.00000000000000))*(x1372)))+(((cj4)*(r22)))+(((sj4)*(x1363))));
evalcond[1]=((((r22)*(sj4)))+(((cj4)*(x1361)))+(((IkReal(-1.00000000000000))*(x1370)))+(((IkReal(-1.00000000000000))*(x1363)*(x1364)))+(((IkReal(-1.00000000000000))*(sj2)*(x1366))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x1362)*(x1364)))+(((IkReal(-1.00000000000000))*(r02)*(x1368)))+(((sj4)*(x1371)))+(((cj0)*(sj4)*(x1360)))+(((IkReal(-1.00000000000000))*(x1359)*(x1367)))+(x1370)+(((IkReal(-1.00000000000000))*(x1359)*(x1369)))+(((sj2)*(x1357))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x1359)*(x1362)))+(x1365)+(((IkReal(-1.00000000000000))*(x1372)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x1359)))+(((cj4)*(x1367)))+(((IkReal(-1.00000000000000))*(x1364)*(x1371)))+(((IkReal(-1.00000000000000))*(x1360)*(x1368)))+(((cj4)*(x1369))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}
}
}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x1373=((cj3)*(sj4));
IkReal x1374=((IkReal(1.00000000000000))*(sj5));
IkReal x1375=((IkReal(1.00000000000000))*(cj3)*(cj4));
if( IKabs(((gconst84)*(((((IkReal(-1.00000000000000))*(r12)*(x1375)))+(((cj5)*(r10)*(x1373)))+(((IkReal(-1.00000000000000))*(r11)*(x1373)*(x1374))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst84)*(((((cj5)*(r00)*(x1373)))+(((IkReal(-1.00000000000000))*(r01)*(x1373)*(x1374)))+(((IkReal(-1.00000000000000))*(r02)*(x1375))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst84)*(((((IkReal(-1.00000000000000))*(r12)*(x1375)))+(((cj5)*(r10)*(x1373)))+(((IkReal(-1.00000000000000))*(r11)*(x1373)*(x1374)))))), ((gconst84)*(((((cj5)*(r00)*(x1373)))+(((IkReal(-1.00000000000000))*(r01)*(x1373)*(x1374)))+(((IkReal(-1.00000000000000))*(r02)*(x1375)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[3];
IkReal x1376=IKsin(j0);
IkReal x1377=IKcos(j0);
IkReal x1378=((cj5)*(r00));
IkReal x1379=((r01)*(sj5));
IkReal x1380=((cj5)*(r10));
IkReal x1381=((IkReal(1.00000000000000))*(r12));
IkReal x1382=((r11)*(sj5));
IkReal x1383=((cj4)*(x1376));
IkReal x1384=((sj4)*(x1376));
IkReal x1385=((sj4)*(x1377));
IkReal x1386=((cj4)*(x1377));
IkReal x1387=((IkReal(1.00000000000000))*(x1377));
evalcond[0]=((((r00)*(sj5)*(x1376)))+(cj3)+(((cj5)*(r01)*(x1376)))+(((IkReal(-1.00000000000000))*(r10)*(sj5)*(x1387)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x1387))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1378)*(x1384)))+(((x1379)*(x1384)))+(((IkReal(-1.00000000000000))*(x1382)*(x1385)))+(((x1380)*(x1385)))+(((r02)*(x1383)))+(((IkReal(-1.00000000000000))*(x1381)*(x1386))));
evalcond[2]=((((r02)*(x1384)))+(sj3)+(((IkReal(-1.00000000000000))*(x1381)*(x1385)))+(((IkReal(-1.00000000000000))*(x1380)*(x1386)))+(((x1378)*(x1383)))+(((x1382)*(x1386)))+(((IkReal(-1.00000000000000))*(x1379)*(x1383))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst88;
gconst88=IKsign(((((sj3)*((cj2)*(cj2))))+(((sj3)*((sj2)*(sj2))))));
dummyeval[0]=((((sj3)*((cj2)*(cj2))))+(((sj3)*((sj2)*(sj2)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst89;
gconst89=IKsign(((((cj3)*((sj2)*(sj2))))+(((cj3)*((cj2)*(cj2))))));
dummyeval[0]=((((cj3)*((sj2)*(sj2))))+(((cj3)*((cj2)*(cj2)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[9];
IkReal x1388=((sj0)*(sj4));
IkReal x1389=((IkReal(1.00000000000000))*(r12));
IkReal x1390=((cj4)*(cj5));
IkReal x1391=((IkReal(1.00000000000000))*(cj0));
IkReal x1392=((cj4)*(sj0));
IkReal x1393=((IkReal(1.00000000000000))*(sj5));
IkReal x1394=((cj0)*(cj4));
IkReal x1395=((r00)*(sj0));
IkReal x1396=((sj4)*(sj5));
IkReal x1397=((IkReal(1.00000000000000))*(cj5));
IkReal x1398=((r01)*(sj5));
IkReal x1399=((cj0)*(sj4));
IkReal x1400=((r11)*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j3)), IkReal(6.28318530717959))));
evalcond[1]=((IkReal(0.0950000000000000))+(((cj5)*(npy)))+(((IkReal(-0.350000000000000))*(sj2)))+(((npx)*(sj5))));
evalcond[2]=((IkReal(-0.350000000000000))+(((IkReal(-0.350000000000000))*(cj2)))+(((cj4)*(npz)))+(((IkReal(-1.00000000000000))*(npx)*(sj4)*(x1397)))+(((npy)*(x1396))));
evalcond[3]=((((IkReal(-1.00000000000000))*(cj4)*(npy)*(x1393)))+(((npz)*(sj4)))+(((npx)*(x1390))));
evalcond[4]=((((cj5)*(r01)*(sj0)))+(((sj5)*(x1395)))+(((IkReal(-1.00000000000000))*(r10)*(sj5)*(x1391)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x1391))));
evalcond[5]=((((IkReal(-1.00000000000000))*(cj4)*(r21)*(x1393)))+(((r22)*(sj4)))+(((r20)*(x1390))));
evalcond[6]=((((IkReal(-1.00000000000000))*(x1389)*(x1394)))+(((cj5)*(r10)*(x1399)))+(((IkReal(-1.00000000000000))*(r00)*(x1388)*(x1397)))+(((r02)*(x1392)))+(((x1388)*(x1398)))+(((IkReal(-1.00000000000000))*(r11)*(x1391)*(x1396))));
evalcond[7]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x1389)*(x1399)))+(((x1390)*(x1395)))+(((IkReal(-1.00000000000000))*(r01)*(x1392)*(x1393)))+(((r02)*(x1388)))+(((x1394)*(x1400)))+(((IkReal(-1.00000000000000))*(r10)*(x1390)*(x1391))));
evalcond[8]=((((x1392)*(x1400)))+(((IkReal(-1.00000000000000))*(x1388)*(x1389)))+(((IkReal(-1.00000000000000))*(r00)*(x1390)*(x1391)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x1390)))+(((IkReal(-1.00000000000000))*(r02)*(sj4)*(x1391)))+(((x1394)*(x1398))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst90;
gconst90=IKsign((((cj2)*(cj2))+((sj2)*(sj2))));
dummyeval[0]=(((cj2)*(cj2))+((sj2)*(sj2)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst91;
gconst91=IKsign((((cj2)*(cj2))+((sj2)*(sj2))));
dummyeval[0]=(((cj2)*(cj2))+((sj2)*(sj2)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x1401=((cj2)*(sj5));
IkReal x1402=((r10)*(sj0));
IkReal x1403=((cj2)*(cj5));
IkReal x1404=((cj0)*(r00));
IkReal x1405=((sj2)*(sj5));
IkReal x1406=((r11)*(sj0));
IkReal x1407=((cj5)*(sj2));
IkReal x1408=((cj0)*(r01));
if( IKabs(((gconst91)*(((((r20)*(x1401)))+(((x1406)*(x1407)))+(((x1404)*(x1405)))+(((x1407)*(x1408)))+(((r21)*(x1403)))+(((x1402)*(x1405))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst91)*(((((IkReal(-1.00000000000000))*(x1403)*(x1408)))+(((r20)*(x1405)))+(((IkReal(-1.00000000000000))*(x1401)*(x1404)))+(((IkReal(-1.00000000000000))*(x1401)*(x1402)))+(((r21)*(x1407)))+(((IkReal(-1.00000000000000))*(x1403)*(x1406))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst91)*(((((r20)*(x1401)))+(((x1406)*(x1407)))+(((x1404)*(x1405)))+(((x1407)*(x1408)))+(((r21)*(x1403)))+(((x1402)*(x1405)))))), ((gconst91)*(((((IkReal(-1.00000000000000))*(x1403)*(x1408)))+(((r20)*(x1405)))+(((IkReal(-1.00000000000000))*(x1401)*(x1404)))+(((IkReal(-1.00000000000000))*(x1401)*(x1402)))+(((r21)*(x1407)))+(((IkReal(-1.00000000000000))*(x1403)*(x1406)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x1409=IKsin(j1);
IkReal x1410=IKcos(j1);
IkReal x1411=((cj0)*(sj4));
IkReal x1412=((IkReal(1.00000000000000))*(sj5));
IkReal x1413=((cj5)*(sj0));
IkReal x1414=((IkReal(1.00000000000000))*(cj4));
IkReal x1415=((IkReal(1.00000000000000))*(cj5));
IkReal x1416=((sj2)*(x1409));
IkReal x1417=((IkReal(1.00000000000000))*(x1410));
IkReal x1418=((cj2)*(x1409));
IkReal x1419=((cj2)*(x1417));
evalcond[0]=((((r20)*(sj5)))+(((IkReal(-1.00000000000000))*(x1418)))+(((cj5)*(r21)))+(((IkReal(-1.00000000000000))*(sj2)*(x1417))));
evalcond[1]=((x1416)+(((IkReal(-1.00000000000000))*(r20)*(sj4)*(x1415)))+(((IkReal(-1.00000000000000))*(x1419)))+(((cj4)*(r22)))+(((r21)*(sj4)*(sj5))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r11)*(x1413)))+(x1416)+(((IkReal(-1.00000000000000))*(cj0)*(r01)*(x1415)))+(((IkReal(-1.00000000000000))*(x1419)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x1412)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x1412))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r01)*(x1411)*(x1412)))+(((IkReal(-1.00000000000000))*(r12)*(sj0)*(x1414)))+(x1418)+(((sj2)*(x1410)))+(((r10)*(sj4)*(x1413)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x1414)))+(((IkReal(-1.00000000000000))*(r11)*(sj0)*(sj4)*(x1412)))+(((cj5)*(r00)*(x1411))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x1420=((r20)*(sj5));
IkReal x1421=((cj4)*(r22));
IkReal x1422=((sj2)*(sj4));
IkReal x1423=((cj5)*(r20));
IkReal x1424=((cj5)*(r21));
IkReal x1425=((r21)*(sj5));
IkReal x1426=((cj2)*(sj4));
if( IKabs(((gconst90)*(((((IkReal(-1.00000000000000))*(sj2)*(x1421)))+(((cj2)*(x1420)))+(((x1422)*(x1423)))+(((cj2)*(x1424)))+(((IkReal(-1.00000000000000))*(x1422)*(x1425))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst90)*(((((sj2)*(x1424)))+(((sj2)*(x1420)))+(((cj2)*(x1421)))+(((x1425)*(x1426)))+(((IkReal(-1.00000000000000))*(x1423)*(x1426))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst90)*(((((IkReal(-1.00000000000000))*(sj2)*(x1421)))+(((cj2)*(x1420)))+(((x1422)*(x1423)))+(((cj2)*(x1424)))+(((IkReal(-1.00000000000000))*(x1422)*(x1425)))))), ((gconst90)*(((((sj2)*(x1424)))+(((sj2)*(x1420)))+(((cj2)*(x1421)))+(((x1425)*(x1426)))+(((IkReal(-1.00000000000000))*(x1423)*(x1426)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x1427=IKsin(j1);
IkReal x1428=IKcos(j1);
IkReal x1429=((cj0)*(sj4));
IkReal x1430=((IkReal(1.00000000000000))*(sj5));
IkReal x1431=((cj5)*(sj0));
IkReal x1432=((IkReal(1.00000000000000))*(cj4));
IkReal x1433=((IkReal(1.00000000000000))*(cj5));
IkReal x1434=((sj2)*(x1427));
IkReal x1435=((IkReal(1.00000000000000))*(x1428));
IkReal x1436=((cj2)*(x1427));
IkReal x1437=((cj2)*(x1435));
evalcond[0]=((((IkReal(-1.00000000000000))*(x1436)))+(((r20)*(sj5)))+(((IkReal(-1.00000000000000))*(sj2)*(x1435)))+(((cj5)*(r21))));
evalcond[1]=((x1434)+(((cj4)*(r22)))+(((IkReal(-1.00000000000000))*(x1437)))+(((IkReal(-1.00000000000000))*(r20)*(sj4)*(x1433)))+(((r21)*(sj4)*(sj5))));
evalcond[2]=((((IkReal(-1.00000000000000))*(cj0)*(r01)*(x1433)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x1430)))+(x1434)+(((IkReal(-1.00000000000000))*(x1437)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x1430)))+(((IkReal(-1.00000000000000))*(r11)*(x1431))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r12)*(sj0)*(x1432)))+(((IkReal(-1.00000000000000))*(r01)*(x1429)*(x1430)))+(((cj5)*(r00)*(x1429)))+(((IkReal(-1.00000000000000))*(r11)*(sj0)*(sj4)*(x1430)))+(((r10)*(sj4)*(x1431)))+(x1436)+(((sj2)*(x1428)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x1432))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
IkReal x1438=((sj0)*(sj4));
IkReal x1439=((IkReal(1.00000000000000))*(r12));
IkReal x1440=((cj4)*(cj5));
IkReal x1441=((IkReal(1.00000000000000))*(cj0));
IkReal x1442=((cj4)*(sj0));
IkReal x1443=((IkReal(1.00000000000000))*(sj5));
IkReal x1444=((cj0)*(cj4));
IkReal x1445=((r00)*(sj0));
IkReal x1446=((sj4)*(sj5));
IkReal x1447=((IkReal(1.00000000000000))*(cj5));
IkReal x1448=((r01)*(sj5));
IkReal x1449=((cj0)*(sj4));
IkReal x1450=((r11)*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j3)), IkReal(6.28318530717959))));
evalcond[1]=((IkReal(0.0950000000000000))+(((cj5)*(npy)))+(((IkReal(0.350000000000000))*(sj2)))+(((npx)*(sj5))));
evalcond[2]=((IkReal(-0.350000000000000))+(((IkReal(-0.350000000000000))*(cj2)))+(((IkReal(-1.00000000000000))*(npx)*(sj4)*(x1447)))+(((cj4)*(npz)))+(((npy)*(x1446))));
evalcond[3]=((((npx)*(x1440)))+(((IkReal(-1.00000000000000))*(cj4)*(npy)*(x1443)))+(((npz)*(sj4))));
evalcond[4]=((((cj5)*(r01)*(sj0)))+(((IkReal(-1.00000000000000))*(r10)*(sj5)*(x1441)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x1441)))+(((sj5)*(x1445))));
evalcond[5]=((((IkReal(-1.00000000000000))*(cj4)*(r21)*(x1443)))+(((r22)*(sj4)))+(((r20)*(x1440))));
evalcond[6]=((((IkReal(-1.00000000000000))*(r00)*(x1438)*(x1447)))+(((r02)*(x1442)))+(((x1438)*(x1448)))+(((cj5)*(r10)*(x1449)))+(((IkReal(-1.00000000000000))*(r11)*(x1441)*(x1446)))+(((IkReal(-1.00000000000000))*(x1439)*(x1444))));
evalcond[7]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(x1439)*(x1449)))+(((x1444)*(x1450)))+(((IkReal(-1.00000000000000))*(r10)*(x1440)*(x1441)))+(((IkReal(-1.00000000000000))*(r01)*(x1442)*(x1443)))+(((x1440)*(x1445)))+(((r02)*(x1438))));
evalcond[8]=((((IkReal(-1.00000000000000))*(r02)*(sj4)*(x1441)))+(((x1444)*(x1448)))+(((IkReal(-1.00000000000000))*(x1438)*(x1439)))+(((IkReal(-1.00000000000000))*(r00)*(x1440)*(x1441)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x1440)))+(((x1442)*(x1450))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst92;
gconst92=IKsign(((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2))))));
dummyeval[0]=((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst93;
gconst93=IKsign((((cj2)*(cj2))+((sj2)*(sj2))));
dummyeval[0]=(((cj2)*(cj2))+((sj2)*(sj2)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x1451=((IkReal(1.00000000000000))*(sj2));
IkReal x1452=((cj5)*(r21));
IkReal x1453=((r20)*(sj5));
IkReal x1454=((IkReal(1.00000000000000))*(cj2));
IkReal x1455=((cj5)*(r11)*(sj0));
IkReal x1456=((r10)*(sj0)*(sj5));
IkReal x1457=((cj0)*(r00)*(sj5));
IkReal x1458=((cj0)*(cj5)*(r01));
if( IKabs(((gconst93)*(((((IkReal(-1.00000000000000))*(x1452)*(x1454)))+(((IkReal(-1.00000000000000))*(x1451)*(x1457)))+(((IkReal(-1.00000000000000))*(x1451)*(x1456)))+(((IkReal(-1.00000000000000))*(x1451)*(x1458)))+(((IkReal(-1.00000000000000))*(x1453)*(x1454)))+(((IkReal(-1.00000000000000))*(x1451)*(x1455))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst93)*(((((cj2)*(x1456)))+(((IkReal(-1.00000000000000))*(x1451)*(x1452)))+(((cj2)*(x1455)))+(((cj2)*(x1458)))+(((IkReal(-1.00000000000000))*(x1451)*(x1453)))+(((cj2)*(x1457))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst93)*(((((IkReal(-1.00000000000000))*(x1452)*(x1454)))+(((IkReal(-1.00000000000000))*(x1451)*(x1457)))+(((IkReal(-1.00000000000000))*(x1451)*(x1456)))+(((IkReal(-1.00000000000000))*(x1451)*(x1458)))+(((IkReal(-1.00000000000000))*(x1453)*(x1454)))+(((IkReal(-1.00000000000000))*(x1451)*(x1455)))))), ((gconst93)*(((((cj2)*(x1456)))+(((IkReal(-1.00000000000000))*(x1451)*(x1452)))+(((cj2)*(x1455)))+(((cj2)*(x1458)))+(((IkReal(-1.00000000000000))*(x1451)*(x1453)))+(((cj2)*(x1457)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x1459=IKsin(j1);
IkReal x1460=IKcos(j1);
IkReal x1461=((cj5)*(sj0));
IkReal x1462=((IkReal(1.00000000000000))*(r11));
IkReal x1463=((cj5)*(sj4));
IkReal x1464=((cj0)*(r00));
IkReal x1465=((IkReal(1.00000000000000))*(sj0));
IkReal x1466=((sj4)*(sj5));
IkReal x1467=((IkReal(1.00000000000000))*(cj0));
IkReal x1468=((sj2)*(x1460));
IkReal x1469=((cj2)*(x1459));
IkReal x1470=((cj2)*(x1460));
IkReal x1471=((sj2)*(x1459));
IkReal x1472=((x1469)+(x1468));
evalcond[0]=((((r20)*(sj5)))+(x1472)+(((cj5)*(r21))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r20)*(x1463)))+(((IkReal(-1.00000000000000))*(x1470)))+(((cj4)*(r22)))+(((r21)*(x1466)))+(x1471));
evalcond[2]=((((IkReal(-1.00000000000000))*(x1461)*(x1462)))+(((IkReal(-1.00000000000000))*(sj5)*(x1464)))+(((IkReal(-1.00000000000000))*(r10)*(sj5)*(x1465)))+(((IkReal(-1.00000000000000))*(x1471)))+(x1470)+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(x1467))));
evalcond[3]=((((r10)*(sj4)*(x1461)))+(((IkReal(-1.00000000000000))*(cj4)*(r02)*(x1467)))+(((x1463)*(x1464)))+(((IkReal(-1.00000000000000))*(sj0)*(x1462)*(x1466)))+(((IkReal(-1.00000000000000))*(r01)*(x1466)*(x1467)))+(((IkReal(-1.00000000000000))*(cj4)*(r12)*(x1465)))+(x1472));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x1473=((cj4)*(r22));
IkReal x1474=((r20)*(sj5));
IkReal x1475=((cj5)*(r21));
IkReal x1476=((sj2)*(sj4));
IkReal x1477=((r21)*(sj5));
IkReal x1478=((IkReal(1.00000000000000))*(cj2));
IkReal x1479=((cj5)*(r20));
if( IKabs(((gconst92)*(((((cj2)*(x1475)))+(((IkReal(-1.00000000000000))*(x1476)*(x1479)))+(((sj2)*(x1473)))+(((x1476)*(x1477)))+(((cj2)*(x1474))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst92)*(((((sj2)*(x1474)))+(((IkReal(-1.00000000000000))*(sj4)*(x1477)*(x1478)))+(((IkReal(-1.00000000000000))*(x1473)*(x1478)))+(((cj2)*(sj4)*(x1479)))+(((sj2)*(x1475))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst92)*(((((cj2)*(x1475)))+(((IkReal(-1.00000000000000))*(x1476)*(x1479)))+(((sj2)*(x1473)))+(((x1476)*(x1477)))+(((cj2)*(x1474)))))), ((gconst92)*(((((sj2)*(x1474)))+(((IkReal(-1.00000000000000))*(sj4)*(x1477)*(x1478)))+(((IkReal(-1.00000000000000))*(x1473)*(x1478)))+(((cj2)*(sj4)*(x1479)))+(((sj2)*(x1475)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x1480=IKsin(j1);
IkReal x1481=IKcos(j1);
IkReal x1482=((cj5)*(sj0));
IkReal x1483=((IkReal(1.00000000000000))*(r11));
IkReal x1484=((cj5)*(sj4));
IkReal x1485=((cj0)*(r00));
IkReal x1486=((IkReal(1.00000000000000))*(sj0));
IkReal x1487=((sj4)*(sj5));
IkReal x1488=((IkReal(1.00000000000000))*(cj0));
IkReal x1489=((sj2)*(x1481));
IkReal x1490=((cj2)*(x1480));
IkReal x1491=((cj2)*(x1481));
IkReal x1492=((sj2)*(x1480));
IkReal x1493=((x1489)+(x1490));
evalcond[0]=((x1493)+(((r20)*(sj5)))+(((cj5)*(r21))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r20)*(x1484)))+(((IkReal(-1.00000000000000))*(x1491)))+(x1492)+(((cj4)*(r22)))+(((r21)*(x1487))));
evalcond[2]=((x1491)+(((IkReal(-1.00000000000000))*(x1482)*(x1483)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(x1488)))+(((IkReal(-1.00000000000000))*(x1492)))+(((IkReal(-1.00000000000000))*(r10)*(sj5)*(x1486)))+(((IkReal(-1.00000000000000))*(sj5)*(x1485))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r01)*(x1487)*(x1488)))+(((IkReal(-1.00000000000000))*(sj0)*(x1483)*(x1487)))+(((r10)*(sj4)*(x1482)))+(((IkReal(-1.00000000000000))*(cj4)*(r02)*(x1488)))+(x1493)+(((x1484)*(x1485)))+(((IkReal(-1.00000000000000))*(cj4)*(r12)*(x1486))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
IkReal x1494=((IkReal(1.00000000000000))*(r10));
IkReal x1495=((sj0)*(sj5));
IkReal x1496=((r02)*(sj0));
IkReal x1497=((cj4)*(cj5));
IkReal x1498=((IkReal(1.00000000000000))*(cj4));
IkReal x1499=((cj0)*(r12));
IkReal x1500=((IkReal(1.00000000000000))*(cj0));
IkReal x1501=((cj5)*(r11));
IkReal x1502=((cj5)*(r01));
IkReal x1503=((r00)*(sj0));
IkReal x1504=((npy)*(sj5));
IkReal x1505=((IkReal(1.00000000000000))*(sj4));
IkReal x1506=((cj0)*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(3.14159265358979))+(j3)), IkReal(6.28318530717959))));
evalcond[1]=((IkReal(0.0950000000000000))+(((cj5)*(npy)))+(((npx)*(sj5))));
evalcond[2]=((IkReal(-0.350000000000000))+(((IkReal(-0.350000000000000))*(cj2)))+(((IkReal(-1.00000000000000))*(cj5)*(npx)*(x1505)))+(((cj4)*(npz)))+(((sj4)*(x1504))));
evalcond[3]=((((npx)*(x1497)))+(((IkReal(0.350000000000000))*(sj2)))+(((npz)*(sj4)))+(((IkReal(-1.00000000000000))*(x1498)*(x1504))));
evalcond[4]=((((r20)*(sj5)))+(((cj5)*(r21))));
evalcond[5]=((IkReal(1.00000000000000))+(((sj0)*(x1502)))+(((IkReal(-1.00000000000000))*(x1500)*(x1501)))+(((r00)*(x1495)))+(((IkReal(-1.00000000000000))*(x1494)*(x1506))));
evalcond[6]=((((IkReal(-1.00000000000000))*(x1494)*(x1495)))+(((IkReal(-1.00000000000000))*(x1500)*(x1502)))+(((IkReal(-1.00000000000000))*(r00)*(sj5)*(x1500)))+(((IkReal(-1.00000000000000))*(sj0)*(x1501))));
evalcond[7]=((((IkReal(-1.00000000000000))*(cj5)*(x1503)*(x1505)))+(((cj4)*(x1496)))+(((cj0)*(cj5)*(r10)*(sj4)))+(((r01)*(sj4)*(x1495)))+(((IkReal(-1.00000000000000))*(r11)*(sj4)*(sj5)*(x1500)))+(((IkReal(-1.00000000000000))*(x1498)*(x1499))));
evalcond[8]=((((IkReal(-1.00000000000000))*(cj0)*(x1494)*(x1497)))+(((sj4)*(x1496)))+(((IkReal(-1.00000000000000))*(r01)*(x1495)*(x1498)))+(((IkReal(-1.00000000000000))*(x1499)*(x1505)))+(((x1497)*(x1503)))+(((cj4)*(r11)*(x1506))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst94;
gconst94=IKsign(((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2))))));
dummyeval[0]=((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst95;
gconst95=IKsign(((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2))))));
dummyeval[0]=((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x1507=((cj4)*(r22));
IkReal x1508=((IkReal(1.00000000000000))*(cj2));
IkReal x1509=((sj2)*(sj4));
IkReal x1510=((r21)*(sj5));
IkReal x1511=((IkReal(1.00000000000000))*(sj2));
IkReal x1512=((cj2)*(sj4));
IkReal x1513=((cj5)*(r20));
IkReal x1514=((cj0)*(cj4)*(r02));
IkReal x1515=((cj4)*(r12)*(sj0));
IkReal x1516=((cj5)*(r10)*(sj0));
IkReal x1517=((cj0)*(cj5)*(r00));
IkReal x1518=((cj0)*(r01)*(sj5));
IkReal x1519=((IkReal(1.00000000000000))*(r11)*(sj0)*(sj4)*(sj5));
if( IKabs(((gconst95)*(((((IkReal(-1.00000000000000))*(r11)*(sj0)*(sj4)*(sj5)*(x1508)))+(((IkReal(-1.00000000000000))*(x1508)*(x1514)))+(((x1512)*(x1517)))+(((IkReal(-1.00000000000000))*(sj4)*(x1508)*(x1518)))+(((x1509)*(x1510)))+(((IkReal(-1.00000000000000))*(x1508)*(x1515)))+(((x1512)*(x1516)))+(((sj2)*(x1507)))+(((IkReal(-1.00000000000000))*(x1509)*(x1513))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst95)*(((((x1512)*(x1513)))+(((IkReal(-1.00000000000000))*(x1509)*(x1518)))+(((IkReal(-1.00000000000000))*(x1507)*(x1508)))+(((IkReal(-1.00000000000000))*(x1511)*(x1515)))+(((x1509)*(x1517)))+(((IkReal(-1.00000000000000))*(x1511)*(x1514)))+(((IkReal(-1.00000000000000))*(r11)*(sj0)*(sj5)*(x1509)))+(((x1509)*(x1516)))+(((IkReal(-1.00000000000000))*(sj4)*(x1508)*(x1510))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst95)*(((((IkReal(-1.00000000000000))*(r11)*(sj0)*(sj4)*(sj5)*(x1508)))+(((IkReal(-1.00000000000000))*(x1508)*(x1514)))+(((x1512)*(x1517)))+(((IkReal(-1.00000000000000))*(sj4)*(x1508)*(x1518)))+(((x1509)*(x1510)))+(((IkReal(-1.00000000000000))*(x1508)*(x1515)))+(((x1512)*(x1516)))+(((sj2)*(x1507)))+(((IkReal(-1.00000000000000))*(x1509)*(x1513)))))), ((gconst95)*(((((x1512)*(x1513)))+(((IkReal(-1.00000000000000))*(x1509)*(x1518)))+(((IkReal(-1.00000000000000))*(x1507)*(x1508)))+(((IkReal(-1.00000000000000))*(x1511)*(x1515)))+(((x1509)*(x1517)))+(((IkReal(-1.00000000000000))*(x1511)*(x1514)))+(((IkReal(-1.00000000000000))*(r11)*(sj0)*(sj5)*(x1509)))+(((x1509)*(x1516)))+(((IkReal(-1.00000000000000))*(sj4)*(x1508)*(x1510)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x1520=IKcos(j1);
IkReal x1521=IKsin(j1);
IkReal x1522=((IkReal(1.00000000000000))*(sj4));
IkReal x1523=((cj5)*(r00));
IkReal x1524=((cj5)*(r20));
IkReal x1525=((r12)*(sj0));
IkReal x1526=((r21)*(sj5));
IkReal x1527=((IkReal(1.00000000000000))*(cj4));
IkReal x1528=((sj2)*(x1520));
IkReal x1529=((cj2)*(x1521));
IkReal x1530=((cj2)*(x1520));
IkReal x1531=((r11)*(sj0)*(sj5));
IkReal x1532=((cj0)*(x1527));
IkReal x1533=((cj0)*(r01)*(sj5));
IkReal x1534=((cj5)*(r10)*(sj0));
IkReal x1535=((sj2)*(x1521));
IkReal x1536=((x1528)+(x1529));
evalcond[0]=((((IkReal(-1.00000000000000))*(x1522)*(x1524)))+(((IkReal(-1.00000000000000))*(x1530)))+(((cj4)*(r22)))+(((sj4)*(x1526)))+(x1535));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1526)*(x1527)))+(((cj4)*(x1524)))+(((r22)*(sj4)))+(x1536));
evalcond[2]=((((IkReal(-1.00000000000000))*(x1522)*(x1531)))+(((IkReal(-1.00000000000000))*(r02)*(x1532)))+(((IkReal(-1.00000000000000))*(x1522)*(x1533)))+(((cj0)*(sj4)*(x1523)))+(((sj4)*(x1534)))+(x1536)+(((IkReal(-1.00000000000000))*(x1525)*(x1527))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x1535)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x1522)))+(((cj4)*(x1531)))+(((IkReal(-1.00000000000000))*(x1522)*(x1525)))+(((cj4)*(x1533)))+(((IkReal(-1.00000000000000))*(x1527)*(x1534)))+(((IkReal(-1.00000000000000))*(x1523)*(x1532)))+(x1530));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x1537=((cj4)*(r22));
IkReal x1538=((cj2)*(sj4));
IkReal x1539=((sj2)*(sj4));
IkReal x1540=((r21)*(sj5));
IkReal x1541=((cj5)*(r20));
IkReal x1542=((cj4)*(sj2));
IkReal x1543=((IkReal(1.00000000000000))*(cj2)*(x1540));
if( IKabs(((gconst94)*(((((r22)*(x1538)))+(((IkReal(-1.00000000000000))*(x1539)*(x1541)))+(((cj2)*(cj4)*(x1541)))+(((x1539)*(x1540)))+(((IkReal(-1.00000000000000))*(cj4)*(x1543)))+(((sj2)*(x1537))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst94)*(((((IkReal(-1.00000000000000))*(cj2)*(x1537)))+(((r22)*(x1539)))+(((IkReal(-1.00000000000000))*(x1540)*(x1542)))+(((IkReal(-1.00000000000000))*(x1538)*(x1540)))+(((x1541)*(x1542)))+(((x1538)*(x1541))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst94)*(((((r22)*(x1538)))+(((IkReal(-1.00000000000000))*(x1539)*(x1541)))+(((cj2)*(cj4)*(x1541)))+(((x1539)*(x1540)))+(((IkReal(-1.00000000000000))*(cj4)*(x1543)))+(((sj2)*(x1537)))))), ((gconst94)*(((((IkReal(-1.00000000000000))*(cj2)*(x1537)))+(((r22)*(x1539)))+(((IkReal(-1.00000000000000))*(x1540)*(x1542)))+(((IkReal(-1.00000000000000))*(x1538)*(x1540)))+(((x1541)*(x1542)))+(((x1538)*(x1541)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x1544=IKcos(j1);
IkReal x1545=IKsin(j1);
IkReal x1546=((IkReal(1.00000000000000))*(sj4));
IkReal x1547=((cj5)*(r00));
IkReal x1548=((cj5)*(r20));
IkReal x1549=((r12)*(sj0));
IkReal x1550=((r21)*(sj5));
IkReal x1551=((IkReal(1.00000000000000))*(cj4));
IkReal x1552=((sj2)*(x1544));
IkReal x1553=((cj2)*(x1545));
IkReal x1554=((cj2)*(x1544));
IkReal x1555=((r11)*(sj0)*(sj5));
IkReal x1556=((cj0)*(x1551));
IkReal x1557=((cj0)*(r01)*(sj5));
IkReal x1558=((cj5)*(r10)*(sj0));
IkReal x1559=((sj2)*(x1545));
IkReal x1560=((x1553)+(x1552));
evalcond[0]=((x1559)+(((cj4)*(r22)))+(((sj4)*(x1550)))+(((IkReal(-1.00000000000000))*(x1546)*(x1548)))+(((IkReal(-1.00000000000000))*(x1554))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1550)*(x1551)))+(((cj4)*(x1548)))+(((r22)*(sj4)))+(x1560));
evalcond[2]=((((IkReal(-1.00000000000000))*(x1546)*(x1557)))+(((IkReal(-1.00000000000000))*(x1546)*(x1555)))+(((sj4)*(x1558)))+(x1560)+(((IkReal(-1.00000000000000))*(r02)*(x1556)))+(((cj0)*(sj4)*(x1547)))+(((IkReal(-1.00000000000000))*(x1549)*(x1551))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x1551)*(x1558)))+(((IkReal(-1.00000000000000))*(x1559)))+(((IkReal(-1.00000000000000))*(x1546)*(x1549)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x1546)))+(x1554)+(((cj4)*(x1557)))+(((IkReal(-1.00000000000000))*(x1547)*(x1556)))+(((cj4)*(x1555))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
IkReal x1561=((IkReal(1.00000000000000))*(r10));
IkReal x1562=((sj0)*(sj5));
IkReal x1563=((r02)*(sj0));
IkReal x1564=((cj4)*(cj5));
IkReal x1565=((IkReal(1.00000000000000))*(cj4));
IkReal x1566=((cj0)*(r12));
IkReal x1567=((IkReal(1.00000000000000))*(cj0));
IkReal x1568=((cj5)*(r11));
IkReal x1569=((cj5)*(r01));
IkReal x1570=((r00)*(sj0));
IkReal x1571=((npy)*(sj5));
IkReal x1572=((IkReal(1.00000000000000))*(sj4));
IkReal x1573=((cj0)*(sj5));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(j3, IkReal(6.28318530717959))));
evalcond[1]=((IkReal(0.0950000000000000))+(((cj5)*(npy)))+(((npx)*(sj5))));
evalcond[2]=((IkReal(-0.350000000000000))+(((IkReal(-0.350000000000000))*(cj2)))+(((cj4)*(npz)))+(((sj4)*(x1571)))+(((IkReal(-1.00000000000000))*(cj5)*(npx)*(x1572))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x1565)*(x1571)))+(((npx)*(x1564)))+(((IkReal(-0.350000000000000))*(sj2)))+(((npz)*(sj4))));
evalcond[4]=((((r20)*(sj5)))+(((cj5)*(r21))));
evalcond[5]=((IkReal(-1.00000000000000))+(((r00)*(x1562)))+(((sj0)*(x1569)))+(((IkReal(-1.00000000000000))*(x1561)*(x1573)))+(((IkReal(-1.00000000000000))*(x1567)*(x1568))));
evalcond[6]=((((IkReal(-1.00000000000000))*(x1561)*(x1562)))+(((IkReal(-1.00000000000000))*(r00)*(sj5)*(x1567)))+(((IkReal(-1.00000000000000))*(x1567)*(x1569)))+(((IkReal(-1.00000000000000))*(sj0)*(x1568))));
evalcond[7]=((((IkReal(-1.00000000000000))*(r11)*(sj4)*(sj5)*(x1567)))+(((IkReal(-1.00000000000000))*(cj5)*(x1570)*(x1572)))+(((r01)*(sj4)*(x1562)))+(((cj4)*(x1563)))+(((IkReal(-1.00000000000000))*(x1565)*(x1566)))+(((cj0)*(cj5)*(r10)*(sj4))));
evalcond[8]=((((x1564)*(x1570)))+(((sj4)*(x1563)))+(((cj4)*(r11)*(x1573)))+(((IkReal(-1.00000000000000))*(x1566)*(x1572)))+(((IkReal(-1.00000000000000))*(r01)*(x1562)*(x1565)))+(((IkReal(-1.00000000000000))*(cj0)*(x1561)*(x1564))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst96;
gconst96=IKsign((((cj2)*(cj2))+((sj2)*(sj2))));
dummyeval[0]=(((cj2)*(cj2))+((sj2)*(sj2)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst97;
gconst97=IKsign(((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2))))));
dummyeval[0]=((((IkReal(-1.00000000000000))*((sj2)*(sj2))))+(((IkReal(-1.00000000000000))*((cj2)*(cj2)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x1574=((cj4)*(r22));
IkReal x1575=((IkReal(1.00000000000000))*(cj2));
IkReal x1576=((sj2)*(sj4));
IkReal x1577=((r21)*(sj5));
IkReal x1578=((cj2)*(sj4));
IkReal x1579=((cj5)*(r20));
IkReal x1580=((IkReal(1.00000000000000))*(sj2));
IkReal x1581=((cj0)*(cj4)*(r02));
IkReal x1582=((cj5)*(r10)*(sj0));
IkReal x1583=((cj4)*(r12)*(sj0));
IkReal x1584=((cj0)*(cj5)*(r00));
IkReal x1585=((cj0)*(r01)*(sj5));
IkReal x1586=((IkReal(1.00000000000000))*(r11)*(sj0)*(sj4)*(sj5));
if( IKabs(((gconst97)*(((((sj2)*(x1574)))+(((IkReal(-1.00000000000000))*(r11)*(sj0)*(sj4)*(sj5)*(x1575)))+(((x1576)*(x1577)))+(((x1578)*(x1582)))+(((x1578)*(x1584)))+(((IkReal(-1.00000000000000))*(x1575)*(x1583)))+(((IkReal(-1.00000000000000))*(sj4)*(x1575)*(x1585)))+(((IkReal(-1.00000000000000))*(x1575)*(x1581)))+(((IkReal(-1.00000000000000))*(x1576)*(x1579))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst97)*(((((IkReal(-1.00000000000000))*(x1580)*(x1583)))+(((x1576)*(x1584)))+(((IkReal(-1.00000000000000))*(r11)*(sj0)*(sj5)*(x1576)))+(((IkReal(-1.00000000000000))*(x1574)*(x1575)))+(((IkReal(-1.00000000000000))*(sj4)*(x1575)*(x1577)))+(((IkReal(-1.00000000000000))*(x1580)*(x1581)))+(((x1578)*(x1579)))+(((IkReal(-1.00000000000000))*(x1576)*(x1585)))+(((x1576)*(x1582))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst97)*(((((sj2)*(x1574)))+(((IkReal(-1.00000000000000))*(r11)*(sj0)*(sj4)*(sj5)*(x1575)))+(((x1576)*(x1577)))+(((x1578)*(x1582)))+(((x1578)*(x1584)))+(((IkReal(-1.00000000000000))*(x1575)*(x1583)))+(((IkReal(-1.00000000000000))*(sj4)*(x1575)*(x1585)))+(((IkReal(-1.00000000000000))*(x1575)*(x1581)))+(((IkReal(-1.00000000000000))*(x1576)*(x1579)))))), ((gconst97)*(((((IkReal(-1.00000000000000))*(x1580)*(x1583)))+(((x1576)*(x1584)))+(((IkReal(-1.00000000000000))*(r11)*(sj0)*(sj5)*(x1576)))+(((IkReal(-1.00000000000000))*(x1574)*(x1575)))+(((IkReal(-1.00000000000000))*(sj4)*(x1575)*(x1577)))+(((IkReal(-1.00000000000000))*(x1580)*(x1581)))+(((x1578)*(x1579)))+(((IkReal(-1.00000000000000))*(x1576)*(x1585)))+(((x1576)*(x1582)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x1587=IKcos(j1);
IkReal x1588=IKsin(j1);
IkReal x1589=((IkReal(1.00000000000000))*(sj4));
IkReal x1590=((cj5)*(r00));
IkReal x1591=((cj5)*(r20));
IkReal x1592=((r12)*(sj0));
IkReal x1593=((r21)*(sj5));
IkReal x1594=((IkReal(1.00000000000000))*(cj4));
IkReal x1595=((sj2)*(x1588));
IkReal x1596=((IkReal(1.00000000000000))*(x1587));
IkReal x1597=((r11)*(sj0)*(sj5));
IkReal x1598=((cj0)*(x1594));
IkReal x1599=((cj0)*(r01)*(sj5));
IkReal x1600=((cj2)*(x1588));
IkReal x1601=((cj5)*(r10)*(sj0));
IkReal x1602=((cj2)*(x1596));
evalcond[0]=((((IkReal(-1.00000000000000))*(x1602)))+(x1595)+(((sj4)*(x1593)))+(((IkReal(-1.00000000000000))*(x1589)*(x1591)))+(((cj4)*(r22))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1600)))+(((r22)*(sj4)))+(((IkReal(-1.00000000000000))*(sj2)*(x1596)))+(((cj4)*(x1591)))+(((IkReal(-1.00000000000000))*(x1593)*(x1594))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r02)*(x1598)))+(((IkReal(-1.00000000000000))*(x1589)*(x1597)))+(((IkReal(-1.00000000000000))*(x1589)*(x1599)))+(((sj2)*(x1587)))+(((IkReal(-1.00000000000000))*(x1592)*(x1594)))+(((cj0)*(sj4)*(x1590)))+(((sj4)*(x1601)))+(x1600));
evalcond[3]=((((IkReal(-1.00000000000000))*(x1602)))+(x1595)+(((IkReal(-1.00000000000000))*(x1594)*(x1601)))+(((IkReal(-1.00000000000000))*(x1589)*(x1592)))+(((cj4)*(x1597)))+(((cj4)*(x1599)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x1589)))+(((IkReal(-1.00000000000000))*(x1590)*(x1598))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x1603=((IkReal(1.00000000000000))*(cj2));
IkReal x1604=((cj2)*(cj4));
IkReal x1605=((r21)*(sj5));
IkReal x1606=((cj5)*(r20));
IkReal x1607=((r22)*(sj4));
IkReal x1608=((cj4)*(sj2));
IkReal x1609=((sj4)*(x1606));
IkReal x1610=((IkReal(1.00000000000000))*(sj2)*(x1605));
if( IKabs(((gconst96)*(((((sj2)*(x1609)))+(((x1604)*(x1606)))+(((IkReal(-1.00000000000000))*(r22)*(x1608)))+(((cj2)*(x1607)))+(((IkReal(-1.00000000000000))*(sj4)*(x1610)))+(((IkReal(-1.00000000000000))*(cj4)*(x1603)*(x1605))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst96)*(((((sj2)*(x1607)))+(((IkReal(-1.00000000000000))*(x1605)*(x1608)))+(((cj2)*(sj4)*(x1605)))+(((r22)*(x1604)))+(((x1606)*(x1608)))+(((IkReal(-1.00000000000000))*(x1603)*(x1609))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst96)*(((((sj2)*(x1609)))+(((x1604)*(x1606)))+(((IkReal(-1.00000000000000))*(r22)*(x1608)))+(((cj2)*(x1607)))+(((IkReal(-1.00000000000000))*(sj4)*(x1610)))+(((IkReal(-1.00000000000000))*(cj4)*(x1603)*(x1605)))))), ((gconst96)*(((((sj2)*(x1607)))+(((IkReal(-1.00000000000000))*(x1605)*(x1608)))+(((cj2)*(sj4)*(x1605)))+(((r22)*(x1604)))+(((x1606)*(x1608)))+(((IkReal(-1.00000000000000))*(x1603)*(x1609)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[4];
IkReal x1611=IKcos(j1);
IkReal x1612=IKsin(j1);
IkReal x1613=((IkReal(1.00000000000000))*(sj4));
IkReal x1614=((cj5)*(r00));
IkReal x1615=((cj5)*(r20));
IkReal x1616=((r12)*(sj0));
IkReal x1617=((r21)*(sj5));
IkReal x1618=((IkReal(1.00000000000000))*(cj4));
IkReal x1619=((sj2)*(x1612));
IkReal x1620=((IkReal(1.00000000000000))*(x1611));
IkReal x1621=((r11)*(sj0)*(sj5));
IkReal x1622=((cj0)*(x1618));
IkReal x1623=((cj0)*(r01)*(sj5));
IkReal x1624=((cj2)*(x1612));
IkReal x1625=((cj5)*(r10)*(sj0));
IkReal x1626=((cj2)*(x1620));
evalcond[0]=((((IkReal(-1.00000000000000))*(x1626)))+(x1619)+(((cj4)*(r22)))+(((sj4)*(x1617)))+(((IkReal(-1.00000000000000))*(x1613)*(x1615))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1624)))+(((IkReal(-1.00000000000000))*(sj2)*(x1620)))+(((r22)*(sj4)))+(((cj4)*(x1615)))+(((IkReal(-1.00000000000000))*(x1617)*(x1618))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x1616)*(x1618)))+(((sj2)*(x1611)))+(x1624)+(((IkReal(-1.00000000000000))*(x1613)*(x1623)))+(((cj0)*(sj4)*(x1614)))+(((sj4)*(x1625)))+(((IkReal(-1.00000000000000))*(r02)*(x1622)))+(((IkReal(-1.00000000000000))*(x1613)*(x1621))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x1626)))+(x1619)+(((IkReal(-1.00000000000000))*(x1613)*(x1616)))+(((IkReal(-1.00000000000000))*(x1614)*(x1622)))+(((IkReal(-1.00000000000000))*(x1618)*(x1625)))+(((IkReal(-1.00000000000000))*(cj0)*(r02)*(x1613)))+(((cj4)*(x1623)))+(((cj4)*(x1621))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}
}
}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x1627=((IkReal(1.00000000000000))*(sj4));
IkReal x1628=((r22)*(sj2));
IkReal x1629=((cj3)*(cj4));
IkReal x1630=((cj2)*(r22));
IkReal x1631=((cj3)*(cj5)*(r20));
IkReal x1632=((cj2)*(r21)*(sj5));
IkReal x1633=((r21)*(sj2)*(sj5));
IkReal x1634=((IkReal(1.00000000000000))*(cj4)*(cj5)*(r20));
if( IKabs(((gconst89)*(((((sj2)*(sj4)*(x1631)))+(((IkReal(-1.00000000000000))*(x1627)*(x1630)))+(((cj4)*(x1632)))+(((IkReal(-1.00000000000000))*(cj2)*(x1634)))+(((IkReal(-1.00000000000000))*(x1628)*(x1629)))+(((IkReal(-1.00000000000000))*(cj3)*(x1627)*(x1633))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst89)*(((((cj3)*(sj4)*(x1632)))+(((IkReal(-1.00000000000000))*(cj2)*(x1627)*(x1631)))+(((cj4)*(x1633)))+(((x1629)*(x1630)))+(((IkReal(-1.00000000000000))*(sj2)*(x1634)))+(((IkReal(-1.00000000000000))*(x1627)*(x1628))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst89)*(((((sj2)*(sj4)*(x1631)))+(((IkReal(-1.00000000000000))*(x1627)*(x1630)))+(((cj4)*(x1632)))+(((IkReal(-1.00000000000000))*(cj2)*(x1634)))+(((IkReal(-1.00000000000000))*(x1628)*(x1629)))+(((IkReal(-1.00000000000000))*(cj3)*(x1627)*(x1633)))))), ((gconst89)*(((((cj3)*(sj4)*(x1632)))+(((IkReal(-1.00000000000000))*(cj2)*(x1627)*(x1631)))+(((cj4)*(x1633)))+(((x1629)*(x1630)))+(((IkReal(-1.00000000000000))*(sj2)*(x1634)))+(((IkReal(-1.00000000000000))*(x1627)*(x1628)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[6];
IkReal x1635=IKsin(j1);
IkReal x1636=IKcos(j1);
IkReal x1637=((IkReal(1.00000000000000))*(sj2));
IkReal x1638=((cj5)*(r00));
IkReal x1639=((cj0)*(sj4));
IkReal x1640=((cj5)*(sj4));
IkReal x1641=((IkReal(1.00000000000000))*(sj5));
IkReal x1642=((r10)*(sj0));
IkReal x1643=((IkReal(1.00000000000000))*(sj0));
IkReal x1644=((cj0)*(r01));
IkReal x1645=((cj4)*(sj5));
IkReal x1646=((IkReal(1.00000000000000))*(cj5));
IkReal x1647=((cj2)*(x1636));
IkReal x1648=((sj0)*(x1641));
IkReal x1649=((cj3)*(x1635));
IkReal x1650=((IkReal(1.00000000000000))*(cj0)*(cj4));
IkReal x1651=((sj3)*(x1635));
IkReal x1652=((sj2)*(x1636));
evalcond[0]=((((IkReal(-1.00000000000000))*(cj2)*(x1651)))+(((IkReal(-1.00000000000000))*(sj3)*(x1636)*(x1637)))+(((r20)*(sj5)))+(((cj5)*(r21))));
evalcond[1]=((((sj2)*(x1635)))+(((IkReal(-1.00000000000000))*(x1647)))+(((cj4)*(r22)))+(((IkReal(-1.00000000000000))*(r20)*(x1640)))+(((r21)*(sj4)*(sj5))));
evalcond[2]=((((cj2)*(x1649)))+(((cj3)*(x1652)))+(((cj4)*(cj5)*(r20)))+(((r22)*(sj4)))+(((IkReal(-1.00000000000000))*(cj4)*(r21)*(x1641))));
evalcond[3]=((((IkReal(-1.00000000000000))*(cj0)*(r00)*(x1641)))+(((IkReal(-1.00000000000000))*(x1644)*(x1646)))+(((IkReal(-1.00000000000000))*(x1641)*(x1642)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x1643)))+(((sj2)*(x1651)))+(((IkReal(-1.00000000000000))*(sj3)*(x1647))));
evalcond[4]=((((x1638)*(x1639)))+(((IkReal(-1.00000000000000))*(r11)*(sj4)*(x1648)))+(((x1640)*(x1642)))+(((IkReal(-1.00000000000000))*(cj4)*(r12)*(x1643)))+(((IkReal(-1.00000000000000))*(r01)*(x1639)*(x1641)))+(x1652)+(((cj2)*(x1635)))+(((IkReal(-1.00000000000000))*(r02)*(x1650))));
evalcond[5]=((((IkReal(-1.00000000000000))*(cj4)*(x1642)*(x1646)))+(((IkReal(-1.00000000000000))*(r12)*(sj4)*(x1643)))+(((IkReal(-1.00000000000000))*(r02)*(x1639)))+(((x1644)*(x1645)))+(((cj3)*(x1647)))+(((IkReal(-1.00000000000000))*(x1637)*(x1649)))+(((r11)*(sj0)*(x1645)))+(((IkReal(-1.00000000000000))*(x1638)*(x1650))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x1653=((r20)*(sj5));
IkReal x1654=((cj5)*(r21));
IkReal x1655=((IkReal(1.00000000000000))*(sj2));
IkReal x1656=((cj2)*(sj3));
IkReal x1657=((cj4)*(r22));
IkReal x1658=((cj5)*(r20)*(sj4));
IkReal x1659=((r21)*(sj3)*(sj4)*(sj5));
if( IKabs(((gconst88)*(((((IkReal(-1.00000000000000))*(x1655)*(x1659)))+(((cj2)*(x1654)))+(((sj2)*(sj3)*(x1658)))+(((IkReal(-1.00000000000000))*(sj3)*(x1655)*(x1657)))+(((cj2)*(x1653))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst88)*(((((r21)*(sj4)*(sj5)*(x1656)))+(((IkReal(-1.00000000000000))*(x1656)*(x1658)))+(((x1656)*(x1657)))+(((sj2)*(x1654)))+(((sj2)*(x1653))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst88)*(((((IkReal(-1.00000000000000))*(x1655)*(x1659)))+(((cj2)*(x1654)))+(((sj2)*(sj3)*(x1658)))+(((IkReal(-1.00000000000000))*(sj3)*(x1655)*(x1657)))+(((cj2)*(x1653)))))), ((gconst88)*(((((r21)*(sj4)*(sj5)*(x1656)))+(((IkReal(-1.00000000000000))*(x1656)*(x1658)))+(((x1656)*(x1657)))+(((sj2)*(x1654)))+(((sj2)*(x1653)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[6];
IkReal x1660=IKsin(j1);
IkReal x1661=IKcos(j1);
IkReal x1662=((IkReal(1.00000000000000))*(sj2));
IkReal x1663=((cj5)*(r00));
IkReal x1664=((cj0)*(sj4));
IkReal x1665=((cj5)*(sj4));
IkReal x1666=((IkReal(1.00000000000000))*(sj5));
IkReal x1667=((r10)*(sj0));
IkReal x1668=((IkReal(1.00000000000000))*(sj0));
IkReal x1669=((cj0)*(r01));
IkReal x1670=((cj4)*(sj5));
IkReal x1671=((IkReal(1.00000000000000))*(cj5));
IkReal x1672=((cj2)*(x1661));
IkReal x1673=((sj0)*(x1666));
IkReal x1674=((cj3)*(x1660));
IkReal x1675=((IkReal(1.00000000000000))*(cj0)*(cj4));
IkReal x1676=((sj3)*(x1660));
IkReal x1677=((sj2)*(x1661));
evalcond[0]=((((IkReal(-1.00000000000000))*(cj2)*(x1676)))+(((IkReal(-1.00000000000000))*(sj3)*(x1661)*(x1662)))+(((r20)*(sj5)))+(((cj5)*(r21))));
evalcond[1]=((((sj2)*(x1660)))+(((IkReal(-1.00000000000000))*(r20)*(x1665)))+(((cj4)*(r22)))+(((IkReal(-1.00000000000000))*(x1672)))+(((r21)*(sj4)*(sj5))));
evalcond[2]=((((cj3)*(x1677)))+(((cj2)*(x1674)))+(((cj4)*(cj5)*(r20)))+(((IkReal(-1.00000000000000))*(cj4)*(r21)*(x1666)))+(((r22)*(sj4))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x1669)*(x1671)))+(((IkReal(-1.00000000000000))*(cj0)*(r00)*(x1666)))+(((sj2)*(x1676)))+(((IkReal(-1.00000000000000))*(x1666)*(x1667)))+(((IkReal(-1.00000000000000))*(sj3)*(x1672)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x1668))));
evalcond[4]=((((cj2)*(x1660)))+(((IkReal(-1.00000000000000))*(cj4)*(r12)*(x1668)))+(x1677)+(((IkReal(-1.00000000000000))*(r11)*(sj4)*(x1673)))+(((x1665)*(x1667)))+(((x1663)*(x1664)))+(((IkReal(-1.00000000000000))*(r01)*(x1664)*(x1666)))+(((IkReal(-1.00000000000000))*(r02)*(x1675))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r02)*(x1664)))+(((r11)*(sj0)*(x1670)))+(((cj3)*(x1672)))+(((IkReal(-1.00000000000000))*(r12)*(sj4)*(x1668)))+(((IkReal(-1.00000000000000))*(x1662)*(x1674)))+(((IkReal(-1.00000000000000))*(cj4)*(x1667)*(x1671)))+(((x1669)*(x1670)))+(((IkReal(-1.00000000000000))*(x1663)*(x1675))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x1678=((IkReal(1.00000000000000))*(sj4));
IkReal x1679=((r22)*(sj2));
IkReal x1680=((cj2)*(cj4));
IkReal x1681=((r21)*(sj5));
IkReal x1682=((cj4)*(sj2));
IkReal x1683=((cj3)*(cj5)*(r20));
IkReal x1684=((cj3)*(x1681));
IkReal x1685=((IkReal(1.00000000000000))*(cj5)*(r20));
if( IKabs(((gconst87)*(((((IkReal(-1.00000000000000))*(cj2)*(r22)*(x1678)))+(((sj2)*(sj4)*(x1683)))+(((IkReal(-1.00000000000000))*(sj2)*(x1678)*(x1684)))+(((IkReal(-1.00000000000000))*(x1680)*(x1685)))+(((x1680)*(x1681)))+(((IkReal(-1.00000000000000))*(cj3)*(cj4)*(x1679))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst87)*(((((x1681)*(x1682)))+(((cj2)*(sj4)*(x1684)))+(((IkReal(-1.00000000000000))*(x1682)*(x1685)))+(((IkReal(-1.00000000000000))*(cj2)*(x1678)*(x1683)))+(((cj3)*(r22)*(x1680)))+(((IkReal(-1.00000000000000))*(x1678)*(x1679))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst87)*(((((IkReal(-1.00000000000000))*(cj2)*(r22)*(x1678)))+(((sj2)*(sj4)*(x1683)))+(((IkReal(-1.00000000000000))*(sj2)*(x1678)*(x1684)))+(((IkReal(-1.00000000000000))*(x1680)*(x1685)))+(((x1680)*(x1681)))+(((IkReal(-1.00000000000000))*(cj3)*(cj4)*(x1679)))))), ((gconst87)*(((((x1681)*(x1682)))+(((cj2)*(sj4)*(x1684)))+(((IkReal(-1.00000000000000))*(x1682)*(x1685)))+(((IkReal(-1.00000000000000))*(cj2)*(x1678)*(x1683)))+(((cj3)*(r22)*(x1680)))+(((IkReal(-1.00000000000000))*(x1678)*(x1679)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[3];
IkReal x1686=IKsin(j1);
IkReal x1687=IKcos(j1);
IkReal x1688=((IkReal(1.00000000000000))*(cj2));
IkReal x1689=((cj5)*(r20));
IkReal x1690=((r21)*(sj5));
IkReal x1691=((sj2)*(x1687));
evalcond[0]=((((IkReal(-1.00000000000000))*(sj3)*(x1686)*(x1688)))+(((IkReal(-1.00000000000000))*(sj3)*(x1691)))+(((r20)*(sj5)))+(((cj5)*(r21))));
evalcond[1]=((((sj4)*(x1690)))+(((cj4)*(r22)))+(((IkReal(-1.00000000000000))*(sj4)*(x1689)))+(((IkReal(-1.00000000000000))*(x1687)*(x1688)))+(((sj2)*(x1686))));
evalcond[2]=((((IkReal(-1.00000000000000))*(cj4)*(x1690)))+(((cj2)*(cj3)*(x1686)))+(((r22)*(sj4)))+(((cj3)*(x1691)))+(((cj4)*(x1689))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst98;
IkReal x1692=(cj5)*(cj5);
IkReal x1693=(sj5)*(sj5);
IkReal x1694=((IkReal(1.00000000000000))*(r10));
IkReal x1695=((cj4)*(sj5));
IkReal x1696=((r00)*(r11));
IkReal x1697=((cj4)*(cj5));
IkReal x1698=((sj4)*(x1692));
IkReal x1699=((sj4)*(x1693));
gconst98=IKsign(((((IkReal(-1.00000000000000))*(r01)*(x1694)*(x1699)))+(((IkReal(-1.00000000000000))*(r02)*(x1694)*(x1695)))+(((x1696)*(x1698)))+(((IkReal(-1.00000000000000))*(r01)*(x1694)*(x1698)))+(((IkReal(-1.00000000000000))*(r02)*(r11)*(x1697)))+(((r01)*(r12)*(x1697)))+(((r00)*(r12)*(x1695)))+(((x1696)*(x1699)))));
IkReal x1700=(cj5)*(cj5);
IkReal x1701=(sj5)*(sj5);
IkReal x1702=((IkReal(1.00000000000000))*(r10));
IkReal x1703=((cj4)*(sj5));
IkReal x1704=((r00)*(r11));
IkReal x1705=((cj4)*(cj5));
IkReal x1706=((sj4)*(x1700));
IkReal x1707=((sj4)*(x1701));
dummyeval[0]=((((x1704)*(x1706)))+(((r00)*(r12)*(x1703)))+(((IkReal(-1.00000000000000))*(r01)*(x1702)*(x1706)))+(((r01)*(r12)*(x1705)))+(((x1704)*(x1707)))+(((IkReal(-1.00000000000000))*(r02)*(r11)*(x1705)))+(((IkReal(-1.00000000000000))*(r02)*(x1702)*(x1703)))+(((IkReal(-1.00000000000000))*(r01)*(x1702)*(x1707))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst99;
IkReal x1708=(sj5)*(sj5);
IkReal x1709=(cj5)*(cj5);
IkReal x1710=((cj5)*(sj4));
IkReal x1711=((IkReal(1.00000000000000))*(r02));
IkReal x1712=((sj4)*(sj5));
IkReal x1713=((cj4)*(r01)*(r10));
IkReal x1714=((IkReal(1.00000000000000))*(cj4)*(r00)*(r11));
gconst99=IKsign(((((r01)*(r12)*(x1710)))+(((IkReal(-1.00000000000000))*(x1708)*(x1714)))+(((x1708)*(x1713)))+(((IkReal(-1.00000000000000))*(r10)*(x1711)*(x1712)))+(((IkReal(-1.00000000000000))*(x1709)*(x1714)))+(((x1709)*(x1713)))+(((IkReal(-1.00000000000000))*(r11)*(x1710)*(x1711)))+(((r00)*(r12)*(x1712)))));
IkReal x1715=(sj5)*(sj5);
IkReal x1716=(cj5)*(cj5);
IkReal x1717=((cj5)*(sj4));
IkReal x1718=((IkReal(1.00000000000000))*(r02));
IkReal x1719=((sj4)*(sj5));
IkReal x1720=((cj4)*(r01)*(r10));
IkReal x1721=x1714;
dummyeval[0]=((((IkReal(-1.00000000000000))*(x1715)*(x1721)))+(((x1716)*(x1720)))+(((IkReal(-1.00000000000000))*(r10)*(x1718)*(x1719)))+(((r01)*(r12)*(x1717)))+(((x1715)*(x1720)))+(((IkReal(-1.00000000000000))*(x1716)*(x1721)))+(((r00)*(r12)*(x1719)))+(((IkReal(-1.00000000000000))*(r11)*(x1717)*(x1718))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x1722=((IkReal(1.00000000000000))*(cj3));
IkReal x1723=((cj4)*(cj5));
IkReal x1724=((cj5)*(sj3));
IkReal x1725=((sj3)*(sj5));
IkReal x1726=((cj3)*(cj4)*(sj5));
if( IKabs(((gconst99)*(((((r11)*(x1724)))+(((r10)*(x1725)))+(((IkReal(-1.00000000000000))*(r10)*(x1722)*(x1723)))+(((r11)*(x1726)))+(((IkReal(-1.00000000000000))*(r12)*(sj4)*(x1722))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst99)*(((((r00)*(x1725)))+(((r01)*(x1724)))+(((r01)*(x1726)))+(((IkReal(-1.00000000000000))*(r00)*(x1722)*(x1723)))+(((IkReal(-1.00000000000000))*(r02)*(sj4)*(x1722))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst99)*(((((r11)*(x1724)))+(((r10)*(x1725)))+(((IkReal(-1.00000000000000))*(r10)*(x1722)*(x1723)))+(((r11)*(x1726)))+(((IkReal(-1.00000000000000))*(r12)*(sj4)*(x1722)))))), ((gconst99)*(((((r00)*(x1725)))+(((r01)*(x1724)))+(((r01)*(x1726)))+(((IkReal(-1.00000000000000))*(r00)*(x1722)*(x1723)))+(((IkReal(-1.00000000000000))*(r02)*(sj4)*(x1722)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[6];
IkReal x1727=IKsin(j0);
IkReal x1728=IKcos(j0);
IkReal x1729=((cj4)*(r12));
IkReal x1730=((cj1)*(cj2));
IkReal x1731=((IkReal(1.00000000000000))*(sj4));
IkReal x1732=((IkReal(1.00000000000000))*(r10));
IkReal x1733=((r01)*(sj5));
IkReal x1734=((r02)*(sj4));
IkReal x1735=((sj1)*(sj2));
IkReal x1736=((cj5)*(r01));
IkReal x1737=((cj5)*(r00));
IkReal x1738=((r11)*(sj5));
IkReal x1739=((sj5)*(x1727));
IkReal x1740=((IkReal(1.00000000000000))*(x1728));
IkReal x1741=((cj4)*(x1727));
IkReal x1742=((cj5)*(x1727));
IkReal x1743=((cj4)*(x1728));
IkReal x1744=((cj5)*(sj4)*(x1728));
evalcond[0]=((((x1727)*(x1736)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x1740)))+(cj3)+(((r00)*(x1739)))+(((IkReal(-1.00000000000000))*(sj5)*(x1728)*(x1732))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1736)*(x1740)))+(((IkReal(-1.00000000000000))*(r11)*(x1742)))+(((IkReal(-1.00000000000000))*(sj3)*(x1730)))+(((IkReal(-1.00000000000000))*(x1732)*(x1739)))+(((IkReal(-1.00000000000000))*(r00)*(sj5)*(x1740)))+(((sj3)*(x1735))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x1728)*(x1731)*(x1738)))+(((sj4)*(x1727)*(x1733)))+(((IkReal(-1.00000000000000))*(x1729)*(x1740)))+(((r10)*(x1744)))+(((IkReal(-1.00000000000000))*(x1727)*(x1731)*(x1737)))+(((r02)*(x1741))));
evalcond[3]=((((x1737)*(x1741)))+(sj3)+(((IkReal(-1.00000000000000))*(x1733)*(x1741)))+(((IkReal(-1.00000000000000))*(r12)*(x1728)*(x1731)))+(((x1727)*(x1734)))+(((x1738)*(x1743)))+(((IkReal(-1.00000000000000))*(cj5)*(x1732)*(x1743))));
evalcond[4]=((((cj1)*(sj2)))+(((IkReal(-1.00000000000000))*(x1728)*(x1731)*(x1733)))+(((sj4)*(x1728)*(x1737)))+(((IkReal(-1.00000000000000))*(cj4)*(r02)*(x1740)))+(((IkReal(-1.00000000000000))*(x1727)*(x1731)*(x1738)))+(((r10)*(sj4)*(x1742)))+(((cj2)*(sj1)))+(((IkReal(-1.00000000000000))*(x1727)*(x1729))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r12)*(x1727)*(x1731)))+(((IkReal(-1.00000000000000))*(r02)*(x1728)*(x1731)))+(((IkReal(-1.00000000000000))*(cj4)*(x1737)*(x1740)))+(((x1738)*(x1741)))+(((IkReal(-1.00000000000000))*(cj3)*(x1735)))+(((IkReal(-1.00000000000000))*(cj5)*(x1732)*(x1741)))+(((cj3)*(x1730)))+(((x1733)*(x1743))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x1745=((cj3)*(sj4));
IkReal x1746=((IkReal(1.00000000000000))*(sj5));
IkReal x1747=((IkReal(1.00000000000000))*(cj3)*(cj4));
if( IKabs(((gconst98)*(((((IkReal(-1.00000000000000))*(r12)*(x1747)))+(((cj5)*(r10)*(x1745)))+(((IkReal(-1.00000000000000))*(r11)*(x1745)*(x1746))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst98)*(((((IkReal(-1.00000000000000))*(r01)*(x1745)*(x1746)))+(((cj5)*(r00)*(x1745)))+(((IkReal(-1.00000000000000))*(r02)*(x1747))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst98)*(((((IkReal(-1.00000000000000))*(r12)*(x1747)))+(((cj5)*(r10)*(x1745)))+(((IkReal(-1.00000000000000))*(r11)*(x1745)*(x1746)))))), ((gconst98)*(((((IkReal(-1.00000000000000))*(r01)*(x1745)*(x1746)))+(((cj5)*(r00)*(x1745)))+(((IkReal(-1.00000000000000))*(r02)*(x1747)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[6];
IkReal x1748=IKsin(j0);
IkReal x1749=IKcos(j0);
IkReal x1750=((cj4)*(r12));
IkReal x1751=((cj1)*(cj2));
IkReal x1752=((IkReal(1.00000000000000))*(sj4));
IkReal x1753=((IkReal(1.00000000000000))*(r10));
IkReal x1754=((r01)*(sj5));
IkReal x1755=((r02)*(sj4));
IkReal x1756=((sj1)*(sj2));
IkReal x1757=((cj5)*(r01));
IkReal x1758=((cj5)*(r00));
IkReal x1759=((r11)*(sj5));
IkReal x1760=((sj5)*(x1748));
IkReal x1761=((IkReal(1.00000000000000))*(x1749));
IkReal x1762=((cj4)*(x1748));
IkReal x1763=((cj5)*(x1748));
IkReal x1764=((cj4)*(x1749));
IkReal x1765=((cj5)*(sj4)*(x1749));
evalcond[0]=((((x1748)*(x1757)))+(((r00)*(x1760)))+(cj3)+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x1761)))+(((IkReal(-1.00000000000000))*(sj5)*(x1749)*(x1753))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r00)*(sj5)*(x1761)))+(((sj3)*(x1756)))+(((IkReal(-1.00000000000000))*(r11)*(x1763)))+(((IkReal(-1.00000000000000))*(sj3)*(x1751)))+(((IkReal(-1.00000000000000))*(x1753)*(x1760)))+(((IkReal(-1.00000000000000))*(x1757)*(x1761))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x1748)*(x1752)*(x1758)))+(((IkReal(-1.00000000000000))*(x1749)*(x1752)*(x1759)))+(((sj4)*(x1748)*(x1754)))+(((r10)*(x1765)))+(((IkReal(-1.00000000000000))*(x1750)*(x1761)))+(((r02)*(x1762))));
evalcond[3]=((((x1759)*(x1764)))+(((x1758)*(x1762)))+(((x1748)*(x1755)))+(sj3)+(((IkReal(-1.00000000000000))*(r12)*(x1749)*(x1752)))+(((IkReal(-1.00000000000000))*(x1754)*(x1762)))+(((IkReal(-1.00000000000000))*(cj5)*(x1753)*(x1764))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x1748)*(x1750)))+(((cj1)*(sj2)))+(((IkReal(-1.00000000000000))*(x1748)*(x1752)*(x1759)))+(((IkReal(-1.00000000000000))*(cj4)*(r02)*(x1761)))+(((sj4)*(x1749)*(x1758)))+(((r10)*(sj4)*(x1763)))+(((cj2)*(sj1)))+(((IkReal(-1.00000000000000))*(x1749)*(x1752)*(x1754))));
evalcond[5]=((((x1754)*(x1764)))+(((IkReal(-1.00000000000000))*(r02)*(x1749)*(x1752)))+(((x1759)*(x1762)))+(((IkReal(-1.00000000000000))*(r12)*(x1748)*(x1752)))+(((IkReal(-1.00000000000000))*(cj5)*(x1753)*(x1762)))+(((IkReal(-1.00000000000000))*(cj4)*(x1758)*(x1761)))+(((cj3)*(x1751)))+(((IkReal(-1.00000000000000))*(cj3)*(x1756))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x1766=((cj2)*(sj5));
IkReal x1767=((cj5)*(r21));
IkReal x1768=((cj2)*(sj3));
IkReal x1769=((cj4)*(r22));
IkReal x1770=((sj2)*(sj5));
IkReal x1771=((sj2)*(sj3));
IkReal x1772=((r21)*(sj3)*(sj4));
IkReal x1773=((cj5)*(r20)*(sj4));
if( IKabs(((gconst86)*(((((x1771)*(x1773)))+(((IkReal(-1.00000000000000))*(x1769)*(x1771)))+(((cj2)*(x1767)))+(((r20)*(x1766)))+(((IkReal(-1.00000000000000))*(x1770)*(x1772))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst86)*(((((r20)*(x1770)))+(((IkReal(-1.00000000000000))*(x1768)*(x1773)))+(((x1768)*(x1769)))+(((sj2)*(x1767)))+(((x1766)*(x1772))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst86)*(((((x1771)*(x1773)))+(((IkReal(-1.00000000000000))*(x1769)*(x1771)))+(((cj2)*(x1767)))+(((r20)*(x1766)))+(((IkReal(-1.00000000000000))*(x1770)*(x1772)))))), ((gconst86)*(((((r20)*(x1770)))+(((IkReal(-1.00000000000000))*(x1768)*(x1773)))+(((x1768)*(x1769)))+(((sj2)*(x1767)))+(((x1766)*(x1772)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[3];
IkReal x1774=IKsin(j1);
IkReal x1775=IKcos(j1);
IkReal x1776=((IkReal(1.00000000000000))*(cj2));
IkReal x1777=((cj5)*(r20));
IkReal x1778=((r21)*(sj5));
IkReal x1779=((sj2)*(x1775));
evalcond[0]=((((IkReal(-1.00000000000000))*(sj3)*(x1779)))+(((r20)*(sj5)))+(((IkReal(-1.00000000000000))*(sj3)*(x1774)*(x1776)))+(((cj5)*(r21))));
evalcond[1]=((((IkReal(-1.00000000000000))*(sj4)*(x1777)))+(((IkReal(-1.00000000000000))*(x1775)*(x1776)))+(((sj2)*(x1774)))+(((cj4)*(r22)))+(((sj4)*(x1778))));
evalcond[2]=((((r22)*(sj4)))+(((cj2)*(cj3)*(x1774)))+(((cj3)*(x1779)))+(((cj4)*(x1777)))+(((IkReal(-1.00000000000000))*(cj4)*(x1778))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst98;
IkReal x1780=(cj5)*(cj5);
IkReal x1781=(sj5)*(sj5);
IkReal x1782=((IkReal(1.00000000000000))*(r10));
IkReal x1783=((cj4)*(sj5));
IkReal x1784=((r00)*(r11));
IkReal x1785=((cj4)*(cj5));
IkReal x1786=((sj4)*(x1780));
IkReal x1787=((sj4)*(x1781));
gconst98=IKsign(((((x1784)*(x1786)))+(((r00)*(r12)*(x1783)))+(((IkReal(-1.00000000000000))*(r02)*(x1782)*(x1783)))+(((IkReal(-1.00000000000000))*(r01)*(x1782)*(x1786)))+(((IkReal(-1.00000000000000))*(r02)*(r11)*(x1785)))+(((IkReal(-1.00000000000000))*(r01)*(x1782)*(x1787)))+(((r01)*(r12)*(x1785)))+(((x1784)*(x1787)))));
IkReal x1788=(cj5)*(cj5);
IkReal x1789=(sj5)*(sj5);
IkReal x1790=((IkReal(1.00000000000000))*(r10));
IkReal x1791=((cj4)*(sj5));
IkReal x1792=((r00)*(r11));
IkReal x1793=((cj4)*(cj5));
IkReal x1794=((sj4)*(x1788));
IkReal x1795=((sj4)*(x1789));
dummyeval[0]=((((IkReal(-1.00000000000000))*(r02)*(x1790)*(x1791)))+(((x1792)*(x1794)))+(((IkReal(-1.00000000000000))*(r01)*(x1790)*(x1794)))+(((IkReal(-1.00000000000000))*(r01)*(x1790)*(x1795)))+(((r01)*(r12)*(x1793)))+(((x1792)*(x1795)))+(((IkReal(-1.00000000000000))*(r02)*(r11)*(x1793)))+(((r00)*(r12)*(x1791))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst99;
IkReal x1796=(sj5)*(sj5);
IkReal x1797=(cj5)*(cj5);
IkReal x1798=((cj5)*(sj4));
IkReal x1799=((IkReal(1.00000000000000))*(r02));
IkReal x1800=((sj4)*(sj5));
IkReal x1801=((cj4)*(r01)*(r10));
IkReal x1802=((IkReal(1.00000000000000))*(cj4)*(r00)*(r11));
gconst99=IKsign(((((r00)*(r12)*(x1800)))+(((IkReal(-1.00000000000000))*(r11)*(x1798)*(x1799)))+(((x1796)*(x1801)))+(((IkReal(-1.00000000000000))*(x1797)*(x1802)))+(((x1797)*(x1801)))+(((IkReal(-1.00000000000000))*(r10)*(x1799)*(x1800)))+(((IkReal(-1.00000000000000))*(x1796)*(x1802)))+(((r01)*(r12)*(x1798)))));
IkReal x1803=(sj5)*(sj5);
IkReal x1804=(cj5)*(cj5);
IkReal x1805=((cj5)*(sj4));
IkReal x1806=((IkReal(1.00000000000000))*(r02));
IkReal x1807=((sj4)*(sj5));
IkReal x1808=((cj4)*(r01)*(r10));
IkReal x1809=x1802;
dummyeval[0]=((((x1803)*(x1808)))+(((r00)*(r12)*(x1807)))+(((IkReal(-1.00000000000000))*(r10)*(x1806)*(x1807)))+(((IkReal(-1.00000000000000))*(x1803)*(x1809)))+(((x1804)*(x1808)))+(((r01)*(r12)*(x1805)))+(((IkReal(-1.00000000000000))*(r11)*(x1805)*(x1806)))+(((IkReal(-1.00000000000000))*(x1804)*(x1809))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x1810=((IkReal(1.00000000000000))*(cj3));
IkReal x1811=((cj4)*(cj5));
IkReal x1812=((cj5)*(sj3));
IkReal x1813=((sj3)*(sj5));
IkReal x1814=((cj3)*(cj4)*(sj5));
if( IKabs(((gconst99)*(((((r11)*(x1812)))+(((IkReal(-1.00000000000000))*(r12)*(sj4)*(x1810)))+(((r11)*(x1814)))+(((r10)*(x1813)))+(((IkReal(-1.00000000000000))*(r10)*(x1810)*(x1811))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst99)*(((((r01)*(x1814)))+(((IkReal(-1.00000000000000))*(r00)*(x1810)*(x1811)))+(((IkReal(-1.00000000000000))*(r02)*(sj4)*(x1810)))+(((r00)*(x1813)))+(((r01)*(x1812))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst99)*(((((r11)*(x1812)))+(((IkReal(-1.00000000000000))*(r12)*(sj4)*(x1810)))+(((r11)*(x1814)))+(((r10)*(x1813)))+(((IkReal(-1.00000000000000))*(r10)*(x1810)*(x1811)))))), ((gconst99)*(((((r01)*(x1814)))+(((IkReal(-1.00000000000000))*(r00)*(x1810)*(x1811)))+(((IkReal(-1.00000000000000))*(r02)*(sj4)*(x1810)))+(((r00)*(x1813)))+(((r01)*(x1812)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[6];
IkReal x1815=IKsin(j0);
IkReal x1816=IKcos(j0);
IkReal x1817=((cj4)*(r12));
IkReal x1818=((cj1)*(cj2));
IkReal x1819=((IkReal(1.00000000000000))*(sj4));
IkReal x1820=((IkReal(1.00000000000000))*(r10));
IkReal x1821=((r01)*(sj5));
IkReal x1822=((r02)*(sj4));
IkReal x1823=((sj1)*(sj2));
IkReal x1824=((cj5)*(r01));
IkReal x1825=((cj5)*(r00));
IkReal x1826=((r11)*(sj5));
IkReal x1827=((sj5)*(x1815));
IkReal x1828=((IkReal(1.00000000000000))*(x1816));
IkReal x1829=((cj4)*(x1815));
IkReal x1830=((cj5)*(x1815));
IkReal x1831=((cj4)*(x1816));
IkReal x1832=((cj5)*(sj4)*(x1816));
evalcond[0]=((((IkReal(-1.00000000000000))*(cj5)*(r11)*(x1828)))+(cj3)+(((x1815)*(x1824)))+(((IkReal(-1.00000000000000))*(sj5)*(x1816)*(x1820)))+(((r00)*(x1827))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1824)*(x1828)))+(((IkReal(-1.00000000000000))*(r11)*(x1830)))+(((sj3)*(x1823)))+(((IkReal(-1.00000000000000))*(sj3)*(x1818)))+(((IkReal(-1.00000000000000))*(x1820)*(x1827)))+(((IkReal(-1.00000000000000))*(r00)*(sj5)*(x1828))));
evalcond[2]=((((sj4)*(x1815)*(x1821)))+(((IkReal(-1.00000000000000))*(x1817)*(x1828)))+(((r10)*(x1832)))+(((IkReal(-1.00000000000000))*(x1816)*(x1819)*(x1826)))+(((r02)*(x1829)))+(((IkReal(-1.00000000000000))*(x1815)*(x1819)*(x1825))));
evalcond[3]=((((IkReal(-1.00000000000000))*(r12)*(x1816)*(x1819)))+(sj3)+(((x1815)*(x1822)))+(((IkReal(-1.00000000000000))*(cj5)*(x1820)*(x1831)))+(((IkReal(-1.00000000000000))*(x1821)*(x1829)))+(((x1826)*(x1831)))+(((x1825)*(x1829))));
evalcond[4]=((((IkReal(-1.00000000000000))*(cj4)*(r02)*(x1828)))+(((cj1)*(sj2)))+(((IkReal(-1.00000000000000))*(x1815)*(x1819)*(x1826)))+(((r10)*(sj4)*(x1830)))+(((IkReal(-1.00000000000000))*(x1816)*(x1819)*(x1821)))+(((sj4)*(x1816)*(x1825)))+(((IkReal(-1.00000000000000))*(x1815)*(x1817)))+(((cj2)*(sj1))));
evalcond[5]=((((cj3)*(x1818)))+(((IkReal(-1.00000000000000))*(cj4)*(x1825)*(x1828)))+(((x1826)*(x1829)))+(((IkReal(-1.00000000000000))*(r12)*(x1815)*(x1819)))+(((x1821)*(x1831)))+(((IkReal(-1.00000000000000))*(cj3)*(x1823)))+(((IkReal(-1.00000000000000))*(r02)*(x1816)*(x1819)))+(((IkReal(-1.00000000000000))*(cj5)*(x1820)*(x1829))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x1833=((cj3)*(sj4));
IkReal x1834=((IkReal(1.00000000000000))*(sj5));
IkReal x1835=((IkReal(1.00000000000000))*(cj3)*(cj4));
if( IKabs(((gconst98)*(((((IkReal(-1.00000000000000))*(r12)*(x1835)))+(((IkReal(-1.00000000000000))*(r11)*(x1833)*(x1834)))+(((cj5)*(r10)*(x1833))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst98)*(((((IkReal(-1.00000000000000))*(r02)*(x1835)))+(((IkReal(-1.00000000000000))*(r01)*(x1833)*(x1834)))+(((cj5)*(r00)*(x1833))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst98)*(((((IkReal(-1.00000000000000))*(r12)*(x1835)))+(((IkReal(-1.00000000000000))*(r11)*(x1833)*(x1834)))+(((cj5)*(r10)*(x1833)))))), ((gconst98)*(((((IkReal(-1.00000000000000))*(r02)*(x1835)))+(((IkReal(-1.00000000000000))*(r01)*(x1833)*(x1834)))+(((cj5)*(r00)*(x1833)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[6];
IkReal x1836=IKsin(j0);
IkReal x1837=IKcos(j0);
IkReal x1838=((cj4)*(r12));
IkReal x1839=((cj1)*(cj2));
IkReal x1840=((IkReal(1.00000000000000))*(sj4));
IkReal x1841=((IkReal(1.00000000000000))*(r10));
IkReal x1842=((r01)*(sj5));
IkReal x1843=((r02)*(sj4));
IkReal x1844=((sj1)*(sj2));
IkReal x1845=((cj5)*(r01));
IkReal x1846=((cj5)*(r00));
IkReal x1847=((r11)*(sj5));
IkReal x1848=((sj5)*(x1836));
IkReal x1849=((IkReal(1.00000000000000))*(x1837));
IkReal x1850=((cj4)*(x1836));
IkReal x1851=((cj5)*(x1836));
IkReal x1852=((cj4)*(x1837));
IkReal x1853=((cj5)*(sj4)*(x1837));
evalcond[0]=((((r00)*(x1848)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x1849)))+(((IkReal(-1.00000000000000))*(sj5)*(x1837)*(x1841)))+(cj3)+(((x1836)*(x1845))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1845)*(x1849)))+(((IkReal(-1.00000000000000))*(r00)*(sj5)*(x1849)))+(((sj3)*(x1844)))+(((IkReal(-1.00000000000000))*(sj3)*(x1839)))+(((IkReal(-1.00000000000000))*(r11)*(x1851)))+(((IkReal(-1.00000000000000))*(x1841)*(x1848))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x1837)*(x1840)*(x1847)))+(((IkReal(-1.00000000000000))*(x1838)*(x1849)))+(((r02)*(x1850)))+(((sj4)*(x1836)*(x1842)))+(((IkReal(-1.00000000000000))*(x1836)*(x1840)*(x1846)))+(((r10)*(x1853))));
evalcond[3]=((((x1846)*(x1850)))+(((IkReal(-1.00000000000000))*(x1842)*(x1850)))+(((IkReal(-1.00000000000000))*(r12)*(x1837)*(x1840)))+(sj3)+(((x1847)*(x1852)))+(((x1836)*(x1843)))+(((IkReal(-1.00000000000000))*(cj5)*(x1841)*(x1852))));
evalcond[4]=((((r10)*(sj4)*(x1851)))+(((cj1)*(sj2)))+(((IkReal(-1.00000000000000))*(cj4)*(r02)*(x1849)))+(((sj4)*(x1837)*(x1846)))+(((IkReal(-1.00000000000000))*(x1837)*(x1840)*(x1842)))+(((cj2)*(sj1)))+(((IkReal(-1.00000000000000))*(x1836)*(x1838)))+(((IkReal(-1.00000000000000))*(x1836)*(x1840)*(x1847))));
evalcond[5]=((((IkReal(-1.00000000000000))*(cj4)*(x1846)*(x1849)))+(((IkReal(-1.00000000000000))*(r02)*(x1837)*(x1840)))+(((IkReal(-1.00000000000000))*(r12)*(x1836)*(x1840)))+(((IkReal(-1.00000000000000))*(cj3)*(x1844)))+(((cj3)*(x1839)))+(((x1847)*(x1850)))+(((IkReal(-1.00000000000000))*(cj5)*(x1841)*(x1850)))+(((x1842)*(x1852))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}
}
}

}

}
}
}
}
}

}

}
    }
}
return solutions.GetNumSolutions()>0;
}
static inline void polyroots8(IkReal rawcoeffs[8+1], IkReal rawroots[8], int& numroots)
{
    using std::complex;
    IKFAST_ASSERT(rawcoeffs[0] != 0);
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    const IkReal tolsqrt = sqrt(std::numeric_limits<IkReal>::epsilon());
    complex<IkReal> coeffs[8];
    const int maxsteps = 110;
    for(int i = 0; i < 8; ++i) {
        coeffs[i] = complex<IkReal>(rawcoeffs[i+1]/rawcoeffs[0]);
    }
    complex<IkReal> roots[8];
    IkReal err[8];
    roots[0] = complex<IkReal>(1,0);
    roots[1] = complex<IkReal>(0.4,0.9); // any complex number not a root of unity works
    err[0] = 1.0;
    err[1] = 1.0;
    for(int i = 2; i < 8; ++i) {
        roots[i] = roots[i-1]*roots[1];
        err[i] = 1.0;
    }
    for(int step = 0; step < maxsteps; ++step) {
        bool changed = false;
        for(int i = 0; i < 8; ++i) {
            if ( err[i] >= tol ) {
                changed = true;
                // evaluate
                complex<IkReal> x = roots[i] + coeffs[0];
                for(int j = 1; j < 8; ++j) {
                    x = roots[i] * x + coeffs[j];
                }
                for(int j = 0; j < 8; ++j) {
                    if( i != j ) {
                        if( roots[i] != roots[j] ) {
                            x /= (roots[i] - roots[j]);
                        }
                    }
                }
                roots[i] -= x;
                err[i] = abs(x);
            }
        }
        if( !changed ) {
            break;
        }
    }

    numroots = 0;
    bool visited[8] = {false};
    for(int i = 0; i < 8; ++i) {
        if( !visited[i] ) {
            // might be a multiple root, in which case it will have more error than the other roots
            // find any neighboring roots, and take the average
            complex<IkReal> newroot=roots[i];
            int n = 1;
            for(int j = i+1; j < 8; ++j) {
                if( abs(roots[i]-roots[j]) < 8*tolsqrt ) {
                    newroot += roots[j];
                    n += 1;
                    visited[j] = true;
                }
            }
            if( n > 1 ) {
                newroot /= n;
            }
            // there are still cases where even the mean is not accurate enough, until a better multi-root algorithm is used, need to use the sqrt
            if( IKabs(imag(newroot)) < tolsqrt ) {
                rawroots[numroots++] = real(newroot);
            }
        }
    }
}
};


/// solves the inverse kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API bool ComputeIk(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions) {
IKSolver solver;
return solver.ComputeIk(eetrans,eerot,pfree,solutions);
}

IKFAST_API const char* GetKinematicsHash() { return "<robot:genericrobot - fanuc_m430ia2p (f1cfe1db779d431226bee8068f3d5170)>"; }

IKFAST_API const char* GetIkFastVersion() { return IKFAST_STRINGIZE(IKFAST_VERSION); }

#ifdef IKFAST_NAMESPACE
} // end namespace
#endif

#ifndef IKFAST_NO_MAIN
#include <stdio.h>
#include <stdlib.h>
#ifdef IKFAST_NAMESPACE
using namespace IKFAST_NAMESPACE;
#endif
int main(int argc, char** argv)
{
    if( argc != 12+GetNumFreeParameters()+1 ) {
        printf("\nUsage: ./ik r00 r01 r02 t0 r10 r11 r12 t1 r20 r21 r22 t2 free0 ...\n\n"
               "Returns the ik solutions given the transformation of the end effector specified by\n"
               "a 3x3 rotation R (rXX), and a 3x1 translation (tX).\n"
               "There are %d free parameters that have to be specified.\n\n",GetNumFreeParameters());
        return 1;
    }

    IkSolutionList<IkReal> solutions;
    std::vector<IkReal> vfree(GetNumFreeParameters());
    IkReal eerot[9],eetrans[3];
    eerot[0] = atof(argv[1]); eerot[1] = atof(argv[2]); eerot[2] = atof(argv[3]); eetrans[0] = atof(argv[4]);
    eerot[3] = atof(argv[5]); eerot[4] = atof(argv[6]); eerot[5] = atof(argv[7]); eetrans[1] = atof(argv[8]);
    eerot[6] = atof(argv[9]); eerot[7] = atof(argv[10]); eerot[8] = atof(argv[11]); eetrans[2] = atof(argv[12]);
    for(std::size_t i = 0; i < vfree.size(); ++i)
        vfree[i] = atof(argv[13+i]);
    bool bSuccess = ComputeIk(eetrans, eerot, vfree.size() > 0 ? &vfree[0] : NULL, solutions);

    if( !bSuccess ) {
        fprintf(stderr,"Failed to get ik solution\n");
        return -1;
    }

    printf("Found %d ik solutions:\n", (int)solutions.GetNumSolutions());
    std::vector<IkReal> solvalues(GetNumJoints());
    for(std::size_t i = 0; i < solutions.GetNumSolutions(); ++i) {
        const IkSolutionBase<IkReal>& sol = solutions.GetSolution(i);
        printf("sol%d (free=%d): ", (int)i, (int)sol.GetFree().size());
        std::vector<IkReal> vsolfree(sol.GetFree().size());
        sol.GetSolution(&solvalues[0],vsolfree.size()>0?&vsolfree[0]:NULL);
        for( std::size_t j = 0; j < solvalues.size(); ++j)
            printf("%.15f, ", solvalues[j]);
        printf("\n");
    }
    return 0;
}

#endif
