;; Regression test GUMBEL1 for GSLL, automatically generated
;;
;; Copyright 2009 Liam M. Healy
;; Distributed under the terms of the GNU General Public License
;;
;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

(in-package :gsl)

(LISP-UNIT:DEFINE-TEST GUMBEL1
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST
    (LIST 8.954596257487015d0 0.0973051899750762d0
	  0.45913506233088003d0 3.6074124224293223d0
	  0.31300027468174807d0 1.0165796949651174d0
	  3.8292081936610396d0 1.912897393181305d0
	  1.17748457894919d0 1.893232107970416d0
	  1.9859118616847695d0))
   (MULTIPLE-VALUE-LIST
    (LET ((RNG (MAKE-RANDOM-NUMBER-GENERATOR +MT19937+ 0)))
      (LOOP FOR I FROM 0 TO 10 COLLECT
	   (sample rng :gumbel1 :a 1.0d0 :b 2.0d0)))))
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST 0.29625708964974956d0)
   (MULTIPLE-VALUE-LIST (GUMBEL1-PDF 0.1d0 1.0d0 2.0d0)))
  ;; Automatically converted from cdf/test_auto.c
  (ASSERT-TO-TOLERANCE (GUMBEL1-P -1.d10 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P -1.d9 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P -1.d8 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P -1.d7 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P -1000000.0d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P -100000.0d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P -10000.0d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P -1000.0d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P -100.0d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P -10.0d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P -1.0d0 1.3d0 2.7d0) 4.981965353092d-5 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-PINV 4.981965353091824d-5 1.3d0 2.7d0) -1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P -0.1d0 1.3d0 2.7d0) 0.0461971747678d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-PINV 0.04619717476779808d0 1.3d0 2.7d0) -0.1d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P -0.01d0 1.3d0 2.7d0) 0.06487265128366d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-PINV 0.06487265128366305d0 1.3d0 2.7d0) -0.01d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P -0.001d0 1.3d0 2.7d0) 0.06696988203722d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-PINV 0.0669698820372176d0 1.3d0 2.7d0) -0.001d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P -1.d-4 1.3d0 2.7d0) 0.06718192621136d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-PINV 0.06718192621136487d0 1.3d0 2.7d0) -1.d-4 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P -1.d-5 1.3d0 2.7d0) 0.06720315385232d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P -1.d-6 1.3d0 2.7d0) 0.06720527684866d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P -1.d-7 1.3d0 2.7d0) 0.06720548915062d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P -1.d-8 1.3d0 2.7d0) 0.06720551038084d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P -1.d-9 1.3d0 2.7d0) 0.06720551250386d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P -1.d-10 1.3d0 2.7d0) 0.06720551271616d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P 0.0d0 1.3d0 2.7d0) 0.06720551273975d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-PINV 0.06720551273974995d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P 1.d-10 1.3d0 2.7d0) 0.06720551276334d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P 1.d-9 1.3d0 2.7d0) 0.06720551297564d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P 1.d-8 1.3d0 2.7d0) 0.06720551509866d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P 1.d-7 1.3d0 2.7d0) 0.06720553632889d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P 1.d-6 1.3d0 2.7d0) 0.06720574863136d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P 1.d-5 1.3d0 2.7d0) 0.06720787167931d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P 1.d-4 1.3d0 2.7d0) 0.06722910448133d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-PINV 0.06722910448133346d0 1.3d0 2.7d0) 1.d-4 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P 0.001d0 1.3d0 2.7d0) 0.0674416647619d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-PINV 0.06744166476189883d0 1.3d0 2.7d0) 0.001d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P 0.01d0 1.3d0 2.7d0) 0.06959050352518d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-PINV 0.06959050352517981d0 1.3d0 2.7d0) 0.01d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P 0.1d0 1.3d0 2.7d0) 0.09340058564429d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-PINV 0.09340058564429043d0 1.3d0 2.7d0) 0.1d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P 1.0d0 1.3d0 2.7d0) 0.4791048360125d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-PINV 0.47910483601248477d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P 10.0d0 1.3d0 2.7d0) 0.9999938971292d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P 100.0d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P 1000.0d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P 10000.0d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P 100000.0d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P 1000000.0d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P 1.d7 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P 1.d8 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P 1.d9 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-P 1.d10 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q 1.d10 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q 1.d9 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q 1.d8 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q 1.d7 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q 1000000.0d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q 100000.0d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q 10000.0d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q 1000.0d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q 100.0d0 1.3d0 2.7d0) 9.398988467742d-57 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-QINV 9.398988467741606d-57 1.3d0 2.7d0) 100.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q 10.0d0 1.3d0 2.7d0) 6.102870776257d-6 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-QINV 6.10287077625722d-6 1.3d0 2.7d0) 10.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q 1.0d0 1.3d0 2.7d0) 0.5208951639875d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-QINV 0.5208951639875152d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q 0.1d0 1.3d0 2.7d0) 0.9065994143557d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-QINV 0.9065994143557096d0 1.3d0 2.7d0) 0.1d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q 0.01d0 1.3d0 2.7d0) 0.9304094964748d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-QINV 0.9304094964748202d0 1.3d0 2.7d0) 0.01d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q 0.001d0 1.3d0 2.7d0) 0.9325583352381d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-QINV 0.9325583352381012d0 1.3d0 2.7d0) 0.001d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q 1.d-4 1.3d0 2.7d0) 0.9327708955187d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q 1.d-5 1.3d0 2.7d0) 0.9327921283207d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q 1.d-6 1.3d0 2.7d0) 0.9327942513686d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q 1.d-7 1.3d0 2.7d0) 0.9327944636711d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q 1.d-8 1.3d0 2.7d0) 0.9327944849013d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q 1.d-9 1.3d0 2.7d0) 0.9327944870244d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q 1.d-10 1.3d0 2.7d0) 0.9327944872367d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q 0.0d0 1.3d0 2.7d0) 0.9327944872603d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-QINV 0.9327944872602503d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q -1.d-10 1.3d0 2.7d0) 0.9327944872838d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q -1.d-9 1.3d0 2.7d0) 0.9327944874961d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q -1.d-8 1.3d0 2.7d0) 0.9327944896192d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q -1.d-7 1.3d0 2.7d0) 0.9327945108494d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q -1.d-6 1.3d0 2.7d0) 0.9327947231513d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q -1.d-5 1.3d0 2.7d0) 0.9327968461477d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q -1.d-4 1.3d0 2.7d0) 0.9328180737886d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q -0.001d0 1.3d0 2.7d0) 0.9330301179628d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-QINV 0.9330301179627825d0 1.3d0 2.7d0) -0.001d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q -0.01d0 1.3d0 2.7d0) 0.9351273487163d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-QINV 0.935127348716337d0 1.3d0 2.7d0) -0.01d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q -0.1d0 1.3d0 2.7d0) 0.9538028252322d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-QINV 0.953802825232202d0 1.3d0 2.7d0) -0.1d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q -1.0d0 1.3d0 2.7d0) 0.9999501803465d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-QINV 0.9999501803464691d0 1.3d0 2.7d0) -1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q -10.0d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q -100.0d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q -1000.0d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q -10000.0d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q -100000.0d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q -1000000.0d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q -1.d7 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q -1.d8 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q -1.d9 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (GUMBEL1-Q -1.d10 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+))

