;; Regression test LOGNORMAL for GSLL, automatically generated
;;
;; Copyright 2009 Liam M. Healy
;; Distributed under the terms of the GNU General Public License
;;
;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

(in-package :gsl)

(LISP-UNIT:DEFINE-TEST LOGNORMAL
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST
    (LIST 2.386447068127768d0 0.11687602167359055d0
	  4.753374578796263d0 30.093393775755004d0
	  0.8119584375760986d0 3.163421055157545d0
	  0.9146206567715651d0 0.727307901065758d0
	  2.180184852178898d0 3.8908856616896017d0
	  182.18469788916977d0))
   (MULTIPLE-VALUE-LIST
    (LET ((RNG (MAKE-RANDOM-NUMBER-GENERATOR +MT19937+ 0)))
      (LOOP FOR I FROM 0 TO 10 COLLECT
	   (sample rng :lognormal :zeta 1.0d0 :sigma 2.0d0)))))
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST 0.15289833965691607d0)
   (MULTIPLE-VALUE-LIST
    (LOGNORMAL-PDF 1.2d0 1.0d0 2.0d0)))
  ;; Automatically converted from cdf/test_auto.c
  (ASSERT-TO-TOLERANCE (LOGNORMAL-P 0.0d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-P 1.d-10 1.3d0 2.7d0) 1.034288276012d-19 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-PINV 1.0342882760115472d-19 1.3d0 2.7d0) 1.d-10 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-P 1.d-9 1.3d0 2.7d0) 1.720583234428d-16 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-PINV 1.7205832344275183d-16 1.3d0 2.7d0) 1.d-9 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-P 1.d-8 1.3d0 2.7d0) 1.39714069655d-13 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-PINV 1.3971406965496307d-13 1.3d0 2.7d0) 1.d-8 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-P 1.d-7 1.3d0 2.7d0) 5.550354890102d-11 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-PINV 5.550354890101576d-11 1.3d0 2.7d0) 1.d-7 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-P 1.d-6 1.3d0 2.7d0) 1.082087222875d-8 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-PINV 1.0820872228749844d-8 1.3d0 2.7d0) 1.d-6 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-P 1.d-5 1.3d0 2.7d0) 1.03981596749d-6 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-PINV 1.039815967490383d-6 1.3d0 2.7d0) 1.d-5 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-P 1.d-4 1.3d0 2.7d0) 4.956354352667d-5 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-PINV 4.956354352666784d-5 1.3d0 2.7d0) 1.d-4 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-P 0.001d0 1.3d0 2.7d0) 0.001183246775456d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-PINV 0.001183246775456206d0 1.3d0 2.7d0) 0.001d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-P 0.01d0 1.3d0 2.7d0) 0.01436760981041d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-PINV 0.014367609810406523d0 1.3d0 2.7d0) 0.01d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-P 0.1d0 1.3d0 2.7d0) 0.09105428982941d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-PINV 0.09105428982940558d0 1.3d0 2.7d0) 0.1d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-P 1.0d0 1.3d0 2.7d0) 0.3150871690838d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-PINV 0.31508716908375517d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-P 10.0d0 1.3d0 2.7d0) 0.6448033073717d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-PINV 0.6448033073717402d0 1.3d0 2.7d0) 10.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-P 100.0d0 1.3d0 2.7d0) 0.889549744837d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-PINV 0.8895497448370264d0 1.3d0 2.7d0) 100.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-P 1000.0d0 1.3d0 2.7d0) 0.9810967467052d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-PINV 0.9810967467051815d0 1.3d0 2.7d0) 1000.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-P 10000.0d0 1.3d0 2.7d0) 0.9983038570318d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-PINV 0.9983038570318435d0 1.3d0 2.7d0) 10000.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-P 100000.0d0 1.3d0 2.7d0) 0.9999223897251d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-PINV 0.9999223897250857d0 1.3d0 2.7d0) 100000.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-P 1000000.0d0 1.3d0 2.7d0) 0.9999982185389d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-P 1.d7 1.3d0 2.7d0) 0.9999999796956d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-P 1.d8 1.3d0 2.7d0) 0.9999999998859d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-P 1.d9 1.3d0 2.7d0) 0.9999999999997d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-P 1.d10 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-Q 1.d10 1.3d0 2.7d0) 4.25589351365d-16 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-QINV 4.2558935136502785d-16 1.3d0 2.7d0) 1.d10 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-Q 1.d9 1.3d0 2.7d0) 3.150574023842d-13 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-QINV 3.1505740238418296d-13 1.3d0 2.7d0) 1.d9 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-Q 1.d8 1.3d0 2.7d0) 1.14144555008d-10 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-QINV 1.1414455500802107d-10 1.3d0 2.7d0) 1.d8 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-Q 1.d7 1.3d0 2.7d0) 2.030439602858d-8 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-QINV 2.0304396028576915d-8 1.3d0 2.7d0) 1.d7 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-Q 1000000.0d0 1.3d0 2.7d0) 1.781461076603d-6 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-QINV 1.7814610766031938d-6 1.3d0 2.7d0) 1000000.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-Q 100000.0d0 1.3d0 2.7d0) 7.761027491429d-5 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-QINV 7.761027491429d-5 1.3d0 2.7d0) 100000.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-Q 10000.0d0 1.3d0 2.7d0) 0.001696142968157d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-QINV 0.0016961429681565346d0 1.3d0 2.7d0) 10000.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-Q 1000.0d0 1.3d0 2.7d0) 0.01890325329482d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-QINV 0.01890325329481853d0 1.3d0 2.7d0) 1000.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-Q 100.0d0 1.3d0 2.7d0) 0.110450255163d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-QINV 0.11045025516297369d0 1.3d0 2.7d0) 100.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-Q 10.0d0 1.3d0 2.7d0) 0.3551966926283d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-QINV 0.3551966926282599d0 1.3d0 2.7d0) 10.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-Q 1.0d0 1.3d0 2.7d0) 0.6849128309162d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-QINV 0.684912830916245d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-Q 0.1d0 1.3d0 2.7d0) 0.9089457101706d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-QINV 0.9089457101705947d0 1.3d0 2.7d0) 0.1d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-Q 0.01d0 1.3d0 2.7d0) 0.9856323901896d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-QINV 0.9856323901895937d0 1.3d0 2.7d0) 0.01d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-Q 0.001d0 1.3d0 2.7d0) 0.9988167532245d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-QINV 0.998816753224544d0 1.3d0 2.7d0) 0.001d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-Q 1.d-4 1.3d0 2.7d0) 0.9999504364565d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-Q 1.d-5 1.3d0 2.7d0) 0.999998960184d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-Q 1.d-6 1.3d0 2.7d0) 0.9999999891791d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-Q 1.d-7 1.3d0 2.7d0) 0.9999999999445d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-Q 1.d-8 1.3d0 2.7d0) 0.9999999999999d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-Q 1.d-9 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-Q 1.d-10 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGNORMAL-Q 0.0d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+))

