;; Regression test PARETO for GSLL, automatically generated
;;
;; Copyright 2009 Liam M. Healy
;; Distributed under the terms of the GNU General Public License
;;
;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

(in-package :gsl)

(LISP-UNIT:DEFINE-TEST PARETO
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST
    (LIST 2.0005166356083666d0 12.276726596218747d0
	  7.076694965937239d0 2.111484074469764d0
	  8.633470811095883d0 4.123935696449152d0
	  2.0888231161547828d0 2.6870692498025632d0
	  3.703404287965457d0 2.7028744394290123d0
	  2.631773566385122d0))
   (MULTIPLE-VALUE-LIST
    (LET ((RNG (MAKE-RANDOM-NUMBER-GENERATOR +MT19937+ 0)))
      (LOOP FOR I FROM 0 TO 10 COLLECT
	   (sample rng :pareto :a 1.0d0 :b 2.0d0)))))
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST 0.5116034405707658d0)
   (MULTIPLE-VALUE-LIST (PARETO-PDF 1.5d0 1.3d0 1.0d0)))
  ;; Automatically converted from cdf/test_auto.c
  (ASSERT-TO-TOLERANCE (PARETO-P 0.0d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-P 1.d-10 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-P 1.d-9 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-P 1.d-8 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-P 1.d-7 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-P 1.d-6 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-P 1.d-5 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-P 1.d-4 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-P 0.001d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-P 0.01d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-P 0.1d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-P 1.0d0 1.3d0 2.7d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-P 10.0d0 1.3d0 2.7d0) 0.817705782224d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-PINV 0.8177057822239537d0 1.3d0 2.7d0) 10.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-P 100.0d0 1.3d0 2.7d0) 0.9908636465287d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-PINV 0.9908636465286981d0 1.3d0 2.7d0) 100.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-P 1000.0d0 1.3d0 2.7d0) 0.9995420976279d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-PINV 0.9995420976278682d0 1.3d0 2.7d0) 1000.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-P 10000.0d0 1.3d0 2.7d0) 0.9999770505177d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-P 100000.0d0 1.3d0 2.7d0) 0.9999988498013d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-P 1000000.0d0 1.3d0 2.7d0) 0.9999999423535d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-P 1.d7 1.3d0 2.7d0) 0.9999999971109d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-P 1.d8 1.3d0 2.7d0) 0.9999999998552d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-P 1.d9 1.3d0 2.7d0) 0.9999999999928d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-P 1.d10 1.3d0 2.7d0) 0.9999999999997d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-Q 1.d10 1.3d0 2.7d0) 3.637247829654d-13 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-QINV 3.6372478296536173d-13 1.3d0 2.7d0) 1.d10 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-Q 1.d9 1.3d0 2.7d0) 7.25726352471d-12 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-QINV 7.257263524710211d-12 1.3d0 2.7d0) 1.d9 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-Q 1.d8 1.3d0 2.7d0) 1.448014442065d-10 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-QINV 1.4480144420652496d-10 1.3d0 2.7d0) 1.d8 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-Q 1.d7 1.3d0 2.7d0) 2.889168647783d-9 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-QINV 2.8891686477834784d-9 1.3d0 2.7d0) 1.d7 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-Q 1000000.0d0 1.3d0 2.7d0) 5.764649324512d-8 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-QINV 5.7646493245119715d-8 1.3d0 2.7d0) 1000000.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-Q 100000.0d0 1.3d0 2.7d0) 1.150198755621d-6 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-QINV 1.1501987556209536d-6 1.3d0 2.7d0) 100000.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-Q 10000.0d0 1.3d0 2.7d0) 2.294948231815d-5 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-QINV 2.294948231814587d-5 1.3d0 2.7d0) 10000.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-Q 1000.0d0 1.3d0 2.7d0) 4.579023721744d-4 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-QINV 4.579023721744107d-4 1.3d0 2.7d0) 1000.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-Q 100.0d0 1.3d0 2.7d0) 0.009136353471345d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-QINV 0.009136353471344562d0 1.3d0 2.7d0) 100.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-Q 10.0d0 1.3d0 2.7d0) 0.1822942177761d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-QINV 0.18229421777608898d0 1.3d0 2.7d0) 10.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-Q 1.0d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-Q 0.1d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-Q 0.01d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-Q 0.001d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-Q 1.d-4 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-Q 1.d-5 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-Q 1.d-6 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-Q 1.d-7 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-Q 1.d-8 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-Q 1.d-9 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-Q 1.d-10 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (PARETO-Q 0.0d0 1.3d0 2.7d0) 1.0d0 +TEST-TOL6+))
