#ifndef MapScrollArea_H
#define MapScrollArea_H

#include <QScrollArea>
#include <QWidget>

/**
 * @class  MapScrollArea
 * @brief  class derived from QScrollArea which disables scroll functionality for the mouse wheel.
 * @author Christian Fuchs (R12)
 */
class MapScrollArea : public QScrollArea
{
  public:
    /** @brief Constructor */
    MapScrollArea( QWidget * );

    /** @brief Destructor*/
    ~MapScrollArea();
  protected:
    /** @brief Ignores QScrollArea's wheelEvent */
    void wheelEvent( QWheelEvent * );
};

#endif
