/*******************************************************************************
 *  MyStateMachineModule.h
 *
 *  (C) 2009 AG Aktives Sehen <agas@uni-koblenz.de>
 *           Universitaet Koblenz-Landau
 *
 *******************************************************************************/

#ifndef DetectOpeningDoorModule_H
#define DetectOpeningDoorModule_H

//#include <robbie_architecture/Architecture/Module/ActiveMessageModule.h>
#include <robbie_architecture/Architecture/StateMachine/StateMachine.h>

#include <string>

/**
 * @class  DetectOpeningDoorModule
 * @brief  Template for modules containing one or more state machines
 * @author René Bing (R14)
 */
class DetectOpeningDoorModule {

  public:

    /** @brief Define an enum type for the states of each machine here */
    enum ModuleStateT {
      IDLE,
      WAITING,
      DOOR_IS_OPEN,
    };

    /** @brief The constructor. */
    DetectOpeningDoorModule();

    /** @brief The destructor. */
    virtual ~DetectOpeningDoorModule();

  protected:

    /** @brief Is called when all modules are loaded and thread has started. */
    virtual void init();

    /** @brief Handle incoming messages. */
    //virtual std::set<Message*> processMessages();

    /** @brief Is called in constant intervals. */
    //void idleProcess();

    /** @brief Actualize the module's status info.*/
	void refreshStatusInfo();
      
  private:

    StateMachine<ModuleStateT> m_ModuleMachine;

    std::string m_ExtraStatusInfo;
    
    vector<int> m_Ranges;
    
    unsigned int m_InitTimestamp;
    unsigned int m_CurrentTimestamp;
    unsigned int m_NewTimestamp;

    int m_InitRange;
    int m_CurrentRange;
    int m_NewRange;
    
    int m_GameTime;
    
    void compareRanges();

};

#endif

