#ifndef QT_ROS_NODE_H
#define QT_ROS_NODE_H


#include <QThread>
#include <QObject>
#include <QApplication>
//#include <boost/shared_ptr.hpp>

//messages
#include <geometry_msgs/PoseStamped.h>
#include <nav_msgs/OccupancyGrid.h>
#include <homer_mapnav_msgs/PointsOfInterest.h>
#include <sensor_msgs/LaserScan.h>
#include <sensor_msgs/Image.h> //for kinect RGB stream
#include <std_msgs/Empty.h>
#include <std_msgs/Bool.h>

#include "Workers/PointOfInterest/PointOfInterest.h"
#include "Widgets/MapDisplay/MapDisplay.h"
#include <robbie_architecture/Architecture/StateMachine/StateMachine.h>
#include <vector>

//#include <or_msgs/OrImage.h>
#include <or_msgs/OrLearningStatus.h>
#include <or_msgs/OrObjectNames.h>
//#include <hardware_state/HardwareState.h>

#include <ros/ros.h>
//#include <ros/callback_queue.h>

class MainWindow;

class QtRosNode : public QThread {

    Q_OBJECT

public:
    ///Note: The constructor will block until connected with roscore
    ///Instead of ros::spin(), start this thread with the start() method
    ///to run the event loop of ros
    QtRosNode(int argc, char *argv[], const char* node_name, MainWindow* mainWindow);

    ~QtRosNode();

    ros::NodeHandle* getNodeHandle(){ return m_NodeHandle; }

    /// This method contains the ROS event loop. Feel free to modify
    void run();

    enum ModuleStateT {
        IDLE,
        WAITING,
        DOOR_IS_OPEN,
    };


public slots:
    ///Connect to aboutToQuit signals, to stop the thread
    void quitNow();

signals:
    ///Triggered if ros::ok() != true
    void rosShutdown();
    void poseUpdated(double x, double y, double theta);
    void mapUpdated(unsigned char * pMap, unsigned size,
                    double resolution, geometry_msgs::Pose origin);
    void maskUpdated(const nav_msgs::OccupancyGrid::ConstPtr &msg);
    void poiListUpdated(std::vector < homer_mapnav_msgs::PointOfInterest > poiList);
    void pathUpdated(std::vector<geometry_msgs::PoseStamped> path);
    void followingPathUpdated(std::vector<geometry_msgs::PoseStamped> path);

    void learningStatus(std::vector<std::string> filenames, std::string objType);
    void objectNames(std::vector<std::string> names, std::vector<std::string> types);
    void emergencyButtonPressed(bool pressed);

    void kinectRGBImageUpdate(const sensor_msgs::Image::ConstPtr& image_msg );
    //signal for debug gray window
    void kinectDebugGrayUpdate(const sensor_msgs::Image::ConstPtr& image_msg);
    //signal for primary rgb window
    void kinectPrimaryRGBUpdate(const sensor_msgs::Image::ConstPtr& image_msg);
    void anyImageUpdate(const sensor_msgs::Image::ConstPtr& image_msg );

    //void hardwareStatus(std::string device, bool state);
    //void checkHardwareStatus();

  private:

    bool quitfromgui;

    ros::NodeHandle* m_NodeHandle;
    MainWindow* m_MainWindow;
    QApplication* m_Application;

    ros::Subscriber m_TextSubscriber;
    ros::Subscriber m_LaserSubscriber;
    //subscribers to kinect Images for object recognition
    ros::Subscriber m_KinectRGBImageSubscriber;
    ros::Subscriber m_DebugGrayImageSubscriber;
    ros::Subscriber m_PrimaryRGBImageSubscriber;
    ros::Subscriber m_AnyImageSubscriber;

    ros::Subscriber m_PoseStampedSubscriber;
    ros::Subscriber m_MapDataSubscriber;
    ros::Subscriber m_MaskSlamSubscriber;
    ros::Subscriber m_POIsSubscriber;
    ros::Subscriber m_PathSubscriber;

    ros::Subscriber m_OLPrimaryImageSubscriber;
    ros::Subscriber m_ORLearningStatusSubscriber;
    ros::Subscriber m_ORObjectNamesSubscriber;
    ros::Subscriber emergeny_button_pressed_sub_;
    ros::Subscriber m_FollowingPathSubscriber;

    //ros::Subscriber m_HardwareStatusSubscriber;
    ros::Subscriber door_detection_sub_;

    ros::Publisher start_game_pub_;
    ros::Publisher text_out_pub_;

    void subscribeToTopics();
    void advertiseTopics();
    void publishStartGame();

    //callbacks
    void callbackPoseStamped(const geometry_msgs::PoseStamped::ConstPtr& msg);
    void callbackOccupancyGrid(const nav_msgs::OccupancyGrid::ConstPtr& msg);
    void callbackMaskSlam(const nav_msgs::OccupancyGrid::ConstPtr& msg);
    void callbackPOIList(const homer_mapnav_msgs::PointsOfInterest::ConstPtr& msg);
    void callbackPath(const nav_msgs::Path::ConstPtr& msg);
    void callbackFollowingPath(const nav_msgs::Path::ConstPtr& msg);

    void callbackLaserScan(const sensor_msgs::LaserScan::ConstPtr& msg);

    //void callbackPrimaryImage(const or_msgs::OrImage::ConstPtr& msg );
    //void callbackGUIImage(const sensor_msgs::Image::ConstPtr &msg);
    void callbackLearningStatus(const or_msgs::OrLearningStatusConstPtr &msg);
    void callbackObjectNames(const or_msgs::OrObjectNamesConstPtr &msg);

    void callbackDetectDoors(const std_msgs::Empty::ConstPtr& msg);
    void callbackEmergencyButton(const std_msgs::Bool::ConstPtr& msg);

    /** @brief Callback for SensorMsgs::Image from Kinect RGB Stream*/
    void callbackKinectRGBImageDisplay(const sensor_msgs::Image::ConstPtr &msg);
    void callbackDebugGrayDisplay(const sensor_msgs::Image::ConstPtr &msg);
    void callbackPrimaryRGBDisplay(const sensor_msgs::Image::ConstPtr &msg);
    /** @brief Callback for any other source SensorMsgs::Image or images from harddisk*/
    void callbackAnyImageDisplay(const sensor_msgs::Image::ConstPtr &msg);

    //void callbackHardwareStatus(const hardware_state::HardwareState::ConstPtr &msg);
    //void hardwareTimerCallback(const ros::TimerEvent&);

    StateMachine<ModuleStateT> m_ModuleMachine;

    // door detection
    std::string m_ExtraStatusInfo;
    std::vector<float> m_Ranges;
    ros::Time m_InitTimestamp;
    ros::Time m_CurrentTimestamp;
    ros::Time m_NewTimestamp;
    int m_InitRange;
    int m_CurrentRange;
    int m_NewRange;
    int m_GameTime;
    void compareRanges();
    //end door detection
    //
    void speak(std::string text);

    ros::Time m_LastLaserStateUpdateTime;

    //ros::Timer m_HardwareTimer;

};
#endif
