/*******************************************************************************
 *  PoiLabel.h
 *
 *  (C) 2008 AG Aktives Sehen <agas@uni-koblenz.de>
 *           Universitaet Koblenz-Landau
 *
 * §Author: Christian Feinen
 *
 *  Additional information: 
 *  $Id: PoiLabel.h 44313 2011-04-06 22:46:28Z agas $ 
 *******************************************************************************/

#ifndef POILABEL_H
#define POILABEL_H

#include <QLabel>
#include <QPixmap>
#include <QFrame>

/**
	@author Christian Feinen <cfeinen@uni-koblenz.de>
*/
class PoiLabel : public QLabel
{
  public:
    PoiLabel() {}

    PoiLabel(QPoint mapPosition, double theta, QString poiIconFileName, QString poiName, QString poiRemarks, int poiType, QWidget *parent, float zoomFactor);

    ~PoiLabel() {}

    QString getPoiName() const;
    QString getPoiIconFileName() const;
    QPoint getPoiPosition() const;
    double getPoiOrientation() const;
    void setActive(bool value);
    void setNewPoiIcon(QString poiIconFileName);
    void setOrientation(double orientation);

  private:
    QString m_PoiName;
    QString m_PoiIconFileName;
    QPoint m_PoiPosition;
    double m_PoiOrientation;

};

#endif
