#include "XmlStreamReader.h"

XmlStreamReader::XmlStreamReader(QTreeWidget *tree)
{
    treeWidget = tree;
}

bool XmlStreamReader::readFile(const QString &fileName)
{
    QFile file(fileName);
    if (!file.open(QFile::ReadOnly | QFile::Text)) {
        std::cerr << "Error: Cannot read file " << qPrintable(fileName)
                  << ": " << qPrintable(file.errorString())
                  << std::endl;
        return false;
    }
    reader.setDevice(&file);

    reader.readNext();

    QTreeWidgetItem *item = treeWidget->invisibleRootItem();
    QTreeWidgetItem *parent_item = treeWidget->invisibleRootItem();
    while (!reader.atEnd()) {


        if (reader.isStartElement()) {
            QTreeWidgetItem* sub_item = new QTreeWidgetItem(parent_item);
            sub_item->setText(0, reader.name().toString());
            parent_item = sub_item;

        }
        if (reader.isEndElement()) {
//            QTreeWidgetItem* sub_item = new QTreeWidgetItem(parent_item);
//            sub_item->setText(0, "end "+reader.name().toString());
            if (parent_item->parent())
                parent_item = parent_item->parent(); // treeWidget->invisibleRootItem();
        }
        reader.readNext();


//        if (reader.isStartElement()) {
//            if (reader.name() == "root") {
//                readBookindexElement();
//            } else {
//                reader.raiseError(QObject::tr("Not a bookindex file"));
//            }
//        } else {
//            reader.readNext();
//        }
    }
    treeWidget->expandAll();
    file.close();
    if (reader.hasError()) {
        std::cerr << "Error: Failed to parse file "
                  << qPrintable(fileName) << ": "
                  << qPrintable(reader.errorString()) << std::endl;
        return false;
    } else if (file.error() != QFile::NoError) {
        std::cerr << "Error: Cannot read file " << qPrintable(fileName)
                  << ": " << qPrintable(file.errorString())
                  << std::endl;
        return false;
    }
    return true;
}

void XmlStreamReader::readBookindexElement()
{
    reader.readNext();
    while (!reader.atEnd()) {
        if (reader.isEndElement()) {
            reader.readNext();
            break;
        }

        if (reader.isStartElement()) {
            if (reader.name() == "locations") {
                readEntryElement(treeWidget->invisibleRootItem());
            } else {
                skipUnknownElement();
            }
        } else {
            reader.readNext();
        }
    }
}

void XmlStreamReader::readEntryElement(QTreeWidgetItem *parent)
{
    QTreeWidgetItem *item = new QTreeWidgetItem(parent);
    //item->setText(0, "ASSSSD");

    reader.readNext();
    while (!reader.atEnd()) {
        item->setText(0, reader.name().toString());
        reader.readNext();

//        if (reader.isEndElement()) {
////            item->setText(0, "endElement "+reader.name().toString());
//            reader.readNext();
//            continue;
//        }

//        QTreeWidgetItem *item = new QTreeWidgetItem(parent);


//        if (reader.isStartElement()) {
////            if (reader.name() == "ssm") {
////                readEntryElement(item);
////            } else if (reader.name() == "room") {
////                readPageElement(item);
////            } else {
////                skipUnknownElement();
////            }
//            reader.readNext();
//        } else {
//            reader.readNext();
//        }
    }
}

void XmlStreamReader::readPageElement(QTreeWidgetItem *parent)
{
    QString page = reader.readElementText();
    std::cout<<"Room"<<std::endl;
//    if (reader.isEndElement())
//        reader.readNext();

//    QString allPages = parent->text(1);
//    if (!allPages.isEmpty())
//        allPages += ", ";
//    allPages += page;
    parent->setText(1, QString("asd"));
}

void XmlStreamReader::skipUnknownElement()
{
    reader.readNext();
    while (!reader.atEnd()) {
        if (reader.isEndElement()) {
            reader.readNext();
            break;
        }

        if (reader.isStartElement()) {
            skipUnknownElement();
        } else {
            reader.readNext();
        }
    }
}
