#include <sstream>

#include <homer_mapnav_msgs/RegionsOfInterest.h>

#include <homer_map_manager/Managers/RoiManager.h>

RoiManager::RoiManager(ros::NodeHandle *nh)
{
    m_ROIsPublisher = nh->advertise<homer_mapnav_msgs::RegionsOfInterest>("/map_manager/roi_list", 1);
}

RoiManager::RoiManager (std::vector<homer_mapnav_msgs::RegionOfInterest> rois )
{
  //copy POIs
  m_Rois = rois;
}

std::vector<homer_mapnav_msgs::RegionOfInterest> RoiManager::getList()
{
  return m_Rois;
}

bool RoiManager::addRegionOfInterest (const homer_mapnav_msgs::RegionOfInterest::ConstPtr &roi ) // TODO
{
    if ( roiExists ( roi->id ) )
    {
      std::ostringstream stream;
      stream << "Roi with ID " << roi->id << " (name: " << roi->name << ") already exists! Doing nothing.";
      ROS_WARN_STREAM ( stream.str() );
      return false;
    }

    //copy roi & assigning new id
    homer_mapnav_msgs::RegionOfInterest new_roi= *roi;

    ROS_INFO_STREAM ("Adding ROI '" << new_roi.name << "' with ID " << roi->id << ".");

    //insert into list
    m_Rois.push_back ( new_roi );

    broadcastRoiList();
    return true;
}


bool RoiManager::modifyRegionOfInterest (const homer_mapnav_msgs::RegionOfInterest::ConstPtr &roi )
{
  std::vector<homer_mapnav_msgs::RegionOfInterest>::iterator it;

  for ( it=m_Rois.begin() ; it != m_Rois.end(); it++ )
  {
    if ( it->id == roi->id )
    {
      *it=*roi;
      broadcastRoiList();
      return true;
    }
  }

  ROS_ERROR_STREAM ( "Cannot modify: ROI does not exist!" );

  return false;
}


void RoiManager::replaceROIList(std::vector<homer_mapnav_msgs::RegionOfInterest> roilist)
{
    m_Rois = roilist;
    broadcastRoiList();
}

bool RoiManager::roiExists ( int id )
{
  std::vector<homer_mapnav_msgs::RegionOfInterest>::iterator it;

  for ( it=m_Rois.begin() ; it != m_Rois.end(); it++ )
  {
    if ( it->id == id )
    {
      return true;
    }
  }

  return false;
}


bool RoiManager::deleteRegionOfInterest (std::string name )
{
  std::vector< homer_mapnav_msgs::RegionOfInterest >::iterator it;

  bool modified = false;
  for ( it=m_Rois.begin() ; it != m_Rois.end(); it++ )
  {
    if ( it->name == name )
    {
      if(!modified)
      {
          ROS_INFO_STREAM ("Erasing all ROIs with name " << name << ".");
          modified = true;
      }

      it = m_Rois.erase ( it );
    }
  }

  if(modified)
  {
      broadcastRoiList();
      return true;
  }

  ROS_ERROR_STREAM ("ROI " << name << " does not exist.");

  return false;
}


bool RoiManager::deleteRegionOfInterest (int id )
{
  std::vector< homer_mapnav_msgs::RegionOfInterest >::iterator it;

  for ( it=m_Rois.begin() ; it != m_Rois.end(); it++ )
  {
    if ( it->id == id )
    {
          ROS_INFO_STREAM ("Erasing ROI with ID " << id << ".");
          it = m_Rois.erase ( it );
          broadcastRoiList();
          return true;
    }
  }

  ROS_ERROR_STREAM ("ROI with ID " << id << " does not exist.");

  return false;
}

// TODO
void RoiManager::broadcastRoiList()
{
  std::ostringstream stream;

  //print the current list
  std::vector< homer_mapnav_msgs::RegionOfInterest >::iterator it;
  stream << "Contents of POI list:\n";
  homer_mapnav_msgs::RegionsOfInterest roiMsg;
  for ( it = m_Rois.begin(); it != m_Rois.end(); it++ ) {
   // TODO
   // stream << "    ROI " << it->name << "', " << it->type
   //        << ", (" << it->pose.position.x << "," << it->pose.position.y << "), '" << it->remarks << "'\n";
  }
  roiMsg.rois = m_Rois;
  ros::Rate poll_rate(10);
  while(m_ROIsPublisher.getNumSubscribers() == 0)
      poll_rate.sleep();
  m_ROIsPublisher.publish(roiMsg);
  ROS_DEBUG_STREAM( stream.str() );
}

