
#ifndef LOAD_ROS_CONFIG_H
#define LOAD_ROS_CONFIG_H

#include <ros/ros.h>
#include <string>

template <typename T>
inline bool loadConfigValue(std::string valueName, T &variable, T default_variable = T() )
{
    if(ros::param::has(valueName))
    {
      ros::param::get(valueName, variable);
      ROS_INFO_STREAM(valueName << ": " << variable);
      return true;
    }
    else
    {
      ROS_WARN_STREAM("No Parameter: " << valueName << ". Defaulting to "<<default_variable<<".");
      variable = default_variable;
      return false;
    }
}

template <typename T>
inline bool loadConfigValue(std::string valueName, std::vector<T> &variable)
{
    if(ros::param::has(valueName))
    {
		ros::param::get(valueName, variable);
		ROS_INFO_STREAM(valueName << ":");

		for (int i = 0; i < variable.size(); ++i)
			ROS_INFO_STREAM("Value "<< i << " :" << variable[i]);

		return true;
    }
    else
    {
      ROS_WARN_STREAM("No Parameter: " << valueName << ". Defaulting to empty vector.");
      variable.clear();
      return false;
    }
}

#endif
