#ifndef SCANNER_H
#define SCANNER_H

#ifndef YY_DECL

#define  YY_DECL            \
    SlamParser::Parser::token_type        \
    SlamParser::Scanner::lex(        \
  SlamParser::Parser::semantic_type* yylval,    \
  SlamParser::Parser::location_type* yylloc    \
    )
#endif

#ifndef __FLEX_LEXER_H
#define yyFlexLexer SlamFlexLexer
#include "FlexLexer.h"
#undef yyFlexLexer
#endif

#include "bison_parser.h"

namespace SlamParser {

  class Scanner : public SlamFlexLexer
  {
    public:
      /** Create a new scanner object. The streams arg_yyin and arg_yyout default
       * to cin and cout, but that assignment is only made when initializing in
       * yylex(). */
      Scanner(std::istream* arg_yyin = 0,
          std::ostream* arg_yyout = 0);

      /** Required for virtual functions */
      virtual ~Scanner();

      /** This is the main lexing function. It is generated by flex according to
       * the macro declaration YY_DECL above. The generated bison parser then
       * calls this virtual function to fetch new tokens. */
      virtual Parser::token_type lex(
          Parser::semantic_type* yylval,
          Parser::location_type* yylloc
          );

      /** Enable debug output (via arg_yyout) if compiled into the scanner. */
      void set_debug(bool b);
  };

} // end namespace

#endif
